/*
 * ANSI Standard 4.4: Localisation <locale.h>
 * Copyright (c) 1997-2005 Nick Burrett
 * Copyright (c) 2000-2010 UnixLib Developers
 */

#ifndef	__LOCALE_H
#define	__LOCALE_H

#ifndef __UNIXLIB_FEATURES_H
#include <features.h>
#endif

__BEGIN_DECLS

/* Locale information types.
   If you change these values, then you better fix setlocale().  */

#ifndef __TARGET_SCL__
/* String collation (functions 'strcoll' and 'strxfrm').  */
#  define LC_COLLATE 0
/* Classification and conversion of characters, multibyte and
   wide characters.  */
#  define LC_CTYPE 1
/* Localisable natural-language messages.  */
#  define LC_MESSAGES 2
/* Formatting of monetary values.  */
#  define LC_MONETARY 3
/* Formatting of numeric values that are not monetary. */
#  define LC_NUMERIC 4
/* Formatting of data and time values.  */
#  define LC_TIME 5
/* Entire locale.  */
#  define LC_ALL 6

#  ifdef __USE_XOPEN2K8
#    define LC_COLLATE_MASK (1L << 0)
#    define LC_CTYPE_MASK (1L << 1)
#    define LC_MESSAGES_MASK (1L << 2)
#    define LC_MONETARY_MASK (1L << 3)
#    define LC_NUMERIC_MASK (1L << 4)
#    define LC_TIME_MASK (1L << 5)
#    define LC_ALL_MASK (LC_COLLATE_MASK | LC_CTYPE_MASK | LC_MESSAGES_MASK | LC_MONETARY_MASK | LC_NUMERIC_MASK | LC_TIME_MASK)
#  endif

#else
/* String collation (functions 'strcoll' and 'strxfrm').  */
#  define LC_COLLATE 1
/* Classification and conversion of characters, multibyte and
   wide characters.  */
#  define LC_CTYPE 2
/* Formatting of monetary values.  */
#  define LC_MONETARY 4
/* Formatting of numeric values that are not monetary. */
#  define LC_NUMERIC 8
/* Formatting of data and time values.  */
#  define LC_TIME 16
/* Entire locale.  */
#  define LC_ALL 31
#endif

struct lconv
{
  /* Decimal-point separators used in formatting non-monetary quantities.  */
  char *decimal_point;
  /* Separators used to delimit groups of digits to the left of the
     decimal point in formatting non-monetary quantities.  */
  char *thousands_sep;
  /* A string that specifies how to group the digits to the left
     of the decimal point for non-monetary quantities.  */
  char *grouping;
  /* The international currency symbol for the selected locale.  */
  char *int_curr_symbol;
  /* The local currency symbol for the selected locale.  */
  char *currency_symbol;
  /* Decimal-point separators used in formatting monetary quantities.  */
  char *mon_decimal_point;
  /* Separators used to delimit groups of digits to the left of the
     decimal point in formatting monetary quantities.  */
  char *mon_thousands_sep;
  /* A string that specifies how to group the digits to the left
     of the decimal point for monetary quantities.  */
  char *mon_grouping;
  /* String used to indicate positive (or zero) monetary quantities.  */
  char *positive_sign;
  /* String used to indicate negative monetary quantities.  */
  char *negative_sign;
  /* Small integers indicating how many fractional digits should
     be displayed in a monetary value in international (int_frac_digits)
     and local formats (frac_digits).  */
  char int_frac_digits;
  char frac_digits;
  /* Set to 1 is the 'currency_symbol' string should precede the
     value of a monetary amount, 0 if the string should follow the value.  */
  char p_cs_precedes;
  /* Set to 1 if a space should appear between the 'currency_symbol'
     string and the amount, 0 if no space should appear.  */
  char p_sep_by_space;
  /* Set to 1 is the 'currency_symbol' string should precede the
     value of a monetary amount, 0 if the string should follow the value.  */
  char n_cs_precedes;
  /* Set to 1 if a space should appear between the 'currency_symbol'
     string and the amount, 0 if no space should appear.  */
  char n_sep_by_space;
  /* Indicate how to position the sign for non-negative monetary quantities.  */
  char p_sign_posn;
  /* Indicate how to position the sign for negative monetary quantities.  */
  char n_sign_posn;
};

__BEGIN_NAMESPACE_STD

/* Sets the current locale for category 'category' to 'locale'.

   If 'category' is 'LC_ALL', this specifies the locale for
   all purposes. The other possible values of 'category' specify
   an individual purpose.  */
extern char *setlocale (int __category, const char *__locale) __THROW;

/* Set the lconv structure with the current locale settings.  */
extern struct lconv *localeconv (void) __THROW;

#ifndef __TARGET_SCL__
#  ifdef __USE_XOPEN2K8
#    include <bits/locale_t.h>

extern locale_t uselocale(locale_t newloc);

extern void freelocale(locale_t locobj);

extern locale_t newlocale(int category_mask, const char *locale,
                          locale_t base);

extern locale_t duplocale(locale_t locobj);

#    define LC_GLOBAL_LOCALE        ((locale_t) -1L)
#  endif
#endif

__END_NAMESPACE_STD

__END_DECLS

#endif
