/* Title:   event.c
 * Purpose: event dispatching
 * Author:  IDJ
 * History: 19-Jun-94: IDJ: created
 *          22nd Mar 1995: J R C: hacked mercilessly to use OSLib
 */

/*
      OSLibSupport is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

      OSLibSupport is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
   along with this programme; if not, write to the Free Software
   Foundation, Inc, 675 Mass Ave, Cambridge, MA 02139, U S A.
*/
/*From CLib*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*From OSLib*/
#include "oslib/wimp.h"

/*From TLib*/
#include "oslib/toolbox.h"

/*From Support*/
//#include "trace.h"
#include "Tbevent.h"
#include "Wimpevent.h"
#include "Wimpmsg.h"

static toolbox_block *Block = 0;
static wimp_poll_flags Mask = NONE;

/* ------------------------------------- dispatching events ------------------------------------ */
static void Dispatch (wimp_event_no event_code, wimp_block *poll_block, toolbox_block *id_block)

{  //tracef ("Dispatch\n");
   //tracef ("id_block 0x%X\n" _ id_block);

   switch (event_code)
   {  case toolbox_EVENT:
         tbevent_dispatch (poll_block, id_block);
      break;

      case wimp_USER_MESSAGE: case wimp_USER_MESSAGE_RECORDED:
         wimpmsg_dispatch (poll_block, id_block);
      break;

      default:
         wimpevent_dispatch (event_code, poll_block, id_block);
      break;
   }
}

void event_poll (wimp_event_no *event_code, wimp_block *poll_block, void *poll_word)

{  *event_code = wimp_poll (Mask, poll_block, poll_word);
   //tracef ("event_poll: event_code %d\n" _ *event_code);

   Dispatch (*event_code, poll_block, Block);
}

extern void event_poll_idle (wimp_event_no *event_code, wimp_block *poll_block, os_t earliest, void *poll_word)

{  *event_code = wimp_poll_idle (Mask, poll_block, earliest, poll_word);
   //tracef ("event_poll: event_code %d\n" _ *event_code);

   Dispatch (*event_code, poll_block, Block);
}

/* ------------------------------------- registering/deregistering handlers ----------------------- */
/* wimp events */
extern
osbool event_register_wimp_handler (toolbox_o object_id,
                                    wimp_event_no event_code,
                                    event_wimp_handler handler,
                                    void *handle
                                   )
{  return wimpevent_register_wimp_handler(object_id,
                                          event_code,
                                          handler,
                                          handle
                                        );
}

void event_deregister_wimp_handler (toolbox_o object_id, wimp_event_no event_code, event_wimp_handler handler, void *handle)
      {wimpevent_deregister_wimp_handler (object_id, event_code, handler, handle);}

/* toolbox events */
osbool event_register_toolbox_handler (toolbox_o object_id, bits event_code, event_toolbox_handler handler, void *handle)
      {return tbevent_register_toolbox_handler (object_id, event_code, handler, handle);}
void event_deregister_toolbox_handler (toolbox_o object_id, bits event_code, event_toolbox_handler handler, void *handle)
      {tbevent_deregister_toolbox_handler (object_id, event_code, handler, handle);}

/* wimp messages */
osbool event_register_message_handler (bits msg_no, event_message_handler handler, void *handle)
      {return wimpmsg_register_message_handler (msg_no, handler, handle);}
void event_deregister_message_handler (bits msg_no, event_message_handler handler, void *handle)
      {wimpmsg_deregister_message_handler (msg_no, handler, handle);}

/* ------------------------------------- getting/setting poll mask -------------------------------- */
extern void event_set_mask (wimp_poll_flags mask) {Mask = mask;}
extern void event_get_mask (wimp_poll_flags *mask) {if (mask != NULL) *mask = Mask;}

/* ---------------------------------------- initialisation -------------------------------------- */
void event_initialise (toolbox_block *b)

{  Block = b;
}
