#ifndef font_H
#define font_H

#include <swis.h>

#ifndef types_H
   #include "oslib/types.h"
#endif

#ifndef os_H
   #include "oslib/os.h"
#endif

#define font_COMMAND_NUL                 0
#define font_COMMAND_MOVE_HORIZONTAL     9
#define font_COMMAND_LF                 10
#define font_COMMAND_MOVE_VERTICAL      11
#define font_COMMAND_CR                 13
#define font_COMMAND_GCOL               17
#define font_COMMAND_COLOURS            18
#define font_COMMAND_TRUE_COLOURS       19
#define font_COMMAND_COMMENT            21
#define font_COMMAND_UNDERLINE          25
#define font_COMMAND_FONT               26
#define font_COMMAND_MATRIX             27
#define font_COMMAND_MATRIX_WITH_OFFSET 28

#define font_PAINT_JUSTIFY       (1U <<  0)
#define font_PAINT_RUBOUT        (1U <<  1)
#define font_PAINT_OS_UNITS      (1U <<  4)
#define font_PAINT_GIVEN_COORDS  (1U <<  5)
#define font_PAINT_GIVEN_TRFM    (1U <<  6)
#define font_PAINT_GIVEN_LENGTH  (1U <<  7)
#define font_PAINT_GIVEN_FONT    (1U <<  8)
#define font_PAINT_KERN          (1U <<  9)
#define font_PAINT_RIGHT_TO_LEFT (1U << 10)

#define font_NO_OUTPUT       (1U << 0)
#define font_ADD_HINTS       (1U << 1)
#define font_OUTPUT_SKELETON (1U << 2)
#define font_CONVERT_BITMAP  (1U << 3)
#define font_ERROR_IF_BITMAP (1U << 4)

typedef int font_f;

typedef
   struct
   {  os_coord space_offset;
      os_coord letter_offset;
      os_box   rubout;
   }
   font_coords;

#define xfont_cache_addr(version, cache, used) \
   (os_error *)_swix (Font_CacheAddr, _OUT (0) | _OUT (2) | _OUT (3), \
         (int *) (version), (int *) (cache), (int *) (used))

#define xfont_find_font(font_name, xsize, ysize, xres, yres, f) \
   (os_error *)_swix (Font_FindFont, _IN (1) | _IN (2) | _IN (3) | _IN (4) | _IN (5) | \
         _OUT (0) | _OUT (4) | _OUT (5), \
         (char *) (font_name), (int) (xsize), (int) (ysize), \
         *(int *) (xres), *(int *) (yres), \
         (font_f *) (f), (int *) (xres), (int *) (yres))

#define xfont_lose_font(f) \
   (os_error *)_swix (Font_LoseFont, _IN (0), (font_f) (f))

#define xfont_read_defn() \
   (os_error *)_swix (Font_ReadDefn, )

#define xfont_read_info() \
   (os_error *)_swix (Font_ReadInfo, )

#define xfont_string_width() \
   (os_error *)_swix (Font_StringWidth, )

#define xfont_paint(f, string, paint, xpos, ypos, coords, trfm, length) \
   (os_error *)_swix (Font_Paint, _IN (0) | _IN (1) | _IN (2) | _IN (3) | _IN (4) | \
         _IN (5) | _IN (6) | _IN (7), \
         (font_f) (f), (char *) (string), (int) (paint), (int) (xpos), \
         (int) (ypos), (font_coords *) (coords), (os_trfm_mat *) (trfm), \
         (int) (length))

#define xfont_caret() \
   (os_error *)_swix (Font_Caret, )

#define xfont_convert_to_os() \
   (os_error *)_swix (Font_ConverttoOS, )

#define xfont_convert_to_points() \
   (os_error *)_swix (Font_Converttopoints, )

#define xfont_set_font() \
   (os_error *)_swix (Font_SetFont, )

#define xfont_current_font() \
   (os_error *)_swix (Font_CurrentFont, )

#define xfont_future_font() \
   (os_error *)_swix (Font_FutureFont, )

#define xfont_find_caret() \
   (os_error *)_swix (Font_FindCaret, )

#define xfont_char_bbox() \
   (os_error *)_swix (Font_CharBBox, )

#define xfont_read_scale_factor() \
   (os_error *)_swix (Font_ReadScaleFactor, )

#define xfont_set_scale_factor() \
   (os_error *)_swix (Font_SetScaleFactor, )

#define xfont_list_fonts() \
   (os_error *)_swix (Font_ListFonts, )

#define xfont_set_font_colours() \
   (os_error *)_swix (Font_SetFontColours, )

#define xfont_set_palette() \
   (os_error *)_swix (Font_SetPalette, )

#define xfont_read_thresholds() \
   (os_error *)_swix (Font_ReadThresholds, )

#define xfont_set_thresholds() \
   (os_error *)_swix (Font_SetThresholds, )

#define xfont_find_caret_j() \
   (os_error *)_swix (Font_FindCaretJ, )

#define xfont_string_bbox() \
   (os_error *)_swix (Font_StringBBox, )

#define xfont_read_colour_table() \
   (os_error *)_swix (Font_ReadColourTable, )

#define xfont_make_bitmap() \
   (os_error *)_swix (Font_MakeBitmap, )

#define xfont_uncache_file() \
   (os_error *)_swix (Font_UnCacheFile, )

#define xfont_set_font_max() \
   (os_error *)_swix (Font_SetFontMax, )

#define xfont_read_font_max() \
   (os_error *)_swix (Font_ReadFontMax, )

#define xfont_read_font_prefix() \
   (os_error *)_swix (Font_ReadFontPrefix, )

#define xfont_switch_output_to_buffer(flags, buffer, end) \
   (os_error *)_swix (Font_SwitchOutputToBuffer, _IN (0) | _IN (1) | _OUT (1), \
         (int) (flags), (int *) (buffer), (int *) (end))

#define xfont_read_font_metrics() \
   (os_error *)_swix (Font_ReadFontMetrics, )

#define xfont_decode_menu() \
   (os_error *)_swix (Font_DecodeMenu, )

#define xfont_scan_string() \
   (os_error *)_swix (Font_ScanString, )

#define xfont_set_colour_table() \
   (os_error *)_swix (Font_SetColourTable, )

#define xfont_current_rgb() \
   (os_error *)_swix (Font_CurrentRGB, )

#define xfont_future_rgb() \
   (os_error *)_swix (Font_FutureRGB, )

#define xfont_read_encoding_filename() \
   (os_error *)_swix (Font_ReadEncodingFilename, )

#define xfont_find_field() \
   (os_error *)_swix (Font_FindField, )

#define xfont_apply_fields() \
   (os_error *)_swix (Font_ApplyFields, )

#define xfont_lookup_font() \
   (os_error *)_swix (Font_LookupFont, )

#endif
