#ifndef hostfs_H
#define hostfs_H

/*OSLib---efficient, type-safe, transparent, extensible,\n"
   register-safe API coverage of RISC OS*/
/*Copyright (c) 1994 Jonathan Coxhead*/

/*
      OSLib is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

      OSLib is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
   along with this programme; if not, write to the Free Software
   Foundation, Inc, 675 Mass Ave, Cambridge, MA 02139, U S A.
*/

#ifndef types_H
   #include "oslib/types.h"
#endif

#ifndef os_H
   #include "oslib/os.h"
#endif

/**********************************
 * SWI names and SWI reason codes *
 **********************************/
#undef  HostFS_HostVdu
#define HostFS_HostVdu                          0x40100
#undef  XHostFS_HostVdu
#define XHostFS_HostVdu                         0x60100
#undef  HostFS_TubeVdu
#define HostFS_TubeVdu                          0x40101
#undef  XHostFS_TubeVdu
#define XHostFS_TubeVdu                         0x60101
#undef  HostFS_WriteC
#define HostFS_WriteC                           0x40102
#undef  XHostFS_WriteC
#define XHostFS_WriteC                          0x60102

/*************************
 * Function declarations *
 *************************/

#ifdef __cplusplus
   extern "C" {
#endif

/* ------------------------------------------------------------------------
 * Function:      hostfs_host_vdu()
 *
 * Description:   Calls SWI 0x40100
 */

extern os_error *xhostfs_host_vdu (void);
__swi (0x40100) void hostfs_host_vdu (void);

/* ------------------------------------------------------------------------
 * Function:      hostfs_tube_vdu()
 *
 * Description:   Calls SWI 0x40101
 */

extern os_error *xhostfs_tube_vdu (void);
__swi (0x40101) void hostfs_tube_vdu (void);

/* ------------------------------------------------------------------------
 * Function:      hostfs_writec()
 *
 * Description:   Calls SWI 0x40102
 *
 * Input:         c - value of R0 on entry
 */

extern os_error *xhostfs_writec (char c);
__swi (0x40102) void hostfs_writec (char c);

#ifdef __cplusplus
   }
#endif

#endif
