;riscosa.asm - length of a variable
;written by Jonathan Coxhead, 15th Aug 1995

;OSLib---efficient, type-safe, transparent, extensible,
;   register-safe API coverage of RISC OS
;Copyright (c) 1994 Jonathan Coxhead
;
;   OSLib is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation; either version 1, or (at your option)
;any later version.
;
;   OSLib is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;along with this programme; if not, write to the Free Software
;Foundation, Inc, 675 Mass Ave, Cambridge, MA 02139, U S A.

        GET     Hdr.OS

        EXPORT  riscos_var_len

        AREA    |C$$code|, CODE, READONLY

riscos_var_len  ROUT
;Entry  R0 -> name of a variable
;       R1 = variable type (os_VARTYPE_EXPANDED or 0)
;Exit   R0 = length of variable value, or -1 if not found
        STMFD   SP!, {R4, LR}
        MOV     R4, R1
        MOV     R3, #0
        MOV     R2, #1 << 31
        MOV     R1, #Null
        SWI     XOS_ReadVarVal
        ;Ignore error
        MVN     R0, R2
    [ {CONFIG}=26
        LDMFD   SP!, {R4, PC}^
    |
        LDMFD   SP!, {R4, PC}
    ]

        END
