; Outputs the builtin variables : {CPU}, {ARCHITECTURE}, {FPU},
; {TARGET_ARCH_ARM}, {TARGET_ARCH_THUMB}, {TARGET_ARCH_1}, {TARGET_ARCH_2},
; {TARGET_ARCH_2A}, {TARGET_ARCH_3}, {TARGET_ARCH_3G}, {TARGET_ARCH_3M},
; {TARGET_ARCH_4XM}, {TARGET_ARCH_4}, {TARGET_ARCH_4TXM}, {TARGET_ARCH_4T},
; {TARGET_ARCH_5XM}, {TARGET_ARCH_5}, {TARGET_ARCH_5TXM}, {TARGET_ARCH_5T},
; {TARGET_ARCH_5TEXP}, {TARGET_ARCH_5TE}, {TARGET_ARCH_5TEJ},
; {TARGET_ARCH, {TARGET_ARCH_6K}, {TARGET_ARCH_6T2}, {TARGET_ARCH_6Z},
; {TARGET_ARCH_6_M}, {TARGET_ARCH_6S_M}, {TARGET_ARCH_7}, {TARGET_ARCH_7_A},
; {TARGET_ARCH_7_R}, {TARGET_ARCH_7_M}, {TARGET_ARCH_7E_M},
; {TARGET_FEATURE_CLZ}, {TARGET_FEATURE_DIVIDE}, {TARGET_FEATURE_DOUBLEWORD},
; {TARGET_FEATURE_DSPMUL}, {TARGET_FEATURE_EXTENSION_REGISTER_COUNT},
; {TARGET_FEATURE_MULTIPLY}, {TARGET_FEATURE_MULTIPROCESSING},
; {TARGET_FEATURE_NEON}, {TARGET_FEATURE_NEON_FP16},
; {TARGET_FEATURE_NEON_FP32}, {TARGET_FEATURE_NEON_INTEGER},
; {TARGET_FEATURE_UNALIGNED},
; {TARGET_FPU_FPA}, {TARGET_FPU_SOFTFPA}, {TARGET_FPU_SOFTFPA_FPA},
; {TARGET_FPU_SOFTFPA_VFP}, {TARGET_FPU_SOFTVFP}, {TARGET_FPU_SOFTVFP_FPA},
; {TARGET_FPU_SOFTVFP_VFP}, {TARGET_FPU_VFP}, {TARGET_FPU_VFPV1},
; {TARGET_FPU_VFPV2}, {TARGET_FPU_VFPV3}, {TARGET_FPU_VFPV4},
; {TARGET_PROFILE_A}, {TARGET_PROFILE_M}, {TARGET_PROFILE_R}.

	AREA	Data, DATA

	= "\n"

	[ :LNOT: REFERENCE
	= "{CPU} : ", {CPU}, "\n"
	= "{ARCHITECTURE} : ", {ARCHITECTURE}, "\n"
	= "{FPU} : ", {FPU}, "\n"

	= "{TARGET_ARCH_ARM} : ", :STR:{TARGET_ARCH_ARM}, "\n"
	= "{TARGET_ARCH_THUMB} : ", :STR:{TARGET_ARCH_THUMB}, "\n"

	= "{TARGET_ARCH_1} : ", :STR:{TARGET_ARCH_1}, "\n"
	= "{TARGET_ARCH_2} : ", :STR:{TARGET_ARCH_2}, "\n"
	= "{TARGET_ARCH_2A} : ", :STR:{TARGET_ARCH_2A}, "\n"
	= "{TARGET_ARCH_3} : ", :STR:{TARGET_ARCH_3}, "\n"
	= "{TARGET_ARCH_3G} : ", :STR:{TARGET_ARCH_3G}, "\n"
	= "{TARGET_ARCH_3M} : ", :STR:{TARGET_ARCH_3M}, "\n"
	= "{TARGET_ARCH_4XM} : ", :STR:{TARGET_ARCH_4XM}, "\n"
	= "{TARGET_ARCH_4} : ", :STR:{TARGET_ARCH_4}, "\n"
	= "{TARGET_ARCH_4TXM} : ", :STR:{TARGET_ARCH_4TXM}, "\n"
	= "{TARGET_ARCH_4T} : ", :STR:{TARGET_ARCH_4T}, "\n"
	= "{TARGET_ARCH_5XM} : ", :STR:{TARGET_ARCH_5XM}, "\n"
	= "{TARGET_ARCH_5} : ", :STR:{TARGET_ARCH_5}, "\n"
	= "{TARGET_ARCH_5TXM} : ", :STR:{TARGET_ARCH_5TXM}, "\n"
	= "{TARGET_ARCH_5T} : ", :STR:{TARGET_ARCH_5T}, "\n"
	= "{TARGET_ARCH_5TEXP} : ", :STR:{TARGET_ARCH_5TEXP}, "\n"
	= "{TARGET_ARCH_5TE} : ", :STR:{TARGET_ARCH_5TE}, "\n"
	= "{TARGET_ARCH_5TEJ} : ", :STR:{TARGET_ARCH_5TEJ}, "\n"
	= "{TARGET_ARCH_6} : ", :STR:{TARGET_ARCH_6}, "\n"
	= "{TARGET_ARCH_6K} : ", :STR:{TARGET_ARCH_6K}, "\n"
	= "{TARGET_ARCH_6T2} : ", :STR:{TARGET_ARCH_6T2}, "\n"
	= "{TARGET_ARCH_6Z} : ", :STR:{TARGET_ARCH_6Z}, "\n"
	= "{TARGET_ARCH_6_M} : ", :STR:{TARGET_ARCH_6_M}, "\n"
	= "{TARGET_ARCH_6S_M} : ", :STR:{TARGET_ARCH_6S_M}, "\n"
	= "{TARGET_ARCH_7} : ", :STR:{TARGET_ARCH_7}, "\n"
	= "{TARGET_ARCH_7_A} : ", :STR:{TARGET_ARCH_7_A}, "\n"
	= "{TARGET_ARCH_7_R} : ", :STR:{TARGET_ARCH_7_R}, "\n"
	= "{TARGET_ARCH_7_M} : ", :STR:{TARGET_ARCH_7_M}, "\n"
	= "{TARGET_ARCH_7E_M} : ", :STR:{TARGET_ARCH_7E_M}, "\n"
	= "{TARGET_ARCH_8} : ", :STR:{TARGET_ARCH_8}, "\n"
	= "{TARGET_ARCH_8_A} : ", :STR:{TARGET_ARCH_8_A}, "\n"

	= "{TARGET_FEATURE_CLZ} : ", :STR:{TARGET_FEATURE_CLZ}, "\n"
	= "{TARGET_FEATURE_DIVIDE} : ", :STR:{TARGET_FEATURE_DIVIDE}, "\n"
	= "{TARGET_FEATURE_DOUBLEWORD} : ", :STR:{TARGET_FEATURE_DOUBLEWORD}, "\n"
	= "{TARGET_FEATURE_DSPMUL} : ", :STR:{TARGET_FEATURE_DSPMUL}, "\n"
	= "{TARGET_FEATURE_EXTENSION_REGISTER_COUNT} : ", :STR:{TARGET_FEATURE_EXTENSION_REGISTER_COUNT}, "\n"
	= "{TARGET_FEATURE_MULTIPLY} : ", :STR:{TARGET_FEATURE_MULTIPLY}, "\n"
	= "{TARGET_FEATURE_MULTIPROCESSING} : ", :STR:{TARGET_FEATURE_MULTIPROCESSING}, "\n"
	= "{TARGET_FEATURE_NEON} : ", :STR:{TARGET_FEATURE_NEON}, "\n"
	= "{TARGET_FEATURE_NEON_FP16} : ", :STR:{TARGET_FEATURE_NEON_FP16}, "\n"
	= "{TARGET_FEATURE_NEON_FP32} : ", :STR:{TARGET_FEATURE_NEON_FP32}, "\n"
	= "{TARGET_FEATURE_NEON_INTEGER} : ", :STR:{TARGET_FEATURE_NEON_INTEGER}, "\n"
	= "{TARGET_FEATURE_UNALIGNED} : ", :STR:{TARGET_FEATURE_UNALIGNED}, "\n"

	= "{TARGET_FPU_FPA} : ", :STR:{TARGET_FPU_FPA}, "\n"
	= "{TARGET_FPU_SOFTFPA} : ", :STR:{TARGET_FPU_SOFTFPA}, "\n"
	= "{TARGET_FPU_SOFTFPA_FPA} : ", :STR:{TARGET_FPU_SOFTFPA_FPA}, "\n"
	= "{TARGET_FPU_SOFTFPA_VFP} : ", :STR:{TARGET_FPU_SOFTFPA_VFP}, "\n"
	= "{TARGET_FPU_SOFTVFP} : ", :STR:{TARGET_FPU_SOFTVFP}, "\n"
	= "{TARGET_FPU_SOFTVFP_FPA} : ", :STR:{TARGET_FPU_SOFTVFP_FPA}, "\n"
	= "{TARGET_FPU_SOFTVFP_VFP} : ", :STR:{TARGET_FPU_SOFTVFP_VFP}, "\n"
	= "{TARGET_FPU_VFP} : ", :STR:{TARGET_FPU_VFP}, "\n"
	= "{TARGET_FPU_VFPV1} : ", :STR:{TARGET_FPU_VFPV1}, "\n"
	= "{TARGET_FPU_VFPV2} : ", :STR:{TARGET_FPU_VFPV2}, "\n"
	= "{TARGET_FPU_VFPV3} : ", :STR:{TARGET_FPU_VFPV3}, "\n"
	= "{TARGET_FPU_VFPV4} : ", :STR:{TARGET_FPU_VFPV4}, "\n"
	; FIXME: ARMv8 versions for {TARGET_FPU_...} ?

	= "{TARGET_PROFILE_A} : ", :STR:{TARGET_PROFILE_A}, "\n"
	= "{TARGET_PROFILE_M} : ", :STR:{TARGET_PROFILE_M}, "\n"
	= "{TARGET_PROFILE_R} : ", :STR:{TARGET_PROFILE_R}, "\n"

	; Santiy checks:

	; Count number of {TARGET_FPU_VFPV*} set:
	GBLA	NumVFPV
	[ {TARGET_FPU_VFPV1}
NumVFPV	SETA	NumVFPV + 1
	]
	[ {TARGET_FPU_VFPV2}
NumVFPV	SETA	NumVFPV + 1
	]
	[ {TARGET_FPU_VFPV3}
NumVFPV	SETA	NumVFPV + 1
	]
	[ {TARGET_FPU_VFPV4}
NumVFPV	SETA	NumVFPV + 1
	]
	; When {TARGET_FPU_VFP} is set, NumVFPV must be 1.  When {TARGEt_FPU_VFP}
	; is not set, NumVFPV must be 0.
	ASSERT ({TARGET_FPU_VFP} :LAND: (NumVFPV = 1)) :LOR: (:LNOT: {TARGET_FPU_VFP} :LAND: (NumVFPV = 0))

	GBLA	NumProfile
	[ {TARGET_PROFILE_A}
NumProfile SETA NumProfile + 1
	]
	[ {TARGET_PROFILE_M}
NumProfile SETA NumProfile + 1
	]
	[ {TARGET_PROFILE_R}
NumProfile SETA NumProfile + 1
	]
	ASSERT NumProfile = 0 :LOR: NumProfile = 1

	]

	END
