/*
 * IBM Accurate Mathematical Library
 * Written by International Business Machines Corp.
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/***************************************************************************/
/* Table for  arcsin() and arccos()  FUNCTIONS                             */
/***************************************************************************/

#ifdef BIG_ENDI
static const union {int4 i[5136];double x[2568];} asncs = { .i = {
/**/                   0x3FC04000, 0x00000000,
/**/                   0x3FF02169, 0x88994424,
/**/                   0x3FB0A6A2, 0xB799B115,
/**/                   0x3FC6EF15, 0xD57409A0,
/**/                   0x3FAA141E, 0xAF52EAA0,
/**/                   0x3FB75591, 0xABBBE261,
/**/                   0x3FA72B51, 0xD206D88F,
/**/                   0x3C96B595, 0x5BB33E7D,
/**/                   0x3FC04B41, 0xA03E2700,
/**/                   0x3FF04000, 0x00000000,
/**/                   0xBF7E9677, 0x66BBDC7C,
/**/                   0x3FC0C000, 0x00000000,
/**/                   0x3FF02386, 0xF9E23A56,
/**/                   0x3FB1308C, 0x60FD0235,
/**/                   0x3FC7099F, 0x14D16B02,
/**/                   0x3FAAFED6, 0x27C01EE1,
/**/                   0x3FB79C6F, 0xDBCD5F98,
/**/                   0x3FA8144A, 0x4084DAAC,
/**/                   0xBC87C092, 0x38D8505E,
/**/                   0x3FC0CC55, 0x56C9F380,
/**/                   0x3FF04000, 0x00000000,
/**/                   0xBF7C7906, 0x1DC5AA24,
/**/                   0x3FC14000, 0x00000000,
/**/                   0x3FF025B5, 0xB27141F6,
/**/                   0x3FB1BB18, 0x04CE7400,
/**/                   0x3FC72514, 0x72907342,
/**/                   0x3FABEC60, 0x0BF4222C,
/**/                   0x3FB7E610, 0x75B3736C,
/**/                   0x3FA9024C, 0x5199C343,
/**/                   0xBC8AE84C, 0x06B56F60,
/**/                   0x3FC14D7A, 0x3DEFA070,
/**/                   0x3FF04000, 0x00000000,
/**/                   0xBF7A4A4D, 0x8EBE0A5C,
/**/                   0x3FC1C000, 0x00000000,
/**/                   0x3FF027F5, 0xC6DE8F57,
/**/                   0x3FB2464B, 0x345751E1,
/**/                   0x3FC74178, 0xCF026805,
/**/                   0x3FACDCD8, 0x40A9E0D6,
/**/                   0x3FB83282, 0xEB1D9C38,
/**/                   0x3FA9F590, 0xD7BE707B,
/**/                   0xBCAB9768, 0x03A2A6D6,
/**/                   0x3FC1CEB0, 0xE03B4870,
/**/                   0x3FF04000, 0x00000000,
/**/                   0xBF780A39, 0x2170A943,
/**/                   0x3FC24000, 0x00000000,
/**/                   0x3FF02A47, 0x4C759796,
/**/                   0x3FB2D22B, 0x92771935,
/**/                   0x3FC75ECF, 0x26ABA06D,
/**/                   0x3FADD05B, 0x486A1932,
/**/                   0x3FB881D7, 0x5AF971D5,
/**/                   0x3FAAEE52, 0x831AEE0C,
/**/                   0x3CA13F57, 0xAD1B1BEF,
/**/                   0x3FC24FF9, 0xC8E09330,
/**/                   0x3FF04000, 0x00000000,
/**/                   0xBF75B8B3, 0x8A68699B,
/**/                   0x3FC2C000, 0x00000000,
/**/                   0x3FF02CAA, 0x59374E09,
/**/                   0x3FB35EBE, 0xD44E8BEA,
/**/                   0x3FC77D1A, 0x92E4BE8A,
/**/                   0x3FAEC706, 0x4A6C34FD,
/**/                   0x3FB8D41E, 0x972F6E07,
/**/                   0x3FABECCD, 0xF9845F69,
/**/                   0x3C8BA1FA, 0x945C4185,
/**/                   0x3FC2D155, 0x83C058B0,
/**/                   0x3FF04000, 0x00000000,
/**/                   0xBF7355A6, 0xC8B1F774,
/**/                   0x3FC34000, 0x00000000,
/**/                   0x3FF02F1F, 0x03DC7745,
/**/                   0x3FB3EC0A, 0xC1EE9F61,
/**/                   0x3FC79C5E, 0x4A82E6D2,
/**/                   0x3FAFC0F7, 0x19B1EF72,
/**/                   0x3FB9296A, 0x2AA943E5,
/**/                   0x3FACF141, 0xEF8B9DE7,
/**/                   0xBC834081, 0x083C8716,
/**/                   0x3FC352C4, 0x9D6E5610,
/**/                   0x3FF04000, 0x00000000,
/**/                   0xBF70E0FC, 0x2388BB30,
/**/                   0x3FC3C000, 0x00000000,
/**/                   0x3FF031A5, 0x63D81251,
/**/                   0x3FB47A15, 0x370B721F,
/**/                   0x3FC7BC9D, 0xA28731E5,
/**/                   0x3FB05F26, 0x1E305BE9,
/**/                   0x3FB981CC, 0x5FA50FBD,
/**/                   0x3FADFBEF, 0x42AC4083,
/**/                   0x3CA20ACB, 0xA8E107C7,
/**/                   0x3FC3D447, 0xA336F5E0,
/**/                   0x3FF04000, 0x00000000,
/**/                   0xBF6CB538, 0x4FDB5D5C,
/**/                   0x3FC44000, 0x00000000,
/**/                   0x3FF0343D, 0x9159D86F,
/**/                   0x3FB508E4, 0x23B3747C,
/**/                   0x3FC7DDDC, 0x0ED597CB,
/**/                   0x3FB0DF92, 0x79ADF104,
/**/                   0x3FB9DD58, 0x4658D945,
/**/                   0x3FAF0D19, 0x14ACA06B,
/**/                   0xBCA4E10D, 0xDF636EFE,
/**/                   0x3FC455DF, 0x23252C00,
/**/                   0x3FF04000, 0x00000000,
/**/                   0xBF6784DD, 0x4C4F221A,
/**/                   0x3FC4C000, 0x00000000,
/**/                   0x3FF036E7, 0xA550D410,
/**/                   0x3FB5987D, 0x8D0AF1E7,
/**/                   0x3FC8001D, 0x22F39726,
/**/                   0x3FB161D0, 0xA1116D73,
/**/                   0x3FBA3C21, 0xBBEA1528,
/**/                   0x3FB01282, 0x74202FF6,
/**/                   0x3CAA0611, 0xD10866E2,
/**/                   0x3FC4D78B, 0xAC086560,
/**/                   0x3FF04000, 0x00000000,
/**/                   0xBF6230B5, 0x5E57DF8A,
/**/                   0x3FC54000, 0x00000000,
/**/                   0x3FF039A3, 0xB96E0F8A,
/**/                   0x3FB628E7, 0x8E0C29F6,
/**/                   0x3FC82364, 0x92CEDE01,
/**/                   0x3FB1E5F0, 0xFB7B5D84,
/**/                   0x3FBA9E3D, 0x71BD08EE,
/**/                   0x3FB0A1FD, 0x5F7FFAB4,
/**/                   0xBC90F980, 0xEF04F6E7,
/**/                   0x3FC5594D, 0xCD7A8DC0,
/**/                   0x3FF04000, 0x00000000,
/**/                   0xBF59711A, 0x47C1D879,
/**/                   0x3FC5C000, 0x00000000,
/**/                   0x3FF03C71, 0xE8275C12,
/**/                   0x3FB6BA28, 0x584C2A23,
/**/                   0x3FC847B6, 0x338C3D4B,
/**/                   0x3FB26C04, 0x59A55DD8,
/**/                   0x3FBB03C0, 0xF5202D6A,
/**/                   0x3FB13522, 0x9C6466A4,
/**/                   0x3C983C9A, 0x2A268973,
/**/                   0x3FC5DB26, 0x17E62A20,
/**/                   0x3FF04000, 0x00000000,
/**/                   0xBF4C70BE, 0xC51F7008,
/**/                   0x3FC64000, 0x00000000,
/**/                   0x3FF03F52, 0x4CBA31A9,
/**/                   0x3FB74C46, 0x34C49ADE,
/**/                   0x3FC86D15, 0xFC5F33CC,
/**/                   0x3FB2F41B, 0xFA419D7C,
/**/                   0x3FBB6CC2, 0xB757E82A,
/**/                   0x3FB1CC18, 0xDA4D5C39,
/**/                   0xBCA862D4, 0x2DFB224D,
/**/                   0x3FC65D15, 0x1C8C8AF0,
/**/                   0x3FF04000, 0x00000000,
/**/                   0xBF25B668, 0xB9CADBBF,
/**/                   0x3FC6C000, 0x00000000,
/**/                   0x3FF04245, 0x032EA88F,
/**/                   0x3FB7DF47, 0x84A2B473,
/**/                   0x3FC89388, 0x076A60F5,
/**/                   0x3FB37E49, 0x8E8394C1,
/**/                   0x3FBBD95A, 0x160F3472,
/**/                   0x3FB26708, 0x39844810,
/**/                   0x3C994228, 0x698BC8EA,
/**/                   0x3FC6DF1B, 0x6D8C14A0,
/**/                   0x3FF04000, 0x00000000,
/**/                   0x3F422819, 0x754477AC,
/**/                   0x3FC74000, 0x00000000,
/**/                   0x3FF0454A, 0x285A8CEB,
/**/                   0x3FB87332, 0xC21B9224,
/**/                   0x3FC8BB10, 0x92A93402,
/**/                   0x3FB40A9F, 0x3ED3F586,
/**/                   0x3FBC499F, 0x643217C8,
/**/                   0x3FB3061A, 0x5D29A16B,
/**/                   0xBCA3B2DF, 0x3DF9F2D7,
/**/                   0x3FC76139, 0x9DE6A160,
/**/                   0x3FF04000, 0x00000000,
/**/                   0x3F5528A1, 0x6A33AB4B,
/**/                   0x3FC7C000, 0x00000000,
/**/                   0x3FF04861, 0xD9E48D58,
/**/                   0x3FB9080E, 0x81461BF6,
/**/                   0x3FC8E3B4, 0x00E32FFA,
/**/                   0x3FB4992F, 0xAFB1F2A5,
/**/                   0x3FBCBDAB, 0xF33705D5,
/**/                   0x3FB3A97A, 0x7E23EE89,
/**/                   0x3C7AAD12, 0xCCE44C41,
/**/                   0x3FC7E370, 0x4187FAE0,
/**/                   0x3FF04000, 0x00000000,
/**/                   0x3F60C3B3, 0xC91AAF11,
/**/                   0x3FC84000, 0x00000000,
/**/                   0x3FF04B8C, 0x36478509,
/**/                   0x3FB99DE1, 0x70FAC1B4,
/**/                   0x3FC90D76, 0xDAA92166,
/**/                   0x3FB52A0E, 0x06C416A6,
/**/                   0x3FBD359A, 0x1CDCA344,
/**/                   0x3FB45155, 0x7EFD4CA0,
/**/                   0x3C396CA5, 0x35A8895D,
/**/                   0x3FC865BF, 0xED4C6EF0,
/**/                   0x3FF04000, 0x00000000,
/**/                   0x3F67186C, 0x8F0A11A4,
/**/                   0x3FC8C000, 0x00000000,
/**/                   0x3FF04EC9, 0x5CD5E248,
/**/                   0x3FBA34B2, 0x5BB94403,
/**/                   0x3FC9385D, 0xCF5CA73A,
/**/                   0x3FB5BD4D, 0xF01AFDBE,
/**/                   0x3FBDB185, 0x4D61A7A9,
/**/                   0x3FB4FDDA, 0x00BD47CF,
/**/                   0xBC9D1119, 0x727E8B64,
/**/                   0x3FC8E829, 0x37077E20,
/**/                   0x3FF04000, 0x00000000,
/**/                   0x3F6D92B9, 0xABC490CB,
/**/                   0x3FC94000, 0x00000000,
/**/                   0x3FF05219, 0x6DBD2A10,
/**/                   0x3FBACC88, 0x2894CAA1,
/**/                   0x3FC9646D, 0xB6427516,
/**/                   0x3FB65303, 0xA3A864D7,
/**/                   0x3FBE318A, 0x0E3CF3D4,
/**/                   0x3FB5AF38, 0x78CDA678,
/**/                   0x3CA3841D, 0xDA9D51DF,
/**/                   0x3FC96AAC, 0xB58AA660,
/**/                   0x3FF04000, 0x00000000,
/**/                   0x3F72196D, 0xBD2A1052,
/**/                   0x3FC9C000, 0x00000000,
/**/                   0x3FF0557C, 0x8A099990,
/**/                   0x3FBB6569, 0xDC268965,
/**/                   0x3FC991AB, 0x8F9FBA21,
/**/                   0x3FB6EB43, 0xEAED1E85,
/**/                   0x3FBEB5C6, 0x115C4C63,
/**/                   0x3FB665A3, 0x47F9AEFA,
/**/                   0xBCA1F8FD, 0x03AB3673,
/**/                   0x3FC9ED4B, 0x00AC4A60,
/**/                   0x3FF04000, 0x00000000,
/**/                   0x3F757C8A, 0x0999905B,
/**/                   0x3FCA4000, 0x00000000,
/**/                   0x3FF058F2, 0xD3A9E674,
/**/                   0x3FBBFF5E, 0x99873832,
/**/                   0x3FC9C01C, 0x85E31CE9,
/**/                   0x3FB78624, 0x26E09FF2,
/**/                   0x3FBF3E58, 0x3CF0885C,
/**/                   0x3FB7214E, 0xD2986239,
/**/                   0x3C97E3E5, 0x3E594694,
/**/                   0x3FCA7004, 0xB14EB5D0,
/**/                   0x3FF04000, 0x00000000,
/**/                   0x3F78F2D3, 0xA9E6746B,
/**/                   0x3FCAC000, 0x00000000,
/**/                   0x3FF05C7C, 0x6D731ECB,
/**/                   0x3FBC9A6D, 0xA34FA4B3,
/**/                   0x3FC9EFC5, 0xEED9C253,
/**/                   0x3FB823BA, 0x5614FAEB,
/**/                   0x3FBFCB60, 0xB7CE698F,
/**/                   0x3FB7E271, 0x99F3292F,
/**/                   0xBC9842C6, 0x068D709C,
/**/                   0x3FCAF2DA, 0x61674110,
/**/                   0x3FF04000, 0x00000000,
/**/                   0x3F7C7C6D, 0x731ECAE2,
/**/                   0x3FCB4000, 0x00000000,
/**/                   0x3FF06019, 0x7B24A973,
/**/                   0x3FBD369E, 0x5CA0A798,
/**/                   0x3FCA20AD, 0x4CF0DB64,
/**/                   0x3FB8C41D, 0x1B1A3F31,
/**/                   0x3FC02E80, 0x7B35E049,
/**/                   0x3FB8A944, 0x56FB8A97,
/**/                   0xBCACBF9C, 0xD337B37C,
/**/                   0x3FCB75CC, 0xAC059370,
/**/                   0x3FF08000, 0x00000000,
/**/                   0xBF7FE684, 0xDB568D78,
/**/                   0x3FCBC000, 0x00000000,
/**/                   0x3FF063CA, 0x216C6801,
/**/                   0x3FBDD3F8, 0x4A32C9FD,
/**/                   0x3FCA52D8, 0x50843BC9,
/**/                   0x3FB96763, 0xC324648A,
/**/                   0x3FC079AD, 0xE4407899,
/**/                   0x3FB97602, 0x1663A5DC,
/**/                   0xBCA3ADC3, 0xC637289D,
/**/                   0x3FCBF8DC, 0x2D5B06A0,
/**/                   0x3FF08000, 0x00000000,
/**/                   0xBF7C35DE, 0x9397FEA6,
/**/                   0x3FCC4000, 0x00000000,
/**/                   0x3FF0678E, 0x85EAFB1F,
/**/                   0x3FBE7283, 0x136DEAC6,
/**/                   0x3FCA864C, 0xD93A817D,
/**/                   0x3FBA0DA6, 0x4CF7089B,
/**/                   0x3FC0C74A, 0xB3ABB322,
/**/                   0x3FBA48E8, 0x562E6E1E,
/**/                   0xBC951E3E, 0x7EB8FFF8,
/**/                   0x3FCC7C09, 0x82C22B80,
/**/                   0x3FF08000, 0x00000000,
/**/                   0xBF78717A, 0x1504E0D3,
/**/                   0x3FCCC000, 0x00000000,
/**/                   0x3FF06B66, 0xCF382A59,
/**/                   0x3FBF1246, 0x838936FB,
/**/                   0x3FCABB10, 0xF76F5C94,
/**/                   0x3FBAB6FD, 0x701A77AE,
/**/                   0x3FC11769, 0xC26702C6,
/**/                   0x3FBB2237, 0x24CDF38E,
/**/                   0xBC8DB69A, 0xE28307A9,
/**/                   0x3FCCFF55, 0x4AC67190,
/**/                   0x3FF08000, 0x00000000,
/**/                   0xBF749930, 0xC7D5A6B9,
/**/                   0x3FCD4000, 0x00000000,
/**/                   0x3FF06F53, 0x24E7707F,
/**/                   0x3FBFB34A, 0x8AB3CBB2,
/**/                   0x3FCAF12A, 0xEDAC8D74,
/**/                   0x3FBB6382, 0xA45DA614,
/**/                   0x3FC16A1E, 0xAD8E9F44,
/**/                   0x3FBC0231, 0x41E7749D,
/**/                   0x3C76CA27, 0x22DC16A2,
/**/                   0x3FCD82C0, 0x252BF240,
/**/                   0x3FF08000, 0x00000000,
/**/                   0xBF70ACDB, 0x188F814B,
/**/                   0x3FCDC000, 0x00000000,
/**/                   0x3FF07353, 0xAF8CADA0,
/**/                   0x3FC02ACB, 0x9FA32DC9,
/**/                   0x3FCB28A1, 0x32323718,
/**/                   0x3FBC1350, 0x29A8F15E,
/**/                   0x3FC1BF7D, 0xDEB270E1,
/**/                   0x3FBCE91C, 0x40D67463,
/**/                   0x3CA6E976, 0x104BAA08,
/**/                   0x3FCE064A, 0xB2F76140,
/**/                   0x3FF08000, 0x00000000,
/**/                   0xBF6958A0, 0xE6A4BFC9,
/**/                   0x3FCE4000, 0x00000000,
/**/                   0x3FF07768, 0x98C0FFD9,
/**/                   0x3FC07C9A, 0x6F7F1AF0,
/**/                   0x3FCB617A, 0x708F2AFB,
/**/                   0x3FBCC681, 0x1025B50C,
/**/                   0x3FC2179C, 0x9487453A,
/**/                   0x3FBDD740, 0xAD09B3AB,
/**/                   0xBC8D32DB, 0x189038C0,
/**/                   0x3FCE89F5, 0x96762300,
/**/                   0x3FF08000, 0x00000000,
/**/                   0xBF612ECE, 0x7E004D50,
/**/                   0x3FCEC000, 0x00000000,
/**/                   0x3FF07B92, 0x0B27C417,
/**/                   0x3FC0CF15, 0xE821087A,
/**/                   0x3FCB9BBD, 0x8B49DC8C,
/**/                   0x3FBD7D31, 0x40BEF5C2,
/**/                   0x3FC27290, 0xEC080575,
/**/                   0x3FBECCEA, 0x3056A6A9,
/**/                   0x3C9DE506, 0x0C9B27A2,
/**/                   0x3FCF0DC1, 0x73468A50,
/**/                   0x3FF08000, 0x00000000,
/**/                   0xBF51B7D3, 0x60EFA34D,
/**/                   0x3FCF4000, 0x00000000,
/**/                   0x3FF07FD0, 0x3273C018,
/**/                   0x3FC12242, 0x51B87F08,
/**/                   0x3FCBD771, 0x9D9AB2BC,
/**/                   0x3FBE377D, 0x85FFA125,
/**/                   0x3FC2D071, 0xEA0CFE55,
/**/                   0x3FBFCA67, 0xBB61DDD3,
/**/                   0xBCA25383, 0x88A645E7,
/**/                   0x3FCF91AE, 0xEE603F40,
/**/                   0x3FF08000, 0x00000000,
/**/                   0xBF07E6C6, 0x1FF422B6,
/**/                   0x3FCFC000, 0x00000000,
/**/                   0x3FF08423, 0x3B6C76F2,
/**/                   0x3FC17624, 0x0A1DF897,
/**/                   0x3FCC149D, 0xFD38779D,
/**/                   0x3FBEF583, 0x95531ECD,
/**/                   0x3FC33157, 0x855FA966,
/**/                   0x3FC06805, 0xD81E6BAA,
/**/                   0x3C86827E, 0x1B47FAEC,
/**/                   0x3FD00ADF, 0x570E6798,
/**/                   0x3FF08000, 0x00000000,
/**/                   0x3F508CED, 0xB1DBC656,
/**/                   0x3FD02000, 0x00000000,
/**/                   0x3FF0888B, 0x53F3A97B,
/**/                   0x3FC1CABF, 0x858525D6,
/**/                   0x3FCC534A, 0x3C37AF90,
/**/                   0x3FBFB762, 0x18AD312A,
/**/                   0x3FC3955A, 0xB151CAAD,
/**/                   0x3FC0EF16, 0x07ADE82D,
/**/                   0x3CAEEF44, 0xFCDE8746,
/**/                   0x3FD04CF8, 0xAD203480,
/**/                   0x3FF08000, 0x00000000,
/**/                   0x3F6116A7, 0xE752F5A1,
/**/                   0x3FD06000, 0x00000000,
/**/                   0x3FF08D08, 0xAB0B03F8,
/**/                   0x3FC22019, 0x4F34EEE8,
/**/                   0x3FCC937E, 0x2AFDABDE,
/**/                   0x3FC03E9C, 0x5C4F35BA,
/**/                   0x3FC3FC95, 0x68DF21A6,
/**/                   0x3FC17A91, 0x53843C52,
/**/                   0xBC9D6F54, 0xC2BB835A,
/**/                   0x3FD08F23, 0xCE0162B8,
/**/                   0x3FF08000, 0x00000000,
/**/                   0x3F6A1156, 0x1607EF23,
/**/                   0x3FD0A000, 0x00000000,
/**/                   0x3FF0919B, 0x70D9FA87,
/**/                   0x3FC27636, 0x0A456C09,
/**/                   0x3FCCD541, 0xDA483778,
/**/                   0x3FC0A394, 0x136D6630,
/**/                   0x3FC46722, 0xBA615E9C,
/**/                   0x3FC20AA6, 0xA2BC6F73,
/**/                   0x3CA9D006, 0x7F1D9D86,
/**/                   0x3FD0D161, 0x0F0C1EC8,
/**/                   0x3FF08000, 0x00000000,
/**/                   0x3F719B70, 0xD9FA8688,
/**/                   0x3FD0E000, 0x00000000,
/**/                   0x3FF09643, 0xD6B3D5D1,
/**/                   0x3FC2CD1A, 0x72641546,
/**/                   0x3FCD189D, 0x9D4AC7EC,
/**/                   0x3FC10AA9, 0x149C2E66,
/**/                   0x3FC4D51E, 0xD3DE8741,
/**/                   0x3FC29F86, 0xF6DA4768,
/**/                   0x3CAEA900, 0x828C2A81,
/**/                   0x3FD113B0, 0xC65D88C8,
/**/                   0x3FF08000, 0x00000000,
/**/                   0x3F7643D6, 0xB3D5D119,
/**/                   0x3FD12000, 0x00000000,
/**/                   0x3FF09B02, 0x0F1DF195,
/**/                   0x3FC324CB, 0x5C9E6B3F,
/**/                   0x3FCD5D9A, 0x0BE228B7,
/**/                   0x3FC173EC, 0xD29602B0,
/**/                   0x3FC546A7, 0x0FFA7799,
/**/                   0x3FC33965, 0x87BA569F,
/**/                   0xBCAE3258, 0x9956F2C3,
/**/                   0x3FD15613, 0x4ADA6FF0,
/**/                   0x3FF08000, 0x00000000,
/**/                   0x3F7B020F, 0x1DF1952F,
/**/                   0x3FD16000, 0x00000000,
/**/                   0x3FF09FD6, 0x4DD62EB0,
/**/                   0x3FC37D4D, 0xB8335DE5,
/**/                   0x3FCDA440, 0x04DFA3F1,
/**/                   0x3FC1DF71, 0x55E59412,
/**/                   0x3FC5BBDA, 0x0394B72E,
/**/                   0x3FC3D877, 0xE1177398,
/**/                   0x3CA8AC88, 0x3B5720A7,
/**/                   0x3FD19888, 0xF43427A8,
/**/                   0x3FF08000, 0x00000000,
/**/                   0x3F7FD64D, 0xD62EAF85,
/**/                   0x3FD1A000, 0x00000000,
/**/                   0x3FF0A4C0, 0xC7D99A5F,
/**/                   0x3FC3D6A6, 0x8F6BB942,
/**/                   0x3FCDEC98, 0xB06CB8A9,
/**/                   0x3FC24D49, 0x432C74B1,
/**/                   0x3FC634D7, 0x8C1C6EC6,
/**/                   0x3FC47CF6, 0x01BF2560,
/**/                   0x3CA3EDE7, 0x476E25C7,
/**/                   0x3FD1DB12, 0x1AED7720,
/**/                   0x3FF0C000, 0x00000000,
/**/                   0xBF7B3F38, 0x2665A126,
/**/                   0x3FD1E000, 0x00000000,
/**/                   0x3FF0A9C1, 0xB36B4C8B,
/**/                   0x3FC430DB, 0x0879E39B,
/**/                   0x3FCE36AD, 0x82887D8B,
/**/                   0x3FC2BD87, 0xE1B33C79,
/**/                   0x3FC6B1C0, 0xDEA4E95E,
/**/                   0x3FC5271A, 0x7C90504A,
/**/                   0x3CAAFAD9, 0x8A6EBD08,
/**/                   0x3FD21DAF, 0x185FA360,
/**/                   0x3FF0C000, 0x00000000,
/**/                   0xBF763E4C, 0x94B3751C,
/**/                   0x3FD22000, 0x00000000,
/**/                   0x3FF0AED9, 0x481B7EED,
/**/                   0x3FC48BF0, 0x66613BB3,
/**/                   0x3FCE8288, 0x3D9FDD8F,
/**/                   0x3FC33041, 0x22470BF2,
/**/                   0x3FC732B8, 0x97C5B476,
/**/                   0x3FC5D722, 0x9B614F73,
/**/                   0x3CA96B82, 0x759745C8,
/**/                   0x3FD26060, 0x46BF95B8,
/**/                   0x3FF0C000, 0x00000000,
/**/                   0xBF7126B7, 0xE48112DC,
/**/                   0x3FD26000, 0x00000000,
/**/                   0x3FF0B407, 0xBECEDF0E,
/**/                   0x3FC4E7EC, 0x09E5699A,
/**/                   0x3FCED032, 0xF541EC2D,
/**/                   0x3FC3A589, 0xA6688484,
/**/                   0x3FC7B7E2, 0xCC5228BD,
/**/                   0x3FC68D4E, 0x83ECAD1F,
/**/                   0x3CA98586, 0x7CB79363,
/**/                   0x3FD2A326, 0x01231EC8,
/**/                   0x3FF0C000, 0x00000000,
/**/                   0xBF67F082, 0x6241E449,
/**/                   0x3FD2A000, 0x00000000,
/**/                   0x3FF0B94D, 0x51C61D1C,
/**/                   0x3FC544D3, 0x7281F837,
/**/                   0x3FCF1FB8, 0x10F19F89,
/**/                   0x3FC41D76, 0xC7D08A44,
/**/                   0x3FC84165, 0x1AF4E5E6,
/**/                   0x3FC749E1, 0x5EE5D838,
/**/                   0x3C8A2A36, 0xA1F9A890,
/**/                   0x3FD2E600, 0xA3865760,
/**/                   0x3FF0C000, 0x00000000,
/**/                   0xBF5ACAB8, 0xE78B8E2F,
/**/                   0x3FD2E000, 0x00000000,
/**/                   0x3FF0BEAA, 0x3CA5B9C1,
/**/                   0x3FC5A2AC, 0x3F6A91D3,
/**/                   0x3FCF7122, 0x4F1650DB,
/**/                   0x3FC4981E, 0xA04F63E7,
/**/                   0x3FC8CF66, 0xBEBC9B64,
/**/                   0x3FC80D21, 0x81598BF7,
/**/                   0xBC984143, 0x8E0FD320,
/**/                   0x3FD328F0, 0x8AD12008,
/**/                   0x3FF0C000, 0x00000000,
/**/                   0xBF355C35, 0xA463F3FD,
/**/                   0x3FD32000, 0x00000000,
/**/                   0x3FF0C41E, 0xBC7E151A,
/**/                   0x3FC6017C, 0x30943E19,
/**/                   0x3FCFC47C, 0xC80C760D,
/**/                   0x3FC51598, 0x120B129D,
/**/                   0x3FC96210, 0xA2A855B5,
/**/                   0x3FC8D758, 0x9880230D,
/**/                   0xBCA4D129, 0xBF178596,
/**/                   0x3FD36BF6, 0x14DCC050,
/**/                   0x3FF0C000, 0x00000000,
/**/                   0x3F507AF1, 0xF854661E,
/**/                   0x3FD36000, 0x00000000,
/**/                   0x3FF0C9AB, 0x0FD3C135,
/**/                   0x3FC66149, 0x27C80482,
/**/                   0x3FD00CE9, 0x78AC0DDD,
/**/                   0x3FC595FA, 0xD02204B1,
/**/                   0x3FC9F98D, 0x7642750D,
/**/                   0x3FC9A8D3, 0xD82AC48A,
/**/                   0x3C977587, 0x289B3951,
/**/                   0x3FD3AF11, 0xA079A6D8,
/**/                   0x3FF0C000, 0x00000000,
/**/                   0x3F63561F, 0xA7826A0D,
/**/                   0x3FD3A000, 0x00000000,
/**/                   0x3FF0CF4F, 0x76A81A69,
/**/                   0x3FC6C219, 0x29BF5ACD,
/**/                   0x3FD03898, 0x507D5DD4,
/**/                   0x3FC6195F, 0x67B79439,
/**/                   0x3FCA9609, 0xC35A709F,
/**/                   0x3FCA81E4, 0x2BF7455C,
/**/                   0x3CA03304, 0xF424551E,
/**/                   0x3FD3F243, 0x8D754B40,
/**/                   0x3FF0C000, 0x00000000,
/**/                   0x3F6E9EED, 0x5034D2A8,
/**/                   0x3FD3E000, 0x00000000,
/**/                   0x3FF0D50C, 0x3282280D,
/**/                   0x3FC723F2, 0x5F4ACC23,
/**/                   0x3FD06551, 0x08771131,
/**/                   0x3FC69FDF, 0x4970163E,
/**/                   0x3FCB37B4, 0x04EE9A0A,
/**/                   0x3FCB62DE, 0x6B79BC18,
/**/                   0x3CAECF25, 0x02A2F456,
/**/                   0x3FD4358C, 0x3CA032E0,
/**/                   0x3FF0C000, 0x00000000,
/**/                   0x3F750C32, 0x82280D28,
/**/                   0x3FD42000, 0x00000000,
/**/                   0x3FF0DAE1, 0x8677C82D,
/**/                   0x3FC786DB, 0x16834ABE,
/**/                   0x3FD09319, 0xF1631731,
/**/                   0x3FC72994, 0xD36297AF,
/**/                   0x3FCBDEBC, 0xBF583888,
/**/                   0x3FCC4C1B, 0x918E2AE6,
/**/                   0x3CA92F70, 0xF34A155C,
/**/                   0x3FD478EC, 0x0FD419C8,
/**/                   0x3FF0C000, 0x00000000,
/**/                   0x3F7AE186, 0x77C82D53,
/**/                   0x3FD46000, 0x00000000,
/**/                   0x3FF0E0CF, 0xB73728F8,
/**/                   0x3FC7EAD9, 0xC406A36A,
/**/                   0x3FD0C1F9, 0x91BDA616,
/**/                   0x3FC7B69B, 0x5B86C42B,
/**/                   0x3FCC8B56, 0x99CD8C9F,
/**/                   0x3FCD3DF8, 0xF7084936,
/**/                   0xBC923B74, 0x54942387,
/**/                   0x3FD4BC63, 0x69FA40E8,
/**/                   0x3FF10000, 0x00000000,
/**/                   0xBF7F3048, 0xC8D707BB,
/**/                   0x3FD4A000, 0x00000000,
/**/                   0x3FF0E6D7, 0x0B1092B8,
/**/                   0x3FC84FF5, 0x043F9011,
/**/                   0x3FD0F1F6, 0xA7AFD6EB,
/**/                   0x3FC8470F, 0x3AA5D7B9,
/**/                   0x3FCD3DB6, 0x794E9CFD,
/**/                   0x3FCE38D8, 0x90FB69FD,
/**/                   0x3C9CFA2D, 0xC2327DC5,
/**/                   0x3FD4FFF2, 0xAF11E2C0,
/**/                   0x3FF10000, 0x00000000,
/**/                   0xBF7928F4, 0xEF6D4848,
/**/                   0x3FD4E000, 0x00000000,
/**/                   0x3FF0ECF7, 0xCA008550,
/**/                   0x3FC8B633, 0x9CB9ECA7,
/**/                   0x3FD12318, 0x2B20AC3D,
/**/                   0x3FC8DB0D, 0xD7D5E860,
/**/                   0x3FCDF613, 0x9D1315AF,
/**/                   0x3FCF3D21, 0x32D8BC6F,
/**/                   0x3C9C6A36, 0x92E48EEE,
/**/                   0x3FD5439A, 0x4436D008,
/**/                   0x3FF10000, 0x00000000,
/**/                   0xBF730835, 0xFF7AAF92,
/**/                   0x3FD52000, 0x00000000,
/**/                   0x3FF0F332, 0x3DBA2C62,
/**/                   0x3FC91D9C, 0x7D83983C,
/**/                   0x3FD15565, 0x4FDDA02E,
/**/                   0x3FC972B5, 0xB48747C7,
/**/                   0x3FCEB4A7, 0xBC9105F9,
/**/                   0x3FD0259F, 0x6A535ECF,
/**/                   0x3C87EB36, 0xF6EA55C1,
/**/                   0x3FD5875A, 0x8FA83538,
/**/                   0x3FF10000, 0x00000000,
/**/                   0xBF699B84, 0x8BA73C6A,
/**/                   0x3FD56000, 0x00000000,
/**/                   0x3FF0F986, 0xB1B22D42,
/**/                   0x3FC98636, 0xC29A92ED,
/**/                   0x3FD188E5, 0x87DBE62D,
/**/                   0x3FCA0E26, 0x792C37EB,
/**/                   0x3FCF79AF, 0x2735E8CD,
/**/                   0x3FD0B1D1, 0x6ECCD4C0,
/**/                   0x3C9502B5, 0xBEAE0510,
/**/                   0x3FD5CB33, 0xF8CF8AC0,
/**/                   0x3FF10000, 0x00000000,
/**/                   0xBF59E539, 0x374AF74C,
/**/                   0x3FD5A000, 0x00000000,
/**/                   0x3FF0FFF5, 0x7329D23A,
/**/                   0x3FC9F009, 0xB568F082,
/**/                   0x3FD1BDA0, 0x85939DB2,
/**/                   0x3FCAAD81, 0x0283B18A,
/**/                   0x3FD022B4, 0x72F69148,
/**/                   0x3FD14362, 0x39AD0B79,
/**/                   0xBCAD7968, 0x80828B86,
/**/                   0x3FD60F26, 0xE847B130,
/**/                   0x3FF10000, 0x00000000,
/**/                   0xBEE519AC, 0x5B8BC081,
/**/                   0x3FD5E000, 0x00000000,
/**/                   0x3FF1067E, 0xD13A9687,
/**/                   0x3FCA5B1C, 0xCE4F3F61,
/**/                   0x3FD1F39E, 0x3E764545,
/**/                   0x3FCB50E7, 0x6F90871B,
/**/                   0x3FD08C0B, 0x6F487F97,
/**/                   0x3FD1DA90, 0x67265C20,
/**/                   0x3CAE5B02, 0x995723AD,
/**/                   0x3FD65333, 0xC7E43AA0,
/**/                   0x3FF10000, 0x00000000,
/**/                   0x3F59FB44, 0xEA5A1D64,
/**/                   0x3FD62000, 0x00000000,
/**/                   0x3FF10D23, 0x1CE216D9,
/**/                   0x3FCAC777, 0xB63E0B53,
/**/                   0x3FD22AE6, 0xED81D055,
/**/                   0x3FCBF87D, 0x3046C5AC,
/**/                   0x3FD0F8FE, 0xFCB29FE4,
/**/                   0x3FD2779D, 0xC99A404E,
/**/                   0xBCA2AF1E, 0xC3202AE8,
/**/                   0x3FD6975B, 0x02B8E378,
/**/                   0x3FF10000, 0x00000000,
/**/                   0x3F6A4639, 0xC42DB2AB,
/**/                   0x3FD66000, 0x00000000,
/**/                   0x3FF113E2, 0xA90E6A24,
/**/                   0x3FCB3522, 0x485F2C6B,
/**/                   0x3FD26383, 0x15F1D6CC,
/**/                   0x3FCCA467, 0x14F9D555,
/**/                   0x3FD169B3, 0x245E397E,
/**/                   0x3FD31ACF, 0x99479CF7,
/**/                   0xBC730D3F, 0x8992C228,
/**/                   0x3FD6DB9D, 0x05213B28,
/**/                   0x3FF10000, 0x00000000,
/**/                   0x3F73E2A9, 0x0E6A2469,
/**/                   0x3FD6A000, 0x00000000,
/**/                   0x3FF11ABD, 0xCAAAE6D5,
/**/                   0x3FCBA424, 0x93CF9B23,
/**/                   0x3FD29D7B, 0x86106AD4,
/**/                   0x3FCD54CB, 0x5E96870B,
/**/                   0x3FD1DE4D, 0x9975D46D,
/**/                   0x3FD3C46E, 0xA709F8A4,
/**/                   0xBC9CB630, 0x457B6F5C,
/**/                   0x3FD71FFA, 0x3CC87FC8,
/**/                   0x3FF10000, 0x00000000,
/**/                   0x3F7ABDCA, 0xAAE6D53D,
/**/                   0x3FD6E000, 0x00000000,
/**/                   0x3FF121B4, 0xD8AD589E,
/**/                   0x3FCC1486, 0xDD6A8C89,
/**/                   0x3FD2D8D9, 0x5A283891,
/**/                   0x3FCE09D1, 0xCFB4F5A1,
/**/                   0x3FD256F5, 0xCF594BB6,
/**/                   0x3FD474C7, 0x92614C29,
/**/                   0xBC88FB31, 0x533051E9,
/**/                   0x3FD76473, 0x18B1AD28,
/**/                   0x3FF14000, 0x00000000,
/**/                   0xBF7E4B27, 0x52A761D6,
/**/                   0x3FD72000, 0x00000000,
/**/                   0x3FF128C8, 0x2C23AB4A,
/**/                   0x3FCC8651, 0xA1A6A356,
/**/                   0x3FD315A5, 0xFF99ABE3,
/**/                   0x3FCEC3A3, 0xBE8EE4C2,
/**/                   0x3FD2D3D5, 0x11207D5D,
/**/                   0x3FD52C2B, 0x02FE6DF8,
/**/                   0xBCA3F304, 0xFE4D8DF3,
/**/                   0x3FD7A908, 0x093FC1F0,
/**/                   0x3FF14000, 0x00000000,
/**/                   0xBF7737D3, 0xDC54B622,
/**/                   0x3FD76000, 0x00000000,
/**/                   0x3FF12FF8, 0x20420F33,
/**/                   0x3FCCF98D, 0x96860D89,
/**/                   0x3FD353EB, 0x3814F292,
/**/                   0x3FCF826C, 0x27E81BF7,
/**/                   0x3FD35516, 0x9A827352,
/**/                   0x3FD5EAED, 0xE614C6DF,
/**/                   0x3C80AEDB, 0x36C1700C,
/**/                   0x3FD7EDB9, 0x803E3C28,
/**/                   0x3FF14000, 0x00000000,
/**/                   0xBF7007DF, 0xBDF0CCC6,
/**/                   0x3FD7A000, 0x00000000,
/**/                   0x3FF13745, 0x12719C3A,
/**/                   0x3FCD6E43, 0xAD9A717F,
/**/                   0x3FD393B3, 0x1CFACD12,
/**/                   0x3FD0232B, 0xE17B8F05,
/**/                   0x3FD3DAE7, 0xB23873BC,
/**/                   0x3FD6B169, 0xAFB712E5,
/**/                   0x3C994C0C, 0x0BC74599,
/**/                   0x3FD83287, 0xF0E9CF80,
/**/                   0x3FF14000, 0x00000000,
/**/                   0xBF6175DB, 0x1CC78CA5,
/**/                   0x3FD7E000, 0x00000000,
/**/                   0x3FF13EAF, 0x625F7844,
/**/                   0x3FCDE47D, 0x161D9978,
/**/                   0x3FD3D508, 0x22E63DCA,
/**/                   0x3FD087CA, 0x8B2EC7EB,
/**/                   0x3FD46577, 0xC5F619C8,
/**/                   0x3FD77FFC, 0xA08A73DE,
/**/                   0x3CA1DBDE, 0x6E7B547F,
/**/                   0x3FD87773, 0xCFF956F8,
/**/                   0x3FF14000, 0x00000000,
/**/                   0xBF3509DA, 0x087BC752,
/**/                   0x3FD82000, 0x00000000,
/**/                   0x3FF14637, 0x720C869D,
/**/                   0x3FCE5C43, 0x3F1FD940,
/**/                   0x3FD417F5, 0x1D614654,
/**/                   0x3FD0EF2A, 0x472052ED,
/**/                   0x3FD4F4F8, 0x88116DA6,
/**/                   0x3FD8570A, 0x102117B6,
/**/                   0xBCAB6E89, 0x214A7328,
/**/                   0x3FD8BC7D, 0x93A70458,
/**/                   0x3FF14000, 0x00000000,
/**/                   0x3F58DDC8, 0x321A7479,
/**/                   0x3FD86000, 0x00000000,
/**/                   0x3FF14DDD, 0xA5DDA5C4,
/**/                   0x3FCED59F, 0xD9CD3739,
/**/                   0x3FD45C85, 0x42C70412,
/**/                   0x3FD15964, 0x49C983A8,
/**/                   0x3FD5899E, 0x0EF7ED0B,
/**/                   0x3FD936FA, 0xBC543499,
/**/                   0x3CAFF50D, 0x7B29F22E,
/**/                   0x3FD901A5, 0xB3B9CF50,
/**/                   0x3FF14000, 0x00000000,
/**/                   0x3F6BBB4B, 0xBB4B87E0,
/**/                   0x3FD8A000, 0x00000000,
/**/                   0x3FF155A2, 0x64AC8172,
/**/                   0x3FCF509C, 0xDBCA7047,
/**/                   0x3FD4A2C4, 0x3055A16F,
/**/                   0x3FD1C692, 0xD25160C7,
/**/                   0x3FD6239E, 0xF68F9906,
/**/                   0x3FDA203D, 0x1DFC2EE2,
/**/                   0x3CAD2019, 0x671EF39F,
/**/                   0x3FD946EC, 0xA98F2718,
/**/                   0x3FF14000, 0x00000000,
/**/                   0x3F75A264, 0xAC8171A9,
/**/                   0x3FD8E000, 0x00000000,
/**/                   0x3FF15D86, 0x17D8FF02,
/**/                   0x3FCFCD44, 0x81AAFD5E,
/**/                   0x3FD4EABD, 0xEE72B776,
/**/                   0x3FD236D1, 0x377F943F,
/**/                   0x3FD6C334, 0x83A56DB7,
/**/                   0x3FDB1345, 0xC36D6C50,
/**/                   0xBC7841E5, 0x761537BB,
/**/                   0x3FD98C52, 0xF024E808,
/**/                   0x3FF14000, 0x00000000,
/**/                   0x3F7D8617, 0xD8FF01DE,
/**/                   0x3FD92000, 0x00000000,
/**/                   0x3FF16589, 0x2B5B4A9A,
/**/                   0x3FD025D0, 0xA8C0A8C6,
/**/                   0x3FD5347E, 0xF524E4B6,
/**/                   0x3FD2AA3B, 0xF565EDBD,
/**/                   0x3FD7689A, 0xC98D2842,
/**/                   0x3FDC108F, 0xB128B4DD,
/**/                   0xBC8A5EEB, 0x4452A669,
/**/                   0x3FD9D1D9, 0x04239878,
/**/                   0x3FF18000, 0x00000000,
/**/                   0xBF7A76D4, 0xA4B56661,
/**/                   0x3FD96000, 0x00000000,
/**/                   0x3FF16DAC, 0x0DD68BC8,
/**/                   0x3FD065DF, 0x0EC54C3A,
/**/                   0x3FD58014, 0x30C58A12,
/**/                   0x3FD320F0, 0xBBCBCCEF,
/**/                   0x3FD81410, 0xD218F380,
/**/                   0x3FDD189C, 0xC9371D29,
/**/                   0x3C58C3C1, 0x1D6E6EC7,
/**/                   0x3FDA177F, 0x63E8EF18,
/**/                   0x3FF18000, 0x00000000,
/**/                   0xBF7253F2, 0x29743866,
/**/                   0x3FD9A000, 0x00000000,
/**/                   0x3FF175EF, 0x30AC48A8,
/**/                   0x3FD0A6D3, 0x037BA7C0,
/**/                   0x3FD5CD8B, 0x06EDCD18,
/**/                   0x3FD39B0E, 0x7D679188,
/**/                   0x3FD8C5D8, 0xC8128143,
/**/                   0x3FDE2BF6, 0x39B3613A,
/**/                   0xBC874080, 0xC70C9C76,
/**/                   0x3FDA5D46, 0x8F92A560,
/**/                   0x3FF18000, 0x00000000,
/**/                   0xBF64219E, 0xA76EB06E,
/**/                   0x3FD9E000, 0x00000000,
/**/                   0x3FF17E53, 0x08107EEF,
/**/                   0x3FD0E8B2, 0x40691386,
/**/                   0x3FD61CF1, 0x5BA2319A,
/**/                   0x3FD418B5, 0x7FF30656,
/**/                   0x3FD97E38, 0x24624146,
/**/                   0x3FDF4B2C, 0xF30D6589,
/**/                   0xBC8D4AD9, 0x74DD0C9B,
/**/                   0x3FDAA32F, 0x090998F8,
/**/                   0x3FF18000, 0x00000000,
/**/                   0xBF3ACF7E, 0xF81116BC,
/**/                   0x3FDA2000, 0x00000000,
/**/                   0x3FF186D8, 0x0B1E7A9D,
/**/                   0x3FD12B82, 0xA98356F0,
/**/                   0x3FD66E55, 0x96C051D8,
/**/                   0x3FD49A07, 0x6D28A49D,
/**/                   0x3FDA3D77, 0xDE14D616,
/**/                   0x3FE03B6D, 0x13502F53,
/**/                   0x3CA51700, 0x4AD59707,
/**/                   0x3FDAE939, 0x540D3F08,
/**/                   0x3FF18000, 0x00000000,
/**/                   0x3F5B602C, 0x79EA752F,
/**/                   0x3FDA6000, 0x00000000,
/**/                   0x3FF18F7E, 0xB3EE7285,
/**/                   0x3FD16F4A, 0x4EC4AF40,
/**/                   0x3FD6C1C6, 0xA9B275FD,
/**/                   0x3FD51F27, 0x64B886B9,
/**/                   0x3FDB03E4, 0x9D72A144,
/**/                   0x3FE0D7CF, 0xE7207DD5,
/**/                   0xBCAACE1E, 0x8E77D1B2,
/**/                   0x3FDB2F65, 0xF63F6C78,
/**/                   0x3FF18000, 0x00000000,
/**/                   0x3F6EFD67, 0xDCE509F5,
/**/                   0x3FDAA000, 0x00000000,
/**/                   0x3FF19847, 0x7FABF325,
/**/                   0x3FD1B40F, 0x6DD15EDB,
/**/                   0x3FD71754, 0x156D090D,
/**/                   0x3FD5A83A, 0x0F44EE42,
/**/                   0x3FDBD1CE, 0xF26149CC,
/**/                   0x3FE17B14, 0x9EBB7D53,
/**/                   0x3CA18867, 0x054C177A,
/**/                   0x3FDB75B5, 0x773075F8,
/**/                   0x3FF18000, 0x00000000,
/**/                   0x3F78477F, 0xABF3257B,
/**/                   0x3FDAE000, 0x00000000,
/**/                   0x3FF1A132, 0xEEAD20E6,
/**/                   0x3FD1F9D8, 0x73AFA8F4,
/**/                   0x3FD76F0D, 0xF0BA2B44,
/**/                   0x3FD63565, 0xB2776412,
/**/                   0x3FDCA78B, 0x8E4B8181,
/**/                   0x3FE22595, 0xDE92725A,
/**/                   0xBCABDA45, 0x225EE470,
/**/                   0x3FDBBC28, 0x606BABE0,
/**/                   0x3FF1C000, 0x00000000,
/**/                   0xBF7ECD11, 0x52DF1A7E,
/**/                   0x3FDB2000, 0x00000000,
/**/                   0x3FF1AA41, 0x848ADB16,
/**/                   0x3FD240AB, 0xFE932ABB,
/**/                   0x3FD7C904, 0xEED7E85D,
/**/                   0x3FD6C6D2, 0x4640B1B3,
/**/                   0x3FDD8573, 0x81D01020,
/**/                   0x3FE2D7B3, 0x9938B939,
/**/                   0x3CA12ECB, 0x36D76E02,
/**/                   0x3FDC02BF, 0x3D843430,
/**/                   0x3FF1C000, 0x00000000,
/**/                   0xBF75BE7B, 0x7524EA70,
/**/                   0x3FDB6000, 0x00000000,
/**/                   0x3FF1B373, 0xC839C9AC,
/**/                   0x3FD28890, 0xDFBC912D,
/**/                   0x3FD8254A, 0x666DE3CA,
/**/                   0x3FD75CA9, 0x8B57457C,
/**/                   0x3FDE6BE4, 0x7E7E55FE,
/**/                   0x3FE391D3, 0x68EC3777,
/**/                   0xBC9F7EFE, 0x4D8A80A5,
/**/                   0x3FDC497A, 0x9C2247A0,
/**/                   0x3FF1C000, 0x00000000,
/**/                   0xBF69186F, 0x8C6CA8A7,
/**/                   0x3FDBA000, 0x00000000,
/**/                   0x3FF1BCCA, 0x44246029,
/**/                   0x3FD2D18E, 0x1D6EB966,
/**/                   0x3FD883F0, 0x58DF9E20,
/**/                   0x3FD7F717, 0x2308FF84,
/**/                   0x3FDF5B41, 0x1CEC1692,
/**/                   0x3FE45460, 0xEFAE7F7E,
/**/                   0xBCACA88A, 0xC247C281,
/**/                   0x3FDC905B, 0x0C10D428,
/**/                   0x3FF1C000, 0x00000000,
/**/                   0xBF49ADDE, 0xDCFEB6F6,
/**/                   0x3FDBE000, 0x00000000,
/**/                   0x3FF1C645, 0x8645E0A6,
/**/                   0x3FD31BAA, 0xF4FA598C,
/**/                   0x3FD8E509, 0x7A00CDBD,
/**/                   0x3FD89648, 0xA876EFA4,
/**/                   0x3FE029F8, 0x93BB3BA0,
/**/                   0x3FE51FCE, 0x3E769492,
/**/                   0xBC63BD0A, 0xDAC78BA6,
/**/                   0x3FDCD761, 0x1F4B8A08,
/**/                   0x3FF1C000, 0x00000000,
/**/                   0x3F591619, 0x178298DB,
/**/                   0x3FDC2000, 0x00000000,
/**/                   0x3FF1CFE6, 0x20466A93,
/**/                   0x3FD366EE, 0xDCE16113,
/**/                   0x3FD948A9, 0x3831A262,
/**/                   0x3FD93A6D, 0xCB5336B7,
/**/                   0x3FE0AB30, 0xF50362A5,
/**/                   0x3FE5F494, 0x440F45E4,
/**/                   0xBCA1B23F, 0x79A811B8,
/**/                   0x3FDD1E8D, 0x6A0D56C8,
/**/                   0x3FF1C000, 0x00000000,
/**/                   0x3F6FCC40, 0x8CD52690,
/**/                   0x3FDC6000, 0x00000000,
/**/                   0x3FF1D9AC, 0xA798215A,
/**/                   0x3FD3B361, 0x87135170,
/**/                   0x3FD9AEE3, 0xC4E92F90,
/**/                   0x3FD9E3B8, 0x6C3B0A06,
/**/                   0x3FE13183, 0x439D6983,
/**/                   0x3FE6D333, 0x444347EE,
/**/                   0x3C9E6687, 0x141D7ADE,
/**/                   0x3FDD65E0, 0x82DF5278,
/**/                   0x3FF1C000, 0x00000000,
/**/                   0x3F79ACA7, 0x98215A4D,
/**/                   0x3FDCA000, 0x00000000,
/**/                   0x3FF1E399, 0xB59577B1,
/**/                   0x3FD4010A, 0xE343E389,
/**/                   0x3FDA17CE, 0x1DB4A57B,
/**/                   0x3FDA925C, 0xBAC8CA27,
/**/                   0x3FE1BD2C, 0x29AC5009,
/**/                   0x3FE7BC33, 0x5806ABBE,
/**/                   0x3C89743A, 0xD953CBEA,
/**/                   0x3FDDAD5B, 0x02A82420,
/**/                   0x3FF20000, 0x00000000,
/**/                   0xBF7C664A, 0x6A884EAF,
/**/                   0x3FDCE000, 0x00000000,
/**/                   0x3FF1EDAD, 0xE7A0AD1E,
/**/                   0x3FD44FF3, 0x215D62D8,
/**/                   0x3FDA837E, 0x15B2742E,
/**/                   0x3FDB4691, 0x557C3A62,
/**/                   0x3FE24E6B, 0x9ABECCA0,
/**/                   0x3FE8B024, 0xF75D3619,
/**/                   0xBC60A42B, 0x953C1F21,
/**/                   0x3FDDF4FD, 0x84BBE168,
/**/                   0x3FF20000, 0x00000000,
/**/                   0xBF725218, 0x5F52E269,
/**/                   0x3FDD2000, 0x00000000,
/**/                   0x3FF1F7E9, 0xDF448BE1,
/**/                   0x3FD4A022, 0xB4103D45,
/**/                   0x3FDAF20A, 0x5F90F152,
/**/                   0x3FDC008F, 0x6B992E26,
/**/                   0x3FE2E585, 0x07C18F30,
/**/                   0x3FE9AFA1, 0x8DCE89C2,
/**/                   0xBC8B90A5, 0xE5B4E0DD,
/**/                   0x3FDE3CC8, 0xA6EC6EF0,
/**/                   0x3FF20000, 0x00000000,
/**/                   0xBF602C41, 0x76E83DEE,
/**/                   0x3FDD6000, 0x00000000,
/**/                   0x3FF2024E, 0x42567651,
/**/                   0x3FD4F1A2, 0x53815E48,
/**/                   0x3FDB638A, 0x98189F26,
/**/                   0x3FDCC092, 0xE11F7BB9,
/**/                   0x3FE382BF, 0x968E1C3C,
/**/                   0x3FEABB4C, 0x1A4C4551,
/**/                   0xBCAC384D, 0xC65EE1E9,
/**/                   0x3FDE84BD, 0x099A6620,
/**/                   0x3FF20000, 0x00000000,
/**/                   0x3F427212, 0xB3B2877E,
/**/                   0x3FDDA000, 0x00000000,
/**/                   0x3FF20CDB, 0xBB19D366,
/**/                   0x3FD5447B, 0x00190520,
/**/                   0x3FDBD817, 0x514AC3D7,
/**/                   0x3FDD86DA, 0x7501B24E,
/**/                   0x3FE42666, 0x5D5DCC91,
/**/                   0x3FEBD3D1, 0xDB834BBA,
/**/                   0xBCA62892, 0x64307FE4,
/**/                   0x3FDECCDB, 0x4FC685E0,
/**/                   0x3FF20000, 0x00000000,
/**/                   0x3F69B776, 0x33A6CD00,
/**/                   0x3FDDE000, 0x00000000,
/**/                   0x3FF21792, 0xF864EB38,
/**/                   0x3FD598B6, 0x0573E0CA,
/**/                   0x3FDC4FCA, 0x1E1D9C05,
/**/                   0x3FDE53A7, 0xE9C2FB44,
/**/                   0x3FE4D0C8, 0xA26E99AF,
/**/                   0x3FECF9EB, 0x09A8A359,
/**/                   0xBCADF861, 0xD9AFA9E0,
/**/                   0x3FDF1524, 0x1F23B3F8,
/**/                   0x3FF20000, 0x00000000,
/**/                   0x3F7792F8, 0x64EB3836,
/**/                   0x3FDE2000, 0x00000000,
/**/                   0x3FF22274, 0xADC744F8,
/**/                   0x3FD5EE5C, 0xFD785957,
/**/                   0x3FDCCABD, 0x9EE01B3A,
/**/                   0x3FDF2740, 0x30A7B7B5,
/**/                   0x3FE5823A, 0x202E0D0D,
/**/                   0x3FEE2E5B, 0x9EEBE829,
/**/                   0xBC93BB42, 0xE2EA9787,
/**/                   0x3FDF5D98, 0x202994B8,
/**/                   0x3FF24000, 0x00000000,
/**/                   0xBF7D8B52, 0x38BB0864,
/**/                   0x3FDE6000, 0x00000000,
/**/                   0x3FF22D81, 0x93B1990A,
/**/                   0x3FD64579, 0xD3920D0F,
/**/                   0x3FDD490D, 0x8E4FE1FE,
/**/                   0x3FE000F5, 0xCBD3ED59,
/**/                   0x3FE63B13, 0x4E45F774,
/**/                   0x3FEF71F4, 0x2FD578CE,
/**/                   0x3CA8AD1C, 0xC0E1AC47,
/**/                   0x3FDFA637, 0xFE27BF60,
/**/                   0x3FF24000, 0x00000000,
/**/                   0xBF727E6C, 0x4E66F5A1,
/**/                   0x3FDEA000, 0x00000000,
/**/                   0x3FF238BA, 0x679F6AE1,
/**/                   0x3FD69E16, 0xC815A8F5,
/**/                   0x3FDDCAD6, 0xCF6CD4C9,
/**/                   0x3FE071FA, 0xFD2ADE38,
/**/                   0x3FE6FBB1, 0xAFEE9630,
/**/                   0x3FF062C9, 0x6A7ACB82,
/**/                   0x3C7E3580, 0x35D3555B,
/**/                   0x3FDFEF04, 0x67599588,
/**/                   0x3FF24000, 0x00000000,
/**/                   0xBF5D1661, 0x82547B6F,
/**/                   0x3FDEE000, 0x00000000,
/**/                   0x3FF2441F, 0xEC425F4B,
/**/                   0x3FD6F83E, 0x73CF67B4,
/**/                   0x3FDE5037, 0x7C1691BA,
/**/                   0x3FE0E6D7, 0x7AF8190E,
/**/                   0x3FE7C478, 0x27F29078,
/**/                   0x3FF11512, 0x13B5FFDC,
/**/                   0x3C6CC7A1, 0x5FEBA301,
/**/                   0x3FE01BFF, 0x067D6224,
/**/                   0x3FF24000, 0x00000000,
/**/                   0x3F507FB1, 0x097D2BDC,
/**/                   0x3FDF2000, 0x00000000,
/**/                   0x3FF24FB2, 0xE9AF6533,
/**/                   0x3FD753FB, 0xCBBEA804,
/**/                   0x3FDED94E, 0xF480E731,
/**/                   0x3FE15FB5, 0x106D90C6,
/**/                   0x3FE895CF, 0x52DAD430,
/**/                   0x3FF1D052, 0x28FAAE13,
/**/                   0xBCA50976, 0xE849F35A,
/**/                   0x3FE04092, 0xD1AE3B48,
/**/                   0x3FF24000, 0x00000000,
/**/                   0x3F6F65D3, 0x5ECA665D,
/**/                   0x3FDF6000, 0x00000000,
/**/                   0x3FF25B74, 0x2D8DC7FA,
/**/                   0x3FD7B15A, 0x25013475,
/**/                   0x3FDF663D, 0xEF8D6387,
/**/                   0x3FE1DCBF, 0xA2DF4BFF,
/**/                   0x3FE97025, 0xE7C2E4E5,
/**/                   0x3FF29510, 0x1C2AE4AB,
/**/                   0x3CA4C8DC, 0xB02A3D13,
/**/                   0x3FE0653D, 0xF0FD9FD8,
/**/                   0x3FF24000, 0x00000000,
/**/                   0x3F7B742D, 0x8DC7FA40,
/**/                   0x3FDFA000, 0x00000000,
/**/                   0x3FF26764, 0x8B4843F2,
/**/                   0x3FD81065, 0x38F10257,
/**/                   0x3FDFF726, 0x8C1920B1,
/**/                   0x3FE25E25, 0x5148D4E4,
/**/                   0x3FEA53F1, 0x2061C3FE,
/**/                   0x3FF363DB, 0x5B9300E5,
/**/                   0xBCA47774, 0x624B8B97,
/**/                   0x3FE08A00, 0xC1CAE338,
/**/                   0x3FF28000, 0x00000000,
/**/                   0xBF789B74, 0xB7BC0E50,
/**/                   0x3FDFE000, 0x00000000,
/**/                   0x3FF27384, 0xDC4036F2,
/**/                   0x3FD87129, 0x29775C8F,
/**/                   0x3FE04616, 0x31A78776,
/**/                   0x3FE2E416, 0x95EE0C65,
/**/                   0x3FEB41AD, 0x28E05161,
/**/                   0x3FF43D4C, 0xFF1DF849,
/**/                   0x3CA5941C, 0xBABBA919,
/**/                   0x3FE0AEDB, 0xA3221C1C,
/**/                   0x3FF28000, 0x00000000,
/**/                   0xBF68F647, 0x7F921C27,
/**/                   0x3FE01000, 0x00000000,
/**/                   0x3FF27FD6, 0x00030888,
/**/                   0x3FD8D3B2, 0x8598A1B5,
/**/                   0x3FE092BA, 0x4E0BC755,
/**/                   0x3FE36EC6, 0x6A428EEC,
/**/                   0x3FEC39C0, 0x44F514C9,
/**/                   0x3FF52205, 0x18C4EF3A,
/**/                   0x4000C1D1, 0xA852F235,
/**/                   0x3CA78082, 0xD00F64B8,
/**/                   0x3FE0D3CE, 0xF5C846F8,
/**/                   0x3FF28000, 0x00000000,
/**/                   0xBF04FFFE, 0x7BBC39DF,
/**/                   0x3FE03000, 0x00000000,
/**/                   0x3FF28C58, 0xDC81E6D7,
/**/                   0x3FD9380E, 0x4E3BF356,
/**/                   0x3FE0E192, 0xFFC646A7,
/**/                   0x3FE3FE6A, 0x6D34756D,
/**/                   0x3FED3CEF, 0x139ABC91,
/**/                   0x3FF612B8, 0xF80111C0,
/**/                   0x4001A33C, 0x3467C688,
/**/                   0xBC8A9954, 0x34F59445,
/**/                   0x3FE0F8DB, 0x1C47D550,
/**/                   0x3FF28000, 0x00000000,
/**/                   0x3F68B1B9, 0x03CDAE3F,
/**/                   0x3FE05000, 0x00000000,
/**/                   0x3FF2990E, 0x5E4BF713,
/**/                   0x3FD99E49, 0xFB326E9E,
/**/                   0x3FE132B4, 0x8779391A,
/**/                   0x3FE4933B, 0x0C2FE325,
/**/                   0x3FEE4BB1, 0xAEAAE1D0,
/**/                   0x3FF71020, 0x1F4377BD,
/**/                   0x40029271, 0x1C886605,
/**/                   0xBCA33AB1, 0x7130CE99,
/**/                   0x3FE11E00, 0x7AFDAF10,
/**/                   0x3FF28000, 0x00000000,
/**/                   0x3F790E5E, 0x4BF712C7,
/**/                   0x3FE07000, 0x00000000,
/**/                   0x3FF2A5F7, 0x78CB1A3B,
/**/                   0x3FDA0673, 0x8081C5D1,
/**/                   0x3FE18634, 0x0D5E6499,
/**/                   0x3FE52D73, 0xAEDD6BE6,
/**/                   0x3FEF66A5, 0x1CF1AAA0,
/**/                   0x3FF81B02, 0x4834E5A9,
/**/                   0x40039066, 0xFCE48906,
/**/                   0xBCA34E4F, 0x6BFB4C85,
/**/                   0x3FE1433F, 0x7826AAD4,
/**/                   0x3FF2C000, 0x00000000,
/**/                   0xBF7A0887, 0x34E5C574,
/**/                   0x3FE09000, 0x00000000,
/**/                   0x3FF2B315, 0x268368DB,
/**/                   0x3FDA7099, 0x53F655B7,
/**/                   0x3FE1DC27, 0xAD9032EC,
/**/                   0x3FE5CD52, 0xE5F88E23,
/**/                   0x3FF04738, 0x0A68BDFC,
/**/                   0x3FF93435, 0x2F057820,
/**/                   0x40049E27, 0xDAE8A2FC,
/**/                   0x3C86832C, 0xFAA44565,
/**/                   0x3FE16898, 0x7BED8260,
/**/                   0x3FF2C000, 0x00000000,
/**/                   0xBF69D5B2, 0xF92E4A41,
/**/                   0x3FE0B000, 0x00000000,
/**/                   0x3FF2C068, 0x69558A9E,
/**/                   0x3FDADCCA, 0x73011B64,
/**/                   0x3FE234A6, 0x8511146A,
/**/                   0x3FE6731A, 0x9D6CBF3C,
/**/                   0x3FF0E1E1, 0xD575F00A,
/**/                   0x3FFA5C9D, 0xADEA17E7,
/**/                   0x4005BCD2, 0xD9123E7C,
/**/                   0xBCA23E4F, 0xCC2AE1E4,
/**/                   0x3FE18E0B, 0xF07948F0,
/**/                   0x3FF2C000, 0x00000000,
/**/                   0x3F1A1A55, 0x62A7614A,
/**/                   0x3FE0D000, 0x00000000,
/**/                   0x3FF2CDF2, 0x4AC410C6,
/**/                   0x3FDB4B16, 0x68E63D97,
/**/                   0x3FE28FC8, 0xBFA256B2,
/**/                   0x3FE71F10, 0x51FDF05A,
/**/                   0x3FF183AE, 0x0753C882,
/**/                   0x3FFB9530, 0xF1921090,
/**/                   0x4006ED9E, 0x14F942BC,
/**/                   0x3CA27879, 0x89C77FA3,
/**/                   0x3FE1B39A, 0x41FC691C,
/**/                   0x3FF2C000, 0x00000000,
/**/                   0x3F6BE495, 0x88218CD6,
/**/                   0x3FE0F000, 0x00000000,
/**/                   0x3FF2DBB3, 0xDC3BFD25,
/**/                   0x3FDBBB8D, 0x55413207,
/**/                   0x3FE2EDA7, 0xA6792BF1,
/**/                   0x3FE7D17D, 0x4AC4E230,
/**/                   0x3FF22D00, 0xAAE6CB05,
/**/                   0x3FFCDEF5, 0xC9028E71,
/**/                   0x400831D8, 0xB40C626C,
/**/                   0x3C953FEF, 0x9873F484,
/**/                   0x3FE1D943, 0xDEC430C0,
/**/                   0x3FF2C000, 0x00000000,
/**/                   0x3F7BB3DC, 0x3BFD24A1,
/**/                   0x3FE11000, 0x00000000,
/**/                   0x3FF2E9AE, 0x3760A19B,
/**/                   0x3FDC2E3F, 0xF2E3E2EB,
/**/                   0x3FE34E5D, 0xAFE1CD38,
/**/                   0x3FE88AAE, 0xD6CE0B26,
/**/                   0x3FF2DE44, 0x2C4B06C6,
/**/                   0x3FFE3B06, 0x138813D2,
/**/                   0x40098AED, 0x23FD5612,
/**/                   0xBC91EC19, 0xB7AF0E54,
/**/                   0x3FE1FF09, 0x3748F114,
/**/                   0x3FF30000, 0x00000000,
/**/                   0xBF7651C8, 0x9F5E657E,
/**/                   0x3FE13000, 0x00000000,
/**/                   0x3FF2F7E2, 0x7E5B072B,
/**/                   0x3FDCA33F, 0x9F169C4D,
/**/                   0x3FE3B206, 0x8FE1EB56,
/**/                   0x3FE94AF6, 0x8F30E1B7,
/**/                   0x3FF397E9, 0xCFCF9887,
/**/                   0x3FFFAA90, 0x4FB7F25F,
/**/                   0x400AFA63, 0x94745D90,
/**/                   0x3C96955C, 0x2A139390,
/**/                   0x3FE224EA, 0xBE3EBA20,
/**/                   0x3FF30000, 0x00000000,
/**/                   0xBF603B03, 0x49F1AA85,
/**/                   0x3FE15000, 0x00000000,
/**/                   0x3FF30651, 0xDC2D0E76,
/**/                   0x3FDD1A9E, 0x613EF408,
/**/                   0x3FE418BF, 0x49ED083D,
/**/                   0x3FEA12AA, 0x9DFD1E23,
/**/                   0x3FF45A6A, 0x32B75F76,
/**/                   0x4000976C, 0xA7673F47,
/**/                   0x400C81E4, 0xB046AC6A,
/**/                   0x3C879FF7, 0x7D1BEB80,
/**/                   0x3FE24AE8, 0xE8A6B8B0,
/**/                   0x3FF30000, 0x00000000,
/**/                   0x3F594770, 0xB439D90E,
/**/                   0x3FE17000, 0x00000000,
/**/                   0x3FF314FD, 0x85087ECD,
/**/                   0x3FDD946E, 0xF2F45390,
/**/                   0x3FE482A6, 0x43BEDA05,
/**/                   0x3FEAE226, 0x0A640DD7,
/**/                   0x3FF52645, 0xD6A3D695,
/**/                   0x4001649F, 0x08098FE0,
/**/                   0x400E233C, 0x9D2BADE7,
/**/                   0x3C9E948C, 0x4E5F8348,
/**/                   0x3FE27104, 0x2DE13E58,
/**/                   0x3FF30000, 0x00000000,
/**/                   0x3F74FD85, 0x087ECD1A,
/**/                   0x3FE19000, 0x00000000,
/**/                   0x3FF323E6, 0xB6AA3C67,
/**/                   0x3FDE10C4, 0xC8894828,
/**/                   0x3FE4EFDB, 0x59718389,
/**/                   0x3FEBB9C9, 0x0A8D7622,
/**/                   0x3FF5FC05, 0xB8A62B12,
/**/                   0x40023D9A, 0xE4296831,
/**/                   0x400FE05E, 0x49C0B830,
/**/                   0x3CA19107, 0xC1189DE8,
/**/                   0x3FE2973D, 0x07C07BCC,
/**/                   0x3FF34000, 0x00000000,
/**/                   0xBF7C1949, 0x55C3993D,
/**/                   0x3FE1B000, 0x00000000,
/**/                   0x3FF3330E, 0xB8B9E20B,
/**/                   0x3FDE8FB4, 0x1A11468B,
/**/                   0x3FE5607F, 0xF2E740E1,
/**/                   0x3FEC99F9, 0x5B91DB14,
/**/                   0x3FF6DC3B, 0xF50C5FAA,
/**/                   0x4003232A, 0x0CFAC1C7,
/**/                   0x4010DDB3, 0x894EFD30,
/**/                   0xBCA7760F, 0x3783D916,
/**/                   0x3FE2BD93, 0xF29BF5F0,
/**/                   0x3FF34000, 0x00000000,
/**/                   0xBF69E28E, 0x8C3BEA7F,
/**/                   0x3FE1D000, 0x00000000,
/**/                   0x3FF34276, 0xDD2DFE6D,
/**/                   0x3FDF1151, 0xECEB226B,
/**/                   0x3FE5D4B7, 0x1AA123CE,
/**/                   0x3FED8322, 0xA01F65F8,
/**/                   0x3FF7C784, 0x791CE583,
/**/                   0x40041625, 0xC15A6B9C,
/**/                   0x4011DB51, 0x64280FEB,
/**/                   0x3CA10463, 0x28CA6DBB,
/**/                   0x3FE2E409, 0x6D64BEAC,
/**/                   0x3FF34000, 0x00000000,
/**/                   0x3F43B6E9, 0x6FF364E1,
/**/                   0x3FE1F000, 0x00000000,
/**/                   0x3FF35220, 0x80B539C7,
/**/                   0x3FDF95B4, 0x1DD91A82,
/**/                   0x3FE64CA5, 0x961EA9CA,
/**/                   0x3FEE75B6, 0xC65B3B2F,
/**/                   0x3FF8BE85, 0xC412E59F,
/**/                   0x40051778, 0x02462A51,
/**/                   0x4012EA48, 0x109FC81B,
/**/                   0x3C959E4C, 0x9F70CA98,
/**/                   0x3FE30A9D, 0xF9BA7B3C,
/**/                   0x3FF34000, 0x00000000,
/**/                   0x3F722080, 0xB539C6A2,
/**/                   0x3FE21000, 0x00000000,
/**/                   0x3FF3620D, 0x0B24ACDA,
/**/                   0x3FE00E78, 0xB5D803B6,
/**/                   0x3FE6C871, 0xFFE457FB,
/**/                   0x3FEF722E, 0x759EF386,
/**/                   0x3FF9C1F1, 0xB8D0E874,
/**/                   0x4006281D, 0x080FB06E,
/**/                   0x40140BF2, 0xD1F69DF7,
/**/                   0xBC8489EA, 0xCBFAF37F,
/**/                   0x3FE33152, 0x1C0141BC,
/**/                   0x3FF38000, 0x00000000,
/**/                   0xBF7DF2F4, 0xDB532667,
/**/                   0x3FE23000, 0x00000000,
/**/                   0x3FF3723D, 0xEFEBB76D,
/**/                   0x3FE05390, 0xC153FC4C,
/**/                   0x3FE74844, 0xE34A2666,
/**/                   0x3FF03C84, 0xC260A400,
/**/                   0x3FFAD286, 0x81E70F01,
/**/                   0x40074924, 0xDBC4A78E,
/**/                   0x401541CB, 0x8BBCA2E0,
/**/                   0x3C9C7528, 0x7BEA8472,
/**/                   0x3FE35826, 0x5B7858F8,
/**/                   0x3FF38000, 0x00000000,
/**/                   0xBF6B8420, 0x28912510,
/**/                   0x3FE25000, 0x00000000,
/**/                   0x3FF382B4, 0xAE8DA9C7,
/**/                   0x3FE09A2E, 0x842CABB9,
/**/                   0x3FE7CC48, 0xDA356141,
/**/                   0x3FF0C567, 0xBCD4FDB8,
/**/                   0x3FFBF10F, 0x89B62C32,
/**/                   0x40087BB5, 0x18ADC4B9,
/**/                   0x40168D6D, 0xC516F6F1,
/**/                   0xBC933A6B, 0x2E37D6A3,
/**/                   0x3FE37F1B, 0x4251E5AC,
/**/                   0x3FF38000, 0x00000000,
/**/                   0x3F45A574, 0x6D4E3A7A,
/**/                   0x3FE27000, 0x00000000,
/**/                   0x3FF39372, 0xD3219A4C,
/**/                   0x3FE0E25E, 0xD4394437,
/**/                   0x3FE854AA, 0xACE4CC74,
/**/                   0x3FF15408, 0x0981EE13,
/**/                   0x3FFD1E66, 0x88AA5332,
/**/                   0x4009C10A, 0xDA3BD18F,
/**/                   0x4017F099, 0xFFE4AE21,
/**/                   0xBCAED56B, 0x7B588ABE,
/**/                   0x3FE3A631, 0x5DCB911C,
/**/                   0x3FF38000, 0x00000000,
/**/                   0x3F7372D3, 0x219A4BA9,
/**/                   0x3FE29000, 0x00000000,
/**/                   0x3FF3A479, 0xF6D8C6BC,
/**/                   0x3FE12C2F, 0x11197A32,
/**/                   0x3FE8E199, 0x73F949D5,
/**/                   0x3FF1E8B1, 0xEE7A481D,
/**/                   0x3FFE5B74, 0xABBE8828,
/**/                   0x400B1A7C, 0xDB3D83BC,
/**/                   0x40196D39, 0x6DC46100,
/**/                   0x3CA7798C, 0xACD8F69C,
/**/                   0x3FE3CD69, 0x3E4835E8,
/**/                   0x3FF3C000, 0x00000000,
/**/                   0xBF7B8609, 0x27394391,
/**/                   0x3FE2B000, 0x00000000,
/**/                   0x3FF3B5CB, 0xC08BE738,
/**/                   0x3FE177AD, 0x2B5CB6B7,
/**/                   0x3FE97346, 0xBCE90EB1,
/**/                   0x3FF283B6, 0x68EC7F04,
/**/                   0x3FFFA933, 0xD5B8ED04,
/**/                   0x400C897D, 0xCBCDFF9A,
/**/                   0x401B0562, 0x0E4ABF55,
/**/                   0x3C881FF6, 0x1EE42043,
/**/                   0x3FE3F4C3, 0x776AA08C,
/**/                   0x3FF3C000, 0x00000000,
/**/                   0xBF64687E, 0xE8319086,
/**/                   0x3FE2D000, 0x00000000,
/**/                   0x3FF3C769, 0xE54FE05E,
/**/                   0x3FE1C4E7, 0xAC1A81A0,
/**/                   0x3FEA09E6, 0xB10FA326,
/**/                   0x3FF3256B, 0x840F679B,
/**/                   0x40008457, 0xFEE9EF1A,
/**/                   0x400E0F9E, 0xE4146343,
/**/                   0x401CBB5B, 0x433496A9,
/**/                   0xBCA57A4C, 0x59F087C0,
/**/                   0x3FE41C40, 0xA03171A8,
/**/                   0x3FF3C000, 0x00000000,
/**/                   0x3F5DA795, 0x3F81773D,
/**/                   0x3FE2F000, 0x00000000,
/**/                   0x3FF3D956, 0x291249DC,
/**/                   0x3FE213ED, 0xBD044AC9,
/**/                   0x3FEAA5B0, 0x3F917FA8,
/**/                   0x3FF3CE2C, 0xB7380A79,
/**/                   0x40013D84, 0x576AFAE8,
/**/                   0x400FAE92, 0xBAAB74F3,
/**/                   0x401E91A2, 0xE9129E4A,
/**/                   0x3C905671, 0x0CEC83F7,
/**/                   0x3FE443E1, 0x53143194,
/**/                   0x3FF3C000, 0x00000000,
/**/                   0x3F795629, 0x1249DBC4,
/**/                   0x3FE31000, 0x00000000,
/**/                   0x3FF3EB92, 0x5F3E4715,
/**/                   0x3FE264CF, 0x30F965D1,
/**/                   0x3FEB46DD, 0x4A4F2FB2,
/**/                   0x3FF47E5B, 0x4BC2E94F,
/**/                   0x400200B9, 0x54F8F9EB,
/**/                   0x4010B418, 0x33305D9F,
/**/                   0x40204579, 0x826EF167,
/**/                   0xBC9737A0, 0xE06EBCAE,
/**/                   0x3FE46BA6, 0x2E21A53C,
/**/                   0x3FF40000, 0x00000000,
/**/                   0xBF746DA0, 0xC1B8EB04,
/**/                   0x3FE33000, 0x00000000,
/**/                   0x3FF3FE20, 0x6B6A38D5,
/**/                   0x3FE2B79C, 0x8D26C7A0,
/**/                   0x3FEBEDAA, 0xD62978F8,
/**/                   0x3FF5365E, 0xCB8CC6D1,
/**/                   0x4002CE9C, 0xD894AF54,
/**/                   0x40119F3B, 0x79F7C63E,
/**/                   0x40215524, 0x0C8E7B9E,
/**/                   0x3CA485D0, 0x13DC9A80,
/**/                   0x3FE4938F, 0xD31F754C,
/**/                   0x3FF40000, 0x00000000,
/**/                   0xBF3DF949, 0x5C72B1E7,
/**/                   0x3FE35000, 0x00000000,
/**/                   0x3FF41102, 0x420ED8E7,
/**/                   0x3FE30C67, 0x12BCE2B2,
/**/                   0x3FEC9A59, 0x3EDE345E,
/**/                   0x3FF5F6A5, 0x78CAB466,
/**/                   0x4003A7E1, 0x3EAD62EE,
/**/                   0x401299C8, 0x9CB9A228,
/**/                   0x40227974, 0x1BE749B0,
/**/                   0x3CAFE28F, 0xC6A9831F,
/**/                   0x3FE4BB9E, 0xE7AB3A40,
/**/                   0x3FF40000, 0x00000000,
/**/                   0x3F710242, 0x0ED8E776,
/**/                   0x3FE37000, 0x00000000,
/**/                   0x3FF42439, 0xE9485B43,
/**/                   0x3FE36340, 0xC946E033,
/**/                   0x3FED4D2C, 0x6ECC5A7E,
/**/                   0x3FF6BFA4, 0xD027255A,
/**/                   0x40048D46, 0x72504BE1,
/**/                   0x4013A4ED, 0x09445BD5,
/**/                   0x4023B435, 0x749E19F9,
/**/                   0xBC40E7E5, 0xEAAAF53E,
/**/                   0x3FE4E3D4, 0x155D0070,
/**/                   0x3FF44000, 0x00000000,
/**/                   0xBF7BC616, 0xB7A4BD36,
/**/                   0x3FE39000, 0x00000000,
/**/                   0x3FF437C9, 0x79A23C23,
/**/                   0x3FE3BC3C, 0x89AF6A9D,
/**/                   0x3FEE066C, 0x1AF553BA,
/**/                   0x3FF791DA, 0x1622569A,
/**/                   0x40057F9B, 0x1B18AE2B,
/**/                   0x4014C1F0, 0x88BFF240,
/**/                   0x40250761, 0x019A4522,
/**/                   0x3CA4C238, 0xFDFCCB13,
/**/                   0x3FE50C30, 0x09EB58F8,
/**/                   0x3FF44000, 0x00000000,
/**/                   0xBF606D0C, 0xBB87B9E1,
/**/                   0x3FE3B000, 0x00000000,
/**/                   0x3FF44BB3, 0x1EEE6F35,
/**/                   0x3FE4176E, 0x0A004D1D,
/**/                   0x3FEEC664, 0x0399FA54,
/**/                   0x3FF86DCA, 0xF0CFD106,
/**/                   0x40067FBD, 0xE8C80E97,
/**/                   0x4015F237, 0xD9CD2D79,
/**/                   0x40267521, 0xC8076345,
/**/                   0x3CAEC756, 0xB089F7AF,
/**/                   0x3FE534B3, 0x77510D94,
/**/                   0x3FF44000, 0x00000000,
/**/                   0x3F67663D, 0xDCDE698F,
/**/                   0x3FE3D000, 0x00000000,
/**/                   0x3FF45FF9, 0x1928B1BE,
/**/                   0x3FE474E9, 0xE9EB53E9,
/**/                   0x3FEF8D64, 0x39DB03B6,
/**/                   0x3FF95406, 0x0F298B87,
/**/                   0x40078E9E, 0xFFC72AB6,
/**/                   0x40173747, 0x941456E7,
/**/                   0x4027FFDA, 0x74A71E71,
/**/                   0xBCAEED93, 0xFE7483B3,
/**/                   0x3FE55D5F, 0x13F48EC0,
/**/                   0x3FF44000, 0x00000000,
/**/                   0x3F7FF919, 0x28B1BDFF,
/**/                   0x3FE3F000, 0x00000000,
/**/                   0x3FF4749D, 0xBD66D0C4,
/**/                   0x3FE4D4C5, 0xC02C2013,
/**/                   0x3FF02DE0, 0xB56768CC,
/**/                   0x3FFA4523, 0xDF53A7BD,
/**/                   0x4008AD41, 0x8A357386,
/**/                   0x401892C7, 0x5E392799,
/**/                   0x4029AA2B, 0x97746ACD,
/**/                   0x3C924F0A, 0xB4A71E44,
/**/                   0x3FE58633, 0x9AD13548,
/**/                   0x3FF48000, 0x00000000,
/**/                   0xBF66C485, 0x325E775E,
/**/                   0x3FE41000, 0x00000000,
/**/                   0x3FF489A3, 0x76D6C491,
/**/                   0x3FE53718, 0x28D40829,
/**/                   0x3FF098EA, 0x98450D83,
/**/                   0x3FFB41C7, 0x55526E3B,
/**/                   0x4009DCBD, 0x719F540E,
/**/                   0x401A0685, 0x805D08D1,
/**/                   0x402B76FA, 0xA5142633,
/**/                   0x3C2AD9A7, 0xF1FF56FC,
/**/                   0x3FE5AF31, 0xCBA27244,
/**/                   0x3FF48000, 0x00000000,
/**/                   0x3F6346ED, 0xAD892100,
/**/                   0x3FE43000, 0x00000000,
/**/                   0x3FF49F0C, 0xC7CB94CC,
/**/                   0x3FE59BF8, 0xD492AA1E,
/**/                   0x3FF107FF, 0x34D2CA82,
/**/                   0x3FFC4A9E, 0xC3DF9E51,
/**/                   0x400B1E41, 0x45F5874E,
/**/                   0x401B947A, 0xDEB92648,
/**/                   0x402D6979, 0xD903D532,
/**/                   0x3CA43231, 0x04C67F5E,
/**/                   0x3FE5D85A, 0x6B1109A4,
/**/                   0x3FF48000, 0x00000000,
/**/                   0x3F7F0CC7, 0xCB94CC1A,
/**/                   0x3FE45000, 0x00000000,
/**/                   0x3FF4B4DC, 0x4ADA0BF0,
/**/                   0x3FE60380, 0x990F861F,
/**/                   0x3FF17B50, 0xCBEC7542,
/**/                   0x3FFD6064, 0xC93CFE8F,
/**/                   0x400C7314, 0x56F36FE3,
/**/                   0x401D3ECF, 0x696E5374,
/**/                   0x402F8531, 0x1778AF1D,
/**/                   0x3C7A53BF, 0x31EBDA84,
/**/                   0x3FE601AE, 0x42E27660,
/**/                   0x3FF4C000, 0x00000000,
/**/                   0xBF66476A, 0x4BE81F81,
/**/                   0x3FE47000, 0x00000000,
/**/                   0x3FF4CB14, 0xB4065600,
/**/                   0x3FE66DC9, 0x826ADA4F,
/**/                   0x3FF1F314, 0xA3298D4D,
/**/                   0x3FFE83E1, 0x52191CB4,
/**/                   0x400DDC99, 0x05CA69AF,
/**/                   0x401F07DF, 0x1079C46A,
/**/                   0x4030E703, 0xF9440EB0,
/**/                   0x3CA495E1, 0x5817D0DD,
/**/                   0x3FE62B2E, 0x222A98A0,
/**/                   0x3FF4C000, 0x00000000,
/**/                   0x3F662968, 0x0CAC00D4,
/**/                   0x3FE49000, 0x00000000,
/**/                   0x3FF4E1B8, 0xD203BDC9,
/**/                   0x3FE6DAEE, 0xE5FE0976,
/**/                   0x3FF26F83, 0x3C44F71E,
/**/                   0x3FFFB5EA, 0xB4D92F91,
/**/                   0x400F5C4F, 0x55A779C8,
/**/                   0x4020791F, 0xA66A7536,
/**/                   0x40322428, 0x7DCE5D75,
/**/                   0x3CADE7E8, 0x964F770B,
/**/                   0x3FE654DA, 0xDD7FD12C,
/**/                   0x3FF50000, 0x00000000,
/**/                   0xBF7E472D, 0xFC42374B,
/**/                   0x3FE4B000, 0x00000000,
/**/                   0x3FF4F8CB, 0x8F87D541,
/**/                   0x3FE74B0D, 0x767620C4,
/**/                   0x3FF2F0D8, 0x9126F083,
/**/                   0x40007BB3, 0x73F08794,
/**/                   0x401079EB, 0xE1419117,
/**/                   0x40218062, 0xA917F81E,
/**/                   0x40337C6B, 0x48444DEE,
/**/                   0x3C907A41, 0xF4061E08,
/**/                   0x3FE67EB5, 0x4F31AF70,
/**/                   0x3FF50000, 0x00000000,
/**/                   0xBF5CD1C1, 0xE0AAFA85,
/**/                   0x3FE4D000, 0x00000000,
/**/                   0x3FF5104F, 0xF4B2718C,
/**/                   0x3FE7BE43, 0x59659939,
/**/                   0x3FF37754, 0x5502EAE6,
/**/                   0x400124A6, 0x6AE0AC51,
/**/                   0x4011527B, 0x33524D17,
/**/                   0x40229B46, 0x7FBF7A2D,
/**/                   0x4034F274, 0xAD716768,
/**/                   0xBC9C610F, 0x7C204EA8,
/**/                   0x3FE6A8BE, 0x57825A6C,
/**/                   0x3FF50000, 0x00000000,
/**/                   0x3F704FF4, 0xB2718C01,
/**/                   0x3FE4F000, 0x00000000,
/**/                   0x3FF52849, 0x288C017D,
/**/                   0x3FE834B0, 0x3E6D3F7F,
/**/                   0x3FF4033A, 0x3B0747CB,
/**/                   0x4001D652, 0xE946B196,
/**/                   0x401238CB, 0x3C2F8CB4,
/**/                   0x4023CB80, 0x53E520C1,
/**/                   0x40368938, 0x607BC0F6,
/**/                   0xBC84274C, 0xCC053597,
/**/                   0x3FE6D2F6, 0xDCE2DFB8,
/**/                   0x3FF54000, 0x00000000,
/**/                   0xBF77B6D7, 0x73FE8364,
/**/                   0x3FE51000, 0x00000000,
/**/                   0x3FF540BA, 0x729BE713,
/**/                   0x3FE8AE75, 0x781F49A2,
/**/                   0x3FF494D2, 0x432AC103,
/**/                   0x40029147, 0x9B0015B6,
/**/                   0x40132DE7, 0x156B74E9,
/**/                   0x402512F0, 0xE8362EC8,
/**/                   0x403843FE, 0xC8D2E0F8,
/**/                   0xBC8F55DB, 0xBB3ACC53,
/**/                   0x3FE6FD5F, 0xCC3296F0,
/**/                   0x3FF54000, 0x00000000,
/**/                   0x3F274E53, 0x7CE2565E,
/**/                   0x3FE53000, 0x00000000,
/**/                   0x3FF559A7, 0x3C98A101,
/**/                   0x3FE92BB6, 0x16C3163D,
/**/                   0x3FF52C69, 0x0DB2C44D,
/**/                   0x4003561E, 0x0F4546B8,
/**/                   0x401432F1, 0x7F099A82,
/**/                   0x402673A9, 0x831E227A,
/**/                   0x403A266F, 0xA02BBCD5,
/**/                   0x3CA279A8, 0xAEA9CB9D,
/**/                   0x3FE727FA, 0x1901CB44,
/**/                   0x3FF54000, 0x00000000,
/**/                   0x3F79A73C, 0x98A10084,
/**/                   0x3FE55000, 0x00000000,
/**/                   0x3FF57313, 0x1433B9BD,
/**/                   0x3FE9AC97, 0x0523E7B2,
/**/                   0x3FF5CA50, 0x361F7393,
/**/                   0x4004257B, 0xB0F40825,
/**/                   0x40154927, 0x46286025,
/**/                   0x4027EFF1, 0x781495B4,
/**/                   0x403C349E, 0x0A1139F1,
/**/                   0xBC5D2C66, 0x8B6015DA,
/**/                   0x3FE752C6, 0xBDD7E0E0,
/**/                   0x3FF58000, 0x00000000,
/**/                   0xBF69D9D7, 0x988C865F,
/**/                   0x3FE57000, 0x00000000,
/**/                   0x3FF58D01, 0xAD039E07,
/**/                   0x3FEA313F, 0x279933CD,
/**/                   0x3FF66EDE, 0xB63D93A6,
/**/                   0x40050012, 0xD836441A,
/**/                   0x401671E1, 0xF23D152C,
/**/                   0x40298A4C, 0x65D3A1DD,
/**/                   0x403E7316, 0x5EBDBF39,
/**/                   0xBCAE5B6C, 0x7AAA4996,
/**/                   0x3FE77DC6, 0xBC7D2FA0,
/**/                   0x3FF58000, 0x00000000,
/**/                   0x3F6A035A, 0x073C0E86,
/**/                   0x3FE59000, 0x00000000,
/**/                   0x3FF5A776, 0xE28DADB6,
/**/                   0x3FEAB9D7, 0x7D7BE2B5,
/**/                   0x3FF71A71, 0x5234C8A9,
/**/                   0x4005E6A3, 0xF873554C,
/**/                   0x4017AE9A, 0xC1F33F9B,
/**/                   0x402B4581, 0x4310046E,
/**/                   0x40407376, 0xF64B03E7,
/**/                   0xBCA3F39B, 0xB3AB0542,
/**/                   0x3FE7A8FB, 0x1E48D158,
/**/                   0x3FF5C000, 0x00000000,
/**/                   0xBF78891D, 0x725249CA,
/**/                   0x3FE5B000, 0x00000000,
/**/                   0x3FF5C276, 0xBA730F9B,
/**/                   0x3FEB468B, 0x454127C3,
/**/                   0x3FF7CD6B, 0x0E816ADB,
/**/                   0x4006D9FE, 0xEDDAC837,
/**/                   0x401900EE, 0x0209E3B7,
/**/                   0x402D24A2, 0x57489C7E,
/**/                   0x4041CAEA, 0x7F810E14,
/**/                   0xBC84F20E, 0x24F9675B,
/**/                   0x3FE7D464, 0xF472A690,
/**/                   0x3FF5C000, 0x00000000,
/**/                   0x3F43B5D3, 0x987CD623,
/**/                   0x3FE5D000, 0x00000000,
/**/                   0x3FF5DE05, 0x66C30CDC,
/**/                   0x3FEBD788, 0x23798D1A,
/**/                   0x3FF88835, 0xB0E567D8,
/**/                   0x4007DB04, 0x6E46660A,
/**/                   0x401A6A9E, 0xCA07CAA5,
/**/                   0x402F2B16, 0x41ECEF64,
/**/                   0x40434315, 0xC36F367B,
/**/                   0xBCA08CA1, 0x542594A6,
/**/                   0x3FE80005, 0x5869D9E8,
/**/                   0x3FF5C000, 0x00000000,
/**/                   0x3F7E0566, 0xC30CDBD9,
/**/                   0x3FE5F000, 0x00000000,
/**/                   0x3FF5FA27, 0x4875FA03,
/**/                   0x3FEC6CFE, 0x4CF96D63,
/**/                   0x3FF94B42, 0x4D7B8313,
/**/                   0x4008EAA7, 0xA1B04592,
/**/                   0x401BED9B, 0x2C5A9D87,
/**/                   0x4030AE51, 0x1BC92F68,
/**/                   0x4044DF8C, 0x685FBD64,
/**/                   0xBCAC07A8, 0x30FE6378,
/**/                   0x3FE82BDD, 0x6C30303C,
/**/                   0x3FF60000, 0x00000000,
/**/                   0xBF5762DE, 0x2817F40C,
/**/                   0x3FE61000, 0x00000000,
/**/                   0x3FF616E0, 0xF213FCD6,
/**/                   0x3FED0720, 0xB47784FF,
/**/                   0x3FFA1709, 0xE13C6707,
/**/                   0x400A09EF, 0xE70B2E72,
/**/                   0x401D8C00, 0xE976AAD9,
/**/                   0x4031DEBA, 0xD1AE1EA8,
/**/                   0x4046A453, 0x6424341F,
/**/                   0x3CA13E53, 0xA65D40B1,
/**/                   0x3FE857EE, 0x5ABA79E8,
/**/                   0x3FF60000, 0x00000000,
/**/                   0x3F76E0F2, 0x13FCD614,
/**/                   0x3FE63000, 0x00000000,
/**/                   0x3FF63437, 0x2A8B4ED8,
/**/                   0x3FEDA625, 0x3BF69915,
/**/                   0x3FFAEC0D, 0xFB6DF86F,
/**/                   0x400B39FA, 0xCAF2D64B,
/**/                   0x401F4822, 0xB7E2DC06,
/**/                   0x4033291B, 0xB12537E3,
/**/                   0x404895F0, 0xAF3EF0D1,
/**/                   0x3CAEA588, 0x71E7ED76,
/**/                   0x3FE88439, 0x5856807C,
/**/                   0x3FF64000, 0x00000000,
/**/                   0xBF6791AA, 0xE9624F1C,
/**/                   0x3FE65000, 0x00000000,
/**/                   0x3FF6522E, 0xF039F5E3,
/**/                   0x3FEE4A44, 0xEA588E54,
/**/                   0x3FFBCAD9, 0x77A3F8A4,
/**/                   0x400C7BFE, 0x3669F2F2,
/**/                   0x40209247, 0x1AEA54A4,
/**/                   0x4034900A, 0x6B866959,
/**/                   0x404AB97D, 0x620634CF,
/**/                   0x3C948649, 0xDA91B0FD,
/**/                   0x3FE8B0BF, 0xA316D3A0,
/**/                   0x3FF64000, 0x00000000,
/**/                   0x3F722EF0, 0x39F5E2AD,
/**/                   0x3FE67000, 0x00000000,
/**/                   0x3FF670CD, 0x7C2F4FC3,
/**/                   0x3FEEF3BC, 0x2583CF60,
/**/                   0x3FFCB401, 0x4A2E1684,
/**/                   0x400DD14A, 0xDCB9F8FB,
/**/                   0x40219209, 0x4E164373,
/**/                   0x40361669, 0x8FC171BC,
/**/                   0x404D14BA, 0xA46B7BE1,
/**/                   0xBCABAC31, 0xBBDFE65A,
/**/                   0x3FE8DD82, 0x8344E08C,
/**/                   0x3FF68000, 0x00000000,
/**/                   0xBF6E6507, 0xA1607A77,
/**/                   0x3FE69000, 0x00000000,
/**/                   0x3FF69018, 0x45AA3C85,
/**/                   0x3FEFA2CA, 0xF18FBD18,
/**/                   0x3FFDA825, 0x610C140E,
/**/                   0x400F3B4E, 0xF08895E1,
/**/                   0x4022A4E4, 0x272CD203,
/**/                   0x4037BF71, 0x60C4A0EE,
/**/                   0x404FAE29, 0xEC79351D,
/**/                   0x3C6BF5BB, 0x3E22FB0A,
/**/                   0x3FE90A83, 0x4BD9C858,
/**/                   0x3FF68000, 0x00000000,
/**/                   0x3F701845, 0xAA3C8533,
/**/                   0x3FE6B000, 0x00000000,
/**/                   0x3FF6B015, 0x05D92E4E,
/**/                   0x3FF02BDA, 0x9ABD20D8,
/**/                   0x3FFEA7F1, 0x9BC5CC13,
/**/                   0x40105DCC, 0x94AFB2BB,
/**/                   0x4023CC8C, 0xB382B54A,
/**/                   0x40398EBB, 0x19C28EAE,
/**/                   0x40514694, 0x8F7609B5,
/**/                   0x3C9CD223, 0xF66137E5,
/**/                   0x3FE937C3, 0x5AFE73AC,
/**/                   0x3FF6C000, 0x00000000,
/**/                   0xBF6FD5F4, 0x4DA36334,
/**/                   0x3FE6D000, 0x00000000,
/**/                   0x3FF6D0C9, 0xBBE1EF2B,
/**/                   0x3FF08961, 0x82FBDD29,
/**/                   0x3FFFB41E, 0xDCD403EC,
/**/                   0x401129EE, 0x121D0023,
/**/                   0x40250AE5, 0xB34159B2,
/**/                   0x403B884D, 0xDB5CEAC4,
/**/                   0x4052DD09, 0xA0B334B0,
/**/                   0xBC96BF1D, 0xD8F14BF9,
/**/                   0x3FE96544, 0x1A936D24,
/**/                   0x3FF6C000, 0x00000000,
/**/                   0x3F70C9BB, 0xE1EF2AEE,
/**/                   0x3FE6F000, 0x00000000,
/**/                   0x3FF6F23C, 0xB13786CF,
/**/                   0x3FF0EA20, 0x7B7FC134,
/**/                   0x400066BA, 0x1BD0D518,
/**/                   0x401202F9, 0x159EC945,
/**/                   0x40266205, 0x16FF868A,
/**/                   0x403DB0AD, 0x87398014,
/**/                   0x40549F33, 0x47D58711,
/**/                   0x3C8D858F, 0x54B11A28,
/**/                   0x3FE99307, 0x00C1184C,
/**/                   0x3FF70000, 0x00000000,
/**/                   0xBF6B869D, 0x90F2626A,
/**/                   0x3FE71000, 0x00000000,
/**/                   0x3FF71474, 0x7E455603,
/**/                   0x3FF14E40, 0x3A65655F,
/**/                   0x4000FA64, 0x1F4AA7A1,
/**/                   0x4012E9F0, 0xB946C70A,
/**/                   0x4027D43A, 0x3CC53936,
/**/                   0x40400675, 0xEE087279,
/**/                   0x40569278, 0x77313CEF,
/**/                   0xBCAB1BA1, 0x772D6E62,
/**/                   0x3FE9C10D, 0x9090E874,
/**/                   0x3FF70000, 0x00000000,
/**/                   0x3F74747E, 0x455602D3,
/**/                   0x3FE73000, 0x00000000,
/**/                   0x3FF73778, 0x0F773DEC,
/**/                   0x3FF1B5EC, 0x1288B243,
/**/                   0x40019581, 0x3A853FA5,
/**/                   0x4013DFF0, 0x6D2743E5,
/**/                   0x40296415, 0x09B4B924,
/**/                   0x4041515E, 0x19A59D1F,
/**/                   0x4058BD01, 0xF3E53877,
/**/                   0x3C962269, 0xFC348BAE,
/**/                   0x3FE9EF59, 0x5A90493C,
/**/                   0x3FF74000, 0x00000000,
/**/                   0xBF610FE1, 0x11842743,
/**/                   0x3FE75000, 0x00000000,
/**/                   0x3FF75B4E, 0xAAA78140,
/**/                   0x3FF22152, 0x28B49576,
/**/                   0x4002388E, 0x74D66746,
/**/                   0x4014E62E, 0xA43083A8,
/**/                   0x402B146E, 0x02885ED7,
/**/                   0x4042BC45, 0x29A3BC2C,
/**/                   0x405B25D8, 0xCDAFE7E5,
/**/                   0x3CA8862D, 0xF03F8A74,
/**/                   0x3FEA1DEB, 0xFD7DFBD8,
/**/                   0x3FF74000, 0x00000000,
/**/                   0x3F7B4EAA, 0xA7813FBA,
/**/                   0x3FE77000, 0x00000000,
/**/                   0x3FF77FFF, 0xF4FC0008,
/**/                   0x3FF290A3, 0xADE499E4,
/**/                   0x4002E412, 0xFF22FE11,
/**/                   0x4015FDFF, 0xD7A17943,
/**/                   0x402CE86F, 0x8AF79AEF,
/**/                   0x40444ACA, 0x6F8EDF86,
/**/                   0x405DD50A, 0x29CF9F92,
/**/                   0x3CA49DB0, 0xC5865233,
/**/                   0x3FEA4CC7, 0x2702BD90,
/**/                   0x3FF78000, 0x00000000,
/**/                   0xBE6607FF, 0xF08268E1,
/**/                   0x3FE79000, 0x00000000,
/**/                   0x3FF7A593, 0xF93D7FBC,
/**/                   0x3FF30415, 0x1F293A81,
/**/                   0x400398A1, 0x31649EA4,
/**/                   0x401728D9, 0xED75DA1E,
/**/                   0x402EE3A0, 0x7B1736CA,
/**/                   0x40460106, 0x036EC9D4,
/**/                   0x406069E8, 0xB3E5A09F,
/**/                   0xBCA79BBD, 0x4E8EB882,
/**/                   0x3FEA7BEC, 0x94762100,
/**/                   0x3FF7C000, 0x00000000,
/**/                   0xBF7A6C06, 0xC280445C,
/**/                   0x3FE7B000, 0x00000000,
/**/                   0x3FF7CC13, 0x2EB4E536,
/**/                   0x3FF37BDE, 0x8BD25D7D,
/**/                   0x400456D7, 0xA51DF797,
/**/                   0x40186858, 0x103AF33E,
/**/                   0x403084F8, 0x21121C2E,
/**/                   0x4047E39A, 0x9D7C6DE3,
/**/                   0x40621664, 0xEF4C9A12,
/**/                   0x3C804D2D, 0x39DB72FF,
/**/                   0x3FEAAB5E, 0x13B099B0,
/**/                   0x3FF7C000, 0x00000000,
/**/                   0x3F68265D, 0x69CA6C2F,
/**/                   0x3FE7D000, 0x00000000,
/**/                   0x3FF7F386, 0x809BA1CD,
/**/                   0x3FF3F83B, 0xE298B2EB,
/**/                   0x40051F62, 0x708A6ABE,
/**/                   0x4019BE3F, 0x090F77AB,
/**/                   0x4031AFE2, 0x6C13BF38,
/**/                   0x4049F7CA, 0x65FF02A8,
/**/                   0x4063F614, 0xDA840FE0,
/**/                   0xBCA7BDE9, 0xAB5D1A54,
/**/                   0x3FEADB1D, 0x83EBD320,
/**/                   0x3FF80000, 0x00000000,
/**/                   0xBF68F2FE, 0xC8BC6562,
/**/                   0x3FE7F000, 0x00000000,
/**/                   0x3FF81BF7, 0x562E1E24,
/**/                   0x3FF4796D, 0x469724DB,
/**/                   0x4005F2FC, 0x86E67917,
/**/                   0x401B2C82, 0x2F5AE582,
/**/                   0x4032F505, 0x65EE1919,
/**/                   0x404C438F, 0x4744D220,
/**/                   0x40661003, 0xD66309FD,
/**/                   0x3C8470C8, 0xFC828894,
/**/                   0x3FEB0B2C, 0xD6B287DC,
/**/                   0x3FF80000, 0x00000000,
/**/                   0x3F7BF756, 0x2E1E23E5,
/**/                   0x3FE81000, 0x00000000,
/**/                   0x3FF8456F, 0x9B70AB1D,
/**/                   0x3FF4FFB7, 0x6D01A674,
/**/                   0x4006D271, 0x42D7B667,
/**/                   0x401CB549, 0x05DD4055,
/**/                   0x40345723, 0xE490CA9B,
/**/                   0x404ECD17, 0x47C5589B,
/**/                   0x40686C46, 0x3D6DB036,
/**/                   0x4084044D, 0xECF23C2E,
/**/                   0xBC7F0990, 0x0D173A5F,
/**/                   0x3FEB3B8E, 0x10E12D3C,
/**/                   0x3FF84000, 0x00000000,
/**/                   0x3F55BE6D, 0xC2AC733C,
/**/                   0x3FE83000, 0x00000000,
/**/                   0x3FF86FF9, 0xCAB97B9D,
/**/                   0x3FF58B64, 0x04A71B42,
/**/                   0x4007BE9E, 0x20C0FB6E,
/**/                   0x401E5AF5, 0x9B426297,
/**/                   0x4035D958, 0x013C40EE,
/**/                   0x4050CEA9, 0x2215E48C,
/**/                   0x406B146B, 0xB8C0669A,
/**/                   0x40868C96, 0xFB8EB0FE,
/**/                   0x3CA55848, 0x1FCCBAD4,
/**/                   0x3FEB6C43, 0x4BB8EA98,
/**/                   0x3FF88000, 0x00000000,
/**/                   0xBF700635, 0x46846319,
/**/                   0x3FE85000, 0x00000000,
/**/                   0x3FF89BA0, 0xF71469BF,
/**/                   0x3FF61CC2, 0x28717EFA,
/**/                   0x4008B874, 0xAFB7BAF7,
/**/                   0x40201015, 0xEC7286DB,
/**/                   0x40377F1F, 0x8329A469,
/**/                   0x40525E49, 0x2927F0DD,
/**/                   0x406E135C, 0x5AE80CD9,
/**/                   0x40897364, 0x40DF64FD,
/**/                   0x3C89F53B, 0x1ED91B03,
/**/                   0x3FEB9D4E, 0xB6067ABC,
/**/                   0x3FF88000, 0x00000000,
/**/                   0x3F7BA0F7, 0x1469BF33,
/**/                   0x3FE87000, 0x00000000,
/**/                   0x3FF8C870, 0xD797DABF,
/**/                   0x3FF6B426, 0xDE42D55F,
/**/                   0x4009C0FC, 0xC0E06552,
/**/                   0x402103EC, 0xEB059907,
/**/                   0x40394C6A, 0x49A75AA7,
/**/                   0x40541A81, 0xB2A496D0,
/**/                   0x4070BAEE, 0x209CB693,
/**/                   0x408CC860, 0x285808C5,
/**/                   0xBCAE6D8C, 0x9B0DC6F3,
/**/                   0x3FEBCEB2, 0x955EC1C4,
/**/                   0x3FF8C000, 0x00000000,
/**/                   0x3F60E1AF, 0x2FB57EE7,
/**/                   0x3FE89000, 0x00000000,
/**/                   0x3FF8F675, 0xD3C502F4,
/**/                   0x3FF751ED, 0xA3BFB2E4,
/**/                   0x400AD956, 0xDE3987BC,
/**/                   0x40220AA0, 0xB30AAD0A,
/**/                   0x403B45AB, 0x16220014,
/**/                   0x40560929, 0xEC84429C,
/**/                   0x4072A569, 0x0D747939,
/**/                   0x40904F10, 0x5407F41E,
/**/                   0xBC675CEB, 0xFC269962,
/**/                   0x3FEC0071, 0x4773138C,
/**/                   0x3FF90000, 0x00000000,
/**/                   0xBF631458, 0x75FA1750,
/**/                   0x3FE8B000, 0x00000000,
/**/                   0x3FF925BD, 0x111125DF,
/**/                   0x3FF7F679, 0x0AD2B4C2,
/**/                   0x400C02BF, 0x1359A3C8,
/**/                   0x40232601, 0x88857C21,
/**/                   0x403D6FEB, 0x2515D90E,
/**/                   0x405830FA, 0xD421145E,
/**/                   0x4074D1D6, 0xFD789544,
/**/                   0x40928561, 0x4B30EBF1,
/**/                   0x3CA13E7B, 0x7876F9D2,
/**/                   0x3FEC328D, 0x437F5E74,
/**/                   0x3FF94000, 0x00000000,
/**/                   0xBF7A42EE, 0xEEDA20A4,
/**/                   0x3FE8D000, 0x00000000,
/**/                   0x3FF95654, 0x81B9477B,
/**/                   0x3FF8A233, 0x67F87779,
/**/                   0x400D3E90, 0x14665EA0,
/**/                   0x40245815, 0x5A415747,
/**/                   0x403FD0E1, 0x1D7511C0,
/**/                   0x405A99B6, 0x01EC30FB,
/**/                   0x40774A72, 0xDD7EE7A1,
/**/                   0x40951454, 0x5C2F1724,
/**/                   0x3C8185B3, 0x774A5205,
/**/                   0x3FEC6509, 0x1BD4AD0C,
/**/                   0x3FF94000, 0x00000000,
/**/                   0x3F765481, 0xB9477AC0,
/**/                   0x3FE8F000, 0x00000000,
/**/                   0x3FF9884A, 0xF50630B5,
/**/                   0x3FF9558F, 0x94B35A8D,
/**/                   0x400E8E46, 0xD1A32B1D,
/**/                   0x4025A31F, 0x0AEC68DB,
/**/                   0x40413785, 0xFD21A759,
/**/                   0x405D4C53, 0xF56DFCA6,
/**/                   0x407A1B45, 0xF89C0F5F,
/**/                   0x40980BB3, 0xC92C8CF3,
/**/                   0xBC8696E8, 0xFEB6A05E,
/**/                   0x3FEC97E7, 0x7F82B8CC,
/**/                   0x3FF98000, 0x00000000,
/**/                   0x3F6095EA, 0x0C6169C6,
/**/                   0x3FE91000, 0x00000000,
/**/                   0x3FF9BBB0, 0x292BC29F,
/**/                   0x3FFA1109, 0xC8E3D76B,
/**/                   0x400FF386, 0x8873C480,
/**/                   0x402709A6, 0xDE619C77,
/**/                   0x4042A8E9, 0x5A9417B9,
/**/                   0x4060299D, 0xBFE20B57,
/**/                   0x407D5283, 0xE1225431,
/**/                   0x409B7E74, 0xC225406C,
/**/                   0xBC879431, 0x74F396DB,
/**/                   0x3FECCB2B, 0x3C239888,
/**/                   0x3FF9C000, 0x00000000,
/**/                   0xBF513F5B, 0x50F5839F,
/**/                   0x3FE93000, 0x00000000,
/**/                   0x3FF9F094, 0xDEF4783D,
/**/                   0x3FFAD528, 0x8E300736,
/**/                   0x4010B80E, 0xB2D4D4EE,
/**/                   0x40288E84, 0x3F3D0057,
/**/                   0x404440D4, 0xD20263C0,
/**/                   0x4061DD42, 0x26E14927,
/**/                   0x4080807D, 0x5EF13D09,
/**/                   0x409F836C, 0xFE9E94BE,
/**/                   0xBC813C84, 0xE5FD9D2D,
/**/                   0x3FECFED7, 0x3FCCF104,
/**/                   0x3FFA0000, 0x00000000,
/**/                   0xBF6ED642, 0x170F854B,
/**/                   0x3FE95000, 0x00000000,
/**/                   0x3FFA270A, 0xEF70C9F9,
/**/                   0x3FFBA27D, 0xD12662D9,
/**/                   0x40118304, 0xE8433B59,
/**/                   0x402A34E9, 0x1B4DD8D9,
/**/                   0x4046041F, 0x58AA354C,
/**/                   0x4063C823, 0x87EB035B,
/**/                   0x40829D4E, 0x7F89A6B6,
/**/                   0x40A21B1A, 0xB4BED54D,
/**/                   0x3C855D66, 0xFD8283D4,
/**/                   0x3FED32EE, 0x9B2A7684,
/**/                   0x3FFA4000, 0x00000000,
/**/                   0xBF78F510, 0x8F3606B9,
/**/                   0x3FE97000, 0x00000000,
/**/                   0x3FFA5F25, 0x63EA127F,
/**/                   0x3FFC79A8, 0x1460C218,
/**/                   0x40125BC0, 0x3D14975C,
/**/                   0x402C006F, 0x2249DB66,
/**/                   0x4047F856, 0xED0AEFCD,
/**/                   0x4065F27F, 0x2E2028D0,
/**/                   0x40850B95, 0x6CE59595,
/**/                   0x40A4DC23, 0x18C497E2,
/**/                   0x3C8BDFAE, 0x76BA54CA,
/**/                   0x3FED6774, 0x83C60554,
/**/                   0x3FFA4000, 0x00000000,
/**/                   0x3F7F2563, 0xEA127F53,
/**/                   0x3FE99000, 0x00000000,
/**/                   0x3FFA98F8, 0x9061CEFE,
/**/                   0x3FFD5B53, 0xCAA1F466,
/**/                   0x40134379, 0xA92630E8,
/**/                   0x402DF527, 0x41E37357,
/**/                   0x404A23DF, 0xD7DE2305,
/**/                   0x406865FE, 0x1911C50F,
/**/                   0x4087D981, 0xD5CE543D,
/**/                   0x40A8192E, 0x2134A322,
/**/                   0xBC915CF9, 0x4FE6DAC8,
/**/                   0x3FED9C6C, 0x56821F74,
/**/                   0x3FFA8000, 0x00000000,
/**/                   0x3F78F890, 0x61CEFDBB,
/**/                   0x3FE9B000, 0x00000000,
/**/                   0x3FFAD49A, 0x30F0DACC,
/**/                   0x3FFE483C, 0xDDBFEE70,
/**/                   0x40143B8C, 0xC4418459,
/**/                   0x40300BD5, 0xE6E7E816,
/**/                   0x404C8E1A, 0x02EE200E,
/**/                   0x406B2DFC, 0x83038A03,
/**/                   0x408B1814, 0xD987E3D9,
/**/                   0x40ABEB1E, 0x8827CEFA,
/**/                   0x3CA8829A, 0xE22AFCE0,
/**/                   0x3FEDD1D9, 0x9A4C39D0,
/**/                   0x3FFAC000, 0x00000000,
/**/                   0x3F749A30, 0xF0DACB86,
/**/                   0x3FE9D000, 0x00000000,
/**/                   0x3FFB1221, 0x8A66E40D,
/**/                   0x3FFF4130, 0x692DC10A,
/**/                   0x4015457C, 0x64621A80,
/**/                   0x4031369A, 0xED2A1AB4,
/**/                   0x404F3F8D, 0xBC003A70,
/**/                   0x406E57E1, 0x462E99D6,
/**/                   0x408EDBC2, 0xC53F5717,
/**/                   0x40B0383D, 0x0A71E453,
/**/                   0x3C90AF9F, 0xBEDD86A9,
/**/                   0x3FEE07C0, 0x030CF708,
/**/                   0x3FFB0000, 0x00000000,
/**/                   0x3F72218A, 0x66E40CBE,
/**/                   0x3FE9F000, 0x00000000,
/**/                   0x3FFB51A7, 0x8E9927E5,
/**/                   0x40002387, 0x581637B3,
/**/                   0x401662F7, 0xF5B2C17E,
/**/                   0x40327DDB, 0x36EAC07E,
/**/                   0x40512110, 0xC70D9C43,
/**/                   0x4070F9C4, 0x88C52943,
/**/                   0x40919E9E, 0xB1AB4848,
/**/                   0x40B2E76B, 0xB1EC7695,
/**/                   0x3CAA2400, 0x5E9F6FD9,
/**/                   0x3FEE3E23, 0x74DD3C64,
/**/                   0x3FFB4000, 0x00000000,
/**/                   0x3F71A78E, 0x9927E571,
/**/                   0x3FEA1000, 0x00000000,
/**/                   0x3FFB9347, 0x04E0F95F,
/**/                   0x4000AD66, 0xAC8DC27B,
/**/                   0x401795E1, 0xAE05A580,
/**/                   0x4033E4FA, 0x299AA0A0,
/**/                   0x4052D0AD, 0xA33AB75C,
/**/                   0x407309E5, 0x39D64C89,
/**/                   0x40942D39, 0x154C34C4,
/**/                   0x40B61A59, 0x59D15B1D,
/**/                   0xBCAFC899, 0x114BE565,
/**/                   0x3FEE7508, 0x0787FD30,
/**/                   0x3FFB8000, 0x00000000,
/**/                   0x3F734704, 0xE0F95E8B,
/**/                   0x3FEA3000, 0x00000000,
/**/                   0x3FFBD71C, 0xB75F37A1,
/**/                   0x40013EBC, 0xFC9006E1,
/**/                   0x4018E055, 0xC48D2C09,
/**/                   0x40356FD7, 0xC2C8C9CD,
/**/                   0x4054B557, 0x6198B971,
/**/                   0x4075678C, 0x9680F9AF,
/**/                   0x40972BE5, 0x8AF946DD,
/**/                   0x40B9EDE4, 0xE1B531F9,
/**/                   0xBC447F69, 0xE4527544,
/**/                   0x3FEEAC72, 0x0A61AD1C,
/**/                   0x3FFBC000, 0x00000000,
/**/                   0x3F771CB7, 0x5F37A0DF,
/**/                   0x3FEA5000, 0x00000000,
/**/                   0x3FFC1D47, 0xA5B24F80,
/**/                   0x4001D81E, 0x7EB9F789,
/**/                   0x401A44B2, 0xDF42B6B7,
/**/                   0x403722E5, 0xB4766752,
/**/                   0x4056D6EE, 0xECFADFF0,
/**/                   0x40782028, 0x8B1EB8D5,
/**/                   0x409AB0E2, 0xCA840144,
/**/                   0x40BE8614, 0xE2126BBF,
/**/                   0xBC8D9A93, 0x2CC624E2,
/**/                   0x3FEEE466, 0x087F8D20,
/**/                   0x3FFC0000, 0x00000000,
/**/                   0x3F7D47A5, 0xB24F8064,
/**/                   0x3FEA7000, 0x00000000,
/**/                   0x3FFC65E9, 0x3DE98207,
/**/                   0x40027A2E, 0x811F641B,
/**/                   0x401BC5A3, 0xF223266D,
/**/                   0x40390340, 0xA6ECBE29,
/**/                   0x40593EB6, 0xC3D499AF,
/**/                   0x407B43D9, 0xAD8CC2F1,
/**/                   0x409ED77C, 0xA519B816,
/**/                   0x40C2080A, 0x5B3B703B,
/**/                   0x3C7B187D, 0xE993C3DD,
/**/                   0x3FEF1CE8, 0xCD5A7CE8,
/**/                   0x3FFC8000, 0x00000000,
/**/                   0xBF7A16C2, 0x167DF937,
/**/                   0x3FEA9000, 0x00000000,
/**/                   0x3FFCB125, 0x9CA2F05E,
/**/                   0x400325A1, 0x54FC4C95,
/**/                   0x401D662B, 0xD9C5FF75,
/**/                   0x403B16CE, 0x8E93577D,
/**/                   0x405BF79A, 0xE0E3029E,
/**/                   0x407EE612, 0x04BCDF91,
/**/                   0x40A1E0AC, 0x31EFE3F1,
/**/                   0x40C56267, 0x85DF051C,
/**/                   0xBCAD6122, 0x2D0BC06E,
/**/                   0x3FEF55FF, 0x69EAB2F0,
/**/                   0x3FFCC000, 0x00000000,
/**/                   0xBF6DB4C6, 0xBA1F43E4,
/**/                   0x3FEAB000, 0x00000000,
/**/                   0x3FFCFF23, 0xD56B9F55,
/**/                   0x4003DB3E, 0x86149A3B,
/**/                   0x401F29B3, 0x0B8D0DAD,
/**/                   0x403D6463, 0x40E9D1A7,
/**/                   0x405F0E89, 0x619D6679,
/**/                   0x40818F2E, 0x92CF3FBC,
/**/                   0x40A4CC10, 0x844E51BD,
/**/                   0x40C9762D, 0xF3A9EB60,
/**/                   0x3CA20E79, 0xEF4B1E02,
/**/                   0x3FEF8FAF, 0x3A4BC01C,
/**/                   0x3FFD0000, 0x00000000,
/**/                   0xBF2B8552, 0x8C156248,
/**/                   0x3FEAD000, 0x00000000,
/**/                   0x3FFD500E, 0x44AAD4F2,
/**/                   0x40049BE3, 0x6B85DB68,
/**/                   0x40208A0B, 0xE558F351,
/**/                   0x403FF3EC, 0xC1BCC632,
/**/                   0x40614970, 0x2A555E45,
/**/                   0x408404AE, 0xDD057F33,
/**/                   0x40A847D9, 0x22610A18,
/**/                   0x40CE7146, 0x3C7AA2B4,
/**/                   0xBC9571D0, 0x53CA14EC,
/**/                   0x3FEFC9FD, 0xEBFAA348,
/**/                   0x3FFD4000, 0x00000000,
/**/                   0x3F700E44, 0xAAD4F267,
/**/                   0x3FEAF000, 0x00000000,
/**/                   0x3FFDA412, 0xEC9EDC5A,
/**/                   0x40056886, 0x22B6D908,
/**/                   0x402194E0, 0xB605B3B4,
/**/                   0x40416754, 0x9338560C,
/**/                   0x40634B7B, 0x34B16169,
/**/                   0x4086E508, 0x3B1BAF9C,
/**/                   0x40AC7475, 0xFB9DFBF5,
/**/                   0x40D2473E, 0xF4B4BB01,
/**/                   0x3CA82B31, 0xE9F06EFC,
/**/                   0x3FF00278, 0xC2613F02,
/**/                   0x3FFDC000, 0x00000000,
/**/                   0xBF7BED13, 0x6123A5D1,
/**/                   0x3FEB1000, 0x00000000,
/**/                   0x3FFDFB63, 0xDF3AE0DB,
/**/                   0x40064239, 0x08AD38CF,
/**/                   0x4022B7DB, 0xAA166573,
/**/                   0x4042FFB4, 0x38210D3E,
/**/                   0x40659862, 0xFB634456,
/**/                   0x408A45B4, 0xEE8F3E34,
/**/                   0x40B0BD59, 0xD39A6C6F,
/**/                   0x40D60CCD, 0x2B4867E8,
/**/                   0xBCA6097F, 0x1CBB85B3,
/**/                   0x3FF02048, 0x3537E800,
/**/                   0x3FFE0000, 0x00000000,
/**/                   0xBF527083, 0x147C93ED,
/**/                   0x3FEB3000, 0x00000000,
/**/                   0x3FFE5637, 0xB70F5F72,
/**/                   0x40072A2E, 0xCA935102,
/**/                   0x4023F5DE, 0x43559218,
/**/                   0x4044C96E, 0xB4E19CA3,
/**/                   0x40683D62, 0x1272DDA3,
/**/                   0x408E4135, 0xC6BFAAED,
/**/                   0x40B3C717, 0x099FB249,
/**/                   0x40DABA6D, 0xD5294F7D,
/**/                   0x3CA488B1, 0xC91FFA21,
/**/                   0x3FF03E70, 0xB5B309E0,
/**/                   0x3FFE4000, 0x00000000,
/**/                   0x3F7637B7, 0x0F5F723E,
/**/                   0x3FEB5000, 0x00000000,
/**/                   0x3FFEB4CA, 0x21D4B842,
/**/                   0x400821BF, 0x2BE08FC5,
/**/                   0x40255238, 0x6A6A3BD0,
/**/                   0x4046CC00, 0xBAC907E2,
/**/                   0x406B4A78, 0x94202458,
/**/                   0x40917C35, 0xFE065CA6,
/**/                   0x40B77848, 0xE8D5B845,
/**/                   0x40E04820, 0x0CD72D76,
/**/                   0x3CA54B6E, 0x9CBE508B,
/**/                   0x3FF05CF5, 0xE41C2ACE,
/**/                   0x3FFEC000, 0x00000000,
/**/                   0xBF666BBC, 0x568F7C18,
/**/                   0x3FEB7000, 0x00000000,
/**/                   0x3FFF175C, 0x7FB6EB26,
/**/                   0x40092A6C, 0xA7BA9C35,
/**/                   0x4026D0BC, 0x80F5BA9F,
/**/                   0x40491048, 0x33BD74FB,
/**/                   0x406ED319, 0x61FCE21F,
/**/                   0x40944A2E, 0x60DF5AED,
/**/                   0x40BBFAFC, 0x1AC97175,
/**/                   0x40E3F145, 0xC3A8BC22,
/**/                   0xBC994B5D, 0xA70A42D9,
/**/                   0x3FF07BDB, 0x9F358760,
/**/                   0x3FFF0000, 0x00000000,
/**/                   0x3F775C7F, 0xB6EB2582,
/**/                   0x3FEB9000, 0x00000000,
/**/                   0x3FFF7E36, 0x9B29492C,
/**/                   0x400A45EB, 0x1C35AD8A,
/**/                   0x402875D7, 0xC8373BB1,
/**/                   0x404BA0D1, 0x885E6AE6,
/**/                   0x40717784, 0x0831631E,
/**/                   0x4097A441, 0x7F51DA78,
/**/                   0x40C0C2B2, 0x6D7642FB,
/**/                   0x40E89073, 0x594961FB,
/**/                   0xBCA5DECE, 0x96CDC181,
/**/                   0x3FF09B26, 0x0A46374E,
/**/                   0x3FFF8000, 0x00000000,
/**/                   0xBF3C964D, 0x6B6D3D05,
/**/                   0x3FEBB000, 0x00000000,
/**/                   0x3FFFE9A7, 0x7DD9B1CF,
/**/                   0x400B7627, 0xB9AE77AF,
/**/                   0x402A46B0, 0x3338306D,
/**/                   0x404E8A38, 0xA0CAACE9,
/**/                   0x4073DDBB, 0x864F53A2,
/**/                   0x409BAAF0, 0xD6C97F8D,
/**/                   0x40C42EEF, 0xDFAE5A98,
/**/                   0x40EE701A, 0xE19501DA,
/**/                   0x3C9CC4F4, 0xC7D3D675,
/**/                   0x3FF0BAD9, 0x93EC49AE,
/**/                   0x40000000, 0x00000000,
/**/                   0xBF765882, 0x264E310D,
/**/                   0x3FEBD000, 0x00000000,
/**/                   0x40002D03, 0x34302F3B,
/**/                   0x400CBD52, 0x7F5AAF0D,
/**/                   0x402C4949, 0x0C635C0A,
/**/                   0x4050EDD1, 0xB6BB1732,
/**/                   0x4076AE3D, 0x9691A9F4,
/**/                   0x40A043C7, 0x61482FC6,
/**/                   0x40C87037, 0xF81EB6E0,
/**/                   0x40F2FA30, 0xE84FE55E,
/**/                   0xBC9820F1, 0x228FC41D,
/**/                   0x3FF0DAFA, 0xFDD4AE68,
/**/                   0x40002000, 0x00000000,
/**/                   0x3F7A0668, 0x605E76B0,
/**/                   0x3FEBF000, 0x00000000,
/**/                   0x400067D9, 0xF9C947A3,
/**/                   0x400E1DE9, 0xA1722882,
/**/                   0x402E84B0, 0x41FE0247,
/**/                   0x4052D3AE, 0xDBD1D676,
/**/                   0x4079FF78, 0xE088BEF5,
/**/                   0x40A33780, 0x64D9A484,
/**/                   0x40CDC32D, 0x1974F9B5,
/**/                   0x40F7D295, 0xCE268611,
/**/                   0xBCA5A192, 0xD437D23F,
/**/                   0x3FF0FB8F, 0x657EFDCA,
/**/                   0x40006000, 0x00000000,
/**/                   0x3F6F67E7, 0x251E8CF3,
/**/                   0x3FEC1000, 0x00000000,
/**/                   0x4000A58D, 0xB1FFFA6D,
/**/                   0x400F9AC7, 0x4E7307C3,
/**/                   0x4030809B, 0x5EA15962,
/**/                   0x405501D0, 0x5418E1B6,
/**/                   0x407DED80, 0xB476D79F,
/**/                   0x40A6D2BF, 0x37F33D5F,
/**/                   0x40D23C31, 0xA43F6C6F,
/**/                   0x40FE1E46, 0xDB17BBAA,
/**/                   0xBCA7EB62, 0x41D8AD56,
/**/                   0x3FF11C9C, 0x4E3ADE0A,
/**/                   0x4000A000, 0x00000000,
/**/                   0x3F6636C7, 0xFFE9B457,
/**/                   0x3FEC3000, 0x00000000,
/**/                   0x4000E65A, 0x1D1BDCC6,
/**/                   0x40109B99, 0x3503CCCE,
/**/                   0x4031E45B, 0x7580EC24,
/**/                   0x405785CA, 0x1803E176,
/**/                   0x40814DDB, 0x8458A77D,
/**/                   0x40AB41D9, 0x6C115AB7,
/**/                   0x40D67DF0, 0xD7BCE584,
/**/                   0x41032EF5, 0xF5487646,
/**/                   0xBC9C4040, 0xF3631254,
/**/                   0x3FF13E27, 0xAC964DA8,
/**/                   0x4000E000, 0x00000000,
/**/                   0x3F696874, 0x6F731770,
/**/                   0x3FEC5000, 0x00000000,
/**/                   0x40012A82, 0x068FBCB4,
/**/                   0x40117B79, 0x7FE89A5F,
/**/                   0x40337376, 0xD37F3897,
/**/                   0x405A704E, 0xDF3B47A2,
/**/                   0x40841B83, 0xEB114449,
/**/                   0x40B05F75, 0x8D323120,
/**/                   0x40DBEFEC, 0x8AE65DDD,
/**/                   0x4108A2A2, 0xD1814341,
/**/                   0x3CA3E83D, 0xFB25EC76,
/**/                   0x3FF16037, 0xF37FFEDA,
/**/                   0x40012000, 0x00000000,
/**/                   0x3F75040D, 0x1F796787,
/**/                   0x3FEC7000, 0x00000000,
/**/                   0x40017250, 0x5F8F574B,
/**/                   0x40126F35, 0xB566493D,
/**/                   0x403534F5, 0x95186E3D,
/**/                   0x405DD60B, 0x947D5EA5,
/**/                   0x40877C77, 0x568C5D73,
/**/                   0x40B3CB66, 0xA26261F0,
/**/                   0x40E17B06, 0xBF32194D,
/**/                   0x410FE921, 0x11490E42,
/**/                   0xBCA34428, 0x5376CB61,
/**/                   0x3FF182D4, 0x236FE314,
/**/                   0x40018000, 0x00000000,
/**/                   0xBF7B5F40, 0xE15169A9,
/**/                   0x3FEC9000, 0x00000000,
/**/                   0x4001BE19, 0x91B4C8D8,
/**/                   0x4013795B, 0xBE69BAE6,
/**/                   0x40373151, 0xCD6F8B02,
/**/                   0x4060E864, 0xD86A7BFF,
/**/                   0x408B95CC, 0x515F5BD6,
/**/                   0x40B8180C, 0xD070B4A1,
/**/                   0x40E60D2C, 0xC9B24D80,
/**/                   0x4114DBF6, 0xAA392CAF,
/**/                   0xBCA89BD0, 0xF5844C55,
/**/                   0x3FF1A603, 0xDBFAF236,
/**/                   0x4001C000, 0x00000000,
/**/                   0xBF4E66E4, 0xB37285FC,
/**/                   0x3FECB000, 0x00000000,
/**/                   0x40020E3D, 0x1757F6B1,
/**/                   0x40149CE9, 0xAE890640,
/**/                   0x403972D4, 0xD6174F60,
/**/                   0x40634079, 0x8C82DF92,
/**/                   0x40904BE6, 0xACAB5569,
/**/                   0x40BD8A99, 0xB362E75A,
/**/                   0x40EC0ED7, 0x389374DC,
/**/                   0x411B8ADF, 0xCA5E9653,
/**/                   0xBC80CBC7, 0x4A1E3E49,
/**/                   0x3FF1C9CF, 0x704F5D26,
/**/                   0x40020000, 0x00000000,
/**/                   0x3F7C7A2E, 0xAFED62A2,
/**/                   0x3FECD000, 0x00000000,
/**/                   0x40026327, 0x6B3395AA,
/**/                   0x4015DD66, 0x33FB1467,
/**/                   0x403C0610, 0xDCF3437C,
/**/                   0x406607CE, 0xC9D7C47A,
/**/                   0x409360FB, 0xA330DC5C,
/**/                   0x40C240B4, 0x38A3194B,
/**/                   0x40F20437, 0xBAA6A879,
/**/                   0x41226106, 0x04D6F19C,
/**/                   0x3CABCCF5, 0x15E5252C,
/**/                   0x3FF1EE3F, 0xFF35681A,
/**/                   0x40026000, 0x00000000,
/**/                   0x3F593B59, 0x9CAD4CE9,
/**/                   0x3FECF000, 0x00000000,
/**/                   0x4002BD54, 0x664A8350,
/**/                   0x40173EFF, 0x945190A0,
/**/                   0x403EFA80, 0xC7CC5224,
/**/                   0x406958AA, 0x896F1658,
/**/                   0x40973450, 0x4FD54E04,
/**/                   0x40C6BF55, 0x4CD60C4A,
/**/                   0x40F75EBE, 0x3EFFD07C,
/**/                   0x4128D03C, 0x9E2E6981,
/**/                   0xBC987CEE, 0xC8A488FF,
/**/                   0x3FF2135F, 0x8F597306,
/**/                   0x4002C000, 0x00000000,
/**/                   0xBF555CCD, 0xABE583FE,
/**/                   0x3FED1000, 0x00000000,
/**/                   0x40031D52, 0x2A40EA5C,
/**/                   0x4018C6B3, 0x52B4947D,
/**/                   0x404131AE, 0x5D01146E,
/**/                   0x406D54FB, 0x0163E71C,
/**/                   0x409BFE8A, 0xEF3ED15B,
/**/                   0x40CC9C28, 0xA33A6B00,
/**/                   0x40FEA523, 0x1456E1A6,
/**/                   0x4130F60F, 0xFC8790DB,
/**/                   0x3CAC104F, 0x6FABCA41,
/**/                   0x3FF23939, 0x30D87C68,
/**/                   0x40032000, 0x00000000,
/**/                   0xBF556EAD, 0xF8AD1CF9,
/**/                   0x3FED3000, 0x00000000,
/**/                   0x400383C4, 0xC053C623,
/**/                   0x401A7A81, 0x6ADBFF2C,
/**/                   0x40432C5B, 0xE219A24E,
/**/                   0x40711484, 0x30F4B8D8,
/**/                   0x40A10659, 0xBC59423E,
/**/                   0x40D22C09, 0x3D537AE5,
/**/                   0x410454A2, 0xA4B7D930,
/**/                   0x41378151, 0xC151F3C3,
/**/                   0xBCA2F226, 0x779E9951,
/**/                   0x3FF25FD9, 0x254E3F9C,
/**/                   0x40038000, 0x00000000,
/**/                   0x3F5E2602, 0x9E311A8B,
/**/                   0x3FED5000, 0x00000000,
/**/                   0x4003F16A, 0xA2F65F8C,
/**/                   0x401C61AF, 0x36C0308E,
/**/                   0x40457C82, 0x5337FF7D,
/**/                   0x407407A3, 0x7FB84BA9,
/**/                   0x40A4E476, 0x4C74DEA7,
/**/                   0x40D75638, 0xDF1C2124,
/**/                   0x410B5320, 0xA2556E94,
/**/                   0x414087CD, 0x7D68ABBE,
/**/                   0xBCACD58C, 0x73A87AB9,
/**/                   0x3FF2874D, 0x10017B06,
/**/                   0x40040000, 0x00000000,
/**/                   0xBF7D2ABA, 0x1340E849,
/**/                   0x3FED7000, 0x00000000,
/**/                   0x40046722, 0x7BA9A810,
/**/                   0x401E851F, 0xCBC74735,
/**/                   0x40483596, 0xF3879985,
/**/                   0x4077AAEB, 0xCD297F00,
/**/                   0x40A9E3C8, 0x31669F50,
/**/                   0x40DE5420, 0xB7CBB664,
/**/                   0x41129F7B, 0xB75100A0,
/**/                   0x4147A1C1, 0x51D127BF,
/**/                   0x3CAC647E, 0x46D9C78F,
/**/                   0x3FF2AFA4, 0x304962AE,
/**/                   0x40046000, 0x00000000,
/**/                   0x3F6C89EE, 0xA6A041C9,
/**/                   0x3FED9000, 0x00000000,
/**/                   0x4004E5F2, 0x7A99A835,
/**/                   0x402077E5, 0x15B0232D,
/**/                   0x404B70C1, 0xEE468866,
/**/                   0x407C334A, 0x43A041C3,
/**/                   0x40B036D1, 0x53D2C164,
/**/                   0x40E3F7B1, 0x10CCEDBE,
/**/                   0x4119C160, 0xF6C2E560,
/**/                   0x415131DD, 0x6D21D20F,
/**/                   0x41878683, 0x2EC50766,
/**/                   0xBCA95596, 0xD1134ECC,
/**/                   0x3FF2D8EF, 0xA8F4B028,
/**/                   0x4004E000, 0x00000000,
/**/                   0x3F67C9EA, 0x66A0D2C7,
/**/                   0x3FEDB000, 0x00000000,
/**/                   0x40056F11, 0xD6373B90,
/**/                   0x4021D7AC, 0xC3747DF3,
/**/                   0x404F4EF3, 0x6A014D6F,
/**/                   0x4080F4C4, 0x505C454B,
/**/                   0x40B48D16, 0x214975C5,
/**/                   0x40EAACFD, 0xF57BFAC6,
/**/                   0x41222235, 0x5225A6ED,
/**/                   0x41598643, 0xACBA67AB,
/**/                   0x419267B9, 0xDE5D19B9,
/**/                   0xBCAEF63C, 0x42C92439,
/**/                   0x3FF30342, 0xD86BED76,
/**/                   0x40056000, 0x00000000,
/**/                   0x3F7E23AC, 0x6E771F48,
/**/                   0x3FEDD000, 0x00000000,
/**/                   0x400603F5, 0x3D2D8CF1,
/**/                   0x40236A84, 0xEF4A10FA,
/**/                   0x4051FDF3, 0x4EA265AF,
/**/                   0x408499B5, 0xD944F636,
/**/                   0x40BA64B8, 0x37F73BAC,
/**/                   0x40F21B9F, 0x259B27FC,
/**/                   0x412A0669, 0x265D5B9F,
/**/                   0x41635D8E, 0x3DC806E2,
/**/                   0x419D8657, 0x36AD8B00,
/**/                   0x3CA4CEEB, 0x3FFCDCA3,
/**/                   0x3FF32EB3, 0xC69D2D10,
/**/                   0x40060000, 0x00000000,
/**/                   0x3F5FA9E9, 0x6C678625,
/**/                   0x3FEDF000, 0x00000000,
/**/                   0x4006A65F, 0x5FCDF915,
/**/                   0x40253B6E, 0x68321BDA,
/**/                   0x4054D949, 0x706E8DA9,
/**/                   0x408950EF, 0x4A70D2D7,
/**/                   0x40C13319, 0x1F15E14E,
/**/                   0x40F907B1, 0x846A9BD5,
/**/                   0x4133139C, 0x17C39016,
/**/                   0x416E1DA3, 0xBC86F11B,
/**/                   0x41A8597F, 0xD9F86F3B,
/**/                   0x3C32D4F8, 0x7D0D5190,
/**/                   0x3FF35B5B, 0xAFA88354,
/**/                   0x4006A000, 0x00000000,
/**/                   0x3F697D7F, 0x37E455FD,
/**/                   0x3FEE1000, 0x00000000,
/**/                   0x40075877, 0x41D1DBF9,
/**/                   0x402758A8, 0xF5852184,
/**/                   0x405861EE, 0x65C0F467,
/**/                   0x408F83C0, 0xD2D91276,
/**/                   0x40C6CA7C, 0x43EC3B0E,
/**/                   0x4101A722, 0x718322C8,
/**/                   0x413CA4C6, 0x9533D806,
/**/                   0x417812B7, 0xE9899583,
/**/                   0x41B4B875, 0x85EE8B86,
/**/                   0xBC99DEFB, 0xD1AEEED1,
/**/                   0x3FF38957, 0xB510476E,
/**/                   0x40076000, 0x00000000,
/**/                   0xBF6E22F8, 0xB8901BF9,
/**/                   0x3FEE3000, 0x00000000,
/**/                   0x40081CE6, 0xE1C37E57,
/**/                   0x4029D4F3, 0xD3DC9910,
/**/                   0x405CD074, 0xE3095065,
/**/                   0x4093E764, 0xC5C38224,
/**/                   0x40CEC5AE, 0x3CAE1F31,
/**/                   0x41097A50, 0xC0645F38,
/**/                   0x41461866, 0xD8A7F25E,
/**/                   0x4183DAF5, 0x8C2F04A3,
/**/                   0x41C2450E, 0xA9143C1F,
/**/                   0x3C7D25BE, 0x9FD995BC,
/**/                   0x3FF3B8C9, 0xC35D33E6,
/**/                   0x40082000, 0x00000000,
/**/                   0xBF58C8F1, 0xE40D49E0,
/**/                   0x3FEE5000, 0x00000000,
/**/                   0x4008F706, 0x285640BB,
/**/                   0x402CC96B, 0x3B2B7CD1,
/**/                   0x40613ADF, 0xC5341328,
/**/                   0x4099908D, 0x16E928A9,
/**/                   0x40D53986, 0x7CC08A3C,
/**/                   0x4112DFC5, 0x31DD3E45,
/**/                   0x41519499, 0xE2A13787,
/**/                   0x4190F943, 0xF94424AD,
/**/                   0x41D0C6BC, 0xCDCD49BE,
/**/                   0xBC9E2458, 0x6D41701D,
/**/                   0x3FF3E9D9, 0xC088BD28,
/**/                   0x40090000, 0x00000000,
/**/                   0xBF71F3AF, 0x537E8A00,
/**/                   0x3FEE7000, 0x00000000,
/**/                   0x4009EB18, 0x6562D1E0,
/**/                   0x40302C31, 0x75651223,
/**/                   0x4064E431, 0x336E41C7,
/**/                   0x40A0BCA6, 0xA065DA69,
/**/                   0x40DE034D, 0x917AF357,
/**/                   0x411CD2C1, 0x4168FB0F,
/**/                   0x415CFEB6, 0x15BB794D,
/**/                   0x419E3EE1, 0x6EFFD5E5,
/**/                   0x41E024E7, 0x1ACB4D9C,
/**/                   0xBC9C29C8, 0xD93F153F,
/**/                   0x3FF41CB7, 0x2183E810,
/**/                   0x4009E000, 0x00000000,
/**/                   0x3F7630CA, 0xC5A3C038,
/**/                   0x3FEE9000, 0x00000000,
/**/                   0x400AFEA6, 0xA364196F,
/**/                   0x403258F3, 0x0B19A2EB,
/**/                   0x4069BDA5, 0x2520AC75,
/**/                   0x40A669BC, 0x8F67EDEA,
/**/                   0x40E5D78C, 0xC026C9F8,
/**/                   0x4126CCB4, 0x1E3B36C2,
/**/                   0x4168EDE4, 0xBF45C805,
/**/                   0x41AC2F6A, 0x8AC89E76,
/**/                   0x41F0675E, 0x4CA9EB55,
/**/                   0x42336AC1, 0x0D13E3DF,
/**/                   0x3C9B1D74, 0xF2DE93A6,
/**/                   0x3FF4519B, 0x155FB22E,
/**/                   0x400B0000, 0x00000000,
/**/                   0xBF4595C9, 0xBE690E67,
/**/                   0x3FEEB000, 0x00000000,
/**/                   0x400C3908, 0x4BD1C065,
/**/                   0x40350D88, 0x26C39FFD,
/**/                   0x4070296B, 0x69D3E79E,
/**/                   0x40AED279, 0xD7FEEA5D,
/**/                   0x40F072A8, 0xFD5BD547,
/**/                   0x4132CDB9, 0x4A08BB38,
/**/                   0x41768482, 0x536BED06,
/**/                   0x41BBE1FF, 0x2F10E88D,
/**/                   0x4201C966, 0xABDBBDAC,
/**/                   0x42471011, 0x02E62DDA,
/**/                   0xBCA0855D, 0x3E907E71,
/**/                   0x3FF488CB, 0x8FA73920,
/**/                   0x400C4000, 0x00000000,
/**/                   0xBF6BDED0, 0xB8FE6DDF,
/**/                   0x3FEED000, 0x00000000,
/**/                   0x400DA439, 0x12AAF9A9,
/**/                   0x40387D46, 0x62F25109,
/**/                   0x4074C339, 0x3F133A3F,
/**/                   0x40B5E143, 0x662036F9,
/**/                   0x40F9CF04, 0x74467831,
/**/                   0x41404E10, 0x576C6FA8,
/**/                   0x41859489, 0xFF4F8E88,
/**/                   0x41CD88D2, 0xB44962A9,
/**/                   0x4214D838, 0x97A288F3,
/**/                   0x425DE10B, 0x6CF738B3,
/**/                   0xBC8E9EA7, 0x5F7263CC,
/**/                   0x3FF4C29F, 0xAA786F36,
/**/                   0x400DA000, 0x00000000,
/**/                   0x3F60E44A, 0xABE6A2AD,
/**/                   0x3FEEF000, 0x00000000,
/**/                   0x400F4E35, 0xC169B52F,
/**/                   0x403CF773, 0x29E8699C,
/**/                   0x407B6D37, 0xFC1818D6,
/**/                   0x40C02655, 0x1386790A,
/**/                   0x41054A1F, 0x4FF79D1E,
/**/                   0x414E104A, 0x7DB0265A,
/**/                   0x41963C39, 0xE5C8114B,
/**/                   0x41E10156, 0xF52A87DB,
/**/                   0x422ADD76, 0x2E9E7ABE,
/**/                   0x427586AB, 0x6EC81361,
/**/                   0x3C935690, 0xE395EEA6,
/**/                   0x3FF4FF86, 0x2E5965A2,
/**/                   0x400F4000, 0x00000000,
/**/                   0x3F7C6B82, 0xD36A5E70 } };

#else
#ifdef LITTLE_ENDI
static const union {int4 i[5136];double x[2568];} asncs = { .i = {
/**/                   0x00000000, 0x3FC04000,
/**/                   0x88994424, 0x3FF02169,
/**/                   0xB799B115, 0x3FB0A6A2,
/**/                   0xD57409A0, 0x3FC6EF15,
/**/                   0xAF52EAA0, 0x3FAA141E,
/**/                   0xABBBE261, 0x3FB75591,
/**/                   0xD206D88F, 0x3FA72B51,
/**/                   0x5BB33E7D, 0x3C96B595,
/**/                   0xA03E2700, 0x3FC04B41,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x66BBDC7C, 0xBF7E9677,
/**/                   0x00000000, 0x3FC0C000,
/**/                   0xF9E23A56, 0x3FF02386,
/**/                   0x60FD0235, 0x3FB1308C,
/**/                   0x14D16B02, 0x3FC7099F,
/**/                   0x27C01EE1, 0x3FAAFED6,
/**/                   0xDBCD5F98, 0x3FB79C6F,
/**/                   0x4084DAAC, 0x3FA8144A,
/**/                   0x38D8505E, 0xBC87C092,
/**/                   0x56C9F380, 0x3FC0CC55,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x1DC5AA24, 0xBF7C7906,
/**/                   0x00000000, 0x3FC14000,
/**/                   0xB27141F6, 0x3FF025B5,
/**/                   0x04CE7400, 0x3FB1BB18,
/**/                   0x72907342, 0x3FC72514,
/**/                   0x0BF4222C, 0x3FABEC60,
/**/                   0x75B3736C, 0x3FB7E610,
/**/                   0x5199C343, 0x3FA9024C,
/**/                   0x06B56F60, 0xBC8AE84C,
/**/                   0x3DEFA070, 0x3FC14D7A,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x8EBE0A5C, 0xBF7A4A4D,
/**/                   0x00000000, 0x3FC1C000,
/**/                   0xC6DE8F57, 0x3FF027F5,
/**/                   0x345751E1, 0x3FB2464B,
/**/                   0xCF026805, 0x3FC74178,
/**/                   0x40A9E0D6, 0x3FACDCD8,
/**/                   0xEB1D9C38, 0x3FB83282,
/**/                   0xD7BE707B, 0x3FA9F590,
/**/                   0x03A2A6D6, 0xBCAB9768,
/**/                   0xE03B4870, 0x3FC1CEB0,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x2170A943, 0xBF780A39,
/**/                   0x00000000, 0x3FC24000,
/**/                   0x4C759796, 0x3FF02A47,
/**/                   0x92771935, 0x3FB2D22B,
/**/                   0x26ABA06D, 0x3FC75ECF,
/**/                   0x486A1932, 0x3FADD05B,
/**/                   0x5AF971D5, 0x3FB881D7,
/**/                   0x831AEE0C, 0x3FAAEE52,
/**/                   0xAD1B1BEF, 0x3CA13F57,
/**/                   0xC8E09330, 0x3FC24FF9,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x8A68699B, 0xBF75B8B3,
/**/                   0x00000000, 0x3FC2C000,
/**/                   0x59374E09, 0x3FF02CAA,
/**/                   0xD44E8BEA, 0x3FB35EBE,
/**/                   0x92E4BE8A, 0x3FC77D1A,
/**/                   0x4A6C34FD, 0x3FAEC706,
/**/                   0x972F6E07, 0x3FB8D41E,
/**/                   0xF9845F69, 0x3FABECCD,
/**/                   0x945C4185, 0x3C8BA1FA,
/**/                   0x83C058B0, 0x3FC2D155,
/**/                   0x00000000, 0x3FF04000,
/**/                   0xC8B1F774, 0xBF7355A6,
/**/                   0x00000000, 0x3FC34000,
/**/                   0x03DC7745, 0x3FF02F1F,
/**/                   0xC1EE9F61, 0x3FB3EC0A,
/**/                   0x4A82E6D2, 0x3FC79C5E,
/**/                   0x19B1EF72, 0x3FAFC0F7,
/**/                   0x2AA943E5, 0x3FB9296A,
/**/                   0xEF8B9DE7, 0x3FACF141,
/**/                   0x083C8716, 0xBC834081,
/**/                   0x9D6E5610, 0x3FC352C4,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x2388BB30, 0xBF70E0FC,
/**/                   0x00000000, 0x3FC3C000,
/**/                   0x63D81251, 0x3FF031A5,
/**/                   0x370B721F, 0x3FB47A15,
/**/                   0xA28731E5, 0x3FC7BC9D,
/**/                   0x1E305BE9, 0x3FB05F26,
/**/                   0x5FA50FBD, 0x3FB981CC,
/**/                   0x42AC4083, 0x3FADFBEF,
/**/                   0xA8E107C7, 0x3CA20ACB,
/**/                   0xA336F5E0, 0x3FC3D447,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x4FDB5D5C, 0xBF6CB538,
/**/                   0x00000000, 0x3FC44000,
/**/                   0x9159D86F, 0x3FF0343D,
/**/                   0x23B3747C, 0x3FB508E4,
/**/                   0x0ED597CB, 0x3FC7DDDC,
/**/                   0x79ADF104, 0x3FB0DF92,
/**/                   0x4658D945, 0x3FB9DD58,
/**/                   0x14ACA06B, 0x3FAF0D19,
/**/                   0xDF636EFE, 0xBCA4E10D,
/**/                   0x23252C00, 0x3FC455DF,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x4C4F221A, 0xBF6784DD,
/**/                   0x00000000, 0x3FC4C000,
/**/                   0xA550D410, 0x3FF036E7,
/**/                   0x8D0AF1E7, 0x3FB5987D,
/**/                   0x22F39726, 0x3FC8001D,
/**/                   0xA1116D73, 0x3FB161D0,
/**/                   0xBBEA1528, 0x3FBA3C21,
/**/                   0x74202FF6, 0x3FB01282,
/**/                   0xD10866E2, 0x3CAA0611,
/**/                   0xAC086560, 0x3FC4D78B,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x5E57DF8A, 0xBF6230B5,
/**/                   0x00000000, 0x3FC54000,
/**/                   0xB96E0F8A, 0x3FF039A3,
/**/                   0x8E0C29F6, 0x3FB628E7,
/**/                   0x92CEDE01, 0x3FC82364,
/**/                   0xFB7B5D84, 0x3FB1E5F0,
/**/                   0x71BD08EE, 0x3FBA9E3D,
/**/                   0x5F7FFAB4, 0x3FB0A1FD,
/**/                   0xEF04F6E7, 0xBC90F980,
/**/                   0xCD7A8DC0, 0x3FC5594D,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x47C1D879, 0xBF59711A,
/**/                   0x00000000, 0x3FC5C000,
/**/                   0xE8275C12, 0x3FF03C71,
/**/                   0x584C2A23, 0x3FB6BA28,
/**/                   0x338C3D4B, 0x3FC847B6,
/**/                   0x59A55DD8, 0x3FB26C04,
/**/                   0xF5202D6A, 0x3FBB03C0,
/**/                   0x9C6466A4, 0x3FB13522,
/**/                   0x2A268973, 0x3C983C9A,
/**/                   0x17E62A20, 0x3FC5DB26,
/**/                   0x00000000, 0x3FF04000,
/**/                   0xC51F7008, 0xBF4C70BE,
/**/                   0x00000000, 0x3FC64000,
/**/                   0x4CBA31A9, 0x3FF03F52,
/**/                   0x34C49ADE, 0x3FB74C46,
/**/                   0xFC5F33CC, 0x3FC86D15,
/**/                   0xFA419D7C, 0x3FB2F41B,
/**/                   0xB757E82A, 0x3FBB6CC2,
/**/                   0xDA4D5C39, 0x3FB1CC18,
/**/                   0x2DFB224D, 0xBCA862D4,
/**/                   0x1C8C8AF0, 0x3FC65D15,
/**/                   0x00000000, 0x3FF04000,
/**/                   0xB9CADBBF, 0xBF25B668,
/**/                   0x00000000, 0x3FC6C000,
/**/                   0x032EA88F, 0x3FF04245,
/**/                   0x84A2B473, 0x3FB7DF47,
/**/                   0x076A60F5, 0x3FC89388,
/**/                   0x8E8394C1, 0x3FB37E49,
/**/                   0x160F3472, 0x3FBBD95A,
/**/                   0x39844810, 0x3FB26708,
/**/                   0x698BC8EA, 0x3C994228,
/**/                   0x6D8C14A0, 0x3FC6DF1B,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x754477AC, 0x3F422819,
/**/                   0x00000000, 0x3FC74000,
/**/                   0x285A8CEB, 0x3FF0454A,
/**/                   0xC21B9224, 0x3FB87332,
/**/                   0x92A93402, 0x3FC8BB10,
/**/                   0x3ED3F586, 0x3FB40A9F,
/**/                   0x643217C8, 0x3FBC499F,
/**/                   0x5D29A16B, 0x3FB3061A,
/**/                   0x3DF9F2D7, 0xBCA3B2DF,
/**/                   0x9DE6A160, 0x3FC76139,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x6A33AB4B, 0x3F5528A1,
/**/                   0x00000000, 0x3FC7C000,
/**/                   0xD9E48D58, 0x3FF04861,
/**/                   0x81461BF6, 0x3FB9080E,
/**/                   0x00E32FFA, 0x3FC8E3B4,
/**/                   0xAFB1F2A5, 0x3FB4992F,
/**/                   0xF33705D5, 0x3FBCBDAB,
/**/                   0x7E23EE89, 0x3FB3A97A,
/**/                   0xCCE44C41, 0x3C7AAD12,
/**/                   0x4187FAE0, 0x3FC7E370,
/**/                   0x00000000, 0x3FF04000,
/**/                   0xC91AAF11, 0x3F60C3B3,
/**/                   0x00000000, 0x3FC84000,
/**/                   0x36478509, 0x3FF04B8C,
/**/                   0x70FAC1B4, 0x3FB99DE1,
/**/                   0xDAA92166, 0x3FC90D76,
/**/                   0x06C416A6, 0x3FB52A0E,
/**/                   0x1CDCA344, 0x3FBD359A,
/**/                   0x7EFD4CA0, 0x3FB45155,
/**/                   0x35A8895D, 0x3C396CA5,
/**/                   0xED4C6EF0, 0x3FC865BF,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x8F0A11A4, 0x3F67186C,
/**/                   0x00000000, 0x3FC8C000,
/**/                   0x5CD5E248, 0x3FF04EC9,
/**/                   0x5BB94403, 0x3FBA34B2,
/**/                   0xCF5CA73A, 0x3FC9385D,
/**/                   0xF01AFDBE, 0x3FB5BD4D,
/**/                   0x4D61A7A9, 0x3FBDB185,
/**/                   0x00BD47CF, 0x3FB4FDDA,
/**/                   0x727E8B64, 0xBC9D1119,
/**/                   0x37077E20, 0x3FC8E829,
/**/                   0x00000000, 0x3FF04000,
/**/                   0xABC490CB, 0x3F6D92B9,
/**/                   0x00000000, 0x3FC94000,
/**/                   0x6DBD2A10, 0x3FF05219,
/**/                   0x2894CAA1, 0x3FBACC88,
/**/                   0xB6427516, 0x3FC9646D,
/**/                   0xA3A864D7, 0x3FB65303,
/**/                   0x0E3CF3D4, 0x3FBE318A,
/**/                   0x78CDA678, 0x3FB5AF38,
/**/                   0xDA9D51DF, 0x3CA3841D,
/**/                   0xB58AA660, 0x3FC96AAC,
/**/                   0x00000000, 0x3FF04000,
/**/                   0xBD2A1052, 0x3F72196D,
/**/                   0x00000000, 0x3FC9C000,
/**/                   0x8A099990, 0x3FF0557C,
/**/                   0xDC268965, 0x3FBB6569,
/**/                   0x8F9FBA21, 0x3FC991AB,
/**/                   0xEAED1E85, 0x3FB6EB43,
/**/                   0x115C4C63, 0x3FBEB5C6,
/**/                   0x47F9AEFA, 0x3FB665A3,
/**/                   0x03AB3673, 0xBCA1F8FD,
/**/                   0x00AC4A60, 0x3FC9ED4B,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x0999905B, 0x3F757C8A,
/**/                   0x00000000, 0x3FCA4000,
/**/                   0xD3A9E674, 0x3FF058F2,
/**/                   0x99873832, 0x3FBBFF5E,
/**/                   0x85E31CE9, 0x3FC9C01C,
/**/                   0x26E09FF2, 0x3FB78624,
/**/                   0x3CF0885C, 0x3FBF3E58,
/**/                   0xD2986239, 0x3FB7214E,
/**/                   0x3E594694, 0x3C97E3E5,
/**/                   0xB14EB5D0, 0x3FCA7004,
/**/                   0x00000000, 0x3FF04000,
/**/                   0xA9E6746B, 0x3F78F2D3,
/**/                   0x00000000, 0x3FCAC000,
/**/                   0x6D731ECB, 0x3FF05C7C,
/**/                   0xA34FA4B3, 0x3FBC9A6D,
/**/                   0xEED9C253, 0x3FC9EFC5,
/**/                   0x5614FAEB, 0x3FB823BA,
/**/                   0xB7CE698F, 0x3FBFCB60,
/**/                   0x99F3292F, 0x3FB7E271,
/**/                   0x068D709C, 0xBC9842C6,
/**/                   0x61674110, 0x3FCAF2DA,
/**/                   0x00000000, 0x3FF04000,
/**/                   0x731ECAE2, 0x3F7C7C6D,
/**/                   0x00000000, 0x3FCB4000,
/**/                   0x7B24A973, 0x3FF06019,
/**/                   0x5CA0A798, 0x3FBD369E,
/**/                   0x4CF0DB64, 0x3FCA20AD,
/**/                   0x1B1A3F31, 0x3FB8C41D,
/**/                   0x7B35E049, 0x3FC02E80,
/**/                   0x56FB8A97, 0x3FB8A944,
/**/                   0xD337B37C, 0xBCACBF9C,
/**/                   0xAC059370, 0x3FCB75CC,
/**/                   0x00000000, 0x3FF08000,
/**/                   0xDB568D78, 0xBF7FE684,
/**/                   0x00000000, 0x3FCBC000,
/**/                   0x216C6801, 0x3FF063CA,
/**/                   0x4A32C9FD, 0x3FBDD3F8,
/**/                   0x50843BC9, 0x3FCA52D8,
/**/                   0xC324648A, 0x3FB96763,
/**/                   0xE4407899, 0x3FC079AD,
/**/                   0x1663A5DC, 0x3FB97602,
/**/                   0xC637289D, 0xBCA3ADC3,
/**/                   0x2D5B06A0, 0x3FCBF8DC,
/**/                   0x00000000, 0x3FF08000,
/**/                   0x9397FEA6, 0xBF7C35DE,
/**/                   0x00000000, 0x3FCC4000,
/**/                   0x85EAFB1F, 0x3FF0678E,
/**/                   0x136DEAC6, 0x3FBE7283,
/**/                   0xD93A817D, 0x3FCA864C,
/**/                   0x4CF7089B, 0x3FBA0DA6,
/**/                   0xB3ABB322, 0x3FC0C74A,
/**/                   0x562E6E1E, 0x3FBA48E8,
/**/                   0x7EB8FFF8, 0xBC951E3E,
/**/                   0x82C22B80, 0x3FCC7C09,
/**/                   0x00000000, 0x3FF08000,
/**/                   0x1504E0D3, 0xBF78717A,
/**/                   0x00000000, 0x3FCCC000,
/**/                   0xCF382A59, 0x3FF06B66,
/**/                   0x838936FB, 0x3FBF1246,
/**/                   0xF76F5C94, 0x3FCABB10,
/**/                   0x701A77AE, 0x3FBAB6FD,
/**/                   0xC26702C6, 0x3FC11769,
/**/                   0x24CDF38E, 0x3FBB2237,
/**/                   0xE28307A9, 0xBC8DB69A,
/**/                   0x4AC67190, 0x3FCCFF55,
/**/                   0x00000000, 0x3FF08000,
/**/                   0xC7D5A6B9, 0xBF749930,
/**/                   0x00000000, 0x3FCD4000,
/**/                   0x24E7707F, 0x3FF06F53,
/**/                   0x8AB3CBB2, 0x3FBFB34A,
/**/                   0xEDAC8D74, 0x3FCAF12A,
/**/                   0xA45DA614, 0x3FBB6382,
/**/                   0xAD8E9F44, 0x3FC16A1E,
/**/                   0x41E7749D, 0x3FBC0231,
/**/                   0x22DC16A2, 0x3C76CA27,
/**/                   0x252BF240, 0x3FCD82C0,
/**/                   0x00000000, 0x3FF08000,
/**/                   0x188F814B, 0xBF70ACDB,
/**/                   0x00000000, 0x3FCDC000,
/**/                   0xAF8CADA0, 0x3FF07353,
/**/                   0x9FA32DC9, 0x3FC02ACB,
/**/                   0x32323718, 0x3FCB28A1,
/**/                   0x29A8F15E, 0x3FBC1350,
/**/                   0xDEB270E1, 0x3FC1BF7D,
/**/                   0x40D67463, 0x3FBCE91C,
/**/                   0x104BAA08, 0x3CA6E976,
/**/                   0xB2F76140, 0x3FCE064A,
/**/                   0x00000000, 0x3FF08000,
/**/                   0xE6A4BFC9, 0xBF6958A0,
/**/                   0x00000000, 0x3FCE4000,
/**/                   0x98C0FFD9, 0x3FF07768,
/**/                   0x6F7F1AF0, 0x3FC07C9A,
/**/                   0x708F2AFB, 0x3FCB617A,
/**/                   0x1025B50C, 0x3FBCC681,
/**/                   0x9487453A, 0x3FC2179C,
/**/                   0xAD09B3AB, 0x3FBDD740,
/**/                   0x189038C0, 0xBC8D32DB,
/**/                   0x96762300, 0x3FCE89F5,
/**/                   0x00000000, 0x3FF08000,
/**/                   0x7E004D50, 0xBF612ECE,
/**/                   0x00000000, 0x3FCEC000,
/**/                   0x0B27C417, 0x3FF07B92,
/**/                   0xE821087A, 0x3FC0CF15,
/**/                   0x8B49DC8C, 0x3FCB9BBD,
/**/                   0x40BEF5C2, 0x3FBD7D31,
/**/                   0xEC080575, 0x3FC27290,
/**/                   0x3056A6A9, 0x3FBECCEA,
/**/                   0x0C9B27A2, 0x3C9DE506,
/**/                   0x73468A50, 0x3FCF0DC1,
/**/                   0x00000000, 0x3FF08000,
/**/                   0x60EFA34D, 0xBF51B7D3,
/**/                   0x00000000, 0x3FCF4000,
/**/                   0x3273C018, 0x3FF07FD0,
/**/                   0x51B87F08, 0x3FC12242,
/**/                   0x9D9AB2BC, 0x3FCBD771,
/**/                   0x85FFA125, 0x3FBE377D,
/**/                   0xEA0CFE55, 0x3FC2D071,
/**/                   0xBB61DDD3, 0x3FBFCA67,
/**/                   0x88A645E7, 0xBCA25383,
/**/                   0xEE603F40, 0x3FCF91AE,
/**/                   0x00000000, 0x3FF08000,
/**/                   0x1FF422B6, 0xBF07E6C6,
/**/                   0x00000000, 0x3FCFC000,
/**/                   0x3B6C76F2, 0x3FF08423,
/**/                   0x0A1DF897, 0x3FC17624,
/**/                   0xFD38779D, 0x3FCC149D,
/**/                   0x95531ECD, 0x3FBEF583,
/**/                   0x855FA966, 0x3FC33157,
/**/                   0xD81E6BAA, 0x3FC06805,
/**/                   0x1B47FAEC, 0x3C86827E,
/**/                   0x570E6798, 0x3FD00ADF,
/**/                   0x00000000, 0x3FF08000,
/**/                   0xB1DBC656, 0x3F508CED,
/**/                   0x00000000, 0x3FD02000,
/**/                   0x53F3A97B, 0x3FF0888B,
/**/                   0x858525D6, 0x3FC1CABF,
/**/                   0x3C37AF90, 0x3FCC534A,
/**/                   0x18AD312A, 0x3FBFB762,
/**/                   0xB151CAAD, 0x3FC3955A,
/**/                   0x07ADE82D, 0x3FC0EF16,
/**/                   0xFCDE8746, 0x3CAEEF44,
/**/                   0xAD203480, 0x3FD04CF8,
/**/                   0x00000000, 0x3FF08000,
/**/                   0xE752F5A1, 0x3F6116A7,
/**/                   0x00000000, 0x3FD06000,
/**/                   0xAB0B03F8, 0x3FF08D08,
/**/                   0x4F34EEE8, 0x3FC22019,
/**/                   0x2AFDABDE, 0x3FCC937E,
/**/                   0x5C4F35BA, 0x3FC03E9C,
/**/                   0x68DF21A6, 0x3FC3FC95,
/**/                   0x53843C52, 0x3FC17A91,
/**/                   0xC2BB835A, 0xBC9D6F54,
/**/                   0xCE0162B8, 0x3FD08F23,
/**/                   0x00000000, 0x3FF08000,
/**/                   0x1607EF23, 0x3F6A1156,
/**/                   0x00000000, 0x3FD0A000,
/**/                   0x70D9FA87, 0x3FF0919B,
/**/                   0x0A456C09, 0x3FC27636,
/**/                   0xDA483778, 0x3FCCD541,
/**/                   0x136D6630, 0x3FC0A394,
/**/                   0xBA615E9C, 0x3FC46722,
/**/                   0xA2BC6F73, 0x3FC20AA6,
/**/                   0x7F1D9D86, 0x3CA9D006,
/**/                   0x0F0C1EC8, 0x3FD0D161,
/**/                   0x00000000, 0x3FF08000,
/**/                   0xD9FA8688, 0x3F719B70,
/**/                   0x00000000, 0x3FD0E000,
/**/                   0xD6B3D5D1, 0x3FF09643,
/**/                   0x72641546, 0x3FC2CD1A,
/**/                   0x9D4AC7EC, 0x3FCD189D,
/**/                   0x149C2E66, 0x3FC10AA9,
/**/                   0xD3DE8741, 0x3FC4D51E,
/**/                   0xF6DA4768, 0x3FC29F86,
/**/                   0x828C2A81, 0x3CAEA900,
/**/                   0xC65D88C8, 0x3FD113B0,
/**/                   0x00000000, 0x3FF08000,
/**/                   0xB3D5D119, 0x3F7643D6,
/**/                   0x00000000, 0x3FD12000,
/**/                   0x0F1DF195, 0x3FF09B02,
/**/                   0x5C9E6B3F, 0x3FC324CB,
/**/                   0x0BE228B7, 0x3FCD5D9A,
/**/                   0xD29602B0, 0x3FC173EC,
/**/                   0x0FFA7799, 0x3FC546A7,
/**/                   0x87BA569F, 0x3FC33965,
/**/                   0x9956F2C3, 0xBCAE3258,
/**/                   0x4ADA6FF0, 0x3FD15613,
/**/                   0x00000000, 0x3FF08000,
/**/                   0x1DF1952F, 0x3F7B020F,
/**/                   0x00000000, 0x3FD16000,
/**/                   0x4DD62EB0, 0x3FF09FD6,
/**/                   0xB8335DE5, 0x3FC37D4D,
/**/                   0x04DFA3F1, 0x3FCDA440,
/**/                   0x55E59412, 0x3FC1DF71,
/**/                   0x0394B72E, 0x3FC5BBDA,
/**/                   0xE1177398, 0x3FC3D877,
/**/                   0x3B5720A7, 0x3CA8AC88,
/**/                   0xF43427A8, 0x3FD19888,
/**/                   0x00000000, 0x3FF08000,
/**/                   0xD62EAF85, 0x3F7FD64D,
/**/                   0x00000000, 0x3FD1A000,
/**/                   0xC7D99A5F, 0x3FF0A4C0,
/**/                   0x8F6BB942, 0x3FC3D6A6,
/**/                   0xB06CB8A9, 0x3FCDEC98,
/**/                   0x432C74B1, 0x3FC24D49,
/**/                   0x8C1C6EC6, 0x3FC634D7,
/**/                   0x01BF2560, 0x3FC47CF6,
/**/                   0x476E25C7, 0x3CA3EDE7,
/**/                   0x1AED7720, 0x3FD1DB12,
/**/                   0x00000000, 0x3FF0C000,
/**/                   0x2665A126, 0xBF7B3F38,
/**/                   0x00000000, 0x3FD1E000,
/**/                   0xB36B4C8B, 0x3FF0A9C1,
/**/                   0x0879E39B, 0x3FC430DB,
/**/                   0x82887D8B, 0x3FCE36AD,
/**/                   0xE1B33C79, 0x3FC2BD87,
/**/                   0xDEA4E95E, 0x3FC6B1C0,
/**/                   0x7C90504A, 0x3FC5271A,
/**/                   0x8A6EBD08, 0x3CAAFAD9,
/**/                   0x185FA360, 0x3FD21DAF,
/**/                   0x00000000, 0x3FF0C000,
/**/                   0x94B3751C, 0xBF763E4C,
/**/                   0x00000000, 0x3FD22000,
/**/                   0x481B7EED, 0x3FF0AED9,
/**/                   0x66613BB3, 0x3FC48BF0,
/**/                   0x3D9FDD8F, 0x3FCE8288,
/**/                   0x22470BF2, 0x3FC33041,
/**/                   0x97C5B476, 0x3FC732B8,
/**/                   0x9B614F73, 0x3FC5D722,
/**/                   0x759745C8, 0x3CA96B82,
/**/                   0x46BF95B8, 0x3FD26060,
/**/                   0x00000000, 0x3FF0C000,
/**/                   0xE48112DC, 0xBF7126B7,
/**/                   0x00000000, 0x3FD26000,
/**/                   0xBECEDF0E, 0x3FF0B407,
/**/                   0x09E5699A, 0x3FC4E7EC,
/**/                   0xF541EC2D, 0x3FCED032,
/**/                   0xA6688484, 0x3FC3A589,
/**/                   0xCC5228BD, 0x3FC7B7E2,
/**/                   0x83ECAD1F, 0x3FC68D4E,
/**/                   0x7CB79363, 0x3CA98586,
/**/                   0x01231EC8, 0x3FD2A326,
/**/                   0x00000000, 0x3FF0C000,
/**/                   0x6241E449, 0xBF67F082,
/**/                   0x00000000, 0x3FD2A000,
/**/                   0x51C61D1C, 0x3FF0B94D,
/**/                   0x7281F837, 0x3FC544D3,
/**/                   0x10F19F89, 0x3FCF1FB8,
/**/                   0xC7D08A44, 0x3FC41D76,
/**/                   0x1AF4E5E6, 0x3FC84165,
/**/                   0x5EE5D838, 0x3FC749E1,
/**/                   0xA1F9A890, 0x3C8A2A36,
/**/                   0xA3865760, 0x3FD2E600,
/**/                   0x00000000, 0x3FF0C000,
/**/                   0xE78B8E2F, 0xBF5ACAB8,
/**/                   0x00000000, 0x3FD2E000,
/**/                   0x3CA5B9C1, 0x3FF0BEAA,
/**/                   0x3F6A91D3, 0x3FC5A2AC,
/**/                   0x4F1650DB, 0x3FCF7122,
/**/                   0xA04F63E7, 0x3FC4981E,
/**/                   0xBEBC9B64, 0x3FC8CF66,
/**/                   0x81598BF7, 0x3FC80D21,
/**/                   0x8E0FD320, 0xBC984143,
/**/                   0x8AD12008, 0x3FD328F0,
/**/                   0x00000000, 0x3FF0C000,
/**/                   0xA463F3FD, 0xBF355C35,
/**/                   0x00000000, 0x3FD32000,
/**/                   0xBC7E151A, 0x3FF0C41E,
/**/                   0x30943E19, 0x3FC6017C,
/**/                   0xC80C760D, 0x3FCFC47C,
/**/                   0x120B129D, 0x3FC51598,
/**/                   0xA2A855B5, 0x3FC96210,
/**/                   0x9880230D, 0x3FC8D758,
/**/                   0xBF178596, 0xBCA4D129,
/**/                   0x14DCC050, 0x3FD36BF6,
/**/                   0x00000000, 0x3FF0C000,
/**/                   0xF854661E, 0x3F507AF1,
/**/                   0x00000000, 0x3FD36000,
/**/                   0x0FD3C135, 0x3FF0C9AB,
/**/                   0x27C80482, 0x3FC66149,
/**/                   0x78AC0DDD, 0x3FD00CE9,
/**/                   0xD02204B1, 0x3FC595FA,
/**/                   0x7642750D, 0x3FC9F98D,
/**/                   0xD82AC48A, 0x3FC9A8D3,
/**/                   0x289B3951, 0x3C977587,
/**/                   0xA079A6D8, 0x3FD3AF11,
/**/                   0x00000000, 0x3FF0C000,
/**/                   0xA7826A0D, 0x3F63561F,
/**/                   0x00000000, 0x3FD3A000,
/**/                   0x76A81A69, 0x3FF0CF4F,
/**/                   0x29BF5ACD, 0x3FC6C219,
/**/                   0x507D5DD4, 0x3FD03898,
/**/                   0x67B79439, 0x3FC6195F,
/**/                   0xC35A709F, 0x3FCA9609,
/**/                   0x2BF7455C, 0x3FCA81E4,
/**/                   0xF424551E, 0x3CA03304,
/**/                   0x8D754B40, 0x3FD3F243,
/**/                   0x00000000, 0x3FF0C000,
/**/                   0x5034D2A8, 0x3F6E9EED,
/**/                   0x00000000, 0x3FD3E000,
/**/                   0x3282280D, 0x3FF0D50C,
/**/                   0x5F4ACC23, 0x3FC723F2,
/**/                   0x08771131, 0x3FD06551,
/**/                   0x4970163E, 0x3FC69FDF,
/**/                   0x04EE9A0A, 0x3FCB37B4,
/**/                   0x6B79BC18, 0x3FCB62DE,
/**/                   0x02A2F456, 0x3CAECF25,
/**/                   0x3CA032E0, 0x3FD4358C,
/**/                   0x00000000, 0x3FF0C000,
/**/                   0x82280D28, 0x3F750C32,
/**/                   0x00000000, 0x3FD42000,
/**/                   0x8677C82D, 0x3FF0DAE1,
/**/                   0x16834ABE, 0x3FC786DB,
/**/                   0xF1631731, 0x3FD09319,
/**/                   0xD36297AF, 0x3FC72994,
/**/                   0xBF583888, 0x3FCBDEBC,
/**/                   0x918E2AE6, 0x3FCC4C1B,
/**/                   0xF34A155C, 0x3CA92F70,
/**/                   0x0FD419C8, 0x3FD478EC,
/**/                   0x00000000, 0x3FF0C000,
/**/                   0x77C82D53, 0x3F7AE186,
/**/                   0x00000000, 0x3FD46000,
/**/                   0xB73728F8, 0x3FF0E0CF,
/**/                   0xC406A36A, 0x3FC7EAD9,
/**/                   0x91BDA616, 0x3FD0C1F9,
/**/                   0x5B86C42B, 0x3FC7B69B,
/**/                   0x99CD8C9F, 0x3FCC8B56,
/**/                   0xF7084936, 0x3FCD3DF8,
/**/                   0x54942387, 0xBC923B74,
/**/                   0x69FA40E8, 0x3FD4BC63,
/**/                   0x00000000, 0x3FF10000,
/**/                   0xC8D707BB, 0xBF7F3048,
/**/                   0x00000000, 0x3FD4A000,
/**/                   0x0B1092B8, 0x3FF0E6D7,
/**/                   0x043F9011, 0x3FC84FF5,
/**/                   0xA7AFD6EB, 0x3FD0F1F6,
/**/                   0x3AA5D7B9, 0x3FC8470F,
/**/                   0x794E9CFD, 0x3FCD3DB6,
/**/                   0x90FB69FD, 0x3FCE38D8,
/**/                   0xC2327DC5, 0x3C9CFA2D,
/**/                   0xAF11E2C0, 0x3FD4FFF2,
/**/                   0x00000000, 0x3FF10000,
/**/                   0xEF6D4848, 0xBF7928F4,
/**/                   0x00000000, 0x3FD4E000,
/**/                   0xCA008550, 0x3FF0ECF7,
/**/                   0x9CB9ECA7, 0x3FC8B633,
/**/                   0x2B20AC3D, 0x3FD12318,
/**/                   0xD7D5E860, 0x3FC8DB0D,
/**/                   0x9D1315AF, 0x3FCDF613,
/**/                   0x32D8BC6F, 0x3FCF3D21,
/**/                   0x92E48EEE, 0x3C9C6A36,
/**/                   0x4436D008, 0x3FD5439A,
/**/                   0x00000000, 0x3FF10000,
/**/                   0xFF7AAF92, 0xBF730835,
/**/                   0x00000000, 0x3FD52000,
/**/                   0x3DBA2C62, 0x3FF0F332,
/**/                   0x7D83983C, 0x3FC91D9C,
/**/                   0x4FDDA02E, 0x3FD15565,
/**/                   0xB48747C7, 0x3FC972B5,
/**/                   0xBC9105F9, 0x3FCEB4A7,
/**/                   0x6A535ECF, 0x3FD0259F,
/**/                   0xF6EA55C1, 0x3C87EB36,
/**/                   0x8FA83538, 0x3FD5875A,
/**/                   0x00000000, 0x3FF10000,
/**/                   0x8BA73C6A, 0xBF699B84,
/**/                   0x00000000, 0x3FD56000,
/**/                   0xB1B22D42, 0x3FF0F986,
/**/                   0xC29A92ED, 0x3FC98636,
/**/                   0x87DBE62D, 0x3FD188E5,
/**/                   0x792C37EB, 0x3FCA0E26,
/**/                   0x2735E8CD, 0x3FCF79AF,
/**/                   0x6ECCD4C0, 0x3FD0B1D1,
/**/                   0xBEAE0510, 0x3C9502B5,
/**/                   0xF8CF8AC0, 0x3FD5CB33,
/**/                   0x00000000, 0x3FF10000,
/**/                   0x374AF74C, 0xBF59E539,
/**/                   0x00000000, 0x3FD5A000,
/**/                   0x7329D23A, 0x3FF0FFF5,
/**/                   0xB568F082, 0x3FC9F009,
/**/                   0x85939DB2, 0x3FD1BDA0,
/**/                   0x0283B18A, 0x3FCAAD81,
/**/                   0x72F69148, 0x3FD022B4,
/**/                   0x39AD0B79, 0x3FD14362,
/**/                   0x80828B86, 0xBCAD7968,
/**/                   0xE847B130, 0x3FD60F26,
/**/                   0x00000000, 0x3FF10000,
/**/                   0x5B8BC081, 0xBEE519AC,
/**/                   0x00000000, 0x3FD5E000,
/**/                   0xD13A9687, 0x3FF1067E,
/**/                   0xCE4F3F61, 0x3FCA5B1C,
/**/                   0x3E764545, 0x3FD1F39E,
/**/                   0x6F90871B, 0x3FCB50E7,
/**/                   0x6F487F97, 0x3FD08C0B,
/**/                   0x67265C20, 0x3FD1DA90,
/**/                   0x995723AD, 0x3CAE5B02,
/**/                   0xC7E43AA0, 0x3FD65333,
/**/                   0x00000000, 0x3FF10000,
/**/                   0xEA5A1D64, 0x3F59FB44,
/**/                   0x00000000, 0x3FD62000,
/**/                   0x1CE216D9, 0x3FF10D23,
/**/                   0xB63E0B53, 0x3FCAC777,
/**/                   0xED81D055, 0x3FD22AE6,
/**/                   0x3046C5AC, 0x3FCBF87D,
/**/                   0xFCB29FE4, 0x3FD0F8FE,
/**/                   0xC99A404E, 0x3FD2779D,
/**/                   0xC3202AE8, 0xBCA2AF1E,
/**/                   0x02B8E378, 0x3FD6975B,
/**/                   0x00000000, 0x3FF10000,
/**/                   0xC42DB2AB, 0x3F6A4639,
/**/                   0x00000000, 0x3FD66000,
/**/                   0xA90E6A24, 0x3FF113E2,
/**/                   0x485F2C6B, 0x3FCB3522,
/**/                   0x15F1D6CC, 0x3FD26383,
/**/                   0x14F9D555, 0x3FCCA467,
/**/                   0x245E397E, 0x3FD169B3,
/**/                   0x99479CF7, 0x3FD31ACF,
/**/                   0x8992C228, 0xBC730D3F,
/**/                   0x05213B28, 0x3FD6DB9D,
/**/                   0x00000000, 0x3FF10000,
/**/                   0x0E6A2469, 0x3F73E2A9,
/**/                   0x00000000, 0x3FD6A000,
/**/                   0xCAAAE6D5, 0x3FF11ABD,
/**/                   0x93CF9B23, 0x3FCBA424,
/**/                   0x86106AD4, 0x3FD29D7B,
/**/                   0x5E96870B, 0x3FCD54CB,
/**/                   0x9975D46D, 0x3FD1DE4D,
/**/                   0xA709F8A4, 0x3FD3C46E,
/**/                   0x457B6F5C, 0xBC9CB630,
/**/                   0x3CC87FC8, 0x3FD71FFA,
/**/                   0x00000000, 0x3FF10000,
/**/                   0xAAE6D53D, 0x3F7ABDCA,
/**/                   0x00000000, 0x3FD6E000,
/**/                   0xD8AD589E, 0x3FF121B4,
/**/                   0xDD6A8C89, 0x3FCC1486,
/**/                   0x5A283891, 0x3FD2D8D9,
/**/                   0xCFB4F5A1, 0x3FCE09D1,
/**/                   0xCF594BB6, 0x3FD256F5,
/**/                   0x92614C29, 0x3FD474C7,
/**/                   0x533051E9, 0xBC88FB31,
/**/                   0x18B1AD28, 0x3FD76473,
/**/                   0x00000000, 0x3FF14000,
/**/                   0x52A761D6, 0xBF7E4B27,
/**/                   0x00000000, 0x3FD72000,
/**/                   0x2C23AB4A, 0x3FF128C8,
/**/                   0xA1A6A356, 0x3FCC8651,
/**/                   0xFF99ABE3, 0x3FD315A5,
/**/                   0xBE8EE4C2, 0x3FCEC3A3,
/**/                   0x11207D5D, 0x3FD2D3D5,
/**/                   0x02FE6DF8, 0x3FD52C2B,
/**/                   0xFE4D8DF3, 0xBCA3F304,
/**/                   0x093FC1F0, 0x3FD7A908,
/**/                   0x00000000, 0x3FF14000,
/**/                   0xDC54B622, 0xBF7737D3,
/**/                   0x00000000, 0x3FD76000,
/**/                   0x20420F33, 0x3FF12FF8,
/**/                   0x96860D89, 0x3FCCF98D,
/**/                   0x3814F292, 0x3FD353EB,
/**/                   0x27E81BF7, 0x3FCF826C,
/**/                   0x9A827352, 0x3FD35516,
/**/                   0xE614C6DF, 0x3FD5EAED,
/**/                   0x36C1700C, 0x3C80AEDB,
/**/                   0x803E3C28, 0x3FD7EDB9,
/**/                   0x00000000, 0x3FF14000,
/**/                   0xBDF0CCC6, 0xBF7007DF,
/**/                   0x00000000, 0x3FD7A000,
/**/                   0x12719C3A, 0x3FF13745,
/**/                   0xAD9A717F, 0x3FCD6E43,
/**/                   0x1CFACD12, 0x3FD393B3,
/**/                   0xE17B8F05, 0x3FD0232B,
/**/                   0xB23873BC, 0x3FD3DAE7,
/**/                   0xAFB712E5, 0x3FD6B169,
/**/                   0x0BC74599, 0x3C994C0C,
/**/                   0xF0E9CF80, 0x3FD83287,
/**/                   0x00000000, 0x3FF14000,
/**/                   0x1CC78CA5, 0xBF6175DB,
/**/                   0x00000000, 0x3FD7E000,
/**/                   0x625F7844, 0x3FF13EAF,
/**/                   0x161D9978, 0x3FCDE47D,
/**/                   0x22E63DCA, 0x3FD3D508,
/**/                   0x8B2EC7EB, 0x3FD087CA,
/**/                   0xC5F619C8, 0x3FD46577,
/**/                   0xA08A73DE, 0x3FD77FFC,
/**/                   0x6E7B547F, 0x3CA1DBDE,
/**/                   0xCFF956F8, 0x3FD87773,
/**/                   0x00000000, 0x3FF14000,
/**/                   0x087BC752, 0xBF3509DA,
/**/                   0x00000000, 0x3FD82000,
/**/                   0x720C869D, 0x3FF14637,
/**/                   0x3F1FD940, 0x3FCE5C43,
/**/                   0x1D614654, 0x3FD417F5,
/**/                   0x472052ED, 0x3FD0EF2A,
/**/                   0x88116DA6, 0x3FD4F4F8,
/**/                   0x102117B6, 0x3FD8570A,
/**/                   0x214A7328, 0xBCAB6E89,
/**/                   0x93A70458, 0x3FD8BC7D,
/**/                   0x00000000, 0x3FF14000,
/**/                   0x321A7479, 0x3F58DDC8,
/**/                   0x00000000, 0x3FD86000,
/**/                   0xA5DDA5C4, 0x3FF14DDD,
/**/                   0xD9CD3739, 0x3FCED59F,
/**/                   0x42C70412, 0x3FD45C85,
/**/                   0x49C983A8, 0x3FD15964,
/**/                   0x0EF7ED0B, 0x3FD5899E,
/**/                   0xBC543499, 0x3FD936FA,
/**/                   0x7B29F22E, 0x3CAFF50D,
/**/                   0xB3B9CF50, 0x3FD901A5,
/**/                   0x00000000, 0x3FF14000,
/**/                   0xBB4B87E0, 0x3F6BBB4B,
/**/                   0x00000000, 0x3FD8A000,
/**/                   0x64AC8172, 0x3FF155A2,
/**/                   0xDBCA7047, 0x3FCF509C,
/**/                   0x3055A16F, 0x3FD4A2C4,
/**/                   0xD25160C7, 0x3FD1C692,
/**/                   0xF68F9906, 0x3FD6239E,
/**/                   0x1DFC2EE2, 0x3FDA203D,
/**/                   0x671EF39F, 0x3CAD2019,
/**/                   0xA98F2718, 0x3FD946EC,
/**/                   0x00000000, 0x3FF14000,
/**/                   0xAC8171A9, 0x3F75A264,
/**/                   0x00000000, 0x3FD8E000,
/**/                   0x17D8FF02, 0x3FF15D86,
/**/                   0x81AAFD5E, 0x3FCFCD44,
/**/                   0xEE72B776, 0x3FD4EABD,
/**/                   0x377F943F, 0x3FD236D1,
/**/                   0x83A56DB7, 0x3FD6C334,
/**/                   0xC36D6C50, 0x3FDB1345,
/**/                   0x761537BB, 0xBC7841E5,
/**/                   0xF024E808, 0x3FD98C52,
/**/                   0x00000000, 0x3FF14000,
/**/                   0xD8FF01DE, 0x3F7D8617,
/**/                   0x00000000, 0x3FD92000,
/**/                   0x2B5B4A9A, 0x3FF16589,
/**/                   0xA8C0A8C6, 0x3FD025D0,
/**/                   0xF524E4B6, 0x3FD5347E,
/**/                   0xF565EDBD, 0x3FD2AA3B,
/**/                   0xC98D2842, 0x3FD7689A,
/**/                   0xB128B4DD, 0x3FDC108F,
/**/                   0x4452A669, 0xBC8A5EEB,
/**/                   0x04239878, 0x3FD9D1D9,
/**/                   0x00000000, 0x3FF18000,
/**/                   0xA4B56661, 0xBF7A76D4,
/**/                   0x00000000, 0x3FD96000,
/**/                   0x0DD68BC8, 0x3FF16DAC,
/**/                   0x0EC54C3A, 0x3FD065DF,
/**/                   0x30C58A12, 0x3FD58014,
/**/                   0xBBCBCCEF, 0x3FD320F0,
/**/                   0xD218F380, 0x3FD81410,
/**/                   0xC9371D29, 0x3FDD189C,
/**/                   0x1D6E6EC7, 0x3C58C3C1,
/**/                   0x63E8EF18, 0x3FDA177F,
/**/                   0x00000000, 0x3FF18000,
/**/                   0x29743866, 0xBF7253F2,
/**/                   0x00000000, 0x3FD9A000,
/**/                   0x30AC48A8, 0x3FF175EF,
/**/                   0x037BA7C0, 0x3FD0A6D3,
/**/                   0x06EDCD18, 0x3FD5CD8B,
/**/                   0x7D679188, 0x3FD39B0E,
/**/                   0xC8128143, 0x3FD8C5D8,
/**/                   0x39B3613A, 0x3FDE2BF6,
/**/                   0xC70C9C76, 0xBC874080,
/**/                   0x8F92A560, 0x3FDA5D46,
/**/                   0x00000000, 0x3FF18000,
/**/                   0xA76EB06E, 0xBF64219E,
/**/                   0x00000000, 0x3FD9E000,
/**/                   0x08107EEF, 0x3FF17E53,
/**/                   0x40691386, 0x3FD0E8B2,
/**/                   0x5BA2319A, 0x3FD61CF1,
/**/                   0x7FF30656, 0x3FD418B5,
/**/                   0x24624146, 0x3FD97E38,
/**/                   0xF30D6589, 0x3FDF4B2C,
/**/                   0x74DD0C9B, 0xBC8D4AD9,
/**/                   0x090998F8, 0x3FDAA32F,
/**/                   0x00000000, 0x3FF18000,
/**/                   0xF81116BC, 0xBF3ACF7E,
/**/                   0x00000000, 0x3FDA2000,
/**/                   0x0B1E7A9D, 0x3FF186D8,
/**/                   0xA98356F0, 0x3FD12B82,
/**/                   0x96C051D8, 0x3FD66E55,
/**/                   0x6D28A49D, 0x3FD49A07,
/**/                   0xDE14D616, 0x3FDA3D77,
/**/                   0x13502F53, 0x3FE03B6D,
/**/                   0x4AD59707, 0x3CA51700,
/**/                   0x540D3F08, 0x3FDAE939,
/**/                   0x00000000, 0x3FF18000,
/**/                   0x79EA752F, 0x3F5B602C,
/**/                   0x00000000, 0x3FDA6000,
/**/                   0xB3EE7285, 0x3FF18F7E,
/**/                   0x4EC4AF40, 0x3FD16F4A,
/**/                   0xA9B275FD, 0x3FD6C1C6,
/**/                   0x64B886B9, 0x3FD51F27,
/**/                   0x9D72A144, 0x3FDB03E4,
/**/                   0xE7207DD5, 0x3FE0D7CF,
/**/                   0x8E77D1B2, 0xBCAACE1E,
/**/                   0xF63F6C78, 0x3FDB2F65,
/**/                   0x00000000, 0x3FF18000,
/**/                   0xDCE509F5, 0x3F6EFD67,
/**/                   0x00000000, 0x3FDAA000,
/**/                   0x7FABF325, 0x3FF19847,
/**/                   0x6DD15EDB, 0x3FD1B40F,
/**/                   0x156D090D, 0x3FD71754,
/**/                   0x0F44EE42, 0x3FD5A83A,
/**/                   0xF26149CC, 0x3FDBD1CE,
/**/                   0x9EBB7D53, 0x3FE17B14,
/**/                   0x054C177A, 0x3CA18867,
/**/                   0x773075F8, 0x3FDB75B5,
/**/                   0x00000000, 0x3FF18000,
/**/                   0xABF3257B, 0x3F78477F,
/**/                   0x00000000, 0x3FDAE000,
/**/                   0xEEAD20E6, 0x3FF1A132,
/**/                   0x73AFA8F4, 0x3FD1F9D8,
/**/                   0xF0BA2B44, 0x3FD76F0D,
/**/                   0xB2776412, 0x3FD63565,
/**/                   0x8E4B8181, 0x3FDCA78B,
/**/                   0xDE92725A, 0x3FE22595,
/**/                   0x225EE470, 0xBCABDA45,
/**/                   0x606BABE0, 0x3FDBBC28,
/**/                   0x00000000, 0x3FF1C000,
/**/                   0x52DF1A7E, 0xBF7ECD11,
/**/                   0x00000000, 0x3FDB2000,
/**/                   0x848ADB16, 0x3FF1AA41,
/**/                   0xFE932ABB, 0x3FD240AB,
/**/                   0xEED7E85D, 0x3FD7C904,
/**/                   0x4640B1B3, 0x3FD6C6D2,
/**/                   0x81D01020, 0x3FDD8573,
/**/                   0x9938B939, 0x3FE2D7B3,
/**/                   0x36D76E02, 0x3CA12ECB,
/**/                   0x3D843430, 0x3FDC02BF,
/**/                   0x00000000, 0x3FF1C000,
/**/                   0x7524EA70, 0xBF75BE7B,
/**/                   0x00000000, 0x3FDB6000,
/**/                   0xC839C9AC, 0x3FF1B373,
/**/                   0xDFBC912D, 0x3FD28890,
/**/                   0x666DE3CA, 0x3FD8254A,
/**/                   0x8B57457C, 0x3FD75CA9,
/**/                   0x7E7E55FE, 0x3FDE6BE4,
/**/                   0x68EC3777, 0x3FE391D3,
/**/                   0x4D8A80A5, 0xBC9F7EFE,
/**/                   0x9C2247A0, 0x3FDC497A,
/**/                   0x00000000, 0x3FF1C000,
/**/                   0x8C6CA8A7, 0xBF69186F,
/**/                   0x00000000, 0x3FDBA000,
/**/                   0x44246029, 0x3FF1BCCA,
/**/                   0x1D6EB966, 0x3FD2D18E,
/**/                   0x58DF9E20, 0x3FD883F0,
/**/                   0x2308FF84, 0x3FD7F717,
/**/                   0x1CEC1692, 0x3FDF5B41,
/**/                   0xEFAE7F7E, 0x3FE45460,
/**/                   0xC247C281, 0xBCACA88A,
/**/                   0x0C10D428, 0x3FDC905B,
/**/                   0x00000000, 0x3FF1C000,
/**/                   0xDCFEB6F6, 0xBF49ADDE,
/**/                   0x00000000, 0x3FDBE000,
/**/                   0x8645E0A6, 0x3FF1C645,
/**/                   0xF4FA598C, 0x3FD31BAA,
/**/                   0x7A00CDBD, 0x3FD8E509,
/**/                   0xA876EFA4, 0x3FD89648,
/**/                   0x93BB3BA0, 0x3FE029F8,
/**/                   0x3E769492, 0x3FE51FCE,
/**/                   0xDAC78BA6, 0xBC63BD0A,
/**/                   0x1F4B8A08, 0x3FDCD761,
/**/                   0x00000000, 0x3FF1C000,
/**/                   0x178298DB, 0x3F591619,
/**/                   0x00000000, 0x3FDC2000,
/**/                   0x20466A93, 0x3FF1CFE6,
/**/                   0xDCE16113, 0x3FD366EE,
/**/                   0x3831A262, 0x3FD948A9,
/**/                   0xCB5336B7, 0x3FD93A6D,
/**/                   0xF50362A5, 0x3FE0AB30,
/**/                   0x440F45E4, 0x3FE5F494,
/**/                   0x79A811B8, 0xBCA1B23F,
/**/                   0x6A0D56C8, 0x3FDD1E8D,
/**/                   0x00000000, 0x3FF1C000,
/**/                   0x8CD52690, 0x3F6FCC40,
/**/                   0x00000000, 0x3FDC6000,
/**/                   0xA798215A, 0x3FF1D9AC,
/**/                   0x87135170, 0x3FD3B361,
/**/                   0xC4E92F90, 0x3FD9AEE3,
/**/                   0x6C3B0A06, 0x3FD9E3B8,
/**/                   0x439D6983, 0x3FE13183,
/**/                   0x444347EE, 0x3FE6D333,
/**/                   0x141D7ADE, 0x3C9E6687,
/**/                   0x82DF5278, 0x3FDD65E0,
/**/                   0x00000000, 0x3FF1C000,
/**/                   0x98215A4D, 0x3F79ACA7,
/**/                   0x00000000, 0x3FDCA000,
/**/                   0xB59577B1, 0x3FF1E399,
/**/                   0xE343E389, 0x3FD4010A,
/**/                   0x1DB4A57B, 0x3FDA17CE,
/**/                   0xBAC8CA27, 0x3FDA925C,
/**/                   0x29AC5009, 0x3FE1BD2C,
/**/                   0x5806ABBE, 0x3FE7BC33,
/**/                   0xD953CBEA, 0x3C89743A,
/**/                   0x02A82420, 0x3FDDAD5B,
/**/                   0x00000000, 0x3FF20000,
/**/                   0x6A884EAF, 0xBF7C664A,
/**/                   0x00000000, 0x3FDCE000,
/**/                   0xE7A0AD1E, 0x3FF1EDAD,
/**/                   0x215D62D8, 0x3FD44FF3,
/**/                   0x15B2742E, 0x3FDA837E,
/**/                   0x557C3A62, 0x3FDB4691,
/**/                   0x9ABECCA0, 0x3FE24E6B,
/**/                   0xF75D3619, 0x3FE8B024,
/**/                   0x953C1F21, 0xBC60A42B,
/**/                   0x84BBE168, 0x3FDDF4FD,
/**/                   0x00000000, 0x3FF20000,
/**/                   0x5F52E269, 0xBF725218,
/**/                   0x00000000, 0x3FDD2000,
/**/                   0xDF448BE1, 0x3FF1F7E9,
/**/                   0xB4103D45, 0x3FD4A022,
/**/                   0x5F90F152, 0x3FDAF20A,
/**/                   0x6B992E26, 0x3FDC008F,
/**/                   0x07C18F30, 0x3FE2E585,
/**/                   0x8DCE89C2, 0x3FE9AFA1,
/**/                   0xE5B4E0DD, 0xBC8B90A5,
/**/                   0xA6EC6EF0, 0x3FDE3CC8,
/**/                   0x00000000, 0x3FF20000,
/**/                   0x76E83DEE, 0xBF602C41,
/**/                   0x00000000, 0x3FDD6000,
/**/                   0x42567651, 0x3FF2024E,
/**/                   0x53815E48, 0x3FD4F1A2,
/**/                   0x98189F26, 0x3FDB638A,
/**/                   0xE11F7BB9, 0x3FDCC092,
/**/                   0x968E1C3C, 0x3FE382BF,
/**/                   0x1A4C4551, 0x3FEABB4C,
/**/                   0xC65EE1E9, 0xBCAC384D,
/**/                   0x099A6620, 0x3FDE84BD,
/**/                   0x00000000, 0x3FF20000,
/**/                   0xB3B2877E, 0x3F427212,
/**/                   0x00000000, 0x3FDDA000,
/**/                   0xBB19D366, 0x3FF20CDB,
/**/                   0x00190520, 0x3FD5447B,
/**/                   0x514AC3D7, 0x3FDBD817,
/**/                   0x7501B24E, 0x3FDD86DA,
/**/                   0x5D5DCC91, 0x3FE42666,
/**/                   0xDB834BBA, 0x3FEBD3D1,
/**/                   0x64307FE4, 0xBCA62892,
/**/                   0x4FC685E0, 0x3FDECCDB,
/**/                   0x00000000, 0x3FF20000,
/**/                   0x33A6CD00, 0x3F69B776,
/**/                   0x00000000, 0x3FDDE000,
/**/                   0xF864EB38, 0x3FF21792,
/**/                   0x0573E0CA, 0x3FD598B6,
/**/                   0x1E1D9C05, 0x3FDC4FCA,
/**/                   0xE9C2FB44, 0x3FDE53A7,
/**/                   0xA26E99AF, 0x3FE4D0C8,
/**/                   0x09A8A359, 0x3FECF9EB,
/**/                   0xD9AFA9E0, 0xBCADF861,
/**/                   0x1F23B3F8, 0x3FDF1524,
/**/                   0x00000000, 0x3FF20000,
/**/                   0x64EB3836, 0x3F7792F8,
/**/                   0x00000000, 0x3FDE2000,
/**/                   0xADC744F8, 0x3FF22274,
/**/                   0xFD785957, 0x3FD5EE5C,
/**/                   0x9EE01B3A, 0x3FDCCABD,
/**/                   0x30A7B7B5, 0x3FDF2740,
/**/                   0x202E0D0D, 0x3FE5823A,
/**/                   0x9EEBE829, 0x3FEE2E5B,
/**/                   0xE2EA9787, 0xBC93BB42,
/**/                   0x202994B8, 0x3FDF5D98,
/**/                   0x00000000, 0x3FF24000,
/**/                   0x38BB0864, 0xBF7D8B52,
/**/                   0x00000000, 0x3FDE6000,
/**/                   0x93B1990A, 0x3FF22D81,
/**/                   0xD3920D0F, 0x3FD64579,
/**/                   0x8E4FE1FE, 0x3FDD490D,
/**/                   0xCBD3ED59, 0x3FE000F5,
/**/                   0x4E45F774, 0x3FE63B13,
/**/                   0x2FD578CE, 0x3FEF71F4,
/**/                   0xC0E1AC47, 0x3CA8AD1C,
/**/                   0xFE27BF60, 0x3FDFA637,
/**/                   0x00000000, 0x3FF24000,
/**/                   0x4E66F5A1, 0xBF727E6C,
/**/                   0x00000000, 0x3FDEA000,
/**/                   0x679F6AE1, 0x3FF238BA,
/**/                   0xC815A8F5, 0x3FD69E16,
/**/                   0xCF6CD4C9, 0x3FDDCAD6,
/**/                   0xFD2ADE38, 0x3FE071FA,
/**/                   0xAFEE9630, 0x3FE6FBB1,
/**/                   0x6A7ACB82, 0x3FF062C9,
/**/                   0x35D3555B, 0x3C7E3580,
/**/                   0x67599588, 0x3FDFEF04,
/**/                   0x00000000, 0x3FF24000,
/**/                   0x82547B6F, 0xBF5D1661,
/**/                   0x00000000, 0x3FDEE000,
/**/                   0xEC425F4B, 0x3FF2441F,
/**/                   0x73CF67B4, 0x3FD6F83E,
/**/                   0x7C1691BA, 0x3FDE5037,
/**/                   0x7AF8190E, 0x3FE0E6D7,
/**/                   0x27F29078, 0x3FE7C478,
/**/                   0x13B5FFDC, 0x3FF11512,
/**/                   0x5FEBA301, 0x3C6CC7A1,
/**/                   0x067D6224, 0x3FE01BFF,
/**/                   0x00000000, 0x3FF24000,
/**/                   0x097D2BDC, 0x3F507FB1,
/**/                   0x00000000, 0x3FDF2000,
/**/                   0xE9AF6533, 0x3FF24FB2,
/**/                   0xCBBEA804, 0x3FD753FB,
/**/                   0xF480E731, 0x3FDED94E,
/**/                   0x106D90C6, 0x3FE15FB5,
/**/                   0x52DAD430, 0x3FE895CF,
/**/                   0x28FAAE13, 0x3FF1D052,
/**/                   0xE849F35A, 0xBCA50976,
/**/                   0xD1AE3B48, 0x3FE04092,
/**/                   0x00000000, 0x3FF24000,
/**/                   0x5ECA665D, 0x3F6F65D3,
/**/                   0x00000000, 0x3FDF6000,
/**/                   0x2D8DC7FA, 0x3FF25B74,
/**/                   0x25013475, 0x3FD7B15A,
/**/                   0xEF8D6387, 0x3FDF663D,
/**/                   0xA2DF4BFF, 0x3FE1DCBF,
/**/                   0xE7C2E4E5, 0x3FE97025,
/**/                   0x1C2AE4AB, 0x3FF29510,
/**/                   0xB02A3D13, 0x3CA4C8DC,
/**/                   0xF0FD9FD8, 0x3FE0653D,
/**/                   0x00000000, 0x3FF24000,
/**/                   0x8DC7FA40, 0x3F7B742D,
/**/                   0x00000000, 0x3FDFA000,
/**/                   0x8B4843F2, 0x3FF26764,
/**/                   0x38F10257, 0x3FD81065,
/**/                   0x8C1920B1, 0x3FDFF726,
/**/                   0x5148D4E4, 0x3FE25E25,
/**/                   0x2061C3FE, 0x3FEA53F1,
/**/                   0x5B9300E5, 0x3FF363DB,
/**/                   0x624B8B97, 0xBCA47774,
/**/                   0xC1CAE338, 0x3FE08A00,
/**/                   0x00000000, 0x3FF28000,
/**/                   0xB7BC0E50, 0xBF789B74,
/**/                   0x00000000, 0x3FDFE000,
/**/                   0xDC4036F2, 0x3FF27384,
/**/                   0x29775C8F, 0x3FD87129,
/**/                   0x31A78776, 0x3FE04616,
/**/                   0x95EE0C65, 0x3FE2E416,
/**/                   0x28E05161, 0x3FEB41AD,
/**/                   0xFF1DF849, 0x3FF43D4C,
/**/                   0xBABBA919, 0x3CA5941C,
/**/                   0xA3221C1C, 0x3FE0AEDB,
/**/                   0x00000000, 0x3FF28000,
/**/                   0x7F921C27, 0xBF68F647,
/**/                   0x00000000, 0x3FE01000,
/**/                   0x00030888, 0x3FF27FD6,
/**/                   0x8598A1B5, 0x3FD8D3B2,
/**/                   0x4E0BC755, 0x3FE092BA,
/**/                   0x6A428EEC, 0x3FE36EC6,
/**/                   0x44F514C9, 0x3FEC39C0,
/**/                   0x18C4EF3A, 0x3FF52205,
/**/                   0xA852F235, 0x4000C1D1,
/**/                   0xD00F64B8, 0x3CA78082,
/**/                   0xF5C846F8, 0x3FE0D3CE,
/**/                   0x00000000, 0x3FF28000,
/**/                   0x7BBC39DF, 0xBF04FFFE,
/**/                   0x00000000, 0x3FE03000,
/**/                   0xDC81E6D7, 0x3FF28C58,
/**/                   0x4E3BF356, 0x3FD9380E,
/**/                   0xFFC646A7, 0x3FE0E192,
/**/                   0x6D34756D, 0x3FE3FE6A,
/**/                   0x139ABC91, 0x3FED3CEF,
/**/                   0xF80111C0, 0x3FF612B8,
/**/                   0x3467C688, 0x4001A33C,
/**/                   0x34F59445, 0xBC8A9954,
/**/                   0x1C47D550, 0x3FE0F8DB,
/**/                   0x00000000, 0x3FF28000,
/**/                   0x03CDAE3F, 0x3F68B1B9,
/**/                   0x00000000, 0x3FE05000,
/**/                   0x5E4BF713, 0x3FF2990E,
/**/                   0xFB326E9E, 0x3FD99E49,
/**/                   0x8779391A, 0x3FE132B4,
/**/                   0x0C2FE325, 0x3FE4933B,
/**/                   0xAEAAE1D0, 0x3FEE4BB1,
/**/                   0x1F4377BD, 0x3FF71020,
/**/                   0x1C886605, 0x40029271,
/**/                   0x7130CE99, 0xBCA33AB1,
/**/                   0x7AFDAF10, 0x3FE11E00,
/**/                   0x00000000, 0x3FF28000,
/**/                   0x4BF712C7, 0x3F790E5E,
/**/                   0x00000000, 0x3FE07000,
/**/                   0x78CB1A3B, 0x3FF2A5F7,
/**/                   0x8081C5D1, 0x3FDA0673,
/**/                   0x0D5E6499, 0x3FE18634,
/**/                   0xAEDD6BE6, 0x3FE52D73,
/**/                   0x1CF1AAA0, 0x3FEF66A5,
/**/                   0x4834E5A9, 0x3FF81B02,
/**/                   0xFCE48906, 0x40039066,
/**/                   0x6BFB4C85, 0xBCA34E4F,
/**/                   0x7826AAD4, 0x3FE1433F,
/**/                   0x00000000, 0x3FF2C000,
/**/                   0x34E5C574, 0xBF7A0887,
/**/                   0x00000000, 0x3FE09000,
/**/                   0x268368DB, 0x3FF2B315,
/**/                   0x53F655B7, 0x3FDA7099,
/**/                   0xAD9032EC, 0x3FE1DC27,
/**/                   0xE5F88E23, 0x3FE5CD52,
/**/                   0x0A68BDFC, 0x3FF04738,
/**/                   0x2F057820, 0x3FF93435,
/**/                   0xDAE8A2FC, 0x40049E27,
/**/                   0xFAA44565, 0x3C86832C,
/**/                   0x7BED8260, 0x3FE16898,
/**/                   0x00000000, 0x3FF2C000,
/**/                   0xF92E4A41, 0xBF69D5B2,
/**/                   0x00000000, 0x3FE0B000,
/**/                   0x69558A9E, 0x3FF2C068,
/**/                   0x73011B64, 0x3FDADCCA,
/**/                   0x8511146A, 0x3FE234A6,
/**/                   0x9D6CBF3C, 0x3FE6731A,
/**/                   0xD575F00A, 0x3FF0E1E1,
/**/                   0xADEA17E7, 0x3FFA5C9D,
/**/                   0xD9123E7C, 0x4005BCD2,
/**/                   0xCC2AE1E4, 0xBCA23E4F,
/**/                   0xF07948F0, 0x3FE18E0B,
/**/                   0x00000000, 0x3FF2C000,
/**/                   0x62A7614A, 0x3F1A1A55,
/**/                   0x00000000, 0x3FE0D000,
/**/                   0x4AC410C6, 0x3FF2CDF2,
/**/                   0x68E63D97, 0x3FDB4B16,
/**/                   0xBFA256B2, 0x3FE28FC8,
/**/                   0x51FDF05A, 0x3FE71F10,
/**/                   0x0753C882, 0x3FF183AE,
/**/                   0xF1921090, 0x3FFB9530,
/**/                   0x14F942BC, 0x4006ED9E,
/**/                   0x89C77FA3, 0x3CA27879,
/**/                   0x41FC691C, 0x3FE1B39A,
/**/                   0x00000000, 0x3FF2C000,
/**/                   0x88218CD6, 0x3F6BE495,
/**/                   0x00000000, 0x3FE0F000,
/**/                   0xDC3BFD25, 0x3FF2DBB3,
/**/                   0x55413207, 0x3FDBBB8D,
/**/                   0xA6792BF1, 0x3FE2EDA7,
/**/                   0x4AC4E230, 0x3FE7D17D,
/**/                   0xAAE6CB05, 0x3FF22D00,
/**/                   0xC9028E71, 0x3FFCDEF5,
/**/                   0xB40C626C, 0x400831D8,
/**/                   0x9873F484, 0x3C953FEF,
/**/                   0xDEC430C0, 0x3FE1D943,
/**/                   0x00000000, 0x3FF2C000,
/**/                   0x3BFD24A1, 0x3F7BB3DC,
/**/                   0x00000000, 0x3FE11000,
/**/                   0x3760A19B, 0x3FF2E9AE,
/**/                   0xF2E3E2EB, 0x3FDC2E3F,
/**/                   0xAFE1CD38, 0x3FE34E5D,
/**/                   0xD6CE0B26, 0x3FE88AAE,
/**/                   0x2C4B06C6, 0x3FF2DE44,
/**/                   0x138813D2, 0x3FFE3B06,
/**/                   0x23FD5612, 0x40098AED,
/**/                   0xB7AF0E54, 0xBC91EC19,
/**/                   0x3748F114, 0x3FE1FF09,
/**/                   0x00000000, 0x3FF30000,
/**/                   0x9F5E657E, 0xBF7651C8,
/**/                   0x00000000, 0x3FE13000,
/**/                   0x7E5B072B, 0x3FF2F7E2,
/**/                   0x9F169C4D, 0x3FDCA33F,
/**/                   0x8FE1EB56, 0x3FE3B206,
/**/                   0x8F30E1B7, 0x3FE94AF6,
/**/                   0xCFCF9887, 0x3FF397E9,
/**/                   0x4FB7F25F, 0x3FFFAA90,
/**/                   0x94745D90, 0x400AFA63,
/**/                   0x2A139390, 0x3C96955C,
/**/                   0xBE3EBA20, 0x3FE224EA,
/**/                   0x00000000, 0x3FF30000,
/**/                   0x49F1AA85, 0xBF603B03,
/**/                   0x00000000, 0x3FE15000,
/**/                   0xDC2D0E76, 0x3FF30651,
/**/                   0x613EF408, 0x3FDD1A9E,
/**/                   0x49ED083D, 0x3FE418BF,
/**/                   0x9DFD1E23, 0x3FEA12AA,
/**/                   0x32B75F76, 0x3FF45A6A,
/**/                   0xA7673F47, 0x4000976C,
/**/                   0xB046AC6A, 0x400C81E4,
/**/                   0x7D1BEB80, 0x3C879FF7,
/**/                   0xE8A6B8B0, 0x3FE24AE8,
/**/                   0x00000000, 0x3FF30000,
/**/                   0xB439D90E, 0x3F594770,
/**/                   0x00000000, 0x3FE17000,
/**/                   0x85087ECD, 0x3FF314FD,
/**/                   0xF2F45390, 0x3FDD946E,
/**/                   0x43BEDA05, 0x3FE482A6,
/**/                   0x0A640DD7, 0x3FEAE226,
/**/                   0xD6A3D695, 0x3FF52645,
/**/                   0x08098FE0, 0x4001649F,
/**/                   0x9D2BADE7, 0x400E233C,
/**/                   0x4E5F8348, 0x3C9E948C,
/**/                   0x2DE13E58, 0x3FE27104,
/**/                   0x00000000, 0x3FF30000,
/**/                   0x087ECD1A, 0x3F74FD85,
/**/                   0x00000000, 0x3FE19000,
/**/                   0xB6AA3C67, 0x3FF323E6,
/**/                   0xC8894828, 0x3FDE10C4,
/**/                   0x59718389, 0x3FE4EFDB,
/**/                   0x0A8D7622, 0x3FEBB9C9,
/**/                   0xB8A62B12, 0x3FF5FC05,
/**/                   0xE4296831, 0x40023D9A,
/**/                   0x49C0B830, 0x400FE05E,
/**/                   0xC1189DE8, 0x3CA19107,
/**/                   0x07C07BCC, 0x3FE2973D,
/**/                   0x00000000, 0x3FF34000,
/**/                   0x55C3993D, 0xBF7C1949,
/**/                   0x00000000, 0x3FE1B000,
/**/                   0xB8B9E20B, 0x3FF3330E,
/**/                   0x1A11468B, 0x3FDE8FB4,
/**/                   0xF2E740E1, 0x3FE5607F,
/**/                   0x5B91DB14, 0x3FEC99F9,
/**/                   0xF50C5FAA, 0x3FF6DC3B,
/**/                   0x0CFAC1C7, 0x4003232A,
/**/                   0x894EFD30, 0x4010DDB3,
/**/                   0x3783D916, 0xBCA7760F,
/**/                   0xF29BF5F0, 0x3FE2BD93,
/**/                   0x00000000, 0x3FF34000,
/**/                   0x8C3BEA7F, 0xBF69E28E,
/**/                   0x00000000, 0x3FE1D000,
/**/                   0xDD2DFE6D, 0x3FF34276,
/**/                   0xECEB226B, 0x3FDF1151,
/**/                   0x1AA123CE, 0x3FE5D4B7,
/**/                   0xA01F65F8, 0x3FED8322,
/**/                   0x791CE583, 0x3FF7C784,
/**/                   0xC15A6B9C, 0x40041625,
/**/                   0x64280FEB, 0x4011DB51,
/**/                   0x28CA6DBB, 0x3CA10463,
/**/                   0x6D64BEAC, 0x3FE2E409,
/**/                   0x00000000, 0x3FF34000,
/**/                   0x6FF364E1, 0x3F43B6E9,
/**/                   0x00000000, 0x3FE1F000,
/**/                   0x80B539C7, 0x3FF35220,
/**/                   0x1DD91A82, 0x3FDF95B4,
/**/                   0x961EA9CA, 0x3FE64CA5,
/**/                   0xC65B3B2F, 0x3FEE75B6,
/**/                   0xC412E59F, 0x3FF8BE85,
/**/                   0x02462A51, 0x40051778,
/**/                   0x109FC81B, 0x4012EA48,
/**/                   0x9F70CA98, 0x3C959E4C,
/**/                   0xF9BA7B3C, 0x3FE30A9D,
/**/                   0x00000000, 0x3FF34000,
/**/                   0xB539C6A2, 0x3F722080,
/**/                   0x00000000, 0x3FE21000,
/**/                   0x0B24ACDA, 0x3FF3620D,
/**/                   0xB5D803B6, 0x3FE00E78,
/**/                   0xFFE457FB, 0x3FE6C871,
/**/                   0x759EF386, 0x3FEF722E,
/**/                   0xB8D0E874, 0x3FF9C1F1,
/**/                   0x080FB06E, 0x4006281D,
/**/                   0xD1F69DF7, 0x40140BF2,
/**/                   0xCBFAF37F, 0xBC8489EA,
/**/                   0x1C0141BC, 0x3FE33152,
/**/                   0x00000000, 0x3FF38000,
/**/                   0xDB532667, 0xBF7DF2F4,
/**/                   0x00000000, 0x3FE23000,
/**/                   0xEFEBB76D, 0x3FF3723D,
/**/                   0xC153FC4C, 0x3FE05390,
/**/                   0xE34A2666, 0x3FE74844,
/**/                   0xC260A400, 0x3FF03C84,
/**/                   0x81E70F01, 0x3FFAD286,
/**/                   0xDBC4A78E, 0x40074924,
/**/                   0x8BBCA2E0, 0x401541CB,
/**/                   0x7BEA8472, 0x3C9C7528,
/**/                   0x5B7858F8, 0x3FE35826,
/**/                   0x00000000, 0x3FF38000,
/**/                   0x28912510, 0xBF6B8420,
/**/                   0x00000000, 0x3FE25000,
/**/                   0xAE8DA9C7, 0x3FF382B4,
/**/                   0x842CABB9, 0x3FE09A2E,
/**/                   0xDA356141, 0x3FE7CC48,
/**/                   0xBCD4FDB8, 0x3FF0C567,
/**/                   0x89B62C32, 0x3FFBF10F,
/**/                   0x18ADC4B9, 0x40087BB5,
/**/                   0xC516F6F1, 0x40168D6D,
/**/                   0x2E37D6A3, 0xBC933A6B,
/**/                   0x4251E5AC, 0x3FE37F1B,
/**/                   0x00000000, 0x3FF38000,
/**/                   0x6D4E3A7A, 0x3F45A574,
/**/                   0x00000000, 0x3FE27000,
/**/                   0xD3219A4C, 0x3FF39372,
/**/                   0xD4394437, 0x3FE0E25E,
/**/                   0xACE4CC74, 0x3FE854AA,
/**/                   0x0981EE13, 0x3FF15408,
/**/                   0x88AA5332, 0x3FFD1E66,
/**/                   0xDA3BD18F, 0x4009C10A,
/**/                   0xFFE4AE21, 0x4017F099,
/**/                   0x7B588ABE, 0xBCAED56B,
/**/                   0x5DCB911C, 0x3FE3A631,
/**/                   0x00000000, 0x3FF38000,
/**/                   0x219A4BA9, 0x3F7372D3,
/**/                   0x00000000, 0x3FE29000,
/**/                   0xF6D8C6BC, 0x3FF3A479,
/**/                   0x11197A32, 0x3FE12C2F,
/**/                   0x73F949D5, 0x3FE8E199,
/**/                   0xEE7A481D, 0x3FF1E8B1,
/**/                   0xABBE8828, 0x3FFE5B74,
/**/                   0xDB3D83BC, 0x400B1A7C,
/**/                   0x6DC46100, 0x40196D39,
/**/                   0xACD8F69C, 0x3CA7798C,
/**/                   0x3E4835E8, 0x3FE3CD69,
/**/                   0x00000000, 0x3FF3C000,
/**/                   0x27394391, 0xBF7B8609,
/**/                   0x00000000, 0x3FE2B000,
/**/                   0xC08BE738, 0x3FF3B5CB,
/**/                   0x2B5CB6B7, 0x3FE177AD,
/**/                   0xBCE90EB1, 0x3FE97346,
/**/                   0x68EC7F04, 0x3FF283B6,
/**/                   0xD5B8ED04, 0x3FFFA933,
/**/                   0xCBCDFF9A, 0x400C897D,
/**/                   0x0E4ABF55, 0x401B0562,
/**/                   0x1EE42043, 0x3C881FF6,
/**/                   0x776AA08C, 0x3FE3F4C3,
/**/                   0x00000000, 0x3FF3C000,
/**/                   0xE8319086, 0xBF64687E,
/**/                   0x00000000, 0x3FE2D000,
/**/                   0xE54FE05E, 0x3FF3C769,
/**/                   0xAC1A81A0, 0x3FE1C4E7,
/**/                   0xB10FA326, 0x3FEA09E6,
/**/                   0x840F679B, 0x3FF3256B,
/**/                   0xFEE9EF1A, 0x40008457,
/**/                   0xE4146343, 0x400E0F9E,
/**/                   0x433496A9, 0x401CBB5B,
/**/                   0x59F087C0, 0xBCA57A4C,
/**/                   0xA03171A8, 0x3FE41C40,
/**/                   0x00000000, 0x3FF3C000,
/**/                   0x3F81773D, 0x3F5DA795,
/**/                   0x00000000, 0x3FE2F000,
/**/                   0x291249DC, 0x3FF3D956,
/**/                   0xBD044AC9, 0x3FE213ED,
/**/                   0x3F917FA8, 0x3FEAA5B0,
/**/                   0xB7380A79, 0x3FF3CE2C,
/**/                   0x576AFAE8, 0x40013D84,
/**/                   0xBAAB74F3, 0x400FAE92,
/**/                   0xE9129E4A, 0x401E91A2,
/**/                   0x0CEC83F7, 0x3C905671,
/**/                   0x53143194, 0x3FE443E1,
/**/                   0x00000000, 0x3FF3C000,
/**/                   0x1249DBC4, 0x3F795629,
/**/                   0x00000000, 0x3FE31000,
/**/                   0x5F3E4715, 0x3FF3EB92,
/**/                   0x30F965D1, 0x3FE264CF,
/**/                   0x4A4F2FB2, 0x3FEB46DD,
/**/                   0x4BC2E94F, 0x3FF47E5B,
/**/                   0x54F8F9EB, 0x400200B9,
/**/                   0x33305D9F, 0x4010B418,
/**/                   0x826EF167, 0x40204579,
/**/                   0xE06EBCAE, 0xBC9737A0,
/**/                   0x2E21A53C, 0x3FE46BA6,
/**/                   0x00000000, 0x3FF40000,
/**/                   0xC1B8EB04, 0xBF746DA0,
/**/                   0x00000000, 0x3FE33000,
/**/                   0x6B6A38D5, 0x3FF3FE20,
/**/                   0x8D26C7A0, 0x3FE2B79C,
/**/                   0xD62978F8, 0x3FEBEDAA,
/**/                   0xCB8CC6D1, 0x3FF5365E,
/**/                   0xD894AF54, 0x4002CE9C,
/**/                   0x79F7C63E, 0x40119F3B,
/**/                   0x0C8E7B9E, 0x40215524,
/**/                   0x13DC9A80, 0x3CA485D0,
/**/                   0xD31F754C, 0x3FE4938F,
/**/                   0x00000000, 0x3FF40000,
/**/                   0x5C72B1E7, 0xBF3DF949,
/**/                   0x00000000, 0x3FE35000,
/**/                   0x420ED8E7, 0x3FF41102,
/**/                   0x12BCE2B2, 0x3FE30C67,
/**/                   0x3EDE345E, 0x3FEC9A59,
/**/                   0x78CAB466, 0x3FF5F6A5,
/**/                   0x3EAD62EE, 0x4003A7E1,
/**/                   0x9CB9A228, 0x401299C8,
/**/                   0x1BE749B0, 0x40227974,
/**/                   0xC6A9831F, 0x3CAFE28F,
/**/                   0xE7AB3A40, 0x3FE4BB9E,
/**/                   0x00000000, 0x3FF40000,
/**/                   0x0ED8E776, 0x3F710242,
/**/                   0x00000000, 0x3FE37000,
/**/                   0xE9485B43, 0x3FF42439,
/**/                   0xC946E033, 0x3FE36340,
/**/                   0x6ECC5A7E, 0x3FED4D2C,
/**/                   0xD027255A, 0x3FF6BFA4,
/**/                   0x72504BE1, 0x40048D46,
/**/                   0x09445BD5, 0x4013A4ED,
/**/                   0x749E19F9, 0x4023B435,
/**/                   0xEAAAF53E, 0xBC40E7E5,
/**/                   0x155D0070, 0x3FE4E3D4,
/**/                   0x00000000, 0x3FF44000,
/**/                   0xB7A4BD36, 0xBF7BC616,
/**/                   0x00000000, 0x3FE39000,
/**/                   0x79A23C23, 0x3FF437C9,
/**/                   0x89AF6A9D, 0x3FE3BC3C,
/**/                   0x1AF553BA, 0x3FEE066C,
/**/                   0x1622569A, 0x3FF791DA,
/**/                   0x1B18AE2B, 0x40057F9B,
/**/                   0x88BFF240, 0x4014C1F0,
/**/                   0x019A4522, 0x40250761,
/**/                   0xFDFCCB13, 0x3CA4C238,
/**/                   0x09EB58F8, 0x3FE50C30,
/**/                   0x00000000, 0x3FF44000,
/**/                   0xBB87B9E1, 0xBF606D0C,
/**/                   0x00000000, 0x3FE3B000,
/**/                   0x1EEE6F35, 0x3FF44BB3,
/**/                   0x0A004D1D, 0x3FE4176E,
/**/                   0x0399FA54, 0x3FEEC664,
/**/                   0xF0CFD106, 0x3FF86DCA,
/**/                   0xE8C80E97, 0x40067FBD,
/**/                   0xD9CD2D79, 0x4015F237,
/**/                   0xC8076345, 0x40267521,
/**/                   0xB089F7AF, 0x3CAEC756,
/**/                   0x77510D94, 0x3FE534B3,
/**/                   0x00000000, 0x3FF44000,
/**/                   0xDCDE698F, 0x3F67663D,
/**/                   0x00000000, 0x3FE3D000,
/**/                   0x1928B1BE, 0x3FF45FF9,
/**/                   0xE9EB53E9, 0x3FE474E9,
/**/                   0x39DB03B6, 0x3FEF8D64,
/**/                   0x0F298B87, 0x3FF95406,
/**/                   0xFFC72AB6, 0x40078E9E,
/**/                   0x941456E7, 0x40173747,
/**/                   0x74A71E71, 0x4027FFDA,
/**/                   0xFE7483B3, 0xBCAEED93,
/**/                   0x13F48EC0, 0x3FE55D5F,
/**/                   0x00000000, 0x3FF44000,
/**/                   0x28B1BDFF, 0x3F7FF919,
/**/                   0x00000000, 0x3FE3F000,
/**/                   0xBD66D0C4, 0x3FF4749D,
/**/                   0xC02C2013, 0x3FE4D4C5,
/**/                   0xB56768CC, 0x3FF02DE0,
/**/                   0xDF53A7BD, 0x3FFA4523,
/**/                   0x8A357386, 0x4008AD41,
/**/                   0x5E392799, 0x401892C7,
/**/                   0x97746ACD, 0x4029AA2B,
/**/                   0xB4A71E44, 0x3C924F0A,
/**/                   0x9AD13548, 0x3FE58633,
/**/                   0x00000000, 0x3FF48000,
/**/                   0x325E775E, 0xBF66C485,
/**/                   0x00000000, 0x3FE41000,
/**/                   0x76D6C491, 0x3FF489A3,
/**/                   0x28D40829, 0x3FE53718,
/**/                   0x98450D83, 0x3FF098EA,
/**/                   0x55526E3B, 0x3FFB41C7,
/**/                   0x719F540E, 0x4009DCBD,
/**/                   0x805D08D1, 0x401A0685,
/**/                   0xA5142633, 0x402B76FA,
/**/                   0xF1FF56FC, 0x3C2AD9A7,
/**/                   0xCBA27244, 0x3FE5AF31,
/**/                   0x00000000, 0x3FF48000,
/**/                   0xAD892100, 0x3F6346ED,
/**/                   0x00000000, 0x3FE43000,
/**/                   0xC7CB94CC, 0x3FF49F0C,
/**/                   0xD492AA1E, 0x3FE59BF8,
/**/                   0x34D2CA82, 0x3FF107FF,
/**/                   0xC3DF9E51, 0x3FFC4A9E,
/**/                   0x45F5874E, 0x400B1E41,
/**/                   0xDEB92648, 0x401B947A,
/**/                   0xD903D532, 0x402D6979,
/**/                   0x04C67F5E, 0x3CA43231,
/**/                   0x6B1109A4, 0x3FE5D85A,
/**/                   0x00000000, 0x3FF48000,
/**/                   0xCB94CC1A, 0x3F7F0CC7,
/**/                   0x00000000, 0x3FE45000,
/**/                   0x4ADA0BF0, 0x3FF4B4DC,
/**/                   0x990F861F, 0x3FE60380,
/**/                   0xCBEC7542, 0x3FF17B50,
/**/                   0xC93CFE8F, 0x3FFD6064,
/**/                   0x56F36FE3, 0x400C7314,
/**/                   0x696E5374, 0x401D3ECF,
/**/                   0x1778AF1D, 0x402F8531,
/**/                   0x31EBDA84, 0x3C7A53BF,
/**/                   0x42E27660, 0x3FE601AE,
/**/                   0x00000000, 0x3FF4C000,
/**/                   0x4BE81F81, 0xBF66476A,
/**/                   0x00000000, 0x3FE47000,
/**/                   0xB4065600, 0x3FF4CB14,
/**/                   0x826ADA4F, 0x3FE66DC9,
/**/                   0xA3298D4D, 0x3FF1F314,
/**/                   0x52191CB4, 0x3FFE83E1,
/**/                   0x05CA69AF, 0x400DDC99,
/**/                   0x1079C46A, 0x401F07DF,
/**/                   0xF9440EB0, 0x4030E703,
/**/                   0x5817D0DD, 0x3CA495E1,
/**/                   0x222A98A0, 0x3FE62B2E,
/**/                   0x00000000, 0x3FF4C000,
/**/                   0x0CAC00D4, 0x3F662968,
/**/                   0x00000000, 0x3FE49000,
/**/                   0xD203BDC9, 0x3FF4E1B8,
/**/                   0xE5FE0976, 0x3FE6DAEE,
/**/                   0x3C44F71E, 0x3FF26F83,
/**/                   0xB4D92F91, 0x3FFFB5EA,
/**/                   0x55A779C8, 0x400F5C4F,
/**/                   0xA66A7536, 0x4020791F,
/**/                   0x7DCE5D75, 0x40322428,
/**/                   0x964F770B, 0x3CADE7E8,
/**/                   0xDD7FD12C, 0x3FE654DA,
/**/                   0x00000000, 0x3FF50000,
/**/                   0xFC42374B, 0xBF7E472D,
/**/                   0x00000000, 0x3FE4B000,
/**/                   0x8F87D541, 0x3FF4F8CB,
/**/                   0x767620C4, 0x3FE74B0D,
/**/                   0x9126F083, 0x3FF2F0D8,
/**/                   0x73F08794, 0x40007BB3,
/**/                   0xE1419117, 0x401079EB,
/**/                   0xA917F81E, 0x40218062,
/**/                   0x48444DEE, 0x40337C6B,
/**/                   0xF4061E08, 0x3C907A41,
/**/                   0x4F31AF70, 0x3FE67EB5,
/**/                   0x00000000, 0x3FF50000,
/**/                   0xE0AAFA85, 0xBF5CD1C1,
/**/                   0x00000000, 0x3FE4D000,
/**/                   0xF4B2718C, 0x3FF5104F,
/**/                   0x59659939, 0x3FE7BE43,
/**/                   0x5502EAE6, 0x3FF37754,
/**/                   0x6AE0AC51, 0x400124A6,
/**/                   0x33524D17, 0x4011527B,
/**/                   0x7FBF7A2D, 0x40229B46,
/**/                   0xAD716768, 0x4034F274,
/**/                   0x7C204EA8, 0xBC9C610F,
/**/                   0x57825A6C, 0x3FE6A8BE,
/**/                   0x00000000, 0x3FF50000,
/**/                   0xB2718C01, 0x3F704FF4,
/**/                   0x00000000, 0x3FE4F000,
/**/                   0x288C017D, 0x3FF52849,
/**/                   0x3E6D3F7F, 0x3FE834B0,
/**/                   0x3B0747CB, 0x3FF4033A,
/**/                   0xE946B196, 0x4001D652,
/**/                   0x3C2F8CB4, 0x401238CB,
/**/                   0x53E520C1, 0x4023CB80,
/**/                   0x607BC0F6, 0x40368938,
/**/                   0xCC053597, 0xBC84274C,
/**/                   0xDCE2DFB8, 0x3FE6D2F6,
/**/                   0x00000000, 0x3FF54000,
/**/                   0x73FE8364, 0xBF77B6D7,
/**/                   0x00000000, 0x3FE51000,
/**/                   0x729BE713, 0x3FF540BA,
/**/                   0x781F49A2, 0x3FE8AE75,
/**/                   0x432AC103, 0x3FF494D2,
/**/                   0x9B0015B6, 0x40029147,
/**/                   0x156B74E9, 0x40132DE7,
/**/                   0xE8362EC8, 0x402512F0,
/**/                   0xC8D2E0F8, 0x403843FE,
/**/                   0xBB3ACC53, 0xBC8F55DB,
/**/                   0xCC3296F0, 0x3FE6FD5F,
/**/                   0x00000000, 0x3FF54000,
/**/                   0x7CE2565E, 0x3F274E53,
/**/                   0x00000000, 0x3FE53000,
/**/                   0x3C98A101, 0x3FF559A7,
/**/                   0x16C3163D, 0x3FE92BB6,
/**/                   0x0DB2C44D, 0x3FF52C69,
/**/                   0x0F4546B8, 0x4003561E,
/**/                   0x7F099A82, 0x401432F1,
/**/                   0x831E227A, 0x402673A9,
/**/                   0xA02BBCD5, 0x403A266F,
/**/                   0xAEA9CB9D, 0x3CA279A8,
/**/                   0x1901CB44, 0x3FE727FA,
/**/                   0x00000000, 0x3FF54000,
/**/                   0x98A10084, 0x3F79A73C,
/**/                   0x00000000, 0x3FE55000,
/**/                   0x1433B9BD, 0x3FF57313,
/**/                   0x0523E7B2, 0x3FE9AC97,
/**/                   0x361F7393, 0x3FF5CA50,
/**/                   0xB0F40825, 0x4004257B,
/**/                   0x46286025, 0x40154927,
/**/                   0x781495B4, 0x4027EFF1,
/**/                   0x0A1139F1, 0x403C349E,
/**/                   0x8B6015DA, 0xBC5D2C66,
/**/                   0xBDD7E0E0, 0x3FE752C6,
/**/                   0x00000000, 0x3FF58000,
/**/                   0x988C865F, 0xBF69D9D7,
/**/                   0x00000000, 0x3FE57000,
/**/                   0xAD039E07, 0x3FF58D01,
/**/                   0x279933CD, 0x3FEA313F,
/**/                   0xB63D93A6, 0x3FF66EDE,
/**/                   0xD836441A, 0x40050012,
/**/                   0xF23D152C, 0x401671E1,
/**/                   0x65D3A1DD, 0x40298A4C,
/**/                   0x5EBDBF39, 0x403E7316,
/**/                   0x7AAA4996, 0xBCAE5B6C,
/**/                   0xBC7D2FA0, 0x3FE77DC6,
/**/                   0x00000000, 0x3FF58000,
/**/                   0x073C0E86, 0x3F6A035A,
/**/                   0x00000000, 0x3FE59000,
/**/                   0xE28DADB6, 0x3FF5A776,
/**/                   0x7D7BE2B5, 0x3FEAB9D7,
/**/                   0x5234C8A9, 0x3FF71A71,
/**/                   0xF873554C, 0x4005E6A3,
/**/                   0xC1F33F9B, 0x4017AE9A,
/**/                   0x4310046E, 0x402B4581,
/**/                   0xF64B03E7, 0x40407376,
/**/                   0xB3AB0542, 0xBCA3F39B,
/**/                   0x1E48D158, 0x3FE7A8FB,
/**/                   0x00000000, 0x3FF5C000,
/**/                   0x725249CA, 0xBF78891D,
/**/                   0x00000000, 0x3FE5B000,
/**/                   0xBA730F9B, 0x3FF5C276,
/**/                   0x454127C3, 0x3FEB468B,
/**/                   0x0E816ADB, 0x3FF7CD6B,
/**/                   0xEDDAC837, 0x4006D9FE,
/**/                   0x0209E3B7, 0x401900EE,
/**/                   0x57489C7E, 0x402D24A2,
/**/                   0x7F810E14, 0x4041CAEA,
/**/                   0x24F9675B, 0xBC84F20E,
/**/                   0xF472A690, 0x3FE7D464,
/**/                   0x00000000, 0x3FF5C000,
/**/                   0x987CD623, 0x3F43B5D3,
/**/                   0x00000000, 0x3FE5D000,
/**/                   0x66C30CDC, 0x3FF5DE05,
/**/                   0x23798D1A, 0x3FEBD788,
/**/                   0xB0E567D8, 0x3FF88835,
/**/                   0x6E46660A, 0x4007DB04,
/**/                   0xCA07CAA5, 0x401A6A9E,
/**/                   0x41ECEF64, 0x402F2B16,
/**/                   0xC36F367B, 0x40434315,
/**/                   0x542594A6, 0xBCA08CA1,
/**/                   0x5869D9E8, 0x3FE80005,
/**/                   0x00000000, 0x3FF5C000,
/**/                   0xC30CDBD9, 0x3F7E0566,
/**/                   0x00000000, 0x3FE5F000,
/**/                   0x4875FA03, 0x3FF5FA27,
/**/                   0x4CF96D63, 0x3FEC6CFE,
/**/                   0x4D7B8313, 0x3FF94B42,
/**/                   0xA1B04592, 0x4008EAA7,
/**/                   0x2C5A9D87, 0x401BED9B,
/**/                   0x1BC92F68, 0x4030AE51,
/**/                   0x685FBD64, 0x4044DF8C,
/**/                   0x30FE6378, 0xBCAC07A8,
/**/                   0x6C30303C, 0x3FE82BDD,
/**/                   0x00000000, 0x3FF60000,
/**/                   0x2817F40C, 0xBF5762DE,
/**/                   0x00000000, 0x3FE61000,
/**/                   0xF213FCD6, 0x3FF616E0,
/**/                   0xB47784FF, 0x3FED0720,
/**/                   0xE13C6707, 0x3FFA1709,
/**/                   0xE70B2E72, 0x400A09EF,
/**/                   0xE976AAD9, 0x401D8C00,
/**/                   0xD1AE1EA8, 0x4031DEBA,
/**/                   0x6424341F, 0x4046A453,
/**/                   0xA65D40B1, 0x3CA13E53,
/**/                   0x5ABA79E8, 0x3FE857EE,
/**/                   0x00000000, 0x3FF60000,
/**/                   0x13FCD614, 0x3F76E0F2,
/**/                   0x00000000, 0x3FE63000,
/**/                   0x2A8B4ED8, 0x3FF63437,
/**/                   0x3BF69915, 0x3FEDA625,
/**/                   0xFB6DF86F, 0x3FFAEC0D,
/**/                   0xCAF2D64B, 0x400B39FA,
/**/                   0xB7E2DC06, 0x401F4822,
/**/                   0xB12537E3, 0x4033291B,
/**/                   0xAF3EF0D1, 0x404895F0,
/**/                   0x71E7ED76, 0x3CAEA588,
/**/                   0x5856807C, 0x3FE88439,
/**/                   0x00000000, 0x3FF64000,
/**/                   0xE9624F1C, 0xBF6791AA,
/**/                   0x00000000, 0x3FE65000,
/**/                   0xF039F5E3, 0x3FF6522E,
/**/                   0xEA588E54, 0x3FEE4A44,
/**/                   0x77A3F8A4, 0x3FFBCAD9,
/**/                   0x3669F2F2, 0x400C7BFE,
/**/                   0x1AEA54A4, 0x40209247,
/**/                   0x6B866959, 0x4034900A,
/**/                   0x620634CF, 0x404AB97D,
/**/                   0xDA91B0FD, 0x3C948649,
/**/                   0xA316D3A0, 0x3FE8B0BF,
/**/                   0x00000000, 0x3FF64000,
/**/                   0x39F5E2AD, 0x3F722EF0,
/**/                   0x00000000, 0x3FE67000,
/**/                   0x7C2F4FC3, 0x3FF670CD,
/**/                   0x2583CF60, 0x3FEEF3BC,
/**/                   0x4A2E1684, 0x3FFCB401,
/**/                   0xDCB9F8FB, 0x400DD14A,
/**/                   0x4E164373, 0x40219209,
/**/                   0x8FC171BC, 0x40361669,
/**/                   0xA46B7BE1, 0x404D14BA,
/**/                   0xBBDFE65A, 0xBCABAC31,
/**/                   0x8344E08C, 0x3FE8DD82,
/**/                   0x00000000, 0x3FF68000,
/**/                   0xA1607A77, 0xBF6E6507,
/**/                   0x00000000, 0x3FE69000,
/**/                   0x45AA3C85, 0x3FF69018,
/**/                   0xF18FBD18, 0x3FEFA2CA,
/**/                   0x610C140E, 0x3FFDA825,
/**/                   0xF08895E1, 0x400F3B4E,
/**/                   0x272CD203, 0x4022A4E4,
/**/                   0x60C4A0EE, 0x4037BF71,
/**/                   0xEC79351D, 0x404FAE29,
/**/                   0x3E22FB0A, 0x3C6BF5BB,
/**/                   0x4BD9C858, 0x3FE90A83,
/**/                   0x00000000, 0x3FF68000,
/**/                   0xAA3C8533, 0x3F701845,
/**/                   0x00000000, 0x3FE6B000,
/**/                   0x05D92E4E, 0x3FF6B015,
/**/                   0x9ABD20D8, 0x3FF02BDA,
/**/                   0x9BC5CC13, 0x3FFEA7F1,
/**/                   0x94AFB2BB, 0x40105DCC,
/**/                   0xB382B54A, 0x4023CC8C,
/**/                   0x19C28EAE, 0x40398EBB,
/**/                   0x8F7609B5, 0x40514694,
/**/                   0xF66137E5, 0x3C9CD223,
/**/                   0x5AFE73AC, 0x3FE937C3,
/**/                   0x00000000, 0x3FF6C000,
/**/                   0x4DA36334, 0xBF6FD5F4,
/**/                   0x00000000, 0x3FE6D000,
/**/                   0xBBE1EF2B, 0x3FF6D0C9,
/**/                   0x82FBDD29, 0x3FF08961,
/**/                   0xDCD403EC, 0x3FFFB41E,
/**/                   0x121D0023, 0x401129EE,
/**/                   0xB34159B2, 0x40250AE5,
/**/                   0xDB5CEAC4, 0x403B884D,
/**/                   0xA0B334B0, 0x4052DD09,
/**/                   0xD8F14BF9, 0xBC96BF1D,
/**/                   0x1A936D24, 0x3FE96544,
/**/                   0x00000000, 0x3FF6C000,
/**/                   0xE1EF2AEE, 0x3F70C9BB,
/**/                   0x00000000, 0x3FE6F000,
/**/                   0xB13786CF, 0x3FF6F23C,
/**/                   0x7B7FC134, 0x3FF0EA20,
/**/                   0x1BD0D518, 0x400066BA,
/**/                   0x159EC945, 0x401202F9,
/**/                   0x16FF868A, 0x40266205,
/**/                   0x87398014, 0x403DB0AD,
/**/                   0x47D58711, 0x40549F33,
/**/                   0x54B11A28, 0x3C8D858F,
/**/                   0x00C1184C, 0x3FE99307,
/**/                   0x00000000, 0x3FF70000,
/**/                   0x90F2626A, 0xBF6B869D,
/**/                   0x00000000, 0x3FE71000,
/**/                   0x7E455603, 0x3FF71474,
/**/                   0x3A65655F, 0x3FF14E40,
/**/                   0x1F4AA7A1, 0x4000FA64,
/**/                   0xB946C70A, 0x4012E9F0,
/**/                   0x3CC53936, 0x4027D43A,
/**/                   0xEE087279, 0x40400675,
/**/                   0x77313CEF, 0x40569278,
/**/                   0x772D6E62, 0xBCAB1BA1,
/**/                   0x9090E874, 0x3FE9C10D,
/**/                   0x00000000, 0x3FF70000,
/**/                   0x455602D3, 0x3F74747E,
/**/                   0x00000000, 0x3FE73000,
/**/                   0x0F773DEC, 0x3FF73778,
/**/                   0x1288B243, 0x3FF1B5EC,
/**/                   0x3A853FA5, 0x40019581,
/**/                   0x6D2743E5, 0x4013DFF0,
/**/                   0x09B4B924, 0x40296415,
/**/                   0x19A59D1F, 0x4041515E,
/**/                   0xF3E53877, 0x4058BD01,
/**/                   0xFC348BAE, 0x3C962269,
/**/                   0x5A90493C, 0x3FE9EF59,
/**/                   0x00000000, 0x3FF74000,
/**/                   0x11842743, 0xBF610FE1,
/**/                   0x00000000, 0x3FE75000,
/**/                   0xAAA78140, 0x3FF75B4E,
/**/                   0x28B49576, 0x3FF22152,
/**/                   0x74D66746, 0x4002388E,
/**/                   0xA43083A8, 0x4014E62E,
/**/                   0x02885ED7, 0x402B146E,
/**/                   0x29A3BC2C, 0x4042BC45,
/**/                   0xCDAFE7E5, 0x405B25D8,
/**/                   0xF03F8A74, 0x3CA8862D,
/**/                   0xFD7DFBD8, 0x3FEA1DEB,
/**/                   0x00000000, 0x3FF74000,
/**/                   0xA7813FBA, 0x3F7B4EAA,
/**/                   0x00000000, 0x3FE77000,
/**/                   0xF4FC0008, 0x3FF77FFF,
/**/                   0xADE499E4, 0x3FF290A3,
/**/                   0xFF22FE11, 0x4002E412,
/**/                   0xD7A17943, 0x4015FDFF,
/**/                   0x8AF79AEF, 0x402CE86F,
/**/                   0x6F8EDF86, 0x40444ACA,
/**/                   0x29CF9F92, 0x405DD50A,
/**/                   0xC5865233, 0x3CA49DB0,
/**/                   0x2702BD90, 0x3FEA4CC7,
/**/                   0x00000000, 0x3FF78000,
/**/                   0xF08268E1, 0xBE6607FF,
/**/                   0x00000000, 0x3FE79000,
/**/                   0xF93D7FBC, 0x3FF7A593,
/**/                   0x1F293A81, 0x3FF30415,
/**/                   0x31649EA4, 0x400398A1,
/**/                   0xED75DA1E, 0x401728D9,
/**/                   0x7B1736CA, 0x402EE3A0,
/**/                   0x036EC9D4, 0x40460106,
/**/                   0xB3E5A09F, 0x406069E8,
/**/                   0x4E8EB882, 0xBCA79BBD,
/**/                   0x94762100, 0x3FEA7BEC,
/**/                   0x00000000, 0x3FF7C000,
/**/                   0xC280445C, 0xBF7A6C06,
/**/                   0x00000000, 0x3FE7B000,
/**/                   0x2EB4E536, 0x3FF7CC13,
/**/                   0x8BD25D7D, 0x3FF37BDE,
/**/                   0xA51DF797, 0x400456D7,
/**/                   0x103AF33E, 0x40186858,
/**/                   0x21121C2E, 0x403084F8,
/**/                   0x9D7C6DE3, 0x4047E39A,
/**/                   0xEF4C9A12, 0x40621664,
/**/                   0x39DB72FF, 0x3C804D2D,
/**/                   0x13B099B0, 0x3FEAAB5E,
/**/                   0x00000000, 0x3FF7C000,
/**/                   0x69CA6C2F, 0x3F68265D,
/**/                   0x00000000, 0x3FE7D000,
/**/                   0x809BA1CD, 0x3FF7F386,
/**/                   0xE298B2EB, 0x3FF3F83B,
/**/                   0x708A6ABE, 0x40051F62,
/**/                   0x090F77AB, 0x4019BE3F,
/**/                   0x6C13BF38, 0x4031AFE2,
/**/                   0x65FF02A8, 0x4049F7CA,
/**/                   0xDA840FE0, 0x4063F614,
/**/                   0xAB5D1A54, 0xBCA7BDE9,
/**/                   0x83EBD320, 0x3FEADB1D,
/**/                   0x00000000, 0x3FF80000,
/**/                   0xC8BC6562, 0xBF68F2FE,
/**/                   0x00000000, 0x3FE7F000,
/**/                   0x562E1E24, 0x3FF81BF7,
/**/                   0x469724DB, 0x3FF4796D,
/**/                   0x86E67917, 0x4005F2FC,
/**/                   0x2F5AE582, 0x401B2C82,
/**/                   0x65EE1919, 0x4032F505,
/**/                   0x4744D220, 0x404C438F,
/**/                   0xD66309FD, 0x40661003,
/**/                   0xFC828894, 0x3C8470C8,
/**/                   0xD6B287DC, 0x3FEB0B2C,
/**/                   0x00000000, 0x3FF80000,
/**/                   0x2E1E23E5, 0x3F7BF756,
/**/                   0x00000000, 0x3FE81000,
/**/                   0x9B70AB1D, 0x3FF8456F,
/**/                   0x6D01A674, 0x3FF4FFB7,
/**/                   0x42D7B667, 0x4006D271,
/**/                   0x05DD4055, 0x401CB549,
/**/                   0xE490CA9B, 0x40345723,
/**/                   0x47C5589B, 0x404ECD17,
/**/                   0x3D6DB036, 0x40686C46,
/**/                   0xECF23C2E, 0x4084044D,
/**/                   0x0D173A5F, 0xBC7F0990,
/**/                   0x10E12D3C, 0x3FEB3B8E,
/**/                   0x00000000, 0x3FF84000,
/**/                   0xC2AC733C, 0x3F55BE6D,
/**/                   0x00000000, 0x3FE83000,
/**/                   0xCAB97B9D, 0x3FF86FF9,
/**/                   0x04A71B42, 0x3FF58B64,
/**/                   0x20C0FB6E, 0x4007BE9E,
/**/                   0x9B426297, 0x401E5AF5,
/**/                   0x013C40EE, 0x4035D958,
/**/                   0x2215E48C, 0x4050CEA9,
/**/                   0xB8C0669A, 0x406B146B,
/**/                   0xFB8EB0FE, 0x40868C96,
/**/                   0x1FCCBAD4, 0x3CA55848,
/**/                   0x4BB8EA98, 0x3FEB6C43,
/**/                   0x00000000, 0x3FF88000,
/**/                   0x46846319, 0xBF700635,
/**/                   0x00000000, 0x3FE85000,
/**/                   0xF71469BF, 0x3FF89BA0,
/**/                   0x28717EFA, 0x3FF61CC2,
/**/                   0xAFB7BAF7, 0x4008B874,
/**/                   0xEC7286DB, 0x40201015,
/**/                   0x8329A469, 0x40377F1F,
/**/                   0x2927F0DD, 0x40525E49,
/**/                   0x5AE80CD9, 0x406E135C,
/**/                   0x40DF64FD, 0x40897364,
/**/                   0x1ED91B03, 0x3C89F53B,
/**/                   0xB6067ABC, 0x3FEB9D4E,
/**/                   0x00000000, 0x3FF88000,
/**/                   0x1469BF33, 0x3F7BA0F7,
/**/                   0x00000000, 0x3FE87000,
/**/                   0xD797DABF, 0x3FF8C870,
/**/                   0xDE42D55F, 0x3FF6B426,
/**/                   0xC0E06552, 0x4009C0FC,
/**/                   0xEB059907, 0x402103EC,
/**/                   0x49A75AA7, 0x40394C6A,
/**/                   0xB2A496D0, 0x40541A81,
/**/                   0x209CB693, 0x4070BAEE,
/**/                   0x285808C5, 0x408CC860,
/**/                   0x9B0DC6F3, 0xBCAE6D8C,
/**/                   0x955EC1C4, 0x3FEBCEB2,
/**/                   0x00000000, 0x3FF8C000,
/**/                   0x2FB57EE7, 0x3F60E1AF,
/**/                   0x00000000, 0x3FE89000,
/**/                   0xD3C502F4, 0x3FF8F675,
/**/                   0xA3BFB2E4, 0x3FF751ED,
/**/                   0xDE3987BC, 0x400AD956,
/**/                   0xB30AAD0A, 0x40220AA0,
/**/                   0x16220014, 0x403B45AB,
/**/                   0xEC84429C, 0x40560929,
/**/                   0x0D747939, 0x4072A569,
/**/                   0x5407F41E, 0x40904F10,
/**/                   0xFC269962, 0xBC675CEB,
/**/                   0x4773138C, 0x3FEC0071,
/**/                   0x00000000, 0x3FF90000,
/**/                   0x75FA1750, 0xBF631458,
/**/                   0x00000000, 0x3FE8B000,
/**/                   0x111125DF, 0x3FF925BD,
/**/                   0x0AD2B4C2, 0x3FF7F679,
/**/                   0x1359A3C8, 0x400C02BF,
/**/                   0x88857C21, 0x40232601,
/**/                   0x2515D90E, 0x403D6FEB,
/**/                   0xD421145E, 0x405830FA,
/**/                   0xFD789544, 0x4074D1D6,
/**/                   0x4B30EBF1, 0x40928561,
/**/                   0x7876F9D2, 0x3CA13E7B,
/**/                   0x437F5E74, 0x3FEC328D,
/**/                   0x00000000, 0x3FF94000,
/**/                   0xEEDA20A4, 0xBF7A42EE,
/**/                   0x00000000, 0x3FE8D000,
/**/                   0x81B9477B, 0x3FF95654,
/**/                   0x67F87779, 0x3FF8A233,
/**/                   0x14665EA0, 0x400D3E90,
/**/                   0x5A415747, 0x40245815,
/**/                   0x1D7511C0, 0x403FD0E1,
/**/                   0x01EC30FB, 0x405A99B6,
/**/                   0xDD7EE7A1, 0x40774A72,
/**/                   0x5C2F1724, 0x40951454,
/**/                   0x774A5205, 0x3C8185B3,
/**/                   0x1BD4AD0C, 0x3FEC6509,
/**/                   0x00000000, 0x3FF94000,
/**/                   0xB9477AC0, 0x3F765481,
/**/                   0x00000000, 0x3FE8F000,
/**/                   0xF50630B5, 0x3FF9884A,
/**/                   0x94B35A8D, 0x3FF9558F,
/**/                   0xD1A32B1D, 0x400E8E46,
/**/                   0x0AEC68DB, 0x4025A31F,
/**/                   0xFD21A759, 0x40413785,
/**/                   0xF56DFCA6, 0x405D4C53,
/**/                   0xF89C0F5F, 0x407A1B45,
/**/                   0xC92C8CF3, 0x40980BB3,
/**/                   0xFEB6A05E, 0xBC8696E8,
/**/                   0x7F82B8CC, 0x3FEC97E7,
/**/                   0x00000000, 0x3FF98000,
/**/                   0x0C6169C6, 0x3F6095EA,
/**/                   0x00000000, 0x3FE91000,
/**/                   0x292BC29F, 0x3FF9BBB0,
/**/                   0xC8E3D76B, 0x3FFA1109,
/**/                   0x8873C480, 0x400FF386,
/**/                   0xDE619C77, 0x402709A6,
/**/                   0x5A9417B9, 0x4042A8E9,
/**/                   0xBFE20B57, 0x4060299D,
/**/                   0xE1225431, 0x407D5283,
/**/                   0xC225406C, 0x409B7E74,
/**/                   0x74F396DB, 0xBC879431,
/**/                   0x3C239888, 0x3FECCB2B,
/**/                   0x00000000, 0x3FF9C000,
/**/                   0x50F5839F, 0xBF513F5B,
/**/                   0x00000000, 0x3FE93000,
/**/                   0xDEF4783D, 0x3FF9F094,
/**/                   0x8E300736, 0x3FFAD528,
/**/                   0xB2D4D4EE, 0x4010B80E,
/**/                   0x3F3D0057, 0x40288E84,
/**/                   0xD20263C0, 0x404440D4,
/**/                   0x26E14927, 0x4061DD42,
/**/                   0x5EF13D09, 0x4080807D,
/**/                   0xFE9E94BE, 0x409F836C,
/**/                   0xE5FD9D2D, 0xBC813C84,
/**/                   0x3FCCF104, 0x3FECFED7,
/**/                   0x00000000, 0x3FFA0000,
/**/                   0x170F854B, 0xBF6ED642,
/**/                   0x00000000, 0x3FE95000,
/**/                   0xEF70C9F9, 0x3FFA270A,
/**/                   0xD12662D9, 0x3FFBA27D,
/**/                   0xE8433B59, 0x40118304,
/**/                   0x1B4DD8D9, 0x402A34E9,
/**/                   0x58AA354C, 0x4046041F,
/**/                   0x87EB035B, 0x4063C823,
/**/                   0x7F89A6B6, 0x40829D4E,
/**/                   0xB4BED54D, 0x40A21B1A,
/**/                   0xFD8283D4, 0x3C855D66,
/**/                   0x9B2A7684, 0x3FED32EE,
/**/                   0x00000000, 0x3FFA4000,
/**/                   0x8F3606B9, 0xBF78F510,
/**/                   0x00000000, 0x3FE97000,
/**/                   0x63EA127F, 0x3FFA5F25,
/**/                   0x1460C218, 0x3FFC79A8,
/**/                   0x3D14975C, 0x40125BC0,
/**/                   0x2249DB66, 0x402C006F,
/**/                   0xED0AEFCD, 0x4047F856,
/**/                   0x2E2028D0, 0x4065F27F,
/**/                   0x6CE59595, 0x40850B95,
/**/                   0x18C497E2, 0x40A4DC23,
/**/                   0x76BA54CA, 0x3C8BDFAE,
/**/                   0x83C60554, 0x3FED6774,
/**/                   0x00000000, 0x3FFA4000,
/**/                   0xEA127F53, 0x3F7F2563,
/**/                   0x00000000, 0x3FE99000,
/**/                   0x9061CEFE, 0x3FFA98F8,
/**/                   0xCAA1F466, 0x3FFD5B53,
/**/                   0xA92630E8, 0x40134379,
/**/                   0x41E37357, 0x402DF527,
/**/                   0xD7DE2305, 0x404A23DF,
/**/                   0x1911C50F, 0x406865FE,
/**/                   0xD5CE543D, 0x4087D981,
/**/                   0x2134A322, 0x40A8192E,
/**/                   0x4FE6DAC8, 0xBC915CF9,
/**/                   0x56821F74, 0x3FED9C6C,
/**/                   0x00000000, 0x3FFA8000,
/**/                   0x61CEFDBB, 0x3F78F890,
/**/                   0x00000000, 0x3FE9B000,
/**/                   0x30F0DACC, 0x3FFAD49A,
/**/                   0xDDBFEE70, 0x3FFE483C,
/**/                   0xC4418459, 0x40143B8C,
/**/                   0xE6E7E816, 0x40300BD5,
/**/                   0x02EE200E, 0x404C8E1A,
/**/                   0x83038A03, 0x406B2DFC,
/**/                   0xD987E3D9, 0x408B1814,
/**/                   0x8827CEFA, 0x40ABEB1E,
/**/                   0xE22AFCE0, 0x3CA8829A,
/**/                   0x9A4C39D0, 0x3FEDD1D9,
/**/                   0x00000000, 0x3FFAC000,
/**/                   0xF0DACB86, 0x3F749A30,
/**/                   0x00000000, 0x3FE9D000,
/**/                   0x8A66E40D, 0x3FFB1221,
/**/                   0x692DC10A, 0x3FFF4130,
/**/                   0x64621A80, 0x4015457C,
/**/                   0xED2A1AB4, 0x4031369A,
/**/                   0xBC003A70, 0x404F3F8D,
/**/                   0x462E99D6, 0x406E57E1,
/**/                   0xC53F5717, 0x408EDBC2,
/**/                   0x0A71E453, 0x40B0383D,
/**/                   0xBEDD86A9, 0x3C90AF9F,
/**/                   0x030CF708, 0x3FEE07C0,
/**/                   0x00000000, 0x3FFB0000,
/**/                   0x66E40CBE, 0x3F72218A,
/**/                   0x00000000, 0x3FE9F000,
/**/                   0x8E9927E5, 0x3FFB51A7,
/**/                   0x581637B3, 0x40002387,
/**/                   0xF5B2C17E, 0x401662F7,
/**/                   0x36EAC07E, 0x40327DDB,
/**/                   0xC70D9C43, 0x40512110,
/**/                   0x88C52943, 0x4070F9C4,
/**/                   0xB1AB4848, 0x40919E9E,
/**/                   0xB1EC7695, 0x40B2E76B,
/**/                   0x5E9F6FD9, 0x3CAA2400,
/**/                   0x74DD3C64, 0x3FEE3E23,
/**/                   0x00000000, 0x3FFB4000,
/**/                   0x9927E571, 0x3F71A78E,
/**/                   0x00000000, 0x3FEA1000,
/**/                   0x04E0F95F, 0x3FFB9347,
/**/                   0xAC8DC27B, 0x4000AD66,
/**/                   0xAE05A580, 0x401795E1,
/**/                   0x299AA0A0, 0x4033E4FA,
/**/                   0xA33AB75C, 0x4052D0AD,
/**/                   0x39D64C89, 0x407309E5,
/**/                   0x154C34C4, 0x40942D39,
/**/                   0x59D15B1D, 0x40B61A59,
/**/                   0x114BE565, 0xBCAFC899,
/**/                   0x0787FD30, 0x3FEE7508,
/**/                   0x00000000, 0x3FFB8000,
/**/                   0xE0F95E8B, 0x3F734704,
/**/                   0x00000000, 0x3FEA3000,
/**/                   0xB75F37A1, 0x3FFBD71C,
/**/                   0xFC9006E1, 0x40013EBC,
/**/                   0xC48D2C09, 0x4018E055,
/**/                   0xC2C8C9CD, 0x40356FD7,
/**/                   0x6198B971, 0x4054B557,
/**/                   0x9680F9AF, 0x4075678C,
/**/                   0x8AF946DD, 0x40972BE5,
/**/                   0xE1B531F9, 0x40B9EDE4,
/**/                   0xE4527544, 0xBC447F69,
/**/                   0x0A61AD1C, 0x3FEEAC72,
/**/                   0x00000000, 0x3FFBC000,
/**/                   0x5F37A0DF, 0x3F771CB7,
/**/                   0x00000000, 0x3FEA5000,
/**/                   0xA5B24F80, 0x3FFC1D47,
/**/                   0x7EB9F789, 0x4001D81E,
/**/                   0xDF42B6B7, 0x401A44B2,
/**/                   0xB4766752, 0x403722E5,
/**/                   0xECFADFF0, 0x4056D6EE,
/**/                   0x8B1EB8D5, 0x40782028,
/**/                   0xCA840144, 0x409AB0E2,
/**/                   0xE2126BBF, 0x40BE8614,
/**/                   0x2CC624E2, 0xBC8D9A93,
/**/                   0x087F8D20, 0x3FEEE466,
/**/                   0x00000000, 0x3FFC0000,
/**/                   0xB24F8064, 0x3F7D47A5,
/**/                   0x00000000, 0x3FEA7000,
/**/                   0x3DE98207, 0x3FFC65E9,
/**/                   0x811F641B, 0x40027A2E,
/**/                   0xF223266D, 0x401BC5A3,
/**/                   0xA6ECBE29, 0x40390340,
/**/                   0xC3D499AF, 0x40593EB6,
/**/                   0xAD8CC2F1, 0x407B43D9,
/**/                   0xA519B816, 0x409ED77C,
/**/                   0x5B3B703B, 0x40C2080A,
/**/                   0xE993C3DD, 0x3C7B187D,
/**/                   0xCD5A7CE8, 0x3FEF1CE8,
/**/                   0x00000000, 0x3FFC8000,
/**/                   0x167DF937, 0xBF7A16C2,
/**/                   0x00000000, 0x3FEA9000,
/**/                   0x9CA2F05E, 0x3FFCB125,
/**/                   0x54FC4C95, 0x400325A1,
/**/                   0xD9C5FF75, 0x401D662B,
/**/                   0x8E93577D, 0x403B16CE,
/**/                   0xE0E3029E, 0x405BF79A,
/**/                   0x04BCDF91, 0x407EE612,
/**/                   0x31EFE3F1, 0x40A1E0AC,
/**/                   0x85DF051C, 0x40C56267,
/**/                   0x2D0BC06E, 0xBCAD6122,
/**/                   0x69EAB2F0, 0x3FEF55FF,
/**/                   0x00000000, 0x3FFCC000,
/**/                   0xBA1F43E4, 0xBF6DB4C6,
/**/                   0x00000000, 0x3FEAB000,
/**/                   0xD56B9F55, 0x3FFCFF23,
/**/                   0x86149A3B, 0x4003DB3E,
/**/                   0x0B8D0DAD, 0x401F29B3,
/**/                   0x40E9D1A7, 0x403D6463,
/**/                   0x619D6679, 0x405F0E89,
/**/                   0x92CF3FBC, 0x40818F2E,
/**/                   0x844E51BD, 0x40A4CC10,
/**/                   0xF3A9EB60, 0x40C9762D,
/**/                   0xEF4B1E02, 0x3CA20E79,
/**/                   0x3A4BC01C, 0x3FEF8FAF,
/**/                   0x00000000, 0x3FFD0000,
/**/                   0x8C156248, 0xBF2B8552,
/**/                   0x00000000, 0x3FEAD000,
/**/                   0x44AAD4F2, 0x3FFD500E,
/**/                   0x6B85DB68, 0x40049BE3,
/**/                   0xE558F351, 0x40208A0B,
/**/                   0xC1BCC632, 0x403FF3EC,
/**/                   0x2A555E45, 0x40614970,
/**/                   0xDD057F33, 0x408404AE,
/**/                   0x22610A18, 0x40A847D9,
/**/                   0x3C7AA2B4, 0x40CE7146,
/**/                   0x53CA14EC, 0xBC9571D0,
/**/                   0xEBFAA348, 0x3FEFC9FD,
/**/                   0x00000000, 0x3FFD4000,
/**/                   0xAAD4F267, 0x3F700E44,
/**/                   0x00000000, 0x3FEAF000,
/**/                   0xEC9EDC5A, 0x3FFDA412,
/**/                   0x22B6D908, 0x40056886,
/**/                   0xB605B3B4, 0x402194E0,
/**/                   0x9338560C, 0x40416754,
/**/                   0x34B16169, 0x40634B7B,
/**/                   0x3B1BAF9C, 0x4086E508,
/**/                   0xFB9DFBF5, 0x40AC7475,
/**/                   0xF4B4BB01, 0x40D2473E,
/**/                   0xE9F06EFC, 0x3CA82B31,
/**/                   0xC2613F02, 0x3FF00278,
/**/                   0x00000000, 0x3FFDC000,
/**/                   0x6123A5D1, 0xBF7BED13,
/**/                   0x00000000, 0x3FEB1000,
/**/                   0xDF3AE0DB, 0x3FFDFB63,
/**/                   0x08AD38CF, 0x40064239,
/**/                   0xAA166573, 0x4022B7DB,
/**/                   0x38210D3E, 0x4042FFB4,
/**/                   0xFB634456, 0x40659862,
/**/                   0xEE8F3E34, 0x408A45B4,
/**/                   0xD39A6C6F, 0x40B0BD59,
/**/                   0x2B4867E8, 0x40D60CCD,
/**/                   0x1CBB85B3, 0xBCA6097F,
/**/                   0x3537E800, 0x3FF02048,
/**/                   0x00000000, 0x3FFE0000,
/**/                   0x147C93ED, 0xBF527083,
/**/                   0x00000000, 0x3FEB3000,
/**/                   0xB70F5F72, 0x3FFE5637,
/**/                   0xCA935102, 0x40072A2E,
/**/                   0x43559218, 0x4023F5DE,
/**/                   0xB4E19CA3, 0x4044C96E,
/**/                   0x1272DDA3, 0x40683D62,
/**/                   0xC6BFAAED, 0x408E4135,
/**/                   0x099FB249, 0x40B3C717,
/**/                   0xD5294F7D, 0x40DABA6D,
/**/                   0xC91FFA21, 0x3CA488B1,
/**/                   0xB5B309E0, 0x3FF03E70,
/**/                   0x00000000, 0x3FFE4000,
/**/                   0x0F5F723E, 0x3F7637B7,
/**/                   0x00000000, 0x3FEB5000,
/**/                   0x21D4B842, 0x3FFEB4CA,
/**/                   0x2BE08FC5, 0x400821BF,
/**/                   0x6A6A3BD0, 0x40255238,
/**/                   0xBAC907E2, 0x4046CC00,
/**/                   0x94202458, 0x406B4A78,
/**/                   0xFE065CA6, 0x40917C35,
/**/                   0xE8D5B845, 0x40B77848,
/**/                   0x0CD72D76, 0x40E04820,
/**/                   0x9CBE508B, 0x3CA54B6E,
/**/                   0xE41C2ACE, 0x3FF05CF5,
/**/                   0x00000000, 0x3FFEC000,
/**/                   0x568F7C18, 0xBF666BBC,
/**/                   0x00000000, 0x3FEB7000,
/**/                   0x7FB6EB26, 0x3FFF175C,
/**/                   0xA7BA9C35, 0x40092A6C,
/**/                   0x80F5BA9F, 0x4026D0BC,
/**/                   0x33BD74FB, 0x40491048,
/**/                   0x61FCE21F, 0x406ED319,
/**/                   0x60DF5AED, 0x40944A2E,
/**/                   0x1AC97175, 0x40BBFAFC,
/**/                   0xC3A8BC22, 0x40E3F145,
/**/                   0xA70A42D9, 0xBC994B5D,
/**/                   0x9F358760, 0x3FF07BDB,
/**/                   0x00000000, 0x3FFF0000,
/**/                   0xB6EB2582, 0x3F775C7F,
/**/                   0x00000000, 0x3FEB9000,
/**/                   0x9B29492C, 0x3FFF7E36,
/**/                   0x1C35AD8A, 0x400A45EB,
/**/                   0xC8373BB1, 0x402875D7,
/**/                   0x885E6AE6, 0x404BA0D1,
/**/                   0x0831631E, 0x40717784,
/**/                   0x7F51DA78, 0x4097A441,
/**/                   0x6D7642FB, 0x40C0C2B2,
/**/                   0x594961FB, 0x40E89073,
/**/                   0x96CDC181, 0xBCA5DECE,
/**/                   0x0A46374E, 0x3FF09B26,
/**/                   0x00000000, 0x3FFF8000,
/**/                   0x6B6D3D05, 0xBF3C964D,
/**/                   0x00000000, 0x3FEBB000,
/**/                   0x7DD9B1CF, 0x3FFFE9A7,
/**/                   0xB9AE77AF, 0x400B7627,
/**/                   0x3338306D, 0x402A46B0,
/**/                   0xA0CAACE9, 0x404E8A38,
/**/                   0x864F53A2, 0x4073DDBB,
/**/                   0xD6C97F8D, 0x409BAAF0,
/**/                   0xDFAE5A98, 0x40C42EEF,
/**/                   0xE19501DA, 0x40EE701A,
/**/                   0xC7D3D675, 0x3C9CC4F4,
/**/                   0x93EC49AE, 0x3FF0BAD9,
/**/                   0x00000000, 0x40000000,
/**/                   0x264E310D, 0xBF765882,
/**/                   0x00000000, 0x3FEBD000,
/**/                   0x34302F3B, 0x40002D03,
/**/                   0x7F5AAF0D, 0x400CBD52,
/**/                   0x0C635C0A, 0x402C4949,
/**/                   0xB6BB1732, 0x4050EDD1,
/**/                   0x9691A9F4, 0x4076AE3D,
/**/                   0x61482FC6, 0x40A043C7,
/**/                   0xF81EB6E0, 0x40C87037,
/**/                   0xE84FE55E, 0x40F2FA30,
/**/                   0x228FC41D, 0xBC9820F1,
/**/                   0xFDD4AE68, 0x3FF0DAFA,
/**/                   0x00000000, 0x40002000,
/**/                   0x605E76B0, 0x3F7A0668,
/**/                   0x00000000, 0x3FEBF000,
/**/                   0xF9C947A3, 0x400067D9,
/**/                   0xA1722882, 0x400E1DE9,
/**/                   0x41FE0247, 0x402E84B0,
/**/                   0xDBD1D676, 0x4052D3AE,
/**/                   0xE088BEF5, 0x4079FF78,
/**/                   0x64D9A484, 0x40A33780,
/**/                   0x1974F9B5, 0x40CDC32D,
/**/                   0xCE268611, 0x40F7D295,
/**/                   0xD437D23F, 0xBCA5A192,
/**/                   0x657EFDCA, 0x3FF0FB8F,
/**/                   0x00000000, 0x40006000,
/**/                   0x251E8CF3, 0x3F6F67E7,
/**/                   0x00000000, 0x3FEC1000,
/**/                   0xB1FFFA6D, 0x4000A58D,
/**/                   0x4E7307C3, 0x400F9AC7,
/**/                   0x5EA15962, 0x4030809B,
/**/                   0x5418E1B6, 0x405501D0,
/**/                   0xB476D79F, 0x407DED80,
/**/                   0x37F33D5F, 0x40A6D2BF,
/**/                   0xA43F6C6F, 0x40D23C31,
/**/                   0xDB17BBAA, 0x40FE1E46,
/**/                   0x41D8AD56, 0xBCA7EB62,
/**/                   0x4E3ADE0A, 0x3FF11C9C,
/**/                   0x00000000, 0x4000A000,
/**/                   0xFFE9B457, 0x3F6636C7,
/**/                   0x00000000, 0x3FEC3000,
/**/                   0x1D1BDCC6, 0x4000E65A,
/**/                   0x3503CCCE, 0x40109B99,
/**/                   0x7580EC24, 0x4031E45B,
/**/                   0x1803E176, 0x405785CA,
/**/                   0x8458A77D, 0x40814DDB,
/**/                   0x6C115AB7, 0x40AB41D9,
/**/                   0xD7BCE584, 0x40D67DF0,
/**/                   0xF5487646, 0x41032EF5,
/**/                   0xF3631254, 0xBC9C4040,
/**/                   0xAC964DA8, 0x3FF13E27,
/**/                   0x00000000, 0x4000E000,
/**/                   0x6F731770, 0x3F696874,
/**/                   0x00000000, 0x3FEC5000,
/**/                   0x068FBCB4, 0x40012A82,
/**/                   0x7FE89A5F, 0x40117B79,
/**/                   0xD37F3897, 0x40337376,
/**/                   0xDF3B47A2, 0x405A704E,
/**/                   0xEB114449, 0x40841B83,
/**/                   0x8D323120, 0x40B05F75,
/**/                   0x8AE65DDD, 0x40DBEFEC,
/**/                   0xD1814341, 0x4108A2A2,
/**/                   0xFB25EC76, 0x3CA3E83D,
/**/                   0xF37FFEDA, 0x3FF16037,
/**/                   0x00000000, 0x40012000,
/**/                   0x1F796787, 0x3F75040D,
/**/                   0x00000000, 0x3FEC7000,
/**/                   0x5F8F574B, 0x40017250,
/**/                   0xB566493D, 0x40126F35,
/**/                   0x95186E3D, 0x403534F5,
/**/                   0x947D5EA5, 0x405DD60B,
/**/                   0x568C5D73, 0x40877C77,
/**/                   0xA26261F0, 0x40B3CB66,
/**/                   0xBF32194D, 0x40E17B06,
/**/                   0x11490E42, 0x410FE921,
/**/                   0x5376CB61, 0xBCA34428,
/**/                   0x236FE314, 0x3FF182D4,
/**/                   0x00000000, 0x40018000,
/**/                   0xE15169A9, 0xBF7B5F40,
/**/                   0x00000000, 0x3FEC9000,
/**/                   0x91B4C8D8, 0x4001BE19,
/**/                   0xBE69BAE6, 0x4013795B,
/**/                   0xCD6F8B02, 0x40373151,
/**/                   0xD86A7BFF, 0x4060E864,
/**/                   0x515F5BD6, 0x408B95CC,
/**/                   0xD070B4A1, 0x40B8180C,
/**/                   0xC9B24D80, 0x40E60D2C,
/**/                   0xAA392CAF, 0x4114DBF6,
/**/                   0xF5844C55, 0xBCA89BD0,
/**/                   0xDBFAF236, 0x3FF1A603,
/**/                   0x00000000, 0x4001C000,
/**/                   0xB37285FC, 0xBF4E66E4,
/**/                   0x00000000, 0x3FECB000,
/**/                   0x1757F6B1, 0x40020E3D,
/**/                   0xAE890640, 0x40149CE9,
/**/                   0xD6174F60, 0x403972D4,
/**/                   0x8C82DF92, 0x40634079,
/**/                   0xACAB5569, 0x40904BE6,
/**/                   0xB362E75A, 0x40BD8A99,
/**/                   0x389374DC, 0x40EC0ED7,
/**/                   0xCA5E9653, 0x411B8ADF,
/**/                   0x4A1E3E49, 0xBC80CBC7,
/**/                   0x704F5D26, 0x3FF1C9CF,
/**/                   0x00000000, 0x40020000,
/**/                   0xAFED62A2, 0x3F7C7A2E,
/**/                   0x00000000, 0x3FECD000,
/**/                   0x6B3395AA, 0x40026327,
/**/                   0x33FB1467, 0x4015DD66,
/**/                   0xDCF3437C, 0x403C0610,
/**/                   0xC9D7C47A, 0x406607CE,
/**/                   0xA330DC5C, 0x409360FB,
/**/                   0x38A3194B, 0x40C240B4,
/**/                   0xBAA6A879, 0x40F20437,
/**/                   0x04D6F19C, 0x41226106,
/**/                   0x15E5252C, 0x3CABCCF5,
/**/                   0xFF35681A, 0x3FF1EE3F,
/**/                   0x00000000, 0x40026000,
/**/                   0x9CAD4CE9, 0x3F593B59,
/**/                   0x00000000, 0x3FECF000,
/**/                   0x664A8350, 0x4002BD54,
/**/                   0x945190A0, 0x40173EFF,
/**/                   0xC7CC5224, 0x403EFA80,
/**/                   0x896F1658, 0x406958AA,
/**/                   0x4FD54E04, 0x40973450,
/**/                   0x4CD60C4A, 0x40C6BF55,
/**/                   0x3EFFD07C, 0x40F75EBE,
/**/                   0x9E2E6981, 0x4128D03C,
/**/                   0xC8A488FF, 0xBC987CEE,
/**/                   0x8F597306, 0x3FF2135F,
/**/                   0x00000000, 0x4002C000,
/**/                   0xABE583FE, 0xBF555CCD,
/**/                   0x00000000, 0x3FED1000,
/**/                   0x2A40EA5C, 0x40031D52,
/**/                   0x52B4947D, 0x4018C6B3,
/**/                   0x5D01146E, 0x404131AE,
/**/                   0x0163E71C, 0x406D54FB,
/**/                   0xEF3ED15B, 0x409BFE8A,
/**/                   0xA33A6B00, 0x40CC9C28,
/**/                   0x1456E1A6, 0x40FEA523,
/**/                   0xFC8790DB, 0x4130F60F,
/**/                   0x6FABCA41, 0x3CAC104F,
/**/                   0x30D87C68, 0x3FF23939,
/**/                   0x00000000, 0x40032000,
/**/                   0xF8AD1CF9, 0xBF556EAD,
/**/                   0x00000000, 0x3FED3000,
/**/                   0xC053C623, 0x400383C4,
/**/                   0x6ADBFF2C, 0x401A7A81,
/**/                   0xE219A24E, 0x40432C5B,
/**/                   0x30F4B8D8, 0x40711484,
/**/                   0xBC59423E, 0x40A10659,
/**/                   0x3D537AE5, 0x40D22C09,
/**/                   0xA4B7D930, 0x410454A2,
/**/                   0xC151F3C3, 0x41378151,
/**/                   0x779E9951, 0xBCA2F226,
/**/                   0x254E3F9C, 0x3FF25FD9,
/**/                   0x00000000, 0x40038000,
/**/                   0x9E311A8B, 0x3F5E2602,
/**/                   0x00000000, 0x3FED5000,
/**/                   0xA2F65F8C, 0x4003F16A,
/**/                   0x36C0308E, 0x401C61AF,
/**/                   0x5337FF7D, 0x40457C82,
/**/                   0x7FB84BA9, 0x407407A3,
/**/                   0x4C74DEA7, 0x40A4E476,
/**/                   0xDF1C2124, 0x40D75638,
/**/                   0xA2556E94, 0x410B5320,
/**/                   0x7D68ABBE, 0x414087CD,
/**/                   0x73A87AB9, 0xBCACD58C,
/**/                   0x10017B06, 0x3FF2874D,
/**/                   0x00000000, 0x40040000,
/**/                   0x1340E849, 0xBF7D2ABA,
/**/                   0x00000000, 0x3FED7000,
/**/                   0x7BA9A810, 0x40046722,
/**/                   0xCBC74735, 0x401E851F,
/**/                   0xF3879985, 0x40483596,
/**/                   0xCD297F00, 0x4077AAEB,
/**/                   0x31669F50, 0x40A9E3C8,
/**/                   0xB7CBB664, 0x40DE5420,
/**/                   0xB75100A0, 0x41129F7B,
/**/                   0x51D127BF, 0x4147A1C1,
/**/                   0x46D9C78F, 0x3CAC647E,
/**/                   0x304962AE, 0x3FF2AFA4,
/**/                   0x00000000, 0x40046000,
/**/                   0xA6A041C9, 0x3F6C89EE,
/**/                   0x00000000, 0x3FED9000,
/**/                   0x7A99A835, 0x4004E5F2,
/**/                   0x15B0232D, 0x402077E5,
/**/                   0xEE468866, 0x404B70C1,
/**/                   0x43A041C3, 0x407C334A,
/**/                   0x53D2C164, 0x40B036D1,
/**/                   0x10CCEDBE, 0x40E3F7B1,
/**/                   0xF6C2E560, 0x4119C160,
/**/                   0x6D21D20F, 0x415131DD,
/**/                   0x2EC50766, 0x41878683,
/**/                   0xD1134ECC, 0xBCA95596,
/**/                   0xA8F4B028, 0x3FF2D8EF,
/**/                   0x00000000, 0x4004E000,
/**/                   0x66A0D2C7, 0x3F67C9EA,
/**/                   0x00000000, 0x3FEDB000,
/**/                   0xD6373B90, 0x40056F11,
/**/                   0xC3747DF3, 0x4021D7AC,
/**/                   0x6A014D6F, 0x404F4EF3,
/**/                   0x505C454B, 0x4080F4C4,
/**/                   0x214975C5, 0x40B48D16,
/**/                   0xF57BFAC6, 0x40EAACFD,
/**/                   0x5225A6ED, 0x41222235,
/**/                   0xACBA67AB, 0x41598643,
/**/                   0xDE5D19B9, 0x419267B9,
/**/                   0x42C92439, 0xBCAEF63C,
/**/                   0xD86BED76, 0x3FF30342,
/**/                   0x00000000, 0x40056000,
/**/                   0x6E771F48, 0x3F7E23AC,
/**/                   0x00000000, 0x3FEDD000,
/**/                   0x3D2D8CF1, 0x400603F5,
/**/                   0xEF4A10FA, 0x40236A84,
/**/                   0x4EA265AF, 0x4051FDF3,
/**/                   0xD944F636, 0x408499B5,
/**/                   0x37F73BAC, 0x40BA64B8,
/**/                   0x259B27FC, 0x40F21B9F,
/**/                   0x265D5B9F, 0x412A0669,
/**/                   0x3DC806E2, 0x41635D8E,
/**/                   0x36AD8B00, 0x419D8657,
/**/                   0x3FFCDCA3, 0x3CA4CEEB,
/**/                   0xC69D2D10, 0x3FF32EB3,
/**/                   0x00000000, 0x40060000,
/**/                   0x6C678625, 0x3F5FA9E9,
/**/                   0x00000000, 0x3FEDF000,
/**/                   0x5FCDF915, 0x4006A65F,
/**/                   0x68321BDA, 0x40253B6E,
/**/                   0x706E8DA9, 0x4054D949,
/**/                   0x4A70D2D7, 0x408950EF,
/**/                   0x1F15E14E, 0x40C13319,
/**/                   0x846A9BD5, 0x40F907B1,
/**/                   0x17C39016, 0x4133139C,
/**/                   0xBC86F11B, 0x416E1DA3,
/**/                   0xD9F86F3B, 0x41A8597F,
/**/                   0x7D0D5190, 0x3C32D4F8,
/**/                   0xAFA88354, 0x3FF35B5B,
/**/                   0x00000000, 0x4006A000,
/**/                   0x37E455FD, 0x3F697D7F,
/**/                   0x00000000, 0x3FEE1000,
/**/                   0x41D1DBF9, 0x40075877,
/**/                   0xF5852184, 0x402758A8,
/**/                   0x65C0F467, 0x405861EE,
/**/                   0xD2D91276, 0x408F83C0,
/**/                   0x43EC3B0E, 0x40C6CA7C,
/**/                   0x718322C8, 0x4101A722,
/**/                   0x9533D806, 0x413CA4C6,
/**/                   0xE9899583, 0x417812B7,
/**/                   0x85EE8B86, 0x41B4B875,
/**/                   0xD1AEEED1, 0xBC99DEFB,
/**/                   0xB510476E, 0x3FF38957,
/**/                   0x00000000, 0x40076000,
/**/                   0xB8901BF9, 0xBF6E22F8,
/**/                   0x00000000, 0x3FEE3000,
/**/                   0xE1C37E57, 0x40081CE6,
/**/                   0xD3DC9910, 0x4029D4F3,
/**/                   0xE3095065, 0x405CD074,
/**/                   0xC5C38224, 0x4093E764,
/**/                   0x3CAE1F31, 0x40CEC5AE,
/**/                   0xC0645F38, 0x41097A50,
/**/                   0xD8A7F25E, 0x41461866,
/**/                   0x8C2F04A3, 0x4183DAF5,
/**/                   0xA9143C1F, 0x41C2450E,
/**/                   0x9FD995BC, 0x3C7D25BE,
/**/                   0xC35D33E6, 0x3FF3B8C9,
/**/                   0x00000000, 0x40082000,
/**/                   0xE40D49E0, 0xBF58C8F1,
/**/                   0x00000000, 0x3FEE5000,
/**/                   0x285640BB, 0x4008F706,
/**/                   0x3B2B7CD1, 0x402CC96B,
/**/                   0xC5341328, 0x40613ADF,
/**/                   0x16E928A9, 0x4099908D,
/**/                   0x7CC08A3C, 0x40D53986,
/**/                   0x31DD3E45, 0x4112DFC5,
/**/                   0xE2A13787, 0x41519499,
/**/                   0xF94424AD, 0x4190F943,
/**/                   0xCDCD49BE, 0x41D0C6BC,
/**/                   0x6D41701D, 0xBC9E2458,
/**/                   0xC088BD28, 0x3FF3E9D9,
/**/                   0x00000000, 0x40090000,
/**/                   0x537E8A00, 0xBF71F3AF,
/**/                   0x00000000, 0x3FEE7000,
/**/                   0x6562D1E0, 0x4009EB18,
/**/                   0x75651223, 0x40302C31,
/**/                   0x336E41C7, 0x4064E431,
/**/                   0xA065DA69, 0x40A0BCA6,
/**/                   0x917AF357, 0x40DE034D,
/**/                   0x4168FB0F, 0x411CD2C1,
/**/                   0x15BB794D, 0x415CFEB6,
/**/                   0x6EFFD5E5, 0x419E3EE1,
/**/                   0x1ACB4D9C, 0x41E024E7,
/**/                   0xD93F153F, 0xBC9C29C8,
/**/                   0x2183E810, 0x3FF41CB7,
/**/                   0x00000000, 0x4009E000,
/**/                   0xC5A3C038, 0x3F7630CA,
/**/                   0x00000000, 0x3FEE9000,
/**/                   0xA364196F, 0x400AFEA6,
/**/                   0x0B19A2EB, 0x403258F3,
/**/                   0x2520AC75, 0x4069BDA5,
/**/                   0x8F67EDEA, 0x40A669BC,
/**/                   0xC026C9F8, 0x40E5D78C,
/**/                   0x1E3B36C2, 0x4126CCB4,
/**/                   0xBF45C805, 0x4168EDE4,
/**/                   0x8AC89E76, 0x41AC2F6A,
/**/                   0x4CA9EB55, 0x41F0675E,
/**/                   0x0D13E3DF, 0x42336AC1,
/**/                   0xF2DE93A6, 0x3C9B1D74,
/**/                   0x155FB22E, 0x3FF4519B,
/**/                   0x00000000, 0x400B0000,
/**/                   0xBE690E67, 0xBF4595C9,
/**/                   0x00000000, 0x3FEEB000,
/**/                   0x4BD1C065, 0x400C3908,
/**/                   0x26C39FFD, 0x40350D88,
/**/                   0x69D3E79E, 0x4070296B,
/**/                   0xD7FEEA5D, 0x40AED279,
/**/                   0xFD5BD547, 0x40F072A8,
/**/                   0x4A08BB38, 0x4132CDB9,
/**/                   0x536BED06, 0x41768482,
/**/                   0x2F10E88D, 0x41BBE1FF,
/**/                   0xABDBBDAC, 0x4201C966,
/**/                   0x02E62DDA, 0x42471011,
/**/                   0x3E907E71, 0xBCA0855D,
/**/                   0x8FA73920, 0x3FF488CB,
/**/                   0x00000000, 0x400C4000,
/**/                   0xB8FE6DDF, 0xBF6BDED0,
/**/                   0x00000000, 0x3FEED000,
/**/                   0x12AAF9A9, 0x400DA439,
/**/                   0x62F25109, 0x40387D46,
/**/                   0x3F133A3F, 0x4074C339,
/**/                   0x662036F9, 0x40B5E143,
/**/                   0x74467831, 0x40F9CF04,
/**/                   0x576C6FA8, 0x41404E10,
/**/                   0xFF4F8E88, 0x41859489,
/**/                   0xB44962A9, 0x41CD88D2,
/**/                   0x97A288F3, 0x4214D838,
/**/                   0x6CF738B3, 0x425DE10B,
/**/                   0x5F7263CC, 0xBC8E9EA7,
/**/                   0xAA786F36, 0x3FF4C29F,
/**/                   0x00000000, 0x400DA000,
/**/                   0xABE6A2AD, 0x3F60E44A,
/**/                   0x00000000, 0x3FEEF000,
/**/                   0xC169B52F, 0x400F4E35,
/**/                   0x29E8699C, 0x403CF773,
/**/                   0xFC1818D6, 0x407B6D37,
/**/                   0x1386790A, 0x40C02655,
/**/                   0x4FF79D1E, 0x41054A1F,
/**/                   0x7DB0265A, 0x414E104A,
/**/                   0xE5C8114B, 0x41963C39,
/**/                   0xF52A87DB, 0x41E10156,
/**/                   0x2E9E7ABE, 0x422ADD76,
/**/                   0x6EC81361, 0x427586AB,
/**/                   0xE395EEA6, 0x3C935690,
/**/                   0x2E5965A2, 0x3FF4FF86,
/**/                   0x00000000, 0x400F4000,
/**/                   0xD36A5E70, 0x3F7C6B82 } };

#endif
#endif
