/*
 * IBM Accurate Mathematical Library
 * Written by International Business Machines Corp.
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/****************************************************************/
/* TABLES FOR THE ulog() FUNCTION                               */
/****************************************************************/

#ifdef BIG_ENDI

static const  union {
  int i[1424];
  double x[712];
} coar = { .i = {
  0x3FE69A59,  0xC8000000,  0x3DF22D4D,  0x6079C9F7,
  0x3FE6A5A9,  0xC8000000,  0x3E19882D,  0x25AF6823,
  0x3FE6B0FF,  0x74000000,  0xBE221476,  0x31DABF59,
  0x3FE6BC5A,  0xC8000000,  0x3E2312AC,  0x99A2DC0A,
  0x3FE6C7BB,  0xD0000000,  0xBE265926,  0xCE9F9355,
  0x3FE6D322,  0x84000000,  0x3E2F2C26,  0x2D298DED,
  0x3FE6DE8E,  0xF4000000,  0xBE2EC28E,  0x1E748D2F,
  0x3FE6EA01,  0x14000000,  0x3E2D8C6D,  0xC68CB7E5,
  0x3FE6F578,  0xF4000000,  0x3DEE1A9E,  0x419FE2F0,
  0x3FE700F6,  0x90000000,  0xBDFF1AFD,  0xDEAEAE34,
  0x3FE70C79,  0xEC000000,  0xBE0730FE,  0x558B7122,
  0x3FE71803,  0x0C000000,  0xBE25CB85,  0x2D280C3B,
  0x3FE72391,  0xF0000000,  0xBE06F2CE,  0x337B7B54,
  0x3FE72F26,  0x9C000000,  0x3E289BCA,  0x45C02B72,
  0x3FE73AC1,  0x18000000,  0xBE18DEA6,  0x5039F1CA,
  0x3FE74661,  0x60000000,  0xBE09D090,  0x86CE0538,
  0x3FE75207,  0x78000000,  0x3E290E79,  0xCFCE5DDB,
  0x3FE75DB3,  0x68000000,  0x3DD61DF0,  0xB249A17C,
  0x3FE76965,  0x2C000000,  0x3E2F22F7,  0xE13445F7,
  0x3FE7751C,  0xD0000000,  0xBE2CD454,  0x874E75CE,
  0x3FE780DA,  0x4C000000,  0xBE0159CE,  0xDF43E3BC,
  0x3FE78C9D,  0xA8000000,  0x3E279291,  0x699A1332,
  0x3FE79866,  0xEC000000,  0xBE2A0BCD,  0x2DD98C6C,
  0x3FE7A436,  0x10000000,  0x3E25F375,  0x15AC979E,
  0x3FE7B00B,  0x20000000,  0x3E26CCF5,  0x2FEAFCF6,
  0x3FE7BBE6,  0x1C000000,  0x3E27D4F4,  0x53ADAD67,
  0x3FE7C7C7,  0x08000000,  0x3E10EEC7,  0x7FBD9566,
  0x3FE7D3AD,  0xE4000000,  0x3E2837F0,  0x9A831D86,
  0x3FE7DF9A,  0xB8000000,  0xBE129BE0,  0x5CB4C35B,
  0x3FE7EB8D,  0x80000000,  0x3E23990A,  0x0234F04D,
  0x3FE7F786,  0x44000000,  0x3E2EB807,  0x64D5C842,
  0x3FE80385,  0x08000000,  0x3E0FC86F,  0x02B4E9E8,
  0x3FE80F89,  0xCC000000,  0xBDD7B5B3,  0x7B4274BF,
  0x3FE81B94,  0x94000000,  0xBE16888B,  0xB899B00F,
  0x3FE827A5,  0x60000000,  0x3E288971,  0x5E94D155,
  0x3FE833BC,  0x38000000,  0x3E2AEEB2,  0x099F3E5E,
  0x3FE83FD9,  0x20000000,  0xBE23B922,  0x3FF60B7C,
  0x3FE84BFC,  0x14000000,  0xBDF7D3B1,  0x2DBD8012,
  0x3FE85825,  0x1C000000,  0xBDF24BA3,  0xA8872BEB,
  0x3FE86454,  0x38000000,  0x3E2EFE04,  0x01AA18A7,
  0x3FE87089,  0x70000000,  0x3E21986C,  0x944496A2,
  0x3FE87CC4,  0xC4000000,  0x3E096A8B,  0xB71FFAFF,
  0x3FE88906,  0x38000000,  0xBE21CE0A,  0xBC4C7AC5,
  0x3FE8954D,  0xCC000000,  0xBE076F45,  0xBAC02491,
  0x3FE8A19B,  0x84000000,  0x3E2B4FA2,  0xD922B925,
  0x3FE8ADEF,  0x68000000,  0x3DF759DB,  0x641863AF,
  0x3FE8BA49,  0x78000000,  0xBE2DB97C,  0xC6AB5E04,
  0x3FE8C6A9,  0xB4000000,  0xBE25364C,  0xE2156713,
  0x3FE8D310,  0x20000000,  0x3E1BEB7C,  0x862BEFF7,
  0x3FE8DF7C,  0xC4000000,  0xBDF4DD0C,  0x1CEA33A5,
  0x3FE8EBEF,  0xA0000000,  0xBE2537DF,  0x51797D47,
  0x3FE8F868,  0xB4000000,  0x3E0FB1C4,  0xF0107B28,
  0x3FE904E8,  0x08000000,  0x3E0AD6A1,  0xE01B68BD,
  0x3FE9116D,  0x9C000000,  0x3E292117,  0x1F78D9D9,
  0x3FE91DF9,  0x78000000,  0xBE1D75DA,  0x4F50E5CF,
  0x3FE92A8B,  0x98000000,  0x3DE5102B,  0x74959E58,
  0x3FE93724,  0x04000000,  0xBE01CA50,  0xD2216C35,
  0x3FE943C2,  0xBC000000,  0x3E225BFD,  0xB0B05884,
  0x3FE95067,  0xC8000000,  0xBE0F2183,  0x60B7C5C1,
  0x3FE95D13,  0x24000000,  0x3E2FB47A,  0xB5860441,
  0x3FE969C4,  0xDC000000,  0xBE01FFD2,  0xE2D4059E,
  0x3FE9767C,  0xEC000000,  0xBDE9ED72,  0x12BB6A8D,
  0x3FE9833B,  0x58000000,  0x3E2B3815,  0x43BFFB24,
  0x3FE99000,  0x28000000,  0x3E03FA22,  0xEE9EAD1E,
  0x3FE99CCB,  0x5C000000,  0xBE213841,  0x377138F7,
  0x3FE9A99C,  0xF4000000,  0x3E178105,  0xDB636C94,
  0x3FE9B674,  0xF8000000,  0x3E1E5E7A,  0xF5720122,
  0x3FE9C353,  0x6C000000,  0xBE238BFF,  0xA2AC5AAE,
  0x3FE9D038,  0x4C000000,  0x3E270893,  0xF93BDBD8,
  0x3FE9DD23,  0xA4000000,  0x3DF40420,  0x354B86CF,
  0x3FE9EA15,  0x74000000,  0xBE2D76D3,  0x88CB06B7,
  0x3FE9F70D,  0xBC000000,  0xBE251639,  0x9ED0EC60,
  0x3FEA040C,  0x80000000,  0x3E1F06E9,  0xE2DDE506,
  0x3FEA1111,  0xC8000000,  0x3E014549,  0x8E6DB477,
  0x3FEA1E1D,  0x94000000,  0xBDF4BC17,  0xF8716509,
  0x3FEA2B2F,  0xE8000000,  0xBE2107DB,  0xDA723A49,
  0x3FEA3848,  0xC4000000,  0x3E1A932A,  0x986AA369,
  0x3FEA4568,  0x30000000,  0x3E198092,  0x41592CDB,
  0x3FEA528E,  0x30000000,  0xBE2E260F,  0x676BCAB8,
  0x3FEA5FBA,  0xC0000000,  0x3DE2E821,  0x2D5D5610,
  0x3FEA6CED,  0xE8000000,  0x3E2F7046,  0x7DA20167,
  0x3FEA7A27,  0xB0000000,  0xBE1D2832,  0xF9FAAD30,
  0x3FEA8768,  0x14000000,  0xBE23F788,  0x43FA6C45,
  0x3FEA94AF,  0x18000000,  0x3E011E27,  0xAA082732,
  0x3FEAA1FC,  0xC4000000,  0xBE20BACB,  0xC682F0BF,
  0x3FEAAF51,  0x18000000,  0xBE2DC7DD,  0x7BD08C78,
  0x3FEABCAC,  0x14000000,  0x3E2271A2,  0xA3B10F9A,
  0x3FEACA0D,  0xC4000000,  0xBE15449C,  0x7966F94C,
  0x3FEAD776,  0x24000000,  0x3DD06137,  0x6FD8F3EE,
  0x3FEAE4E5,  0x3C000000,  0xBE267CD1,  0x8C5A144A,
  0x3FEAF25B,  0x0C000000,  0xBE29E584,  0xB59DA94B,
  0x3FEAFFD7,  0x98000000,  0xBE23DFCF,  0x7B52192F,
  0x3FEB0D5A,  0xE4000000,  0xBE1CF2FE,  0x78A76B45,
  0x3FEB1AE4,  0xF4000000,  0xBE23A561,  0x7EC80FF6,
  0x3FEB2875,  0xC8000000,  0x3E22C4C9,  0x932EED68,
  0x3FEB360D,  0x68000000,  0x3E2B085C,  0xB5833C97,
  0x3FEB43AB,  0xD8000000,  0xBE01F093,  0x93B9319A,
  0x3FEB5151,  0x18000000,  0xBE254F01,  0xFABCE670,
  0x3FEB5EFD,  0x28000000,  0x3E2F24C2,  0x627ABFB0,
  0x3FEB6CB0,  0x14000000,  0x3E1F1EEC,  0xE6AC0B48,
  0x3FEB7A69,  0xDC000000,  0xBE1A8671,  0x127F9ABC,
  0x3FEB882A,  0x80000000,  0xBDCB0C28,  0xC87C73B3,
  0x3FEB95F2,  0x08000000,  0xBE22E8DD,  0x7F2B5A97,
  0x3FEBA3C0,  0x74000000,  0xBE1B3645,  0x2D22A9D5,
  0x3FEBB195,  0xC8000000,  0x3E0ADACA,  0x428F8B88,
  0x3FEBBF72,  0x0C000000,  0xBE2E9E07,  0xCDF9F681,
  0x3FEBCD55,  0x3C000000,  0xBE08A127,  0x7FA54ACF,
  0x3FEBDB3F,  0x60000000,  0x3E0E92CE,  0x8225B385,
  0x3FEBE930,  0x7C000000,  0x3DF38C2A,  0x7BB09485,
  0x3FEBF728,  0x94000000,  0xBE2DFD64,  0xF681FA5F,
  0x3FEC0527,  0xA4000000,  0x3E2E384D,  0xDCE88BD2,
  0x3FEC132D,  0xBC000000,  0xBE20F111,  0xFE46A893,
  0x3FEC213A,  0xD4000000,  0x3E193DA1,  0xB189BFDA,
  0x3FEC2F4E,  0xF8000000,  0xBE20E3A1,  0x0E39FB00,
  0x3FEC3D6A,  0x24000000,  0x3E1DB044,  0x30F0FAC5,
  0x3FEC4B8C,  0x64000000,  0xBE2BC12C,  0x97446B17,
  0x3FEC59B5,  0xB4000000,  0xBE282696,  0x963F4150,
  0x3FEC67E6,  0x18000000,  0x3E224D26,  0x3049824B,
  0x3FEC761D,  0x98000000,  0x3E2C5BA5,  0x87F84C7D,
  0x3FEC845C,  0x38000000,  0xBDE1D14D,  0xC4852339,
  0x3FEC92A1,  0xF8000000,  0xBE1A451E,  0x5588D9E1,
  0x3FECA0EE,  0xDC000000,  0xBE1D3B96,  0x68BFF457,
  0x3FECAF42,  0xE8000000,  0xBE18B670,  0x4DADF774,
  0x3FECBD9E,  0x20000000,  0xBE1A1548,  0x7FB1FC01,
  0x3FECCC00,  0x88000000,  0xBE273F2E,  0x78FC5AF0,
  0x3FECDA6A,  0x20000000,  0x3E1D218F,  0xA6F4A841,
  0x3FECE8DA,  0xF0000000,  0x3E2E0BA9,  0x4D002CA0,
  0x3FECF752,  0xFC000000,  0x3E20F4BB,  0x065EF979,
  0x3FED05D2,  0x48000000,  0xBE2ED3D5,  0x11793B33,
  0x3FED1458,  0xD0000000,  0x3E115E3C,  0x913341B3,
  0x3FED22E6,  0xA0000000,  0x3DE97C02,  0xB3546109,
  0x3FED317B,  0xB8000000,  0x3E087540,  0x1BF898EF,
  0x3FED4018,  0x1C000000,  0x3E209430,  0x346F9641,
  0x3FED4EBB,  0xD0000000,  0x3E2B6DF4,  0x88F4B20B,
  0x3FED5D66,  0xDC000000,  0xBE2EC68F,  0x0CB26035,
  0x3FED6C19,  0x38000000,  0x3E2CA2C8,  0x1F44D9C3,
  0x3FED7AD2,  0xF4000000,  0x3E10E6F4,  0x41704EE0,
  0x3FED8994,  0x0C000000,  0x3E2F9273,  0x25F8F0E2,
  0x3FED985C,  0x88000000,  0x3E2D041A,  0x318798DE,
  0x3FEDA72C,  0x6C000000,  0xBE005680,  0x9349CF58,
  0x3FEDB603,  0xB8000000,  0xBE10F665,  0xCF0C934D,
  0x3FEDC4E2,  0x70000000,  0x3E166124,  0x19461C64,
  0x3FEDD3C8,  0x9C000000,  0xBE1B2ED6,  0x405624C8,
  0x3FEDE2B6,  0x3C000000,  0xBE273A7F,  0x62171501,
  0x3FEDF1AB,  0x54000000,  0xBE26022B,  0xE36E1450,
  0x3FEE00A7,  0xE8000000,  0xBE1C341E,  0x2E07AE15,
  0x3FEE0FAB,  0xFC000000,  0xBDFC7EAE,  0x18D0E701,
  0x3FEE1EB7,  0x94000000,  0x3E06B34F,  0xECD1FF8B,
  0x3FEE2DCA,  0xB4000000,  0x3E1394A3,  0x6813A649,
  0x3FEE3CE5,  0x60000000,  0x3E045496,  0xC1754D14,
  0x3FEE4C07,  0x9C000000,  0xBE180FFF,  0xF5C6087C,
  0x3FEE5B31,  0x68000000,  0x3E22FBCD,  0xADD9A300,
  0x3FEE6A62,  0xCC000000,  0x3E2EC7C7,  0xAF0289E5,
  0x3FEE799B,  0xCC000000,  0x3E242182,  0x3FB3EDD4,
  0x3FEE88DC,  0x6C000000,  0xBE201304,  0x04E39885,
  0x3FEE9824,  0xAC000000,  0xBE20D352,  0xE6831D31,
  0x3FEEA774,  0x90000000,  0x3E1E032D,  0x618DFCEB,
  0x3FEEB6CC,  0x20000000,  0x3E1956A3,  0xF9BB457E,
  0x3FEEC62B,  0x60000000,  0xBE2A77E0,  0x50845DB2,
  0x3FEED592,  0x4C000000,  0x3E2714F7,  0x47C43858,
  0x3FEEE500,  0xF0000000,  0x3E2EED96,  0x71813A66,
  0x3FEEF477,  0x50000000,  0xBE04CDBE,  0x4FB4AA34,
  0x3FEF03F5,  0x6C000000,  0xBE2774A2,  0x86EB4FF5,
  0x3FEF137B,  0x48000000,  0xBE29DD95,  0xAD43B2D2,
  0x3FEF2308,  0xE8000000,  0xBE1CADB0,  0xAC16E506,
  0x3FEF329E,  0x50000000,  0x3E12AC33,  0x58745C7B,
  0x3FEF423B,  0x88000000,  0xBE248118,  0x6EC2D854,
  0x3FEF51E0,  0x8C000000,  0x3E26986B,  0x304ACE08,
  0x3FEF618D,  0x68000000,  0x3E126D81,  0x3B09354E,
  0x3FEF7142,  0x1C000000,  0x3DF06AAE,  0x773C23B3,
  0x3FEF80FE,  0xAC000000,  0xBDA105B6,  0xD82EF423,
  0x3FEF90C3,  0x1C000000,  0x3DECDEED,  0x465499B8,
  0x3FEFA08F,  0x70000000,  0x3E0AEFD4,  0xE2EF03AE,
  0x3FEFB063,  0xAC000000,  0x3E1BD4C0,  0x0567B2E7,
  0x3FEFC03F,  0xD4000000,  0x3E26AA22,  0x4F97FCBF,
  0x3FEFD023,  0xF0000000,  0xBE2F9420,  0x5E4E88D1,
  0x3FEFE00F,  0xFC000000,  0xBE254004,  0x438E52E2,
  0x3FEFF004,  0x00000000,  0xBE1552AA,  0xEEE93EFC,
  0x3FF00000,  0x00000000,  0x00000000,  0x00000000,
  0x3FF00802,  0x00000000,  0x3E155800,  0x4449F507,
  0x3FF01008,  0x04000000,  0xBE354AA8,  0x882D75D6,
  0x3FF01812,  0x08000000,  0x3E303610,  0x3740DE56,
  0x3FF02020,  0x14000000,  0x3E360044,  0x5B0C3264,
  0x3FF02832,  0x28000000,  0x3E3C4C26,  0x0197EDC3,
  0x3FF03048,  0x48000000,  0x3E0B103B,  0x5046CA09,
  0x3FF03862,  0x74000000,  0xBE34659C,  0xF9A62624,
  0x3FF04080,  0xAC000000,  0xBE254438,  0xDD0A8F37,
  0x3FF048A2,  0xF4000000,  0x3DF256C2,  0x97AFB6E2,
  0x3FF050C9,  0x50000000,  0xBE3085DF,  0x923D25E1,
  0x3FF058F3,  0xC0000000,  0xBE3F0A93,  0x5EA3B091,
  0x3FF06122,  0x44000000,  0xBE237DE4,  0x5D63534C,
  0x3FF06954,  0xE0000000,  0x3E301719,  0xFF0C58B7,
  0x3FF0718B,  0x98000000,  0x3E2E8410,  0x9DF7B665,
  0x3FF079C6,  0x6C000000,  0x3E349CB9,  0x3B127222,
  0x3FF08205,  0x60000000,  0x3DF127EC,  0x98E0BD08,
  0x3FF08A48,  0x74000000,  0xBE24C1B6,  0x706CC41F,
  0x3FF0928F,  0xA8000000,  0x3E334EF9,  0x093044EF,
  0x3FF09ADB,  0x04000000,  0xBE1304B1,  0x56BC6C83,
  0x3FF0A32A,  0x84000000,  0x3E2D383E,  0xB028B984,
  0x3FF0AB7E,  0x30000000,  0xBE315B1E,  0x64E7A202,
  0x3FF0B3D6,  0x04000000,  0xBE0AC1E6,  0xC678291E,
  0x3FF0BC32,  0x04000000,  0x3E3A0418,  0x2F12FFE2,
  0x3FF0C492,  0x38000000,  0xBE37D617,  0x43D6D302,
  0x3FF0CCF6,  0x98000000,  0x3E2133F2,  0x152CC8FA,
  0x3FF0D55F,  0x2C000000,  0x3E3CE5D1,  0xE966E6B7,
  0x3FF0DDCB,  0xF8000000,  0x3E1ABF24,  0x7BCACA64,
  0x3FF0E63C,  0xFC000000,  0xBE3854F6,  0x2E8CDBED,
  0x3FF0EEB2,  0x38000000,  0xBE3E6463,  0x0C32156B,
  0x3FF0F72B,  0xAC000000,  0x3E365671,  0xB69772CC,
  0x3FF0FFA9,  0x64000000,  0xBE383E9A,  0x02B1201A,
  0x3FF1082B,  0x58000000,  0xBE205962,  0x50549CC0,
  0x3FF110B1,  0x90000000,  0xBE376BFE,  0xFFDACA72,
  0x3FF1193C,  0x08000000,  0x3E3C1C59,  0x5C43E2F3,
  0x3FF121CA,  0xCC000000,  0xBE26D374,  0xF7067C8B,
  0x3FF12A5D,  0xD4000000,  0x3E343CCC,  0x4DDAFE1D,
  0x3FF132F5,  0x28000000,  0x3E3D5C16,  0x58EBCB7F,
  0x3FF13B90,  0xCC000000,  0xBE2B5D12,  0xB66E8B53,
  0x3FF14430,  0xBC000000,  0xBE24E919,  0xB326B482,
  0x3FF14CD4,  0xFC000000,  0x3E23139A,  0xC8AABD43,
  0x3FF1557D,  0x90000000,  0x3E30DD8B,  0x16743B55,
  0x3FF15E2A,  0x7C000000,  0xBE31D701,  0x35904C50,
  0x3FF166DB,  0xBC000000,  0x3E107F42,  0x30E0CA83,
  0x3FF16F91,  0x58000000,  0xBE24F1F2,  0xDA1B7123,
  0x3FF1784B,  0x50000000,  0xBE3ACAF2,  0x0DC79E23,
  0x3FF18109,  0xA4000000,  0xBE23DC79,  0x609374EE,
  0x3FF189CC,  0x58000000,  0x3E262CF7,  0x3A40C3B7,
  0x3FF19293,  0x70000000,  0x3E1D3833,  0x5A24F463,
  0x3FF19B5E,  0xEC000000,  0x3E2BA9AD,  0x8A2E4440,
  0x3FF1A42E,  0xD0000000,  0x3DFD8CBC,  0x61C41828,
  0x3FF1AD03,  0x1C000000,  0x3E1A65E6,  0x5A4DDF0D,
  0x3FF1B5DB,  0xD4000000,  0xBDE2FDBB,  0x9F828DB5,
  0x3FF1BEB8,  0xF8000000,  0x3E2F4EE8,  0xB79B700F,
  0x3FF1C79A,  0x8C000000,  0x3E3ACC35,  0x0DE1D7E8,
  0x3FF1D080,  0x94000000,  0x3E11729E,  0xFF9E20A0,
  0x3FF1D96B,  0x10000000,  0xBE300F18,  0x6C2EA70B,
  0x3FF1E25A,  0x00000000,  0x3DF32E02,  0xCE425A35,
  0x3FF1EB4D,  0x68000000,  0x3E3BDE56,  0x9A322D12,
  0x3FF1F445,  0x50000000,  0xBE3C3F0D,  0xBA737AEF,
  0x3FF1FD41,  0xB0000000,  0xBE0A2DD0,  0xC896DB7A,
  0x3FF20642,  0x90000000,  0x3E2577B0,  0xF8B782F6,
  0x3FF20F47,  0xF4000000,  0xBE2C6DA3,  0x73607FC8,
  0x3FF21851,  0xD8000000,  0x3E35F7D1,  0xC8917348,
  0x3FF22160,  0x44000000,  0x3E3B6F5C,  0xCF9CED69,
  0x3FF22A73,  0x3C000000,  0xBE39967E,  0x85775C2E,
  0x3FF2338A,  0xB8000000,  0x3E3B3213,  0x497226D4,
  0x3FF23CA6,  0xC4000000,  0x3E3E2710,  0x30733227,
  0x3FF245C7,  0x60000000,  0x3E33B8A9,  0xAF215A72,
  0x3FF24EEC,  0x90000000,  0xBE3F96B2,  0x1365623F,
  0x3FF25816,  0x50000000,  0xBE37324F,  0x27DEE202,
  0x3FF26144,  0xA4000000,  0x3E318CD5,  0x4E484D87,
  0x3FF26A77,  0x94000000,  0xBDE3FD37,  0xA94519E8,
  0x3FF273AF,  0x1C000000,  0x3E37132F,  0xEE788C29,
  0x3FF27CEB,  0x44000000,  0xBE03DDB7,  0xE842E5C0,
  0x3FF2862C,  0x08000000,  0x3E37A3FB,  0xE17C9693,
  0x3FF28F71,  0x70000000,  0x3E24EABF,  0xAEB3D9A0,
  0x3FF298BB,  0x7C000000,  0xBE13C7B6,  0x853B0733,
  0x3FF2A20A,  0x2C000000,  0x3E2D2C80,  0xC7B588B5,
  0x3FF2AB5D,  0x88000000,  0xBE35B750,  0x708F3912,
  0x3FF2B4B5,  0x8C000000,  0xBE291A70,  0xD5FD9130,
  0x3FF2BE12,  0x3C000000,  0x3E2EE937,  0x0CCF9F73,
  0x3FF2C773,  0xA0000000,  0xBE3C3F0C,  0xD42CF76C,
  0x3FF2D0D9,  0xB0000000,  0x3E35DD54,  0x60763D61,
  0x3FF2DA44,  0x78000000,  0x3E26C418,  0xE7D6AA3B,
  0x3FF2E3B3,  0xF8000000,  0xBE3605C6,  0x6FB9B7A8,
  0x3FF2ED28,  0x2C000000,  0x3E3763D4,  0x24DCDDF5,
  0x3FF2F6A1,  0x20000000,  0xBE1A411E,  0xA8EC1AA8,
  0x3FF3001E,  0xD0000000,  0xBE23FCA1,  0x1FE8546F,
  0x3FF309A1,  0x40000000,  0xBE29DF0D,  0x3AAEE75E,
  0x3FF31328,  0x70000000,  0x3E36A5D6,  0x3C2C4206,
  0x3FF31CB4,  0x68000000,  0x3E1B7A3E,  0xB4C979B0,
  0x3FF32645,  0x28000000,  0xBE36157D,  0x706CD593,
  0x3FF32FDA,  0xB0000000,  0xBE39F357,  0x8DA4C646,
  0x3FF33975,  0x04000000,  0xBE3E64DE,  0xD575FE6F,
  0x3FF34314,  0x24000000,  0x3E07F9E3,  0x44D008E0,
  0x3FF34CB8,  0x18000000,  0xBE2E94F9,  0x5A563E77,
  0x3FF35660,  0xDC000000,  0x3E314DC2,  0x2475EF19,
  0x3FF3600E,  0x78000000,  0x3E26D623,  0xA33AC606,
  0x3FF369C0,  0xEC000000,  0x3E170F86,  0xC05B3160,
  0x3FF37378,  0x3C000000,  0xBE38DDFE,  0xDB0AE31A,
  0x3FF37D34,  0x64000000,  0x3E3662A9,  0x5706B570,
  0x3FF386F5,  0x70000000,  0xBE1625E4,  0x6770731E,
  0x3FF390BB,  0x5C000000,  0xBE1678F1,  0x62971091,
  0x3FF39A86,  0x2C000000,  0xBE061F7C,  0xD045CB0C,
  0x3FF3A455,  0xE4000000,  0xBE35CF51,  0x568B1CA2,
  0x3FF3AE2A,  0x84000000,  0xBE378185,  0x7FB61F58,
  0x3FF3B804,  0x0C000000,  0x3E3F77F4,  0x4FA133AF,
  0x3FF3C1E2,  0x88000000,  0xBE22F96A,  0xB00B73FE,
  0x3FF3CBC5,  0xF0000000,  0x3E351A64,  0x1EB4CE2F,
  0x3FF3D5AE,  0x50000000,  0xBE3D3516,  0xD3755639,
  0x3FF3DF9B,  0xA0000000,  0x3E1CD938,  0x43E8C10E,
  0x3FF3E98D,  0xEC000000,  0xBE35EE23,  0x455C8842,
  0x3FF3F385,  0x30000000,  0xBE29B282,  0x96C9F4ED,
  0x3FF3FD81,  0x70000000,  0x3E24A40E,  0x3168CC0B,
  0x3FF40782,  0xB0000000,  0x3E3784BC,  0x86C72839,
  0x3FF41188,  0xF4000000,  0x3E061F19,  0x0785D847,
  0x3FF41B94,  0x3C000000,  0xBE27AEF2,  0xE654A9C9,
  0x3FF425A4,  0x88000000,  0x3E33DFC3,  0xF9E4C1BA,
  0x3FF42FB9,  0xE0000000,  0x3E2455A8,  0x593D0C75,
  0x3FF439D4,  0x44000000,  0xBDE41D4E,  0x238B65D1,
  0x3FF443F3,  0xB4000000,  0x3E3BE616,  0x454CBECB,
  0x3FF44E18,  0x38000000,  0x3E207B3C,  0x931C5332,
  0x3FF45841,  0xD0000000,  0xBE330846,  0x7615DCC9,
  0x3FF46270,  0x7C000000,  0xBE2A8A7B,  0xE497F84E,
  0x3FF46CA4,  0x40000000,  0x3E020B50,  0xF737AF78,
  0x3FF476DD,  0x20000000,  0x3E116B19,  0xE34AFBD3,
  0x3FF4811B,  0x20000000,  0xBE3E15A7,  0x841EDB52,
  0x3FF48B5E,  0x3C000000,  0x3E0F40C3,  0x33B3DE1E,
  0x3FF495A6,  0x7C000000,  0x3E33607F,  0x92EFEE02,
  0x3FF49FF3,  0xE4000000,  0xBE1A2DB5,  0x14F7E168,
  0x3FF4AA46,  0x70000000,  0x3E3F59EC,  0x3EBA1C94,
  0x3FF4B49E,  0x2C000000,  0xBE31A539,  0x8B9AE885,
  0x3FF4BEFB,  0x10000000,  0x3E2FAC0B,  0xF13C8C95,
  0x3FF4C95D,  0x28000000,  0xBE32C0BB,  0xF8B74775,
  0x3FF4D3C4,  0x70000000,  0xBE2FC24E,  0x4F9474BB,
  0x3FF4DE30,  0xEC000000,  0x3E008F30,  0x09DA911F,
  0x3FF4E8A2,  0xA0000000,  0x3E2994C1,  0xBAF8D98B,
  0x3FF4F319,  0x90000000,  0xBE17C38C,  0x18648D0A,
  0x3FF4FD95,  0xBC000000,  0xBE288852,  0xF22F8698,
  0x3FF50817,  0x28000000,  0xBE3C3EC3,  0x30A2C153,
  0x3FF5129D,  0xD4000000,  0xBE27B606,  0x968492AA,
  0x3FF51D29,  0xC4000000,  0x3E2E0396,  0x61101629,
  0x3FF527BA,  0xFC000000,  0x3E3E876F,  0xDAEEAB38,
  0x3FF53251,  0x80000000,  0x3E29F59E,  0xED945B30,
  0x3FF53CED,  0x50000000,  0x3E12D7DA,  0x0B4AE3F1,
  0x3FF5478E,  0x70000000,  0xBE2FAFB8,  0x5FB946D0,
  0x3FF55234,  0xE0000000,  0xBE18A8B3,  0x87D80C66,
  0x3FF55CE0,  0xA4000000,  0x3E28B18F,  0x764CF85C,
  0x3FF56791,  0xC0000000,  0x3E326017,  0x2BDBC6F4,
  0x3FF57248,  0x38000000,  0xBE229F98,  0x53D523FE,
  0x3FF57D04,  0x0C000000,  0xBE3BDD08,  0x4D9B8720,
  0x3FF587C5,  0x3C000000,  0x3E169EBC,  0x09D8749E,
  0x3FF5928B,  0xD0000000,  0x3E190C8C,  0x339C2080,
  0x3FF59D57,  0xC8000000,  0x3E310FA4,  0xDE75E9CA,
  0x3FF5A829,  0x28000000,  0x3E313D18,  0x1097F186,
  0x3FF5B2FF,  0xF4000000,  0xBE2BDE04,  0xD51C23F6,
  0x3FF5BDDC,  0x28000000,  0x3E3EE67E,  0x8938C386,
  0x3FF5C8BD,  0xD0000000,  0x3E0973B8,  0x47DF6575,
  0x3FF5D3A4,  0xE8000000,  0x3E24DF02,  0x1DB97781,
  0x3FF5DE91,  0x78000000,  0xBE3FBA00,  0xAC4AECDC,
  0x3FF5E983,  0x7C000000,  0xBE2F37AF,  0x939F646A,
  0x3FF5F47A,  0xFC000000,  0xBE396DEF,  0x58A6EEE9,
  0x3FF5FF77,  0xF8000000,  0xBE315248,  0xE3613C7B,
  0x3FF60A7A,  0x74000000,  0xBE26A9E2,  0xF1553706,
  0x3FF61582,  0x74000000,  0xBE3B6BF6,  0xAE4D7CB6,
  0x3FF6208F,  0xF8000000,  0xBE35775B,  0x9EB5EBA5,
  0x3FF62BA3,  0x04000000,  0xBE2A821B,  0xC1E43506,
  0x3FF636BB,  0x9C000000,  0xBE367CDA,  0x7B2D8CF4,
  0x3FF641D9,  0xC0000000,  0xBE13218B,  0x3E907A1D,
  0x3FF64CFD,  0x74000000,  0x3E3454EE,  0x7BF5DFE4,
  0x3FF65826,  0xC0000000,  0xBE3E960F,  0x6366C5FD,
  0x3FF66355,  0x9C000000,  0x3E2E378F,  0x8B43C17E,
  0x3FF66E8A,  0x14000000,  0x3E244BE0,  0xA4306535,
  0x3FF679C4,  0x28000000,  0xBDE4B6C1,  0x8DF63D6E,
  0x3FF68503,  0xD8000000,  0x3E3BA122,  0xE6A239CF,
  0x3FF69049,  0x2C000000,  0x3E27F286,  0x59FB5F30,
  0x3FF69B94,  0x24000000,  0xBE044041,  0x971D3970 } };

static const union {
  int4   i[2048];
  double x[1024];
}  fine = { .i = {
  0x3FF00000,  0x00000000,  0x00000000,  0x00000000,
  0x3FF00004,  0x00000000,  0x3DA00001,  0x55556AAB,
  0x3FF00008,  0x00000000,  0x3DC00002,  0xAAAB0000,
  0x3FF0000C,  0x00000000,  0x3DD20004,  0x8000D800,
  0x3FF00010,  0x00000000,  0x3DE00005,  0x5556AAAB,
  0x3FF00014,  0x00000000,  0x3DE9000A,  0x6AADEC01,
  0x3FF00018,  0x00000000,  0x3DF20009,  0x00036001,
  0x3FF0001C,  0x00000000,  0x3DF8800E,  0x4AB0EB58,
  0x3FF00020,  0x00000000,  0x3E00000A,  0xAAB00002,
  0x3FF00024,  0x00000000,  0x3E04400F,  0x30088B04,
  0x3FF00028,  0x00000000,  0x3E090014,  0xD5625AB1,
  0x3FF0002C,  0x00000000,  0x3E0E401B,  0xBABDBB0A,
  0x3FF00030,  0x00000000,  0x3E120012,  0x000D8008,
  0x3FF00034,  0x00000000,  0x3E152016,  0xE2BD42E1,
  0x3FF00038,  0x00000000,  0x3E18801C,  0x956E5812,
  0x3FF0003C,  0x00000000,  0x3E1C2023,  0x2820F599,
  0x3FF00040,  0x00000000,  0x3E200015,  0x556AAABC,
  0x3FF00044,  0x00000000,  0x3E221019,  0x96C5DAD7,
  0x3FF00048,  0x00000000,  0x3E24401E,  0x60222C1F,
  0x3FF0004C,  0x00000000,  0x3E269023,  0xB97FC193,
  0x3FF00050,  0x00000000,  0x3E290029,  0xAADEC034,
  0x3FF00054,  0x00000000,  0x3E2B9030,  0x3C3F4F02,
  0x3FF00058,  0x00000000,  0x3E2E4037,  0x75A196FF,
  0x3FF0005C,  0x00000000,  0x3E30881F,  0xAF82E194,
  0x3FF00060,  0x00000000,  0x3E320024,  0x00360041,
  0x3FF00064,  0x00000000,  0x3E338828,  0xB0EA3F05,
  0x3FF00068,  0x00000000,  0x3E35202D,  0xC59FB661,
  0x3FF0006C,  0x00000000,  0x3E36C833,  0x42567FD5,
  0x3FF00070,  0x00000000,  0x3E388039,  0x2B0EB5E1,
  0x3FF00074,  0x00000000,  0x3E3A483F,  0x83C87407,
  0x3FF00078,  0x00000000,  0x3E3C2046,  0x5083D6C6,
  0x3FF0007C,  0x00000000,  0x3E3E084D,  0x9540FB9E,
  0x3FF00080,  0x04000000,  0xBE3FFFAA,  0xA9FFFEEF,
  0x3FF00084,  0x04000000,  0xBE3DF7A2,  0x693EF962,
  0x3FF00088,  0x04000000,  0xBE3BDF99,  0xA47BD339,
  0x3FF0008C,  0x04000000,  0xBE39B790,  0x57B66AF5,
  0x3FF00090,  0x04000000,  0xBE377F86,  0x7EEE9E14,
  0x3FF00094,  0x04000000,  0xBE35377C,  0x16244916,
  0x3FF00098,  0x04000000,  0xBE32DF71,  0x1957477B,
  0x3FF0009C,  0x04000000,  0xBE307765,  0x848773C2,
  0x3FF000A0,  0x04000000,  0xBE2BFEB2,  0xA7694ED3,
  0x3FF000A4,  0x04000000,  0xBE26EE99,  0x05BD75E2,
  0x3FF000A8,  0x04000000,  0xBE21BE7E,  0x1C0B0BB1,
  0x3FF000AC,  0x04000000,  0xBE18DCC3,  0xC4A37A79,
  0x3FF000B0,  0x04000000,  0xBE0BF911,  0x4244D60F,
  0x3FF000B4,  0x04000000,  0xBDE6E255,  0xEC91D848,
  0x3FF000B8,  0x04000000,  0x3E0107EB,  0xEC1B8F0C,
  0x3FF000BC,  0x04000000,  0x3E142439,  0x89BE52AA,
  0x3FF000C0,  0x04000000,  0x3E200240,  0x06C01033,
  0x3FF000C4,  0x04000000,  0x3E261264,  0xC8A9F760,
  0x3FF000C8,  0x04000000,  0x3E2C428B,  0x129D3FDE,
  0x3FF000CC,  0x04000000,  0x3E314959,  0x764D2658,
  0x3FF000D0,  0x04000000,  0x3E34816E,  0x2F50C16C,
  0x3FF000D4,  0x04000000,  0x3E37C983,  0xB859A4AB,
  0x3FF000D8,  0x04000000,  0x3E3B219A,  0x15680499,
  0x3FF000DC,  0x04000000,  0x3E3E89B1,  0x4A7C16B5,
  0x3FF000E0,  0x08000000,  0xBE3DFE36,  0xA469EE7E,
  0x3FF000E4,  0x08000000,  0xBE3A761D,  0xB349D37F,
  0x3FF000E8,  0x08000000,  0xBE36DE03,  0xDE235FCD,
  0x3FF000EC,  0x08000000,  0xBE3335E9,  0x20F659E6,
  0x3FF000F0,  0x08000000,  0xBE2EFB9A,  0xEF850E8F,
  0x3FF000F4,  0x08000000,  0xBE276B61,  0xBD0F58E2,
  0x3FF000F8,  0x08000000,  0xBE1F764D,  0x45163381,
  0x3FF000FC,  0x08000000,  0xBE0FABA6,  0x5FDF589A,
  0x3FF00100,  0x08000000,  0x3D8555AA,  0xABBBBE94,
  0x3FF00104,  0x08000000,  0x3E102B2C,  0xDABB690B,
  0x3FF00108,  0x08000000,  0x3E2045D9,  0x7820FBA0,
  0x3FF0010C,  0x08000000,  0x3E28961E,  0x92F54742,
  0x3FF00110,  0x08000000,  0x3E308332,  0xE2ED8E39,
  0x3FF00114,  0x08000000,  0x3E34CB57,  0x8C698119,
  0x3FF00118,  0x08000000,  0x3E39237D,  0x49EEC0C4,
  0x3FF0011C,  0x08000000,  0x3E3D8BA4,  0x1F7D92BC,
  0x3FF00120,  0x0C000000,  0xBE3DFC33,  0xEEE9C27D,
  0x3FF00124,  0x0C000000,  0xBE39740A,  0xDD46F763,
  0x3FF00128,  0x0C000000,  0xBE34DBE0,  0xA799C375,
  0x3FF0012C,  0x0C000000,  0xBE3033B5,  0x49E1DD2F,
  0x3FF00130,  0x0C000000,  0xBE26F711,  0x803DF41F,
  0x3FF00134,  0x0C000000,  0xBE1ACD6C,  0x19433A4C,
  0x3FF00138,  0x0C000000,  0xBDFDB2C1,  0x8770E36F,
  0x3FF0013C,  0x0C000000,  0x3E086820,  0x6B74A43E,
  0x3FF00140,  0x0C000000,  0x3E200A6A,  0xDEC0D058,
  0x3FF00144,  0x0C000000,  0x3E2A1AD0,  0x22BD7872,
  0x3FF00148,  0x0C000000,  0x3E32259B,  0xF769E132,
  0x3FF0014C,  0x0C000000,  0x3E374DD1,  0x2582289A,
  0x3FF00150,  0x0C000000,  0x3E3C8607,  0x9FA7E4F4,
  0x3FF00154,  0x10000000,  0xBE3E31C0,  0x9624963C,
  0x3FF00158,  0x10000000,  0xBE38D987,  0x77E2F472,
  0x3FF0015C,  0x10000000,  0xBE33714D,  0x0192E02C,
  0x3FF00160,  0x10000000,  0xBE2BF222,  0x5E6805CB,
  0x3FF00164,  0x10000000,  0xBE20E1A7,  0xF98C0A34,
  0x3FF00168,  0x10000000,  0xBE06C4AB,  0x32447238,
  0x3FF0016C,  0x10000000,  0x3E067D54,  0xC225D8C1,
  0x3FF00170,  0x10000000,  0x3E210FD8,  0x05C4630F,
  0x3FF00174,  0x10000000,  0x3E2CA05D,  0xBB206115,
  0x3FF00178,  0x10000000,  0x3E342873,  0x2C4F14A6,
  0x3FF0017C,  0x10000000,  0x3E3A10B8,  0xF31F3B5E,
  0x3FF00180,  0x14000000,  0xBE3FF6FF,  0xC9FEFCC9,
  0x3FF00184,  0x14000000,  0xBE39EEB7,  0x070B344A,
  0x3FF00188,  0x14000000,  0xBE33D66C,  0xC0050AA2,
  0x3FF0018C,  0x14000000,  0xBE2B5C41,  0xE1D83C97,
  0x3FF00190,  0x14000000,  0xBE1DD74E,  0x57003305,
  0x3FF00194,  0x14000000,  0xBDF2D84A,  0xA80727F1,
  0x3FF00198,  0x14000000,  0x3E14AB2F,  0x534C5401,
  0x3FF0019C,  0x14000000,  0x3E27263B,  0xD875DE83,
  0x3FF001A0,  0x14000000,  0x3E320B71,  0x9FB782CA,
  0x3FF001A4,  0x14000000,  0x3E3893C6,  0xF349371F,
  0x3FF001A8,  0x14000000,  0x3E3F2C1D,  0xEAF074C6,
  0x3FF001AC,  0x18000000,  0xBE3A2B89,  0x75525ABC,
  0x3FF001B0,  0x18000000,  0xBE33732F,  0x297ECCE2,
  0x3FF001B4,  0x18000000,  0xBE2955A6,  0x5B28EC49,
  0x3FF001B8,  0x18000000,  0xBE1749D5,  0xF64BA7FD,
  0x3FF001BC,  0x18000000,  0x3DF15E9E,  0xA8645141,
  0x3FF001C0,  0x18000000,  0x3E201C96,  0x1D6F0B37,
  0x3FF001C4,  0x18000000,  0x3E2E2D5B,  0xE6028E39,
  0x3FF001C8,  0x18000000,  0x3E362F12,  0x9B63FA1E,
  0x3FF001CC,  0x18000000,  0x3E3D5779,  0x0BE01026,
  0x3FF001D0,  0x1C000000,  0xBE3B701E,  0xB78A0445,
  0x3FF001D4,  0x1C000000,  0xBE3427B4,  0xAAD9CF9D,
  0x3FF001D8,  0x1C000000,  0xBE299E91,  0x941DBAB5,
  0x3FF001DC,  0x1C000000,  0xBE159B6C,  0x44A2DFDD,
  0x3FF001E0,  0x1C000000,  0x3E008CA4,  0x1EC8B89C,
  0x3FF001E4,  0x1C000000,  0x3E23340B,  0xF1EE0E9A,
  0x3FF001E8,  0x1C000000,  0x3E313279,  0x5231913C,
  0x3FF001EC,  0x1C000000,  0x3E38DAEE,  0x93892E68,
  0x3FF001F0,  0x20000000,  0xBE3F6C9A,  0x3F01A6A8,
  0x3FF001F4,  0x20000000,  0xBE37A421,  0x216E726C,
  0x3FF001F8,  0x20000000,  0xBE2F974C,  0x1F7970B9,
  0x3FF001FC,  0x20000000,  0xBE1F8CA4,  0x17AFEBC8,
  0x3FF00200,  0x20000000,  0x3DB55600,  0x04445B06,
  0x3FF00204,  0x20000000,  0x3E203BAE,  0x0C290A26,
  0x3FF00208,  0x20000000,  0x3E30365A,  0x104547BD,
  0x3FF0020C,  0x20000000,  0x3E385EDF,  0x22970DE3,
  0x3FF00210,  0x24000000,  0xBE3F6899,  0xBEF5A5F4,
  0x3FF00214,  0x24000000,  0xBE372010,  0x90605040,
  0x3FF00218,  0x24000000,  0xBE2D8F0A,  0x9B50D8EE,
  0x3FF0021C,  0x24000000,  0xBE197BDF,  0xCB35D444,
  0x3FF00220,  0x24000000,  0x3E00CCBC,  0x2188E3D5,
  0x3FF00224,  0x24000000,  0x3E254452,  0x36A79F6A,
  0x3FF00228,  0x24000000,  0x3E333ABC,  0xD69B2D28,
  0x3FF0022C,  0x24000000,  0x3E3BE352,  0xBA07BE5B,
  0x3FF00230,  0x28000000,  0xBE3B6415,  0x3665F227,
  0x3FF00234,  0x28000000,  0xBE329B7A,  0xF6AD58D5,
  0x3FF00238,  0x28000000,  0xBE2385BD,  0x059BD24A,
  0x3FF0023C,  0x28000000,  0xBDEB47FA,  0xD8E2B1B4,
  0x3FF00240,  0x28000000,  0x3E203CC2,  0x22CF60F6,
  0x3FF00244,  0x28000000,  0x3E312704,  0x39BEF87F,
  0x3FF00248,  0x28000000,  0x3E3A3FA9,  0xA63F5309,
  0x3FF0024C,  0x2C000000,  0xBE3C97AE,  0xA516AE5E,
  0x3FF00250,  0x2C000000,  0xBE335F04,  0xA442792A,
  0x3FF00254,  0x2C000000,  0xBE242CB0,  0xA686F3A2,
  0x3FF00258,  0x2C000000,  0xBDE7B535,  0xC3237903,
  0x3FF0025C,  0x2C000000,  0x3E21560E,  0x9E7A6CF7,
  0x3FF00260,  0x2C000000,  0x3E3223BA,  0xA8C01385,
  0x3FF00264,  0x2C000000,  0x3E3BAC70,  0x627012DF,
  0x3FF00268,  0x30000000,  0xBE3ABAD7,  0x7FB232EA,
  0x3FF0026C,  0x30000000,  0xBE31121C,  0xF9A6244B,
  0x3FF00270,  0x30000000,  0xBE1D6580,  0x1DAC9AE4,
  0x3FF00274,  0x30000000,  0x3E037AFA,  0xD7FB0AC3,
  0x3FF00278,  0x30000000,  0x3E289042,  0x633420EB,
  0x3FF0027C,  0x30000000,  0x3E3630E5,  0x8065842A,
  0x3FF00280,  0x34000000,  0xBE3FD653,  0xB49DA4FF,
  0x3FF00284,  0x34000000,  0xBE35CD8A,  0x696ECB76,
  0x3FF00288,  0x34000000,  0xBE27697D,  0x341A9D63,
  0x3FF0028C,  0x34000000,  0xBDF8BF04,  0x2788D238,
  0x3FF00290,  0x34000000,  0x3E2159C1,  0x42A03782,
  0x3FF00294,  0x34000000,  0x3E32F5B4,  0x154D4F89,
  0x3FF00298,  0x34000000,  0x3E3D4E8A,  0x1D7FB2C1,
  0x3FF0029C,  0x38000000,  0xBE38489D,  0x42181508,
  0x3FF002A0,  0x38000000,  0xBE2B9F84,  0x0AF2C28C,
  0x3FF002A4,  0x38000000,  0xBE0A3721,  0x451C5357,
  0x3FF002A8,  0x38000000,  0x3E1D47F1,  0x61A8605E,
  0x3FF002AC,  0x38000000,  0x3E31FADF,  0x81B02FCF,
  0x3FF002B0,  0x38000000,  0x3E3CB3C5,  0x572F674A,
  0x3FF002B4,  0x3C000000,  0xBE388352,  0x231795EA,
  0x3FF002B8,  0x3C000000,  0xBE2B54CD,  0xD248367A,
  0x3FF002BC,  0x3C000000,  0xBE060BC7,  0xB7ABD90D,
  0x3FF002C0,  0x3C000000,  0x3E206EEF,  0x6EE9F1EF,
  0x3FF002C4,  0x3C000000,  0x3E33406B,  0x261BF09E,
  0x3FF002C8,  0x3C000000,  0x3E3E5961,  0x59001C60,
  0x3FF002CC,  0x40000000,  0xBE367DA5,  0xABDDD232,
  0x3FF002D0,  0x40000000,  0xBE268953,  0xC8FA5113,
  0x3FF002D4,  0x40000000,  0x3D9152CC,  0x8B33A701,
  0x3FF002D8,  0x40000000,  0x3E26BAAC,  0x3E058570,
  0x3FF002DC,  0x40000000,  0x3E36C65A,  0x63236E71,
  0x3FF002E0,  0x44000000,  0xBE3DC09E,  0x7C7A795C,
  0x3FF002E4,  0x44000000,  0xBE323794,  0x7BD63D1D,
  0x3FF002E8,  0x44000000,  0xBE1A7A1E,  0x5BBC9105,
  0x3FF002EC,  0x44000000,  0x3E142A20,  0xD8EE2B1B,
  0x3FF002F0,  0x44000000,  0x3E30C39A,  0xEFAA8A8D,
  0x3FF002F4,  0x44000000,  0x3E3C8CB0,  0x995E96A2,
  0x3FF002F8,  0x48000000,  0xBE379A36,  0xC8A79469,
  0x3FF002FC,  0x48000000,  0xBE276236,  0x64CE7203,
  0x3FF00300,  0x48000000,  0x3DD200D8,  0x0819DA68,
  0x3FF00304,  0x48000000,  0x3E28A249,  0xE5E018D4,
  0x3FF00308,  0x48000000,  0x3E386A49,  0x8A087692,
  0x3FF0030C,  0x4C000000,  0xBE3B6C8E,  0xD695988B,
  0x3FF00310,  0x4C000000,  0xBE2E66C8,  0x55D2BCBA,
  0x3FF00314,  0x4C000000,  0xBE0751B3,  0x7790BA7A,
  0x3FF00318,  0x4C000000,  0x3E22DDF4,  0xC2A20261,
  0x3FF0031C,  0x4C000000,  0x3E35D82E,  0x49E0B0B5,
  0x3FF00320,  0x50000000,  0xBE3DAE9A,  0xB142422E,
  0x3FF00324,  0x50000000,  0xBE312560,  0x8C170FE6,
  0x3FF00328,  0x50000000,  0xBE12308D,  0x0A73BF77,
  0x3FF0032C,  0x50000000,  0x3E203A3A,  0x5E59CEFA,
  0x3FF00330,  0x50000000,  0x3E34D660,  0xCD4740BF,
  0x3FF00334,  0x54000000,  0xBE3E6058,  0x644D1883,
  0x3FF00338,  0x54000000,  0xBE31870E,  0x618F57B6,
  0x3FF0033C,  0x54000000,  0xBE127704,  0x99FABD0F,
  0x3FF00340,  0x54000000,  0x3E20B71E,  0xA1CB5ECF,
  0x3FF00344,  0x54000000,  0x3E3564E3,  0x089E93E1,
  0x3FF00348,  0x58000000,  0xBE3D81C5,  0xFB533142,
  0x3FF0034C,  0x58000000,  0xBE30586B,  0xB6EECE6C,
  0x3FF00350,  0x58000000,  0xBE08F871,  0x319B883E,
  0x3FF00354,  0x58000000,  0x3E2454A5,  0x75BF7503,
  0x3FF00358,  0x58000000,  0x3E3783B6,  0xF04B88C5,
  0x3FF0035C,  0x5C000000,  0xBE3B12E1,  0x81EF30A7,
  0x3FF00360,  0x5C000000,  0xBE2B32ED,  0x2F9F3657,
  0x3FF00364,  0x5C000000,  0xBDB0084D,  0x54DF31BC,
  0x3FF00368,  0x5C000000,  0x3E2B12D2,  0xC303B7B9,
  0x3FF0036C,  0x5C000000,  0x3E3B32DE,  0x78B56F97,
  0x3FF00370,  0x60000000,  0xBE3713A9,  0x03B9496C,
  0x3FF00374,  0x60000000,  0xBE22945A,  0x1F92E726,
  0x3FF00378,  0x60000000,  0x3E123D49,  0x621736DF,
  0x3FF0037C,  0x60000000,  0x3E3278D5,  0x3935580D,
  0x3FF00380,  0x64000000,  0xBE3F8DA4,  0x69B9F5FB,
  0x3FF00384,  0x64000000,  0xBE31841A,  0x8C473CC8,
  0x3FF00388,  0x64000000,  0xBE0B5469,  0x538CDE07,
  0x3FF0038C,  0x64000000,  0x3E257E07,  0x7F8F9D65,
  0x3FF00390,  0x64000000,  0x3E38F898,  0x3665E52B,
  0x3FF00394,  0x68000000,  0xBE38BDCF,  0xC29674BD,
  0x3FF00398,  0x68000000,  0xBE24C868,  0x4E58B4D9,
  0x3FF0039C,  0x68000000,  0x3E1015AC,  0x329466D7,
  0x3FF003A0,  0x68000000,  0x3E327F0D,  0xDCDECE44,
  0x3FF003A4,  0x6C000000,  0xBE3EF74B,  0xB27E5528,
  0x3FF003A8,  0x6C000000,  0xBE305DA1,  0x9D7167F2,
  0x3FF003AC,  0x6C000000,  0xBDFB3F3D,  0xFF980820,
  0x3FF003B0,  0x6C000000,  0x3E2A0B7B,  0x13D49789,
  0x3FF003B4,  0x6C000000,  0x3E3BCF72,  0xA43AE87C,
  0x3FF003B8,  0x70000000,  0xBE3556D4,  0x8D06BDC0,
  0x3FF003BC,  0x70000000,  0xBE19B460,  0x1766E54D,
  0x3FF003C0,  0x70000000,  0x3E211950,  0x7B85C8BA,
  0x3FF003C4,  0x70000000,  0x3E37966C,  0x41D00AED,
  0x3FF003C8,  0x74000000,  0xBE394FCB,  0xF5B15507,
  0x3FF003CC,  0x74000000,  0xBE244C00,  0xC98093C4,
  0x3FF003D0,  0x74000000,  0x3E144F3B,  0xE2907BDF,
  0x3FF003D4,  0x74000000,  0x3E345DA2,  0x267CD924,
  0x3FF003D8,  0x78000000,  0xBE3C4886,  0xD73526C0,
  0x3FF003DC,  0x78000000,  0xBE29BD57,  0xF8E1D62E,
  0x3FF003E0,  0x78000000,  0x3E04D995,  0xD65415E1,
  0x3FF003E4,  0x78000000,  0x3E322515,  0x527E1A58,
  0x3FF003E8,  0x7C000000,  0xBE3E4104,  0x31552BA5,
  0x3FF003EC,  0x7C000000,  0xBE2D2E33,  0x995CAB3B,
  0x3FF003F0,  0x7C000000,  0x3DF22D48,  0x473970DC,
  0x3FF003F4,  0x7C000000,  0x3E30ECC6,  0xC61195FC,
  0x3FF003F8,  0x80000000,  0xBE3F3943,  0x03D35C34,
  0x3FF003FC,  0x80000000,  0xBE2E9E91,  0xAA7483C7,
  0x3FF00400,  0x80000000,  0x3DE556AA,  0xBBBC71CE,
  0x3FF00404,  0x80000000,  0x3E30B4B7,  0x817613C1,
  0x3FF00408,  0x84000000,  0xBE3F3142,  0x4E70B0AC,
  0x3FF0040C,  0x84000000,  0xBE2E0E70,  0x2BAAD02F,
  0x3FF00410,  0x84000000,  0x3DF32D62,  0xF48F01F2,
  0x3FF00414,  0x84000000,  0x3E317CE8,  0x84EB5B98,
  0x3FF00418,  0x88000000,  0xBE3E2901,  0x10ED210B,
  0x3FF0041C,  0x88000000,  0xBE2B7DCD,  0x1C7F0051,
  0x3FF00420,  0x88000000,  0x3E05D9C0,  0x87AA2706,
  0x3FF00424,  0x88000000,  0x3E33455A,  0xD0B235B3,
  0x3FF00428,  0x8C000000,  0xBE3C207E,  0x4B07A510,
  0x3FF0042C,  0x8C000000,  0xBE26ECA6,  0x7C6E838B,
  0x3FF00430,  0x8C000000,  0x3E150F6F,  0xEC91A8D5,
  0x3FF00434,  0x8C000000,  0x3E360E0F,  0x650C6A83,
  0x3FF00438,  0x90000000,  0xBE3917B8,  0xFC7E3439,
  0x3FF0043C,  0x90000000,  0xBE205AFA,  0x4AF4C8B6,
  0x3FF00440,  0x90000000,  0x3E219985,  0xDC31D181,
  0x3FF00444,  0x90000000,  0x3E39D707,  0x423CC2BE,
  0x3FF00448,  0x94000000,  0xBE350EB0,  0x250DC5BF,
  0x3FF0044C,  0x94000000,  0xBE0F231A,  0x1E2CF893,
  0x3FF00450,  0x94000000,  0x3E2AABDB,  0xD42C92D4,
  0x3FF00454,  0x94000000,  0x3E3EA043,  0x6887075B,
  0x3FF00458,  0x98000000,  0xBE300562,  0xC472509B,
  0x3FF0045C,  0x98000000,  0x3DF64FB6,  0x72B572E0,
  0x3FF00460,  0x98000000,  0x3E32DF5D,  0xEF61155C,
  0x3FF00464,  0x9C000000,  0xBE3B963B,  0x27CFFE6A,
  0x3FF00468,  0x9C000000,  0xBE23F79F,  0xB4CD96FE,
  0x3FF0046C,  0x9C000000,  0x3E1EBA7F,  0x6E771F13,
  0x3FF00470,  0x9C000000,  0x3E396913,  0xFE3ED608,
  0x3FF00474,  0xA0000000,  0xBE34CC73,  0x6E82850F,
  0x3FF00478,  0xA0000000,  0xBE078FB3,  0x352966B7,
  0x3FF0047C,  0xA0000000,  0x3E2DF116,  0x33AFF8AE,
  0x3FF00480,  0xA4000000,  0xBE3F0CEE,  0xE909EADD,
  0x3FF00484,  0xA4000000,  0xBE2A04C8,  0xD6938597,
  0x3FF00488,  0xA4000000,  0x3E1460AA,  0x5C6654D8,
  0x3FF0048C,  0xA4000000,  0x3E3742BE,  0x22213ECF,
  0x3FF00490,  0xA8000000,  0xBE3682A9,  0xC631A356,
  0x3FF00494,  0xA8000000,  0xBE10E034,  0x7777B644,
  0x3FF00498,  0xA8000000,  0x3E2C4528,  0x3E3B0991,
  0x3FF0049C,  0xAC000000,  0xBE3F72C6,  0x0B3E269F,
  0x3FF004A0,  0xAC000000,  0xBE29F037,  0x31DF923B,
  0x3FF004A4,  0xAC000000,  0x3E164A4D,  0xE82713DE,
  0x3FF004A8,  0xAC000000,  0x3E382D47,  0x31AFAC4B,
  0x3FF004AC,  0xB0000000,  0xBE352800,  0x6DFCE978,
  0x3FF004B0,  0xB0000000,  0xBE036A1B,  0x07D68D27,
  0x3FF004B4,  0xB0000000,  0x3E305D7E,  0x5CB71F6F,
  0x3FF004B8,  0xB4000000,  0xBE3CC7BB,  0x30E5E990,
  0x3FF004BC,  0xB4000000,  0xBE23B9E0,  0x0BA17DEA,
  0x3FF004C0,  0xB4000000,  0x3E223BBF,  0xC3EF9BD8,
  0x3FF004C4,  0xB4000000,  0x3E3C28B4,  0x8A74ECC0,
  0x3FF004C8,  0xB8000000,  0xBE30BC72,  0x085831CA,
  0x3FF004CC,  0xB8000000,  0x3E037361,  0x6C8D1FC8,
  0x3FF004D0,  0xB8000000,  0x3E35A94F,  0x3033A0B8,
  0x3FF004D4,  0xBC000000,  0xBE370BC8,  0xFC7107DE,
  0x3FF004D8,  0xBC000000,  0xBE0D86E2,  0xA2D908DA,
  0x3FF004DC,  0xBC000000,  0x3E2F742A,  0x58ED155E,
  0x3FF004E0,  0xC0000000,  0xBE3CCAF4,  0x75FACDD0,
  0x3FF004E4,  0xC0000000,  0xBE227FF2,  0x6F5BE5D3,
  0x3FF004E8,  0xC0000000,  0x3E24B60D,  0xD6BCA827,
  0x3FF004EC,  0xC0000000,  0x3E3E060B,  0xF72B40D6,
  0x3FF004F0,  0xC4000000,  0xBE2C7DD4,  0x208BE3E3,
  0x3FF004F4,  0xC4000000,  0x3E163093,  0x642FDDB8,
  0x3FF004F8,  0xC4000000,  0x3E396738,  0xB72239A5,
  0x3FF004FC,  0xC8000000,  0xBE32ADAE,  0x7201ED9B,
  0x3FF00500,  0xC8000000,  0x3DF4D6F6,  0x1A0C05F3,
  0x3FF00504,  0xC8000000,  0x3E355892,  0x360B8346,
  0x3FF00508,  0xCC000000,  0xBE368C45,  0xF0C06435,
  0x3FF0050C,  0xCC000000,  0xBE0308C8,  0x760DA2F6,
  0x3FF00510,  0xCC000000,  0x3E31DA18,  0xE008D57B,
  0x3FF00514,  0xD0000000,  0xBE39DAB0,  0x205F82F4,
  0x3FF00518,  0xD0000000,  0xBE15FDD0,  0x2FE5E3E3,
  0x3FF0051C,  0xD0000000,  0x3E2DD79A,  0x42787241,
  0x3FF00520,  0xD4000000,  0xBE3C98EC,  0x94BD25F4,
  0x3FF00524,  0xD4000000,  0xBE201B42,  0x53C89D03,
  0x3FF00528,  0xD4000000,  0x3E291B5E,  0xCB901057,
  0x3FF0052C,  0xD8000000,  0xBE3EC6FA,  0xE1B6D837,
  0x3FF00530,  0xD8000000,  0xBE24173F,  0xF8BF49E7,
  0x3FF00534,  0xD8000000,  0x3E257F80,  0x339DDB57,
  0x3FF00538,  0xD8000000,  0x3E3F9B25,  0x64D62C5C,
  0x3FF0053C,  0xDC000000,  0xBE26F2E0,  0x2E913659,
  0x3FF00540,  0xDC000000,  0x3E2303FF,  0x52E7CB93,
  0x3FF00544,  0xDC000000,  0x3E3E8D74,  0xAB0CFEF5,
  0x3FF00548,  0xE0000000,  0xBE28AE22,  0x1CF7FDE6,
  0x3FF0054C,  0xE0000000,  0x3E21A8DD,  0x01B47B93,
  0x3FF00550,  0xE0000000,  0x3E3E0FF3,  0x5D1107E2,
  0x3FF00554,  0xE4000000,  0xBE294904,  0xEBAC99E1,
  0x3FF00558,  0xE4000000,  0x3E216E1A,  0x184B2814,
  0x3FF0055C,  0xE4000000,  0x3E3E22A1,  0xE706008B,
  0x3FF00560,  0xE8000000,  0xBE28C387,  0xC267616A,
  0x3FF00564,  0xE8000000,  0x3E2253B7,  0x6EF3B008,
  0x3FF00568,  0xE8000000,  0x3E3EC580,  0xB50FF371,
  0x3FF0056C,  0xEC000000,  0xBE271DA9,  0xC8E0096B,
  0x3FF00570,  0xEC000000,  0x3E2459B5,  0xDDF69498,
  0x3FF00574,  0xEC000000,  0x3E3FF890,  0x33533C31,
  0x3FF00578,  0xF0000000,  0xBE24576A,  0x26CDA497,
  0x3FF0057C,  0xF0000000,  0x3E278016,  0x3D9CF923,
  0x3FF00580,  0xF4000000,  0xBE3E442F,  0x320B787B,
  0x3FF00584,  0xF4000000,  0xBE2070C8,  0x03E6A36B,
  0x3FF00588,  0xF4000000,  0x3E2BC6D9,  0x6630A33F,
  0x3FF0058C,  0xF8000000,  0xBE3BF0BD,  0x0EE72CBF,
  0x3FF00590,  0xF8000000,  0xBE16D385,  0x0FC1A853,
  0x3FF00594,  0xF8000000,  0x3E309700,  0x17FDFD5D,
  0x3FF00598,  0xFC000000,  0xBE390D18,  0xF71A91AC,
  0x3FF0059C,  0xFC000000,  0xBE050963,  0x69C58B86,
  0x3FF005A0,  0xFC000000,  0x3E33DAC5,  0xB9A504CD,
  0x3FF005A5,  0x00000000,  0xBE359942,  0x7E800734,
  0x3FF005A9,  0x00000000,  0x3DF02BAE,  0xE59934CD,
  0x3FF005AD,  0x00000000,  0x3E37AEBE,  0x04333E0E,
  0x3FF005B1,  0x04000000,  0xBE319539,  0x38F19C2F,
  0x3FF005B5,  0x04000000,  0x3E14DB54,  0xEBB1C157,
  0x3FF005B9,  0x04000000,  0x3E3C12E9,  0x63CED05D,
  0x3FF005BD,  0x08000000,  0xBE2A01F9,  0x74921CAF,
  0x3FF005C1,  0x08000000,  0x3E23F645,  0xC94C85F2,
  0x3FF005C5,  0x0C000000,  0xBE3EF8B7,  0xBB61CBEE,
  0x3FF005C9,  0x0C000000,  0xBE1F7232,  0x597F2931,
  0x3FF005CD,  0x0C000000,  0x3E2E9F48,  0xAF5B7345,
  0x3FF005D1,  0x10000000,  0xBE397424,  0xED37CD5F,
  0x3FF005D5,  0x10000000,  0xBE013F43,  0x08775C6B,
  0x3FF005D9,  0x10000000,  0x3E35345A,  0x0029D3DB,
  0x3FF005DD,  0x14000000,  0xBE335F5D,  0xC58C1962,
  0x3FF005E1,  0x14000000,  0x3E1073C1,  0x47430E04,
  0x3FF005E5,  0x14000000,  0x3E3BA944,  0x4A41E248,
  0x3FF005E9,  0x18000000,  0xBE2974C3,  0xB06E888E,
  0x3FF005ED,  0x18000000,  0x3E25E3FB,  0xDCCD9333,
  0x3FF005F1,  0x1C000000,  0xBE3D519C,  0x5DE27951,
  0x3FF005F5,  0x1C000000,  0xBE1614C2,  0xE4464502,
  0x3FF005F9,  0x1C000000,  0x3E325740,  0xE0DAFE93,
  0x3FF005FD,  0x20000000,  0xBE35BC47,  0x8C1B4C10,
  0x3FF00601,  0x20000000,  0x3E0201B0,  0x20686CE9,
  0x3FF00605,  0x20000000,  0x3E3A4CB9,  0x95558B63,
  0x3FF00609,  0x24000000,  0xBE2B2D79,  0xA880A3EB,
  0x3FF0060D,  0x24000000,  0x3E252BA5,  0x9699EEB7,
  0x3FF00611,  0x28000000,  0xBE3D2D97,  0x880115E1,
  0x3FF00615,  0x28000000,  0xBE1383EF,  0x28A3D788,
  0x3FF00619,  0x28000000,  0x3E337BA6,  0x08D6DC23,
  0x3FF0061D,  0x2C000000,  0xBE3417B2,  0x0B001A08,
  0x3FF00621,  0x2C000000,  0x3E1193EF,  0xF94EB99A,
  0x3FF00625,  0x2C000000,  0x3E3CF1B0,  0x28D3BD3B,
  0x3FF00629,  0x30000000,  0xBE24E32B,  0x0EFCC982,
  0x3FF0062D,  0x30000000,  0x3E2C7655,  0xE2BDA47F,
  0x3FF00631,  0x34000000,  0xBE39080E,  0x689312F8,
  0x3FF00635,  0x34000000,  0xBDCDA0C8,  0xA9444DB4,
  0x3FF00639,  0x34000000,  0x3E38A191,  0x7B21FE23,
  0x3FF0063D,  0x38000000,  0xBE2CE32A,  0x7E67E1E1,
  0x3FF00641,  0x38000000,  0x3E251694,  0x875A71F0,
  0x3FF00645,  0x3C000000,  0xBE3C67CF,  0xF838F455,
  0x3FF00649,  0x3C000000,  0xBE0A571F,  0x77274052,
  0x3FF0064D,  0x3C000000,  0x3E35E20E,  0x63AAEFA8,
  0x3FF00651,  0x40000000,  0xBE30E0F8,  0xFC87DA70,
  0x3FF00655,  0x40000000,  0x3E20D80B,  0xE9089AFD,
  0x3FF00659,  0x44000000,  0xBE3E36F4,  0xC52F03BD,
  0x3FF0065D,  0x44000000,  0xBE1327A4,  0x9680E14E,
  0x3FF00661,  0x44000000,  0x3E34B328,  0xD732468D,
  0x3FF00665,  0x48000000,  0xBE31BFBE,  0xCAB5EF4A,
  0x3FF00669,  0x48000000,  0x3E1F757F,  0xE2A2FBE1,
  0x3FF0066D,  0x4C000000,  0xBE3E757A,  0xDAB014DA,
  0x3FF00671,  0x4C000000,  0xBE12E13D,  0x02FB3FBB,
  0x3FF00675,  0x4C000000,  0x3E3514E2,  0xCA7E298D,
  0x3FF00679,  0x50000000,  0xBE310DE4,  0xB4F78B94,
  0x3FF0067D,  0x50000000,  0x3E21BEB4,  0x89C35D05,
  0x3FF00681,  0x54000000,  0xBE3D2360,  0x43F4895C,
  0x3FF00685,  0x54000000,  0xBE08B0A2,  0x5BC49ADF,
  0x3FF00689,  0x54000000,  0x3E37073E,  0x32573159,
  0x3FF0068D,  0x58000000,  0xBE2D96D1,  0x8D0732D2,
  0x3FF00691,  0x58000000,  0x3E26E3ED,  0x9BF15E67,
  0x3FF00695,  0x5C000000,  0xBE3A40A3,  0x0C3250FB,
  0x3FF00699,  0x5C000000,  0x3DBCC9AE,  0xFD0AE214,
  0x3FF0069D,  0x5C000000,  0x3E3A8A3D,  0x038868A1,
  0x3FF006A1,  0x60000000,  0xBE25F092,  0x151D21CE,
  0x3FF006A5,  0x60000000,  0x3E2F2A6F,  0x11738C43,
  0x3FF006A9,  0x64000000,  0xBE35CD41,  0x3E9CE96D,
  0x3FF006AD,  0x64000000,  0x3E138132,  0x8DBC2918,
  0x3FF006B1,  0x64000000,  0x3E3F9DE1,  0x32DF4C13,
  0x3FF006B5,  0x68000000,  0xBE16520E,  0x3129E0B2,
  0x3FF006B9,  0x68000000,  0x3E35491E,  0x69F36A61,
  0x3FF006BD,  0x6C000000,  0xBE2F9271,  0xCCCABCD4,
  0x3FF006C1,  0x6C000000,  0x3E2668ED,  0x0D59B899,
  0x3FF006C5,  0x70000000,  0xBE39BDD3,  0x4AD435A0,
  0x3FF006C9,  0x70000000,  0x3DF5FE9A,  0x9191CABB,
  0x3FF006CD,  0x70000000,  0x3E3C8DAD,  0x6676850B,
  0x3FF006D1,  0x74000000,  0xBE206910,  0x1D74934A,
  0x3FF006D5,  0x74000000,  0x3E331949,  0x4D886478,
  0x3FF006D9,  0x78000000,  0xBE3188DE,  0x80BFBBC2,
  0x3FF006DD,  0x78000000,  0x3E23CA01,  0x14DE1719,
  0x3FF006E1,  0x7C000000,  0xBE3A9D19,  0x8CE98EC0,
  0x3FF006E5,  0x7C000000,  0x3DEE1A67,  0xA705A6E7,
  0x3FF006E9,  0x7C000000,  0x3E3C8EC6,  0xECD5F851,
  0x3FF006ED,  0x80000000,  0xBE1F0CF9,  0xE839CE4D,
  0x3FF006F1,  0x80000000,  0x3E33FAC3,  0x0C8CA46A,
  0x3FF006F5,  0x84000000,  0xBE303734,  0x7B5703D8,
  0x3FF006F9,  0x84000000,  0x3E274DB5,  0xE490A112,
  0x3FF006FD,  0x88000000,  0xBE386B0E,  0xA693A093,
  0x3FF00701,  0x88000000,  0x3E0C9875,  0xF0B73DAA,
  0x3FF00705,  0x88000000,  0x3E3FA133,  0x2449A944,
  0x3FF00709,  0x8C000000,  0xBE110285,  0xBFE66C14,
  0x3FF0070D,  0x8C000000,  0x3E37ED91,  0x054EDCBD,
  0x3FF00711,  0x90000000,  0xBE27A86A,  0xEFB65924,
  0x3FF00715,  0x90000000,  0x3E307A0B,  0x1C8A0CF1,
  0x3FF00719,  0x94000000,  0xBE3327AD,  0x397FB1D6,
  0x3FF0071D,  0x94000000,  0x3E228D43,  0x1412B9FB,
  0x3FF00721,  0x98000000,  0xBE3A3B08,  0x94D8FFB0,
  0x3FF00725,  0x98000000,  0x3E029AA3,  0x6ED80040,
  0x3FF00729,  0x98000000,  0x3E3EF1B8,  0x9627250A,
  0x3FF0072D,  0x9C000000,  0xBE117F70,  0x5FCB1B09,
  0x3FF00731,  0x9C000000,  0x3E385E96,  0x678F0789,
  0x3FF00735,  0xA0000000,  0xBE25A5DF,  0xCEA3485B,
  0x3FF00739,  0xA0000000,  0x3E320B90,  0xFF6D0303,
  0x3FF0073D,  0xA4000000,  0xBE3105E6,  0xE03334FF,
  0x3FF00741,  0xA4000000,  0x3E27F150,  0xFB9F056D,
  0x3FF00745,  0xA8000000,  0xBE36F8C0,  0xE28905F4,
  0x3FF00749,  0xA8000000,  0x3E189774,  0x0B1407AA,
  0x3FF0074D,  0xAC000000,  0xBE3CAB7D,  0xCE4493C4,
  0x3FF00751,  0xAC000000,  0x3DE265D5,  0xCB817D78,
  0x3FF00755,  0xAC000000,  0x3E3DE1E2,  0x7CA8B4E3,
  0x3FF00759,  0xB0000000,  0xBE12FD89,  0x7D730FC6,
  0x3FF0075D,  0xB0000000,  0x3E38AF60,  0x1E4D7759,
  0x3FF00761,  0xB4000000,  0xBE23A3AC,  0x0CAD84A2,
  0x3FF00765,  0xB4000000,  0x3E33BCFB,  0x36B866FD,
  0x3FF00769,  0xB8000000,  0xBE2D4858,  0x4D0667A1,
  0x3FF0076D,  0xB8000000,  0x3E2E1567,  0xCBF08E6A,
  0x3FF00771,  0xBC000000,  0xBE333664,  0x9FD34D05,
  0x3FF00775,  0xBC000000,  0x3E253114,  0x9837D6E0,
  0x3FF00779,  0xC0000000,  0xBE37887F,  0x5238327D,
  0x3FF0077D,  0xC0000000,  0x3E1999FA,  0x24C8DC90,
  0x3FF00781,  0xC4000000,  0xBE3B9A7C,  0x1DA2F8BE,
  0x3FF00785,  0xC4000000,  0x3E03A485,  0xEA50EE6A,
  0x3FF00789,  0xC8000000,  0xBE3F6C5A,  0xE204A449,
  0x3FF0078D,  0xC8000000,  0xBDF3D3EF,  0x78D5D0F3,
  0x3FF00791,  0xC8000000,  0x3E3D01E4,  0x80B1D66C,
  0x3FF00795,  0xCC000000,  0xBE12BBC1,  0xD5149796,
  0x3FF00799,  0xCC000000,  0x3E39B042,  0x2A8F92F0,
  0x3FF0079D,  0xD0000000,  0xBE1F820E,  0x6F386487,
  0x3FF007A1,  0xD0000000,  0x3E369EBE,  0x3BA3BCDA,
  0x3FF007A5,  0xD4000000,  0xBE25A3F0,  0x96320652,
  0x3FF007A9,  0xD4000000,  0x3E33CD58,  0xD3FD8FCA,
  0x3FF007AD,  0xD8000000,  0xBE2B069C,  0xC62D40B1,
  0x3FF007B1,  0xD8000000,  0x3E313C12,  0x13AC5766,
  0x3FF007B5,  0xDC000000,  0xBE2FE90B,  0x876F3A0B,
  0x3FF007B9,  0xDC000000,  0x3E2DD5D4,  0x357EDEB8,
  0x3FF007BD,  0xE0000000,  0xBE32259E,  0x4CEC957E,
  0x3FF007C1,  0xE0000000,  0x3E29B3C2,  0x128C86C6,
  0x3FF007C5,  0xE4000000,  0xBE341697,  0xDEA61608,
  0x3FF007C9,  0xE4000000,  0x3E2611ED,  0xFEA09E70,
  0x3FF007CD,  0xE8000000,  0xBE35C772,  0x58D49AE3,
  0x3FF007D1,  0xE8000000,  0x3E22F058,  0x39DA3D42,
  0x3FF007D5,  0xEC000000,  0xBE37382D,  0x9B689043,
  0x3FF007D9,  0xEC000000,  0x3E204F01,  0x04589AD6,
  0x3FF007DD,  0xF0000000,  0xBE3868C9,  0x86525259,
  0x3FF007E1,  0xF0000000,  0x3E1C5BD1,  0x3C761DAC,
  0x3FF007E5,  0xF4000000,  0xBE395945,  0xF9822D4C,
  0x3FF007E9,  0xF4000000,  0x3E191A1E,  0x8F4221F9,
  0x3FF007ED,  0xF8000000,  0xBE3A09A2,  0xD4E85D3A,
  0x3FF007F1,  0xF8000000,  0x3E16D8EA,  0x81547225,
  0x3FF007F5,  0xFC000000,  0xBE3A79DF,  0xF8750E3B,
  0x3FF007F9,  0xFC000000,  0x3E159835,  0x92EC7DE3,
  0x3FF007FE,  0x00000000,  0xBE3AA9FD,  0x44185C5D } };

#else
#ifdef LITTLE_ENDI

static const  union {
  int i[1424];
  double x[712];
} coar = {  .i = {
  0xC8000000,  0x3FE69A59,  0x6079C9F7,  0x3DF22D4D,
  0xC8000000,  0x3FE6A5A9,  0x25AF6823,  0x3E19882D,
  0x74000000,  0x3FE6B0FF,  0x31DABF59,  0xBE221476,
  0xC8000000,  0x3FE6BC5A,  0x99A2DC0A,  0x3E2312AC,
  0xD0000000,  0x3FE6C7BB,  0xCE9F9355,  0xBE265926,
  0x84000000,  0x3FE6D322,  0x2D298DED,  0x3E2F2C26,
  0xF4000000,  0x3FE6DE8E,  0x1E748D2F,  0xBE2EC28E,
  0x14000000,  0x3FE6EA01,  0xC68CB7E5,  0x3E2D8C6D,
  0xF4000000,  0x3FE6F578,  0x419FE2F0,  0x3DEE1A9E,
  0x90000000,  0x3FE700F6,  0xDEAEAE34,  0xBDFF1AFD,
  0xEC000000,  0x3FE70C79,  0x558B7122,  0xBE0730FE,
  0x0C000000,  0x3FE71803,  0x2D280C3B,  0xBE25CB85,
  0xF0000000,  0x3FE72391,  0x337B7B54,  0xBE06F2CE,
  0x9C000000,  0x3FE72F26,  0x45C02B72,  0x3E289BCA,
  0x18000000,  0x3FE73AC1,  0x5039F1CA,  0xBE18DEA6,
  0x60000000,  0x3FE74661,  0x86CE0538,  0xBE09D090,
  0x78000000,  0x3FE75207,  0xCFCE5DDB,  0x3E290E79,
  0x68000000,  0x3FE75DB3,  0xB249A17C,  0x3DD61DF0,
  0x2C000000,  0x3FE76965,  0xE13445F7,  0x3E2F22F7,
  0xD0000000,  0x3FE7751C,  0x874E75CE,  0xBE2CD454,
  0x4C000000,  0x3FE780DA,  0xDF43E3BC,  0xBE0159CE,
  0xA8000000,  0x3FE78C9D,  0x699A1332,  0x3E279291,
  0xEC000000,  0x3FE79866,  0x2DD98C6C,  0xBE2A0BCD,
  0x10000000,  0x3FE7A436,  0x15AC979E,  0x3E25F375,
  0x20000000,  0x3FE7B00B,  0x2FEAFCF6,  0x3E26CCF5,
  0x1C000000,  0x3FE7BBE6,  0x53ADAD67,  0x3E27D4F4,
  0x08000000,  0x3FE7C7C7,  0x7FBD9566,  0x3E10EEC7,
  0xE4000000,  0x3FE7D3AD,  0x9A831D86,  0x3E2837F0,
  0xB8000000,  0x3FE7DF9A,  0x5CB4C35B,  0xBE129BE0,
  0x80000000,  0x3FE7EB8D,  0x0234F04D,  0x3E23990A,
  0x44000000,  0x3FE7F786,  0x64D5C842,  0x3E2EB807,
  0x08000000,  0x3FE80385,  0x02B4E9E8,  0x3E0FC86F,
  0xCC000000,  0x3FE80F89,  0x7B4274BF,  0xBDD7B5B3,
  0x94000000,  0x3FE81B94,  0xB899B00F,  0xBE16888B,
  0x60000000,  0x3FE827A5,  0x5E94D155,  0x3E288971,
  0x38000000,  0x3FE833BC,  0x099F3E5E,  0x3E2AEEB2,
  0x20000000,  0x3FE83FD9,  0x3FF60B7C,  0xBE23B922,
  0x14000000,  0x3FE84BFC,  0x2DBD8012,  0xBDF7D3B1,
  0x1C000000,  0x3FE85825,  0xA8872BEB,  0xBDF24BA3,
  0x38000000,  0x3FE86454,  0x01AA18A7,  0x3E2EFE04,
  0x70000000,  0x3FE87089,  0x944496A2,  0x3E21986C,
  0xC4000000,  0x3FE87CC4,  0xB71FFAFF,  0x3E096A8B,
  0x38000000,  0x3FE88906,  0xBC4C7AC5,  0xBE21CE0A,
  0xCC000000,  0x3FE8954D,  0xBAC02491,  0xBE076F45,
  0x84000000,  0x3FE8A19B,  0xD922B925,  0x3E2B4FA2,
  0x68000000,  0x3FE8ADEF,  0x641863AF,  0x3DF759DB,
  0x78000000,  0x3FE8BA49,  0xC6AB5E04,  0xBE2DB97C,
  0xB4000000,  0x3FE8C6A9,  0xE2156713,  0xBE25364C,
  0x20000000,  0x3FE8D310,  0x862BEFF7,  0x3E1BEB7C,
  0xC4000000,  0x3FE8DF7C,  0x1CEA33A5,  0xBDF4DD0C,
  0xA0000000,  0x3FE8EBEF,  0x51797D47,  0xBE2537DF,
  0xB4000000,  0x3FE8F868,  0xF0107B28,  0x3E0FB1C4,
  0x08000000,  0x3FE904E8,  0xE01B68BD,  0x3E0AD6A1,
  0x9C000000,  0x3FE9116D,  0x1F78D9D9,  0x3E292117,
  0x78000000,  0x3FE91DF9,  0x4F50E5CF,  0xBE1D75DA,
  0x98000000,  0x3FE92A8B,  0x74959E58,  0x3DE5102B,
  0x04000000,  0x3FE93724,  0xD2216C35,  0xBE01CA50,
  0xBC000000,  0x3FE943C2,  0xB0B05884,  0x3E225BFD,
  0xC8000000,  0x3FE95067,  0x60B7C5C1,  0xBE0F2183,
  0x24000000,  0x3FE95D13,  0xB5860441,  0x3E2FB47A,
  0xDC000000,  0x3FE969C4,  0xE2D4059E,  0xBE01FFD2,
  0xEC000000,  0x3FE9767C,  0x12BB6A8D,  0xBDE9ED72,
  0x58000000,  0x3FE9833B,  0x43BFFB24,  0x3E2B3815,
  0x28000000,  0x3FE99000,  0xEE9EAD1E,  0x3E03FA22,
  0x5C000000,  0x3FE99CCB,  0x377138F7,  0xBE213841,
  0xF4000000,  0x3FE9A99C,  0xDB636C94,  0x3E178105,
  0xF8000000,  0x3FE9B674,  0xF5720122,  0x3E1E5E7A,
  0x6C000000,  0x3FE9C353,  0xA2AC5AAE,  0xBE238BFF,
  0x4C000000,  0x3FE9D038,  0xF93BDBD8,  0x3E270893,
  0xA4000000,  0x3FE9DD23,  0x354B86CF,  0x3DF40420,
  0x74000000,  0x3FE9EA15,  0x88CB06B7,  0xBE2D76D3,
  0xBC000000,  0x3FE9F70D,  0x9ED0EC60,  0xBE251639,
  0x80000000,  0x3FEA040C,  0xE2DDE506,  0x3E1F06E9,
  0xC8000000,  0x3FEA1111,  0x8E6DB477,  0x3E014549,
  0x94000000,  0x3FEA1E1D,  0xF8716509,  0xBDF4BC17,
  0xE8000000,  0x3FEA2B2F,  0xDA723A49,  0xBE2107DB,
  0xC4000000,  0x3FEA3848,  0x986AA369,  0x3E1A932A,
  0x30000000,  0x3FEA4568,  0x41592CDB,  0x3E198092,
  0x30000000,  0x3FEA528E,  0x676BCAB8,  0xBE2E260F,
  0xC0000000,  0x3FEA5FBA,  0x2D5D5610,  0x3DE2E821,
  0xE8000000,  0x3FEA6CED,  0x7DA20167,  0x3E2F7046,
  0xB0000000,  0x3FEA7A27,  0xF9FAAD30,  0xBE1D2832,
  0x14000000,  0x3FEA8768,  0x43FA6C45,  0xBE23F788,
  0x18000000,  0x3FEA94AF,  0xAA082732,  0x3E011E27,
  0xC4000000,  0x3FEAA1FC,  0xC682F0BF,  0xBE20BACB,
  0x18000000,  0x3FEAAF51,  0x7BD08C78,  0xBE2DC7DD,
  0x14000000,  0x3FEABCAC,  0xA3B10F9A,  0x3E2271A2,
  0xC4000000,  0x3FEACA0D,  0x7966F94C,  0xBE15449C,
  0x24000000,  0x3FEAD776,  0x6FD8F3EE,  0x3DD06137,
  0x3C000000,  0x3FEAE4E5,  0x8C5A144A,  0xBE267CD1,
  0x0C000000,  0x3FEAF25B,  0xB59DA94B,  0xBE29E584,
  0x98000000,  0x3FEAFFD7,  0x7B52192F,  0xBE23DFCF,
  0xE4000000,  0x3FEB0D5A,  0x78A76B45,  0xBE1CF2FE,
  0xF4000000,  0x3FEB1AE4,  0x7EC80FF6,  0xBE23A561,
  0xC8000000,  0x3FEB2875,  0x932EED68,  0x3E22C4C9,
  0x68000000,  0x3FEB360D,  0xB5833C97,  0x3E2B085C,
  0xD8000000,  0x3FEB43AB,  0x93B9319A,  0xBE01F093,
  0x18000000,  0x3FEB5151,  0xFABCE670,  0xBE254F01,
  0x28000000,  0x3FEB5EFD,  0x627ABFB0,  0x3E2F24C2,
  0x14000000,  0x3FEB6CB0,  0xE6AC0B48,  0x3E1F1EEC,
  0xDC000000,  0x3FEB7A69,  0x127F9ABC,  0xBE1A8671,
  0x80000000,  0x3FEB882A,  0xC87C73B3,  0xBDCB0C28,
  0x08000000,  0x3FEB95F2,  0x7F2B5A97,  0xBE22E8DD,
  0x74000000,  0x3FEBA3C0,  0x2D22A9D5,  0xBE1B3645,
  0xC8000000,  0x3FEBB195,  0x428F8B88,  0x3E0ADACA,
  0x0C000000,  0x3FEBBF72,  0xCDF9F681,  0xBE2E9E07,
  0x3C000000,  0x3FEBCD55,  0x7FA54ACF,  0xBE08A127,
  0x60000000,  0x3FEBDB3F,  0x8225B385,  0x3E0E92CE,
  0x7C000000,  0x3FEBE930,  0x7BB09485,  0x3DF38C2A,
  0x94000000,  0x3FEBF728,  0xF681FA5F,  0xBE2DFD64,
  0xA4000000,  0x3FEC0527,  0xDCE88BD2,  0x3E2E384D,
  0xBC000000,  0x3FEC132D,  0xFE46A893,  0xBE20F111,
  0xD4000000,  0x3FEC213A,  0xB189BFDA,  0x3E193DA1,
  0xF8000000,  0x3FEC2F4E,  0x0E39FB00,  0xBE20E3A1,
  0x24000000,  0x3FEC3D6A,  0x30F0FAC5,  0x3E1DB044,
  0x64000000,  0x3FEC4B8C,  0x97446B17,  0xBE2BC12C,
  0xB4000000,  0x3FEC59B5,  0x963F4150,  0xBE282696,
  0x18000000,  0x3FEC67E6,  0x3049824B,  0x3E224D26,
  0x98000000,  0x3FEC761D,  0x87F84C7D,  0x3E2C5BA5,
  0x38000000,  0x3FEC845C,  0xC4852339,  0xBDE1D14D,
  0xF8000000,  0x3FEC92A1,  0x5588D9E1,  0xBE1A451E,
  0xDC000000,  0x3FECA0EE,  0x68BFF457,  0xBE1D3B96,
  0xE8000000,  0x3FECAF42,  0x4DADF774,  0xBE18B670,
  0x20000000,  0x3FECBD9E,  0x7FB1FC01,  0xBE1A1548,
  0x88000000,  0x3FECCC00,  0x78FC5AF0,  0xBE273F2E,
  0x20000000,  0x3FECDA6A,  0xA6F4A841,  0x3E1D218F,
  0xF0000000,  0x3FECE8DA,  0x4D002CA0,  0x3E2E0BA9,
  0xFC000000,  0x3FECF752,  0x065EF979,  0x3E20F4BB,
  0x48000000,  0x3FED05D2,  0x11793B33,  0xBE2ED3D5,
  0xD0000000,  0x3FED1458,  0x913341B3,  0x3E115E3C,
  0xA0000000,  0x3FED22E6,  0xB3546109,  0x3DE97C02,
  0xB8000000,  0x3FED317B,  0x1BF898EF,  0x3E087540,
  0x1C000000,  0x3FED4018,  0x346F9641,  0x3E209430,
  0xD0000000,  0x3FED4EBB,  0x88F4B20B,  0x3E2B6DF4,
  0xDC000000,  0x3FED5D66,  0x0CB26035,  0xBE2EC68F,
  0x38000000,  0x3FED6C19,  0x1F44D9C3,  0x3E2CA2C8,
  0xF4000000,  0x3FED7AD2,  0x41704EE0,  0x3E10E6F4,
  0x0C000000,  0x3FED8994,  0x25F8F0E2,  0x3E2F9273,
  0x88000000,  0x3FED985C,  0x318798DE,  0x3E2D041A,
  0x6C000000,  0x3FEDA72C,  0x9349CF58,  0xBE005680,
  0xB8000000,  0x3FEDB603,  0xCF0C934D,  0xBE10F665,
  0x70000000,  0x3FEDC4E2,  0x19461C64,  0x3E166124,
  0x9C000000,  0x3FEDD3C8,  0x405624C8,  0xBE1B2ED6,
  0x3C000000,  0x3FEDE2B6,  0x62171501,  0xBE273A7F,
  0x54000000,  0x3FEDF1AB,  0xE36E1450,  0xBE26022B,
  0xE8000000,  0x3FEE00A7,  0x2E07AE15,  0xBE1C341E,
  0xFC000000,  0x3FEE0FAB,  0x18D0E701,  0xBDFC7EAE,
  0x94000000,  0x3FEE1EB7,  0xECD1FF8B,  0x3E06B34F,
  0xB4000000,  0x3FEE2DCA,  0x6813A649,  0x3E1394A3,
  0x60000000,  0x3FEE3CE5,  0xC1754D14,  0x3E045496,
  0x9C000000,  0x3FEE4C07,  0xF5C6087C,  0xBE180FFF,
  0x68000000,  0x3FEE5B31,  0xADD9A300,  0x3E22FBCD,
  0xCC000000,  0x3FEE6A62,  0xAF0289E5,  0x3E2EC7C7,
  0xCC000000,  0x3FEE799B,  0x3FB3EDD4,  0x3E242182,
  0x6C000000,  0x3FEE88DC,  0x04E39885,  0xBE201304,
  0xAC000000,  0x3FEE9824,  0xE6831D31,  0xBE20D352,
  0x90000000,  0x3FEEA774,  0x618DFCEB,  0x3E1E032D,
  0x20000000,  0x3FEEB6CC,  0xF9BB457E,  0x3E1956A3,
  0x60000000,  0x3FEEC62B,  0x50845DB2,  0xBE2A77E0,
  0x4C000000,  0x3FEED592,  0x47C43858,  0x3E2714F7,
  0xF0000000,  0x3FEEE500,  0x71813A66,  0x3E2EED96,
  0x50000000,  0x3FEEF477,  0x4FB4AA34,  0xBE04CDBE,
  0x6C000000,  0x3FEF03F5,  0x86EB4FF5,  0xBE2774A2,
  0x48000000,  0x3FEF137B,  0xAD43B2D2,  0xBE29DD95,
  0xE8000000,  0x3FEF2308,  0xAC16E506,  0xBE1CADB0,
  0x50000000,  0x3FEF329E,  0x58745C7B,  0x3E12AC33,
  0x88000000,  0x3FEF423B,  0x6EC2D854,  0xBE248118,
  0x8C000000,  0x3FEF51E0,  0x304ACE08,  0x3E26986B,
  0x68000000,  0x3FEF618D,  0x3B09354E,  0x3E126D81,
  0x1C000000,  0x3FEF7142,  0x773C23B3,  0x3DF06AAE,
  0xAC000000,  0x3FEF80FE,  0xD82EF423,  0xBDA105B6,
  0x1C000000,  0x3FEF90C3,  0x465499B8,  0x3DECDEED,
  0x70000000,  0x3FEFA08F,  0xE2EF03AE,  0x3E0AEFD4,
  0xAC000000,  0x3FEFB063,  0x0567B2E7,  0x3E1BD4C0,
  0xD4000000,  0x3FEFC03F,  0x4F97FCBF,  0x3E26AA22,
  0xF0000000,  0x3FEFD023,  0x5E4E88D1,  0xBE2F9420,
  0xFC000000,  0x3FEFE00F,  0x438E52E2,  0xBE254004,
  0x00000000,  0x3FEFF004,  0xEEE93EFC,  0xBE1552AA,
  0x00000000,  0x3FF00000,  0x00000000,  0x00000000,
  0x00000000,  0x3FF00802,  0x4449F507,  0x3E155800,
  0x04000000,  0x3FF01008,  0x882D75D6,  0xBE354AA8,
  0x08000000,  0x3FF01812,  0x3740DE56,  0x3E303610,
  0x14000000,  0x3FF02020,  0x5B0C3264,  0x3E360044,
  0x28000000,  0x3FF02832,  0x0197EDC3,  0x3E3C4C26,
  0x48000000,  0x3FF03048,  0x5046CA09,  0x3E0B103B,
  0x74000000,  0x3FF03862,  0xF9A62624,  0xBE34659C,
  0xAC000000,  0x3FF04080,  0xDD0A8F37,  0xBE254438,
  0xF4000000,  0x3FF048A2,  0x97AFB6E2,  0x3DF256C2,
  0x50000000,  0x3FF050C9,  0x923D25E1,  0xBE3085DF,
  0xC0000000,  0x3FF058F3,  0x5EA3B091,  0xBE3F0A93,
  0x44000000,  0x3FF06122,  0x5D63534C,  0xBE237DE4,
  0xE0000000,  0x3FF06954,  0xFF0C58B7,  0x3E301719,
  0x98000000,  0x3FF0718B,  0x9DF7B665,  0x3E2E8410,
  0x6C000000,  0x3FF079C6,  0x3B127222,  0x3E349CB9,
  0x60000000,  0x3FF08205,  0x98E0BD08,  0x3DF127EC,
  0x74000000,  0x3FF08A48,  0x706CC41F,  0xBE24C1B6,
  0xA8000000,  0x3FF0928F,  0x093044EF,  0x3E334EF9,
  0x04000000,  0x3FF09ADB,  0x56BC6C83,  0xBE1304B1,
  0x84000000,  0x3FF0A32A,  0xB028B984,  0x3E2D383E,
  0x30000000,  0x3FF0AB7E,  0x64E7A202,  0xBE315B1E,
  0x04000000,  0x3FF0B3D6,  0xC678291E,  0xBE0AC1E6,
  0x04000000,  0x3FF0BC32,  0x2F12FFE2,  0x3E3A0418,
  0x38000000,  0x3FF0C492,  0x43D6D302,  0xBE37D617,
  0x98000000,  0x3FF0CCF6,  0x152CC8FA,  0x3E2133F2,
  0x2C000000,  0x3FF0D55F,  0xE966E6B7,  0x3E3CE5D1,
  0xF8000000,  0x3FF0DDCB,  0x7BCACA64,  0x3E1ABF24,
  0xFC000000,  0x3FF0E63C,  0x2E8CDBED,  0xBE3854F6,
  0x38000000,  0x3FF0EEB2,  0x0C32156B,  0xBE3E6463,
  0xAC000000,  0x3FF0F72B,  0xB69772CC,  0x3E365671,
  0x64000000,  0x3FF0FFA9,  0x02B1201A,  0xBE383E9A,
  0x58000000,  0x3FF1082B,  0x50549CC0,  0xBE205962,
  0x90000000,  0x3FF110B1,  0xFFDACA72,  0xBE376BFE,
  0x08000000,  0x3FF1193C,  0x5C43E2F3,  0x3E3C1C59,
  0xCC000000,  0x3FF121CA,  0xF7067C8B,  0xBE26D374,
  0xD4000000,  0x3FF12A5D,  0x4DDAFE1D,  0x3E343CCC,
  0x28000000,  0x3FF132F5,  0x58EBCB7F,  0x3E3D5C16,
  0xCC000000,  0x3FF13B90,  0xB66E8B53,  0xBE2B5D12,
  0xBC000000,  0x3FF14430,  0xB326B482,  0xBE24E919,
  0xFC000000,  0x3FF14CD4,  0xC8AABD43,  0x3E23139A,
  0x90000000,  0x3FF1557D,  0x16743B55,  0x3E30DD8B,
  0x7C000000,  0x3FF15E2A,  0x35904C50,  0xBE31D701,
  0xBC000000,  0x3FF166DB,  0x30E0CA83,  0x3E107F42,
  0x58000000,  0x3FF16F91,  0xDA1B7123,  0xBE24F1F2,
  0x50000000,  0x3FF1784B,  0x0DC79E23,  0xBE3ACAF2,
  0xA4000000,  0x3FF18109,  0x609374EE,  0xBE23DC79,
  0x58000000,  0x3FF189CC,  0x3A40C3B7,  0x3E262CF7,
  0x70000000,  0x3FF19293,  0x5A24F463,  0x3E1D3833,
  0xEC000000,  0x3FF19B5E,  0x8A2E4440,  0x3E2BA9AD,
  0xD0000000,  0x3FF1A42E,  0x61C41828,  0x3DFD8CBC,
  0x1C000000,  0x3FF1AD03,  0x5A4DDF0D,  0x3E1A65E6,
  0xD4000000,  0x3FF1B5DB,  0x9F828DB5,  0xBDE2FDBB,
  0xF8000000,  0x3FF1BEB8,  0xB79B700F,  0x3E2F4EE8,
  0x8C000000,  0x3FF1C79A,  0x0DE1D7E8,  0x3E3ACC35,
  0x94000000,  0x3FF1D080,  0xFF9E20A0,  0x3E11729E,
  0x10000000,  0x3FF1D96B,  0x6C2EA70B,  0xBE300F18,
  0x00000000,  0x3FF1E25A,  0xCE425A35,  0x3DF32E02,
  0x68000000,  0x3FF1EB4D,  0x9A322D12,  0x3E3BDE56,
  0x50000000,  0x3FF1F445,  0xBA737AEF,  0xBE3C3F0D,
  0xB0000000,  0x3FF1FD41,  0xC896DB7A,  0xBE0A2DD0,
  0x90000000,  0x3FF20642,  0xF8B782F6,  0x3E2577B0,
  0xF4000000,  0x3FF20F47,  0x73607FC8,  0xBE2C6DA3,
  0xD8000000,  0x3FF21851,  0xC8917348,  0x3E35F7D1,
  0x44000000,  0x3FF22160,  0xCF9CED69,  0x3E3B6F5C,
  0x3C000000,  0x3FF22A73,  0x85775C2E,  0xBE39967E,
  0xB8000000,  0x3FF2338A,  0x497226D4,  0x3E3B3213,
  0xC4000000,  0x3FF23CA6,  0x30733227,  0x3E3E2710,
  0x60000000,  0x3FF245C7,  0xAF215A72,  0x3E33B8A9,
  0x90000000,  0x3FF24EEC,  0x1365623F,  0xBE3F96B2,
  0x50000000,  0x3FF25816,  0x27DEE202,  0xBE37324F,
  0xA4000000,  0x3FF26144,  0x4E484D87,  0x3E318CD5,
  0x94000000,  0x3FF26A77,  0xA94519E8,  0xBDE3FD37,
  0x1C000000,  0x3FF273AF,  0xEE788C29,  0x3E37132F,
  0x44000000,  0x3FF27CEB,  0xE842E5C0,  0xBE03DDB7,
  0x08000000,  0x3FF2862C,  0xE17C9693,  0x3E37A3FB,
  0x70000000,  0x3FF28F71,  0xAEB3D9A0,  0x3E24EABF,
  0x7C000000,  0x3FF298BB,  0x853B0733,  0xBE13C7B6,
  0x2C000000,  0x3FF2A20A,  0xC7B588B5,  0x3E2D2C80,
  0x88000000,  0x3FF2AB5D,  0x708F3912,  0xBE35B750,
  0x8C000000,  0x3FF2B4B5,  0xD5FD9130,  0xBE291A70,
  0x3C000000,  0x3FF2BE12,  0x0CCF9F73,  0x3E2EE937,
  0xA0000000,  0x3FF2C773,  0xD42CF76C,  0xBE3C3F0C,
  0xB0000000,  0x3FF2D0D9,  0x60763D61,  0x3E35DD54,
  0x78000000,  0x3FF2DA44,  0xE7D6AA3B,  0x3E26C418,
  0xF8000000,  0x3FF2E3B3,  0x6FB9B7A8,  0xBE3605C6,
  0x2C000000,  0x3FF2ED28,  0x24DCDDF5,  0x3E3763D4,
  0x20000000,  0x3FF2F6A1,  0xA8EC1AA8,  0xBE1A411E,
  0xD0000000,  0x3FF3001E,  0x1FE8546F,  0xBE23FCA1,
  0x40000000,  0x3FF309A1,  0x3AAEE75E,  0xBE29DF0D,
  0x70000000,  0x3FF31328,  0x3C2C4206,  0x3E36A5D6,
  0x68000000,  0x3FF31CB4,  0xB4C979B0,  0x3E1B7A3E,
  0x28000000,  0x3FF32645,  0x706CD593,  0xBE36157D,
  0xB0000000,  0x3FF32FDA,  0x8DA4C646,  0xBE39F357,
  0x04000000,  0x3FF33975,  0xD575FE6F,  0xBE3E64DE,
  0x24000000,  0x3FF34314,  0x44D008E0,  0x3E07F9E3,
  0x18000000,  0x3FF34CB8,  0x5A563E77,  0xBE2E94F9,
  0xDC000000,  0x3FF35660,  0x2475EF19,  0x3E314DC2,
  0x78000000,  0x3FF3600E,  0xA33AC606,  0x3E26D623,
  0xEC000000,  0x3FF369C0,  0xC05B3160,  0x3E170F86,
  0x3C000000,  0x3FF37378,  0xDB0AE31A,  0xBE38DDFE,
  0x64000000,  0x3FF37D34,  0x5706B570,  0x3E3662A9,
  0x70000000,  0x3FF386F5,  0x6770731E,  0xBE1625E4,
  0x5C000000,  0x3FF390BB,  0x62971091,  0xBE1678F1,
  0x2C000000,  0x3FF39A86,  0xD045CB0C,  0xBE061F7C,
  0xE4000000,  0x3FF3A455,  0x568B1CA2,  0xBE35CF51,
  0x84000000,  0x3FF3AE2A,  0x7FB61F58,  0xBE378185,
  0x0C000000,  0x3FF3B804,  0x4FA133AF,  0x3E3F77F4,
  0x88000000,  0x3FF3C1E2,  0xB00B73FE,  0xBE22F96A,
  0xF0000000,  0x3FF3CBC5,  0x1EB4CE2F,  0x3E351A64,
  0x50000000,  0x3FF3D5AE,  0xD3755639,  0xBE3D3516,
  0xA0000000,  0x3FF3DF9B,  0x43E8C10E,  0x3E1CD938,
  0xEC000000,  0x3FF3E98D,  0x455C8842,  0xBE35EE23,
  0x30000000,  0x3FF3F385,  0x96C9F4ED,  0xBE29B282,
  0x70000000,  0x3FF3FD81,  0x3168CC0B,  0x3E24A40E,
  0xB0000000,  0x3FF40782,  0x86C72839,  0x3E3784BC,
  0xF4000000,  0x3FF41188,  0x0785D847,  0x3E061F19,
  0x3C000000,  0x3FF41B94,  0xE654A9C9,  0xBE27AEF2,
  0x88000000,  0x3FF425A4,  0xF9E4C1BA,  0x3E33DFC3,
  0xE0000000,  0x3FF42FB9,  0x593D0C75,  0x3E2455A8,
  0x44000000,  0x3FF439D4,  0x238B65D1,  0xBDE41D4E,
  0xB4000000,  0x3FF443F3,  0x454CBECB,  0x3E3BE616,
  0x38000000,  0x3FF44E18,  0x931C5332,  0x3E207B3C,
  0xD0000000,  0x3FF45841,  0x7615DCC9,  0xBE330846,
  0x7C000000,  0x3FF46270,  0xE497F84E,  0xBE2A8A7B,
  0x40000000,  0x3FF46CA4,  0xF737AF78,  0x3E020B50,
  0x20000000,  0x3FF476DD,  0xE34AFBD3,  0x3E116B19,
  0x20000000,  0x3FF4811B,  0x841EDB52,  0xBE3E15A7,
  0x3C000000,  0x3FF48B5E,  0x33B3DE1E,  0x3E0F40C3,
  0x7C000000,  0x3FF495A6,  0x92EFEE02,  0x3E33607F,
  0xE4000000,  0x3FF49FF3,  0x14F7E168,  0xBE1A2DB5,
  0x70000000,  0x3FF4AA46,  0x3EBA1C94,  0x3E3F59EC,
  0x2C000000,  0x3FF4B49E,  0x8B9AE885,  0xBE31A539,
  0x10000000,  0x3FF4BEFB,  0xF13C8C95,  0x3E2FAC0B,
  0x28000000,  0x3FF4C95D,  0xF8B74775,  0xBE32C0BB,
  0x70000000,  0x3FF4D3C4,  0x4F9474BB,  0xBE2FC24E,
  0xEC000000,  0x3FF4DE30,  0x09DA911F,  0x3E008F30,
  0xA0000000,  0x3FF4E8A2,  0xBAF8D98B,  0x3E2994C1,
  0x90000000,  0x3FF4F319,  0x18648D0A,  0xBE17C38C,
  0xBC000000,  0x3FF4FD95,  0xF22F8698,  0xBE288852,
  0x28000000,  0x3FF50817,  0x30A2C153,  0xBE3C3EC3,
  0xD4000000,  0x3FF5129D,  0x968492AA,  0xBE27B606,
  0xC4000000,  0x3FF51D29,  0x61101629,  0x3E2E0396,
  0xFC000000,  0x3FF527BA,  0xDAEEAB38,  0x3E3E876F,
  0x80000000,  0x3FF53251,  0xED945B30,  0x3E29F59E,
  0x50000000,  0x3FF53CED,  0x0B4AE3F1,  0x3E12D7DA,
  0x70000000,  0x3FF5478E,  0x5FB946D0,  0xBE2FAFB8,
  0xE0000000,  0x3FF55234,  0x87D80C66,  0xBE18A8B3,
  0xA4000000,  0x3FF55CE0,  0x764CF85C,  0x3E28B18F,
  0xC0000000,  0x3FF56791,  0x2BDBC6F4,  0x3E326017,
  0x38000000,  0x3FF57248,  0x53D523FE,  0xBE229F98,
  0x0C000000,  0x3FF57D04,  0x4D9B8720,  0xBE3BDD08,
  0x3C000000,  0x3FF587C5,  0x09D8749E,  0x3E169EBC,
  0xD0000000,  0x3FF5928B,  0x339C2080,  0x3E190C8C,
  0xC8000000,  0x3FF59D57,  0xDE75E9CA,  0x3E310FA4,
  0x28000000,  0x3FF5A829,  0x1097F186,  0x3E313D18,
  0xF4000000,  0x3FF5B2FF,  0xD51C23F6,  0xBE2BDE04,
  0x28000000,  0x3FF5BDDC,  0x8938C386,  0x3E3EE67E,
  0xD0000000,  0x3FF5C8BD,  0x47DF6575,  0x3E0973B8,
  0xE8000000,  0x3FF5D3A4,  0x1DB97781,  0x3E24DF02,
  0x78000000,  0x3FF5DE91,  0xAC4AECDC,  0xBE3FBA00,
  0x7C000000,  0x3FF5E983,  0x939F646A,  0xBE2F37AF,
  0xFC000000,  0x3FF5F47A,  0x58A6EEE9,  0xBE396DEF,
  0xF8000000,  0x3FF5FF77,  0xE3613C7B,  0xBE315248,
  0x74000000,  0x3FF60A7A,  0xF1553706,  0xBE26A9E2,
  0x74000000,  0x3FF61582,  0xAE4D7CB6,  0xBE3B6BF6,
  0xF8000000,  0x3FF6208F,  0x9EB5EBA5,  0xBE35775B,
  0x04000000,  0x3FF62BA3,  0xC1E43506,  0xBE2A821B,
  0x9C000000,  0x3FF636BB,  0x7B2D8CF4,  0xBE367CDA,
  0xC0000000,  0x3FF641D9,  0x3E907A1D,  0xBE13218B,
  0x74000000,  0x3FF64CFD,  0x7BF5DFE4,  0x3E3454EE,
  0xC0000000,  0x3FF65826,  0x6366C5FD,  0xBE3E960F,
  0x9C000000,  0x3FF66355,  0x8B43C17E,  0x3E2E378F,
  0x14000000,  0x3FF66E8A,  0xA4306535,  0x3E244BE0,
  0x28000000,  0x3FF679C4,  0x8DF63D6E,  0xBDE4B6C1,
  0xD8000000,  0x3FF68503,  0xE6A239CF,  0x3E3BA122,
  0x2C000000,  0x3FF69049,  0x59FB5F30,  0x3E27F286,
  0x24000000,  0x3FF69B94,  0x971D3970,  0xBE044041 } };

static const union {
  int4   i[2048];
  double x[1024];
}  fine = { .i = {
  0x00000000,  0x3FF00000,  0x00000000,  0x00000000,
  0x00000000,  0x3FF00004,  0x55556AAB,  0x3DA00001,
  0x00000000,  0x3FF00008,  0xAAAB0000,  0x3DC00002,
  0x00000000,  0x3FF0000C,  0x8000D800,  0x3DD20004,
  0x00000000,  0x3FF00010,  0x5556AAAB,  0x3DE00005,
  0x00000000,  0x3FF00014,  0x6AADEC01,  0x3DE9000A,
  0x00000000,  0x3FF00018,  0x00036001,  0x3DF20009,
  0x00000000,  0x3FF0001C,  0x4AB0EB58,  0x3DF8800E,
  0x00000000,  0x3FF00020,  0xAAB00002,  0x3E00000A,
  0x00000000,  0x3FF00024,  0x30088B04,  0x3E04400F,
  0x00000000,  0x3FF00028,  0xD5625AB1,  0x3E090014,
  0x00000000,  0x3FF0002C,  0xBABDBB0A,  0x3E0E401B,
  0x00000000,  0x3FF00030,  0x000D8008,  0x3E120012,
  0x00000000,  0x3FF00034,  0xE2BD42E1,  0x3E152016,
  0x00000000,  0x3FF00038,  0x956E5812,  0x3E18801C,
  0x00000000,  0x3FF0003C,  0x2820F599,  0x3E1C2023,
  0x00000000,  0x3FF00040,  0x556AAABC,  0x3E200015,
  0x00000000,  0x3FF00044,  0x96C5DAD7,  0x3E221019,
  0x00000000,  0x3FF00048,  0x60222C1F,  0x3E24401E,
  0x00000000,  0x3FF0004C,  0xB97FC193,  0x3E269023,
  0x00000000,  0x3FF00050,  0xAADEC034,  0x3E290029,
  0x00000000,  0x3FF00054,  0x3C3F4F02,  0x3E2B9030,
  0x00000000,  0x3FF00058,  0x75A196FF,  0x3E2E4037,
  0x00000000,  0x3FF0005C,  0xAF82E194,  0x3E30881F,
  0x00000000,  0x3FF00060,  0x00360041,  0x3E320024,
  0x00000000,  0x3FF00064,  0xB0EA3F05,  0x3E338828,
  0x00000000,  0x3FF00068,  0xC59FB661,  0x3E35202D,
  0x00000000,  0x3FF0006C,  0x42567FD5,  0x3E36C833,
  0x00000000,  0x3FF00070,  0x2B0EB5E1,  0x3E388039,
  0x00000000,  0x3FF00074,  0x83C87407,  0x3E3A483F,
  0x00000000,  0x3FF00078,  0x5083D6C6,  0x3E3C2046,
  0x00000000,  0x3FF0007C,  0x9540FB9E,  0x3E3E084D,
  0x04000000,  0x3FF00080,  0xA9FFFEEF,  0xBE3FFFAA,
  0x04000000,  0x3FF00084,  0x693EF962,  0xBE3DF7A2,
  0x04000000,  0x3FF00088,  0xA47BD339,  0xBE3BDF99,
  0x04000000,  0x3FF0008C,  0x57B66AF5,  0xBE39B790,
  0x04000000,  0x3FF00090,  0x7EEE9E14,  0xBE377F86,
  0x04000000,  0x3FF00094,  0x16244916,  0xBE35377C,
  0x04000000,  0x3FF00098,  0x1957477B,  0xBE32DF71,
  0x04000000,  0x3FF0009C,  0x848773C2,  0xBE307765,
  0x04000000,  0x3FF000A0,  0xA7694ED3,  0xBE2BFEB2,
  0x04000000,  0x3FF000A4,  0x05BD75E2,  0xBE26EE99,
  0x04000000,  0x3FF000A8,  0x1C0B0BB1,  0xBE21BE7E,
  0x04000000,  0x3FF000AC,  0xC4A37A79,  0xBE18DCC3,
  0x04000000,  0x3FF000B0,  0x4244D60F,  0xBE0BF911,
  0x04000000,  0x3FF000B4,  0xEC91D848,  0xBDE6E255,
  0x04000000,  0x3FF000B8,  0xEC1B8F0C,  0x3E0107EB,
  0x04000000,  0x3FF000BC,  0x89BE52AA,  0x3E142439,
  0x04000000,  0x3FF000C0,  0x06C01033,  0x3E200240,
  0x04000000,  0x3FF000C4,  0xC8A9F760,  0x3E261264,
  0x04000000,  0x3FF000C8,  0x129D3FDE,  0x3E2C428B,
  0x04000000,  0x3FF000CC,  0x764D2658,  0x3E314959,
  0x04000000,  0x3FF000D0,  0x2F50C16C,  0x3E34816E,
  0x04000000,  0x3FF000D4,  0xB859A4AB,  0x3E37C983,
  0x04000000,  0x3FF000D8,  0x15680499,  0x3E3B219A,
  0x04000000,  0x3FF000DC,  0x4A7C16B5,  0x3E3E89B1,
  0x08000000,  0x3FF000E0,  0xA469EE7E,  0xBE3DFE36,
  0x08000000,  0x3FF000E4,  0xB349D37F,  0xBE3A761D,
  0x08000000,  0x3FF000E8,  0xDE235FCD,  0xBE36DE03,
  0x08000000,  0x3FF000EC,  0x20F659E6,  0xBE3335E9,
  0x08000000,  0x3FF000F0,  0xEF850E8F,  0xBE2EFB9A,
  0x08000000,  0x3FF000F4,  0xBD0F58E2,  0xBE276B61,
  0x08000000,  0x3FF000F8,  0x45163381,  0xBE1F764D,
  0x08000000,  0x3FF000FC,  0x5FDF589A,  0xBE0FABA6,
  0x08000000,  0x3FF00100,  0xABBBBE94,  0x3D8555AA,
  0x08000000,  0x3FF00104,  0xDABB690B,  0x3E102B2C,
  0x08000000,  0x3FF00108,  0x7820FBA0,  0x3E2045D9,
  0x08000000,  0x3FF0010C,  0x92F54742,  0x3E28961E,
  0x08000000,  0x3FF00110,  0xE2ED8E39,  0x3E308332,
  0x08000000,  0x3FF00114,  0x8C698119,  0x3E34CB57,
  0x08000000,  0x3FF00118,  0x49EEC0C4,  0x3E39237D,
  0x08000000,  0x3FF0011C,  0x1F7D92BC,  0x3E3D8BA4,
  0x0C000000,  0x3FF00120,  0xEEE9C27D,  0xBE3DFC33,
  0x0C000000,  0x3FF00124,  0xDD46F763,  0xBE39740A,
  0x0C000000,  0x3FF00128,  0xA799C375,  0xBE34DBE0,
  0x0C000000,  0x3FF0012C,  0x49E1DD2F,  0xBE3033B5,
  0x0C000000,  0x3FF00130,  0x803DF41F,  0xBE26F711,
  0x0C000000,  0x3FF00134,  0x19433A4C,  0xBE1ACD6C,
  0x0C000000,  0x3FF00138,  0x8770E36F,  0xBDFDB2C1,
  0x0C000000,  0x3FF0013C,  0x6B74A43E,  0x3E086820,
  0x0C000000,  0x3FF00140,  0xDEC0D058,  0x3E200A6A,
  0x0C000000,  0x3FF00144,  0x22BD7872,  0x3E2A1AD0,
  0x0C000000,  0x3FF00148,  0xF769E132,  0x3E32259B,
  0x0C000000,  0x3FF0014C,  0x2582289A,  0x3E374DD1,
  0x0C000000,  0x3FF00150,  0x9FA7E4F4,  0x3E3C8607,
  0x10000000,  0x3FF00154,  0x9624963C,  0xBE3E31C0,
  0x10000000,  0x3FF00158,  0x77E2F472,  0xBE38D987,
  0x10000000,  0x3FF0015C,  0x0192E02C,  0xBE33714D,
  0x10000000,  0x3FF00160,  0x5E6805CB,  0xBE2BF222,
  0x10000000,  0x3FF00164,  0xF98C0A34,  0xBE20E1A7,
  0x10000000,  0x3FF00168,  0x32447238,  0xBE06C4AB,
  0x10000000,  0x3FF0016C,  0xC225D8C1,  0x3E067D54,
  0x10000000,  0x3FF00170,  0x05C4630F,  0x3E210FD8,
  0x10000000,  0x3FF00174,  0xBB206115,  0x3E2CA05D,
  0x10000000,  0x3FF00178,  0x2C4F14A6,  0x3E342873,
  0x10000000,  0x3FF0017C,  0xF31F3B5E,  0x3E3A10B8,
  0x14000000,  0x3FF00180,  0xC9FEFCC9,  0xBE3FF6FF,
  0x14000000,  0x3FF00184,  0x070B344A,  0xBE39EEB7,
  0x14000000,  0x3FF00188,  0xC0050AA2,  0xBE33D66C,
  0x14000000,  0x3FF0018C,  0xE1D83C97,  0xBE2B5C41,
  0x14000000,  0x3FF00190,  0x57003305,  0xBE1DD74E,
  0x14000000,  0x3FF00194,  0xA80727F1,  0xBDF2D84A,
  0x14000000,  0x3FF00198,  0x534C5401,  0x3E14AB2F,
  0x14000000,  0x3FF0019C,  0xD875DE83,  0x3E27263B,
  0x14000000,  0x3FF001A0,  0x9FB782CA,  0x3E320B71,
  0x14000000,  0x3FF001A4,  0xF349371F,  0x3E3893C6,
  0x14000000,  0x3FF001A8,  0xEAF074C6,  0x3E3F2C1D,
  0x18000000,  0x3FF001AC,  0x75525ABC,  0xBE3A2B89,
  0x18000000,  0x3FF001B0,  0x297ECCE2,  0xBE33732F,
  0x18000000,  0x3FF001B4,  0x5B28EC49,  0xBE2955A6,
  0x18000000,  0x3FF001B8,  0xF64BA7FD,  0xBE1749D5,
  0x18000000,  0x3FF001BC,  0xA8645141,  0x3DF15E9E,
  0x18000000,  0x3FF001C0,  0x1D6F0B37,  0x3E201C96,
  0x18000000,  0x3FF001C4,  0xE6028E39,  0x3E2E2D5B,
  0x18000000,  0x3FF001C8,  0x9B63FA1E,  0x3E362F12,
  0x18000000,  0x3FF001CC,  0x0BE01026,  0x3E3D5779,
  0x1C000000,  0x3FF001D0,  0xB78A0445,  0xBE3B701E,
  0x1C000000,  0x3FF001D4,  0xAAD9CF9D,  0xBE3427B4,
  0x1C000000,  0x3FF001D8,  0x941DBAB5,  0xBE299E91,
  0x1C000000,  0x3FF001DC,  0x44A2DFDD,  0xBE159B6C,
  0x1C000000,  0x3FF001E0,  0x1EC8B89C,  0x3E008CA4,
  0x1C000000,  0x3FF001E4,  0xF1EE0E9A,  0x3E23340B,
  0x1C000000,  0x3FF001E8,  0x5231913C,  0x3E313279,
  0x1C000000,  0x3FF001EC,  0x93892E68,  0x3E38DAEE,
  0x20000000,  0x3FF001F0,  0x3F01A6A8,  0xBE3F6C9A,
  0x20000000,  0x3FF001F4,  0x216E726C,  0xBE37A421,
  0x20000000,  0x3FF001F8,  0x1F7970B9,  0xBE2F974C,
  0x20000000,  0x3FF001FC,  0x17AFEBC8,  0xBE1F8CA4,
  0x20000000,  0x3FF00200,  0x04445B06,  0x3DB55600,
  0x20000000,  0x3FF00204,  0x0C290A26,  0x3E203BAE,
  0x20000000,  0x3FF00208,  0x104547BD,  0x3E30365A,
  0x20000000,  0x3FF0020C,  0x22970DE3,  0x3E385EDF,
  0x24000000,  0x3FF00210,  0xBEF5A5F4,  0xBE3F6899,
  0x24000000,  0x3FF00214,  0x90605040,  0xBE372010,
  0x24000000,  0x3FF00218,  0x9B50D8EE,  0xBE2D8F0A,
  0x24000000,  0x3FF0021C,  0xCB35D444,  0xBE197BDF,
  0x24000000,  0x3FF00220,  0x2188E3D5,  0x3E00CCBC,
  0x24000000,  0x3FF00224,  0x36A79F6A,  0x3E254452,
  0x24000000,  0x3FF00228,  0xD69B2D28,  0x3E333ABC,
  0x24000000,  0x3FF0022C,  0xBA07BE5B,  0x3E3BE352,
  0x28000000,  0x3FF00230,  0x3665F227,  0xBE3B6415,
  0x28000000,  0x3FF00234,  0xF6AD58D5,  0xBE329B7A,
  0x28000000,  0x3FF00238,  0x059BD24A,  0xBE2385BD,
  0x28000000,  0x3FF0023C,  0xD8E2B1B4,  0xBDEB47FA,
  0x28000000,  0x3FF00240,  0x22CF60F6,  0x3E203CC2,
  0x28000000,  0x3FF00244,  0x39BEF87F,  0x3E312704,
  0x28000000,  0x3FF00248,  0xA63F5309,  0x3E3A3FA9,
  0x2C000000,  0x3FF0024C,  0xA516AE5E,  0xBE3C97AE,
  0x2C000000,  0x3FF00250,  0xA442792A,  0xBE335F04,
  0x2C000000,  0x3FF00254,  0xA686F3A2,  0xBE242CB0,
  0x2C000000,  0x3FF00258,  0xC3237903,  0xBDE7B535,
  0x2C000000,  0x3FF0025C,  0x9E7A6CF7,  0x3E21560E,
  0x2C000000,  0x3FF00260,  0xA8C01385,  0x3E3223BA,
  0x2C000000,  0x3FF00264,  0x627012DF,  0x3E3BAC70,
  0x30000000,  0x3FF00268,  0x7FB232EA,  0xBE3ABAD7,
  0x30000000,  0x3FF0026C,  0xF9A6244B,  0xBE31121C,
  0x30000000,  0x3FF00270,  0x1DAC9AE4,  0xBE1D6580,
  0x30000000,  0x3FF00274,  0xD7FB0AC3,  0x3E037AFA,
  0x30000000,  0x3FF00278,  0x633420EB,  0x3E289042,
  0x30000000,  0x3FF0027C,  0x8065842A,  0x3E3630E5,
  0x34000000,  0x3FF00280,  0xB49DA4FF,  0xBE3FD653,
  0x34000000,  0x3FF00284,  0x696ECB76,  0xBE35CD8A,
  0x34000000,  0x3FF00288,  0x341A9D63,  0xBE27697D,
  0x34000000,  0x3FF0028C,  0x2788D238,  0xBDF8BF04,
  0x34000000,  0x3FF00290,  0x42A03782,  0x3E2159C1,
  0x34000000,  0x3FF00294,  0x154D4F89,  0x3E32F5B4,
  0x34000000,  0x3FF00298,  0x1D7FB2C1,  0x3E3D4E8A,
  0x38000000,  0x3FF0029C,  0x42181508,  0xBE38489D,
  0x38000000,  0x3FF002A0,  0x0AF2C28C,  0xBE2B9F84,
  0x38000000,  0x3FF002A4,  0x451C5357,  0xBE0A3721,
  0x38000000,  0x3FF002A8,  0x61A8605E,  0x3E1D47F1,
  0x38000000,  0x3FF002AC,  0x81B02FCF,  0x3E31FADF,
  0x38000000,  0x3FF002B0,  0x572F674A,  0x3E3CB3C5,
  0x3C000000,  0x3FF002B4,  0x231795EA,  0xBE388352,
  0x3C000000,  0x3FF002B8,  0xD248367A,  0xBE2B54CD,
  0x3C000000,  0x3FF002BC,  0xB7ABD90D,  0xBE060BC7,
  0x3C000000,  0x3FF002C0,  0x6EE9F1EF,  0x3E206EEF,
  0x3C000000,  0x3FF002C4,  0x261BF09E,  0x3E33406B,
  0x3C000000,  0x3FF002C8,  0x59001C60,  0x3E3E5961,
  0x40000000,  0x3FF002CC,  0xABDDD232,  0xBE367DA5,
  0x40000000,  0x3FF002D0,  0xC8FA5113,  0xBE268953,
  0x40000000,  0x3FF002D4,  0x8B33A701,  0x3D9152CC,
  0x40000000,  0x3FF002D8,  0x3E058570,  0x3E26BAAC,
  0x40000000,  0x3FF002DC,  0x63236E71,  0x3E36C65A,
  0x44000000,  0x3FF002E0,  0x7C7A795C,  0xBE3DC09E,
  0x44000000,  0x3FF002E4,  0x7BD63D1D,  0xBE323794,
  0x44000000,  0x3FF002E8,  0x5BBC9105,  0xBE1A7A1E,
  0x44000000,  0x3FF002EC,  0xD8EE2B1B,  0x3E142A20,
  0x44000000,  0x3FF002F0,  0xEFAA8A8D,  0x3E30C39A,
  0x44000000,  0x3FF002F4,  0x995E96A2,  0x3E3C8CB0,
  0x48000000,  0x3FF002F8,  0xC8A79469,  0xBE379A36,
  0x48000000,  0x3FF002FC,  0x64CE7203,  0xBE276236,
  0x48000000,  0x3FF00300,  0x0819DA68,  0x3DD200D8,
  0x48000000,  0x3FF00304,  0xE5E018D4,  0x3E28A249,
  0x48000000,  0x3FF00308,  0x8A087692,  0x3E386A49,
  0x4C000000,  0x3FF0030C,  0xD695988B,  0xBE3B6C8E,
  0x4C000000,  0x3FF00310,  0x55D2BCBA,  0xBE2E66C8,
  0x4C000000,  0x3FF00314,  0x7790BA7A,  0xBE0751B3,
  0x4C000000,  0x3FF00318,  0xC2A20261,  0x3E22DDF4,
  0x4C000000,  0x3FF0031C,  0x49E0B0B5,  0x3E35D82E,
  0x50000000,  0x3FF00320,  0xB142422E,  0xBE3DAE9A,
  0x50000000,  0x3FF00324,  0x8C170FE6,  0xBE312560,
  0x50000000,  0x3FF00328,  0x0A73BF77,  0xBE12308D,
  0x50000000,  0x3FF0032C,  0x5E59CEFA,  0x3E203A3A,
  0x50000000,  0x3FF00330,  0xCD4740BF,  0x3E34D660,
  0x54000000,  0x3FF00334,  0x644D1883,  0xBE3E6058,
  0x54000000,  0x3FF00338,  0x618F57B6,  0xBE31870E,
  0x54000000,  0x3FF0033C,  0x99FABD0F,  0xBE127704,
  0x54000000,  0x3FF00340,  0xA1CB5ECF,  0x3E20B71E,
  0x54000000,  0x3FF00344,  0x089E93E1,  0x3E3564E3,
  0x58000000,  0x3FF00348,  0xFB533142,  0xBE3D81C5,
  0x58000000,  0x3FF0034C,  0xB6EECE6C,  0xBE30586B,
  0x58000000,  0x3FF00350,  0x319B883E,  0xBE08F871,
  0x58000000,  0x3FF00354,  0x75BF7503,  0x3E2454A5,
  0x58000000,  0x3FF00358,  0xF04B88C5,  0x3E3783B6,
  0x5C000000,  0x3FF0035C,  0x81EF30A7,  0xBE3B12E1,
  0x5C000000,  0x3FF00360,  0x2F9F3657,  0xBE2B32ED,
  0x5C000000,  0x3FF00364,  0x54DF31BC,  0xBDB0084D,
  0x5C000000,  0x3FF00368,  0xC303B7B9,  0x3E2B12D2,
  0x5C000000,  0x3FF0036C,  0x78B56F97,  0x3E3B32DE,
  0x60000000,  0x3FF00370,  0x03B9496C,  0xBE3713A9,
  0x60000000,  0x3FF00374,  0x1F92E726,  0xBE22945A,
  0x60000000,  0x3FF00378,  0x621736DF,  0x3E123D49,
  0x60000000,  0x3FF0037C,  0x3935580D,  0x3E3278D5,
  0x64000000,  0x3FF00380,  0x69B9F5FB,  0xBE3F8DA4,
  0x64000000,  0x3FF00384,  0x8C473CC8,  0xBE31841A,
  0x64000000,  0x3FF00388,  0x538CDE07,  0xBE0B5469,
  0x64000000,  0x3FF0038C,  0x7F8F9D65,  0x3E257E07,
  0x64000000,  0x3FF00390,  0x3665E52B,  0x3E38F898,
  0x68000000,  0x3FF00394,  0xC29674BD,  0xBE38BDCF,
  0x68000000,  0x3FF00398,  0x4E58B4D9,  0xBE24C868,
  0x68000000,  0x3FF0039C,  0x329466D7,  0x3E1015AC,
  0x68000000,  0x3FF003A0,  0xDCDECE44,  0x3E327F0D,
  0x6C000000,  0x3FF003A4,  0xB27E5528,  0xBE3EF74B,
  0x6C000000,  0x3FF003A8,  0x9D7167F2,  0xBE305DA1,
  0x6C000000,  0x3FF003AC,  0xFF980820,  0xBDFB3F3D,
  0x6C000000,  0x3FF003B0,  0x13D49789,  0x3E2A0B7B,
  0x6C000000,  0x3FF003B4,  0xA43AE87C,  0x3E3BCF72,
  0x70000000,  0x3FF003B8,  0x8D06BDC0,  0xBE3556D4,
  0x70000000,  0x3FF003BC,  0x1766E54D,  0xBE19B460,
  0x70000000,  0x3FF003C0,  0x7B85C8BA,  0x3E211950,
  0x70000000,  0x3FF003C4,  0x41D00AED,  0x3E37966C,
  0x74000000,  0x3FF003C8,  0xF5B15507,  0xBE394FCB,
  0x74000000,  0x3FF003CC,  0xC98093C4,  0xBE244C00,
  0x74000000,  0x3FF003D0,  0xE2907BDF,  0x3E144F3B,
  0x74000000,  0x3FF003D4,  0x267CD924,  0x3E345DA2,
  0x78000000,  0x3FF003D8,  0xD73526C0,  0xBE3C4886,
  0x78000000,  0x3FF003DC,  0xF8E1D62E,  0xBE29BD57,
  0x78000000,  0x3FF003E0,  0xD65415E1,  0x3E04D995,
  0x78000000,  0x3FF003E4,  0x527E1A58,  0x3E322515,
  0x7C000000,  0x3FF003E8,  0x31552BA5,  0xBE3E4104,
  0x7C000000,  0x3FF003EC,  0x995CAB3B,  0xBE2D2E33,
  0x7C000000,  0x3FF003F0,  0x473970DC,  0x3DF22D48,
  0x7C000000,  0x3FF003F4,  0xC61195FC,  0x3E30ECC6,
  0x80000000,  0x3FF003F8,  0x03D35C34,  0xBE3F3943,
  0x80000000,  0x3FF003FC,  0xAA7483C7,  0xBE2E9E91,
  0x80000000,  0x3FF00400,  0xBBBC71CE,  0x3DE556AA,
  0x80000000,  0x3FF00404,  0x817613C1,  0x3E30B4B7,
  0x84000000,  0x3FF00408,  0x4E70B0AC,  0xBE3F3142,
  0x84000000,  0x3FF0040C,  0x2BAAD02F,  0xBE2E0E70,
  0x84000000,  0x3FF00410,  0xF48F01F2,  0x3DF32D62,
  0x84000000,  0x3FF00414,  0x84EB5B98,  0x3E317CE8,
  0x88000000,  0x3FF00418,  0x10ED210B,  0xBE3E2901,
  0x88000000,  0x3FF0041C,  0x1C7F0051,  0xBE2B7DCD,
  0x88000000,  0x3FF00420,  0x87AA2706,  0x3E05D9C0,
  0x88000000,  0x3FF00424,  0xD0B235B3,  0x3E33455A,
  0x8C000000,  0x3FF00428,  0x4B07A510,  0xBE3C207E,
  0x8C000000,  0x3FF0042C,  0x7C6E838B,  0xBE26ECA6,
  0x8C000000,  0x3FF00430,  0xEC91A8D5,  0x3E150F6F,
  0x8C000000,  0x3FF00434,  0x650C6A83,  0x3E360E0F,
  0x90000000,  0x3FF00438,  0xFC7E3439,  0xBE3917B8,
  0x90000000,  0x3FF0043C,  0x4AF4C8B6,  0xBE205AFA,
  0x90000000,  0x3FF00440,  0xDC31D181,  0x3E219985,
  0x90000000,  0x3FF00444,  0x423CC2BE,  0x3E39D707,
  0x94000000,  0x3FF00448,  0x250DC5BF,  0xBE350EB0,
  0x94000000,  0x3FF0044C,  0x1E2CF893,  0xBE0F231A,
  0x94000000,  0x3FF00450,  0xD42C92D4,  0x3E2AABDB,
  0x94000000,  0x3FF00454,  0x6887075B,  0x3E3EA043,
  0x98000000,  0x3FF00458,  0xC472509B,  0xBE300562,
  0x98000000,  0x3FF0045C,  0x72B572E0,  0x3DF64FB6,
  0x98000000,  0x3FF00460,  0xEF61155C,  0x3E32DF5D,
  0x9C000000,  0x3FF00464,  0x27CFFE6A,  0xBE3B963B,
  0x9C000000,  0x3FF00468,  0xB4CD96FE,  0xBE23F79F,
  0x9C000000,  0x3FF0046C,  0x6E771F13,  0x3E1EBA7F,
  0x9C000000,  0x3FF00470,  0xFE3ED608,  0x3E396913,
  0xA0000000,  0x3FF00474,  0x6E82850F,  0xBE34CC73,
  0xA0000000,  0x3FF00478,  0x352966B7,  0xBE078FB3,
  0xA0000000,  0x3FF0047C,  0x33AFF8AE,  0x3E2DF116,
  0xA4000000,  0x3FF00480,  0xE909EADD,  0xBE3F0CEE,
  0xA4000000,  0x3FF00484,  0xD6938597,  0xBE2A04C8,
  0xA4000000,  0x3FF00488,  0x5C6654D8,  0x3E1460AA,
  0xA4000000,  0x3FF0048C,  0x22213ECF,  0x3E3742BE,
  0xA8000000,  0x3FF00490,  0xC631A356,  0xBE3682A9,
  0xA8000000,  0x3FF00494,  0x7777B644,  0xBE10E034,
  0xA8000000,  0x3FF00498,  0x3E3B0991,  0x3E2C4528,
  0xAC000000,  0x3FF0049C,  0x0B3E269F,  0xBE3F72C6,
  0xAC000000,  0x3FF004A0,  0x31DF923B,  0xBE29F037,
  0xAC000000,  0x3FF004A4,  0xE82713DE,  0x3E164A4D,
  0xAC000000,  0x3FF004A8,  0x31AFAC4B,  0x3E382D47,
  0xB0000000,  0x3FF004AC,  0x6DFCE978,  0xBE352800,
  0xB0000000,  0x3FF004B0,  0x07D68D27,  0xBE036A1B,
  0xB0000000,  0x3FF004B4,  0x5CB71F6F,  0x3E305D7E,
  0xB4000000,  0x3FF004B8,  0x30E5E990,  0xBE3CC7BB,
  0xB4000000,  0x3FF004BC,  0x0BA17DEA,  0xBE23B9E0,
  0xB4000000,  0x3FF004C0,  0xC3EF9BD8,  0x3E223BBF,
  0xB4000000,  0x3FF004C4,  0x8A74ECC0,  0x3E3C28B4,
  0xB8000000,  0x3FF004C8,  0x085831CA,  0xBE30BC72,
  0xB8000000,  0x3FF004CC,  0x6C8D1FC8,  0x3E037361,
  0xB8000000,  0x3FF004D0,  0x3033A0B8,  0x3E35A94F,
  0xBC000000,  0x3FF004D4,  0xFC7107DE,  0xBE370BC8,
  0xBC000000,  0x3FF004D8,  0xA2D908DA,  0xBE0D86E2,
  0xBC000000,  0x3FF004DC,  0x58ED155E,  0x3E2F742A,
  0xC0000000,  0x3FF004E0,  0x75FACDD0,  0xBE3CCAF4,
  0xC0000000,  0x3FF004E4,  0x6F5BE5D3,  0xBE227FF2,
  0xC0000000,  0x3FF004E8,  0xD6BCA827,  0x3E24B60D,
  0xC0000000,  0x3FF004EC,  0xF72B40D6,  0x3E3E060B,
  0xC4000000,  0x3FF004F0,  0x208BE3E3,  0xBE2C7DD4,
  0xC4000000,  0x3FF004F4,  0x642FDDB8,  0x3E163093,
  0xC4000000,  0x3FF004F8,  0xB72239A5,  0x3E396738,
  0xC8000000,  0x3FF004FC,  0x7201ED9B,  0xBE32ADAE,
  0xC8000000,  0x3FF00500,  0x1A0C05F3,  0x3DF4D6F6,
  0xC8000000,  0x3FF00504,  0x360B8346,  0x3E355892,
  0xCC000000,  0x3FF00508,  0xF0C06435,  0xBE368C45,
  0xCC000000,  0x3FF0050C,  0x760DA2F6,  0xBE0308C8,
  0xCC000000,  0x3FF00510,  0xE008D57B,  0x3E31DA18,
  0xD0000000,  0x3FF00514,  0x205F82F4,  0xBE39DAB0,
  0xD0000000,  0x3FF00518,  0x2FE5E3E3,  0xBE15FDD0,
  0xD0000000,  0x3FF0051C,  0x42787241,  0x3E2DD79A,
  0xD4000000,  0x3FF00520,  0x94BD25F4,  0xBE3C98EC,
  0xD4000000,  0x3FF00524,  0x53C89D03,  0xBE201B42,
  0xD4000000,  0x3FF00528,  0xCB901057,  0x3E291B5E,
  0xD8000000,  0x3FF0052C,  0xE1B6D837,  0xBE3EC6FA,
  0xD8000000,  0x3FF00530,  0xF8BF49E7,  0xBE24173F,
  0xD8000000,  0x3FF00534,  0x339DDB57,  0x3E257F80,
  0xD8000000,  0x3FF00538,  0x64D62C5C,  0x3E3F9B25,
  0xDC000000,  0x3FF0053C,  0x2E913659,  0xBE26F2E0,
  0xDC000000,  0x3FF00540,  0x52E7CB93,  0x3E2303FF,
  0xDC000000,  0x3FF00544,  0xAB0CFEF5,  0x3E3E8D74,
  0xE0000000,  0x3FF00548,  0x1CF7FDE6,  0xBE28AE22,
  0xE0000000,  0x3FF0054C,  0x01B47B93,  0x3E21A8DD,
  0xE0000000,  0x3FF00550,  0x5D1107E2,  0x3E3E0FF3,
  0xE4000000,  0x3FF00554,  0xEBAC99E1,  0xBE294904,
  0xE4000000,  0x3FF00558,  0x184B2814,  0x3E216E1A,
  0xE4000000,  0x3FF0055C,  0xE706008B,  0x3E3E22A1,
  0xE8000000,  0x3FF00560,  0xC267616A,  0xBE28C387,
  0xE8000000,  0x3FF00564,  0x6EF3B008,  0x3E2253B7,
  0xE8000000,  0x3FF00568,  0xB50FF371,  0x3E3EC580,
  0xEC000000,  0x3FF0056C,  0xC8E0096B,  0xBE271DA9,
  0xEC000000,  0x3FF00570,  0xDDF69498,  0x3E2459B5,
  0xEC000000,  0x3FF00574,  0x33533C31,  0x3E3FF890,
  0xF0000000,  0x3FF00578,  0x26CDA497,  0xBE24576A,
  0xF0000000,  0x3FF0057C,  0x3D9CF923,  0x3E278016,
  0xF4000000,  0x3FF00580,  0x320B787B,  0xBE3E442F,
  0xF4000000,  0x3FF00584,  0x03E6A36B,  0xBE2070C8,
  0xF4000000,  0x3FF00588,  0x6630A33F,  0x3E2BC6D9,
  0xF8000000,  0x3FF0058C,  0x0EE72CBF,  0xBE3BF0BD,
  0xF8000000,  0x3FF00590,  0x0FC1A853,  0xBE16D385,
  0xF8000000,  0x3FF00594,  0x17FDFD5D,  0x3E309700,
  0xFC000000,  0x3FF00598,  0xF71A91AC,  0xBE390D18,
  0xFC000000,  0x3FF0059C,  0x69C58B86,  0xBE050963,
  0xFC000000,  0x3FF005A0,  0xB9A504CD,  0x3E33DAC5,
  0x00000000,  0x3FF005A5,  0x7E800734,  0xBE359942,
  0x00000000,  0x3FF005A9,  0xE59934CD,  0x3DF02BAE,
  0x00000000,  0x3FF005AD,  0x04333E0E,  0x3E37AEBE,
  0x04000000,  0x3FF005B1,  0x38F19C2F,  0xBE319539,
  0x04000000,  0x3FF005B5,  0xEBB1C157,  0x3E14DB54,
  0x04000000,  0x3FF005B9,  0x63CED05D,  0x3E3C12E9,
  0x08000000,  0x3FF005BD,  0x74921CAF,  0xBE2A01F9,
  0x08000000,  0x3FF005C1,  0xC94C85F2,  0x3E23F645,
  0x0C000000,  0x3FF005C5,  0xBB61CBEE,  0xBE3EF8B7,
  0x0C000000,  0x3FF005C9,  0x597F2931,  0xBE1F7232,
  0x0C000000,  0x3FF005CD,  0xAF5B7345,  0x3E2E9F48,
  0x10000000,  0x3FF005D1,  0xED37CD5F,  0xBE397424,
  0x10000000,  0x3FF005D5,  0x08775C6B,  0xBE013F43,
  0x10000000,  0x3FF005D9,  0x0029D3DB,  0x3E35345A,
  0x14000000,  0x3FF005DD,  0xC58C1962,  0xBE335F5D,
  0x14000000,  0x3FF005E1,  0x47430E04,  0x3E1073C1,
  0x14000000,  0x3FF005E5,  0x4A41E248,  0x3E3BA944,
  0x18000000,  0x3FF005E9,  0xB06E888E,  0xBE2974C3,
  0x18000000,  0x3FF005ED,  0xDCCD9333,  0x3E25E3FB,
  0x1C000000,  0x3FF005F1,  0x5DE27951,  0xBE3D519C,
  0x1C000000,  0x3FF005F5,  0xE4464502,  0xBE1614C2,
  0x1C000000,  0x3FF005F9,  0xE0DAFE93,  0x3E325740,
  0x20000000,  0x3FF005FD,  0x8C1B4C10,  0xBE35BC47,
  0x20000000,  0x3FF00601,  0x20686CE9,  0x3E0201B0,
  0x20000000,  0x3FF00605,  0x95558B63,  0x3E3A4CB9,
  0x24000000,  0x3FF00609,  0xA880A3EB,  0xBE2B2D79,
  0x24000000,  0x3FF0060D,  0x9699EEB7,  0x3E252BA5,
  0x28000000,  0x3FF00611,  0x880115E1,  0xBE3D2D97,
  0x28000000,  0x3FF00615,  0x28A3D788,  0xBE1383EF,
  0x28000000,  0x3FF00619,  0x08D6DC23,  0x3E337BA6,
  0x2C000000,  0x3FF0061D,  0x0B001A08,  0xBE3417B2,
  0x2C000000,  0x3FF00621,  0xF94EB99A,  0x3E1193EF,
  0x2C000000,  0x3FF00625,  0x28D3BD3B,  0x3E3CF1B0,
  0x30000000,  0x3FF00629,  0x0EFCC982,  0xBE24E32B,
  0x30000000,  0x3FF0062D,  0xE2BDA47F,  0x3E2C7655,
  0x34000000,  0x3FF00631,  0x689312F8,  0xBE39080E,
  0x34000000,  0x3FF00635,  0xA9444DB4,  0xBDCDA0C8,
  0x34000000,  0x3FF00639,  0x7B21FE23,  0x3E38A191,
  0x38000000,  0x3FF0063D,  0x7E67E1E1,  0xBE2CE32A,
  0x38000000,  0x3FF00641,  0x875A71F0,  0x3E251694,
  0x3C000000,  0x3FF00645,  0xF838F455,  0xBE3C67CF,
  0x3C000000,  0x3FF00649,  0x77274052,  0xBE0A571F,
  0x3C000000,  0x3FF0064D,  0x63AAEFA8,  0x3E35E20E,
  0x40000000,  0x3FF00651,  0xFC87DA70,  0xBE30E0F8,
  0x40000000,  0x3FF00655,  0xE9089AFD,  0x3E20D80B,
  0x44000000,  0x3FF00659,  0xC52F03BD,  0xBE3E36F4,
  0x44000000,  0x3FF0065D,  0x9680E14E,  0xBE1327A4,
  0x44000000,  0x3FF00661,  0xD732468D,  0x3E34B328,
  0x48000000,  0x3FF00665,  0xCAB5EF4A,  0xBE31BFBE,
  0x48000000,  0x3FF00669,  0xE2A2FBE1,  0x3E1F757F,
  0x4C000000,  0x3FF0066D,  0xDAB014DA,  0xBE3E757A,
  0x4C000000,  0x3FF00671,  0x02FB3FBB,  0xBE12E13D,
  0x4C000000,  0x3FF00675,  0xCA7E298D,  0x3E3514E2,
  0x50000000,  0x3FF00679,  0xB4F78B94,  0xBE310DE4,
  0x50000000,  0x3FF0067D,  0x89C35D05,  0x3E21BEB4,
  0x54000000,  0x3FF00681,  0x43F4895C,  0xBE3D2360,
  0x54000000,  0x3FF00685,  0x5BC49ADF,  0xBE08B0A2,
  0x54000000,  0x3FF00689,  0x32573159,  0x3E37073E,
  0x58000000,  0x3FF0068D,  0x8D0732D2,  0xBE2D96D1,
  0x58000000,  0x3FF00691,  0x9BF15E67,  0x3E26E3ED,
  0x5C000000,  0x3FF00695,  0x0C3250FB,  0xBE3A40A3,
  0x5C000000,  0x3FF00699,  0xFD0AE214,  0x3DBCC9AE,
  0x5C000000,  0x3FF0069D,  0x038868A1,  0x3E3A8A3D,
  0x60000000,  0x3FF006A1,  0x151D21CE,  0xBE25F092,
  0x60000000,  0x3FF006A5,  0x11738C43,  0x3E2F2A6F,
  0x64000000,  0x3FF006A9,  0x3E9CE96D,  0xBE35CD41,
  0x64000000,  0x3FF006AD,  0x8DBC2918,  0x3E138132,
  0x64000000,  0x3FF006B1,  0x32DF4C13,  0x3E3F9DE1,
  0x68000000,  0x3FF006B5,  0x3129E0B2,  0xBE16520E,
  0x68000000,  0x3FF006B9,  0x69F36A61,  0x3E35491E,
  0x6C000000,  0x3FF006BD,  0xCCCABCD4,  0xBE2F9271,
  0x6C000000,  0x3FF006C1,  0x0D59B899,  0x3E2668ED,
  0x70000000,  0x3FF006C5,  0x4AD435A0,  0xBE39BDD3,
  0x70000000,  0x3FF006C9,  0x9191CABB,  0x3DF5FE9A,
  0x70000000,  0x3FF006CD,  0x6676850B,  0x3E3C8DAD,
  0x74000000,  0x3FF006D1,  0x1D74934A,  0xBE206910,
  0x74000000,  0x3FF006D5,  0x4D886478,  0x3E331949,
  0x78000000,  0x3FF006D9,  0x80BFBBC2,  0xBE3188DE,
  0x78000000,  0x3FF006DD,  0x14DE1719,  0x3E23CA01,
  0x7C000000,  0x3FF006E1,  0x8CE98EC0,  0xBE3A9D19,
  0x7C000000,  0x3FF006E5,  0xA705A6E7,  0x3DEE1A67,
  0x7C000000,  0x3FF006E9,  0xECD5F851,  0x3E3C8EC6,
  0x80000000,  0x3FF006ED,  0xE839CE4D,  0xBE1F0CF9,
  0x80000000,  0x3FF006F1,  0x0C8CA46A,  0x3E33FAC3,
  0x84000000,  0x3FF006F5,  0x7B5703D8,  0xBE303734,
  0x84000000,  0x3FF006F9,  0xE490A112,  0x3E274DB5,
  0x88000000,  0x3FF006FD,  0xA693A093,  0xBE386B0E,
  0x88000000,  0x3FF00701,  0xF0B73DAA,  0x3E0C9875,
  0x88000000,  0x3FF00705,  0x2449A944,  0x3E3FA133,
  0x8C000000,  0x3FF00709,  0xBFE66C14,  0xBE110285,
  0x8C000000,  0x3FF0070D,  0x054EDCBD,  0x3E37ED91,
  0x90000000,  0x3FF00711,  0xEFB65924,  0xBE27A86A,
  0x90000000,  0x3FF00715,  0x1C8A0CF1,  0x3E307A0B,
  0x94000000,  0x3FF00719,  0x397FB1D6,  0xBE3327AD,
  0x94000000,  0x3FF0071D,  0x1412B9FB,  0x3E228D43,
  0x98000000,  0x3FF00721,  0x94D8FFB0,  0xBE3A3B08,
  0x98000000,  0x3FF00725,  0x6ED80040,  0x3E029AA3,
  0x98000000,  0x3FF00729,  0x9627250A,  0x3E3EF1B8,
  0x9C000000,  0x3FF0072D,  0x5FCB1B09,  0xBE117F70,
  0x9C000000,  0x3FF00731,  0x678F0789,  0x3E385E96,
  0xA0000000,  0x3FF00735,  0xCEA3485B,  0xBE25A5DF,
  0xA0000000,  0x3FF00739,  0xFF6D0303,  0x3E320B90,
  0xA4000000,  0x3FF0073D,  0xE03334FF,  0xBE3105E6,
  0xA4000000,  0x3FF00741,  0xFB9F056D,  0x3E27F150,
  0xA8000000,  0x3FF00745,  0xE28905F4,  0xBE36F8C0,
  0xA8000000,  0x3FF00749,  0x0B1407AA,  0x3E189774,
  0xAC000000,  0x3FF0074D,  0xCE4493C4,  0xBE3CAB7D,
  0xAC000000,  0x3FF00751,  0xCB817D78,  0x3DE265D5,
  0xAC000000,  0x3FF00755,  0x7CA8B4E3,  0x3E3DE1E2,
  0xB0000000,  0x3FF00759,  0x7D730FC6,  0xBE12FD89,
  0xB0000000,  0x3FF0075D,  0x1E4D7759,  0x3E38AF60,
  0xB4000000,  0x3FF00761,  0x0CAD84A2,  0xBE23A3AC,
  0xB4000000,  0x3FF00765,  0x36B866FD,  0x3E33BCFB,
  0xB8000000,  0x3FF00769,  0x4D0667A1,  0xBE2D4858,
  0xB8000000,  0x3FF0076D,  0xCBF08E6A,  0x3E2E1567,
  0xBC000000,  0x3FF00771,  0x9FD34D05,  0xBE333664,
  0xBC000000,  0x3FF00775,  0x9837D6E0,  0x3E253114,
  0xC0000000,  0x3FF00779,  0x5238327D,  0xBE37887F,
  0xC0000000,  0x3FF0077D,  0x24C8DC90,  0x3E1999FA,
  0xC4000000,  0x3FF00781,  0x1DA2F8BE,  0xBE3B9A7C,
  0xC4000000,  0x3FF00785,  0xEA50EE6A,  0x3E03A485,
  0xC8000000,  0x3FF00789,  0xE204A449,  0xBE3F6C5A,
  0xC8000000,  0x3FF0078D,  0x78D5D0F3,  0xBDF3D3EF,
  0xC8000000,  0x3FF00791,  0x80B1D66C,  0x3E3D01E4,
  0xCC000000,  0x3FF00795,  0xD5149796,  0xBE12BBC1,
  0xCC000000,  0x3FF00799,  0x2A8F92F0,  0x3E39B042,
  0xD0000000,  0x3FF0079D,  0x6F386487,  0xBE1F820E,
  0xD0000000,  0x3FF007A1,  0x3BA3BCDA,  0x3E369EBE,
  0xD4000000,  0x3FF007A5,  0x96320652,  0xBE25A3F0,
  0xD4000000,  0x3FF007A9,  0xD3FD8FCA,  0x3E33CD58,
  0xD8000000,  0x3FF007AD,  0xC62D40B1,  0xBE2B069C,
  0xD8000000,  0x3FF007B1,  0x13AC5766,  0x3E313C12,
  0xDC000000,  0x3FF007B5,  0x876F3A0B,  0xBE2FE90B,
  0xDC000000,  0x3FF007B9,  0x357EDEB8,  0x3E2DD5D4,
  0xE0000000,  0x3FF007BD,  0x4CEC957E,  0xBE32259E,
  0xE0000000,  0x3FF007C1,  0x128C86C6,  0x3E29B3C2,
  0xE4000000,  0x3FF007C5,  0xDEA61608,  0xBE341697,
  0xE4000000,  0x3FF007C9,  0xFEA09E70,  0x3E2611ED,
  0xE8000000,  0x3FF007CD,  0x58D49AE3,  0xBE35C772,
  0xE8000000,  0x3FF007D1,  0x39DA3D42,  0x3E22F058,
  0xEC000000,  0x3FF007D5,  0x9B689043,  0xBE37382D,
  0xEC000000,  0x3FF007D9,  0x04589AD6,  0x3E204F01,
  0xF0000000,  0x3FF007DD,  0x86525259,  0xBE3868C9,
  0xF0000000,  0x3FF007E1,  0x3C761DAC,  0x3E1C5BD1,
  0xF4000000,  0x3FF007E5,  0xF9822D4C,  0xBE395945,
  0xF4000000,  0x3FF007E9,  0x8F4221F9,  0x3E191A1E,
  0xF8000000,  0x3FF007ED,  0xD4E85D3A,  0xBE3A09A2,
  0xF8000000,  0x3FF007F1,  0x81547225,  0x3E16D8EA,
  0xFC000000,  0x3FF007F5,  0xF8750E3B,  0xBE3A79DF,
  0xFC000000,  0x3FF007F9,  0x92EC7DE3,  0x3E159835,
  0x00000000,  0x3FF007FE,  0x44185C5D,  0xBE3AA9FD } };

#endif
#endif
