; Tests ALIGN
; RUNOPT: -cpu=7-A

	MACRO
	TestCase $val
	DCD	$val + &10		; Offset &00
	ALIGN	16

	DCD	$val + &20		; Offset &10
	ALIGN	16, 0

	DCD	$val + &30		; Offset &20
	ALIGN	16, -16

	DCD	$val + &40		; Offset &30
	ALIGN	16, 32

	DCD	$val + &50		; Offset &40
	ALIGN	16, 12
	DCD	$val + &51
	ALIGN	16

	DCD	$val + &60, $val + &61, $val + &62
	ALIGN	16, -16
	DCD	$val + &63
	ALIGN	16

	DCD	$val + &70, $val + &71, $val + &72
	ALIGN	16, -12
	DCD	$val + &73
	ALIGN	16

	DCD	$val + &80, $val + &81, $val + &82
	ALIGN	16, -8
	DCD	$val + &83
	ALIGN	16

	DCD	$val + &90, $val + &91, $val + &92
	ALIGN	16, -4
	DCD	$val + &93
	ALIGN	16

	DCD	$val + &A0, $val + &A1, $val + &A2
	ALIGN	16, 0
	DCD	$val + &A3
	ALIGN	16

	DCD	$val + &B0, $val + &B1, $val + &B2
	ALIGN	16, 4
	DCD	$val + &B3
	ALIGN	16

	DCD	$val + &C0, $val + &C1, $val + &C2
	ALIGN	16, 8
	DCD	$val + &C3
	ALIGN	16

	DCD	$val + &D0, $val + &D1, $val + &D2
	ALIGN	16, 12
	DCD	$val + &D3
	ALIGN	16

	DCD	$val + &E0, $val + &E1, $val + &E2
	ALIGN	16, 16
	DCD	$val + &E3
	ALIGN	16

	MEND

	[ :LNOT: REFERENCE

	AREA	Data1, DATA

	TestCase &1000

	AREA	Data2, DATA
	ORG	4
	
	TestCase &2000

	AREA	Data3, DATA
	ORG	8
	
	TestCase &3000

	AREA	Data4, DATA
	ORG	12
	
	TestCase &4000

	|

	AREA	Data1, DATA

	DCD &00001010, &00000000, &00000000, &00000000
	DCD &00001020, &00000000, &00000000, &00000000
	DCD &00001030, &00000000, &00000000, &00000000
	DCD &00001040, &00000000, &00000000, &00000000
	DCD &00001050, &00000000, &00000000, &00001051
	DCD &00001060, &00001061, &00001062, &00000000, &00001063, &00000000, &00000000, &00000000
	DCD &00001070, &00001071, &00001072, &00000000, &00000000, &00001073, &00000000, &00000000
	DCD &00001080, &00001081, &00001082, &00000000, &00000000, &00000000, &00001083, &00000000
	DCD &00001090, &00001091, &00001092, &00001093
	DCD &000010a0, &000010a1, &000010a2, &00000000, &000010a3, &00000000, &00000000, &00000000
	DCD &000010b0, &000010b1, &000010b2, &00000000, &00000000, &000010b3, &00000000, &00000000
	DCD &000010c0, &000010c1, &000010c2, &00000000, &00000000, &00000000, &000010c3, &00000000
	DCD &000010d0, &000010d1, &000010d2, &000010d3, &000010e0, &000010e1, &000010e2, &00000000
	DCD &000010e3, &00000000, &00000000, &00000000

	AREA	Data2, DATA
	ORG	4

	DCD &00002010, &00000000, &00000000
	DCD &00002020, &00000000, &00000000, &00000000
	DCD &00002030, &00000000, &00000000, &00000000
	DCD &00002040, &00000000, &00000000, &00000000
	DCD &00002050, &00000000, &00000000, &00002051
	DCD &00002060, &00002061, &00002062, &00000000, &00002063, &00000000, &00000000, &00000000
	DCD &00002070, &00002071, &00002072, &00000000, &00000000, &00002073, &00000000, &00000000
	DCD &00002080, &00002081, &00002082, &00000000, &00000000, &00000000, &00002083, &00000000
	DCD &00002090, &00002091, &00002092, &00002093
	DCD &000020a0, &000020a1, &000020a2, &00000000, &000020a3, &00000000, &00000000, &00000000
	DCD &000020b0, &000020b1, &000020b2, &00000000, &00000000, &000020b3, &00000000, &00000000
	DCD &000020c0, &000020c1, &000020c2, &00000000, &00000000, &00000000, &000020c3, &00000000
	DCD &000020d0, &000020d1, &000020d2, &000020d3
	DCD &000020e0, &000020e1, &000020e2, &00000000, &000020e3, &00000000, &00000000, &00000000

	AREA	Data3, DATA
	ORG	8

	DCD &00003010, &00000000
	DCD &00003020, &00000000, &00000000, &00000000
	DCD &00003030, &00000000, &00000000, &00000000
	DCD &00003040, &00000000, &00000000, &00000000
	DCD &00003050, &00000000, &00000000, &00003051
	DCD &00003060, &00003061, &00003062, &00000000, &00003063, &00000000, &00000000, &00000000
	DCD &00003070, &00003071, &00003072, &00000000, &00000000, &00003073, &00000000, &00000000
	DCD &00003080, &00003081, &00003082, &00000000, &00000000, &00000000, &00003083, &00000000
	DCD &00003090, &00003091, &00003092, &00003093
	DCD &000030a0, &000030a1, &000030a2, &00000000, &000030a3, &00000000, &00000000, &00000000
	DCD &000030b0, &000030b1, &000030b2, &00000000, &00000000, &000030b3, &00000000, &00000000
	DCD &000030c0, &000030c1, &000030c2, &00000000, &00000000, &00000000, &000030c3, &00000000
	DCD &000030d0, &000030d1, &000030d2, &000030d3
	DCD &000030e0, &000030e1, &000030e2, &00000000, &000030e3, &00000000, &00000000, &00000000

	AREA	Data4, DATA
	ORG	12

	DCD &00004010
	DCD &00004020, &00000000, &00000000, &00000000
	DCD &00004030, &00000000, &00000000, &00000000
	DCD &00004040, &00000000, &00000000, &00000000
	DCD &00004050, &00000000, &00000000, &00004051
	DCD &00004060, &00004061, &00004062, &00000000, &00004063, &00000000, &00000000, &00000000
	DCD &00004070, &00004071, &00004072, &00000000, &00000000, &00004073, &00000000, &00000000
	DCD &00004080, &00004081, &00004082, &00000000, &00000000, &00000000, &00004083, &00000000
	DCD &00004090, &00004091, &00004092, &00004093
	DCD &000040a0, &000040a1, &000040a2, &00000000, &000040a3, &00000000, &00000000, &00000000
	DCD &000040b0, &000040b1, &000040b2, &00000000, &00000000, &000040b3, &00000000, &00000000
	DCD &000040c0, &000040c1, &000040c2, &00000000, &00000000, &00000000, &000040c3, &00000000
	DCD &000040d0, &000040d1, &000040d2, &000040d3
	DCD &000040e0, &000040e1, &000040e2, &00000000, &000040e3, &00000000, &00000000, &00000000
	
	]

	; Test fill value and fill value size:
	[ :LNOT: REFERENCE

	AREA	DataFill, DATA

	DCB	0x11
	ALIGN	8, 0, 0xFF
	DCB	0x22
	ALIGN	8, 0, 0xFF, 1
	DCB	0x33
	ALIGN	8, 0, 0xFFEE, 2
	DCB	0x44
	ALIGN	8, 0, 0xFFEEDDCC, 4

	AREA	CodeFill, CODE

	ARM
	DCB	0x11
	ALIGN	4, 0, 0xFFEEDDCC

	THUMB
	DCB	0x22
	ALIGN	4, 0, 0xFFEEDDCC	; Warning: Size value -1122868 (= 0xffeeddcc) exceeds 2 bytes

	|

	AREA	DataFill, DATA
	
	DCD	0xFFFFFF11, 0xFFFFFFFF
	DCD	0xFFFFFF22, 0xFFFFFFFF
	DCD	0xFFEEFF33, 0xFFEEFFEE
	DCD	0xFFEEDD44, 0xFFEEDDCC
	
	AREA	CodeFill, CODE

	ARM
	DCD	0xFFEEDD11

	THUMB
	DCW	0xDD22
	DCW	0xDDCC

	]

	; Test align for CODE areas with CODEALIGN attribute.
	[ :LNOT: REFERENCE
	AREA	CodeAlign, CODE, CODEALIGN

	ARM
	UND
	ALIGN	16

	THUMB
	UND
	ALIGN	8

	ARM
	DCD	&44332211
	ALIGN	16		; No NOP (as it is not following ARM/Thumb instruction)

	THUMB
	DCW	&6655
	ALIGN	8		; No NOP (as it is not following ARM/Thumb instruction)
	|
	AREA	CodeAlign, CODE		; No CODEALIGN necessary.

	ARM
	UND
	NOP
	NOP
	NOP

	THUMB
	UND
	NOP
	NOP
	NOP

	DCD	&44332211
	DCD	0
	DCD	&00006655
	DCD	0
	]

	END
