/*
 * Copyright (c) 2000-2022 UnixLib Developers
 */

#ifndef __INTERNAL_SWIPARAMS_H
#define __INTERNAL_SWIPARAMS_H

/* Limited set of SWI parameters needed in UnixLib itself */

#define OSFIND_OPEN_OPENIN            (4<<4)
#define OSFIND_OPEN_OPENOUT           (8<<4)
#define OSFIND_OPEN_OPENUP            (12<<4)

#define OSFIND_OPEN_PATH              1
#define OSFIND_OPEN_PATHVAR           2
#define OSFIND_OPEN_NOPATH	      3
#define OSFIND_OPEN_ERRORIFABSENT     8
#define OSFIND_OPEN_ERRORIFDIR	      4

#define OSFIND_OPENIN	   (OSFIND_OPEN_OPENIN | OSFIND_OPEN_NOPATH)
#define OSFIND_OPENOUT	   (OSFIND_OPEN_OPENOUT | OSFIND_OPEN_NOPATH)
#define OSFIND_OPENUP	   (OSFIND_OPEN_OPENUP | OSFIND_OPEN_NOPATH)

#define MMM_TYPE_RISCOS               0
#define MMM_TYPE_RISCOS_STRING        1
#define MMM_TYPE_MIME                 2
#define MMM_TYPE_DOT_EXTN             3

#define ARMEABISUPPORT_ABORTOP_READ_ERROR	4

#define ARMEABISUPPORT_STACKOP_ALLOC		0
#define ARMEABISUPPORT_STACKOP_FREE		1
#define ARMEABISUPPORT_STACKOP_GET_STACK	2
#define ARMEABISUPPORT_STACKOP_GET_BOUNDS	3
#define ARMEABISUPPORT_STACKOP_GET_SIZE		4

#define ARMEABISUPPORT_MMAPOP_MAP		0
#define ARMEABISUPPORT_MMAPOP_UNMAP		1
#define ARMEABISUPPORT_MMAPOP_ADVISE		2
#define ARMEABISUPPORT_MMAPOP_PROTECT		3
#define ARMEABISUPPORT_MMAPOP_GET_INFO		4
#define ARMEABISUPPORT_MMAPOP_MREMAP		5

#define ARMEABISUPPORT_SHMOP_OPEN		0
#define ARMEABISUPPORT_SHMOP_UNLINK		1
#define ARMEABISUPPORT_SHMOP_CLOSE		2
#define ARMEABISUPPORT_SHMOP_DUP		3

#define ARMEABISUPPORT_ERROR_BAD_REASON		0x81DC20
#define ARMEABISUPPORT_ERROR_BAD_PARAM		0x81DC21
#define ARMEABISUPPORT_ERROR_NO_MEMORY		0x81DC22
#define ARMEABISUPPORT_ERROR_BAD_PROCESS	0x81DC23
#define ARMEABISUPPORT_ERROR_IN_USE		0x81DC24
#define ARMEABISUPPORT_ERROR_PAGE_MAP_ERROR	0x81DC25
#define ARMEABISUPPORT_ERROR_EACCES		0x81DC26
#define ARMEABISUPPORT_ERROR_EEXIST		0x81DC27
#define ARMEABISUPPORT_ERROR_EINVAL		0x81DC28
#define ARMEABISUPPORT_ERROR_ENAMETOOLONG	0x81DC29
#define ARMEABISUPPORT_ERROR_ENOENT		0x81DC2A
#define ARMEABISUPPORT_ERROR_ENOSPC		0x81DC2B
#define ARMEABISUPPORT_ERROR_EBADF		0x81DC2C
#define ARMEABISUPPORT_ERROR_ENOMEM		0x81DC2D
#define ARMEABISUPPORT_ERROR_EOPSYS		0x81DC2E

#endif
