/*
 * IBM Accurate Mathematical Library
 * Written by International Business Machines Corp.
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/****************************************************************/
/* TABLES FOR THE uatan() FUNCTION                               */
/****************************************************************/

#include "endian.h"

#ifdef BIG_ENDI

  static const number
      cij[241][7] = {                             /* x0,cij for (1/16,1) */
/**/                 {{{0X3FB04006, 0X65E0244E} },
/**/                  {{0X3FB03A73, 0X7B53DD20} },
/**/                  {{0X3FEFDF1F, 0XCF5CFB72} },
/**/                  {{0XBFB01EB3, 0XCE2AE4C2} },
/**/                  {{0XBFD4D29E, 0XDD58A40D} },
/**/                  {{0X3FAFDA4A, 0XD907A18A} },
/**/                  {{0X3FC814DF, 0X4DF65B18} } },
/**/                 {{{0X3FB0FFFD, 0XB9B88CD8} },
/**/                  {{0X3FB0F99C, 0X63645300} },
/**/                  {{0X3FEFDC08, 0XA3DED30F} },
/**/                  {{0XBFB0D9DC, 0X669C1AED} },
/**/                  {{0XBFD4C669, 0XF7138DE2} },
/**/                  {{0X3FB0A12F, 0X29D085A7} },
/**/                  {{0X3FC7F0EE, 0XCFD48D20} } },
/**/                 {{{0X3FB1FFF1, 0X5A73D4F1} },
/**/                  {{0X3FB1F85F, 0X2BEE2040} },
/**/                  {{0X3FEFD7B3, 0X42B56D31} },
/**/                  {{0XBFB1D2B7, 0XB69DEA40} },
/**/                  {{0XBFD4B552, 0X3922ECC9} },
/**/                  {{0X3FB18F93, 0X522B1A04} },
/**/                  {{0X3FC7BEAD, 0X5660F061} } },
/**/                 {{{0X3FB2FFFD, 0XB2524AA2} },
/**/                  {{0X3FB2F716, 0XE71790A0} },
/**/                  {{0X3FEFD31F, 0X53B496A4} },
/**/                  {{0XBFB2CAD8, 0X4AAB7374} },
/**/                  {{0XBFD4A34B, 0X58DD2FB2} },
/**/                  {{0X3FB27C0A, 0XD0CECC18} },
/**/                  {{0X3FC789D2, 0X5D2743D7} } },
/**/                 {{{0X3FB3FFFE, 0X0573F3AC} },
/**/                  {{0X3FB3F59D, 0X1702F6A0} },
/**/                  {{0X3FEFCE4D, 0XB071ACC2} },
/**/                  {{0XBFB3C20F, 0X64DB3686} },
/**/                  {{0XBFD49059, 0XEB3BFE93} },
/**/                  {{0X3FB36659, 0XCAF74FED} },
/**/                  {{0X3FC75269, 0X1C011FB0} } },
/**/                 {{{0X3FB4FFEF, 0X894384D6} },
/**/                  {{0X3FB4F3ED, 0X0CE204C0} },
/**/                  {{0X3FEFC93E, 0XA8EA5A01} },
/**/                  {{0XBFB4B84F, 0X7B5457C9} },
/**/                  {{0XBFD47C80, 0X7401F2F9} },
/**/                  {{0X3FB44E64, 0XB4F67209} },
/**/                  {{0X3FC7187D, 0X4C540B77} } },
/**/                 {{{0X3FB5FFF8, 0XDF406528} },
/**/                  {{0X3FB5F22B, 0X3C73D820} },
/**/                  {{0X3FEFC3F1, 0XB1F60F13} },
/**/                  {{0XBFB5ADB2, 0XCB7FA73B} },
/**/                  {{0XBFD467BE, 0X2B1EB555} },
/**/                  {{0X3FB53435, 0X99EDC463} },
/**/                  {{0X3FC6DC1B, 0X238F5059} } },
/**/                 {{{0X3FB7000F, 0X8C4F0D56} },
/**/                  {{0X3FB6F04B, 0X495A2FA0} },
/**/                  {{0X3FEFBE67, 0X340DCE97} },
/**/                  {{0XBFB6A224, 0X4D98E1AD} },
/**/                  {{0XBFD45216, 0X14064DF1} },
/**/                  {{0X3FB617AA, 0X2BA78A66} },
/**/                  {{0X3FC69D4F, 0X50A3D7AC} } },
/**/                 {{{0X3FB8000F, 0XBB4057CF} },
/**/                  {{0X3FB7EE27, 0XBE2CD3A0} },
/**/                  {{0X3FEFB8A0, 0X39EC9246} },
/**/                  {{0XBFB79577, 0X31D9C773} },
/**/                  {{0XBFD43B8D, 0XB6DC7D72} },
/**/                  {{0X3FB6F88A, 0XD69547DF} },
/**/                  {{0X3FC65C26, 0XF633CE8C} } },
/**/                 {{{0X3FB8FFF2, 0X39CF2B7F} },
/**/                  {{0X3FB8EBB7, 0X9F979E80} },
/**/                  {{0X3FEFB29D, 0X435506E1} },
/**/                  {{0XBFB8879A, 0X69B9CDB5} },
/**/                  {{0XBFD42428, 0X85FEAFA9} },
/**/                  {{0X3FB7D6BA, 0XB6191A0E} },
/**/                  {{0X3FC618AF, 0XA7CB8BB5} } },
/**/                 {{{0X3FB9FFF9, 0X6E2F0772} },
/**/                  {{0X3FB9E93A, 0XD32A9480} },
/**/                  {{0X3FEFAC5D, 0X04A3EC40} },
/**/                  {{0XBFB978C2, 0X53F6EA97} },
/**/                  {{0XBFD40BE3, 0X089C36F6} },
/**/                  {{0X3FB8B25C, 0X885AEB77} },
/**/                  {{0X3FC5D2F7, 0X63CADCE1} } },
/**/                 {{{0X3FBB0002, 0X6316B097} },
/**/                  {{0X3FBAE68C, 0XCE24CC00} },
/**/                  {{0X3FEFA5E0, 0X938C5C66} },
/**/                  {{0XBFBA68C3, 0X76F14E4B} },
/**/                  {{0XBFD3F2C3, 0X1696CD7C} },
/**/                  {{0X3FB98B3B, 0X722A2CB4} },
/**/                  {{0X3FC58B0C, 0X9067AD62} } },
/**/                 {{{0X3FBC0008, 0X604F58B1} },
/**/                  {{0X3FBBE3A7, 0X05650780} },
/**/                  {{0X3FEF9F28, 0X5A7A2773} },
/**/                  {{0XBFBB578F, 0X3D5AC0A4} },
/**/                  {{0XBFD3D8CB, 0XF767119F} },
/**/                  {{0X3FBA613D, 0XC7E31B88} },
/**/                  {{0X3FC540FD, 0XF5594565} } },
/**/                 {{{0X3FBD0002, 0X6CCA4EBA} },
/**/                  {{0X3FBCE07E, 0XC1298A80} },
/**/                  {{0X3FEF9834, 0XE8D36C4A} },
/**/                  {{0XBFBC4513, 0X5BCAC5FE} },
/**/                  {{0XBFD3BE01, 0X8B5236F1} },
/**/                  {{0X3FBB3447, 0X2E991970} },
/**/                  {{0X3FC4F4DA, 0XB8ADB373} } },
/**/                 {{{0X3FBDFFF4, 0XB2B47FCA} },
/**/                  {{0X3FBDDD16, 0X4A051D80} },
/**/                  {{0X3FEF9106, 0X78DCC895} },
/**/                  {{0XBFBD3149, 0XF0966844} },
/**/                  {{0XBFD3A266, 0X744F9A5F} },
/**/                  {{0X3FBC0446, 0XEDB7F27A} },
/**/                  {{0X3FC4A6B2, 0X583F9ECA} } },
/**/                 {{{0X3FBF000A, 0XA9A05BE0} },
/**/                  {{0X3FBED996, 0XA3BDA540} },
/**/                  {{0X3FEF899C, 0X1B8BA97F} },
/**/                  {{0XBFBE1C51, 0X2287A677} },
/**/                  {{0XBFD385F8, 0XEDC130BB} },
/**/                  {{0X3FBCD14B, 0XF306FF50} },
/**/                  {{0X3FC45694, 0XA667A72B} } },
/**/                 {{{0X3FBFFFFA, 0XBA8F63DE} },
/**/                  {{0X3FBFD5B5, 0X69FE4780} },
/**/                  {{0X3FEF81F8, 0X4863DC7D} },
/**/                  {{0XBFBF05DB, 0XD1518706} },
/**/                  {{0XBFD368C4, 0X4687A69C} },
/**/                  {{0X3FBD9B08, 0X1B3868DA} },
/**/                  {{0X3FC40491, 0XC345ADFC} } },
/**/                 {{{0X3FC07FFA, 0X6ECCADA8} },
/**/                  {{0X3FC068D0, 0X0A396400} },
/**/                  {{0X3FEF7A19, 0XF1FCFC6B} },
/**/                  {{0XBFBFEE0C, 0X861DF0DF} },
/**/                  {{0XBFD34AC6, 0X5A586C0C} },
/**/                  {{0X3FBE618F, 0X189D637A} },
/**/                  {{0X3FC3B0BA, 0X195779D4} } },
/**/                 {{{0X3FC10003, 0X33432713} },
/**/                  {{0X3FC0E6B0, 0XF203D1A0} },
/**/                  {{0X3FEF7200, 0XFE0EB463} },
/**/                  {{0XBFC06A72, 0XE15CB19A} },
/**/                  {{0XBFD32C00, 0XB8DB761E} },
/**/                  {{0X3FBF24D8, 0XA11F5E3E} },
/**/                  {{0X3FC35B1E, 0X569E85DD} } },
/**/                 {{{0X3FC17FFC, 0XDA1C4811} },
/**/                  {{0X3FC16462, 0X29EBDA00} },
/**/                  {{0X3FEF69AF, 0X7D558737} },
/**/                  {{0XBFC0DD17, 0X0B33969B} },
/**/                  {{0XBFD30C7D, 0X33AC50D1} },
/**/                  {{0X3FBFE4AA, 0X9BE43F0F} },
/**/                  {{0X3FC303CF, 0X692539CB} } },
/**/                 {{{0X3FC1FFFF, 0X3CCA418D} },
/**/                  {{0X3FC1E1FA, 0X3B978EA0} },
/**/                  {{0X3FEF6124, 0X45D421A9} },
/**/                  {{0XBFC14F03, 0XACAC8AA8} },
/**/                  {{0XBFD2EC39, 0X62E675A3} },
/**/                  {{0X3FC0508C, 0X2FA6B426} },
/**/                  {{0X3FC2AADE, 0X780A6467} } },
/**/                 {{{0X3FC27FF7, 0XD9C78922} },
/**/                  {{0X3FC25F66, 0X1B91E640} },
/**/                  {{0X3FEF5860, 0XF52E192C} },
/**/                  {{0XBFC1C023, 0XE5DE2394} },
/**/                  {{0XBFD2CB3D, 0X6BEE0ABD} },
/**/                  {{0X3FC0ACFB, 0X5E075C1A} },
/**/                  {{0X3FC2505C, 0XDFFE453A} } },
/**/                 {{{0X3FC2FFF7, 0XA1FC1AAA} },
/**/                  {{0X3FC2DCB5, 0X83257C40} },
/**/                  {{0X3FEF4F64, 0XC719B6FB} },
/**/                  {{0XBFC23082, 0X61514083} },
/**/                  {{0XBFD2A988, 0X7F7B72D5} },
/**/                  {{0X3FC107A7, 0X7C887402} },
/**/                  {{0X3FC1F45C, 0X2C3CD6D1} } },
/**/                 {{{0X3FC38005, 0X9D78E15E} },
/**/                  {{0X3FC359EE, 0X6AC98EE0} },
/**/                  {{0X3FEF462F, 0X944CEC16} },
/**/                  {{0XBFC2A020, 0XD85B87A9} },
/**/                  {{0XBFD2871C, 0X2E4AB369} },
/**/                  {{0X3FC1608D, 0XC31A65D9} },
/**/                  {{0X3FC196EE, 0X130BBE50} } },
/**/                 {{{0X3FC40004, 0X9F431B1A} },
/**/                  {{0X3FC3D6F3, 0X6BD65360} },
/**/                  {{0X3FEF3CC3, 0XDD99B68A} },
/**/                  {{0XBFC30EE1, 0XB3DD00ED} },
/**/                  {{0XBFD26403, 0XF8482664} },
/**/                  {{0X3FC1B792, 0XFE136626} },
/**/                  {{0X3FC13824, 0X6EAC7440} } },
/**/                 {{{0X3FC48004, 0XE01D95A1} },
/**/                  {{0X3FC453D3, 0X86F00CC0} },
/**/                  {{0X3FEF3320, 0XE3970539} },
/**/                  {{0XBFC37CCF, 0X0A5279AA} },
/**/                  {{0XBFD2403F, 0X3B151D5D} },
/**/                  {{0X3FC20CBB, 0XE331C9E6} },
/**/                  {{0X3FC0D811, 0X39E3F097} } },
/**/                 {{{0X3FC4FFF7, 0XAA9382DD} },
/**/                  {{0X3FC4D07F, 0X8C590A80} },
/**/                  {{0X3FEF2948, 0X34DF28E0} },
/**/                  {{0XBFC3E9D8, 0X5B43915C} },
/**/                  {{0XBFD21BD5, 0XEB8845A2} },
/**/                  {{0X3FC25FF8, 0XAC6AC8AD} },
/**/                  {{0X3FC076C6, 0X88ED96CA} } },
/**/                 {{{0X3FC58006, 0X352408BE} },
/**/                  {{0X3FC54D1E, 0XC39A73E0} },
/**/                  {{0X3FEF1F37, 0X09AE009C} },
/**/                  {{0XBFC4561C, 0XB9BE8550} },
/**/                  {{0XBFD1F6C0, 0X0053F52E} },
/**/                  {{0X3FC2B15D, 0XEF783BE9} },
/**/                  {{0X3FC01456, 0X8615239B} } },
/**/                 {{{0X3FC5FFFF, 0X2B193F81} },
/**/                  {{0X3FC5C980, 0X4F73E000} },
/**/                  {{0X3FEF14F1, 0XAE110E29} },
/**/                  {{0XBFC4C16E, 0X9098B3D2} },
/**/                  {{0XBFD1D10F, 0X8F058241} },
/**/                  {{0X3FC300C6, 0XA14FA897} },
/**/                  {{0X3FBF61A6, 0XD56607C0} } },
/**/                 {{{0X3FC68008, 0X4460E6E1} },
/**/                  {{0X3FC645C8, 0X04A55E20} },
/**/                  {{0X3FEF0A75, 0X8FA36EC5} },
/**/                  {{0XBFC52BE9, 0XD62FA883} },
/**/                  {{0XBFD1AABD, 0X69A74048} },
/**/                  {{0X3FC34E45, 0X1679EB02} },
/**/                  {{0X3FBE989E, 0XF7C14C3D} } },
/**/                 {{{0X3FC6FFFB, 0X9E99A846} },
/**/                  {{0X3FC6C1D0, 0X4B35FD40} },
/**/                  {{0X3FEEFFC6, 0X3EF8EF95} },
/**/                  {{0XBFC5956B, 0X76A2FE63} },
/**/                  {{0XBFD183D8, 0XDDC78DDF} },
/**/                  {{0X3FC399BD, 0XAC606D66} },
/**/                  {{0X3FBDCDBA, 0X070D286A} } },
/**/                 {{{0X3FC78008, 0X0FFCD490} },
/**/                  {{0X3FC73DC5, 0XB55758E0} },
/**/                  {{0X3FEEF4E0, 0X457E2065} },
/**/                  {{0XBFC5FE16, 0X7D6FF9BC} },
/**/                  {{0XBFD15C57, 0X9FADD384} },
/**/                  {{0X3FC3E347, 0X73E52D32} },
/**/                  {{0X3FBD011C, 0X9A65AE4B} } },
/**/                 {{{0X3FC80006, 0X148E79C1} },
/**/                  {{0X3FC7B981, 0X2B7F8CA0} },
/**/                  {{0X3FEEE9C7, 0X701687ED} },
/**/                  {{0XBFC665C7, 0X0E1EF36D} },
/**/                  {{0XBFD13449, 0XCCBCBDAB} },
/**/                  {{0X3FC42AC7, 0X5C71B3E8} },
/**/                  {{0X3FBC32EB, 0X3E81980E} } },
/**/                 {{{0X3FC88006, 0X0F487C17} },
/**/                  {{0X3FC83511, 0XBC0E3640} },
/**/                  {{0X3FEEDE7A, 0XD2D55329} },
/**/                  {{0XBFC6CC87, 0X37E644BA} },
/**/                  {{0XBFD10BAE, 0X60597557} },
/**/                  {{0X3FC47043, 0X13E26FBE} },
/**/                  {{0X3FBB634A, 0X6FB18BF4} } },
/**/                 {{{0X3FC90004, 0XD3518D76} },
/**/                  {{0X3FC8B073, 0X8874C100} },
/**/                  {{0X3FEED2FB, 0X2ED6673B} },
/**/                  {{0XBFC73251, 0X2A6EBAC3} },
/**/                  {{0XBFD0E28A, 0X6924232F} },
/**/                  {{0X3FC4B3B5, 0X73BCC03F} },
/**/                  {{0X3FBA925E, 0X8C72507F} } },
/**/                 {{{0X3FC97FFF, 0XD2F20D5C} },
/**/                  {{0X3FC92BA3, 0X51AF5920} },
/**/                  {{0X3FEEC749, 0X3D32449F} },
/**/                  {{0XBFC7971F, 0XC308255F} },
/**/                  {{0XBFD0B8E2, 0XD572D28F} },
/**/                  {{0X3FC4F51A, 0X337448FE} },
/**/                  {{0X3FB9C04B, 0XCFCBC620} } },
/**/                 {{{0X3FCA0005, 0XBF80F060} },
/**/                  {{0X3FC9A6AE, 0X6E9E8960} },
/**/                  {{0X3FEEBB64, 0X1EF200E7} },
/**/                  {{0XBFC7FAFB, 0X6E96E5C1} },
/**/                  {{0XBFD08EB6, 0XEC6AD647} },
/**/                  {{0X3FC53475, 0XF53D0BA6} },
/**/                  {{0X3FB8ED36, 0X4433C20E} } },
/**/                 {{{0X3FCA7FF7, 0XDEECA8E4} },
/**/                  {{0X3FCA2176, 0X948578E0} },
/**/                  {{0X3FEEAF4F, 0X328FF98B} },
/**/                  {{0XBFC85DC9, 0X58149B1C} },
/**/                  {{0XBFD06414, 0XF933A1AB} },
/**/                  {{0X3FC571B7, 0X60C45A8F} },
/**/                  {{0X3FB81941, 0XBE58C308} } },
/**/                 {{{0X3FCAFFFF, 0X7DEFD553} },
/**/                  {{0X3FCA9C22, 0X9EBA6B80} },
/**/                  {{0X3FEEA307, 0X10A85E10} },
/**/                  {{0XBFC8BFA6, 0X7F9DEA61} },
/**/                  {{0XBFD038F3, 0X5A474E8F} },
/**/                  {{0X3FC5ACF0, 0X30C225D2} },
/**/                  {{0X3FB74491, 0XD062812F} } },
/**/                 {{{0X3FCB7FFE, 0X669932A5} },
/**/                  {{0X3FCB1694, 0XCFF6DFE0} },
/**/                  {{0X3FEE968F, 0X1921D387} },
/**/                  {{0XBFC92078, 0XE075D95A} },
/**/                  {{0XBFD00D60, 0X526793C4} },
/**/                  {{0X3FC5E610, 0X73842A52} },
/**/                  {{0X3FB66F49, 0XC5331D5A} } },
/**/                 {{{0X3FCBFFF9, 0XB44759F3} },
/**/                  {{0X3FCB90D1, 0X5073A2A0} },
/**/                  {{0X3FEE89E7, 0X56598313} },
/**/                  {{0XBFC98041, 0XCFB9203D} },
/**/                  {{0XBFCFC2BC, 0XBED91B37} },
/**/                  {{0X3FC61D19, 0X6D4FC2FC} },
/**/                  {{0X3FB5998C, 0X9411537E} } },
/**/                 {{{0X3FCC8007, 0X5568F3EC} },
/**/                  {{0X3FCC0AEC, 0X4A31DBE0} },
/**/                  {{0X3FEE7D0E, 0X18F270A8} },
/**/                  {{0XBFC9DF0E, 0XF522B132} },
/**/                  {{0XBFCF69D4, 0X2179C242} },
/**/                  {{0X3FC65213, 0X36646FCD} },
/**/                  {{0X3FB4C37C, 0XDC699095} } },
/**/                 {{{0X3FCCFFF8, 0X601A799F} },
/**/                  {{0X3FCC84B8, 0X49DB66A0} },
/**/                  {{0X3FEE7008, 0XA0EE780E} },
/**/                  {{0XBFCA3CBB, 0X3A403934} },
/**/                  {{0XBFCF102F, 0XD490BE32} },
/**/                  {{0X3FC684EA, 0X037D4137} },
/**/                  {{0X3FB3ED3C, 0XD9EC855A} } },
/**/                 {{{0X3FCD7FF9, 0X7BBF1497} },
/**/                  {{0X3FCCFE5F, 0X1E008CE0} },
/**/                  {{0X3FEE62D2, 0XF04615C7} },
/**/                  {{0XBFCA9965, 0X15AADE2C} },
/**/                  {{0XBFCEB5B9, 0X0B44B682} },
/**/                  {{0X3FC6B5AF, 0X92EC8D57} },
/**/                  {{0X3FB316EE, 0X60D831AE} } },
/**/                 {{{0X3FCE0008, 0X40209B20} },
/**/                  {{0X3FCD77DD, 0XB145A760} },
/**/                  {{0X3FEE556D, 0XBE1DFDF1} },
/**/                  {{0XBFCAF508, 0X2186AF0F} },
/**/                  {{0XBFCE5A79, 0X9420489D} },
/**/                  {{0X3FC6E462, 0X454FEB2C} },
/**/                  {{0X3FB240B2, 0XD2945A8C} } },
/**/                 {{{0X3FCE8000, 0XC0AE943C} },
/**/                  {{0X3FCDF111, 0X3CA10100} },
/**/                  {{0X3FEE47DD, 0X59E7308B} },
/**/                  {{0XBFCB4F88, 0X9439F69F} },
/**/                  {{0XBFCDFE93, 0X798DE600} },
/**/                  {{0X3FC710F5, 0X8F267389} },
/**/                  {{0X3FB16AAB, 0X1A8A373E} } },
/**/                 {{{0X3FCF0003, 0X6D532803} },
/**/                  {{0X3FCE6A17, 0XCB4E5C80} },
/**/                  {{0X3FEE3A1E, 0XE3D0F6C2} },
/**/                  {{0XBFCBA8FB, 0X6E31F768} },
/**/                  {{0XBFCDA1F7, 0XE6A382E3} },
/**/                  {{0X3FC73B75, 0XB36AC4C0} },
/**/                  {{0X3FB094F7, 0XA3470B0A} } },
/**/                 {{{0X3FCF7FFA, 0X48B8AFC3} },
/**/                  {{0X3FCEE2DB, 0XE1654560} },
/**/                  {{0X3FEE2C35, 0X43F2AB37} },
/**/                  {{0XBFCC014F, 0X598207D6} },
/**/                  {{0XBFCD44BF, 0X1EFE809A} },
/**/                  {{0X3FC763DC, 0X698A561E} },
/**/                  {{0X3FAF7F70, 0XA7CF78A3} } },
/**/                 {{{0X3FD00002, 0XEB334FAE} },
/**/                  {{0X3FCF5B7B, 0X77AB25E0} },
/**/                  {{0X3FEE1E1D, 0X78A5C127} },
/**/                  {{0XBFCC5898, 0XC555D571} },
/**/                  {{0XBFCCE6D9, 0XB706CF86} },
/**/                  {{0X3FC78A35, 0X0823F643} },
/**/                  {{0X3FADD619, 0X0B9118E8} } },
/**/                 {{{0X3FD03FFC, 0XA8AF86FE} },
/**/                  {{0X3FCFD3CB, 0XB53A0C00} },
/**/                  {{0X3FEE0FDC, 0XFDCBAC8B} },
/**/                  {{0XBFCCAEB7, 0X6C3246FF} },
/**/                  {{0XBFCC8870, 0XD6E19AD3} },
/**/                  {{0X3FC7AE73, 0XD2C48E91} },
/**/                  {{0X3FAC2E26, 0X0510FDB0} } },
/**/                 {{{0X3FD07FFC, 0XD38984B7} },
/**/                  {{0X3FD025F7, 0X5732D4A0} },
/**/                  {{0X3FEE0170, 0X49C17AB3} },
/**/                  {{0XBFCD03C2, 0X9AFE5028} },
/**/                  {{0XBFCC2971, 0X9A2C1833} },
/**/                  {{0X3FC7D0A5, 0X69041DCF} },
/**/                  {{0X3FAA87D3, 0XF497C653} } },
/**/                 {{{0X3FD0BFFF, 0X1ED2ADD7} },
/**/                  {{0X3FD061ED, 0XCD7F7420} },
/**/                  {{0X3FEDF2D8, 0XDA96B750} },
/**/                  {{0XBFCD57B2, 0XC777881E} },
/**/                  {{0XBFCBC9EA, 0X8692B503} },
/**/                  {{0X3FC7F0C9, 0X42ABF9E7} },
/**/                  {{0X3FA8E35E, 0X04B42BB4} } },
/**/                 {{{0X3FD10003, 0XA8515CDA} },
/**/                  {{0X3FD09DC9, 0X027416A0} },
/**/                  {{0X3FEDE417, 0X34899950} },
/**/                  {{0XBFCDAA86, 0X7983EDE4} },
/**/                  {{0XBFCB69E3, 0X999706B6} },
/**/                  {{0X3FC80EE1, 0XB0F126DB} },
/**/                  {{0X3FA740FE, 0X17EE9BAB} } },
/**/                 {{{0X3FD14001, 0XF3AF9CC5} },
/**/                  {{0X3FD0D980, 0XB6E1ABA0} },
/**/                  {{0X3FEDD52D, 0XE0412681} },
/**/                  {{0XBFCDFC31, 0X6863B28B} },
/**/                  {{0XBFCB0971, 0XC55B8D5A} },
/**/                  {{0X3FC82AED, 0XA6731AAC} },
/**/                  {{0X3FA5A0EC, 0XC73BD8F0} } },
/**/                 {{{0X3FD18003, 0XB6122509} },
/**/                  {{0X3FD1151D, 0XAA1E67A0} },
/**/                  {{0X3FEDC61B, 0X2E0C1F32} },
/**/                  {{0XBFCE4CBE, 0XB9BA6B7E} },
/**/                  {{0XBFCAA88E, 0X90C2431C} },
/**/                  {{0X3FC844F4, 0X8BCBDA5E} },
/**/                  {{0X3FA40361, 0X50E585FF} } },
/**/                 {{{0X3FD1BFFF, 0XA6A2A153} },
/**/                  {{0X3FD15096, 0XE7A18DC0} },
/**/                  {{0X3FEDB6E1, 0XE1218F3F} },
/**/                  {{0XBFCE9C21, 0X9621D6A2} },
/**/                  {{0XBFCA4750, 0X22627B04} },
/**/                  {{0X3FC85CF5, 0XFF8B908E} },
/**/                  {{0X3FA26891, 0X9833C0D6} } },
/**/                 {{{0X3FD1FFFD, 0X2D345AAF} },
/**/                  {{0X3FD18BF3, 0X053BF760} },
/**/                  {{0X3FEDA780, 0XCC3ACB29} },
/**/                  {{0XBFCEEA62, 0X2AA756AE} },
/**/                  {{0XBFC9E5B3, 0X47ED9793} },
/**/                  {{0X3FC872F8, 0X87AB542A} },
/**/                  {{0X3FA0D0B2, 0X158E9E9A} } },
/**/                 {{{0X3FD23FFC, 0XF14CF05A} },
/**/                  {{0X3FD1C732, 0X4D568460} },
/**/                  {{0X3FED97F8, 0X55F32D3D} },
/**/                  {{0XBFCF3780, 0X21D457C8} },
/**/                  {{0XBFC983BE, 0XF065B845} },
/**/                  {{0X3FC886FF, 0XFBA70CD8} },
/**/                  {{0X3F9E77EB, 0XAEB85CCC} } },
/**/                 {{{0X3FD27FFE, 0X0BAE6FC9} },
/**/                  {{0X3FD20253, 0X9A27C160} },
/**/                  {{0X3FED8849, 0X4619176E} },
/**/                  {{0XBFCF8379, 0X5C0AC9EC} },
/**/                  {{0XBFC9217C, 0X5E645195} },
/**/                  {{0X3FC8990F, 0XF4264515} },
/**/                  {{0X3F9B551C, 0XE6B92E65} } },
/**/                 {{{0X3FD2C001, 0XA297A7DE} },
/**/                  {{0X3FD23D57, 0XACB927C0} },
/**/                  {{0X3FED7873, 0XE4958FB6} },
/**/                  {{0XBFCFCE4E, 0X43572249} },
/**/                  {{0XBFC8BEF1, 0X9F3560F3} },
/**/                  {{0X3FC8A92C, 0XDF7F0E5B} },
/**/                  {{0X3F983958, 0X116F3B19} } },
/**/                 {{{0X3FD2FFFE, 0X7267616A} },
/**/                  {{0X3FD27835, 0XB2F378C0} },
/**/                  {{0X3FED687B, 0X13906586} },
/**/                  {{0XBFD00BF9, 0XAFDA1A0F} },
/**/                  {{0XBFC85C34, 0XC197AD7D} },
/**/                  {{0X3FC8B759, 0X1E99F0A7} },
/**/                  {{0X3F9524FA, 0X6525C365} } },
/**/                 {{{0X3FD33FFE, 0X48153B20} },
/**/                  {{0X3FD2B2F6, 0X6A2FDCC0} },
/**/                  {{0X3FED585C, 0XF827FBE4} },
/**/                  {{0XBFD03039, 0XB45A6918} },
/**/                  {{0XBFC7F93E, 0X5DFC3F72} },
/**/                  {{0X3FC8C39B, 0XC5210022} },
/**/                  {{0X3F92185E, 0X168FB62E} } },
/**/                 {{{0X3FD38003, 0X8122579A} },
/**/                  {{0X3FD2ED9B, 0XAF6EC1E0} },
/**/                  {{0X3FED4819, 0X872F20D3} },
/**/                  {{0XBFD053E8, 0X1F4C1031} },
/**/                  {{0XBFC79612, 0X621FFD79} },
/**/                  {{0X3FC8CDF9, 0XDB9D9DFC} },
/**/                  {{0X3F8E27B4, 0X80C6852F} } },
/**/                 {{{0X3FD3C003, 0X3EF39141} },
/**/                  {{0X3FD3281B, 0X4668C700} },
/**/                  {{0X3FED37B4, 0X18590D1A} },
/**/                  {{0XBFD076FE, 0XA3EF2560} },
/**/                  {{0XBFC732C9, 0X3033287A} },
/**/                  {{0X3FC8D676, 0XCA2E5458} },
/**/                  {{0X3F882F85, 0XD80944B1} } },
/**/                 {{{0X3FD40001, 0X63FA0E31} },
/**/                  {{0X3FD36278, 0X7B565000} },
/**/                  {{0X3FED272C, 0X47A813DA} },
/**/                  {{0XBFD0997F, 0X493B9D88} },
/**/                  {{0XBFC6CF64, 0X3DA9FE3C} },
/**/                  {{0X3FC8DD18, 0XC1CD3331} },
/**/                  {{0X3F8248D1, 0XF70F6E07} } },
/**/                 {{{0X3FD44003, 0X74071092} },
/**/                  {{0X3FD39CB8, 0X0F0A4000} },
/**/                  {{0X3FED1681, 0X3BA47A6B} },
/**/                  {{0XBFD0BB6C, 0XD8788947} },
/**/                  {{0XBFC66BE2, 0X589596A6} },
/**/                  {{0X3FC8E1E5, 0XC9B3EC1E} },
/**/                  {{0X3F78E868, 0XD20FAB86} } },
/**/                 {{{0X3FD48000, 0XC880F200} },
/**/                  {{0X3FD3D6D1, 0XDEFFB460} },
/**/                  {{0X3FED05B5, 0XCADC576C} },
/**/                  {{0XBFD0DCC2, 0XA1D352C2} },
/**/                  {{0XBFC60858, 0X3D7D2574} },
/**/                  {{0X3FC8E4E3, 0X03208BC0} },
/**/                  {{0X3F6AC909, 0X6379E732} } },
/**/                 {{{0X3FD4C000, 0X4D97D2CB} },
/**/                  {{0X3FD410CB, 0XF3A2E220} },
/**/                  {{0X3FECF4C8, 0XBB7ED511} },
/**/                  {{0XBFD0FD84, 0X37766A49} },
/**/                  {{0XBFC5A4C2, 0X5AABC13C} },
/**/                  {{0X3FC8E616, 0XC80DAC4B} },
/**/                  {{0X3F4038AA, 0XB04695C2} } },
/**/                 {{{0X3FD4FFFD, 0X9397539F} },
/**/                  {{0X3FD44AA2, 0X06A7DEC0} },
/**/                  {{0X3FECE3BB, 0XCF479DDE} },
/**/                  {{0XBFD11DAF, 0X4D122984} },
/**/                  {{0XBFC5412E, 0XB1024DF0} },
/**/                  {{0X3FC8E587, 0X1B2C560D} },
/**/                  {{0XBF625DA8, 0X951C088D} } },
/**/                 {{{0X3FD53FFF, 0XF304715F} },
/**/                  {{0X3FD4845A, 0X791F3900} },
/**/                  {{0X3FECD28D, 0XA45E0FD8} },
/**/                  {{0XBFD13D47, 0X8D61F221} },
/**/                  {{0XBFC4DD98, 0XD3E9BB99} },
/**/                  {{0X3FC8E33A, 0X0F181507} },
/**/                  {{0XBF743C33, 0XD08BD25C} } },
/**/                 {{{0X3FD58002, 0XE88EA386} },
/**/                  {{0X3FD4BDF0, 0XF575D6C0} },
/**/                  {{0X3FECC140, 0X02035609} },
/**/                  {{0XBFD15C4A, 0XB808071E} },
/**/                  {{0XBFC47A0E, 0XB2945FCF} },
/**/                  {{0X3FC8DF35, 0XFC056447} },
/**/                  {{0XBF7F2011, 0XB00A45CD} } },
/**/                 {{{0X3FD5BFFD, 0X70F4D590} },
/**/                  {{0X3FD4F75D, 0X284D7AE0} },
/**/                  {{0X3FECAFD5, 0XF2DE98B6} },
/**/                  {{0XBFD17AB4, 0XA2B42F42} },
/**/                  {{0XBFC416A5, 0X1C285A92} },
/**/                  {{0X3FC8D982, 0X511D6C5A} },
/**/                  {{0XBF84ECC1, 0X77008605} } },
/**/                 {{{0X3FD5FFFD, 0XB70D6E53} },
/**/                  {{0X3FD530AB, 0X8E2FF500} },
/**/                  {{0X3FEC9E4C, 0X32D2429D} },
/**/                  {{0XBFD1988C, 0X35190681} },
/**/                  {{0XBFC3B34C, 0XBF748319} },
/**/                  {{0X3FC8D224, 0X98D3A613} },
/**/                  {{0XBF8A33D4, 0XAA295F9F} } },
/**/                 {{{0X3FD63FFC, 0X5C7399E2} },
/**/                  {{0X3FD569D5, 0X4F022E80} },
/**/                  {{0X3FEC8CA5, 0X58DD180F} },
/**/                  {{0XBFD1B5CE, 0X1D701DE4} },
/**/                  {{0XBFC35017, 0XA7806A5A} },
/**/                  {{0X3FC8C924, 0X56C01CF9} },
/**/                  {{0XBF8F64D9, 0X942059E1} } },
/**/                 {{{0X3FD67FFD, 0X9A1AC7D2} },
/**/                  {{0X3FD5A2DD, 0XF50031E0} },
/**/                  {{0X3FEC7AE0, 0XCEFF6DEB} },
/**/                  {{0XBFD1D27C, 0X7C8C245B} },
/**/                  {{0XBFC2ED05, 0XC6AA933F} },
/**/                  {{0X3FC8BE87, 0XDDC5CF1F} },
/**/                  {{0XBF923FB6, 0XD594386F} } },
/**/                 {{{0X3FD6BFFD, 0X6F7B9353} },
/**/                  {{0X3FD5DBC1, 0XB4E066C0} },
/**/                  {{0X3FEC6900, 0X456B591A} },
/**/                  {{0XBFD1EE95, 0XC2D6D0AA} },
/**/                  {{0XBFC28A23, 0XB11086F7} },
/**/                  {{0X3FC8B256, 0XDDE22D5A} },
/**/                  {{0XBF94C19A, 0X489D85A4} } },
/**/                 {{{0X3FD6FFFB, 0XF02A83E4} },
/**/                  {{0X3FD61480, 0X6A237DC0} },
/**/                  {{0X3FEC5704, 0X4CC81773} },
/**/                  {{0XBFD20A1A, 0X4B9029CA} },
/**/                  {{0XBFC22777, 0X89F5FB1C} },
/**/                  {{0X3FC8A498, 0X9B09E911} },
/**/                  {{0XBF9737EC, 0X130D419A} } },
/**/                 {{{0X3FD73FFE, 0X128C213A} },
/**/                  {{0X3FD64D1E, 0X42499480} },
/**/                  {{0X3FEC44EC, 0X129C0D30} },
/**/                  {{0XBFD2250C, 0X83787259} },
/**/                  {{0XBFC1C4FF, 0XD55BE4FC} },
/**/                  {{0X3FC89553, 0X36B2D603} },
/**/                  {{0XBF99A284, 0X2E43DF46} } },
/**/                 {{{0X3FD77FFB, 0XEA0CDC7A} },
/**/                  {{0X3FD68594, 0X05B0E220} },
/**/                  {{0X3FEC32BA, 0X687132C0} },
/**/                  {{0XBFD23F69, 0X7273497E} },
/**/                  {{0XBFC162CE, 0XCD39B037} },
/**/                  {{0X3FC8848F, 0XFA930AAF} },
/**/                  {{0XBF9C013D, 0XA4554412} } },
/**/                 {{{0X3FD7C003, 0XF18EDAB8} },
/**/                  {{0X3FD6BDEE, 0X4127BEE0} },
/**/                  {{0X3FEC206B, 0XC01607BD} },
/**/                  {{0XBFD25937, 0X5FEE2F42} },
/**/                  {{0XBFC100D4, 0X307761E1} },
/**/                  {{0X3FC87252, 0X5DFEC556} },
/**/                  {{0XBF9E53F6, 0X7958F973} } },
/**/                 {{{0X3FD7FFFD, 0X41F35C4C} },
/**/                  {{0X3FD6F616, 0XDA6607A0} },
/**/                  {{0X3FEC0E07, 0XCDDC8437} },
/**/                  {{0XBFD2726C, 0XBFB4DAEA} },
/**/                  {{0XBFC09F3B, 0XE0DB1472} },
/**/                  {{0X3FC85EA9, 0X2A95AA1B} },
/**/                  {{0XBFA04D47, 0XD872CFA2} } },
/**/                 {{{0X3FD84003, 0X26C7C46B} },
/**/                  {{0X3FD72E25, 0X96B8BE00} },
/**/                  {{0X3FEBFB87, 0X4CDEDF38} },
/**/                  {{0XBFD28B14, 0XD09404F3} },
/**/                  {{0XBFC03DE1, 0XE7FB61F2} },
/**/                  {{0X3FC84993, 0XACB33BE9} },
/**/                  {{0XBFA16A76, 0X9B1DE607} } },
/**/                 {{{0X3FD88003, 0XCA90B179} },
/**/                  {{0X3FD7660A, 0XA104A220} },
/**/                  {{0X3FEBE8EF, 0XF236E2F6} },
/**/                  {{0XBFD2A329, 0X19A94DDF} },
/**/                  {{0XBFBFB9CE, 0X0856A081} },
/**/                  {{0X3FC8331F, 0X33F70280} },
/**/                  {{0XBFA2817A, 0XF01308CC} } },
/**/                 {{{0X3FD8C003, 0XE9692FD5} },
/**/                  {{0X3FD79DC9, 0XF0B2CB00} },
/**/                  {{0X3FEBD640, 0XF2966495} },
/**/                  {{0XBFD2BAAB, 0XFD6EC2EA} },
/**/                  {{0XBFBEF892, 0XE08E9C2D} },
/**/                  {{0X3FC81B52, 0X031873E3} },
/**/                  {{0XBFA39249, 0XAC12113D} } },
/**/                 {{{0X3FD8FFFE, 0X35BE5C5F} },
/**/                  {{0X3FD7D55E, 0XBDCCDFC0} },
/**/                  {{0X3FEBC37C, 0X6EABCF77} },
/**/                  {{0XBFD2D19C, 0X2D74F445} },
/**/                  {{0XBFBE382C, 0XE63F2CDB} },
/**/                  {{0X3FC80236, 0X0E6FE2AE} },
/**/                  {{0XBFA49CD9, 0X0E66AB41} } },
/**/                 {{{0X3FD94002, 0XAA8974CD} },
/**/                  {{0X3FD80CD6, 0XB8AFD880} },
/**/                  {{0X3FEBB09E, 0X4468CCBA} },
/**/                  {{0XBFD2E7FF, 0XEC84E686} },
/**/                  {{0XBFBD7876, 0X88C659E8} },
/**/                  {{0X3FC7E7CC, 0XC2F15460} },
/**/                  {{0XBFA5A120, 0XB410D3ED} } },
/**/                 {{{0X3FD98002, 0XE08EFDEA} },
/**/                  {{0X3FD84425, 0X34856920} },
/**/                  {{0X3FEB9DAB, 0X3F290478} },
/**/                  {{0XBFD2FDD2, 0XBB81EDEF} },
/**/                  {{0XBFBCB9A5, 0X31E68398} },
/**/                  {{0X3FC7CC23, 0XC2DBB11B} },
/**/                  {{0XBFA69F19, 0X98467E78} } },
/**/                 {{{0X3FD9C002, 0X75294B6B} },
/**/                  {{0X3FD87B4D, 0X299F6200} },
/**/                  {{0X3FEB8AA2, 0XDE96CF1F} },
/**/                  {{0XBFD31316, 0X8C4D45D2} },
/**/                  {{0XBFBBFBB7, 0XEDCE4DBA} },
/**/                  {{0X3FC7AF41, 0X8907FEC9} },
/**/                  {{0XBFA796BE, 0X07419F55} } },
/**/                 {{{0X3FDA0002, 0XF3E490EC} },
/**/                  {{0X3FD8B24F, 0XC21A4500} },
/**/                  {{0X3FEB7785, 0X3B5EF7DD} },
/**/                  {{0XBFD327CC, 0X8EAE70CD} },
/**/                  {{0XBFBB3EB3, 0XD49E40DA} },
/**/                  {{0X3FC7912D, 0X4D93F7EA} },
/**/                  {{0XBFA88809, 0X9E21606A} } },
/**/                 {{{0X3FDA3FFF, 0X458461B6} },
/**/                  {{0X3FD8E928, 0X7754D2C0} },
/**/                  {{0X3FEB6454, 0X6A0DAF0E} },
/**/                  {{0XBFD33BF3, 0XDC2A9A3F} },
/**/                  {{0XBFBA82B1, 0X4917D003} },
/**/                  {{0X3FC771F1, 0X7C7566CF} },
/**/                  {{0XBFA972F9, 0X3D700DD8} } },
/**/                 {{{0X3FDA8002, 0X87E12AAE} },
/**/                  {{0X3FD91FE0, 0XA5DFD000} },
/**/                  {{0X3FEB510D, 0XA0D82E05} },
/**/                  {{0XBFD34F90, 0XA76AD312} },
/**/                  {{0XBFB9C798, 0XDEEC35AD} },
/**/                  {{0X3FC75190, 0X8A0EF43E} },
/**/                  {{0XBFAA578B, 0X0872EFC8} } },
/**/                 {{{0X3FDAC001, 0X49A86C84} },
/**/                  {{0X3FD9566E, 0X5C4516E0} },
/**/                  {{0X3FEB3DB4, 0XDD03F6B6} },
/**/                  {{0XBFD362A0, 0X291C1F82} },
/**/                  {{0XBFB90D95, 0X03F6DF60} },
/**/                  {{0X3FC73018, 0X25091E92} },
/**/                  {{0XBFAB35BE, 0X577A022B} } },
/**/                 {{{0X3FDAFFFF, 0X2F4CC2E1} },
/**/                  {{0X3FD98CD4, 0X94226540} },
/**/                  {{0X3FEB2A49, 0X9297200A} },
/**/                  {{0XBFD37524, 0X5153FD01} },
/**/                  {{0XBFB854A3, 0XAE3DE27E} },
/**/                  {{0X3FC70D8E, 0X7EB3F331} },
/**/                  {{0XBFAC0D93, 0XB6AD570E} } },
/**/                 {{{0X3FDB4000, 0XC2F3711E} },
/**/                  {{0X3FD9C317, 0X01CDC4C0} },
/**/                  {{0X3FEB16CA, 0XEA63781B} },
/**/                  {{0XBFD3871F, 0X3665B649} },
/**/                  {{0XBFB79CC0, 0X3F70FBC6} },
/**/                  {{0X3FC6E9F9, 0X061DFC2E} },
/**/                  {{0XBFACDF0C, 0XD837F9C3} } },
/**/                 {{{0X3FDB8000, 0XA777E180} },
/**/                  {{0X3FD9F930, 0XF3748F20} },
/**/                  {{0X3FEB033B, 0X0FB0162A} },
/**/                  {{0XBFD39890, 0X25978CAB} },
/**/                  {{0XBFB6E602, 0X5C765AAB} },
/**/                  {{0X3FC6C562, 0X9C16D678} },
/**/                  {{0XBFADAA2C, 0X92A16EBF} } },
/**/                 {{{0X3FDBBFFD, 0X087E14ED} },
/**/                  {{0X3FDA2F20, 0XBF0DDB00} },
/**/                  {{0X3FEAEF9B, 0X1CCE6E94} },
/**/                  {{0XBFD3A977, 0X8B73E3C3} },
/**/                  {{0XBFB63077, 0X09EFD1CC} },
/**/                  {{0X3FC69FD4, 0X58408D3A} },
/**/                  {{0XBFAE6EF6, 0XD2E48013} } },
/**/                 {{{0X3FDC0000, 0XF0086783} },
/**/                  {{0X3FDA64EF, 0X8D448080} },
/**/                  {{0X3FEADBE8, 0X35990B5A} },
/**/                  {{0XBFD3B9D9, 0X27241B86} },
/**/                  {{0XBFB57C06, 0XC20E4001} },
/**/                  {{0X3FC6794F, 0X90E6C8AB} },
/**/                  {{0XBFAF2D70, 0X9A630A27} } },
/**/                 {{{0X3FDC4001, 0X863E58F8} },
/**/                  {{0X3FDA9A94, 0X1C3A1BA0} },
/**/                  {{0X3FEAC826, 0X35ED7DD2} },
/**/                  {{0XBFD3C9B3, 0X0C075B50} },
/**/                  {{0XBFB4C8D7, 0XA429793C} },
/**/                  {{0X3FC651E2, 0X95903C22} },
/**/                  {{0XBFAFE59F, 0XF0F8B649} } },
/**/                 {{{0X3FDC7FFC, 0X6C62C3BF} },
/**/                  {{0X3FDAD00C, 0X580A5840} },
/**/                  {{0X3FEAB456, 0X62D1D808} },
/**/                  {{0XBFD3D905, 0XACBB06EC} },
/**/                  {{0XBFB416F7, 0X421E42DC} },
/**/                  {{0X3FC62996, 0XE5608EFD} },
/**/                  {{0XBFB04BC5, 0XF14B649A} } },
/**/                 {{{0X3FDCC002, 0X34B2A209} },
/**/                  {{0X3FDB0565, 0XF68F3B40} },
/**/                  {{0X3FEAA074, 0X1E3DC946} },
/**/                  {{0XBFD3E7D5, 0XE2DB674E} },
/**/                  {{0XBFB3663E, 0XA4833FFE} },
/**/                  {{0X3FC60069, 0XC4F0392B} },
/**/                  {{0XBFB0A19E, 0X38B10201} } },
/**/                 {{{0X3FDCFFFC, 0XAAC5F9F9} },
/**/                  {{0X3FDB3A8E, 0X59C45CC0} },
/**/                  {{0X3FEA8C86, 0XD2389C24} },
/**/                  {{0XBFD3F61F, 0X8362B2CB} },
/**/                  {{0XBFB2B6F1, 0XC6C746A6} },
/**/                  {{0X3FC5D671, 0X426D2946} },
/**/                  {{0XBFB0F45D, 0X4981CE75} } },
/**/                 {{{0X3FDD4004, 0X0D800C64} },
/**/                  {{0X3FDB6F99, 0X88AF6580} },
/**/                  {{0X3FEA7887, 0X7498CED2} },
/**/                  {{0XBFD403E8, 0XEF8975C0} },
/**/                  {{0XBFB208D4, 0XBEA81E2B} },
/**/                  {{0X3FC5ABA5, 0X283FFA4E} },
/**/                  {{0XBFB14408, 0X11705130} } },
/**/                 {{{0X3FDD7FFE, 0XB0E64500} },
/**/                  {{0X3FDBA472, 0X2324E140} },
/**/                  {{0X3FEA647E, 0X8C5AD680} },
/**/                  {{0XBFD4112D, 0XA03F042D} },
/**/                  {{0XBFB15C33, 0X9580389C} },
/**/                  {{0X3FC5801E, 0X49D9889E} },
/**/                  {{0XBFB190A3, 0XEF96554F} } },
/**/                 {{{0X3FDDBFFE, 0X2DFCF4EB} },
/**/                  {{0X3FDBD926, 0X9F1D27A0} },
/**/                  {{0X3FEA5067, 0X1AC286CA} },
/**/                  {{0XBFD41DF2, 0X590A4DE1} },
/**/                  {{0XBFB0B0E4, 0X8BD1EFA5} },
/**/                  {{0X3FC553D8, 0X702506D0} },
/**/                  {{0XBFB1DA36, 0XADA415A6} } },
/**/                 {{{0X3FDDFFFD, 0X8A34BBC2} },
/**/                  {{0X3FDC0DB2, 0XC4F7A2C0} },
/**/                  {{0X3FEA3C43, 0X2EF70BB3} },
/**/                  {{0XBFD42A37, 0X16EE647C} },
/**/                  {{0XBFB006FA, 0XDB6270BB} },
/**/                  {{0X3FC526DE, 0X86F08DE6} },
/**/                  {{0XBFB220C6, 0X7E5061FB} } },
/**/                 {{{0X3FDE3FFD, 0XD26415C0} },
/**/                  {{0X3FDC4217, 0X58282940} },
/**/                  {{0X3FEA2812, 0XF391DDCB} },
/**/                  {{0XBFD435FD, 0X18EDDF0A} },
/**/                  {{0XBFAEBCF2, 0X88A589AF} },
/**/                  {{0X3FC4F937, 0X4CF96163} },
/**/                  {{0XBFB26459, 0XF6A18481} } },
/**/                 {{{0X3FDE7FFF, 0X37F72672} },
/**/                  {{0X3FDC7654, 0X67AA3DC0} },
/**/                  {{0X3FEA13D6, 0XD6CE86B3} },
/**/                  {{0XBFD44145, 0X74037E91} },
/**/                  {{0XBFAD6EC9, 0X3B2CC445} },
/**/                  {{0X3FC4CAEA, 0X0564F101} },
/**/                  {{0XBFB2A4F8, 0X0C49CD64} } },
/**/                 {{{0X3FDEBFFD, 0XA11BC00F} },
/**/                  {{0X3FDCAA66, 0X85E23660} },
/**/                  {{0X3FE9FF90, 0XA25C2396} },
/**/                  {{0XBFD44C10, 0X8A64724F} },
/**/                  {{0XBFAC2399, 0X2F871E82} },
/**/                  {{0X3FC49C01, 0X0AFBFB85} },
/**/                  {{0XBFB2E2A8, 0X0F0FF3FE} } },
/**/                 {{{0X3FDEFFFF, 0X3313756D} },
/**/                  {{0X3FDCDE52, 0X9D30CC20} },
/**/                  {{0X3FE9EB3E, 0XDFF9491F} },
/**/                  {{0XBFD45660, 0X7E6ABAAE} },
/**/                  {{0XBFAADB4C, 0X3E8AA98D} },
/**/                  {{0X3FC46C7F, 0X25D8FF7D} },
/**/                  {{0XBFB31D71, 0XA71D448D} } },
/**/                 {{{0X3FDF4001, 0X914B856E} },
/**/                  {{0X3FDD1216, 0XAAC1BB20} },
/**/                  {{0X3FE9D6E2, 0XC9BC4315} },
/**/                  {{0XBFD46036, 0X004E7E91} },
/**/                  {{0XBFA995F7, 0XFB901F89} },
/**/                  {{0X3FC43C6D, 0X3F5BE04A} },
/**/                  {{0XBFB3555C, 0XCE8ABF92} } },
/**/                 {{{0X3FDF8003, 0XCD144428} },
/**/                  {{0X3FDD45B1, 0XD93E9640} },
/**/                  {{0X3FE9C27D, 0X256FDFEB} },
/**/                  {{0XBFD46992, 0X09F7C145} },
/**/                  {{0XBFA853A9, 0XED521174} },
/**/                  {{0X3FC40BD3, 0X2B27751F} },
/**/                  {{0XBFB38A71, 0XCFA5C5F2} } },
/**/                 {{{0X3FDFC002, 0X00545BD9} },
/**/                  {{0X3FDD7920, 0XF536D960} },
/**/                  {{0X3FE9AE0F, 0XAAE99EA5} },
/**/                  {{0XBFD47275, 0X38DD66F4} },
/**/                  {{0XBFA7147D, 0XB5484F74} },
/**/                  {{0X3FC3DABA, 0XF8EFC373} },
/**/                  {{0XBFB3BCB9, 0X3EA6B864} } },
/**/                 {{{0X3FDFFFFB, 0XDA6F2AA8} },
/**/                  {{0X3FDDAC63, 0XB420FAA0} },
/**/                  {{0X3FE9999A, 0XED4D0CAB} },
/**/                  {{0XBFD47AE0, 0XBFCC6072} },
/**/                  {{0XBFA5D87C, 0X25BF7A4A} },
/**/                  {{0X3FC3A92B, 0XF5999EE5} },
/**/                  {{0XBFB3EC3B, 0XF7F09D08} } },
/**/                 {{{0X3FE01FFF, 0XA65118C8} },
/**/                  {{0X3FDDDF85, 0X2BF70C00} },
/**/                  {{0X3FE9851A, 0XECD72AE5} },
/**/                  {{0XBFD482D7, 0X8F5794C5} },
/**/                  {{0XBFA49F68, 0X2E4A020B} },
/**/                  {{0X3FC37722, 0X25A156DA} },
/**/                  {{0XBFB41903, 0X19F58064} } },
/**/                 {{{0X3FE04001, 0X9C0B0556} },
/**/                  {{0X3FDE127D, 0XFA2BA200} },
/**/                  {{0X3FE97093, 0X08C17A55} },
/**/                  {{0XBFD48A59, 0X957A7EFD} },
/**/                  {{0XBFA36976, 0X2648F2BB} },
/**/                  {{0X3FC344AB, 0X592569B1} },
/**/                  {{0XBFB44318, 0X03752DDB} } },
/**/                 {{{0X3FE05FFF, 0XC24501DB} },
/**/                  {{0X3FDE4547, 0XA495BCC0} },
/**/                  {{0X3FE95C06, 0X4F225B79} },
/**/                  {{0XBFD49167, 0X2163F5B8} },
/**/                  {{0XBFA236D3, 0X4B79B89F} },
/**/                  {{0X3FC311D4, 0XB530B7BE} },
/**/                  {{0XBFB46A84, 0X4D931476} } },
/**/                 {{{0X3FE07FFE, 0X865125FC} },
/**/                  {{0X3FDE77E9, 0X2A5FAD60} },
/**/                  {{0X3FE94772, 0X5C13B0EA} },
/**/                  {{0XBFD49802, 0X6F33ABCA} },
/**/                  {{0XBFA1075A, 0XDE947C6B} },
/**/                  {{0X3FC2DE9D, 0XD8D5E01B} },
/**/                  {{0XBFB48F51, 0XCA17CA60} } },
/**/                 {{{0X3FE0A002, 0X107EAC25} },
/**/                  {{0X3FDEAA69, 0X08243180} },
/**/                  {{0X3FE932D4, 0XF339824B} },
/**/                  {{0XBFD49E2D, 0X7145F475} },
/**/                  {{0XBF9FB5D8, 0X00571424} },
/**/                  {{0X3FC2AB06, 0X85D1CF84} },
/**/                  {{0XBFB4B18A, 0X7DBBBABE} } },
/**/                 {{{0X3FE0BFFF, 0X7376E5D4} },
/**/                  {{0X3FDEDCB5, 0XF79FF560} },
/**/                  {{0X3FE91E35, 0X8EE1B492} },
/**/                  {{0XBFD4A3E7, 0X49498453} },
/**/                  {{0XBF9D63E4, 0XBE685C6F} },
/**/                  {{0X3FC27726, 0XC4B1F032} },
/**/                  {{0XBFB4D138, 0X9E6ECC3A} } },
/**/                 {{{0X3FE0DFFE, 0X1715EE2E} },
/**/                  {{0X3FDF0EDB, 0X9BE1BB80} },
/**/                  {{0X3FE9098F, 0XD993BD60} },
/**/                  {{0XBFD4A932, 0X9B84E907} },
/**/                  {{0XBF9B185A, 0XE07DBA5E} },
/**/                  {{0X3FC242F8, 0XF2D7A804} },
/**/                  {{0XBFB4EE66, 0X8DDAA340} } },
/**/                 {{{0X3FE10001, 0X7F3D776C} },
/**/                  {{0X3FDF40DF, 0X6119E100} },
/**/                  {{0X3FE8F4E1, 0XFB44BCFB} },
/**/                  {{0XBFD4AE11, 0X16E3467E} },
/**/                  {{0XBF98D304, 0XCF368422} },
/**/                  {{0X3FC20E7D, 0X736708AE} },
/**/                  {{0XBFB5091E, 0XD7B3658D} } },
/**/                 {{{0X3FE11FFE, 0XFD8C7B65} },
/**/                  {{0X3FDF72B0, 0X8FD21560} },
/**/                  {{0X3FE8E033, 0X4770FB0A} },
/**/                  {{0XBFD4B282, 0X5C0F6783} },
/**/                  {{0XBF9694AC, 0X7FFE0364} },
/**/                  {{0X3FC1D9CB, 0XE529BF4C} },
/**/                  {{0XBFB5216C, 0X2C73E5F0} } },
/**/                 {{{0X3FE14000, 0XAFA3EE71} },
/**/                  {{0X3FDFA45E, 0XE3324D60} },
/**/                  {{0X3FE8CB7D, 0X9FF684DF} },
/**/                  {{0XBFD4B689, 0X17ADD34D} },
/**/                  {{0XBF945CA3, 0X67276E70} },
/**/                  {{0X3FC1A4D9, 0XA1FBF3B1} },
/**/                  {{0XBFB53759, 0X5FBA2374} } },
/**/                 {{{0X3FE15FFF, 0X73336187} },
/**/                  {{0X3FDFD5DF, 0X3DE48D00} },
/**/                  {{0X3FE8B6C6, 0X0CBE3546} },
/**/                  {{0XBFD4BA25, 0X9B291BCB} },
/**/                  {{0XBF922B6F, 0X5FB712CC} },
/**/                  {{0X3FC16FB8, 0X55E28B0B} },
/**/                  {{0XBFB54AF1, 0X633F423C} } },
/**/                 {{{0X3FE17FFF, 0X6C447B82} },
/**/                  {{0X3FE0039C, 0X0208ECC0} },
/**/                  {{0X3FE8A20A, 0X48F15926} },
/**/                  {{0XBFD4BD59, 0XA5808AC3} },
/**/                  {{0XBF9000CD, 0X5EEF6F2A} },
/**/                  {{0X3FC13A66, 0XEBE54AA7} },
/**/                  {{0XBFB55C3F, 0X45420CE4} } },
/**/                 {{{0X3FE19FFF, 0XAE932B61} },
/**/                  {{0X3FE01C33, 0XE0091BC0} },
/**/                  {{0X3FE88D4B, 0X55664E00} },
/**/                  {{0XBFD4C026, 0X579F5ABB} },
/**/                  {{0XBF8BB9A6, 0X8797C32A} },
/**/                  {{0X3FC104EC, 0X95D4F64E} },
/**/                  {{0XBFB56B4E, 0X2BBC325E} } },
/**/                 {{{0X3FE1BFFF, 0XBA12AE50} },
/**/                  {{0X3FE034B6, 0XD3ABA020} },
/**/                  {{0X3FE87889, 0XEBDCCF04} },
/**/                  {{0XBFD4C28C, 0XE6D463C1} },
/**/                  {{0XBF877F1C, 0XB36211FC} },
/**/                  {{0X3FC0CF4F, 0XB90B11E7} },
/**/                  {{0XBFB57829, 0X52DCBE1A} } },
/**/                 {{{0X3FE1E001, 0X4B459E41} },
/**/                  {{0X3FE04D26, 0X2DC05800} },
/**/                  {{0X3FE863C5, 0X51625B6A} },
/**/                  {{0XBFD4C48E, 0XAFFDD399} },
/**/                  {{0XBF8351CB, 0X603059CA} },
/**/                  {{0X3FC09992, 0XDE65D0D9} },
/**/                  {{0XBFB582DC, 0X087BB367} } },
/**/                 {{{0X3FE20000, 0X32306F33} },
/**/                  {{0X3FE0657E, 0XBAFB6CE0} },
/**/                  {{0X3FE84F00, 0XA1E2EEC3} },
/**/                  {{0XBFD4C62C, 0XB79EC8C6} },
/**/                  {{0XBF7E6488, 0XD95DE8D1} },
/**/                  {{0X3FC063C2, 0X661DF241} },
/**/                  {{0XBFB58B71, 0XAAA63BAD} } },
/**/                 {{{0X3FE22000, 0XD30A486C} },
/**/                  {{0X3FE07DC3, 0XD2165080} },
/**/                  {{0X3FE83A39, 0X66B3E5BF} },
/**/                  {{0XBFD4C768, 0X7DE04DEE} },
/**/                  {{0XBF763FF7, 0X800F052F} },
/**/                  {{0X3FC02DDC, 0X28F35EDD} },
/**/                  {{0XBFB591F5, 0XA351CF91} } },
/**/                 {{{0X3FE23FFE, 0X215E03FC} },
/**/                  {{0X3FE095F1, 0X9F380A00} },
/**/                  {{0X3FE82573, 0X48BE5F3F} },
/**/                  {{0XBFD4C843, 0X1B793F77} },
/**/                  {{0XBF6C6E63, 0X625993B8} },
/**/                  {{0X3FBFEFDB, 0X8C5E4B3B} },
/**/                  {{0XBFB59673, 0X66FE9CA7} } },
/**/                 {{{0X3FE26000, 0X6833D65D} },
/**/                  {{0X3FE0AE0E, 0X6496A8C0} },
/**/                  {{0X3FE810A9, 0X45B44AA3} },
/**/                  {{0XBFD4C8BE, 0X055B407A} },
/**/                  {{0XBF5920A7, 0XAE83F0A4} },
/**/                  {{0X3FBF83DC, 0X860A6A5E} },
/**/                  {{0XBFB598F6, 0X70D98EE7} } },
/**/                 {{{0X3FE28000, 0XE82D4D50} },
/**/                  {{0X3FE0C615, 0X095F5300} },
/**/                  {{0X3FE7FBE0, 0X1E9337B7} },
/**/                  {{0XBFD4C8DA, 0X573C6F6A} },
/**/                  {{0X3F38B6C7, 0XC50F565D} },
/**/                  {{0X3FBF17DB, 0XC9C4B6CA} },
/**/                  {{0XBFB5998A, 0X45D6DAE0} } },
/**/                 {{{0X3FE29FFF, 0X203B6A0B} },
/**/                  {{0X3FE0DE05, 0X30852720} },
/**/                  {{0X3FE7E718, 0X8520538D} },
/**/                  {{0XBFD4C899, 0X668C6963} },
/**/                  {{0X3F6286EC, 0XBECA8AB0} },
/**/                  {{0X3FBEABE4, 0X9B6AC5BD} },
/**/                  {{0XBFB5983A, 0X575A9684} } },
/**/                 {{{0X3FE2C001, 0XE91A9D93} },
/**/                  {{0X3FE0F5E3, 0XF7817A20} },
/**/                  {{0X3FE7D24E, 0X63A45D97} },
/**/                  {{0XBFD4C7FC, 0X5F83C46D} },
/**/                  {{0X3F70E199, 0X5D9C800A} },
/**/                  {{0X3FBE3FE9, 0X3721A8E0} },
/**/                  {{0XBFB59512, 0X377DA840} } },
/**/                 {{{0X3FE2DFFF, 0XC6FB4948} },
/**/                  {{0X3FE10DAA, 0X4CE36040} },
/**/                  {{0X3FE7BD88, 0X3E39011F} },
/**/                  {{0XBFD4C704, 0XB5EAE11F} },
/**/                  {{0X3F786398, 0X192C622B} },
/**/                  {{0X3FBDD412, 0XB62BA357} },
/**/                  {{0XBFB5901D, 0X5F0E020E} } },
/**/                 {{{0X3FE2FFFF, 0X39CB4EED} },
/**/                  {{0X3FE1255D, 0X0970AD60} },
/**/                  {{0X3FE7A8C2, 0X365B7A9B} },
/**/                  {{0XBFD4C5B3, 0X8925F532} },
/**/                  {{0X3F7FCB03, 0X785E3070} },
/**/                  {{0X3FBD6854, 0X0EEDF3B3} },
/**/                  {{0XBFB58967, 0X479C252A} } },
/**/                 {{{0X3FE31FFE, 0X002E31CB} },
/**/                  {{0X3FE13CFA, 0X81FD3780} },
/**/                  {{0X3FE793FE, 0X1BBE9667} },
/**/                  {{0XBFD4C40A, 0X3046F4C7} },
/**/                  {{0X3F838BAE, 0X8F5E6BF1} },
/**/                  {{0X3FBCFCBD, 0X83775C98} },
/**/                  {{0XBFB580FB, 0X62E887AB} } },
/**/                 {{{0X3FE34000, 0XEDC7BFFD} },
/**/                  {{0X3FE15486, 0X44D05200} },
/**/                  {{0X3FE77F39, 0X244A1DA5} },
/**/                  {{0XBFD4C209, 0X9FB764C1} },
/**/                  {{0X3F8724E2, 0X851B0BE5} },
/**/                  {{0X3FBC9147, 0X507C76E0} },
/**/                  {{0XBFB576E5, 0X19C7F0AB} } },
/**/                 {{{0X3FE36001, 0XCE042830} },
/**/                  {{0X3FE16BFB, 0XC1656AE0} },
/**/                  {{0X3FE76A77, 0XAD3B2B77} },
/**/                  {{0XBFD4BFB3, 0X74AAC296} },
/**/                  {{0X3F8AB070, 0X05B229C2} },
/**/                  {{0X3FBC260E, 0X87DCA54B} },
/**/                  {{0XBFB56B2F, 0XC90DF763} } },
/**/                 {{{0X3FE37FFE, 0X89B8FC54} },
/**/                  {{0X3FE18359, 0X77D0BA80} },
/**/                  {{0X3FE755BB, 0X660CAA3D} },
/**/                  {{0XBFD4BD09, 0X308BB975} },
/**/                  {{0X3F8E2E26, 0XFE0A1240} },
/**/                  {{0X3FBBBB22, 0X18790F26} },
/**/                  {{0XBFB55DE6, 0XC094F3DA} } },
/**/                 {{{0X3FE3A001, 0X9B4DA842} },
/**/                  {{0X3FE19AA7, 0X100CD140} },
/**/                  {{0X3FE740FD, 0XD801F889} },
/**/                  {{0XBFD4BA0B, 0X2C32C656} },
/**/                  {{0X3F90CF99, 0X8ECA44A2} },
/**/                  {{0X3FBB5066, 0XC9863443} },
/**/                  {{0XBFB54F15, 0X406672B5} } },
/**/                 {{{0X3FE3C000, 0XCE6B63E8} },
/**/                  {{0X3FE1B1DD, 0X1D0B0AE0} },
/**/                  {{0X3FE72C45, 0XF28670E6} },
/**/                  {{0XBFD4B6BB, 0X92422E2E} },
/**/                  {{0X3F928141, 0XA0D32146} },
/**/                  {{0X3FBAE606, 0X37452321} },
/**/                  {{0XBFB53EC6, 0X77D91F56} } },
/**/                 {{{0X3FE3DFFF, 0X114A2607} },
/**/                  {{0X3FE1C8FD, 0XC6FF6F20} },
/**/                  {{0X3FE71792, 0X206847A7} },
/**/                  {{0XBFD4B31B, 0X669BD306} },
/**/                  {{0X3F942C3A, 0X04FFD28A} },
/**/                  {{0X3FBA7BFD, 0XE7FC0825} },
/**/                  {{0XBFB52D05, 0X82F471BA} } },
/**/                 {{{0X3FE3FFFF, 0XC1DA9B7D} },
/**/                  {{0X3FE1E00B, 0X7F2E8840} },
/**/                  {{0X3FE702E0, 0X84371133} },
/**/                  {{0XBFD4AF2B, 0X8012FBE4} },
/**/                  {{0X3F95D0B4, 0XBFC47F4B} },
/**/                  {{0X3FBA1249, 0XD80AB6C5} },
/**/                  {{0XBFB519DD, 0X69A4108D} } },
/**/                 {{{0X3FE41FFE, 0XE11D9C33} },
/**/                  {{0X3FE1F703, 0X67C3EC20} },
/**/                  {{0X3FE6EE34, 0X026A76A0} },
/**/                  {{0XBFD4AAED, 0X96514B12} },
/**/                  {{0X3F976E83, 0X07BA2905} },
/**/                  {{0X3FB9A8FE, 0X261A1221} },
/**/                  {{0XBFB50559, 0X1D552BA0} } },
/**/                 {{{0X3FE43FFF, 0XFA174676} },
/**/                  {{0X3FE20DE8, 0X0FAFF860} },
/**/                  {{0X3FE6D98A, 0X9EA6D162} },
/**/                  {{0XBFD4A662, 0X6B927B3B} },
/**/                  {{0X3F9905D8, 0XF84ADBB0} },
/**/                  {{0X3FB94015, 0XDD484DB5} },
/**/                  {{0XBFB4EF83, 0X783EEF44} } },
/**/                 {{{0X3FE45FFF, 0X0D457FA4} },
/**/                  {{0X3FE224B6, 0X9F675300} },
/**/                  {{0X3FE6C4E7, 0X3A093351} },
/**/                  {{0XBFD4A18B, 0XCBF2BFF8} },
/**/                  {{0X3F9A968A, 0X84BB8C16} },
/**/                  {{0X3FB8D7A4, 0X93FBB975} },
/**/                  {{0XBFB4D867, 0X3B37E4FB} } },
/**/                 {{{0X3FE47FFE, 0X8F910E57} },
/**/                  {{0X3FE23B70, 0XDD92B840} },
/**/                  {{0X3FE6B048, 0X89B04359} },
/**/                  {{0XBFD49C6A, 0X974B07FF} },
/**/                  {{0X3F9C20BE, 0X25F20251} },
/**/                  {{0X3FB86FA8, 0X82E9673D} },
/**/                  {{0XBFB4C00F, 0X0D12F550} } },
/**/                 {{{0X3FE4A001, 0X7323FC6B} },
/**/                  {{0X3FE25218, 0XE34E3420} },
/**/                  {{0X3FE69BAC, 0XF277FE27} },
/**/                  {{0XBFD496FF, 0X7F856ABA} },
/**/                  {{0X3F9DA49E, 0X9928150C} },
/**/                  {{0X3FB8081E, 0X3EB66A26} },
/**/                  {{0XBFB4A685, 0X78AB06C5} } },
/**/                 {{{0X3FE4C000, 0XB1BF0500} },
/**/                  {{0X3FE268A9, 0XBD8B2C80} },
/**/                  {{0X3FE68719, 0X42ABBD42} },
/**/                  {{0XBFD4914C, 0XEC74E64A} },
/**/                  {{0X3F9F21DE, 0XD0C3EEEC} },
/**/                  {{0X3FB7A122, 0X5B30AA05} },
/**/                  {{0XBFB48BD4, 0XEC53EF43} } },
/**/                 {{{0X3FE4E001, 0X1D07207B} },
/**/                  {{0X3FE27F26, 0XDA64F7A0} },
/**/                  {{0X3FE6728A, 0XA7CFBEB2} },
/**/                  {{0XBFD48B53, 0X3FCBB247} },
/**/                  {{0X3FA04C60, 0XA7354A41} },
/**/                  {{0X3FB73AAA, 0XEFF6F27A} },
/**/                  {{0XBFB47007, 0XB81A6BB2} } },
/**/                 {{{0X3FE4FFFE, 0X5F36EB46} },
/**/                  {{0X3FE2958D, 0X35DDD180} },
/**/                  {{0X3FE65E04, 0X307B6AF3} },
/**/                  {{0XBFD48514, 0X828BB6E6} },
/**/                  {{0X3FA1048E, 0X48993ED9} },
/**/                  {{0X3FB6D4CB, 0X468D7C59} },
/**/                  {{0XBFB45328, 0X0D484989} } },
/**/                 {{{0X3FE52001, 0X2AFDF759} },
/**/                  {{0X3FE2ABE2, 0XEB1C3280} },
/**/                  {{0X3FE64980, 0X8DC5DAAD} },
/**/                  {{0XBFD47E90, 0X2C11E3B7} },
/**/                  {{0X3FA1B9AE, 0X88E1B343} },
/**/                  {{0X3FB66F6C, 0XFF4501BF} },
/**/                  {{0XBFB4353F, 0XFCD6B8DE} } },
/**/                 {{{0X3FE54001, 0XDFDB2423} },
/**/                  {{0X3FE2C222, 0XAB0402C0} },
/**/                  {{0X3FE63504, 0XE7E657FB} },
/**/                  {{0XBFD477C8, 0XEEE53FA9} },
/**/                  {{0X3FA26B9A, 0X696CD845} },
/**/                  {{0X3FB60AAD, 0X6A3AA6EF} },
/**/                  {{0XBFB41659, 0X7704E1F4} } },
/**/                 {{{0X3FE55FFE, 0X72D2A74F} },
/**/                  {{0X3FE2D84B, 0X16BE7240} },
/**/                  {{0X3FE62092, 0XCE54AEDE} },
/**/                  {{0XBFD470C0, 0X7B764156} },
/**/                  {{0X3FA31A4C, 0X4D9ABEE7} },
/**/                  {{0X3FB5A697, 0XA899A63D} },
/**/                  {{0XBFB3F67E, 0X49FA7FB1} } },
/**/                 {{{0X3FE58000, 0XEE716C33} },
/**/                  {{0X3FE2EE63, 0X284F3FE0} },
/**/                  {{0X3FE60C24, 0X181C5720} },
/**/                  {{0XBFD46975, 0XC383B0C1} },
/**/                  {{0X3FA3C5FF, 0XC40A1A5A} },
/**/                  {{0X3FB54311, 0X0B7B3B72} },
/**/                  {{0XBFB3D5B8, 0X21700401} } },
/**/                 {{{0X3FE59FFF, 0X9825CD2A} },
/**/                  {{0X3FE30464, 0X2DEFCF40} },
/**/                  {{0X3FE5F7BF, 0X3C14A317} },
/**/                  {{0XBFD461EC, 0X227A4CDE} },
/**/                  {{0X3FA46E85, 0X6DA8D837} },
/**/                  {{0X3FB4E03C, 0X6162F4C8} },
/**/                  {{0XBFB3B410, 0X857F5976} } },
/**/                 {{{0X3FE5BFFD, 0XFE2A42CD} },
/**/                  {{0X3FE31A50, 0XA5110DC0} },
/**/                  {{0X3FE5E362, 0X33CF1268} },
/**/                  {{0XBFD45A23, 0XF68B7DBC} },
/**/                  {{0X3FA513F5, 0XDE40F0E9} },
/**/                  {{0X3FB47E12, 0XDE05901E} },
/**/                  {{0XBFB39190, 0XDA5CABB5} } },
/**/                 {{{0X3FE5E000, 0X57330799} },
/**/                  {{0X3FE3302B, 0X75253480} },
/**/                  {{0X3FE5CF0A, 0X901DA45A} },
/**/                  {{0XBFD4521D, 0X552754CF} },
/**/                  {{0X3FA5B66B, 0XBBF000BB} },
/**/                  {{0X3FB41C8B, 0XD2BAF7B2} },
/**/                  {{0XBFB36E42, 0X5F53241A} } },
/**/                 {{{0X3FE60001, 0X4D6055DA} },
/**/                  {{0X3FE345F0, 0XFF2EDA60} },
/**/                  {{0X3FE5BABB, 0XF2EA5900} },
/**/                  {{0XBFD449DA, 0XB2008754} },
/**/                  {{0X3FA655D1, 0X18F56FBB} },
/**/                  {{0X3FB3BBBB, 0X89A0C1B2} },
/**/                  {{0XBFB34A2E, 0X2E8D60FC} } },
/**/                 {{{0X3FE62001, 0X2C3809CB} },
/**/                  {{0X3FE35BA1, 0X812D5040} },
/**/                  {{0X3FE5A676, 0X671E49E9} },
/**/                  {{0XBFD4415D, 0X230E6216} },
/**/                  {{0X3FA6F22D, 0X6B05C7F7} },
/**/                  {{0X3FB35BA4, 0XCFE6B72B} },
/**/                  {{0XBFB3255D, 0X3C3BFA3B} } },
/**/                 {{{0X3FE64000, 0X87B47ECC} },
/**/                  {{0X3FE3713D, 0X69715580} },
/**/                  {{0X3FE59239, 0XC8FB0E69} },
/**/                  {{0XBFD438A5, 0XA5BD1F6E} },
/**/                  {{0X3FA78B89, 0X7F9B13CF} },
/**/                  {{0X3FB2FC49, 0X74F57C8F} },
/**/                  {{0XBFB2FFD8, 0X566CAACA} } },
/**/                 {{{0X3FE66000, 0XA746397F} },
/**/                  {{0X3FE386C5, 0X9D968940} },
/**/                  {{0X3FE57E05, 0X83073C58} },
/**/                  {{0XBFD42FB4, 0XFE3D0083} },
/**/                  {{0X3FA821F1, 0X4B9E1EEB} },
/**/                  {{0X3FB29DA9, 0X1952EE82} },
/**/                  {{0XBFB2D9A8, 0X245866A8} } },
/**/                 {{{0X3FE68000, 0XE4E3094B} },
/**/                  {{0X3FE39C39, 0XB5FE3900} },
/**/                  {{0X3FE569DA, 0X36DD131E} },
/**/                  {{0XBFD4268C, 0X74778FE0} },
/**/                  {{0X3FA8B567, 0X9AB0310F} },
/**/                  {{0X3FB23FC8, 0XF2E43205} },
/**/                  {{0XBFB2B2D5, 0X26483573} } },
/**/                 {{{0X3FE6A001, 0XE2E37787} },
/**/                  {{0X3FE3B19A, 0X27D52620} },
/**/                  {{0X3FE555B7, 0XB5D865CD} },
/**/                  {{0XBFD41D2C, 0XF1600CD3} },
/**/                  {{0X3FA945F5, 0X4B79E859} },
/**/                  {{0X3FB1E2AA, 0X46A0B02D} },
/**/                  {{0XBFB28B67, 0XB508A35B} } },
/**/                 {{{0X3FE6BFFE, 0X0DF4BBFB} },
/**/                  {{0X3FE3C6E3, 0X46F2B6E0} },
/**/                  {{0X3FE541A1, 0XB658AFBE} },
/**/                  {{0XBFD41399, 0X388DA137} },
/**/                  {{0X3FA9D387, 0XE5B3C2BA} },
/**/                  {{0X3FB18660, 0X173397F9} },
/**/                  {{0XBFB26368, 0X01DB4945} } },
/**/                 {{{0X3FE6DFFF, 0XEA406CEA} },
/**/                  {{0X3FE3DC1C, 0X1BB3D400} },
/**/                  {{0X3FE52D91, 0XD33FFE8E} },
/**/                  {{0XBFD409CF, 0X36BCFFE9} },
/**/                  {{0X3FAA5E54, 0X174405AF} },
/**/                  {{0X3FB12ACE, 0XDC041806} },
/**/                  {{0XBFB23ADE, 0X160D6557} } },
/**/                 {{{0X3FE70000, 0XED01EA65} },
/**/                  {{0X3FE3F140, 0X54E51400} },
/**/                  {{0X3FE5198C, 0X5C8B9119} },
/**/                  {{0XBFD3FFD1, 0XF2EA4FF7} },
/**/                  {{0X3FAAE643, 0X308C81CD} },
/**/                  {{0X3FB0D00C, 0X1960AAF7} },
/**/                  {{0XBFB211D1, 0XD2F50D25} } },
/**/                 {{{0X3FE72002, 0X00D515EB} },
/**/                  {{0X3FE40650, 0X983BB3E0} },
/**/                  {{0X3FE50590, 0XF2175C71} },
/**/                  {{0XBFD3F5A2, 0X361BB15C} },
/**/                  {{0X3FAB6B5F, 0X9B536AFC} },
/**/                  {{0X3FB07617, 0XA731624D} },
/**/                  {{0XBFB1E84A, 0XF1A8C054} } },
/**/                 {{{0X3FE74001, 0X1323DE6D} },
/**/                  {{0X3FE41B4B, 0X9483E720} },
/**/                  {{0X3FE4F1A1, 0X1027BA01} },
/**/                  {{0XBFD3EB41, 0XBB978C8F} },
/**/                  {{0X3FABEDA7, 0X7765626A} },
/**/                  {{0X3FB01CF9, 0X97F58C8A} },
/**/                  {{0XBFB1BE51, 0X03074348} } },
/**/                 {{{0X3FE75FFF, 0X25CAB4CA} },
/**/                  {{0X3FE43032, 0X0001D5C0} },
/**/                  {{0X3FE4DDBC, 0X4573FB6C} },
/**/                  {{0XBFD3E0B1, 0X41F21D2A} },
/**/                  {{0X3FAC6D25, 0XD1BDA00F} },
/**/                  {{0X3FAF8962, 0X5935EE68} },
/**/                  {{0XBFB193EB, 0X6F8E0689} } },
/**/                 {{{0X3FE77FFE, 0X90921F76} },
/**/                  {{0X3FE44505, 0X6CC6AF00} },
/**/                  {{0X3FE4C9E1, 0X4CFFBDAE} },
/**/                  {{0XBFD3D5F1, 0X0B247EC4} },
/**/                  {{0X3FACE9EA, 0X943F4516} },
/**/                  {{0X3FAEDA73, 0XF24A8AF1} },
/**/                  {{0XBFB16921, 0X776AAC42} } },
/**/                 {{{0X3FE79FFE, 0X47B2F83B} },
/**/                  {{0X3FE459C5, 0X35C19F20} },
/**/                  {{0X3FE4B610, 0XFC8F20BD} },
/**/                  {{0XBFD3CB02, 0X73DF2A0D} },
/**/                  {{0X3FAD63F8, 0X23C5D6DE} },
/**/                  {{0X3FAE2D31, 0X9C5116AB} },
/**/                  {{0XBFB13DFA, 0X326E2972} } },
/**/                 {{{0X3FE7BFFF, 0X2F1E79A9} },
/**/                  {{0X3FE46E71, 0XF84DF5C0} },
/**/                  {{0X3FE4A24A, 0XF586B1BD} },
/**/                  {{0XBFD3BFE6, 0X2EF81E5B} },
/**/                  {{0X3FADDB58, 0X738896F0} },
/**/                  {{0X3FAD819A, 0X2515DE78} },
/**/                  {{0XBFB1127C, 0X9026FDD0} } },
/**/                 {{{0X3FE7E001, 0X973C8D05} },
/**/                  {{0X3FE4830B, 0XF0FB9580} },
/**/                  {{0X3FE48E8F, 0X3466B08E} },
/**/                  {{0XBFD3B49D, 0X1C53A01A} },
/**/                  {{0X3FAE5013, 0X25103EED} },
/**/                  {{0X3FACD7AF, 0X5290F4AF} },
/**/                  {{0XBFB0E6AF, 0X57EF003B} } },
/**/                 {{{0X3FE7FFFF, 0X69EFC092} },
/**/                  {{0X3FE4978F, 0X431C3800} },
/**/                  {{0X3FE47AE1, 0XA3E1064A} },
/**/                  {{0XBFD3A92A, 0X666C50C4} },
/**/                  {{0X3FAEC219, 0X4098A4BE} },
/**/                  {{0X3FAC2F94, 0X2EEE57E0} },
/**/                  {{0XBFB0BA99, 0X290D5730} } },
/**/                 {{{0X3FE82001, 0XC52B5232} },
/**/                  {{0X3FE4AC01, 0XD2B83340} },
/**/                  {{0X3FE4673C, 0XD31B7CF5} },
/**/                  {{0XBFD39D8B, 0XC67D05F0} },
/**/                  {{0X3FAF3192, 0X2A81B5D5} },
/**/                  {{0X3FAB891B, 0X8AA20E90} },
/**/                  {{0XBFB08E40, 0X7ADCEFD6} } },
/**/                 {{{0X3FE84000, 0XBD4D4E3F} },
/**/                  {{0X3FE4C05E, 0X9B1DBC60} },
/**/                  {{0X3FE453A5, 0XC8D629F7} },
/**/                  {{0XBFD391C5, 0X13E9EF47} },
/**/                  {{0X3FAF9E69, 0X17383D6B} },
/**/                  {{0X3FAAE471, 0X278E21B9} },
/**/                  {{0XBFB061AB, 0X9CF54D10} } },
/**/                 {{{0X3FE86001, 0X8C869CBD} },
/**/                  {{0X3FE4D4A8, 0XFD2285A0} },
/**/                  {{0X3FE44019, 0X79B82471} },
/**/                  {{0XBFD385D5, 0X5C3E2929} },
/**/                  {{0X3FB0045B, 0X7B2C8FF2} },
/**/                  {{0X3FAA417C, 0X39D7CA4F} },
/**/                  {{0XBFB034E0, 0XB767B7D4} } },
/**/                 {{{0X3FE87FFE, 0XB5DB3710} },
/**/                  {{0X3FE4E8DD, 0X8B93BCA0} },
/**/                  {{0X3FE42C9B, 0X66C6E6BF} },
/**/                  {{0XBFD379BF, 0XA32EE2A1} },
/**/                  {{0X3FB03838, 0X6187FE0F} },
/**/                  {{0X3FA9A05A, 0X8B3A0B33} },
/**/                  {{0XBFB007E5, 0XCAEE03A9} } },
/**/                 {{{0X3FE8A000, 0X863C77E3} },
/**/                  {{0X3FE4FD01, 0X8FCD1E80} },
/**/                  {{0X3FE41926, 0XA8A8093F} },
/**/                  {{0XBFD36D81, 0XB5EE344D} },
/**/                  {{0X3FB06ADC, 0X2841F292} },
/**/                  {{0X3FA900E4, 0X2484560B} },
/**/                  {{0XBFAFB581, 0X62792F0A} } },
/**/                 {{{0X3FE8BFFF, 0X0ED982AF} },
/**/                  {{0X3FE51110, 0X16E28AC0} },
/**/                  {{0X3FE405C0, 0X389112EE} },
/**/                  {{0XBFD3611F, 0X89D38DC7} },
/**/                  {{0X3FB09C3D, 0XB450B9F7} },
/**/                  {{0X3FA86342, 0X312D0C4A} },
/**/                  {{0XBFAF5AEE, 0X3A6CA012} } },
/**/                 {{{0X3FE8E000, 0X02C3AEAE} },
/**/                  {{0X3FE5250C, 0XC0AB0A40} },
/**/                  {{0X3FE3F264, 0XC65593C5} },
/**/                  {{0XBFD35497, 0XD82BE900} },
/**/                  {{0X3FB0CC69, 0X68546D39} },
/**/                  {{0X3FA7C759, 0XDB8499FD} },
/**/                  {{0XBFAF001D, 0X36A32337} } },
/**/                 {{{0X3FE90000, 0XECBFA97B} },
/**/                  {{0X3FE538F6, 0X0E8D4EE0} },
/**/                  {{0X3FE3DF15, 0XF4119333} },
/**/                  {{0XBFD347EC, 0X7D2149F4} },
/**/                  {{0X3FB0FB5E, 0XFA921D3C} },
/**/                  {{0X3FA72D38, 0X69693E89} },
/**/                  {{0XBFAEA519, 0X23A0F5F3} } },
/**/                 {{{0X3FE91FFF, 0XD251C01C} },
/**/                  {{0X3FE54CCA, 0XD3F3BD20} },
/**/                  {{0X3FE3CBD5, 0X1554DD15} },
/**/                  {{0XBFD33B1F, 0X2BC94245} },
/**/                  {{0X3FB1291F, 0X2FC4C3F6} },
/**/                  {{0X3FA694E8, 0X1B7A765C} },
/**/                  {{0XBFAE49EC, 0X826E86F6} } },
/**/                 {{{0X3FE94001, 0XD90AF4E6} },
/**/                  {{0X3FE5608E, 0X4D4EC640} },
/**/                  {{0X3FE3B89F, 0X3445EF72} },
/**/                  {{0XBFD32E2E, 0XB7BBD79A} },
/**/                  {{0X3FB155B4, 0XE401D071} },
/**/                  {{0X3FA5FE51, 0X3A256F1C} },
/**/                  {{0XBFADEEA1, 0X890FF662} } },
/**/                 {{{0X3FE96001, 0X04FD6C17} },
/**/                  {{0X3FE5743C, 0XD5673C20} },
/**/                  {{0X3FE3A578, 0X09EBC6E2} },
/**/                  {{0XBFD3211E, 0X6DA5039C} },
/**/                  {{0X3FB1811B, 0X4E62286B} },
/**/                  {{0X3FA56990, 0X71BECE9D} },
/**/                  {{0XBFAD9342, 0X23911641} } },
/**/                 {{{0X3FE98000, 0X2D214B82} },
/**/                  {{0X3FE587D8, 0X3B0D6120} },
/**/                  {{0X3FE3925E, 0X01EAAC3E} },
/**/                  {{0XBFD313EE, 0X08425504} },
/**/                  {{0X3FB1AB5A, 0X02BDB571} },
/**/                  {{0X3FA4D698, 0X9EBD70B8} },
/**/                  {{0XBFAD37D7, 0XF482965A} } },
/**/                 {{{0X3FE99FFD, 0XEB980651} },
/**/                  {{0X3FE59B5F, 0XB16BA7A0} },
/**/                  {{0X3FE37F52, 0X10B1AB7A} },
/**/                  {{0XBFD3069E, 0XF993D676} },
/**/                  {{0X3FB1D472, 0XCDED25A8} },
/**/                  {{0X3FA44570, 0X2D0ABD9A} },
/**/                  {{0XBFACDC6C, 0X56221AA1} } },
/**/                 {{{0X3FE9BFFF, 0XE5504053} },
/**/                  {{0X3FE5AED6, 0XB55DE6A0} },
/**/                  {{0X3FE36C50, 0XFA91C51E} },
/**/                  {{0XBFD2F92F, 0XBE311E56} },
/**/                  {{0X3FB1FC70, 0X5BE3AF05} },
/**/                  {{0X3FA3B5FD, 0XACD5CDC7} },
/**/                  {{0XBFAC8108, 0X5ADBB9B8} } },
/**/                 {{{0X3FE9E001, 0X6E60A234} },
/**/                  {{0X3FE5C23A, 0X79ACD480} },
/**/                  {{0X3FE3595D, 0XA5FAB2EA} },
/**/                  {{0XBFD2EBA3, 0X1DDECEEA} },
/**/                  {{0X3FB22350, 0X35736518} },
/**/                  {{0X3FA32856, 0X22F9FD28} },
/**/                  {{0XBFAC25B4, 0XCE8B2259} } },
/**/                 {{{0X3FE9FFFF, 0XB685741B} },
/**/                  {{0X3FE5D589, 0X5AD40460} },
/**/                  {{0X3FE34679, 0XD832B8D3} },
/**/                  {{0XBFD2DDFB, 0X230EDA41} },
/**/                  {{0X3FB24912, 0XB23C0BA2} },
/**/                  {{0X3FA29C85, 0X4C4E86DA} },
/**/                  {{0XBFABCA7A, 0X37002A55} } },
/**/                 {{{0X3FEA2001, 0X9D59B943} },
/**/                  {{0X3FE5E8C7, 0X8C187EA0} },
/**/                  {{0X3FE333A1, 0X9EDE2183} },
/**/                  {{0XBFD2D035, 0XB0043779} },
/**/                  {{0X3FB26DC3, 0X7AB9110C} },
/**/                  {{0X3FA2126C, 0X959CFC0E} },
/**/                  {{0XBFAB6F60, 0XD556233E} } },
/**/                 {{{0X3FEA3FFF, 0XBE9E153F} },
/**/                  {{0X3FE5FBF0, 0XA9C08AE0} },
/**/                  {{0X3FE320D9, 0X6F7861AA} },
/**/                  {{0XBFD2C256, 0XC2200F18} },
/**/                  {{0X3FB2915D, 0XA6795293} },
/**/                  {{0X3FA18A2B, 0X256A8FDE} },
/**/                  {{0XBFAB1470, 0XA67A4E89} } },
/**/                 {{{0X3FEA5FFE, 0X7A23A1CE} },
/**/                  {{0X3FE60F07, 0X63200600} },
/**/                  {{0X3FE30E1E, 0XD13D395E} },
/**/                  {{0XBFD2B45D, 0X44403932} },
/**/                  {{0X3FB2B3E9, 0XC967F013} },
/**/                  {{0X3FA103AD, 0X35D002B8} },
/**/                  {{0XBFAAB9B1, 0X6496A8F1} } },
/**/                 {{{0X3FEA8001, 0X57F250B8} },
/**/                  {{0X3FE6220D, 0XDD6453A0} },
/**/                  {{0X3FE2FB6F, 0XCFFFCC1E} },
/**/                  {{0XBFD2A648, 0X6F8D8291} },
/**/                  {{0X3FB2D56F, 0X03654CC3} },
/**/                  {{0X3FA07EE3, 0X4BB6E7A6} },
/**/                  {{0XBFAA5F2A, 0X87992F03} } },
/**/                 {{{0X3FEAA000, 0XDD839D49} },
/**/                  {{0X3FE634FF, 0XB412C9A0} },
/**/                  {{0X3FE2E8D0, 0XE2D59E01} },
/**/                  {{0XBFD2981C, 0X5467CFDD} },
/**/                  {{0X3FB2F5E8, 0XFF1FADB5} },
/**/                  {{0X3F9FF7D6, 0XA3BA803C} },
/**/                  {{0XBFAA04E3, 0X46AF8DB7} } },
/**/                 {{{0X3FEAC000, 0X770DF220} },
/**/                  {{0X3FE647DE, 0XFEF70020} },
/**/                  {{0X3FE2D640, 0X220AFF7F} },
/**/                  {{0XBFD289D8, 0X36F9E74F} },
/**/                  {{0X3FB3155E, 0XE509140A} },
/**/                  {{0X3F9EF56B, 0X61AB0B7F} },
/**/                  {{0XBFA9AAE2, 0X98CE391F} } },
/**/                 {{{0X3FEAE001, 0X125BBE48} },
/**/                  {{0X3FE65AAC, 0X57A24D20} },
/**/                  {{0X3FE2C3BD, 0X1BFB3559} },
/**/                  {{0XBFD27B7C, 0X6DDE55DD} },
/**/                  {{0X3FB333D5, 0X15C4C270} },
/**/                  {{0X3F9DF67A, 0X9BAC4ECF} },
/**/                  {{0XBFA9512F, 0X363A972B} } },
/**/                 {{{0X3FEAFFFE, 0X7C321839} },
/**/                  {{0X3FE66D65, 0X569B83C0} },
/**/                  {{0X3FE2B14A, 0X53FBF8D9} },
/**/                  {{0XBFD26D0B, 0X9CFA03CE} },
/**/                  {{0X3FB3514B, 0X2CAA2E0C} },
/**/                  {{0X3F9CFB22, 0X4597BE9A} },
/**/                  {{0XBFA8F7CF, 0X99110022} } },
/**/                 {{{0X3FEB1FFE, 0X75486924} },
/**/                  {{0X3FE6800D, 0X68CEFB40} },
/**/                  {{0X3FE29EE4, 0X8E6AA814} },
/**/                  {{0XBFD25E83, 0XE8AFA7EB} },
/**/                  {{0X3FB36DC9, 0XFB0E8AC8} },
/**/                  {{0X3F9C0331, 0XAD5D66CA} },
/**/                  {{0XBFA89EC9, 0XFEDB1E8B} } },
/**/                 {{{0X3FEB4001, 0X5FB8DEB8} },
/**/                  {{0X3FE692A4, 0XD137C500} },
/**/                  {{0X3FE28C8B, 0XABFF668E} },
/**/                  {{0XBFD24FE5, 0XD8E71E0A} },
/**/                  {{0X3FB38955, 0X1297317A} },
/**/                  {{0X3F9B0EA3, 0X1D844655} },
/**/                  {{0XBFA84624, 0X6914067D} } },
/**/                 {{{0X3FEB6000, 0X386C27B9} },
/**/                  {{0X3FE6A527, 0X8CDF6FC0} },
/**/                  {{0X3FE27A43, 0XC5758DB8} },
/**/                  {{0XBFD24135, 0X59CADCE0} },
/**/                  {{0X3FB3A3E9, 0XEE34AE91} },
/**/                  {{0X3F9A1DA8, 0X1C5FFF05} },
/**/                  {{0XBFA7EDE4, 0X9EC8AAC6} } },
/**/                 {{{0X3FEB8000, 0XD1EFDDB3} },
/**/                  {{0X3FE6B799, 0X0ACCB660} },
/**/                  {{0X3FE26809, 0X9983AAB2} },
/**/                  {{0XBFD23270, 0X76047E08} },
/**/                  {{0X3FB3BD90, 0XF132139B} },
/**/                  {{0X3F993010, 0X58DEB3E1} },
/**/                  {{0XBFA79610, 0X2D194CE9} } },
/**/                 {{{0X3FEB9FFE, 0X42CC4047} },
/**/                  {{0X3FE6C9F6, 0X86445E60} },
/**/                  {{0X3FE255E0, 0X069F871F} },
/**/                  {{0XBFD2239A, 0X25461639} },
/**/                  {{0X3FB3D649, 0XA926C127} },
/**/                  {{0X3F9845FB, 0XC5A21F70} },
/**/                  {{0XBFA73EAC, 0X68E20BE6} } },
/**/                 {{{0X3FEBC001, 0X951AEAAD} },
/**/                  {{0X3FE6DC45, 0X3C4E45A0} },
/**/                  {{0X3FE243C1, 0XFF6573B0} },
/**/                  {{0XBFD214AE, 0XE38FA7E7} },
/**/                  {{0X3FB3EE1E, 0X5EA1330F} },
/**/                  {{0X3F975F24, 0X2BCCE6DF} },
/**/                  {{0XBFA6E7BE, 0X6F3902C5} } },
/**/                 {{{0X3FEBDFFE, 0X6616FE11} },
/**/                  {{0X3FE6EE7E, 0X27106FE0} },
/**/                  {{0X3FE231B6, 0X97B587F0} },
/**/                  {{0XBFD205B5, 0X240FEF32} },
/**/                  {{0X3FB40509, 0X44EB818C} },
/**/                  {{0X3F967BDE, 0X108160F9} },
/**/                  {{0XBFA6914B, 0X271D18AD} } },
/**/                 {{{0X3FEBFFFF, 0X54511C72} },
/**/                  {{0X3FE700A7, 0X643BBB40} },
/**/                  {{0X3FE21FB7, 0XE1823C8B} },
/**/                  {{0XBFD1F6A8, 0X9A854F7A} },
/**/                  {{0X3FB41B15, 0X71F04837} },
/**/                  {{0X3F959BD8, 0XBBD10F7C} },
/**/                  {{0XBFA63B57, 0X41F03711} } },
/**/                 {{{0X3FEC2000, 0XC537593E} },
/**/                  {{0X3FE712BE, 0XF36D6400} },
/**/                  {{0X3FE20DC7, 0XF754B2D5} },
/**/                  {{0XBFD1E78B, 0X9D24DBED} },
/**/                  {{0X3FB43043, 0X94F485E0} },
/**/                  {{0X3F94BF29, 0X122A6884} },
/**/                  {{0XBFA5E5E7, 0X3D2AA4E9} } },
/**/                 {{{0X3FEC4000, 0XDDD35719} },
/**/                  {{0X3FE724C3, 0XD7FA3000} },
/**/                  {{0X3FE1FBE7, 0XF2A8B1BF} },
/**/                  {{0XBFD1D85F, 0XB25DDDF6} },
/**/                  {{0X3FB44495, 0XD2E3B20F} },
/**/                  {{0X3F93E5D6, 0X7FCC1B30} },
/**/                  {{0XBFA590FF, 0X62D0D00F} } },
/**/                 {{{0X3FEC6000, 0X402375B6} },
/**/                  {{0X3FE736B6, 0X7DFF3720} },
/**/                  {{0X3FE1EA17, 0X86C92387} },
/**/                  {{0XBFD1C925, 0X31DDFC58} },
/**/                  {{0X3FB4580F, 0XF8B6CBC2} },
/**/                  {{0X3F930FD7, 0X00CE998E} },
/**/                  {{0XBFA53CA3, 0XCB299E5F} } },
/**/                 {{{0X3FEC7FFF, 0X19904FE4} },
/**/                  {{0X3FE74897, 0X0F395860} },
/**/                  {{0X3FE1D856, 0XA825BA33} },
/**/                  {{0XBFD1B9DC, 0XA75E0FC5} },
/**/                  {{0X3FB46AB5, 0X79F8FD7D} },
/**/                  {{0X3F923D23, 0XA5A90AFE} },
/**/                  {{0XBFA4E8D8, 0X5D2F574B} } },
/**/                 {{{0X3FEC9FFE, 0XF9E2409D} },
/**/                  {{0X3FE75A66, 0X79E7F1C0} },
/**/                  {{0X3FE1C6A4, 0X8740D2E9} },
/**/                  {{0XBFD1AA85, 0XF198392C} },
/**/                  {{0X3FB47C8A, 0X808C583A} },
/**/                  {{0X3F916DAC, 0X857F2526} },
/**/                  {{0XBFA495A0, 0XD0477576} } },
/**/                 {{{0X3FECC001, 0XE038EF72} },
/**/                  {{0X3FE76C25, 0XE6815140} },
/**/                  {{0X3FE1B500, 0X19BDADF8} },
/**/                  {{0XBFD19B20, 0XB4A469AE} },
/**/                  {{0X3FB48D93, 0X42387EA2} },
/**/                  {{0X3F90A15F, 0X7305BAF5} },
/**/                  {{0XBFA44300, 0XACAE4E17} } },
/**/                 {{{0X3FECDFFE, 0XEB72037F} },
/**/                  {{0X3FE77DD0, 0X7A7A4AA0} },
/**/                  {{0X3FE1A36E, 0X4F1F6702} },
/**/                  {{0XBFD18BB1, 0XD0992CF8} },
/**/                  {{0X3FB49DCE, 0X5AA4990D} },
/**/                  {{0X3F8FB0DD, 0X63759665} },
/**/                  {{0XBFA3F0FB, 0X4D2F0C0F} } },
/**/                 {{{0X3FECFFFF, 0XEA4839ED} },
/**/                  {{0X3FE78F6B, 0XB17088C0} },
/**/                  {{0X3FE191E9, 0XCF32122F} },
/**/                  {{0XBFD17C35, 0X220400AC} },
/**/                  {{0X3FB4AD44, 0X0A159641} },
/**/                  {{0X3F8E252C, 0X80894CA9} },
/**/                  {{0XBFA39F93, 0XDF89C265} } },
/**/                 {{{0X3FED1FFD, 0XEC3EC8B2} },
/**/                  {{0X3FE7A0F3, 0XC8C6C880} },
/**/                  {{0X3FE18076, 0X729F01D6} },
/**/                  {{0XBFD16CAE, 0X98515540} },
/**/                  {{0X3FB4BBF4, 0X1B0933FF} },
/**/                  {{0X3F8C9FF5, 0XE09A60CD} },
/**/                  {{0XBFA34ECD, 0X662A5704} } },
/**/                 {{{0X3FED3FFF, 0X7084EDD4} },
/**/                  {{0X3FE7B26C, 0X5F02F220} },
/**/                  {{0X3FE16F10, 0XB9973206} },
/**/                  {{0XBFD15D1B, 0X9E1E0A54} },
/**/                  {{0X3FB4C9E4, 0XAC2C9A30} },
/**/                  {{0X3F8B20DD, 0XEFCE76CC} },
/**/                  {{0XBFA2FEAA, 0XB888BC37} } },
/**/                 {{{0X3FED5FFE, 0X8D728E7C} },
/**/                  {{0X3FE7C3D2, 0X488D7E80} },
/**/                  {{0X3FE15DBB, 0XE622A5A7} },
/**/                  {{0XBFD14D7F, 0XA305CEB2} },
/**/                  {{0X3FB4D716, 0X417BF1C7} },
/**/                  {{0X3F89A81E, 0XE19FE239} },
/**/                  {{0XBFA2AF2E, 0X84DDAD07} } },
/**/                 {{{0X3FED7FFF, 0X70AA3B03} },
/**/                  {{0X3FE7D527, 0XDB239580} },
/**/                  {{0X3FE14C75, 0XBE4FEA01} },
/**/                  {{0XBFD13DD9, 0X2AD706AA} },
/**/                  {{0X3FB4E38D, 0XB49D32AA} },
/**/                  {{0X3F88357A, 0X37DF2B6D} },
/**/                  {{0XBFA2605B, 0X507CD77B} } },
/**/                 {{{0X3FED9FFF, 0X1434FBA3} },
/**/                  {{0X3FE7E66B, 0X82C8A720} },
/**/                  {{0X3FE13B3F, 0XED9B7FED} },
/**/                  {{0XBFD12E2A, 0X3AC9D646} },
/**/                  {{0X3FB4EF4C, 0XE7B01CF5} },
/**/                  {{0X3F86C905, 0XD25FD52D} },
/**/                  {{0XBFA21233, 0X798666EF} } },
/**/                 {{{0X3FEDBFFE, 0XA8C8DE8C} },
/**/                  {{0X3FE7F79D, 0XF4A0A520} },
/**/                  {{0X3FE12A19, 0XD7FC2119} },
/**/                  {{0XBFD11E72, 0XC6BE19DF} },
/**/                  {{0X3FB4FA57, 0X634E1B91} },
/**/                  {{0X3F8562A6, 0X47F96DF5} },
/**/                  {{0XBFA1C4B9, 0X373AF599} } },
/**/                 {{{0X3FEDE000, 0X26573DF5} },
/**/                  {{0X3FE808C0, 0X4DBCB960} },
/**/                  {{0X3FE11902, 0X7903E4B9} },
/**/                  {{0XBFD10EB2, 0X5CDFED06} },
/**/                  {{0X3FB504B0, 0XCCA681FA} },
/**/                  {{0X3F840238, 0X6F3CDE09} },
/**/                  {{0XBFA177EE, 0X9BA8FA6A} } },
/**/                 {{{0X3FEDFFFE, 0X35009B66} },
/**/                  {{0X3FE819CF, 0XC2CB5340} },
/**/                  {{0X3FE107FC, 0XB1C942B5} },
/**/                  {{0XBFD0FEEC, 0X230D7D92} },
/**/                  {{0X3FB50E5A, 0X75C5B4F1} },
/**/                  {{0X3F82A7E8, 0XE3C139D8} },
/**/                  {{0XBFA12BD5, 0X93FA642B} } },
/**/                 {{{0X3FEE2000, 0X492D4C68} },
/**/                  {{0X3FE82AD0, 0X5CCB8680} },
/**/                  {{0X3FE0F704, 0X928E55DF} },
/**/                  {{0XBFD0EF1C, 0XEE0B0721} },
/**/                  {{0X3FB51759, 0X937BFB74} },
/**/                  {{0X3F815359, 0X2BC9FDDB} },
/**/                  {{0XBFA0E06F, 0XEA1D1824} } },
/**/                 {{{0X3FEE4000, 0X9412BB65} },
/**/                  {{0X3FE83BBF, 0X14001A60} },
/**/                  {{0X3FE0E61D, 0X37F485DA} },
/**/                  {{0XBFD0DF48, 0X1B2BD37D} },
/**/                  {{0X3FB51FAF, 0X64024D14} },
/**/                  {{0X3F8004B9, 0X9B849698} },
/**/                  {{0XBFA095BF, 0X450A2434} } },
/**/                 {{{0X3FEE5FFF, 0X4758EF2F} },
/**/                  {{0X3FE84C9C, 0X1531C180} },
/**/                  {{0X3FE0D546, 0X8B7FECE7} },
/**/                  {{0XBFD0CF6E, 0X105BFE1E} },
/**/                  {{0X3FB5275E, 0XF9C5E03A} },
/**/                  {{0X3F7D77F2, 0X17AA1137} },
/**/                  {{0XBFA04BC5, 0X2A6891E1} } },
/**/                 {{{0X3FEE8000, 0X380F819F} },
/**/                  {{0X3FE85D69, 0X74CCC060} },
/**/                  {{0X3FE0C47E, 0X8F1DA5B5} },
/**/                  {{0XBFD0BF8D, 0X62AD700F} },
/**/                  {{0X3FB52E6C, 0X1F3FBC2B} },
/**/                  {{0X3F7AF1C3, 0XEE24AD7D} },
/**/                  {{0XBFA00282, 0XFECE26C9} } },
/**/                 {{{0X3FEEA000, 0XA6D8CB7B} },
/**/                  {{0X3FE86E25, 0XD00E3A60} },
/**/                  {{0X3FE0B3C6, 0XBA314D62} },
/**/                  {{0XBFD0AFA7, 0XE7CB2D84} },
/**/                  {{0X3FB534D9, 0X08E9071F} },
/**/                  {{0X3F787704, 0X4CE5E5C9} },
/**/                  {{0XBF9F73F4, 0X0EB7C9D5} } },
/**/                 {{{0X3FEEC000, 0X5A13BA60} },
/**/                  {{0X3FE87ED1, 0X19B163E0} },
/**/                  {{0X3FE0A31F, 0X2EBB7AD7} },
/**/                  {{0XBFD09FBE, 0X33A3FCE1} },
/**/                  {{0X3FB53AA8, 0X89D9AF5D} },
/**/                  {{0X3F760799, 0XF7F7040B} },
/**/                  {{0XBF9EE456, 0XD3F0B3FB} } },
/**/                 {{{0X3FEEDFFF, 0X58F8DD18} },
/**/                  {{0X3FE88F6B, 0X6681CA80} },
/**/                  {{0X3FE09287, 0XEC4360B3} },
/**/                  {{0XBFD08FD0, 0XB7CE07E5} },
/**/                  {{0X3FB53FDD, 0X7BDEDD3F} },
/**/                  {{0X3F73A366, 0X70C52E66} },
/**/                  {{0XBF9E5630, 0X5DCA7315} } },
/**/                 {{{0X3FEEFFFF, 0XBE033400} },
/**/                  {{0X3FE89FF5, 0XDD4D7960} },
/**/                  {{0X3FE081FF, 0XDFFE15BD} },
/**/                  {{0XBFD07FDE, 0XDAE56C0F} },
/**/                  {{0X3FB5447A, 0XF84D6F5D} },
/**/                  {{0X3F714A24, 0X7982941E} },
/**/                  {{0XBF9DC982, 0X81E68835} } },
/**/                 {{{0X3FEF2001, 0XE6B5125D} },
/**/                  {{0X3FE8B070, 0XBBE88160} },
/**/                  {{0X3FE07186, 0XDF7122E2} },
/**/                  {{0XBFD06FE8, 0XDE905325} },
/**/                  {{0X3FB54883, 0XB5DEEC7A} },
/**/                  {{0X3F6DF762, 0XB4A186D5} },
/**/                  {{0XBF9D3E4E, 0XDE20F495} } },
/**/                 {{{0X3FEF3FFD, 0XF770E0DB} },
/**/                  {{0X3FE8C0D8, 0X09E96380} },
/**/                  {{0X3FE06120, 0XF5A576A9} },
/**/                  {{0XBFD05FF3, 0X1D2912FF} },
/**/                  {{0X3FB54BF9, 0X8CD1001F} },
/**/                  {{0X3F6970FC, 0X6E90DC16} },
/**/                  {{0XBF9CB496, 0XD8EB587E} } },
/**/                 {{{0X3FEF5FFE, 0X4E16DA33} },
/**/                  {{0X3FE8D131, 0X29BCCDC0} },
/**/                  {{0X3FE050C8, 0XD33BA4E9} },
/**/                  {{0XBFD04FF8, 0XD74C83D2} },
/**/                  {{0X3FB54EE0, 0X592BB252} },
/**/                  {{0X3F64FF61, 0X7193EEB5} },
/**/                  {{0XBF9C2C5B, 0XA459AC86} } },
/**/                 {{{0X3FEF8000, 0X4576FF2E} },
/**/                  {{0X3FE8E17A, 0XCCE443A0} },
/**/                  {{0X3FE0407F, 0XD8A97B6C} },
/**/                  {{0XBFD03FFB, 0XC91B3E55} },
/**/                  {{0X3FB5513A, 0X5F3357F7} },
/**/                  {{0X3F60A2BA, 0X14C92B53} },
/**/                  {{0XBF9BA59E, 0X3E70DF71} } },
/**/                 {{{0X3FEF9FFF, 0X39B6A330} },
/**/                  {{0X3FE8F1B2, 0XA7F515A0} },
/**/                  {{0X3FE03048, 0X63064158} },
/**/                  {{0XBFD02FFE, 0XACBAADA8} },
/**/                  {{0X3FB55309, 0XF27448C0} },
/**/                  {{0X3F58B6D6, 0X4850006B} },
/**/                  {{0XBF9B205F, 0X742323DF} } },
/**/                 {{{0X3FEFC001, 0XAA76C0B9} },
/**/                  {{0X3FE901DC, 0X15D66D80} },
/**/                  {{0X3FE0201F, 0X28D9B4AA} },
/**/                  {{0XBFD01FFE, 0XA98D4C38} },
/**/                  {{0X3FB55452, 0X089780F8} },
/**/                  {{0X3F5050B5, 0X7F35C5BB} },
/**/                  {{0XBF9A9C9F, 0XE19247AF} } },
/**/                 {{{0X3FEFDFFE, 0X39A592CA} },
/**/                  {{0X3FE911F2, 0X6D88A780} },
/**/                  {{0X3FE01008, 0XE40C6538} },
/**/                  {{0XBFD01000, 0XD31688DE} },
/**/                  {{0X3FB55514, 0XE32F1816} },
/**/                  {{0X3F402A15, 0X4E1628D2} },
/**/                  {{0XBF9A1A5F, 0XF4FAF5A0} } },
/**/                 {{{0X3FEFF801, 0X8E92D1B0} },
/**/                  {{0X3FE91DFB, 0X9BB4BF00} },
/**/                  {{0X3FE003FF, 0XB884C5A9} },
/**/                  {{0XBFD003FF, 0X3876A954} },
/**/                  {{0X3FB55551, 0X5539DDFB} },
/**/                  {{0X3F2007E7, 0X7B95E6C2} },
/**/                  {{0XBF99B9A7, 0X18A3BA58} } },
  };

  static const number
     hij[241][16] = {                             /* x0,hij for (1/16,1) */
/**/                 {{{0x3fb04000, 0x00000000} },
/**/                  {{0x3fb03a6d, 0x1c06693d} },
/**/                  {{0xbc428a02, 0xd4e7f128} },
/**/                  {{0x3fefdf1f, 0xe92592ae} },
/**/                  {{0x3c88bfc0, 0xb5490162} },
/**/                  {{0xbfb01ead, 0x8f7e4151} },
/**/                  {{0xbc5395e8, 0x0b64d205} },
/**/                  {{0xbfd4d29f, 0x433dd49b} },
/**/                  {{0xbc75b19d, 0x4aa42633} },
/**/                  {{0x3fafda41, 0xce35961d} },
/**/                  {{0x3c4e6a5f, 0x425d7696} },
/**/                  {{0x3fc814dd, 0x6c1bb5e2} },
/**/                  {{0xbfaf4cb7, 0x2b33739f} },
/**/                  {{0xbfc048b2, 0xc267d8ec} },
/**/                  {{0x3fae9649, 0xe8ababc6} },
/**/                  {{0x3fb78293, 0xfe802692} } },
/**/                 {{{0x3fb10000, 0x00000000} },
/**/                  {{0x3fb0f99e, 0xa71d52a7} },
/**/                  {{0xbc22069f, 0xeec3624f} },
/**/                  {{0x3fefdc08, 0x9a49d2a9} },
/**/                  {{0x3c7780f7, 0x68b2ce25} },
/**/                  {{0xbfb0d9de, 0x9da73e1d} },
/**/                  {{0x3c4ebf46, 0xa1a487bf} },
/**/                  {{0xbfd4c669, 0xd13ea108} },
/**/                  {{0x3c7354bc, 0xebb4528c} },
/**/                  {{0x3fb0a137, 0x789374c1} },
/**/                  {{0xbc56c223, 0xc3f2c5c2} },
/**/                  {{0x3fc7f0e7, 0x79c60cda} },
/**/                  {{0xbfb05062, 0xcdcc7b81} },
/**/                  {{0xbfc019e4, 0xc5266783} },
/**/                  {{0x3fafd0b2, 0xf2540289} },
/**/                  {{0x3fb71107, 0xf6d3cd8a} } },
/**/                 {{{0x3fb20000, 0x00000000} },
/**/                  {{0x3fb1f86d, 0xbf082d59} },
/**/                  {{0xbc4095dc, 0x7732ef81} },
/**/                  {{0x3fefd7b3, 0x01722b81} },
/**/                  {{0xbc5e618c, 0x8a212e02} },
/**/                  {{0xbfb1d2c5, 0xee4e9cfa} },
/**/                  {{0x3c426273, 0x29abece0} },
/**/                  {{0xbfd4b551, 0x37eb7f46} },
/**/                  {{0x3c73b360, 0x01d8bf12} },
/**/                  {{0x3fb18fa7, 0x6adb6a7c} },
/**/                  {{0xbc5c00d8, 0x398999ad} },
/**/                  {{0x3fc7bea5, 0xf4a7cff3} },
/**/                  {{0xbfb13008, 0x61f84829} },
/**/                  {{0xbfbfb14f, 0xa8e135a1} },
/**/                  {{0x3fb0b532, 0x4324f177} },
/**/                  {{0x3fb6734a, 0x3498dd9d} } },
/**/                 {{{0x3fb30000, 0x00000000} },
/**/                  {{0x3fb2f719, 0x318a4a9a} },
/**/                  {{0x3c03fd17, 0x79b9801f} },
/**/                  {{0x3fefd31f, 0x48e238fe} },
/**/                  {{0xbc876a7a, 0xd8c45327} },
/**/                  {{0xbfb2cada, 0x852096e2} },
/**/                  {{0x3c460860, 0x11efd787} },
/**/                  {{0xbfd4a34b, 0x2e476a39} },
/**/                  {{0x3c7254f2, 0xeb11ee51} },
/**/                  {{0x3fb27c13, 0xc54ae225} },
/**/                  {{0x3c513096, 0x4ae66f0c} },
/**/                  {{0x3fc789ca, 0xef0d59d0} },
/**/                  {{0xbfb20c06, 0x6d9aaa8c} },
/**/                  {{0xbfbf2885, 0x846ba912} },
/**/                  {{0x3fb17c5f, 0xc697ef5e} },
/**/                  {{0x3fb5ce93, 0xcad31e6e} } },
/**/                 {{{0x3fb40000, 0x00000000} },
/**/                  {{0x3fb3f59f, 0x0e7c559d} },
/**/                  {{0x3c5ac4ce, 0x285df847} },
/**/                  {{0x3fefce4d, 0xa6ab93e9} },
/**/                  {{0xbc6be46b, 0x18a97736} },
/**/                  {{0xbfb3c211, 0x4d22b635} },
/**/                  {{0x3c42033c, 0x6950679f} },
/**/                  {{0xbfd49059, 0xc4d74033} },
/**/                  {{0x3c57dd7c, 0xd7e376aa} },
/**/                  {{0x3fb36662, 0xc0896a7c} },
/**/                  {{0xbc36cf6a, 0xd79232cf} },
/**/                  {{0x3fc75261, 0xa13a97a2} },
/**/                  {{0xbfb2e431, 0x5fdd1509} },
/**/                  {{0xbfbe9999, 0x6e52db32} },
/**/                  {{0x3fb23da4, 0xb0a71e9f} },
/**/                  {{0x3fb52335, 0xe3bc8178} } },
/**/                 {{{0x3fb50000, 0x00000000} },
/**/                  {{0x3fb4f3fd, 0x677292fb} },
/**/                  {{0x3c4008d3, 0x6264979e} },
/**/                  {{0x3fefc93e, 0x53a1ee0d} },
/**/                  {{0xbc64421a, 0x20fd2bdf} },
/**/                  {{0xbfb4b85f, 0x4aba88e3} },
/**/                  {{0x3c54f184, 0x3c9d1e89} },
/**/                  {{0xbfd47c7f, 0x25ae4668} },
/**/                  {{0xbc7d7581, 0x816630d1} },
/**/                  {{0x3fb44e7b, 0x07f85056} },
/**/                  {{0x3c56d63c, 0x910bdf4f} },
/**/                  {{0x3fc71875, 0xc439029c} },
/**/                  {{0xbfb3b85e, 0xf2bcfa10} },
/**/                  {{0xbfbe04bb, 0x9707b205} },
/**/                  {{0x3fb2f8c6, 0x95e3e0cc} },
/**/                  {{0x3fb47184, 0x8093431b} } },
/**/                 {{{0x3fb60000, 0x00000000} },
/**/                  {{0x3fb5f232, 0x4fd2d7b2} },
/**/                  {{0x3c58a8da, 0x4401318e} },
/**/                  {{0x3fefc3f1, 0x8b549418} },
/**/                  {{0x3c34d896, 0x836f8130} },
/**/                  {{0xbfb5adb9, 0x9cdd92e7} },
/**/                  {{0x3c4d4161, 0xeb397cc3} },
/**/                  {{0xbfd467bd, 0x93f8f1dc} },
/**/                  {{0xbc609d7b, 0xffc760ad} },
/**/                  {{0x3fb53443, 0xbea6b2fe} },
/**/                  {{0x3c5eb03c, 0x4b24f5db} },
/**/                  {{0x3fc6dc13, 0x8de3d005} },
/**/                  {{0xbfb48866, 0x37d2d99d} },
/**/                  {{0xbfbd6a1d, 0xf6663fcb} },
/**/                  {{0x3fb3ad8e, 0x0adff464} },
/**/                  {{0x3fb3b9d6, 0x4159c223} } },
/**/                 {{{0x3fb70000, 0x00000000} },
/**/                  {{0x3fb6f03b, 0xdcea4b0d} },
/**/                  {{0xbc33f00e, 0x512fa17d} },
/**/                  {{0x3fefbe67, 0x8c07a436} },
/**/                  {{0xbc84baaa, 0x46250d6f} },
/**/                  {{0xbfb6a215, 0x7e3ba4c7} },
/**/                  {{0xbc3504e7, 0x54503f8d} },
/**/                  {{0xbfd45217, 0x6b82d03a} },
/**/                  {{0x3c7d1f0d, 0xbebdd1db} },
/**/                  {{0x3fb617a4, 0x841d5604} },
/**/                  {{0xbc47168b, 0x6681c436} },
/**/                  {{0x3fc69d47, 0xaccec6ce} },
/**/                  {{0xbfb5541f, 0xa4715800} },
/**/                  {{0xbfbcc9f4, 0x335a1c1b} },
/**/                  {{0x3fb45bc6, 0xbac0061f} },
/**/                  {{0x3fb2fc84, 0x2b3853b6} } },
/**/                 {{{0x3fb80000, 0x00000000} },
/**/                  {{0x3fb7ee18, 0x2602f10f} },
/**/                  {{0xbc5cfb65, 0x4c0c3d98} },
/**/                  {{0x3fefb8a0, 0x96acfacc} },
/**/                  {{0xbc82962e, 0x18495af3} },
/**/                  {{0xbfb79568, 0x46635c89} },
/**/                  {{0x3c5ac468, 0xa6bfd498} },
/**/                  {{0xbfd43b8f, 0x2037b997} },
/**/                  {{0xbc72ad53, 0xe2f12373} },
/**/                  {{0x3fb6f885, 0x7900c4ee} },
/**/                  {{0x3c53145d, 0x0aef1f9d} },
/**/                  {{0x3fc65c1f, 0x4409ba0e} },
/**/                  {{0xbfb61b65, 0x1d176e0c} },
/**/                  {{0xbfbc2473, 0x8ad65152} },
/**/                  {{0x3fb5033f, 0x7bc246c1} },
/**/                  {{0x3fb239e9, 0x6db30b46} } },
/**/                 {{{0x3fb90000, 0x00000000} },
/**/                  {{0x3fb8ebc5, 0x4478fb28} },
/**/                  {{0x3c473288, 0x0cad24cc} },
/**/                  {{0x3fefb29c, 0xeedcd6d7} },
/**/                  {{0x3c8efa9e, 0x23ea50f0} },
/**/                  {{0xbfb887a7, 0x6ae09982} },
/**/                  {{0x3c5b2275, 0x53801511} },
/**/                  {{0xbfd42427, 0x3da0757c} },
/**/                  {{0xbc7199e5, 0x311c7ac8} },
/**/                  {{0x3fb7d6cf, 0x4388717b} },
/**/                  {{0xbc5c4eb2, 0x3dd070b4} },
/**/                  {{0x3fc618a7, 0xe6c2b5f3} },
/**/                  {{0xbfb6de12, 0x00313569} },
/**/                  {{0xbfbb79d2, 0xb6316619} },
/**/                  {{0x3fb5a3ca, 0x61af5c21} },
/**/                  {{0x3fb17263, 0x26e60289} } },
/**/                 {{{0x3fba0000, 0x00000000} },
/**/                  {{0x3fb9e941, 0x53cfdcf1} },
/**/                  {{0x3c5a332e, 0x1d69c47e} },
/**/                  {{0x3fefac5c, 0xdace3776} },
/**/                  {{0xbc8c9a78, 0x1ad91ab5} },
/**/                  {{0xbfb978c8, 0x8054ad75} },
/**/                  {{0xbc5e35b8, 0x8ed66c17} },
/**/                  {{0xbfd40be2, 0x665afed1} },
/**/                  {{0x3c62eeef, 0x08ef10fb} },
/**/                  {{0x3fb8b26b, 0x13c989d2} },
/**/                  {{0x3c329f11, 0xbfeab3ba} },
/**/                  {{0x3fc5d2ef, 0x93c8f97c} },
/**/                  {{0xbfb79c03, 0x30234881} },
/**/                  {{0xbfbaca49, 0xd0f650c8} },
/**/                  {{0x3fb63d3c, 0xce2dcccc} },
/**/                  {{0x3fb0a650, 0x26fb0af2} } },
/**/                 {{{0x3fbb0000, 0x00000000} },
/**/                  {{0x3fbae68a, 0x71c722b8} },
/**/                  {{0x3c4c014e, 0x6910b9db} },
/**/                  {{0x3fefa5e0, 0xa34ef42b} },
/**/                  {{0xbc836583, 0xeb56d5b9} },
/**/                  {{0xbfba68c1, 0x3b881779} },
/**/                  {{0xbc473a0d, 0x13a09314} },
/**/                  {{0xbfd3f2c3, 0x538e939c} },
/**/                  {{0xbc68ed49, 0xee53e648} },
/**/                  {{0x3fb98b42, 0xa7d45973} },
/**/                  {{0xbc523943, 0x461ca7c4} },
/**/                  {{0x3fc58b04, 0xb0f2e2bb} },
/**/                  {{0xbfb85517, 0x1c9d23dc} },
/**/                  {{0xbfba1612, 0x3e3b5a66} },
/**/                  {{0x3fb6cf6f, 0x7ef1d0b9} },
/**/                  {{0x3fafac21, 0x6617b315} } },
/**/                 {{{0x3fbc0000, 0x00000000} },
/**/                  {{0x3fbbe39e, 0xbe6f07c3} },
/**/                  {{0x3c5f7b8f, 0x29a05987} },
/**/                  {{0x3fef9f28, 0x93bb9192} },
/**/                  {{0x3c78260b, 0x7cd1bdab} },
/**/                  {{0xbfbb5787, 0x72759741} },
/**/                  {{0x3c52f93f, 0xa6767247} },
/**/                  {{0xbfd3d8cc, 0xd45bbe91} },
/**/                  {{0x3c664839, 0x2edc0762} },
/**/                  {{0x3fba6140, 0x4fa31d26} },
/**/                  {{0x3c400647, 0x97891510} },
/**/                  {{0x3fc540f6, 0x0668fd66} },
/**/                  {{0xbfb9092d, 0xcb2f6e8f} },
/**/                  {{0xbfb95d66, 0x8d902073} },
/**/                  {{0x3fb75a3e, 0x99c53d16} },
/**/                  {{0x3fae040c, 0x8f475e61} } },
/**/                 {{{0x3fbd0000, 0x00000000} },
/**/                  {{0x3fbce07c, 0x5c3cca32} },
/**/                  {{0x3c4138e6, 0x425918a7} },
/**/                  {{0x3fef9834, 0xf9f6d421} },
/**/                  {{0x3c6f3089, 0x8c22a239} },
/**/                  {{0xbfbc4511, 0x1d4e69a5} },
/**/                  {{0x3c254c0f, 0xd2083ce8} },
/**/                  {{0xbfd3be01, 0xcd488978} },
/**/                  {{0x3c5612db, 0x6362ec0f} },
/**/                  {{0x3fbb344e, 0xf0d94873} },
/**/                  {{0xbc182beb, 0xfdf7db72} },
/**/                  {{0x3fc4f4d2, 0xb9d86c04} },
/**/                  {{0xbfb9b828, 0xdf238807} },
/**/                  {{0xbfb8a082, 0x5f93ffd6} },
/**/                  {{0x3fb7dd89, 0xb6650b0c} },
/**/                  {{0x3fac5526, 0xb62676ef} } },
/**/                 {{{0x3fbe0000, 0x00000000} },
/**/                  {{0x3fbddd21, 0x701eba6e} },
/**/                  {{0x3c594eff, 0xcd76fe58} },
/**/                  {{0x3fef9106, 0x266112ba} },
/**/                  {{0x3c74c302, 0x6b7e18b1} },
/**/                  {{0xbfbd3154, 0x5777816c} },
/**/                  {{0x3c5dc7e4, 0x1f9dbddd} },
/**/                  {{0xbfd3a265, 0x37a90881} },
/**/                  {{0xbc75bd61, 0xeb7ba840} },
/**/                  {{0x3fbc045a, 0x0a52514b} },
/**/                  {{0xbc35ca88, 0xcff49a99} },
/**/                  {{0x3fc4a6aa, 0x498eeb56} },
/**/                  {{0xbfba61eb, 0xa09232cf} },
/**/                  {{0xbfb7dfa2, 0x4a464027} },
/**/                  {{0x3fb85933, 0xe633c053} },
/**/                  {{0x3faaa036, 0x3f920107} } },
/**/                 {{{0x3fbf0000, 0x00000000} },
/**/                  {{0x3fbed98c, 0x2190043b} },
/**/                  {{0xbc23a598, 0x592c7b13} },
/**/                  {{0x3fef899c, 0x6bcf4ad8} },
/**/                  {{0x3c55fd73, 0x912c09b0} },
/**/                  {{0xbfbe1c47, 0x607f91a0} },
/**/                  {{0x3c576677, 0x5b5db022} },
/**/                  {{0xbfd385fa, 0x21046f5f} },
/**/                  {{0x3c7f01c3, 0x4487f4b8} },
/**/                  {{0x3fbcd14d, 0xb77f2d51} },
/**/                  {{0x3c57a86d, 0x30a2ccfe} },
/**/                  {{0x3fc4568c, 0x8782b530} },
/**/                  {{0xbfbb065b, 0x02b7ad2d} },
/**/                  {{0xbfb71b03, 0xbd215555} },
/**/                  {{0x3fb8cd23, 0xb9c1c1de} },
/**/                  {{0x3fa8e602, 0x8dbfa69b} } },
/**/                 {{{0x3fc00000, 0x00000000} },
/**/                  {{0x3fbfd5ba, 0x9aac2f6e} },
/**/                  {{0xbc4cd376, 0x86760c17} },
/**/                  {{0x3fef81f8, 0x1f81f820} },
/**/                  {{0xbc8f81f8, 0x1f81f820} },
/**/                  {{0xbfbf05e0, 0x9d0dc11b} },
/**/                  {{0xbc35a199, 0x1d821725} },
/**/                  {{0xbfd368c3, 0xaa76e1d7} },
/**/                  {{0xbc672d4c, 0xc796f8cd} },
/**/                  {{0x3fbd9b16, 0xb391c2e3} },
/**/                  {{0x3c58051b, 0x8086c51d} },
/**/                  {{0x3fc40489, 0x94488c86} },
/**/                  {{0xbfbba55d, 0xa98401c8} },
/**/                  {{0xbfb652e4, 0xe5127e64} },
/**/                  {{0x3fb93943, 0x442e53ae} },
/**/                  {{0x3fa72753, 0x86286f75} } },
/**/                 {{{0x3fc08000, 0x00000000} },
/**/                  {{0x3fc068d5, 0x84212b3e} },
/**/                  {{0xbc69e2d2, 0x83019bfd} },
/**/                  {{0x3fef7a19, 0x991bb133} },
/**/                  {{0x3c7a956a, 0x66627723} },
/**/                  {{0xbfbfee16, 0x97c8e137} },
/**/                  {{0x3c4d9399, 0x66dbe7af} },
/**/                  {{0xbfd34ac5, 0x0810323a} },
/**/                  {{0x3c6a1a57, 0x6bc6c512} },
/**/                  {{0x3fbe61a2, 0x5c75a6f9} },
/**/                  {{0xbc492b99, 0xd75c8f85} },
/**/                  {{0x3fc3b0b1, 0xd9fa3f20} },
/**/                  {{0xbfbc3edb, 0xee66d309} },
/**/                  {{0xbfb58784, 0x905eeb33} },
/**/                  {{0x3fb99d80, 0x1c65bb14} },
/**/                  {{0x3fa564f1, 0x18a09884} } },
/**/                 {{{0x3fc10000, 0x00000000} },
/**/                  {{0x3fc0e6ad, 0xccf40882} },
/**/                  {{0xbc6d71a3, 0x1bb98d0d} },
/**/                  {{0x3fef7201, 0x32978bad} },
/**/                  {{0x3c816476, 0x599381e9} },
/**/                  {{0xbfc06a70, 0x011b81fd} },
/**/                  {{0xbc422f5d, 0x9ba697ca} },
/**/                  {{0xbfd32c01, 0x802fc0a5} },
/**/                  {{0x3c7d8e47, 0x08a20868} },
/**/                  {{0x3fbf24de, 0xb59597fe} },
/**/                  {{0xbc43288f, 0x410d31eb} },
/**/                  {{0x3fc35b16, 0x070feb24} },
/**/                  {{0xbfbcd2bf, 0xe4565b78} },
/**/                  {{0xbfb4b922, 0x128768c6} },
/**/                  {{0x3fb9f9cb, 0x5c42a097} },
/**/                  {{0x3fa39fa2, 0xc7f97f2e} } },
/**/                 {{{0x3fc18000, 0x00000000} },
/**/                  {{0x3fc16465, 0x41060850} },
/**/                  {{0x3c66bcee, 0x8ae7ea92} },
/**/                  {{0x3fef69af, 0x483f492b} },
/**/                  {{0xbc6e3280, 0x57db963e} },
/**/                  {{0xbfc0dd19, 0xdacaa844} },
/**/                  {{0xbc6133c7, 0xad7fc21e} },
/**/                  {{0xbfd30c7c, 0x6addaea8} },
/**/                  {{0xbc71443d, 0x89161c76} },
/**/                  {{0x3fbfe4ba, 0x6a6d3cd2} },
/**/                  {{0x3c50d4b8, 0x423ee67a} },
/**/                  {{0x3fc303c7, 0x092e569a} },
/**/                  {{0xbfbd60f5, 0x5b11d3b6} },
/**/                  {{0xbfb3e7fd, 0x283b5c55} },
/**/                  {{0x3fba4e19, 0x9d9a6ab7} },
/**/                  {{0x3fa1d82f, 0x3487cc29} } },
/**/                 {{{0x3fc20000, 0x00000000} },
/**/                  {{0x3fc1e1fa, 0xfb043727} },
/**/                  {{0xbc4b4859, 0x14dacf8c} },
/**/                  {{0x3fef6124, 0x38a14f5e} },
/**/                  {{0x3c798e9e, 0x001f6124} },
/**/                  {{0xbfc14f04, 0x59d3fb7c} },
/**/                  {{0x3c531efa, 0x4cc99cb2} },
/**/                  {{0xbfd2ec39, 0x31219b34} },
/**/                  {{0xbc618697, 0x6e004611} },
/**/                  {{0x3fc05092, 0x68736312} },
/**/                  {{0x3c67aad4, 0x8a06e4b5} },
/**/                  {{0x3fc2aad6, 0x07eca5ec} },
/**/                  {{0xbfbde969, 0xe19fe31c} },
/**/                  {{0xbfb31455, 0xdb6b9127} },
/**/                  {{0x3fba9a62, 0xf53dd9ee} },
/**/                  {{0x3fa00f5b, 0xa8e4ede0} } },
/**/                 {{{0x3fc28000, 0x00000000} },
/**/                  {{0x3fc25f6e, 0x171a535c} },
/**/                  {{0x3c67c6d7, 0xbde1a310} },
/**/                  {{0x3fef5860, 0x64866d22} },
/**/                  {{0x3c88c6ff, 0xd1f6326c} },
/**/                  {{0xbfc1c02b, 0x13c11396} },
/**/                  {{0xbc51b469, 0xffeb1a0f} },
/**/                  {{0xbfd2cb3b, 0x4c571b0f} },
/**/                  {{0x3c6e4f76, 0x2fb0b163} },
/**/                  {{0x3fc0ad06, 0xf5c213ab} },
/**/                  {{0x3c625bf2, 0xabea9e66} },
/**/                  {{0x3fc25054, 0x5f93bbb2} },
/**/                  {{0xbfbe6c0c, 0xc80a32c8} },
/**/                  {{0xbfb23e6c, 0x678d0d1e} },
/**/                  {{0x3fbadea2, 0xebf8ae4b} },
/**/                  {{0x3f9c8bd7, 0x527f133b} } },
/**/                 {{{0x3fc30000, 0x00000000} },
/**/                  {{0x3fc2dcbd, 0xb2fba1ff} },
/**/                  {{0x3c58f287, 0x05561534} },
/**/                  {{0x3fef4f64, 0x2ee76e94} },
/**/                  {{0x3c80ec89, 0xc6da5865} },
/**/                  {{0xbfc23089, 0xb322f867} },
/**/                  {{0x3c4c2b54, 0x5fcd0d6f} },
/**/                  {{0xbfd2a986, 0x45802261} },
/**/                  {{0xbc79a132, 0x5ae78b8a} },
/**/                  {{0x3fc107b3, 0x35a9d974} },
/**/                  {{0x3c5ef22d, 0xb725e335} },
/**/                  {{0x3fc1f453, 0x9bd98832} },
/**/                  {{0xbfbee8cf, 0x2057aad4} },
/**/                  {{0xbfb16681, 0x1e1bc3a1} },
/**/                  {{0x3fbb1ad8, 0x759c8f58} },
/**/                  {{0x3f98f941, 0x0b15b4aa} } },
/**/                 {{{0x3fc38000, 0x00000000} },
/**/                  {{0x3fc359e8, 0xedeb99a4} },
/**/                  {{0xbc6a5fd7, 0x4e4604c6} },
/**/                  {{0x3fef462f, 0xfce28238} },
/**/                  {{0x3c83dc01, 0xd90595d1} },
/**/                  {{0xbfc2a01b, 0xf7edfa6d} },
/**/                  {{0xbc6b11fb, 0x4a3b5c9a} },
/**/                  {{0xbfd2871d, 0xb4959402} },
/**/                  {{0xbc4a3702, 0x2fcf7ea3} },
/**/                  {{0x3fc1608f, 0xd8d7fe8c} },
/**/                  {{0x3c61ac60, 0xf8f1d41c} },
/**/                  {{0x3fc196e5, 0x729a89ca} },
/**/                  {{0xbfbf5fa3, 0xbec74f31} },
/**/                  {{0xbfb08cd4, 0x4b6c9767} },
/**/                  {{0x3fbb4f05, 0xe624ce15} },
/**/                  {{0x3f956871, 0xddb2020c} } },
/**/                 {{{0x3fc40000, 0x00000000} },
/**/                  {{0x3fc3d6ee, 0xe8c6626c} },
/**/                  {{0x3c661a3b, 0x0ce9281b} },
/**/                  {{0x3fef3cc4, 0x35b0713c} },
/**/                  {{0x3c81d0a7, 0xe69ea094} },
/**/                  {{0xbfc30edd, 0xb7d169f0} },
/**/                  {{0x3c6b3394, 0xae999b97} },
/**/                  {{0xbfd26405, 0x3fd62b3c} },
/**/                  {{0x3c73e339, 0xc0736df9} },
/**/                  {{0x3fc1b795, 0xe8e57ee3} },
/**/                  {{0xbc6130dc, 0x0a42c7f6} },
/**/                  {{0x3fc1381b, 0xbe93b8e5} },
/**/                  {{0xbfbfd07f, 0x394e1bf7} },
/**/                  {{0xbfaf634c, 0x37bb5315} },
/**/                  {{0x3fbb7b30, 0xe501e57b} },
/**/                  {{0x3f91dae1, 0x20503792} } },
/**/                 {{{0x3fc48000, 0x00000000} },
/**/                  {{0x3fc453ce, 0xc6092a9e} },
/**/                  {{0x3c61f653, 0xb3a5a78b} },
/**/                  {{0x3fef3321, 0x4299ace8} },
/**/                  {{0xbc87414c, 0x3a742b30} },
/**/                  {{0xbfc37cca, 0xde8b2323} },
/**/                  {{0x3c649378, 0x7b50aedf} },
/**/                  {{0xbfd24040, 0x9b13f4d0} },
/**/                  {{0x3c7e271f, 0xb7dc85c0} },
/**/                  {{0x3fc20cbe, 0xc9024068} },
/**/                  {{0x3c50921f, 0x88ef3da7} },
/**/                  {{0x3fc0d808, 0x7a1f1270} },
/**/                  {{0xbfc01dab, 0xf32d5436} },
/**/                  {{0xbfadaa6d, 0x02e6f09c} },
/**/                  {{0x3fbb9f62, 0x5e9cd766} },
/**/                  {{0x3f8ca3fe, 0xab964c04} } },
/**/                 {{{0x3fc50000, 0x00000000} },
/**/                  {{0x3fc4d087, 0xa9da4f17} },
/**/                  {{0x3c61f323, 0xf1adf158} },
/**/                  {{0x3fef2947, 0x8eeb3352} },
/**/                  {{0x3c871eb0, 0x8799a164} },
/**/                  {{0xbfc3e9df, 0x6e36e75c} },
/**/                  {{0x3c541555, 0x4e37666f} },
/**/                  {{0xbfd21bd3, 0x87008bd0} },
/**/                  {{0xbc609e14, 0xc24ff75f} },
/**/                  {{0x3fc26004, 0x36860504} },
/**/                  {{0xbc58f8ca, 0x1ebc8c40} },
/**/                  {{0x3fc076bd, 0xb9f4ead3} },
/**/                  {{0xbfc05012, 0xed70ddd5} },
/**/                  {{0xbfabef8a, 0x33e194b1} },
/**/                  {{0x3fbbbba6, 0x7423a91f} },
/**/                  {{0x3f859e6a, 0xdd99da12} } },
/**/                 {{{0x3fc58000, 0x00000000} },
/**/                  {{0x3fc54d18, 0xba11570a} },
/**/                  {{0x3c618282, 0xf2884073} },
/**/                  {{0x3fef1f37, 0x87eb4d7d} },
/**/                  {{0x3c8476f0, 0xedda13e6} },
/**/                  {{0xbfc45617, 0x7f997c7c} },
/**/                  {{0xbc46bf5b, 0x6423ceda} },
/**/                  {{0xbfd1f6c1, 0xd0784ec7} },
/**/                  {{0xbc74ec12, 0xd106a8e0} },
/**/                  {{0x3fc2b160, 0x4967338d} },
/**/                  {{0x3c5309c0, 0x61339c25} },
/**/                  {{0x3fc0144d, 0xa7f42962} },
/**/                  {{0xbfc07f71, 0x73dbaeec} },
/**/                  {{0xbfaa3322, 0x2aeda9a4} },
/**/                  {{0x3fbbd00c, 0x69b152b3} },
/**/                  {{0x3f7d4f90, 0x4c782821} } },
/**/                 {{{0x3fc60000, 0x00000000} },
/**/                  {{0x3fc5c981, 0x1e3ec26a} },
/**/                  {{0xbc5054ab, 0x2c010f3d} },
/**/                  {{0x3fef14f1, 0x9cce28eb} },
/**/                  {{0xbc8b7c25, 0x2708cd6e} },
/**/                  {{0xbfc4c16f, 0x42678d07} },
/**/                  {{0x3c5f55ba, 0xc1560017} },
/**/                  {{0xbfd1d10f, 0x4fccc153} },
/**/                  {{0x3c529588, 0x1bcc361d} },
/**/                  {{0x3fc300cd, 0x74979f8c} },
/**/                  {{0xbc6b1da5, 0x0bc1e891} },
/**/                  {{0x3fbf6194, 0xfbe70208} },
/**/                  {{0xbfc0abc5, 0x4b1c266f} },
/**/                  {{0xbfa875b2, 0x3b74e858} },
/**/                  {{0x3fbbdca6, 0x92e46f11} },
/**/                  {{0x3f6f0b17, 0x9de94aef} } },
/**/                 {{{0x3fc68000, 0x00000000} },
/**/                  {{0x3fc645bf, 0xffb3aa74} },
/**/                  {{0xbc3f536b, 0x677c2cb4} },
/**/                  {{0x3fef0a76, 0x3eaa4ed6} },
/**/                  {{0x3c888c52, 0x0b06c761} },
/**/                  {{0xbfc52be2, 0xfd884489} },
/**/                  {{0x3c67ec59, 0xbe5c728a} },
/**/                  {{0xbfd1aabf, 0xe80e4e0a} },
/**/                  {{0xbc71320e, 0xe90c909e} },
/**/                  {{0x3fc34e46, 0x864781ca} },
/**/                  {{0x3c42fcb3, 0x126138ee} },
/**/                  {{0x3fbe988d, 0x013b5d4f} },
/**/                  {{0xbfc0d50d, 0x122409a2} },
/**/                  {{0xbfa6b7b6, 0x7bb562c1} },
/**/                  {{0x3fbbe18a, 0x3df8dee8} },
/**/                  {{0x3f3e4009, 0x8809e1ef} } },
/**/                 {{{0x3fc70000, 0x00000000} },
/**/                  {{0x3fc6c1d4, 0x898933d9} },
/**/                  {{0xbc52954a, 0x7603c427} },
/**/                  {{0x3feeffc5, 0xe06cfb34} },
/**/                  {{0xbc85c037, 0x379877c2} },
/**/                  {{0xbfc5956f, 0x0f53a52c} },
/**/                  {{0x3c4d46a2, 0xe566376c} },
/**/                  {{0xbfd183d7, 0x86559c11} },
/**/                  {{0x3c7d2520, 0x64734c7f} },
/**/                  {{0x3fc399c6, 0xa80eddd5} },
/**/                  {{0x3c616c26, 0x40fbef6f} },
/**/                  {{0x3fbdcda7, 0xf4b571a7} },
/**/                  {{0xbfc0fb48, 0x3fd42996} },
/**/                  {{0xbfa4f9a9, 0x95c85118} },
/**/                  {{0x3fbbdecf, 0x9d795df4} },
/**/                  {{0xbf672003, 0xb85bf719} } },
/**/                 {{{0x3fc78000, 0x00000000} },
/**/                  {{0x3fc73dbd, 0xe8a7d202} },
/**/                  {{0xbc55ad0f, 0x6d4a665d} },
/**/                  {{0x3feef4e0, 0xf6ce5590} },
/**/                  {{0xbc833df6, 0x556900ef} },
/**/                  {{0xbfc5fe0f, 0xedcc9488} },
/**/                  {{0x3c5078de, 0xd2b9e35c} },
/**/                  {{0xbfd15c5a, 0x210cab36} },
/**/                  {{0x3c67fa93, 0xf55e532a} },
/**/                  {{0x3fc3e349, 0x5efd9a41} },
/**/                  {{0xbc6cf709, 0xc8573a12} },
/**/                  {{0x3fbd010a, 0x6c903aef} },
/**/                  {{0xbfc11e77, 0x20571328} },
/**/                  {{0xbfa33c04, 0x9a1875dd} },
/**/                  {{0x3fbbd491, 0xb09ec0ce} },
/**/                  {{0xbf78d197, 0x35537a65} } },
/**/                 {{{0x3fc80000, 0x00000000} },
/**/                  {{0x3fc7b97b, 0x4bce5b02} },
/**/                  {{0x3c5347b0, 0xb4f881ca} },
/**/                  {{0x3feee9c7, 0xf8458e02} },
/**/                  {{0xbc616380, 0x7ba71fe1} },
/**/                  {{0xbfc665c2, 0x26d69eeb} },
/**/                  {{0xbc572a33, 0xfdb5eea8} },
/**/                  {{0xbfd1344b, 0xb737e8f3} },
/**/                  {{0xbc757b70, 0x62badf41} },
/**/                  {{0x3fc42aca, 0x8b929b0b} },
/**/                  {{0x3c43cdb5, 0x7a8b7d91} },
/**/                  {{0x3fbc32d8, 0xf683981c} },
/**/                  {{0xbfc13e9a, 0xd22d5ecc} },
/**/                  {{0xbfa17f3e, 0xd35c8c33} },
/**/                  {{0x3fbbc2ee, 0x2a73307e} },
/**/                  {{0xbf82ee04, 0x2bddc834} } },
/**/                 {{{0x3fc88000, 0x00000000} },
/**/                  {{0x3fc8350b, 0xe398ebc8} },
/**/                  {{0xbc55a913, 0x32b9c90d} },
/**/                  {{0x3feede7b, 0x5cfce04c} },
/**/                  {{0x3c8507c2, 0x3b51a72f} },
/**/                  {{0xbfc6cc82, 0x6067718b} },
/**/                  {{0x3c6d00ca, 0xdbfc430f} },
/**/                  {{0xbfd10bb0, 0x4fbf6fe8} },
/**/                  {{0x3c321748, 0x53749c72} },
/**/                  {{0x3fc47046, 0x699a36ad} },
/**/                  {{0xbc63924c, 0x3994d40c} },
/**/                  {{0x3fbb6338, 0x0dfb7483} },
/**/                  {{0xbfc15bb5, 0x42ee5820} },
/**/                  {{0xbf9f879b, 0x385194fc} },
/**/                  {{0x3fbbaa05, 0x57d040e9} },
/**/                  {{0xbf895566, 0xada71ca0} } },
/**/                 {{{0x3fc90000, 0x00000000} },
/**/                  {{0x3fc8b06e, 0xe2879c29} },
/**/                  {{0xbc6118cd, 0x30308c4f} },
/**/                  {{0x3feed2fb, 0x9ec57f51} },
/**/                  {{0xbc83fdc5, 0xc0d106ba} },
/**/                  {{0xbfc7324d, 0x58b40d27} },
/**/                  {{0x3c68e240, 0xfc062163} },
/**/                  {{0xbfd0e28b, 0xf8b8a2bf} },
/**/                  {{0xbc7b8d8a, 0x64c55b39} },
/**/                  {{0x3fc4b3b9, 0x8ff46730} },
/**/                  {{0xbc5af146, 0x988563da} },
/**/                  {{0x3fba924c, 0x1277a10d} },
/**/                  {{0xbfc175c9, 0x2bbfd54d} },
/**/                  {{0xbf9c1448, 0x6c522340} },
/**/                  {{0x3fbb89fa, 0x044f2f6b} },
/**/                  {{0xbf8f9cc7, 0xaaecc742} } },
/**/                 {{{0x3fc98000, 0x00000000} },
/**/                  {{0x3fc92ba3, 0x7d050272} },
/**/                  {{0xbc60d3de, 0xd0ff4764} },
/**/                  {{0x3feec749, 0x390b6afe} },
/**/                  {{0xbc5c3d17, 0x4e3659ca} },
/**/                  {{0xbfc7971f, 0xe659b3de} },
/**/                  {{0x3c4cab11, 0x373f554d} },
/**/                  {{0xbfd0b8e2, 0xc6b052a4} },
/**/                  {{0x3c7da014, 0x6f3b74bc} },
/**/                  {{0x3fc4f520, 0xf0432146} },
/**/                  {{0xbc6769ad, 0xa8027290} },
/**/                  {{0x3fb9c039, 0x3e17b570} },
/**/                  {{0xbfc18cda, 0x0d8833a4} },
/**/                  {{0xbf98a567, 0x4627d340} },
/**/                  {{0x3fbb62f1, 0x5e42eff7} },
/**/                  {{0xbf92e10a, 0x7ee3bed3} } },
/**/                 {{{0x3fca0000, 0x00000000} },
/**/                  {{0x3fc9a6a8, 0xe96c8626} },
/**/                  {{0x3c4cf601, 0xe7b4348e} },
/**/                  {{0x3feebb64, 0xa8c932d7} },
/**/                  {{0x3c20538d, 0x79aae302} },
/**/                  {{0xbfc7faf6, 0xf88295fe} },
/**/                  {{0xbc687a81, 0x932909e9} },
/**/                  {{0xbfd08eb8, 0xd3f5a07b} },
/**/                  {{0xbc620a05, 0xfb7d6aaa} },
/**/                  {{0x3fc53479, 0xd6814372} },
/**/                  {{0xbc53c682, 0x0a0c6620} },
/**/                  {{0x3fb8ed23, 0x9c562d77} },
/**/                  {{0xbfc1a0ec, 0x2cdd89fd} },
/**/                  {{0xbf953bd4, 0xfec9df82} },
/**/                  {{0x3fbb3512, 0xd9d3f0f6} },
/**/                  {{0xbf95e1ab, 0x4534ccf5} } },
/**/                 {{{0x3fca8000, 0x00000000} },
/**/                  {{0x3fca217e, 0x601081a6} },
/**/                  {{0xbc60def8, 0xa60af374} },
/**/                  {{0x3feeaf4e, 0x6c7ba732} },
/**/                  {{0x3c89fa72, 0xe91fffe1} },
/**/                  {{0xbfc85dcf, 0x970642c3} },
/**/                  {{0xbc5732c2, 0x5b7f0ad0} },
/**/                  {{0xbfd06412, 0x3fe5c74d} },
/**/                  {{0xbc7d0053, 0x4a82f9b1} },
/**/                  {{0x3fc571c1, 0xe882973d} },
/**/                  {{0x3c59d9a3, 0x9090f12c} },
/**/                  {{0x3fb8192f, 0x00f5d0e0} },
/**/                  {{0xbfc1b204, 0x8db53983} },
/**/                  {{0xbf91d869, 0xbdd7b47e} },
/**/                  {{0x3fbb0088, 0x1355a903} },
/**/                  {{0xbf98cf57, 0x724a2ad9} } },
/**/                 {{{0x3fcb0000, 0x00000000} },
/**/                  {{0x3fca9c23, 0x1b403279} },
/**/                  {{0x3c60e8bb, 0xe89cca85} },
/**/                  {{0x3feea307, 0x04157b4f} },
/**/                  {{0x3c8ad743, 0xfd8bf1f0} },
/**/                  {{0xbfc8bfa6, 0xe285e2fd} },
/**/                  {{0xbc6ce765, 0x9c834c8f} },
/**/                  {{0xbfd038f3, 0x2e38fd26} },
/**/                  {{0x3c6a42ec, 0xef212a80} },
/**/                  {{0x3fc5acf7, 0x255d65d5} },
/**/                  {{0xbc619fba, 0xbe486771} },
/**/                  {{0x3fb7447e, 0xff244e15} },
/**/                  {{0xbfc1c028, 0xeed71b69} },
/**/                  {{0xbf8cf7f0, 0xaceecf68} },
/**/                  {{0x3fbac57c, 0xb0ee161b} },
/**/                  {{0xbf9ba92d, 0xefc8f53e} } },
/**/                 {{{0x3fcb8000, 0x00000000} },
/**/                  {{0x3fcb1696, 0x574d780c} },
/**/                  {{0xbc585ab8, 0xfc15a673} },
/**/                  {{0x3fee968e, 0xf0f2da5a} },
/**/                  {{0xbc6fffe1, 0x69710f0d} },
/**/                  {{0xbfc9207a, 0x148444b5} },
/**/                  {{0xbc66661a, 0x1802fa91} },
/**/                  {{0xbfd00d5f, 0xc65096ca} },
/**/                  {{0x3c7f2a2e, 0x8920e744} },
/**/                  {{0x3fc5e617, 0xe4be288d} },
/**/                  {{0x3c67fa48, 0x99be934f} },
/**/                  {{0x3fb66f36, 0xe0d4c87a} },
/**/                  {{0xbfc1cb5f, 0xc5179ce8} },
/**/                  {{0xbf864e9c, 0x1011bb6c} },
/**/                  {{0x3fba841e, 0x43a75476} },
/**/                  {{0xbf9e6e5b, 0x845fc859} } },
/**/                 {{{0x3fcc0000, 0x00000000} },
/**/                  {{0x3fcb90d7, 0x529260a2} },
/**/                  {{0x3c217b10, 0xd2e0e5ab} },
/**/                  {{0x3fee89e6, 0xb5ccf172} },
/**/                  {{0x3c820357, 0x153be26a} },
/**/                  {{0xbfc98046, 0x7f79bfd6} },
/**/                  {{0xbc0799ee, 0xf5d60955} },
/**/                  {{0xbfcfc2b8, 0x650d32f4} },
/**/                  {{0xbc6b59de, 0x4d01b49e} },
/**/                  {{0x3fc61d22, 0xd625e475} },
/**/                  {{0xbc68013f, 0xe23c6105} },
/**/                  {{0x3fb59979, 0x9e54f300} },
/**/                  {{0xbfc1d3b0, 0x365c2b85} },
/**/                  {{0xbf7f6cc9, 0x0afb6b97} },
/**/                  {{0x3fba3c9c, 0x28035c12} },
/**/                  {{0xbfa08f0d, 0x8331488a} } },
/**/                 {{{0x3fcc8000, 0x00000000} },
/**/                  {{0x3fcc0ae5, 0x4d768467} },
/**/                  {{0xbc604cdb, 0xf55f26dc} },
/**/                  {{0x3fee7d0e, 0xd6ad70cb} },
/**/                  {{0x3c8e6761, 0xee20d17d} },
/**/                  {{0xbfc9df09, 0x8ee3fcf8} },
/**/                  {{0x3c62daa3, 0xed723e81} },
/**/                  {{0xbfcf69d9, 0x3efdc9b4} },
/**/                  {{0x3c6c7b6f, 0x85a20110} },
/**/                  {{0x3fc65217, 0x0013c661} },
/**/                  {{0xbc678a0c, 0xab1387be} },
/**/                  {{0x3fb4c369, 0xd61f268e} },
/**/                  {{0xbfc1d922, 0x146d6110} },
/**/                  {{0xbf726199, 0xc0b0ed0a} },
/**/                  {{0x3fb9ef27, 0x6629c856} },
/**/                  {{0xbfa1dbda, 0xc1ea955d} } },
/**/                 {{{0x3fcd0000, 0x00000000} },
/**/                  {{0x3fcc84bf, 0x8a742e6e} },
/**/                  {{0xbc595bdd, 0x0682ea26} },
/**/                  {{0x3fee7007, 0xd8e205ea} },
/**/                  {{0x3c816199, 0x7b2991c1} },
/**/                  {{0xbfca3cc0, 0xc751a854} },
/**/                  {{0xbc66a2fd, 0x4efbc78c} },
/**/                  {{0xbfcf102a, 0x76f43baa} },
/**/                  {{0x3c6cfc38, 0x38d996b1} },
/**/                  {{0x3fc684f3, 0xbf1a9ad6} },
/**/                  {{0x3c52eaf7, 0x7c3b6690} },
/**/                  {{0x3fb3ed29, 0xc4ebba84} },
/**/                  {{0xbfc1dbbd, 0xd79a6a53} },
/**/                  {{0xbf55fa5b, 0xfd09510e} },
/**/                  {{0x3fb99bf2, 0x91c74d50} },
/**/                  {{0xbfa31d41, 0x3002c38b} } },
/**/                 {{{0x3fcd8000, 0x00000000} },
/**/                  {{0x3fccfe65, 0x4e1d5395} },
/**/                  {{0x3c647b9a, 0x3f71eafb} },
/**/                  {{0x3fee62d2, 0x42efd10e} },
/**/                  {{0x3c850a65, 0xa021973e} },
/**/                  {{0xbfca9969, 0xc66a1be4} },
/**/                  {{0x3c326164, 0x3753f036} },
/**/                  {{0xbfceb5b4, 0x6b550477} },
/**/                  {{0xbc64cacb, 0xa3ef610f} },
/**/                  {{0x3fc6b5b8, 0xc4e2c295} },
/**/                  {{0x3c66b228, 0x98b2ac7f} },
/**/                  {{0x3fb316db, 0x3e03bb80} },
/**/                  {{0xbfc1db8c, 0x99312ba1} },
/**/                  {{0x3f5ce5b0, 0x8536556f} },
/**/                  {{0x3fb94331, 0xa9b62abf} },
/**/                  {{0xbfa452f3, 0xb36f42fc} } },
/**/                 {{{0x3fce0000, 0x00000000} },
/**/                  {{0x3fcd77d5, 0xdf205736} },
/**/                  {{0x3c6c648d, 0x1534597e} },
/**/                  {{0x3fee556e, 0x9c86d7c6} },
/**/                  {{0xbc830c25, 0x34c9abfd} },
/**/                  {{0xbfcaf502, 0x42f10c89} },
/**/                  {{0xbc411261, 0xf8576d95} },
/**/                  {{0xbfce5a7f, 0x7b1596d9} },
/**/                  {{0x3c574baa, 0x78f7ae18} },
/**/                  {{0x3fc6e466, 0x171949b1} },
/**/                  {{0xbc6ff86b, 0x52f9c399} },
/**/                  {{0x3fb2409f, 0xa3d6f244} },
/**/                  {{0xbfc1d898, 0x0dceacbf} },
/**/                  {{0x3f73c3b6, 0xdc715080} },
/**/                  {{0x3fb8e519, 0xf78687ab} },
/**/                  {{0xbfa57cac, 0x6b1251ec} } },
/**/                 {{{0x3fce8000, 0x00000000} },
/**/                  {{0x3fcdf110, 0x864c9d9e} },
/**/                  {{0xbc35818b, 0x53bf4781} },
/**/                  {{0x3fee47dd, 0x6e7576a6} },
/**/                  {{0x3c89d322, 0x24b84595} },
/**/                  {{0xbfcb4f88, 0x0cc64717} },
/**/                  {{0xbc624035, 0x44bb97a3} },
/**/                  {{0xbfcdfe94, 0x046e8a3b} },
/**/                  {{0xbc6078ee, 0xd278da00} },
/**/                  {{0x3fc710fc, 0x0e4ccbb7} },
/**/                  {{0xbc58c89c, 0x1da51f71} },
/**/                  {{0x3fb16a97, 0xe0d7022a} },
/**/                  {{0xbfc1d2ea, 0x7f8b58f8} },
/**/                  {{0x3f800ed5, 0xaf259d18} },
/**/                  {{0x3fb881e1, 0xeefd29c7} },
/**/                  {{0xbfa69a2c, 0xae6aa0c1} } },
/**/                 {{{0x3fcf0000, 0x00000000} },
/**/                  {{0x3fce6a14, 0x8e96ec4d} },
/**/                  {{0x3c6866b2, 0x2029f765} },
/**/                  {{0x3fee3a1f, 0x429bd423} },
/**/                  {{0xbc86174a, 0x48961291} },
/**/                  {{0xbfcba8f9, 0x0ce18ad9} },
/**/                  {{0x3c62e3e9, 0xb50eb15d} },
/**/                  {{0xbfcda1fa, 0x63927806} },
/**/                  {{0xbbed7b15, 0x8073bacf} },
/**/                  {{0x3fc73b7b, 0x54b8d3bb} },
/**/                  {{0x3c602afb, 0x74869c1c} },
/**/                  {{0x3fb094e4, 0x60993bd6} },
/**/                  {{0xbfc1ca8e, 0xc806a157} },
/**/                  {{0x3f862263, 0xa854d278} },
/**/                  {{0x3fb819c1, 0x0d9e7452} },
/**/                  {{0xbfa7ab3d, 0x08743869} } },
/**/                 {{{0x3fcf8000, 0x00000000} },
/**/                  {{0x3fcee2e1, 0x451d980d} },
/**/                  {{0xbc59a770, 0x8c46ba91} },
/**/                  {{0x3fee2c34, 0xa3df5666} },
/**/                  {{0xbc8ef949, 0x19a92865} },
/**/                  {{0xbfcc0153, 0x454a9009} },
/**/                  {{0x3c5572bf, 0xda1123ca} },
/**/                  {{0xbfcd44ba, 0xf169cd42} },
/**/                  {{0xbc6db0f2, 0xf1052e0a} },
/**/                  {{0x3fc763e4, 0xe5006ad1} },
/**/                  {{0x3c66e21a, 0x3e902796} },
/**/                  {{0x3faf7f4a, 0x12812c7d} },
/**/                  {{0xbfc1bf90, 0x4a558d9d} },
/**/                  {{0x3f8c1b52, 0x2be7fbfd} },
/**/                  {{0x3fb7acef, 0xba5b0263} },
/**/                  {{0xbfa8afad, 0x2dddf4e5} } },
/**/                 {{{0x3fd00000, 0x00000000} },
/**/                  {{0x3fcf5b75, 0xf92c80dd} },
/**/                  {{0x3c68ab6e, 0x3cf7afbd} },
/**/                  {{0x3fee1e1e, 0x1e1e1e1e} },
/**/                  {{0x3c6e1e1e, 0x1e1e1e1e} },
/**/                  {{0xbfcc5894, 0xd10d4986} },
/**/                  {{0x3c5f00e2, 0xc4a6886a} },
/**/                  {{0xbfcce6de, 0x0253d27e} },
/**/                  {{0xbc65d764, 0x3c5fce89} },
/**/                  {{0x3fc78a3a, 0x08d88b02} },
/**/                  {{0x3c4fc5d6, 0x32bd57e4} },
/**/                  {{0x3fadd5f2, 0x6a622b44} },
/**/                  {{0xbfc1b1fa, 0xecd7c4e0} },
/**/                  {{0x3f90fc3e, 0x1fc8b549} },
/**/                  {{0x3fb73ba7, 0x25728acf} },
/**/                  {{0xbfa9a753, 0xeeba051f} } },
/**/                 {{{0x3fd04000, 0x00000000} },
/**/                  {{0x3fcfd3d1, 0xfc40dbe4} },
/**/                  {{0x3c437146, 0xf3a1c5ea} },
/**/                  {{0x3fee0fdc, 0x3e228818} },
/**/                  {{0xbc62e075, 0x8c042ef5} },
/**/                  {{0xbfccaebb, 0xe42a71b9} },
/**/                  {{0xbc69fa0a, 0x8025fd1d} },
/**/                  {{0xbfcc886b, 0xe4ed28e5} },
/**/                  {{0xbc59ccc3, 0x7604b95a} },
/**/                  {{0x3fc7ae7c, 0x57a32fb9} },
/**/                  {{0x3c67393b, 0xe36848c2} },
/**/                  {{0x3fac2dff, 0x5a1b7b6f} },
/**/                  {{0xbfc1a1db, 0x12f690d4} },
/**/                  {{0x3f93dc65, 0xa575dc1d} },
/**/                  {{0x3fb6c621, 0x28a107f6} },
/**/                  {{0xbfaa920f, 0x23d2c35f} } },
/**/                 {{{0x3fd08000, 0x00000000} },
/**/                  {{0x3fd025fa, 0x510665b6} },
/**/                  {{0xbc7672df, 0x6832fa48} },
/**/                  {{0x3fee016f, 0x9196b776} },
/**/                  {{0x3c81da3a, 0xb14efc08} },
/**/                  {{0xbfcd03c6, 0xcb847375} },
/**/                  {{0xbc6819f2, 0xfc4c6f52} },
/**/                  {{0xbfcc296c, 0xe0dbf8a5} },
/**/                  {{0xbc55cc84, 0x27fb1c17} },
/**/                  {{0x3fc7d0ad, 0xb4fbbf40} },
/**/                  {{0x3c6378b3, 0x41b71641} },
/**/                  {{0x3faa87ad, 0x440404cd} },
/**/                  {{0xbfc18f3d, 0x96d156a8} },
/**/                  {{0x3f96ad9b, 0x9ef40490} },
/**/                  {{0x3fb64c98, 0x27a95e14} },
/**/                  {{0xbfab6fc3, 0x97cfdce0} } },
/**/                 {{{0x3fd0c000, 0x00000000} },
/**/                  {{0x3fd061ee, 0xa03d6291} },
/**/                  {{0xbc45f760, 0xdb154301} },
/**/                  {{0x3fedf2d8, 0xa6f82a61} },
/**/                  {{0xbc6cedbb, 0x560866af} },
/**/                  {{0xbfcd57b3, 0xecc8c02c} },
/**/                  {{0x3c641512, 0x85b9541c} },
/**/                  {{0xbfcbc9e9, 0x35a209c0} },
/**/                  {{0x3c65bfd8, 0x4914a5d1} },
/**/                  {{0x3fc7f0d0, 0x4f358b07} },
/**/                  {{0xbc60dc70, 0x3f47a5cc} },
/**/                  {{0x3fa8e337, 0x50af01c1} },
/**/                  {{0xbfc17a2f, 0xc2daf61b} },
/**/                  {{0x3f996f63, 0x57b649f0} },
/**/                  {{0x3fb5cf46, 0xf14fef28} },
/**/                  {{0xbfac405c, 0xec5a22c2} } },
/**/                 {{{0x3fd10000, 0x00000000} },
/**/                  {{0x3fd09dc5, 0x97d86362} },
/**/                  {{0x3c762e47, 0x390cb865} },
/**/                  {{0x3fede418, 0x0d8b5ae6} },
/**/                  {{0x3c719298, 0x23f66cf0} },
/**/                  {{0xbfcdaa81, 0xc655a596} },
/**/                  {{0x3c666d0d, 0x6a90480b} },
/**/                  {{0xbfcb69e9, 0x1974fd6c} },
/**/                  {{0xbc68e199, 0xec28723f} },
/**/                  {{0x3fc80ee6, 0x9dcd2641} },
/**/                  {{0x3c37ccfe, 0x45b4bb82} },
/**/                  {{0x3fa740d7, 0x64b143be} },
/**/                  {{0xbfc162bf, 0x4b6b7330} },
/**/                  {{0x3f9c2147, 0x7a20d203} },
/**/                  {{0x3fb54e68, 0xa0d6b625} },
/**/                  {{0xbfad03cd, 0x7b6e81ad} } },
/**/                 {{{0x3fd14000, 0x00000000} },
/**/                  {{0x3fd0d97e, 0xe509acb3} },
/**/                  {{0x3c747c31, 0x7bd5a3eb} },
/**/                  {{0x3fedd52e, 0x554f6dcf} },
/**/                  {{0xbc75c686, 0xddcd060b} },
/**/                  {{0xbfcdfc2e, 0xef1cb578} },
/**/                  {{0xbc46ae20, 0xd1677d50} },
/**/                  {{0xbfcb0974, 0xb81cdb34} },
/**/                  {{0x3c36ed8e, 0xda61c86c} },
/**/                  {{0x3fc82af3, 0x5fcd53c1} },
/**/                  {{0xbc424fe5, 0x57b559e7} },
/**/                  {{0x3fa5a0c6, 0x17013aef} },
/**/                  {{0xbfc148fa, 0x484940dd} },
/**/                  {{0x3f9ec2da, 0x1737ca6d} },
/**/                  {{0x3fb4ca38, 0x800ba495} },
/**/                  {{0xbfadba0e, 0x35128042} } },
/**/                 {{{0x3fd18000, 0x00000000} },
/**/                  {{0x3fd1151a, 0x362431ca} },
/**/                  {{0xbc74dc8d, 0xc9077b9f} },
/**/                  {{0x3fedc61c, 0x0ef1f116} },
/**/                  {{0xbc8fe39f, 0x2d41c166} },
/**/                  {{0xbfce4cba, 0x1681d2c9} },
/**/                  {{0x3c340fb4, 0x369a3c18} },
/**/                  {{0xbfcaa894, 0x31d921e2} },
/**/                  {{0x3c6bf59e, 0x64c48da4} },
/**/                  {{0x3fc844f9, 0x9a284cea} },
/**/                  {{0xbc563be0, 0x629cfeb8} },
/**/                  {{0x3fa4033a, 0xa7f26285} },
/**/                  {{0xbfc12cef, 0x2e2d72ea} },
/**/                  {{0x3fa0a9da, 0x554d151d} },
/**/                  {{0x3fb442f1, 0xe9f9174f} },
/**/                  {{0xbfae631e, 0x799e467c} } },
/**/                 {{{0x3fd1c000, 0x00000000} },
/**/                  {{0x3fd15097, 0x3a9ce547} },
/**/                  {{0xbc7796ba, 0x7f9ca328} },
/**/                  {{0x3fedb6e1, 0xcbc2abaa} },
/**/                  {{0xbc823b7a, 0xc39a4e7c} },
/**/                  {{0xbfce9c22, 0x0436f806} },
/**/                  {{0xbc64a5ec, 0x885803cb} },
/**/                  {{0xbfca474f, 0x9a4c8963} },
/**/                  {{0x3c671cf3, 0x6793b663} },
/**/                  {{0x3fc85cfc, 0x9606243b} },
/**/                  {{0x3c5fd2b2, 0x1dcd45ed} },
/**/                  {{0x3fa2686a, 0xf8cc655f} },
/**/                  {{0xbfc10eac, 0xc8460b94} },
/**/                  {{0x3fa1e9bc, 0x0d6eb5ba} },
/**/                  {{0x3fb3b8d0, 0x2e4749c2} },
/**/                  {{0xbfaeff03, 0xf0d19201} } },
/**/                 {{{0x3fd20000, 0x00000000} },
/**/                  {{0x3fd18bf5, 0xa30bf178} },
/**/                  {{0x3c630ca4, 0x748b1bf9} },
/**/                  {{0x3feda780, 0x1da7801e} },
/**/                  {{0xbc861ff8, 0x961ff896} },
/**/                  {{0xbfceea65, 0x9814cb11} },
/**/                  {{0xbc5f9845, 0x34cb01ca} },
/**/                  {{0xbfc9e5ae, 0xf76f9fa1} },
/**/                  {{0x3c688b7a, 0xa3ee6a86} },
/**/                  {{0x3fc872ff, 0xdf090624} },
/**/                  {{0x3c31016f, 0x6fbad4bb} },
/**/                  {{0x3fa0d08b, 0x83fe02bc} },
/**/                  {{0xbfc0ee42, 0x31b98637} },
/**/                  {{0x3fa320e6, 0x5b309f28} },
/**/                  {{0x3fb32c0e, 0x755cbc43} },
/**/                  {{0xbfaf8dca, 0x5dea1ddb} } },
/**/                 {{{0x3fd24000, 0x00000000} },
/**/                  {{0x3fd1c735, 0x212dd884} },
/**/                  {{0xbc67d9ac, 0x78cb2f2e} },
/**/                  {{0x3fed97f7, 0x971063d2} },
/**/                  {{0x3c67a20b, 0xc8b326b7} },
/**/                  {{0xbfcf3783, 0xc9f01359} },
/**/                  {{0x3c4a8b96, 0xd0a651ad} },
/**/                  {{0xbfc983ba, 0x408a6757} },
/**/                  {{0x3c6dfff9, 0xe6424f06} },
/**/                  {{0x3fc88707, 0x41881aad} },
/**/                  {{0xbc63baf9, 0x2204fd29} },
/**/                  {{0x3f9e779e, 0xabd6e10d} },
/**/                  {{0xbfc0cbbe, 0xcf2eab41} },
/**/                  {{0x3fa44f31, 0x1659f377} },
/**/                  {{0x3fb29ce7, 0xa54a8a94} },
/**/                  {{0xbfb007c1, 0xb87973d7} } },
/**/                 {{{0x3fd28000, 0x00000000} },
/**/                  {{0x3fd20255, 0x67e47c96} },
/**/                  {{0xbc618323, 0x28f4290e} },
/**/                  {{0x3fed8848, 0xcaeb6c2a} },
/**/                  {{0x3c81e70d, 0xa08296a2} },
/**/                  {{0xbfcf837b, 0xa96c2792} },
/**/                  {{0xbc6ab5ce, 0xc6884369} },
/**/                  {{0xbfc92179, 0x5d351cdb} },
/**/                  {{0x3c617000, 0x68719d81} },
/**/                  {{0x3fc89916, 0xc8c1ca07} },
/**/                  {{0xbc6a3339, 0x18b0f81b} },
/**/                  {{0x3f9b54d0, 0x0caf6121} },
/**/                  {{0xbfc0a732, 0x485ba392} },
/**/                  {{0x3fa57477, 0xc250c31e} },
/**/                  {{0x3fb20b96, 0x4790b4a8} },
/**/                  {{0xbfb04223, 0x4ac23178} } },
/**/                 {{{0x3fd2c000, 0x00000000} },
/**/                  {{0x3fd23d56, 0x2b381042} },
/**/                  {{0xbc5c5317, 0x16200088} },
/**/                  {{0x3fed7874, 0x4c98f347} },
/**/                  {{0xbc8a7dac, 0x9a72647e} },
/**/                  {{0xbfcfce4c, 0x5dca68a2} },
/**/                  {{0x3c6433de, 0x8fb9ffdd} },
/**/                  {{0xbfc8bef4, 0x246041ce} },
/**/                  {{0xbc66c620, 0x1fb39160} },
/**/                  {{0x3fc8a932, 0xbd062535} },
/**/                  {{0xbc6e24c7, 0xfbc3a86c} },
/**/                  {{0x3f98390b, 0x64d0109d} },
/**/                  {{0xbfc080ac, 0x819f2998} },
/**/                  {{0x3fa69099, 0x8784ffb8} },
/**/                  {{0x3fb17854, 0x6fc55e9b} },
/**/                  {{0xbfb07618, 0x5f970a81} } },
/**/                 {{{0x3fd30000, 0x00000000} },
/**/                  {{0x3fd27837, 0x2057ef46} },
/**/                  {{0xbc7077cd, 0xd36dfc81} },
/**/                  {{0x3fed687a, 0xafdfd5ba} },
/**/                  {{0xbc782e68, 0xe19d8d3d} },
/**/                  {{0xbfd00bfa, 0x92db6fdb} },
/**/                  {{0x3c7854cd, 0xc0af523f} },
/**/                  {{0xbfc85c32, 0x5b640da2} },
/**/                  {{0x3c5d5bdd, 0x5e6f23d6} },
/**/                  {{0x3fc8b75f, 0xa1da32d2} },
/**/                  {{0x3c2788df, 0x29860bfe} },
/**/                  {{0x3f9524ad, 0xee810d60} },
/**/                  {{0xbfc0583d, 0x95a69dea} },
/**/                  {{0x3fa7a379, 0x2b4d3dec} },
/**/                  {{0x3fb0e35b, 0xa3290dfe} },
/**/                  {{0xbfb0a3b2, 0x19e12287} } },
/**/                 {{{0x3fd34000, 0x00000000} },
/**/                  {{0x3fd2b2f7, 0xfd9b5fe2} },
/**/                  {{0x3c2423cf, 0xc1c2d443} },
/**/                  {{0x3fed585c, 0x88e1caa2} },
/**/                  {{0xbc2c8af2, 0x01239e18} },
/**/                  {{0xbfd0303a, 0xab890af7} },
/**/                  {{0x3c7d42bf, 0x726290e6} },
/**/                  {{0xbfc7f93b, 0xb5175de0} },
/**/                  {{0x3c5d5d4b, 0xe0ddc367} },
/**/                  {{0x3fc8c3a2, 0x3414de7c} },
/**/                  {{0x3c5ade9b, 0xba92bfce} },
/**/                  {{0x3f921811, 0xda70853d} },
/**/                  {{0xbfc02df5, 0xcf23aaf0} },
/**/                  {{0x3fa8acfd, 0x06445ff8} },
/**/                  {{0x3fb04ce4, 0xc130eba4} },
/**/                  {{0xbfb0cb04, 0x29de3135} } },
/**/                 {{{0x3fd38000, 0x00000000} },
/**/                  {{0x3fd2ed98, 0x7a823cfe} },
/**/                  {{0x3c6b9125, 0x8ea012ca} },
/**/                  {{0x3fed481a, 0x6c0fd782} },
/**/                  {{0x3c82dda4, 0x85ff74ea} },
/**/                  {{0xbfd053e6, 0x2f5c1e18} },
/**/                  {{0xbc679cf2, 0x8ec637b8} },
/**/                  {{0xbfc79617, 0xd0ee3e3b} },
/**/                  {{0xbc4e91e0, 0x732049a6} },
/**/                  {{0x3fc8cdff, 0x67f6478d} },
/**/                  {{0xbc5cb659, 0xf5079e63} },
/**/                  {{0x3f8e271c, 0x8e8ef686} },
/**/                  {{0xbfc001e5, 0xa2940881} },
/**/                  {{0x3fa9ad0e, 0xf937caae} },
/**/                  {{0x3faf6a4f, 0xda1e257f} },
/**/                  {{0xbfb0ec24, 0xb07d42be} } },
/**/                 {{{0x3fd3c000, 0x00000000} },
/**/                  {{0x3fd32818, 0x4fb58952} },
/**/                  {{0xbc7a95f0, 0xa9939f2f} },
/**/                  {{0x3fed37b4, 0xee1ee130} },
/**/                  {{0x3c747541, 0x6fbb1f2d} },
/**/                  {{0xbfd076fc, 0xe022dd0d} },
/**/                  {{0x3c6d8659, 0x5534523a} },
/**/                  {{0xbfc732ce, 0x3a201d6b} },
/**/                  {{0xbc56a551, 0xc98a3a62} },
/**/                  {{0x3fc8d67c, 0x673a29b8} },
/**/                  {{0xbc54ae9d, 0xff95efe6} },
/**/                  {{0x3f882eee, 0x74ce6814} },
/**/                  {{0xbfbfa83b, 0x503ba8f4} },
/**/                  {{0x3faaa39c, 0x60b63f75} },
/**/                  {{0x3fae38b8, 0xf07ff274} },
/**/                  {{0xbfb1072c, 0x2200fe4d} } },
/**/                 {{{0x3fd40000, 0x00000000} },
/**/                  {{0x3fd36277, 0x3707ebcc} },
/**/                  {{0xbc6963a5, 0x44b672d8} },
/**/                  {{0x3fed272c, 0xa3fc5b1a} },
/**/                  {{0x3c8ae01d, 0x272ca3fc} },
/**/                  {{0xbfd0997e, 0x8aec9d8e} },
/**/                  {{0x3c74aeda, 0x72595f36} },
/**/                  {{0xbfc6cf66, 0x66d5c0ff} },
/**/                  {{0x3c410e2a, 0x3ca66cc1} },
/**/                  {{0x3fc8dd1e, 0x8f2617b5} },
/**/                  {{0xbc6d173e, 0x4facfb67} },
/**/                  {{0x3f82483b, 0x33966883} },
/**/                  {{0xbfbf495d, 0x2b05b16b} },
/**/                  {{0x3fab9096, 0x074fdeaf} },
/**/                  {{0x3fad0571, 0x9c4605c9} },
/**/                  {{0xbfb11c35, 0x280318fd} } },
/**/                 {{{0x3fd44000, 0x00000000} },
/**/                  {{0x3fd39cb4, 0xeb76157c} },
/**/                  {{0xbc72f4da, 0x5a214713} },
/**/                  {{0x3fed1682, 0x22c31625} },
/**/                  {{0x3c8ac111, 0xd5e51b41} },
/**/                  {{0xbfd0bb6b, 0x07e9a89a} },
/**/                  {{0x3c76fb53, 0x7faa1dda} },
/**/                  {{0xbfc66be7, 0xb75f0772} },
/**/                  {{0xbc69a77d, 0xee6d618b} },
/**/                  {{0x3fc8e1eb, 0x6e943d69} },
/**/                  {{0xbc6982c4, 0xc5ec9ebe} },
/**/                  {{0x3f78e73c, 0x9c2d3c0c} },
/**/                  {{0xbfbee752, 0x7059f387} },
/**/                  {{0x3fac73f0, 0x16982f58} },
/**/                  {{0x3fabd0e4, 0xc146b407} },
/**/                  {{0xbfb12b5c, 0x82f43254} } },
/**/                 {{{0x3fd48000, 0x00000000} },
/**/                  {{0x3fd3d6d1, 0x29271134} },
/**/                  {{0x3c7137ca, 0x41cc958a} },
/**/                  {{0x3fed05b5, 0xffb0304c} },
/**/                  {{0xbc8fc921, 0x33e896e5} },
/**/                  {{0xbfd0dcc2, 0x3a49e254} },
/**/                  {{0x3c704578, 0x925cb599} },
/**/                  {{0xbfc60859, 0x75708502} },
/**/                  {{0xbc5f88bc, 0x9feebe6c} },
/**/                  {{0x3fc8e4e8, 0xc3fb5c1c} },
/**/                  {{0x3c6de114, 0xd6b77a05} },
/**/                  {{0x3f6ac6b3, 0xdbc6c857} },
/**/                  {{0xbfbe823c, 0xdeabd793} },
/**/                  {{0x3fad4da2, 0x06fb52a7} },
/**/                  {{0x3faa9b7b, 0x2bea698c} },
/**/                  {{0xbfb134c0, 0xeb32d745} } },
/**/                 {{{0x3fd4c000, 0x00000000} },
/**/                  {{0x3fd410cb, 0xad6c7d33} },
/**/                  {{0xbc7b0c8b, 0xae13b512} },
/**/                  {{0x3fecf4c8, 0xd0182625} },
/**/                  {{0x3c8e6308, 0xf4103798} },
/**/                  {{0xbfd0fd84, 0x101a5438} },
/**/                  {{0x3c425fcd, 0x7d2e3e34} },
/**/                  {{0xbfc5a4c2, 0xd36904f6} },
/**/                  {{0x3c5d3583, 0x54f27bb6} },
/**/                  {{0x3fc8e61c, 0x7b74b00c} },
/**/                  {{0x3c32f7ad, 0xefe568b6} },
/**/                  {{0x3f402f60, 0xaa3667f2} },
/**/                  {{0xbfbe1a3e, 0x4c9859c0} },
/**/                  {{0x3fae1da6, 0x8e77c589} },
/**/                  {{0x3fa9659b, 0x6ed5823e} },
/**/                  {{0xbfb13882, 0xf1d3d420} } },
/**/                 {{{0x3fd50000, 0x00000000} },
/**/                  {{0x3fd44aa4, 0x36c2af0a} },
/**/                  {{0xbc75d5e4, 0x3c55b3ba} },
/**/                  {{0x3fece3bb, 0x295c0773} },
/**/                  {{0xbc826fd5, 0x91851b41} },
/**/                  {{0xbfd11db0, 0x8221a582} },
/**/                  {{0x3c7e9654, 0xa9f31d11} },
/**/                  {{0xbfc5412a, 0xeb9ef661} },
/**/                  {{0x3c573faf, 0x5e60433c} },
/**/                  {{0x3fc8e58c, 0xacc06b3a} },
/**/                  {{0xbc5dba9a, 0x64dd81ed} },
/**/                  {{0xbf625ff7, 0xcfe3f01e} },
/**/                  {{0xbfbdaf78, 0x9dae4b1c} },
/**/                  {{0x3faee3fb, 0x8e4e3e16} },
/**/                  {{0x3fa82fa9, 0xc2c60fed} },
/**/                  {{0xbfb136c4, 0xe13555d9} } },
/**/                 {{{0x3fd54000, 0x00000000} },
/**/                  {{0x3fd4845a, 0x84d0c21b} },
/**/                  {{0x3c71e28a, 0x7563c6a6} },
/**/                  {{0x3fecd28d, 0xa0decfad} },
/**/                  {{0xbc72b2c8, 0x49610c12} },
/**/                  {{0xbfd13d47, 0x93bb8da8} },
/**/                  {{0x3c5df07a, 0x1b48d912} },
/**/                  {{0xbfc4dd98, 0xbfb5c8b7} },
/**/                  {{0x3c58a9ff, 0x39a108d7} },
/**/                  {{0x3fc8e33f, 0x99496dc4} },
/**/                  {{0x3c380d8b, 0x19d3995c} },
/**/                  {{0xbf743d59, 0xba1bc2d2} },
/**/                  {{0xbfbd420d, 0xb77862a1} },
/**/                  {{0x3fafa0a1, 0xffb9511c} },
/**/                  {{0x3fa6fa07, 0xe8a86cad} },
/**/                  {{0xbfb12faa, 0x9d75a109} } },
/**/                 {{{0x3fd58000, 0x00000000} },
/**/                  {{0x3fd4bdee, 0x586890e7} },
/**/                  {{0xbc6e4dc7, 0x7c22a757} },
/**/                  {{0x3fecc140, 0xcbfae3a7} },
/**/                  {{0xbc41045d, 0xd8b6f9b9} },
/**/                  {{0xbfd15c49, 0x52b34cdc} },
/**/                  {{0x3c729992, 0x2daa60ac} },
/**/                  {{0xbfc47a13, 0x37fb39ef} },
/**/                  {{0x3c5cb3b2, 0x3482d371} },
/**/                  {{0x3fc8df3b, 0xaa28e022} },
/**/                  {{0xbc61a8ab, 0x969a5447} },
/**/                  {{0xbf7f2135, 0xc651ecb4} },
/**/                  {{0xbfbcd21f, 0x76cc63f7} },
/**/                  {{0x3fb029ce, 0xefdf4de1} },
/**/                  {{0x3fa5c515, 0x0de3bf96} },
/**/                  {{0xbfb12359, 0x84e55ab4} } },
/**/                 {{{0x3fd5c000, 0x00000000} },
/**/                  {{0x3fd4f75f, 0x73869979} },
/**/                  {{0xbc595a1c, 0xf7ff1108} },
/**/                  {{0x3fecafd5, 0x3ff7b52c} },
/**/                  {{0x3c86e099, 0x684b6314} },
/**/                  {{0xbfd17ab5, 0xd71d366e} },
/**/                  {{0x3c602f2c, 0xae2f7b71} },
/**/                  {{0xbfc416a1, 0x22cc956f} },
/**/                  {{0x3c61d29e, 0xe98c24c1} },
/**/                  {{0x3fc8d987, 0x6e2a4f9f} },
/**/                  {{0xbc60de73, 0x4a6a7880} },
/**/                  {{0xbf84ed52, 0x909e42ec} },
/**/                  {{0xbfbc5fcf, 0xa56263a8} },
/**/                  {{0x3fb07e7b, 0x0d159803} },
/**/                  {{0x3fa4912d, 0xb2ddf20b} },
/**/                  {{0xbfb111f8, 0x508c8585} } },
/**/                 {{{0x3fd60000, 0x00000000} },
/**/                  {{0x3fd530ad, 0x9951cd4a} },
/**/                  {{0xbc625664, 0x80884082} },
/**/                  {{0x3fec9e4b, 0x91ff8d87} },
/**/                  {{0xbc7723ff, 0x1b0da370} },
/**/                  {{0xbfd1988d, 0x432f5908} },
/**/                  {{0x3c7d065e, 0xf8714cda} },
/**/                  {{0xbfc3b349, 0x3403e07c} },
/**/                  {{0x3c6b571d, 0x2717fbb0} },
/**/                  {{0x3fc8d229, 0x97d0e938} },
/**/                  {{0x3c66b228, 0xb08a0625} },
/**/                  {{0xbf8a3464, 0xc2fe9cde} },
/**/                  {{0xbfbbeb3f, 0xefb6f244} },
/**/                  {{0x3fb0ce5a, 0x39e67c0b} },
/**/                  {{0x3fa35eab, 0x93b4fb73} },
/**/                  {{0xbfb0fbae, 0xf4d86f78} } },
/**/                 {{{0x3fd64000, 0x00000000} },
/**/                  {{0x3fd569d8, 0x8e1b4cd8} },
/**/                  {{0xbc6fec61, 0xe713cfe2} },
/**/                  {{0x3fec8ca4, 0x57157fc9} },
/**/                  {{0x3c70da14, 0x515734ba} },
/**/                  {{0xbfd1b5cf, 0xc3195094} },
/**/                  {{0x3c740cce, 0xa9537e45} },
/**/                  {{0xbfc35012, 0x046cee83} },
/**/                  {{0xbc651b6c, 0xe446fd10} },
/**/                  {{0x3fc8c928, 0xfb5e6a95} },
/**/                  {{0x3c656cd2, 0x82469bf3} },
/**/                  {{0xbf8f6568, 0xa4afbb1b} },
/**/                  {{0xbfbb7491, 0xdb3aba50} },
/**/                  {{0x3fb11972, 0xb9fd56ec} },
/**/                  {{0x3fa22de5, 0x9329e15e} },
/**/                  {{0xbfb0e0a6, 0x8287d93d} } },
/**/                 {{{0x3fd68000, 0x00000000} },
/**/                  {{0x3fd5a2e0, 0x175e0f4e} },
/**/                  {{0x3c713b7a, 0x8f82e457} },
/**/                  {{0x3fec7ae0, 0x240b83ae} },
/**/                  {{0xbc885b56, 0x10d398ed} },
/**/                  {{0xbfd1d27d, 0x8cdb4db0} },
/**/                  {{0x3c11d95f, 0x2db0447f} },
/**/                  {{0xbfc2ed02, 0x11425541} },
/**/                  {{0xbc11d124, 0x6b2cbaa3} },
/**/                  {{0x3fc8be8c, 0x8cdc5c4d} },
/**/                  {{0xbc542511, 0x794444b0} },
/**/                  {{0xbf923ffd, 0xd25a5415} },
/**/                  {{0xbfbafbe6, 0xbcd1df44} },
/**/                  {{0x3fb15fcc, 0x26bdf05c} },
/**/                  {{0x3fa0ff2f, 0xa7b853e6} },
/**/                  {{0xbfb0c109, 0x07e9a35f} } },
/**/                 {{{0x3fd6c000, 0x00000000} },
/**/                  {{0x3fd5dbc3, 0xfbbe768d} },
/**/                  {{0x3c6ea0ec, 0x1b76f7da} },
/**/                  {{0x3fec68ff, 0x8d78b9ce} },
/**/                  {{0xbc83ab41, 0x4cb5a0c3} },
/**/                  {{0xbfd1ee96, 0xe01c5e6e} },
/**/                  {{0x3c73922c, 0xfb76d8dd} },
/**/                  {{0xbfc28a1f, 0xbbb23677} },
/**/                  {{0x3c6e592a, 0x288601f2} },
/**/                  {{0x3fc8b25b, 0x5e282403} },
/**/                  {{0xbbef7d58, 0x707e09fa} },
/**/                  {{0xbf94c1e0, 0xb65add31} },
/**/                  {{0xbfba815f, 0xafa52f1b} },
/**/                  {{0x3fb1a16f, 0x63712acc} },
/**/                  {{0x3f9fa5b5, 0x95a8d3ad} },
/**/                  {{0xbfb09d01, 0x72814750} } },
/**/                 {{{0x3fd70000, 0x00000000} },
/**/                  {{0x3fd61484, 0x0309cfe2} },
/**/                  {{0xbc7a7257, 0x15711f00} },
/**/                  {{0x3fec5703, 0x27afd9eb} },
/**/                  {{0x3c63c2ab, 0xb32c1d72} },
/**/                  {{0xbfd20a1c, 0x06000419} },
/**/                  {{0xbc7b5fe7, 0xf51a3a28} },
/**/                  {{0xbfc22771, 0x486ad2c8} },
/**/                  {{0xbc499ab5, 0xf84a7eae} },
/**/                  {{0x3fc8a49c, 0x9d027817} },
/**/                  {{0xbc53fcab, 0x2e376ecc} },
/**/                  {{0xbf973831, 0xeaabcb23} },
/**/                  {{0xbfba051d, 0x8c46fbce} },
/**/                  {{0x3fb1de66, 0x9132e9cc} },
/**/                  {{0x3f9d5269, 0xd48d5d65} },
/**/                  {{0xbfb074bb, 0x712354a4} } },
/**/                 {{{0x3fd74000, 0x00000000} },
/**/                  {{0x3fd64d1f, 0xf635c1c6} },
/**/                  {{0xbc7fa403, 0xe7c0fdbe} },
/**/                  {{0x3fec44eb, 0x86b5cbf8} },
/**/                  {{0xbc6a4101, 0xbc5b562d} },
/**/                  {{0xbfd2250d, 0x50fb21ad} },
/**/                  {{0xbc750066, 0xa39bdc1a} },
/**/                  {{0xbfc1c4fc, 0xdf2ed728} },
/**/                  {{0x3c6a87bb, 0x006772e9} },
/**/                  {{0x3fc89557, 0x9122b9b7} },
/**/                  {{0xbc05454e, 0x45b04f75} },
/**/                  {{0xbf99a2c9, 0x6c7888f1} },
/**/                  {{0xbfb98740, 0xe02d36ad} },
/**/                  {{0x3fb216bd, 0x02a99665} },
/**/                  {{0x3f9b0511, 0xb73aeccb} },
/**/                  {{0xbfb04863, 0x569b1738} } },
/**/                 {{{0x3fd78000, 0x00000000} },
/**/                  {{0x3fd68597, 0x9f5fa6fe} },
/**/                  {{0xbc425781, 0x4d1ada9c} },
/**/                  {{0x3fec32b9, 0x3e386c7f} },
/**/                  {{0x3c756033, 0x8cbaa5bf} },
/**/                  {{0xbfd23f6b, 0x1ca84e79} },
/**/                  {{0x3c604cc0, 0xf123d574} },
/**/                  {{0xbfc162c8, 0x8a715435} },
/**/                  {{0x3c5cf6db, 0x454fb8fd} },
/**/                  {{0x3fc88493, 0x9a4eb534} },
/**/                  {{0xbc668a5c, 0x42b959b0} },
/**/                  {{0xbf9c0182, 0x42580bb5} },
/**/                  {{0xbfb907e9, 0xe5822d56} },
/**/                  {{0x3fb24a7f, 0x2f8f8273} },
/**/                  {{0x3f98be3c, 0xa3527f46} },
/**/                  {{0xbfb01825, 0xfce97270} } },
/**/                 {{{0x3fd7c000, 0x00000000} },
/**/                  {{0x3fd6bdea, 0xc9cbd76d} },
/**/                  {{0xbc5a5c56, 0x3e6de828} },
/**/                  {{0x3fec206c, 0xe1857d04} },
/**/                  {{0xbc80439f, 0xf5c83872} },
/**/                  {{0xbfd25935, 0xcd9b9870} },
/**/                  {{0x3c6aaf98, 0xf1ec7306} },
/**/                  {{0xbfc100da, 0x36f94d02} },
/**/                  {{0xbc6e72ca, 0xd96d84ff} },
/**/                  {{0x3fc87258, 0x2e774351} },
/**/                  {{0x3c6c50a2, 0xb8860ef0} },
/**/                  {{0xbf9e543a, 0x741ef0ec} },
/**/                  {{0xbfb88738, 0x7b4d0ec2} },
/**/                  {{0x3fb279ba, 0xa8164103} },
/**/                  {{0x3f967e73, 0xa7f1ae35} },
/**/                  {{0xbfafc861, 0x5257c3de} } },
/**/                 {{{0x3fd80000, 0x00000000} },
/**/                  {{0x3fd6f619, 0x41e4def1} },
/**/                  {{0xbc7c63aa, 0xe6f6e918} },
/**/                  {{0x3fec0e07, 0x0381c0e0} },
/**/                  {{0x3c8c0e07, 0x0381c0e0} },
/**/                  {{0xbfd2726d, 0xd135c174} },
/**/                  {{0xbc2d352d, 0xe0951cf8} },
/**/                  {{0xbfc09f37, 0xb38cc8cf} },
/**/                  {{0xbc69db81, 0xae75327f} },
/**/                  {{0x3fc85eac, 0xd7da413c} },
/**/                  {{0x3c5b1a89, 0x6ebae2bc} },
/**/                  {{0xbfa04d69, 0x80fcc815} },
/**/                  {{0xbfb8054c, 0x1df326f9} },
/**/                  {{0x3fb2a47e, 0x082bda60} },
/**/                  {{0x3f944639, 0x7091d5a4} },
/**/                  {{0xbfaf5961, 0xe072e48c} } },
/**/                 {{{0x3fd84000, 0x00000000} },
/**/                  {{0x3fd72e22, 0xd53aa2aa} },
/**/                  {{0xbc7d9c93, 0x4e79f27c} },
/**/                  {{0x3febfb88, 0x36a04729} },
/**/                  {{0xbc872745, 0x9ac2ea21} },
/**/                  {{0xbfd28b13, 0x9d7702cf} },
/**/                  {{0x3c7819b9, 0x4be8bff6} },
/**/                  {{0xbfc03de6, 0xb0a35176} },
/**/                  {{0x3c5dbfb0, 0xc83347af} },
/**/                  {{0x3fc84999, 0x332a4f86} },
/**/                  {{0x3c5d304e, 0x0a22d12d} },
/**/                  {{0xbfa16a97, 0xed6b2d30} },
/**/                  {{0xbfb78243, 0xe0128950} },
/**/                  {{0x3fb2cad8, 0xeaa98f57} },
/**/                  {{0x3f92160a, 0x3bb39c5b} },
/**/                  {{0xbfaee3a9, 0x3804caa3} } },
/**/                 {{{0x3fd88000, 0x00000000} },
/**/                  {{0x3fd76607, 0x52817502} },
/**/                  {{0xbc4dd117, 0x91cc7600} },
/**/                  {{0x3febe8f1, 0x0cd9e1fe} },
/**/                  {{0xbc7a9688, 0xa21e102a} },
/**/                  {{0xbfd2a327, 0xb0d161e9} },
/**/                  {{0xbc60a2a9, 0x14b44140} },
/**/                  {{0xbfbfb9d9, 0x803f8d3b} },
/**/                  {{0x3c5e5779, 0x2a5c4097} },
/**/                  {{0x3fc83324, 0xedbcc363} },
/**/                  {{0x3c651fbc, 0xa0442744} },
/**/                  {{0xbfa2819b, 0xe91477c3} },
/**/                  {{0xbfb6fe3e, 0x63b6abf0} },
/**/                  {{0x3fb2ecdb, 0xdc73a89a} },
/**/                  {{0x3f8fdcb7, 0xaa755298} },
/**/                  {{0xbfae6793, 0x237c2f3d} } },
/**/                 {{{0x3fd8c000, 0x00000000} },
/**/                  {{0x3fd79dc6, 0x899118d1} },
/**/                  {{0x3c2b7413, 0xa0ef606d} },
/**/                  {{0x3febd642, 0x17a4cbc3} },
/**/                  {{0xbc55ee5d, 0x3200a548} },
/**/                  {{0xbfd2baaa, 0x91faa133} },
/**/                  {{0xbc6bd391, 0xfaf41548} },
/**/                  {{0xbfbef89e, 0xaa22d832} },
/**/                  {{0x3c413b3b, 0xc874fdb9} },
/**/                  {{0x3fc81b57, 0xc3be300a} },
/**/                  {{0x3c6baf9b, 0xc01a615f} },
/**/                  {{0xbfa3926a, 0x4a872ec7} },
/**/                  {{0xbfb67959, 0xd3e743cd} },
/**/                  {{0x3fb30a98, 0x4f919505} },
/**/                  {{0x3f8b9f3b, 0x28b78b08} },
/**/                  {{0xbfade57b, 0x71e33e9d} } },
/**/                 {{{0x3fd90000, 0x00000000} },
/**/                  {{0x3fd7d560, 0x4b63b3f7} },
/**/                  {{0x3c769c88, 0x5c2b249a} },
/**/                  {{0x3febc37b, 0xe7ec7a8d} },
/**/                  {{0xbc6f1246, 0x2b0e2727} },
/**/                  {{0xbfd2d19c, 0xcfbdd7fa} },
/**/                  {{0x3c7d0b11, 0x5e00c582} },
/**/                  {{0xbfbe3827, 0x86f8309b} },
/**/                  {{0x3c5d64e9, 0xfa6c56a7} },
/**/                  {{0x3fc80239, 0x7e6de8de} },
/**/                  {{0x3c68d62f, 0x7776e849} },
/**/                  {{0xbfa49cf9, 0x4f6d8017} },
/**/                  {{0xbfb5f3b3, 0xde917e27} },
/**/                  {{0x3fb32420, 0x8e455cc2} },
/**/                  {{0x3f877470, 0xb9fc88fe} },
/**/                  {{0xbfad5dbd, 0xc6b10536} } },
/**/                 {{{0x3fd94000, 0x00000000} },
/**/                  {{0x3fd80cd4, 0x6a14b1d1} },
/**/                  {{0xbc7e79f9, 0x9684fa19} },
/**/                  {{0x3febb09f, 0x0e09a222} },
/**/                  {{0x3c85748e, 0x7e047edd} },
/**/                  {{0xbfd2e7ff, 0x00ccbbc8} },
/**/                  {{0xbc78eb0a, 0x96875561} },
/**/                  {{0xbfbd787e, 0x804ecc06} },
/**/                  {{0xbc27263b, 0x2e4351f8} },
/**/                  {{0x3fc7e7d1, 0xf260d7b4} },
/**/                  {{0xbc430525, 0x8ed258e3} },
/**/                  {{0xbfa5a140, 0x968d3d02} },
/**/                  {{0xbfb56d69, 0xaecb845e} },
/**/                  {{0x3fb33987, 0xae292f95} },
/**/                  {{0x3f835d1d, 0x48e09ecd} },
/**/                  {{0xbfacd0b5, 0x6b6f9aca} } },
/**/                 {{{0x3fd98000, 0x00000000} },
/**/                  {{0x3fd84422, 0xb8df95d7} },
/**/                  {{0x3c7d76a0, 0x299b41b6} },
/**/                  {{0x3feb9dac, 0x19ba64d6} },
/**/                  {{0xbc4f643a, 0xa13ee09f} },
/**/                  {{0xbfd2fdd1, 0xc390a5c9} },
/**/                  {{0x3c575152, 0xaa856fcc} },
/**/                  {{0xbfbcb9ad, 0xc0e99751} },
/**/                  {{0x3c4e2d44, 0x1347a357} },
/**/                  {{0x3fc7cc28, 0xfdcbfd40} },
/**/                  {{0x3c60dc32, 0xe516db08} },
/**/                  {{0xbfa69f39, 0x19851d86} },
/**/                  {{0xbfb4e697, 0xe772087d} },
/**/                  {{0x3fb34ae1, 0x835992de} },
/**/                  {{0x3f7eb3f1, 0xe5326389} },
/**/                  {{0xbfac3ebd, 0x234575e8} } },
/**/                 {{{0x3fd9c000, 0x00000000} },
/**/                  {{0x3fd87b4b, 0x0c1ebedc} },
/**/                  {{0xbc76dcfa, 0xa2fa470f} },
/**/                  {{0x3feb8aa3, 0x9a1ab378} },
/**/                  {{0x3c8efdb0, 0xb797ab93} },
/**/                  {{0xbfd31315, 0xbdfb5e5a} },
/**/                  {{0x3c5813a8, 0x862f0c0d} },
/**/                  {{0xbfbbfbbf, 0x3478f169} },
/**/                  {{0xbc51e810, 0xd9e52582} },
/**/                  {{0x3fc7af46, 0x86d6ec76} },
/**/                  {{0xbc6336de, 0x3c13b159} },
/**/                  {{0xbfa796dd, 0x264b8050} },
/**/                  {{0xbfb45f5a, 0x9e1f6bef} },
/**/                  {{0x3fb35842, 0x93b26fc1} },
/**/                  {{0x3f76d75e, 0x39bc3abf} },
/**/                  {{0xbfaba82f, 0x006e38b2} } },
/**/                 {{{0x3fda0000, 0x00000000} },
/**/                  {{0x3fd8b24d, 0x394a1b25} },
/**/                  {{0x3c7b6d0b, 0xa3748fa8} },
/**/                  {{0x3feb7786, 0x1d9cdc98} },
/**/                  {{0xbc62e22c, 0x345bd7a8} },
/**/                  {{0xbfd327cb, 0x9d57b8f5} },
/**/                  {{0xbc135343, 0x753cc4f1} },
/**/                  {{0xbfbb3ebc, 0x8761b154} },
/**/                  {{0x3c5abeec, 0x8c168fdd} },
/**/                  {{0x3fc79132, 0x79f68c54} },
/**/                  {{0xbc658ab9, 0xd8d15eda} },
/**/                  {{0xbfa88828, 0x5872d73c} },
/**/                  {{0xbfb3d7cd, 0x567be750} },
/**/                  {{0x3fb361c0, 0x0a24fc71} },
/**/                  {{0x3f6e4b7a, 0x46aa98b6} },
/**/                  {{0xbfab0d64, 0x3bad3a76} } },
/**/                 {{{0x3fda4000, 0x00000000} },
/**/                  {{0x3fd8e929, 0x16f5cde8} },
/**/                  {{0x3c74c0a7, 0xe12bfafb} },
/**/                  {{0x3feb6454, 0x32024b37} },
/**/                  {{0xbc7987f7, 0x69cc9b53} },
/**/                  {{0xbfd33bf4, 0x161a0a40} },
/**/                  {{0x3c7a2321, 0x83ff46db} },
/**/                  {{0xbfba82af, 0x26913418} },
/**/                  {{0x3c3c4c62, 0x10a559fe} },
/**/                  {{0x3fc771f4, 0xc8506679} },
/**/                  {{0xbc54aaed, 0x63c7ccc3} },
/**/                  {{0xbfa97317, 0x9237e7ff} },
/**/                  {{0xbfb3500a, 0xfde5f112} },
/**/                  {{0x3fb3676f, 0xaa2c3459} },
/**/                  {{0x3f5e80cd, 0x04721907} },
/**/                  {{0xbfaa6eb5, 0x0dc212a5} } },
/**/                 {{{0x3fda8000, 0x00000000} },
/**/                  {{0x3fd91fde, 0x7cd0c662} },
/**/                  {{0x3c710741, 0x88054b53} },
/**/                  {{0x3feb510e, 0x6454751c} },
/**/                  {{0xbc199bfd, 0x7e0f2dca} },
/**/                  {{0xbfd34f8f, 0xe3b081f4} },
/**/                  {{0x3c7d7209, 0x3e2c0515} },
/**/                  {{0xbfb9c7a0, 0x3f5e2d2f} },
/**/                  {{0xbc20b02e, 0xea3bd312} },
/**/                  {{0x3fc75195, 0x6626c39a} },
/**/                  {{0x3c6f30d2, 0xb4219a8a} },
/**/                  {{0xbfaa57a8, 0xf55dfea5} },
/**/                  {{0xbfb2c82d, 0xe771fa17} },
/**/                  {{0x3fb36967, 0xc3654ab4} },
/**/                  {{0x3f11f322, 0xa23eb6eb} },
/**/                  {{0xbfa9cc78, 0x8ae579b1} } },
/**/                 {{{0x3fdac000, 0x00000000} },
/**/                  {{0x3fd9566d, 0x43a34907} },
/**/                  {{0x3c69b015, 0x37e0af2b} },
/**/                  {{0x3feb3db5, 0x40ddf8d3} },
/**/                  {{0xbc616f46, 0x793c10b8} },
/**/                  {{0xbfd3629f, 0xc8537217} },
/**/                  {{0x3c505738, 0x38143614} },
/**/                  {{0xbfb90d98, 0xbf75f20a} },
/**/                  {{0x3c4dc715, 0x6b842647} },
/**/                  {{0x3fc7301c, 0x494dd1e6} },
/**/                  {{0x3c5ec3d6, 0xf49f85b4} },
/**/                  {{0xbfab35db, 0xdbdd23b1} },
/**/                  {{0xbfb2404f, 0xc8407216} },
/**/                  {{0x3fb367bf, 0x255139f9} },
/**/                  {{0xbf5b8a0d, 0x65acd6da} },
/**/                  {{0xbfa92704, 0x8052f51d} } },
/**/                 {{{0x3fdb0000, 0x00000000} },
/**/                  {{0x3fd98cd5, 0x454d6b18} },
/**/                  {{0x3c79e6c9, 0x88fd0a77} },
/**/                  {{0x3feb2a49, 0x5323eb6a} },
/**/                  {{0xbc572202, 0x70cc9678} },
/**/                  {{0xbfd37524, 0x8cd58cc4} },
/**/                  {{0x3c6978a3, 0xda42aa4e} },
/**/                  {{0xbfb854a1, 0x54d5f784} },
/**/                  {{0xbc5e9a15, 0xb33b3d0d} },
/**/                  {{0x3fc70d91, 0x67aa0c46} },
/**/                  {{0xbc6aa72f, 0xa4ac9df8} },
/**/                  {{0xbfac0db0, 0xd0665a46} },
/**/                  {{0xbfb1b889, 0xb428e30d} },
/**/                  {{0x3fb3628d, 0x134448b0} },
/**/                  {{0xbf6bbbc1, 0x67619c9c} },
/**/                  {{0xbfa87ead, 0x53e1f653} } },
/**/                 {{{0x3fdb4000, 0x00000000} },
/**/                  {{0x3fd9c316, 0x5cc58107} },
/**/                  {{0x3c4b6696, 0x02250cfb} },
/**/                  {{0x3feb16cb, 0x25df55f4} },
/**/                  {{0xbc653abc, 0xf48e26bc} },
/**/                  {{0xbfd3871f, 0x00742189} },
/**/                  {{0xbc725ae2, 0xc05df451} },
/**/                  {{0xbfb79cc2, 0x6dd13675} },
/**/                  {{0x3be1d4e0, 0x991905e4} },
/**/                  {{0x3fc6e9fc, 0xb5b8147e} },
/**/                  {{0x3c46463b, 0xa57d4eca} },
/**/                  {{0xbfacdf29, 0x86c1db89} },
/**/                  {{0xbfb130f4, 0x1ab8d1c4} },
/**/                  {{0x3fb359e9, 0x38881228} },
/**/                  {{0xbf74a987, 0x53bec2ff} },
/**/                  {{0xbfa7d3c5, 0xe5af58b6} } },
/**/                 {{{0x3fdb8000, 0x00000000} },
/**/                  {{0x3fd9f930, 0x66168002} },
/**/                  {{0xbc7c8270, 0x47c9439a} },
/**/                  {{0x3feb033b, 0x42f6e2c9} },
/**/                  {{0xbc6eb80c, 0xc48702a7} },
/**/                  {{0xbfd3988f, 0xf8a76337} },
/**/                  {{0xbc636968, 0x5b1bb38a} },
/**/                  {{0xbfb6e604, 0x39212b04} },
/**/                  {{0xbc3c2e20, 0xba255e71} },
/**/                  {{0x3fc6c566, 0x251e2d41} },
/**/                  {{0x3c230ab3, 0x47236369} },
/**/                  {{0xbfadaa48, 0xd40b3417} },
/**/                  {{0xbfb0a9a6, 0xc484f2cc} },
/**/                  {{0x3fb34deb, 0x9cb4573e} },
/**/                  {{0xbf7b44ca, 0x1def6f17} },
/**/                  {{0xbfa7269f, 0x73d683b8} } },
/**/                 {{{0x3fdbc000, 0x00000000} },
/**/                  {{0x3fda2f23, 0x3e5e530b} },
/**/                  {{0x3c5814d5, 0xf797086b} },
/**/                  {{0x3feaef9a, 0x3378ba79} },
/**/                  {{0x3c7da16a, 0x4476e241} },
/**/                  {{0xbfd3a978, 0x50f2beab} },
/**/                  {{0x3c7b7e7f, 0xad5a31ea} },
/**/                  {{0xbfb6306e, 0xa602212f} },
/**/                  {{0xbc31ec15, 0x9ec38d55} },
/**/                  {{0x3fc69fd5, 0xa3477c6a} },
/**/                  {{0x3c571f2f, 0xb2996038} },
/**/                  {{0xbfae6f12, 0xa6cf162d} },
/**/                  {{0xbfb022b8, 0xd0cb2655} },
/**/                  {{0x3fb33eac, 0x9842912f} },
/**/                  {{0xbf80d789, 0x4919e78d} },
/**/                  {{0xbfa67789, 0x8037e242} } },
/**/                 {{{0x3fdc0000, 0x00000000} },
/**/                  {{0x3fda64ee, 0xc3cc23fd} },
/**/                  {{0xbc724dec, 0x1b50b7ff} },
/**/                  {{0x3feadbe8, 0x7f94905e} },
/**/                  {{0x3c2adbe8, 0x7f94905e} },
/**/                  {{0xbfd3b9d8, 0xeab54af9} },
/**/                  {{0x3c75b97d, 0x54fd0941} },
/**/                  {{0xbfb57c09, 0x645a7f9e} },
/**/                  {{0xbc5e79f6, 0x09320811} },
/**/                  {{0x3fc67953, 0x180938f2} },
/**/                  {{0x3c6246f2, 0xe7aee726} },
/**/                  {{0xbfaf2d8b, 0xff0ea012} },
/**/                  {{0xbfaf3881, 0x66c7250c} },
/**/                  {{0x3fb32c44, 0xc95ff694} },
/**/                  {{0xbf83f3f0, 0x25d7ff49} },
/**/                  {{0xbfa5c6d1, 0xb848e1d1} } },
/**/                 {{{0x3fdc4000, 0x00000000} },
/**/                  {{0x3fda9a92, 0xd59e98cf} },
/**/                  {{0x3c42e42d, 0xff75d817} },
/**/                  {{0x3feac826, 0xae95dea9} },
/**/                  {{0xbc534eec, 0x633dec57} },
/**/                  {{0xbfd3c9b2, 0xacfa5b18} },
/**/                  {{0x3c7a7e0c, 0x6c4d8d27} },
/**/                  {{0xbfb4c8db, 0xe4ecc0f6} },
/**/                  {{0xbc534990, 0xc0c32772} },
/**/                  {{0x3fc651e6, 0x6451e377} },
/**/                  {{0xbc6ea814, 0x2a9bb1f1} },
/**/                  {{0xbfafe5ba, 0xe62bc1b2} },
/**/                  {{0xbfae2ca8, 0x65fe3642} },
/**/                  {{0x3fb316cd, 0x09015968} },
/**/                  {{0xbf86f764, 0x3ce97a26} },
/**/                  {{0xbfa514c3, 0xdee8421b} } },
/**/                 {{{0x3fdc8000, 0x00000000} },
/**/                  {{0x3fdad00f, 0x5422058b} },
/**/                  {{0x3c7fc4c3, 0x3891d2e8} },
/**/                  {{0x3feab455, 0x46de51cf} },
/**/                  {{0xbc5b834a, 0xdbc38cc9} },
/**/                  {{0xbfd3d906, 0x844a38eb} },
/**/                  {{0x3c6198e5, 0xbc44eee8} },
/**/                  {{0xbfb416ed, 0x5993cade} },
/**/                  {{0xbc235ccb, 0xfa289b6c} },
/**/                  {{0x3fc62997, 0x60e2a3af} },
/**/                  {{0xbc69a660, 0xcf7bda0e} },
/**/                  {{0xbfb04bd3, 0x33612b72} },
/**/                  {{0xbfad2210, 0xcf62bcd9} },
/**/                  {{0x3fb2fe5e, 0x603bfc37} },
/**/                  {{0xbf89e1ba, 0xa9bce7ec} },
/**/                  {{0xbfa461a9, 0xb83029d5} } },
/**/                 {{{0x3fdcc000, 0x00000000} },
/**/                  {{0x3fdb0564, 0x20ae9344} },
/**/                  {{0xbc793139, 0x46363455} },
/**/                  {{0x3feaa074, 0xcde0631f} },
/**/                  {{0x3c84b49a, 0x143fe6d4} },
/**/                  {{0xbfd3e7d5, 0x627b115b} },
/**/                  {{0x3c77a502, 0x332989c0} },
/**/                  {{0xbfb36644, 0xb589513f} },
/**/                  {{0x3c3abdc9, 0x105eec96} },
/**/                  {{0x3fc6006d, 0xdd12e0be} },
/**/                  {{0xbc4f0281, 0x5d67cb35} },
/**/                  {{0xbfb0a1ab, 0x4238ba83} },
/**/                  {{0xbfac18e3, 0x73889526} },
/**/                  {{0x3fb2e311, 0xfde6351a} },
/**/                  {{0xbf8cb2d2, 0xc256833f} },
/**/                  {{0xbfa3adca, 0xf73e36f0} } },
/**/                 {{{0x3fdd0000, 0x00000000} },
/**/                  {{0x3fdb3a91, 0x1da65c6c} },
/**/                  {{0x3c7ae187, 0xb1ca5040} },
/**/                  {{0x3fea8c85, 0xc81a2254} },
/**/                  {{0xbc83c191, 0x8d67728b} },
/**/                  {{0xbfd3f620, 0x3e8218e0} },
/**/                  {{0xbc72bf32, 0x52bd43ef} },
/**/                  {{0xbfb2b6e8, 0xadb5f398} },
/**/                  {{0x3c340287, 0x6b74d451} },
/**/                  {{0x3fc5d671, 0x9d9e25fc} },
/**/                  {{0x3c639669, 0x518d7a71} },
/**/                  {{0xbfb0f46a, 0x19cc29a0} },
/**/                  {{0xbfab1147, 0xc1a69750} },
/**/                  {{0x3fb2c501, 0x2c826e6b} },
/**/                  {{0xbf8f6a95, 0xcbc1b186} },
/**/                  {{0xbfa2f96d, 0x2de89811} } },
/**/                 {{{0x3fdd4000, 0x00000000} },
/**/                  {{0x3fdb6f96, 0x2e737efc} },
/**/                  {{0xbc5ca534, 0x64981e71} },
/**/                  {{0x3fea7888, 0xb9102ddc} },
/**/                  {{0xbc7791b2, 0x3c46d7d5} },
/**/                  {{0xbfd403e8, 0x1444efb5} },
/**/                  {{0xbc6047c5, 0x4f3d22a6} },
/**/                  {{0xbfb208df, 0xb90ac1cc} },
/**/                  {{0x3c4078b1, 0x2d2115d8} },
/**/                  {{0x3fc5abaa, 0x5b7c61a2} },
/**/                  {{0x3c3eef6a, 0x2bd2d19a} },
/**/                  {{0xbfb14414, 0xa8850e1a} },
/**/                  {{0xbfaa0b63, 0xc6580343} },
/**/                  {{0x3fb2a445, 0x4876cfdf} },
/**/                  {{0xbf91047b, 0x562d0829} },
/**/                  {{0xbfa244d3, 0xbe562a83} } },
/**/                 {{{0x3fdd8000, 0x00000000} },
/**/                  {{0x3fdba473, 0x378624a5} },
/**/                  {{0x3c7519a1, 0xb46e4aff} },
/**/                  {{0x3fea647e, 0x2348d9a3} },
/**/                  {{0xbc84f6c2, 0x9156e59f} },
/**/                  {{0xbfd4112d, 0xe46b4c91} },
/**/                  {{0xbc78c11d, 0x110fe0b7} },
/**/                  {{0xbfb15c30, 0x10e3d572} },
/**/                  {{0x3c53b45b, 0x4427c00b} },
/**/                  {{0x3fc5801f, 0xc2c486ae} },
/**/                  {{0xbc49bb5e, 0xc20ced8b} },
/**/                  {{0xbfb190b0, 0x4cddef65} },
/**/                  {{0xbfa9075c, 0x2ae4bcd0} },
/**/                  {{0x3fb280f7, 0xb69396b9} },
/**/                  {{0xbf9246f8, 0xce179ccb} },
/**/                  {{0xbfa1903f, 0xce6e9b2b} } },
/**/                 {{{0x3fddc000, 0x00000000} },
/**/                  {{0x3fdbd928, 0x1e528192} },
/**/                  {{0xbc74b154, 0x39af6b66} },
/**/                  {{0x3fea5066, 0x88478403} },
/**/                  {{0xbc85c7e8, 0xbe71620f} },
/**/                  {{0xbfd41df2, 0xb430f4ac} },
/**/                  {{0xbc55db82, 0xe79c7595} },
/**/                  {{0xbfb0b0df, 0xb173ac76} },
/**/                  {{0x3c57f440, 0xe4738d25} },
/**/                  {{0x3fc553d9, 0x7199976b} },
/**/                  {{0x3c54990c, 0x2a872a12} },
/**/                  {{0xbfb1da42, 0xd137dd01} },
/**/                  {{0xbfa80554, 0x350bfdb5} },
/**/                  {{0x3fb25b31, 0xdae9e17f} },
/**/                  {{0xbf937cc5, 0xe9e265b4} },
/**/                  {{0xbfa0dbf0, 0x3d16a202} } },
/**/                 {{{0x3fde0000, 0x00000000} },
/**/                  {{0x3fdc0db4, 0xc94ec9f0} },
/**/                  {{0xbc7cc1ce, 0x70934c34} },
/**/                  {{0x3fea3c42, 0x68881898} },
/**/                  {{0x3c8f907f, 0xe5c3bd97} },
/**/                  {{0xbfd42a37, 0x8d38076d} },
/**/                  {{0xbc6b8354, 0x7e19d62d} },
/**/                  {{0xbfb006f4, 0x5a36f1bd} },
/**/                  {{0xbc41701e, 0xca398c09} },
/**/                  {{0x3fc526de, 0xf7221a2a} },
/**/                  {{0xbc211868, 0x8041247e} },
/**/                  {{0xbfb220d2, 0x67b0229a} },
/**/                  {{0xbfa7056d, 0xc74d0c66} },
/**/                  {{0x3fb2330d, 0x0ff472e2} },
/**/                  {{0xbf94a5e9, 0x9cb74216} },
/**/                  {{0xbfa02821, 0x992b9e1f} } },
/**/                 {{{0x3fde4000, 0x00000000} },
/**/                  {{0x3fdc4219, 0x1ff11eb7} },
/**/                  {{0xbc7b17df, 0x434b3eee} },
/**/                  {{0x3fea2812, 0x437ac09e} },
/**/                  {{0xbc540368, 0xf9618c21} },
/**/                  {{0xbfd435fd, 0x7d5ba406} },
/**/                  {{0x3c75605b, 0x5e0a732a} },
/**/                  {{0xbfaebce7, 0x1ce0c104} },
/**/                  {{0xbc446d02, 0xd4eb3297} },
/**/                  {{0x3fc4f937, 0xd289f60b} },
/**/                  {{0x3c5b88b7, 0xe736fa8b} },
/**/                  {{0xbfb26465, 0xa5f78db4} },
/**/                  {{0xbfa607c9, 0x61a972db} },
/**/                  {{0x3fb208a2, 0x9e13b088} },
/**/                  {{0xbf95c26f, 0x06c33653} },
/**/                  {{0xbf9eea1c, 0x346237b1} } },
/**/                 {{{0x3fde8000, 0x00000000} },
/**/                  {{0x3fdc7655, 0x0aad71f9} },
/**/                  {{0xbc774b8b, 0xff7043e4} },
/**/                  {{0x3fea13d6, 0x977fc070} },
/**/                  {{0xbc86c451, 0xd9440881} },
/**/                  {{0xbfd44145, 0x9682eee2} },
/**/                  {{0x3c74156f, 0xb13901b4} },
/**/                  {{0xbfad6ec5, 0x2b58de73} },
/**/                  {{0x3c2ced26, 0xdf653988} },
/**/                  {{0x3fc4caeb, 0x720eb232} },
/**/                  {{0x3c614246, 0x92f3f809} },
/**/                  {{0xbfb2a503, 0x812caa81} },
/**/                  {{0xbfa50c86, 0x22dc20a7} },
/**/                  {{0x3fb1dc0b, 0xb35de59d} },
/**/                  {{0xbf96d265, 0x4adc8c38} },
/**/                  {{0xbf9d85db, 0x35444e0c} } },
/**/                 {{{0x3fdec000, 0x00000000} },
/**/                  {{0x3fdcaa68, 0x72f3631b} },
/**/                  {{0x3c295067, 0x81636f48} },
/**/                  {{0x3fe9ff8f, 0xe1e381db} },
/**/                  {{0xbc6fffe6, 0x00701e1c} },
/**/                  {{0xbfd44c10, 0xee747cac} },
/**/                  {{0xbc7a7f22, 0xced401ad} },
/**/                  {{0xbfac238c, 0xf898de26} },
/**/                  {{0x3c1eb191, 0xdaa7d32f} },
/**/                  {{0x3fc49c01, 0x32160e42} },
/**/                  {{0x3c649f02, 0x03d0023c} },
/**/                  {{0xbfb2e2b3, 0x49ba4fb7} },
/**/                  {{0xbfa413c1, 0xca00d6c7} },
/**/                  {{0x3fb1ad61, 0x5bc495cf} },
/**/                  {{0xbf97d5df, 0x63d0ff69} },
/**/                  {{0xbf9c23eb, 0x27af7010} } },
/**/                 {{{0x3fdf0000, 0x00000000} },
/**/                  {{0x3fdcde53, 0x432c1351} },
/**/                  {{0xbc7a2cfa, 0x4418f1ad} },
/**/                  {{0x3fe9eb3e, 0x9edacacc} },
/**/                  {{0xbc8942c5, 0x87d23ca5} },
/**/                  {{0xbfd45660, 0x9eaa285d} },
/**/                  {{0x3c4fe8e6, 0x52cf85b4} },
/**/                  {{0xbfaadb48, 0x28319af3} },
/**/                  {{0xbc207b46, 0x31b456b0} },
/**/                  {{0x3fc46c80, 0x5c4ee7c2} },
/**/                  {{0x3c4bdfc1, 0xb4443c76} },
/**/                  {{0xbfb31d7c, 0xa73bc33f} },
/**/                  {{0xbfa31d98, 0xb8a731f5} },
/**/                  {{0x3fb17cbc, 0x798f7481} },
/**/                  {{0xbf98ccf3, 0xf977e9ca} },
/**/                  {{0xbf9ac4b2, 0x36ea1578} } },
/**/                 {{{0x3fdf4000, 0x00000000} },
/**/                  {{0x3fdd1215, 0x66b7f2ad} },
/**/                  {{0x3c7be678, 0x35886c30} },
/**/                  {{0x3fe9d6e3, 0x497f1fed} },
/**/                  {{0xbc8ec056, 0x9a35c454} },
/**/                  {{0xbfd46035, 0xc4255988} },
/**/                  {{0x3c7ddb7b, 0x7144427c} },
/**/                  {{0xbfa995ff, 0xe9b44acd} },
/**/                  {{0x3c3c9d56, 0xb529cf65} },
/**/                  {{0x3fc43c70, 0x26dc5cda} },
/**/                  {{0x3c6d6ee6, 0xfde6cd82} },
/**/                  {{0xbfb35567, 0x9467b39a} },
/**/                  {{0xbfa22a25, 0xf54ca1ba} },
/**/                  {{0x3fb14a35, 0xbe2d5d2d} },
/**/                  {{0xbf99b7bd, 0x35a34e74} },
/**/                  {{0xbf996891, 0xc4948489} } },
/**/                 {{{0x3fdf8000, 0x00000000} },
/**/                  {{0x3fdd45ae, 0xc9ec862b} },
/**/                  {{0x3c689421, 0x163ef92d} },
/**/                  {{0x3fe9c27e, 0x5bcb52c7} },
/**/                  {{0xbc892d91, 0xf148a350} },
/**/                  {{0xbfd46991, 0x7f43bff0} },
/**/                  {{0xbc738b23, 0x8da13c27} },
/**/                  {{0xbfa853bc, 0xf9f19dcd} },
/**/                  {{0x3c2ea7a9, 0x2433c5cf} },
/**/                  {{0x3fc40bd7, 0xb38b19e0} },
/**/                  {{0xbc5d466e, 0x1c2a2863} },
/**/                  {{0xbfb38a7c, 0x5b0333a7} },
/**/                  {{0xbfa13983, 0x2e3896d7} },
/**/                  {{0x3fb115e5, 0xa35b7545} },
/**/                  {{0xbf9a9658, 0x99098556} },
/**/                  {{0xbf980fe6, 0x693ac59e} } },
/**/                 {{{0x3fdfc000, 0x00000000} },
/**/                  {{0x3fdd791f, 0x5a1226f5} },
/**/                  {{0xbc64017e, 0xa5b64a76} },
/**/                  {{0x3fe9ae10, 0x4e983ae9} },
/**/                  {{0xbc8d45ed, 0x52b783d7} },
/**/                  {{0xbfd47274, 0xf394891f} },
/**/                  {{0xbc7cd478, 0x22e08713} },
/**/                  {{0xbfa71487, 0xa445379d} },
/**/                  {{0x3c1569aa, 0x831d87b7} },
/**/                  {{0x3fc3dabe, 0x0f10bc36} },
/**/                  {{0x3bd8df2b, 0x1cb9bbe6} },
/**/                  {{0xbfb3bcc3, 0x8fddd862} },
/**/                  {{0xbfa04bc8, 0xbcb632d9} },
/**/                  {{0x3fb0dfe4, 0x64a26d77} },
/**/                  {{0xbf9b68e6, 0xd04027d1} },
/**/                  {{0xbf96bb07, 0xf792c5d9} } },
/**/                 {{{0x3fe00000, 0x00000000} },
/**/                  {{0x3fddac67, 0x0561bb4f} },
/**/                  {{0x3c7a2b7f, 0x222f65e2} },
/**/                  {{0x3fe99999, 0x9999999a} },
/**/                  {{0xbc899999, 0x9999999a} },
/**/                  {{0xbfd47ae1, 0x47ae147b} },
/**/                  {{0x3c5eb851, 0xeb851eb8} },
/**/                  {{0xbfa5d867, 0xc3ece2a5} },
/**/                  {{0xbc3a485c, 0xd7b900af} },
/**/                  {{0x3fc3a92a, 0x30553261} },
/**/                  {{0x3c6f06f6, 0x94467382} },
/**/                  {{0xbfb3ec46, 0x0ed80a18} },
/**/                  {{0xbf9ec21b, 0x514d88d8} },
/**/                  {{0x3fb0a849, 0xf929a833} },
/**/                  {{0xbf9c2f8b, 0x88dfb80c} },
/**/                  {{0xbf956a49, 0x8245bf09} } },
/**/                 {{{0x3fe02000, 0x00000000} },
/**/                  {{0x3fdddf85, 0xbb026974} },
/**/                  {{0x3c643bbb, 0x0c0a1226} },
/**/                  {{0x3fe9851a, 0xb35b2797} },
/**/                  {{0x3c89cd14, 0x18a8fead} },
/**/                  {{0xbfd482d7, 0xa5042a2d} },
/**/                  {{0x3c0dbc04, 0xa8224d16} },
/**/                  {{0xbfa49f64, 0xc56ade02} },
/**/                  {{0x3c451e52, 0x47da7eea} },
/**/                  {{0x3fc37722, 0xf7c5fe7d} },
/**/                  {{0xbc5165be, 0xd22c4b5c} },
/**/                  {{0xbfb4190c, 0xf6f48c5d} },
/**/                  {{0xbf9cf2cf, 0x58d0c132} },
/**/                  {{0x3fb06f2e, 0x0ddfdd74} },
/**/                  {{0xbf9cea6d, 0x46e65336} },
/**/                  {{0xbf941df9, 0x6423af3b} } },
/**/                 {{{0x3fe04000, 0x00000000} },
/**/                  {{0x3fde127b, 0x6b0744b0} },
/**/                  {{0xbc52b098, 0x6398d4ab} },
/**/                  {{0x3fe97094, 0x113dcc5a} },
/**/                  {{0xbc842780, 0x4de8c575} },
/**/                  {{0xbfd48a59, 0x37beb8e5} },
/**/                  {{0xbc601dd2, 0x9dc7541e} },
/**/                  {{0xbfa36985, 0xa7f2a8fe} },
/**/                  {{0xbc45e414, 0x7437d42d} },
/**/                  {{0x3fc344af, 0x2eb33dd6} },
/**/                  {{0xbc6d66e9, 0xe3a3193c} },
/**/                  {{0xbfb44321, 0xa6763232} },
/**/                  {{0xbf9b29d6, 0x7217dfc9} },
/**/                  {{0x3fb034a7, 0xfff8a866} },
/**/                  {{0xbf9d99b5, 0x3a6e931d} },
/**/                  {{0xbf92d661, 0x4a9f7e19} } },
/**/                 {{{0x3fe06000, 0x00000000} },
/**/                  {{0x3fde4548, 0x066cf51a} },
/**/                  {{0x3c43a3aa, 0x12ce98f2} },
/**/                  {{0x3fe95c06, 0x2774fe53} },
/**/                  {{0x3c810dfd, 0x3b851412} },
/**/                  {{0xbfd49167, 0x2e911e43} },
/**/                  {{0xbc7f6506, 0x09466fcd} },
/**/                  {{0xbfa236d0, 0xfedfb0c1} },
/**/                  {{0xbc3f6870, 0x79cb63a9} },
/**/                  {{0x3fc311d5, 0x86b6561c} },
/**/                  {{0x3c561982, 0x9543fc9a} },
/**/                  {{0xbfb46a8d, 0xb70aa5a7} },
/**/                  {{0xbf996756, 0xf5ac1efc} },
/**/                  {{0x3faff19d, 0xaf7c84b3} },
/**/                  {{0xbf9e3d8f, 0x15ce96b8} },
/**/                  {{0xbf9193c6, 0x42726021} } },
/**/                 {{{0x3fe08000, 0x00000000} },
/**/                  {{0x3fde77eb, 0x7f175a34} },
/**/                  {{0x3c70e53d, 0xc1bf3435} },
/**/                  {{0x3fe94771, 0x69044ba4} },
/**/                  {{0xbc7d53e2, 0x92d5fbc1} },
/**/                  {{0xbfd49802, 0xba91fd89} },
/**/                  {{0x3c71963e, 0xc3c8c4f3} },
/**/                  {{0xbfa1074c, 0xf33546d5} },
/**/                  {{0x3c4bc296, 0xc71ad288} },
/**/                  {{0x3fc2de9c, 0x99222665} },
/**/                  {{0x3c6e4a10, 0x28dadb64} },
/**/                  {{0xbfb48f5a, 0xfa031cb1} },
/**/                  {{0xbf97ab74, 0xbc0c6420} },
/**/                  {{0x3faf7772, 0x876d0f75} },
/**/                  {{0xbf9ed628, 0xe431fc96} },
/**/                  {{0xbf905668, 0xc64515ec} } },
/**/                 {{{0x3fe0a000, 0x00000000} },
/**/                  {{0x3fdeaa65, 0xc7cf28c4} },
/**/                  {{0x3c62fb2c, 0xeca3bf05} },
/**/                  {{0x3fe932d6, 0x47bd0aaa} },
/**/                  {{0x3c6bdfec, 0x697b6e3c} },
/**/                  {{0xbfd49e2d, 0x0f13a7e8} },
/**/                  {{0x3c6198c5, 0x20412940} },
/**/                  {{0xbf9fb5fe, 0x8a4e92df} },
/**/                  {{0xbc3cbb58, 0x6309a51a} },
/**/                  {{0x3fc2ab0a, 0xe67c9829} },
/**/                  {{0xbc647643, 0x06a4c4ef} },
/**/                  {{0xbfb4b193, 0x749bc711} },
/**/                  {{0xbf95f651, 0x27bef265} },
/**/                  {{0x3faefafb, 0x28347ebf} },
/**/                  {{0xbf9f63b2, 0xe0c06e2f} },
/**/                  {{0xbf8e3d09, 0x9e7b9dd7} } },
/**/                 {{{0x3fe0c000, 0x00000000} },
/**/                  {{0x3fdedcb6, 0xd43f8435} },
/**/                  {{0xbc5fc976, 0x330884e4} },
/**/                  {{0x3fe91e35, 0x343c31e5} },
/**/                  {{0xbc8fd46f, 0x9bb96799} },
/**/                  {{0xbfd4a3e7, 0x617d19a1} },
/**/                  {{0xbc7d7303, 0xea58b250} },
/**/                  {{0xbf9d63da, 0x9b55d156} },
/**/                  {{0xbc14bf72, 0xd5b4cc6c} },
/**/                  {{0x3fc27726, 0xd6016a7c} },
/**/                  {{0x3c4eba22, 0x435ec4b4} },
/**/                  {{0xbfb4d141, 0x5c52b3c6} },
/**/                  {{0xbf94480b, 0x2fdd9fbd} },
/**/                  {{0x3fae7c63, 0x6d3af4b6} },
/**/                  {{0xbf9fe65f, 0x4e61315b} },
/**/                  {{0xbf8bd8a3, 0xcea37283} } },
/**/                 {{{0x3fe0e000, 0x00000000} },
/**/                  {{0x3fdf0ede, 0x98f393d0} },
/**/                  {{0xbc72f40a, 0x87cb1894} },
/**/                  {{0x3fe9098e, 0x9de85688} },
/**/                  {{0xbc7c2de1, 0xa3791e64} },
/**/                  {{0xbfd4a932, 0xe9238ed7} },
/**/                  {{0xbc67a1bb, 0x28864386} },
/**/                  {{0xbf9b1838, 0x001dec68} },
/**/                  {{0xbc33ee0e, 0x8f0ffbdd} },
/**/                  {{0x3fc242f6, 0xb52e1005} },
/**/                  {{0xbc5476eb, 0x371fd2c1} },
/**/                  {{0xbfb4ee6f, 0x134edf2d} },
/**/                  {{0xbf92a0bf, 0x6b13becc} },
/**/                  {{0x3fadfbd6, 0x650f859c} },
/**/                  {{0xbfa02f31, 0x281586f4} },
/**/                  {{0xbf898006, 0x7a73449e} } },
/**/                 {{{0x3fe10000, 0x00000000} },
/**/                  {{0x3fdf40dd, 0x0b541418} },
/**/                  {{0xbc6a3992, 0xdc382a23} },
/**/                  {{0x3fe8f4e2, 0xf2efd135} },
/**/                  {{0xbc74c3c0, 0xd4218911} },
/**/                  {{0xbfd4ae10, 0xdf24b2d1} },
/**/                  {{0x3c713b12, 0x79d0ac37} },
/**/                  {{0xbf98d31f, 0xd7365f3f} },
/**/                  {{0xbc18bf3b, 0x62531dc5} },
/**/                  {{0x3fc20e80, 0xb7567664} },
/**/                  {{0xbc54a699, 0xd450197f} },
/**/                  {{0xbfb50927, 0x24d80ddd} },
/**/                  {{0xbf910088, 0x1b0516ab} },
/**/                  {{0x3fad797e, 0x4a356567} },
/**/                  {{0xbfa065f8, 0xe14758ed} },
/**/                  {{0xbf87338f, 0x73d2f6bb} } },
/**/                 {{{0x3fe12000, 0x00000000} },
/**/                  {{0x3fdf72b2, 0x21a4e495} },
/**/                  {{0x3c5489c2, 0x0f7eb740} },
/**/                  {{0x3fe8e032, 0xa0470831} },
/**/                  {{0xbc8c154a, 0xe75570cd} },
/**/                  {{0xbfd4b282, 0x7e416c35} },
/**/                  {{0xbc7f1837, 0x60646afd} },
/**/                  {{0xbf96949a, 0x7a6bec27} },
/**/                  {{0x3c38238f, 0xe6b77ba9} },
/**/                  {{0x3fc1d9ca, 0xf5428c61} },
/**/                  {{0x3c6a968d, 0xcd7881aa} },
/**/                  {{0xbfb52174, 0x41e00b6e} },
/**/                  {{0xbf8ecefa, 0x702ad3de} },
/**/                  {{0x3facf584, 0x7c8ae0dc} },
/**/                  {{0xbfa097a2, 0x8aa44fa8} },
/**/                  {{0xbf84f394, 0x2ed63408} } },
/**/                 {{{0x3fe14000, 0x00000000} },
/**/                  {{0x3fdfa45d, 0xd3029259} },
/**/                  {{0xbc7ca563, 0xdc28d8b5} },
/**/                  {{0x3fe8cb7e, 0x11a6de80} },
/**/                  {{0x3c610be6, 0xac22b8f8} },
/**/                  {{0xbfd4b689, 0x02b9488a} },
/**/                  {{0x3c5ea0bd, 0xaf91d442} },
/**/                  {{0xbf945caf, 0x821fd17e} },
/**/                  {{0x3c38e464, 0x0e51a049} },
/**/                  {{0x3fc1a4db, 0x6cd45aad} },
/**/                  {{0x3c2288e0, 0xf4200d5e} },
/**/                  {{0xbfb53761, 0x3d9dd7c4} },
/**/                  {{0xbf8bab68, 0xfb107457} },
/**/                  {{0x3fac7011, 0x7b46ebd1} },
/**/                  {{0xbfa0c44a, 0x93134a8f} },
/**/                  {{0xbf82c061, 0xf1fa4589} } },
/**/                 {{{0x3fe16000, 0x00000000} },
/**/                  {{0x3fdfd5e0, 0x175fdf83} },
/**/                  {{0x3c63a87b, 0x1ec49b15} },
/**/                  {{0x3fe8b6c5, 0xb18b4749} },
/**/                  {{0xbc5fabb8, 0xb7d58c0a} },
/**/                  {{0xbfd4ba25, 0xaa26890c} },
/**/                  {{0x3c50e395, 0x0ef9b688} },
/**/                  {{0xbf922b65, 0xc8a9b4c0} },
/**/                  {{0x3c2835ee, 0xd319146f} },
/**/                  {{0x3fc16fb8, 0x00b681bd} },
/**/                  {{0x3c1df633, 0x279133b0} },
/**/                  {{0xbfb54af9, 0x0a3b410c} },
/**/                  {{0xbf889682, 0xebe14682} },
/**/                  {{0x3fabe94c, 0xdf89e086} },
/**/                  {{0xbfa0ec0e, 0x0e55a6f8} },
/**/                  {{0xbf809a3e, 0x08af68f3} } },
/**/                 {{{0x3fe18000, 0x00000000} },
/**/                  {{0x3fe0039c, 0x73c1a40c} },
/**/                  {{0xbc8b32c9, 0x49c9d593} },
/**/                  {{0x3fe8a209, 0xe931fcd3} },
/**/                  {{0x3c6cb8f0, 0x8e68c94c} },
/**/                  {{0xbfd4bd59, 0xb35ad2d8} },
/**/                  {{0xbc61ac1a, 0xcaa606b4} },
/**/                  {{0xbf9000c3, 0x6dc339ef} },
/**/                  {{0x3c2c62e2, 0xaeaeaa73} },
/**/                  {{0x3fc13a66, 0x7812ee2d} },
/**/                  {{0x3c6a8cc2, 0x948ffe5b} },
/**/                  {{0xbfb55c46, 0xb5955c9c} },
/**/                  {{0xbf85906b, 0x0fd2b503} },
/**/                  {{0x3fab615d, 0x577de2da} },
/**/                  {{0xbfa10f0a, 0xa34d31ec} },
/**/                  {{0xbf7d02cb, 0xefe48ad0} } },
/**/                 {{{0x3fe1a000, 0x00000000} },
/**/                  {{0x3fe01c34, 0x1e82422d} },
/**/                  {{0x3c83db44, 0xfcca90ee} },
/**/                  {{0x3fe88d4b, 0x20995a88} },
/**/                  {{0x3c802777, 0x1e42e681} },
/**/                  {{0xbfd4c026, 0x5e3c840f} },
/**/                  {{0x3c7d7c65, 0x3800420d} },
/**/                  {{0xbf8bb99b, 0xb3f88703} },
/**/                  {{0x3c1f62ec, 0x4bf63e82} },
/**/                  {{0x3fc104ec, 0x7e5193ee} },
/**/                  {{0xbc27771e, 0xbae4e07d} },
/**/                  {{0xbfb56b55, 0x66104515} },
/**/                  {{0xbf829940, 0x061a20d1} },
/**/                  {{0x3faad868, 0xa20334d9} },
/**/                  {{0xbfa12d5e, 0x7aba8ee6} },
/**/                  {{0xbf78ec1f, 0x69774b8d} } },
/**/                 {{{0x3fe1c000, 0x00000000} },
/**/                  {{0x3fe034b7, 0x09250488} },
/**/                  {{0x3c78f9b3, 0x8d855410} },
/**/                  {{0x3fe87889, 0xbe7f594b} },
/**/                  {{0xbc7530e1, 0xc826e7a3} },
/**/                  {{0xbfd4c28c, 0xeba4af80} },
/**/                  {{0x3c7104a9, 0xe6a95faa} },
/**/                  {{0xbf877f13, 0x846dba10} },
/**/                  {{0x3c2bc924, 0x4abd0010} },
/**/                  {{0x3fc0cf4f, 0xa2deff9f} },
/**/                  {{0xbc67d17e, 0xa013c015} },
/**/                  {{0xbfb57830, 0x577e7899} },
/**/                  {{0xbf7f6238, 0xb49ea16d} },
/**/                  {{0x3faa4e93, 0x8ae4a926} },
/**/                  {{0xbfa14728, 0x2e77f633} },
/**/                  {{0xbf74f0d3, 0xb81c893e} } },
/**/                 {{{0x3fe1e000, 0x00000000} },
/**/                  {{0x3fe04d25, 0x314342e6} },
/**/                  {{0xbc81c863, 0x6442c767} },
/**/                  {{0x3fe863c6, 0x2860ad7e} },
/**/                  {{0xbc81dcb2, 0x137a2d8f} },
/**/                  {{0xbfd4c48e, 0x9d3dc03a} },
/**/                  {{0xbc7d92af, 0x197b1db9} },
/**/                  {{0xbf8351f6, 0x5653b1a7} },
/**/                  {{0xbbe368b4, 0x2127dea7} },
/**/                  {{0x3fc09995, 0x58fa8ca4} },
/**/                  {{0xbc446391, 0x530429e5} },
/**/                  {{0xbfb582e2, 0xd81c26eb} },
/**/                  {{0xbf79b02d, 0x3e63c109} },
/**/                  {{0x3fa9c401, 0xe7904294} },
/**/                  {{0xbfa15c86, 0xb933b0f3} },
/**/                  {{0xbf711137, 0xd8d860e1} } },
/**/                 {{{0x3fe20000, 0x00000000} },
/**/                  {{0x3fe0657e, 0x94db30d0} },
/**/                  {{0xbc7d5b49, 0x5f6349e6} },
/**/                  {{0x3fe84f00, 0xc2780614} },
/**/                  {{0xbc7fe7b0, 0xff3d87fa} },
/**/                  {{0xbfd4c62c, 0xb562c625} },
/**/                  {{0x3c77b2c3, 0xa78e848c} },
/**/                  {{0xbf7e6495, 0xb3a4bcb7} },
/**/                  {{0x3c14eb89, 0xe3f2b0a5} },
/**/                  {{0x3fc063c2, 0xf78c0dc4} },
/**/                  {{0xbc6badf0, 0x7539dc13} },
/**/                  {{0xbfb58b78, 0x459eb443} },
/**/                  {{0xbf741c83, 0x1386e6b4} },
/**/                  {{0x3fa938d6, 0x944ff706} },
/**/                  {{0xbfa16d99, 0x66ad4037} },
/**/                  {{0xbf6a9b1a, 0x01fc736a} } },
/**/                 {{{0x3fe22000, 0x00000000} },
/**/                  {{0x3fe07dc3, 0x324e9b38} },
/**/                  {{0x3c7b70c9, 0xe04450ac} },
/**/                  {{0x3fe83a39, 0xefbd6bfe} },
/**/                  {{0xbc7b2885, 0x21f5de26} },
/**/                  {{0xbfd4c768, 0x76ff6c9e} },
/**/                  {{0x3c56a2c0, 0xdebc1603} },
/**/                  {{0xbf76402c, 0xd9cccfd7} },
/**/                  {{0xbc1b39c0, 0x4e9786c1} },
/**/                  {{0x3fc02ddd, 0xb900b57a} },
/**/                  {{0x3c45d916, 0xea88a215} },
/**/                  {{0xbfb591fc, 0x0a58ab40} },
/**/                  {{0xbf6d4eb0, 0x32a37ac9} },
/**/                  {{0x3fa8ad33, 0x71fe75f8} },
/**/                  {{0xbfa17a7f, 0xc477a855} },
/**/                  {{0xbf634c0e, 0x2b035011} } },
/**/                 {{{0x3fe24000, 0x00000000} },
/**/                  {{0x3fe095f3, 0x0861a590} },
/**/                  {{0xbc7121b2, 0x0a15a9f3} },
/**/                  {{0x3fe82572, 0x11e5c14d} },
/**/                  {{0xbc7df9fc, 0xacd80b09} },
/**/                  {{0xbfd4c843, 0x25709bff} },
/**/                  {{0x3c7a9ef6, 0x1790f484} },
/**/                  {{0xbf6c6d74, 0x8a0def34} },
/**/                  {{0xbc051e57, 0x2a8142d7} },
/**/                  {{0x3fbfefd5, 0x765e156b} },
/**/                  {{0xbc3e6048, 0xf0e29c9e} },
/**/                  {{0xbfb59679, 0x9a724e28} },
/**/                  {{0xbf62a185, 0xcf13e192} },
/**/                  {{0x3fa82139, 0x6433c13f} },
/**/                  {{0xbfa18359, 0x9342e95d} },
/**/                  {{0xbf586b34, 0x8f974107} } },
/**/                 {{{0x3fe26000, 0x00000000} },
/**/                  {{0x3fe0ae0e, 0x1639866c} },
/**/                  {{0x3c7075ab, 0xf2de445a} },
/**/                  {{0x3fe810a9, 0x89625f5d} },
/**/                  {{0xbc8e4bea, 0x0fcf7262} },
/**/                  {{0xbfd4c8be, 0x0465c69b} },
/**/                  {{0x3c462ef4, 0xd7f7f89c} },
/**/                  {{0xbf59210e, 0x4de612d5} },
/**/                  {{0xbbf43659, 0xba53898d} },
/**/                  {{0x3fbf83dd, 0xfe836c69} },
/**/                  {{0xbc36cb56, 0x27f5499a} },
/**/                  {{0xbfb598fc, 0x7136edda} },
/**/                  {{0xbf50634c, 0x00013fb7} },
/**/                  {{0x3fa79508, 0x4fe557c2} },
/**/                  {{0xbfa18846, 0xb8ae41dc} },
/**/                  {{0xbf455fce, 0xe36bd239} } },
/**/                 {{{0x3fe28000, 0x00000000} },
/**/                  {{0x3fe0c614, 0x5b5b43da} },
/**/                  {{0x3c5974fa, 0x13b5404f} },
/**/                  {{0x3fe7fbe0, 0xb560d35c} },
/**/                  {{0xbc84f066, 0xae5a0887} },
/**/                  {{0xbfd4c8da, 0x57c2e1cb} },
/**/                  {{0x3c73de0e, 0xe0a3774c} },
/**/                  {{0x3f38b341, 0x61c69f3c} },
/**/                  {{0x3bd7b2e2, 0x7b200371} },
/**/                  {{0x3fbf17de, 0xd351e8ed} },
/**/                  {{0x3c5bce38, 0x650c5a9c} },
/**/                  {{0xbfb59990, 0x0e77234c} },
/**/                  {{0x3f3006ef, 0x99f594ee} },
/**/                  {{0x3fa708bf, 0x1a75a6cc} },
/**/                  {{0xbfa18967, 0x31a471d5} },
/**/                  {{0x3f24cc7e, 0x59bf0521} } },
/**/                 {{{0x3fe2a000, 0x00000000} },
/**/                  {{0x3fe0de05, 0xd7aa6f7d} },
/**/                  {{0xbc783684, 0xb1c529ab} },
/**/                  {{0x3fe7e717, 0xf3cab884} },
/**/                  {{0x3c7e1b21, 0x3b1fa4c7} },
/**/                  {{0xbfd4c899, 0x63830b4b} },
/**/                  {{0xbc7b6e32, 0xae3ffeff} },
/**/                  {{0x3f628757, 0xfc06cc4f} },
/**/                  {{0xbbb4c155, 0x56f01f66} },
/**/                  {{0x3fbeabe1, 0x8424efd8} },
/**/                  {{0x3bdf5129, 0x6e5604ea} },
/**/                  {{0xbfb5983f, 0xf3ffff64} },
/**/                  {{0x3f57ec04, 0x1f564189} },
/**/                  {{0x3fa67c7b, 0xa92e6e68} },
/**/                  {{0xbfa186db, 0x0542d0ff} },
/**/                  {{0x3f4ee247, 0x11a37bde} } },
/**/                 {{{0x3fe2c000, 0x00000000} },
/**/                  {{0x3fe0f5e2, 0x8b67e295} },
/**/                  {{0x3be311b1, 0x7ec990d0} },
/**/                  {{0x3fe7d24f, 0xa145af59} },
/**/                  {{0xbc83c6d1, 0xabdb623b} },
/**/                  {{0xbfd4c7fc, 0x6b9bdb30} },
/**/                  {{0x3c7c2fae, 0xd3bbb84b} },
/**/                  {{0x3f70e125, 0xc729b366} },
/**/                  {{0x3c1291fb, 0x7a19993c} },
/**/                  {{0x3fbe3fef, 0x66cf0dd8} },
/**/                  {{0xbc5428b7, 0xcd5e7640} },
/**/                  {{0xbfb59517, 0xa3273c21} },
/**/                  {{0x3f65adcf, 0x36891acb} },
/**/                  {{0x3fa5f05a, 0xe121c017} },
/**/                  {{0xbfa180c2, 0x384bad65} },
/**/                  {{0x3f5bd6f1, 0xd31e02a7} } },
/**/                 {{{0x3fe2e000, 0x00000000} },
/**/                  {{0x3fe10daa, 0x77307a0d} },
/**/                  {{0x3c869c33, 0xd44c7b05} },
/**/                  {{0x3fe7bd88, 0x19337139} },
/**/                  {{0xbc7fd248, 0x00e777ef} },
/**/                  {{0xbfd4c704, 0xb3e16264} },
/**/                  {{0xbc7ed720, 0xd46ed4e3} },
/**/                  {{0x3f7863a5, 0x62c1daf7} },
/**/                  {{0x3c155e73, 0x30cc82d1} },
/**/                  {{0x3fbdd411, 0x97a241da} },
/**/                  {{0x3c27a15a, 0x9ac44edd} },
/**/                  {{0xbfb59022, 0x9a6c71a6} },
/**/                  {{0x3f6f285a, 0xb5534ebe} },
/**/                  {{0x3fa56478, 0xa76d3cf7} },
/**/                  {{0xbfa1773c, 0xc1240db6} },
/**/                  {{0x3f63e5a1, 0x3891a70c} } },
/**/                 {{{0x3fe30000, 0x00000000} },
/**/                  {{0x3fe1255d, 0x9bfbd2a9} },
/**/                  {{0xbc52bdae, 0xe1c0ee35} },
/**/                  {{0x3fe7a8c1, 0xb5b1ffa1} },
/**/                  {{0x3c873e4a, 0x4e005ea3} },
/**/                  {{0xbfd4c5b3, 0x7fead5b8} },
/**/                  {{0x3c77958e, 0x55abc25a} },
/**/                  {{0x3f7fcb31, 0x01e4c970} },
/**/                  {{0xbc1ad968, 0xc5337fda} },
/**/                  {{0x3fbd6850, 0xf983ecf1} },
/**/                  {{0xbc3e45e6, 0x02ed6910} },
/**/                  {{0xbfb5896c, 0x532f49b6} },
/**/                  {{0x3f7432e2, 0xeaefcf7f} },
/**/                  {{0x3fa4d8ef, 0xe1db38f0} },
/**/                  {{0xbfa16a6a, 0x7c5c9def} },
/**/                  {{0x3f69a742, 0x7b6fe5d0} } },
/**/                 {{{0x3fe32000, 0x00000000} },
/**/                  {{0x3fe13cfb, 0xfb1b056e} },
/**/                  {{0x3c83110e, 0x6fc3ed38} },
/**/                  {{0x3fe793fc, 0xcf9bee6c} },
/**/                  {{0xbc8dc7d2, 0xd8d91b6c} },
/**/                  {{0xbfd4c40a, 0x12f7e51f} },
/**/                  {{0x3c7d1e10, 0x0d5d686d} },
/**/                  {{0x3f838be8, 0x839d28fa} },
/**/                  {{0x3c13427a, 0x52131640} },
/**/                  {{0x3fbcfcb6, 0x360bfed5} },
/**/                  {{0xbc5e3cb4, 0xa36f599f} },
/**/                  {{0xbfb58100, 0x3f7aa463} },
/**/                  {{0x3f78b31e, 0xb76f2bc0} },
/**/                  {{0x3fa44dda, 0x77dd6b80} },
/**/                  {{0xbfa15a6b, 0x21c53ca9} },
/**/                  {{0x3f6f30a7, 0x6cd99ed4} } },
/**/                 {{{0x3fe34000, 0x00000000} },
/**/                  {{0x3fe15485, 0x9637646a} },
/**/                  {{0xbc84ba7c, 0x548bf3c3} },
/**/                  {{0x3fe77f39, 0xbe88c85e} },
/**/                  {{0xbc6a983f, 0x9b6750c8} },
/**/                  {{0xbfd4c209, 0xafd6bee5} },
/**/                  {{0x3c7d21ef, 0x5e73e93a} },
/**/                  {{0x3f8724c7, 0xfc556ca7} },
/**/                  {{0xbc23cef2, 0x42e5673e} },
/**/                  {{0x3fbc9149, 0xbdaef67d} },
/**/                  {{0xbc1e549c, 0x3f04fcdc} },
/**/                  {{0xbfb576e9, 0xc7e4996a} },
/**/                  {{0x3f7d14fc, 0xba6ceedb} },
/**/                  {{0x3fa3c351, 0x53dcdc4a} },
/**/                  {{0xbfa1475e, 0x3a0a53a1} },
/**/                  {{0x3f724116, 0x62102619} } },
/**/                 {{{0x3fe36000, 0x00000000} },
/**/                  {{0x3fe16bfa, 0x6f5137e1} },
/**/                  {{0x3c79606f, 0xe141bd35} },
/**/                  {{0x3fe76a78, 0xd8cd8d65} },
/**/                  {{0x3c854a99, 0xddf1f71f} },
/**/                  {{0xbfd4bfb3, 0x98cabe40} },
/**/                  {{0xbc61e24d, 0x9ef99598} },
/**/                  {{0x3f8ab03d, 0x388e6864} },
/**/                  {{0x3c210541, 0xc340d113} },
/**/                  {{0x3fbc2613, 0xc7f24ec4} },
/**/                  {{0x3c54042a, 0x0a59af31} },
/**/                  {{0xbfb56b34, 0x49833ac1} },
/**/                  {{0x3f80ac4f, 0x22f6cd28} },
/**/                  {{0x3fa3396c, 0x64dac153} },
/**/                  {{0xbfa13163, 0x14dadf32} },
/**/                  {{0x3f74ce20, 0x21aeee27} } },
/**/                 {{{0x3fe38000, 0x00000000} },
/**/                  {{0x3fe1835a, 0x88be7c13} },
/**/                  {{0x3c8c621c, 0xec00c301} },
/**/                  {{0x3fe755ba, 0x737d49ca} },
/**/                  {{0xbc8abaf3, 0xd4cb44c6} },
/**/                  {{0xbfd4bd09, 0x0f73c4b3} },
/**/                  {{0x3c3e9ebf, 0xa9936e0b} },
/**/                  {{0x3f8e2e4f, 0x8920477f} },
/**/                  {{0xbc0889e3, 0x0360e009} },
/**/                  {{0x3fbbbb1c, 0x53aaefa0} },
/**/                  {{0xbc5edb26, 0xa1007b7f} },
/**/                  {{0xbfb55deb, 0x13f5f619} },
/**/                  {{0x3f82bf14, 0xe675741e} },
/**/                  {{0x3fa2b042, 0xa05e0ebf} },
/**/                  {{0xbfa11898, 0xbf95c5c1} },
/**/                  {{0x3f773faf, 0xe421ee51} } },
/**/                 {{{0x3fe3a000, 0x00000000} },
/**/                  {{0x3fe19aa5, 0xe5299f9a} },
/**/                  {{0xbc8a606c, 0x2c58f835} },
/**/                  {{0x3fe740fe, 0xe269c5b3} },
/**/                  {{0x3c873eff, 0x4c82509c} },
/**/                  {{0xbfd4ba0b, 0x54b63d79} },
/**/                  {{0xbc51d68a, 0x75bceeff} },
/**/                  {{0x3f90cf83, 0x9d9b3eb0} },
/**/                  {{0xbc107399, 0x68a7ca2f} },
/**/                  {{0x3fbb506b, 0x27453d35} },
/**/                  {{0x3c326b36, 0x00bdfedd} },
/**/                  {{0xbfb54f19, 0x67836cef} },
/**/                  {{0x3f84c2e5, 0x567ed6e8} },
/**/                  {{0x3fa227ea, 0x04a983e8} },
/**/                  {{0xbfa0fd1d, 0xfc7ce22f} },
/**/                  {{0x3f79960c, 0x2ffea71d} } },
/**/                 {{{0x3fe3c000, 0x00000000} },
/**/                  {{0x3fe1b1dc, 0x87904285} },
/**/                  {{0xbc621e8c, 0x8aef8f29} },
/**/                  {{0x3fe72c46, 0x78244c5a} },
/**/                  {{0x3c888c36, 0xe664f3a2} },
/**/                  {{0xbfd4b6bb, 0xa8a3ca2f} },
/**/                  {{0xbc778793, 0x1e1f3e19} },
/**/                  {{0x3f928136, 0xc8a3d8bb} },
/**/                  {{0x3c3dc4d8, 0x140daf1c} },
/**/                  {{0x3fbae607, 0xd1165ef3} },
/**/                  {{0xbc5fbfaa, 0x6305876c} },
/**/                  {{0xbfb53eca, 0x734b94bd} },
/**/                  {{0x3f86b7d8, 0x7c458eb1} },
/**/                  {{0x3fa1a077, 0x9b360f57} },
/**/                  {{0xbfa0df11, 0x3a6beabd} },
/**/                  {{0x3f7bd182, 0xaf42dc87} } },
/**/                 {{{0x3fe3e000, 0x00000000} },
/**/                  {{0x3fe1c8fe, 0x7341f64f} },
/**/                  {{0x3c728bbc, 0x9d5e792a} },
/**/                  {{0x3fe71791, 0x85fe8a32} },
/**/                  {{0x3c8f15bd, 0xe8bbb0d0} },
/**/                  {{0xbfd4b31b, 0x4a6497be} },
/**/                  {{0x3c737223, 0x782968f7} },
/**/                  {{0x3f942c46, 0x5e0c3122} },
/**/                  {{0xbc33e26a, 0x86422b13} },
/**/                  {{0x3fba7bf9, 0xa7b659b8} },
/**/                  {{0xbc3cdf63, 0x25381986} },
/**/                  {{0xbfb52d09, 0x538deb45} },
/**/                  {{0x3f889e08, 0xa0c1f425} },
/**/                  {{0x3fa119ff, 0x7b6d72e6} },
/**/                  {{0xbfa0be90, 0x8d11287b} },
/**/                  {{0x3f7df267, 0xbce83ad4} } },
/**/                 {{{0x3fe40000, 0x00000000} },
/**/                  {{0x3fe1e00b, 0xabdefeb4} },
/**/                  {{0xbc5928df, 0x287a668f} },
/**/                  {{0x3fe702e0, 0x5c0b8170} },
/**/                  {{0x3c7702e0, 0x5c0b8170} },
/**/                  {{0xbfd4af2b, 0x78215a76} },
/**/                  {{0xbc581c2e, 0xab3a13d8} },
/**/                  {{0x3f95d0b7, 0xe9e4a9d0} },
/**/                  {{0xbc3aa02a, 0xebf91fc7} },
/**/                  {{0x3fba1247, 0xca629942} },
/**/                  {{0xbc46961a, 0xc245db83} },
/**/                  {{0xbfb519e1, 0x100385b4} },
/**/                  {{0x3f8a7592, 0x32616ed8} },
/**/                  {{0x3fa09494, 0xcda1223a} },
/**/                  {{0xbfa09bb9, 0xa5a5c251} },
/**/                  {{0x3f7ff915, 0xf489d8ba} } },
/**/                 {{{0x3fe42000, 0x00000000} },
/**/                  {{0x3fe1f704, 0x3557138a} },
/**/                  {{0x3c76c659, 0xf6d7dd47} },
/**/                  {{0x3fe6ee33, 0x4920943e} },
/**/                  {{0xbc62723e, 0x61a3a541} },
/**/                  {{0xbfd4aaed, 0x6eedf042} },
/**/                  {{0x3c5b337a, 0xe7561ed4} },
/**/                  {{0x3f976e91, 0x68796803} },
/**/                  {{0xbc0e806f, 0x44d1db93} },
/**/                  {{0x3fb9a8f9, 0x21688625} },
/**/                  {{0x3c540185, 0xb1ec0554} },
/**/                  {{0xbfb5055c, 0x9a4cbc61} },
/**/                  {{0x3f8c3e93, 0xab0be204} },
/**/                  {{0x3fa01049, 0xce3968a1} },
/**/                  {{0xbfa076a9, 0xcc2331ba} },
/**/                  {{0x3f80f2f6, 0xe220db7e} } },
/**/                 {{{0x3fe44000, 0x00000000} },
/**/                  {{0x3fe20de8, 0x13e823b2} },
/**/                  {{0xbc8791d7, 0x53ebb744} },
/**/                  {{0x3fe6d98a, 0x9ad6a3fd} },
/**/                  {{0xbc808110, 0xc4e69862} },
/**/                  {{0xbfd4a662, 0x6ab4a79d} },
/**/                  {{0x3c52ed25, 0x9fc1cc2b} },
/**/                  {{0x3f9905d9, 0x42e6dc28} },
/**/                  {{0xbc228c79, 0xe39b7707} },
/**/                  {{0x3fb94014, 0x5e97c6f4} },
/**/                  {{0xbc52b822, 0xf8779202} },
/**/                  {{0xbfb4ef86, 0xcc723054} },
/**/                  {{0x3f8df92d, 0x76852811} },
/**/                  {{0x3f9f1a5f, 0xa231ee3f} },
/**/                  {{0xbfa04f7d, 0xd8f34e77} },
/**/                  {{0x3f81dcaa, 0x80706a34} } },
/**/                 {{{0x3fe46000, 0x00000000} },
/**/                  {{0x3fe224b7, 0x4c1d192a} },
/**/                  {{0x3c8d6d3d, 0xf88a60c4} },
/**/                  {{0x3fe6c4e6, 0x9d8b44ec} },
/**/                  {{0xbc589d5c, 0x4ed04ec2} },
/**/                  {{0xbfd4a18b, 0xa6222a08} },
/**/                  {{0xbc66c919, 0xd3867dbd} },
/**/                  {{0x3f9a9696, 0x4bb5a8a0} },
/**/                  {{0x3c36698e, 0x927bb5bd} },
/**/                  {{0x3fb8d79f, 0xfdbbcc76} },
/**/                  {{0x3c2578bd, 0x4efb71a1} },
/**/                  {{0xbfb4d86a, 0x6778e363} },
/**/                  {{0x3f8fa581, 0xd930230d} },
/**/                  {{0x3f9e16ae, 0x8a6221aa} },
/**/                  {{0xbfa02652, 0x2f183972} },
/**/                  {{0x3f82b9db, 0x3e507f4f} } },
/**/                 {{{0x3fe48000, 0x00000000} },
/**/                  {{0x3fe23b71, 0xe2cc9e6a} },
/**/                  {{0x3c6c421c, 0x9f38224e} },
/**/                  {{0x3fe6b047, 0x9c620595} },
/**/                  {{0x3c8867df, 0x07d7f0c2} },
/**/                  {{0xbfd49c6a, 0x5a920887} },
/**/                  {{0xbc764547, 0x37bcc433} },
/**/                  {{0x3f9c20cf, 0xbb7e5931} },
/**/                  {{0xbc3d86f5, 0x4db6bef2} },
/**/                  {{0x3fb86fa2, 0x451c4a5d} },
/**/                  {{0xbc475142, 0x15afb52c} },
/**/                  {{0xbfb4c012, 0x120917da} },
/**/                  {{0x3f90a1da, 0x6b9c3fad} },
/**/                  {{0x3f9d159f, 0x708543e5} },
/**/                  {{0xbf9ff685, 0x6d929bce} },
/**/                  {{0x3f838ac0, 0xd0361a66} } },
/**/                 {{{0x3fe4a000, 0x00000000} },
/**/                  {{0x3fe25217, 0xdd17e501} },
/**/                  {{0x3c856aa8, 0x8c1b679c} },
/**/                  {{0x3fe69bad, 0xe145c95d} },
/**/                  {{0xbc873257, 0x5605046d} },
/**/                  {{0xbfd496ff, 0xbffbe8a8} },
/**/                  {{0x3c36a5c5, 0xc7b45e6f} },
/**/                  {{0x3f9da48d, 0x2d9556eb} },
/**/                  {{0x3c3ff0e8, 0x1871a19d} },
/**/                  {{0x3fb80821, 0x46043f42} },
/**/                  {{0x3c550eec, 0xe660cfa1} },
/**/                  {{0xbfb4a688, 0x5727a8cb} },
/**/                  {{0x3f9169f6, 0x0e13efbc} },
/**/                  {{0x3f9c174f, 0xb59149dd} },
/**/                  {{0xbf9f9cd5, 0xb10444dd} },
/**/                  {{0x3f844f95, 0x03e91dd9} } },
/**/                 {{{0x3fe4c000, 0x00000000} },
/**/                  {{0x3fe268a9, 0x40696da6} },
/**/                  {{0x3c5d1348, 0xa04c73cc} },
/**/                  {{0x3fe68719, 0xb4ea3592} },
/**/                  {{0xbc7ecf86, 0x088ed284} },
/**/                  {{0xbfd4914d, 0x0ce1507d} },
/**/                  {{0xbc6410ef, 0x4dff2946} },
/**/                  {{0x3f9f21d6, 0x9cbf7eb7} },
/**/                  {{0x3c39bc22, 0xeaaad7e2} },
/**/                  {{0x3fb7a122, 0xdd4f3070} },
/**/                  {{0x3c50d950, 0x1cfe44af} },
/**/                  {{0xbfb48bd7, 0xa50188df} },
/**/                  {{0x3f922b27, 0x71756204} },
/**/                  {{0x3f9b1bdb, 0x0810a33a} },
/**/                  {{0xbf9f3fca, 0xf1011313} },
/**/                  {{0x3f850893, 0x8fe0f49b} } },
/**/                 {{{0x3fe4e000, 0x00000000} },
/**/                  {{0x3fe27f26, 0x1273d1b3} },
/**/                  {{0x3c843bf3, 0x6151dd9f} },
/**/                  {{0x3fe6728b, 0x5ecd3069} },
/**/                  {{0x3c67417b, 0x539f23ff} },
/**/                  {{0xbfd48b53, 0x763c0fe8} },
/**/                  {{0xbc677a1a, 0x6027975c} },
/**/                  {{0x3fa04c5a, 0x2ff7dd6a} },
/**/                  {{0xbc40808e, 0x496202e8} },
/**/                  {{0x3fb73aac, 0xb3fc3f7c} },
/**/                  {{0x3c4b58cb, 0x86b114ff} },
/**/                  {{0xbfb4700a, 0x4bc91249} },
/**/                  {{0x3f92e582, 0xef2490f8} },
/**/                  {{0x3f9a235b, 0x6c875580} },
/**/                  {{0xbf9edf99, 0xe55cd596} },
/**/                  {{0x3f85b5f9, 0xe40c5a18} } },
/**/                 {{{0x3fe50000, 0x00000000} },
/**/                  {{0x3fe2958e, 0x59308e31} },
/**/                  {{0xbc709e73, 0xb0c6c087} },
/**/                  {{0x3fe65e03, 0x2538713c} },
/**/                  {{0xbc601392, 0x42c09163} },
/**/                  {{0xbfd48514, 0x2f6d4575} },
/**/                  {{0xbc356341, 0x4568af3f} },
/**/                  {{0x3fa10497, 0x9386fd1d} },
/**/                  {{0xbc4a756a, 0x230a452f} },
/**/                  {{0x3fb6d4c4, 0x3fc6c180} },
/**/                  {{0x3c5ab2b9, 0xdb3fe137} },
/**/                  {{0xbfb4532a, 0x7ca4cfd0} },
/**/                  {{0x3f93991d, 0x90eb1d30} },
/**/                  {{0x3f992de9, 0x46163051} },
/**/                  {{0xbf9e7c76, 0x2de874ff} },
/**/                  {{0x3f865806, 0xfc0c1cb2} } },
/**/                 {{{0x3fe52000, 0x00000000} },
/**/                  {{0x3fe2abe2, 0x1aded073} },
/**/                  {{0x3c8c28c0, 0x01ad022e} },
/**/                  {{0x3fe64981, 0x4d432177} },
/**/                  {{0x3c83f41b, 0x055e240c} },
/**/                  {{0xbfd47e90, 0x6a2cfd01} },
/**/                  {{0x3c628585, 0xf152d080} },
/**/                  {{0x3fa1b9a7, 0xfbe3ed9e} },
/**/                  {{0xbc18a085, 0xf259fe04} },
/**/                  {{0x3fb66f6e, 0xc3c40175} },
/**/                  {{0x3c41d80a, 0xb0fda762} },
/**/                  {{0xbfb43542, 0x48af643a} },
/**/                  {{0x3f94460d, 0x05ad7652} },
/**/                  {{0x3f983b9b, 0x5f55ab26} },
/**/                  {{0xbf9e1692, 0x4be18b23} },
/**/                  {{0x3f86eefb, 0x32e755a3} } },
/**/                 {{{0x3fe54000, 0x00000000} },
/**/                  {{0x3fe2c221, 0x5e024466} },
/**/                  {{0xbc44b810, 0xda3a4be1} },
/**/                  {{0x3fe63506, 0x1ad38da0} },
/**/                  {{0xbc67f12a, 0x94ec14b0} },
/**/                  {{0xbfd477c9, 0x567a6652} },
/**/                  {{0x3c7be71c, 0xbbb9df88} },
/**/                  {{0x3fa26b90, 0x1535acb9} },
/**/                  {{0xbc30ff6c, 0xff041454} },
/**/                  {{0x3fb60ab1, 0x5105d8fa} },
/**/                  {{0x3c535a89, 0x3f2d6492} },
/**/                  {{0xbfb4165b, 0xa0083319} },
/**/                  {{0x3f94ec67, 0x965eb0a7} },
/**/                  {{0x3f974c86, 0xf36231e5} },
/**/                  {{0xbf9dae1f, 0x9c25f4a4} },
/**/                  {{0x3f877b18, 0x183e42dc} } },
/**/                 {{{0x3fe56000, 0x00000000} },
/**/                  {{0x3fe2d84c, 0x2961e48c} },
/**/                  {{0xbc7f2542, 0x0a36e506} },
/**/                  {{0x3fe62091, 0xd0a0e5d4} },
/**/                  {{0x3c82a27d, 0xcccb008e} },
/**/                  {{0xbfd470c0, 0x228ca1b6} },
/**/                  {{0xbc788e9b, 0x32884415} },
/**/                  {{0x3fa31a54, 0xb365e4d9} },
/**/                  {{0x3c3e6e70, 0xda0f99ae} },
/**/                  {{0x3fb5a690, 0xc741ccb7} },
/**/                  {{0xbc383905, 0x6508ffe1} },
/**/                  {{0xbfb3f680, 0x50f46c17} },
/**/                  {{0x3f958c44, 0x1b344c30} },
/**/                  {{0x3f9660bf, 0xb713db8a} },
/**/                  {{0xbf9d434e, 0x5224992a} },
/**/                  {{0x3f87fca0, 0x46ffb16e} } },
/**/                 {{{0x3fe58000, 0x00000000} },
/**/                  {{0x3fe2ee62, 0x8406cbca} },
/**/                  {{0x3c8c5d5e, 0x9ff0cf8d} },
/**/                  {{0x3fe60c24, 0xb0350d38} },
/**/                  {{0x3c81ffe9, 0xf3db4fcb} },
/**/                  {{0xbfd46975, 0xfac420bd} },
/**/                  {{0x3c7e6994, 0x850528a0} },
/**/                  {{0x3fa3c5fa, 0xd098b4ee} },
/**/                  {{0x3c353c41, 0xaa6a6874} },
/**/                  {{0x3fb54311, 0xd57c5b53} },
/**/                  {{0x3c50d02e, 0x72d146e0} },
/**/                  {{0xbfb3d5ba, 0x071017e0} },
/**/                  {{0x3f9625b9, 0xf11b08a7} },
/**/                  {{0x3f957857, 0xe25bbc6f} },
/**/                  {{0xbf9cd64d, 0x7384981f} },
/**/                  {{0x3f8873d7, 0x3da3b8d5} } },
/**/                 {{{0x3fe5a000, 0x00000000} },
/**/                  {{0x3fe30464, 0x753b090b} },
/**/                  {{0xbc73e712, 0x61da18f3} },
/**/                  {{0x3fe5f7be, 0xf9ee77b6} },
/**/                  {{0x3c8949f7, 0x854f9928} },
/**/                  {{0xbfd461ec, 0x099c98f6} },
/**/                  {{0x3c5da491, 0x3eafe889} },
/**/                  {{0x3fa46e87, 0x8ba9e286} },
/**/                  {{0x3c42573a, 0x5377a1a9} },
/**/                  {{0x3fb4e038, 0xfab82ffb} },
/**/                  {{0xbc414e45, 0x402ef939} },
/**/                  {{0xbfb3b412, 0x4a8ec478} },
/**/                  {{0x3f96b8e0, 0xef6dba07} },
/**/                  {{0x3f949360, 0x39c13c6e} },
/**/                  {{0xbf9c674a, 0xd47bfddb} },
/**/                  {{0x3f88e101, 0x37ed6935} } },
/**/                 {{{0x3fe5c000, 0x00000000} },
/**/                  {{0x3fe31a52, 0x048874be} },
/**/                  {{0x3c840cab, 0x87a7ac24} },
/**/                  {{0x3fe5e360, 0xed021586} },
/**/                  {{0x3c86a444, 0xb32ab7e4} },
/**/                  {{0xbfd45a23, 0x779f86c4} },
/**/                  {{0xbc75b9dc, 0x6b782501} },
/**/                  {{0x3fa51400, 0x26af940c} },
/**/                  {{0x3c4f700e, 0xf9ce64e2} },
/**/                  {{0x3fb47e0a, 0x86a8eb42} },
/**/                  {{0xbc5a4df9, 0x36377584} },
/**/                  {{0xbfb39192, 0x7f8b6d42} },
/**/                  {{0x3f9745d1, 0x5deeeabc} },
/**/                  {{0x3f93b1e8, 0x17fa1033} },
/**/                  {{0xbf9bf673, 0x14cf2061} },
/**/                  {{0x3f894463, 0x0a340016} } },
/**/                 {{{0x3fe5e000, 0x00000000} },
/**/                  {{0x3fe3302b, 0x39b78856} },
/**/                  {{0x3c85dd2e, 0xd87ba82b} },
/**/                  {{0x3fe5cf0a, 0xc77d4bea} },
/**/                  {{0xbc8684ab, 0x0d42ab66} },
/**/                  {{0xbfd4521d, 0x6b573e11} },
/**/                  {{0xbc7601b9, 0xb90c9c27} },
/**/                  {{0x3fa5b66a, 0x0582aeaa} },
/**/                  {{0x3c281575, 0x8cc985ad} },
/**/                  {{0x3fb41c8a, 0x9a69373d} },
/**/                  {{0xbc33df07, 0x25ea8f67} },
/**/                  {{0xbfb36e43, 0xe5673a18} },
/**/                  {{0x3f97cca3, 0xeb05f3bc} },
/**/                  {{0x3f92d3fd, 0x7797abe9} },
/**/                  {{0xbf9b83f1, 0x9d71c254} },
/**/                  {{0x3f899e41, 0xfe333861} } },
/**/                 {{{0x3fe60000, 0x00000000} },
/**/                  {{0x3fe345f0, 0x1cce37bb} },
/**/                  {{0x3c810211, 0x37c71102} },
/**/                  {{0x3fe5babc, 0xc647fa91} },
/**/                  {{0x3c84339b, 0x8056eaf3} },
/**/                  {{0xbfd449db, 0x094286d0} },
/**/                  {{0x3c75e178, 0x512b1c7b} },
/**/                  {{0x3fa655ca, 0xac4cf102} },
/**/                  {{0xbc27a1e4, 0x61e8206a} },
/**/                  {{0x3fb3bbbd, 0x2933dd9c} },
/**/                  {{0xbc517633, 0xbd42c006} },
/**/                  {{0xbfb34a2f, 0x9636afc9} },
/**/                  {{0x3f984d71, 0xa2400f6f} },
/**/                  {{0x3f91f9ac, 0xfcc53cab} },
/**/                  {{0xbf9b0ff0, 0x9ec31ef1} },
/**/                  {{0x3f89eee3, 0xb1615b05} } },
/**/                 {{{0x3fe62000, 0x00000000} },
/**/                  {{0x3fe35ba0, 0xb60eccce} },
/**/                  {{0x3c8e3ba1, 0x9b9368b9} },
/**/                  {{0x3fe5a677, 0x25268d22} },
/**/                  {{0x3c7bc76e, 0xaf72cee6} },
/**/                  {{0xbfd4415d, 0x73c8c31c} },
/**/                  {{0xbc3e5b3c, 0xe00e5645} },
/**/                  {{0x3fa6f227, 0xbe1ce1b6} },
/**/                  {{0xbc04a922, 0xe699fcac} },
/**/                  {{0x3fb35ba5, 0xf91f9885} },
/**/                  {{0xbc43f8be, 0x418827b3} },
/**/                  {{0xbfb3255e, 0x863cebc9} },
/**/                  {{0x3f98c853, 0xe315ca66} },
/**/                  {{0x3f912301, 0xff116cac} },
/**/                  {{0xbf9a9a99, 0x0f5e09c2} },
/**/                  {{0x3f8a368d, 0xf4c8d587} } },
/**/                 {{{0x3fe64000, 0x00000000} },
/**/                  {{0x3fe3713d, 0x0df6c504} },
/**/                  {{0xbc54f789, 0xe031606d} },
/**/                  {{0x3fe5923a, 0x1ebc184f} },
/**/                  {{0x3c829fe8, 0xbe5956dd} },
/**/                  {{0xbfd438a5, 0xcb2e9cc9} },
/**/                  {{0xbc7c1839, 0x7d6ce3eb} },
/**/                  {{0x3fa78b86, 0xfb7fa678} },
/**/                  {{0x3befb53e, 0xd082025e} },
/**/                  {{0x3fb2fc48, 0xa3dd5905} },
/**/                  {{0x3c5fd567, 0x06b78682} },
/**/                  {{0xbfb2ffd9, 0x8374843c} },
/**/                  {{0x3f993d64, 0x57f51471} },
/**/                  {{0x3f905006, 0x933f6cc5} },
/**/                  {{0xbf9a2412, 0xab7658df} },
/**/                  {{0x3f8a7586, 0xae624ab4} } },
/**/                 {{{0x3fe66000, 0x00000000} },
/**/                  {{0x3fe386c5, 0x2d3db11f} },
/**/                  {{0xbc8b78e1, 0xcbebe6a0} },
/**/                  {{0x3fe57e05, 0xec8c8203} },
/**/                  {{0x3c8ea585, 0x5e7f92dc} },
/**/                  {{0xbfd42fb5, 0x2d8b381e} },
/**/                  {{0xbc63afe6, 0x5cff451e} },
/**/                  {{0x3fa821ee, 0x4120d643} },
/**/                  {{0xbc3e664f, 0xcbc4d2dc} },
/**/                  {{0x3fb29da8, 0x9778bfdb} },
/**/                  {{0x3c3760dd, 0x7c2057a5} },
/**/                  {{0xbfb2d9a9, 0x3525a55a} },
/**/                  {{0x3f99acbc, 0xed9015c8} },
/**/                  {{0x3f8f0187, 0x2a35e7d2} },
/**/                  {{0xbf99ac83, 0xf4bcdfc7} },
/**/                  {{0x3f8aac13, 0xbbeb4f11} } },
/**/                 {{{0x3fe68000, 0x00000000} },
/**/                  {{0x3fe39c39, 0x1cd4171a} },
/**/                  {{0xbc823043, 0x31d8bf46} },
/**/                  {{0x3fe569da, 0xc6feb417} },
/**/                  {{0x3c803ce5, 0x0625e450} },
/**/                  {{0xbfd4268c, 0xb6bde980} },
/**/                  {{0xbc6e8f76, 0xe8258561} },
/**/                  {{0x3fa8b563, 0x86705749} },
/**/                  {{0x3c418e14, 0xe6172281} },
/**/                  {{0x3fb23fc9, 0x171a8768} },
/**/                  {{0xbc562184, 0x3225d825} },
/**/                  {{0xbfb2b2d6, 0x1b8904fd} },
/**/                  {{0x3f9a1677, 0xca70ce88} },
/**/                  {{0x3f8d6a81, 0x62963581} },
/**/                  {{0xbf993412, 0x32c353bb} },
/**/                  {{0x3f8ada7a, 0xd7354ec0} } },
/**/                 {{{0x3fe6a000, 0x00000000} },
/**/                  {{0x3fe3b198, 0xe5e2564b} },
/**/                  {{0xbc72f922, 0x1f0752ac} },
/**/                  {{0x3fe555b8, 0xe55ed910} },
/**/                  {{0xbc5615bc, 0x656f2eb2} },
/**/                  {{0xbfd41d2d, 0x80646bca} },
/**/                  {{0xbc75d1d6, 0x1ff3506f} },
/**/                  {{0x3fa945ec, 0xdc4e5727} },
/**/                  {{0x3c213c8e, 0x18968922} },
/**/                  {{0x3fb1e2ad, 0x3bcc9fa4} },
/**/                  {{0x3c2b899c, 0x0a43c591} },
/**/                  {{0xbfb28b68, 0x8f774533} },
/**/                  {{0x3f9a7aaf, 0x46d16acc} },
/**/                  {{0x3f8bdb08, 0xde405cc6} },
/**/                  {{0xbf98bae1, 0x73d9884b} },
/**/                  {{0x3f8b0101, 0x7be7742a} } },
/**/                 {{{0x3fe6c000, 0x00000000} },
/**/                  {{0x3fe3c6e4, 0x91c78dc5} },
/**/                  {{0xbc8e1450, 0x94fd0ba7} },
/**/                  {{0x3fe541a0, 0x7de0a269} },
/**/                  {{0x3c8b9072, 0x163b639c} },
/**/                  {{0xbfd41398, 0xa1d194fc} },
/**/                  {{0xbc7ef191, 0x8629402d} },
/**/                  {{0x3fa9d390, 0x6bbd69eb} },
/**/                  {{0x3c488aec, 0xd2c4a6a5} },
/**/                  {{0x3fb18657, 0xf53fbee6} },
/**/                  {{0x3c54e6aa, 0x0104d1dd} },
/**/                  {{0xbfb26368, 0xc2245ee6} },
/**/                  {{0x3f9ad97d, 0xe4b91b16} },
/**/                  {{0x3f8a5328, 0x74b192c7} },
/**/                  {{0xbf984114, 0x8e5d8b31} },
/**/                  {{0x3f8b1fec, 0xceadce82} } },
/**/                 {{{0x3fe6e000, 0x00000000} },
/**/                  {{0x3fe3dc1c, 0x2a188504} },
/**/                  {{0x3c82ce63, 0x70f4e971} },
/**/                  {{0x3fe52d91, 0xc5a197ed} },
/**/                  {{0xbc804b92, 0x1baab820} },
/**/                  {{0xbfd409cf, 0x300486f8} },
/**/                  {{0xbc6d3bb8, 0xae804189} },
/**/                  {{0x3faa5e54, 0x749adab8} },
/**/                  {{0x3c20b0d5, 0xc631cfd3} },
/**/                  {{0x3fb12acc, 0x0a922c54} },
/**/                  {{0x3c521a06, 0x7cbc4417} },
/**/                  {{0xbfb23ade, 0xbce6ae05} },
/**/                  {{0x3f9b32fe, 0x485d279b} },
/**/                  {{0x3f88d2e8, 0xd9b56b96} },
/**/                  {{0xbf97c6cd, 0x227841f4} },
/**/                  {{0x3f8b3781, 0x85cf6ba0} } },
/**/                 {{{0x3fe70000, 0x00000000} },
/**/                  {{0x3fe3f13f, 0xb89e96f4} },
/**/                  {{0x3c7ecf8b, 0x492644f0} },
/**/                  {{0x3fe5198c, 0xf0ab6f99} },
/**/                  {{0x3c71b875, 0x5e1ffaba} },
/**/                  {{0xbfd3ffd2, 0x3da059f4} },
/**/                  {{0x3c5bba8e, 0x77eee53d} },
/**/                  {{0x3faae63f, 0x4c5d36dc} },
/**/                  {{0xbc4e6e4e, 0x2a3994d6} },
/**/                  {{0x3fb0d00c, 0x1b178ada} },
/**/                  {{0x3c4b94c3, 0xb3e710cc} },
/**/                  {{0xbfb211d2, 0x61093929} },
/**/                  {{0x3f9b874b, 0x30c5dd59} },
/**/                  {{0x3f875a50, 0xb0b899ed} },
/**/                  {{0xbf974c2b, 0x9c404912} },
/**/                  {{0x3f8b4803, 0xd3249a4d} } },
/**/                 {{{0x3fe72000, 0x00000000} },
/**/                  {{0x3fe4064f, 0x47569f49} },
/**/                  {{0xbc8aad88, 0xf91bf2b2} },
/**/                  {{0x3fe50592, 0x31f66da7} },
/**/                  {{0xbc8837f1, 0x134b7507} },
/**/                  {{0xbfd3f5a2, 0xdae43e4d} },
/**/                  {{0xbc7f29b0, 0xdc59e382} },
/**/                  {{0x3fab6b57, 0x5cd91a8c} },
/**/                  {{0xbc225bf7, 0xd6ab0dfc} },
/**/                  {{0x3fb0761a, 0x9f216d7a} },
/**/                  {{0x3c577818, 0xe546203e} },
/**/                  {{0xbfb1e84b, 0x67a8cf31} },
/**/                  {{0x3f9bd67f, 0x70b6dd6f} },
/**/                  {{0x3f85e964, 0x9ff677e5} },
/**/                  {{0xbf96d14f, 0x363cf426} },
/**/                  {{0x3f8b51b7, 0x4f6617de} } },
/**/                 {{{0x3fe74000, 0x00000000} },
/**/                  {{0x3fe41b4a, 0xe06fea41} },
/**/                  {{0x3c63d60a, 0x53277652} },
/**/                  {{0x3fe4f1a1, 0xbb6bcc2c} },
/**/                  {{0x3c5c8d69, 0x7c81f558} },
/**/                  {{0xbfd3eb42, 0x15a41364} },
/**/                  {{0x3c728a9c, 0x617c316a} },
/**/                  {{0x3fabeda3, 0x230c44b8} },
/**/                  {{0x3c41fa15, 0x50d9e9da} },
/**/                  {{0x3fb01cf9, 0xe8c87fc3} },
/**/                  {{0x3c410990, 0xa175df34} },
/**/                  {{0xbfb1be51, 0x619b963c} },
/**/                  {{0x3f9c20b5, 0xe7da421c} },
/**/                  {{0x3f848027, 0x637b86b0} },
/**/                  {{0xbf965655, 0xfc436ff1} },
/**/                  {{0x3f8b54de, 0xe6cd859f} } },
/**/                 {{{0x3fe76000, 0x00000000} },
/**/                  {{0x3fe43032, 0x8e4b26d6} },
/**/                  {{0xbc813159, 0x1070b99f} },
/**/                  {{0x3fe4ddbb, 0xbde829f5} },
/**/                  {{0xbc735ff2, 0xb6d17615} },
/**/                  {{0xbfd3e0b0, 0xf941711a} },
/**/                  {{0x3c7d3454, 0xe9027227} },
/**/                  {{0x3fac6d29, 0x2deef5c2} },
/**/                  {{0x3c476533, 0x0ba13bb6} },
/**/                  {{0x3faf8958, 0x496c1e5e} },
/**/                  {{0x3c49ebf2, 0xe1abdf2f} },
/**/                  {{0xbfb193eb, 0xb762a82c} },
/**/                  {{0x3f9c6609, 0x7c2df93f} },
/**/                  {{0x3f831e99, 0xdff7724a} },
/**/                  {{0xbf95db5c, 0xcea82a5a} },
/**/                  {{0x3f8b51bc, 0xc6ff27bb} } },
/**/                 {{{0x3fe78000, 0x00000000} },
/**/                  {{0x3fe44506, 0x5b795b56} },
/**/                  {{0xbc7f76d0, 0x163f79c8} },
/**/                  {{0x3fe4c9e0, 0x693e0015} },
/**/                  {{0xbc7b0fcb, 0x60fff59b} },
/**/                  {{0xbfd3d5f0, 0x8ea521a8} },
/**/                  {{0x3c561573, 0xb5bcc402} },
/**/                  {{0x3face9f0, 0x1d4b9b62} },
/**/                  {{0x3c481226, 0xf2c93cfb} },
/**/                  {{0x3faeda66, 0xb5db8847} },
/**/                  {{0xbc44ec99, 0x3a386670} },
/**/                  {{0xbfb16921, 0xa92559e3} },
/**/                  {{0x3f9ca695, 0x13b2a17d} },
/**/                  {{0x3f81c4bb, 0x355982b3} },
/**/                  {{0xbf95607f, 0x65bec936} },
/**/                  {{0x3f8b4892, 0x4e349f67} } },
/**/                 {{{0x3fe7a000, 0x00000000} },
/**/                  {{0x3fe459c6, 0x52badc7f} },
/**/                  {{0x3c819969, 0x8e8e135c} },
/**/                  {{0x3fe4b60f, 0xec381dcb} },
/**/                  {{0xbc6b9874, 0x4724e4f2} },
/**/                  {{0xbfd3cb01, 0xdc390960} },
/**/                  {{0xbc7243b1, 0x7ba1320c} },
/**/                  {{0x3fad63fe, 0xa09cca72} },
/**/                  {{0x3c48308c, 0xe5ab8d04} },
/**/                  {{0x3fae2d22, 0xdf2eb652} },
/**/                  {{0xbc4988a3, 0x4eb29ad3} },
/**/                  {{0xbfb13dfa, 0x4eb5cb96} },
/**/                  {{0x3f9ce273, 0x8e5b2657} },
/**/                  {{0x3f807288, 0xd132be74} },
/**/                  {{0xbf94e5d8, 0x55a31e9e} },
/**/                  {{0x3f8b399f, 0xfba00cb2} } },
/**/                 {{{0x3fe7c000, 0x00000000} },
/**/                  {{0x3fe46e72, 0x7efe4716} },
/**/                  {{0xbc639b9b, 0x1b844cc9} },
/**/                  {{0x3fe4a24a, 0x749c2a47} },
/**/                  {{0xbc8f9d05, 0x82d8a2e5} },
/**/                  {{0xbfd3bfe5, 0xe5e27a03} },
/**/                  {{0xbc5047da, 0xb30f6d58} },
/**/                  {{0x3faddb5b, 0x75f185ec} },
/**/                  {{0x3c43b680, 0x23d5084a} },
/**/                  {{0x3fad8190, 0x479061d2} },
/**/                  {{0xbbf4565c, 0x602d3547} },
/**/                  {{0xbfb1127c, 0x979e619e} },
/**/                  {{0x3f9d19bf, 0xc03c4720} },
/**/                  {{0x3f7e4ffd, 0x01b2b45f} },
/**/                  {{0xbf946b81, 0x1245b0bb} },
/**/                  {{0x3f8b2525, 0x60fec8ec} } },
/**/                 {{{0x3fe7e000, 0x00000000} },
/**/                  {{0x3fe4830a, 0xeb5f7bfe} },
/**/                  {{0xbc5a2656, 0x66764a73} },
/**/                  {{0x3fe48e90, 0x2f2d2be4} },
/**/                  {{0x3c810a8e, 0x969bba3b} },
/**/                  {{0xbfd3b49d, 0xacfcef4d} },
/**/                  {{0xbc6a4f98, 0xb7a61548} },
/**/                  {{0x3fae500d, 0x68d7d101} },
/**/                  {{0xbc305c3e, 0x04860c21} },
/**/                  {{0x3facd7b2, 0x2c98ea9c} },
/**/                  {{0x3c48692b, 0xd46adca0} },
/**/                  {{0xbfb0e6af, 0x4b37c6a5} },
/**/                  {{0x3f9d4c94, 0x6bfb2662} },
/**/                  {{0x3f7bca2d, 0x0692cc75} },
/**/                  {{0xbf93f191, 0xf3b69312} },
/**/                  {{0x3f8b0b61, 0x1552b8ee} } },
/**/                 {{{0x3fe80000, 0x00000000} },
/**/                  {{0x3fe4978f, 0xa3269ee1} },
/**/                  {{0x3c72419a, 0x87f2a458} },
/**/                  {{0x3fe47ae1, 0x47ae147b} },
/**/                  {{0xbc6eb851, 0xeb851eb8} },
/**/                  {{0xbfd3a92a, 0x30553261} },
/**/                  {{0xbc7f06f6, 0x94467382} },
/**/                  {{0x3faec21b, 0x514d88d8} },
/**/                  {{0x3c3cd061, 0xf45873a6} },
/**/                  {{0x3fac2f8b, 0x88dfb80c} },
/**/                  {{0xbc14fcbc, 0x53add20b} },
/**/                  {{0xbfb0ba99, 0x08c71945} },
/**/                  {{0x3f9d7b0c, 0x3d79f13f} },
/**/                  {{0x3f795393, 0x357dfc67} },
/**/                  {{0xbf937822, 0x3aa97829} },
/**/                  {{0x3f8aec90, 0xa8b90db0} } },
/**/                 {{{0x3fe82000, 0x00000000} },
/**/                  {{0x3fe4ac00, 0xb1c71762} },
/**/                  {{0x3c8b20e7, 0x2382b900} },
/**/                  {{0x3fe4673d, 0xe8e45252} },
/**/                  {{0x3c57d208, 0x67458f9c} },
/**/                  {{0xbfd39d8c, 0x6c24e1b3} },
/**/                  {{0xbc7830c5, 0x973c6d15} },
/**/                  {{0x3faf318c, 0x12b78147} },
/**/                  {{0xbc4fa440, 0xd318184c} },
/**/                  {{0x3fab891f, 0x158b44e7} },
/**/                  {{0x3c4d5f9f, 0x45d7f1f3} },
/**/                  {{0xbfb08e40, 0x47a3e8ba} },
/**/                  {{0x3f9da541, 0xc4c1a21a} },
/**/                  {{0x3f76ec1e, 0x3c0d1d71} },
/**/                  {{0xbf92ff48, 0x152e0bfc} },
/**/                  {{0x3f8ac8f0, 0x9955298f} } },
/**/                 {{{0x3fe84000, 0x00000000} },
/**/                  {{0x3fe4c05e, 0x22de94e5} },
/**/                  {{0xbc8c0ac1, 0xf09f2edf} },
/**/                  {{0x3fe453a6, 0x3c9a6560} },
/**/                  {{0x3c77a95f, 0x828bba02} },
/**/                  {{0xbfd391c5, 0x5a0e5b1c} },
/**/                  {{0x3c7d553d, 0xcd3f76d2} },
/**/                  {{0x3faf9e66, 0x9adede86} },
/**/                  {{0xbc225e54, 0xd6d2bac0} },
/**/                  {{0x3faae46f, 0x4bdf89d7} },
/**/                  {{0x3c39c98c, 0x2b25b8d9} },
/**/                  {{0xbfb061ab, 0x5765a5c1} },
/**/                  {{0x3f9dcb4f, 0x7127d649} },
/**/                  {{0x3f7493ba, 0x13002646} },
/**/                  {{0xbf928718, 0xa397d1a6} },
/**/                  {{0x3f8aa0bc, 0x494648b5} } },
/**/                 {{{0x3fe86000, 0x00000000} },
/**/                  {{0x3fe4d4a8, 0x023414e8} },
/**/                  {{0x3c6e3a89, 0x1daa88b0} },
/**/                  {{0x3fe4401a, 0x6ba2786e} },
/**/                  {{0xbc4b8213, 0xe3b5f317} },
/**/                  {{0xbfd385d5, 0xf11905c0} },
/**/                  {{0xbc72a1e9, 0xa2f42dd1} },
/**/                  {{0x3fb00458, 0xf07a526f} },
/**/                  {{0xbc14f965, 0xac5fd817} },
/**/                  {{0x3faa417e, 0x66ca7da2} },
/**/                  {{0x3c4b1e1a, 0xa050b433} },
/**/                  {{0xbfb034e0, 0x60182e4f} },
/**/                  {{0x3f9ded4f, 0x8cafa41b} },
/**/                  {{0x3f724a50, 0x1fa4f037} },
/**/                  {{0xbf920fa7, 0xfd90e915} },
/**/                  {{0x3f8a742d, 0xf59e7acf} } },
/**/                 {{{0x3fe88000, 0x00000000} },
/**/                  {{0x3fe4e8de, 0x5bb6ec04} },
/**/                  {{0x3c84a33d, 0xbeb3796c} },
/**/                  {{0x3fe42c9a, 0x9dd8fdc1} },
/**/                  {{0x3c5192da, 0xaf80050b} },
/**/                  {{0xbfd379bf, 0x25adf97f} },
/**/                  {{0xbc774019, 0x20cd3651} },
/**/                  {{0x3fb0383a, 0x724dbb01} },
/**/                  {{0x3c5c4e67, 0xeb93e538} },
/**/                  {{0x3fa9a04e, 0x646e65df} },
/**/                  {{0x3c21a7cb, 0x894a6b77} },
/**/                  {{0xbfb007e5, 0x62771c79} },
/**/                  {{0x3f9e0b5c, 0x37a45544} },
/**/                  {{0x3f700fc7, 0x54993092} },
/**/                  {{0xbf919909, 0x37534c25} },
/**/                  {{0x3f8a437e, 0xae51732a} } },
/**/                 {{{0x3fe8a000, 0x00000000} },
/**/                  {{0x3fe4fd01, 0x3b7dd17e} },
/**/                  {{0x3c7d513f, 0x3e7c24b5} },
/**/                  {{0x3fe41926, 0xfa274ef1} },
/**/                  {{0x3c8ad830, 0x4d72ecb3} },
/**/                  {{0xbfd36d81, 0xe995018a} },
/**/                  {{0x3c7e7ec5, 0x6fd6094d} },
/**/                  {{0x3fb06adb, 0x567bb975} },
/**/                  {{0x3c5212c1, 0xf0d7364f} },
/**/                  {{0x3fa900e1, 0x07a9b624} },
/**/                  {{0xbc4e5b5b, 0xc16bcc85} },
/**/                  {{0xbfafb580, 0x705f052b} },
/**/                  {{0x3f9e258f, 0x646ce12e} },
/**/                  {{0x3f6bc808, 0xa3c63841} },
/**/                  {{0xbf91234e, 0x67043d41} },
/**/                  {{0x3f8a0ee6, 0x4f11b221} } },
/**/                 {{{0x3fe8c000, 0x00000000} },
/**/                  {{0x3fe51110, 0xadc5ed81} },
/**/                  {{0x3c723dcd, 0x6832a63e} },
/**/                  {{0x3fe405bf, 0xa6864f90} },
/**/                  {{0xbc7419c5, 0x662cd5df} },
/**/                  {{0xbfd3611f, 0x2bf1f7e4} },
/**/                  {{0xbc6e94dd, 0x65483b78} },
/**/                  {{0x3fb09c3f, 0x23e21be9} },
/**/                  {{0x3c22db63, 0xcaca858d} },
/**/                  {{0x3fa86337, 0xd99c3f1d} },
/**/                  {{0x3c034382, 0xdc0a6dfc} },
/**/                  {{0xbfaf5aed, 0x284f8093} },
/**/                  {{0x3f9e3c02, 0xd396fb43} },
/**/                  {{0x3f678dd3, 0x08b96150} },
/**/                  {{0xbf90ae88, 0xaa2dcc3a} },
/**/                  {{0x3f89d69b, 0x79128ee7} } },
/**/                 {{{0x3fe8e000, 0x00000000} },
/**/                  {{0x3fe5250c, 0xbef1e9fb} },
/**/                  {{0xbc5539b7, 0xa3228870} },
/**/                  {{0x3fe3f264, 0xc8011245} },
/**/                  {{0xbc6641f1, 0x44cc720b} },
/**/                  {{0xbfd35497, 0xd942778a} },
/**/                  {{0x3c750a5a, 0x9bd7dbd6} },
/**/                  {{0x3fb0cc69, 0x6438739e} },
/**/                  {{0x3bf5d933, 0x435f798d} },
/**/                  {{0x3fa7c754, 0x2b29722f} },
/**/                  {{0xbbe736fe, 0x5b3af27b} },
/**/                  {{0xbfaf001c, 0x059a3c24} },
/**/                  {{0x3f9e4ed0, 0x101882b0} },
/**/                  {{0x3f6370ae, 0x88dc4269} },
/**/                  {{0xbf903ac8, 0x2b5280b6} },
/**/                  {{0x3f899ad3, 0x8da5b2ad} } },
/**/                 {{{0x3fe90000, 0x00000000} },
/**/                  {{0x3fe538f5, 0x7b89061f} },
/**/                  {{0xbc81bb74, 0xabda520c} },
/**/                  {{0x3fe3df16, 0x82b78014} },
/**/                  {{0xbc7074be, 0xa43ff610} },
/**/                  {{0xbfd347ec, 0xdb5be2e4} },
/**/                  {{0x3c7848c8, 0x8a0e9303} },
/**/                  {{0x3fb0fb5d, 0xa3a11be4} },
/**/                  {{0x3c3d68f2, 0x09dd0d69} },
/**/                  {{0x3fa72d37, 0x16778170} },
/**/                  {{0xbc4ea85d, 0x2200d1d4} },
/**/                  {{0xbfaea517, 0xd4cdbd49} },
/**/                  {{0x3f9e5e10, 0x6bc61b6f} },
/**/                  {{0x3f5ee0af, 0xd0517524} },
/**/                  {{0xbf8f9038, 0x4f2ec799} },
/**/                  {{0x3f895bc2, 0xa9aaa5bb} } },
/**/                 {{{0x3fe92000, 0x00000000} },
/**/                  {{0x3fe54cca, 0xf0362c8f} },
/**/                  {{0x3c88a324, 0x7f8f43c1} },
/**/                  {{0x3fe3cbd4, 0xf9e1016e} },
/**/                  {{0xbc88dea6, 0x431b67e7} },
/**/                  {{0xbfd33b1f, 0x1969bc63} },
/**/                  {{0x3c6ef16e, 0x5f3d8fd8} },
/**/                  {{0x3fb1291f, 0x703d3bf6} },
/**/                  {{0xbc566e82, 0xb04e0672} },
/**/                  {{0x3fa694e1, 0x806b26f2} },
/**/                  {{0x3c302819, 0xafcee740} },
/**/                  {{0xbfae49eb, 0x16dcee96} },
/**/                  {{0x3f9e69dc, 0xfbfdb35f} },
/**/                  {{0x3f571910, 0x70c48510} },
/**/                  {{0xbf8ead25, 0xe90198c8} },
/**/                  {{0x3f89199b, 0xa1c723cb} } },
/**/                 {{{0x3fe94000, 0x00000000} },
/**/                  {{0x3fe5608d, 0x29c70c34} },
/**/                  {{0x3c89939c, 0xf0de8088} },
/**/                  {{0x3fe3b8a0, 0x4fcf28c3} },
/**/                  {{0xbc469c2b, 0xcb80013c} },
/**/                  {{0xbfd32e2f, 0x77ec4ef9} },
/**/                  {{0x3c7f9d06, 0xc61f7341} },
/**/                  {{0x3fb155b2, 0x59c3bcdf} },
/**/                  {{0xbc2d692e, 0x3583c01b} },
/**/                  {{0x3fa5fe54, 0x1a1fe15d} },
/**/                  {{0x3c430dc5, 0x5d9bad81} },
/**/                  {{0xbfadeea0, 0x01d944a8} },
/**/                  {{0x3f9e724e, 0x9683b244} },
/**/                  {{0x3f4f13d4, 0x491379ef} },
/**/                  {{0xbf8dcc74, 0x0b7cf74b} },
/**/                  {{0x3f88d48f, 0xff5f0625} } },
/**/                 {{{0x3fe96000, 0x00000000} },
/**/                  {{0x3fe5743c, 0x352b33ba} },
/**/                  {{0xbc8ea00d, 0x34c87ea6} },
/**/                  {{0x3fe3a578, 0xa5f05e48} },
/**/                  {{0xbc8ba1ec, 0x00e4639b} },
/**/                  {{0xbfd3211e, 0xd8b7a43f} },
/**/                  {{0xbc6d4b54, 0x676e23a8} },
/**/                  {{0x3fb18119, 0xf11b2c2d} },
/**/                  {{0x3c34855b, 0x3a3bf5fa} },
/**/                  {{0x3fa5698f, 0x625c76bf} },
/**/                  {{0xbc2f758a, 0xbedb0264} },
/**/                  {{0xbfad9340, 0x81b60103} },
/**/                  {{0x3f9e777d, 0xce91900f} },
/**/                  {{0x3f406543, 0x34fddb2f} },
/**/                  {{0xbf8cee3b, 0xe6077f81} },
/**/                  {{0x3f888ccf, 0xfe42afde} } },
/**/                 {{{0x3fe98000, 0x00000000} },
/**/                  {{0x3fe587d8, 0x1f732fbb} },
/**/                  {{0xbc75e5c9, 0xd8c5a950} },
/**/                  {{0x3fe3925e, 0x1cd28c98} },
/**/                  {{0x3c8c8443, 0x1ffec6da} },
/**/                  {{0xbfd313ee, 0x1af2c622} },
/**/                  {{0x3c0a0e9b, 0xbc3f7ac8} },
/**/                  {{0x3fb1ab59, 0xc7f683c3} },
/**/                  {{0x3c5eaf17, 0x12c04500} },
/**/                  {{0x3fa4d693, 0xa7039179} },
/**/                  {{0xbc4c8d74, 0xa4ce58a2} },
/**/                  {{0xbfad37d6, 0x391400b3} },
/**/                  {{0x3f9e7982, 0xf2148a36} },
/**/                  {{0x3f112956, 0xb6df63ca} },
/**/                  {{0xbf8c1294, 0xfbd0f7ee} },
/**/                  {{0x3f88428a, 0x8b0b0a0e} } },
/**/                 {{{0x3fe9a000, 0x00000000} },
/**/                  {{0x3fe59b60, 0xf5cfab9e} },
/**/                  {{0xbc81b04c, 0x41026bc5} },
/**/                  {{0x3fe37f50, 0xd425cdfc} },
/**/                  {{0x3c865633, 0x518aef64} },
/**/                  {{0xbfd3069e, 0x1b1749db} },
/**/                  {{0xbc311c20, 0xa119d9bc} },
/**/                  {{0x3fb1d475, 0x7074cee3} },
/**/                  {{0xbc5102e0, 0x4ff61e2c} },
/**/                  {{0x3fa44561, 0x06804def} },
/**/                  {{0x3c4e829f, 0xc3865804} },
/**/                  {{0xbfacdc6a, 0x82158836} },
/**/                  {{0x3f9e7876, 0x071b2eec} },
/**/                  {{0xbf375b85, 0xf17c4beb} },
/**/                  {{0xbf8b3995, 0x2fa03971} },
/**/                  {{0x3f87f5ed, 0x421a433b} } },
/**/                 {{{0x3fe9c000, 0x00000000} },
/**/                  {{0x3fe5aed6, 0xc5909517} },
/**/                  {{0x3c87312f, 0x714a9436} },
/**/                  {{0x3fe36c50, 0xeabf19f5} },
/**/                  {{0x3c70d1dc, 0x52485cca} },
/**/                  {{0xbfd2f92f, 0xb2f12226} },
/**/                  {{0x3c5400ba, 0x3e5d3d61} },
/**/                  {{0x3fb1fc70, 0x7cc3a41b} },
/**/                  {{0x3c4b58e7, 0x8819ff5b} },
/**/                  {{0x3fa3b5f7, 0x712e9269} },
/**/                  {{0xbc4e436a, 0x7879d8ab} },
/**/                  {{0xbfac8106, 0x6f398221} },
/**/                  {{0x3f9e746e, 0xc97073c7} },
/**/                  {{0xbf4914de, 0xecfc2d6a} },
/**/                  {{0xbf8a6350, 0xcfa74bd5} },
/**/                  {{0x3f87a724, 0x6f38ad9e} } },
/**/                 {{{0x3fe9e000, 0x00000000} },
/**/                  {{0x3fe5c239, 0x9c244261} },
/**/                  {{0xbc831bd4, 0xe9e56b35} },
/**/                  {{0x3fe3595e, 0x7e9af2dc} },
/**/                  {{0x3c81ef2d, 0x9dc90e6a} },
/**/                  {{0xbfd2eba3, 0xb99eb689} },
/**/                  {{0xbc7b12ef, 0x6a2f2701} },
/**/                  {{0x3fb2234e, 0x7ec46b9b} },
/**/                  {{0x3c59f30c, 0x8d415d66} },
/**/                  {{0x3fa32856, 0xaabf0d26} },
/**/                  {{0xbc122571, 0x3f33d7ea} },
/**/                  {{0xbfac25b2, 0xcc3da9ce} },
/**/                  {{0x3f9e6d84, 0xa8630cad} },
/**/                  {{0xbf5308c5, 0xbeba707a} },
/**/                  {{0xbf898fda, 0xa1585fd1} },
/**/                  {{0x3f87565b, 0x0dc54356} } },
/**/                 {{{0x3fea0000, 0x00000000} },
/**/                  {{0x3fe5d589, 0x87169b18} },
/**/                  {{0x3c60028e, 0x4bc5e7ca} },
/**/                  {{0x3fe34679, 0xace01346} },
/**/                  {{0x3c8e6b38, 0x04d19e6b} },
/**/                  {{0xbfd2ddfb, 0x03913da2} },
/**/                  {{0xbc763ec8, 0x9a19adbd} },
/**/                  {{0x3fb24913, 0x07b46905} },
/**/                  {{0xbc4e7be8, 0xd6f0307f} },
/**/                  {{0x3fa29c7e, 0x4b96b773} },
/**/                  {{0xbc24c2cd, 0x9182d783} },
/**/                  {{0xbfabca78, 0x1f071f44} },
/**/                  {{0x3f9e63ce, 0xc4b7b7c4} },
/**/                  {{0xbf59529a, 0x125f35b0} },
/**/                  {{0xbf88bf43, 0xed369b2b} },
/**/                  {{0x3f8703ba, 0xc97185cd} } },
/**/                 {{{0x3fea2000, 0x00000000} },
/**/                  {{0x3fe5e8c6, 0x941043d0} },
/**/                  {{0xbc70bf75, 0xbe451e70} },
/**/                  {{0x3fe333a2, 0x91e21aec} },
/**/                  {{0x3c7ae035, 0x7acfc84f} },
/**/                  {{0xbfd2d036, 0x628d5861} },
/**/                  {{0x3c67c5fb, 0xe463d006} },
/**/                  {{0x3fb26dc1, 0xa7d77fb2} },
/**/                  {{0xbc5432bd, 0xc47ba861} },
/**/                  {{0x3fa2126d, 0xc229bece} },
/**/                  {{0xbc4be1bf, 0x1da8ed9e} },
/**/                  {{0xbfab6f5e, 0xa890e568} },
/**/                  {{0x3f9e5763, 0xeec5339a} },
/**/                  {{0xbf5f68a6, 0x5274aa52} },
/**/                  {{0xbf87f19c, 0x8a9df558} },
/**/                  {{0x3f86af6b, 0xff809dc5} } },
/**/                 {{{0x3fea4000, 0x00000000} },
/**/                  {{0x3fe5fbf0, 0xd0d5cc4a} },
/**/                  {{0xbc5b4cfd, 0x000b7158} },
/**/                  {{0x3fe320d9, 0x49243ad8} },
/**/                  {{0xbc8ce5e0, 0x433f7be5} },
/**/                  {{0xbfd2c256, 0xa5abec2f} },
/**/                  {{0xbc68785b, 0x04494dc1} },
/**/                  {{0x3fb2915d, 0xee25a81c} },
/**/                  {{0x3c3e7045, 0x68b37e8b} },
/**/                  {{0x3fa18a24, 0x5451b7d2} },
/**/                  {{0xbc3b2d29, 0x79d21dd5} },
/**/                  {{0xbfab146e, 0x65dfcf66} },
/**/                  {{0x3f9e485a, 0xa4b895b9} },
/**/                  {{0xbf62a5d4, 0x14770b65} },
/**/                  {{0xbf8726f2, 0xeb7dab0f} },
/**/                  {{0x3f865995, 0xc081d40d} } },
/**/                 {{{0x3fea6000, 0x00000000} },
/**/                  {{0x3fe60f08, 0x4b46e05f} },
/**/                  {{0xbc8dbb86, 0x99945193} },
/**/                  {{0x3fe30e1d, 0xed5be099} },
/**/                  {{0x3c6c6e78, 0x373fae45} },
/**/                  {{0xbfd2b45c, 0x995b3a02} },
/**/                  {{0x3c7cb97b, 0xe7cea2ad} },
/**/                  {{0x3fb2b3eb, 0x67fb0cde} },
/**/                  {{0xbc402927, 0x4920d50b} },
/**/                  {{0x3fa103a1, 0x209f00e4} },
/**/                  {{0xbc36fb57, 0xecac275a} },
/**/                  {{0xbfaab9af, 0x10fb6629} },
/**/                  {{0x3f9e36c9, 0x1100b94a} },
/**/                  {{0xbf657e30, 0x58620e6c} },
/**/                  {{0xbf865f54, 0x2801158e} },
/**/                  {{0x3f86025d, 0xd27eaf07} } },
/**/                 {{{0x3fea8000, 0x00000000} },
/**/                  {{0x3fe6220d, 0x115d7b8e} },
/**/                  {{0xbc62b785, 0x350ee8c1} },
/**/                  {{0x3fe2fb70, 0x98736048} },
/**/                  {{0x3c87a751, 0x4df7c4fa} },
/**/                  {{0xbfd2a649, 0x07603054} },
/**/                  {{0x3c7c41eb, 0xf564247c} },
/**/                  {{0x3fb2d56d, 0xa0cac592} },
/**/                  {{0x3c333138, 0x4e757ddf} },
/**/                  {{0x3fa07ee3, 0x1fa53ce5} },
/**/                  {{0xbc41bd0c, 0x28113a76} },
/**/                  {{0xbfaa5f28, 0x21eb5271} },
/**/                  {{0x3f9e22c5, 0x08df7f4f} },
/**/                  {{0xbf683dca, 0x107b528f} },
/**/                  {{0xbf859acc, 0x0a22f693} },
/**/                  {{0x3f85a9e8, 0xb39536ba} } },
/**/                 {{{0x3feaa000, 0x00000000} },
/**/                  {{0x3fe634ff, 0x312d1f3b} },
/**/                  {{0x3c89d2f3, 0x15f2b598} },
/**/                  {{0x3fe2e8d1, 0x638c9d15} },
/**/                  {{0x3c831ae5, 0xfe1a437d} },
/**/                  {{0xbfd2981c, 0xb6d7f622} },
/**/                  {{0xbc53da87, 0x86e9fe4d} },
/**/                  {{0x3fb2f5e8, 0x21d425b2} },
/**/                  {{0xbc186482, 0xae2616cb} },
/**/                  {{0x3f9ff7d2, 0x4a85a0e4} },
/**/                  {{0xbc294288, 0xe2d9205b} },
/**/                  {{0xbfaa04e0, 0xcfb8dc09} },
/**/                  {{0x3f9e0c64, 0x0b1f9c73} },
/**/                  {{0xbf6ae504, 0xbd3845d8} },
/**/                  {{0xbf84d965, 0x19278cae} },
/**/                  {{0x3f855059, 0x9cf7183b} } },
/**/                 {{{0x3feac000, 0x00000000} },
/**/                  {{0x3fe647de, 0xb8e20b90} },
/**/                  {{0xbc5eca04, 0x023a51cf} },
/**/                  {{0x3fe2d640, 0x6703b033} },
/**/                  {{0x3c870ae6, 0x38039b02} },
/**/                  {{0xbfd289d8, 0x6c39acf5} },
/**/                  {{0xbc71f038, 0x0238a7ee} },
/**/                  {{0x3fb3155e, 0x71da955f} },
/**/                  {{0xbc5faa02, 0xd41f84df} },
/**/                  {{0x3f9ef563, 0xc3c69caa} },
/**/                  {{0x3c331d29, 0x75403dbd} },
/**/                  {{0xbfa9aae0, 0x1174124f} },
/**/                  {{0x3f9df3bb, 0x3eedb30b} },
/**/                  {{0xbf6d7445, 0x1c632765} },
/**/                  {{0xbf841b28, 0xa4fa03e7} },
/**/                  {{0x3f84f5d2, 0x8646990d} } },
/**/                 {{{0x3feae000, 0x00000000} },
/**/                  {{0x3fe65aab, 0xb6c07b03} },
/**/                  {{0xbc67939b, 0x3af32729} },
/**/                  {{0x3fe2c3bd, 0xba718de8} },
/**/                  {{0xbc82d2fc, 0xc4990a2b} },
/**/                  {{0xbfd27b7c, 0xe9586818} },
/**/                  {{0x3c780d5e, 0x880839ca} },
/**/                  {{0x3fb333d4, 0x14dfe9e3} },
/**/                  {{0x3c536469, 0xbce74cae} },
/**/                  {{0x3f9df677, 0xc77983b8} },
/**/                  {{0x3c373272, 0xb42f53aa} },
/**/                  {{0xbfa9512c, 0x9f3c360e} },
/**/                  {{0x3f9dd8df, 0x72d37b24} },
/**/                  {{0xbf6febf1, 0x02e417f5} },
/**/                  {{0xbf83601e, 0xd16a1579} },
/**/                  {{0x3f849a74, 0x294a83e4} } },
/**/                 {{{0x3feb0000, 0x00000000} },
/**/                  {{0x3fe66d66, 0x3923e087} },
/**/                  {{0xbc76ea6f, 0xebe8bbba} },
/**/                  {{0x3fe2b149, 0x74aea886} },
/**/                  {{0x3c868ffd, 0xa9d6d16a} },
/**/                  {{0xbfd26d0a, 0xed65571e} },
/**/                  {{0x3c6cf972, 0x476fb5f2} },
/**/                  {{0x3fb3514c, 0x8be1339f} },
/**/                  {{0x3c5c8c0f, 0x3f722216} },
/**/                  {{0x3f9cfb0b, 0x300f8f9b} },
/**/                  {{0xbc0edd81, 0x38d1c932} },
/**/                  {{0xbfa8f7cc, 0xf34b004f} },
/**/                  {{0x3f9dbbe5, 0x1bd3bde0} },
/**/                  {{0xbf712637, 0x9bf7dceb} },
/**/                  {{0xbf82a84e, 0xa146e5b2} },
/**/                  {{0x3f843e5e, 0x05f2718e} } },
/**/                 {{{0x3feb2000, 0x00000000} },
/**/                  {{0x3fe6800e, 0x4e7e2858} },
/**/                  {{0xbc58ea6a, 0x1b3e90f0} },
/**/                  {{0x3fe29ee3, 0xabd5912c} },
/**/                  {{0xbc61b3cd, 0xb17c28e3} },
/**/                  {{0xbfd25e83, 0x34f221eb} },
/**/                  {{0xbc74c483, 0xfa300585} },
/**/                  {{0x3fb36dcb, 0x5495f6e3} },
/**/                  {{0x3c59b55b, 0x311973fe} },
/**/                  {{0x3f9c031a, 0x9864d139} },
/**/                  {{0x3c28fdf3, 0xbd00e171} },
/**/                  {{0xbfa89ec7, 0x4b026585} },
/**/                  {{0x3f9d9ce0, 0x54a5ed3d} },
/**/                  {{0xbf724b13, 0xa8cb6dfc} },
/**/                  {{0xbf81f3be, 0x015469a9} },
/**/                  {{0x3f83e1ae, 0x66a50a89} } },
/**/                 {{{0x3feb4000, 0x00000000} },
/**/                  {{0x3fe692a4, 0x0556fb6a} },
/**/                  {{0x3c8d94b9, 0x5a8ea2cc} },
/**/                  {{0x3fe28c8c, 0x75459603} },
/**/                  {{0x3c8b1c3b, 0x2945fc08} },
/**/                  {{0xbfd24fe6, 0x79f37468} },
/**/                  {{0xbc4e3751, 0x0ec1ef94} },
/**/                  {{0x3fb38953, 0xe931c53b} },
/**/                  {{0xbc3b108d, 0x16d80688} },
/**/                  {{0x3f9b0ea2, 0x5e1b50b5} },
/**/                  {{0x3c0074c0, 0x63fd1067} },
/**/                  {{0xbfa84621, 0xa7fc7800} },
/**/                  {{0x3f9d7be4, 0xdd10256e} },
/**/                  {{0xbf7364c0, 0xc9592c5e} },
/**/                  {{0xbf814271, 0xd318d707} },
/**/                  {{0x3f838482, 0x64d217b8} } },
/**/                 {{{0x3feb6000, 0x00000000} },
/**/                  {{0x3fe6a527, 0x6c4b0576} },
/**/                  {{0xbc8f6b65, 0x9c46a69e} },
/**/                  {{0x3fe27a43, 0xe5a55de9} },
/**/                  {{0x3c66846e, 0xedc25d49} },
/**/                  {{0xbfd24135, 0x73c3b821} },
/**/                  {{0xbc79202a, 0x56ab5808} },
/**/                  {{0x3fb3a3e9, 0xc0282c84} },
/**/                  {{0x3c4057ca, 0x03d25dab} },
/**/                  {{0x3f9a1d9e, 0xa3eb854d} },
/**/                  {{0xbc3775ed, 0xf03e2fb1} },
/**/                  {{0xbfa7ede1, 0xd11d1043} },
/**/                  {{0x3f9d5906, 0x195e6961} },
/**/                  {{0xbf747373, 0x65130256} },
/**/                  {{0xbf80946d, 0xf77fd664} },
/**/                  {{0x3f8326f5, 0xedc272c2} } },
/**/                 {{{0x3feb8000, 0x00000000} },
/**/                  {{0x3fe6b798, 0x920b3d99} },
/**/                  {{0xbc8a8038, 0x6188c50e} },
/**/                  {{0x3fe2680a, 0x10e5813e} },
/**/                  {{0xbc8f5497, 0x2242a6bc} },
/**/                  {{0xbfd23270, 0xd725fa1c} },
/**/                  {{0x3c757282, 0x5c781b14} },
/**/                  {{0x3fb3bd90, 0x4bf2f124} },
/**/                  {{0x3c31ae9c, 0x6a14ed74} },
/**/                  {{0x3f99300b, 0x53ea1533} },
/**/                  {{0x3c2a8d88, 0x68f98d7e} },
/**/                  {{0xbfa7960d, 0x53a4e537} },
/**/                  {{0x3f9d3457, 0x11f5f086} },
/**/                  {{0xbf757760, 0x19baa1da} },
/**/                  {{0xbf7fd36a, 0xb2a2ca7e} },
/**/                  {{0x3f82c923, 0xc7a02081} } },
/**/                 {{{0x3feba000, 0x00000000} },
/**/                  {{0x3fe6c9f7, 0x855c3198} },
/**/                  {{0x3c7c09de, 0x29bd280d} },
/**/                  {{0x3fe255df, 0x0a431fbd} },
/**/                  {{0x3c8d9866, 0xf09a745d} },
/**/                  {{0xbfd22399, 0x5648fb1f} },
/**/                  {{0x3c412100, 0xb4df0b3e} },
/**/                  {{0x3fb3d64a, 0xfada8899} },
/**/                  {{0x3c3dd891, 0x659c4346} },
/**/                  {{0x3f9845e4, 0x21c2d0a1} },
/**/                  {{0x3c28c6b1, 0xf397827c} },
/**/                  {{0xbfa73ea9, 0x8445c1cc} },
/**/                  {{0x3f9d0dea, 0x730360f8} },
/**/                  {{0xbf7670bb, 0xac51ce30} },
/**/                  {{0xbf7e8493, 0xeef50deb} },
/**/                  {{0x3f826b25, 0x96b119a9} } },
/**/                 {{{0x3febc000, 0x00000000} },
/**/                  {{0x3fe6dc44, 0x551553af} },
/**/                  {{0xbc5bf886, 0x3573828e} },
/**/                  {{0x3fe243c2, 0xe44a7335} },
/**/                  {{0xbc667287, 0x65d1ffd7} },
/**/                  {{0xbfd214af, 0xa0ca68d3} },
/**/                  {{0xbc71296c, 0x88820895} },
/**/                  {{0x3fb3ee1d, 0x36c0c9a2} },
/**/                  {{0x3c540bf6, 0x831dfabe} },
/**/                  {{0x3f975f24, 0x8ce8de84} },
/**/                  {{0xbc125368, 0x43eb5853} },
/**/                  {{0xbfa6e7bb, 0x803788f8} },
/**/                  {{0x3f9ce5d2, 0x8c42d5f9} },
/**/                  {{0xbf775fba, 0xfaadb3ab} },
/**/                  {{0xbf7d3c59, 0xde4c28da} },
/**/                  {{0x3f820d13, 0xe2bf7ef5} } },
/**/                 {{{0x3febe000, 0x00000000} },
/**/                  {{0x3fe6ee7f, 0x10204aef} },
/**/                  {{0x3c8692ee, 0xa3066272} },
/**/                  {{0x3fe231b5, 0xb0d95ee5} },
/**/                  {{0x3c7aae7e, 0x1eb505b6} },
/**/                  {{0xbfd205b4, 0x63ba3e08} },
/**/                  {{0x3c71c6d1, 0xb975517d} },
/**/                  {{0x3fb4050a, 0x64edc729} },
/**/                  {{0x3c4960ed, 0x715db809} },
/**/                  {{0x3f967bc7, 0xe2bc143b} },
/**/                  {{0xbc2cbf17, 0xf0823143} },
/**/                  {{0xbfa69148, 0x2e4dbc47} },
/**/                  {{0x3f9cbc21, 0x50e0982e} },
/**/                  {{0xbf784492, 0xedaa432a} },
/**/                  {{0xbf7bfabd, 0x0b4850f3} },
/**/                  {{0x3f81af06, 0x1caa2f2c} } },
/**/                 {{{0x3fec0000, 0x00000000} },
/**/                  {{0x3fe700a7, 0xc5784634} },
/**/                  {{0xbc78c34d, 0x25aadef6} },
/**/                  {{0x3fe21fb7, 0x8121fb78} },
/**/                  {{0x3c621fb7, 0x8121fb78} },
/**/                  {{0xbfd1f6a8, 0x499e4889} },
/**/                  {{0xbc60e934, 0x6d4e0249} },
/**/                  {{0x3fb41b15, 0xe5decb17} },
/**/                  {{0x3c5194f4, 0xab3541e6} },
/**/                  {{0x3f959bc9, 0x40a374b5} },
/**/                  {{0xbc39dc6e, 0x54be0e10} },
/**/                  {{0xbfa63b54, 0x400d3c9a} },
/**/                  {{0x3f9c90e8, 0x57717232} },
/**/                  {{0xbf791f78, 0x6bfa704e} },
/**/                  {{0xbf7abfbc, 0x643da6dd} },
/**/                  {{0x3f815112, 0xa418ed31} } },
/**/                 {{{0x3fec2000, 0x00000000} },
/**/                  {{0x3fe712be, 0x84295198} },
/**/                  {{0x3c85cd90, 0x337d8881} },
/**/                  {{0x3fe20dc8, 0x65ad1f5b} },
/**/                  {{0xbc88102a, 0xd7b50d48} },
/**/                  {{0xbfd1e78b, 0xfa75d2f4} },
/**/                  {{0x3c723734, 0x619624d2} },
/**/                  {{0x3fb43043, 0x1517663e} },
/**/                  {{0xbc4af8a4, 0xe5e1ddf1} },
/**/                  {{0x3f94bf23, 0x961cd605} },
/**/                  {{0xbc26e86e, 0x5ca14507} },
/**/                  {{0xbfa5e5e4, 0x32c1ffd7} },
/**/                  {{0x3f9c6438, 0xda0191cd} },
/**/                  {{0xbf79f0a0, 0x4d921d2b} },
/**/                  {{0xbf798b55, 0x4e35d54e} },
/**/                  {{0x3f80f34e, 0xcd4f7bfd} } },
/**/                 {{{0x3fec4000, 0x00000000} },
/**/                  {{0x3fe724c3, 0x5b4fae7b} },
/**/                  {{0x3c5948b3, 0x2db3499b} },
/**/                  {{0x3fe1fbe8, 0x6e5ce35d} },
/**/                  {{0x3c8101d1, 0x561e27a3} },
/**/                  {{0xbfd1d860, 0x1bbd70f4} },
/**/                  {{0xbc7b4c97, 0xfa32c4d1} },
/**/                  {{0x3fb44495, 0x48f48a77} },
/**/                  {{0xbc2ccfed, 0xb47fdf89} },
/**/                  {{0x3f93e5d1, 0xa6c1af2c} },
/**/                  {{0xbc14af58, 0xc3b5a19b} },
/**/                  {{0xbfa590fc, 0x5094795f} },
/**/                  {{0x3f9c3623, 0xb638ebc2} },
/**/                  {{0xbf7ab83f, 0x4fa66d0e} },
/**/                  {{0xbf785d83, 0xb787e297} },
/**/                  {{0x3f8095ce, 0xe71b4cea} } },
/**/                 {{{0x3fec6000, 0x00000000} },
/**/                  {{0x3fe736b6, 0x5a172dff} },
/**/                  {{0x3c7775fd, 0x06a892d1} },
/**/                  {{0x3fe1ea17, 0xaa6f2377} },
/**/                  {{0xbc8395a8, 0xcb44ec07} },
/**/                  {{0xbfd1c925, 0x5072ec76} },
/**/                  {{0xbc6e11b3, 0xf650d5de} },
/**/                  {{0x3fb4580f, 0xd281a42b} },
/**/                  {{0xbc55bbce, 0xf63226cb} },
/**/                  {{0x3f930fce, 0x0c411254} },
/**/                  {{0x3c3a4412, 0xc9852726} },
/**/                  {{0xbfa53ca0, 0xb19e766e} },
/**/                  {{0x3f9c06b9, 0x6d941dd5} },
/**/                  {{0xbf7b768a, 0x094128b2} },
/**/                  {{0xbf773642, 0x2a047c42} },
/**/                  {{0x3f8038a6, 0x40d7925f} } },
/**/                 {{{0x3fec8000, 0x00000000} },
/**/                  {{0x3fe74897, 0x8fba8e0f} },
/**/                  {{0x3c47b2a6, 0x165884a1} },
/**/                  {{0x3fe1d856, 0x287ffb8a} },
/**/                  {{0xbc658a1f, 0xfee27a9d} },
/**/                  {{0xbfd1b9dc, 0x39195240} },
/**/                  {{0x3c604646, 0x551dc6bf} },
/**/                  {{0x3fb46ab5, 0xfd4fa866} },
/**/                  {{0x3c5f62a7, 0xc2febe43} },
/**/                  {{0x3f923d13, 0x384eda2c} },
/**/                  {{0x3c3b9a7c, 0x1dfd9f34} },
/**/                  {{0xbfa4e8d5, 0x3cff324c} },
/**/                  {{0x3f9bd60a, 0x25b0d0ad} },
/**/                  {{0xbf7c2bb4, 0xe063d1e6} },
/**/                  {{0xbf761589, 0xdcb54dd5} },
/**/                  {{0x3f7fb7ce, 0x61077b85} } },
/**/                 {{{0x3feca000, 0x00000000} },
/**/                  {{0x3fe75a67, 0x0b82d8d8} },
/**/                  {{0x3c8ee4ac, 0x4c729087} },
/**/                  {{0x3fe1c6a3, 0xf68c4011} },
/**/                  {{0xbc8e54e4, 0x32671c29} },
/**/                  {{0xbfd1aa85, 0x73bd1c8f} },
/**/                  {{0x3c7525ad, 0x41d7bd80} },
/**/                  {{0x3fb47c8b, 0x0f4e0cc0} },
/**/                  {{0x3c2efdd1, 0xd854875c} },
/**/                  {{0x3f916d9b, 0x7688134d} },
/**/                  {{0xbc1abef6, 0x42a6f922} },
/**/                  {{0xbfa4959d, 0xa9ee694e} },
/**/                  {{0x3f9ba425, 0xa8aca118} },
/**/                  {{0xbf7cd7f3, 0xffb6fa1f} },
/**/                  {{0xbf74fb52, 0xc52e395a} },
/**/                  {{0x3f7eff46, 0x31d14661} } },
/**/                 {{{0x3fecc000, 0x00000000} },
/**/                  {{0x3fe76c24, 0xdcc6c6c0} },
/**/                  {{0x3c819525, 0x51adc83d} },
/**/                  {{0x3fe1b501, 0x21f3f28c} },
/**/                  {{0xbc45712f, 0x5f1d67b6} },
/**/                  {{0xbfd19b21, 0x9bf87a43} },
/**/                  {{0xbc64520a, 0xb2071e48} },
/**/                  {{0x3fb48d92, 0x48a59e43} },
/**/                  {{0x3c5f8e56, 0x42014b8b} },
/**/                  {{0x3f90a160, 0xee4caccb} },
/**/                  {{0x3c2bd92b, 0x7b6daa67} },
/**/                  {{0xbfa442fd, 0x80ce3489} },
/**/                  {{0x3f9b711b, 0x65959e45} },
/**/                  {{0xbf7d7b7b, 0x4cc2673a} },
/**/                  {{0xbf73e793, 0xa86f8a8e} },
/**/                  {{0x3f7e47d4, 0xdf91602d} } },
/**/                 {{{0x3fece000, 0x00000000} },
/**/                  {{0x3fe77dd1, 0x12ea22c7} },
/**/                  {{0x3c873260, 0x8fc10d3d} },
/**/                  {{0x3fe1a36d, 0xb77cb1a2} },
/**/                  {{0xbc42c20d, 0x6e625be9} },
/**/                  {{0xbfd18bb1, 0x4af7b13c} },
/**/                  {{0xbc68446b, 0xbc063e5a} },
/**/                  {{0x3fb49dce, 0xe3952cbb} },
/**/                  {{0x3c588e60, 0x58cf9123} },
/**/                  {{0x3f8fb0bb, 0x491cfa44} },
/**/                  {{0x3c1534fc, 0x0e3f2a43} },
/**/                  {{0xbfa3f0f8, 0x1c3b7aca} },
/**/                  {{0x3f9b3cfa, 0x70eb708a} },
/**/                  {{0xbf7e167e, 0x5eaa8b7f} },
/**/                  {{0xbf72da42, 0x2b587c04} },
/**/                  {{0x3f7d9199, 0x882fa65b} } },
/**/                 {{{0x3fed0000, 0x00000000} },
/**/                  {{0x3fe78f6b, 0xbd5d315e} },
/**/                  {{0x3c8406a0, 0x89803740} },
/**/                  {{0x3fe191e9, 0xc35424ca} },
/**/                  {{0xbc8fa3c1, 0xf4be863f} },
/**/                  {{0xbfd17c35, 0x177d9a85} },
/**/                  {{0xbc717b81, 0x6a99d546} },
/**/                  {{0x3fb4ad44, 0x144fffae} },
/**/                  {{0x3c3538b3, 0xdccca2a3} },
/**/                  {{0x3f8e2516, 0xfb2b5523} },
/**/                  {{0x3c0f7c11, 0x60181bd9} },
/**/                  {{0xbfa39f90, 0xaa1cc641} },
/**/                  {{0x3f9b07d1, 0x85304289} },
/**/                  {{0xbf7ea930, 0x756fd193} },
/**/                  {{0xbf71d352, 0xe2a9a0de} },
/**/                  {{0x3f7cdcb1, 0x886fc912} } },
/**/                 {{{0x3fed2000, 0x00000000} },
/**/                  {{0x3fe7a0f4, 0xeb9c19a2} },
/**/                  {{0x3c613c67, 0xcd815f57} },
/**/                  {{0x3fe18075, 0x5112636f} },
/**/                  {{0x3c80a172, 0x7a335b20} },
/**/                  {{0xbfd16cad, 0x95e83705} },
/**/                  {{0x3c62a94b, 0x7b21d5e1} },
/**/                  {{0x3fb4bbf5, 0x08de0a7c} },
/**/                  {{0x3c3570d0, 0x057457a0} },
/**/                  {{0x3f8c9fc8, 0x7d750fdf} },
/**/                  {{0x3c2900a7, 0xfe4cff3c} },
/**/                  {{0xbfa34eca, 0x2caf50ea} },
/**/                  {{0x3f9ad1af, 0x03888c77} },
/**/                  {{0xbf7f33c4, 0x71ac3a86} },
/**/                  {{0xbf70d2b9, 0x6296fd58} },
/**/                  {{0x3f7c2938, 0x886d16b8} } },
/**/                 {{{0x3fed4000, 0x00000000} },
/**/                  {{0x3fe7b26c, 0xad2e50fe} },
/**/                  {{0xbc8ce80d, 0xf30411fb} },
/**/                  {{0x3fe16f10, 0x6bbc577a} },
/**/                  {{0xbc7d0db6, 0xbd8abf47} },
/**/                  {{0xbfd15d1b, 0x58355b5f} },
/**/                  {{0xbc5b5457, 0xbcc70038} },
/**/                  {{0x3fb4c9e4, 0xe8fdd51d} },
/**/                  {{0x3c462959, 0x28ac9383} },
/**/                  {{0x3f8b20c3, 0x2029f143} },
/**/                  {{0xbc2f8a44, 0x2b420400} },
/**/                  {{0xbfa2fea7, 0x7b921c49} },
/**/                  {{0x3f9a9aa0, 0xf468e79e} },
/**/                  {{0xbf7fb66c, 0xcccbcb4f} },
/**/                  {{0xbf6fb0d0, 0x9bd39a5f} },
/**/                  {{0x3f7b7748, 0x8813998f} } },
/**/                 {{{0x3fed6000, 0x00000000} },
/**/                  {{0x3fe7c3d3, 0x11a6092b} },
/**/                  {{0x3c8bb3cb, 0x2d303288} },
/**/                  {{0x3fe15dbb, 0x1dc61b17} },
/**/                  {{0xbc8f0487, 0xbb77dc56} },
/**/                  {{0xbfd14d7e, 0xee0771ca} },
/**/                  {{0x3c72d38b, 0xdc2fcbd0} },
/**/                  {{0x3fb4d716, 0xd6080f0e} },
/**/                  {{0xbc5cb5bc, 0xa9fbc2c3} },
/**/                  {{0x3f89a7f9, 0xfc42e02f} },
/**/                  {{0xbc201eec, 0x857be8a4} },
/**/                  {{0xbfa2af2b, 0x44ceebb3} },
/**/                  {{0x3f9a62b5, 0x08511639} },
/**/                  {{0xbf8018ad, 0xc8de23de} },
/**/                  {{0xbf6dc8a2, 0xc964501a} },
/**/                  {{0x3f7ac6f9, 0xeb913697} } },
/**/                 {{{0x3fed8000, 0x00000000} },
/**/                  {{0x3fe7d528, 0x289fa093} },
/**/                  {{0x3c856082, 0x1e2f3aa9} },
/**/                  {{0x3fe14c75, 0x711551bb} },
/**/                  {{0xbc80c88e, 0x71970f2c} },
/**/                  {{0xbfd13dd8, 0xe4aa5095} },
/**/                  {{0x3c66dd31, 0xb4b7ae12} },
/**/                  {{0x3fb4e38d, 0xead4c211} },
/**/                  {{0x3c513fb0, 0xe392a31e} },
/**/                  {{0x3f88355f, 0xf6b74576} },
/**/                  {{0x3ba8cb44, 0xf3561ab7} },
/**/                  {{0xbfa26058, 0x0de0faaa} },
/**/                  {{0x3f9a29f8, 0x989371f0} },
/**/                  {{0xbf805261, 0x2b085d9a} },
/**/                  {{0xbf6beccb, 0x2511c555} },
/**/                  {{0x3f7a1863, 0x87b9d333} } },
/**/                 {{{0x3feda000, 0x00000000} },
/**/                  {{0x3fe7e66c, 0x01c114fe} },
/**/                  {{0xbc8c82b8, 0x8b760b8d} },
/**/                  {{0x3fe13b3f, 0x6f037c44} },
/**/                  {{0xbc635393, 0x8562c8c0} },
/**/                  {{0xbfd12e29, 0xc7182435} },
/**/                  {{0xbc73da80, 0x0d0fda95} },
/**/                  {{0x3fb4ef4d, 0x3ba21a8b} },
/**/                  {{0xbc17c450, 0x9aa41146} },
/**/                  {{0x3f86c8e7, 0xc39dff46} },
/**/                  {{0x3c1ddd70, 0x800ba9ae} },
/**/                  {{0xbfa21230, 0x34b94b56} },
/**/                  {{0x3f99f078, 0xa827f95a} },
/**/                  {{0xbf808869, 0x19caa997} },
/**/                  {{0xbf6a1d29, 0xf8c46d26} },
/**/                  {{0x3f796b9a, 0xae59da17} } },
/**/                 {{{0x3fedc000, 0x00000000} },
/**/                  {{0x3fe7f79e, 0xacb97898} },
/**/                  {{0x3c8fd5ca, 0x80ead221} },
/**/                  {{0x3fe12a19, 0x20604825} },
/**/                  {{0xbc5cc7d6, 0xa18970f8} },
/**/                  {{0xbfd11e72, 0x1dfe6ba4} },
/**/                  {{0x3c706717, 0x9d653d1c} },
/**/                  {{0x3fb4fa57, 0xd5fcbb3b} },
/**/                  {{0x3c1922c8, 0x5f50bc06} },
/**/                  {{0x3f856283, 0xe93a179f} },
/**/                  {{0xbc01c2ec, 0x5ea7135a} },
/**/                  {{0xbfa1c4b5, 0xf0c06b4f} },
/**/                  {{0x3f99b641, 0xe48a3b04} },
/**/                  {{0xbf80badd, 0xe1280a21} },
/**/                  {{0xbf68599e, 0x1be3c5dd} },
/**/                  {{0x3f78c0b3, 0x3a72c8e6} } },
/**/                 {{{0x3fede000, 0x00000000} },
/**/                  {{0x3fe808c0, 0x3940694b} },
/**/                  {{0xbc800f32, 0x7715f6a5} },
/**/                  {{0x3fe11902, 0x8d73d98e} },
/**/                  {{0x3c71d158, 0x30f8e290} },
/**/                  {{0xbfd10eb2, 0x6fc305eb} },
/**/                  {{0xbc7fd2e3, 0x3858c4b7} },
/**/                  {{0x3fb504b0, 0xc0a99255} },
/**/                  {{0x3c55c054, 0x142e134f} },
/**/                  {{0x3f840226, 0xc2f371cf} },
/**/                  {{0xbbfc85b0, 0xfc7d6225} },
/**/                  {{0xbfa177eb, 0x53d58f53} },
/**/                  {{0x3f997b60, 0xa6a1627d} },
/**/                  {{0xbf80e9d7, 0x89757c78} },
/**/                  {{0xbf66a205, 0x0d433cd6} },
/**/                  {{0x3f7817bf, 0x9c5dbd9f} } },
/**/                 {{{0x3fee0000, 0x00000000} },
/**/                  {{0x3fe819d0, 0xb7158a4d} },
/**/                  {{0xbc7bf762, 0x29d3b917} },
/**/                  {{0x3fe107fb, 0xbe011080} },
/**/                  {{0xbc8107fb, 0xbe011080} },
/**/                  {{0xbfd0feeb, 0x40894fcd} },
/**/                  {{0x3c76fbb9, 0xc155af9a} },
/**/                  {{0x3fb50e5a, 0xfb9125f7} },
/**/                  {{0x3c357762, 0x2f3313b0} },
/**/                  {{0x3f82a7c2, 0x843ba55a} },
/**/                  {{0x3c1f4994, 0x3fc197b7} },
/**/                  {{0xbfa12bd2, 0x4b4ae875} },
/**/                  {{0x3f993fe0, 0xf3b1b1ee} },
/**/                  {{0xbf81156d, 0xd4c2083b} },
/**/                  {{0xbf64f63b, 0x0c35aa9c} },
/**/                  {{0x3f7770d0, 0xe5d0462f} } },
/**/                 {{{0x3fee2000, 0x00000000} },
/**/                  {{0x3fe82ad0, 0x36000005} },
/**/                  {{0x3c74592f, 0xce924d24} },
/**/                  {{0x3fe0f704, 0xb947c8b7} },
/**/                  {{0x3c436cd7, 0x48a651b3} },
/**/                  {{0xbfd0ef1d, 0x1237505b} },
/**/                  {{0x3c69239b, 0x1b86b9d1} },
/**/                  {{0x3fb51759, 0x7fac4e21} },
/**/                  {{0xbc42a8cc, 0xbfce0e36} },
/**/                  {{0x3f815349, 0x3b5f3edd} },
/**/                  {{0xbc25e1f1, 0x88c702d9} },
/**/                  {{0xbfa0e06c, 0xa0df17a9} },
/**/                  {{0x3f9903ce, 0x7e56b8b1} },
/**/                  {{0xbf813db8, 0x3c701e30} },
/**/                  {{0xbf63561b, 0x30c99e47} },
/**/                  {{0x3f76cbf6, 0xd5bffce0} } },
/**/                 {{{0x3fee4000, 0x00000000} },
/**/                  {{0x3fe83bbe, 0xc5cdee22} },
/**/                  {{0x3c631071, 0x04ffc6c3} },
/**/                  {{0x3fe0e61d, 0x86071468} },
/**/                  {{0xbc70ccc4, 0x59be09c9} },
/**/                  {{0xbfd0df48, 0x647af38b} },
/**/                  {{0x3c7dd47c, 0x427c295b} },
/**/                  {{0x3fb51faf, 0x3ef25277} },
/**/                  {{0x3bdf056a, 0xa81026a7} },
/**/                  {{0x3f8004ac, 0xd443a18b} },
/**/                  {{0x3c027610, 0x8178f329} },
/**/                  {{0xbfa095bb, 0xfbb3a658} },
/**/                  {{0x3f98c734, 0xa7859d46} },
/**/                  {{0xbf8162cd, 0xeefe9a81} },
/**/                  {{0xbf61c17f, 0x8330eac0} },
/**/                  {{0x3f76293f, 0xe421c20a} } },
/**/                 {{{0x3fee6000, 0x00000000} },
/**/                  {{0x3fe84c9c, 0x7653f7eb} },
/**/                  {{0xbc383611, 0xfe0a3e8f} },
/**/                  {{0x3fe0d546, 0x2a7f71b5} },
/**/                  {{0x3c757061, 0x596848c6} },
/**/                  {{0xbfd0cf6d, 0xb4cf51a6} },
/**/                  {{0x3c4c99ab, 0x5b18bb8c} },
/**/                  {{0x3fb5275f, 0x24486227} },
/**/                  {{0x3c5b4a59, 0xbb1f4f56} },
/**/                  {{0x3f7d77be, 0x36238bb2} },
/**/                  {{0x3c1ddbd1, 0xcaec6ba2} },
/**/                  {{0xbfa04bc1, 0xe1406cd0} },
/**/                  {{0x3f988a1e, 0x7f96d6ca} },
/**/                  {{0xbf8184c5, 0xcdffc380} },
/**/                  {{0xbf603841, 0x12561f8b} },
/**/                  {{0x3f7588b9, 0x4d81a668} } },
/**/                 {{{0x3fee8000, 0x00000000} },
/**/                  {{0x3fe85d69, 0x576cc2c5} },
/**/                  {{0x3c66b66e, 0x7fc8b8c3} },
/**/                  {{0x3fe0c47e, 0xac74fadc} },
/**/                  {{0xbc8035f8, 0x77bb1887} },
/**/                  {{0xbfd0bf8d, 0x7e8202a9} },
/**/                  {{0x3c798048, 0x1f4d2357} },
/**/                  {{0x3fb52e6c, 0x13725c73} },
/**/                  {{0xbc34c3af, 0xf5b19ded} },
/**/                  {{0x3f7af1a3, 0x7d9c2711} },
/**/                  {{0x3bea7ec7, 0x1af1098d} },
/**/                  {{0xbfa0027f, 0xb643d11f} },
/**/                  {{0x3f984c96, 0xc756b7d7} },
/**/                  {{0xbf81a3b6, 0x6c3ca3ae} },
/**/                  {{0xbf5d7470, 0x13459246} },
/**/                  {{0x3f74ea6f, 0x1e70d9a4} } },
/**/                 {{{0x3feea000, 0x00000000} },
/**/                  {{0x3fe86e25, 0x78f87ae5} },
/**/                  {{0x3c8022b1, 0x375cfe34} },
/**/                  {{0x3fe0b3c7, 0x11319104} },
/**/                  {{0x3c8ac394, 0x25152519} },
/**/                  {{0xbfd0afa8, 0x3ab87c8a} },
/**/                  {{0x3c724f26, 0x27b31384} },
/**/                  {{0x3fb534d8, 0xe904e078} },
/**/                  {{0xbc55bfde, 0xf8948323} },
/**/                  {{0x3f7876ec, 0xa7bb2dfb} },
/**/                  {{0xbc197116, 0x8a87be50} },
/**/                  {{0xbf9f73ed, 0x7f5f95b4} },
/**/                  {{0x3f980ea7, 0xf11c3266} },
/**/                  {{0xbf81bfb6, 0x0c032389} },
/**/                  {{0xbf5a8e77, 0x8bf305a1} },
/**/                  {{0x3f744e6c, 0x3ec72e6d} } },
/**/                 {{{0x3feec000, 0x00000000} },
/**/                  {{0x3fe87ed0, 0xeadc5a2a} },
/**/                  {{0x3c70af5a, 0xd957f4bc} },
/**/                  {{0x3fe0a31f, 0x5d8701b3} },
/**/                  {{0xbc869b25, 0x263ce937} },
/**/                  {{0xbfd09fbe, 0x60757b83} },
/**/                  {{0x3c767aff, 0xa96db9ef} },
/**/                  {{0x3fb53aa8, 0x7a589afb} },
/**/                  {{0xbc4b7e8e, 0x0844ff86} },
/**/                  {{0x3f76077c, 0xacf1a65c} },
/**/                  {{0xbc19a3b2, 0xb13331a9} },
/**/                  {{0xbf9ee450, 0x472733eb} },
/**/                  {{0x3f97d05c, 0x21e541d7} },
/**/                  {{0xbf81d8da, 0x9d9d4dfc} },
/**/                  {{0xbf57be45, 0xd3ce1b4a} },
/**/                  {{0x3f73b4ba, 0x7cb60047} } },
/**/                 {{{0x3feee000, 0x00000000} },
/**/                  {{0x3fe88f6b, 0xbd023119} },
/**/                  {{0xbc532d1d, 0x25aba660} },
/**/                  {{0x3fe09287, 0x95d126c6} },
/**/                  {{0x3c85aad3, 0xeccc37a6} },
/**/                  {{0xbfd08fd0, 0x649e7367} },
/**/                  {{0x3c71e96c, 0xed21a127} },
/**/                  {{0x3fb53fdd, 0x957ec910} },
/**/                  {{0xbc339c23, 0xaf97a601} },
/**/                  {{0x3f73a336, 0x5a18e5a2} },
/**/                  {{0xbc1f7225, 0x477571de} },
/**/                  {{0xbf9e5629, 0xd4044135} },
/**/                  {{0x3f9791bd, 0x32786dc4} },
/**/                  {{0xbf81ef39, 0xbdf030c4} },
/**/                  {{0xbf550386, 0xe21b8bcb} },
/**/                  {{0x3f731d62, 0x97aa7fb2} } },
/**/                 {{{0x3fef0000, 0x00000000} },
/**/                  {{0x3fe89ff5, 0xff57f1f8} },
/**/                  {{0xbc855b9a, 0x5e177a1b} },
/**/                  {{0x3fe081ff, 0xbdf80108} },
/**/                  {{0x3c6ffbdf, 0x80108200} },
/**/                  {{0xbfd07fde, 0xba010928} },
/**/                  {{0x3c38d37f, 0x7bae0295} },
/**/                  {{0x3fb5447b, 0x0136e69f} },
/**/                  {{0x3c50316a, 0x0dda278d} },
/**/                  {{0x3f7149fc, 0x55103947} },
/**/                  {{0x3c176e96, 0x849e505f} },
/**/                  {{0xbf9dc97b, 0xfbe9a2ee} },
/**/                  {{0x3f9752d4, 0xb08adda9} },
/**/                  {{0xbf8202e8, 0xb540d106} },
/**/                  {{0xbf525de5, 0x859de3e9} },
/**/                  {{0x3f72886c, 0x4afd9f21} } },
/**/                 {{{0x3fef2000, 0x00000000} },
/**/                  {{0x3fe8b06f, 0xc1cf3dff} },
/**/                  {{0xbc80fb31, 0x2656db6d} },
/**/                  {{0x3fe07187, 0xd971cd38} },
/**/                  {{0x3c89baa4, 0x202c20ac} },
/**/                  {{0xbfd06fe9, 0xd15893ab} },
/**/                  {{0xbc7a864b, 0xdc0cb586} },
/**/                  {{0x3fb54883, 0x7ce57fed} },
/**/                  {{0xbc49498e, 0x294f4b18} },
/**/                  {{0x3f6df762, 0x426ebecc} },
/**/                  {{0xbc022f08, 0xf28644c0} },
/**/                  {{0xbf9d3e48, 0x5c564b44} },
/**/                  {{0x3f9713ab, 0xdfea7acf} },
/**/                  {{0xbf8213fc, 0x761db35c} },
/**/                  {{0xbf4f9a17, 0x10d60f49} },
/**/                  {{0x3f71f5de, 0x58700e9b} } },
/**/                 {{{0x3fef4000, 0x00000000} },
/**/                  {{0x3fe8c0d9, 0x145cf49d} },
/**/                  {{0x3c8bea40, 0x76dc4333} },
/**/                  {{0x3fe0611f, 0xeb45139a} },
/**/                  {{0x3c7e4998, 0x65aadb1f} },
/**/                  {{0xbfd05ff2, 0x1953a316} },
/**/                  {{0x3c759922, 0xa1b67b0f} },
/**/                  {{0x3fb54bf9, 0xc08c1d66} },
/**/                  {{0x3c5b9353, 0xd220330c} },
/**/                  {{0x3f69706e, 0x478cb604} },
/**/                  {{0xbbfdb6d3, 0xa22fd45a} },
/**/                  {{0xbf9cb490, 0x5c0d1d38} },
/**/                  {{0x3f96d44b, 0xbbaba2f2} },
/**/                  {{0xbf822289, 0x9c6b7de1} },
/**/                  {{0xbf4aa143, 0xa49803b6} },
/**/                  {{0x3f7165be, 0x9270e49e} } },
/**/                 {{{0x3fef6000, 0x00000000} },
/**/                  {{0x3fe8d132, 0x06f8c4cb} },
/**/                  {{0xbc7b018c, 0xbaa89a8b} },
/**/                  {{0x3fe050c7, 0xf60ab1f4} },
/**/                  {{0x3c63f8e2, 0xc6cf5796} },
/**/                  {{0xbfd04ff7, 0xfe998dc0} },
/**/                  {{0x3c77873c, 0x7dc56419} },
/**/                  {{0x3fb54ee0, 0x7cc24121} },
/**/                  {{0x3c313117, 0x8e5c84c5} },
/**/                  {{0x3f64fee1, 0x50066301} },
/**/                  {{0x3c043698, 0x017261a1} },
/**/                  {{0xbf9c2c55, 0x2cc5b4f1} },
/**/                  {{0x3f9694bc, 0xf759f369} },
/**/                  {{0xbf822ea4, 0x6c93426a} },
/**/                  {{0xbf45d0a1, 0x135d6c51} },
/**/                  {{0x3f70d811, 0xe62dc18f} } },
/**/                 {{{0x3fef8000, 0x00000000} },
/**/                  {{0x3fe8e17a, 0xa99cc05e} },
/**/                  {{0xbc7ec182, 0xab042f61} },
/**/                  {{0x3fe0407f, 0xfbefe001} },
/**/                  {{0x3c401ffe, 0xfbf80041} },
/**/                  {{0xbfd03ffb, 0xebd00209} },
/**/                  {{0xbc53ff3c, 0xb9004112} },
/**/                  {{0x3fb5513a, 0x5aaf6d91} },
/**/                  {{0x3c54a20d, 0xc0516ddb} },
/**/                  {{0x3f60a27f, 0xc6ac4038} },
/**/                  {{0x3bf06bee, 0x2a340912} },
/**/                  {{0xbf9ba597, 0xccd6032a} },
/**/                  {{0x3f965508, 0x002bb974} },
/**/                  {{0xbf823860, 0xd2d1068b} },
/**/                  {{0xbf41277e, 0x666265bc} },
/**/                  {{0x3f704cdc, 0x656b66ea} } },
/**/                 {{{0x3fefa000, 0x00000000} },
/**/                  {{0x3fe8f1b3, 0x0c44f167} },
/**/                  {{0x3c6dd1ca, 0xb93933fd} },
/**/                  {{0x3fe03047, 0xfeb82e4e} },
/**/                  {{0x3c69ee56, 0x5272e5ac} },
/**/                  {{0xbfd02ffe, 0x49a09c45} },
/**/                  {{0xbc700a59, 0xb26267bb} },
/**/                  {{0x3fb55309, 0xfc062d2f} },
/**/                  {{0x3c5dba48, 0xb11938e0} },
/**/                  {{0x3f58b61b, 0xe4f365be} },
/**/                  {{0x3bf8b585, 0xa79ad31a} },
/**/                  {{0xbf9b2059, 0x08d4ad17} },
/**/                  {{0x3f961534, 0xfe379940} },
/**/                  {{0xbf823fd2, 0x62a1270e} },
/**/                  {{0xbf394a53, 0x3f3a0aec} },
/**/                  {{0x3f6f8842, 0xa04bcae2} } },
/**/                 {{{0x3fefc000, 0x00000000} },
/**/                  {{0x3fe901db, 0x3eeef187} },
/**/                  {{0x3c868665, 0xe5603c8f} },
/**/                  {{0x3fe0201f, 0xffbf7f80} },
/**/                  {{0x3c20201f, 0xffbf7f80} },
/**/                  {{0xbfd01fff, 0x7ebe8004} },
/**/                  {{0xbc4213ff, 0xcf979001} },
/**/                  {{0x3fb55451, 0xfb0012db} },
/**/                  {{0xbc395606, 0xf73aa59f} },
/**/                  {{0x3f50509f, 0xfc757100} },
/**/                  {{0x3bebc7da, 0xfee554d0} },
/**/                  {{0xbf9a9c99, 0x7d3424d0} },
/**/                  {{0x3f95d54b, 0xd5ac0217} },
/**/                  {{0xbf82450c, 0x564b3c49} },
/**/                  {{0xbf3091df, 0xe6d3e986} },
/**/                  {{0x3f6e7bc6, 0x3bef5a22} } },
/**/                 {{{0x3fefe000, 0x00000000} },
/**/                  {{0x3fe911f3, 0x5199833b} },
/**/                  {{0x3c63ae8a, 0x0edbf522} },
/**/                  {{0x3fe01007, 0xfffbfbfe} },
/**/                  {{0x3ba01007, 0xfffbfbfe} },
/**/                  {{0xbfd00fff, 0xefebf400} },
/**/                  {{0xbc401209, 0xfff9f97d} },
/**/                  {{0x3fb55514, 0xea5aaaf6} },
/**/                  {{0xbc529baa, 0xb5b7b240} },
/**/                  {{0x3f402827, 0xffc7abc4} },
/**/                  {{0x3b5ba3d6, 0xbfee6ab3} },
/**/                  {{0xbf9a1a59, 0x97d67093} },
/**/                  {{0x3f959554, 0x28080aaf} },
/**/                  {{0xbf824821, 0x8e892ce2} },
/**/                  {{0xbf204877, 0xfe70a2a6} },
/**/                  {{0x3f6d7447, 0x0e8ddd67} } },
/**/                 {{{0x3feff800, 0x00000000} },
/**/                  {{0x3fe91dfa, 0xd439826e} },
/**/                  {{0xbc786a19, 0x6df48d55} },
/**/                  {{0x3fe00400, 0x7ffffbff} },
/**/                  {{0xbbeffffe, 0xffbff800} },
/**/                  {{0xbfd003ff, 0xffbfebfd} },
/**/                  {{0xbb600480, 0x9ffff9fe} },
/**/                  {{0x3fb55551, 0x53aa5aab} },
/**/                  {{0xbc542a4a, 0x9baaab5b} },
/**/                  {{0x3f200a02, 0x7fffc7eb} },
/**/                  {{0xbb7dfffe, 0x4770e940} },
/**/                  {{0xbf99b9a5, 0x9997d8d0} },
/**/                  {{0x3f956555, 0x50a80a03} },
/**/                  {{0xbf824914, 0x86456493} },
/**/                  {{0xbf001207, 0x7ffe7329} },
/**/                  {{0x3f6cb1ef, 0x1c63fe2a} } },
  };

#else
#ifdef LITTLE_ENDI

  static const number
      cij[241][7] = {                             /* x0,cij for (1/16,1) */
/**/                 {{{0X65E0244E, 0X3FB04006} },
/**/                  {{0X7B53DD20, 0X3FB03A73} },
/**/                  {{0XCF5CFB72, 0X3FEFDF1F} },
/**/                  {{0XCE2AE4C2, 0XBFB01EB3} },
/**/                  {{0XDD58A40D, 0XBFD4D29E} },
/**/                  {{0XD907A18A, 0X3FAFDA4A} },
/**/                  {{0X4DF65B18, 0X3FC814DF} } },
/**/                 {{{0XB9B88CD8, 0X3FB0FFFD} },
/**/                  {{0X63645300, 0X3FB0F99C} },
/**/                  {{0XA3DED30F, 0X3FEFDC08} },
/**/                  {{0X669C1AED, 0XBFB0D9DC} },
/**/                  {{0XF7138DE2, 0XBFD4C669} },
/**/                  {{0X29D085A7, 0X3FB0A12F} },
/**/                  {{0XCFD48D20, 0X3FC7F0EE} } },
/**/                 {{{0X5A73D4F1, 0X3FB1FFF1} },
/**/                  {{0X2BEE2040, 0X3FB1F85F} },
/**/                  {{0X42B56D31, 0X3FEFD7B3} },
/**/                  {{0XB69DEA40, 0XBFB1D2B7} },
/**/                  {{0X3922ECC9, 0XBFD4B552} },
/**/                  {{0X522B1A04, 0X3FB18F93} },
/**/                  {{0X5660F061, 0X3FC7BEAD} } },
/**/                 {{{0XB2524AA2, 0X3FB2FFFD} },
/**/                  {{0XE71790A0, 0X3FB2F716} },
/**/                  {{0X53B496A4, 0X3FEFD31F} },
/**/                  {{0X4AAB7374, 0XBFB2CAD8} },
/**/                  {{0X58DD2FB2, 0XBFD4A34B} },
/**/                  {{0XD0CECC18, 0X3FB27C0A} },
/**/                  {{0X5D2743D7, 0X3FC789D2} } },
/**/                 {{{0X0573F3AC, 0X3FB3FFFE} },
/**/                  {{0X1702F6A0, 0X3FB3F59D} },
/**/                  {{0XB071ACC2, 0X3FEFCE4D} },
/**/                  {{0X64DB3686, 0XBFB3C20F} },
/**/                  {{0XEB3BFE93, 0XBFD49059} },
/**/                  {{0XCAF74FED, 0X3FB36659} },
/**/                  {{0X1C011FB0, 0X3FC75269} } },
/**/                 {{{0X894384D6, 0X3FB4FFEF} },
/**/                  {{0X0CE204C0, 0X3FB4F3ED} },
/**/                  {{0XA8EA5A01, 0X3FEFC93E} },
/**/                  {{0X7B5457C9, 0XBFB4B84F} },
/**/                  {{0X7401F2F9, 0XBFD47C80} },
/**/                  {{0XB4F67209, 0X3FB44E64} },
/**/                  {{0X4C540B77, 0X3FC7187D} } },
/**/                 {{{0XDF406528, 0X3FB5FFF8} },
/**/                  {{0X3C73D820, 0X3FB5F22B} },
/**/                  {{0XB1F60F13, 0X3FEFC3F1} },
/**/                  {{0XCB7FA73B, 0XBFB5ADB2} },
/**/                  {{0X2B1EB555, 0XBFD467BE} },
/**/                  {{0X99EDC463, 0X3FB53435} },
/**/                  {{0X238F5059, 0X3FC6DC1B} } },
/**/                 {{{0X8C4F0D56, 0X3FB7000F} },
/**/                  {{0X495A2FA0, 0X3FB6F04B} },
/**/                  {{0X340DCE97, 0X3FEFBE67} },
/**/                  {{0X4D98E1AD, 0XBFB6A224} },
/**/                  {{0X14064DF1, 0XBFD45216} },
/**/                  {{0X2BA78A66, 0X3FB617AA} },
/**/                  {{0X50A3D7AC, 0X3FC69D4F} } },
/**/                 {{{0XBB4057CF, 0X3FB8000F} },
/**/                  {{0XBE2CD3A0, 0X3FB7EE27} },
/**/                  {{0X39EC9246, 0X3FEFB8A0} },
/**/                  {{0X31D9C773, 0XBFB79577} },
/**/                  {{0XB6DC7D72, 0XBFD43B8D} },
/**/                  {{0XD69547DF, 0X3FB6F88A} },
/**/                  {{0XF633CE8C, 0X3FC65C26} } },
/**/                 {{{0X39CF2B7F, 0X3FB8FFF2} },
/**/                  {{0X9F979E80, 0X3FB8EBB7} },
/**/                  {{0X435506E1, 0X3FEFB29D} },
/**/                  {{0X69B9CDB5, 0XBFB8879A} },
/**/                  {{0X85FEAFA9, 0XBFD42428} },
/**/                  {{0XB6191A0E, 0X3FB7D6BA} },
/**/                  {{0XA7CB8BB5, 0X3FC618AF} } },
/**/                 {{{0X6E2F0772, 0X3FB9FFF9} },
/**/                  {{0XD32A9480, 0X3FB9E93A} },
/**/                  {{0X04A3EC40, 0X3FEFAC5D} },
/**/                  {{0X53F6EA97, 0XBFB978C2} },
/**/                  {{0X089C36F6, 0XBFD40BE3} },
/**/                  {{0X885AEB77, 0X3FB8B25C} },
/**/                  {{0X63CADCE1, 0X3FC5D2F7} } },
/**/                 {{{0X6316B097, 0X3FBB0002} },
/**/                  {{0XCE24CC00, 0X3FBAE68C} },
/**/                  {{0X938C5C66, 0X3FEFA5E0} },
/**/                  {{0X76F14E4B, 0XBFBA68C3} },
/**/                  {{0X1696CD7C, 0XBFD3F2C3} },
/**/                  {{0X722A2CB4, 0X3FB98B3B} },
/**/                  {{0X9067AD62, 0X3FC58B0C} } },
/**/                 {{{0X604F58B1, 0X3FBC0008} },
/**/                  {{0X05650780, 0X3FBBE3A7} },
/**/                  {{0X5A7A2773, 0X3FEF9F28} },
/**/                  {{0X3D5AC0A4, 0XBFBB578F} },
/**/                  {{0XF767119F, 0XBFD3D8CB} },
/**/                  {{0XC7E31B88, 0X3FBA613D} },
/**/                  {{0XF5594565, 0X3FC540FD} } },
/**/                 {{{0X6CCA4EBA, 0X3FBD0002} },
/**/                  {{0XC1298A80, 0X3FBCE07E} },
/**/                  {{0XE8D36C4A, 0X3FEF9834} },
/**/                  {{0X5BCAC5FE, 0XBFBC4513} },
/**/                  {{0X8B5236F1, 0XBFD3BE01} },
/**/                  {{0X2E991970, 0X3FBB3447} },
/**/                  {{0XB8ADB373, 0X3FC4F4DA} } },
/**/                 {{{0XB2B47FCA, 0X3FBDFFF4} },
/**/                  {{0X4A051D80, 0X3FBDDD16} },
/**/                  {{0X78DCC895, 0X3FEF9106} },
/**/                  {{0XF0966844, 0XBFBD3149} },
/**/                  {{0X744F9A5F, 0XBFD3A266} },
/**/                  {{0XEDB7F27A, 0X3FBC0446} },
/**/                  {{0X583F9ECA, 0X3FC4A6B2} } },
/**/                 {{{0XA9A05BE0, 0X3FBF000A} },
/**/                  {{0XA3BDA540, 0X3FBED996} },
/**/                  {{0X1B8BA97F, 0X3FEF899C} },
/**/                  {{0X2287A677, 0XBFBE1C51} },
/**/                  {{0XEDC130BB, 0XBFD385F8} },
/**/                  {{0XF306FF50, 0X3FBCD14B} },
/**/                  {{0XA667A72B, 0X3FC45694} } },
/**/                 {{{0XBA8F63DE, 0X3FBFFFFA} },
/**/                  {{0X69FE4780, 0X3FBFD5B5} },
/**/                  {{0X4863DC7D, 0X3FEF81F8} },
/**/                  {{0XD1518706, 0XBFBF05DB} },
/**/                  {{0X4687A69C, 0XBFD368C4} },
/**/                  {{0X1B3868DA, 0X3FBD9B08} },
/**/                  {{0XC345ADFC, 0X3FC40491} } },
/**/                 {{{0X6ECCADA8, 0X3FC07FFA} },
/**/                  {{0X0A396400, 0X3FC068D0} },
/**/                  {{0XF1FCFC6B, 0X3FEF7A19} },
/**/                  {{0X861DF0DF, 0XBFBFEE0C} },
/**/                  {{0X5A586C0C, 0XBFD34AC6} },
/**/                  {{0X189D637A, 0X3FBE618F} },
/**/                  {{0X195779D4, 0X3FC3B0BA} } },
/**/                 {{{0X33432713, 0X3FC10003} },
/**/                  {{0XF203D1A0, 0X3FC0E6B0} },
/**/                  {{0XFE0EB463, 0X3FEF7200} },
/**/                  {{0XE15CB19A, 0XBFC06A72} },
/**/                  {{0XB8DB761E, 0XBFD32C00} },
/**/                  {{0XA11F5E3E, 0X3FBF24D8} },
/**/                  {{0X569E85DD, 0X3FC35B1E} } },
/**/                 {{{0XDA1C4811, 0X3FC17FFC} },
/**/                  {{0X29EBDA00, 0X3FC16462} },
/**/                  {{0X7D558737, 0X3FEF69AF} },
/**/                  {{0X0B33969B, 0XBFC0DD17} },
/**/                  {{0X33AC50D1, 0XBFD30C7D} },
/**/                  {{0X9BE43F0F, 0X3FBFE4AA} },
/**/                  {{0X692539CB, 0X3FC303CF} } },
/**/                 {{{0X3CCA418D, 0X3FC1FFFF} },
/**/                  {{0X3B978EA0, 0X3FC1E1FA} },
/**/                  {{0X45D421A9, 0X3FEF6124} },
/**/                  {{0XACAC8AA8, 0XBFC14F03} },
/**/                  {{0X62E675A3, 0XBFD2EC39} },
/**/                  {{0X2FA6B426, 0X3FC0508C} },
/**/                  {{0X780A6467, 0X3FC2AADE} } },
/**/                 {{{0XD9C78922, 0X3FC27FF7} },
/**/                  {{0X1B91E640, 0X3FC25F66} },
/**/                  {{0XF52E192C, 0X3FEF5860} },
/**/                  {{0XE5DE2394, 0XBFC1C023} },
/**/                  {{0X6BEE0ABD, 0XBFD2CB3D} },
/**/                  {{0X5E075C1A, 0X3FC0ACFB} },
/**/                  {{0XDFFE453A, 0X3FC2505C} } },
/**/                 {{{0XA1FC1AAA, 0X3FC2FFF7} },
/**/                  {{0X83257C40, 0X3FC2DCB5} },
/**/                  {{0XC719B6FB, 0X3FEF4F64} },
/**/                  {{0X61514083, 0XBFC23082} },
/**/                  {{0X7F7B72D5, 0XBFD2A988} },
/**/                  {{0X7C887402, 0X3FC107A7} },
/**/                  {{0X2C3CD6D1, 0X3FC1F45C} } },
/**/                 {{{0X9D78E15E, 0X3FC38005} },
/**/                  {{0X6AC98EE0, 0X3FC359EE} },
/**/                  {{0X944CEC16, 0X3FEF462F} },
/**/                  {{0XD85B87A9, 0XBFC2A020} },
/**/                  {{0X2E4AB369, 0XBFD2871C} },
/**/                  {{0XC31A65D9, 0X3FC1608D} },
/**/                  {{0X130BBE50, 0X3FC196EE} } },
/**/                 {{{0X9F431B1A, 0X3FC40004} },
/**/                  {{0X6BD65360, 0X3FC3D6F3} },
/**/                  {{0XDD99B68A, 0X3FEF3CC3} },
/**/                  {{0XB3DD00ED, 0XBFC30EE1} },
/**/                  {{0XF8482664, 0XBFD26403} },
/**/                  {{0XFE136626, 0X3FC1B792} },
/**/                  {{0X6EAC7440, 0X3FC13824} } },
/**/                 {{{0XE01D95A1, 0X3FC48004} },
/**/                  {{0X86F00CC0, 0X3FC453D3} },
/**/                  {{0XE3970539, 0X3FEF3320} },
/**/                  {{0X0A5279AA, 0XBFC37CCF} },
/**/                  {{0X3B151D5D, 0XBFD2403F} },
/**/                  {{0XE331C9E6, 0X3FC20CBB} },
/**/                  {{0X39E3F097, 0X3FC0D811} } },
/**/                 {{{0XAA9382DD, 0X3FC4FFF7} },
/**/                  {{0X8C590A80, 0X3FC4D07F} },
/**/                  {{0X34DF28E0, 0X3FEF2948} },
/**/                  {{0X5B43915C, 0XBFC3E9D8} },
/**/                  {{0XEB8845A2, 0XBFD21BD5} },
/**/                  {{0XAC6AC8AD, 0X3FC25FF8} },
/**/                  {{0X88ED96CA, 0X3FC076C6} } },
/**/                 {{{0X352408BE, 0X3FC58006} },
/**/                  {{0XC39A73E0, 0X3FC54D1E} },
/**/                  {{0X09AE009C, 0X3FEF1F37} },
/**/                  {{0XB9BE8550, 0XBFC4561C} },
/**/                  {{0X0053F52E, 0XBFD1F6C0} },
/**/                  {{0XEF783BE9, 0X3FC2B15D} },
/**/                  {{0X8615239B, 0X3FC01456} } },
/**/                 {{{0X2B193F81, 0X3FC5FFFF} },
/**/                  {{0X4F73E000, 0X3FC5C980} },
/**/                  {{0XAE110E29, 0X3FEF14F1} },
/**/                  {{0X9098B3D2, 0XBFC4C16E} },
/**/                  {{0X8F058241, 0XBFD1D10F} },
/**/                  {{0XA14FA897, 0X3FC300C6} },
/**/                  {{0XD56607C0, 0X3FBF61A6} } },
/**/                 {{{0X4460E6E1, 0X3FC68008} },
/**/                  {{0X04A55E20, 0X3FC645C8} },
/**/                  {{0X8FA36EC5, 0X3FEF0A75} },
/**/                  {{0XD62FA883, 0XBFC52BE9} },
/**/                  {{0X69A74048, 0XBFD1AABD} },
/**/                  {{0X1679EB02, 0X3FC34E45} },
/**/                  {{0XF7C14C3D, 0X3FBE989E} } },
/**/                 {{{0X9E99A846, 0X3FC6FFFB} },
/**/                  {{0X4B35FD40, 0X3FC6C1D0} },
/**/                  {{0X3EF8EF95, 0X3FEEFFC6} },
/**/                  {{0X76A2FE63, 0XBFC5956B} },
/**/                  {{0XDDC78DDF, 0XBFD183D8} },
/**/                  {{0XAC606D66, 0X3FC399BD} },
/**/                  {{0X070D286A, 0X3FBDCDBA} } },
/**/                 {{{0X0FFCD490, 0X3FC78008} },
/**/                  {{0XB55758E0, 0X3FC73DC5} },
/**/                  {{0X457E2065, 0X3FEEF4E0} },
/**/                  {{0X7D6FF9BC, 0XBFC5FE16} },
/**/                  {{0X9FADD384, 0XBFD15C57} },
/**/                  {{0X73E52D32, 0X3FC3E347} },
/**/                  {{0X9A65AE4B, 0X3FBD011C} } },
/**/                 {{{0X148E79C1, 0X3FC80006} },
/**/                  {{0X2B7F8CA0, 0X3FC7B981} },
/**/                  {{0X701687ED, 0X3FEEE9C7} },
/**/                  {{0X0E1EF36D, 0XBFC665C7} },
/**/                  {{0XCCBCBDAB, 0XBFD13449} },
/**/                  {{0X5C71B3E8, 0X3FC42AC7} },
/**/                  {{0X3E81980E, 0X3FBC32EB} } },
/**/                 {{{0X0F487C17, 0X3FC88006} },
/**/                  {{0XBC0E3640, 0X3FC83511} },
/**/                  {{0XD2D55329, 0X3FEEDE7A} },
/**/                  {{0X37E644BA, 0XBFC6CC87} },
/**/                  {{0X60597557, 0XBFD10BAE} },
/**/                  {{0X13E26FBE, 0X3FC47043} },
/**/                  {{0X6FB18BF4, 0X3FBB634A} } },
/**/                 {{{0XD3518D76, 0X3FC90004} },
/**/                  {{0X8874C100, 0X3FC8B073} },
/**/                  {{0X2ED6673B, 0X3FEED2FB} },
/**/                  {{0X2A6EBAC3, 0XBFC73251} },
/**/                  {{0X6924232F, 0XBFD0E28A} },
/**/                  {{0X73BCC03F, 0X3FC4B3B5} },
/**/                  {{0X8C72507F, 0X3FBA925E} } },
/**/                 {{{0XD2F20D5C, 0X3FC97FFF} },
/**/                  {{0X51AF5920, 0X3FC92BA3} },
/**/                  {{0X3D32449F, 0X3FEEC749} },
/**/                  {{0XC308255F, 0XBFC7971F} },
/**/                  {{0XD572D28F, 0XBFD0B8E2} },
/**/                  {{0X337448FE, 0X3FC4F51A} },
/**/                  {{0XCFCBC620, 0X3FB9C04B} } },
/**/                 {{{0XBF80F060, 0X3FCA0005} },
/**/                  {{0X6E9E8960, 0X3FC9A6AE} },
/**/                  {{0X1EF200E7, 0X3FEEBB64} },
/**/                  {{0X6E96E5C1, 0XBFC7FAFB} },
/**/                  {{0XEC6AD647, 0XBFD08EB6} },
/**/                  {{0XF53D0BA6, 0X3FC53475} },
/**/                  {{0X4433C20E, 0X3FB8ED36} } },
/**/                 {{{0XDEECA8E4, 0X3FCA7FF7} },
/**/                  {{0X948578E0, 0X3FCA2176} },
/**/                  {{0X328FF98B, 0X3FEEAF4F} },
/**/                  {{0X58149B1C, 0XBFC85DC9} },
/**/                  {{0XF933A1AB, 0XBFD06414} },
/**/                  {{0X60C45A8F, 0X3FC571B7} },
/**/                  {{0XBE58C308, 0X3FB81941} } },
/**/                 {{{0X7DEFD553, 0X3FCAFFFF} },
/**/                  {{0X9EBA6B80, 0X3FCA9C22} },
/**/                  {{0X10A85E10, 0X3FEEA307} },
/**/                  {{0X7F9DEA61, 0XBFC8BFA6} },
/**/                  {{0X5A474E8F, 0XBFD038F3} },
/**/                  {{0X30C225D2, 0X3FC5ACF0} },
/**/                  {{0XD062812F, 0X3FB74491} } },
/**/                 {{{0X669932A5, 0X3FCB7FFE} },
/**/                  {{0XCFF6DFE0, 0X3FCB1694} },
/**/                  {{0X1921D387, 0X3FEE968F} },
/**/                  {{0XE075D95A, 0XBFC92078} },
/**/                  {{0X526793C4, 0XBFD00D60} },
/**/                  {{0X73842A52, 0X3FC5E610} },
/**/                  {{0XC5331D5A, 0X3FB66F49} } },
/**/                 {{{0XB44759F3, 0X3FCBFFF9} },
/**/                  {{0X5073A2A0, 0X3FCB90D1} },
/**/                  {{0X56598313, 0X3FEE89E7} },
/**/                  {{0XCFB9203D, 0XBFC98041} },
/**/                  {{0XBED91B37, 0XBFCFC2BC} },
/**/                  {{0X6D4FC2FC, 0X3FC61D19} },
/**/                  {{0X9411537E, 0X3FB5998C} } },
/**/                 {{{0X5568F3EC, 0X3FCC8007} },
/**/                  {{0X4A31DBE0, 0X3FCC0AEC} },
/**/                  {{0X18F270A8, 0X3FEE7D0E} },
/**/                  {{0XF522B132, 0XBFC9DF0E} },
/**/                  {{0X2179C242, 0XBFCF69D4} },
/**/                  {{0X36646FCD, 0X3FC65213} },
/**/                  {{0XDC699095, 0X3FB4C37C} } },
/**/                 {{{0X601A799F, 0X3FCCFFF8} },
/**/                  {{0X49DB66A0, 0X3FCC84B8} },
/**/                  {{0XA0EE780E, 0X3FEE7008} },
/**/                  {{0X3A403934, 0XBFCA3CBB} },
/**/                  {{0XD490BE32, 0XBFCF102F} },
/**/                  {{0X037D4137, 0X3FC684EA} },
/**/                  {{0XD9EC855A, 0X3FB3ED3C} } },
/**/                 {{{0X7BBF1497, 0X3FCD7FF9} },
/**/                  {{0X1E008CE0, 0X3FCCFE5F} },
/**/                  {{0XF04615C7, 0X3FEE62D2} },
/**/                  {{0X15AADE2C, 0XBFCA9965} },
/**/                  {{0X0B44B682, 0XBFCEB5B9} },
/**/                  {{0X92EC8D57, 0X3FC6B5AF} },
/**/                  {{0X60D831AE, 0X3FB316EE} } },
/**/                 {{{0X40209B20, 0X3FCE0008} },
/**/                  {{0XB145A760, 0X3FCD77DD} },
/**/                  {{0XBE1DFDF1, 0X3FEE556D} },
/**/                  {{0X2186AF0F, 0XBFCAF508} },
/**/                  {{0X9420489D, 0XBFCE5A79} },
/**/                  {{0X454FEB2C, 0X3FC6E462} },
/**/                  {{0XD2945A8C, 0X3FB240B2} } },
/**/                 {{{0XC0AE943C, 0X3FCE8000} },
/**/                  {{0X3CA10100, 0X3FCDF111} },
/**/                  {{0X59E7308B, 0X3FEE47DD} },
/**/                  {{0X9439F69F, 0XBFCB4F88} },
/**/                  {{0X798DE600, 0XBFCDFE93} },
/**/                  {{0X8F267389, 0X3FC710F5} },
/**/                  {{0X1A8A373E, 0X3FB16AAB} } },
/**/                 {{{0X6D532803, 0X3FCF0003} },
/**/                  {{0XCB4E5C80, 0X3FCE6A17} },
/**/                  {{0XE3D0F6C2, 0X3FEE3A1E} },
/**/                  {{0X6E31F768, 0XBFCBA8FB} },
/**/                  {{0XE6A382E3, 0XBFCDA1F7} },
/**/                  {{0XB36AC4C0, 0X3FC73B75} },
/**/                  {{0XA3470B0A, 0X3FB094F7} } },
/**/                 {{{0X48B8AFC3, 0X3FCF7FFA} },
/**/                  {{0XE1654560, 0X3FCEE2DB} },
/**/                  {{0X43F2AB37, 0X3FEE2C35} },
/**/                  {{0X598207D6, 0XBFCC014F} },
/**/                  {{0X1EFE809A, 0XBFCD44BF} },
/**/                  {{0X698A561E, 0X3FC763DC} },
/**/                  {{0XA7CF78A3, 0X3FAF7F70} } },
/**/                 {{{0XEB334FAE, 0X3FD00002} },
/**/                  {{0X77AB25E0, 0X3FCF5B7B} },
/**/                  {{0X78A5C127, 0X3FEE1E1D} },
/**/                  {{0XC555D571, 0XBFCC5898} },
/**/                  {{0XB706CF86, 0XBFCCE6D9} },
/**/                  {{0X0823F643, 0X3FC78A35} },
/**/                  {{0X0B9118E8, 0X3FADD619} } },
/**/                 {{{0XA8AF86FE, 0X3FD03FFC} },
/**/                  {{0XB53A0C00, 0X3FCFD3CB} },
/**/                  {{0XFDCBAC8B, 0X3FEE0FDC} },
/**/                  {{0X6C3246FF, 0XBFCCAEB7} },
/**/                  {{0XD6E19AD3, 0XBFCC8870} },
/**/                  {{0XD2C48E91, 0X3FC7AE73} },
/**/                  {{0X0510FDB0, 0X3FAC2E26} } },
/**/                 {{{0XD38984B7, 0X3FD07FFC} },
/**/                  {{0X5732D4A0, 0X3FD025F7} },
/**/                  {{0X49C17AB3, 0X3FEE0170} },
/**/                  {{0X9AFE5028, 0XBFCD03C2} },
/**/                  {{0X9A2C1833, 0XBFCC2971} },
/**/                  {{0X69041DCF, 0X3FC7D0A5} },
/**/                  {{0XF497C653, 0X3FAA87D3} } },
/**/                 {{{0X1ED2ADD7, 0X3FD0BFFF} },
/**/                  {{0XCD7F7420, 0X3FD061ED} },
/**/                  {{0XDA96B750, 0X3FEDF2D8} },
/**/                  {{0XC777881E, 0XBFCD57B2} },
/**/                  {{0X8692B503, 0XBFCBC9EA} },
/**/                  {{0X42ABF9E7, 0X3FC7F0C9} },
/**/                  {{0X04B42BB4, 0X3FA8E35E} } },
/**/                 {{{0XA8515CDA, 0X3FD10003} },
/**/                  {{0X027416A0, 0X3FD09DC9} },
/**/                  {{0X34899950, 0X3FEDE417} },
/**/                  {{0X7983EDE4, 0XBFCDAA86} },
/**/                  {{0X999706B6, 0XBFCB69E3} },
/**/                  {{0XB0F126DB, 0X3FC80EE1} },
/**/                  {{0X17EE9BAB, 0X3FA740FE} } },
/**/                 {{{0XF3AF9CC5, 0X3FD14001} },
/**/                  {{0XB6E1ABA0, 0X3FD0D980} },
/**/                  {{0XE0412681, 0X3FEDD52D} },
/**/                  {{0X6863B28B, 0XBFCDFC31} },
/**/                  {{0XC55B8D5A, 0XBFCB0971} },
/**/                  {{0XA6731AAC, 0X3FC82AED} },
/**/                  {{0XC73BD8F0, 0X3FA5A0EC} } },
/**/                 {{{0XB6122509, 0X3FD18003} },
/**/                  {{0XAA1E67A0, 0X3FD1151D} },
/**/                  {{0X2E0C1F32, 0X3FEDC61B} },
/**/                  {{0XB9BA6B7E, 0XBFCE4CBE} },
/**/                  {{0X90C2431C, 0XBFCAA88E} },
/**/                  {{0X8BCBDA5E, 0X3FC844F4} },
/**/                  {{0X50E585FF, 0X3FA40361} } },
/**/                 {{{0XA6A2A153, 0X3FD1BFFF} },
/**/                  {{0XE7A18DC0, 0X3FD15096} },
/**/                  {{0XE1218F3F, 0X3FEDB6E1} },
/**/                  {{0X9621D6A2, 0XBFCE9C21} },
/**/                  {{0X22627B04, 0XBFCA4750} },
/**/                  {{0XFF8B908E, 0X3FC85CF5} },
/**/                  {{0X9833C0D6, 0X3FA26891} } },
/**/                 {{{0X2D345AAF, 0X3FD1FFFD} },
/**/                  {{0X053BF760, 0X3FD18BF3} },
/**/                  {{0XCC3ACB29, 0X3FEDA780} },
/**/                  {{0X2AA756AE, 0XBFCEEA62} },
/**/                  {{0X47ED9793, 0XBFC9E5B3} },
/**/                  {{0X87AB542A, 0X3FC872F8} },
/**/                  {{0X158E9E9A, 0X3FA0D0B2} } },
/**/                 {{{0XF14CF05A, 0X3FD23FFC} },
/**/                  {{0X4D568460, 0X3FD1C732} },
/**/                  {{0X55F32D3D, 0X3FED97F8} },
/**/                  {{0X21D457C8, 0XBFCF3780} },
/**/                  {{0XF065B845, 0XBFC983BE} },
/**/                  {{0XFBA70CD8, 0X3FC886FF} },
/**/                  {{0XAEB85CCC, 0X3F9E77EB} } },
/**/                 {{{0X0BAE6FC9, 0X3FD27FFE} },
/**/                  {{0X9A27C160, 0X3FD20253} },
/**/                  {{0X4619176E, 0X3FED8849} },
/**/                  {{0X5C0AC9EC, 0XBFCF8379} },
/**/                  {{0X5E645195, 0XBFC9217C} },
/**/                  {{0XF4264515, 0X3FC8990F} },
/**/                  {{0XE6B92E65, 0X3F9B551C} } },
/**/                 {{{0XA297A7DE, 0X3FD2C001} },
/**/                  {{0XACB927C0, 0X3FD23D57} },
/**/                  {{0XE4958FB6, 0X3FED7873} },
/**/                  {{0X43572249, 0XBFCFCE4E} },
/**/                  {{0X9F3560F3, 0XBFC8BEF1} },
/**/                  {{0XDF7F0E5B, 0X3FC8A92C} },
/**/                  {{0X116F3B19, 0X3F983958} } },
/**/                 {{{0X7267616A, 0X3FD2FFFE} },
/**/                  {{0XB2F378C0, 0X3FD27835} },
/**/                  {{0X13906586, 0X3FED687B} },
/**/                  {{0XAFDA1A0F, 0XBFD00BF9} },
/**/                  {{0XC197AD7D, 0XBFC85C34} },
/**/                  {{0X1E99F0A7, 0X3FC8B759} },
/**/                  {{0X6525C365, 0X3F9524FA} } },
/**/                 {{{0X48153B20, 0X3FD33FFE} },
/**/                  {{0X6A2FDCC0, 0X3FD2B2F6} },
/**/                  {{0XF827FBE4, 0X3FED585C} },
/**/                  {{0XB45A6918, 0XBFD03039} },
/**/                  {{0X5DFC3F72, 0XBFC7F93E} },
/**/                  {{0XC5210022, 0X3FC8C39B} },
/**/                  {{0X168FB62E, 0X3F92185E} } },
/**/                 {{{0X8122579A, 0X3FD38003} },
/**/                  {{0XAF6EC1E0, 0X3FD2ED9B} },
/**/                  {{0X872F20D3, 0X3FED4819} },
/**/                  {{0X1F4C1031, 0XBFD053E8} },
/**/                  {{0X621FFD79, 0XBFC79612} },
/**/                  {{0XDB9D9DFC, 0X3FC8CDF9} },
/**/                  {{0X80C6852F, 0X3F8E27B4} } },
/**/                 {{{0X3EF39141, 0X3FD3C003} },
/**/                  {{0X4668C700, 0X3FD3281B} },
/**/                  {{0X18590D1A, 0X3FED37B4} },
/**/                  {{0XA3EF2560, 0XBFD076FE} },
/**/                  {{0X3033287A, 0XBFC732C9} },
/**/                  {{0XCA2E5458, 0X3FC8D676} },
/**/                  {{0XD80944B1, 0X3F882F85} } },
/**/                 {{{0X63FA0E31, 0X3FD40001} },
/**/                  {{0X7B565000, 0X3FD36278} },
/**/                  {{0X47A813DA, 0X3FED272C} },
/**/                  {{0X493B9D88, 0XBFD0997F} },
/**/                  {{0X3DA9FE3C, 0XBFC6CF64} },
/**/                  {{0XC1CD3331, 0X3FC8DD18} },
/**/                  {{0XF70F6E07, 0X3F8248D1} } },
/**/                 {{{0X74071092, 0X3FD44003} },
/**/                  {{0X0F0A4000, 0X3FD39CB8} },
/**/                  {{0X3BA47A6B, 0X3FED1681} },
/**/                  {{0XD8788947, 0XBFD0BB6C} },
/**/                  {{0X589596A6, 0XBFC66BE2} },
/**/                  {{0XC9B3EC1E, 0X3FC8E1E5} },
/**/                  {{0XD20FAB86, 0X3F78E868} } },
/**/                 {{{0XC880F200, 0X3FD48000} },
/**/                  {{0XDEFFB460, 0X3FD3D6D1} },
/**/                  {{0XCADC576C, 0X3FED05B5} },
/**/                  {{0XA1D352C2, 0XBFD0DCC2} },
/**/                  {{0X3D7D2574, 0XBFC60858} },
/**/                  {{0X03208BC0, 0X3FC8E4E3} },
/**/                  {{0X6379E732, 0X3F6AC909} } },
/**/                 {{{0X4D97D2CB, 0X3FD4C000} },
/**/                  {{0XF3A2E220, 0X3FD410CB} },
/**/                  {{0XBB7ED511, 0X3FECF4C8} },
/**/                  {{0X37766A49, 0XBFD0FD84} },
/**/                  {{0X5AABC13C, 0XBFC5A4C2} },
/**/                  {{0XC80DAC4B, 0X3FC8E616} },
/**/                  {{0XB04695C2, 0X3F4038AA} } },
/**/                 {{{0X9397539F, 0X3FD4FFFD} },
/**/                  {{0X06A7DEC0, 0X3FD44AA2} },
/**/                  {{0XCF479DDE, 0X3FECE3BB} },
/**/                  {{0X4D122984, 0XBFD11DAF} },
/**/                  {{0XB1024DF0, 0XBFC5412E} },
/**/                  {{0X1B2C560D, 0X3FC8E587} },
/**/                  {{0X951C088D, 0XBF625DA8} } },
/**/                 {{{0XF304715F, 0X3FD53FFF} },
/**/                  {{0X791F3900, 0X3FD4845A} },
/**/                  {{0XA45E0FD8, 0X3FECD28D} },
/**/                  {{0X8D61F221, 0XBFD13D47} },
/**/                  {{0XD3E9BB99, 0XBFC4DD98} },
/**/                  {{0X0F181507, 0X3FC8E33A} },
/**/                  {{0XD08BD25C, 0XBF743C33} } },
/**/                 {{{0XE88EA386, 0X3FD58002} },
/**/                  {{0XF575D6C0, 0X3FD4BDF0} },
/**/                  {{0X02035609, 0X3FECC140} },
/**/                  {{0XB808071E, 0XBFD15C4A} },
/**/                  {{0XB2945FCF, 0XBFC47A0E} },
/**/                  {{0XFC056447, 0X3FC8DF35} },
/**/                  {{0XB00A45CD, 0XBF7F2011} } },
/**/                 {{{0X70F4D590, 0X3FD5BFFD} },
/**/                  {{0X284D7AE0, 0X3FD4F75D} },
/**/                  {{0XF2DE98B6, 0X3FECAFD5} },
/**/                  {{0XA2B42F42, 0XBFD17AB4} },
/**/                  {{0X1C285A92, 0XBFC416A5} },
/**/                  {{0X511D6C5A, 0X3FC8D982} },
/**/                  {{0X77008605, 0XBF84ECC1} } },
/**/                 {{{0XB70D6E53, 0X3FD5FFFD} },
/**/                  {{0X8E2FF500, 0X3FD530AB} },
/**/                  {{0X32D2429D, 0X3FEC9E4C} },
/**/                  {{0X35190681, 0XBFD1988C} },
/**/                  {{0XBF748319, 0XBFC3B34C} },
/**/                  {{0X98D3A613, 0X3FC8D224} },
/**/                  {{0XAA295F9F, 0XBF8A33D4} } },
/**/                 {{{0X5C7399E2, 0X3FD63FFC} },
/**/                  {{0X4F022E80, 0X3FD569D5} },
/**/                  {{0X58DD180F, 0X3FEC8CA5} },
/**/                  {{0X1D701DE4, 0XBFD1B5CE} },
/**/                  {{0XA7806A5A, 0XBFC35017} },
/**/                  {{0X56C01CF9, 0X3FC8C924} },
/**/                  {{0X942059E1, 0XBF8F64D9} } },
/**/                 {{{0X9A1AC7D2, 0X3FD67FFD} },
/**/                  {{0XF50031E0, 0X3FD5A2DD} },
/**/                  {{0XCEFF6DEB, 0X3FEC7AE0} },
/**/                  {{0X7C8C245B, 0XBFD1D27C} },
/**/                  {{0XC6AA933F, 0XBFC2ED05} },
/**/                  {{0XDDC5CF1F, 0X3FC8BE87} },
/**/                  {{0XD594386F, 0XBF923FB6} } },
/**/                 {{{0X6F7B9353, 0X3FD6BFFD} },
/**/                  {{0XB4E066C0, 0X3FD5DBC1} },
/**/                  {{0X456B591A, 0X3FEC6900} },
/**/                  {{0XC2D6D0AA, 0XBFD1EE95} },
/**/                  {{0XB11086F7, 0XBFC28A23} },
/**/                  {{0XDDE22D5A, 0X3FC8B256} },
/**/                  {{0X489D85A4, 0XBF94C19A} } },
/**/                 {{{0XF02A83E4, 0X3FD6FFFB} },
/**/                  {{0X6A237DC0, 0X3FD61480} },
/**/                  {{0X4CC81773, 0X3FEC5704} },
/**/                  {{0X4B9029CA, 0XBFD20A1A} },
/**/                  {{0X89F5FB1C, 0XBFC22777} },
/**/                  {{0X9B09E911, 0X3FC8A498} },
/**/                  {{0X130D419A, 0XBF9737EC} } },
/**/                 {{{0X128C213A, 0X3FD73FFE} },
/**/                  {{0X42499480, 0X3FD64D1E} },
/**/                  {{0X129C0D30, 0X3FEC44EC} },
/**/                  {{0X83787259, 0XBFD2250C} },
/**/                  {{0XD55BE4FC, 0XBFC1C4FF} },
/**/                  {{0X36B2D603, 0X3FC89553} },
/**/                  {{0X2E43DF46, 0XBF99A284} } },
/**/                 {{{0XEA0CDC7A, 0X3FD77FFB} },
/**/                  {{0X05B0E220, 0X3FD68594} },
/**/                  {{0X687132C0, 0X3FEC32BA} },
/**/                  {{0X7273497E, 0XBFD23F69} },
/**/                  {{0XCD39B037, 0XBFC162CE} },
/**/                  {{0XFA930AAF, 0X3FC8848F} },
/**/                  {{0XA4554412, 0XBF9C013D} } },
/**/                 {{{0XF18EDAB8, 0X3FD7C003} },
/**/                  {{0X4127BEE0, 0X3FD6BDEE} },
/**/                  {{0XC01607BD, 0X3FEC206B} },
/**/                  {{0X5FEE2F42, 0XBFD25937} },
/**/                  {{0X307761E1, 0XBFC100D4} },
/**/                  {{0X5DFEC556, 0X3FC87252} },
/**/                  {{0X7958F973, 0XBF9E53F6} } },
/**/                 {{{0X41F35C4C, 0X3FD7FFFD} },
/**/                  {{0XDA6607A0, 0X3FD6F616} },
/**/                  {{0XCDDC8437, 0X3FEC0E07} },
/**/                  {{0XBFB4DAEA, 0XBFD2726C} },
/**/                  {{0XE0DB1472, 0XBFC09F3B} },
/**/                  {{0X2A95AA1B, 0X3FC85EA9} },
/**/                  {{0XD872CFA2, 0XBFA04D47} } },
/**/                 {{{0X26C7C46B, 0X3FD84003} },
/**/                  {{0X96B8BE00, 0X3FD72E25} },
/**/                  {{0X4CDEDF38, 0X3FEBFB87} },
/**/                  {{0XD09404F3, 0XBFD28B14} },
/**/                  {{0XE7FB61F2, 0XBFC03DE1} },
/**/                  {{0XACB33BE9, 0X3FC84993} },
/**/                  {{0X9B1DE607, 0XBFA16A76} } },
/**/                 {{{0XCA90B179, 0X3FD88003} },
/**/                  {{0XA104A220, 0X3FD7660A} },
/**/                  {{0XF236E2F6, 0X3FEBE8EF} },
/**/                  {{0X19A94DDF, 0XBFD2A329} },
/**/                  {{0X0856A081, 0XBFBFB9CE} },
/**/                  {{0X33F70280, 0X3FC8331F} },
/**/                  {{0XF01308CC, 0XBFA2817A} } },
/**/                 {{{0XE9692FD5, 0X3FD8C003} },
/**/                  {{0XF0B2CB00, 0X3FD79DC9} },
/**/                  {{0XF2966495, 0X3FEBD640} },
/**/                  {{0XFD6EC2EA, 0XBFD2BAAB} },
/**/                  {{0XE08E9C2D, 0XBFBEF892} },
/**/                  {{0X031873E3, 0X3FC81B52} },
/**/                  {{0XAC12113D, 0XBFA39249} } },
/**/                 {{{0X35BE5C5F, 0X3FD8FFFE} },
/**/                  {{0XBDCCDFC0, 0X3FD7D55E} },
/**/                  {{0X6EABCF77, 0X3FEBC37C} },
/**/                  {{0X2D74F445, 0XBFD2D19C} },
/**/                  {{0XE63F2CDB, 0XBFBE382C} },
/**/                  {{0X0E6FE2AE, 0X3FC80236} },
/**/                  {{0X0E66AB41, 0XBFA49CD9} } },
/**/                 {{{0XAA8974CD, 0X3FD94002} },
/**/                  {{0XB8AFD880, 0X3FD80CD6} },
/**/                  {{0X4468CCBA, 0X3FEBB09E} },
/**/                  {{0XEC84E686, 0XBFD2E7FF} },
/**/                  {{0X88C659E8, 0XBFBD7876} },
/**/                  {{0XC2F15460, 0X3FC7E7CC} },
/**/                  {{0XB410D3ED, 0XBFA5A120} } },
/**/                 {{{0XE08EFDEA, 0X3FD98002} },
/**/                  {{0X34856920, 0X3FD84425} },
/**/                  {{0X3F290478, 0X3FEB9DAB} },
/**/                  {{0XBB81EDEF, 0XBFD2FDD2} },
/**/                  {{0X31E68398, 0XBFBCB9A5} },
/**/                  {{0XC2DBB11B, 0X3FC7CC23} },
/**/                  {{0X98467E78, 0XBFA69F19} } },
/**/                 {{{0X75294B6B, 0X3FD9C002} },
/**/                  {{0X299F6200, 0X3FD87B4D} },
/**/                  {{0XDE96CF1F, 0X3FEB8AA2} },
/**/                  {{0X8C4D45D2, 0XBFD31316} },
/**/                  {{0XEDCE4DBA, 0XBFBBFBB7} },
/**/                  {{0X8907FEC9, 0X3FC7AF41} },
/**/                  {{0X07419F55, 0XBFA796BE} } },
/**/                 {{{0XF3E490EC, 0X3FDA0002} },
/**/                  {{0XC21A4500, 0X3FD8B24F} },
/**/                  {{0X3B5EF7DD, 0X3FEB7785} },
/**/                  {{0X8EAE70CD, 0XBFD327CC} },
/**/                  {{0XD49E40DA, 0XBFBB3EB3} },
/**/                  {{0X4D93F7EA, 0X3FC7912D} },
/**/                  {{0X9E21606A, 0XBFA88809} } },
/**/                 {{{0X458461B6, 0X3FDA3FFF} },
/**/                  {{0X7754D2C0, 0X3FD8E928} },
/**/                  {{0X6A0DAF0E, 0X3FEB6454} },
/**/                  {{0XDC2A9A3F, 0XBFD33BF3} },
/**/                  {{0X4917D003, 0XBFBA82B1} },
/**/                  {{0X7C7566CF, 0X3FC771F1} },
/**/                  {{0X3D700DD8, 0XBFA972F9} } },
/**/                 {{{0X87E12AAE, 0X3FDA8002} },
/**/                  {{0XA5DFD000, 0X3FD91FE0} },
/**/                  {{0XA0D82E05, 0X3FEB510D} },
/**/                  {{0XA76AD312, 0XBFD34F90} },
/**/                  {{0XDEEC35AD, 0XBFB9C798} },
/**/                  {{0X8A0EF43E, 0X3FC75190} },
/**/                  {{0X0872EFC8, 0XBFAA578B} } },
/**/                 {{{0X49A86C84, 0X3FDAC001} },
/**/                  {{0X5C4516E0, 0X3FD9566E} },
/**/                  {{0XDD03F6B6, 0X3FEB3DB4} },
/**/                  {{0X291C1F82, 0XBFD362A0} },
/**/                  {{0X03F6DF60, 0XBFB90D95} },
/**/                  {{0X25091E92, 0X3FC73018} },
/**/                  {{0X577A022B, 0XBFAB35BE} } },
/**/                 {{{0X2F4CC2E1, 0X3FDAFFFF} },
/**/                  {{0X94226540, 0X3FD98CD4} },
/**/                  {{0X9297200A, 0X3FEB2A49} },
/**/                  {{0X5153FD01, 0XBFD37524} },
/**/                  {{0XAE3DE27E, 0XBFB854A3} },
/**/                  {{0X7EB3F331, 0X3FC70D8E} },
/**/                  {{0XB6AD570E, 0XBFAC0D93} } },
/**/                 {{{0XC2F3711E, 0X3FDB4000} },
/**/                  {{0X01CDC4C0, 0X3FD9C317} },
/**/                  {{0XEA63781B, 0X3FEB16CA} },
/**/                  {{0X3665B649, 0XBFD3871F} },
/**/                  {{0X3F70FBC6, 0XBFB79CC0} },
/**/                  {{0X061DFC2E, 0X3FC6E9F9} },
/**/                  {{0XD837F9C3, 0XBFACDF0C} } },
/**/                 {{{0XA777E180, 0X3FDB8000} },
/**/                  {{0XF3748F20, 0X3FD9F930} },
/**/                  {{0X0FB0162A, 0X3FEB033B} },
/**/                  {{0X25978CAB, 0XBFD39890} },
/**/                  {{0X5C765AAB, 0XBFB6E602} },
/**/                  {{0X9C16D678, 0X3FC6C562} },
/**/                  {{0X92A16EBF, 0XBFADAA2C} } },
/**/                 {{{0X087E14ED, 0X3FDBBFFD} },
/**/                  {{0XBF0DDB00, 0X3FDA2F20} },
/**/                  {{0X1CCE6E94, 0X3FEAEF9B} },
/**/                  {{0X8B73E3C3, 0XBFD3A977} },
/**/                  {{0X09EFD1CC, 0XBFB63077} },
/**/                  {{0X58408D3A, 0X3FC69FD4} },
/**/                  {{0XD2E48013, 0XBFAE6EF6} } },
/**/                 {{{0XF0086783, 0X3FDC0000} },
/**/                  {{0X8D448080, 0X3FDA64EF} },
/**/                  {{0X35990B5A, 0X3FEADBE8} },
/**/                  {{0X27241B86, 0XBFD3B9D9} },
/**/                  {{0XC20E4001, 0XBFB57C06} },
/**/                  {{0X90E6C8AB, 0X3FC6794F} },
/**/                  {{0X9A630A27, 0XBFAF2D70} } },
/**/                 {{{0X863E58F8, 0X3FDC4001} },
/**/                  {{0X1C3A1BA0, 0X3FDA9A94} },
/**/                  {{0X35ED7DD2, 0X3FEAC826} },
/**/                  {{0X0C075B50, 0XBFD3C9B3} },
/**/                  {{0XA429793C, 0XBFB4C8D7} },
/**/                  {{0X95903C22, 0X3FC651E2} },
/**/                  {{0XF0F8B649, 0XBFAFE59F} } },
/**/                 {{{0X6C62C3BF, 0X3FDC7FFC} },
/**/                  {{0X580A5840, 0X3FDAD00C} },
/**/                  {{0X62D1D808, 0X3FEAB456} },
/**/                  {{0XACBB06EC, 0XBFD3D905} },
/**/                  {{0X421E42DC, 0XBFB416F7} },
/**/                  {{0XE5608EFD, 0X3FC62996} },
/**/                  {{0XF14B649A, 0XBFB04BC5} } },
/**/                 {{{0X34B2A209, 0X3FDCC002} },
/**/                  {{0XF68F3B40, 0X3FDB0565} },
/**/                  {{0X1E3DC946, 0X3FEAA074} },
/**/                  {{0XE2DB674E, 0XBFD3E7D5} },
/**/                  {{0XA4833FFE, 0XBFB3663E} },
/**/                  {{0XC4F0392B, 0X3FC60069} },
/**/                  {{0X38B10201, 0XBFB0A19E} } },
/**/                 {{{0XAAC5F9F9, 0X3FDCFFFC} },
/**/                  {{0X59C45CC0, 0X3FDB3A8E} },
/**/                  {{0XD2389C24, 0X3FEA8C86} },
/**/                  {{0X8362B2CB, 0XBFD3F61F} },
/**/                  {{0XC6C746A6, 0XBFB2B6F1} },
/**/                  {{0X426D2946, 0X3FC5D671} },
/**/                  {{0X4981CE75, 0XBFB0F45D} } },
/**/                 {{{0X0D800C64, 0X3FDD4004} },
/**/                  {{0X88AF6580, 0X3FDB6F99} },
/**/                  {{0X7498CED2, 0X3FEA7887} },
/**/                  {{0XEF8975C0, 0XBFD403E8} },
/**/                  {{0XBEA81E2B, 0XBFB208D4} },
/**/                  {{0X283FFA4E, 0X3FC5ABA5} },
/**/                  {{0X11705130, 0XBFB14408} } },
/**/                 {{{0XB0E64500, 0X3FDD7FFE} },
/**/                  {{0X2324E140, 0X3FDBA472} },
/**/                  {{0X8C5AD680, 0X3FEA647E} },
/**/                  {{0XA03F042D, 0XBFD4112D} },
/**/                  {{0X9580389C, 0XBFB15C33} },
/**/                  {{0X49D9889E, 0X3FC5801E} },
/**/                  {{0XEF96554F, 0XBFB190A3} } },
/**/                 {{{0X2DFCF4EB, 0X3FDDBFFE} },
/**/                  {{0X9F1D27A0, 0X3FDBD926} },
/**/                  {{0X1AC286CA, 0X3FEA5067} },
/**/                  {{0X590A4DE1, 0XBFD41DF2} },
/**/                  {{0X8BD1EFA5, 0XBFB0B0E4} },
/**/                  {{0X702506D0, 0X3FC553D8} },
/**/                  {{0XADA415A6, 0XBFB1DA36} } },
/**/                 {{{0X8A34BBC2, 0X3FDDFFFD} },
/**/                  {{0XC4F7A2C0, 0X3FDC0DB2} },
/**/                  {{0X2EF70BB3, 0X3FEA3C43} },
/**/                  {{0X16EE647C, 0XBFD42A37} },
/**/                  {{0XDB6270BB, 0XBFB006FA} },
/**/                  {{0X86F08DE6, 0X3FC526DE} },
/**/                  {{0X7E5061FB, 0XBFB220C6} } },
/**/                 {{{0XD26415C0, 0X3FDE3FFD} },
/**/                  {{0X58282940, 0X3FDC4217} },
/**/                  {{0XF391DDCB, 0X3FEA2812} },
/**/                  {{0X18EDDF0A, 0XBFD435FD} },
/**/                  {{0X88A589AF, 0XBFAEBCF2} },
/**/                  {{0X4CF96163, 0X3FC4F937} },
/**/                  {{0XF6A18481, 0XBFB26459} } },
/**/                 {{{0X37F72672, 0X3FDE7FFF} },
/**/                  {{0X67AA3DC0, 0X3FDC7654} },
/**/                  {{0XD6CE86B3, 0X3FEA13D6} },
/**/                  {{0X74037E91, 0XBFD44145} },
/**/                  {{0X3B2CC445, 0XBFAD6EC9} },
/**/                  {{0X0564F101, 0X3FC4CAEA} },
/**/                  {{0X0C49CD64, 0XBFB2A4F8} } },
/**/                 {{{0XA11BC00F, 0X3FDEBFFD} },
/**/                  {{0X85E23660, 0X3FDCAA66} },
/**/                  {{0XA25C2396, 0X3FE9FF90} },
/**/                  {{0X8A64724F, 0XBFD44C10} },
/**/                  {{0X2F871E82, 0XBFAC2399} },
/**/                  {{0X0AFBFB85, 0X3FC49C01} },
/**/                  {{0X0F0FF3FE, 0XBFB2E2A8} } },
/**/                 {{{0X3313756D, 0X3FDEFFFF} },
/**/                  {{0X9D30CC20, 0X3FDCDE52} },
/**/                  {{0XDFF9491F, 0X3FE9EB3E} },
/**/                  {{0X7E6ABAAE, 0XBFD45660} },
/**/                  {{0X3E8AA98D, 0XBFAADB4C} },
/**/                  {{0X25D8FF7D, 0X3FC46C7F} },
/**/                  {{0XA71D448D, 0XBFB31D71} } },
/**/                 {{{0X914B856E, 0X3FDF4001} },
/**/                  {{0XAAC1BB20, 0X3FDD1216} },
/**/                  {{0XC9BC4315, 0X3FE9D6E2} },
/**/                  {{0X004E7E91, 0XBFD46036} },
/**/                  {{0XFB901F89, 0XBFA995F7} },
/**/                  {{0X3F5BE04A, 0X3FC43C6D} },
/**/                  {{0XCE8ABF92, 0XBFB3555C} } },
/**/                 {{{0XCD144428, 0X3FDF8003} },
/**/                  {{0XD93E9640, 0X3FDD45B1} },
/**/                  {{0X256FDFEB, 0X3FE9C27D} },
/**/                  {{0X09F7C145, 0XBFD46992} },
/**/                  {{0XED521174, 0XBFA853A9} },
/**/                  {{0X2B27751F, 0X3FC40BD3} },
/**/                  {{0XCFA5C5F2, 0XBFB38A71} } },
/**/                 {{{0X00545BD9, 0X3FDFC002} },
/**/                  {{0XF536D960, 0X3FDD7920} },
/**/                  {{0XAAE99EA5, 0X3FE9AE0F} },
/**/                  {{0X38DD66F4, 0XBFD47275} },
/**/                  {{0XB5484F74, 0XBFA7147D} },
/**/                  {{0XF8EFC373, 0X3FC3DABA} },
/**/                  {{0X3EA6B864, 0XBFB3BCB9} } },
/**/                 {{{0XDA6F2AA8, 0X3FDFFFFB} },
/**/                  {{0XB420FAA0, 0X3FDDAC63} },
/**/                  {{0XED4D0CAB, 0X3FE9999A} },
/**/                  {{0XBFCC6072, 0XBFD47AE0} },
/**/                  {{0X25BF7A4A, 0XBFA5D87C} },
/**/                  {{0XF5999EE5, 0X3FC3A92B} },
/**/                  {{0XF7F09D08, 0XBFB3EC3B} } },
/**/                 {{{0XA65118C8, 0X3FE01FFF} },
/**/                  {{0X2BF70C00, 0X3FDDDF85} },
/**/                  {{0XECD72AE5, 0X3FE9851A} },
/**/                  {{0X8F5794C5, 0XBFD482D7} },
/**/                  {{0X2E4A020B, 0XBFA49F68} },
/**/                  {{0X25A156DA, 0X3FC37722} },
/**/                  {{0X19F58064, 0XBFB41903} } },
/**/                 {{{0X9C0B0556, 0X3FE04001} },
/**/                  {{0XFA2BA200, 0X3FDE127D} },
/**/                  {{0X08C17A55, 0X3FE97093} },
/**/                  {{0X957A7EFD, 0XBFD48A59} },
/**/                  {{0X2648F2BB, 0XBFA36976} },
/**/                  {{0X592569B1, 0X3FC344AB} },
/**/                  {{0X03752DDB, 0XBFB44318} } },
/**/                 {{{0XC24501DB, 0X3FE05FFF} },
/**/                  {{0XA495BCC0, 0X3FDE4547} },
/**/                  {{0X4F225B79, 0X3FE95C06} },
/**/                  {{0X2163F5B8, 0XBFD49167} },
/**/                  {{0X4B79B89F, 0XBFA236D3} },
/**/                  {{0XB530B7BE, 0X3FC311D4} },
/**/                  {{0X4D931476, 0XBFB46A84} } },
/**/                 {{{0X865125FC, 0X3FE07FFE} },
/**/                  {{0X2A5FAD60, 0X3FDE77E9} },
/**/                  {{0X5C13B0EA, 0X3FE94772} },
/**/                  {{0X6F33ABCA, 0XBFD49802} },
/**/                  {{0XDE947C6B, 0XBFA1075A} },
/**/                  {{0XD8D5E01B, 0X3FC2DE9D} },
/**/                  {{0XCA17CA60, 0XBFB48F51} } },
/**/                 {{{0X107EAC25, 0X3FE0A002} },
/**/                  {{0X08243180, 0X3FDEAA69} },
/**/                  {{0XF339824B, 0X3FE932D4} },
/**/                  {{0X7145F475, 0XBFD49E2D} },
/**/                  {{0X00571424, 0XBF9FB5D8} },
/**/                  {{0X85D1CF84, 0X3FC2AB06} },
/**/                  {{0X7DBBBABE, 0XBFB4B18A} } },
/**/                 {{{0X7376E5D4, 0X3FE0BFFF} },
/**/                  {{0XF79FF560, 0X3FDEDCB5} },
/**/                  {{0X8EE1B492, 0X3FE91E35} },
/**/                  {{0X49498453, 0XBFD4A3E7} },
/**/                  {{0XBE685C6F, 0XBF9D63E4} },
/**/                  {{0XC4B1F032, 0X3FC27726} },
/**/                  {{0X9E6ECC3A, 0XBFB4D138} } },
/**/                 {{{0X1715EE2E, 0X3FE0DFFE} },
/**/                  {{0X9BE1BB80, 0X3FDF0EDB} },
/**/                  {{0XD993BD60, 0X3FE9098F} },
/**/                  {{0X9B84E907, 0XBFD4A932} },
/**/                  {{0XE07DBA5E, 0XBF9B185A} },
/**/                  {{0XF2D7A804, 0X3FC242F8} },
/**/                  {{0X8DDAA340, 0XBFB4EE66} } },
/**/                 {{{0X7F3D776C, 0X3FE10001} },
/**/                  {{0X6119E100, 0X3FDF40DF} },
/**/                  {{0XFB44BCFB, 0X3FE8F4E1} },
/**/                  {{0X16E3467E, 0XBFD4AE11} },
/**/                  {{0XCF368422, 0XBF98D304} },
/**/                  {{0X736708AE, 0X3FC20E7D} },
/**/                  {{0XD7B3658D, 0XBFB5091E} } },
/**/                 {{{0XFD8C7B65, 0X3FE11FFE} },
/**/                  {{0X8FD21560, 0X3FDF72B0} },
/**/                  {{0X4770FB0A, 0X3FE8E033} },
/**/                  {{0X5C0F6783, 0XBFD4B282} },
/**/                  {{0X7FFE0364, 0XBF9694AC} },
/**/                  {{0XE529BF4C, 0X3FC1D9CB} },
/**/                  {{0X2C73E5F0, 0XBFB5216C} } },
/**/                 {{{0XAFA3EE71, 0X3FE14000} },
/**/                  {{0XE3324D60, 0X3FDFA45E} },
/**/                  {{0X9FF684DF, 0X3FE8CB7D} },
/**/                  {{0X17ADD34D, 0XBFD4B689} },
/**/                  {{0X67276E70, 0XBF945CA3} },
/**/                  {{0XA1FBF3B1, 0X3FC1A4D9} },
/**/                  {{0X5FBA2374, 0XBFB53759} } },
/**/                 {{{0X73336187, 0X3FE15FFF} },
/**/                  {{0X3DE48D00, 0X3FDFD5DF} },
/**/                  {{0X0CBE3546, 0X3FE8B6C6} },
/**/                  {{0X9B291BCB, 0XBFD4BA25} },
/**/                  {{0X5FB712CC, 0XBF922B6F} },
/**/                  {{0X55E28B0B, 0X3FC16FB8} },
/**/                  {{0X633F423C, 0XBFB54AF1} } },
/**/                 {{{0X6C447B82, 0X3FE17FFF} },
/**/                  {{0X0208ECC0, 0X3FE0039C} },
/**/                  {{0X48F15926, 0X3FE8A20A} },
/**/                  {{0XA5808AC3, 0XBFD4BD59} },
/**/                  {{0X5EEF6F2A, 0XBF9000CD} },
/**/                  {{0XEBE54AA7, 0X3FC13A66} },
/**/                  {{0X45420CE4, 0XBFB55C3F} } },
/**/                 {{{0XAE932B61, 0X3FE19FFF} },
/**/                  {{0XE0091BC0, 0X3FE01C33} },
/**/                  {{0X55664E00, 0X3FE88D4B} },
/**/                  {{0X579F5ABB, 0XBFD4C026} },
/**/                  {{0X8797C32A, 0XBF8BB9A6} },
/**/                  {{0X95D4F64E, 0X3FC104EC} },
/**/                  {{0X2BBC325E, 0XBFB56B4E} } },
/**/                 {{{0XBA12AE50, 0X3FE1BFFF} },
/**/                  {{0XD3ABA020, 0X3FE034B6} },
/**/                  {{0XEBDCCF04, 0X3FE87889} },
/**/                  {{0XE6D463C1, 0XBFD4C28C} },
/**/                  {{0XB36211FC, 0XBF877F1C} },
/**/                  {{0XB90B11E7, 0X3FC0CF4F} },
/**/                  {{0X52DCBE1A, 0XBFB57829} } },
/**/                 {{{0X4B459E41, 0X3FE1E001} },
/**/                  {{0X2DC05800, 0X3FE04D26} },
/**/                  {{0X51625B6A, 0X3FE863C5} },
/**/                  {{0XAFFDD399, 0XBFD4C48E} },
/**/                  {{0X603059CA, 0XBF8351CB} },
/**/                  {{0XDE65D0D9, 0X3FC09992} },
/**/                  {{0X087BB367, 0XBFB582DC} } },
/**/                 {{{0X32306F33, 0X3FE20000} },
/**/                  {{0XBAFB6CE0, 0X3FE0657E} },
/**/                  {{0XA1E2EEC3, 0X3FE84F00} },
/**/                  {{0XB79EC8C6, 0XBFD4C62C} },
/**/                  {{0XD95DE8D1, 0XBF7E6488} },
/**/                  {{0X661DF241, 0X3FC063C2} },
/**/                  {{0XAAA63BAD, 0XBFB58B71} } },
/**/                 {{{0XD30A486C, 0X3FE22000} },
/**/                  {{0XD2165080, 0X3FE07DC3} },
/**/                  {{0X66B3E5BF, 0X3FE83A39} },
/**/                  {{0X7DE04DEE, 0XBFD4C768} },
/**/                  {{0X800F052F, 0XBF763FF7} },
/**/                  {{0X28F35EDD, 0X3FC02DDC} },
/**/                  {{0XA351CF91, 0XBFB591F5} } },
/**/                 {{{0X215E03FC, 0X3FE23FFE} },
/**/                  {{0X9F380A00, 0X3FE095F1} },
/**/                  {{0X48BE5F3F, 0X3FE82573} },
/**/                  {{0X1B793F77, 0XBFD4C843} },
/**/                  {{0X625993B8, 0XBF6C6E63} },
/**/                  {{0X8C5E4B3B, 0X3FBFEFDB} },
/**/                  {{0X66FE9CA7, 0XBFB59673} } },
/**/                 {{{0X6833D65D, 0X3FE26000} },
/**/                  {{0X6496A8C0, 0X3FE0AE0E} },
/**/                  {{0X45B44AA3, 0X3FE810A9} },
/**/                  {{0X055B407A, 0XBFD4C8BE} },
/**/                  {{0XAE83F0A4, 0XBF5920A7} },
/**/                  {{0X860A6A5E, 0X3FBF83DC} },
/**/                  {{0X70D98EE7, 0XBFB598F6} } },
/**/                 {{{0XE82D4D50, 0X3FE28000} },
/**/                  {{0X095F5300, 0X3FE0C615} },
/**/                  {{0X1E9337B7, 0X3FE7FBE0} },
/**/                  {{0X573C6F6A, 0XBFD4C8DA} },
/**/                  {{0XC50F565D, 0X3F38B6C7} },
/**/                  {{0XC9C4B6CA, 0X3FBF17DB} },
/**/                  {{0X45D6DAE0, 0XBFB5998A} } },
/**/                 {{{0X203B6A0B, 0X3FE29FFF} },
/**/                  {{0X30852720, 0X3FE0DE05} },
/**/                  {{0X8520538D, 0X3FE7E718} },
/**/                  {{0X668C6963, 0XBFD4C899} },
/**/                  {{0XBECA8AB0, 0X3F6286EC} },
/**/                  {{0X9B6AC5BD, 0X3FBEABE4} },
/**/                  {{0X575A9684, 0XBFB5983A} } },
/**/                 {{{0XE91A9D93, 0X3FE2C001} },
/**/                  {{0XF7817A20, 0X3FE0F5E3} },
/**/                  {{0X63A45D97, 0X3FE7D24E} },
/**/                  {{0X5F83C46D, 0XBFD4C7FC} },
/**/                  {{0X5D9C800A, 0X3F70E199} },
/**/                  {{0X3721A8E0, 0X3FBE3FE9} },
/**/                  {{0X377DA840, 0XBFB59512} } },
/**/                 {{{0XC6FB4948, 0X3FE2DFFF} },
/**/                  {{0X4CE36040, 0X3FE10DAA} },
/**/                  {{0X3E39011F, 0X3FE7BD88} },
/**/                  {{0XB5EAE11F, 0XBFD4C704} },
/**/                  {{0X192C622B, 0X3F786398} },
/**/                  {{0XB62BA357, 0X3FBDD412} },
/**/                  {{0X5F0E020E, 0XBFB5901D} } },
/**/                 {{{0X39CB4EED, 0X3FE2FFFF} },
/**/                  {{0X0970AD60, 0X3FE1255D} },
/**/                  {{0X365B7A9B, 0X3FE7A8C2} },
/**/                  {{0X8925F532, 0XBFD4C5B3} },
/**/                  {{0X785E3070, 0X3F7FCB03} },
/**/                  {{0X0EEDF3B3, 0X3FBD6854} },
/**/                  {{0X479C252A, 0XBFB58967} } },
/**/                 {{{0X002E31CB, 0X3FE31FFE} },
/**/                  {{0X81FD3780, 0X3FE13CFA} },
/**/                  {{0X1BBE9667, 0X3FE793FE} },
/**/                  {{0X3046F4C7, 0XBFD4C40A} },
/**/                  {{0X8F5E6BF1, 0X3F838BAE} },
/**/                  {{0X83775C98, 0X3FBCFCBD} },
/**/                  {{0X62E887AB, 0XBFB580FB} } },
/**/                 {{{0XEDC7BFFD, 0X3FE34000} },
/**/                  {{0X44D05200, 0X3FE15486} },
/**/                  {{0X244A1DA5, 0X3FE77F39} },
/**/                  {{0X9FB764C1, 0XBFD4C209} },
/**/                  {{0X851B0BE5, 0X3F8724E2} },
/**/                  {{0X507C76E0, 0X3FBC9147} },
/**/                  {{0X19C7F0AB, 0XBFB576E5} } },
/**/                 {{{0XCE042830, 0X3FE36001} },
/**/                  {{0XC1656AE0, 0X3FE16BFB} },
/**/                  {{0XAD3B2B77, 0X3FE76A77} },
/**/                  {{0X74AAC296, 0XBFD4BFB3} },
/**/                  {{0X05B229C2, 0X3F8AB070} },
/**/                  {{0X87DCA54B, 0X3FBC260E} },
/**/                  {{0XC90DF763, 0XBFB56B2F} } },
/**/                 {{{0X89B8FC54, 0X3FE37FFE} },
/**/                  {{0X77D0BA80, 0X3FE18359} },
/**/                  {{0X660CAA3D, 0X3FE755BB} },
/**/                  {{0X308BB975, 0XBFD4BD09} },
/**/                  {{0XFE0A1240, 0X3F8E2E26} },
/**/                  {{0X18790F26, 0X3FBBBB22} },
/**/                  {{0XC094F3DA, 0XBFB55DE6} } },
/**/                 {{{0X9B4DA842, 0X3FE3A001} },
/**/                  {{0X100CD140, 0X3FE19AA7} },
/**/                  {{0XD801F889, 0X3FE740FD} },
/**/                  {{0X2C32C656, 0XBFD4BA0B} },
/**/                  {{0X8ECA44A2, 0X3F90CF99} },
/**/                  {{0XC9863443, 0X3FBB5066} },
/**/                  {{0X406672B5, 0XBFB54F15} } },
/**/                 {{{0XCE6B63E8, 0X3FE3C000} },
/**/                  {{0X1D0B0AE0, 0X3FE1B1DD} },
/**/                  {{0XF28670E6, 0X3FE72C45} },
/**/                  {{0X92422E2E, 0XBFD4B6BB} },
/**/                  {{0XA0D32146, 0X3F928141} },
/**/                  {{0X37452321, 0X3FBAE606} },
/**/                  {{0X77D91F56, 0XBFB53EC6} } },
/**/                 {{{0X114A2607, 0X3FE3DFFF} },
/**/                  {{0XC6FF6F20, 0X3FE1C8FD} },
/**/                  {{0X206847A7, 0X3FE71792} },
/**/                  {{0X669BD306, 0XBFD4B31B} },
/**/                  {{0X04FFD28A, 0X3F942C3A} },
/**/                  {{0XE7FC0825, 0X3FBA7BFD} },
/**/                  {{0X82F471BA, 0XBFB52D05} } },
/**/                 {{{0XC1DA9B7D, 0X3FE3FFFF} },
/**/                  {{0X7F2E8840, 0X3FE1E00B} },
/**/                  {{0X84371133, 0X3FE702E0} },
/**/                  {{0X8012FBE4, 0XBFD4AF2B} },
/**/                  {{0XBFC47F4B, 0X3F95D0B4} },
/**/                  {{0XD80AB6C5, 0X3FBA1249} },
/**/                  {{0X69A4108D, 0XBFB519DD} } },
/**/                 {{{0XE11D9C33, 0X3FE41FFE} },
/**/                  {{0X67C3EC20, 0X3FE1F703} },
/**/                  {{0X026A76A0, 0X3FE6EE34} },
/**/                  {{0X96514B12, 0XBFD4AAED} },
/**/                  {{0X07BA2905, 0X3F976E83} },
/**/                  {{0X261A1221, 0X3FB9A8FE} },
/**/                  {{0X1D552BA0, 0XBFB50559} } },
/**/                 {{{0XFA174676, 0X3FE43FFF} },
/**/                  {{0X0FAFF860, 0X3FE20DE8} },
/**/                  {{0X9EA6D162, 0X3FE6D98A} },
/**/                  {{0X6B927B3B, 0XBFD4A662} },
/**/                  {{0XF84ADBB0, 0X3F9905D8} },
/**/                  {{0XDD484DB5, 0X3FB94015} },
/**/                  {{0X783EEF44, 0XBFB4EF83} } },
/**/                 {{{0X0D457FA4, 0X3FE45FFF} },
/**/                  {{0X9F675300, 0X3FE224B6} },
/**/                  {{0X3A093351, 0X3FE6C4E7} },
/**/                  {{0XCBF2BFF8, 0XBFD4A18B} },
/**/                  {{0X84BB8C16, 0X3F9A968A} },
/**/                  {{0X93FBB975, 0X3FB8D7A4} },
/**/                  {{0X3B37E4FB, 0XBFB4D867} } },
/**/                 {{{0X8F910E57, 0X3FE47FFE} },
/**/                  {{0XDD92B840, 0X3FE23B70} },
/**/                  {{0X89B04359, 0X3FE6B048} },
/**/                  {{0X974B07FF, 0XBFD49C6A} },
/**/                  {{0X25F20251, 0X3F9C20BE} },
/**/                  {{0X82E9673D, 0X3FB86FA8} },
/**/                  {{0X0D12F550, 0XBFB4C00F} } },
/**/                 {{{0X7323FC6B, 0X3FE4A001} },
/**/                  {{0XE34E3420, 0X3FE25218} },
/**/                  {{0XF277FE27, 0X3FE69BAC} },
/**/                  {{0X7F856ABA, 0XBFD496FF} },
/**/                  {{0X9928150C, 0X3F9DA49E} },
/**/                  {{0X3EB66A26, 0X3FB8081E} },
/**/                  {{0X78AB06C5, 0XBFB4A685} } },
/**/                 {{{0XB1BF0500, 0X3FE4C000} },
/**/                  {{0XBD8B2C80, 0X3FE268A9} },
/**/                  {{0X42ABBD42, 0X3FE68719} },
/**/                  {{0XEC74E64A, 0XBFD4914C} },
/**/                  {{0XD0C3EEEC, 0X3F9F21DE} },
/**/                  {{0X5B30AA05, 0X3FB7A122} },
/**/                  {{0XEC53EF43, 0XBFB48BD4} } },
/**/                 {{{0X1D07207B, 0X3FE4E001} },
/**/                  {{0XDA64F7A0, 0X3FE27F26} },
/**/                  {{0XA7CFBEB2, 0X3FE6728A} },
/**/                  {{0X3FCBB247, 0XBFD48B53} },
/**/                  {{0XA7354A41, 0X3FA04C60} },
/**/                  {{0XEFF6F27A, 0X3FB73AAA} },
/**/                  {{0XB81A6BB2, 0XBFB47007} } },
/**/                 {{{0X5F36EB46, 0X3FE4FFFE} },
/**/                  {{0X35DDD180, 0X3FE2958D} },
/**/                  {{0X307B6AF3, 0X3FE65E04} },
/**/                  {{0X828BB6E6, 0XBFD48514} },
/**/                  {{0X48993ED9, 0X3FA1048E} },
/**/                  {{0X468D7C59, 0X3FB6D4CB} },
/**/                  {{0X0D484989, 0XBFB45328} } },
/**/                 {{{0X2AFDF759, 0X3FE52001} },
/**/                  {{0XEB1C3280, 0X3FE2ABE2} },
/**/                  {{0X8DC5DAAD, 0X3FE64980} },
/**/                  {{0X2C11E3B7, 0XBFD47E90} },
/**/                  {{0X88E1B343, 0X3FA1B9AE} },
/**/                  {{0XFF4501BF, 0X3FB66F6C} },
/**/                  {{0XFCD6B8DE, 0XBFB4353F} } },
/**/                 {{{0XDFDB2423, 0X3FE54001} },
/**/                  {{0XAB0402C0, 0X3FE2C222} },
/**/                  {{0XE7E657FB, 0X3FE63504} },
/**/                  {{0XEEE53FA9, 0XBFD477C8} },
/**/                  {{0X696CD845, 0X3FA26B9A} },
/**/                  {{0X6A3AA6EF, 0X3FB60AAD} },
/**/                  {{0X7704E1F4, 0XBFB41659} } },
/**/                 {{{0X72D2A74F, 0X3FE55FFE} },
/**/                  {{0X16BE7240, 0X3FE2D84B} },
/**/                  {{0XCE54AEDE, 0X3FE62092} },
/**/                  {{0X7B764156, 0XBFD470C0} },
/**/                  {{0X4D9ABEE7, 0X3FA31A4C} },
/**/                  {{0XA899A63D, 0X3FB5A697} },
/**/                  {{0X49FA7FB1, 0XBFB3F67E} } },
/**/                 {{{0XEE716C33, 0X3FE58000} },
/**/                  {{0X284F3FE0, 0X3FE2EE63} },
/**/                  {{0X181C5720, 0X3FE60C24} },
/**/                  {{0XC383B0C1, 0XBFD46975} },
/**/                  {{0XC40A1A5A, 0X3FA3C5FF} },
/**/                  {{0X0B7B3B72, 0X3FB54311} },
/**/                  {{0X21700401, 0XBFB3D5B8} } },
/**/                 {{{0X9825CD2A, 0X3FE59FFF} },
/**/                  {{0X2DEFCF40, 0X3FE30464} },
/**/                  {{0X3C14A317, 0X3FE5F7BF} },
/**/                  {{0X227A4CDE, 0XBFD461EC} },
/**/                  {{0X6DA8D837, 0X3FA46E85} },
/**/                  {{0X6162F4C8, 0X3FB4E03C} },
/**/                  {{0X857F5976, 0XBFB3B410} } },
/**/                 {{{0XFE2A42CD, 0X3FE5BFFD} },
/**/                  {{0XA5110DC0, 0X3FE31A50} },
/**/                  {{0X33CF1268, 0X3FE5E362} },
/**/                  {{0XF68B7DBC, 0XBFD45A23} },
/**/                  {{0XDE40F0E9, 0X3FA513F5} },
/**/                  {{0XDE05901E, 0X3FB47E12} },
/**/                  {{0XDA5CABB5, 0XBFB39190} } },
/**/                 {{{0X57330799, 0X3FE5E000} },
/**/                  {{0X75253480, 0X3FE3302B} },
/**/                  {{0X901DA45A, 0X3FE5CF0A} },
/**/                  {{0X552754CF, 0XBFD4521D} },
/**/                  {{0XBBF000BB, 0X3FA5B66B} },
/**/                  {{0XD2BAF7B2, 0X3FB41C8B} },
/**/                  {{0X5F53241A, 0XBFB36E42} } },
/**/                 {{{0X4D6055DA, 0X3FE60001} },
/**/                  {{0XFF2EDA60, 0X3FE345F0} },
/**/                  {{0XF2EA5900, 0X3FE5BABB} },
/**/                  {{0XB2008754, 0XBFD449DA} },
/**/                  {{0X18F56FBB, 0X3FA655D1} },
/**/                  {{0X89A0C1B2, 0X3FB3BBBB} },
/**/                  {{0X2E8D60FC, 0XBFB34A2E} } },
/**/                 {{{0X2C3809CB, 0X3FE62001} },
/**/                  {{0X812D5040, 0X3FE35BA1} },
/**/                  {{0X671E49E9, 0X3FE5A676} },
/**/                  {{0X230E6216, 0XBFD4415D} },
/**/                  {{0X6B05C7F7, 0X3FA6F22D} },
/**/                  {{0XCFE6B72B, 0X3FB35BA4} },
/**/                  {{0X3C3BFA3B, 0XBFB3255D} } },
/**/                 {{{0X87B47ECC, 0X3FE64000} },
/**/                  {{0X69715580, 0X3FE3713D} },
/**/                  {{0XC8FB0E69, 0X3FE59239} },
/**/                  {{0XA5BD1F6E, 0XBFD438A5} },
/**/                  {{0X7F9B13CF, 0X3FA78B89} },
/**/                  {{0X74F57C8F, 0X3FB2FC49} },
/**/                  {{0X566CAACA, 0XBFB2FFD8} } },
/**/                 {{{0XA746397F, 0X3FE66000} },
/**/                  {{0X9D968940, 0X3FE386C5} },
/**/                  {{0X83073C58, 0X3FE57E05} },
/**/                  {{0XFE3D0083, 0XBFD42FB4} },
/**/                  {{0X4B9E1EEB, 0X3FA821F1} },
/**/                  {{0X1952EE82, 0X3FB29DA9} },
/**/                  {{0X245866A8, 0XBFB2D9A8} } },
/**/                 {{{0XE4E3094B, 0X3FE68000} },
/**/                  {{0XB5FE3900, 0X3FE39C39} },
/**/                  {{0X36DD131E, 0X3FE569DA} },
/**/                  {{0X74778FE0, 0XBFD4268C} },
/**/                  {{0X9AB0310F, 0X3FA8B567} },
/**/                  {{0XF2E43205, 0X3FB23FC8} },
/**/                  {{0X26483573, 0XBFB2B2D5} } },
/**/                 {{{0XE2E37787, 0X3FE6A001} },
/**/                  {{0X27D52620, 0X3FE3B19A} },
/**/                  {{0XB5D865CD, 0X3FE555B7} },
/**/                  {{0XF1600CD3, 0XBFD41D2C} },
/**/                  {{0X4B79E859, 0X3FA945F5} },
/**/                  {{0X46A0B02D, 0X3FB1E2AA} },
/**/                  {{0XB508A35B, 0XBFB28B67} } },
/**/                 {{{0X0DF4BBFB, 0X3FE6BFFE} },
/**/                  {{0X46F2B6E0, 0X3FE3C6E3} },
/**/                  {{0XB658AFBE, 0X3FE541A1} },
/**/                  {{0X388DA137, 0XBFD41399} },
/**/                  {{0XE5B3C2BA, 0X3FA9D387} },
/**/                  {{0X173397F9, 0X3FB18660} },
/**/                  {{0X01DB4945, 0XBFB26368} } },
/**/                 {{{0XEA406CEA, 0X3FE6DFFF} },
/**/                  {{0X1BB3D400, 0X3FE3DC1C} },
/**/                  {{0XD33FFE8E, 0X3FE52D91} },
/**/                  {{0X36BCFFE9, 0XBFD409CF} },
/**/                  {{0X174405AF, 0X3FAA5E54} },
/**/                  {{0XDC041806, 0X3FB12ACE} },
/**/                  {{0X160D6557, 0XBFB23ADE} } },
/**/                 {{{0XED01EA65, 0X3FE70000} },
/**/                  {{0X54E51400, 0X3FE3F140} },
/**/                  {{0X5C8B9119, 0X3FE5198C} },
/**/                  {{0XF2EA4FF7, 0XBFD3FFD1} },
/**/                  {{0X308C81CD, 0X3FAAE643} },
/**/                  {{0X1960AAF7, 0X3FB0D00C} },
/**/                  {{0XD2F50D25, 0XBFB211D1} } },
/**/                 {{{0X00D515EB, 0X3FE72002} },
/**/                  {{0X983BB3E0, 0X3FE40650} },
/**/                  {{0XF2175C71, 0X3FE50590} },
/**/                  {{0X361BB15C, 0XBFD3F5A2} },
/**/                  {{0X9B536AFC, 0X3FAB6B5F} },
/**/                  {{0XA731624D, 0X3FB07617} },
/**/                  {{0XF1A8C054, 0XBFB1E84A} } },
/**/                 {{{0X1323DE6D, 0X3FE74001} },
/**/                  {{0X9483E720, 0X3FE41B4B} },
/**/                  {{0X1027BA01, 0X3FE4F1A1} },
/**/                  {{0XBB978C8F, 0XBFD3EB41} },
/**/                  {{0X7765626A, 0X3FABEDA7} },
/**/                  {{0X97F58C8A, 0X3FB01CF9} },
/**/                  {{0X03074348, 0XBFB1BE51} } },
/**/                 {{{0X25CAB4CA, 0X3FE75FFF} },
/**/                  {{0X0001D5C0, 0X3FE43032} },
/**/                  {{0X4573FB6C, 0X3FE4DDBC} },
/**/                  {{0X41F21D2A, 0XBFD3E0B1} },
/**/                  {{0XD1BDA00F, 0X3FAC6D25} },
/**/                  {{0X5935EE68, 0X3FAF8962} },
/**/                  {{0X6F8E0689, 0XBFB193EB} } },
/**/                 {{{0X90921F76, 0X3FE77FFE} },
/**/                  {{0X6CC6AF00, 0X3FE44505} },
/**/                  {{0X4CFFBDAE, 0X3FE4C9E1} },
/**/                  {{0X0B247EC4, 0XBFD3D5F1} },
/**/                  {{0X943F4516, 0X3FACE9EA} },
/**/                  {{0XF24A8AF1, 0X3FAEDA73} },
/**/                  {{0X776AAC42, 0XBFB16921} } },
/**/                 {{{0X47B2F83B, 0X3FE79FFE} },
/**/                  {{0X35C19F20, 0X3FE459C5} },
/**/                  {{0XFC8F20BD, 0X3FE4B610} },
/**/                  {{0X73DF2A0D, 0XBFD3CB02} },
/**/                  {{0X23C5D6DE, 0X3FAD63F8} },
/**/                  {{0X9C5116AB, 0X3FAE2D31} },
/**/                  {{0X326E2972, 0XBFB13DFA} } },
/**/                 {{{0X2F1E79A9, 0X3FE7BFFF} },
/**/                  {{0XF84DF5C0, 0X3FE46E71} },
/**/                  {{0XF586B1BD, 0X3FE4A24A} },
/**/                  {{0X2EF81E5B, 0XBFD3BFE6} },
/**/                  {{0X738896F0, 0X3FADDB58} },
/**/                  {{0X2515DE78, 0X3FAD819A} },
/**/                  {{0X9026FDD0, 0XBFB1127C} } },
/**/                 {{{0X973C8D05, 0X3FE7E001} },
/**/                  {{0XF0FB9580, 0X3FE4830B} },
/**/                  {{0X3466B08E, 0X3FE48E8F} },
/**/                  {{0X1C53A01A, 0XBFD3B49D} },
/**/                  {{0X25103EED, 0X3FAE5013} },
/**/                  {{0X5290F4AF, 0X3FACD7AF} },
/**/                  {{0X57EF003B, 0XBFB0E6AF} } },
/**/                 {{{0X69EFC092, 0X3FE7FFFF} },
/**/                  {{0X431C3800, 0X3FE4978F} },
/**/                  {{0XA3E1064A, 0X3FE47AE1} },
/**/                  {{0X666C50C4, 0XBFD3A92A} },
/**/                  {{0X4098A4BE, 0X3FAEC219} },
/**/                  {{0X2EEE57E0, 0X3FAC2F94} },
/**/                  {{0X290D5730, 0XBFB0BA99} } },
/**/                 {{{0XC52B5232, 0X3FE82001} },
/**/                  {{0XD2B83340, 0X3FE4AC01} },
/**/                  {{0XD31B7CF5, 0X3FE4673C} },
/**/                  {{0XC67D05F0, 0XBFD39D8B} },
/**/                  {{0X2A81B5D5, 0X3FAF3192} },
/**/                  {{0X8AA20E90, 0X3FAB891B} },
/**/                  {{0X7ADCEFD6, 0XBFB08E40} } },
/**/                 {{{0XBD4D4E3F, 0X3FE84000} },
/**/                  {{0X9B1DBC60, 0X3FE4C05E} },
/**/                  {{0XC8D629F7, 0X3FE453A5} },
/**/                  {{0X13E9EF47, 0XBFD391C5} },
/**/                  {{0X17383D6B, 0X3FAF9E69} },
/**/                  {{0X278E21B9, 0X3FAAE471} },
/**/                  {{0X9CF54D10, 0XBFB061AB} } },
/**/                 {{{0X8C869CBD, 0X3FE86001} },
/**/                  {{0XFD2285A0, 0X3FE4D4A8} },
/**/                  {{0X79B82471, 0X3FE44019} },
/**/                  {{0X5C3E2929, 0XBFD385D5} },
/**/                  {{0X7B2C8FF2, 0X3FB0045B} },
/**/                  {{0X39D7CA4F, 0X3FAA417C} },
/**/                  {{0XB767B7D4, 0XBFB034E0} } },
/**/                 {{{0XB5DB3710, 0X3FE87FFE} },
/**/                  {{0X8B93BCA0, 0X3FE4E8DD} },
/**/                  {{0X66C6E6BF, 0X3FE42C9B} },
/**/                  {{0XA32EE2A1, 0XBFD379BF} },
/**/                  {{0X6187FE0F, 0X3FB03838} },
/**/                  {{0X8B3A0B33, 0X3FA9A05A} },
/**/                  {{0XCAEE03A9, 0XBFB007E5} } },
/**/                 {{{0X863C77E3, 0X3FE8A000} },
/**/                  {{0X8FCD1E80, 0X3FE4FD01} },
/**/                  {{0XA8A8093F, 0X3FE41926} },
/**/                  {{0XB5EE344D, 0XBFD36D81} },
/**/                  {{0X2841F292, 0X3FB06ADC} },
/**/                  {{0X2484560B, 0X3FA900E4} },
/**/                  {{0X62792F0A, 0XBFAFB581} } },
/**/                 {{{0X0ED982AF, 0X3FE8BFFF} },
/**/                  {{0X16E28AC0, 0X3FE51110} },
/**/                  {{0X389112EE, 0X3FE405C0} },
/**/                  {{0X89D38DC7, 0XBFD3611F} },
/**/                  {{0XB450B9F7, 0X3FB09C3D} },
/**/                  {{0X312D0C4A, 0X3FA86342} },
/**/                  {{0X3A6CA012, 0XBFAF5AEE} } },
/**/                 {{{0X02C3AEAE, 0X3FE8E000} },
/**/                  {{0XC0AB0A40, 0X3FE5250C} },
/**/                  {{0XC65593C5, 0X3FE3F264} },
/**/                  {{0XD82BE900, 0XBFD35497} },
/**/                  {{0X68546D39, 0X3FB0CC69} },
/**/                  {{0XDB8499FD, 0X3FA7C759} },
/**/                  {{0X36A32337, 0XBFAF001D} } },
/**/                 {{{0XECBFA97B, 0X3FE90000} },
/**/                  {{0X0E8D4EE0, 0X3FE538F6} },
/**/                  {{0XF4119333, 0X3FE3DF15} },
/**/                  {{0X7D2149F4, 0XBFD347EC} },
/**/                  {{0XFA921D3C, 0X3FB0FB5E} },
/**/                  {{0X69693E89, 0X3FA72D38} },
/**/                  {{0X23A0F5F3, 0XBFAEA519} } },
/**/                 {{{0XD251C01C, 0X3FE91FFF} },
/**/                  {{0XD3F3BD20, 0X3FE54CCA} },
/**/                  {{0X1554DD15, 0X3FE3CBD5} },
/**/                  {{0X2BC94245, 0XBFD33B1F} },
/**/                  {{0X2FC4C3F6, 0X3FB1291F} },
/**/                  {{0X1B7A765C, 0X3FA694E8} },
/**/                  {{0X826E86F6, 0XBFAE49EC} } },
/**/                 {{{0XD90AF4E6, 0X3FE94001} },
/**/                  {{0X4D4EC640, 0X3FE5608E} },
/**/                  {{0X3445EF72, 0X3FE3B89F} },
/**/                  {{0XB7BBD79A, 0XBFD32E2E} },
/**/                  {{0XE401D071, 0X3FB155B4} },
/**/                  {{0X3A256F1C, 0X3FA5FE51} },
/**/                  {{0X890FF662, 0XBFADEEA1} } },
/**/                 {{{0X04FD6C17, 0X3FE96001} },
/**/                  {{0XD5673C20, 0X3FE5743C} },
/**/                  {{0X09EBC6E2, 0X3FE3A578} },
/**/                  {{0X6DA5039C, 0XBFD3211E} },
/**/                  {{0X4E62286B, 0X3FB1811B} },
/**/                  {{0X71BECE9D, 0X3FA56990} },
/**/                  {{0X23911641, 0XBFAD9342} } },
/**/                 {{{0X2D214B82, 0X3FE98000} },
/**/                  {{0X3B0D6120, 0X3FE587D8} },
/**/                  {{0X01EAAC3E, 0X3FE3925E} },
/**/                  {{0X08425504, 0XBFD313EE} },
/**/                  {{0X02BDB571, 0X3FB1AB5A} },
/**/                  {{0X9EBD70B8, 0X3FA4D698} },
/**/                  {{0XF482965A, 0XBFAD37D7} } },
/**/                 {{{0XEB980651, 0X3FE99FFD} },
/**/                  {{0XB16BA7A0, 0X3FE59B5F} },
/**/                  {{0X10B1AB7A, 0X3FE37F52} },
/**/                  {{0XF993D676, 0XBFD3069E} },
/**/                  {{0XCDED25A8, 0X3FB1D472} },
/**/                  {{0X2D0ABD9A, 0X3FA44570} },
/**/                  {{0X56221AA1, 0XBFACDC6C} } },
/**/                 {{{0XE5504053, 0X3FE9BFFF} },
/**/                  {{0XB55DE6A0, 0X3FE5AED6} },
/**/                  {{0XFA91C51E, 0X3FE36C50} },
/**/                  {{0XBE311E56, 0XBFD2F92F} },
/**/                  {{0X5BE3AF05, 0X3FB1FC70} },
/**/                  {{0XACD5CDC7, 0X3FA3B5FD} },
/**/                  {{0X5ADBB9B8, 0XBFAC8108} } },
/**/                 {{{0X6E60A234, 0X3FE9E001} },
/**/                  {{0X79ACD480, 0X3FE5C23A} },
/**/                  {{0XA5FAB2EA, 0X3FE3595D} },
/**/                  {{0X1DDECEEA, 0XBFD2EBA3} },
/**/                  {{0X35736518, 0X3FB22350} },
/**/                  {{0X22F9FD28, 0X3FA32856} },
/**/                  {{0XCE8B2259, 0XBFAC25B4} } },
/**/                 {{{0XB685741B, 0X3FE9FFFF} },
/**/                  {{0X5AD40460, 0X3FE5D589} },
/**/                  {{0XD832B8D3, 0X3FE34679} },
/**/                  {{0X230EDA41, 0XBFD2DDFB} },
/**/                  {{0XB23C0BA2, 0X3FB24912} },
/**/                  {{0X4C4E86DA, 0X3FA29C85} },
/**/                  {{0X37002A55, 0XBFABCA7A} } },
/**/                 {{{0X9D59B943, 0X3FEA2001} },
/**/                  {{0X8C187EA0, 0X3FE5E8C7} },
/**/                  {{0X9EDE2183, 0X3FE333A1} },
/**/                  {{0XB0043779, 0XBFD2D035} },
/**/                  {{0X7AB9110C, 0X3FB26DC3} },
/**/                  {{0X959CFC0E, 0X3FA2126C} },
/**/                  {{0XD556233E, 0XBFAB6F60} } },
/**/                 {{{0XBE9E153F, 0X3FEA3FFF} },
/**/                  {{0XA9C08AE0, 0X3FE5FBF0} },
/**/                  {{0X6F7861AA, 0X3FE320D9} },
/**/                  {{0XC2200F18, 0XBFD2C256} },
/**/                  {{0XA6795293, 0X3FB2915D} },
/**/                  {{0X256A8FDE, 0X3FA18A2B} },
/**/                  {{0XA67A4E89, 0XBFAB1470} } },
/**/                 {{{0X7A23A1CE, 0X3FEA5FFE} },
/**/                  {{0X63200600, 0X3FE60F07} },
/**/                  {{0XD13D395E, 0X3FE30E1E} },
/**/                  {{0X44403932, 0XBFD2B45D} },
/**/                  {{0XC967F013, 0X3FB2B3E9} },
/**/                  {{0X35D002B8, 0X3FA103AD} },
/**/                  {{0X6496A8F1, 0XBFAAB9B1} } },
/**/                 {{{0X57F250B8, 0X3FEA8001} },
/**/                  {{0XDD6453A0, 0X3FE6220D} },
/**/                  {{0XCFFFCC1E, 0X3FE2FB6F} },
/**/                  {{0X6F8D8291, 0XBFD2A648} },
/**/                  {{0X03654CC3, 0X3FB2D56F} },
/**/                  {{0X4BB6E7A6, 0X3FA07EE3} },
/**/                  {{0X87992F03, 0XBFAA5F2A} } },
/**/                 {{{0XDD839D49, 0X3FEAA000} },
/**/                  {{0XB412C9A0, 0X3FE634FF} },
/**/                  {{0XE2D59E01, 0X3FE2E8D0} },
/**/                  {{0X5467CFDD, 0XBFD2981C} },
/**/                  {{0XFF1FADB5, 0X3FB2F5E8} },
/**/                  {{0XA3BA803C, 0X3F9FF7D6} },
/**/                  {{0X46AF8DB7, 0XBFAA04E3} } },
/**/                 {{{0X770DF220, 0X3FEAC000} },
/**/                  {{0XFEF70020, 0X3FE647DE} },
/**/                  {{0X220AFF7F, 0X3FE2D640} },
/**/                  {{0X36F9E74F, 0XBFD289D8} },
/**/                  {{0XE509140A, 0X3FB3155E} },
/**/                  {{0X61AB0B7F, 0X3F9EF56B} },
/**/                  {{0X98CE391F, 0XBFA9AAE2} } },
/**/                 {{{0X125BBE48, 0X3FEAE001} },
/**/                  {{0X57A24D20, 0X3FE65AAC} },
/**/                  {{0X1BFB3559, 0X3FE2C3BD} },
/**/                  {{0X6DDE55DD, 0XBFD27B7C} },
/**/                  {{0X15C4C270, 0X3FB333D5} },
/**/                  {{0X9BAC4ECF, 0X3F9DF67A} },
/**/                  {{0X363A972B, 0XBFA9512F} } },
/**/                 {{{0X7C321839, 0X3FEAFFFE} },
/**/                  {{0X569B83C0, 0X3FE66D65} },
/**/                  {{0X53FBF8D9, 0X3FE2B14A} },
/**/                  {{0X9CFA03CE, 0XBFD26D0B} },
/**/                  {{0X2CAA2E0C, 0X3FB3514B} },
/**/                  {{0X4597BE9A, 0X3F9CFB22} },
/**/                  {{0X99110022, 0XBFA8F7CF} } },
/**/                 {{{0X75486924, 0X3FEB1FFE} },
/**/                  {{0X68CEFB40, 0X3FE6800D} },
/**/                  {{0X8E6AA814, 0X3FE29EE4} },
/**/                  {{0XE8AFA7EB, 0XBFD25E83} },
/**/                  {{0XFB0E8AC8, 0X3FB36DC9} },
/**/                  {{0XAD5D66CA, 0X3F9C0331} },
/**/                  {{0XFEDB1E8B, 0XBFA89EC9} } },
/**/                 {{{0X5FB8DEB8, 0X3FEB4001} },
/**/                  {{0XD137C500, 0X3FE692A4} },
/**/                  {{0XABFF668E, 0X3FE28C8B} },
/**/                  {{0XD8E71E0A, 0XBFD24FE5} },
/**/                  {{0X1297317A, 0X3FB38955} },
/**/                  {{0X1D844655, 0X3F9B0EA3} },
/**/                  {{0X6914067D, 0XBFA84624} } },
/**/                 {{{0X386C27B9, 0X3FEB6000} },
/**/                  {{0X8CDF6FC0, 0X3FE6A527} },
/**/                  {{0XC5758DB8, 0X3FE27A43} },
/**/                  {{0X59CADCE0, 0XBFD24135} },
/**/                  {{0XEE34AE91, 0X3FB3A3E9} },
/**/                  {{0X1C5FFF05, 0X3F9A1DA8} },
/**/                  {{0X9EC8AAC6, 0XBFA7EDE4} } },
/**/                 {{{0XD1EFDDB3, 0X3FEB8000} },
/**/                  {{0X0ACCB660, 0X3FE6B799} },
/**/                  {{0X9983AAB2, 0X3FE26809} },
/**/                  {{0X76047E08, 0XBFD23270} },
/**/                  {{0XF132139B, 0X3FB3BD90} },
/**/                  {{0X58DEB3E1, 0X3F993010} },
/**/                  {{0X2D194CE9, 0XBFA79610} } },
/**/                 {{{0X42CC4047, 0X3FEB9FFE} },
/**/                  {{0X86445E60, 0X3FE6C9F6} },
/**/                  {{0X069F871F, 0X3FE255E0} },
/**/                  {{0X25461639, 0XBFD2239A} },
/**/                  {{0XA926C127, 0X3FB3D649} },
/**/                  {{0XC5A21F70, 0X3F9845FB} },
/**/                  {{0X68E20BE6, 0XBFA73EAC} } },
/**/                 {{{0X951AEAAD, 0X3FEBC001} },
/**/                  {{0X3C4E45A0, 0X3FE6DC45} },
/**/                  {{0XFF6573B0, 0X3FE243C1} },
/**/                  {{0XE38FA7E7, 0XBFD214AE} },
/**/                  {{0X5EA1330F, 0X3FB3EE1E} },
/**/                  {{0X2BCCE6DF, 0X3F975F24} },
/**/                  {{0X6F3902C5, 0XBFA6E7BE} } },
/**/                 {{{0X6616FE11, 0X3FEBDFFE} },
/**/                  {{0X27106FE0, 0X3FE6EE7E} },
/**/                  {{0X97B587F0, 0X3FE231B6} },
/**/                  {{0X240FEF32, 0XBFD205B5} },
/**/                  {{0X44EB818C, 0X3FB40509} },
/**/                  {{0X108160F9, 0X3F967BDE} },
/**/                  {{0X271D18AD, 0XBFA6914B} } },
/**/                 {{{0X54511C72, 0X3FEBFFFF} },
/**/                  {{0X643BBB40, 0X3FE700A7} },
/**/                  {{0XE1823C8B, 0X3FE21FB7} },
/**/                  {{0X9A854F7A, 0XBFD1F6A8} },
/**/                  {{0X71F04837, 0X3FB41B15} },
/**/                  {{0XBBD10F7C, 0X3F959BD8} },
/**/                  {{0X41F03711, 0XBFA63B57} } },
/**/                 {{{0XC537593E, 0X3FEC2000} },
/**/                  {{0XF36D6400, 0X3FE712BE} },
/**/                  {{0XF754B2D5, 0X3FE20DC7} },
/**/                  {{0X9D24DBED, 0XBFD1E78B} },
/**/                  {{0X94F485E0, 0X3FB43043} },
/**/                  {{0X122A6884, 0X3F94BF29} },
/**/                  {{0X3D2AA4E9, 0XBFA5E5E7} } },
/**/                 {{{0XDDD35719, 0X3FEC4000} },
/**/                  {{0XD7FA3000, 0X3FE724C3} },
/**/                  {{0XF2A8B1BF, 0X3FE1FBE7} },
/**/                  {{0XB25DDDF6, 0XBFD1D85F} },
/**/                  {{0XD2E3B20F, 0X3FB44495} },
/**/                  {{0X7FCC1B30, 0X3F93E5D6} },
/**/                  {{0X62D0D00F, 0XBFA590FF} } },
/**/                 {{{0X402375B6, 0X3FEC6000} },
/**/                  {{0X7DFF3720, 0X3FE736B6} },
/**/                  {{0X86C92387, 0X3FE1EA17} },
/**/                  {{0X31DDFC58, 0XBFD1C925} },
/**/                  {{0XF8B6CBC2, 0X3FB4580F} },
/**/                  {{0X00CE998E, 0X3F930FD7} },
/**/                  {{0XCB299E5F, 0XBFA53CA3} } },
/**/                 {{{0X19904FE4, 0X3FEC7FFF} },
/**/                  {{0X0F395860, 0X3FE74897} },
/**/                  {{0XA825BA33, 0X3FE1D856} },
/**/                  {{0XA75E0FC5, 0XBFD1B9DC} },
/**/                  {{0X79F8FD7D, 0X3FB46AB5} },
/**/                  {{0XA5A90AFE, 0X3F923D23} },
/**/                  {{0X5D2F574B, 0XBFA4E8D8} } },
/**/                 {{{0XF9E2409D, 0X3FEC9FFE} },
/**/                  {{0X79E7F1C0, 0X3FE75A66} },
/**/                  {{0X8740D2E9, 0X3FE1C6A4} },
/**/                  {{0XF198392C, 0XBFD1AA85} },
/**/                  {{0X808C583A, 0X3FB47C8A} },
/**/                  {{0X857F2526, 0X3F916DAC} },
/**/                  {{0XD0477576, 0XBFA495A0} } },
/**/                 {{{0XE038EF72, 0X3FECC001} },
/**/                  {{0XE6815140, 0X3FE76C25} },
/**/                  {{0X19BDADF8, 0X3FE1B500} },
/**/                  {{0XB4A469AE, 0XBFD19B20} },
/**/                  {{0X42387EA2, 0X3FB48D93} },
/**/                  {{0X7305BAF5, 0X3F90A15F} },
/**/                  {{0XACAE4E17, 0XBFA44300} } },
/**/                 {{{0XEB72037F, 0X3FECDFFE} },
/**/                  {{0X7A7A4AA0, 0X3FE77DD0} },
/**/                  {{0X4F1F6702, 0X3FE1A36E} },
/**/                  {{0XD0992CF8, 0XBFD18BB1} },
/**/                  {{0X5AA4990D, 0X3FB49DCE} },
/**/                  {{0X63759665, 0X3F8FB0DD} },
/**/                  {{0X4D2F0C0F, 0XBFA3F0FB} } },
/**/                 {{{0XEA4839ED, 0X3FECFFFF} },
/**/                  {{0XB17088C0, 0X3FE78F6B} },
/**/                  {{0XCF32122F, 0X3FE191E9} },
/**/                  {{0X220400AC, 0XBFD17C35} },
/**/                  {{0X0A159641, 0X3FB4AD44} },
/**/                  {{0X80894CA9, 0X3F8E252C} },
/**/                  {{0XDF89C265, 0XBFA39F93} } },
/**/                 {{{0XEC3EC8B2, 0X3FED1FFD} },
/**/                  {{0XC8C6C880, 0X3FE7A0F3} },
/**/                  {{0X729F01D6, 0X3FE18076} },
/**/                  {{0X98515540, 0XBFD16CAE} },
/**/                  {{0X1B0933FF, 0X3FB4BBF4} },
/**/                  {{0XE09A60CD, 0X3F8C9FF5} },
/**/                  {{0X662A5704, 0XBFA34ECD} } },
/**/                 {{{0X7084EDD4, 0X3FED3FFF} },
/**/                  {{0X5F02F220, 0X3FE7B26C} },
/**/                  {{0XB9973206, 0X3FE16F10} },
/**/                  {{0X9E1E0A54, 0XBFD15D1B} },
/**/                  {{0XAC2C9A30, 0X3FB4C9E4} },
/**/                  {{0XEFCE76CC, 0X3F8B20DD} },
/**/                  {{0XB888BC37, 0XBFA2FEAA} } },
/**/                 {{{0X8D728E7C, 0X3FED5FFE} },
/**/                  {{0X488D7E80, 0X3FE7C3D2} },
/**/                  {{0XE622A5A7, 0X3FE15DBB} },
/**/                  {{0XA305CEB2, 0XBFD14D7F} },
/**/                  {{0X417BF1C7, 0X3FB4D716} },
/**/                  {{0XE19FE239, 0X3F89A81E} },
/**/                  {{0X84DDAD07, 0XBFA2AF2E} } },
/**/                 {{{0X70AA3B03, 0X3FED7FFF} },
/**/                  {{0XDB239580, 0X3FE7D527} },
/**/                  {{0XBE4FEA01, 0X3FE14C75} },
/**/                  {{0X2AD706AA, 0XBFD13DD9} },
/**/                  {{0XB49D32AA, 0X3FB4E38D} },
/**/                  {{0X37DF2B6D, 0X3F88357A} },
/**/                  {{0X507CD77B, 0XBFA2605B} } },
/**/                 {{{0X1434FBA3, 0X3FED9FFF} },
/**/                  {{0X82C8A720, 0X3FE7E66B} },
/**/                  {{0XED9B7FED, 0X3FE13B3F} },
/**/                  {{0X3AC9D646, 0XBFD12E2A} },
/**/                  {{0XE7B01CF5, 0X3FB4EF4C} },
/**/                  {{0XD25FD52D, 0X3F86C905} },
/**/                  {{0X798666EF, 0XBFA21233} } },
/**/                 {{{0XA8C8DE8C, 0X3FEDBFFE} },
/**/                  {{0XF4A0A520, 0X3FE7F79D} },
/**/                  {{0XD7FC2119, 0X3FE12A19} },
/**/                  {{0XC6BE19DF, 0XBFD11E72} },
/**/                  {{0X634E1B91, 0X3FB4FA57} },
/**/                  {{0X47F96DF5, 0X3F8562A6} },
/**/                  {{0X373AF599, 0XBFA1C4B9} } },
/**/                 {{{0X26573DF5, 0X3FEDE000} },
/**/                  {{0X4DBCB960, 0X3FE808C0} },
/**/                  {{0X7903E4B9, 0X3FE11902} },
/**/                  {{0X5CDFED06, 0XBFD10EB2} },
/**/                  {{0XCCA681FA, 0X3FB504B0} },
/**/                  {{0X6F3CDE09, 0X3F840238} },
/**/                  {{0X9BA8FA6A, 0XBFA177EE} } },
/**/                 {{{0X35009B66, 0X3FEDFFFE} },
/**/                  {{0XC2CB5340, 0X3FE819CF} },
/**/                  {{0XB1C942B5, 0X3FE107FC} },
/**/                  {{0X230D7D92, 0XBFD0FEEC} },
/**/                  {{0X75C5B4F1, 0X3FB50E5A} },
/**/                  {{0XE3C139D8, 0X3F82A7E8} },
/**/                  {{0X93FA642B, 0XBFA12BD5} } },
/**/                 {{{0X492D4C68, 0X3FEE2000} },
/**/                  {{0X5CCB8680, 0X3FE82AD0} },
/**/                  {{0X928E55DF, 0X3FE0F704} },
/**/                  {{0XEE0B0721, 0XBFD0EF1C} },
/**/                  {{0X937BFB74, 0X3FB51759} },
/**/                  {{0X2BC9FDDB, 0X3F815359} },
/**/                  {{0XEA1D1824, 0XBFA0E06F} } },
/**/                 {{{0X9412BB65, 0X3FEE4000} },
/**/                  {{0X14001A60, 0X3FE83BBF} },
/**/                  {{0X37F485DA, 0X3FE0E61D} },
/**/                  {{0X1B2BD37D, 0XBFD0DF48} },
/**/                  {{0X64024D14, 0X3FB51FAF} },
/**/                  {{0X9B849698, 0X3F8004B9} },
/**/                  {{0X450A2434, 0XBFA095BF} } },
/**/                 {{{0X4758EF2F, 0X3FEE5FFF} },
/**/                  {{0X1531C180, 0X3FE84C9C} },
/**/                  {{0X8B7FECE7, 0X3FE0D546} },
/**/                  {{0X105BFE1E, 0XBFD0CF6E} },
/**/                  {{0XF9C5E03A, 0X3FB5275E} },
/**/                  {{0X17AA1137, 0X3F7D77F2} },
/**/                  {{0X2A6891E1, 0XBFA04BC5} } },
/**/                 {{{0X380F819F, 0X3FEE8000} },
/**/                  {{0X74CCC060, 0X3FE85D69} },
/**/                  {{0X8F1DA5B5, 0X3FE0C47E} },
/**/                  {{0X62AD700F, 0XBFD0BF8D} },
/**/                  {{0X1F3FBC2B, 0X3FB52E6C} },
/**/                  {{0XEE24AD7D, 0X3F7AF1C3} },
/**/                  {{0XFECE26C9, 0XBFA00282} } },
/**/                 {{{0XA6D8CB7B, 0X3FEEA000} },
/**/                  {{0XD00E3A60, 0X3FE86E25} },
/**/                  {{0XBA314D62, 0X3FE0B3C6} },
/**/                  {{0XE7CB2D84, 0XBFD0AFA7} },
/**/                  {{0X08E9071F, 0X3FB534D9} },
/**/                  {{0X4CE5E5C9, 0X3F787704} },
/**/                  {{0X0EB7C9D5, 0XBF9F73F4} } },
/**/                 {{{0X5A13BA60, 0X3FEEC000} },
/**/                  {{0X19B163E0, 0X3FE87ED1} },
/**/                  {{0X2EBB7AD7, 0X3FE0A31F} },
/**/                  {{0X33A3FCE1, 0XBFD09FBE} },
/**/                  {{0X89D9AF5D, 0X3FB53AA8} },
/**/                  {{0XF7F7040B, 0X3F760799} },
/**/                  {{0XD3F0B3FB, 0XBF9EE456} } },
/**/                 {{{0X58F8DD18, 0X3FEEDFFF} },
/**/                  {{0X6681CA80, 0X3FE88F6B} },
/**/                  {{0XEC4360B3, 0X3FE09287} },
/**/                  {{0XB7CE07E5, 0XBFD08FD0} },
/**/                  {{0X7BDEDD3F, 0X3FB53FDD} },
/**/                  {{0X70C52E66, 0X3F73A366} },
/**/                  {{0X5DCA7315, 0XBF9E5630} } },
/**/                 {{{0XBE033400, 0X3FEEFFFF} },
/**/                  {{0XDD4D7960, 0X3FE89FF5} },
/**/                  {{0XDFFE15BD, 0X3FE081FF} },
/**/                  {{0XDAE56C0F, 0XBFD07FDE} },
/**/                  {{0XF84D6F5D, 0X3FB5447A} },
/**/                  {{0X7982941E, 0X3F714A24} },
/**/                  {{0X81E68835, 0XBF9DC982} } },
/**/                 {{{0XE6B5125D, 0X3FEF2001} },
/**/                  {{0XBBE88160, 0X3FE8B070} },
/**/                  {{0XDF7122E2, 0X3FE07186} },
/**/                  {{0XDE905325, 0XBFD06FE8} },
/**/                  {{0XB5DEEC7A, 0X3FB54883} },
/**/                  {{0XB4A186D5, 0X3F6DF762} },
/**/                  {{0XDE20F495, 0XBF9D3E4E} } },
/**/                 {{{0XF770E0DB, 0X3FEF3FFD} },
/**/                  {{0X09E96380, 0X3FE8C0D8} },
/**/                  {{0XF5A576A9, 0X3FE06120} },
/**/                  {{0X1D2912FF, 0XBFD05FF3} },
/**/                  {{0X8CD1001F, 0X3FB54BF9} },
/**/                  {{0X6E90DC16, 0X3F6970FC} },
/**/                  {{0XD8EB587E, 0XBF9CB496} } },
/**/                 {{{0X4E16DA33, 0X3FEF5FFE} },
/**/                  {{0X29BCCDC0, 0X3FE8D131} },
/**/                  {{0XD33BA4E9, 0X3FE050C8} },
/**/                  {{0XD74C83D2, 0XBFD04FF8} },
/**/                  {{0X592BB252, 0X3FB54EE0} },
/**/                  {{0X7193EEB5, 0X3F64FF61} },
/**/                  {{0XA459AC86, 0XBF9C2C5B} } },
/**/                 {{{0X4576FF2E, 0X3FEF8000} },
/**/                  {{0XCCE443A0, 0X3FE8E17A} },
/**/                  {{0XD8A97B6C, 0X3FE0407F} },
/**/                  {{0XC91B3E55, 0XBFD03FFB} },
/**/                  {{0X5F3357F7, 0X3FB5513A} },
/**/                  {{0X14C92B53, 0X3F60A2BA} },
/**/                  {{0X3E70DF71, 0XBF9BA59E} } },
/**/                 {{{0X39B6A330, 0X3FEF9FFF} },
/**/                  {{0XA7F515A0, 0X3FE8F1B2} },
/**/                  {{0X63064158, 0X3FE03048} },
/**/                  {{0XACBAADA8, 0XBFD02FFE} },
/**/                  {{0XF27448C0, 0X3FB55309} },
/**/                  {{0X4850006B, 0X3F58B6D6} },
/**/                  {{0X742323DF, 0XBF9B205F} } },
/**/                 {{{0XAA76C0B9, 0X3FEFC001} },
/**/                  {{0X15D66D80, 0X3FE901DC} },
/**/                  {{0X28D9B4AA, 0X3FE0201F} },
/**/                  {{0XA98D4C38, 0XBFD01FFE} },
/**/                  {{0X089780F8, 0X3FB55452} },
/**/                  {{0X7F35C5BB, 0X3F5050B5} },
/**/                  {{0XE19247AF, 0XBF9A9C9F} } },
/**/                 {{{0X39A592CA, 0X3FEFDFFE} },
/**/                  {{0X6D88A780, 0X3FE911F2} },
/**/                  {{0XE40C6538, 0X3FE01008} },
/**/                  {{0XD31688DE, 0XBFD01000} },
/**/                  {{0XE32F1816, 0X3FB55514} },
/**/                  {{0X4E1628D2, 0X3F402A15} },
/**/                  {{0XF4FAF5A0, 0XBF9A1A5F} } },
/**/                 {{{0X8E92D1B0, 0X3FEFF801} },
/**/                  {{0X9BB4BF00, 0X3FE91DFB} },
/**/                  {{0XB884C5A9, 0X3FE003FF} },
/**/                  {{0X3876A954, 0XBFD003FF} },
/**/                  {{0X5539DDFB, 0X3FB55551} },
/**/                  {{0X7B95E6C2, 0X3F2007E7} },
/**/                  {{0X18A3BA58, 0XBF99B9A7} } },
  };

  static const number
     hij[241][16] = {                             /* x0,hij for (1/16,1) */
/**/                 {{{0x00000000, 0x3fb04000} },
/**/                  {{0x1c06693d, 0x3fb03a6d} },
/**/                  {{0xd4e7f128, 0xbc428a02} },
/**/                  {{0xe92592ae, 0x3fefdf1f} },
/**/                  {{0xb5490162, 0x3c88bfc0} },
/**/                  {{0x8f7e4151, 0xbfb01ead} },
/**/                  {{0x0b64d205, 0xbc5395e8} },
/**/                  {{0x433dd49b, 0xbfd4d29f} },
/**/                  {{0x4aa42633, 0xbc75b19d} },
/**/                  {{0xce35961d, 0x3fafda41} },
/**/                  {{0x425d7696, 0x3c4e6a5f} },
/**/                  {{0x6c1bb5e2, 0x3fc814dd} },
/**/                  {{0x2b33739f, 0xbfaf4cb7} },
/**/                  {{0xc267d8ec, 0xbfc048b2} },
/**/                  {{0xe8ababc6, 0x3fae9649} },
/**/                  {{0xfe802692, 0x3fb78293} } },
/**/                 {{{0x00000000, 0x3fb10000} },
/**/                  {{0xa71d52a7, 0x3fb0f99e} },
/**/                  {{0xeec3624f, 0xbc22069f} },
/**/                  {{0x9a49d2a9, 0x3fefdc08} },
/**/                  {{0x68b2ce25, 0x3c7780f7} },
/**/                  {{0x9da73e1d, 0xbfb0d9de} },
/**/                  {{0xa1a487bf, 0x3c4ebf46} },
/**/                  {{0xd13ea108, 0xbfd4c669} },
/**/                  {{0xebb4528c, 0x3c7354bc} },
/**/                  {{0x789374c1, 0x3fb0a137} },
/**/                  {{0xc3f2c5c2, 0xbc56c223} },
/**/                  {{0x79c60cda, 0x3fc7f0e7} },
/**/                  {{0xcdcc7b81, 0xbfb05062} },
/**/                  {{0xc5266783, 0xbfc019e4} },
/**/                  {{0xf2540289, 0x3fafd0b2} },
/**/                  {{0xf6d3cd8a, 0x3fb71107} } },
/**/                 {{{0x00000000, 0x3fb20000} },
/**/                  {{0xbf082d59, 0x3fb1f86d} },
/**/                  {{0x7732ef81, 0xbc4095dc} },
/**/                  {{0x01722b81, 0x3fefd7b3} },
/**/                  {{0x8a212e02, 0xbc5e618c} },
/**/                  {{0xee4e9cfa, 0xbfb1d2c5} },
/**/                  {{0x29abece0, 0x3c426273} },
/**/                  {{0x37eb7f46, 0xbfd4b551} },
/**/                  {{0x01d8bf12, 0x3c73b360} },
/**/                  {{0x6adb6a7c, 0x3fb18fa7} },
/**/                  {{0x398999ad, 0xbc5c00d8} },
/**/                  {{0xf4a7cff3, 0x3fc7bea5} },
/**/                  {{0x61f84829, 0xbfb13008} },
/**/                  {{0xa8e135a1, 0xbfbfb14f} },
/**/                  {{0x4324f177, 0x3fb0b532} },
/**/                  {{0x3498dd9d, 0x3fb6734a} } },
/**/                 {{{0x00000000, 0x3fb30000} },
/**/                  {{0x318a4a9a, 0x3fb2f719} },
/**/                  {{0x79b9801f, 0x3c03fd17} },
/**/                  {{0x48e238fe, 0x3fefd31f} },
/**/                  {{0xd8c45327, 0xbc876a7a} },
/**/                  {{0x852096e2, 0xbfb2cada} },
/**/                  {{0x11efd787, 0x3c460860} },
/**/                  {{0x2e476a39, 0xbfd4a34b} },
/**/                  {{0xeb11ee51, 0x3c7254f2} },
/**/                  {{0xc54ae225, 0x3fb27c13} },
/**/                  {{0x4ae66f0c, 0x3c513096} },
/**/                  {{0xef0d59d0, 0x3fc789ca} },
/**/                  {{0x6d9aaa8c, 0xbfb20c06} },
/**/                  {{0x846ba912, 0xbfbf2885} },
/**/                  {{0xc697ef5e, 0x3fb17c5f} },
/**/                  {{0xcad31e6e, 0x3fb5ce93} } },
/**/                 {{{0x00000000, 0x3fb40000} },
/**/                  {{0x0e7c559d, 0x3fb3f59f} },
/**/                  {{0x285df847, 0x3c5ac4ce} },
/**/                  {{0xa6ab93e9, 0x3fefce4d} },
/**/                  {{0x18a97736, 0xbc6be46b} },
/**/                  {{0x4d22b635, 0xbfb3c211} },
/**/                  {{0x6950679f, 0x3c42033c} },
/**/                  {{0xc4d74033, 0xbfd49059} },
/**/                  {{0xd7e376aa, 0x3c57dd7c} },
/**/                  {{0xc0896a7c, 0x3fb36662} },
/**/                  {{0xd79232cf, 0xbc36cf6a} },
/**/                  {{0xa13a97a2, 0x3fc75261} },
/**/                  {{0x5fdd1509, 0xbfb2e431} },
/**/                  {{0x6e52db32, 0xbfbe9999} },
/**/                  {{0xb0a71e9f, 0x3fb23da4} },
/**/                  {{0xe3bc8178, 0x3fb52335} } },
/**/                 {{{0x00000000, 0x3fb50000} },
/**/                  {{0x677292fb, 0x3fb4f3fd} },
/**/                  {{0x6264979e, 0x3c4008d3} },
/**/                  {{0x53a1ee0d, 0x3fefc93e} },
/**/                  {{0x20fd2bdf, 0xbc64421a} },
/**/                  {{0x4aba88e3, 0xbfb4b85f} },
/**/                  {{0x3c9d1e89, 0x3c54f184} },
/**/                  {{0x25ae4668, 0xbfd47c7f} },
/**/                  {{0x816630d1, 0xbc7d7581} },
/**/                  {{0x07f85056, 0x3fb44e7b} },
/**/                  {{0x910bdf4f, 0x3c56d63c} },
/**/                  {{0xc439029c, 0x3fc71875} },
/**/                  {{0xf2bcfa10, 0xbfb3b85e} },
/**/                  {{0x9707b205, 0xbfbe04bb} },
/**/                  {{0x95e3e0cc, 0x3fb2f8c6} },
/**/                  {{0x8093431b, 0x3fb47184} } },
/**/                 {{{0x00000000, 0x3fb60000} },
/**/                  {{0x4fd2d7b2, 0x3fb5f232} },
/**/                  {{0x4401318e, 0x3c58a8da} },
/**/                  {{0x8b549418, 0x3fefc3f1} },
/**/                  {{0x836f8130, 0x3c34d896} },
/**/                  {{0x9cdd92e7, 0xbfb5adb9} },
/**/                  {{0xeb397cc3, 0x3c4d4161} },
/**/                  {{0x93f8f1dc, 0xbfd467bd} },
/**/                  {{0xffc760ad, 0xbc609d7b} },
/**/                  {{0xbea6b2fe, 0x3fb53443} },
/**/                  {{0x4b24f5db, 0x3c5eb03c} },
/**/                  {{0x8de3d005, 0x3fc6dc13} },
/**/                  {{0x37d2d99d, 0xbfb48866} },
/**/                  {{0xf6663fcb, 0xbfbd6a1d} },
/**/                  {{0x0adff464, 0x3fb3ad8e} },
/**/                  {{0x4159c223, 0x3fb3b9d6} } },
/**/                 {{{0x00000000, 0x3fb70000} },
/**/                  {{0xdcea4b0d, 0x3fb6f03b} },
/**/                  {{0x512fa17d, 0xbc33f00e} },
/**/                  {{0x8c07a436, 0x3fefbe67} },
/**/                  {{0x46250d6f, 0xbc84baaa} },
/**/                  {{0x7e3ba4c7, 0xbfb6a215} },
/**/                  {{0x54503f8d, 0xbc3504e7} },
/**/                  {{0x6b82d03a, 0xbfd45217} },
/**/                  {{0xbebdd1db, 0x3c7d1f0d} },
/**/                  {{0x841d5604, 0x3fb617a4} },
/**/                  {{0x6681c436, 0xbc47168b} },
/**/                  {{0xaccec6ce, 0x3fc69d47} },
/**/                  {{0xa4715800, 0xbfb5541f} },
/**/                  {{0x335a1c1b, 0xbfbcc9f4} },
/**/                  {{0xbac0061f, 0x3fb45bc6} },
/**/                  {{0x2b3853b6, 0x3fb2fc84} } },
/**/                 {{{0x00000000, 0x3fb80000} },
/**/                  {{0x2602f10f, 0x3fb7ee18} },
/**/                  {{0x4c0c3d98, 0xbc5cfb65} },
/**/                  {{0x96acfacc, 0x3fefb8a0} },
/**/                  {{0x18495af3, 0xbc82962e} },
/**/                  {{0x46635c89, 0xbfb79568} },
/**/                  {{0xa6bfd498, 0x3c5ac468} },
/**/                  {{0x2037b997, 0xbfd43b8f} },
/**/                  {{0xe2f12373, 0xbc72ad53} },
/**/                  {{0x7900c4ee, 0x3fb6f885} },
/**/                  {{0x0aef1f9d, 0x3c53145d} },
/**/                  {{0x4409ba0e, 0x3fc65c1f} },
/**/                  {{0x1d176e0c, 0xbfb61b65} },
/**/                  {{0x8ad65152, 0xbfbc2473} },
/**/                  {{0x7bc246c1, 0x3fb5033f} },
/**/                  {{0x6db30b46, 0x3fb239e9} } },
/**/                 {{{0x00000000, 0x3fb90000} },
/**/                  {{0x4478fb28, 0x3fb8ebc5} },
/**/                  {{0x0cad24cc, 0x3c473288} },
/**/                  {{0xeedcd6d7, 0x3fefb29c} },
/**/                  {{0x23ea50f0, 0x3c8efa9e} },
/**/                  {{0x6ae09982, 0xbfb887a7} },
/**/                  {{0x53801511, 0x3c5b2275} },
/**/                  {{0x3da0757c, 0xbfd42427} },
/**/                  {{0x311c7ac8, 0xbc7199e5} },
/**/                  {{0x4388717b, 0x3fb7d6cf} },
/**/                  {{0x3dd070b4, 0xbc5c4eb2} },
/**/                  {{0xe6c2b5f3, 0x3fc618a7} },
/**/                  {{0x00313569, 0xbfb6de12} },
/**/                  {{0xb6316619, 0xbfbb79d2} },
/**/                  {{0x61af5c21, 0x3fb5a3ca} },
/**/                  {{0x26e60289, 0x3fb17263} } },
/**/                 {{{0x00000000, 0x3fba0000} },
/**/                  {{0x53cfdcf1, 0x3fb9e941} },
/**/                  {{0x1d69c47e, 0x3c5a332e} },
/**/                  {{0xdace3776, 0x3fefac5c} },
/**/                  {{0x1ad91ab5, 0xbc8c9a78} },
/**/                  {{0x8054ad75, 0xbfb978c8} },
/**/                  {{0x8ed66c17, 0xbc5e35b8} },
/**/                  {{0x665afed1, 0xbfd40be2} },
/**/                  {{0x08ef10fb, 0x3c62eeef} },
/**/                  {{0x13c989d2, 0x3fb8b26b} },
/**/                  {{0xbfeab3ba, 0x3c329f11} },
/**/                  {{0x93c8f97c, 0x3fc5d2ef} },
/**/                  {{0x30234881, 0xbfb79c03} },
/**/                  {{0xd0f650c8, 0xbfbaca49} },
/**/                  {{0xce2dcccc, 0x3fb63d3c} },
/**/                  {{0x26fb0af2, 0x3fb0a650} } },
/**/                 {{{0x00000000, 0x3fbb0000} },
/**/                  {{0x71c722b8, 0x3fbae68a} },
/**/                  {{0x6910b9db, 0x3c4c014e} },
/**/                  {{0xa34ef42b, 0x3fefa5e0} },
/**/                  {{0xeb56d5b9, 0xbc836583} },
/**/                  {{0x3b881779, 0xbfba68c1} },
/**/                  {{0x13a09314, 0xbc473a0d} },
/**/                  {{0x538e939c, 0xbfd3f2c3} },
/**/                  {{0xee53e648, 0xbc68ed49} },
/**/                  {{0xa7d45973, 0x3fb98b42} },
/**/                  {{0x461ca7c4, 0xbc523943} },
/**/                  {{0xb0f2e2bb, 0x3fc58b04} },
/**/                  {{0x1c9d23dc, 0xbfb85517} },
/**/                  {{0x3e3b5a66, 0xbfba1612} },
/**/                  {{0x7ef1d0b9, 0x3fb6cf6f} },
/**/                  {{0x6617b315, 0x3fafac21} } },
/**/                 {{{0x00000000, 0x3fbc0000} },
/**/                  {{0xbe6f07c3, 0x3fbbe39e} },
/**/                  {{0x29a05987, 0x3c5f7b8f} },
/**/                  {{0x93bb9192, 0x3fef9f28} },
/**/                  {{0x7cd1bdab, 0x3c78260b} },
/**/                  {{0x72759741, 0xbfbb5787} },
/**/                  {{0xa6767247, 0x3c52f93f} },
/**/                  {{0xd45bbe91, 0xbfd3d8cc} },
/**/                  {{0x2edc0762, 0x3c664839} },
/**/                  {{0x4fa31d26, 0x3fba6140} },
/**/                  {{0x97891510, 0x3c400647} },
/**/                  {{0x0668fd66, 0x3fc540f6} },
/**/                  {{0xcb2f6e8f, 0xbfb9092d} },
/**/                  {{0x8d902073, 0xbfb95d66} },
/**/                  {{0x99c53d16, 0x3fb75a3e} },
/**/                  {{0x8f475e61, 0x3fae040c} } },
/**/                 {{{0x00000000, 0x3fbd0000} },
/**/                  {{0x5c3cca32, 0x3fbce07c} },
/**/                  {{0x425918a7, 0x3c4138e6} },
/**/                  {{0xf9f6d421, 0x3fef9834} },
/**/                  {{0x8c22a239, 0x3c6f3089} },
/**/                  {{0x1d4e69a5, 0xbfbc4511} },
/**/                  {{0xd2083ce8, 0x3c254c0f} },
/**/                  {{0xcd488978, 0xbfd3be01} },
/**/                  {{0x6362ec0f, 0x3c5612db} },
/**/                  {{0xf0d94873, 0x3fbb344e} },
/**/                  {{0xfdf7db72, 0xbc182beb} },
/**/                  {{0xb9d86c04, 0x3fc4f4d2} },
/**/                  {{0xdf238807, 0xbfb9b828} },
/**/                  {{0x5f93ffd6, 0xbfb8a082} },
/**/                  {{0xb6650b0c, 0x3fb7dd89} },
/**/                  {{0xb62676ef, 0x3fac5526} } },
/**/                 {{{0x00000000, 0x3fbe0000} },
/**/                  {{0x701eba6e, 0x3fbddd21} },
/**/                  {{0xcd76fe58, 0x3c594eff} },
/**/                  {{0x266112ba, 0x3fef9106} },
/**/                  {{0x6b7e18b1, 0x3c74c302} },
/**/                  {{0x5777816c, 0xbfbd3154} },
/**/                  {{0x1f9dbddd, 0x3c5dc7e4} },
/**/                  {{0x37a90881, 0xbfd3a265} },
/**/                  {{0xeb7ba840, 0xbc75bd61} },
/**/                  {{0x0a52514b, 0x3fbc045a} },
/**/                  {{0xcff49a99, 0xbc35ca88} },
/**/                  {{0x498eeb56, 0x3fc4a6aa} },
/**/                  {{0xa09232cf, 0xbfba61eb} },
/**/                  {{0x4a464027, 0xbfb7dfa2} },
/**/                  {{0xe633c053, 0x3fb85933} },
/**/                  {{0x3f920107, 0x3faaa036} } },
/**/                 {{{0x00000000, 0x3fbf0000} },
/**/                  {{0x2190043b, 0x3fbed98c} },
/**/                  {{0x592c7b13, 0xbc23a598} },
/**/                  {{0x6bcf4ad8, 0x3fef899c} },
/**/                  {{0x912c09b0, 0x3c55fd73} },
/**/                  {{0x607f91a0, 0xbfbe1c47} },
/**/                  {{0x5b5db022, 0x3c576677} },
/**/                  {{0x21046f5f, 0xbfd385fa} },
/**/                  {{0x4487f4b8, 0x3c7f01c3} },
/**/                  {{0xb77f2d51, 0x3fbcd14d} },
/**/                  {{0x30a2ccfe, 0x3c57a86d} },
/**/                  {{0x8782b530, 0x3fc4568c} },
/**/                  {{0x02b7ad2d, 0xbfbb065b} },
/**/                  {{0xbd215555, 0xbfb71b03} },
/**/                  {{0xb9c1c1de, 0x3fb8cd23} },
/**/                  {{0x8dbfa69b, 0x3fa8e602} } },
/**/                 {{{0x00000000, 0x3fc00000} },
/**/                  {{0x9aac2f6e, 0x3fbfd5ba} },
/**/                  {{0x86760c17, 0xbc4cd376} },
/**/                  {{0x1f81f820, 0x3fef81f8} },
/**/                  {{0x1f81f820, 0xbc8f81f8} },
/**/                  {{0x9d0dc11b, 0xbfbf05e0} },
/**/                  {{0x1d821725, 0xbc35a199} },
/**/                  {{0xaa76e1d7, 0xbfd368c3} },
/**/                  {{0xc796f8cd, 0xbc672d4c} },
/**/                  {{0xb391c2e3, 0x3fbd9b16} },
/**/                  {{0x8086c51d, 0x3c58051b} },
/**/                  {{0x94488c86, 0x3fc40489} },
/**/                  {{0xa98401c8, 0xbfbba55d} },
/**/                  {{0xe5127e64, 0xbfb652e4} },
/**/                  {{0x442e53ae, 0x3fb93943} },
/**/                  {{0x86286f75, 0x3fa72753} } },
/**/                 {{{0x00000000, 0x3fc08000} },
/**/                  {{0x84212b3e, 0x3fc068d5} },
/**/                  {{0x83019bfd, 0xbc69e2d2} },
/**/                  {{0x991bb133, 0x3fef7a19} },
/**/                  {{0x66627723, 0x3c7a956a} },
/**/                  {{0x97c8e137, 0xbfbfee16} },
/**/                  {{0x66dbe7af, 0x3c4d9399} },
/**/                  {{0x0810323a, 0xbfd34ac5} },
/**/                  {{0x6bc6c512, 0x3c6a1a57} },
/**/                  {{0x5c75a6f9, 0x3fbe61a2} },
/**/                  {{0xd75c8f85, 0xbc492b99} },
/**/                  {{0xd9fa3f20, 0x3fc3b0b1} },
/**/                  {{0xee66d309, 0xbfbc3edb} },
/**/                  {{0x905eeb33, 0xbfb58784} },
/**/                  {{0x1c65bb14, 0x3fb99d80} },
/**/                  {{0x18a09884, 0x3fa564f1} } },
/**/                 {{{0x00000000, 0x3fc10000} },
/**/                  {{0xccf40882, 0x3fc0e6ad} },
/**/                  {{0x1bb98d0d, 0xbc6d71a3} },
/**/                  {{0x32978bad, 0x3fef7201} },
/**/                  {{0x599381e9, 0x3c816476} },
/**/                  {{0x011b81fd, 0xbfc06a70} },
/**/                  {{0x9ba697ca, 0xbc422f5d} },
/**/                  {{0x802fc0a5, 0xbfd32c01} },
/**/                  {{0x08a20868, 0x3c7d8e47} },
/**/                  {{0xb59597fe, 0x3fbf24de} },
/**/                  {{0x410d31eb, 0xbc43288f} },
/**/                  {{0x070feb24, 0x3fc35b16} },
/**/                  {{0xe4565b78, 0xbfbcd2bf} },
/**/                  {{0x128768c6, 0xbfb4b922} },
/**/                  {{0x5c42a097, 0x3fb9f9cb} },
/**/                  {{0xc7f97f2e, 0x3fa39fa2} } },
/**/                 {{{0x00000000, 0x3fc18000} },
/**/                  {{0x41060850, 0x3fc16465} },
/**/                  {{0x8ae7ea92, 0x3c66bcee} },
/**/                  {{0x483f492b, 0x3fef69af} },
/**/                  {{0x57db963e, 0xbc6e3280} },
/**/                  {{0xdacaa844, 0xbfc0dd19} },
/**/                  {{0xad7fc21e, 0xbc6133c7} },
/**/                  {{0x6addaea8, 0xbfd30c7c} },
/**/                  {{0x89161c76, 0xbc71443d} },
/**/                  {{0x6a6d3cd2, 0x3fbfe4ba} },
/**/                  {{0x423ee67a, 0x3c50d4b8} },
/**/                  {{0x092e569a, 0x3fc303c7} },
/**/                  {{0x5b11d3b6, 0xbfbd60f5} },
/**/                  {{0x283b5c55, 0xbfb3e7fd} },
/**/                  {{0x9d9a6ab7, 0x3fba4e19} },
/**/                  {{0x3487cc29, 0x3fa1d82f} } },
/**/                 {{{0x00000000, 0x3fc20000} },
/**/                  {{0xfb043727, 0x3fc1e1fa} },
/**/                  {{0x14dacf8c, 0xbc4b4859} },
/**/                  {{0x38a14f5e, 0x3fef6124} },
/**/                  {{0x001f6124, 0x3c798e9e} },
/**/                  {{0x59d3fb7c, 0xbfc14f04} },
/**/                  {{0x4cc99cb2, 0x3c531efa} },
/**/                  {{0x31219b34, 0xbfd2ec39} },
/**/                  {{0x6e004611, 0xbc618697} },
/**/                  {{0x68736312, 0x3fc05092} },
/**/                  {{0x8a06e4b5, 0x3c67aad4} },
/**/                  {{0x07eca5ec, 0x3fc2aad6} },
/**/                  {{0xe19fe31c, 0xbfbde969} },
/**/                  {{0xdb6b9127, 0xbfb31455} },
/**/                  {{0xf53dd9ee, 0x3fba9a62} },
/**/                  {{0xa8e4ede0, 0x3fa00f5b} } },
/**/                 {{{0x00000000, 0x3fc28000} },
/**/                  {{0x171a535c, 0x3fc25f6e} },
/**/                  {{0xbde1a310, 0x3c67c6d7} },
/**/                  {{0x64866d22, 0x3fef5860} },
/**/                  {{0xd1f6326c, 0x3c88c6ff} },
/**/                  {{0x13c11396, 0xbfc1c02b} },
/**/                  {{0xffeb1a0f, 0xbc51b469} },
/**/                  {{0x4c571b0f, 0xbfd2cb3b} },
/**/                  {{0x2fb0b163, 0x3c6e4f76} },
/**/                  {{0xf5c213ab, 0x3fc0ad06} },
/**/                  {{0xabea9e66, 0x3c625bf2} },
/**/                  {{0x5f93bbb2, 0x3fc25054} },
/**/                  {{0xc80a32c8, 0xbfbe6c0c} },
/**/                  {{0x678d0d1e, 0xbfb23e6c} },
/**/                  {{0xebf8ae4b, 0x3fbadea2} },
/**/                  {{0x527f133b, 0x3f9c8bd7} } },
/**/                 {{{0x00000000, 0x3fc30000} },
/**/                  {{0xb2fba1ff, 0x3fc2dcbd} },
/**/                  {{0x05561534, 0x3c58f287} },
/**/                  {{0x2ee76e94, 0x3fef4f64} },
/**/                  {{0xc6da5865, 0x3c80ec89} },
/**/                  {{0xb322f867, 0xbfc23089} },
/**/                  {{0x5fcd0d6f, 0x3c4c2b54} },
/**/                  {{0x45802261, 0xbfd2a986} },
/**/                  {{0x5ae78b8a, 0xbc79a132} },
/**/                  {{0x35a9d974, 0x3fc107b3} },
/**/                  {{0xb725e335, 0x3c5ef22d} },
/**/                  {{0x9bd98832, 0x3fc1f453} },
/**/                  {{0x2057aad4, 0xbfbee8cf} },
/**/                  {{0x1e1bc3a1, 0xbfb16681} },
/**/                  {{0x759c8f58, 0x3fbb1ad8} },
/**/                  {{0x0b15b4aa, 0x3f98f941} } },
/**/                 {{{0x00000000, 0x3fc38000} },
/**/                  {{0xedeb99a4, 0x3fc359e8} },
/**/                  {{0x4e4604c6, 0xbc6a5fd7} },
/**/                  {{0xfce28238, 0x3fef462f} },
/**/                  {{0xd90595d1, 0x3c83dc01} },
/**/                  {{0xf7edfa6d, 0xbfc2a01b} },
/**/                  {{0x4a3b5c9a, 0xbc6b11fb} },
/**/                  {{0xb4959402, 0xbfd2871d} },
/**/                  {{0x2fcf7ea3, 0xbc4a3702} },
/**/                  {{0xd8d7fe8c, 0x3fc1608f} },
/**/                  {{0xf8f1d41c, 0x3c61ac60} },
/**/                  {{0x729a89ca, 0x3fc196e5} },
/**/                  {{0xbec74f31, 0xbfbf5fa3} },
/**/                  {{0x4b6c9767, 0xbfb08cd4} },
/**/                  {{0xe624ce15, 0x3fbb4f05} },
/**/                  {{0xddb2020c, 0x3f956871} } },
/**/                 {{{0x00000000, 0x3fc40000} },
/**/                  {{0xe8c6626c, 0x3fc3d6ee} },
/**/                  {{0x0ce9281b, 0x3c661a3b} },
/**/                  {{0x35b0713c, 0x3fef3cc4} },
/**/                  {{0xe69ea094, 0x3c81d0a7} },
/**/                  {{0xb7d169f0, 0xbfc30edd} },
/**/                  {{0xae999b97, 0x3c6b3394} },
/**/                  {{0x3fd62b3c, 0xbfd26405} },
/**/                  {{0xc0736df9, 0x3c73e339} },
/**/                  {{0xe8e57ee3, 0x3fc1b795} },
/**/                  {{0x0a42c7f6, 0xbc6130dc} },
/**/                  {{0xbe93b8e5, 0x3fc1381b} },
/**/                  {{0x394e1bf7, 0xbfbfd07f} },
/**/                  {{0x37bb5315, 0xbfaf634c} },
/**/                  {{0xe501e57b, 0x3fbb7b30} },
/**/                  {{0x20503792, 0x3f91dae1} } },
/**/                 {{{0x00000000, 0x3fc48000} },
/**/                  {{0xc6092a9e, 0x3fc453ce} },
/**/                  {{0xb3a5a78b, 0x3c61f653} },
/**/                  {{0x4299ace8, 0x3fef3321} },
/**/                  {{0x3a742b30, 0xbc87414c} },
/**/                  {{0xde8b2323, 0xbfc37cca} },
/**/                  {{0x7b50aedf, 0x3c649378} },
/**/                  {{0x9b13f4d0, 0xbfd24040} },
/**/                  {{0xb7dc85c0, 0x3c7e271f} },
/**/                  {{0xc9024068, 0x3fc20cbe} },
/**/                  {{0x88ef3da7, 0x3c50921f} },
/**/                  {{0x7a1f1270, 0x3fc0d808} },
/**/                  {{0xf32d5436, 0xbfc01dab} },
/**/                  {{0x02e6f09c, 0xbfadaa6d} },
/**/                  {{0x5e9cd766, 0x3fbb9f62} },
/**/                  {{0xab964c04, 0x3f8ca3fe} } },
/**/                 {{{0x00000000, 0x3fc50000} },
/**/                  {{0xa9da4f17, 0x3fc4d087} },
/**/                  {{0xf1adf158, 0x3c61f323} },
/**/                  {{0x8eeb3352, 0x3fef2947} },
/**/                  {{0x8799a164, 0x3c871eb0} },
/**/                  {{0x6e36e75c, 0xbfc3e9df} },
/**/                  {{0x4e37666f, 0x3c541555} },
/**/                  {{0x87008bd0, 0xbfd21bd3} },
/**/                  {{0xc24ff75f, 0xbc609e14} },
/**/                  {{0x36860504, 0x3fc26004} },
/**/                  {{0x1ebc8c40, 0xbc58f8ca} },
/**/                  {{0xb9f4ead3, 0x3fc076bd} },
/**/                  {{0xed70ddd5, 0xbfc05012} },
/**/                  {{0x33e194b1, 0xbfabef8a} },
/**/                  {{0x7423a91f, 0x3fbbbba6} },
/**/                  {{0xdd99da12, 0x3f859e6a} } },
/**/                 {{{0x00000000, 0x3fc58000} },
/**/                  {{0xba11570a, 0x3fc54d18} },
/**/                  {{0xf2884073, 0x3c618282} },
/**/                  {{0x87eb4d7d, 0x3fef1f37} },
/**/                  {{0xedda13e6, 0x3c8476f0} },
/**/                  {{0x7f997c7c, 0xbfc45617} },
/**/                  {{0x6423ceda, 0xbc46bf5b} },
/**/                  {{0xd0784ec7, 0xbfd1f6c1} },
/**/                  {{0xd106a8e0, 0xbc74ec12} },
/**/                  {{0x4967338d, 0x3fc2b160} },
/**/                  {{0x61339c25, 0x3c5309c0} },
/**/                  {{0xa7f42962, 0x3fc0144d} },
/**/                  {{0x73dbaeec, 0xbfc07f71} },
/**/                  {{0x2aeda9a4, 0xbfaa3322} },
/**/                  {{0x69b152b3, 0x3fbbd00c} },
/**/                  {{0x4c782821, 0x3f7d4f90} } },
/**/                 {{{0x00000000, 0x3fc60000} },
/**/                  {{0x1e3ec26a, 0x3fc5c981} },
/**/                  {{0x2c010f3d, 0xbc5054ab} },
/**/                  {{0x9cce28eb, 0x3fef14f1} },
/**/                  {{0x2708cd6e, 0xbc8b7c25} },
/**/                  {{0x42678d07, 0xbfc4c16f} },
/**/                  {{0xc1560017, 0x3c5f55ba} },
/**/                  {{0x4fccc153, 0xbfd1d10f} },
/**/                  {{0x1bcc361d, 0x3c529588} },
/**/                  {{0x74979f8c, 0x3fc300cd} },
/**/                  {{0x0bc1e891, 0xbc6b1da5} },
/**/                  {{0xfbe70208, 0x3fbf6194} },
/**/                  {{0x4b1c266f, 0xbfc0abc5} },
/**/                  {{0x3b74e858, 0xbfa875b2} },
/**/                  {{0x92e46f11, 0x3fbbdca6} },
/**/                  {{0x9de94aef, 0x3f6f0b17} } },
/**/                 {{{0x00000000, 0x3fc68000} },
/**/                  {{0xffb3aa74, 0x3fc645bf} },
/**/                  {{0x677c2cb4, 0xbc3f536b} },
/**/                  {{0x3eaa4ed6, 0x3fef0a76} },
/**/                  {{0x0b06c761, 0x3c888c52} },
/**/                  {{0xfd884489, 0xbfc52be2} },
/**/                  {{0xbe5c728a, 0x3c67ec59} },
/**/                  {{0xe80e4e0a, 0xbfd1aabf} },
/**/                  {{0xe90c909e, 0xbc71320e} },
/**/                  {{0x864781ca, 0x3fc34e46} },
/**/                  {{0x126138ee, 0x3c42fcb3} },
/**/                  {{0x013b5d4f, 0x3fbe988d} },
/**/                  {{0x122409a2, 0xbfc0d50d} },
/**/                  {{0x7bb562c1, 0xbfa6b7b6} },
/**/                  {{0x3df8dee8, 0x3fbbe18a} },
/**/                  {{0x8809e1ef, 0x3f3e4009} } },
/**/                 {{{0x00000000, 0x3fc70000} },
/**/                  {{0x898933d9, 0x3fc6c1d4} },
/**/                  {{0x7603c427, 0xbc52954a} },
/**/                  {{0xe06cfb34, 0x3feeffc5} },
/**/                  {{0x379877c2, 0xbc85c037} },
/**/                  {{0x0f53a52c, 0xbfc5956f} },
/**/                  {{0xe566376c, 0x3c4d46a2} },
/**/                  {{0x86559c11, 0xbfd183d7} },
/**/                  {{0x64734c7f, 0x3c7d2520} },
/**/                  {{0xa80eddd5, 0x3fc399c6} },
/**/                  {{0x40fbef6f, 0x3c616c26} },
/**/                  {{0xf4b571a7, 0x3fbdcda7} },
/**/                  {{0x3fd42996, 0xbfc0fb48} },
/**/                  {{0x95c85118, 0xbfa4f9a9} },
/**/                  {{0x9d795df4, 0x3fbbdecf} },
/**/                  {{0xb85bf719, 0xbf672003} } },
/**/                 {{{0x00000000, 0x3fc78000} },
/**/                  {{0xe8a7d202, 0x3fc73dbd} },
/**/                  {{0x6d4a665d, 0xbc55ad0f} },
/**/                  {{0xf6ce5590, 0x3feef4e0} },
/**/                  {{0x556900ef, 0xbc833df6} },
/**/                  {{0xedcc9488, 0xbfc5fe0f} },
/**/                  {{0xd2b9e35c, 0x3c5078de} },
/**/                  {{0x210cab36, 0xbfd15c5a} },
/**/                  {{0xf55e532a, 0x3c67fa93} },
/**/                  {{0x5efd9a41, 0x3fc3e349} },
/**/                  {{0xc8573a12, 0xbc6cf709} },
/**/                  {{0x6c903aef, 0x3fbd010a} },
/**/                  {{0x20571328, 0xbfc11e77} },
/**/                  {{0x9a1875dd, 0xbfa33c04} },
/**/                  {{0xb09ec0ce, 0x3fbbd491} },
/**/                  {{0x35537a65, 0xbf78d197} } },
/**/                 {{{0x00000000, 0x3fc80000} },
/**/                  {{0x4bce5b02, 0x3fc7b97b} },
/**/                  {{0xb4f881ca, 0x3c5347b0} },
/**/                  {{0xf8458e02, 0x3feee9c7} },
/**/                  {{0x7ba71fe1, 0xbc616380} },
/**/                  {{0x26d69eeb, 0xbfc665c2} },
/**/                  {{0xfdb5eea8, 0xbc572a33} },
/**/                  {{0xb737e8f3, 0xbfd1344b} },
/**/                  {{0x62badf41, 0xbc757b70} },
/**/                  {{0x8b929b0b, 0x3fc42aca} },
/**/                  {{0x7a8b7d91, 0x3c43cdb5} },
/**/                  {{0xf683981c, 0x3fbc32d8} },
/**/                  {{0xd22d5ecc, 0xbfc13e9a} },
/**/                  {{0xd35c8c33, 0xbfa17f3e} },
/**/                  {{0x2a73307e, 0x3fbbc2ee} },
/**/                  {{0x2bddc834, 0xbf82ee04} } },
/**/                 {{{0x00000000, 0x3fc88000} },
/**/                  {{0xe398ebc8, 0x3fc8350b} },
/**/                  {{0x32b9c90d, 0xbc55a913} },
/**/                  {{0x5cfce04c, 0x3feede7b} },
/**/                  {{0x3b51a72f, 0x3c8507c2} },
/**/                  {{0x6067718b, 0xbfc6cc82} },
/**/                  {{0xdbfc430f, 0x3c6d00ca} },
/**/                  {{0x4fbf6fe8, 0xbfd10bb0} },
/**/                  {{0x53749c72, 0x3c321748} },
/**/                  {{0x699a36ad, 0x3fc47046} },
/**/                  {{0x3994d40c, 0xbc63924c} },
/**/                  {{0x0dfb7483, 0x3fbb6338} },
/**/                  {{0x42ee5820, 0xbfc15bb5} },
/**/                  {{0x385194fc, 0xbf9f879b} },
/**/                  {{0x57d040e9, 0x3fbbaa05} },
/**/                  {{0xada71ca0, 0xbf895566} } },
/**/                 {{{0x00000000, 0x3fc90000} },
/**/                  {{0xe2879c29, 0x3fc8b06e} },
/**/                  {{0x30308c4f, 0xbc6118cd} },
/**/                  {{0x9ec57f51, 0x3feed2fb} },
/**/                  {{0xc0d106ba, 0xbc83fdc5} },
/**/                  {{0x58b40d27, 0xbfc7324d} },
/**/                  {{0xfc062163, 0x3c68e240} },
/**/                  {{0xf8b8a2bf, 0xbfd0e28b} },
/**/                  {{0x64c55b39, 0xbc7b8d8a} },
/**/                  {{0x8ff46730, 0x3fc4b3b9} },
/**/                  {{0x988563da, 0xbc5af146} },
/**/                  {{0x1277a10d, 0x3fba924c} },
/**/                  {{0x2bbfd54d, 0xbfc175c9} },
/**/                  {{0x6c522340, 0xbf9c1448} },
/**/                  {{0x044f2f6b, 0x3fbb89fa} },
/**/                  {{0xaaecc742, 0xbf8f9cc7} } },
/**/                 {{{0x00000000, 0x3fc98000} },
/**/                  {{0x7d050272, 0x3fc92ba3} },
/**/                  {{0xd0ff4764, 0xbc60d3de} },
/**/                  {{0x390b6afe, 0x3feec749} },
/**/                  {{0x4e3659ca, 0xbc5c3d17} },
/**/                  {{0xe659b3de, 0xbfc7971f} },
/**/                  {{0x373f554d, 0x3c4cab11} },
/**/                  {{0xc6b052a4, 0xbfd0b8e2} },
/**/                  {{0x6f3b74bc, 0x3c7da014} },
/**/                  {{0xf0432146, 0x3fc4f520} },
/**/                  {{0xa8027290, 0xbc6769ad} },
/**/                  {{0x3e17b570, 0x3fb9c039} },
/**/                  {{0x0d8833a4, 0xbfc18cda} },
/**/                  {{0x4627d340, 0xbf98a567} },
/**/                  {{0x5e42eff7, 0x3fbb62f1} },
/**/                  {{0x7ee3bed3, 0xbf92e10a} } },
/**/                 {{{0x00000000, 0x3fca0000} },
/**/                  {{0xe96c8626, 0x3fc9a6a8} },
/**/                  {{0xe7b4348e, 0x3c4cf601} },
/**/                  {{0xa8c932d7, 0x3feebb64} },
/**/                  {{0x79aae302, 0x3c20538d} },
/**/                  {{0xf88295fe, 0xbfc7faf6} },
/**/                  {{0x932909e9, 0xbc687a81} },
/**/                  {{0xd3f5a07b, 0xbfd08eb8} },
/**/                  {{0xfb7d6aaa, 0xbc620a05} },
/**/                  {{0xd6814372, 0x3fc53479} },
/**/                  {{0x0a0c6620, 0xbc53c682} },
/**/                  {{0x9c562d77, 0x3fb8ed23} },
/**/                  {{0x2cdd89fd, 0xbfc1a0ec} },
/**/                  {{0xfec9df82, 0xbf953bd4} },
/**/                  {{0xd9d3f0f6, 0x3fbb3512} },
/**/                  {{0x4534ccf5, 0xbf95e1ab} } },
/**/                 {{{0x00000000, 0x3fca8000} },
/**/                  {{0x601081a6, 0x3fca217e} },
/**/                  {{0xa60af374, 0xbc60def8} },
/**/                  {{0x6c7ba732, 0x3feeaf4e} },
/**/                  {{0xe91fffe1, 0x3c89fa72} },
/**/                  {{0x970642c3, 0xbfc85dcf} },
/**/                  {{0x5b7f0ad0, 0xbc5732c2} },
/**/                  {{0x3fe5c74d, 0xbfd06412} },
/**/                  {{0x4a82f9b1, 0xbc7d0053} },
/**/                  {{0xe882973d, 0x3fc571c1} },
/**/                  {{0x9090f12c, 0x3c59d9a3} },
/**/                  {{0x00f5d0e0, 0x3fb8192f} },
/**/                  {{0x8db53983, 0xbfc1b204} },
/**/                  {{0xbdd7b47e, 0xbf91d869} },
/**/                  {{0x1355a903, 0x3fbb0088} },
/**/                  {{0x724a2ad9, 0xbf98cf57} } },
/**/                 {{{0x00000000, 0x3fcb0000} },
/**/                  {{0x1b403279, 0x3fca9c23} },
/**/                  {{0xe89cca85, 0x3c60e8bb} },
/**/                  {{0x04157b4f, 0x3feea307} },
/**/                  {{0xfd8bf1f0, 0x3c8ad743} },
/**/                  {{0xe285e2fd, 0xbfc8bfa6} },
/**/                  {{0x9c834c8f, 0xbc6ce765} },
/**/                  {{0x2e38fd26, 0xbfd038f3} },
/**/                  {{0xef212a80, 0x3c6a42ec} },
/**/                  {{0x255d65d5, 0x3fc5acf7} },
/**/                  {{0xbe486771, 0xbc619fba} },
/**/                  {{0xff244e15, 0x3fb7447e} },
/**/                  {{0xeed71b69, 0xbfc1c028} },
/**/                  {{0xaceecf68, 0xbf8cf7f0} },
/**/                  {{0xb0ee161b, 0x3fbac57c} },
/**/                  {{0xefc8f53e, 0xbf9ba92d} } },
/**/                 {{{0x00000000, 0x3fcb8000} },
/**/                  {{0x574d780c, 0x3fcb1696} },
/**/                  {{0xfc15a673, 0xbc585ab8} },
/**/                  {{0xf0f2da5a, 0x3fee968e} },
/**/                  {{0x69710f0d, 0xbc6fffe1} },
/**/                  {{0x148444b5, 0xbfc9207a} },
/**/                  {{0x1802fa91, 0xbc66661a} },
/**/                  {{0xc65096ca, 0xbfd00d5f} },
/**/                  {{0x8920e744, 0x3c7f2a2e} },
/**/                  {{0xe4be288d, 0x3fc5e617} },
/**/                  {{0x99be934f, 0x3c67fa48} },
/**/                  {{0xe0d4c87a, 0x3fb66f36} },
/**/                  {{0xc5179ce8, 0xbfc1cb5f} },
/**/                  {{0x1011bb6c, 0xbf864e9c} },
/**/                  {{0x43a75476, 0x3fba841e} },
/**/                  {{0x845fc859, 0xbf9e6e5b} } },
/**/                 {{{0x00000000, 0x3fcc0000} },
/**/                  {{0x529260a2, 0x3fcb90d7} },
/**/                  {{0xd2e0e5ab, 0x3c217b10} },
/**/                  {{0xb5ccf172, 0x3fee89e6} },
/**/                  {{0x153be26a, 0x3c820357} },
/**/                  {{0x7f79bfd6, 0xbfc98046} },
/**/                  {{0xf5d60955, 0xbc0799ee} },
/**/                  {{0x650d32f4, 0xbfcfc2b8} },
/**/                  {{0x4d01b49e, 0xbc6b59de} },
/**/                  {{0xd625e475, 0x3fc61d22} },
/**/                  {{0xe23c6105, 0xbc68013f} },
/**/                  {{0x9e54f300, 0x3fb59979} },
/**/                  {{0x365c2b85, 0xbfc1d3b0} },
/**/                  {{0x0afb6b97, 0xbf7f6cc9} },
/**/                  {{0x28035c12, 0x3fba3c9c} },
/**/                  {{0x8331488a, 0xbfa08f0d} } },
/**/                 {{{0x00000000, 0x3fcc8000} },
/**/                  {{0x4d768467, 0x3fcc0ae5} },
/**/                  {{0xf55f26dc, 0xbc604cdb} },
/**/                  {{0xd6ad70cb, 0x3fee7d0e} },
/**/                  {{0xee20d17d, 0x3c8e6761} },
/**/                  {{0x8ee3fcf8, 0xbfc9df09} },
/**/                  {{0xed723e81, 0x3c62daa3} },
/**/                  {{0x3efdc9b4, 0xbfcf69d9} },
/**/                  {{0x85a20110, 0x3c6c7b6f} },
/**/                  {{0x0013c661, 0x3fc65217} },
/**/                  {{0xab1387be, 0xbc678a0c} },
/**/                  {{0xd61f268e, 0x3fb4c369} },
/**/                  {{0x146d6110, 0xbfc1d922} },
/**/                  {{0xc0b0ed0a, 0xbf726199} },
/**/                  {{0x6629c856, 0x3fb9ef27} },
/**/                  {{0xc1ea955d, 0xbfa1dbda} } },
/**/                 {{{0x00000000, 0x3fcd0000} },
/**/                  {{0x8a742e6e, 0x3fcc84bf} },
/**/                  {{0x0682ea26, 0xbc595bdd} },
/**/                  {{0xd8e205ea, 0x3fee7007} },
/**/                  {{0x7b2991c1, 0x3c816199} },
/**/                  {{0xc751a854, 0xbfca3cc0} },
/**/                  {{0x4efbc78c, 0xbc66a2fd} },
/**/                  {{0x76f43baa, 0xbfcf102a} },
/**/                  {{0x38d996b1, 0x3c6cfc38} },
/**/                  {{0xbf1a9ad6, 0x3fc684f3} },
/**/                  {{0x7c3b6690, 0x3c52eaf7} },
/**/                  {{0xc4ebba84, 0x3fb3ed29} },
/**/                  {{0xd79a6a53, 0xbfc1dbbd} },
/**/                  {{0xfd09510e, 0xbf55fa5b} },
/**/                  {{0x91c74d50, 0x3fb99bf2} },
/**/                  {{0x3002c38b, 0xbfa31d41} } },
/**/                 {{{0x00000000, 0x3fcd8000} },
/**/                  {{0x4e1d5395, 0x3fccfe65} },
/**/                  {{0x3f71eafb, 0x3c647b9a} },
/**/                  {{0x42efd10e, 0x3fee62d2} },
/**/                  {{0xa021973e, 0x3c850a65} },
/**/                  {{0xc66a1be4, 0xbfca9969} },
/**/                  {{0x3753f036, 0x3c326164} },
/**/                  {{0x6b550477, 0xbfceb5b4} },
/**/                  {{0xa3ef610f, 0xbc64cacb} },
/**/                  {{0xc4e2c295, 0x3fc6b5b8} },
/**/                  {{0x98b2ac7f, 0x3c66b228} },
/**/                  {{0x3e03bb80, 0x3fb316db} },
/**/                  {{0x99312ba1, 0xbfc1db8c} },
/**/                  {{0x8536556f, 0x3f5ce5b0} },
/**/                  {{0xa9b62abf, 0x3fb94331} },
/**/                  {{0xb36f42fc, 0xbfa452f3} } },
/**/                 {{{0x00000000, 0x3fce0000} },
/**/                  {{0xdf205736, 0x3fcd77d5} },
/**/                  {{0x1534597e, 0x3c6c648d} },
/**/                  {{0x9c86d7c6, 0x3fee556e} },
/**/                  {{0x34c9abfd, 0xbc830c25} },
/**/                  {{0x42f10c89, 0xbfcaf502} },
/**/                  {{0xf8576d95, 0xbc411261} },
/**/                  {{0x7b1596d9, 0xbfce5a7f} },
/**/                  {{0x78f7ae18, 0x3c574baa} },
/**/                  {{0x171949b1, 0x3fc6e466} },
/**/                  {{0x52f9c399, 0xbc6ff86b} },
/**/                  {{0xa3d6f244, 0x3fb2409f} },
/**/                  {{0x0dceacbf, 0xbfc1d898} },
/**/                  {{0xdc715080, 0x3f73c3b6} },
/**/                  {{0xf78687ab, 0x3fb8e519} },
/**/                  {{0x6b1251ec, 0xbfa57cac} } },
/**/                 {{{0x00000000, 0x3fce8000} },
/**/                  {{0x864c9d9e, 0x3fcdf110} },
/**/                  {{0x53bf4781, 0xbc35818b} },
/**/                  {{0x6e7576a6, 0x3fee47dd} },
/**/                  {{0x24b84595, 0x3c89d322} },
/**/                  {{0x0cc64717, 0xbfcb4f88} },
/**/                  {{0x44bb97a3, 0xbc624035} },
/**/                  {{0x046e8a3b, 0xbfcdfe94} },
/**/                  {{0xd278da00, 0xbc6078ee} },
/**/                  {{0x0e4ccbb7, 0x3fc710fc} },
/**/                  {{0x1da51f71, 0xbc58c89c} },
/**/                  {{0xe0d7022a, 0x3fb16a97} },
/**/                  {{0x7f8b58f8, 0xbfc1d2ea} },
/**/                  {{0xaf259d18, 0x3f800ed5} },
/**/                  {{0xeefd29c7, 0x3fb881e1} },
/**/                  {{0xae6aa0c1, 0xbfa69a2c} } },
/**/                 {{{0x00000000, 0x3fcf0000} },
/**/                  {{0x8e96ec4d, 0x3fce6a14} },
/**/                  {{0x2029f765, 0x3c6866b2} },
/**/                  {{0x429bd423, 0x3fee3a1f} },
/**/                  {{0x48961291, 0xbc86174a} },
/**/                  {{0x0ce18ad9, 0xbfcba8f9} },
/**/                  {{0xb50eb15d, 0x3c62e3e9} },
/**/                  {{0x63927806, 0xbfcda1fa} },
/**/                  {{0x8073bacf, 0xbbed7b15} },
/**/                  {{0x54b8d3bb, 0x3fc73b7b} },
/**/                  {{0x74869c1c, 0x3c602afb} },
/**/                  {{0x60993bd6, 0x3fb094e4} },
/**/                  {{0xc806a157, 0xbfc1ca8e} },
/**/                  {{0xa854d278, 0x3f862263} },
/**/                  {{0x0d9e7452, 0x3fb819c1} },
/**/                  {{0x08743869, 0xbfa7ab3d} } },
/**/                 {{{0x00000000, 0x3fcf8000} },
/**/                  {{0x451d980d, 0x3fcee2e1} },
/**/                  {{0x8c46ba91, 0xbc59a770} },
/**/                  {{0xa3df5666, 0x3fee2c34} },
/**/                  {{0x19a92865, 0xbc8ef949} },
/**/                  {{0x454a9009, 0xbfcc0153} },
/**/                  {{0xda1123ca, 0x3c5572bf} },
/**/                  {{0xf169cd42, 0xbfcd44ba} },
/**/                  {{0xf1052e0a, 0xbc6db0f2} },
/**/                  {{0xe5006ad1, 0x3fc763e4} },
/**/                  {{0x3e902796, 0x3c66e21a} },
/**/                  {{0x12812c7d, 0x3faf7f4a} },
/**/                  {{0x4a558d9d, 0xbfc1bf90} },
/**/                  {{0x2be7fbfd, 0x3f8c1b52} },
/**/                  {{0xba5b0263, 0x3fb7acef} },
/**/                  {{0x2dddf4e5, 0xbfa8afad} } },
/**/                 {{{0x00000000, 0x3fd00000} },
/**/                  {{0xf92c80dd, 0x3fcf5b75} },
/**/                  {{0x3cf7afbd, 0x3c68ab6e} },
/**/                  {{0x1e1e1e1e, 0x3fee1e1e} },
/**/                  {{0x1e1e1e1e, 0x3c6e1e1e} },
/**/                  {{0xd10d4986, 0xbfcc5894} },
/**/                  {{0xc4a6886a, 0x3c5f00e2} },
/**/                  {{0x0253d27e, 0xbfcce6de} },
/**/                  {{0x3c5fce89, 0xbc65d764} },
/**/                  {{0x08d88b02, 0x3fc78a3a} },
/**/                  {{0x32bd57e4, 0x3c4fc5d6} },
/**/                  {{0x6a622b44, 0x3fadd5f2} },
/**/                  {{0xecd7c4e0, 0xbfc1b1fa} },
/**/                  {{0x1fc8b549, 0x3f90fc3e} },
/**/                  {{0x25728acf, 0x3fb73ba7} },
/**/                  {{0xeeba051f, 0xbfa9a753} } },
/**/                 {{{0x00000000, 0x3fd04000} },
/**/                  {{0xfc40dbe4, 0x3fcfd3d1} },
/**/                  {{0xf3a1c5ea, 0x3c437146} },
/**/                  {{0x3e228818, 0x3fee0fdc} },
/**/                  {{0x8c042ef5, 0xbc62e075} },
/**/                  {{0xe42a71b9, 0xbfccaebb} },
/**/                  {{0x8025fd1d, 0xbc69fa0a} },
/**/                  {{0xe4ed28e5, 0xbfcc886b} },
/**/                  {{0x7604b95a, 0xbc59ccc3} },
/**/                  {{0x57a32fb9, 0x3fc7ae7c} },
/**/                  {{0xe36848c2, 0x3c67393b} },
/**/                  {{0x5a1b7b6f, 0x3fac2dff} },
/**/                  {{0x12f690d4, 0xbfc1a1db} },
/**/                  {{0xa575dc1d, 0x3f93dc65} },
/**/                  {{0x28a107f6, 0x3fb6c621} },
/**/                  {{0x23d2c35f, 0xbfaa920f} } },
/**/                 {{{0x00000000, 0x3fd08000} },
/**/                  {{0x510665b6, 0x3fd025fa} },
/**/                  {{0x6832fa48, 0xbc7672df} },
/**/                  {{0x9196b776, 0x3fee016f} },
/**/                  {{0xb14efc08, 0x3c81da3a} },
/**/                  {{0xcb847375, 0xbfcd03c6} },
/**/                  {{0xfc4c6f52, 0xbc6819f2} },
/**/                  {{0xe0dbf8a5, 0xbfcc296c} },
/**/                  {{0x27fb1c17, 0xbc55cc84} },
/**/                  {{0xb4fbbf40, 0x3fc7d0ad} },
/**/                  {{0x41b71641, 0x3c6378b3} },
/**/                  {{0x440404cd, 0x3faa87ad} },
/**/                  {{0x96d156a8, 0xbfc18f3d} },
/**/                  {{0x9ef40490, 0x3f96ad9b} },
/**/                  {{0x27a95e14, 0x3fb64c98} },
/**/                  {{0x97cfdce0, 0xbfab6fc3} } },
/**/                 {{{0x00000000, 0x3fd0c000} },
/**/                  {{0xa03d6291, 0x3fd061ee} },
/**/                  {{0xdb154301, 0xbc45f760} },
/**/                  {{0xa6f82a61, 0x3fedf2d8} },
/**/                  {{0x560866af, 0xbc6cedbb} },
/**/                  {{0xecc8c02c, 0xbfcd57b3} },
/**/                  {{0x85b9541c, 0x3c641512} },
/**/                  {{0x35a209c0, 0xbfcbc9e9} },
/**/                  {{0x4914a5d1, 0x3c65bfd8} },
/**/                  {{0x4f358b07, 0x3fc7f0d0} },
/**/                  {{0x3f47a5cc, 0xbc60dc70} },
/**/                  {{0x50af01c1, 0x3fa8e337} },
/**/                  {{0xc2daf61b, 0xbfc17a2f} },
/**/                  {{0x57b649f0, 0x3f996f63} },
/**/                  {{0xf14fef28, 0x3fb5cf46} },
/**/                  {{0xec5a22c2, 0xbfac405c} } },
/**/                 {{{0x00000000, 0x3fd10000} },
/**/                  {{0x97d86362, 0x3fd09dc5} },
/**/                  {{0x390cb865, 0x3c762e47} },
/**/                  {{0x0d8b5ae6, 0x3fede418} },
/**/                  {{0x23f66cf0, 0x3c719298} },
/**/                  {{0xc655a596, 0xbfcdaa81} },
/**/                  {{0x6a90480b, 0x3c666d0d} },
/**/                  {{0x1974fd6c, 0xbfcb69e9} },
/**/                  {{0xec28723f, 0xbc68e199} },
/**/                  {{0x9dcd2641, 0x3fc80ee6} },
/**/                  {{0x45b4bb82, 0x3c37ccfe} },
/**/                  {{0x64b143be, 0x3fa740d7} },
/**/                  {{0x4b6b7330, 0xbfc162bf} },
/**/                  {{0x7a20d203, 0x3f9c2147} },
/**/                  {{0xa0d6b625, 0x3fb54e68} },
/**/                  {{0x7b6e81ad, 0xbfad03cd} } },
/**/                 {{{0x00000000, 0x3fd14000} },
/**/                  {{0xe509acb3, 0x3fd0d97e} },
/**/                  {{0x7bd5a3eb, 0x3c747c31} },
/**/                  {{0x554f6dcf, 0x3fedd52e} },
/**/                  {{0xddcd060b, 0xbc75c686} },
/**/                  {{0xef1cb578, 0xbfcdfc2e} },
/**/                  {{0xd1677d50, 0xbc46ae20} },
/**/                  {{0xb81cdb34, 0xbfcb0974} },
/**/                  {{0xda61c86c, 0x3c36ed8e} },
/**/                  {{0x5fcd53c1, 0x3fc82af3} },
/**/                  {{0x57b559e7, 0xbc424fe5} },
/**/                  {{0x17013aef, 0x3fa5a0c6} },
/**/                  {{0x484940dd, 0xbfc148fa} },
/**/                  {{0x1737ca6d, 0x3f9ec2da} },
/**/                  {{0x800ba495, 0x3fb4ca38} },
/**/                  {{0x35128042, 0xbfadba0e} } },
/**/                 {{{0x00000000, 0x3fd18000} },
/**/                  {{0x362431ca, 0x3fd1151a} },
/**/                  {{0xc9077b9f, 0xbc74dc8d} },
/**/                  {{0x0ef1f116, 0x3fedc61c} },
/**/                  {{0x2d41c166, 0xbc8fe39f} },
/**/                  {{0x1681d2c9, 0xbfce4cba} },
/**/                  {{0x369a3c18, 0x3c340fb4} },
/**/                  {{0x31d921e2, 0xbfcaa894} },
/**/                  {{0x64c48da4, 0x3c6bf59e} },
/**/                  {{0x9a284cea, 0x3fc844f9} },
/**/                  {{0x629cfeb8, 0xbc563be0} },
/**/                  {{0xa7f26285, 0x3fa4033a} },
/**/                  {{0x2e2d72ea, 0xbfc12cef} },
/**/                  {{0x554d151d, 0x3fa0a9da} },
/**/                  {{0xe9f9174f, 0x3fb442f1} },
/**/                  {{0x799e467c, 0xbfae631e} } },
/**/                 {{{0x00000000, 0x3fd1c000} },
/**/                  {{0x3a9ce547, 0x3fd15097} },
/**/                  {{0x7f9ca328, 0xbc7796ba} },
/**/                  {{0xcbc2abaa, 0x3fedb6e1} },
/**/                  {{0xc39a4e7c, 0xbc823b7a} },
/**/                  {{0x0436f806, 0xbfce9c22} },
/**/                  {{0x885803cb, 0xbc64a5ec} },
/**/                  {{0x9a4c8963, 0xbfca474f} },
/**/                  {{0x6793b663, 0x3c671cf3} },
/**/                  {{0x9606243b, 0x3fc85cfc} },
/**/                  {{0x1dcd45ed, 0x3c5fd2b2} },
/**/                  {{0xf8cc655f, 0x3fa2686a} },
/**/                  {{0xc8460b94, 0xbfc10eac} },
/**/                  {{0x0d6eb5ba, 0x3fa1e9bc} },
/**/                  {{0x2e4749c2, 0x3fb3b8d0} },
/**/                  {{0xf0d19201, 0xbfaeff03} } },
/**/                 {{{0x00000000, 0x3fd20000} },
/**/                  {{0xa30bf178, 0x3fd18bf5} },
/**/                  {{0x748b1bf9, 0x3c630ca4} },
/**/                  {{0x1da7801e, 0x3feda780} },
/**/                  {{0x961ff896, 0xbc861ff8} },
/**/                  {{0x9814cb11, 0xbfceea65} },
/**/                  {{0x34cb01ca, 0xbc5f9845} },
/**/                  {{0xf76f9fa1, 0xbfc9e5ae} },
/**/                  {{0xa3ee6a86, 0x3c688b7a} },
/**/                  {{0xdf090624, 0x3fc872ff} },
/**/                  {{0x6fbad4bb, 0x3c31016f} },
/**/                  {{0x83fe02bc, 0x3fa0d08b} },
/**/                  {{0x31b98637, 0xbfc0ee42} },
/**/                  {{0x5b309f28, 0x3fa320e6} },
/**/                  {{0x755cbc43, 0x3fb32c0e} },
/**/                  {{0x5dea1ddb, 0xbfaf8dca} } },
/**/                 {{{0x00000000, 0x3fd24000} },
/**/                  {{0x212dd884, 0x3fd1c735} },
/**/                  {{0x78cb2f2e, 0xbc67d9ac} },
/**/                  {{0x971063d2, 0x3fed97f7} },
/**/                  {{0xc8b326b7, 0x3c67a20b} },
/**/                  {{0xc9f01359, 0xbfcf3783} },
/**/                  {{0xd0a651ad, 0x3c4a8b96} },
/**/                  {{0x408a6757, 0xbfc983ba} },
/**/                  {{0xe6424f06, 0x3c6dfff9} },
/**/                  {{0x41881aad, 0x3fc88707} },
/**/                  {{0x2204fd29, 0xbc63baf9} },
/**/                  {{0xabd6e10d, 0x3f9e779e} },
/**/                  {{0xcf2eab41, 0xbfc0cbbe} },
/**/                  {{0x1659f377, 0x3fa44f31} },
/**/                  {{0xa54a8a94, 0x3fb29ce7} },
/**/                  {{0xb87973d7, 0xbfb007c1} } },
/**/                 {{{0x00000000, 0x3fd28000} },
/**/                  {{0x67e47c96, 0x3fd20255} },
/**/                  {{0x28f4290e, 0xbc618323} },
/**/                  {{0xcaeb6c2a, 0x3fed8848} },
/**/                  {{0xa08296a2, 0x3c81e70d} },
/**/                  {{0xa96c2792, 0xbfcf837b} },
/**/                  {{0xc6884369, 0xbc6ab5ce} },
/**/                  {{0x5d351cdb, 0xbfc92179} },
/**/                  {{0x68719d81, 0x3c617000} },
/**/                  {{0xc8c1ca07, 0x3fc89916} },
/**/                  {{0x18b0f81b, 0xbc6a3339} },
/**/                  {{0x0caf6121, 0x3f9b54d0} },
/**/                  {{0x485ba392, 0xbfc0a732} },
/**/                  {{0xc250c31e, 0x3fa57477} },
/**/                  {{0x4790b4a8, 0x3fb20b96} },
/**/                  {{0x4ac23178, 0xbfb04223} } },
/**/                 {{{0x00000000, 0x3fd2c000} },
/**/                  {{0x2b381042, 0x3fd23d56} },
/**/                  {{0x16200088, 0xbc5c5317} },
/**/                  {{0x4c98f347, 0x3fed7874} },
/**/                  {{0x9a72647e, 0xbc8a7dac} },
/**/                  {{0x5dca68a2, 0xbfcfce4c} },
/**/                  {{0x8fb9ffdd, 0x3c6433de} },
/**/                  {{0x246041ce, 0xbfc8bef4} },
/**/                  {{0x1fb39160, 0xbc66c620} },
/**/                  {{0xbd062535, 0x3fc8a932} },
/**/                  {{0xfbc3a86c, 0xbc6e24c7} },
/**/                  {{0x64d0109d, 0x3f98390b} },
/**/                  {{0x819f2998, 0xbfc080ac} },
/**/                  {{0x8784ffb8, 0x3fa69099} },
/**/                  {{0x6fc55e9b, 0x3fb17854} },
/**/                  {{0x5f970a81, 0xbfb07618} } },
/**/                 {{{0x00000000, 0x3fd30000} },
/**/                  {{0x2057ef46, 0x3fd27837} },
/**/                  {{0xd36dfc81, 0xbc7077cd} },
/**/                  {{0xafdfd5ba, 0x3fed687a} },
/**/                  {{0xe19d8d3d, 0xbc782e68} },
/**/                  {{0x92db6fdb, 0xbfd00bfa} },
/**/                  {{0xc0af523f, 0x3c7854cd} },
/**/                  {{0x5b640da2, 0xbfc85c32} },
/**/                  {{0x5e6f23d6, 0x3c5d5bdd} },
/**/                  {{0xa1da32d2, 0x3fc8b75f} },
/**/                  {{0x29860bfe, 0x3c2788df} },
/**/                  {{0xee810d60, 0x3f9524ad} },
/**/                  {{0x95a69dea, 0xbfc0583d} },
/**/                  {{0x2b4d3dec, 0x3fa7a379} },
/**/                  {{0xa3290dfe, 0x3fb0e35b} },
/**/                  {{0x19e12287, 0xbfb0a3b2} } },
/**/                 {{{0x00000000, 0x3fd34000} },
/**/                  {{0xfd9b5fe2, 0x3fd2b2f7} },
/**/                  {{0xc1c2d443, 0x3c2423cf} },
/**/                  {{0x88e1caa2, 0x3fed585c} },
/**/                  {{0x01239e18, 0xbc2c8af2} },
/**/                  {{0xab890af7, 0xbfd0303a} },
/**/                  {{0x726290e6, 0x3c7d42bf} },
/**/                  {{0xb5175de0, 0xbfc7f93b} },
/**/                  {{0xe0ddc367, 0x3c5d5d4b} },
/**/                  {{0x3414de7c, 0x3fc8c3a2} },
/**/                  {{0xba92bfce, 0x3c5ade9b} },
/**/                  {{0xda70853d, 0x3f921811} },
/**/                  {{0xcf23aaf0, 0xbfc02df5} },
/**/                  {{0x06445ff8, 0x3fa8acfd} },
/**/                  {{0xc130eba4, 0x3fb04ce4} },
/**/                  {{0x29de3135, 0xbfb0cb04} } },
/**/                 {{{0x00000000, 0x3fd38000} },
/**/                  {{0x7a823cfe, 0x3fd2ed98} },
/**/                  {{0x8ea012ca, 0x3c6b9125} },
/**/                  {{0x6c0fd782, 0x3fed481a} },
/**/                  {{0x85ff74ea, 0x3c82dda4} },
/**/                  {{0x2f5c1e18, 0xbfd053e6} },
/**/                  {{0x8ec637b8, 0xbc679cf2} },
/**/                  {{0xd0ee3e3b, 0xbfc79617} },
/**/                  {{0x732049a6, 0xbc4e91e0} },
/**/                  {{0x67f6478d, 0x3fc8cdff} },
/**/                  {{0xf5079e63, 0xbc5cb659} },
/**/                  {{0x8e8ef686, 0x3f8e271c} },
/**/                  {{0xa2940881, 0xbfc001e5} },
/**/                  {{0xf937caae, 0x3fa9ad0e} },
/**/                  {{0xda1e257f, 0x3faf6a4f} },
/**/                  {{0xb07d42be, 0xbfb0ec24} } },
/**/                 {{{0x00000000, 0x3fd3c000} },
/**/                  {{0x4fb58952, 0x3fd32818} },
/**/                  {{0xa9939f2f, 0xbc7a95f0} },
/**/                  {{0xee1ee130, 0x3fed37b4} },
/**/                  {{0x6fbb1f2d, 0x3c747541} },
/**/                  {{0xe022dd0d, 0xbfd076fc} },
/**/                  {{0x5534523a, 0x3c6d8659} },
/**/                  {{0x3a201d6b, 0xbfc732ce} },
/**/                  {{0xc98a3a62, 0xbc56a551} },
/**/                  {{0x673a29b8, 0x3fc8d67c} },
/**/                  {{0xff95efe6, 0xbc54ae9d} },
/**/                  {{0x74ce6814, 0x3f882eee} },
/**/                  {{0x503ba8f4, 0xbfbfa83b} },
/**/                  {{0x60b63f75, 0x3faaa39c} },
/**/                  {{0xf07ff274, 0x3fae38b8} },
/**/                  {{0x2200fe4d, 0xbfb1072c} } },
/**/                 {{{0x00000000, 0x3fd40000} },
/**/                  {{0x3707ebcc, 0x3fd36277} },
/**/                  {{0x44b672d8, 0xbc6963a5} },
/**/                  {{0xa3fc5b1a, 0x3fed272c} },
/**/                  {{0x272ca3fc, 0x3c8ae01d} },
/**/                  {{0x8aec9d8e, 0xbfd0997e} },
/**/                  {{0x72595f36, 0x3c74aeda} },
/**/                  {{0x66d5c0ff, 0xbfc6cf66} },
/**/                  {{0x3ca66cc1, 0x3c410e2a} },
/**/                  {{0x8f2617b5, 0x3fc8dd1e} },
/**/                  {{0x4facfb67, 0xbc6d173e} },
/**/                  {{0x33966883, 0x3f82483b} },
/**/                  {{0x2b05b16b, 0xbfbf495d} },
/**/                  {{0x074fdeaf, 0x3fab9096} },
/**/                  {{0x9c4605c9, 0x3fad0571} },
/**/                  {{0x280318fd, 0xbfb11c35} } },
/**/                 {{{0x00000000, 0x3fd44000} },
/**/                  {{0xeb76157c, 0x3fd39cb4} },
/**/                  {{0x5a214713, 0xbc72f4da} },
/**/                  {{0x22c31625, 0x3fed1682} },
/**/                  {{0xd5e51b41, 0x3c8ac111} },
/**/                  {{0x07e9a89a, 0xbfd0bb6b} },
/**/                  {{0x7faa1dda, 0x3c76fb53} },
/**/                  {{0xb75f0772, 0xbfc66be7} },
/**/                  {{0xee6d618b, 0xbc69a77d} },
/**/                  {{0x6e943d69, 0x3fc8e1eb} },
/**/                  {{0xc5ec9ebe, 0xbc6982c4} },
/**/                  {{0x9c2d3c0c, 0x3f78e73c} },
/**/                  {{0x7059f387, 0xbfbee752} },
/**/                  {{0x16982f58, 0x3fac73f0} },
/**/                  {{0xc146b407, 0x3fabd0e4} },
/**/                  {{0x82f43254, 0xbfb12b5c} } },
/**/                 {{{0x00000000, 0x3fd48000} },
/**/                  {{0x29271134, 0x3fd3d6d1} },
/**/                  {{0x41cc958a, 0x3c7137ca} },
/**/                  {{0xffb0304c, 0x3fed05b5} },
/**/                  {{0x33e896e5, 0xbc8fc921} },
/**/                  {{0x3a49e254, 0xbfd0dcc2} },
/**/                  {{0x925cb599, 0x3c704578} },
/**/                  {{0x75708502, 0xbfc60859} },
/**/                  {{0x9feebe6c, 0xbc5f88bc} },
/**/                  {{0xc3fb5c1c, 0x3fc8e4e8} },
/**/                  {{0xd6b77a05, 0x3c6de114} },
/**/                  {{0xdbc6c857, 0x3f6ac6b3} },
/**/                  {{0xdeabd793, 0xbfbe823c} },
/**/                  {{0x06fb52a7, 0x3fad4da2} },
/**/                  {{0x2bea698c, 0x3faa9b7b} },
/**/                  {{0xeb32d745, 0xbfb134c0} } },
/**/                 {{{0x00000000, 0x3fd4c000} },
/**/                  {{0xad6c7d33, 0x3fd410cb} },
/**/                  {{0xae13b512, 0xbc7b0c8b} },
/**/                  {{0xd0182625, 0x3fecf4c8} },
/**/                  {{0xf4103798, 0x3c8e6308} },
/**/                  {{0x101a5438, 0xbfd0fd84} },
/**/                  {{0x7d2e3e34, 0x3c425fcd} },
/**/                  {{0xd36904f6, 0xbfc5a4c2} },
/**/                  {{0x54f27bb6, 0x3c5d3583} },
/**/                  {{0x7b74b00c, 0x3fc8e61c} },
/**/                  {{0xefe568b6, 0x3c32f7ad} },
/**/                  {{0xaa3667f2, 0x3f402f60} },
/**/                  {{0x4c9859c0, 0xbfbe1a3e} },
/**/                  {{0x8e77c589, 0x3fae1da6} },
/**/                  {{0x6ed5823e, 0x3fa9659b} },
/**/                  {{0xf1d3d420, 0xbfb13882} } },
/**/                 {{{0x00000000, 0x3fd50000} },
/**/                  {{0x36c2af0a, 0x3fd44aa4} },
/**/                  {{0x3c55b3ba, 0xbc75d5e4} },
/**/                  {{0x295c0773, 0x3fece3bb} },
/**/                  {{0x91851b41, 0xbc826fd5} },
/**/                  {{0x8221a582, 0xbfd11db0} },
/**/                  {{0xa9f31d11, 0x3c7e9654} },
/**/                  {{0xeb9ef661, 0xbfc5412a} },
/**/                  {{0x5e60433c, 0x3c573faf} },
/**/                  {{0xacc06b3a, 0x3fc8e58c} },
/**/                  {{0x64dd81ed, 0xbc5dba9a} },
/**/                  {{0xcfe3f01e, 0xbf625ff7} },
/**/                  {{0x9dae4b1c, 0xbfbdaf78} },
/**/                  {{0x8e4e3e16, 0x3faee3fb} },
/**/                  {{0xc2c60fed, 0x3fa82fa9} },
/**/                  {{0xe13555d9, 0xbfb136c4} } },
/**/                 {{{0x00000000, 0x3fd54000} },
/**/                  {{0x84d0c21b, 0x3fd4845a} },
/**/                  {{0x7563c6a6, 0x3c71e28a} },
/**/                  {{0xa0decfad, 0x3fecd28d} },
/**/                  {{0x49610c12, 0xbc72b2c8} },
/**/                  {{0x93bb8da8, 0xbfd13d47} },
/**/                  {{0x1b48d912, 0x3c5df07a} },
/**/                  {{0xbfb5c8b7, 0xbfc4dd98} },
/**/                  {{0x39a108d7, 0x3c58a9ff} },
/**/                  {{0x99496dc4, 0x3fc8e33f} },
/**/                  {{0x19d3995c, 0x3c380d8b} },
/**/                  {{0xba1bc2d2, 0xbf743d59} },
/**/                  {{0xb77862a1, 0xbfbd420d} },
/**/                  {{0xffb9511c, 0x3fafa0a1} },
/**/                  {{0xe8a86cad, 0x3fa6fa07} },
/**/                  {{0x9d75a109, 0xbfb12faa} } },
/**/                 {{{0x00000000, 0x3fd58000} },
/**/                  {{0x586890e7, 0x3fd4bdee} },
/**/                  {{0x7c22a757, 0xbc6e4dc7} },
/**/                  {{0xcbfae3a7, 0x3fecc140} },
/**/                  {{0xd8b6f9b9, 0xbc41045d} },
/**/                  {{0x52b34cdc, 0xbfd15c49} },
/**/                  {{0x2daa60ac, 0x3c729992} },
/**/                  {{0x37fb39ef, 0xbfc47a13} },
/**/                  {{0x3482d371, 0x3c5cb3b2} },
/**/                  {{0xaa28e022, 0x3fc8df3b} },
/**/                  {{0x969a5447, 0xbc61a8ab} },
/**/                  {{0xc651ecb4, 0xbf7f2135} },
/**/                  {{0x76cc63f7, 0xbfbcd21f} },
/**/                  {{0xefdf4de1, 0x3fb029ce} },
/**/                  {{0x0de3bf96, 0x3fa5c515} },
/**/                  {{0x84e55ab4, 0xbfb12359} } },
/**/                 {{{0x00000000, 0x3fd5c000} },
/**/                  {{0x73869979, 0x3fd4f75f} },
/**/                  {{0xf7ff1108, 0xbc595a1c} },
/**/                  {{0x3ff7b52c, 0x3fecafd5} },
/**/                  {{0x684b6314, 0x3c86e099} },
/**/                  {{0xd71d366e, 0xbfd17ab5} },
/**/                  {{0xae2f7b71, 0x3c602f2c} },
/**/                  {{0x22cc956f, 0xbfc416a1} },
/**/                  {{0xe98c24c1, 0x3c61d29e} },
/**/                  {{0x6e2a4f9f, 0x3fc8d987} },
/**/                  {{0x4a6a7880, 0xbc60de73} },
/**/                  {{0x909e42ec, 0xbf84ed52} },
/**/                  {{0xa56263a8, 0xbfbc5fcf} },
/**/                  {{0x0d159803, 0x3fb07e7b} },
/**/                  {{0xb2ddf20b, 0x3fa4912d} },
/**/                  {{0x508c8585, 0xbfb111f8} } },
/**/                 {{{0x00000000, 0x3fd60000} },
/**/                  {{0x9951cd4a, 0x3fd530ad} },
/**/                  {{0x80884082, 0xbc625664} },
/**/                  {{0x91ff8d87, 0x3fec9e4b} },
/**/                  {{0x1b0da370, 0xbc7723ff} },
/**/                  {{0x432f5908, 0xbfd1988d} },
/**/                  {{0xf8714cda, 0x3c7d065e} },
/**/                  {{0x3403e07c, 0xbfc3b349} },
/**/                  {{0x2717fbb0, 0x3c6b571d} },
/**/                  {{0x97d0e938, 0x3fc8d229} },
/**/                  {{0xb08a0625, 0x3c66b228} },
/**/                  {{0xc2fe9cde, 0xbf8a3464} },
/**/                  {{0xefb6f244, 0xbfbbeb3f} },
/**/                  {{0x39e67c0b, 0x3fb0ce5a} },
/**/                  {{0x93b4fb73, 0x3fa35eab} },
/**/                  {{0xf4d86f78, 0xbfb0fbae} } },
/**/                 {{{0x00000000, 0x3fd64000} },
/**/                  {{0x8e1b4cd8, 0x3fd569d8} },
/**/                  {{0xe713cfe2, 0xbc6fec61} },
/**/                  {{0x57157fc9, 0x3fec8ca4} },
/**/                  {{0x515734ba, 0x3c70da14} },
/**/                  {{0xc3195094, 0xbfd1b5cf} },
/**/                  {{0xa9537e45, 0x3c740cce} },
/**/                  {{0x046cee83, 0xbfc35012} },
/**/                  {{0xe446fd10, 0xbc651b6c} },
/**/                  {{0xfb5e6a95, 0x3fc8c928} },
/**/                  {{0x82469bf3, 0x3c656cd2} },
/**/                  {{0xa4afbb1b, 0xbf8f6568} },
/**/                  {{0xdb3aba50, 0xbfbb7491} },
/**/                  {{0xb9fd56ec, 0x3fb11972} },
/**/                  {{0x9329e15e, 0x3fa22de5} },
/**/                  {{0x8287d93d, 0xbfb0e0a6} } },
/**/                 {{{0x00000000, 0x3fd68000} },
/**/                  {{0x175e0f4e, 0x3fd5a2e0} },
/**/                  {{0x8f82e457, 0x3c713b7a} },
/**/                  {{0x240b83ae, 0x3fec7ae0} },
/**/                  {{0x10d398ed, 0xbc885b56} },
/**/                  {{0x8cdb4db0, 0xbfd1d27d} },
/**/                  {{0x2db0447f, 0x3c11d95f} },
/**/                  {{0x11425541, 0xbfc2ed02} },
/**/                  {{0x6b2cbaa3, 0xbc11d124} },
/**/                  {{0x8cdc5c4d, 0x3fc8be8c} },
/**/                  {{0x794444b0, 0xbc542511} },
/**/                  {{0xd25a5415, 0xbf923ffd} },
/**/                  {{0xbcd1df44, 0xbfbafbe6} },
/**/                  {{0x26bdf05c, 0x3fb15fcc} },
/**/                  {{0xa7b853e6, 0x3fa0ff2f} },
/**/                  {{0x07e9a35f, 0xbfb0c109} } },
/**/                 {{{0x00000000, 0x3fd6c000} },
/**/                  {{0xfbbe768d, 0x3fd5dbc3} },
/**/                  {{0x1b76f7da, 0x3c6ea0ec} },
/**/                  {{0x8d78b9ce, 0x3fec68ff} },
/**/                  {{0x4cb5a0c3, 0xbc83ab41} },
/**/                  {{0xe01c5e6e, 0xbfd1ee96} },
/**/                  {{0xfb76d8dd, 0x3c73922c} },
/**/                  {{0xbbb23677, 0xbfc28a1f} },
/**/                  {{0x288601f2, 0x3c6e592a} },
/**/                  {{0x5e282403, 0x3fc8b25b} },
/**/                  {{0x707e09fa, 0xbbef7d58} },
/**/                  {{0xb65add31, 0xbf94c1e0} },
/**/                  {{0xafa52f1b, 0xbfba815f} },
/**/                  {{0x63712acc, 0x3fb1a16f} },
/**/                  {{0x95a8d3ad, 0x3f9fa5b5} },
/**/                  {{0x72814750, 0xbfb09d01} } },
/**/                 {{{0x00000000, 0x3fd70000} },
/**/                  {{0x0309cfe2, 0x3fd61484} },
/**/                  {{0x15711f00, 0xbc7a7257} },
/**/                  {{0x27afd9eb, 0x3fec5703} },
/**/                  {{0xb32c1d72, 0x3c63c2ab} },
/**/                  {{0x06000419, 0xbfd20a1c} },
/**/                  {{0xf51a3a28, 0xbc7b5fe7} },
/**/                  {{0x486ad2c8, 0xbfc22771} },
/**/                  {{0xf84a7eae, 0xbc499ab5} },
/**/                  {{0x9d027817, 0x3fc8a49c} },
/**/                  {{0x2e376ecc, 0xbc53fcab} },
/**/                  {{0xeaabcb23, 0xbf973831} },
/**/                  {{0x8c46fbce, 0xbfba051d} },
/**/                  {{0x9132e9cc, 0x3fb1de66} },
/**/                  {{0xd48d5d65, 0x3f9d5269} },
/**/                  {{0x712354a4, 0xbfb074bb} } },
/**/                 {{{0x00000000, 0x3fd74000} },
/**/                  {{0xf635c1c6, 0x3fd64d1f} },
/**/                  {{0xe7c0fdbe, 0xbc7fa403} },
/**/                  {{0x86b5cbf8, 0x3fec44eb} },
/**/                  {{0xbc5b562d, 0xbc6a4101} },
/**/                  {{0x50fb21ad, 0xbfd2250d} },
/**/                  {{0xa39bdc1a, 0xbc750066} },
/**/                  {{0xdf2ed728, 0xbfc1c4fc} },
/**/                  {{0x006772e9, 0x3c6a87bb} },
/**/                  {{0x9122b9b7, 0x3fc89557} },
/**/                  {{0x45b04f75, 0xbc05454e} },
/**/                  {{0x6c7888f1, 0xbf99a2c9} },
/**/                  {{0xe02d36ad, 0xbfb98740} },
/**/                  {{0x02a99665, 0x3fb216bd} },
/**/                  {{0xb73aeccb, 0x3f9b0511} },
/**/                  {{0x569b1738, 0xbfb04863} } },
/**/                 {{{0x00000000, 0x3fd78000} },
/**/                  {{0x9f5fa6fe, 0x3fd68597} },
/**/                  {{0x4d1ada9c, 0xbc425781} },
/**/                  {{0x3e386c7f, 0x3fec32b9} },
/**/                  {{0x8cbaa5bf, 0x3c756033} },
/**/                  {{0x1ca84e79, 0xbfd23f6b} },
/**/                  {{0xf123d574, 0x3c604cc0} },
/**/                  {{0x8a715435, 0xbfc162c8} },
/**/                  {{0x454fb8fd, 0x3c5cf6db} },
/**/                  {{0x9a4eb534, 0x3fc88493} },
/**/                  {{0x42b959b0, 0xbc668a5c} },
/**/                  {{0x42580bb5, 0xbf9c0182} },
/**/                  {{0xe5822d56, 0xbfb907e9} },
/**/                  {{0x2f8f8273, 0x3fb24a7f} },
/**/                  {{0xa3527f46, 0x3f98be3c} },
/**/                  {{0xfce97270, 0xbfb01825} } },
/**/                 {{{0x00000000, 0x3fd7c000} },
/**/                  {{0xc9cbd76d, 0x3fd6bdea} },
/**/                  {{0x3e6de828, 0xbc5a5c56} },
/**/                  {{0xe1857d04, 0x3fec206c} },
/**/                  {{0xf5c83872, 0xbc80439f} },
/**/                  {{0xcd9b9870, 0xbfd25935} },
/**/                  {{0xf1ec7306, 0x3c6aaf98} },
/**/                  {{0x36f94d02, 0xbfc100da} },
/**/                  {{0xd96d84ff, 0xbc6e72ca} },
/**/                  {{0x2e774351, 0x3fc87258} },
/**/                  {{0xb8860ef0, 0x3c6c50a2} },
/**/                  {{0x741ef0ec, 0xbf9e543a} },
/**/                  {{0x7b4d0ec2, 0xbfb88738} },
/**/                  {{0xa8164103, 0x3fb279ba} },
/**/                  {{0xa7f1ae35, 0x3f967e73} },
/**/                  {{0x5257c3de, 0xbfafc861} } },
/**/                 {{{0x00000000, 0x3fd80000} },
/**/                  {{0x41e4def1, 0x3fd6f619} },
/**/                  {{0xe6f6e918, 0xbc7c63aa} },
/**/                  {{0x0381c0e0, 0x3fec0e07} },
/**/                  {{0x0381c0e0, 0x3c8c0e07} },
/**/                  {{0xd135c174, 0xbfd2726d} },
/**/                  {{0xe0951cf8, 0xbc2d352d} },
/**/                  {{0xb38cc8cf, 0xbfc09f37} },
/**/                  {{0xae75327f, 0xbc69db81} },
/**/                  {{0xd7da413c, 0x3fc85eac} },
/**/                  {{0x6ebae2bc, 0x3c5b1a89} },
/**/                  {{0x80fcc815, 0xbfa04d69} },
/**/                  {{0x1df326f9, 0xbfb8054c} },
/**/                  {{0x082bda60, 0x3fb2a47e} },
/**/                  {{0x7091d5a4, 0x3f944639} },
/**/                  {{0xe072e48c, 0xbfaf5961} } },
/**/                 {{{0x00000000, 0x3fd84000} },
/**/                  {{0xd53aa2aa, 0x3fd72e22} },
/**/                  {{0x4e79f27c, 0xbc7d9c93} },
/**/                  {{0x36a04729, 0x3febfb88} },
/**/                  {{0x9ac2ea21, 0xbc872745} },
/**/                  {{0x9d7702cf, 0xbfd28b13} },
/**/                  {{0x4be8bff6, 0x3c7819b9} },
/**/                  {{0xb0a35176, 0xbfc03de6} },
/**/                  {{0xc83347af, 0x3c5dbfb0} },
/**/                  {{0x332a4f86, 0x3fc84999} },
/**/                  {{0x0a22d12d, 0x3c5d304e} },
/**/                  {{0xed6b2d30, 0xbfa16a97} },
/**/                  {{0xe0128950, 0xbfb78243} },
/**/                  {{0xeaa98f57, 0x3fb2cad8} },
/**/                  {{0x3bb39c5b, 0x3f92160a} },
/**/                  {{0x3804caa3, 0xbfaee3a9} } },
/**/                 {{{0x00000000, 0x3fd88000} },
/**/                  {{0x52817502, 0x3fd76607} },
/**/                  {{0x91cc7600, 0xbc4dd117} },
/**/                  {{0x0cd9e1fe, 0x3febe8f1} },
/**/                  {{0xa21e102a, 0xbc7a9688} },
/**/                  {{0xb0d161e9, 0xbfd2a327} },
/**/                  {{0x14b44140, 0xbc60a2a9} },
/**/                  {{0x803f8d3b, 0xbfbfb9d9} },
/**/                  {{0x2a5c4097, 0x3c5e5779} },
/**/                  {{0xedbcc363, 0x3fc83324} },
/**/                  {{0xa0442744, 0x3c651fbc} },
/**/                  {{0xe91477c3, 0xbfa2819b} },
/**/                  {{0x63b6abf0, 0xbfb6fe3e} },
/**/                  {{0xdc73a89a, 0x3fb2ecdb} },
/**/                  {{0xaa755298, 0x3f8fdcb7} },
/**/                  {{0x237c2f3d, 0xbfae6793} } },
/**/                 {{{0x00000000, 0x3fd8c000} },
/**/                  {{0x899118d1, 0x3fd79dc6} },
/**/                  {{0xa0ef606d, 0x3c2b7413} },
/**/                  {{0x17a4cbc3, 0x3febd642} },
/**/                  {{0x3200a548, 0xbc55ee5d} },
/**/                  {{0x91faa133, 0xbfd2baaa} },
/**/                  {{0xfaf41548, 0xbc6bd391} },
/**/                  {{0xaa22d832, 0xbfbef89e} },
/**/                  {{0xc874fdb9, 0x3c413b3b} },
/**/                  {{0xc3be300a, 0x3fc81b57} },
/**/                  {{0xc01a615f, 0x3c6baf9b} },
/**/                  {{0x4a872ec7, 0xbfa3926a} },
/**/                  {{0xd3e743cd, 0xbfb67959} },
/**/                  {{0x4f919505, 0x3fb30a98} },
/**/                  {{0x28b78b08, 0x3f8b9f3b} },
/**/                  {{0x71e33e9d, 0xbfade57b} } },
/**/                 {{{0x00000000, 0x3fd90000} },
/**/                  {{0x4b63b3f7, 0x3fd7d560} },
/**/                  {{0x5c2b249a, 0x3c769c88} },
/**/                  {{0xe7ec7a8d, 0x3febc37b} },
/**/                  {{0x2b0e2727, 0xbc6f1246} },
/**/                  {{0xcfbdd7fa, 0xbfd2d19c} },
/**/                  {{0x5e00c582, 0x3c7d0b11} },
/**/                  {{0x86f8309b, 0xbfbe3827} },
/**/                  {{0xfa6c56a7, 0x3c5d64e9} },
/**/                  {{0x7e6de8de, 0x3fc80239} },
/**/                  {{0x7776e849, 0x3c68d62f} },
/**/                  {{0x4f6d8017, 0xbfa49cf9} },
/**/                  {{0xde917e27, 0xbfb5f3b3} },
/**/                  {{0x8e455cc2, 0x3fb32420} },
/**/                  {{0xb9fc88fe, 0x3f877470} },
/**/                  {{0xc6b10536, 0xbfad5dbd} } },
/**/                 {{{0x00000000, 0x3fd94000} },
/**/                  {{0x6a14b1d1, 0x3fd80cd4} },
/**/                  {{0x9684fa19, 0xbc7e79f9} },
/**/                  {{0x0e09a222, 0x3febb09f} },
/**/                  {{0x7e047edd, 0x3c85748e} },
/**/                  {{0x00ccbbc8, 0xbfd2e7ff} },
/**/                  {{0x96875561, 0xbc78eb0a} },
/**/                  {{0x804ecc06, 0xbfbd787e} },
/**/                  {{0x2e4351f8, 0xbc27263b} },
/**/                  {{0xf260d7b4, 0x3fc7e7d1} },
/**/                  {{0x8ed258e3, 0xbc430525} },
/**/                  {{0x968d3d02, 0xbfa5a140} },
/**/                  {{0xaecb845e, 0xbfb56d69} },
/**/                  {{0xae292f95, 0x3fb33987} },
/**/                  {{0x48e09ecd, 0x3f835d1d} },
/**/                  {{0x6b6f9aca, 0xbfacd0b5} } },
/**/                 {{{0x00000000, 0x3fd98000} },
/**/                  {{0xb8df95d7, 0x3fd84422} },
/**/                  {{0x299b41b6, 0x3c7d76a0} },
/**/                  {{0x19ba64d6, 0x3feb9dac} },
/**/                  {{0xa13ee09f, 0xbc4f643a} },
/**/                  {{0xc390a5c9, 0xbfd2fdd1} },
/**/                  {{0xaa856fcc, 0x3c575152} },
/**/                  {{0xc0e99751, 0xbfbcb9ad} },
/**/                  {{0x1347a357, 0x3c4e2d44} },
/**/                  {{0xfdcbfd40, 0x3fc7cc28} },
/**/                  {{0xe516db08, 0x3c60dc32} },
/**/                  {{0x19851d86, 0xbfa69f39} },
/**/                  {{0xe772087d, 0xbfb4e697} },
/**/                  {{0x835992de, 0x3fb34ae1} },
/**/                  {{0xe5326389, 0x3f7eb3f1} },
/**/                  {{0x234575e8, 0xbfac3ebd} } },
/**/                 {{{0x00000000, 0x3fd9c000} },
/**/                  {{0x0c1ebedc, 0x3fd87b4b} },
/**/                  {{0xa2fa470f, 0xbc76dcfa} },
/**/                  {{0x9a1ab378, 0x3feb8aa3} },
/**/                  {{0xb797ab93, 0x3c8efdb0} },
/**/                  {{0xbdfb5e5a, 0xbfd31315} },
/**/                  {{0x862f0c0d, 0x3c5813a8} },
/**/                  {{0x3478f169, 0xbfbbfbbf} },
/**/                  {{0xd9e52582, 0xbc51e810} },
/**/                  {{0x86d6ec76, 0x3fc7af46} },
/**/                  {{0x3c13b159, 0xbc6336de} },
/**/                  {{0x264b8050, 0xbfa796dd} },
/**/                  {{0x9e1f6bef, 0xbfb45f5a} },
/**/                  {{0x93b26fc1, 0x3fb35842} },
/**/                  {{0x39bc3abf, 0x3f76d75e} },
/**/                  {{0x006e38b2, 0xbfaba82f} } },
/**/                 {{{0x00000000, 0x3fda0000} },
/**/                  {{0x394a1b25, 0x3fd8b24d} },
/**/                  {{0xa3748fa8, 0x3c7b6d0b} },
/**/                  {{0x1d9cdc98, 0x3feb7786} },
/**/                  {{0x345bd7a8, 0xbc62e22c} },
/**/                  {{0x9d57b8f5, 0xbfd327cb} },
/**/                  {{0x753cc4f1, 0xbc135343} },
/**/                  {{0x8761b154, 0xbfbb3ebc} },
/**/                  {{0x8c168fdd, 0x3c5abeec} },
/**/                  {{0x79f68c54, 0x3fc79132} },
/**/                  {{0xd8d15eda, 0xbc658ab9} },
/**/                  {{0x5872d73c, 0xbfa88828} },
/**/                  {{0x567be750, 0xbfb3d7cd} },
/**/                  {{0x0a24fc71, 0x3fb361c0} },
/**/                  {{0x46aa98b6, 0x3f6e4b7a} },
/**/                  {{0x3bad3a76, 0xbfab0d64} } },
/**/                 {{{0x00000000, 0x3fda4000} },
/**/                  {{0x16f5cde8, 0x3fd8e929} },
/**/                  {{0xe12bfafb, 0x3c74c0a7} },
/**/                  {{0x32024b37, 0x3feb6454} },
/**/                  {{0x69cc9b53, 0xbc7987f7} },
/**/                  {{0x161a0a40, 0xbfd33bf4} },
/**/                  {{0x83ff46db, 0x3c7a2321} },
/**/                  {{0x26913418, 0xbfba82af} },
/**/                  {{0x10a559fe, 0x3c3c4c62} },
/**/                  {{0xc8506679, 0x3fc771f4} },
/**/                  {{0x63c7ccc3, 0xbc54aaed} },
/**/                  {{0x9237e7ff, 0xbfa97317} },
/**/                  {{0xfde5f112, 0xbfb3500a} },
/**/                  {{0xaa2c3459, 0x3fb3676f} },
/**/                  {{0x04721907, 0x3f5e80cd} },
/**/                  {{0x0dc212a5, 0xbfaa6eb5} } },
/**/                 {{{0x00000000, 0x3fda8000} },
/**/                  {{0x7cd0c662, 0x3fd91fde} },
/**/                  {{0x88054b53, 0x3c710741} },
/**/                  {{0x6454751c, 0x3feb510e} },
/**/                  {{0x7e0f2dca, 0xbc199bfd} },
/**/                  {{0xe3b081f4, 0xbfd34f8f} },
/**/                  {{0x3e2c0515, 0x3c7d7209} },
/**/                  {{0x3f5e2d2f, 0xbfb9c7a0} },
/**/                  {{0xea3bd312, 0xbc20b02e} },
/**/                  {{0x6626c39a, 0x3fc75195} },
/**/                  {{0xb4219a8a, 0x3c6f30d2} },
/**/                  {{0xf55dfea5, 0xbfaa57a8} },
/**/                  {{0xe771fa17, 0xbfb2c82d} },
/**/                  {{0xc3654ab4, 0x3fb36967} },
/**/                  {{0xa23eb6eb, 0x3f11f322} },
/**/                  {{0x8ae579b1, 0xbfa9cc78} } },
/**/                 {{{0x00000000, 0x3fdac000} },
/**/                  {{0x43a34907, 0x3fd9566d} },
/**/                  {{0x37e0af2b, 0x3c69b015} },
/**/                  {{0x40ddf8d3, 0x3feb3db5} },
/**/                  {{0x793c10b8, 0xbc616f46} },
/**/                  {{0xc8537217, 0xbfd3629f} },
/**/                  {{0x38143614, 0x3c505738} },
/**/                  {{0xbf75f20a, 0xbfb90d98} },
/**/                  {{0x6b842647, 0x3c4dc715} },
/**/                  {{0x494dd1e6, 0x3fc7301c} },
/**/                  {{0xf49f85b4, 0x3c5ec3d6} },
/**/                  {{0xdbdd23b1, 0xbfab35db} },
/**/                  {{0xc8407216, 0xbfb2404f} },
/**/                  {{0x255139f9, 0x3fb367bf} },
/**/                  {{0x65acd6da, 0xbf5b8a0d} },
/**/                  {{0x8052f51d, 0xbfa92704} } },
/**/                 {{{0x00000000, 0x3fdb0000} },
/**/                  {{0x454d6b18, 0x3fd98cd5} },
/**/                  {{0x88fd0a77, 0x3c79e6c9} },
/**/                  {{0x5323eb6a, 0x3feb2a49} },
/**/                  {{0x70cc9678, 0xbc572202} },
/**/                  {{0x8cd58cc4, 0xbfd37524} },
/**/                  {{0xda42aa4e, 0x3c6978a3} },
/**/                  {{0x54d5f784, 0xbfb854a1} },
/**/                  {{0xb33b3d0d, 0xbc5e9a15} },
/**/                  {{0x67aa0c46, 0x3fc70d91} },
/**/                  {{0xa4ac9df8, 0xbc6aa72f} },
/**/                  {{0xd0665a46, 0xbfac0db0} },
/**/                  {{0xb428e30d, 0xbfb1b889} },
/**/                  {{0x134448b0, 0x3fb3628d} },
/**/                  {{0x67619c9c, 0xbf6bbbc1} },
/**/                  {{0x53e1f653, 0xbfa87ead} } },
/**/                 {{{0x00000000, 0x3fdb4000} },
/**/                  {{0x5cc58107, 0x3fd9c316} },
/**/                  {{0x02250cfb, 0x3c4b6696} },
/**/                  {{0x25df55f4, 0x3feb16cb} },
/**/                  {{0xf48e26bc, 0xbc653abc} },
/**/                  {{0x00742189, 0xbfd3871f} },
/**/                  {{0xc05df451, 0xbc725ae2} },
/**/                  {{0x6dd13675, 0xbfb79cc2} },
/**/                  {{0x991905e4, 0x3be1d4e0} },
/**/                  {{0xb5b8147e, 0x3fc6e9fc} },
/**/                  {{0xa57d4eca, 0x3c46463b} },
/**/                  {{0x86c1db89, 0xbfacdf29} },
/**/                  {{0x1ab8d1c4, 0xbfb130f4} },
/**/                  {{0x38881228, 0x3fb359e9} },
/**/                  {{0x53bec2ff, 0xbf74a987} },
/**/                  {{0xe5af58b6, 0xbfa7d3c5} } },
/**/                 {{{0x00000000, 0x3fdb8000} },
/**/                  {{0x66168002, 0x3fd9f930} },
/**/                  {{0x47c9439a, 0xbc7c8270} },
/**/                  {{0x42f6e2c9, 0x3feb033b} },
/**/                  {{0xc48702a7, 0xbc6eb80c} },
/**/                  {{0xf8a76337, 0xbfd3988f} },
/**/                  {{0x5b1bb38a, 0xbc636968} },
/**/                  {{0x39212b04, 0xbfb6e604} },
/**/                  {{0xba255e71, 0xbc3c2e20} },
/**/                  {{0x251e2d41, 0x3fc6c566} },
/**/                  {{0x47236369, 0x3c230ab3} },
/**/                  {{0xd40b3417, 0xbfadaa48} },
/**/                  {{0xc484f2cc, 0xbfb0a9a6} },
/**/                  {{0x9cb4573e, 0x3fb34deb} },
/**/                  {{0x1def6f17, 0xbf7b44ca} },
/**/                  {{0x73d683b8, 0xbfa7269f} } },
/**/                 {{{0x00000000, 0x3fdbc000} },
/**/                  {{0x3e5e530b, 0x3fda2f23} },
/**/                  {{0xf797086b, 0x3c5814d5} },
/**/                  {{0x3378ba79, 0x3feaef9a} },
/**/                  {{0x4476e241, 0x3c7da16a} },
/**/                  {{0x50f2beab, 0xbfd3a978} },
/**/                  {{0xad5a31ea, 0x3c7b7e7f} },
/**/                  {{0xa602212f, 0xbfb6306e} },
/**/                  {{0x9ec38d55, 0xbc31ec15} },
/**/                  {{0xa3477c6a, 0x3fc69fd5} },
/**/                  {{0xb2996038, 0x3c571f2f} },
/**/                  {{0xa6cf162d, 0xbfae6f12} },
/**/                  {{0xd0cb2655, 0xbfb022b8} },
/**/                  {{0x9842912f, 0x3fb33eac} },
/**/                  {{0x4919e78d, 0xbf80d789} },
/**/                  {{0x8037e242, 0xbfa67789} } },
/**/                 {{{0x00000000, 0x3fdc0000} },
/**/                  {{0xc3cc23fd, 0x3fda64ee} },
/**/                  {{0x1b50b7ff, 0xbc724dec} },
/**/                  {{0x7f94905e, 0x3feadbe8} },
/**/                  {{0x7f94905e, 0x3c2adbe8} },
/**/                  {{0xeab54af9, 0xbfd3b9d8} },
/**/                  {{0x54fd0941, 0x3c75b97d} },
/**/                  {{0x645a7f9e, 0xbfb57c09} },
/**/                  {{0x09320811, 0xbc5e79f6} },
/**/                  {{0x180938f2, 0x3fc67953} },
/**/                  {{0xe7aee726, 0x3c6246f2} },
/**/                  {{0xff0ea012, 0xbfaf2d8b} },
/**/                  {{0x66c7250c, 0xbfaf3881} },
/**/                  {{0xc95ff694, 0x3fb32c44} },
/**/                  {{0x25d7ff49, 0xbf83f3f0} },
/**/                  {{0xb848e1d1, 0xbfa5c6d1} } },
/**/                 {{{0x00000000, 0x3fdc4000} },
/**/                  {{0xd59e98cf, 0x3fda9a92} },
/**/                  {{0xff75d817, 0x3c42e42d} },
/**/                  {{0xae95dea9, 0x3feac826} },
/**/                  {{0x633dec57, 0xbc534eec} },
/**/                  {{0xacfa5b18, 0xbfd3c9b2} },
/**/                  {{0x6c4d8d27, 0x3c7a7e0c} },
/**/                  {{0xe4ecc0f6, 0xbfb4c8db} },
/**/                  {{0xc0c32772, 0xbc534990} },
/**/                  {{0x6451e377, 0x3fc651e6} },
/**/                  {{0x2a9bb1f1, 0xbc6ea814} },
/**/                  {{0xe62bc1b2, 0xbfafe5ba} },
/**/                  {{0x65fe3642, 0xbfae2ca8} },
/**/                  {{0x09015968, 0x3fb316cd} },
/**/                  {{0x3ce97a26, 0xbf86f764} },
/**/                  {{0xdee8421b, 0xbfa514c3} } },
/**/                 {{{0x00000000, 0x3fdc8000} },
/**/                  {{0x5422058b, 0x3fdad00f} },
/**/                  {{0x3891d2e8, 0x3c7fc4c3} },
/**/                  {{0x46de51cf, 0x3feab455} },
/**/                  {{0xdbc38cc9, 0xbc5b834a} },
/**/                  {{0x844a38eb, 0xbfd3d906} },
/**/                  {{0xbc44eee8, 0x3c6198e5} },
/**/                  {{0x5993cade, 0xbfb416ed} },
/**/                  {{0xfa289b6c, 0xbc235ccb} },
/**/                  {{0x60e2a3af, 0x3fc62997} },
/**/                  {{0xcf7bda0e, 0xbc69a660} },
/**/                  {{0x33612b72, 0xbfb04bd3} },
/**/                  {{0xcf62bcd9, 0xbfad2210} },
/**/                  {{0x603bfc37, 0x3fb2fe5e} },
/**/                  {{0xa9bce7ec, 0xbf89e1ba} },
/**/                  {{0xb83029d5, 0xbfa461a9} } },
/**/                 {{{0x00000000, 0x3fdcc000} },
/**/                  {{0x20ae9344, 0x3fdb0564} },
/**/                  {{0x46363455, 0xbc793139} },
/**/                  {{0xcde0631f, 0x3feaa074} },
/**/                  {{0x143fe6d4, 0x3c84b49a} },
/**/                  {{0x627b115b, 0xbfd3e7d5} },
/**/                  {{0x332989c0, 0x3c77a502} },
/**/                  {{0xb589513f, 0xbfb36644} },
/**/                  {{0x105eec96, 0x3c3abdc9} },
/**/                  {{0xdd12e0be, 0x3fc6006d} },
/**/                  {{0x5d67cb35, 0xbc4f0281} },
/**/                  {{0x4238ba83, 0xbfb0a1ab} },
/**/                  {{0x73889526, 0xbfac18e3} },
/**/                  {{0xfde6351a, 0x3fb2e311} },
/**/                  {{0xc256833f, 0xbf8cb2d2} },
/**/                  {{0xf73e36f0, 0xbfa3adca} } },
/**/                 {{{0x00000000, 0x3fdd0000} },
/**/                  {{0x1da65c6c, 0x3fdb3a91} },
/**/                  {{0xb1ca5040, 0x3c7ae187} },
/**/                  {{0xc81a2254, 0x3fea8c85} },
/**/                  {{0x8d67728b, 0xbc83c191} },
/**/                  {{0x3e8218e0, 0xbfd3f620} },
/**/                  {{0x52bd43ef, 0xbc72bf32} },
/**/                  {{0xadb5f398, 0xbfb2b6e8} },
/**/                  {{0x6b74d451, 0x3c340287} },
/**/                  {{0x9d9e25fc, 0x3fc5d671} },
/**/                  {{0x518d7a71, 0x3c639669} },
/**/                  {{0x19cc29a0, 0xbfb0f46a} },
/**/                  {{0xc1a69750, 0xbfab1147} },
/**/                  {{0x2c826e6b, 0x3fb2c501} },
/**/                  {{0xcbc1b186, 0xbf8f6a95} },
/**/                  {{0x2de89811, 0xbfa2f96d} } },
/**/                 {{{0x00000000, 0x3fdd4000} },
/**/                  {{0x2e737efc, 0x3fdb6f96} },
/**/                  {{0x64981e71, 0xbc5ca534} },
/**/                  {{0xb9102ddc, 0x3fea7888} },
/**/                  {{0x3c46d7d5, 0xbc7791b2} },
/**/                  {{0x1444efb5, 0xbfd403e8} },
/**/                  {{0x4f3d22a6, 0xbc6047c5} },
/**/                  {{0xb90ac1cc, 0xbfb208df} },
/**/                  {{0x2d2115d8, 0x3c4078b1} },
/**/                  {{0x5b7c61a2, 0x3fc5abaa} },
/**/                  {{0x2bd2d19a, 0x3c3eef6a} },
/**/                  {{0xa8850e1a, 0xbfb14414} },
/**/                  {{0xc6580343, 0xbfaa0b63} },
/**/                  {{0x4876cfdf, 0x3fb2a445} },
/**/                  {{0x562d0829, 0xbf91047b} },
/**/                  {{0xbe562a83, 0xbfa244d3} } },
/**/                 {{{0x00000000, 0x3fdd8000} },
/**/                  {{0x378624a5, 0x3fdba473} },
/**/                  {{0xb46e4aff, 0x3c7519a1} },
/**/                  {{0x2348d9a3, 0x3fea647e} },
/**/                  {{0x9156e59f, 0xbc84f6c2} },
/**/                  {{0xe46b4c91, 0xbfd4112d} },
/**/                  {{0x110fe0b7, 0xbc78c11d} },
/**/                  {{0x10e3d572, 0xbfb15c30} },
/**/                  {{0x4427c00b, 0x3c53b45b} },
/**/                  {{0xc2c486ae, 0x3fc5801f} },
/**/                  {{0xc20ced8b, 0xbc49bb5e} },
/**/                  {{0x4cddef65, 0xbfb190b0} },
/**/                  {{0x2ae4bcd0, 0xbfa9075c} },
/**/                  {{0xb69396b9, 0x3fb280f7} },
/**/                  {{0xce179ccb, 0xbf9246f8} },
/**/                  {{0xce6e9b2b, 0xbfa1903f} } },
/**/                 {{{0x00000000, 0x3fddc000} },
/**/                  {{0x1e528192, 0x3fdbd928} },
/**/                  {{0x39af6b66, 0xbc74b154} },
/**/                  {{0x88478403, 0x3fea5066} },
/**/                  {{0xbe71620f, 0xbc85c7e8} },
/**/                  {{0xb430f4ac, 0xbfd41df2} },
/**/                  {{0xe79c7595, 0xbc55db82} },
/**/                  {{0xb173ac76, 0xbfb0b0df} },
/**/                  {{0xe4738d25, 0x3c57f440} },
/**/                  {{0x7199976b, 0x3fc553d9} },
/**/                  {{0x2a872a12, 0x3c54990c} },
/**/                  {{0xd137dd01, 0xbfb1da42} },
/**/                  {{0x350bfdb5, 0xbfa80554} },
/**/                  {{0xdae9e17f, 0x3fb25b31} },
/**/                  {{0xe9e265b4, 0xbf937cc5} },
/**/                  {{0x3d16a202, 0xbfa0dbf0} } },
/**/                 {{{0x00000000, 0x3fde0000} },
/**/                  {{0xc94ec9f0, 0x3fdc0db4} },
/**/                  {{0x70934c34, 0xbc7cc1ce} },
/**/                  {{0x68881898, 0x3fea3c42} },
/**/                  {{0xe5c3bd97, 0x3c8f907f} },
/**/                  {{0x8d38076d, 0xbfd42a37} },
/**/                  {{0x7e19d62d, 0xbc6b8354} },
/**/                  {{0x5a36f1bd, 0xbfb006f4} },
/**/                  {{0xca398c09, 0xbc41701e} },
/**/                  {{0xf7221a2a, 0x3fc526de} },
/**/                  {{0x8041247e, 0xbc211868} },
/**/                  {{0x67b0229a, 0xbfb220d2} },
/**/                  {{0xc74d0c66, 0xbfa7056d} },
/**/                  {{0x0ff472e2, 0x3fb2330d} },
/**/                  {{0x9cb74216, 0xbf94a5e9} },
/**/                  {{0x992b9e1f, 0xbfa02821} } },
/**/                 {{{0x00000000, 0x3fde4000} },
/**/                  {{0x1ff11eb7, 0x3fdc4219} },
/**/                  {{0x434b3eee, 0xbc7b17df} },
/**/                  {{0x437ac09e, 0x3fea2812} },
/**/                  {{0xf9618c21, 0xbc540368} },
/**/                  {{0x7d5ba406, 0xbfd435fd} },
/**/                  {{0x5e0a732a, 0x3c75605b} },
/**/                  {{0x1ce0c104, 0xbfaebce7} },
/**/                  {{0xd4eb3297, 0xbc446d02} },
/**/                  {{0xd289f60b, 0x3fc4f937} },
/**/                  {{0xe736fa8b, 0x3c5b88b7} },
/**/                  {{0xa5f78db4, 0xbfb26465} },
/**/                  {{0x61a972db, 0xbfa607c9} },
/**/                  {{0x9e13b088, 0x3fb208a2} },
/**/                  {{0x06c33653, 0xbf95c26f} },
/**/                  {{0x346237b1, 0xbf9eea1c} } },
/**/                 {{{0x00000000, 0x3fde8000} },
/**/                  {{0x0aad71f9, 0x3fdc7655} },
/**/                  {{0xff7043e4, 0xbc774b8b} },
/**/                  {{0x977fc070, 0x3fea13d6} },
/**/                  {{0xd9440881, 0xbc86c451} },
/**/                  {{0x9682eee2, 0xbfd44145} },
/**/                  {{0xb13901b4, 0x3c74156f} },
/**/                  {{0x2b58de73, 0xbfad6ec5} },
/**/                  {{0xdf653988, 0x3c2ced26} },
/**/                  {{0x720eb232, 0x3fc4caeb} },
/**/                  {{0x92f3f809, 0x3c614246} },
/**/                  {{0x812caa81, 0xbfb2a503} },
/**/                  {{0x22dc20a7, 0xbfa50c86} },
/**/                  {{0xb35de59d, 0x3fb1dc0b} },
/**/                  {{0x4adc8c38, 0xbf96d265} },
/**/                  {{0x35444e0c, 0xbf9d85db} } },
/**/                 {{{0x00000000, 0x3fdec000} },
/**/                  {{0x72f3631b, 0x3fdcaa68} },
/**/                  {{0x81636f48, 0x3c295067} },
/**/                  {{0xe1e381db, 0x3fe9ff8f} },
/**/                  {{0x00701e1c, 0xbc6fffe6} },
/**/                  {{0xee747cac, 0xbfd44c10} },
/**/                  {{0xced401ad, 0xbc7a7f22} },
/**/                  {{0xf898de26, 0xbfac238c} },
/**/                  {{0xdaa7d32f, 0x3c1eb191} },
/**/                  {{0x32160e42, 0x3fc49c01} },
/**/                  {{0x03d0023c, 0x3c649f02} },
/**/                  {{0x49ba4fb7, 0xbfb2e2b3} },
/**/                  {{0xca00d6c7, 0xbfa413c1} },
/**/                  {{0x5bc495cf, 0x3fb1ad61} },
/**/                  {{0x63d0ff69, 0xbf97d5df} },
/**/                  {{0x27af7010, 0xbf9c23eb} } },
/**/                 {{{0x00000000, 0x3fdf0000} },
/**/                  {{0x432c1351, 0x3fdcde53} },
/**/                  {{0x4418f1ad, 0xbc7a2cfa} },
/**/                  {{0x9edacacc, 0x3fe9eb3e} },
/**/                  {{0x87d23ca5, 0xbc8942c5} },
/**/                  {{0x9eaa285d, 0xbfd45660} },
/**/                  {{0x52cf85b4, 0x3c4fe8e6} },
/**/                  {{0x28319af3, 0xbfaadb48} },
/**/                  {{0x31b456b0, 0xbc207b46} },
/**/                  {{0x5c4ee7c2, 0x3fc46c80} },
/**/                  {{0xb4443c76, 0x3c4bdfc1} },
/**/                  {{0xa73bc33f, 0xbfb31d7c} },
/**/                  {{0xb8a731f5, 0xbfa31d98} },
/**/                  {{0x798f7481, 0x3fb17cbc} },
/**/                  {{0xf977e9ca, 0xbf98ccf3} },
/**/                  {{0x36ea1578, 0xbf9ac4b2} } },
/**/                 {{{0x00000000, 0x3fdf4000} },
/**/                  {{0x66b7f2ad, 0x3fdd1215} },
/**/                  {{0x35886c30, 0x3c7be678} },
/**/                  {{0x497f1fed, 0x3fe9d6e3} },
/**/                  {{0x9a35c454, 0xbc8ec056} },
/**/                  {{0xc4255988, 0xbfd46035} },
/**/                  {{0x7144427c, 0x3c7ddb7b} },
/**/                  {{0xe9b44acd, 0xbfa995ff} },
/**/                  {{0xb529cf65, 0x3c3c9d56} },
/**/                  {{0x26dc5cda, 0x3fc43c70} },
/**/                  {{0xfde6cd82, 0x3c6d6ee6} },
/**/                  {{0x9467b39a, 0xbfb35567} },
/**/                  {{0xf54ca1ba, 0xbfa22a25} },
/**/                  {{0xbe2d5d2d, 0x3fb14a35} },
/**/                  {{0x35a34e74, 0xbf99b7bd} },
/**/                  {{0xc4948489, 0xbf996891} } },
/**/                 {{{0x00000000, 0x3fdf8000} },
/**/                  {{0xc9ec862b, 0x3fdd45ae} },
/**/                  {{0x163ef92d, 0x3c689421} },
/**/                  {{0x5bcb52c7, 0x3fe9c27e} },
/**/                  {{0xf148a350, 0xbc892d91} },
/**/                  {{0x7f43bff0, 0xbfd46991} },
/**/                  {{0x8da13c27, 0xbc738b23} },
/**/                  {{0xf9f19dcd, 0xbfa853bc} },
/**/                  {{0x2433c5cf, 0x3c2ea7a9} },
/**/                  {{0xb38b19e0, 0x3fc40bd7} },
/**/                  {{0x1c2a2863, 0xbc5d466e} },
/**/                  {{0x5b0333a7, 0xbfb38a7c} },
/**/                  {{0x2e3896d7, 0xbfa13983} },
/**/                  {{0xa35b7545, 0x3fb115e5} },
/**/                  {{0x99098556, 0xbf9a9658} },
/**/                  {{0x693ac59e, 0xbf980fe6} } },
/**/                 {{{0x00000000, 0x3fdfc000} },
/**/                  {{0x5a1226f5, 0x3fdd791f} },
/**/                  {{0xa5b64a76, 0xbc64017e} },
/**/                  {{0x4e983ae9, 0x3fe9ae10} },
/**/                  {{0x52b783d7, 0xbc8d45ed} },
/**/                  {{0xf394891f, 0xbfd47274} },
/**/                  {{0x22e08713, 0xbc7cd478} },
/**/                  {{0xa445379d, 0xbfa71487} },
/**/                  {{0x831d87b7, 0x3c1569aa} },
/**/                  {{0x0f10bc36, 0x3fc3dabe} },
/**/                  {{0x1cb9bbe6, 0x3bd8df2b} },
/**/                  {{0x8fddd862, 0xbfb3bcc3} },
/**/                  {{0xbcb632d9, 0xbfa04bc8} },
/**/                  {{0x64a26d77, 0x3fb0dfe4} },
/**/                  {{0xd04027d1, 0xbf9b68e6} },
/**/                  {{0xf792c5d9, 0xbf96bb07} } },
/**/                 {{{0x00000000, 0x3fe00000} },
/**/                  {{0x0561bb4f, 0x3fddac67} },
/**/                  {{0x222f65e2, 0x3c7a2b7f} },
/**/                  {{0x9999999a, 0x3fe99999} },
/**/                  {{0x9999999a, 0xbc899999} },
/**/                  {{0x47ae147b, 0xbfd47ae1} },
/**/                  {{0xeb851eb8, 0x3c5eb851} },
/**/                  {{0xc3ece2a5, 0xbfa5d867} },
/**/                  {{0xd7b900af, 0xbc3a485c} },
/**/                  {{0x30553261, 0x3fc3a92a} },
/**/                  {{0x94467382, 0x3c6f06f6} },
/**/                  {{0x0ed80a18, 0xbfb3ec46} },
/**/                  {{0x514d88d8, 0xbf9ec21b} },
/**/                  {{0xf929a833, 0x3fb0a849} },
/**/                  {{0x88dfb80c, 0xbf9c2f8b} },
/**/                  {{0x8245bf09, 0xbf956a49} } },
/**/                 {{{0x00000000, 0x3fe02000} },
/**/                  {{0xbb026974, 0x3fdddf85} },
/**/                  {{0x0c0a1226, 0x3c643bbb} },
/**/                  {{0xb35b2797, 0x3fe9851a} },
/**/                  {{0x18a8fead, 0x3c89cd14} },
/**/                  {{0xa5042a2d, 0xbfd482d7} },
/**/                  {{0xa8224d16, 0x3c0dbc04} },
/**/                  {{0xc56ade02, 0xbfa49f64} },
/**/                  {{0x47da7eea, 0x3c451e52} },
/**/                  {{0xf7c5fe7d, 0x3fc37722} },
/**/                  {{0xd22c4b5c, 0xbc5165be} },
/**/                  {{0xf6f48c5d, 0xbfb4190c} },
/**/                  {{0x58d0c132, 0xbf9cf2cf} },
/**/                  {{0x0ddfdd74, 0x3fb06f2e} },
/**/                  {{0x46e65336, 0xbf9cea6d} },
/**/                  {{0x6423af3b, 0xbf941df9} } },
/**/                 {{{0x00000000, 0x3fe04000} },
/**/                  {{0x6b0744b0, 0x3fde127b} },
/**/                  {{0x6398d4ab, 0xbc52b098} },
/**/                  {{0x113dcc5a, 0x3fe97094} },
/**/                  {{0x4de8c575, 0xbc842780} },
/**/                  {{0x37beb8e5, 0xbfd48a59} },
/**/                  {{0x9dc7541e, 0xbc601dd2} },
/**/                  {{0xa7f2a8fe, 0xbfa36985} },
/**/                  {{0x7437d42d, 0xbc45e414} },
/**/                  {{0x2eb33dd6, 0x3fc344af} },
/**/                  {{0xe3a3193c, 0xbc6d66e9} },
/**/                  {{0xa6763232, 0xbfb44321} },
/**/                  {{0x7217dfc9, 0xbf9b29d6} },
/**/                  {{0xfff8a866, 0x3fb034a7} },
/**/                  {{0x3a6e931d, 0xbf9d99b5} },
/**/                  {{0x4a9f7e19, 0xbf92d661} } },
/**/                 {{{0x00000000, 0x3fe06000} },
/**/                  {{0x066cf51a, 0x3fde4548} },
/**/                  {{0x12ce98f2, 0x3c43a3aa} },
/**/                  {{0x2774fe53, 0x3fe95c06} },
/**/                  {{0x3b851412, 0x3c810dfd} },
/**/                  {{0x2e911e43, 0xbfd49167} },
/**/                  {{0x09466fcd, 0xbc7f6506} },
/**/                  {{0xfedfb0c1, 0xbfa236d0} },
/**/                  {{0x79cb63a9, 0xbc3f6870} },
/**/                  {{0x86b6561c, 0x3fc311d5} },
/**/                  {{0x9543fc9a, 0x3c561982} },
/**/                  {{0xb70aa5a7, 0xbfb46a8d} },
/**/                  {{0xf5ac1efc, 0xbf996756} },
/**/                  {{0xaf7c84b3, 0x3faff19d} },
/**/                  {{0x15ce96b8, 0xbf9e3d8f} },
/**/                  {{0x42726021, 0xbf9193c6} } },
/**/                 {{{0x00000000, 0x3fe08000} },
/**/                  {{0x7f175a34, 0x3fde77eb} },
/**/                  {{0xc1bf3435, 0x3c70e53d} },
/**/                  {{0x69044ba4, 0x3fe94771} },
/**/                  {{0x92d5fbc1, 0xbc7d53e2} },
/**/                  {{0xba91fd89, 0xbfd49802} },
/**/                  {{0xc3c8c4f3, 0x3c71963e} },
/**/                  {{0xf33546d5, 0xbfa1074c} },
/**/                  {{0xc71ad288, 0x3c4bc296} },
/**/                  {{0x99222665, 0x3fc2de9c} },
/**/                  {{0x28dadb64, 0x3c6e4a10} },
/**/                  {{0xfa031cb1, 0xbfb48f5a} },
/**/                  {{0xbc0c6420, 0xbf97ab74} },
/**/                  {{0x876d0f75, 0x3faf7772} },
/**/                  {{0xe431fc96, 0xbf9ed628} },
/**/                  {{0xc64515ec, 0xbf905668} } },
/**/                 {{{0x00000000, 0x3fe0a000} },
/**/                  {{0xc7cf28c4, 0x3fdeaa65} },
/**/                  {{0xeca3bf05, 0x3c62fb2c} },
/**/                  {{0x47bd0aaa, 0x3fe932d6} },
/**/                  {{0x697b6e3c, 0x3c6bdfec} },
/**/                  {{0x0f13a7e8, 0xbfd49e2d} },
/**/                  {{0x20412940, 0x3c6198c5} },
/**/                  {{0x8a4e92df, 0xbf9fb5fe} },
/**/                  {{0x6309a51a, 0xbc3cbb58} },
/**/                  {{0xe67c9829, 0x3fc2ab0a} },
/**/                  {{0x06a4c4ef, 0xbc647643} },
/**/                  {{0x749bc711, 0xbfb4b193} },
/**/                  {{0x27bef265, 0xbf95f651} },
/**/                  {{0x28347ebf, 0x3faefafb} },
/**/                  {{0xe0c06e2f, 0xbf9f63b2} },
/**/                  {{0x9e7b9dd7, 0xbf8e3d09} } },
/**/                 {{{0x00000000, 0x3fe0c000} },
/**/                  {{0xd43f8435, 0x3fdedcb6} },
/**/                  {{0x330884e4, 0xbc5fc976} },
/**/                  {{0x343c31e5, 0x3fe91e35} },
/**/                  {{0x9bb96799, 0xbc8fd46f} },
/**/                  {{0x617d19a1, 0xbfd4a3e7} },
/**/                  {{0xea58b250, 0xbc7d7303} },
/**/                  {{0x9b55d156, 0xbf9d63da} },
/**/                  {{0xd5b4cc6c, 0xbc14bf72} },
/**/                  {{0xd6016a7c, 0x3fc27726} },
/**/                  {{0x435ec4b4, 0x3c4eba22} },
/**/                  {{0x5c52b3c6, 0xbfb4d141} },
/**/                  {{0x2fdd9fbd, 0xbf94480b} },
/**/                  {{0x6d3af4b6, 0x3fae7c63} },
/**/                  {{0x4e61315b, 0xbf9fe65f} },
/**/                  {{0xcea37283, 0xbf8bd8a3} } },
/**/                 {{{0x00000000, 0x3fe0e000} },
/**/                  {{0x98f393d0, 0x3fdf0ede} },
/**/                  {{0x87cb1894, 0xbc72f40a} },
/**/                  {{0x9de85688, 0x3fe9098e} },
/**/                  {{0xa3791e64, 0xbc7c2de1} },
/**/                  {{0xe9238ed7, 0xbfd4a932} },
/**/                  {{0x28864386, 0xbc67a1bb} },
/**/                  {{0x001dec68, 0xbf9b1838} },
/**/                  {{0x8f0ffbdd, 0xbc33ee0e} },
/**/                  {{0xb52e1005, 0x3fc242f6} },
/**/                  {{0x371fd2c1, 0xbc5476eb} },
/**/                  {{0x134edf2d, 0xbfb4ee6f} },
/**/                  {{0x6b13becc, 0xbf92a0bf} },
/**/                  {{0x650f859c, 0x3fadfbd6} },
/**/                  {{0x281586f4, 0xbfa02f31} },
/**/                  {{0x7a73449e, 0xbf898006} } },
/**/                 {{{0x00000000, 0x3fe10000} },
/**/                  {{0x0b541418, 0x3fdf40dd} },
/**/                  {{0xdc382a23, 0xbc6a3992} },
/**/                  {{0xf2efd135, 0x3fe8f4e2} },
/**/                  {{0xd4218911, 0xbc74c3c0} },
/**/                  {{0xdf24b2d1, 0xbfd4ae10} },
/**/                  {{0x79d0ac37, 0x3c713b12} },
/**/                  {{0xd7365f3f, 0xbf98d31f} },
/**/                  {{0x62531dc5, 0xbc18bf3b} },
/**/                  {{0xb7567664, 0x3fc20e80} },
/**/                  {{0xd450197f, 0xbc54a699} },
/**/                  {{0x24d80ddd, 0xbfb50927} },
/**/                  {{0x1b0516ab, 0xbf910088} },
/**/                  {{0x4a356567, 0x3fad797e} },
/**/                  {{0xe14758ed, 0xbfa065f8} },
/**/                  {{0x73d2f6bb, 0xbf87338f} } },
/**/                 {{{0x00000000, 0x3fe12000} },
/**/                  {{0x21a4e495, 0x3fdf72b2} },
/**/                  {{0x0f7eb740, 0x3c5489c2} },
/**/                  {{0xa0470831, 0x3fe8e032} },
/**/                  {{0xe75570cd, 0xbc8c154a} },
/**/                  {{0x7e416c35, 0xbfd4b282} },
/**/                  {{0x60646afd, 0xbc7f1837} },
/**/                  {{0x7a6bec27, 0xbf96949a} },
/**/                  {{0xe6b77ba9, 0x3c38238f} },
/**/                  {{0xf5428c61, 0x3fc1d9ca} },
/**/                  {{0xcd7881aa, 0x3c6a968d} },
/**/                  {{0x41e00b6e, 0xbfb52174} },
/**/                  {{0x702ad3de, 0xbf8ecefa} },
/**/                  {{0x7c8ae0dc, 0x3facf584} },
/**/                  {{0x8aa44fa8, 0xbfa097a2} },
/**/                  {{0x2ed63408, 0xbf84f394} } },
/**/                 {{{0x00000000, 0x3fe14000} },
/**/                  {{0xd3029259, 0x3fdfa45d} },
/**/                  {{0xdc28d8b5, 0xbc7ca563} },
/**/                  {{0x11a6de80, 0x3fe8cb7e} },
/**/                  {{0xac22b8f8, 0x3c610be6} },
/**/                  {{0x02b9488a, 0xbfd4b689} },
/**/                  {{0xaf91d442, 0x3c5ea0bd} },
/**/                  {{0x821fd17e, 0xbf945caf} },
/**/                  {{0x0e51a049, 0x3c38e464} },
/**/                  {{0x6cd45aad, 0x3fc1a4db} },
/**/                  {{0xf4200d5e, 0x3c2288e0} },
/**/                  {{0x3d9dd7c4, 0xbfb53761} },
/**/                  {{0xfb107457, 0xbf8bab68} },
/**/                  {{0x7b46ebd1, 0x3fac7011} },
/**/                  {{0x93134a8f, 0xbfa0c44a} },
/**/                  {{0xf1fa4589, 0xbf82c061} } },
/**/                 {{{0x00000000, 0x3fe16000} },
/**/                  {{0x175fdf83, 0x3fdfd5e0} },
/**/                  {{0x1ec49b15, 0x3c63a87b} },
/**/                  {{0xb18b4749, 0x3fe8b6c5} },
/**/                  {{0xb7d58c0a, 0xbc5fabb8} },
/**/                  {{0xaa26890c, 0xbfd4ba25} },
/**/                  {{0x0ef9b688, 0x3c50e395} },
/**/                  {{0xc8a9b4c0, 0xbf922b65} },
/**/                  {{0xd319146f, 0x3c2835ee} },
/**/                  {{0x00b681bd, 0x3fc16fb8} },
/**/                  {{0x279133b0, 0x3c1df633} },
/**/                  {{0x0a3b410c, 0xbfb54af9} },
/**/                  {{0xebe14682, 0xbf889682} },
/**/                  {{0xdf89e086, 0x3fabe94c} },
/**/                  {{0x0e55a6f8, 0xbfa0ec0e} },
/**/                  {{0x08af68f3, 0xbf809a3e} } },
/**/                 {{{0x00000000, 0x3fe18000} },
/**/                  {{0x73c1a40c, 0x3fe0039c} },
/**/                  {{0x49c9d593, 0xbc8b32c9} },
/**/                  {{0xe931fcd3, 0x3fe8a209} },
/**/                  {{0x8e68c94c, 0x3c6cb8f0} },
/**/                  {{0xb35ad2d8, 0xbfd4bd59} },
/**/                  {{0xcaa606b4, 0xbc61ac1a} },
/**/                  {{0x6dc339ef, 0xbf9000c3} },
/**/                  {{0xaeaeaa73, 0x3c2c62e2} },
/**/                  {{0x7812ee2d, 0x3fc13a66} },
/**/                  {{0x948ffe5b, 0x3c6a8cc2} },
/**/                  {{0xb5955c9c, 0xbfb55c46} },
/**/                  {{0x0fd2b503, 0xbf85906b} },
/**/                  {{0x577de2da, 0x3fab615d} },
/**/                  {{0xa34d31ec, 0xbfa10f0a} },
/**/                  {{0xefe48ad0, 0xbf7d02cb} } },
/**/                 {{{0x00000000, 0x3fe1a000} },
/**/                  {{0x1e82422d, 0x3fe01c34} },
/**/                  {{0xfcca90ee, 0x3c83db44} },
/**/                  {{0x20995a88, 0x3fe88d4b} },
/**/                  {{0x1e42e681, 0x3c802777} },
/**/                  {{0x5e3c840f, 0xbfd4c026} },
/**/                  {{0x3800420d, 0x3c7d7c65} },
/**/                  {{0xb3f88703, 0xbf8bb99b} },
/**/                  {{0x4bf63e82, 0x3c1f62ec} },
/**/                  {{0x7e5193ee, 0x3fc104ec} },
/**/                  {{0xbae4e07d, 0xbc27771e} },
/**/                  {{0x66104515, 0xbfb56b55} },
/**/                  {{0x061a20d1, 0xbf829940} },
/**/                  {{0xa20334d9, 0x3faad868} },
/**/                  {{0x7aba8ee6, 0xbfa12d5e} },
/**/                  {{0x69774b8d, 0xbf78ec1f} } },
/**/                 {{{0x00000000, 0x3fe1c000} },
/**/                  {{0x09250488, 0x3fe034b7} },
/**/                  {{0x8d855410, 0x3c78f9b3} },
/**/                  {{0xbe7f594b, 0x3fe87889} },
/**/                  {{0xc826e7a3, 0xbc7530e1} },
/**/                  {{0xeba4af80, 0xbfd4c28c} },
/**/                  {{0xe6a95faa, 0x3c7104a9} },
/**/                  {{0x846dba10, 0xbf877f13} },
/**/                  {{0x4abd0010, 0x3c2bc924} },
/**/                  {{0xa2deff9f, 0x3fc0cf4f} },
/**/                  {{0xa013c015, 0xbc67d17e} },
/**/                  {{0x577e7899, 0xbfb57830} },
/**/                  {{0xb49ea16d, 0xbf7f6238} },
/**/                  {{0x8ae4a926, 0x3faa4e93} },
/**/                  {{0x2e77f633, 0xbfa14728} },
/**/                  {{0xb81c893e, 0xbf74f0d3} } },
/**/                 {{{0x00000000, 0x3fe1e000} },
/**/                  {{0x314342e6, 0x3fe04d25} },
/**/                  {{0x6442c767, 0xbc81c863} },
/**/                  {{0x2860ad7e, 0x3fe863c6} },
/**/                  {{0x137a2d8f, 0xbc81dcb2} },
/**/                  {{0x9d3dc03a, 0xbfd4c48e} },
/**/                  {{0x197b1db9, 0xbc7d92af} },
/**/                  {{0x5653b1a7, 0xbf8351f6} },
/**/                  {{0x2127dea7, 0xbbe368b4} },
/**/                  {{0x58fa8ca4, 0x3fc09995} },
/**/                  {{0x530429e5, 0xbc446391} },
/**/                  {{0xd81c26eb, 0xbfb582e2} },
/**/                  {{0x3e63c109, 0xbf79b02d} },
/**/                  {{0xe7904294, 0x3fa9c401} },
/**/                  {{0xb933b0f3, 0xbfa15c86} },
/**/                  {{0xd8d860e1, 0xbf711137} } },
/**/                 {{{0x00000000, 0x3fe20000} },
/**/                  {{0x94db30d0, 0x3fe0657e} },
/**/                  {{0x5f6349e6, 0xbc7d5b49} },
/**/                  {{0xc2780614, 0x3fe84f00} },
/**/                  {{0xff3d87fa, 0xbc7fe7b0} },
/**/                  {{0xb562c625, 0xbfd4c62c} },
/**/                  {{0xa78e848c, 0x3c77b2c3} },
/**/                  {{0xb3a4bcb7, 0xbf7e6495} },
/**/                  {{0xe3f2b0a5, 0x3c14eb89} },
/**/                  {{0xf78c0dc4, 0x3fc063c2} },
/**/                  {{0x7539dc13, 0xbc6badf0} },
/**/                  {{0x459eb443, 0xbfb58b78} },
/**/                  {{0x1386e6b4, 0xbf741c83} },
/**/                  {{0x944ff706, 0x3fa938d6} },
/**/                  {{0x66ad4037, 0xbfa16d99} },
/**/                  {{0x01fc736a, 0xbf6a9b1a} } },
/**/                 {{{0x00000000, 0x3fe22000} },
/**/                  {{0x324e9b38, 0x3fe07dc3} },
/**/                  {{0xe04450ac, 0x3c7b70c9} },
/**/                  {{0xefbd6bfe, 0x3fe83a39} },
/**/                  {{0x21f5de26, 0xbc7b2885} },
/**/                  {{0x76ff6c9e, 0xbfd4c768} },
/**/                  {{0xdebc1603, 0x3c56a2c0} },
/**/                  {{0xd9cccfd7, 0xbf76402c} },
/**/                  {{0x4e9786c1, 0xbc1b39c0} },
/**/                  {{0xb900b57a, 0x3fc02ddd} },
/**/                  {{0xea88a215, 0x3c45d916} },
/**/                  {{0x0a58ab40, 0xbfb591fc} },
/**/                  {{0x32a37ac9, 0xbf6d4eb0} },
/**/                  {{0x71fe75f8, 0x3fa8ad33} },
/**/                  {{0xc477a855, 0xbfa17a7f} },
/**/                  {{0x2b035011, 0xbf634c0e} } },
/**/                 {{{0x00000000, 0x3fe24000} },
/**/                  {{0x0861a590, 0x3fe095f3} },
/**/                  {{0x0a15a9f3, 0xbc7121b2} },
/**/                  {{0x11e5c14d, 0x3fe82572} },
/**/                  {{0xacd80b09, 0xbc7df9fc} },
/**/                  {{0x25709bff, 0xbfd4c843} },
/**/                  {{0x1790f484, 0x3c7a9ef6} },
/**/                  {{0x8a0def34, 0xbf6c6d74} },
/**/                  {{0x2a8142d7, 0xbc051e57} },
/**/                  {{0x765e156b, 0x3fbfefd5} },
/**/                  {{0xf0e29c9e, 0xbc3e6048} },
/**/                  {{0x9a724e28, 0xbfb59679} },
/**/                  {{0xcf13e192, 0xbf62a185} },
/**/                  {{0x6433c13f, 0x3fa82139} },
/**/                  {{0x9342e95d, 0xbfa18359} },
/**/                  {{0x8f974107, 0xbf586b34} } },
/**/                 {{{0x00000000, 0x3fe26000} },
/**/                  {{0x1639866c, 0x3fe0ae0e} },
/**/                  {{0xf2de445a, 0x3c7075ab} },
/**/                  {{0x89625f5d, 0x3fe810a9} },
/**/                  {{0x0fcf7262, 0xbc8e4bea} },
/**/                  {{0x0465c69b, 0xbfd4c8be} },
/**/                  {{0xd7f7f89c, 0x3c462ef4} },
/**/                  {{0x4de612d5, 0xbf59210e} },
/**/                  {{0xba53898d, 0xbbf43659} },
/**/                  {{0xfe836c69, 0x3fbf83dd} },
/**/                  {{0x27f5499a, 0xbc36cb56} },
/**/                  {{0x7136edda, 0xbfb598fc} },
/**/                  {{0x00013fb7, 0xbf50634c} },
/**/                  {{0x4fe557c2, 0x3fa79508} },
/**/                  {{0xb8ae41dc, 0xbfa18846} },
/**/                  {{0xe36bd239, 0xbf455fce} } },
/**/                 {{{0x00000000, 0x3fe28000} },
/**/                  {{0x5b5b43da, 0x3fe0c614} },
/**/                  {{0x13b5404f, 0x3c5974fa} },
/**/                  {{0xb560d35c, 0x3fe7fbe0} },
/**/                  {{0xae5a0887, 0xbc84f066} },
/**/                  {{0x57c2e1cb, 0xbfd4c8da} },
/**/                  {{0xe0a3774c, 0x3c73de0e} },
/**/                  {{0x61c69f3c, 0x3f38b341} },
/**/                  {{0x7b200371, 0x3bd7b2e2} },
/**/                  {{0xd351e8ed, 0x3fbf17de} },
/**/                  {{0x650c5a9c, 0x3c5bce38} },
/**/                  {{0x0e77234c, 0xbfb59990} },
/**/                  {{0x99f594ee, 0x3f3006ef} },
/**/                  {{0x1a75a6cc, 0x3fa708bf} },
/**/                  {{0x31a471d5, 0xbfa18967} },
/**/                  {{0x59bf0521, 0x3f24cc7e} } },
/**/                 {{{0x00000000, 0x3fe2a000} },
/**/                  {{0xd7aa6f7d, 0x3fe0de05} },
/**/                  {{0xb1c529ab, 0xbc783684} },
/**/                  {{0xf3cab884, 0x3fe7e717} },
/**/                  {{0x3b1fa4c7, 0x3c7e1b21} },
/**/                  {{0x63830b4b, 0xbfd4c899} },
/**/                  {{0xae3ffeff, 0xbc7b6e32} },
/**/                  {{0xfc06cc4f, 0x3f628757} },
/**/                  {{0x56f01f66, 0xbbb4c155} },
/**/                  {{0x8424efd8, 0x3fbeabe1} },
/**/                  {{0x6e5604ea, 0x3bdf5129} },
/**/                  {{0xf3ffff64, 0xbfb5983f} },
/**/                  {{0x1f564189, 0x3f57ec04} },
/**/                  {{0xa92e6e68, 0x3fa67c7b} },
/**/                  {{0x0542d0ff, 0xbfa186db} },
/**/                  {{0x11a37bde, 0x3f4ee247} } },
/**/                 {{{0x00000000, 0x3fe2c000} },
/**/                  {{0x8b67e295, 0x3fe0f5e2} },
/**/                  {{0x7ec990d0, 0x3be311b1} },
/**/                  {{0xa145af59, 0x3fe7d24f} },
/**/                  {{0xabdb623b, 0xbc83c6d1} },
/**/                  {{0x6b9bdb30, 0xbfd4c7fc} },
/**/                  {{0xd3bbb84b, 0x3c7c2fae} },
/**/                  {{0xc729b366, 0x3f70e125} },
/**/                  {{0x7a19993c, 0x3c1291fb} },
/**/                  {{0x66cf0dd8, 0x3fbe3fef} },
/**/                  {{0xcd5e7640, 0xbc5428b7} },
/**/                  {{0xa3273c21, 0xbfb59517} },
/**/                  {{0x36891acb, 0x3f65adcf} },
/**/                  {{0xe121c017, 0x3fa5f05a} },
/**/                  {{0x384bad65, 0xbfa180c2} },
/**/                  {{0xd31e02a7, 0x3f5bd6f1} } },
/**/                 {{{0x00000000, 0x3fe2e000} },
/**/                  {{0x77307a0d, 0x3fe10daa} },
/**/                  {{0xd44c7b05, 0x3c869c33} },
/**/                  {{0x19337139, 0x3fe7bd88} },
/**/                  {{0x00e777ef, 0xbc7fd248} },
/**/                  {{0xb3e16264, 0xbfd4c704} },
/**/                  {{0xd46ed4e3, 0xbc7ed720} },
/**/                  {{0x62c1daf7, 0x3f7863a5} },
/**/                  {{0x30cc82d1, 0x3c155e73} },
/**/                  {{0x97a241da, 0x3fbdd411} },
/**/                  {{0x9ac44edd, 0x3c27a15a} },
/**/                  {{0x9a6c71a6, 0xbfb59022} },
/**/                  {{0xb5534ebe, 0x3f6f285a} },
/**/                  {{0xa76d3cf7, 0x3fa56478} },
/**/                  {{0xc1240db6, 0xbfa1773c} },
/**/                  {{0x3891a70c, 0x3f63e5a1} } },
/**/                 {{{0x00000000, 0x3fe30000} },
/**/                  {{0x9bfbd2a9, 0x3fe1255d} },
/**/                  {{0xe1c0ee35, 0xbc52bdae} },
/**/                  {{0xb5b1ffa1, 0x3fe7a8c1} },
/**/                  {{0x4e005ea3, 0x3c873e4a} },
/**/                  {{0x7fead5b8, 0xbfd4c5b3} },
/**/                  {{0x55abc25a, 0x3c77958e} },
/**/                  {{0x01e4c970, 0x3f7fcb31} },
/**/                  {{0xc5337fda, 0xbc1ad968} },
/**/                  {{0xf983ecf1, 0x3fbd6850} },
/**/                  {{0x02ed6910, 0xbc3e45e6} },
/**/                  {{0x532f49b6, 0xbfb5896c} },
/**/                  {{0xeaefcf7f, 0x3f7432e2} },
/**/                  {{0xe1db38f0, 0x3fa4d8ef} },
/**/                  {{0x7c5c9def, 0xbfa16a6a} },
/**/                  {{0x7b6fe5d0, 0x3f69a742} } },
/**/                 {{{0x00000000, 0x3fe32000} },
/**/                  {{0xfb1b056e, 0x3fe13cfb} },
/**/                  {{0x6fc3ed38, 0x3c83110e} },
/**/                  {{0xcf9bee6c, 0x3fe793fc} },
/**/                  {{0xd8d91b6c, 0xbc8dc7d2} },
/**/                  {{0x12f7e51f, 0xbfd4c40a} },
/**/                  {{0x0d5d686d, 0x3c7d1e10} },
/**/                  {{0x839d28fa, 0x3f838be8} },
/**/                  {{0x52131640, 0x3c13427a} },
/**/                  {{0x360bfed5, 0x3fbcfcb6} },
/**/                  {{0xa36f599f, 0xbc5e3cb4} },
/**/                  {{0x3f7aa463, 0xbfb58100} },
/**/                  {{0xb76f2bc0, 0x3f78b31e} },
/**/                  {{0x77dd6b80, 0x3fa44dda} },
/**/                  {{0x21c53ca9, 0xbfa15a6b} },
/**/                  {{0x6cd99ed4, 0x3f6f30a7} } },
/**/                 {{{0x00000000, 0x3fe34000} },
/**/                  {{0x9637646a, 0x3fe15485} },
/**/                  {{0x548bf3c3, 0xbc84ba7c} },
/**/                  {{0xbe88c85e, 0x3fe77f39} },
/**/                  {{0x9b6750c8, 0xbc6a983f} },
/**/                  {{0xafd6bee5, 0xbfd4c209} },
/**/                  {{0x5e73e93a, 0x3c7d21ef} },
/**/                  {{0xfc556ca7, 0x3f8724c7} },
/**/                  {{0x42e5673e, 0xbc23cef2} },
/**/                  {{0xbdaef67d, 0x3fbc9149} },
/**/                  {{0x3f04fcdc, 0xbc1e549c} },
/**/                  {{0xc7e4996a, 0xbfb576e9} },
/**/                  {{0xba6ceedb, 0x3f7d14fc} },
/**/                  {{0x53dcdc4a, 0x3fa3c351} },
/**/                  {{0x3a0a53a1, 0xbfa1475e} },
/**/                  {{0x62102619, 0x3f724116} } },
/**/                 {{{0x00000000, 0x3fe36000} },
/**/                  {{0x6f5137e1, 0x3fe16bfa} },
/**/                  {{0xe141bd35, 0x3c79606f} },
/**/                  {{0xd8cd8d65, 0x3fe76a78} },
/**/                  {{0xddf1f71f, 0x3c854a99} },
/**/                  {{0x98cabe40, 0xbfd4bfb3} },
/**/                  {{0x9ef99598, 0xbc61e24d} },
/**/                  {{0x388e6864, 0x3f8ab03d} },
/**/                  {{0xc340d113, 0x3c210541} },
/**/                  {{0xc7f24ec4, 0x3fbc2613} },
/**/                  {{0x0a59af31, 0x3c54042a} },
/**/                  {{0x49833ac1, 0xbfb56b34} },
/**/                  {{0x22f6cd28, 0x3f80ac4f} },
/**/                  {{0x64dac153, 0x3fa3396c} },
/**/                  {{0x14dadf32, 0xbfa13163} },
/**/                  {{0x21aeee27, 0x3f74ce20} } },
/**/                 {{{0x00000000, 0x3fe38000} },
/**/                  {{0x88be7c13, 0x3fe1835a} },
/**/                  {{0xec00c301, 0x3c8c621c} },
/**/                  {{0x737d49ca, 0x3fe755ba} },
/**/                  {{0xd4cb44c6, 0xbc8abaf3} },
/**/                  {{0x0f73c4b3, 0xbfd4bd09} },
/**/                  {{0xa9936e0b, 0x3c3e9ebf} },
/**/                  {{0x8920477f, 0x3f8e2e4f} },
/**/                  {{0x0360e009, 0xbc0889e3} },
/**/                  {{0x53aaefa0, 0x3fbbbb1c} },
/**/                  {{0xa1007b7f, 0xbc5edb26} },
/**/                  {{0x13f5f619, 0xbfb55deb} },
/**/                  {{0xe675741e, 0x3f82bf14} },
/**/                  {{0xa05e0ebf, 0x3fa2b042} },
/**/                  {{0xbf95c5c1, 0xbfa11898} },
/**/                  {{0xe421ee51, 0x3f773faf} } },
/**/                 {{{0x00000000, 0x3fe3a000} },
/**/                  {{0xe5299f9a, 0x3fe19aa5} },
/**/                  {{0x2c58f835, 0xbc8a606c} },
/**/                  {{0xe269c5b3, 0x3fe740fe} },
/**/                  {{0x4c82509c, 0x3c873eff} },
/**/                  {{0x54b63d79, 0xbfd4ba0b} },
/**/                  {{0x75bceeff, 0xbc51d68a} },
/**/                  {{0x9d9b3eb0, 0x3f90cf83} },
/**/                  {{0x68a7ca2f, 0xbc107399} },
/**/                  {{0x27453d35, 0x3fbb506b} },
/**/                  {{0x00bdfedd, 0x3c326b36} },
/**/                  {{0x67836cef, 0xbfb54f19} },
/**/                  {{0x567ed6e8, 0x3f84c2e5} },
/**/                  {{0x04a983e8, 0x3fa227ea} },
/**/                  {{0xfc7ce22f, 0xbfa0fd1d} },
/**/                  {{0x2ffea71d, 0x3f79960c} } },
/**/                 {{{0x00000000, 0x3fe3c000} },
/**/                  {{0x87904285, 0x3fe1b1dc} },
/**/                  {{0x8aef8f29, 0xbc621e8c} },
/**/                  {{0x78244c5a, 0x3fe72c46} },
/**/                  {{0xe664f3a2, 0x3c888c36} },
/**/                  {{0xa8a3ca2f, 0xbfd4b6bb} },
/**/                  {{0x1e1f3e19, 0xbc778793} },
/**/                  {{0xc8a3d8bb, 0x3f928136} },
/**/                  {{0x140daf1c, 0x3c3dc4d8} },
/**/                  {{0xd1165ef3, 0x3fbae607} },
/**/                  {{0x6305876c, 0xbc5fbfaa} },
/**/                  {{0x734b94bd, 0xbfb53eca} },
/**/                  {{0x7c458eb1, 0x3f86b7d8} },
/**/                  {{0x9b360f57, 0x3fa1a077} },
/**/                  {{0x3a6beabd, 0xbfa0df11} },
/**/                  {{0xaf42dc87, 0x3f7bd182} } },
/**/                 {{{0x00000000, 0x3fe3e000} },
/**/                  {{0x7341f64f, 0x3fe1c8fe} },
/**/                  {{0x9d5e792a, 0x3c728bbc} },
/**/                  {{0x85fe8a32, 0x3fe71791} },
/**/                  {{0xe8bbb0d0, 0x3c8f15bd} },
/**/                  {{0x4a6497be, 0xbfd4b31b} },
/**/                  {{0x782968f7, 0x3c737223} },
/**/                  {{0x5e0c3122, 0x3f942c46} },
/**/                  {{0x86422b13, 0xbc33e26a} },
/**/                  {{0xa7b659b8, 0x3fba7bf9} },
/**/                  {{0x25381986, 0xbc3cdf63} },
/**/                  {{0x538deb45, 0xbfb52d09} },
/**/                  {{0xa0c1f425, 0x3f889e08} },
/**/                  {{0x7b6d72e6, 0x3fa119ff} },
/**/                  {{0x8d11287b, 0xbfa0be90} },
/**/                  {{0xbce83ad4, 0x3f7df267} } },
/**/                 {{{0x00000000, 0x3fe40000} },
/**/                  {{0xabdefeb4, 0x3fe1e00b} },
/**/                  {{0x287a668f, 0xbc5928df} },
/**/                  {{0x5c0b8170, 0x3fe702e0} },
/**/                  {{0x5c0b8170, 0x3c7702e0} },
/**/                  {{0x78215a76, 0xbfd4af2b} },
/**/                  {{0xab3a13d8, 0xbc581c2e} },
/**/                  {{0xe9e4a9d0, 0x3f95d0b7} },
/**/                  {{0xebf91fc7, 0xbc3aa02a} },
/**/                  {{0xca629942, 0x3fba1247} },
/**/                  {{0xc245db83, 0xbc46961a} },
/**/                  {{0x100385b4, 0xbfb519e1} },
/**/                  {{0x32616ed8, 0x3f8a7592} },
/**/                  {{0xcda1223a, 0x3fa09494} },
/**/                  {{0xa5a5c251, 0xbfa09bb9} },
/**/                  {{0xf489d8ba, 0x3f7ff915} } },
/**/                 {{{0x00000000, 0x3fe42000} },
/**/                  {{0x3557138a, 0x3fe1f704} },
/**/                  {{0xf6d7dd47, 0x3c76c659} },
/**/                  {{0x4920943e, 0x3fe6ee33} },
/**/                  {{0x61a3a541, 0xbc62723e} },
/**/                  {{0x6eedf042, 0xbfd4aaed} },
/**/                  {{0xe7561ed4, 0x3c5b337a} },
/**/                  {{0x68796803, 0x3f976e91} },
/**/                  {{0x44d1db93, 0xbc0e806f} },
/**/                  {{0x21688625, 0x3fb9a8f9} },
/**/                  {{0xb1ec0554, 0x3c540185} },
/**/                  {{0x9a4cbc61, 0xbfb5055c} },
/**/                  {{0xab0be204, 0x3f8c3e93} },
/**/                  {{0xce3968a1, 0x3fa01049} },
/**/                  {{0xcc2331ba, 0xbfa076a9} },
/**/                  {{0xe220db7e, 0x3f80f2f6} } },
/**/                 {{{0x00000000, 0x3fe44000} },
/**/                  {{0x13e823b2, 0x3fe20de8} },
/**/                  {{0x53ebb744, 0xbc8791d7} },
/**/                  {{0x9ad6a3fd, 0x3fe6d98a} },
/**/                  {{0xc4e69862, 0xbc808110} },
/**/                  {{0x6ab4a79d, 0xbfd4a662} },
/**/                  {{0x9fc1cc2b, 0x3c52ed25} },
/**/                  {{0x42e6dc28, 0x3f9905d9} },
/**/                  {{0xe39b7707, 0xbc228c79} },
/**/                  {{0x5e97c6f4, 0x3fb94014} },
/**/                  {{0xf8779202, 0xbc52b822} },
/**/                  {{0xcc723054, 0xbfb4ef86} },
/**/                  {{0x76852811, 0x3f8df92d} },
/**/                  {{0xa231ee3f, 0x3f9f1a5f} },
/**/                  {{0xd8f34e77, 0xbfa04f7d} },
/**/                  {{0x80706a34, 0x3f81dcaa} } },
/**/                 {{{0x00000000, 0x3fe46000} },
/**/                  {{0x4c1d192a, 0x3fe224b7} },
/**/                  {{0xf88a60c4, 0x3c8d6d3d} },
/**/                  {{0x9d8b44ec, 0x3fe6c4e6} },
/**/                  {{0x4ed04ec2, 0xbc589d5c} },
/**/                  {{0xa6222a08, 0xbfd4a18b} },
/**/                  {{0xd3867dbd, 0xbc66c919} },
/**/                  {{0x4bb5a8a0, 0x3f9a9696} },
/**/                  {{0x927bb5bd, 0x3c36698e} },
/**/                  {{0xfdbbcc76, 0x3fb8d79f} },
/**/                  {{0x4efb71a1, 0x3c2578bd} },
/**/                  {{0x6778e363, 0xbfb4d86a} },
/**/                  {{0xd930230d, 0x3f8fa581} },
/**/                  {{0x8a6221aa, 0x3f9e16ae} },
/**/                  {{0x2f183972, 0xbfa02652} },
/**/                  {{0x3e507f4f, 0x3f82b9db} } },
/**/                 {{{0x00000000, 0x3fe48000} },
/**/                  {{0xe2cc9e6a, 0x3fe23b71} },
/**/                  {{0x9f38224e, 0x3c6c421c} },
/**/                  {{0x9c620595, 0x3fe6b047} },
/**/                  {{0x07d7f0c2, 0x3c8867df} },
/**/                  {{0x5a920887, 0xbfd49c6a} },
/**/                  {{0x37bcc433, 0xbc764547} },
/**/                  {{0xbb7e5931, 0x3f9c20cf} },
/**/                  {{0x4db6bef2, 0xbc3d86f5} },
/**/                  {{0x451c4a5d, 0x3fb86fa2} },
/**/                  {{0x15afb52c, 0xbc475142} },
/**/                  {{0x120917da, 0xbfb4c012} },
/**/                  {{0x6b9c3fad, 0x3f90a1da} },
/**/                  {{0x708543e5, 0x3f9d159f} },
/**/                  {{0x6d929bce, 0xbf9ff685} },
/**/                  {{0xd0361a66, 0x3f838ac0} } },
/**/                 {{{0x00000000, 0x3fe4a000} },
/**/                  {{0xdd17e501, 0x3fe25217} },
/**/                  {{0x8c1b679c, 0x3c856aa8} },
/**/                  {{0xe145c95d, 0x3fe69bad} },
/**/                  {{0x5605046d, 0xbc873257} },
/**/                  {{0xbffbe8a8, 0xbfd496ff} },
/**/                  {{0xc7b45e6f, 0x3c36a5c5} },
/**/                  {{0x2d9556eb, 0x3f9da48d} },
/**/                  {{0x1871a19d, 0x3c3ff0e8} },
/**/                  {{0x46043f42, 0x3fb80821} },
/**/                  {{0xe660cfa1, 0x3c550eec} },
/**/                  {{0x5727a8cb, 0xbfb4a688} },
/**/                  {{0x0e13efbc, 0x3f9169f6} },
/**/                  {{0xb59149dd, 0x3f9c174f} },
/**/                  {{0xb10444dd, 0xbf9f9cd5} },
/**/                  {{0x03e91dd9, 0x3f844f95} } },
/**/                 {{{0x00000000, 0x3fe4c000} },
/**/                  {{0x40696da6, 0x3fe268a9} },
/**/                  {{0xa04c73cc, 0x3c5d1348} },
/**/                  {{0xb4ea3592, 0x3fe68719} },
/**/                  {{0x088ed284, 0xbc7ecf86} },
/**/                  {{0x0ce1507d, 0xbfd4914d} },
/**/                  {{0x4dff2946, 0xbc6410ef} },
/**/                  {{0x9cbf7eb7, 0x3f9f21d6} },
/**/                  {{0xeaaad7e2, 0x3c39bc22} },
/**/                  {{0xdd4f3070, 0x3fb7a122} },
/**/                  {{0x1cfe44af, 0x3c50d950} },
/**/                  {{0xa50188df, 0xbfb48bd7} },
/**/                  {{0x71756204, 0x3f922b27} },
/**/                  {{0x0810a33a, 0x3f9b1bdb} },
/**/                  {{0xf1011313, 0xbf9f3fca} },
/**/                  {{0x8fe0f49b, 0x3f850893} } },
/**/                 {{{0x00000000, 0x3fe4e000} },
/**/                  {{0x1273d1b3, 0x3fe27f26} },
/**/                  {{0x6151dd9f, 0x3c843bf3} },
/**/                  {{0x5ecd3069, 0x3fe6728b} },
/**/                  {{0x539f23ff, 0x3c67417b} },
/**/                  {{0x763c0fe8, 0xbfd48b53} },
/**/                  {{0x6027975c, 0xbc677a1a} },
/**/                  {{0x2ff7dd6a, 0x3fa04c5a} },
/**/                  {{0x496202e8, 0xbc40808e} },
/**/                  {{0xb3fc3f7c, 0x3fb73aac} },
/**/                  {{0x86b114ff, 0x3c4b58cb} },
/**/                  {{0x4bc91249, 0xbfb4700a} },
/**/                  {{0xef2490f8, 0x3f92e582} },
/**/                  {{0x6c875580, 0x3f9a235b} },
/**/                  {{0xe55cd596, 0xbf9edf99} },
/**/                  {{0xe40c5a18, 0x3f85b5f9} } },
/**/                 {{{0x00000000, 0x3fe50000} },
/**/                  {{0x59308e31, 0x3fe2958e} },
/**/                  {{0xb0c6c087, 0xbc709e73} },
/**/                  {{0x2538713c, 0x3fe65e03} },
/**/                  {{0x42c09163, 0xbc601392} },
/**/                  {{0x2f6d4575, 0xbfd48514} },
/**/                  {{0x4568af3f, 0xbc356341} },
/**/                  {{0x9386fd1d, 0x3fa10497} },
/**/                  {{0x230a452f, 0xbc4a756a} },
/**/                  {{0x3fc6c180, 0x3fb6d4c4} },
/**/                  {{0xdb3fe137, 0x3c5ab2b9} },
/**/                  {{0x7ca4cfd0, 0xbfb4532a} },
/**/                  {{0x90eb1d30, 0x3f93991d} },
/**/                  {{0x46163051, 0x3f992de9} },
/**/                  {{0x2de874ff, 0xbf9e7c76} },
/**/                  {{0xfc0c1cb2, 0x3f865806} } },
/**/                 {{{0x00000000, 0x3fe52000} },
/**/                  {{0x1aded073, 0x3fe2abe2} },
/**/                  {{0x01ad022e, 0x3c8c28c0} },
/**/                  {{0x4d432177, 0x3fe64981} },
/**/                  {{0x055e240c, 0x3c83f41b} },
/**/                  {{0x6a2cfd01, 0xbfd47e90} },
/**/                  {{0xf152d080, 0x3c628585} },
/**/                  {{0xfbe3ed9e, 0x3fa1b9a7} },
/**/                  {{0xf259fe04, 0xbc18a085} },
/**/                  {{0xc3c40175, 0x3fb66f6e} },
/**/                  {{0xb0fda762, 0x3c41d80a} },
/**/                  {{0x48af643a, 0xbfb43542} },
/**/                  {{0x05ad7652, 0x3f94460d} },
/**/                  {{0x5f55ab26, 0x3f983b9b} },
/**/                  {{0x4be18b23, 0xbf9e1692} },
/**/                  {{0x32e755a3, 0x3f86eefb} } },
/**/                 {{{0x00000000, 0x3fe54000} },
/**/                  {{0x5e024466, 0x3fe2c221} },
/**/                  {{0xda3a4be1, 0xbc44b810} },
/**/                  {{0x1ad38da0, 0x3fe63506} },
/**/                  {{0x94ec14b0, 0xbc67f12a} },
/**/                  {{0x567a6652, 0xbfd477c9} },
/**/                  {{0xbbb9df88, 0x3c7be71c} },
/**/                  {{0x1535acb9, 0x3fa26b90} },
/**/                  {{0xff041454, 0xbc30ff6c} },
/**/                  {{0x5105d8fa, 0x3fb60ab1} },
/**/                  {{0x3f2d6492, 0x3c535a89} },
/**/                  {{0xa0083319, 0xbfb4165b} },
/**/                  {{0x965eb0a7, 0x3f94ec67} },
/**/                  {{0xf36231e5, 0x3f974c86} },
/**/                  {{0x9c25f4a4, 0xbf9dae1f} },
/**/                  {{0x183e42dc, 0x3f877b18} } },
/**/                 {{{0x00000000, 0x3fe56000} },
/**/                  {{0x2961e48c, 0x3fe2d84c} },
/**/                  {{0x0a36e506, 0xbc7f2542} },
/**/                  {{0xd0a0e5d4, 0x3fe62091} },
/**/                  {{0xcccb008e, 0x3c82a27d} },
/**/                  {{0x228ca1b6, 0xbfd470c0} },
/**/                  {{0x32884415, 0xbc788e9b} },
/**/                  {{0xb365e4d9, 0x3fa31a54} },
/**/                  {{0xda0f99ae, 0x3c3e6e70} },
/**/                  {{0xc741ccb7, 0x3fb5a690} },
/**/                  {{0x6508ffe1, 0xbc383905} },
/**/                  {{0x50f46c17, 0xbfb3f680} },
/**/                  {{0x1b344c30, 0x3f958c44} },
/**/                  {{0xb713db8a, 0x3f9660bf} },
/**/                  {{0x5224992a, 0xbf9d434e} },
/**/                  {{0x46ffb16e, 0x3f87fca0} } },
/**/                 {{{0x00000000, 0x3fe58000} },
/**/                  {{0x8406cbca, 0x3fe2ee62} },
/**/                  {{0x9ff0cf8d, 0x3c8c5d5e} },
/**/                  {{0xb0350d38, 0x3fe60c24} },
/**/                  {{0xf3db4fcb, 0x3c81ffe9} },
/**/                  {{0xfac420bd, 0xbfd46975} },
/**/                  {{0x850528a0, 0x3c7e6994} },
/**/                  {{0xd098b4ee, 0x3fa3c5fa} },
/**/                  {{0xaa6a6874, 0x3c353c41} },
/**/                  {{0xd57c5b53, 0x3fb54311} },
/**/                  {{0x72d146e0, 0x3c50d02e} },
/**/                  {{0x071017e0, 0xbfb3d5ba} },
/**/                  {{0xf11b08a7, 0x3f9625b9} },
/**/                  {{0xe25bbc6f, 0x3f957857} },
/**/                  {{0x7384981f, 0xbf9cd64d} },
/**/                  {{0x3da3b8d5, 0x3f8873d7} } },
/**/                 {{{0x00000000, 0x3fe5a000} },
/**/                  {{0x753b090b, 0x3fe30464} },
/**/                  {{0x61da18f3, 0xbc73e712} },
/**/                  {{0xf9ee77b6, 0x3fe5f7be} },
/**/                  {{0x854f9928, 0x3c8949f7} },
/**/                  {{0x099c98f6, 0xbfd461ec} },
/**/                  {{0x3eafe889, 0x3c5da491} },
/**/                  {{0x8ba9e286, 0x3fa46e87} },
/**/                  {{0x5377a1a9, 0x3c42573a} },
/**/                  {{0xfab82ffb, 0x3fb4e038} },
/**/                  {{0x402ef939, 0xbc414e45} },
/**/                  {{0x4a8ec478, 0xbfb3b412} },
/**/                  {{0xef6dba07, 0x3f96b8e0} },
/**/                  {{0x39c13c6e, 0x3f949360} },
/**/                  {{0xd47bfddb, 0xbf9c674a} },
/**/                  {{0x37ed6935, 0x3f88e101} } },
/**/                 {{{0x00000000, 0x3fe5c000} },
/**/                  {{0x048874be, 0x3fe31a52} },
/**/                  {{0x87a7ac24, 0x3c840cab} },
/**/                  {{0xed021586, 0x3fe5e360} },
/**/                  {{0xb32ab7e4, 0x3c86a444} },
/**/                  {{0x779f86c4, 0xbfd45a23} },
/**/                  {{0x6b782501, 0xbc75b9dc} },
/**/                  {{0x26af940c, 0x3fa51400} },
/**/                  {{0xf9ce64e2, 0x3c4f700e} },
/**/                  {{0x86a8eb42, 0x3fb47e0a} },
/**/                  {{0x36377584, 0xbc5a4df9} },
/**/                  {{0x7f8b6d42, 0xbfb39192} },
/**/                  {{0x5deeeabc, 0x3f9745d1} },
/**/                  {{0x17fa1033, 0x3f93b1e8} },
/**/                  {{0x14cf2061, 0xbf9bf673} },
/**/                  {{0x0a340016, 0x3f894463} } },
/**/                 {{{0x00000000, 0x3fe5e000} },
/**/                  {{0x39b78856, 0x3fe3302b} },
/**/                  {{0xd87ba82b, 0x3c85dd2e} },
/**/                  {{0xc77d4bea, 0x3fe5cf0a} },
/**/                  {{0x0d42ab66, 0xbc8684ab} },
/**/                  {{0x6b573e11, 0xbfd4521d} },
/**/                  {{0xb90c9c27, 0xbc7601b9} },
/**/                  {{0x0582aeaa, 0x3fa5b66a} },
/**/                  {{0x8cc985ad, 0x3c281575} },
/**/                  {{0x9a69373d, 0x3fb41c8a} },
/**/                  {{0x25ea8f67, 0xbc33df07} },
/**/                  {{0xe5673a18, 0xbfb36e43} },
/**/                  {{0xeb05f3bc, 0x3f97cca3} },
/**/                  {{0x7797abe9, 0x3f92d3fd} },
/**/                  {{0x9d71c254, 0xbf9b83f1} },
/**/                  {{0xfe333861, 0x3f899e41} } },
/**/                 {{{0x00000000, 0x3fe60000} },
/**/                  {{0x1cce37bb, 0x3fe345f0} },
/**/                  {{0x37c71102, 0x3c810211} },
/**/                  {{0xc647fa91, 0x3fe5babc} },
/**/                  {{0x8056eaf3, 0x3c84339b} },
/**/                  {{0x094286d0, 0xbfd449db} },
/**/                  {{0x512b1c7b, 0x3c75e178} },
/**/                  {{0xac4cf102, 0x3fa655ca} },
/**/                  {{0x61e8206a, 0xbc27a1e4} },
/**/                  {{0x2933dd9c, 0x3fb3bbbd} },
/**/                  {{0xbd42c006, 0xbc517633} },
/**/                  {{0x9636afc9, 0xbfb34a2f} },
/**/                  {{0xa2400f6f, 0x3f984d71} },
/**/                  {{0xfcc53cab, 0x3f91f9ac} },
/**/                  {{0x9ec31ef1, 0xbf9b0ff0} },
/**/                  {{0xb1615b05, 0x3f89eee3} } },
/**/                 {{{0x00000000, 0x3fe62000} },
/**/                  {{0xb60eccce, 0x3fe35ba0} },
/**/                  {{0x9b9368b9, 0x3c8e3ba1} },
/**/                  {{0x25268d22, 0x3fe5a677} },
/**/                  {{0xaf72cee6, 0x3c7bc76e} },
/**/                  {{0x73c8c31c, 0xbfd4415d} },
/**/                  {{0xe00e5645, 0xbc3e5b3c} },
/**/                  {{0xbe1ce1b6, 0x3fa6f227} },
/**/                  {{0xe699fcac, 0xbc04a922} },
/**/                  {{0xf91f9885, 0x3fb35ba5} },
/**/                  {{0x418827b3, 0xbc43f8be} },
/**/                  {{0x863cebc9, 0xbfb3255e} },
/**/                  {{0xe315ca66, 0x3f98c853} },
/**/                  {{0xff116cac, 0x3f912301} },
/**/                  {{0x0f5e09c2, 0xbf9a9a99} },
/**/                  {{0xf4c8d587, 0x3f8a368d} } },
/**/                 {{{0x00000000, 0x3fe64000} },
/**/                  {{0x0df6c504, 0x3fe3713d} },
/**/                  {{0xe031606d, 0xbc54f789} },
/**/                  {{0x1ebc184f, 0x3fe5923a} },
/**/                  {{0xbe5956dd, 0x3c829fe8} },
/**/                  {{0xcb2e9cc9, 0xbfd438a5} },
/**/                  {{0x7d6ce3eb, 0xbc7c1839} },
/**/                  {{0xfb7fa678, 0x3fa78b86} },
/**/                  {{0xd082025e, 0x3befb53e} },
/**/                  {{0xa3dd5905, 0x3fb2fc48} },
/**/                  {{0x06b78682, 0x3c5fd567} },
/**/                  {{0x8374843c, 0xbfb2ffd9} },
/**/                  {{0x57f51471, 0x3f993d64} },
/**/                  {{0x933f6cc5, 0x3f905006} },
/**/                  {{0xab7658df, 0xbf9a2412} },
/**/                  {{0xae624ab4, 0x3f8a7586} } },
/**/                 {{{0x00000000, 0x3fe66000} },
/**/                  {{0x2d3db11f, 0x3fe386c5} },
/**/                  {{0xcbebe6a0, 0xbc8b78e1} },
/**/                  {{0xec8c8203, 0x3fe57e05} },
/**/                  {{0x5e7f92dc, 0x3c8ea585} },
/**/                  {{0x2d8b381e, 0xbfd42fb5} },
/**/                  {{0x5cff451e, 0xbc63afe6} },
/**/                  {{0x4120d643, 0x3fa821ee} },
/**/                  {{0xcbc4d2dc, 0xbc3e664f} },
/**/                  {{0x9778bfdb, 0x3fb29da8} },
/**/                  {{0x7c2057a5, 0x3c3760dd} },
/**/                  {{0x3525a55a, 0xbfb2d9a9} },
/**/                  {{0xed9015c8, 0x3f99acbc} },
/**/                  {{0x2a35e7d2, 0x3f8f0187} },
/**/                  {{0xf4bcdfc7, 0xbf99ac83} },
/**/                  {{0xbbeb4f11, 0x3f8aac13} } },
/**/                 {{{0x00000000, 0x3fe68000} },
/**/                  {{0x1cd4171a, 0x3fe39c39} },
/**/                  {{0x31d8bf46, 0xbc823043} },
/**/                  {{0xc6feb417, 0x3fe569da} },
/**/                  {{0x0625e450, 0x3c803ce5} },
/**/                  {{0xb6bde980, 0xbfd4268c} },
/**/                  {{0xe8258561, 0xbc6e8f76} },
/**/                  {{0x86705749, 0x3fa8b563} },
/**/                  {{0xe6172281, 0x3c418e14} },
/**/                  {{0x171a8768, 0x3fb23fc9} },
/**/                  {{0x3225d825, 0xbc562184} },
/**/                  {{0x1b8904fd, 0xbfb2b2d6} },
/**/                  {{0xca70ce88, 0x3f9a1677} },
/**/                  {{0x62963581, 0x3f8d6a81} },
/**/                  {{0x32c353bb, 0xbf993412} },
/**/                  {{0xd7354ec0, 0x3f8ada7a} } },
/**/                 {{{0x00000000, 0x3fe6a000} },
/**/                  {{0xe5e2564b, 0x3fe3b198} },
/**/                  {{0x1f0752ac, 0xbc72f922} },
/**/                  {{0xe55ed910, 0x3fe555b8} },
/**/                  {{0x656f2eb2, 0xbc5615bc} },
/**/                  {{0x80646bca, 0xbfd41d2d} },
/**/                  {{0x1ff3506f, 0xbc75d1d6} },
/**/                  {{0xdc4e5727, 0x3fa945ec} },
/**/                  {{0x18968922, 0x3c213c8e} },
/**/                  {{0x3bcc9fa4, 0x3fb1e2ad} },
/**/                  {{0x0a43c591, 0x3c2b899c} },
/**/                  {{0x8f774533, 0xbfb28b68} },
/**/                  {{0x46d16acc, 0x3f9a7aaf} },
/**/                  {{0xde405cc6, 0x3f8bdb08} },
/**/                  {{0x73d9884b, 0xbf98bae1} },
/**/                  {{0x7be7742a, 0x3f8b0101} } },
/**/                 {{{0x00000000, 0x3fe6c000} },
/**/                  {{0x91c78dc5, 0x3fe3c6e4} },
/**/                  {{0x94fd0ba7, 0xbc8e1450} },
/**/                  {{0x7de0a269, 0x3fe541a0} },
/**/                  {{0x163b639c, 0x3c8b9072} },
/**/                  {{0xa1d194fc, 0xbfd41398} },
/**/                  {{0x8629402d, 0xbc7ef191} },
/**/                  {{0x6bbd69eb, 0x3fa9d390} },
/**/                  {{0xd2c4a6a5, 0x3c488aec} },
/**/                  {{0xf53fbee6, 0x3fb18657} },
/**/                  {{0x0104d1dd, 0x3c54e6aa} },
/**/                  {{0xc2245ee6, 0xbfb26368} },
/**/                  {{0xe4b91b16, 0x3f9ad97d} },
/**/                  {{0x74b192c7, 0x3f8a5328} },
/**/                  {{0x8e5d8b31, 0xbf984114} },
/**/                  {{0xceadce82, 0x3f8b1fec} } },
/**/                 {{{0x00000000, 0x3fe6e000} },
/**/                  {{0x2a188504, 0x3fe3dc1c} },
/**/                  {{0x70f4e971, 0x3c82ce63} },
/**/                  {{0xc5a197ed, 0x3fe52d91} },
/**/                  {{0x1baab820, 0xbc804b92} },
/**/                  {{0x300486f8, 0xbfd409cf} },
/**/                  {{0xae804189, 0xbc6d3bb8} },
/**/                  {{0x749adab8, 0x3faa5e54} },
/**/                  {{0xc631cfd3, 0x3c20b0d5} },
/**/                  {{0x0a922c54, 0x3fb12acc} },
/**/                  {{0x7cbc4417, 0x3c521a06} },
/**/                  {{0xbce6ae05, 0xbfb23ade} },
/**/                  {{0x485d279b, 0x3f9b32fe} },
/**/                  {{0xd9b56b96, 0x3f88d2e8} },
/**/                  {{0x227841f4, 0xbf97c6cd} },
/**/                  {{0x85cf6ba0, 0x3f8b3781} } },
/**/                 {{{0x00000000, 0x3fe70000} },
/**/                  {{0xb89e96f4, 0x3fe3f13f} },
/**/                  {{0x492644f0, 0x3c7ecf8b} },
/**/                  {{0xf0ab6f99, 0x3fe5198c} },
/**/                  {{0x5e1ffaba, 0x3c71b875} },
/**/                  {{0x3da059f4, 0xbfd3ffd2} },
/**/                  {{0x77eee53d, 0x3c5bba8e} },
/**/                  {{0x4c5d36dc, 0x3faae63f} },
/**/                  {{0x2a3994d6, 0xbc4e6e4e} },
/**/                  {{0x1b178ada, 0x3fb0d00c} },
/**/                  {{0xb3e710cc, 0x3c4b94c3} },
/**/                  {{0x61093929, 0xbfb211d2} },
/**/                  {{0x30c5dd59, 0x3f9b874b} },
/**/                  {{0xb0b899ed, 0x3f875a50} },
/**/                  {{0x9c404912, 0xbf974c2b} },
/**/                  {{0xd3249a4d, 0x3f8b4803} } },
/**/                 {{{0x00000000, 0x3fe72000} },
/**/                  {{0x47569f49, 0x3fe4064f} },
/**/                  {{0xf91bf2b2, 0xbc8aad88} },
/**/                  {{0x31f66da7, 0x3fe50592} },
/**/                  {{0x134b7507, 0xbc8837f1} },
/**/                  {{0xdae43e4d, 0xbfd3f5a2} },
/**/                  {{0xdc59e382, 0xbc7f29b0} },
/**/                  {{0x5cd91a8c, 0x3fab6b57} },
/**/                  {{0xd6ab0dfc, 0xbc225bf7} },
/**/                  {{0x9f216d7a, 0x3fb0761a} },
/**/                  {{0xe546203e, 0x3c577818} },
/**/                  {{0x67a8cf31, 0xbfb1e84b} },
/**/                  {{0x70b6dd6f, 0x3f9bd67f} },
/**/                  {{0x9ff677e5, 0x3f85e964} },
/**/                  {{0x363cf426, 0xbf96d14f} },
/**/                  {{0x4f6617de, 0x3f8b51b7} } },
/**/                 {{{0x00000000, 0x3fe74000} },
/**/                  {{0xe06fea41, 0x3fe41b4a} },
/**/                  {{0x53277652, 0x3c63d60a} },
/**/                  {{0xbb6bcc2c, 0x3fe4f1a1} },
/**/                  {{0x7c81f558, 0x3c5c8d69} },
/**/                  {{0x15a41364, 0xbfd3eb42} },
/**/                  {{0x617c316a, 0x3c728a9c} },
/**/                  {{0x230c44b8, 0x3fabeda3} },
/**/                  {{0x50d9e9da, 0x3c41fa15} },
/**/                  {{0xe8c87fc3, 0x3fb01cf9} },
/**/                  {{0xa175df34, 0x3c410990} },
/**/                  {{0x619b963c, 0xbfb1be51} },
/**/                  {{0xe7da421c, 0x3f9c20b5} },
/**/                  {{0x637b86b0, 0x3f848027} },
/**/                  {{0xfc436ff1, 0xbf965655} },
/**/                  {{0xe6cd859f, 0x3f8b54de} } },
/**/                 {{{0x00000000, 0x3fe76000} },
/**/                  {{0x8e4b26d6, 0x3fe43032} },
/**/                  {{0x1070b99f, 0xbc813159} },
/**/                  {{0xbde829f5, 0x3fe4ddbb} },
/**/                  {{0xb6d17615, 0xbc735ff2} },
/**/                  {{0xf941711a, 0xbfd3e0b0} },
/**/                  {{0xe9027227, 0x3c7d3454} },
/**/                  {{0x2deef5c2, 0x3fac6d29} },
/**/                  {{0x0ba13bb6, 0x3c476533} },
/**/                  {{0x496c1e5e, 0x3faf8958} },
/**/                  {{0xe1abdf2f, 0x3c49ebf2} },
/**/                  {{0xb762a82c, 0xbfb193eb} },
/**/                  {{0x7c2df93f, 0x3f9c6609} },
/**/                  {{0xdff7724a, 0x3f831e99} },
/**/                  {{0xcea82a5a, 0xbf95db5c} },
/**/                  {{0xc6ff27bb, 0x3f8b51bc} } },
/**/                 {{{0x00000000, 0x3fe78000} },
/**/                  {{0x5b795b56, 0x3fe44506} },
/**/                  {{0x163f79c8, 0xbc7f76d0} },
/**/                  {{0x693e0015, 0x3fe4c9e0} },
/**/                  {{0x60fff59b, 0xbc7b0fcb} },
/**/                  {{0x8ea521a8, 0xbfd3d5f0} },
/**/                  {{0xb5bcc402, 0x3c561573} },
/**/                  {{0x1d4b9b62, 0x3face9f0} },
/**/                  {{0xf2c93cfb, 0x3c481226} },
/**/                  {{0xb5db8847, 0x3faeda66} },
/**/                  {{0x3a386670, 0xbc44ec99} },
/**/                  {{0xa92559e3, 0xbfb16921} },
/**/                  {{0x13b2a17d, 0x3f9ca695} },
/**/                  {{0x355982b3, 0x3f81c4bb} },
/**/                  {{0x65bec936, 0xbf95607f} },
/**/                  {{0x4e349f67, 0x3f8b4892} } },
/**/                 {{{0x00000000, 0x3fe7a000} },
/**/                  {{0x52badc7f, 0x3fe459c6} },
/**/                  {{0x8e8e135c, 0x3c819969} },
/**/                  {{0xec381dcb, 0x3fe4b60f} },
/**/                  {{0x4724e4f2, 0xbc6b9874} },
/**/                  {{0xdc390960, 0xbfd3cb01} },
/**/                  {{0x7ba1320c, 0xbc7243b1} },
/**/                  {{0xa09cca72, 0x3fad63fe} },
/**/                  {{0xe5ab8d04, 0x3c48308c} },
/**/                  {{0xdf2eb652, 0x3fae2d22} },
/**/                  {{0x4eb29ad3, 0xbc4988a3} },
/**/                  {{0x4eb5cb96, 0xbfb13dfa} },
/**/                  {{0x8e5b2657, 0x3f9ce273} },
/**/                  {{0xd132be74, 0x3f807288} },
/**/                  {{0x55a31e9e, 0xbf94e5d8} },
/**/                  {{0xfba00cb2, 0x3f8b399f} } },
/**/                 {{{0x00000000, 0x3fe7c000} },
/**/                  {{0x7efe4716, 0x3fe46e72} },
/**/                  {{0x1b844cc9, 0xbc639b9b} },
/**/                  {{0x749c2a47, 0x3fe4a24a} },
/**/                  {{0x82d8a2e5, 0xbc8f9d05} },
/**/                  {{0xe5e27a03, 0xbfd3bfe5} },
/**/                  {{0xb30f6d58, 0xbc5047da} },
/**/                  {{0x75f185ec, 0x3faddb5b} },
/**/                  {{0x23d5084a, 0x3c43b680} },
/**/                  {{0x479061d2, 0x3fad8190} },
/**/                  {{0x602d3547, 0xbbf4565c} },
/**/                  {{0x979e619e, 0xbfb1127c} },
/**/                  {{0xc03c4720, 0x3f9d19bf} },
/**/                  {{0x01b2b45f, 0x3f7e4ffd} },
/**/                  {{0x1245b0bb, 0xbf946b81} },
/**/                  {{0x60fec8ec, 0x3f8b2525} } },
/**/                 {{{0x00000000, 0x3fe7e000} },
/**/                  {{0xeb5f7bfe, 0x3fe4830a} },
/**/                  {{0x66764a73, 0xbc5a2656} },
/**/                  {{0x2f2d2be4, 0x3fe48e90} },
/**/                  {{0x969bba3b, 0x3c810a8e} },
/**/                  {{0xacfcef4d, 0xbfd3b49d} },
/**/                  {{0xb7a61548, 0xbc6a4f98} },
/**/                  {{0x68d7d101, 0x3fae500d} },
/**/                  {{0x04860c21, 0xbc305c3e} },
/**/                  {{0x2c98ea9c, 0x3facd7b2} },
/**/                  {{0xd46adca0, 0x3c48692b} },
/**/                  {{0x4b37c6a5, 0xbfb0e6af} },
/**/                  {{0x6bfb2662, 0x3f9d4c94} },
/**/                  {{0x0692cc75, 0x3f7bca2d} },
/**/                  {{0xf3b69312, 0xbf93f191} },
/**/                  {{0x1552b8ee, 0x3f8b0b61} } },
/**/                 {{{0x00000000, 0x3fe80000} },
/**/                  {{0xa3269ee1, 0x3fe4978f} },
/**/                  {{0x87f2a458, 0x3c72419a} },
/**/                  {{0x47ae147b, 0x3fe47ae1} },
/**/                  {{0xeb851eb8, 0xbc6eb851} },
/**/                  {{0x30553261, 0xbfd3a92a} },
/**/                  {{0x94467382, 0xbc7f06f6} },
/**/                  {{0x514d88d8, 0x3faec21b} },
/**/                  {{0xf45873a6, 0x3c3cd061} },
/**/                  {{0x88dfb80c, 0x3fac2f8b} },
/**/                  {{0x53add20b, 0xbc14fcbc} },
/**/                  {{0x08c71945, 0xbfb0ba99} },
/**/                  {{0x3d79f13f, 0x3f9d7b0c} },
/**/                  {{0x357dfc67, 0x3f795393} },
/**/                  {{0x3aa97829, 0xbf937822} },
/**/                  {{0xa8b90db0, 0x3f8aec90} } },
/**/                 {{{0x00000000, 0x3fe82000} },
/**/                  {{0xb1c71762, 0x3fe4ac00} },
/**/                  {{0x2382b900, 0x3c8b20e7} },
/**/                  {{0xe8e45252, 0x3fe4673d} },
/**/                  {{0x67458f9c, 0x3c57d208} },
/**/                  {{0x6c24e1b3, 0xbfd39d8c} },
/**/                  {{0x973c6d15, 0xbc7830c5} },
/**/                  {{0x12b78147, 0x3faf318c} },
/**/                  {{0xd318184c, 0xbc4fa440} },
/**/                  {{0x158b44e7, 0x3fab891f} },
/**/                  {{0x45d7f1f3, 0x3c4d5f9f} },
/**/                  {{0x47a3e8ba, 0xbfb08e40} },
/**/                  {{0xc4c1a21a, 0x3f9da541} },
/**/                  {{0x3c0d1d71, 0x3f76ec1e} },
/**/                  {{0x152e0bfc, 0xbf92ff48} },
/**/                  {{0x9955298f, 0x3f8ac8f0} } },
/**/                 {{{0x00000000, 0x3fe84000} },
/**/                  {{0x22de94e5, 0x3fe4c05e} },
/**/                  {{0xf09f2edf, 0xbc8c0ac1} },
/**/                  {{0x3c9a6560, 0x3fe453a6} },
/**/                  {{0x828bba02, 0x3c77a95f} },
/**/                  {{0x5a0e5b1c, 0xbfd391c5} },
/**/                  {{0xcd3f76d2, 0x3c7d553d} },
/**/                  {{0x9adede86, 0x3faf9e66} },
/**/                  {{0xd6d2bac0, 0xbc225e54} },
/**/                  {{0x4bdf89d7, 0x3faae46f} },
/**/                  {{0x2b25b8d9, 0x3c39c98c} },
/**/                  {{0x5765a5c1, 0xbfb061ab} },
/**/                  {{0x7127d649, 0x3f9dcb4f} },
/**/                  {{0x13002646, 0x3f7493ba} },
/**/                  {{0xa397d1a6, 0xbf928718} },
/**/                  {{0x494648b5, 0x3f8aa0bc} } },
/**/                 {{{0x00000000, 0x3fe86000} },
/**/                  {{0x023414e8, 0x3fe4d4a8} },
/**/                  {{0x1daa88b0, 0x3c6e3a89} },
/**/                  {{0x6ba2786e, 0x3fe4401a} },
/**/                  {{0xe3b5f317, 0xbc4b8213} },
/**/                  {{0xf11905c0, 0xbfd385d5} },
/**/                  {{0xa2f42dd1, 0xbc72a1e9} },
/**/                  {{0xf07a526f, 0x3fb00458} },
/**/                  {{0xac5fd817, 0xbc14f965} },
/**/                  {{0x66ca7da2, 0x3faa417e} },
/**/                  {{0xa050b433, 0x3c4b1e1a} },
/**/                  {{0x60182e4f, 0xbfb034e0} },
/**/                  {{0x8cafa41b, 0x3f9ded4f} },
/**/                  {{0x1fa4f037, 0x3f724a50} },
/**/                  {{0xfd90e915, 0xbf920fa7} },
/**/                  {{0xf59e7acf, 0x3f8a742d} } },
/**/                 {{{0x00000000, 0x3fe88000} },
/**/                  {{0x5bb6ec04, 0x3fe4e8de} },
/**/                  {{0xbeb3796c, 0x3c84a33d} },
/**/                  {{0x9dd8fdc1, 0x3fe42c9a} },
/**/                  {{0xaf80050b, 0x3c5192da} },
/**/                  {{0x25adf97f, 0xbfd379bf} },
/**/                  {{0x20cd3651, 0xbc774019} },
/**/                  {{0x724dbb01, 0x3fb0383a} },
/**/                  {{0xeb93e538, 0x3c5c4e67} },
/**/                  {{0x646e65df, 0x3fa9a04e} },
/**/                  {{0x894a6b77, 0x3c21a7cb} },
/**/                  {{0x62771c79, 0xbfb007e5} },
/**/                  {{0x37a45544, 0x3f9e0b5c} },
/**/                  {{0x54993092, 0x3f700fc7} },
/**/                  {{0x37534c25, 0xbf919909} },
/**/                  {{0xae51732a, 0x3f8a437e} } },
/**/                 {{{0x00000000, 0x3fe8a000} },
/**/                  {{0x3b7dd17e, 0x3fe4fd01} },
/**/                  {{0x3e7c24b5, 0x3c7d513f} },
/**/                  {{0xfa274ef1, 0x3fe41926} },
/**/                  {{0x4d72ecb3, 0x3c8ad830} },
/**/                  {{0xe995018a, 0xbfd36d81} },
/**/                  {{0x6fd6094d, 0x3c7e7ec5} },
/**/                  {{0x567bb975, 0x3fb06adb} },
/**/                  {{0xf0d7364f, 0x3c5212c1} },
/**/                  {{0x07a9b624, 0x3fa900e1} },
/**/                  {{0xc16bcc85, 0xbc4e5b5b} },
/**/                  {{0x705f052b, 0xbfafb580} },
/**/                  {{0x646ce12e, 0x3f9e258f} },
/**/                  {{0xa3c63841, 0x3f6bc808} },
/**/                  {{0x67043d41, 0xbf91234e} },
/**/                  {{0x4f11b221, 0x3f8a0ee6} } },
/**/                 {{{0x00000000, 0x3fe8c000} },
/**/                  {{0xadc5ed81, 0x3fe51110} },
/**/                  {{0x6832a63e, 0x3c723dcd} },
/**/                  {{0xa6864f90, 0x3fe405bf} },
/**/                  {{0x662cd5df, 0xbc7419c5} },
/**/                  {{0x2bf1f7e4, 0xbfd3611f} },
/**/                  {{0x65483b78, 0xbc6e94dd} },
/**/                  {{0x23e21be9, 0x3fb09c3f} },
/**/                  {{0xcaca858d, 0x3c22db63} },
/**/                  {{0xd99c3f1d, 0x3fa86337} },
/**/                  {{0xdc0a6dfc, 0x3c034382} },
/**/                  {{0x284f8093, 0xbfaf5aed} },
/**/                  {{0xd396fb43, 0x3f9e3c02} },
/**/                  {{0x08b96150, 0x3f678dd3} },
/**/                  {{0xaa2dcc3a, 0xbf90ae88} },
/**/                  {{0x79128ee7, 0x3f89d69b} } },
/**/                 {{{0x00000000, 0x3fe8e000} },
/**/                  {{0xbef1e9fb, 0x3fe5250c} },
/**/                  {{0xa3228870, 0xbc5539b7} },
/**/                  {{0xc8011245, 0x3fe3f264} },
/**/                  {{0x44cc720b, 0xbc6641f1} },
/**/                  {{0xd942778a, 0xbfd35497} },
/**/                  {{0x9bd7dbd6, 0x3c750a5a} },
/**/                  {{0x6438739e, 0x3fb0cc69} },
/**/                  {{0x435f798d, 0x3bf5d933} },
/**/                  {{0x2b29722f, 0x3fa7c754} },
/**/                  {{0x5b3af27b, 0xbbe736fe} },
/**/                  {{0x059a3c24, 0xbfaf001c} },
/**/                  {{0x101882b0, 0x3f9e4ed0} },
/**/                  {{0x88dc4269, 0x3f6370ae} },
/**/                  {{0x2b5280b6, 0xbf903ac8} },
/**/                  {{0x8da5b2ad, 0x3f899ad3} } },
/**/                 {{{0x00000000, 0x3fe90000} },
/**/                  {{0x7b89061f, 0x3fe538f5} },
/**/                  {{0xabda520c, 0xbc81bb74} },
/**/                  {{0x82b78014, 0x3fe3df16} },
/**/                  {{0xa43ff610, 0xbc7074be} },
/**/                  {{0xdb5be2e4, 0xbfd347ec} },
/**/                  {{0x8a0e9303, 0x3c7848c8} },
/**/                  {{0xa3a11be4, 0x3fb0fb5d} },
/**/                  {{0x09dd0d69, 0x3c3d68f2} },
/**/                  {{0x16778170, 0x3fa72d37} },
/**/                  {{0x2200d1d4, 0xbc4ea85d} },
/**/                  {{0xd4cdbd49, 0xbfaea517} },
/**/                  {{0x6bc61b6f, 0x3f9e5e10} },
/**/                  {{0xd0517524, 0x3f5ee0af} },
/**/                  {{0x4f2ec799, 0xbf8f9038} },
/**/                  {{0xa9aaa5bb, 0x3f895bc2} } },
/**/                 {{{0x00000000, 0x3fe92000} },
/**/                  {{0xf0362c8f, 0x3fe54cca} },
/**/                  {{0x7f8f43c1, 0x3c88a324} },
/**/                  {{0xf9e1016e, 0x3fe3cbd4} },
/**/                  {{0x431b67e7, 0xbc88dea6} },
/**/                  {{0x1969bc63, 0xbfd33b1f} },
/**/                  {{0x5f3d8fd8, 0x3c6ef16e} },
/**/                  {{0x703d3bf6, 0x3fb1291f} },
/**/                  {{0xb04e0672, 0xbc566e82} },
/**/                  {{0x806b26f2, 0x3fa694e1} },
/**/                  {{0xafcee740, 0x3c302819} },
/**/                  {{0x16dcee96, 0xbfae49eb} },
/**/                  {{0xfbfdb35f, 0x3f9e69dc} },
/**/                  {{0x70c48510, 0x3f571910} },
/**/                  {{0xe90198c8, 0xbf8ead25} },
/**/                  {{0xa1c723cb, 0x3f89199b} } },
/**/                 {{{0x00000000, 0x3fe94000} },
/**/                  {{0x29c70c34, 0x3fe5608d} },
/**/                  {{0xf0de8088, 0x3c89939c} },
/**/                  {{0x4fcf28c3, 0x3fe3b8a0} },
/**/                  {{0xcb80013c, 0xbc469c2b} },
/**/                  {{0x77ec4ef9, 0xbfd32e2f} },
/**/                  {{0xc61f7341, 0x3c7f9d06} },
/**/                  {{0x59c3bcdf, 0x3fb155b2} },
/**/                  {{0x3583c01b, 0xbc2d692e} },
/**/                  {{0x1a1fe15d, 0x3fa5fe54} },
/**/                  {{0x5d9bad81, 0x3c430dc5} },
/**/                  {{0x01d944a8, 0xbfadeea0} },
/**/                  {{0x9683b244, 0x3f9e724e} },
/**/                  {{0x491379ef, 0x3f4f13d4} },
/**/                  {{0x0b7cf74b, 0xbf8dcc74} },
/**/                  {{0xff5f0625, 0x3f88d48f} } },
/**/                 {{{0x00000000, 0x3fe96000} },
/**/                  {{0x352b33ba, 0x3fe5743c} },
/**/                  {{0x34c87ea6, 0xbc8ea00d} },
/**/                  {{0xa5f05e48, 0x3fe3a578} },
/**/                  {{0x00e4639b, 0xbc8ba1ec} },
/**/                  {{0xd8b7a43f, 0xbfd3211e} },
/**/                  {{0x676e23a8, 0xbc6d4b54} },
/**/                  {{0xf11b2c2d, 0x3fb18119} },
/**/                  {{0x3a3bf5fa, 0x3c34855b} },
/**/                  {{0x625c76bf, 0x3fa5698f} },
/**/                  {{0xbedb0264, 0xbc2f758a} },
/**/                  {{0x81b60103, 0xbfad9340} },
/**/                  {{0xce91900f, 0x3f9e777d} },
/**/                  {{0x34fddb2f, 0x3f406543} },
/**/                  {{0xe6077f81, 0xbf8cee3b} },
/**/                  {{0xfe42afde, 0x3f888ccf} } },
/**/                 {{{0x00000000, 0x3fe98000} },
/**/                  {{0x1f732fbb, 0x3fe587d8} },
/**/                  {{0xd8c5a950, 0xbc75e5c9} },
/**/                  {{0x1cd28c98, 0x3fe3925e} },
/**/                  {{0x1ffec6da, 0x3c8c8443} },
/**/                  {{0x1af2c622, 0xbfd313ee} },
/**/                  {{0xbc3f7ac8, 0x3c0a0e9b} },
/**/                  {{0xc7f683c3, 0x3fb1ab59} },
/**/                  {{0x12c04500, 0x3c5eaf17} },
/**/                  {{0xa7039179, 0x3fa4d693} },
/**/                  {{0xa4ce58a2, 0xbc4c8d74} },
/**/                  {{0x391400b3, 0xbfad37d6} },
/**/                  {{0xf2148a36, 0x3f9e7982} },
/**/                  {{0xb6df63ca, 0x3f112956} },
/**/                  {{0xfbd0f7ee, 0xbf8c1294} },
/**/                  {{0x8b0b0a0e, 0x3f88428a} } },
/**/                 {{{0x00000000, 0x3fe9a000} },
/**/                  {{0xf5cfab9e, 0x3fe59b60} },
/**/                  {{0x41026bc5, 0xbc81b04c} },
/**/                  {{0xd425cdfc, 0x3fe37f50} },
/**/                  {{0x518aef64, 0x3c865633} },
/**/                  {{0x1b1749db, 0xbfd3069e} },
/**/                  {{0xa119d9bc, 0xbc311c20} },
/**/                  {{0x7074cee3, 0x3fb1d475} },
/**/                  {{0x4ff61e2c, 0xbc5102e0} },
/**/                  {{0x06804def, 0x3fa44561} },
/**/                  {{0xc3865804, 0x3c4e829f} },
/**/                  {{0x82158836, 0xbfacdc6a} },
/**/                  {{0x071b2eec, 0x3f9e7876} },
/**/                  {{0xf17c4beb, 0xbf375b85} },
/**/                  {{0x2fa03971, 0xbf8b3995} },
/**/                  {{0x421a433b, 0x3f87f5ed} } },
/**/                 {{{0x00000000, 0x3fe9c000} },
/**/                  {{0xc5909517, 0x3fe5aed6} },
/**/                  {{0x714a9436, 0x3c87312f} },
/**/                  {{0xeabf19f5, 0x3fe36c50} },
/**/                  {{0x52485cca, 0x3c70d1dc} },
/**/                  {{0xb2f12226, 0xbfd2f92f} },
/**/                  {{0x3e5d3d61, 0x3c5400ba} },
/**/                  {{0x7cc3a41b, 0x3fb1fc70} },
/**/                  {{0x8819ff5b, 0x3c4b58e7} },
/**/                  {{0x712e9269, 0x3fa3b5f7} },
/**/                  {{0x7879d8ab, 0xbc4e436a} },
/**/                  {{0x6f398221, 0xbfac8106} },
/**/                  {{0xc97073c7, 0x3f9e746e} },
/**/                  {{0xecfc2d6a, 0xbf4914de} },
/**/                  {{0xcfa74bd5, 0xbf8a6350} },
/**/                  {{0x6f38ad9e, 0x3f87a724} } },
/**/                 {{{0x00000000, 0x3fe9e000} },
/**/                  {{0x9c244261, 0x3fe5c239} },
/**/                  {{0xe9e56b35, 0xbc831bd4} },
/**/                  {{0x7e9af2dc, 0x3fe3595e} },
/**/                  {{0x9dc90e6a, 0x3c81ef2d} },
/**/                  {{0xb99eb689, 0xbfd2eba3} },
/**/                  {{0x6a2f2701, 0xbc7b12ef} },
/**/                  {{0x7ec46b9b, 0x3fb2234e} },
/**/                  {{0x8d415d66, 0x3c59f30c} },
/**/                  {{0xaabf0d26, 0x3fa32856} },
/**/                  {{0x3f33d7ea, 0xbc122571} },
/**/                  {{0xcc3da9ce, 0xbfac25b2} },
/**/                  {{0xa8630cad, 0x3f9e6d84} },
/**/                  {{0xbeba707a, 0xbf5308c5} },
/**/                  {{0xa1585fd1, 0xbf898fda} },
/**/                  {{0x0dc54356, 0x3f87565b} } },
/**/                 {{{0x00000000, 0x3fea0000} },
/**/                  {{0x87169b18, 0x3fe5d589} },
/**/                  {{0x4bc5e7ca, 0x3c60028e} },
/**/                  {{0xace01346, 0x3fe34679} },
/**/                  {{0x04d19e6b, 0x3c8e6b38} },
/**/                  {{0x03913da2, 0xbfd2ddfb} },
/**/                  {{0x9a19adbd, 0xbc763ec8} },
/**/                  {{0x07b46905, 0x3fb24913} },
/**/                  {{0xd6f0307f, 0xbc4e7be8} },
/**/                  {{0x4b96b773, 0x3fa29c7e} },
/**/                  {{0x9182d783, 0xbc24c2cd} },
/**/                  {{0x1f071f44, 0xbfabca78} },
/**/                  {{0xc4b7b7c4, 0x3f9e63ce} },
/**/                  {{0x125f35b0, 0xbf59529a} },
/**/                  {{0xed369b2b, 0xbf88bf43} },
/**/                  {{0xc97185cd, 0x3f8703ba} } },
/**/                 {{{0x00000000, 0x3fea2000} },
/**/                  {{0x941043d0, 0x3fe5e8c6} },
/**/                  {{0xbe451e70, 0xbc70bf75} },
/**/                  {{0x91e21aec, 0x3fe333a2} },
/**/                  {{0x7acfc84f, 0x3c7ae035} },
/**/                  {{0x628d5861, 0xbfd2d036} },
/**/                  {{0xe463d006, 0x3c67c5fb} },
/**/                  {{0xa7d77fb2, 0x3fb26dc1} },
/**/                  {{0xc47ba861, 0xbc5432bd} },
/**/                  {{0xc229bece, 0x3fa2126d} },
/**/                  {{0x1da8ed9e, 0xbc4be1bf} },
/**/                  {{0xa890e568, 0xbfab6f5e} },
/**/                  {{0xeec5339a, 0x3f9e5763} },
/**/                  {{0x5274aa52, 0xbf5f68a6} },
/**/                  {{0x8a9df558, 0xbf87f19c} },
/**/                  {{0xff809dc5, 0x3f86af6b} } },
/**/                 {{{0x00000000, 0x3fea4000} },
/**/                  {{0xd0d5cc4a, 0x3fe5fbf0} },
/**/                  {{0x000b7158, 0xbc5b4cfd} },
/**/                  {{0x49243ad8, 0x3fe320d9} },
/**/                  {{0x433f7be5, 0xbc8ce5e0} },
/**/                  {{0xa5abec2f, 0xbfd2c256} },
/**/                  {{0x04494dc1, 0xbc68785b} },
/**/                  {{0xee25a81c, 0x3fb2915d} },
/**/                  {{0x68b37e8b, 0x3c3e7045} },
/**/                  {{0x5451b7d2, 0x3fa18a24} },
/**/                  {{0x79d21dd5, 0xbc3b2d29} },
/**/                  {{0x65dfcf66, 0xbfab146e} },
/**/                  {{0xa4b895b9, 0x3f9e485a} },
/**/                  {{0x14770b65, 0xbf62a5d4} },
/**/                  {{0xeb7dab0f, 0xbf8726f2} },
/**/                  {{0xc081d40d, 0x3f865995} } },
/**/                 {{{0x00000000, 0x3fea6000} },
/**/                  {{0x4b46e05f, 0x3fe60f08} },
/**/                  {{0x99945193, 0xbc8dbb86} },
/**/                  {{0xed5be099, 0x3fe30e1d} },
/**/                  {{0x373fae45, 0x3c6c6e78} },
/**/                  {{0x995b3a02, 0xbfd2b45c} },
/**/                  {{0xe7cea2ad, 0x3c7cb97b} },
/**/                  {{0x67fb0cde, 0x3fb2b3eb} },
/**/                  {{0x4920d50b, 0xbc402927} },
/**/                  {{0x209f00e4, 0x3fa103a1} },
/**/                  {{0xecac275a, 0xbc36fb57} },
/**/                  {{0x10fb6629, 0xbfaab9af} },
/**/                  {{0x1100b94a, 0x3f9e36c9} },
/**/                  {{0x58620e6c, 0xbf657e30} },
/**/                  {{0x2801158e, 0xbf865f54} },
/**/                  {{0xd27eaf07, 0x3f86025d} } },
/**/                 {{{0x00000000, 0x3fea8000} },
/**/                  {{0x115d7b8e, 0x3fe6220d} },
/**/                  {{0x350ee8c1, 0xbc62b785} },
/**/                  {{0x98736048, 0x3fe2fb70} },
/**/                  {{0x4df7c4fa, 0x3c87a751} },
/**/                  {{0x07603054, 0xbfd2a649} },
/**/                  {{0xf564247c, 0x3c7c41eb} },
/**/                  {{0xa0cac592, 0x3fb2d56d} },
/**/                  {{0x4e757ddf, 0x3c333138} },
/**/                  {{0x1fa53ce5, 0x3fa07ee3} },
/**/                  {{0x28113a76, 0xbc41bd0c} },
/**/                  {{0x21eb5271, 0xbfaa5f28} },
/**/                  {{0x08df7f4f, 0x3f9e22c5} },
/**/                  {{0x107b528f, 0xbf683dca} },
/**/                  {{0x0a22f693, 0xbf859acc} },
/**/                  {{0xb39536ba, 0x3f85a9e8} } },
/**/                 {{{0x00000000, 0x3feaa000} },
/**/                  {{0x312d1f3b, 0x3fe634ff} },
/**/                  {{0x15f2b598, 0x3c89d2f3} },
/**/                  {{0x638c9d15, 0x3fe2e8d1} },
/**/                  {{0xfe1a437d, 0x3c831ae5} },
/**/                  {{0xb6d7f622, 0xbfd2981c} },
/**/                  {{0x86e9fe4d, 0xbc53da87} },
/**/                  {{0x21d425b2, 0x3fb2f5e8} },
/**/                  {{0xae2616cb, 0xbc186482} },
/**/                  {{0x4a85a0e4, 0x3f9ff7d2} },
/**/                  {{0xe2d9205b, 0xbc294288} },
/**/                  {{0xcfb8dc09, 0xbfaa04e0} },
/**/                  {{0x0b1f9c73, 0x3f9e0c64} },
/**/                  {{0xbd3845d8, 0xbf6ae504} },
/**/                  {{0x19278cae, 0xbf84d965} },
/**/                  {{0x9cf7183b, 0x3f855059} } },
/**/                 {{{0x00000000, 0x3feac000} },
/**/                  {{0xb8e20b90, 0x3fe647de} },
/**/                  {{0x023a51cf, 0xbc5eca04} },
/**/                  {{0x6703b033, 0x3fe2d640} },
/**/                  {{0x38039b02, 0x3c870ae6} },
/**/                  {{0x6c39acf5, 0xbfd289d8} },
/**/                  {{0x0238a7ee, 0xbc71f038} },
/**/                  {{0x71da955f, 0x3fb3155e} },
/**/                  {{0xd41f84df, 0xbc5faa02} },
/**/                  {{0xc3c69caa, 0x3f9ef563} },
/**/                  {{0x75403dbd, 0x3c331d29} },
/**/                  {{0x1174124f, 0xbfa9aae0} },
/**/                  {{0x3eedb30b, 0x3f9df3bb} },
/**/                  {{0x1c632765, 0xbf6d7445} },
/**/                  {{0xa4fa03e7, 0xbf841b28} },
/**/                  {{0x8646990d, 0x3f84f5d2} } },
/**/                 {{{0x00000000, 0x3feae000} },
/**/                  {{0xb6c07b03, 0x3fe65aab} },
/**/                  {{0x3af32729, 0xbc67939b} },
/**/                  {{0xba718de8, 0x3fe2c3bd} },
/**/                  {{0xc4990a2b, 0xbc82d2fc} },
/**/                  {{0xe9586818, 0xbfd27b7c} },
/**/                  {{0x880839ca, 0x3c780d5e} },
/**/                  {{0x14dfe9e3, 0x3fb333d4} },
/**/                  {{0xbce74cae, 0x3c536469} },
/**/                  {{0xc77983b8, 0x3f9df677} },
/**/                  {{0xb42f53aa, 0x3c373272} },
/**/                  {{0x9f3c360e, 0xbfa9512c} },
/**/                  {{0x72d37b24, 0x3f9dd8df} },
/**/                  {{0x02e417f5, 0xbf6febf1} },
/**/                  {{0xd16a1579, 0xbf83601e} },
/**/                  {{0x294a83e4, 0x3f849a74} } },
/**/                 {{{0x00000000, 0x3feb0000} },
/**/                  {{0x3923e087, 0x3fe66d66} },
/**/                  {{0xebe8bbba, 0xbc76ea6f} },
/**/                  {{0x74aea886, 0x3fe2b149} },
/**/                  {{0xa9d6d16a, 0x3c868ffd} },
/**/                  {{0xed65571e, 0xbfd26d0a} },
/**/                  {{0x476fb5f2, 0x3c6cf972} },
/**/                  {{0x8be1339f, 0x3fb3514c} },
/**/                  {{0x3f722216, 0x3c5c8c0f} },
/**/                  {{0x300f8f9b, 0x3f9cfb0b} },
/**/                  {{0x38d1c932, 0xbc0edd81} },
/**/                  {{0xf34b004f, 0xbfa8f7cc} },
/**/                  {{0x1bd3bde0, 0x3f9dbbe5} },
/**/                  {{0x9bf7dceb, 0xbf712637} },
/**/                  {{0xa146e5b2, 0xbf82a84e} },
/**/                  {{0x05f2718e, 0x3f843e5e} } },
/**/                 {{{0x00000000, 0x3feb2000} },
/**/                  {{0x4e7e2858, 0x3fe6800e} },
/**/                  {{0x1b3e90f0, 0xbc58ea6a} },
/**/                  {{0xabd5912c, 0x3fe29ee3} },
/**/                  {{0xb17c28e3, 0xbc61b3cd} },
/**/                  {{0x34f221eb, 0xbfd25e83} },
/**/                  {{0xfa300585, 0xbc74c483} },
/**/                  {{0x5495f6e3, 0x3fb36dcb} },
/**/                  {{0x311973fe, 0x3c59b55b} },
/**/                  {{0x9864d139, 0x3f9c031a} },
/**/                  {{0xbd00e171, 0x3c28fdf3} },
/**/                  {{0x4b026585, 0xbfa89ec7} },
/**/                  {{0x54a5ed3d, 0x3f9d9ce0} },
/**/                  {{0xa8cb6dfc, 0xbf724b13} },
/**/                  {{0x015469a9, 0xbf81f3be} },
/**/                  {{0x66a50a89, 0x3f83e1ae} } },
/**/                 {{{0x00000000, 0x3feb4000} },
/**/                  {{0x0556fb6a, 0x3fe692a4} },
/**/                  {{0x5a8ea2cc, 0x3c8d94b9} },
/**/                  {{0x75459603, 0x3fe28c8c} },
/**/                  {{0x2945fc08, 0x3c8b1c3b} },
/**/                  {{0x79f37468, 0xbfd24fe6} },
/**/                  {{0x0ec1ef94, 0xbc4e3751} },
/**/                  {{0xe931c53b, 0x3fb38953} },
/**/                  {{0x16d80688, 0xbc3b108d} },
/**/                  {{0x5e1b50b5, 0x3f9b0ea2} },
/**/                  {{0x63fd1067, 0x3c0074c0} },
/**/                  {{0xa7fc7800, 0xbfa84621} },
/**/                  {{0xdd10256e, 0x3f9d7be4} },
/**/                  {{0xc9592c5e, 0xbf7364c0} },
/**/                  {{0xd318d707, 0xbf814271} },
/**/                  {{0x64d217b8, 0x3f838482} } },
/**/                 {{{0x00000000, 0x3feb6000} },
/**/                  {{0x6c4b0576, 0x3fe6a527} },
/**/                  {{0x9c46a69e, 0xbc8f6b65} },
/**/                  {{0xe5a55de9, 0x3fe27a43} },
/**/                  {{0xedc25d49, 0x3c66846e} },
/**/                  {{0x73c3b821, 0xbfd24135} },
/**/                  {{0x56ab5808, 0xbc79202a} },
/**/                  {{0xc0282c84, 0x3fb3a3e9} },
/**/                  {{0x03d25dab, 0x3c4057ca} },
/**/                  {{0xa3eb854d, 0x3f9a1d9e} },
/**/                  {{0xf03e2fb1, 0xbc3775ed} },
/**/                  {{0xd11d1043, 0xbfa7ede1} },
/**/                  {{0x195e6961, 0x3f9d5906} },
/**/                  {{0x65130256, 0xbf747373} },
/**/                  {{0xf77fd664, 0xbf80946d} },
/**/                  {{0xedc272c2, 0x3f8326f5} } },
/**/                 {{{0x00000000, 0x3feb8000} },
/**/                  {{0x920b3d99, 0x3fe6b798} },
/**/                  {{0x6188c50e, 0xbc8a8038} },
/**/                  {{0x10e5813e, 0x3fe2680a} },
/**/                  {{0x2242a6bc, 0xbc8f5497} },
/**/                  {{0xd725fa1c, 0xbfd23270} },
/**/                  {{0x5c781b14, 0x3c757282} },
/**/                  {{0x4bf2f124, 0x3fb3bd90} },
/**/                  {{0x6a14ed74, 0x3c31ae9c} },
/**/                  {{0x53ea1533, 0x3f99300b} },
/**/                  {{0x68f98d7e, 0x3c2a8d88} },
/**/                  {{0x53a4e537, 0xbfa7960d} },
/**/                  {{0x11f5f086, 0x3f9d3457} },
/**/                  {{0x19baa1da, 0xbf757760} },
/**/                  {{0xb2a2ca7e, 0xbf7fd36a} },
/**/                  {{0xc7a02081, 0x3f82c923} } },
/**/                 {{{0x00000000, 0x3feba000} },
/**/                  {{0x855c3198, 0x3fe6c9f7} },
/**/                  {{0x29bd280d, 0x3c7c09de} },
/**/                  {{0x0a431fbd, 0x3fe255df} },
/**/                  {{0xf09a745d, 0x3c8d9866} },
/**/                  {{0x5648fb1f, 0xbfd22399} },
/**/                  {{0xb4df0b3e, 0x3c412100} },
/**/                  {{0xfada8899, 0x3fb3d64a} },
/**/                  {{0x659c4346, 0x3c3dd891} },
/**/                  {{0x21c2d0a1, 0x3f9845e4} },
/**/                  {{0xf397827c, 0x3c28c6b1} },
/**/                  {{0x8445c1cc, 0xbfa73ea9} },
/**/                  {{0x730360f8, 0x3f9d0dea} },
/**/                  {{0xac51ce30, 0xbf7670bb} },
/**/                  {{0xeef50deb, 0xbf7e8493} },
/**/                  {{0x96b119a9, 0x3f826b25} } },
/**/                 {{{0x00000000, 0x3febc000} },
/**/                  {{0x551553af, 0x3fe6dc44} },
/**/                  {{0x3573828e, 0xbc5bf886} },
/**/                  {{0xe44a7335, 0x3fe243c2} },
/**/                  {{0x65d1ffd7, 0xbc667287} },
/**/                  {{0xa0ca68d3, 0xbfd214af} },
/**/                  {{0x88820895, 0xbc71296c} },
/**/                  {{0x36c0c9a2, 0x3fb3ee1d} },
/**/                  {{0x831dfabe, 0x3c540bf6} },
/**/                  {{0x8ce8de84, 0x3f975f24} },
/**/                  {{0x43eb5853, 0xbc125368} },
/**/                  {{0x803788f8, 0xbfa6e7bb} },
/**/                  {{0x8c42d5f9, 0x3f9ce5d2} },
/**/                  {{0xfaadb3ab, 0xbf775fba} },
/**/                  {{0xde4c28da, 0xbf7d3c59} },
/**/                  {{0xe2bf7ef5, 0x3f820d13} } },
/**/                 {{{0x00000000, 0x3febe000} },
/**/                  {{0x10204aef, 0x3fe6ee7f} },
/**/                  {{0xa3066272, 0x3c8692ee} },
/**/                  {{0xb0d95ee5, 0x3fe231b5} },
/**/                  {{0x1eb505b6, 0x3c7aae7e} },
/**/                  {{0x63ba3e08, 0xbfd205b4} },
/**/                  {{0xb975517d, 0x3c71c6d1} },
/**/                  {{0x64edc729, 0x3fb4050a} },
/**/                  {{0x715db809, 0x3c4960ed} },
/**/                  {{0xe2bc143b, 0x3f967bc7} },
/**/                  {{0xf0823143, 0xbc2cbf17} },
/**/                  {{0x2e4dbc47, 0xbfa69148} },
/**/                  {{0x50e0982e, 0x3f9cbc21} },
/**/                  {{0xedaa432a, 0xbf784492} },
/**/                  {{0x0b4850f3, 0xbf7bfabd} },
/**/                  {{0x1caa2f2c, 0x3f81af06} } },
/**/                 {{{0x00000000, 0x3fec0000} },
/**/                  {{0xc5784634, 0x3fe700a7} },
/**/                  {{0x25aadef6, 0xbc78c34d} },
/**/                  {{0x8121fb78, 0x3fe21fb7} },
/**/                  {{0x8121fb78, 0x3c621fb7} },
/**/                  {{0x499e4889, 0xbfd1f6a8} },
/**/                  {{0x6d4e0249, 0xbc60e934} },
/**/                  {{0xe5decb17, 0x3fb41b15} },
/**/                  {{0xab3541e6, 0x3c5194f4} },
/**/                  {{0x40a374b5, 0x3f959bc9} },
/**/                  {{0x54be0e10, 0xbc39dc6e} },
/**/                  {{0x400d3c9a, 0xbfa63b54} },
/**/                  {{0x57717232, 0x3f9c90e8} },
/**/                  {{0x6bfa704e, 0xbf791f78} },
/**/                  {{0x643da6dd, 0xbf7abfbc} },
/**/                  {{0xa418ed31, 0x3f815112} } },
/**/                 {{{0x00000000, 0x3fec2000} },
/**/                  {{0x84295198, 0x3fe712be} },
/**/                  {{0x337d8881, 0x3c85cd90} },
/**/                  {{0x65ad1f5b, 0x3fe20dc8} },
/**/                  {{0xd7b50d48, 0xbc88102a} },
/**/                  {{0xfa75d2f4, 0xbfd1e78b} },
/**/                  {{0x619624d2, 0x3c723734} },
/**/                  {{0x1517663e, 0x3fb43043} },
/**/                  {{0xe5e1ddf1, 0xbc4af8a4} },
/**/                  {{0x961cd605, 0x3f94bf23} },
/**/                  {{0x5ca14507, 0xbc26e86e} },
/**/                  {{0x32c1ffd7, 0xbfa5e5e4} },
/**/                  {{0xda0191cd, 0x3f9c6438} },
/**/                  {{0x4d921d2b, 0xbf79f0a0} },
/**/                  {{0x4e35d54e, 0xbf798b55} },
/**/                  {{0xcd4f7bfd, 0x3f80f34e} } },
/**/                 {{{0x00000000, 0x3fec4000} },
/**/                  {{0x5b4fae7b, 0x3fe724c3} },
/**/                  {{0x2db3499b, 0x3c5948b3} },
/**/                  {{0x6e5ce35d, 0x3fe1fbe8} },
/**/                  {{0x561e27a3, 0x3c8101d1} },
/**/                  {{0x1bbd70f4, 0xbfd1d860} },
/**/                  {{0xfa32c4d1, 0xbc7b4c97} },
/**/                  {{0x48f48a77, 0x3fb44495} },
/**/                  {{0xb47fdf89, 0xbc2ccfed} },
/**/                  {{0xa6c1af2c, 0x3f93e5d1} },
/**/                  {{0xc3b5a19b, 0xbc14af58} },
/**/                  {{0x5094795f, 0xbfa590fc} },
/**/                  {{0xb638ebc2, 0x3f9c3623} },
/**/                  {{0x4fa66d0e, 0xbf7ab83f} },
/**/                  {{0xb787e297, 0xbf785d83} },
/**/                  {{0xe71b4cea, 0x3f8095ce} } },
/**/                 {{{0x00000000, 0x3fec6000} },
/**/                  {{0x5a172dff, 0x3fe736b6} },
/**/                  {{0x06a892d1, 0x3c7775fd} },
/**/                  {{0xaa6f2377, 0x3fe1ea17} },
/**/                  {{0xcb44ec07, 0xbc8395a8} },
/**/                  {{0x5072ec76, 0xbfd1c925} },
/**/                  {{0xf650d5de, 0xbc6e11b3} },
/**/                  {{0xd281a42b, 0x3fb4580f} },
/**/                  {{0xf63226cb, 0xbc55bbce} },
/**/                  {{0x0c411254, 0x3f930fce} },
/**/                  {{0xc9852726, 0x3c3a4412} },
/**/                  {{0xb19e766e, 0xbfa53ca0} },
/**/                  {{0x6d941dd5, 0x3f9c06b9} },
/**/                  {{0x094128b2, 0xbf7b768a} },
/**/                  {{0x2a047c42, 0xbf773642} },
/**/                  {{0x40d7925f, 0x3f8038a6} } },
/**/                 {{{0x00000000, 0x3fec8000} },
/**/                  {{0x8fba8e0f, 0x3fe74897} },
/**/                  {{0x165884a1, 0x3c47b2a6} },
/**/                  {{0x287ffb8a, 0x3fe1d856} },
/**/                  {{0xfee27a9d, 0xbc658a1f} },
/**/                  {{0x39195240, 0xbfd1b9dc} },
/**/                  {{0x551dc6bf, 0x3c604646} },
/**/                  {{0xfd4fa866, 0x3fb46ab5} },
/**/                  {{0xc2febe43, 0x3c5f62a7} },
/**/                  {{0x384eda2c, 0x3f923d13} },
/**/                  {{0x1dfd9f34, 0x3c3b9a7c} },
/**/                  {{0x3cff324c, 0xbfa4e8d5} },
/**/                  {{0x25b0d0ad, 0x3f9bd60a} },
/**/                  {{0xe063d1e6, 0xbf7c2bb4} },
/**/                  {{0xdcb54dd5, 0xbf761589} },
/**/                  {{0x61077b85, 0x3f7fb7ce} } },
/**/                 {{{0x00000000, 0x3feca000} },
/**/                  {{0x0b82d8d8, 0x3fe75a67} },
/**/                  {{0x4c729087, 0x3c8ee4ac} },
/**/                  {{0xf68c4011, 0x3fe1c6a3} },
/**/                  {{0x32671c29, 0xbc8e54e4} },
/**/                  {{0x73bd1c8f, 0xbfd1aa85} },
/**/                  {{0x41d7bd80, 0x3c7525ad} },
/**/                  {{0x0f4e0cc0, 0x3fb47c8b} },
/**/                  {{0xd854875c, 0x3c2efdd1} },
/**/                  {{0x7688134d, 0x3f916d9b} },
/**/                  {{0x42a6f922, 0xbc1abef6} },
/**/                  {{0xa9ee694e, 0xbfa4959d} },
/**/                  {{0xa8aca118, 0x3f9ba425} },
/**/                  {{0xffb6fa1f, 0xbf7cd7f3} },
/**/                  {{0xc52e395a, 0xbf74fb52} },
/**/                  {{0x31d14661, 0x3f7eff46} } },
/**/                 {{{0x00000000, 0x3fecc000} },
/**/                  {{0xdcc6c6c0, 0x3fe76c24} },
/**/                  {{0x51adc83d, 0x3c819525} },
/**/                  {{0x21f3f28c, 0x3fe1b501} },
/**/                  {{0x5f1d67b6, 0xbc45712f} },
/**/                  {{0x9bf87a43, 0xbfd19b21} },
/**/                  {{0xb2071e48, 0xbc64520a} },
/**/                  {{0x48a59e43, 0x3fb48d92} },
/**/                  {{0x42014b8b, 0x3c5f8e56} },
/**/                  {{0xee4caccb, 0x3f90a160} },
/**/                  {{0x7b6daa67, 0x3c2bd92b} },
/**/                  {{0x80ce3489, 0xbfa442fd} },
/**/                  {{0x65959e45, 0x3f9b711b} },
/**/                  {{0x4cc2673a, 0xbf7d7b7b} },
/**/                  {{0xa86f8a8e, 0xbf73e793} },
/**/                  {{0xdf91602d, 0x3f7e47d4} } },
/**/                 {{{0x00000000, 0x3fece000} },
/**/                  {{0x12ea22c7, 0x3fe77dd1} },
/**/                  {{0x8fc10d3d, 0x3c873260} },
/**/                  {{0xb77cb1a2, 0x3fe1a36d} },
/**/                  {{0x6e625be9, 0xbc42c20d} },
/**/                  {{0x4af7b13c, 0xbfd18bb1} },
/**/                  {{0xbc063e5a, 0xbc68446b} },
/**/                  {{0xe3952cbb, 0x3fb49dce} },
/**/                  {{0x58cf9123, 0x3c588e60} },
/**/                  {{0x491cfa44, 0x3f8fb0bb} },
/**/                  {{0x0e3f2a43, 0x3c1534fc} },
/**/                  {{0x1c3b7aca, 0xbfa3f0f8} },
/**/                  {{0x70eb708a, 0x3f9b3cfa} },
/**/                  {{0x5eaa8b7f, 0xbf7e167e} },
/**/                  {{0x2b587c04, 0xbf72da42} },
/**/                  {{0x882fa65b, 0x3f7d9199} } },
/**/                 {{{0x00000000, 0x3fed0000} },
/**/                  {{0xbd5d315e, 0x3fe78f6b} },
/**/                  {{0x89803740, 0x3c8406a0} },
/**/                  {{0xc35424ca, 0x3fe191e9} },
/**/                  {{0xf4be863f, 0xbc8fa3c1} },
/**/                  {{0x177d9a85, 0xbfd17c35} },
/**/                  {{0x6a99d546, 0xbc717b81} },
/**/                  {{0x144fffae, 0x3fb4ad44} },
/**/                  {{0xdccca2a3, 0x3c3538b3} },
/**/                  {{0xfb2b5523, 0x3f8e2516} },
/**/                  {{0x60181bd9, 0x3c0f7c11} },
/**/                  {{0xaa1cc641, 0xbfa39f90} },
/**/                  {{0x85304289, 0x3f9b07d1} },
/**/                  {{0x756fd193, 0xbf7ea930} },
/**/                  {{0xe2a9a0de, 0xbf71d352} },
/**/                  {{0x886fc912, 0x3f7cdcb1} } },
/**/                 {{{0x00000000, 0x3fed2000} },
/**/                  {{0xeb9c19a2, 0x3fe7a0f4} },
/**/                  {{0xcd815f57, 0x3c613c67} },
/**/                  {{0x5112636f, 0x3fe18075} },
/**/                  {{0x7a335b20, 0x3c80a172} },
/**/                  {{0x95e83705, 0xbfd16cad} },
/**/                  {{0x7b21d5e1, 0x3c62a94b} },
/**/                  {{0x08de0a7c, 0x3fb4bbf5} },
/**/                  {{0x057457a0, 0x3c3570d0} },
/**/                  {{0x7d750fdf, 0x3f8c9fc8} },
/**/                  {{0xfe4cff3c, 0x3c2900a7} },
/**/                  {{0x2caf50ea, 0xbfa34eca} },
/**/                  {{0x03888c77, 0x3f9ad1af} },
/**/                  {{0x71ac3a86, 0xbf7f33c4} },
/**/                  {{0x6296fd58, 0xbf70d2b9} },
/**/                  {{0x886d16b8, 0x3f7c2938} } },
/**/                 {{{0x00000000, 0x3fed4000} },
/**/                  {{0xad2e50fe, 0x3fe7b26c} },
/**/                  {{0xf30411fb, 0xbc8ce80d} },
/**/                  {{0x6bbc577a, 0x3fe16f10} },
/**/                  {{0xbd8abf47, 0xbc7d0db6} },
/**/                  {{0x58355b5f, 0xbfd15d1b} },
/**/                  {{0xbcc70038, 0xbc5b5457} },
/**/                  {{0xe8fdd51d, 0x3fb4c9e4} },
/**/                  {{0x28ac9383, 0x3c462959} },
/**/                  {{0x2029f143, 0x3f8b20c3} },
/**/                  {{0x2b420400, 0xbc2f8a44} },
/**/                  {{0x7b921c49, 0xbfa2fea7} },
/**/                  {{0xf468e79e, 0x3f9a9aa0} },
/**/                  {{0xcccbcb4f, 0xbf7fb66c} },
/**/                  {{0x9bd39a5f, 0xbf6fb0d0} },
/**/                  {{0x8813998f, 0x3f7b7748} } },
/**/                 {{{0x00000000, 0x3fed6000} },
/**/                  {{0x11a6092b, 0x3fe7c3d3} },
/**/                  {{0x2d303288, 0x3c8bb3cb} },
/**/                  {{0x1dc61b17, 0x3fe15dbb} },
/**/                  {{0xbb77dc56, 0xbc8f0487} },
/**/                  {{0xee0771ca, 0xbfd14d7e} },
/**/                  {{0xdc2fcbd0, 0x3c72d38b} },
/**/                  {{0xd6080f0e, 0x3fb4d716} },
/**/                  {{0xa9fbc2c3, 0xbc5cb5bc} },
/**/                  {{0xfc42e02f, 0x3f89a7f9} },
/**/                  {{0x857be8a4, 0xbc201eec} },
/**/                  {{0x44ceebb3, 0xbfa2af2b} },
/**/                  {{0x08511639, 0x3f9a62b5} },
/**/                  {{0xc8de23de, 0xbf8018ad} },
/**/                  {{0xc964501a, 0xbf6dc8a2} },
/**/                  {{0xeb913697, 0x3f7ac6f9} } },
/**/                 {{{0x00000000, 0x3fed8000} },
/**/                  {{0x289fa093, 0x3fe7d528} },
/**/                  {{0x1e2f3aa9, 0x3c856082} },
/**/                  {{0x711551bb, 0x3fe14c75} },
/**/                  {{0x71970f2c, 0xbc80c88e} },
/**/                  {{0xe4aa5095, 0xbfd13dd8} },
/**/                  {{0xb4b7ae12, 0x3c66dd31} },
/**/                  {{0xead4c211, 0x3fb4e38d} },
/**/                  {{0xe392a31e, 0x3c513fb0} },
/**/                  {{0xf6b74576, 0x3f88355f} },
/**/                  {{0xf3561ab7, 0x3ba8cb44} },
/**/                  {{0x0de0faaa, 0xbfa26058} },
/**/                  {{0x989371f0, 0x3f9a29f8} },
/**/                  {{0x2b085d9a, 0xbf805261} },
/**/                  {{0x2511c555, 0xbf6beccb} },
/**/                  {{0x87b9d333, 0x3f7a1863} } },
/**/                 {{{0x00000000, 0x3feda000} },
/**/                  {{0x01c114fe, 0x3fe7e66c} },
/**/                  {{0x8b760b8d, 0xbc8c82b8} },
/**/                  {{0x6f037c44, 0x3fe13b3f} },
/**/                  {{0x8562c8c0, 0xbc635393} },
/**/                  {{0xc7182435, 0xbfd12e29} },
/**/                  {{0x0d0fda95, 0xbc73da80} },
/**/                  {{0x3ba21a8b, 0x3fb4ef4d} },
/**/                  {{0x9aa41146, 0xbc17c450} },
/**/                  {{0xc39dff46, 0x3f86c8e7} },
/**/                  {{0x800ba9ae, 0x3c1ddd70} },
/**/                  {{0x34b94b56, 0xbfa21230} },
/**/                  {{0xa827f95a, 0x3f99f078} },
/**/                  {{0x19caa997, 0xbf808869} },
/**/                  {{0xf8c46d26, 0xbf6a1d29} },
/**/                  {{0xae59da17, 0x3f796b9a} } },
/**/                 {{{0x00000000, 0x3fedc000} },
/**/                  {{0xacb97898, 0x3fe7f79e} },
/**/                  {{0x80ead221, 0x3c8fd5ca} },
/**/                  {{0x20604825, 0x3fe12a19} },
/**/                  {{0xa18970f8, 0xbc5cc7d6} },
/**/                  {{0x1dfe6ba4, 0xbfd11e72} },
/**/                  {{0x9d653d1c, 0x3c706717} },
/**/                  {{0xd5fcbb3b, 0x3fb4fa57} },
/**/                  {{0x5f50bc06, 0x3c1922c8} },
/**/                  {{0xe93a179f, 0x3f856283} },
/**/                  {{0x5ea7135a, 0xbc01c2ec} },
/**/                  {{0xf0c06b4f, 0xbfa1c4b5} },
/**/                  {{0xe48a3b04, 0x3f99b641} },
/**/                  {{0xe1280a21, 0xbf80badd} },
/**/                  {{0x1be3c5dd, 0xbf68599e} },
/**/                  {{0x3a72c8e6, 0x3f78c0b3} } },
/**/                 {{{0x00000000, 0x3fede000} },
/**/                  {{0x3940694b, 0x3fe808c0} },
/**/                  {{0x7715f6a5, 0xbc800f32} },
/**/                  {{0x8d73d98e, 0x3fe11902} },
/**/                  {{0x30f8e290, 0x3c71d158} },
/**/                  {{0x6fc305eb, 0xbfd10eb2} },
/**/                  {{0x3858c4b7, 0xbc7fd2e3} },
/**/                  {{0xc0a99255, 0x3fb504b0} },
/**/                  {{0x142e134f, 0x3c55c054} },
/**/                  {{0xc2f371cf, 0x3f840226} },
/**/                  {{0xfc7d6225, 0xbbfc85b0} },
/**/                  {{0x53d58f53, 0xbfa177eb} },
/**/                  {{0xa6a1627d, 0x3f997b60} },
/**/                  {{0x89757c78, 0xbf80e9d7} },
/**/                  {{0x0d433cd6, 0xbf66a205} },
/**/                  {{0x9c5dbd9f, 0x3f7817bf} } },
/**/                 {{{0x00000000, 0x3fee0000} },
/**/                  {{0xb7158a4d, 0x3fe819d0} },
/**/                  {{0x29d3b917, 0xbc7bf762} },
/**/                  {{0xbe011080, 0x3fe107fb} },
/**/                  {{0xbe011080, 0xbc8107fb} },
/**/                  {{0x40894fcd, 0xbfd0feeb} },
/**/                  {{0xc155af9a, 0x3c76fbb9} },
/**/                  {{0xfb9125f7, 0x3fb50e5a} },
/**/                  {{0x2f3313b0, 0x3c357762} },
/**/                  {{0x843ba55a, 0x3f82a7c2} },
/**/                  {{0x3fc197b7, 0x3c1f4994} },
/**/                  {{0x4b4ae875, 0xbfa12bd2} },
/**/                  {{0xf3b1b1ee, 0x3f993fe0} },
/**/                  {{0xd4c2083b, 0xbf81156d} },
/**/                  {{0x0c35aa9c, 0xbf64f63b} },
/**/                  {{0xe5d0462f, 0x3f7770d0} } },
/**/                 {{{0x00000000, 0x3fee2000} },
/**/                  {{0x36000005, 0x3fe82ad0} },
/**/                  {{0xce924d24, 0x3c74592f} },
/**/                  {{0xb947c8b7, 0x3fe0f704} },
/**/                  {{0x48a651b3, 0x3c436cd7} },
/**/                  {{0x1237505b, 0xbfd0ef1d} },
/**/                  {{0x1b86b9d1, 0x3c69239b} },
/**/                  {{0x7fac4e21, 0x3fb51759} },
/**/                  {{0xbfce0e36, 0xbc42a8cc} },
/**/                  {{0x3b5f3edd, 0x3f815349} },
/**/                  {{0x88c702d9, 0xbc25e1f1} },
/**/                  {{0xa0df17a9, 0xbfa0e06c} },
/**/                  {{0x7e56b8b1, 0x3f9903ce} },
/**/                  {{0x3c701e30, 0xbf813db8} },
/**/                  {{0x30c99e47, 0xbf63561b} },
/**/                  {{0xd5bffce0, 0x3f76cbf6} } },
/**/                 {{{0x00000000, 0x3fee4000} },
/**/                  {{0xc5cdee22, 0x3fe83bbe} },
/**/                  {{0x04ffc6c3, 0x3c631071} },
/**/                  {{0x86071468, 0x3fe0e61d} },
/**/                  {{0x59be09c9, 0xbc70ccc4} },
/**/                  {{0x647af38b, 0xbfd0df48} },
/**/                  {{0x427c295b, 0x3c7dd47c} },
/**/                  {{0x3ef25277, 0x3fb51faf} },
/**/                  {{0xa81026a7, 0x3bdf056a} },
/**/                  {{0xd443a18b, 0x3f8004ac} },
/**/                  {{0x8178f329, 0x3c027610} },
/**/                  {{0xfbb3a658, 0xbfa095bb} },
/**/                  {{0xa7859d46, 0x3f98c734} },
/**/                  {{0xeefe9a81, 0xbf8162cd} },
/**/                  {{0x8330eac0, 0xbf61c17f} },
/**/                  {{0xe421c20a, 0x3f76293f} } },
/**/                 {{{0x00000000, 0x3fee6000} },
/**/                  {{0x7653f7eb, 0x3fe84c9c} },
/**/                  {{0xfe0a3e8f, 0xbc383611} },
/**/                  {{0x2a7f71b5, 0x3fe0d546} },
/**/                  {{0x596848c6, 0x3c757061} },
/**/                  {{0xb4cf51a6, 0xbfd0cf6d} },
/**/                  {{0x5b18bb8c, 0x3c4c99ab} },
/**/                  {{0x24486227, 0x3fb5275f} },
/**/                  {{0xbb1f4f56, 0x3c5b4a59} },
/**/                  {{0x36238bb2, 0x3f7d77be} },
/**/                  {{0xcaec6ba2, 0x3c1ddbd1} },
/**/                  {{0xe1406cd0, 0xbfa04bc1} },
/**/                  {{0x7f96d6ca, 0x3f988a1e} },
/**/                  {{0xcdffc380, 0xbf8184c5} },
/**/                  {{0x12561f8b, 0xbf603841} },
/**/                  {{0x4d81a668, 0x3f7588b9} } },
/**/                 {{{0x00000000, 0x3fee8000} },
/**/                  {{0x576cc2c5, 0x3fe85d69} },
/**/                  {{0x7fc8b8c3, 0x3c66b66e} },
/**/                  {{0xac74fadc, 0x3fe0c47e} },
/**/                  {{0x77bb1887, 0xbc8035f8} },
/**/                  {{0x7e8202a9, 0xbfd0bf8d} },
/**/                  {{0x1f4d2357, 0x3c798048} },
/**/                  {{0x13725c73, 0x3fb52e6c} },
/**/                  {{0xf5b19ded, 0xbc34c3af} },
/**/                  {{0x7d9c2711, 0x3f7af1a3} },
/**/                  {{0x1af1098d, 0x3bea7ec7} },
/**/                  {{0xb643d11f, 0xbfa0027f} },
/**/                  {{0xc756b7d7, 0x3f984c96} },
/**/                  {{0x6c3ca3ae, 0xbf81a3b6} },
/**/                  {{0x13459246, 0xbf5d7470} },
/**/                  {{0x1e70d9a4, 0x3f74ea6f} } },
/**/                 {{{0x00000000, 0x3feea000} },
/**/                  {{0x78f87ae5, 0x3fe86e25} },
/**/                  {{0x375cfe34, 0x3c8022b1} },
/**/                  {{0x11319104, 0x3fe0b3c7} },
/**/                  {{0x25152519, 0x3c8ac394} },
/**/                  {{0x3ab87c8a, 0xbfd0afa8} },
/**/                  {{0x27b31384, 0x3c724f26} },
/**/                  {{0xe904e078, 0x3fb534d8} },
/**/                  {{0xf8948323, 0xbc55bfde} },
/**/                  {{0xa7bb2dfb, 0x3f7876ec} },
/**/                  {{0x8a87be50, 0xbc197116} },
/**/                  {{0x7f5f95b4, 0xbf9f73ed} },
/**/                  {{0xf11c3266, 0x3f980ea7} },
/**/                  {{0x0c032389, 0xbf81bfb6} },
/**/                  {{0x8bf305a1, 0xbf5a8e77} },
/**/                  {{0x3ec72e6d, 0x3f744e6c} } },
/**/                 {{{0x00000000, 0x3feec000} },
/**/                  {{0xeadc5a2a, 0x3fe87ed0} },
/**/                  {{0xd957f4bc, 0x3c70af5a} },
/**/                  {{0x5d8701b3, 0x3fe0a31f} },
/**/                  {{0x263ce937, 0xbc869b25} },
/**/                  {{0x60757b83, 0xbfd09fbe} },
/**/                  {{0xa96db9ef, 0x3c767aff} },
/**/                  {{0x7a589afb, 0x3fb53aa8} },
/**/                  {{0x0844ff86, 0xbc4b7e8e} },
/**/                  {{0xacf1a65c, 0x3f76077c} },
/**/                  {{0xb13331a9, 0xbc19a3b2} },
/**/                  {{0x472733eb, 0xbf9ee450} },
/**/                  {{0x21e541d7, 0x3f97d05c} },
/**/                  {{0x9d9d4dfc, 0xbf81d8da} },
/**/                  {{0xd3ce1b4a, 0xbf57be45} },
/**/                  {{0x7cb60047, 0x3f73b4ba} } },
/**/                 {{{0x00000000, 0x3feee000} },
/**/                  {{0xbd023119, 0x3fe88f6b} },
/**/                  {{0x25aba660, 0xbc532d1d} },
/**/                  {{0x95d126c6, 0x3fe09287} },
/**/                  {{0xeccc37a6, 0x3c85aad3} },
/**/                  {{0x649e7367, 0xbfd08fd0} },
/**/                  {{0xed21a127, 0x3c71e96c} },
/**/                  {{0x957ec910, 0x3fb53fdd} },
/**/                  {{0xaf97a601, 0xbc339c23} },
/**/                  {{0x5a18e5a2, 0x3f73a336} },
/**/                  {{0x477571de, 0xbc1f7225} },
/**/                  {{0xd4044135, 0xbf9e5629} },
/**/                  {{0x32786dc4, 0x3f9791bd} },
/**/                  {{0xbdf030c4, 0xbf81ef39} },
/**/                  {{0xe21b8bcb, 0xbf550386} },
/**/                  {{0x97aa7fb2, 0x3f731d62} } },
/**/                 {{{0x00000000, 0x3fef0000} },
/**/                  {{0xff57f1f8, 0x3fe89ff5} },
/**/                  {{0x5e177a1b, 0xbc855b9a} },
/**/                  {{0xbdf80108, 0x3fe081ff} },
/**/                  {{0x80108200, 0x3c6ffbdf} },
/**/                  {{0xba010928, 0xbfd07fde} },
/**/                  {{0x7bae0295, 0x3c38d37f} },
/**/                  {{0x0136e69f, 0x3fb5447b} },
/**/                  {{0x0dda278d, 0x3c50316a} },
/**/                  {{0x55103947, 0x3f7149fc} },
/**/                  {{0x849e505f, 0x3c176e96} },
/**/                  {{0xfbe9a2ee, 0xbf9dc97b} },
/**/                  {{0xb08adda9, 0x3f9752d4} },
/**/                  {{0xb540d106, 0xbf8202e8} },
/**/                  {{0x859de3e9, 0xbf525de5} },
/**/                  {{0x4afd9f21, 0x3f72886c} } },
/**/                 {{{0x00000000, 0x3fef2000} },
/**/                  {{0xc1cf3dff, 0x3fe8b06f} },
/**/                  {{0x2656db6d, 0xbc80fb31} },
/**/                  {{0xd971cd38, 0x3fe07187} },
/**/                  {{0x202c20ac, 0x3c89baa4} },
/**/                  {{0xd15893ab, 0xbfd06fe9} },
/**/                  {{0xdc0cb586, 0xbc7a864b} },
/**/                  {{0x7ce57fed, 0x3fb54883} },
/**/                  {{0x294f4b18, 0xbc49498e} },
/**/                  {{0x426ebecc, 0x3f6df762} },
/**/                  {{0xf28644c0, 0xbc022f08} },
/**/                  {{0x5c564b44, 0xbf9d3e48} },
/**/                  {{0xdfea7acf, 0x3f9713ab} },
/**/                  {{0x761db35c, 0xbf8213fc} },
/**/                  {{0x10d60f49, 0xbf4f9a17} },
/**/                  {{0x58700e9b, 0x3f71f5de} } },
/**/                 {{{0x00000000, 0x3fef4000} },
/**/                  {{0x145cf49d, 0x3fe8c0d9} },
/**/                  {{0x76dc4333, 0x3c8bea40} },
/**/                  {{0xeb45139a, 0x3fe0611f} },
/**/                  {{0x65aadb1f, 0x3c7e4998} },
/**/                  {{0x1953a316, 0xbfd05ff2} },
/**/                  {{0xa1b67b0f, 0x3c759922} },
/**/                  {{0xc08c1d66, 0x3fb54bf9} },
/**/                  {{0xd220330c, 0x3c5b9353} },
/**/                  {{0x478cb604, 0x3f69706e} },
/**/                  {{0xa22fd45a, 0xbbfdb6d3} },
/**/                  {{0x5c0d1d38, 0xbf9cb490} },
/**/                  {{0xbbaba2f2, 0x3f96d44b} },
/**/                  {{0x9c6b7de1, 0xbf822289} },
/**/                  {{0xa49803b6, 0xbf4aa143} },
/**/                  {{0x9270e49e, 0x3f7165be} } },
/**/                 {{{0x00000000, 0x3fef6000} },
/**/                  {{0x06f8c4cb, 0x3fe8d132} },
/**/                  {{0xbaa89a8b, 0xbc7b018c} },
/**/                  {{0xf60ab1f4, 0x3fe050c7} },
/**/                  {{0xc6cf5796, 0x3c63f8e2} },
/**/                  {{0xfe998dc0, 0xbfd04ff7} },
/**/                  {{0x7dc56419, 0x3c77873c} },
/**/                  {{0x7cc24121, 0x3fb54ee0} },
/**/                  {{0x8e5c84c5, 0x3c313117} },
/**/                  {{0x50066301, 0x3f64fee1} },
/**/                  {{0x017261a1, 0x3c043698} },
/**/                  {{0x2cc5b4f1, 0xbf9c2c55} },
/**/                  {{0xf759f369, 0x3f9694bc} },
/**/                  {{0x6c93426a, 0xbf822ea4} },
/**/                  {{0x135d6c51, 0xbf45d0a1} },
/**/                  {{0xe62dc18f, 0x3f70d811} } },
/**/                 {{{0x00000000, 0x3fef8000} },
/**/                  {{0xa99cc05e, 0x3fe8e17a} },
/**/                  {{0xab042f61, 0xbc7ec182} },
/**/                  {{0xfbefe001, 0x3fe0407f} },
/**/                  {{0xfbf80041, 0x3c401ffe} },
/**/                  {{0xebd00209, 0xbfd03ffb} },
/**/                  {{0xb9004112, 0xbc53ff3c} },
/**/                  {{0x5aaf6d91, 0x3fb5513a} },
/**/                  {{0xc0516ddb, 0x3c54a20d} },
/**/                  {{0xc6ac4038, 0x3f60a27f} },
/**/                  {{0x2a340912, 0x3bf06bee} },
/**/                  {{0xccd6032a, 0xbf9ba597} },
/**/                  {{0x002bb974, 0x3f965508} },
/**/                  {{0xd2d1068b, 0xbf823860} },
/**/                  {{0x666265bc, 0xbf41277e} },
/**/                  {{0x656b66ea, 0x3f704cdc} } },
/**/                 {{{0x00000000, 0x3fefa000} },
/**/                  {{0x0c44f167, 0x3fe8f1b3} },
/**/                  {{0xb93933fd, 0x3c6dd1ca} },
/**/                  {{0xfeb82e4e, 0x3fe03047} },
/**/                  {{0x5272e5ac, 0x3c69ee56} },
/**/                  {{0x49a09c45, 0xbfd02ffe} },
/**/                  {{0xb26267bb, 0xbc700a59} },
/**/                  {{0xfc062d2f, 0x3fb55309} },
/**/                  {{0xb11938e0, 0x3c5dba48} },
/**/                  {{0xe4f365be, 0x3f58b61b} },
/**/                  {{0xa79ad31a, 0x3bf8b585} },
/**/                  {{0x08d4ad17, 0xbf9b2059} },
/**/                  {{0xfe379940, 0x3f961534} },
/**/                  {{0x62a1270e, 0xbf823fd2} },
/**/                  {{0x3f3a0aec, 0xbf394a53} },
/**/                  {{0xa04bcae2, 0x3f6f8842} } },
/**/                 {{{0x00000000, 0x3fefc000} },
/**/                  {{0x3eeef187, 0x3fe901db} },
/**/                  {{0xe5603c8f, 0x3c868665} },
/**/                  {{0xffbf7f80, 0x3fe0201f} },
/**/                  {{0xffbf7f80, 0x3c20201f} },
/**/                  {{0x7ebe8004, 0xbfd01fff} },
/**/                  {{0xcf979001, 0xbc4213ff} },
/**/                  {{0xfb0012db, 0x3fb55451} },
/**/                  {{0xf73aa59f, 0xbc395606} },
/**/                  {{0xfc757100, 0x3f50509f} },
/**/                  {{0xfee554d0, 0x3bebc7da} },
/**/                  {{0x7d3424d0, 0xbf9a9c99} },
/**/                  {{0xd5ac0217, 0x3f95d54b} },
/**/                  {{0x564b3c49, 0xbf82450c} },
/**/                  {{0xe6d3e986, 0xbf3091df} },
/**/                  {{0x3bef5a22, 0x3f6e7bc6} } },
/**/                 {{{0x00000000, 0x3fefe000} },
/**/                  {{0x5199833b, 0x3fe911f3} },
/**/                  {{0x0edbf522, 0x3c63ae8a} },
/**/                  {{0xfffbfbfe, 0x3fe01007} },
/**/                  {{0xfffbfbfe, 0x3ba01007} },
/**/                  {{0xefebf400, 0xbfd00fff} },
/**/                  {{0xfff9f97d, 0xbc401209} },
/**/                  {{0xea5aaaf6, 0x3fb55514} },
/**/                  {{0xb5b7b240, 0xbc529baa} },
/**/                  {{0xffc7abc4, 0x3f402827} },
/**/                  {{0xbfee6ab3, 0x3b5ba3d6} },
/**/                  {{0x97d67093, 0xbf9a1a59} },
/**/                  {{0x28080aaf, 0x3f959554} },
/**/                  {{0x8e892ce2, 0xbf824821} },
/**/                  {{0xfe70a2a6, 0xbf204877} },
/**/                  {{0x0e8ddd67, 0x3f6d7447} } },
/**/                 {{{0x00000000, 0x3feff800} },
/**/                  {{0xd439826e, 0x3fe91dfa} },
/**/                  {{0x6df48d55, 0xbc786a19} },
/**/                  {{0x7ffffbff, 0x3fe00400} },
/**/                  {{0xffbff800, 0xbbeffffe} },
/**/                  {{0xffbfebfd, 0xbfd003ff} },
/**/                  {{0x9ffff9fe, 0xbb600480} },
/**/                  {{0x53aa5aab, 0x3fb55551} },
/**/                  {{0x9baaab5b, 0xbc542a4a} },
/**/                  {{0x7fffc7eb, 0x3f200a02} },
/**/                  {{0x4770e940, 0xbb7dfffe} },
/**/                  {{0x9997d8d0, 0xbf99b9a5} },
/**/                  {{0x50a80a03, 0x3f956555} },
/**/                  {{0x86456493, 0xbf824914} },
/**/                  {{0x7ffe7329, 0xbf001207} },
/**/                  {{0x1c63fe2a, 0x3f6cb1ef} } },
  };

#endif
#endif
