/*
 * IBM Accurate Mathematical Library
 * Written by International Business Machines Corp.
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/****************************************************************/
/* TABLES FOR THE ulog() FUNCTION                               */
/****************************************************************/

#ifdef BIG_ENDI
  static const number
           Iu[182] = {                            /* 1/ui   */
/**/                  {{0x3ff6a13c, 0xd1537290} },
/**/                  {{0x3ff68168, 0x16816817} },
/**/                  {{0x3ff661ec, 0x6a5122f9} },
/**/                  {{0x3ff642c8, 0x590b2164} },
/**/                  {{0x3ff623fa, 0x77016240} },
/**/                  {{0x3ff60581, 0x60581606} },
/**/                  {{0x3ff5e75b, 0xb8d015e7} },
/**/                  {{0x3ff5c988, 0x2b931057} },
/**/                  {{0x3ff5ac05, 0x6b015ac0} },
/**/                  {{0x3ff58ed2, 0x308158ed} },
/**/                  {{0x3ff571ed, 0x3c506b3a} },
/**/                  {{0x3ff55555, 0x55555555} },
/**/                  {{0x3ff53909, 0x48f40feb} },
/**/                  {{0x3ff51d07, 0xeae2f815} },
/**/                  {{0x3ff50150, 0x15015015} },
/**/                  {{0x3ff4e5e0, 0xa72f0539} },
/**/                  {{0x3ff4cab8, 0x8725af6e} },
/**/                  {{0x3ff4afd6, 0xa052bf5b} },
/**/                  {{0x3ff49539, 0xe3b2d067} },
/**/                  {{0x3ff47ae1, 0x47ae147b} },
/**/                  {{0x3ff460cb, 0xc7f5cf9a} },
/**/                  {{0x3ff446f8, 0x6562d9fb} },
/**/                  {{0x3ff42d66, 0x25d51f87} },
/**/                  {{0x3ff41414, 0x14141414} },
/**/                  {{0x3ff3fb01, 0x3fb013fb} },
/**/                  {{0x3ff3e22c, 0xbce4a902} },
/**/                  {{0x3ff3c995, 0xa47babe7} },
/**/                  {{0x3ff3b13b, 0x13b13b14} },
/**/                  {{0x3ff3991c, 0x2c187f63} },
/**/                  {{0x3ff38138, 0x13813814} },
/**/                  {{0x3ff3698d, 0xf3de0748} },
/**/                  {{0x3ff3521c, 0xfb2b78c1} },
/**/                  {{0x3ff33ae4, 0x5b57bcb2} },
/**/                  {{0x3ff323e3, 0x4a2b10bf} },
/**/                  {{0x3ff30d19, 0x0130d190} },
/**/                  {{0x3ff2f684, 0xbda12f68} },
/**/                  {{0x3ff2e025, 0xc04b8097} },
/**/                  {{0x3ff2c9fb, 0x4d812ca0} },
/**/                  {{0x3ff2b404, 0xad012b40} },
/**/                  {{0x3ff29e41, 0x29e4129e} },
/**/                  {{0x3ff288b0, 0x1288b013} },
/**/                  {{0x3ff27350, 0xb8812735} },
/**/                  {{0x3ff25e22, 0x708092f1} },
/**/                  {{0x3ff24924, 0x92492492} },
/**/                  {{0x3ff23456, 0x789abcdf} },
/**/                  {{0x3ff21fb7, 0x8121fb78} },
/**/                  {{0x3ff20b47, 0x0c67c0d9} },
/**/                  {{0x3ff1f704, 0x7dc11f70} },
/**/                  {{0x3ff1e2ef, 0x3b3fb874} },
/**/                  {{0x3ff1cf06, 0xada2811d} },
/**/                  {{0x3ff1bb4a, 0x4046ed29} },
/**/                  {{0x3ff1a7b9, 0x611a7b96} },
/**/                  {{0x3ff19453, 0x808ca29c} },
/**/                  {{0x3ff18118, 0x11811812} },
/**/                  {{0x3ff16e06, 0x89427379} },
/**/                  {{0x3ff15b1e, 0x5f75270d} },
/**/                  {{0x3ff1485f, 0x0e0acd3b} },
/**/                  {{0x3ff135c8, 0x1135c811} },
/**/                  {{0x3ff12358, 0xe75d3033} },
/**/                  {{0x3ff11111, 0x11111111} },
/**/                  {{0x3ff0fef0, 0x10fef011} },
/**/                  {{0x3ff0ecf5, 0x6be69c90} },
/**/                  {{0x3ff0db20, 0xa88f4696} },
/**/                  {{0x3ff0c971, 0x4fbcda3b} },
/**/                  {{0x3ff0b7e6, 0xec259dc8} },
/**/                  {{0x3ff0a681, 0x0a6810a7} },
/**/                  {{0x3ff0953f, 0x39010954} },
/**/                  {{0x3ff08421, 0x08421084} },
/**/                  {{0x3ff07326, 0x0a47f7c6} },
/**/                  {{0x3ff0624d, 0xd2f1a9fc} },
/**/                  {{0x3ff05197, 0xf7d73404} },
/**/                  {{0x3ff04104, 0x10410410} },
/**/                  {{0x3ff03091, 0xb51f5e1a} },
/**/                  {{0x3ff02040, 0x81020408} },
/**/                  {{0x3ff01010, 0x10101010} },
/**/                  {{0x3ff00000, 0x00000000} },
/**/                  {{0x3fefe01f, 0xe01fe020} },
/**/                  {{0x3fefc07f, 0x01fc07f0} },
/**/                  {{0x3fefa11c, 0xaa01fa12} },
/**/                  {{0x3fef81f8, 0x1f81f820} },
/**/                  {{0x3fef6310, 0xaca0dbb5} },
/**/                  {{0x3fef4465, 0x9e4a4271} },
/**/                  {{0x3fef25f6, 0x44230ab5} },
/**/                  {{0x3fef07c1, 0xf07c1f08} },
/**/                  {{0x3feee9c7, 0xf8458e02} },
/**/                  {{0x3feecc07, 0xb301ecc0} },
/**/                  {{0x3feeae80, 0x7aba01eb} },
/**/                  {{0x3fee9131, 0xabf0b767} },
/**/                  {{0x3fee741a, 0xa59750e4} },
/**/                  {{0x3fee573a, 0xc901e574} },
/**/                  {{0x3fee3a91, 0x79dc1a73} },
/**/                  {{0x3fee1e1e, 0x1e1e1e1e} },
/**/                  {{0x3fee01e0, 0x1e01e01e} },
/**/                  {{0x3fede5d6, 0xe3f8868a} },
/**/                  {{0x3fedca01, 0xdca01dca} },
/**/                  {{0x3fedae60, 0x76b981db} },
/**/                  {{0x3fed92f2, 0x231e7f8a} },
/**/                  {{0x3fed77b6, 0x54b82c34} },
/**/                  {{0x3fed5cac, 0x807572b2} },
/**/                  {{0x3fed41d4, 0x1d41d41d} },
/**/                  {{0x3fed272c, 0xa3fc5b1a} },
/**/                  {{0x3fed0cb5, 0x8f6ec074} },
/**/                  {{0x3fecf26e, 0x5c44bfc6} },
/**/                  {{0x3fecd856, 0x89039b0b} },
/**/                  {{0x3fecbe6d, 0x9601cbe7} },
/**/                  {{0x3feca4b3, 0x055ee191} },
/**/                  {{0x3fec8b26, 0x5afb8a42} },
/**/                  {{0x3fec71c7, 0x1c71c71c} },
/**/                  {{0x3fec5894, 0xd10d4986} },
/**/                  {{0x3fec3f8f, 0x01c3f8f0} },
/**/                  {{0x3fec26b5, 0x392ea01c} },
/**/                  {{0x3fec0e07, 0x0381c0e0} },
/**/                  {{0x3febf583, 0xee868d8b} },
/**/                  {{0x3febdd2b, 0x899406f7} },
/**/                  {{0x3febc4fd, 0x65883e7b} },
/**/                  {{0x3febacf9, 0x14c1bad0} },
/**/                  {{0x3feb951e, 0x2b18ff23} },
/**/                  {{0x3feb7d6c, 0x3dda338b} },
/**/                  {{0x3feb65e2, 0xe3beee05} },
/**/                  {{0x3feb4e81, 0xb4e81b4f} },
/**/                  {{0x3feb3748, 0x4ad806ce} },
/**/                  {{0x3feb2036, 0x406c80d9} },
/**/                  {{0x3feb094b, 0x31d922a4} },
/**/                  {{0x3feaf286, 0xbca1af28} },
/**/                  {{0x3feadbe8, 0x7f94905e} },
/**/                  {{0x3feac570, 0x1ac5701b} },
/**/                  {{0x3feaaf1d, 0x2f87ebfd} },
/**/                  {{0x3fea98ef, 0x606a63be} },
/**/                  {{0x3fea82e6, 0x5130e159} },
/**/                  {{0x3fea6d01, 0xa6d01a6d} },
/**/                  {{0x3fea5741, 0x07688a4a} },
/**/                  {{0x3fea41a4, 0x1a41a41a} },
/**/                  {{0x3fea2c2a, 0x87c51ca0} },
/**/                  {{0x3fea16d3, 0xf97a4b02} },
/**/                  {{0x3fea01a0, 0x1a01a01a} },
/**/                  {{0x3fe9ec8e, 0x951033d9} },
/**/                  {{0x3fe9d79f, 0x176b682d} },
/**/                  {{0x3fe9c2d1, 0x4ee4a102} },
/**/                  {{0x3fe9ae24, 0xea5510da} },
/**/                  {{0x3fe99999, 0x9999999a} },
/**/                  {{0x3fe9852f, 0x0d8ec0ff} },
/**/                  {{0x3fe970e4, 0xf80cb872} },
/**/                  {{0x3fe95cbb, 0x0be377ae} },
/**/                  {{0x3fe948b0, 0xfcd6e9e0} },
/**/                  {{0x3fe934c6, 0x7f9b2ce6} },
/**/                  {{0x3fe920fb, 0x49d0e229} },
/**/                  {{0x3fe90d4f, 0x120190d5} },
/**/                  {{0x3fe8f9c1, 0x8f9c18fa} },
/**/                  {{0x3fe8e652, 0x7af1373f} },
/**/                  {{0x3fe8d301, 0x8d3018d3} },
/**/                  {{0x3fe8bfce, 0x8062ff3a} },
/**/                  {{0x3fe8acb9, 0x0f6bf3aa} },
/**/                  {{0x3fe899c0, 0xf601899c} },
/**/                  {{0x3fe886e5, 0xf0abb04a} },
/**/                  {{0x3fe87427, 0xbcc092b9} },
/**/                  {{0x3fe86186, 0x18618618} },
/**/                  {{0x3fe84f00, 0xc2780614} },
/**/                  {{0x3fe83c97, 0x7ab2bedd} },
/**/                  {{0x3fe82a4a, 0x0182a4a0} },
/**/                  {{0x3fe81818, 0x18181818} },
/**/                  {{0x3fe80601, 0x80601806} },
/**/                  {{0x3fe7f405, 0xfd017f40} },
/**/                  {{0x3fe7e225, 0x515a4f1d} },
/**/                  {{0x3fe7d05f, 0x417d05f4} },
/**/                  {{0x3fe7beb3, 0x922e017c} },
/**/                  {{0x3fe7ad22, 0x08e0ecc3} },
/**/                  {{0x3fe79baa, 0x6bb6398b} },
/**/                  {{0x3fe78a4c, 0x8178a4c8} },
/**/                  {{0x3fe77908, 0x119ac60d} },
/**/                  {{0x3fe767dc, 0xe434a9b1} },
/**/                  {{0x3fe756ca, 0xc201756d} },
/**/                  {{0x3fe745d1, 0x745d1746} },
/**/                  {{0x3fe734f0, 0xc541fe8d} },
/**/                  {{0x3fe72428, 0x7f46debc} },
/**/                  {{0x3fe71378, 0x6d9c7c09} },
/**/                  {{0x3fe702e0, 0x5c0b8170} },
/**/                  {{0x3fe6f260, 0x16f26017} },
/**/                  {{0x3fe6e1f7, 0x6b4337c7} },
/**/                  {{0x3fe6d1a6, 0x2681c861} },
/**/                  {{0x3fe6c16c, 0x16c16c17} },
/**/                  {{0x3fe6b149, 0x0aa31a3d} },
/**/                  {{0x3fe6a13c, 0xd1537290} },
  };

  static const number
           Iv[362] = {                            /* 1/vj   */
/**/                  {{0x3ff00b47, 0xee93bfe3} },
/**/                  {{0x3ff00b37, 0xd80c106f} },
/**/                  {{0x3ff00b27, 0xc1a4a47a} },
/**/                  {{0x3ff00b17, 0xab5d7ba2} },
/**/                  {{0x3ff00b07, 0x95369587} },
/**/                  {{0x3ff00af7, 0x7f2ff1c6} },
/**/                  {{0x3ff00ae7, 0x69499000} },
/**/                  {{0x3ff00ad7, 0x53836fd3} },
/**/                  {{0x3ff00ac7, 0x3ddd90dd} },
/**/                  {{0x3ff00ab7, 0x2857f2bf} },
/**/                  {{0x3ff00aa7, 0x12f29517} },
/**/                  {{0x3ff00a96, 0xfdad7784} },
/**/                  {{0x3ff00a86, 0xe88899a5} },
/**/                  {{0x3ff00a76, 0xd383fb19} },
/**/                  {{0x3ff00a66, 0xbe9f9b7f} },
/**/                  {{0x3ff00a56, 0xa9db7a76} },
/**/                  {{0x3ff00a46, 0x9537979d} },
/**/                  {{0x3ff00a36, 0x80b3f293} },
/**/                  {{0x3ff00a26, 0x6c508af8} },
/**/                  {{0x3ff00a16, 0x580d606a} },
/**/                  {{0x3ff00a06, 0x43ea7288} },
/**/                  {{0x3ff009f6, 0x2fe7c0f1} },
/**/                  {{0x3ff009e6, 0x1c054b44} },
/**/                  {{0x3ff009d6, 0x08431122} },
/**/                  {{0x3ff009c5, 0xf4a11227} },
/**/                  {{0x3ff009b5, 0xe11f4df4} },
/**/                  {{0x3ff009a5, 0xcdbdc428} },
/**/                  {{0x3ff00995, 0xba7c7462} },
/**/                  {{0x3ff00985, 0xa75b5e40} },
/**/                  {{0x3ff00975, 0x945a8162} },
/**/                  {{0x3ff00965, 0x8179dd68} },
/**/                  {{0x3ff00955, 0x6eb971ef} },
/**/                  {{0x3ff00945, 0x5c193e98} },
/**/                  {{0x3ff00935, 0x49994301} },
/**/                  {{0x3ff00925, 0x37397eca} },
/**/                  {{0x3ff00915, 0x24f9f192} },
/**/                  {{0x3ff00905, 0x12da9af7} },
/**/                  {{0x3ff008f5, 0x00db7a99} },
/**/                  {{0x3ff008e4, 0xeefc9018} },
/**/                  {{0x3ff008d4, 0xdd3ddb12} },
/**/                  {{0x3ff008c4, 0xcb9f5b26} },
/**/                  {{0x3ff008b4, 0xba210ff4} },
/**/                  {{0x3ff008a4, 0xa8c2f91a} },
/**/                  {{0x3ff00894, 0x97851639} },
/**/                  {{0x3ff00884, 0x866766ef} },
/**/                  {{0x3ff00874, 0x7569eadb} },
/**/                  {{0x3ff00864, 0x648ca19d} },
/**/                  {{0x3ff00854, 0x53cf8ad3} },
/**/                  {{0x3ff00844, 0x4332a61e} },
/**/                  {{0x3ff00834, 0x32b5f31b} },
/**/                  {{0x3ff00824, 0x2259716c} },
/**/                  {{0x3ff00814, 0x121d20ad} },
/**/                  {{0x3ff00804, 0x02010080} },
/**/                  {{0x3ff007f3, 0xf2051083} },
/**/                  {{0x3ff007e3, 0xe2295056} },
/**/                  {{0x3ff007d3, 0xd26dbf97} },
/**/                  {{0x3ff007c3, 0xc2d25de5} },
/**/                  {{0x3ff007b3, 0xb3572ae2} },
/**/                  {{0x3ff007a3, 0xa3fc262a} },
/**/                  {{0x3ff00793, 0x94c14f5f} },
/**/                  {{0x3ff00783, 0x85a6a61e} },
/**/                  {{0x3ff00773, 0x76ac2a08} },
/**/                  {{0x3ff00763, 0x67d1dabb} },
/**/                  {{0x3ff00753, 0x5917b7d7} },
/**/                  {{0x3ff00743, 0x4a7dc0fb} },
/**/                  {{0x3ff00733, 0x3c03f5c7} },
/**/                  {{0x3ff00723, 0x2daa55da} },
/**/                  {{0x3ff00713, 0x1f70e0d3} },
/**/                  {{0x3ff00703, 0x11579652} },
/**/                  {{0x3ff006f3, 0x035e75f5} },
/**/                  {{0x3ff006e2, 0xf5857f5d} },
/**/                  {{0x3ff006d2, 0xe7ccb228} },
/**/                  {{0x3ff006c2, 0xda340df6} },
/**/                  {{0x3ff006b2, 0xccbb9266} },
/**/                  {{0x3ff006a2, 0xbf633f18} },
/**/                  {{0x3ff00692, 0xb22b13ab} },
/**/                  {{0x3ff00682, 0xa5130fbe} },
/**/                  {{0x3ff00672, 0x981b32f1} },
/**/                  {{0x3ff00662, 0x8b437ce4} },
/**/                  {{0x3ff00652, 0x7e8bed35} },
/**/                  {{0x3ff00642, 0x71f48383} },
/**/                  {{0x3ff00632, 0x657d3f70} },
/**/                  {{0x3ff00622, 0x59262098} },
/**/                  {{0x3ff00612, 0x4cef269e} },
/**/                  {{0x3ff00602, 0x40d8511e} },
/**/                  {{0x3ff005f2, 0x34e19fba} },
/**/                  {{0x3ff005e2, 0x290b1211} },
/**/                  {{0x3ff005d2, 0x1d54a7c1} },
/**/                  {{0x3ff005c2, 0x11be606b} },
/**/                  {{0x3ff005b2, 0x06483bad} },
/**/                  {{0x3ff005a1, 0xfaf23928} },
/**/                  {{0x3ff00591, 0xefbc587b} },
/**/                  {{0x3ff00581, 0xe4a69945} },
/**/                  {{0x3ff00571, 0xd9b0fb25} },
/**/                  {{0x3ff00561, 0xcedb7dbc} },
/**/                  {{0x3ff00551, 0xc42620a9} },
/**/                  {{0x3ff00541, 0xb990e38b} },
/**/                  {{0x3ff00531, 0xaf1bc601} },
/**/                  {{0x3ff00521, 0xa4c6c7ac} },
/**/                  {{0x3ff00511, 0x9a91e82a} },
/**/                  {{0x3ff00501, 0x907d271c} },
/**/                  {{0x3ff004f1, 0x86888421} },
/**/                  {{0x3ff004e1, 0x7cb3fed8} },
/**/                  {{0x3ff004d1, 0x72ff96e0} },
/**/                  {{0x3ff004c1, 0x696b4bdb} },
/**/                  {{0x3ff004b1, 0x5ff71d66} },
/**/                  {{0x3ff004a1, 0x56a30b21} },
/**/                  {{0x3ff00491, 0x4d6f14ad} },
/**/                  {{0x3ff00481, 0x445b39a8} },
/**/                  {{0x3ff00471, 0x3b6779b3} },
/**/                  {{0x3ff00461, 0x3293d46c} },
/**/                  {{0x3ff00451, 0x29e04974} },
/**/                  {{0x3ff00441, 0x214cd869} },
/**/                  {{0x3ff00431, 0x18d980ed} },
/**/                  {{0x3ff00421, 0x1086429d} },
/**/                  {{0x3ff00411, 0x08531d1a} },
/**/                  {{0x3ff00401, 0x00401004} },
/**/                  {{0x3ff003f0, 0xf84d1afa} },
/**/                  {{0x3ff003e0, 0xf07a3d9b} },
/**/                  {{0x3ff003d0, 0xe8c77787} },
/**/                  {{0x3ff003c0, 0xe134c85f} },
/**/                  {{0x3ff003b0, 0xd9c22fc1} },
/**/                  {{0x3ff003a0, 0xd26fad4d} },
/**/                  {{0x3ff00390, 0xcb3d40a3} },
/**/                  {{0x3ff00380, 0xc42ae963} },
/**/                  {{0x3ff00370, 0xbd38a72c} },
/**/                  {{0x3ff00360, 0xb666799e} },
/**/                  {{0x3ff00350, 0xafb46058} },
/**/                  {{0x3ff00340, 0xa9225afa} },
/**/                  {{0x3ff00330, 0xa2b06925} },
/**/                  {{0x3ff00320, 0x9c5e8a77} },
/**/                  {{0x3ff00310, 0x962cbe90} },
/**/                  {{0x3ff00300, 0x901b0511} },
/**/                  {{0x3ff002f0, 0x8a295d98} },
/**/                  {{0x3ff002e0, 0x8457c7c6} },
/**/                  {{0x3ff002d0, 0x7ea6433a} },
/**/                  {{0x3ff002c0, 0x7914cf94} },
/**/                  {{0x3ff002b0, 0x73a36c73} },
/**/                  {{0x3ff002a0, 0x6e521978} },
/**/                  {{0x3ff00290, 0x6920d642} },
/**/                  {{0x3ff00280, 0x640fa271} },
/**/                  {{0x3ff00270, 0x5f1e7da5} },
/**/                  {{0x3ff00260, 0x5a4d677d} },
/**/                  {{0x3ff00250, 0x559c5f9a} },
/**/                  {{0x3ff00240, 0x510b659a} },
/**/                  {{0x3ff00230, 0x4c9a791f} },
/**/                  {{0x3ff00220, 0x484999c6} },
/**/                  {{0x3ff00210, 0x4418c732} },
/**/                  {{0x3ff00200, 0x40080100} },
/**/                  {{0x3ff001f0, 0x3c1746d2} },
/**/                  {{0x3ff001e0, 0x38469846} },
/**/                  {{0x3ff001d0, 0x3495f4fd} },
/**/                  {{0x3ff001c0, 0x31055c96} },
/**/                  {{0x3ff001b0, 0x2d94ceb2} },
/**/                  {{0x3ff001a0, 0x2a444af0} },
/**/                  {{0x3ff00190, 0x2713d0ef} },
/**/                  {{0x3ff00180, 0x24036051} },
/**/                  {{0x3ff00170, 0x2112f8b4} },
/**/                  {{0x3ff00160, 0x1e4299b9} },
/**/                  {{0x3ff00150, 0x1b9242ff} },
/**/                  {{0x3ff00140, 0x1901f427} },
/**/                  {{0x3ff00130, 0x1691acd0} },
/**/                  {{0x3ff00120, 0x14416c9a} },
/**/                  {{0x3ff00110, 0x12113324} },
/**/                  {{0x3ff00100, 0x10010010} },
/**/                  {{0x3ff000f0, 0x0e10d2fc} },
/**/                  {{0x3ff000e0, 0x0c40ab89} },
/**/                  {{0x3ff000d0, 0x0a908957} },
/**/                  {{0x3ff000c0, 0x09006c05} },
/**/                  {{0x3ff000b0, 0x07905334} },
/**/                  {{0x3ff000a0, 0x06403e82} },
/**/                  {{0x3ff00090, 0x05102d92} },
/**/                  {{0x3ff00080, 0x04002001} },
/**/                  {{0x3ff00070, 0x03101571} },
/**/                  {{0x3ff00060, 0x02400d80} },
/**/                  {{0x3ff00050, 0x019007d0} },
/**/                  {{0x3ff00040, 0x01000400} },
/**/                  {{0x3ff00030, 0x009001b0} },
/**/                  {{0x3ff00020, 0x00400080} },
/**/                  {{0x3ff00010, 0x00100010} },
/**/                  {{0x3ff00000, 0x00000000} },
/**/                  {{0x3fefffe0, 0x001fffe0} },
/**/                  {{0x3fefffc0, 0x007fff00} },
/**/                  {{0x3fefffa0, 0x011ffca0} },
/**/                  {{0x3fefff80, 0x01fff800} },
/**/                  {{0x3fefff60, 0x031ff060} },
/**/                  {{0x3fefff40, 0x047fe501} },
/**/                  {{0x3fefff20, 0x061fd521} },
/**/                  {{0x3fefff00, 0x07ffc002} },
/**/                  {{0x3feffee0, 0x0a1fa4e3} },
/**/                  {{0x3feffec0, 0x0c7f8305} },
/**/                  {{0x3feffea0, 0x0f1f59a7} },
/**/                  {{0x3feffe80, 0x11ff280a} },
/**/                  {{0x3feffe60, 0x151eed6e} },
/**/                  {{0x3feffe40, 0x187ea913} },
/**/                  {{0x3feffe20, 0x1c1e5a39} },
/**/                  {{0x3feffe00, 0x1ffe0020} },
/**/                  {{0x3feffde0, 0x241d9a09} },
/**/                  {{0x3feffdc0, 0x287d2733} },
/**/                  {{0x3feffda0, 0x2d1ca6e0} },
/**/                  {{0x3feffd80, 0x31fc184e} },
/**/                  {{0x3feffd60, 0x371b7abf} },
/**/                  {{0x3feffd40, 0x3c7acd72} },
/**/                  {{0x3feffd20, 0x421a0fa9} },
/**/                  {{0x3feffd00, 0x47f940a2} },
/**/                  {{0x3feffce0, 0x4e185f9f} },
/**/                  {{0x3feffcc0, 0x54776bdf} },
/**/                  {{0x3feffca0, 0x5b1664a3} },
/**/                  {{0x3feffc80, 0x61f5492c} },
/**/                  {{0x3feffc60, 0x691418b9} },
/**/                  {{0x3feffc40, 0x7072d28b} },
/**/                  {{0x3feffc20, 0x781175e3} },
/**/                  {{0x3feffc00, 0x7ff00200} },
/**/                  {{0x3feffbe0, 0x880e7623} },
/**/                  {{0x3feffbc0, 0x906cd18c} },
/**/                  {{0x3feffba0, 0x990b137c} },
/**/                  {{0x3feffb80, 0xa1e93b34} },
/**/                  {{0x3feffb60, 0xab0747f3} },
/**/                  {{0x3feffb40, 0xb46538fa} },
/**/                  {{0x3feffb20, 0xbe030d89} },
/**/                  {{0x3feffb00, 0xc7e0c4e1} },
/**/                  {{0x3feffae0, 0xd1fe5e43} },
/**/                  {{0x3feffac0, 0xdc5bd8ee} },
/**/                  {{0x3feffaa0, 0xe6f93424} },
/**/                  {{0x3feffa80, 0xf1d66f25} },
/**/                  {{0x3feffa60, 0xfcf38931} },
/**/                  {{0x3feffa41, 0x08508189} },
/**/                  {{0x3feffa21, 0x13ed576d} },
/**/                  {{0x3feffa01, 0x1fca0a1e} },
/**/                  {{0x3feff9e1, 0x2be698dd} },
/**/                  {{0x3feff9c1, 0x384302e9} },
/**/                  {{0x3feff9a1, 0x44df4785} },
/**/                  {{0x3feff981, 0x51bb65ef} },
/**/                  {{0x3feff961, 0x5ed75d6a} },
/**/                  {{0x3feff941, 0x6c332d34} },
/**/                  {{0x3feff921, 0x79ced490} },
/**/                  {{0x3feff901, 0x87aa52be} },
/**/                  {{0x3feff8e1, 0x95c5a6fe} },
/**/                  {{0x3feff8c1, 0xa420d091} },
/**/                  {{0x3feff8a1, 0xb2bbceb7} },
/**/                  {{0x3feff881, 0xc196a0b2} },
/**/                  {{0x3feff861, 0xd0b145c2} },
/**/                  {{0x3feff841, 0xe00bbd28} },
/**/                  {{0x3feff821, 0xefa60624} },
/**/                  {{0x3feff801, 0xff801ff8} },
/**/                  {{0x3feff7e2, 0x0f9a09e3} },
/**/                  {{0x3feff7c2, 0x1ff3c328} },
/**/                  {{0x3feff7a2, 0x308d4b05} },
/**/                  {{0x3feff782, 0x4166a0bd} },
/**/                  {{0x3feff762, 0x527fc390} },
/**/                  {{0x3feff742, 0x63d8b2bf} },
/**/                  {{0x3feff722, 0x75716d8b} },
/**/                  {{0x3feff702, 0x8749f334} },
/**/                  {{0x3feff6e2, 0x996242fb} },
/**/                  {{0x3feff6c2, 0xabba5c21} },
/**/                  {{0x3feff6a2, 0xbe523de8} },
/**/                  {{0x3feff682, 0xd129e78f} },
/**/                  {{0x3feff662, 0xe4415858} },
/**/                  {{0x3feff642, 0xf7988f84} },
/**/                  {{0x3feff623, 0x0b2f8c54} },
/**/                  {{0x3feff603, 0x1f064e08} },
/**/                  {{0x3feff5e3, 0x331cd3e1} },
/**/                  {{0x3feff5c3, 0x47731d21} },
/**/                  {{0x3feff5a3, 0x5c092908} },
/**/                  {{0x3feff583, 0x70def6d7} },
/**/                  {{0x3feff563, 0x85f485d0} },
/**/                  {{0x3feff543, 0x9b49d532} },
/**/                  {{0x3feff523, 0xb0dee440} },
/**/                  {{0x3feff503, 0xc6b3b23b} },
/**/                  {{0x3feff4e3, 0xdcc83e62} },
/**/                  {{0x3feff4c3, 0xf31c87f8} },
/**/                  {{0x3feff4a4, 0x09b08e3d} },
/**/                  {{0x3feff484, 0x20845073} },
/**/                  {{0x3feff464, 0x3797cdda} },
/**/                  {{0x3feff444, 0x4eeb05b4} },
/**/                  {{0x3feff424, 0x667df741} },
/**/                  {{0x3feff404, 0x7e50a1c3} },
/**/                  {{0x3feff3e4, 0x9663047b} },
/**/                  {{0x3feff3c4, 0xaeb51eaa} },
/**/                  {{0x3feff3a4, 0xc746ef91} },
/**/                  {{0x3feff384, 0xe0187672} },
/**/                  {{0x3feff364, 0xf929b28d} },
/**/                  {{0x3feff345, 0x127aa323} },
/**/                  {{0x3feff325, 0x2c0b4776} },
/**/                  {{0x3feff305, 0x45db9ec7} },
/**/                  {{0x3feff2e5, 0x5feba858} },
/**/                  {{0x3feff2c5, 0x7a3b6369} },
/**/                  {{0x3feff2a5, 0x94cacf3b} },
/**/                  {{0x3feff285, 0xaf99eb11} },
/**/                  {{0x3feff265, 0xcaa8b62a} },
/**/                  {{0x3feff245, 0xe5f72fc9} },
/**/                  {{0x3feff226, 0x0185572f} },
/**/                  {{0x3feff206, 0x1d532b9d} },
/**/                  {{0x3feff1e6, 0x3960ac54} },
/**/                  {{0x3feff1c6, 0x55add896} },
/**/                  {{0x3feff1a6, 0x723aafa3} },
/**/                  {{0x3feff186, 0x8f0730be} },
/**/                  {{0x3feff166, 0xac135b27} },
/**/                  {{0x3feff146, 0xc95f2e21} },
/**/                  {{0x3feff126, 0xe6eaa8eb} },
/**/                  {{0x3feff107, 0x04b5cac9} },
/**/                  {{0x3feff0e7, 0x22c092fb} },
/**/                  {{0x3feff0c7, 0x410b00c2} },
/**/                  {{0x3feff0a7, 0x5f951360} },
/**/                  {{0x3feff087, 0x7e5eca16} },
/**/                  {{0x3feff067, 0x9d682426} },
/**/                  {{0x3feff047, 0xbcb120d2} },
/**/                  {{0x3feff027, 0xdc39bf5a} },
/**/                  {{0x3feff007, 0xfc01ff00} },
/**/                  {{0x3fefefe8, 0x1c09df07} },
/**/                  {{0x3fefefc8, 0x3c515eae} },
/**/                  {{0x3fefefa8, 0x5cd87d38} },
/**/                  {{0x3fefef88, 0x7d9f39e6} },
/**/                  {{0x3fefef68, 0x9ea593fa} },
/**/                  {{0x3fefef48, 0xbfeb8ab5} },
/**/                  {{0x3fefef28, 0xe1711d5a} },
/**/                  {{0x3fefef09, 0x03364b28} },
/**/                  {{0x3fefeee9, 0x253b1363} },
/**/                  {{0x3fefeec9, 0x477f754b} },
/**/                  {{0x3fefeea9, 0x6a037022} },
/**/                  {{0x3fefee89, 0x8cc7032a} },
/**/                  {{0x3fefee69, 0xafca2da5} },
/**/                  {{0x3fefee49, 0xd30ceed4} },
/**/                  {{0x3fefee29, 0xf68f45f8} },
/**/                  {{0x3fefee0a, 0x1a513254} },
/**/                  {{0x3fefedea, 0x3e52b329} },
/**/                  {{0x3fefedca, 0x6293c7b8} },
/**/                  {{0x3fefedaa, 0x87146f44} },
/**/                  {{0x3fefed8a, 0xabd4a90e} },
/**/                  {{0x3fefed6a, 0xd0d47458} },
/**/                  {{0x3fefed4a, 0xf613d064} },
/**/                  {{0x3fefed2b, 0x1b92bc73} },
/**/                  {{0x3fefed0b, 0x415137c7} },
/**/                  {{0x3fefeceb, 0x674f41a2} },
/**/                  {{0x3fefeccb, 0x8d8cd945} },
/**/                  {{0x3fefecab, 0xb409fdf3} },
/**/                  {{0x3fefec8b, 0xdac6aeed} },
/**/                  {{0x3fefec6c, 0x01c2eb76} },
/**/                  {{0x3fefec4c, 0x28feb2ce} },
/**/                  {{0x3fefec2c, 0x507a0437} },
/**/                  {{0x3fefec0c, 0x7834def5} },
/**/                  {{0x3fefebec, 0xa02f4247} },
/**/                  {{0x3fefebcc, 0xc8692d71} },
/**/                  {{0x3fefebac, 0xf0e29fb4} },
/**/                  {{0x3fefeb8d, 0x199b9852} },
/**/                  {{0x3fefeb6d, 0x4294168d} },
/**/                  {{0x3fefeb4d, 0x6bcc19a7} },
/**/                  {{0x3fefeb2d, 0x9543a0e2} },
/**/                  {{0x3fefeb0d, 0xbefaab7f} },
/**/                  {{0x3fefeaed, 0xe8f138c2} },
/**/                  {{0x3fefeace, 0x132747ea} },
/**/                  {{0x3fefeaae, 0x3d9cd83c} },
/**/                  {{0x3fefea8e, 0x6851e8f7} },
/**/                  {{0x3fefea6e, 0x93467960} },
/**/                  {{0x3fefea4e, 0xbe7a88b7} },
/**/                  {{0x3fefea2e, 0xe9ee163f} },
/**/                  {{0x3fefea0f, 0x15a12139} },
/**/                  {{0x3fefe9ef, 0x4193a8e8} },
/**/                  {{0x3fefe9cf, 0x6dc5ac8e} },
/**/                  {{0x3fefe9af, 0x9a372b6d} },
/**/                  {{0x3fefe98f, 0xc6e824c6} },
/**/                  {{0x3fefe96f, 0xf3d897dd} },
  };

  static const number
       Lu[182][2] = {                               /* log(ui) */
/**/                 {{{0xbfd63003, 0x0b3aac49} },
/**/                  {{0xbc6dc18c, 0xe51fff99} },},
/**/                 {{{0xbfd5d5bd, 0xdf595f30} },
/**/                  {{0x3c765411, 0x48cbb8a2} },},
/**/                 {{{0xbfd57bf7, 0x53c8d1fb} },
/**/                  {{0x3c60908d, 0x15f88b63} },},
/**/                 {{{0xbfd522ae, 0x0738a3d8} },
/**/                  {{0x3c68f7e9, 0xb38a6979} },},
/**/                 {{{0xbfd4c9e0, 0x9e172c3c} },
/**/                  {{0x3c512361, 0x5b147a5d} },},
/**/                 {{{0xbfd4718d, 0xc271c41b} },
/**/                  {{0xbc38fb4c, 0x14c56eef} },},
/**/                 {{{0xbfd419b4, 0x23d5e8c7} },
/**/                  {{0xbc60dbb2, 0x43827392} },},
/**/                 {{{0xbfd3c252, 0x77333184} },
/**/                  {{0x3c72ad27, 0xe50a8ec6} },},
/**/                 {{{0xbfd36b67, 0x76be1117} },
/**/                  {{0x3c5324f0, 0xe883858e} },},
/**/                 {{{0xbfd314f1, 0xe1d35ce4} },
/**/                  {{0x3c73d699, 0x09e5c3dc} },},
/**/                 {{{0xbfd2bef0, 0x7cdc9354} },
/**/                  {{0x3c782dad, 0x7fd86088} },},
/**/                 {{{0xbfd26962, 0x1134db92} },
/**/                  {{0xbc7e0efa, 0xdd9db02b} },},
/**/                 {{{0xbfd21445, 0x6d0eb8d4} },
/**/                  {{0xbc6f7ae9, 0x1aeba60a} },},
/**/                 {{{0xbfd1bf99, 0x635a6b95} },
/**/                  {{0x3c612aeb, 0x84249223} },},
/**/                 {{{0xbfd16b5c, 0xcbacfb73} },
/**/                  {{0xbc766fbd, 0x28b40935} },},
/**/                 {{{0xbfd1178e, 0x8227e47c} },
/**/                  {{0x3c60e63a, 0x5f01c691} },},
/**/                 {{{0xbfd0c42d, 0x676162e3} },
/**/                  {{0xbc5162c7, 0x9d5d11ee} },},
/**/                 {{{0xbfd07138, 0x604d5862} },
/**/                  {{0xbc7cdb16, 0xed4e9138} },},
/**/                 {{{0xbfd01eae, 0x5626c691} },
/**/                  {{0x3c418290, 0xbd2932e2} },},
/**/                 {{{0xbfcf991c, 0x6cb3b379} },
/**/                  {{0xbc6f6650, 0x66f980a2} },},
/**/                 {{{0xbfcef5ad, 0xe4dcffe6} },
/**/                  {{0x3c508ab2, 0xddc708a0} },},
/**/                 {{{0xbfce530e, 0xffe71012} },
/**/                  {{0xbc422760, 0x41f43042} },},
/**/                 {{{0xbfcdb13d, 0xb0d48940} },
/**/                  {{0xbc5aa11d, 0x49f96cb9} },},
/**/                 {{{0xbfcd1037, 0xf2655e7b} },
/**/                  {{0xbc660629, 0x242471a2} },},
/**/                 {{{0xbfcc6ffb, 0xc6f00f71} },
/**/                  {{0x3c68e58b, 0x2c57a4a5} },},
/**/                 {{{0xbfcbd087, 0x383bd8ad} },
/**/                  {{0xbc3dd355, 0xf6a516d7} },},
/**/                 {{{0xbfcb31d8, 0x575bce3d} },
/**/                  {{0x3c66353a, 0xb386a94d} },},
/**/                 {{{0xbfca93ed, 0x3c8ad9e3} },
/**/                  {{0xbc6bcafa, 0x9de97203} },},
/**/                 {{{0xbfc9f6c4, 0x07089664} },
/**/                  {{0xbc435a19, 0x605e67ef} },},
/**/                 {{{0xbfc95a5a, 0xdcf7017f} },
/**/                  {{0xbc5142c5, 0x07fb7a3d} },},
/**/                 {{{0xbfc8beaf, 0xeb38fe8c} },
/**/                  {{0xbc555aa8, 0xb6997a40} },},
/**/                 {{{0xbfc823c1, 0x6551a3c2} },
/**/                  {{0x3c61232c, 0xe70be781} },},
/**/                 {{{0xbfc7898d, 0x85444c73} },
/**/                  {{0xbc5ef8f6, 0xebcfb201} },},
/**/                 {{{0xbfc6f012, 0x8b756abc} },
/**/                  {{0x3c68de59, 0xc21e166c} },},
/**/                 {{{0xbfc6574e, 0xbe8c133a} },
/**/                  {{0x3c3d34f0, 0xf4621bed} },},
/**/                 {{{0xbfc5bf40, 0x6b543db2} },
/**/                  {{0x3c21f5b4, 0x4c0df7e7} },},
/**/                 {{{0xbfc527e5, 0xe4a1b58d} },
/**/                  {{0x3c271a96, 0x82395bfd} },},
/**/                 {{{0xbfc4913d, 0x8333b561} },
/**/                  {{0x3c50d560, 0x4930f135} },},
/**/                 {{{0xbfc3fb45, 0xa59928cc} },
/**/                  {{0x3c6d87e6, 0xa354d056} },},
/**/                 {{{0xbfc365fc, 0xb0159016} },
/**/                  {{0xbc57d411, 0xa5b944ad} },},
/**/                 {{{0xbfc2d161, 0x0c86813a} },
/**/                  {{0x3c5499a3, 0xf25af95f} },},
/**/                 {{{0xbfc23d71, 0x2a49c202} },
/**/                  {{0x3c66e381, 0x61051d69} },},
/**/                 {{{0xbfc1aa2b, 0x7e23f72a} },
/**/                  {{0x3c4c6ef1, 0xd9b2ef7e} },},
/**/                 {{{0xbfc1178e, 0x8227e47c} },
/**/                  {{0x3c50e63a, 0x5f01c691} },},
/**/                 {{{0xbfc08598, 0xb59e3a07} },
/**/                  {{0x3c6dd700, 0x9902bf32} },},
/**/                 {{{0xbfbfe891, 0x39dbd566} },
/**/                  {{0x3c5ac9f4, 0x215f9393} },},
/**/                 {{{0xbfbec739, 0x830a1120} },
/**/                  {{0x3c4a2bf9, 0x91780d3f} },},
/**/                 {{{0xbfbda727, 0x638446a2} },
/**/                  {{0xbc5401fa, 0x71733019} },},
/**/                 {{{0xbfbc8858, 0x01bc4b23} },
/**/                  {{0xbc5a38cb, 0x559a6706} },},
/**/                 {{{0xbfbb6ac8, 0x8dad5b1c} },
/**/                  {{0x3c40057e, 0xed1ca59f} },},
/**/                 {{{0xbfba4e76, 0x40b1bc38} },
/**/                  {{0x3c55b5ca, 0x203e4259} },},
/**/                 {{{0xbfb9335e, 0x5d594989} },
/**/                  {{0x3c5478a8, 0x5704ccb7} },},
/**/                 {{{0xbfb8197e, 0x2f40e3f0} },
/**/                  {{0xbc3b9f2d, 0xffbeed43} },},
/**/                 {{{0xbfb700d3, 0x0aeac0e1} },
/**/                  {{0x3c272566, 0x212cdd05} },},
/**/                 {{{0xbfb5e95a, 0x4d9791cb} },
/**/                  {{0xbc5f3874, 0x5c5c450a} },},
/**/                 {{{0xbfb4d311, 0x5d207eac} },
/**/                  {{0xbc5769f4, 0x2c7842cc} },},
/**/                 {{{0xbfb3bdf5, 0xa7d1ee64} },
/**/                  {{0xbc47a976, 0xd3b5b45f} },},
/**/                 {{{0xbfb2aa04, 0xa44717a5} },
/**/                  {{0x3c5d15d3, 0x8d2fa3f7} },},
/**/                 {{{0xbfb1973b, 0xd1465567} },
/**/                  {{0x3c475583, 0x67a6acf6} },},
/**/                 {{{0xbfb08598, 0xb59e3a07} },
/**/                  {{0x3c5dd700, 0x9902bf32} },},
/**/                 {{{0xbfaeea31, 0xc006b87c} },
/**/                  {{0x3c43e4fc, 0x93b7b66c} },},
/**/                 {{{0xbfaccb73, 0xcdddb2cc} },
/**/                  {{0x3c4e48fb, 0x0500efd4} },},
/**/                 {{{0xbfaaaef2, 0xd0fb10fc} },
/**/                  {{0xbc2a353b, 0xb42e0add} },},
/**/                 {{{0xbfa894aa, 0x149fb343} },
/**/                  {{0xbc3a8be9, 0x7660a23d} },},
/**/                 {{{0xbfa67c94, 0xf2d4bb58} },
/**/                  {{0xbc40413e, 0x6505e603} },},
/**/                 {{{0xbfa466ae, 0xd42de3ea} },
/**/                  {{0x3c4cdd6f, 0x7f4a137e} },},
/**/                 {{{0xbfa252f3, 0x2f8d183f} },
/**/                  {{0x3c4947f7, 0x92615916} },},
/**/                 {{{0xbfa0415d, 0x89e74444} },
/**/                  {{0xbc4c05cf, 0x1d753622} },},
/**/                 {{{0xbf9c63d2, 0xec14aaf2} },
/**/                  {{0x3c3ce030, 0xa686bd86} },},
/**/                 {{{0xbf984925, 0x28c8cabf} },
/**/                  {{0x3c3d192d, 0x0619fa67} },},
/**/                 {{{0xbf9432a9, 0x25980cc1} },
/**/                  {{0x3c38cdaf, 0x39004192} },},
/**/                 {{{0xbf902056, 0x58935847} },
/**/                  {{0xbc327c8e, 0x8416e71f} },},
/**/                 {{{0xbf882448, 0xa388a2aa} },
/**/                  {{0xbc104b16, 0x137f09a0} },},
/**/                 {{{0xbf801015, 0x7588de71} },
/**/                  {{0xbc146662, 0xd417ced0} },},
/**/                 {{{0xbf700805, 0x59588b35} },
/**/                  {{0xbc1f9663, 0x8cf63677} },},
/**/                 {{{0x00000000, 0x00000000} },
/**/                  {{0x00000000, 0x00000000} },},
/**/                 {{{0x3f6ff00a, 0xa2b10bc0} },
/**/                  {{0x3c02821a, 0xd5a6d353} },},
/**/                 {{{0x3f7fe02a, 0x6b106789} },
/**/                  {{0xbbce44b7, 0xe3711ebf} },},
/**/                 {{{0x3f87dc47, 0x5f810a77} },
/**/                  {{0xbc116d76, 0x87d3df21} },},
/**/                 {{{0x3f8fc0a8, 0xb0fc03e4} },
/**/                  {{0xbc183092, 0xc59642a1} },},
/**/                 {{{0x3f93cea4, 0x4346a575} },
/**/                  {{0xbc10cb5a, 0x902b3a1c} },},
/**/                 {{{0x3f97b91b, 0x07d5b11b} },
/**/                  {{0xbc35b602, 0xace3a510} },},
/**/                 {{{0x3f9b9fc0, 0x27af9198} },
/**/                  {{0xbbf0ae69, 0x229dc868} },},
/**/                 {{{0x3f9f829b, 0x0e783300} },
/**/                  {{0x3c333e3f, 0x04f1ef23} },},
/**/                 {{{0x3fa1b0d9, 0x8923d980} },
/**/                  {{0xbc3e9ae8, 0x89bac481} },},
/**/                 {{{0x3fa39e87, 0xb9febd60} },
/**/                  {{0xbc45bfa9, 0x37f551bb} },},
/**/                 {{{0x3fa58a5b, 0xafc8e4d5} },
/**/                  {{0xbc4ce55c, 0x2b4e2b72} },},
/**/                 {{{0x3fa77458, 0xf632dcfc} },
/**/                  {{0x3c418d3c, 0xa87b9296} },},
/**/                 {{{0x3fa95c83, 0x0ec8e3eb} },
/**/                  {{0x3c4f5a0e, 0x80520bf2} },},
/**/                 {{{0x3fab42dd, 0x711971bf} },
/**/                  {{0xbc3eb975, 0x9c130499} },},
/**/                 {{{0x3fad276b, 0x8adb0b52} },
/**/                  {{0x3c21e3c5, 0x3257fd47} },},
/**/                 {{{0x3faf0a30, 0xc01162a6} },
/**/                  {{0x3c485f32, 0x5c5bbacd} },},
/**/                 {{{0x3fb07598, 0x3598e471} },
/**/                  {{0x3c480da5, 0x333c45b8} },},
/**/                 {{{0x3fb16536, 0xeea37ae1} },
/**/                  {{0xbc379da3, 0xe8c22cda} },},
/**/                 {{{0x3fb253f6, 0x2f0a1417} },
/**/                  {{0xbc1c1259, 0x63fc4cfd} },},
/**/                 {{{0x3fb341d7, 0x961bd1d1} },
/**/                  {{0xbc5b599f, 0x227becbb} },},
/**/                 {{{0x3fb42edc, 0xbea646f0} },
/**/                  {{0x3c4ddd4f, 0x935996c9} },},
/**/                 {{{0x3fb51b07, 0x3f06183f} },
/**/                  {{0x3c5a49e3, 0x9a1a8be4} },},
/**/                 {{{0x3fb60658, 0xa93750c4} },
/**/                  {{0xbc538845, 0x8ec21b6a} },},
/**/                 {{{0x3fb6f0d2, 0x8ae56b4c} },
/**/                  {{0xbc5906d9, 0x9184b992} },},
/**/                 {{{0x3fb7da76, 0x6d7b12cd} },
/**/                  {{0xbc5eeedf, 0xcdd94131} },},
/**/                 {{{0x3fb8c345, 0xd6319b21} },
/**/                  {{0xbc24a697, 0xab3424a9} },},
/**/                 {{{0x3fb9ab42, 0x462033ad} },
/**/                  {{0xbc42099e, 0x1c184e8e} },},
/**/                 {{{0x3fba926d, 0x3a4ad563} },
/**/                  {{0x3c5942f4, 0x8aa70ea9} },},
/**/                 {{{0x3fbb78c8, 0x2bb0eda1} },
/**/                  {{0x3c20878c, 0xf0327e21} },},
/**/                 {{{0x3fbc5e54, 0x8f5bc743} },
/**/                  {{0x3c35d617, 0xef8161b1} },},
/**/                 {{{0x3fbd4313, 0xd66cb35d} },
/**/                  {{0x3c5790dd, 0x951d90fa} },},
/**/                 {{{0x3fbe2707, 0x6e2af2e6} },
/**/                  {{0xbc361578, 0x001e0162} },},
/**/                 {{{0x3fbf0a30, 0xc01162a6} },
/**/                  {{0x3c585f32, 0x5c5bbacd} },},
/**/                 {{{0x3fbfec91, 0x31dbeabb} },
/**/                  {{0xbc55746b, 0x9981b36c} },},
/**/                 {{{0x3fc06715, 0x12ca596e} },
/**/                  {{0x3c550c64, 0x7eb86499} },},
/**/                 {{{0x3fc0d77e, 0x7cd08e59} },
/**/                  {{0x3c69a5dc, 0x5e9030ac} },},
/**/                 {{{0x3fc14785, 0x846742ac} },
/**/                  {{0x3c6a2881, 0x3e3a7f07} },},
/**/                 {{{0x3fc1b72a, 0xd52f67a0} },
/**/                  {{0x3c548302, 0x3472cd74} },},
/**/                 {{{0x3fc2266f, 0x190a5acb} },
/**/                  {{0x3c6f547b, 0xf1809e88} },},
/**/                 {{{0x3fc29552, 0xf81ff523} },
/**/                  {{0x3c630177, 0x1c407dbf} },},
/**/                 {{{0x3fc303d7, 0x18e47fd3} },
/**/                  {{0xbc06b9c7, 0xd96091fa} },},
/**/                 {{{0x3fc371fc, 0x201e8f74} },
/**/                  {{0x3c5de6cb, 0x62af18a0} },},
/**/                 {{{0x3fc3dfc2, 0xb0ecc62a} },
/**/                  {{0xbc5ab3a8, 0xe7d81017} },},
/**/                 {{{0x3fc44d2b, 0x6ccb7d1e} },
/**/                  {{0x3c69f4f6, 0x543e1f88} },},
/**/                 {{{0x3fc4ba36, 0xf39a55e5} },
/**/                  {{0x3c668981, 0xbcc36756} },},
/**/                 {{{0x3fc526e5, 0xe3a1b438} },
/**/                  {{0xbc6746ff, 0x8a470d3a} },},
/**/                 {{{0x3fc59338, 0xd9982086} },
/**/                  {{0xbc565d22, 0xaa8ad7cf} },},
/**/                 {{{0x3fc5ff30, 0x70a793d4} },
/**/                  {{0xbc5bc60e, 0xfafc6f6e} },},
/**/                 {{{0x3fc66acd, 0x4272ad51} },
/**/                  {{0xbc50900e, 0x4e1ea8b2} },},
/**/                 {{{0x3fc6d60f, 0xe719d21d} },
/**/                  {{0xbc6caae2, 0x68ecd179} },},
/**/                 {{{0x3fc740f8, 0xf54037a5} },
/**/                  {{0xbc5b2640, 0x62a84cdb} },},
/**/                 {{{0x3fc7ab89, 0x0210d909} },
/**/                  {{0x3c4be36b, 0x2d6a0608} },},
/**/                 {{{0x3fc815c0, 0xa14357eb} },
/**/                  {{0xbc54be48, 0x073a0564} },},
/**/                 {{{0x3fc87fa0, 0x6520c911} },
/**/                  {{0xbc6bf7fd, 0xbfa08d9a} },},
/**/                 {{{0x3fc8e928, 0xde886d41} },
/**/                  {{0xbc6569d8, 0x51a56770} },},
/**/                 {{{0x3fc9525a, 0x9cf456b4} },
/**/                  {{0x3c6d904c, 0x1d4e2e26} },},
/**/                 {{{0x3fc9bb36, 0x2e7dfb83} },
/**/                  {{0x3c6575e3, 0x1f003e0c} },},
/**/                 {{{0x3fca23bc, 0x1fe2b563} },
/**/                  {{0x3c493711, 0xb07a998c} },},
/**/                 {{{0x3fca8bec, 0xfc882f19} },
/**/                  {{0xbc5e8c37, 0x918c39eb} },},
/**/                 {{{0x3fcaf3c9, 0x4e80bff3} },
/**/                  {{0xbc5398cf, 0xf3641985} },},
/**/                 {{{0x3fcb5b51, 0x9e8fb5a4} },
/**/                  {{0x3c6ba27f, 0xdc19e1a0} },},
/**/                 {{{0x3fcbc286, 0x742d8cd6} },
/**/                  {{0x3c54fce7, 0x44870f55} },},
/**/                 {{{0x3fcc2968, 0x558c18c1} },
/**/                  {{0xbc673dee, 0x38a3fb6b} },},
/**/                 {{{0x3fcc8ff7, 0xc79a9a22} },
/**/                  {{0xbc64f689, 0xf8434012} },},
/**/                 {{{0x3fccf635, 0x4e09c5dc} },
/**/                  {{0x3c6239a0, 0x7d55b695} },},
/**/                 {{{0x3fcd5c21, 0x6b4fbb91} },
/**/                  {{0x3c66e443, 0x597e4d40} },},
/**/                 {{{0x3fcdc1bc, 0xa0abec7d} },
/**/                  {{0x3c6834c5, 0x1998b6fc} },},
/**/                 {{{0x3fce2707, 0x6e2af2e6} },
/**/                  {{0xbc461578, 0x001e0162} },},
/**/                 {{{0x3fce8c02, 0x52aa5a60} },
/**/                  {{0xbc46e03a, 0x39bfc89b} },},
/**/                 {{{0x3fcef0ad, 0xcbdc5936} },
/**/                  {{0x3c648637, 0x950dc20d} },},
/**/                 {{{0x3fcf550a, 0x564b7b37} },
/**/                  {{0x3c2c5f6d, 0xfd018c37} },},
/**/                 {{{0x3fcfb918, 0x6d5e3e2b} },
/**/                  {{0xbc6caaae, 0x64f21acb} },},
/**/                 {{{0x3fd00e6c, 0x45ad501d} },
/**/                  {{0xbc6cb956, 0x8ff6fead} },},
/**/                 {{{0x3fd04025, 0x94b4d041} },
/**/                  {{0xbc628ec2, 0x17a5022d} },},
/**/                 {{{0x3fd071b8, 0x5fcd590d} },
/**/                  {{0x3c5d1707, 0xf97bde80} },},
/**/                 {{{0x3fd0a324, 0xe27390e3} },
/**/                  {{0x3c77dcfd, 0xe8061c03} },},
/**/                 {{{0x3fd0d46b, 0x579ab74b} },
/**/                  {{0x3c603ec8, 0x1c3cbd92} },},
/**/                 {{{0x3fd1058b, 0xf9ae4ad5} },
/**/                  {{0x3c589fa0, 0xab4cb31d} },},
/**/                 {{{0x3fd13687, 0x0293a8b0} },
/**/                  {{0x3c77b662, 0x98edd24a} },},
/**/                 {{{0x3fd1675c, 0xababa60e} },
/**/                  {{0x3c2ce63e, 0xab883717} },},
/**/                 {{{0x3fd1980d, 0x2dd4236f} },
/**/                  {{0x3c79d3d1, 0xb0e4d147} },},
/**/                 {{{0x3fd1c898, 0xc16999fb} },
/**/                  {{0xbc30e5c6, 0x2aff1c44} },},
/**/                 {{{0x3fd1f8ff, 0x9e48a2f3} },
/**/                  {{0xbc7c9fdf, 0x9a0c4b07} },},
/**/                 {{{0x3fd22941, 0xfbcf7966} },
/**/                  {{0xbc776f5e, 0xb09628af} },},
/**/                 {{{0x3fd25960, 0x10df763a} },
/**/                  {{0xbc50f76c, 0x57075e9e} },},
/**/                 {{{0x3fd2895a, 0x13de86a3} },
/**/                  {{0x3c77ad24, 0xc13f040e} },},
/**/                 {{{0x3fd2b930, 0x3ab89d25} },
/**/                  {{0xbc7896b5, 0xfd852ad4} },},
/**/                 {{{0x3fd2e8e2, 0xbae11d31} },
/**/                  {{0xbc78f4cd, 0xb95ebdf9} },},
/**/                 {{{0x3fd31871, 0xc9544185} },
/**/                  {{0xbc351acc, 0x4c09b379} },},
/**/                 {{{0x3fd347dd, 0x9a987d55} },
/**/                  {{0xbc64dd4c, 0x580919f8} },},
/**/                 {{{0x3fd37726, 0x62bfd85b} },
/**/                  {{0xbc4b5629, 0xd8117de7} },},
/**/                 {{{0x3fd3a64c, 0x556945ea} },
/**/                  {{0xbc6c6865, 0x1945f97c} },},
/**/                 {{{0x3fd3d54f, 0xa5c1f710} },
/**/                  {{0xbc7e3265, 0xc6a1c98d} },},
/**/                 {{{0x3fd40430, 0x8686a7e4} },
/**/                  {{0xbc70bcfb, 0x6082ce6d} },},
/**/                 {{{0x3fd432ef, 0x2a04e814} },
/**/                  {{0xbc729931, 0x715ac903} },},
/**/                 {{{0x3fd4618b, 0xc21c5ec2} },
/**/                  {{0x3c7f42de, 0xcdeccf1d} },},
/**/                 {{{0x3fd49006, 0x804009d1} },
/**/                  {{0xbc69ffc3, 0x41f177dc} },},
/**/                 {{{0x3fd4be5f, 0x957778a1} },
/**/                  {{0xbc6259b3, 0x5b04813d} },},
/**/                 {{{0x3fd4ec97, 0x3260026a} },
/**/                  {{0xbc742a87, 0xd977dc5e} },},
/**/                 {{{0x3fd51aad, 0x872df82d} },
/**/                  {{0x3c43927a, 0xc19f55e3} },},
/**/                 {{{0x3fd548a2, 0xc3add263} },
/**/                  {{0xbc6819cf, 0x7e308ddb} },},
/**/                 {{{0x3fd57677, 0x17455a6c} },
/**/                  {{0x3c7526ad, 0xb283660c} },},
/**/                 {{{0x3fd5a42a, 0xb0f4cfe2} },
/**/                  {{0xbc78ebcb, 0x7dee9a3d} },},
/**/                 {{{0x3fd5d1bd, 0xbf5809ca} },
/**/                  {{0x3c742363, 0x83dc7fe1} },},
/**/                 {{{0x3fd5ff30, 0x70a793d4} },
/**/                  {{0xbc6bc60e, 0xfafc6f6e} },},
/**/                 {{{0x3fd62c82, 0xf2b9c795} },
/**/                  {{0x3c67b7af, 0x915300e5} },},
  };

  static const number
       Lv[362][2] = {                               /* log(vj) */

/**/                 {{{0xbf6687ec, 0xb72daabf} },
/**/                  {{0x3c052c69, 0x0f13318f} },},
/**/                 {{{0xbf6667d6, 0x3767104f} },
/**/                  {{0x3bd3efa3, 0xd27a7bac} },},
/**/                 {{{0xbf6647bf, 0xd7cd64fb} },
/**/                  {{0x3c09b725, 0x55a89c36} },},
/**/                 {{{0xbf6627a9, 0x9860683b} },
/**/                  {{0x3bcbae22, 0xfebc844a} },},
/**/                 {{{0xbf660793, 0x791fd98a} },
/**/                  {{0xbbfe34af, 0x78fa1cb5} },},
/**/                 {{{0xbf65e77d, 0x7a0b7863} },
/**/                  {{0xbc02f1b1, 0xea78fdd0} },},
/**/                 {{{0xbf65c767, 0x9b230442} },
/**/                  {{0x3bf70d8c, 0x2202b2ca} },},
/**/                 {{{0xbf65a751, 0xdc663ca2} },
/**/                  {{0xbbfdc63d, 0xc3444e64} },},
/**/                 {{{0xbf65873c, 0x3dd4e102} },
/**/                  {{0x3c021b11, 0x370d69c3} },},
/**/                 {{{0xbf656726, 0xbf6eb0de} },
/**/                  {{0xbbfb6da8, 0x154dd8d8} },},
/**/                 {{{0xbf654711, 0x61336bb6} },
/**/                  {{0xbc0b12d2, 0xdf9a4709} },},
/**/                 {{{0xbf6526fc, 0x2322d10a} },
/**/                  {{0x3bf997f2, 0x68d1274f} },},
/**/                 {{{0xbf6506e7, 0x053ca059} },
/**/                  {{0x3c0c2a1f, 0xe70c852a} },},
/**/                 {{{0xbf64e6d2, 0x07809924} },
/**/                  {{0x3c04cc9e, 0xa808538f} },},
/**/                 {{{0xbf64c6bd, 0x29ee7aed} },
/**/                  {{0x3befe68c, 0x7797a4bd} },},
/**/                 {{{0xbf64a6a8, 0x6c860537} },
/**/                  {{0x3c06794d, 0x9efaae3d} },},
/**/                 {{{0xbf648693, 0xcf46f784} },
/**/                  {{0xbbfed318, 0xb2ddd9d1} },},
/**/                 {{{0xbf64667f, 0x5231115a} },
/**/                  {{0x3c061f62, 0x4643624b} },},
/**/                 {{{0xbf64466a, 0xf544123c} },
/**/                  {{0x3c0666a0, 0x9387f11e} },},
/**/                 {{{0xbf642656, 0xb87fb9b0} },
/**/                  {{0x3c0043b2, 0x116ec598} },},
/**/                 {{{0xbf640642, 0x9be3c73c} },
/**/                  {{0xbbfbd84d, 0xd2de6e3e} },},
/**/                 {{{0xbf63e62e, 0x9f6ffa68} },
/**/                  {{0xbbe9149b, 0x433d8c65} },},
/**/                 {{{0xbf63c61a, 0xc32412bb} },
/**/                  {{0xbbf6b88d, 0x08e5a7bb} },},
/**/                 {{{0xbf63a607, 0x06ffcfbe} },
/**/                  {{0xbb9f3c7a, 0xccfac9e2} },},
/**/                 {{{0xbf6385f3, 0x6b02f0fa} },
/**/                  {{0x3bee405c, 0xbec6f6e4} },},
/**/                 {{{0xbf6365df, 0xef2d35f9} },
/**/                  {{0x3bf02993, 0xaf0c0b4c} },},
/**/                 {{{0xbf6345cc, 0x937e5e46} },
/**/                  {{0x3bf9be97, 0xaa64716f} },},
/**/                 {{{0xbf6325b9, 0x57f6296c} },
/**/                  {{0xbbfdeb4d, 0xa2e863ae} },},
/**/                 {{{0xbf6305a6, 0x3c9456f9} },
/**/                  {{0x3c0f3c7f, 0x636d2b2c} },},
/**/                 {{{0xbf62e593, 0x4158a678} },
/**/                  {{0x3c01a8df, 0xb166ca7f} },},
/**/                 {{{0xbf62c580, 0x6642d778} },
/**/                  {{0x3c020ff1, 0x53a2d534} },},
/**/                 {{{0xbf62a56d, 0xab52a987} },
/**/                  {{0xbbe8fef1, 0x0412f1e7} },},
/**/                 {{{0xbf62855b, 0x1087dc35} },
/**/                  {{0xbbfcd17e, 0x4b7ac6c6} },},
/**/                 {{{0xbf626548, 0x95e22f12} },
/**/                  {{0xbbfbfc21, 0x9a8127bf} },},
/**/                 {{{0xbf624536, 0x3b6161af} },
/**/                  {{0x3bd7eda1, 0x66d42390} },},
/**/                 {{{0xbf622524, 0x0105339d} },
/**/                  {{0xbbdf374e, 0x77fedcad} },},
/**/                 {{{0xbf620511, 0xe6cd646f} },
/**/                  {{0x3be1d1fb, 0x52d05dea} },},
/**/                 {{{0xbf61e4ff, 0xecb9b3b8} },
/**/                  {{0x3c02c2fc, 0xffd8e706} },},
/**/                 {{{0xbf61c4ee, 0x12c9e10b} },
/**/                  {{0xbc02b4f8, 0xf1d5cc2c} },},
/**/                 {{{0xbf61a4dc, 0x58fdabfe} },
/**/                  {{0xbc0618c3, 0x1315b191} },},
/**/                 {{{0xbf6184ca, 0xbf54d426} },
/**/                  {{0xbc01f8d5, 0xcb3cdab0} },},
/**/                 {{{0xbf6164b9, 0x45cf1919} },
/**/                  {{0xbc014ff7, 0xc025605a} },},
/**/                 {{{0xbf6144a7, 0xec6c3a6e} },
/**/                  {{0xbbff04ff, 0x87cb08cd} },},
/**/                 {{{0xbf612496, 0xb32bf7bd} },
/**/                  {{0x3bee89b4, 0xe6af1b84} },},
/**/                 {{{0xbf610485, 0x9a0e109e} },
/**/                  {{0x3c07e99e, 0x35a60879} },},
/**/                 {{{0xbf60e474, 0xa11244aa} },
/**/                  {{0x3c04b698, 0x20f2325a} },},
/**/                 {{{0xbf60c463, 0xc838537b} },
/**/                  {{0x3bc0657e, 0x3617200d} },},
/**/                 {{{0xbf60a453, 0x0f7ffcac} },
/**/                  {{0xbc008feb, 0xa5080961} },},
/**/                 {{{0xbf608442, 0x76e8ffd9} },
/**/                  {{0x3bd13002, 0xbb5e1df7} },},
/**/                 {{{0xbf606431, 0xfe731c9d} },
/**/                  {{0xbc0509f3, 0x6e2858c0} },},
/**/                 {{{0xbf604421, 0xa61e1296} },
/**/                  {{0xbc04b556, 0x5f5d9695} },},
/**/                 {{{0xbf602411, 0x6de9a162} },
/**/                  {{0x3c042b89, 0xe79a4e00} },},
/**/                 {{{0xbf600401, 0x55d5889e} },
/**/                  {{0x3be8f98e, 0x1113f403} },},
/**/                 {{{0xbf5fc7e2, 0xbbc30fd4} },
/**/                  {{0xbbfc709b, 0x93382bc9} },},
/**/                 {{{0xbf5f87c3, 0x0c1abdcd} },
/**/                  {{0xbbf2a90d, 0x76a55d1c} },},
/**/                 {{{0xbf5f47a3, 0x9cb19a68} },
/**/                  {{0x3be1b815, 0x76e7826b} },},
/**/                 {{{0xbf5f0784, 0x6d8724e7} },
/**/                  {{0xbbe72d46, 0x2b63756d} },},
/**/                 {{{0xbf5ec765, 0x7e9adc90} },
/**/                  {{0x3beb1a66, 0x73bb17c5} },},
/**/                 {{{0xbf5e8746, 0xcfec40a8} },
/**/                  {{0x3bf11af5, 0xb5e5a553} },},
/**/                 {{{0xbf5e4728, 0x617ad077} },
/**/                  {{0x3bfb2cad, 0xf57dd14f} },},
/**/                 {{{0xbf5e070a, 0x33460b45} },
/**/                  {{0xbbf8db75, 0x4902c8d5} },},
/**/                 {{{0xbf5dc6ec, 0x454d705f} },
/**/                  {{0x3bef5cc6, 0xe8a41057} },},
/**/                 {{{0xbf5d86ce, 0x97907f0f} },
/**/                  {{0x3bed8277, 0xdf8672ef} },},
/**/                 {{{0xbf5d46b1, 0x2a0eb6a3} },
/**/                  {{0xbbc2f9c2, 0x3717e5ee} },},
/**/                 {{{0xbf5d0693, 0xfcc7966b} },
/**/                  {{0x3bf4deed, 0xab4852c6} },},
/**/                 {{{0xbf5cc677, 0x0fba9db6} },
/**/                  {{0xbbf3a2b4, 0x9db2a368} },},
/**/                 {{{0xbf5c865a, 0x62e74bd8} },
/**/                  {{0xbbd2c51d, 0x58fa0c24} },},
/**/                 {{{0xbf5c463d, 0xf64d2024} },
/**/                  {{0x3bf838ca, 0xe3a09391} },},
/**/                 {{{0xbf5c0621, 0xc9eb99ee} },
/**/                  {{0xbbdc2a9e, 0x61b7de71} },},
/**/                 {{{0xbf5bc605, 0xddc2388e} },
/**/                  {{0xbbea9808, 0x4accb195} },},
/**/                 {{{0xbf5b85ea, 0x31d07b5c} },
/**/                  {{0xbbd811a2, 0x032e030b} },},
/**/                 {{{0xbf5b45ce, 0xc615e1b1} },
/**/                  {{0xbbfd5427, 0x821e0b81} },},
/**/                 {{{0xbf5b05b3, 0x9a91eaea} },
/**/                  {{0x3bfffeba, 0x2619306b} },},
/**/                 {{{0xbf5ac598, 0xaf441661} },
/**/                  {{0x3bd22824, 0x9eac7d15} },},
/**/                 {{{0xbf5a857e, 0x042be376} },
/**/                  {{0x3bc20736, 0x24893f0e} },},
/**/                 {{{0xbf5a4563, 0x9948d188} },
/**/                  {{0xbbf58ab4, 0x04d734cd} },},
/**/                 {{{0xbf5a0549, 0x6e9a5ff9} },
/**/                  {{0xbbf22673, 0x5723a6c3} },},
/**/                 {{{0xbf59c52f, 0x84200e2c} },
/**/                  {{0x3bfc81da, 0xa538e8e1} },},
/**/                 {{{0xbf598515, 0xd9d95b83} },
/**/                  {{0xbbfa1a37, 0x2a8e3feb} },},
/**/                 {{{0xbf5944fc, 0x6fc5c767} },
/**/                  {{0x3bf8e1ce, 0x385159f9} },},
/**/                 {{{0xbf5904e3, 0x45e4d13c} },
/**/                  {{0xbbfc4737, 0x1567c7a7} },},
/**/                 {{{0xbf58c4ca, 0x5c35f86e} },
/**/                  {{0x3bf41581, 0x23c9ae0c} },},
/**/                 {{{0xbf5884b1, 0xb2b8bc65} },
/**/                  {{0x3bf70c2c, 0x2b66cfb6} },},
/**/                 {{{0xbf584499, 0x496c9c8d} },
/**/                  {{0xbbdb9042, 0xe5a11e3e} },},
/**/                 {{{0xbf580481, 0x20511854} },
/**/                  {{0xbbf9cf9d, 0x61bcb040} },},
/**/                 {{{0xbf57c469, 0x3765af29} },
/**/                  {{0xbbf65ceb, 0xe26a419b} },},
/**/                 {{{0xbf578451, 0x8ea9e07c} },
/**/                  {{0xbbf1c2f5, 0xb70a4088} },},
/**/                 {{{0xbf57443a, 0x261d2bbf} },
/**/                  {{0xbbbc7b8f, 0x29704ba7} },},
/**/                 {{{0xbf570422, 0xfdbf1065} },
/**/                  {{0x3bca0a54, 0x433ccb3b} },},
/**/                 {{{0xbf56c40c, 0x158f0de3} },
/**/                  {{0x3bd9e257, 0x207cde2d} },},
/**/                 {{{0xbf5683f5, 0x6d8ca3af} },
/**/                  {{0xbbef17a4, 0xf7b51b49} },},
/**/                 {{{0xbf5643df, 0x05b75142} },
/**/                  {{0x3be28239, 0x9d345bf8} },},
/**/                 {{{0xbf5603c8, 0xde0e9614} },
/**/                  {{0xbbde6c21, 0x0918d1bf} },},
/**/                 {{{0xbf55c3b2, 0xf691f1a1} },
/**/                  {{0x3bd37d78, 0x377de4c8} },},
/**/                 {{{0xbf55839d, 0x4f40e365} },
/**/                  {{0x3bf52b7d, 0xbbf7c9d1} },},
/**/                 {{{0xbf554387, 0xe81aeadd} },
/**/                  {{0xbbf0be6a, 0x679c3d9a} },},
/**/                 {{{0xbf550372, 0xc11f878a} },
/**/                  {{0xbbdd9e20, 0xb6cdd88e} },},
/**/                 {{{0xbf54c35d, 0xda4e38ec} },
/**/                  {{0xbbe3b1e7, 0x09302da0} },},
/**/                 {{{0xbf548349, 0x33a67e86} },
/**/                  {{0x3be8cba8, 0x085b922d} },},
/**/                 {{{0xbf544334, 0xcd27d7db} },
/**/                  {{0xbba5f2c9, 0xf024ab43} },},
/**/                 {{{0xbf540320, 0xa6d1c471} },
/**/                  {{0xbbeb31f3, 0xf686cf3d} },},
/**/                 {{{0xbf53c30c, 0xc0a3c3cf} },
/**/                  {{0xbbf74ffe, 0xd4ad32f6} },},
/**/                 {{{0xbf5382f9, 0x1a9d557e} },
/**/                  {{0x3bd2e555, 0x4acb368f} },},
/**/                 {{{0xbf5342e5, 0xb4bdf907} },
/**/                  {{0x3be13442, 0x07812806} },},
/**/                 {{{0xbf5302d2, 0x8f052df6} },
/**/                  {{0x3bf5f429, 0x70b1e756} },},
/**/                 {{{0xbf52c2bf, 0xa97273d7} },
/**/                  {{0xbbf20aa3, 0x43a03fff} },},
/**/                 {{{0xbf5282ad, 0x04054a3a} },
/**/                  {{0xbbed4d57, 0x8bebd7ad} },},
/**/                 {{{0xbf52429a, 0x9ebd30ae} },
/**/                  {{0xbbff9529, 0x5a71c5a4} },},
/**/                 {{{0xbf520288, 0x7999a6c6} },
/**/                  {{0x3bfb055a, 0x54100f9e} },},
/**/                 {{{0xbf51c276, 0x949a2c12} },
/**/                  {{0xbbff6978, 0xa2e9f1b4} },},
/**/                 {{{0xbf518264, 0xefbe402a} },
/**/                  {{0x3bf01fb9, 0xbc188323} },},
/**/                 {{{0xbf514253, 0x8b0562a1} },
/**/                  {{0xbbf7c87c, 0x957bf23a} },},
/**/                 {{{0xbf510242, 0x666f1311} },
/**/                  {{0x3bdc2cb9, 0xc8be6880} },},
/**/                 {{{0xbf50c231, 0x81fad111} },
/**/                  {{0xbbf59fc1, 0x07ba000d} },},
/**/                 {{{0xbf508220, 0xdda81c3d} },
/**/                  {{0xbbf06a0a, 0xbf5c8a0b} },},
/**/                 {{{0xbf504210, 0x79767431} },
/**/                  {{0x3bf3a6cf, 0xa9a705bc} },},
/**/                 {{{0xbf500200, 0x55655889} },
/**/                  {{0xbbe9abe6, 0xbf0fa436} },},
/**/                 {{{0xbf4f83e0, 0xe2e891cc} },
/**/                  {{0x3be4aa59, 0x1b81bf62} },},
/**/                 {{{0xbf4f03c1, 0x9b4589ce} },
/**/                  {{0xbbe60518, 0x8a47f50a} },},
/**/                 {{{0xbf4e83a2, 0xd3e0985f} },
/**/                  {{0x3bed32d8, 0x5ef17e96} },},
/**/                 {{{0xbf4e0384, 0x8cb8bcc3} },
/**/                  {{0xbbeb7b30, 0xf09afa4d} },},
/**/                 {{{0xbf4d8366, 0xc5ccf647} },
/**/                  {{0xbbd527fc, 0xf586cec2} },},
/**/                 {{{0xbf4d0349, 0x7f1c4437} },
/**/                  {{0x3bc2bcf0, 0x4a686886} },},
/**/                 {{{0xbf4c832c, 0xb8a5a5e3} },
/**/                  {{0x3bc98f93, 0x721c2ebe} },},
/**/                 {{{0xbf4c0310, 0x72681a9e} },
/**/                  {{0xbbe20f00, 0xb5308d22} },},
/**/                 {{{0xbf4b82f4, 0xac62a1bf} },
/**/                  {{0xbbe1edd0, 0x9737b561} },},
/**/                 {{{0xbf4b02d9, 0x66943a9f} },
/**/                  {{0xbbcc950b, 0x23f894a1} },},
/**/                 {{{0xbf4a82be, 0xa0fbe49a} },
/**/                  {{0xbb81da04, 0x866bc982} },},
/**/                 {{{0xbf4a02a4, 0x5b989f0f} },
/**/                  {{0xbbd9114d, 0x9d76196e} },},
/**/                 {{{0xbf49828a, 0x96696961} },
/**/                  {{0x3bc10d20, 0xd3292fd6} },},
/**/                 {{{0xbf490271, 0x516d42f4} },
/**/                  {{0xbbee53a3, 0x2e9a5dd5} },},
/**/                 {{{0xbf488258, 0x8ca32b32} },
/**/                  {{0xbbc55af5, 0xd18f8004} },},
/**/                 {{{0xbf480240, 0x480a2185} },
/**/                  {{0xbbb32d23, 0xa9b0178a} },},
/**/                 {{{0xbf478228, 0x83a1255c} },
/**/                  {{0x3be84cc3, 0x8152093a} },},
/**/                 {{{0xbf470211, 0x3f673627} },
/**/                  {{0xbbd0055a, 0xf4881c71} },},
/**/                 {{{0xbf4681fa, 0x7b5b535c} },
/**/                  {{0x3bd2b73f, 0xb98336ea} },},
/**/                 {{{0xbf4601e4, 0x377c7c71} },
/**/                  {{0xbbcdcbed, 0x2ed05089} },},
/**/                 {{{0xbf4581ce, 0x73c9b0e1} },
/**/                  {{0xbbdda0c2, 0x61414697} },},
/**/                 {{{0xbf4501b9, 0x3041f02a} },
/**/                  {{0x3bee5d53, 0x22f8b33c} },},
/**/                 {{{0xbf4481a4, 0x6ce439ca} },
/**/                  {{0xbbe5512f, 0x9c25c999} },},
/**/                 {{{0xbf440190, 0x29af8d47} },
/**/                  {{0x3b7f48c2, 0xa4df0dfd} },},
/**/                 {{{0xbf43817c, 0x66a2ea26} },
/**/                  {{0x3bd157c0, 0x517febd8} },},
/**/                 {{{0xbf430169, 0x23bd4ff0} },
/**/                  {{0xbbe2e229, 0x0176d244} },},
/**/                 {{{0xbf428156, 0x60fdbe33} },
/**/                  {{0x3be64664, 0x175812b3} },},
/**/                 {{{0xbf420144, 0x1e63347c} },
/**/                  {{0xbbe39ab4, 0xd9355524} },},
/**/                 {{{0xbf418132, 0x5becb260} },
/**/                  {{0x3be74b27, 0xb6e1edc9} },},
/**/                 {{{0xbf410121, 0x19993772} },
/**/                  {{0xbbaa390b, 0x393ab56a} },},
/**/                 {{{0xbf408110, 0x5767c34c} },
/**/                  {{0x3bd128e6, 0xf8c7783b} },},
/**/                 {{{0xbf400100, 0x15575589} },
/**/                  {{0x3bec8863, 0xf23ef222} },},
/**/                 {{{0xbf3f01e0, 0xa6cddb8d} },
/**/                  {{0x3b8a9419, 0xcdd29c3f} },},
/**/                 {{{0xbf3e01c2, 0x232b174e} },
/**/                  {{0xbbc7cf55, 0xd5f5b191} },},
/**/                 {{{0xbf3d01a4, 0x9fc45d9e} },
/**/                  {{0x3bddc58f, 0xb5038e7e} },},
/**/                 {{{0xbf3c0188, 0x1c97adca} },
/**/                  {{0x3bc0238d, 0xbb933e41} },},
/**/                 {{{0xbf3b016c, 0x99a30728} },
/**/                  {{0xbbabde04, 0xc3c43664} },},
/**/                 {{{0xbf3a0152, 0x16e46913} },
/**/                  {{0x3bafe081, 0x5adc3673} },},
/**/                 {{{0xbf390138, 0x9459d2eb} },
/**/                  {{0xbbd949da, 0xc2a33d26} },},
/**/                 {{{0xbf380120, 0x12014418} },
/**/                  {{0xbbd3acbc, 0xf76e0326} },},
/**/                 {{{0xbf370108, 0x8fd8bc07} },
/**/                  {{0x3bdbde09, 0x4cd6ce34} },},
/**/                 {{{0xbf3600f2, 0x0dde3a29} },
/**/                  {{0xbbb0bc28, 0x05442a35} },},
/**/                 {{{0xbf3500dc, 0x8c0fbdf9} },
/**/                  {{0x3bd21c68, 0x0908cbf7} },},
/**/                 {{{0xbf3400c8, 0x0a6b46f4} },
/**/                  {{0xbbdbd35e, 0x0f107564} },},
/**/                 {{{0xbf3300b4, 0x88eed4a1} },
/**/                  {{0xbbc22067, 0x49a3dcb8} },},
/**/                 {{{0xbf3200a2, 0x0798668a} },
/**/                  {{0x3bcdb7f0, 0xe7c5d0e5} },},
/**/                 {{{0xbf310090, 0x8665fc3f} },
/**/                  {{0xbbd00add, 0xc7f9d69c} },},
/**/                 {{{0xbf300080, 0x05559559} },
/**/                  {{0x3bddd332, 0xa0e20e2f} },},
/**/                 {{{0xbf2e00e1, 0x08ca62e5} },
/**/                  {{0xbbb15ff9, 0x3a04bb77} },},
/**/                 {{{0xbf2c00c4, 0x0725a061} },
/**/                  {{0x3bc88ab0, 0xcc052f3e} },},
/**/                 {{{0xbf2a00a9, 0x05b8e275} },
/**/                  {{0xbbcbba1a, 0xf5f3cbcf} },},
/**/                 {{{0xbf280090, 0x04802882} },
/**/                  {{0x3bcec900, 0xa5bd7bd0} },},
/**/                 {{{0xbf260079, 0x037771ef} },
/**/                  {{0x3bb77ea0, 0x9b7b54fa} },},
/**/                 {{{0xbf240064, 0x029abe33} },
/**/                  {{0xbbc1bbf0, 0x3ae68d18} },},
/**/                 {{{0xbf220051, 0x01e60cd1} },
/**/                  {{0x3bb1dcd9, 0x2b45cfcd} },},
/**/                 {{{0xbf200040, 0x01555d56} },
/**/                  {{0x3bcddd88, 0x863f53f6} },},
/**/                 {{{0xbf1c0062, 0x01c95eb7} },
/**/                  {{0x3bbd88f7, 0xaa4dfd9a} },},
/**/                 {{{0xbf180048, 0x01200510} },
/**/                  {{0xbb984d46, 0x4f3db50b} },},
/**/                 {{{0xbf140032, 0x00a6ad1c} },
/**/                  {{0x3bb2e44b, 0x28ff1135} },},
/**/                 {{{0xbf100020, 0x00555655} },
/**/                  {{0xbbb62224, 0xccd5f17f} },},
/**/                 {{{0xbf080024, 0x004800a2} },
/**/                  {{0xbb484d09, 0x8d690542} },},
/**/                 {{{0xbf000010, 0x00155575} },
/**/                  {{0xbba56222, 0x37779c0a} },},
/**/                 {{{0xbef00008, 0x00055559} },
/**/                  {{0xbb955622, 0x22cccd5f} },},
/**/                 {{{0x00000000, 0x00000000} },
/**/                  {{0x00000000, 0x00000000} },},
/**/                 {{{0x3eeffff0, 0x000aaaa3} },
/**/                  {{0xbb8553bb, 0xbd110fec} },},
/**/                 {{{0x3effffe0, 0x002aaa6b} },
/**/                  {{0xbb953bbb, 0xe6661d42} },},
/**/                 {{{0x3f07ffdc, 0x0047ff5e} },
/**/                  {{0x3b484c90, 0x0d69020e} },},
/**/                 {{{0x3f0fffc0, 0x00aaa8ab} },
/**/                  {{0xbba3bbc1, 0x10fec82c} },},
/**/                 {{{0x3f13ffce, 0x00a6a83a} },
/**/                  {{0xbbb2e45f, 0x81546808} },},
/**/                 {{{0x3f17ffb8, 0x011ffaf0} },
/**/                  {{0x3b984c53, 0x4f3d9b6a} },},
/**/                 {{{0x3f1bff9e, 0x01c94bf5} },
/**/                  {{0xbbbd8990, 0xdaa368ee} },},
/**/                 {{{0x3f1fff80, 0x02aa9aab} },
/**/                  {{0x3b910e66, 0x78af0afc} },},
/**/                 {{{0x3f21ffaf, 0x01e5f330} },
/**/                  {{0xbbb1df8d, 0x26467402} },},
/**/                 {{{0x3f23ff9c, 0x029a9723} },
/**/                  {{0x3bc1b965, 0x303b23b1} },},
/**/                 {{{0x3f25ff87, 0x037738be} },
/**/                  {{0xbbb787a3, 0x53d3dc06} },},
/**/                 {{{0x3f27ff70, 0x047fd782} },
/**/                  {{0xbbced098, 0xa5c0aff0} },},
/**/                 {{{0x3f29ff57, 0x05b872e4} },
/**/                  {{0x3bcbadd4, 0x81c30d42} },},
/**/                 {{{0x3f2bff3c, 0x07250a51} },
/**/                  {{0xbbc89dd6, 0xd6bad8c1} },},
/**/                 {{{0x3f2dff1f, 0x08c99d24} },
/**/                  {{0x3bb12609, 0xaede8ad0} },},
/**/                 {{{0x3f2fff00, 0x0aaa2ab1} },
/**/                  {{0x3ba0bbc0, 0x4dc4e3dc} },},
/**/                 {{{0x3f30ff6f, 0x8665591f} },
/**/                  {{0xbbd013d3, 0x80357b54} },},
/**/                 {{{0x3f31ff5e, 0x07979982} },
/**/                  {{0xbbce0e70, 0x4817ebcd} },},
/**/                 {{{0x3f32ff4b, 0x88edd619} },
/**/                  {{0xbbd72b9e, 0xc582abc3} },},
/**/                 {{{0x3f33ff38, 0x0a6a0e74} },
/**/                  {{0x3bdb81fc, 0xb95bc1fe} },},
/**/                 {{{0x3f34ff23, 0x8c0e4220} },
/**/                  {{0x3bcaed12, 0x9b549aae} },},
/**/                 {{{0x3f35ff0e, 0x0ddc70a1} },
/**/                  {{0x3bacf6f3, 0xd97a3c05} },},
/**/                 {{{0x3f36fef7, 0x8fd69976} },
/**/                  {{0x3bab2dcf, 0x6f810a3c} },},
/**/                 {{{0x3f37fee0, 0x11febc18} },
/**/                  {{0x3bd2b9bc, 0xf5d3f323} },},
/**/                 {{{0x3f38fec7, 0x9456d7fb} },
/**/                  {{0xbbbfb258, 0x6eaa1d6a} },},
/**/                 {{{0x3f39feae, 0x16e0ec8b} },
/**/                  {{0xbbb6137a, 0xceeb34b1} },},
/**/                 {{{0x3f3afe93, 0x999ef930} },
/**/                  {{0xbbde70e0, 0xdc639b08} },},
/**/                 {{{0x3f3bfe78, 0x1c92fd4a} },
/**/                  {{0xbbc4ed10, 0x713cc126} },},
/**/                 {{{0x3f3cfe5b, 0x9fbef835} },
/**/                  {{0xbb873d63, 0xcc0e81bd} },},
/**/                 {{{0x3f3dfe3e, 0x2324e946} },
/**/                  {{0x3bc09164, 0x62dd5deb} },},
/**/                 {{{0x3f3efe1f, 0xa6c6cfcc} },
/**/                  {{0x3bdac2da, 0x3512d15c} },},
/**/                 {{{0x3f3ffe00, 0x2aa6ab11} },
/**/                  {{0x3b999e2b, 0x62cc632d} },},
/**/                 {{{0x3f407eef, 0xd7633d2c} },
/**/                  {{0xbbebc98b, 0x63ff6024} },},
/**/                 {{{0x3f40fedf, 0x19941e6e} },
/**/                  {{0xbbb194c2, 0xe0aa6338} },},
/**/                 {{{0x3f417ecd, 0xdbe6f8eb} },
/**/                  {{0x3be4241b, 0x57b0f571} },},
/**/                 {{{0x3f41febc, 0x1e5ccc3c} },
/**/                  {{0x3bdc657d, 0x895d3592} },},
/**/                 {{{0x3f427ea9, 0xe0f697f6} },
/**/                  {{0x3be35a5d, 0x1c0ec17c} },},
/**/                 {{{0x3f42fe97, 0x23b55bac} },
/**/                  {{0x3bd6cfb7, 0x3e538464} },},
/**/                 {{{0x3f437e83, 0xe69a16ed} },
/**/                  {{0x3bee96f7, 0x7cef2478} },},
/**/                 {{{0x3f43fe70, 0x29a5c947} },
/**/                  {{0xbbd4d578, 0xbf46e36a} },},
/**/                 {{{0x3f447e5b, 0xecd97242} },
/**/                  {{0xbbc9eb66, 0x3ff7dd44} },},
/**/                 {{{0x3f44fe47, 0x30361165} },
/**/                  {{0x3be400d7, 0x7e93f2fd} },},
/**/                 {{{0x3f457e31, 0xf3bca635} },
/**/                  {{0xbbe0e2a2, 0xd375017f} },},
/**/                 {{{0x3f45fe1c, 0x376e3031} },
/**/                  {{0xbbd524eb, 0x8a5ae7f6} },},
/**/                 {{{0x3f467e05, 0xfb4baed7} },
/**/                  {{0x3be204fb, 0x4e85c4e9} },},
/**/                 {{{0x3f46fdef, 0x3f5621a3} },
/**/                  {{0xbbdf09d7, 0x34886d52} },},
/**/                 {{{0x3f477dd8, 0x038e880b} },
/**/                  {{0xbbb8900e, 0x14e596a3} },},
/**/                 {{{0x3f47fdc0, 0x47f5e185} },
/**/                  {{0xbbebfa5c, 0x57d202d3} },},
/**/                 {{{0x3f487da8, 0x0c8d2d81} },
/**/                  {{0x3be2f6ae, 0xd68c0614} },},
/**/                 {{{0x3f48fd8f, 0x51556b70} },
/**/                  {{0xbbd0f4f2, 0xe08fd201} },},
/**/                 {{{0x3f497d76, 0x164f9abc} },
/**/                  {{0x3b5296b7, 0xa871af60} },},
/**/                 {{{0x3f49fd5c, 0x5b7cbace} },
/**/                  {{0x3beb6ed4, 0x9f17d42d} },},
/**/                 {{{0x3f4a7d42, 0x20ddcb0d} },
/**/                  {{0xbbcb1149, 0x67c30397} },},
/**/                 {{{0x3f4afd27, 0x6673cada} },
/**/                  {{0x3bd32225, 0x45da594f} },},
/**/                 {{{0x3f4b7d0c, 0x2c3fb996} },
/**/                  {{0xbbb68893, 0x208d4630} },},
/**/                 {{{0x3f4bfcf0, 0x7242969d} },
/**/                  {{0x3bc5db4d, 0x2b3efe1c} },},
/**/                 {{{0x3f4c7cd4, 0x387d6149} },
/**/                  {{0x3be46eff, 0xed57d98a} },},
/**/                 {{{0x3f4cfcb7, 0x7ef118f1} },
/**/                  {{0x3becc554, 0x06f300fb} },},
/**/                 {{{0x3f4d7c9a, 0x459ebce9} },
/**/                  {{0x3be1d251, 0x13638eb6} },},
/**/                 {{{0x3f4dfc7c, 0x8c874c82} },
/**/                  {{0xbbe863e9, 0xd57a176f} },},
/**/                 {{{0x3f4e7c5e, 0x53abc708} },
/**/                  {{0x3be2d95c, 0x9528e50d} },},
/**/                 {{{0x3f4efc3f, 0x9b0d2bc8} },
/**/                  {{0x3bd1e8e8, 0xa5f5b8b7} },},
/**/                 {{{0x3f4f7c20, 0x62ac7a09} },
/**/                  {{0x3b5c8123, 0x17802a46} },},
/**/                 {{{0x3f4ffc00, 0xaa8ab110} },
/**/                  {{0xbbe0fecb, 0xeb9b6cdb} },},
/**/                 {{{0x3f503df0, 0x3954680f} },
/**/                  {{0x3bdac89b, 0x1c693678} },},
/**/                 {{{0x3f507ddf, 0xdd83eb3a} },
/**/                  {{0xbbf638f6, 0x0a75ad5f} },},
/**/                 {{{0x3f50bdcf, 0x41d461a5} },
/**/                  {{0x3bfd4bc9, 0x45f05b10} },},
/**/                 {{{0x3f50fdbe, 0x66464aef} },
/**/                  {{0xbbbd0554, 0x6abbf59c} },},
/**/                 {{{0x3f513dad, 0x4ada26b1} },
/**/                  {{0x3be38c65, 0x6036fe6f} },},
/**/                 {{{0x3f517d9b, 0xef907485} },
/**/                  {{0x3bfdc8a1, 0xf158bbc3} },},
/**/                 {{{0x3f51bd8a, 0x5469b404} },
/**/                  {{0xbbdea231, 0x55632e3f} },},
/**/                 {{{0x3f51fd78, 0x796664c3} },
/**/                  {{0xbbe00849, 0x2edb73c2} },},
/**/                 {{{0x3f523d66, 0x5e870657} },
/**/                  {{0x3bfba943, 0x0789343e} },},
/**/                 {{{0x3f527d54, 0x03cc1855} },
/**/                  {{0x3bc5f644, 0xeafafc52} },},
/**/                 {{{0x3f52bd41, 0x69361a4e} },
/**/                  {{0xbbf2f743, 0xa4a6e79f} },},
/**/                 {{{0x3f52fd2e, 0x8ec58bd2} },
/**/                  {{0xbbd4f786, 0x5ceb1abf} },},
/**/                 {{{0x3f533d1b, 0x747aec71} },
/**/                  {{0xbbf369e3, 0x49dc497d} },},
/**/                 {{{0x3f537d08, 0x1a56bbb8} },
/**/                  {{0xbbfc5e6f, 0x3726b14a} },},
/**/                 {{{0x3f53bcf4, 0x80597933} },
/**/                  {{0xbbfe8b82, 0x808f75a7} },},
/**/                 {{{0x3f53fce0, 0xa683a46c} },
/**/                  {{0x3be02719, 0x9cd06ae6} },},
/**/                 {{{0x3f543ccc, 0x8cd5bced} },
/**/                  {{0x3bf9f98d, 0x758f80f8} },},
/**/                 {{{0x3f547cb8, 0x3350423e} },
/**/                  {{0xbbd79c3d, 0x48401f45} },},
/**/                 {{{0x3f54bca3, 0x99f3b3e4} },
/**/                  {{0xbbf422b8, 0x2fba8948} },},
/**/                 {{{0x3f54fc8e, 0xc0c09163} },
/**/                  {{0x3bf32cc1, 0xf4044be8} },},
/**/                 {{{0x3f553c79, 0xa7b75a40} },
/**/                  {{0xbbe72cac, 0xf2249008} },},
/**/                 {{{0x3f557c64, 0x4ed88dfb} },
/**/                  {{0xbbe7183c, 0x459a204f} },},
/**/                 {{{0x3f55bc4e, 0xb624ac14} },
/**/                  {{0x3bf8aa64, 0xba26d3d7} },},
/**/                 {{{0x3f55fc38, 0xdd9c340b} },
/**/                  {{0x3bdbb2ff, 0x45fa193c} },},
/**/                 {{{0x3f563c22, 0xc53fa55c} },
/**/                  {{0x3bd67249, 0x0484397b} },},
/**/                 {{{0x3f567c0c, 0x6d0f7f83} },
/**/                  {{0xbbd183d7, 0xf1e73188} },},
/**/                 {{{0x3f56bbf5, 0xd50c41fa} },
/**/                  {{0xbbef433d, 0x4ab68187} },},
/**/                 {{{0x3f56fbde, 0xfd366c39} },
/**/                  {{0x3be796b8, 0x66e09e58} },},
/**/                 {{{0x3f573bc7, 0xe58e7db8} },
/**/                  {{0x3bf65ec5, 0x81e6e7e6} },},
/**/                 {{{0x3f577bb0, 0x8e14f5ed} },
/**/                  {{0xbbdb944d, 0xa9463a9c} },},
/**/                 {{{0x3f57bb98, 0xf6ca544b} },
/**/                  {{0xbbc396ec, 0xc5eda344} },},
/**/                 {{{0x3f57fb81, 0x1faf1845} },
/**/                  {{0x3beb9e6d, 0xbb624f97} },},
/**/                 {{{0x3f583b69, 0x08c3c14d} },
/**/                  {{0xbbe6ee13, 0xe6295bf2} },},
/**/                 {{{0x3f587b50, 0xb208ced1} },
/**/                  {{0x3bfcf1a5, 0x6ca19875} },},
/**/                 {{{0x3f58bb38, 0x1b7ec041} },
/**/                  {{0x3bf2d181, 0x07b4fc7e} },},
/**/                 {{{0x3f58fb1f, 0x45261509} },
/**/                  {{0x3bc419c5, 0x21bad336} },},
/**/                 {{{0x3f593b06, 0x2eff4c94} },
/**/                  {{0xbbdc2a4c, 0x700b305b} },},
/**/                 {{{0x3f597aec, 0xd90ae64c} },
/**/                  {{0xbbfc53d3, 0xa23f359c} },},
/**/                 {{{0x3f59bad3, 0x43496198} },
/**/                  {{0x3bf0c270, 0xaed6b50f} },},
/**/                 {{{0x3f59fab9, 0x6dbb3de1} },
/**/                  {{0xbbf11464, 0x7a8be031} },},
/**/                 {{{0x3f5a3a9f, 0x5860fa8a} },
/**/                  {{0x3beae9e7, 0x470dbe32} },},
/**/                 {{{0x3f5a7a85, 0x033b16f8} },
/**/                  {{0x3bfc4721, 0xda1f8579} },},
/**/                 {{{0x3f5aba6a, 0x6e4a128e} },
/**/                  {{0xbbf41852, 0x029258ce} },},
/**/                 {{{0x3f5afa4f, 0x998e6cab} },
/**/                  {{0xbbf28584, 0x2eb18782} },},
/**/                 {{{0x3f5b3a34, 0x8508a4af} },
/**/                  {{0xbbea7970, 0x23241a2c} },},
/**/                 {{{0x3f5b7a19, 0x30b939f8} },
/**/                  {{0xbbf1d8db, 0x600551b6} },},
/**/                 {{{0x3f5bb9fd, 0x9ca0abe2} },
/**/                  {{0xbbeaa412, 0x8c26cc71} },},
/**/                 {{{0x3f5bf9e1, 0xc8bf79c8} },
/**/                  {{0xbbe7f81b, 0x30427cfc} },},
/**/                 {{{0x3f5c39c5, 0xb5162303} },
/**/                  {{0x3bd9ec5f, 0xd1f134e1} },},
/**/                 {{{0x3f5c79a9, 0x61a526eb} },
/**/                  {{0x3bff0cb0, 0x8980e47d} },},
/**/                 {{{0x3f5cb98c, 0xce6d04d7} },
/**/                  {{0x3bf35aca, 0xe84ca4e2} },},
/**/                 {{{0x3f5cf96f, 0xfb6e3c1b} },
/**/                  {{0x3bf9b1b8, 0x1b0bd69f} },},
/**/                 {{{0x3f5d3952, 0xe8a94c0b} },
/**/                  {{0x3be21310, 0x3ce51832} },},
/**/                 {{{0x3f5d7935, 0x961eb3f8} },
/**/                  {{0x3bf90786, 0x840c58ce} },},
/**/                 {{{0x3f5db918, 0x03cef334} },
/**/                  {{0xbbfe0048, 0xf2dfb3f4} },},
/**/                 {{{0x3f5df8fa, 0x31ba890b} },
/**/                  {{0x3bfcf652, 0x3e295bec} },},
/**/                 {{{0x3f5e38dc, 0x1fe1f4ce} },
/**/                  {{0xbbfc5ebe, 0x151c9300} },},
/**/                 {{{0x3f5e78bd, 0xce45b5c6} },
/**/                  {{0xbbef2cc4, 0x8a25b9c7} },},
/**/                 {{{0x3f5eb89f, 0x3ce64b3e} },
/**/                  {{0x3bfe6d27, 0xa6fea7bd} },},
/**/                 {{{0x3f5ef880, 0x6bc43481} },
/**/                  {{0xbbf68037, 0x914a6dab} },},
/**/                 {{{0x3f5f3861, 0x5adff0d4} },
/**/                  {{0xbbf1d2f3, 0xf909e0e6} },},
/**/                 {{{0x3f5f7842, 0x0a39ff7e} },
/**/                  {{0xbbf64661, 0xff1e1f71} },},
/**/                 {{{0x3f5fb822, 0x79d2dfc3} },
/**/                  {{0xbbd76ce8, 0x5a6f9e9a} },},
/**/                 {{{0x3f5ff802, 0xa9ab10e6} },
/**/                  {{0x3bfe29e3, 0xa153e3b2} },},
/**/                 {{{0x3f601bf1, 0x4ce18915} },
/**/                  {{0xbbe57c28, 0xa3a73044} },},
/**/                 {{{0x3f603be1, 0x250db166} },
/**/                  {{0x3c0fd271, 0xc1ad9590} },},
/**/                 {{{0x3f605bd0, 0xdd5a4107} },
/**/                  {{0x3bfe4b5d, 0xc424c676} },},
/**/                 {{{0x3f607bc0, 0x75c77796} },
/**/                  {{0xbc068804, 0xc0eff1ba} },},
/**/                 {{{0x3f609baf, 0xee5594b0} },
/**/                  {{0xbc0ff798, 0x51dbded5} },},
/**/                 {{{0x3f60bb9f, 0x4704d7f2} },
/**/                  {{0xbbf70ef4, 0x2d5aba70} },},
/**/                 {{{0x3f60db8e, 0x7fd580f9} },
/**/                  {{0xbbeccb65, 0x7ae804b5} },},
/**/                 {{{0x3f60fb7d, 0x98c7cf60} },
/**/                  {{0x3bfede2f, 0x1775134d} },},
/**/                 {{{0x3f611b6c, 0x91dc02c3} },
/**/                  {{0xbc04d41e, 0x91ca4a67} },},
/**/                 {{{0x3f613b5b, 0x6b125aba} },
/**/                  {{0x3bfe6d0c, 0x4a12201d} },},
/**/                 {{{0x3f615b4a, 0x246b16e0} },
/**/                  {{0x3bfe507d, 0x4d4238d3} },},
/**/                 {{{0x3f617b38, 0xbde676cd} },
/**/                  {{0x3bfe0272, 0x0640462a} },},
/**/                 {{{0x3f619b27, 0x3784ba19} },
/**/                  {{0x3bd94ab3, 0x02285659} },},
/**/                 {{{0x3f61bb15, 0x9146205b} },
/**/                  {{0xbbff1e2e, 0x1cc35b7b} },},
/**/                 {{{0x3f61db03, 0xcb2ae929} },
/**/                  {{0xbc03ee8e, 0x12f6bf8d} },},
/**/                 {{{0x3f61faf1, 0xe5335418} },
/**/                  {{0x3c0bae5f, 0x7b7d619b} },},
/**/                 {{{0x3f621adf, 0xdf5fa0bf} },
/**/                  {{0xbbf5546a, 0xb3b731b0} },},
/**/                 {{{0x3f623acd, 0xb9b00eb0} },
/**/                  {{0xbbafb2b0, 0x105fd253} },},
/**/                 {{{0x3f625abb, 0x7424dd7f} },
/**/                  {{0x3c011647, 0xca53444b} },},
/**/                 {{{0x3f627aa9, 0x0ebe4cbf} },
/**/                  {{0x3c01678f, 0x592f3be8} },},
/**/                 {{{0x3f629a96, 0x897c9c02} },
/**/                  {{0xbbef2b12, 0x4347451d} },},
/**/                 {{{0x3f62ba83, 0xe4600ad8} },
/**/                  {{0x3bfb5bb7, 0xb2a477bc} },},
/**/                 {{{0x3f62da71, 0x1f68d8d3} },
/**/                  {{0xbc0590e1, 0x7a5822e4} },},
/**/                 {{{0x3f62fa5e, 0x3a974581} },
/**/                  {{0xbbf0f2e5, 0x53123101} },},
/**/                 {{{0x3f631a4b, 0x35eb9072} },
/**/                  {{0xbc018db4, 0x0e3f5fde} },},
/**/                 {{{0x3f633a38, 0x1165f933} },
/**/                  {{0x3c0921d5, 0x8d0afb38} },},
/**/                 {{{0x3f635a24, 0xcd06bf53} },
/**/                  {{0x3c01f6ba, 0xb5791b80} },},
/**/                 {{{0x3f637a11, 0x68ce225e} },
/**/                  {{0x3bde2af8, 0xa1894236} },},
/**/                 {{{0x3f6399fd, 0xe4bc61e0} },
/**/                  {{0xbc062a48, 0xd0f06ff3} },},
/**/                 {{{0x3f63b9ea, 0x40d1bd63} },
/**/                  {{0x3bffc80c, 0x4b4f9c11} },},
/**/                 {{{0x3f63d9d6, 0x7d0e7473} },
/**/                  {{0x3c02219b, 0x6a92c891} },},
/**/                 {{{0x3f63f9c2, 0x9972c699} },
/**/                  {{0x3c0d3590, 0x790ade9e} },},
/**/                 {{{0x3f6419ae, 0x95fef35f} },
/**/                  {{0xbc01c279, 0x792a458c} },},
/**/                 {{{0x3f64399a, 0x72b33a4b} },
/**/                  {{0x3c02ce64, 0x327bffae} },},
/**/                 {{{0x3f645986, 0x2f8fdae7} },
/**/                  {{0xbc070aec, 0xd231155c} },},
/**/                 {{{0x3f647971, 0xcc9514b7} },
/**/                  {{0x3c0f373d, 0xe4bbf776} },},
/**/                 {{{0x3f64995d, 0x49c32744} },
/**/                  {{0xbbf6d7e5, 0xbf22b2a7} },},
/**/                 {{{0x3f64b948, 0xa71a5211} },
/**/                  {{0xbbedec69, 0x64fe2936} },},
/**/                 {{{0x3f64d933, 0xe49ad4a3} },
/**/                  {{0x3bf5fc4b, 0xabee4257} },},
/**/                 {{{0x3f64f91f, 0x0244ee7e} },
/**/                  {{0x3c0c6fe3, 0x3cd1474f} },},
/**/                 {{{0x3f65190a, 0x0018df26} },
/**/                  {{0xbc023957, 0xd11e7fa5} },},
/**/                 {{{0x3f6538f4, 0xde16e61b} },
/**/                  {{0x3c006c31, 0x55380346} },},
/**/                 {{{0x3f6558df, 0x9c3f42e1} },
/**/                  {{0xbc09b7d4, 0xc4a5134c} },},
/**/                 {{{0x3f6578ca, 0x3a9234f7} },
/**/                  {{0xbc0e3f10, 0x2772c19c} },},
/**/                 {{{0x3f6598b4, 0xb90ffbdd} },
/**/                  {{0x3be6f110, 0x5592b468} },},
/**/                 {{{0x3f65b89f, 0x17b8d714} },
/**/                  {{0xbc0a5fea, 0xb251ace2} },},
/**/                 {{{0x3f65d889, 0x568d0619} },
/**/                  {{0xbc0aacc9, 0x315da285} },},
/**/                 {{{0x3f65f873, 0x758cc86a} },
/**/                  {{0xbbeb0782, 0xba64d81a} },},
/**/                 {{{0x3f66185d, 0x74b85d85} },
/**/                  {{0xbc09b459, 0x8e1eb3fa} },},
/**/                 {{{0x3f663847, 0x541004e5} },
/**/                  {{0x3bce9c22, 0x1d86e863} },},
/**/                 {{{0x3f665831, 0x1393fe07} },
/**/                  {{0xbbfbeb77, 0xcf37ee90} },},
/**/                 {{{0x3f66781a, 0xb3448865} },
/**/                  {{0xbc02dc68, 0xc252e3c9} },},
/**/                 {{{0x3f669804, 0x3321e379} },
/**/                  {{0xbbe73a0b, 0xb40b3741} },},
  };

#else
#ifdef LITTLE_ENDI
  static const number
           Iu[182] = {                            /* 1/ui   */
/**/                  {{0xd1537290, 0x3ff6a13c} },
/**/                  {{0x16816817, 0x3ff68168} },
/**/                  {{0x6a5122f9, 0x3ff661ec} },
/**/                  {{0x590b2164, 0x3ff642c8} },
/**/                  {{0x77016240, 0x3ff623fa} },
/**/                  {{0x60581606, 0x3ff60581} },
/**/                  {{0xb8d015e7, 0x3ff5e75b} },
/**/                  {{0x2b931057, 0x3ff5c988} },
/**/                  {{0x6b015ac0, 0x3ff5ac05} },
/**/                  {{0x308158ed, 0x3ff58ed2} },
/**/                  {{0x3c506b3a, 0x3ff571ed} },
/**/                  {{0x55555555, 0x3ff55555} },
/**/                  {{0x48f40feb, 0x3ff53909} },
/**/                  {{0xeae2f815, 0x3ff51d07} },
/**/                  {{0x15015015, 0x3ff50150} },
/**/                  {{0xa72f0539, 0x3ff4e5e0} },
/**/                  {{0x8725af6e, 0x3ff4cab8} },
/**/                  {{0xa052bf5b, 0x3ff4afd6} },
/**/                  {{0xe3b2d067, 0x3ff49539} },
/**/                  {{0x47ae147b, 0x3ff47ae1} },
/**/                  {{0xc7f5cf9a, 0x3ff460cb} },
/**/                  {{0x6562d9fb, 0x3ff446f8} },
/**/                  {{0x25d51f87, 0x3ff42d66} },
/**/                  {{0x14141414, 0x3ff41414} },
/**/                  {{0x3fb013fb, 0x3ff3fb01} },
/**/                  {{0xbce4a902, 0x3ff3e22c} },
/**/                  {{0xa47babe7, 0x3ff3c995} },
/**/                  {{0x13b13b14, 0x3ff3b13b} },
/**/                  {{0x2c187f63, 0x3ff3991c} },
/**/                  {{0x13813814, 0x3ff38138} },
/**/                  {{0xf3de0748, 0x3ff3698d} },
/**/                  {{0xfb2b78c1, 0x3ff3521c} },
/**/                  {{0x5b57bcb2, 0x3ff33ae4} },
/**/                  {{0x4a2b10bf, 0x3ff323e3} },
/**/                  {{0x0130d190, 0x3ff30d19} },
/**/                  {{0xbda12f68, 0x3ff2f684} },
/**/                  {{0xc04b8097, 0x3ff2e025} },
/**/                  {{0x4d812ca0, 0x3ff2c9fb} },
/**/                  {{0xad012b40, 0x3ff2b404} },
/**/                  {{0x29e4129e, 0x3ff29e41} },
/**/                  {{0x1288b013, 0x3ff288b0} },
/**/                  {{0xb8812735, 0x3ff27350} },
/**/                  {{0x708092f1, 0x3ff25e22} },
/**/                  {{0x92492492, 0x3ff24924} },
/**/                  {{0x789abcdf, 0x3ff23456} },
/**/                  {{0x8121fb78, 0x3ff21fb7} },
/**/                  {{0x0c67c0d9, 0x3ff20b47} },
/**/                  {{0x7dc11f70, 0x3ff1f704} },
/**/                  {{0x3b3fb874, 0x3ff1e2ef} },
/**/                  {{0xada2811d, 0x3ff1cf06} },
/**/                  {{0x4046ed29, 0x3ff1bb4a} },
/**/                  {{0x611a7b96, 0x3ff1a7b9} },
/**/                  {{0x808ca29c, 0x3ff19453} },
/**/                  {{0x11811812, 0x3ff18118} },
/**/                  {{0x89427379, 0x3ff16e06} },
/**/                  {{0x5f75270d, 0x3ff15b1e} },
/**/                  {{0x0e0acd3b, 0x3ff1485f} },
/**/                  {{0x1135c811, 0x3ff135c8} },
/**/                  {{0xe75d3033, 0x3ff12358} },
/**/                  {{0x11111111, 0x3ff11111} },
/**/                  {{0x10fef011, 0x3ff0fef0} },
/**/                  {{0x6be69c90, 0x3ff0ecf5} },
/**/                  {{0xa88f4696, 0x3ff0db20} },
/**/                  {{0x4fbcda3b, 0x3ff0c971} },
/**/                  {{0xec259dc8, 0x3ff0b7e6} },
/**/                  {{0x0a6810a7, 0x3ff0a681} },
/**/                  {{0x39010954, 0x3ff0953f} },
/**/                  {{0x08421084, 0x3ff08421} },
/**/                  {{0x0a47f7c6, 0x3ff07326} },
/**/                  {{0xd2f1a9fc, 0x3ff0624d} },
/**/                  {{0xf7d73404, 0x3ff05197} },
/**/                  {{0x10410410, 0x3ff04104} },
/**/                  {{0xb51f5e1a, 0x3ff03091} },
/**/                  {{0x81020408, 0x3ff02040} },
/**/                  {{0x10101010, 0x3ff01010} },
/**/                  {{0x00000000, 0x3ff00000} },
/**/                  {{0xe01fe020, 0x3fefe01f} },
/**/                  {{0x01fc07f0, 0x3fefc07f} },
/**/                  {{0xaa01fa12, 0x3fefa11c} },
/**/                  {{0x1f81f820, 0x3fef81f8} },
/**/                  {{0xaca0dbb5, 0x3fef6310} },
/**/                  {{0x9e4a4271, 0x3fef4465} },
/**/                  {{0x44230ab5, 0x3fef25f6} },
/**/                  {{0xf07c1f08, 0x3fef07c1} },
/**/                  {{0xf8458e02, 0x3feee9c7} },
/**/                  {{0xb301ecc0, 0x3feecc07} },
/**/                  {{0x7aba01eb, 0x3feeae80} },
/**/                  {{0xabf0b767, 0x3fee9131} },
/**/                  {{0xa59750e4, 0x3fee741a} },
/**/                  {{0xc901e574, 0x3fee573a} },
/**/                  {{0x79dc1a73, 0x3fee3a91} },
/**/                  {{0x1e1e1e1e, 0x3fee1e1e} },
/**/                  {{0x1e01e01e, 0x3fee01e0} },
/**/                  {{0xe3f8868a, 0x3fede5d6} },
/**/                  {{0xdca01dca, 0x3fedca01} },
/**/                  {{0x76b981db, 0x3fedae60} },
/**/                  {{0x231e7f8a, 0x3fed92f2} },
/**/                  {{0x54b82c34, 0x3fed77b6} },
/**/                  {{0x807572b2, 0x3fed5cac} },
/**/                  {{0x1d41d41d, 0x3fed41d4} },
/**/                  {{0xa3fc5b1a, 0x3fed272c} },
/**/                  {{0x8f6ec074, 0x3fed0cb5} },
/**/                  {{0x5c44bfc6, 0x3fecf26e} },
/**/                  {{0x89039b0b, 0x3fecd856} },
/**/                  {{0x9601cbe7, 0x3fecbe6d} },
/**/                  {{0x055ee191, 0x3feca4b3} },
/**/                  {{0x5afb8a42, 0x3fec8b26} },
/**/                  {{0x1c71c71c, 0x3fec71c7} },
/**/                  {{0xd10d4986, 0x3fec5894} },
/**/                  {{0x01c3f8f0, 0x3fec3f8f} },
/**/                  {{0x392ea01c, 0x3fec26b5} },
/**/                  {{0x0381c0e0, 0x3fec0e07} },
/**/                  {{0xee868d8b, 0x3febf583} },
/**/                  {{0x899406f7, 0x3febdd2b} },
/**/                  {{0x65883e7b, 0x3febc4fd} },
/**/                  {{0x14c1bad0, 0x3febacf9} },
/**/                  {{0x2b18ff23, 0x3feb951e} },
/**/                  {{0x3dda338b, 0x3feb7d6c} },
/**/                  {{0xe3beee05, 0x3feb65e2} },
/**/                  {{0xb4e81b4f, 0x3feb4e81} },
/**/                  {{0x4ad806ce, 0x3feb3748} },
/**/                  {{0x406c80d9, 0x3feb2036} },
/**/                  {{0x31d922a4, 0x3feb094b} },
/**/                  {{0xbca1af28, 0x3feaf286} },
/**/                  {{0x7f94905e, 0x3feadbe8} },
/**/                  {{0x1ac5701b, 0x3feac570} },
/**/                  {{0x2f87ebfd, 0x3feaaf1d} },
/**/                  {{0x606a63be, 0x3fea98ef} },
/**/                  {{0x5130e159, 0x3fea82e6} },
/**/                  {{0xa6d01a6d, 0x3fea6d01} },
/**/                  {{0x07688a4a, 0x3fea5741} },
/**/                  {{0x1a41a41a, 0x3fea41a4} },
/**/                  {{0x87c51ca0, 0x3fea2c2a} },
/**/                  {{0xf97a4b02, 0x3fea16d3} },
/**/                  {{0x1a01a01a, 0x3fea01a0} },
/**/                  {{0x951033d9, 0x3fe9ec8e} },
/**/                  {{0x176b682d, 0x3fe9d79f} },
/**/                  {{0x4ee4a102, 0x3fe9c2d1} },
/**/                  {{0xea5510da, 0x3fe9ae24} },
/**/                  {{0x9999999a, 0x3fe99999} },
/**/                  {{0x0d8ec0ff, 0x3fe9852f} },
/**/                  {{0xf80cb872, 0x3fe970e4} },
/**/                  {{0x0be377ae, 0x3fe95cbb} },
/**/                  {{0xfcd6e9e0, 0x3fe948b0} },
/**/                  {{0x7f9b2ce6, 0x3fe934c6} },
/**/                  {{0x49d0e229, 0x3fe920fb} },
/**/                  {{0x120190d5, 0x3fe90d4f} },
/**/                  {{0x8f9c18fa, 0x3fe8f9c1} },
/**/                  {{0x7af1373f, 0x3fe8e652} },
/**/                  {{0x8d3018d3, 0x3fe8d301} },
/**/                  {{0x8062ff3a, 0x3fe8bfce} },
/**/                  {{0x0f6bf3aa, 0x3fe8acb9} },
/**/                  {{0xf601899c, 0x3fe899c0} },
/**/                  {{0xf0abb04a, 0x3fe886e5} },
/**/                  {{0xbcc092b9, 0x3fe87427} },
/**/                  {{0x18618618, 0x3fe86186} },
/**/                  {{0xc2780614, 0x3fe84f00} },
/**/                  {{0x7ab2bedd, 0x3fe83c97} },
/**/                  {{0x0182a4a0, 0x3fe82a4a} },
/**/                  {{0x18181818, 0x3fe81818} },
/**/                  {{0x80601806, 0x3fe80601} },
/**/                  {{0xfd017f40, 0x3fe7f405} },
/**/                  {{0x515a4f1d, 0x3fe7e225} },
/**/                  {{0x417d05f4, 0x3fe7d05f} },
/**/                  {{0x922e017c, 0x3fe7beb3} },
/**/                  {{0x08e0ecc3, 0x3fe7ad22} },
/**/                  {{0x6bb6398b, 0x3fe79baa} },
/**/                  {{0x8178a4c8, 0x3fe78a4c} },
/**/                  {{0x119ac60d, 0x3fe77908} },
/**/                  {{0xe434a9b1, 0x3fe767dc} },
/**/                  {{0xc201756d, 0x3fe756ca} },
/**/                  {{0x745d1746, 0x3fe745d1} },
/**/                  {{0xc541fe8d, 0x3fe734f0} },
/**/                  {{0x7f46debc, 0x3fe72428} },
/**/                  {{0x6d9c7c09, 0x3fe71378} },
/**/                  {{0x5c0b8170, 0x3fe702e0} },
/**/                  {{0x16f26017, 0x3fe6f260} },
/**/                  {{0x6b4337c7, 0x3fe6e1f7} },
/**/                  {{0x2681c861, 0x3fe6d1a6} },
/**/                  {{0x16c16c17, 0x3fe6c16c} },
/**/                  {{0x0aa31a3d, 0x3fe6b149} },
/**/                  {{0xd1537290, 0x3fe6a13c} },
  };

  static const number
           Iv[362] = {                            /* 1/vj   */
/**/                  {{0xee93bfe3, 0x3ff00b47} },
/**/                  {{0xd80c106f, 0x3ff00b37} },
/**/                  {{0xc1a4a47a, 0x3ff00b27} },
/**/                  {{0xab5d7ba2, 0x3ff00b17} },
/**/                  {{0x95369587, 0x3ff00b07} },
/**/                  {{0x7f2ff1c6, 0x3ff00af7} },
/**/                  {{0x69499000, 0x3ff00ae7} },
/**/                  {{0x53836fd3, 0x3ff00ad7} },
/**/                  {{0x3ddd90dd, 0x3ff00ac7} },
/**/                  {{0x2857f2bf, 0x3ff00ab7} },
/**/                  {{0x12f29517, 0x3ff00aa7} },
/**/                  {{0xfdad7784, 0x3ff00a96} },
/**/                  {{0xe88899a5, 0x3ff00a86} },
/**/                  {{0xd383fb19, 0x3ff00a76} },
/**/                  {{0xbe9f9b7f, 0x3ff00a66} },
/**/                  {{0xa9db7a76, 0x3ff00a56} },
/**/                  {{0x9537979d, 0x3ff00a46} },
/**/                  {{0x80b3f293, 0x3ff00a36} },
/**/                  {{0x6c508af8, 0x3ff00a26} },
/**/                  {{0x580d606a, 0x3ff00a16} },
/**/                  {{0x43ea7288, 0x3ff00a06} },
/**/                  {{0x2fe7c0f1, 0x3ff009f6} },
/**/                  {{0x1c054b44, 0x3ff009e6} },
/**/                  {{0x08431122, 0x3ff009d6} },
/**/                  {{0xf4a11227, 0x3ff009c5} },
/**/                  {{0xe11f4df4, 0x3ff009b5} },
/**/                  {{0xcdbdc428, 0x3ff009a5} },
/**/                  {{0xba7c7462, 0x3ff00995} },
/**/                  {{0xa75b5e40, 0x3ff00985} },
/**/                  {{0x945a8162, 0x3ff00975} },
/**/                  {{0x8179dd68, 0x3ff00965} },
/**/                  {{0x6eb971ef, 0x3ff00955} },
/**/                  {{0x5c193e98, 0x3ff00945} },
/**/                  {{0x49994301, 0x3ff00935} },
/**/                  {{0x37397eca, 0x3ff00925} },
/**/                  {{0x24f9f192, 0x3ff00915} },
/**/                  {{0x12da9af7, 0x3ff00905} },
/**/                  {{0x00db7a99, 0x3ff008f5} },
/**/                  {{0xeefc9018, 0x3ff008e4} },
/**/                  {{0xdd3ddb12, 0x3ff008d4} },
/**/                  {{0xcb9f5b26, 0x3ff008c4} },
/**/                  {{0xba210ff4, 0x3ff008b4} },
/**/                  {{0xa8c2f91a, 0x3ff008a4} },
/**/                  {{0x97851639, 0x3ff00894} },
/**/                  {{0x866766ef, 0x3ff00884} },
/**/                  {{0x7569eadb, 0x3ff00874} },
/**/                  {{0x648ca19d, 0x3ff00864} },
/**/                  {{0x53cf8ad3, 0x3ff00854} },
/**/                  {{0x4332a61e, 0x3ff00844} },
/**/                  {{0x32b5f31b, 0x3ff00834} },
/**/                  {{0x2259716c, 0x3ff00824} },
/**/                  {{0x121d20ad, 0x3ff00814} },
/**/                  {{0x02010080, 0x3ff00804} },
/**/                  {{0xf2051083, 0x3ff007f3} },
/**/                  {{0xe2295056, 0x3ff007e3} },
/**/                  {{0xd26dbf97, 0x3ff007d3} },
/**/                  {{0xc2d25de5, 0x3ff007c3} },
/**/                  {{0xb3572ae2, 0x3ff007b3} },
/**/                  {{0xa3fc262a, 0x3ff007a3} },
/**/                  {{0x94c14f5f, 0x3ff00793} },
/**/                  {{0x85a6a61e, 0x3ff00783} },
/**/                  {{0x76ac2a08, 0x3ff00773} },
/**/                  {{0x67d1dabb, 0x3ff00763} },
/**/                  {{0x5917b7d7, 0x3ff00753} },
/**/                  {{0x4a7dc0fb, 0x3ff00743} },
/**/                  {{0x3c03f5c7, 0x3ff00733} },
/**/                  {{0x2daa55da, 0x3ff00723} },
/**/                  {{0x1f70e0d3, 0x3ff00713} },
/**/                  {{0x11579652, 0x3ff00703} },
/**/                  {{0x035e75f5, 0x3ff006f3} },
/**/                  {{0xf5857f5d, 0x3ff006e2} },
/**/                  {{0xe7ccb228, 0x3ff006d2} },
/**/                  {{0xda340df6, 0x3ff006c2} },
/**/                  {{0xccbb9266, 0x3ff006b2} },
/**/                  {{0xbf633f18, 0x3ff006a2} },
/**/                  {{0xb22b13ab, 0x3ff00692} },
/**/                  {{0xa5130fbe, 0x3ff00682} },
/**/                  {{0x981b32f1, 0x3ff00672} },
/**/                  {{0x8b437ce4, 0x3ff00662} },
/**/                  {{0x7e8bed35, 0x3ff00652} },
/**/                  {{0x71f48383, 0x3ff00642} },
/**/                  {{0x657d3f70, 0x3ff00632} },
/**/                  {{0x59262098, 0x3ff00622} },
/**/                  {{0x4cef269e, 0x3ff00612} },
/**/                  {{0x40d8511e, 0x3ff00602} },
/**/                  {{0x34e19fba, 0x3ff005f2} },
/**/                  {{0x290b1211, 0x3ff005e2} },
/**/                  {{0x1d54a7c1, 0x3ff005d2} },
/**/                  {{0x11be606b, 0x3ff005c2} },
/**/                  {{0x06483bad, 0x3ff005b2} },
/**/                  {{0xfaf23928, 0x3ff005a1} },
/**/                  {{0xefbc587b, 0x3ff00591} },
/**/                  {{0xe4a69945, 0x3ff00581} },
/**/                  {{0xd9b0fb25, 0x3ff00571} },
/**/                  {{0xcedb7dbc, 0x3ff00561} },
/**/                  {{0xc42620a9, 0x3ff00551} },
/**/                  {{0xb990e38b, 0x3ff00541} },
/**/                  {{0xaf1bc601, 0x3ff00531} },
/**/                  {{0xa4c6c7ac, 0x3ff00521} },
/**/                  {{0x9a91e82a, 0x3ff00511} },
/**/                  {{0x907d271c, 0x3ff00501} },
/**/                  {{0x86888421, 0x3ff004f1} },
/**/                  {{0x7cb3fed8, 0x3ff004e1} },
/**/                  {{0x72ff96e0, 0x3ff004d1} },
/**/                  {{0x696b4bdb, 0x3ff004c1} },
/**/                  {{0x5ff71d66, 0x3ff004b1} },
/**/                  {{0x56a30b21, 0x3ff004a1} },
/**/                  {{0x4d6f14ad, 0x3ff00491} },
/**/                  {{0x445b39a8, 0x3ff00481} },
/**/                  {{0x3b6779b3, 0x3ff00471} },
/**/                  {{0x3293d46c, 0x3ff00461} },
/**/                  {{0x29e04974, 0x3ff00451} },
/**/                  {{0x214cd869, 0x3ff00441} },
/**/                  {{0x18d980ed, 0x3ff00431} },
/**/                  {{0x1086429d, 0x3ff00421} },
/**/                  {{0x08531d1a, 0x3ff00411} },
/**/                  {{0x00401004, 0x3ff00401} },
/**/                  {{0xf84d1afa, 0x3ff003f0} },
/**/                  {{0xf07a3d9b, 0x3ff003e0} },
/**/                  {{0xe8c77787, 0x3ff003d0} },
/**/                  {{0xe134c85f, 0x3ff003c0} },
/**/                  {{0xd9c22fc1, 0x3ff003b0} },
/**/                  {{0xd26fad4d, 0x3ff003a0} },
/**/                  {{0xcb3d40a3, 0x3ff00390} },
/**/                  {{0xc42ae963, 0x3ff00380} },
/**/                  {{0xbd38a72c, 0x3ff00370} },
/**/                  {{0xb666799e, 0x3ff00360} },
/**/                  {{0xafb46058, 0x3ff00350} },
/**/                  {{0xa9225afa, 0x3ff00340} },
/**/                  {{0xa2b06925, 0x3ff00330} },
/**/                  {{0x9c5e8a77, 0x3ff00320} },
/**/                  {{0x962cbe90, 0x3ff00310} },
/**/                  {{0x901b0511, 0x3ff00300} },
/**/                  {{0x8a295d98, 0x3ff002f0} },
/**/                  {{0x8457c7c6, 0x3ff002e0} },
/**/                  {{0x7ea6433a, 0x3ff002d0} },
/**/                  {{0x7914cf94, 0x3ff002c0} },
/**/                  {{0x73a36c73, 0x3ff002b0} },
/**/                  {{0x6e521978, 0x3ff002a0} },
/**/                  {{0x6920d642, 0x3ff00290} },
/**/                  {{0x640fa271, 0x3ff00280} },
/**/                  {{0x5f1e7da5, 0x3ff00270} },
/**/                  {{0x5a4d677d, 0x3ff00260} },
/**/                  {{0x559c5f9a, 0x3ff00250} },
/**/                  {{0x510b659a, 0x3ff00240} },
/**/                  {{0x4c9a791f, 0x3ff00230} },
/**/                  {{0x484999c6, 0x3ff00220} },
/**/                  {{0x4418c732, 0x3ff00210} },
/**/                  {{0x40080100, 0x3ff00200} },
/**/                  {{0x3c1746d2, 0x3ff001f0} },
/**/                  {{0x38469846, 0x3ff001e0} },
/**/                  {{0x3495f4fd, 0x3ff001d0} },
/**/                  {{0x31055c96, 0x3ff001c0} },
/**/                  {{0x2d94ceb2, 0x3ff001b0} },
/**/                  {{0x2a444af0, 0x3ff001a0} },
/**/                  {{0x2713d0ef, 0x3ff00190} },
/**/                  {{0x24036051, 0x3ff00180} },
/**/                  {{0x2112f8b4, 0x3ff00170} },
/**/                  {{0x1e4299b9, 0x3ff00160} },
/**/                  {{0x1b9242ff, 0x3ff00150} },
/**/                  {{0x1901f427, 0x3ff00140} },
/**/                  {{0x1691acd0, 0x3ff00130} },
/**/                  {{0x14416c9a, 0x3ff00120} },
/**/                  {{0x12113324, 0x3ff00110} },
/**/                  {{0x10010010, 0x3ff00100} },
/**/                  {{0x0e10d2fc, 0x3ff000f0} },
/**/                  {{0x0c40ab89, 0x3ff000e0} },
/**/                  {{0x0a908957, 0x3ff000d0} },
/**/                  {{0x09006c05, 0x3ff000c0} },
/**/                  {{0x07905334, 0x3ff000b0} },
/**/                  {{0x06403e82, 0x3ff000a0} },
/**/                  {{0x05102d92, 0x3ff00090} },
/**/                  {{0x04002001, 0x3ff00080} },
/**/                  {{0x03101571, 0x3ff00070} },
/**/                  {{0x02400d80, 0x3ff00060} },
/**/                  {{0x019007d0, 0x3ff00050} },
/**/                  {{0x01000400, 0x3ff00040} },
/**/                  {{0x009001b0, 0x3ff00030} },
/**/                  {{0x00400080, 0x3ff00020} },
/**/                  {{0x00100010, 0x3ff00010} },
/**/                  {{0x00000000, 0x3ff00000} },
/**/                  {{0x001fffe0, 0x3fefffe0} },
/**/                  {{0x007fff00, 0x3fefffc0} },
/**/                  {{0x011ffca0, 0x3fefffa0} },
/**/                  {{0x01fff800, 0x3fefff80} },
/**/                  {{0x031ff060, 0x3fefff60} },
/**/                  {{0x047fe501, 0x3fefff40} },
/**/                  {{0x061fd521, 0x3fefff20} },
/**/                  {{0x07ffc002, 0x3fefff00} },
/**/                  {{0x0a1fa4e3, 0x3feffee0} },
/**/                  {{0x0c7f8305, 0x3feffec0} },
/**/                  {{0x0f1f59a7, 0x3feffea0} },
/**/                  {{0x11ff280a, 0x3feffe80} },
/**/                  {{0x151eed6e, 0x3feffe60} },
/**/                  {{0x187ea913, 0x3feffe40} },
/**/                  {{0x1c1e5a39, 0x3feffe20} },
/**/                  {{0x1ffe0020, 0x3feffe00} },
/**/                  {{0x241d9a09, 0x3feffde0} },
/**/                  {{0x287d2733, 0x3feffdc0} },
/**/                  {{0x2d1ca6e0, 0x3feffda0} },
/**/                  {{0x31fc184e, 0x3feffd80} },
/**/                  {{0x371b7abf, 0x3feffd60} },
/**/                  {{0x3c7acd72, 0x3feffd40} },
/**/                  {{0x421a0fa9, 0x3feffd20} },
/**/                  {{0x47f940a2, 0x3feffd00} },
/**/                  {{0x4e185f9f, 0x3feffce0} },
/**/                  {{0x54776bdf, 0x3feffcc0} },
/**/                  {{0x5b1664a3, 0x3feffca0} },
/**/                  {{0x61f5492c, 0x3feffc80} },
/**/                  {{0x691418b9, 0x3feffc60} },
/**/                  {{0x7072d28b, 0x3feffc40} },
/**/                  {{0x781175e3, 0x3feffc20} },
/**/                  {{0x7ff00200, 0x3feffc00} },
/**/                  {{0x880e7623, 0x3feffbe0} },
/**/                  {{0x906cd18c, 0x3feffbc0} },
/**/                  {{0x990b137c, 0x3feffba0} },
/**/                  {{0xa1e93b34, 0x3feffb80} },
/**/                  {{0xab0747f3, 0x3feffb60} },
/**/                  {{0xb46538fa, 0x3feffb40} },
/**/                  {{0xbe030d89, 0x3feffb20} },
/**/                  {{0xc7e0c4e1, 0x3feffb00} },
/**/                  {{0xd1fe5e43, 0x3feffae0} },
/**/                  {{0xdc5bd8ee, 0x3feffac0} },
/**/                  {{0xe6f93424, 0x3feffaa0} },
/**/                  {{0xf1d66f25, 0x3feffa80} },
/**/                  {{0xfcf38931, 0x3feffa60} },
/**/                  {{0x08508189, 0x3feffa41} },
/**/                  {{0x13ed576d, 0x3feffa21} },
/**/                  {{0x1fca0a1e, 0x3feffa01} },
/**/                  {{0x2be698dd, 0x3feff9e1} },
/**/                  {{0x384302e9, 0x3feff9c1} },
/**/                  {{0x44df4785, 0x3feff9a1} },
/**/                  {{0x51bb65ef, 0x3feff981} },
/**/                  {{0x5ed75d6a, 0x3feff961} },
/**/                  {{0x6c332d34, 0x3feff941} },
/**/                  {{0x79ced490, 0x3feff921} },
/**/                  {{0x87aa52be, 0x3feff901} },
/**/                  {{0x95c5a6fe, 0x3feff8e1} },
/**/                  {{0xa420d091, 0x3feff8c1} },
/**/                  {{0xb2bbceb7, 0x3feff8a1} },
/**/                  {{0xc196a0b2, 0x3feff881} },
/**/                  {{0xd0b145c2, 0x3feff861} },
/**/                  {{0xe00bbd28, 0x3feff841} },
/**/                  {{0xefa60624, 0x3feff821} },
/**/                  {{0xff801ff8, 0x3feff801} },
/**/                  {{0x0f9a09e3, 0x3feff7e2} },
/**/                  {{0x1ff3c328, 0x3feff7c2} },
/**/                  {{0x308d4b05, 0x3feff7a2} },
/**/                  {{0x4166a0bd, 0x3feff782} },
/**/                  {{0x527fc390, 0x3feff762} },
/**/                  {{0x63d8b2bf, 0x3feff742} },
/**/                  {{0x75716d8b, 0x3feff722} },
/**/                  {{0x8749f334, 0x3feff702} },
/**/                  {{0x996242fb, 0x3feff6e2} },
/**/                  {{0xabba5c21, 0x3feff6c2} },
/**/                  {{0xbe523de8, 0x3feff6a2} },
/**/                  {{0xd129e78f, 0x3feff682} },
/**/                  {{0xe4415858, 0x3feff662} },
/**/                  {{0xf7988f84, 0x3feff642} },
/**/                  {{0x0b2f8c54, 0x3feff623} },
/**/                  {{0x1f064e08, 0x3feff603} },
/**/                  {{0x331cd3e1, 0x3feff5e3} },
/**/                  {{0x47731d21, 0x3feff5c3} },
/**/                  {{0x5c092908, 0x3feff5a3} },
/**/                  {{0x70def6d7, 0x3feff583} },
/**/                  {{0x85f485d0, 0x3feff563} },
/**/                  {{0x9b49d532, 0x3feff543} },
/**/                  {{0xb0dee440, 0x3feff523} },
/**/                  {{0xc6b3b23b, 0x3feff503} },
/**/                  {{0xdcc83e62, 0x3feff4e3} },
/**/                  {{0xf31c87f8, 0x3feff4c3} },
/**/                  {{0x09b08e3d, 0x3feff4a4} },
/**/                  {{0x20845073, 0x3feff484} },
/**/                  {{0x3797cdda, 0x3feff464} },
/**/                  {{0x4eeb05b4, 0x3feff444} },
/**/                  {{0x667df741, 0x3feff424} },
/**/                  {{0x7e50a1c3, 0x3feff404} },
/**/                  {{0x9663047b, 0x3feff3e4} },
/**/                  {{0xaeb51eaa, 0x3feff3c4} },
/**/                  {{0xc746ef91, 0x3feff3a4} },
/**/                  {{0xe0187672, 0x3feff384} },
/**/                  {{0xf929b28d, 0x3feff364} },
/**/                  {{0x127aa323, 0x3feff345} },
/**/                  {{0x2c0b4776, 0x3feff325} },
/**/                  {{0x45db9ec7, 0x3feff305} },
/**/                  {{0x5feba858, 0x3feff2e5} },
/**/                  {{0x7a3b6369, 0x3feff2c5} },
/**/                  {{0x94cacf3b, 0x3feff2a5} },
/**/                  {{0xaf99eb11, 0x3feff285} },
/**/                  {{0xcaa8b62a, 0x3feff265} },
/**/                  {{0xe5f72fc9, 0x3feff245} },
/**/                  {{0x0185572f, 0x3feff226} },
/**/                  {{0x1d532b9d, 0x3feff206} },
/**/                  {{0x3960ac54, 0x3feff1e6} },
/**/                  {{0x55add896, 0x3feff1c6} },
/**/                  {{0x723aafa3, 0x3feff1a6} },
/**/                  {{0x8f0730be, 0x3feff186} },
/**/                  {{0xac135b27, 0x3feff166} },
/**/                  {{0xc95f2e21, 0x3feff146} },
/**/                  {{0xe6eaa8eb, 0x3feff126} },
/**/                  {{0x04b5cac9, 0x3feff107} },
/**/                  {{0x22c092fb, 0x3feff0e7} },
/**/                  {{0x410b00c2, 0x3feff0c7} },
/**/                  {{0x5f951360, 0x3feff0a7} },
/**/                  {{0x7e5eca16, 0x3feff087} },
/**/                  {{0x9d682426, 0x3feff067} },
/**/                  {{0xbcb120d2, 0x3feff047} },
/**/                  {{0xdc39bf5a, 0x3feff027} },
/**/                  {{0xfc01ff00, 0x3feff007} },
/**/                  {{0x1c09df07, 0x3fefefe8} },
/**/                  {{0x3c515eae, 0x3fefefc8} },
/**/                  {{0x5cd87d38, 0x3fefefa8} },
/**/                  {{0x7d9f39e6, 0x3fefef88} },
/**/                  {{0x9ea593fa, 0x3fefef68} },
/**/                  {{0xbfeb8ab5, 0x3fefef48} },
/**/                  {{0xe1711d5a, 0x3fefef28} },
/**/                  {{0x03364b28, 0x3fefef09} },
/**/                  {{0x253b1363, 0x3fefeee9} },
/**/                  {{0x477f754b, 0x3fefeec9} },
/**/                  {{0x6a037022, 0x3fefeea9} },
/**/                  {{0x8cc7032a, 0x3fefee89} },
/**/                  {{0xafca2da5, 0x3fefee69} },
/**/                  {{0xd30ceed4, 0x3fefee49} },
/**/                  {{0xf68f45f8, 0x3fefee29} },
/**/                  {{0x1a513254, 0x3fefee0a} },
/**/                  {{0x3e52b329, 0x3fefedea} },
/**/                  {{0x6293c7b8, 0x3fefedca} },
/**/                  {{0x87146f44, 0x3fefedaa} },
/**/                  {{0xabd4a90e, 0x3fefed8a} },
/**/                  {{0xd0d47458, 0x3fefed6a} },
/**/                  {{0xf613d064, 0x3fefed4a} },
/**/                  {{0x1b92bc73, 0x3fefed2b} },
/**/                  {{0x415137c7, 0x3fefed0b} },
/**/                  {{0x674f41a2, 0x3fefeceb} },
/**/                  {{0x8d8cd945, 0x3fefeccb} },
/**/                  {{0xb409fdf3, 0x3fefecab} },
/**/                  {{0xdac6aeed, 0x3fefec8b} },
/**/                  {{0x01c2eb76, 0x3fefec6c} },
/**/                  {{0x28feb2ce, 0x3fefec4c} },
/**/                  {{0x507a0437, 0x3fefec2c} },
/**/                  {{0x7834def5, 0x3fefec0c} },
/**/                  {{0xa02f4247, 0x3fefebec} },
/**/                  {{0xc8692d71, 0x3fefebcc} },
/**/                  {{0xf0e29fb4, 0x3fefebac} },
/**/                  {{0x199b9852, 0x3fefeb8d} },
/**/                  {{0x4294168d, 0x3fefeb6d} },
/**/                  {{0x6bcc19a7, 0x3fefeb4d} },
/**/                  {{0x9543a0e2, 0x3fefeb2d} },
/**/                  {{0xbefaab7f, 0x3fefeb0d} },
/**/                  {{0xe8f138c2, 0x3fefeaed} },
/**/                  {{0x132747ea, 0x3fefeace} },
/**/                  {{0x3d9cd83c, 0x3fefeaae} },
/**/                  {{0x6851e8f7, 0x3fefea8e} },
/**/                  {{0x93467960, 0x3fefea6e} },
/**/                  {{0xbe7a88b7, 0x3fefea4e} },
/**/                  {{0xe9ee163f, 0x3fefea2e} },
/**/                  {{0x15a12139, 0x3fefea0f} },
/**/                  {{0x4193a8e8, 0x3fefe9ef} },
/**/                  {{0x6dc5ac8e, 0x3fefe9cf} },
/**/                  {{0x9a372b6d, 0x3fefe9af} },
/**/                  {{0xc6e824c6, 0x3fefe98f} },
/**/                  {{0xf3d897dd, 0x3fefe96f} },
  };

  static const number
       Lu[182][2] = {                               /* log(ui) */
/**/                 {{{0x0b3aac49, 0xbfd63003} },
/**/                  {{0xe51fff99, 0xbc6dc18c} },},
/**/                 {{{0xdf595f30, 0xbfd5d5bd} },
/**/                  {{0x48cbb8a2, 0x3c765411} },},
/**/                 {{{0x53c8d1fb, 0xbfd57bf7} },
/**/                  {{0x15f88b63, 0x3c60908d} },},
/**/                 {{{0x0738a3d8, 0xbfd522ae} },
/**/                  {{0xb38a6979, 0x3c68f7e9} },},
/**/                 {{{0x9e172c3c, 0xbfd4c9e0} },
/**/                  {{0x5b147a5d, 0x3c512361} },},
/**/                 {{{0xc271c41b, 0xbfd4718d} },
/**/                  {{0x14c56eef, 0xbc38fb4c} },},
/**/                 {{{0x23d5e8c7, 0xbfd419b4} },
/**/                  {{0x43827392, 0xbc60dbb2} },},
/**/                 {{{0x77333184, 0xbfd3c252} },
/**/                  {{0xe50a8ec6, 0x3c72ad27} },},
/**/                 {{{0x76be1117, 0xbfd36b67} },
/**/                  {{0xe883858e, 0x3c5324f0} },},
/**/                 {{{0xe1d35ce4, 0xbfd314f1} },
/**/                  {{0x09e5c3dc, 0x3c73d699} },},
/**/                 {{{0x7cdc9354, 0xbfd2bef0} },
/**/                  {{0x7fd86088, 0x3c782dad} },},
/**/                 {{{0x1134db92, 0xbfd26962} },
/**/                  {{0xdd9db02b, 0xbc7e0efa} },},
/**/                 {{{0x6d0eb8d4, 0xbfd21445} },
/**/                  {{0x1aeba60a, 0xbc6f7ae9} },},
/**/                 {{{0x635a6b95, 0xbfd1bf99} },
/**/                  {{0x84249223, 0x3c612aeb} },},
/**/                 {{{0xcbacfb73, 0xbfd16b5c} },
/**/                  {{0x28b40935, 0xbc766fbd} },},
/**/                 {{{0x8227e47c, 0xbfd1178e} },
/**/                  {{0x5f01c691, 0x3c60e63a} },},
/**/                 {{{0x676162e3, 0xbfd0c42d} },
/**/                  {{0x9d5d11ee, 0xbc5162c7} },},
/**/                 {{{0x604d5862, 0xbfd07138} },
/**/                  {{0xed4e9138, 0xbc7cdb16} },},
/**/                 {{{0x5626c691, 0xbfd01eae} },
/**/                  {{0xbd2932e2, 0x3c418290} },},
/**/                 {{{0x6cb3b379, 0xbfcf991c} },
/**/                  {{0x66f980a2, 0xbc6f6650} },},
/**/                 {{{0xe4dcffe6, 0xbfcef5ad} },
/**/                  {{0xddc708a0, 0x3c508ab2} },},
/**/                 {{{0xffe71012, 0xbfce530e} },
/**/                  {{0x41f43042, 0xbc422760} },},
/**/                 {{{0xb0d48940, 0xbfcdb13d} },
/**/                  {{0x49f96cb9, 0xbc5aa11d} },},
/**/                 {{{0xf2655e7b, 0xbfcd1037} },
/**/                  {{0x242471a2, 0xbc660629} },},
/**/                 {{{0xc6f00f71, 0xbfcc6ffb} },
/**/                  {{0x2c57a4a5, 0x3c68e58b} },},
/**/                 {{{0x383bd8ad, 0xbfcbd087} },
/**/                  {{0xf6a516d7, 0xbc3dd355} },},
/**/                 {{{0x575bce3d, 0xbfcb31d8} },
/**/                  {{0xb386a94d, 0x3c66353a} },},
/**/                 {{{0x3c8ad9e3, 0xbfca93ed} },
/**/                  {{0x9de97203, 0xbc6bcafa} },},
/**/                 {{{0x07089664, 0xbfc9f6c4} },
/**/                  {{0x605e67ef, 0xbc435a19} },},
/**/                 {{{0xdcf7017f, 0xbfc95a5a} },
/**/                  {{0x07fb7a3d, 0xbc5142c5} },},
/**/                 {{{0xeb38fe8c, 0xbfc8beaf} },
/**/                  {{0xb6997a40, 0xbc555aa8} },},
/**/                 {{{0x6551a3c2, 0xbfc823c1} },
/**/                  {{0xe70be781, 0x3c61232c} },},
/**/                 {{{0x85444c73, 0xbfc7898d} },
/**/                  {{0xebcfb201, 0xbc5ef8f6} },},
/**/                 {{{0x8b756abc, 0xbfc6f012} },
/**/                  {{0xc21e166c, 0x3c68de59} },},
/**/                 {{{0xbe8c133a, 0xbfc6574e} },
/**/                  {{0xf4621bed, 0x3c3d34f0} },},
/**/                 {{{0x6b543db2, 0xbfc5bf40} },
/**/                  {{0x4c0df7e7, 0x3c21f5b4} },},
/**/                 {{{0xe4a1b58d, 0xbfc527e5} },
/**/                  {{0x82395bfd, 0x3c271a96} },},
/**/                 {{{0x8333b561, 0xbfc4913d} },
/**/                  {{0x4930f135, 0x3c50d560} },},
/**/                 {{{0xa59928cc, 0xbfc3fb45} },
/**/                  {{0xa354d056, 0x3c6d87e6} },},
/**/                 {{{0xb0159016, 0xbfc365fc} },
/**/                  {{0xa5b944ad, 0xbc57d411} },},
/**/                 {{{0x0c86813a, 0xbfc2d161} },
/**/                  {{0xf25af95f, 0x3c5499a3} },},
/**/                 {{{0x2a49c202, 0xbfc23d71} },
/**/                  {{0x61051d69, 0x3c66e381} },},
/**/                 {{{0x7e23f72a, 0xbfc1aa2b} },
/**/                  {{0xd9b2ef7e, 0x3c4c6ef1} },},
/**/                 {{{0x8227e47c, 0xbfc1178e} },
/**/                  {{0x5f01c691, 0x3c50e63a} },},
/**/                 {{{0xb59e3a07, 0xbfc08598} },
/**/                  {{0x9902bf32, 0x3c6dd700} },},
/**/                 {{{0x39dbd566, 0xbfbfe891} },
/**/                  {{0x215f9393, 0x3c5ac9f4} },},
/**/                 {{{0x830a1120, 0xbfbec739} },
/**/                  {{0x91780d3f, 0x3c4a2bf9} },},
/**/                 {{{0x638446a2, 0xbfbda727} },
/**/                  {{0x71733019, 0xbc5401fa} },},
/**/                 {{{0x01bc4b23, 0xbfbc8858} },
/**/                  {{0x559a6706, 0xbc5a38cb} },},
/**/                 {{{0x8dad5b1c, 0xbfbb6ac8} },
/**/                  {{0xed1ca59f, 0x3c40057e} },},
/**/                 {{{0x40b1bc38, 0xbfba4e76} },
/**/                  {{0x203e4259, 0x3c55b5ca} },},
/**/                 {{{0x5d594989, 0xbfb9335e} },
/**/                  {{0x5704ccb7, 0x3c5478a8} },},
/**/                 {{{0x2f40e3f0, 0xbfb8197e} },
/**/                  {{0xffbeed43, 0xbc3b9f2d} },},
/**/                 {{{0x0aeac0e1, 0xbfb700d3} },
/**/                  {{0x212cdd05, 0x3c272566} },},
/**/                 {{{0x4d9791cb, 0xbfb5e95a} },
/**/                  {{0x5c5c450a, 0xbc5f3874} },},
/**/                 {{{0x5d207eac, 0xbfb4d311} },
/**/                  {{0x2c7842cc, 0xbc5769f4} },},
/**/                 {{{0xa7d1ee64, 0xbfb3bdf5} },
/**/                  {{0xd3b5b45f, 0xbc47a976} },},
/**/                 {{{0xa44717a5, 0xbfb2aa04} },
/**/                  {{0x8d2fa3f7, 0x3c5d15d3} },},
/**/                 {{{0xd1465567, 0xbfb1973b} },
/**/                  {{0x67a6acf6, 0x3c475583} },},
/**/                 {{{0xb59e3a07, 0xbfb08598} },
/**/                  {{0x9902bf32, 0x3c5dd700} },},
/**/                 {{{0xc006b87c, 0xbfaeea31} },
/**/                  {{0x93b7b66c, 0x3c43e4fc} },},
/**/                 {{{0xcdddb2cc, 0xbfaccb73} },
/**/                  {{0x0500efd4, 0x3c4e48fb} },},
/**/                 {{{0xd0fb10fc, 0xbfaaaef2} },
/**/                  {{0xb42e0add, 0xbc2a353b} },},
/**/                 {{{0x149fb343, 0xbfa894aa} },
/**/                  {{0x7660a23d, 0xbc3a8be9} },},
/**/                 {{{0xf2d4bb58, 0xbfa67c94} },
/**/                  {{0x6505e603, 0xbc40413e} },},
/**/                 {{{0xd42de3ea, 0xbfa466ae} },
/**/                  {{0x7f4a137e, 0x3c4cdd6f} },},
/**/                 {{{0x2f8d183f, 0xbfa252f3} },
/**/                  {{0x92615916, 0x3c4947f7} },},
/**/                 {{{0x89e74444, 0xbfa0415d} },
/**/                  {{0x1d753622, 0xbc4c05cf} },},
/**/                 {{{0xec14aaf2, 0xbf9c63d2} },
/**/                  {{0xa686bd86, 0x3c3ce030} },},
/**/                 {{{0x28c8cabf, 0xbf984925} },
/**/                  {{0x0619fa67, 0x3c3d192d} },},
/**/                 {{{0x25980cc1, 0xbf9432a9} },
/**/                  {{0x39004192, 0x3c38cdaf} },},
/**/                 {{{0x58935847, 0xbf902056} },
/**/                  {{0x8416e71f, 0xbc327c8e} },},
/**/                 {{{0xa388a2aa, 0xbf882448} },
/**/                  {{0x137f09a0, 0xbc104b16} },},
/**/                 {{{0x7588de71, 0xbf801015} },
/**/                  {{0xd417ced0, 0xbc146662} },},
/**/                 {{{0x59588b35, 0xbf700805} },
/**/                  {{0x8cf63677, 0xbc1f9663} },},
/**/                 {{{0x00000000, 0x00000000} },
/**/                  {{0x00000000, 0x00000000} },},
/**/                 {{{0xa2b10bc0, 0x3f6ff00a} },
/**/                  {{0xd5a6d353, 0x3c02821a} },},
/**/                 {{{0x6b106789, 0x3f7fe02a} },
/**/                  {{0xe3711ebf, 0xbbce44b7} },},
/**/                 {{{0x5f810a77, 0x3f87dc47} },
/**/                  {{0x87d3df21, 0xbc116d76} },},
/**/                 {{{0xb0fc03e4, 0x3f8fc0a8} },
/**/                  {{0xc59642a1, 0xbc183092} },},
/**/                 {{{0x4346a575, 0x3f93cea4} },
/**/                  {{0x902b3a1c, 0xbc10cb5a} },},
/**/                 {{{0x07d5b11b, 0x3f97b91b} },
/**/                  {{0xace3a510, 0xbc35b602} },},
/**/                 {{{0x27af9198, 0x3f9b9fc0} },
/**/                  {{0x229dc868, 0xbbf0ae69} },},
/**/                 {{{0x0e783300, 0x3f9f829b} },
/**/                  {{0x04f1ef23, 0x3c333e3f} },},
/**/                 {{{0x8923d980, 0x3fa1b0d9} },
/**/                  {{0x89bac481, 0xbc3e9ae8} },},
/**/                 {{{0xb9febd60, 0x3fa39e87} },
/**/                  {{0x37f551bb, 0xbc45bfa9} },},
/**/                 {{{0xafc8e4d5, 0x3fa58a5b} },
/**/                  {{0x2b4e2b72, 0xbc4ce55c} },},
/**/                 {{{0xf632dcfc, 0x3fa77458} },
/**/                  {{0xa87b9296, 0x3c418d3c} },},
/**/                 {{{0x0ec8e3eb, 0x3fa95c83} },
/**/                  {{0x80520bf2, 0x3c4f5a0e} },},
/**/                 {{{0x711971bf, 0x3fab42dd} },
/**/                  {{0x9c130499, 0xbc3eb975} },},
/**/                 {{{0x8adb0b52, 0x3fad276b} },
/**/                  {{0x3257fd47, 0x3c21e3c5} },},
/**/                 {{{0xc01162a6, 0x3faf0a30} },
/**/                  {{0x5c5bbacd, 0x3c485f32} },},
/**/                 {{{0x3598e471, 0x3fb07598} },
/**/                  {{0x333c45b8, 0x3c480da5} },},
/**/                 {{{0xeea37ae1, 0x3fb16536} },
/**/                  {{0xe8c22cda, 0xbc379da3} },},
/**/                 {{{0x2f0a1417, 0x3fb253f6} },
/**/                  {{0x63fc4cfd, 0xbc1c1259} },},
/**/                 {{{0x961bd1d1, 0x3fb341d7} },
/**/                  {{0x227becbb, 0xbc5b599f} },},
/**/                 {{{0xbea646f0, 0x3fb42edc} },
/**/                  {{0x935996c9, 0x3c4ddd4f} },},
/**/                 {{{0x3f06183f, 0x3fb51b07} },
/**/                  {{0x9a1a8be4, 0x3c5a49e3} },},
/**/                 {{{0xa93750c4, 0x3fb60658} },
/**/                  {{0x8ec21b6a, 0xbc538845} },},
/**/                 {{{0x8ae56b4c, 0x3fb6f0d2} },
/**/                  {{0x9184b992, 0xbc5906d9} },},
/**/                 {{{0x6d7b12cd, 0x3fb7da76} },
/**/                  {{0xcdd94131, 0xbc5eeedf} },},
/**/                 {{{0xd6319b21, 0x3fb8c345} },
/**/                  {{0xab3424a9, 0xbc24a697} },},
/**/                 {{{0x462033ad, 0x3fb9ab42} },
/**/                  {{0x1c184e8e, 0xbc42099e} },},
/**/                 {{{0x3a4ad563, 0x3fba926d} },
/**/                  {{0x8aa70ea9, 0x3c5942f4} },},
/**/                 {{{0x2bb0eda1, 0x3fbb78c8} },
/**/                  {{0xf0327e21, 0x3c20878c} },},
/**/                 {{{0x8f5bc743, 0x3fbc5e54} },
/**/                  {{0xef8161b1, 0x3c35d617} },},
/**/                 {{{0xd66cb35d, 0x3fbd4313} },
/**/                  {{0x951d90fa, 0x3c5790dd} },},
/**/                 {{{0x6e2af2e6, 0x3fbe2707} },
/**/                  {{0x001e0162, 0xbc361578} },},
/**/                 {{{0xc01162a6, 0x3fbf0a30} },
/**/                  {{0x5c5bbacd, 0x3c585f32} },},
/**/                 {{{0x31dbeabb, 0x3fbfec91} },
/**/                  {{0x9981b36c, 0xbc55746b} },},
/**/                 {{{0x12ca596e, 0x3fc06715} },
/**/                  {{0x7eb86499, 0x3c550c64} },},
/**/                 {{{0x7cd08e59, 0x3fc0d77e} },
/**/                  {{0x5e9030ac, 0x3c69a5dc} },},
/**/                 {{{0x846742ac, 0x3fc14785} },
/**/                  {{0x3e3a7f07, 0x3c6a2881} },},
/**/                 {{{0xd52f67a0, 0x3fc1b72a} },
/**/                  {{0x3472cd74, 0x3c548302} },},
/**/                 {{{0x190a5acb, 0x3fc2266f} },
/**/                  {{0xf1809e88, 0x3c6f547b} },},
/**/                 {{{0xf81ff523, 0x3fc29552} },
/**/                  {{0x1c407dbf, 0x3c630177} },},
/**/                 {{{0x18e47fd3, 0x3fc303d7} },
/**/                  {{0xd96091fa, 0xbc06b9c7} },},
/**/                 {{{0x201e8f74, 0x3fc371fc} },
/**/                  {{0x62af18a0, 0x3c5de6cb} },},
/**/                 {{{0xb0ecc62a, 0x3fc3dfc2} },
/**/                  {{0xe7d81017, 0xbc5ab3a8} },},
/**/                 {{{0x6ccb7d1e, 0x3fc44d2b} },
/**/                  {{0x543e1f88, 0x3c69f4f6} },},
/**/                 {{{0xf39a55e5, 0x3fc4ba36} },
/**/                  {{0xbcc36756, 0x3c668981} },},
/**/                 {{{0xe3a1b438, 0x3fc526e5} },
/**/                  {{0x8a470d3a, 0xbc6746ff} },},
/**/                 {{{0xd9982086, 0x3fc59338} },
/**/                  {{0xaa8ad7cf, 0xbc565d22} },},
/**/                 {{{0x70a793d4, 0x3fc5ff30} },
/**/                  {{0xfafc6f6e, 0xbc5bc60e} },},
/**/                 {{{0x4272ad51, 0x3fc66acd} },
/**/                  {{0x4e1ea8b2, 0xbc50900e} },},
/**/                 {{{0xe719d21d, 0x3fc6d60f} },
/**/                  {{0x68ecd179, 0xbc6caae2} },},
/**/                 {{{0xf54037a5, 0x3fc740f8} },
/**/                  {{0x62a84cdb, 0xbc5b2640} },},
/**/                 {{{0x0210d909, 0x3fc7ab89} },
/**/                  {{0x2d6a0608, 0x3c4be36b} },},
/**/                 {{{0xa14357eb, 0x3fc815c0} },
/**/                  {{0x073a0564, 0xbc54be48} },},
/**/                 {{{0x6520c911, 0x3fc87fa0} },
/**/                  {{0xbfa08d9a, 0xbc6bf7fd} },},
/**/                 {{{0xde886d41, 0x3fc8e928} },
/**/                  {{0x51a56770, 0xbc6569d8} },},
/**/                 {{{0x9cf456b4, 0x3fc9525a} },
/**/                  {{0x1d4e2e26, 0x3c6d904c} },},
/**/                 {{{0x2e7dfb83, 0x3fc9bb36} },
/**/                  {{0x1f003e0c, 0x3c6575e3} },},
/**/                 {{{0x1fe2b563, 0x3fca23bc} },
/**/                  {{0xb07a998c, 0x3c493711} },},
/**/                 {{{0xfc882f19, 0x3fca8bec} },
/**/                  {{0x918c39eb, 0xbc5e8c37} },},
/**/                 {{{0x4e80bff3, 0x3fcaf3c9} },
/**/                  {{0xf3641985, 0xbc5398cf} },},
/**/                 {{{0x9e8fb5a4, 0x3fcb5b51} },
/**/                  {{0xdc19e1a0, 0x3c6ba27f} },},
/**/                 {{{0x742d8cd6, 0x3fcbc286} },
/**/                  {{0x44870f55, 0x3c54fce7} },},
/**/                 {{{0x558c18c1, 0x3fcc2968} },
/**/                  {{0x38a3fb6b, 0xbc673dee} },},
/**/                 {{{0xc79a9a22, 0x3fcc8ff7} },
/**/                  {{0xf8434012, 0xbc64f689} },},
/**/                 {{{0x4e09c5dc, 0x3fccf635} },
/**/                  {{0x7d55b695, 0x3c6239a0} },},
/**/                 {{{0x6b4fbb91, 0x3fcd5c21} },
/**/                  {{0x597e4d40, 0x3c66e443} },},
/**/                 {{{0xa0abec7d, 0x3fcdc1bc} },
/**/                  {{0x1998b6fc, 0x3c6834c5} },},
/**/                 {{{0x6e2af2e6, 0x3fce2707} },
/**/                  {{0x001e0162, 0xbc461578} },},
/**/                 {{{0x52aa5a60, 0x3fce8c02} },
/**/                  {{0x39bfc89b, 0xbc46e03a} },},
/**/                 {{{0xcbdc5936, 0x3fcef0ad} },
/**/                  {{0x950dc20d, 0x3c648637} },},
/**/                 {{{0x564b7b37, 0x3fcf550a} },
/**/                  {{0xfd018c37, 0x3c2c5f6d} },},
/**/                 {{{0x6d5e3e2b, 0x3fcfb918} },
/**/                  {{0x64f21acb, 0xbc6caaae} },},
/**/                 {{{0x45ad501d, 0x3fd00e6c} },
/**/                  {{0x8ff6fead, 0xbc6cb956} },},
/**/                 {{{0x94b4d041, 0x3fd04025} },
/**/                  {{0x17a5022d, 0xbc628ec2} },},
/**/                 {{{0x5fcd590d, 0x3fd071b8} },
/**/                  {{0xf97bde80, 0x3c5d1707} },},
/**/                 {{{0xe27390e3, 0x3fd0a324} },
/**/                  {{0xe8061c03, 0x3c77dcfd} },},
/**/                 {{{0x579ab74b, 0x3fd0d46b} },
/**/                  {{0x1c3cbd92, 0x3c603ec8} },},
/**/                 {{{0xf9ae4ad5, 0x3fd1058b} },
/**/                  {{0xab4cb31d, 0x3c589fa0} },},
/**/                 {{{0x0293a8b0, 0x3fd13687} },
/**/                  {{0x98edd24a, 0x3c77b662} },},
/**/                 {{{0xababa60e, 0x3fd1675c} },
/**/                  {{0xab883717, 0x3c2ce63e} },},
/**/                 {{{0x2dd4236f, 0x3fd1980d} },
/**/                  {{0xb0e4d147, 0x3c79d3d1} },},
/**/                 {{{0xc16999fb, 0x3fd1c898} },
/**/                  {{0x2aff1c44, 0xbc30e5c6} },},
/**/                 {{{0x9e48a2f3, 0x3fd1f8ff} },
/**/                  {{0x9a0c4b07, 0xbc7c9fdf} },},
/**/                 {{{0xfbcf7966, 0x3fd22941} },
/**/                  {{0xb09628af, 0xbc776f5e} },},
/**/                 {{{0x10df763a, 0x3fd25960} },
/**/                  {{0x57075e9e, 0xbc50f76c} },},
/**/                 {{{0x13de86a3, 0x3fd2895a} },
/**/                  {{0xc13f040e, 0x3c77ad24} },},
/**/                 {{{0x3ab89d25, 0x3fd2b930} },
/**/                  {{0xfd852ad4, 0xbc7896b5} },},
/**/                 {{{0xbae11d31, 0x3fd2e8e2} },
/**/                  {{0xb95ebdf9, 0xbc78f4cd} },},
/**/                 {{{0xc9544185, 0x3fd31871} },
/**/                  {{0x4c09b379, 0xbc351acc} },},
/**/                 {{{0x9a987d55, 0x3fd347dd} },
/**/                  {{0x580919f8, 0xbc64dd4c} },},
/**/                 {{{0x62bfd85b, 0x3fd37726} },
/**/                  {{0xd8117de7, 0xbc4b5629} },},
/**/                 {{{0x556945ea, 0x3fd3a64c} },
/**/                  {{0x1945f97c, 0xbc6c6865} },},
/**/                 {{{0xa5c1f710, 0x3fd3d54f} },
/**/                  {{0xc6a1c98d, 0xbc7e3265} },},
/**/                 {{{0x8686a7e4, 0x3fd40430} },
/**/                  {{0x6082ce6d, 0xbc70bcfb} },},
/**/                 {{{0x2a04e814, 0x3fd432ef} },
/**/                  {{0x715ac903, 0xbc729931} },},
/**/                 {{{0xc21c5ec2, 0x3fd4618b} },
/**/                  {{0xcdeccf1d, 0x3c7f42de} },},
/**/                 {{{0x804009d1, 0x3fd49006} },
/**/                  {{0x41f177dc, 0xbc69ffc3} },},
/**/                 {{{0x957778a1, 0x3fd4be5f} },
/**/                  {{0x5b04813d, 0xbc6259b3} },},
/**/                 {{{0x3260026a, 0x3fd4ec97} },
/**/                  {{0xd977dc5e, 0xbc742a87} },},
/**/                 {{{0x872df82d, 0x3fd51aad} },
/**/                  {{0xc19f55e3, 0x3c43927a} },},
/**/                 {{{0xc3add263, 0x3fd548a2} },
/**/                  {{0x7e308ddb, 0xbc6819cf} },},
/**/                 {{{0x17455a6c, 0x3fd57677} },
/**/                  {{0xb283660c, 0x3c7526ad} },},
/**/                 {{{0xb0f4cfe2, 0x3fd5a42a} },
/**/                  {{0x7dee9a3d, 0xbc78ebcb} },},
/**/                 {{{0xbf5809ca, 0x3fd5d1bd} },
/**/                  {{0x83dc7fe1, 0x3c742363} },},
/**/                 {{{0x70a793d4, 0x3fd5ff30} },
/**/                  {{0xfafc6f6e, 0xbc6bc60e} },},
/**/                 {{{0xf2b9c795, 0x3fd62c82} },
/**/                  {{0x915300e5, 0x3c67b7af} },},
  };

  static const number
       Lv[362][2] = {                               /* log(vj) */

/**/                 {{{0xb72daabf, 0xbf6687ec} },
/**/                  {{0x0f13318f, 0x3c052c69} },},
/**/                 {{{0x3767104f, 0xbf6667d6} },
/**/                  {{0xd27a7bac, 0x3bd3efa3} },},
/**/                 {{{0xd7cd64fb, 0xbf6647bf} },
/**/                  {{0x55a89c36, 0x3c09b725} },},
/**/                 {{{0x9860683b, 0xbf6627a9} },
/**/                  {{0xfebc844a, 0x3bcbae22} },},
/**/                 {{{0x791fd98a, 0xbf660793} },
/**/                  {{0x78fa1cb5, 0xbbfe34af} },},
/**/                 {{{0x7a0b7863, 0xbf65e77d} },
/**/                  {{0xea78fdd0, 0xbc02f1b1} },},
/**/                 {{{0x9b230442, 0xbf65c767} },
/**/                  {{0x2202b2ca, 0x3bf70d8c} },},
/**/                 {{{0xdc663ca2, 0xbf65a751} },
/**/                  {{0xc3444e64, 0xbbfdc63d} },},
/**/                 {{{0x3dd4e102, 0xbf65873c} },
/**/                  {{0x370d69c3, 0x3c021b11} },},
/**/                 {{{0xbf6eb0de, 0xbf656726} },
/**/                  {{0x154dd8d8, 0xbbfb6da8} },},
/**/                 {{{0x61336bb6, 0xbf654711} },
/**/                  {{0xdf9a4709, 0xbc0b12d2} },},
/**/                 {{{0x2322d10a, 0xbf6526fc} },
/**/                  {{0x68d1274f, 0x3bf997f2} },},
/**/                 {{{0x053ca059, 0xbf6506e7} },
/**/                  {{0xe70c852a, 0x3c0c2a1f} },},
/**/                 {{{0x07809924, 0xbf64e6d2} },
/**/                  {{0xa808538f, 0x3c04cc9e} },},
/**/                 {{{0x29ee7aed, 0xbf64c6bd} },
/**/                  {{0x7797a4bd, 0x3befe68c} },},
/**/                 {{{0x6c860537, 0xbf64a6a8} },
/**/                  {{0x9efaae3d, 0x3c06794d} },},
/**/                 {{{0xcf46f784, 0xbf648693} },
/**/                  {{0xb2ddd9d1, 0xbbfed318} },},
/**/                 {{{0x5231115a, 0xbf64667f} },
/**/                  {{0x4643624b, 0x3c061f62} },},
/**/                 {{{0xf544123c, 0xbf64466a} },
/**/                  {{0x9387f11e, 0x3c0666a0} },},
/**/                 {{{0xb87fb9b0, 0xbf642656} },
/**/                  {{0x116ec598, 0x3c0043b2} },},
/**/                 {{{0x9be3c73c, 0xbf640642} },
/**/                  {{0xd2de6e3e, 0xbbfbd84d} },},
/**/                 {{{0x9f6ffa68, 0xbf63e62e} },
/**/                  {{0x433d8c65, 0xbbe9149b} },},
/**/                 {{{0xc32412bb, 0xbf63c61a} },
/**/                  {{0x08e5a7bb, 0xbbf6b88d} },},
/**/                 {{{0x06ffcfbe, 0xbf63a607} },
/**/                  {{0xccfac9e2, 0xbb9f3c7a} },},
/**/                 {{{0x6b02f0fa, 0xbf6385f3} },
/**/                  {{0xbec6f6e4, 0x3bee405c} },},
/**/                 {{{0xef2d35f9, 0xbf6365df} },
/**/                  {{0xaf0c0b4c, 0x3bf02993} },},
/**/                 {{{0x937e5e46, 0xbf6345cc} },
/**/                  {{0xaa64716f, 0x3bf9be97} },},
/**/                 {{{0x57f6296c, 0xbf6325b9} },
/**/                  {{0xa2e863ae, 0xbbfdeb4d} },},
/**/                 {{{0x3c9456f9, 0xbf6305a6} },
/**/                  {{0x636d2b2c, 0x3c0f3c7f} },},
/**/                 {{{0x4158a678, 0xbf62e593} },
/**/                  {{0xb166ca7f, 0x3c01a8df} },},
/**/                 {{{0x6642d778, 0xbf62c580} },
/**/                  {{0x53a2d534, 0x3c020ff1} },},
/**/                 {{{0xab52a987, 0xbf62a56d} },
/**/                  {{0x0412f1e7, 0xbbe8fef1} },},
/**/                 {{{0x1087dc35, 0xbf62855b} },
/**/                  {{0x4b7ac6c6, 0xbbfcd17e} },},
/**/                 {{{0x95e22f12, 0xbf626548} },
/**/                  {{0x9a8127bf, 0xbbfbfc21} },},
/**/                 {{{0x3b6161af, 0xbf624536} },
/**/                  {{0x66d42390, 0x3bd7eda1} },},
/**/                 {{{0x0105339d, 0xbf622524} },
/**/                  {{0x77fedcad, 0xbbdf374e} },},
/**/                 {{{0xe6cd646f, 0xbf620511} },
/**/                  {{0x52d05dea, 0x3be1d1fb} },},
/**/                 {{{0xecb9b3b8, 0xbf61e4ff} },
/**/                  {{0xffd8e706, 0x3c02c2fc} },},
/**/                 {{{0x12c9e10b, 0xbf61c4ee} },
/**/                  {{0xf1d5cc2c, 0xbc02b4f8} },},
/**/                 {{{0x58fdabfe, 0xbf61a4dc} },
/**/                  {{0x1315b191, 0xbc0618c3} },},
/**/                 {{{0xbf54d426, 0xbf6184ca} },
/**/                  {{0xcb3cdab0, 0xbc01f8d5} },},
/**/                 {{{0x45cf1919, 0xbf6164b9} },
/**/                  {{0xc025605a, 0xbc014ff7} },},
/**/                 {{{0xec6c3a6e, 0xbf6144a7} },
/**/                  {{0x87cb08cd, 0xbbff04ff} },},
/**/                 {{{0xb32bf7bd, 0xbf612496} },
/**/                  {{0xe6af1b84, 0x3bee89b4} },},
/**/                 {{{0x9a0e109e, 0xbf610485} },
/**/                  {{0x35a60879, 0x3c07e99e} },},
/**/                 {{{0xa11244aa, 0xbf60e474} },
/**/                  {{0x20f2325a, 0x3c04b698} },},
/**/                 {{{0xc838537b, 0xbf60c463} },
/**/                  {{0x3617200d, 0x3bc0657e} },},
/**/                 {{{0x0f7ffcac, 0xbf60a453} },
/**/                  {{0xa5080961, 0xbc008feb} },},
/**/                 {{{0x76e8ffd9, 0xbf608442} },
/**/                  {{0xbb5e1df7, 0x3bd13002} },},
/**/                 {{{0xfe731c9d, 0xbf606431} },
/**/                  {{0x6e2858c0, 0xbc0509f3} },},
/**/                 {{{0xa61e1296, 0xbf604421} },
/**/                  {{0x5f5d9695, 0xbc04b556} },},
/**/                 {{{0x6de9a162, 0xbf602411} },
/**/                  {{0xe79a4e00, 0x3c042b89} },},
/**/                 {{{0x55d5889e, 0xbf600401} },
/**/                  {{0x1113f403, 0x3be8f98e} },},
/**/                 {{{0xbbc30fd4, 0xbf5fc7e2} },
/**/                  {{0x93382bc9, 0xbbfc709b} },},
/**/                 {{{0x0c1abdcd, 0xbf5f87c3} },
/**/                  {{0x76a55d1c, 0xbbf2a90d} },},
/**/                 {{{0x9cb19a68, 0xbf5f47a3} },
/**/                  {{0x76e7826b, 0x3be1b815} },},
/**/                 {{{0x6d8724e7, 0xbf5f0784} },
/**/                  {{0x2b63756d, 0xbbe72d46} },},
/**/                 {{{0x7e9adc90, 0xbf5ec765} },
/**/                  {{0x73bb17c5, 0x3beb1a66} },},
/**/                 {{{0xcfec40a8, 0xbf5e8746} },
/**/                  {{0xb5e5a553, 0x3bf11af5} },},
/**/                 {{{0x617ad077, 0xbf5e4728} },
/**/                  {{0xf57dd14f, 0x3bfb2cad} },},
/**/                 {{{0x33460b45, 0xbf5e070a} },
/**/                  {{0x4902c8d5, 0xbbf8db75} },},
/**/                 {{{0x454d705f, 0xbf5dc6ec} },
/**/                  {{0xe8a41057, 0x3bef5cc6} },},
/**/                 {{{0x97907f0f, 0xbf5d86ce} },
/**/                  {{0xdf8672ef, 0x3bed8277} },},
/**/                 {{{0x2a0eb6a3, 0xbf5d46b1} },
/**/                  {{0x3717e5ee, 0xbbc2f9c2} },},
/**/                 {{{0xfcc7966b, 0xbf5d0693} },
/**/                  {{0xab4852c6, 0x3bf4deed} },},
/**/                 {{{0x0fba9db6, 0xbf5cc677} },
/**/                  {{0x9db2a368, 0xbbf3a2b4} },},
/**/                 {{{0x62e74bd8, 0xbf5c865a} },
/**/                  {{0x58fa0c24, 0xbbd2c51d} },},
/**/                 {{{0xf64d2024, 0xbf5c463d} },
/**/                  {{0xe3a09391, 0x3bf838ca} },},
/**/                 {{{0xc9eb99ee, 0xbf5c0621} },
/**/                  {{0x61b7de71, 0xbbdc2a9e} },},
/**/                 {{{0xddc2388e, 0xbf5bc605} },
/**/                  {{0x4accb195, 0xbbea9808} },},
/**/                 {{{0x31d07b5c, 0xbf5b85ea} },
/**/                  {{0x032e030b, 0xbbd811a2} },},
/**/                 {{{0xc615e1b1, 0xbf5b45ce} },
/**/                  {{0x821e0b81, 0xbbfd5427} },},
/**/                 {{{0x9a91eaea, 0xbf5b05b3} },
/**/                  {{0x2619306b, 0x3bfffeba} },},
/**/                 {{{0xaf441661, 0xbf5ac598} },
/**/                  {{0x9eac7d15, 0x3bd22824} },},
/**/                 {{{0x042be376, 0xbf5a857e} },
/**/                  {{0x24893f0e, 0x3bc20736} },},
/**/                 {{{0x9948d188, 0xbf5a4563} },
/**/                  {{0x04d734cd, 0xbbf58ab4} },},
/**/                 {{{0x6e9a5ff9, 0xbf5a0549} },
/**/                  {{0x5723a6c3, 0xbbf22673} },},
/**/                 {{{0x84200e2c, 0xbf59c52f} },
/**/                  {{0xa538e8e1, 0x3bfc81da} },},
/**/                 {{{0xd9d95b83, 0xbf598515} },
/**/                  {{0x2a8e3feb, 0xbbfa1a37} },},
/**/                 {{{0x6fc5c767, 0xbf5944fc} },
/**/                  {{0x385159f9, 0x3bf8e1ce} },},
/**/                 {{{0x45e4d13c, 0xbf5904e3} },
/**/                  {{0x1567c7a7, 0xbbfc4737} },},
/**/                 {{{0x5c35f86e, 0xbf58c4ca} },
/**/                  {{0x23c9ae0c, 0x3bf41581} },},
/**/                 {{{0xb2b8bc65, 0xbf5884b1} },
/**/                  {{0x2b66cfb6, 0x3bf70c2c} },},
/**/                 {{{0x496c9c8d, 0xbf584499} },
/**/                  {{0xe5a11e3e, 0xbbdb9042} },},
/**/                 {{{0x20511854, 0xbf580481} },
/**/                  {{0x61bcb040, 0xbbf9cf9d} },},
/**/                 {{{0x3765af29, 0xbf57c469} },
/**/                  {{0xe26a419b, 0xbbf65ceb} },},
/**/                 {{{0x8ea9e07c, 0xbf578451} },
/**/                  {{0xb70a4088, 0xbbf1c2f5} },},
/**/                 {{{0x261d2bbf, 0xbf57443a} },
/**/                  {{0x29704ba7, 0xbbbc7b8f} },},
/**/                 {{{0xfdbf1065, 0xbf570422} },
/**/                  {{0x433ccb3b, 0x3bca0a54} },},
/**/                 {{{0x158f0de3, 0xbf56c40c} },
/**/                  {{0x207cde2d, 0x3bd9e257} },},
/**/                 {{{0x6d8ca3af, 0xbf5683f5} },
/**/                  {{0xf7b51b49, 0xbbef17a4} },},
/**/                 {{{0x05b75142, 0xbf5643df} },
/**/                  {{0x9d345bf8, 0x3be28239} },},
/**/                 {{{0xde0e9614, 0xbf5603c8} },
/**/                  {{0x0918d1bf, 0xbbde6c21} },},
/**/                 {{{0xf691f1a1, 0xbf55c3b2} },
/**/                  {{0x377de4c8, 0x3bd37d78} },},
/**/                 {{{0x4f40e365, 0xbf55839d} },
/**/                  {{0xbbf7c9d1, 0x3bf52b7d} },},
/**/                 {{{0xe81aeadd, 0xbf554387} },
/**/                  {{0x679c3d9a, 0xbbf0be6a} },},
/**/                 {{{0xc11f878a, 0xbf550372} },
/**/                  {{0xb6cdd88e, 0xbbdd9e20} },},
/**/                 {{{0xda4e38ec, 0xbf54c35d} },
/**/                  {{0x09302da0, 0xbbe3b1e7} },},
/**/                 {{{0x33a67e86, 0xbf548349} },
/**/                  {{0x085b922d, 0x3be8cba8} },},
/**/                 {{{0xcd27d7db, 0xbf544334} },
/**/                  {{0xf024ab43, 0xbba5f2c9} },},
/**/                 {{{0xa6d1c471, 0xbf540320} },
/**/                  {{0xf686cf3d, 0xbbeb31f3} },},
/**/                 {{{0xc0a3c3cf, 0xbf53c30c} },
/**/                  {{0xd4ad32f6, 0xbbf74ffe} },},
/**/                 {{{0x1a9d557e, 0xbf5382f9} },
/**/                  {{0x4acb368f, 0x3bd2e555} },},
/**/                 {{{0xb4bdf907, 0xbf5342e5} },
/**/                  {{0x07812806, 0x3be13442} },},
/**/                 {{{0x8f052df6, 0xbf5302d2} },
/**/                  {{0x70b1e756, 0x3bf5f429} },},
/**/                 {{{0xa97273d7, 0xbf52c2bf} },
/**/                  {{0x43a03fff, 0xbbf20aa3} },},
/**/                 {{{0x04054a3a, 0xbf5282ad} },
/**/                  {{0x8bebd7ad, 0xbbed4d57} },},
/**/                 {{{0x9ebd30ae, 0xbf52429a} },
/**/                  {{0x5a71c5a4, 0xbbff9529} },},
/**/                 {{{0x7999a6c6, 0xbf520288} },
/**/                  {{0x54100f9e, 0x3bfb055a} },},
/**/                 {{{0x949a2c12, 0xbf51c276} },
/**/                  {{0xa2e9f1b4, 0xbbff6978} },},
/**/                 {{{0xefbe402a, 0xbf518264} },
/**/                  {{0xbc188323, 0x3bf01fb9} },},
/**/                 {{{0x8b0562a1, 0xbf514253} },
/**/                  {{0x957bf23a, 0xbbf7c87c} },},
/**/                 {{{0x666f1311, 0xbf510242} },
/**/                  {{0xc8be6880, 0x3bdc2cb9} },},
/**/                 {{{0x81fad111, 0xbf50c231} },
/**/                  {{0x07ba000d, 0xbbf59fc1} },},
/**/                 {{{0xdda81c3d, 0xbf508220} },
/**/                  {{0xbf5c8a0b, 0xbbf06a0a} },},
/**/                 {{{0x79767431, 0xbf504210} },
/**/                  {{0xa9a705bc, 0x3bf3a6cf} },},
/**/                 {{{0x55655889, 0xbf500200} },
/**/                  {{0xbf0fa436, 0xbbe9abe6} },},
/**/                 {{{0xe2e891cc, 0xbf4f83e0} },
/**/                  {{0x1b81bf62, 0x3be4aa59} },},
/**/                 {{{0x9b4589ce, 0xbf4f03c1} },
/**/                  {{0x8a47f50a, 0xbbe60518} },},
/**/                 {{{0xd3e0985f, 0xbf4e83a2} },
/**/                  {{0x5ef17e96, 0x3bed32d8} },},
/**/                 {{{0x8cb8bcc3, 0xbf4e0384} },
/**/                  {{0xf09afa4d, 0xbbeb7b30} },},
/**/                 {{{0xc5ccf647, 0xbf4d8366} },
/**/                  {{0xf586cec2, 0xbbd527fc} },},
/**/                 {{{0x7f1c4437, 0xbf4d0349} },
/**/                  {{0x4a686886, 0x3bc2bcf0} },},
/**/                 {{{0xb8a5a5e3, 0xbf4c832c} },
/**/                  {{0x721c2ebe, 0x3bc98f93} },},
/**/                 {{{0x72681a9e, 0xbf4c0310} },
/**/                  {{0xb5308d22, 0xbbe20f00} },},
/**/                 {{{0xac62a1bf, 0xbf4b82f4} },
/**/                  {{0x9737b561, 0xbbe1edd0} },},
/**/                 {{{0x66943a9f, 0xbf4b02d9} },
/**/                  {{0x23f894a1, 0xbbcc950b} },},
/**/                 {{{0xa0fbe49a, 0xbf4a82be} },
/**/                  {{0x866bc982, 0xbb81da04} },},
/**/                 {{{0x5b989f0f, 0xbf4a02a4} },
/**/                  {{0x9d76196e, 0xbbd9114d} },},
/**/                 {{{0x96696961, 0xbf49828a} },
/**/                  {{0xd3292fd6, 0x3bc10d20} },},
/**/                 {{{0x516d42f4, 0xbf490271} },
/**/                  {{0x2e9a5dd5, 0xbbee53a3} },},
/**/                 {{{0x8ca32b32, 0xbf488258} },
/**/                  {{0xd18f8004, 0xbbc55af5} },},
/**/                 {{{0x480a2185, 0xbf480240} },
/**/                  {{0xa9b0178a, 0xbbb32d23} },},
/**/                 {{{0x83a1255c, 0xbf478228} },
/**/                  {{0x8152093a, 0x3be84cc3} },},
/**/                 {{{0x3f673627, 0xbf470211} },
/**/                  {{0xf4881c71, 0xbbd0055a} },},
/**/                 {{{0x7b5b535c, 0xbf4681fa} },
/**/                  {{0xb98336ea, 0x3bd2b73f} },},
/**/                 {{{0x377c7c71, 0xbf4601e4} },
/**/                  {{0x2ed05089, 0xbbcdcbed} },},
/**/                 {{{0x73c9b0e1, 0xbf4581ce} },
/**/                  {{0x61414697, 0xbbdda0c2} },},
/**/                 {{{0x3041f02a, 0xbf4501b9} },
/**/                  {{0x22f8b33c, 0x3bee5d53} },},
/**/                 {{{0x6ce439ca, 0xbf4481a4} },
/**/                  {{0x9c25c999, 0xbbe5512f} },},
/**/                 {{{0x29af8d47, 0xbf440190} },
/**/                  {{0xa4df0dfd, 0x3b7f48c2} },},
/**/                 {{{0x66a2ea26, 0xbf43817c} },
/**/                  {{0x517febd8, 0x3bd157c0} },},
/**/                 {{{0x23bd4ff0, 0xbf430169} },
/**/                  {{0x0176d244, 0xbbe2e229} },},
/**/                 {{{0x60fdbe33, 0xbf428156} },
/**/                  {{0x175812b3, 0x3be64664} },},
/**/                 {{{0x1e63347c, 0xbf420144} },
/**/                  {{0xd9355524, 0xbbe39ab4} },},
/**/                 {{{0x5becb260, 0xbf418132} },
/**/                  {{0xb6e1edc9, 0x3be74b27} },},
/**/                 {{{0x19993772, 0xbf410121} },
/**/                  {{0x393ab56a, 0xbbaa390b} },},
/**/                 {{{0x5767c34c, 0xbf408110} },
/**/                  {{0xf8c7783b, 0x3bd128e6} },},
/**/                 {{{0x15575589, 0xbf400100} },
/**/                  {{0xf23ef222, 0x3bec8863} },},
/**/                 {{{0xa6cddb8d, 0xbf3f01e0} },
/**/                  {{0xcdd29c3f, 0x3b8a9419} },},
/**/                 {{{0x232b174e, 0xbf3e01c2} },
/**/                  {{0xd5f5b191, 0xbbc7cf55} },},
/**/                 {{{0x9fc45d9e, 0xbf3d01a4} },
/**/                  {{0xb5038e7e, 0x3bddc58f} },},
/**/                 {{{0x1c97adca, 0xbf3c0188} },
/**/                  {{0xbb933e41, 0x3bc0238d} },},
/**/                 {{{0x99a30728, 0xbf3b016c} },
/**/                  {{0xc3c43664, 0xbbabde04} },},
/**/                 {{{0x16e46913, 0xbf3a0152} },
/**/                  {{0x5adc3673, 0x3bafe081} },},
/**/                 {{{0x9459d2eb, 0xbf390138} },
/**/                  {{0xc2a33d26, 0xbbd949da} },},
/**/                 {{{0x12014418, 0xbf380120} },
/**/                  {{0xf76e0326, 0xbbd3acbc} },},
/**/                 {{{0x8fd8bc07, 0xbf370108} },
/**/                  {{0x4cd6ce34, 0x3bdbde09} },},
/**/                 {{{0x0dde3a29, 0xbf3600f2} },
/**/                  {{0x05442a35, 0xbbb0bc28} },},
/**/                 {{{0x8c0fbdf9, 0xbf3500dc} },
/**/                  {{0x0908cbf7, 0x3bd21c68} },},
/**/                 {{{0x0a6b46f4, 0xbf3400c8} },
/**/                  {{0x0f107564, 0xbbdbd35e} },},
/**/                 {{{0x88eed4a1, 0xbf3300b4} },
/**/                  {{0x49a3dcb8, 0xbbc22067} },},
/**/                 {{{0x0798668a, 0xbf3200a2} },
/**/                  {{0xe7c5d0e5, 0x3bcdb7f0} },},
/**/                 {{{0x8665fc3f, 0xbf310090} },
/**/                  {{0xc7f9d69c, 0xbbd00add} },},
/**/                 {{{0x05559559, 0xbf300080} },
/**/                  {{0xa0e20e2f, 0x3bddd332} },},
/**/                 {{{0x08ca62e5, 0xbf2e00e1} },
/**/                  {{0x3a04bb77, 0xbbb15ff9} },},
/**/                 {{{0x0725a061, 0xbf2c00c4} },
/**/                  {{0xcc052f3e, 0x3bc88ab0} },},
/**/                 {{{0x05b8e275, 0xbf2a00a9} },
/**/                  {{0xf5f3cbcf, 0xbbcbba1a} },},
/**/                 {{{0x04802882, 0xbf280090} },
/**/                  {{0xa5bd7bd0, 0x3bcec900} },},
/**/                 {{{0x037771ef, 0xbf260079} },
/**/                  {{0x9b7b54fa, 0x3bb77ea0} },},
/**/                 {{{0x029abe33, 0xbf240064} },
/**/                  {{0x3ae68d18, 0xbbc1bbf0} },},
/**/                 {{{0x01e60cd1, 0xbf220051} },
/**/                  {{0x2b45cfcd, 0x3bb1dcd9} },},
/**/                 {{{0x01555d56, 0xbf200040} },
/**/                  {{0x863f53f6, 0x3bcddd88} },},
/**/                 {{{0x01c95eb7, 0xbf1c0062} },
/**/                  {{0xaa4dfd9a, 0x3bbd88f7} },},
/**/                 {{{0x01200510, 0xbf180048} },
/**/                  {{0x4f3db50b, 0xbb984d46} },},
/**/                 {{{0x00a6ad1c, 0xbf140032} },
/**/                  {{0x28ff1135, 0x3bb2e44b} },},
/**/                 {{{0x00555655, 0xbf100020} },
/**/                  {{0xccd5f17f, 0xbbb62224} },},
/**/                 {{{0x004800a2, 0xbf080024} },
/**/                  {{0x8d690542, 0xbb484d09} },},
/**/                 {{{0x00155575, 0xbf000010} },
/**/                  {{0x37779c0a, 0xbba56222} },},
/**/                 {{{0x00055559, 0xbef00008} },
/**/                  {{0x22cccd5f, 0xbb955622} },},
/**/                 {{{0x00000000, 0x00000000} },
/**/                  {{0x00000000, 0x00000000} },},
/**/                 {{{0x000aaaa3, 0x3eeffff0} },
/**/                  {{0xbd110fec, 0xbb8553bb} },},
/**/                 {{{0x002aaa6b, 0x3effffe0} },
/**/                  {{0xe6661d42, 0xbb953bbb} },},
/**/                 {{{0x0047ff5e, 0x3f07ffdc} },
/**/                  {{0x0d69020e, 0x3b484c90} },},
/**/                 {{{0x00aaa8ab, 0x3f0fffc0} },
/**/                  {{0x10fec82c, 0xbba3bbc1} },},
/**/                 {{{0x00a6a83a, 0x3f13ffce} },
/**/                  {{0x81546808, 0xbbb2e45f} },},
/**/                 {{{0x011ffaf0, 0x3f17ffb8} },
/**/                  {{0x4f3d9b6a, 0x3b984c53} },},
/**/                 {{{0x01c94bf5, 0x3f1bff9e} },
/**/                  {{0xdaa368ee, 0xbbbd8990} },},
/**/                 {{{0x02aa9aab, 0x3f1fff80} },
/**/                  {{0x78af0afc, 0x3b910e66} },},
/**/                 {{{0x01e5f330, 0x3f21ffaf} },
/**/                  {{0x26467402, 0xbbb1df8d} },},
/**/                 {{{0x029a9723, 0x3f23ff9c} },
/**/                  {{0x303b23b1, 0x3bc1b965} },},
/**/                 {{{0x037738be, 0x3f25ff87} },
/**/                  {{0x53d3dc06, 0xbbb787a3} },},
/**/                 {{{0x047fd782, 0x3f27ff70} },
/**/                  {{0xa5c0aff0, 0xbbced098} },},
/**/                 {{{0x05b872e4, 0x3f29ff57} },
/**/                  {{0x81c30d42, 0x3bcbadd4} },},
/**/                 {{{0x07250a51, 0x3f2bff3c} },
/**/                  {{0xd6bad8c1, 0xbbc89dd6} },},
/**/                 {{{0x08c99d24, 0x3f2dff1f} },
/**/                  {{0xaede8ad0, 0x3bb12609} },},
/**/                 {{{0x0aaa2ab1, 0x3f2fff00} },
/**/                  {{0x4dc4e3dc, 0x3ba0bbc0} },},
/**/                 {{{0x8665591f, 0x3f30ff6f} },
/**/                  {{0x80357b54, 0xbbd013d3} },},
/**/                 {{{0x07979982, 0x3f31ff5e} },
/**/                  {{0x4817ebcd, 0xbbce0e70} },},
/**/                 {{{0x88edd619, 0x3f32ff4b} },
/**/                  {{0xc582abc3, 0xbbd72b9e} },},
/**/                 {{{0x0a6a0e74, 0x3f33ff38} },
/**/                  {{0xb95bc1fe, 0x3bdb81fc} },},
/**/                 {{{0x8c0e4220, 0x3f34ff23} },
/**/                  {{0x9b549aae, 0x3bcaed12} },},
/**/                 {{{0x0ddc70a1, 0x3f35ff0e} },
/**/                  {{0xd97a3c05, 0x3bacf6f3} },},
/**/                 {{{0x8fd69976, 0x3f36fef7} },
/**/                  {{0x6f810a3c, 0x3bab2dcf} },},
/**/                 {{{0x11febc18, 0x3f37fee0} },
/**/                  {{0xf5d3f323, 0x3bd2b9bc} },},
/**/                 {{{0x9456d7fb, 0x3f38fec7} },
/**/                  {{0x6eaa1d6a, 0xbbbfb258} },},
/**/                 {{{0x16e0ec8b, 0x3f39feae} },
/**/                  {{0xceeb34b1, 0xbbb6137a} },},
/**/                 {{{0x999ef930, 0x3f3afe93} },
/**/                  {{0xdc639b08, 0xbbde70e0} },},
/**/                 {{{0x1c92fd4a, 0x3f3bfe78} },
/**/                  {{0x713cc126, 0xbbc4ed10} },},
/**/                 {{{0x9fbef835, 0x3f3cfe5b} },
/**/                  {{0xcc0e81bd, 0xbb873d63} },},
/**/                 {{{0x2324e946, 0x3f3dfe3e} },
/**/                  {{0x62dd5deb, 0x3bc09164} },},
/**/                 {{{0xa6c6cfcc, 0x3f3efe1f} },
/**/                  {{0x3512d15c, 0x3bdac2da} },},
/**/                 {{{0x2aa6ab11, 0x3f3ffe00} },
/**/                  {{0x62cc632d, 0x3b999e2b} },},
/**/                 {{{0xd7633d2c, 0x3f407eef} },
/**/                  {{0x63ff6024, 0xbbebc98b} },},
/**/                 {{{0x19941e6e, 0x3f40fedf} },
/**/                  {{0xe0aa6338, 0xbbb194c2} },},
/**/                 {{{0xdbe6f8eb, 0x3f417ecd} },
/**/                  {{0x57b0f571, 0x3be4241b} },},
/**/                 {{{0x1e5ccc3c, 0x3f41febc} },
/**/                  {{0x895d3592, 0x3bdc657d} },},
/**/                 {{{0xe0f697f6, 0x3f427ea9} },
/**/                  {{0x1c0ec17c, 0x3be35a5d} },},
/**/                 {{{0x23b55bac, 0x3f42fe97} },
/**/                  {{0x3e538464, 0x3bd6cfb7} },},
/**/                 {{{0xe69a16ed, 0x3f437e83} },
/**/                  {{0x7cef2478, 0x3bee96f7} },},
/**/                 {{{0x29a5c947, 0x3f43fe70} },
/**/                  {{0xbf46e36a, 0xbbd4d578} },},
/**/                 {{{0xecd97242, 0x3f447e5b} },
/**/                  {{0x3ff7dd44, 0xbbc9eb66} },},
/**/                 {{{0x30361165, 0x3f44fe47} },
/**/                  {{0x7e93f2fd, 0x3be400d7} },},
/**/                 {{{0xf3bca635, 0x3f457e31} },
/**/                  {{0xd375017f, 0xbbe0e2a2} },},
/**/                 {{{0x376e3031, 0x3f45fe1c} },
/**/                  {{0x8a5ae7f6, 0xbbd524eb} },},
/**/                 {{{0xfb4baed7, 0x3f467e05} },
/**/                  {{0x4e85c4e9, 0x3be204fb} },},
/**/                 {{{0x3f5621a3, 0x3f46fdef} },
/**/                  {{0x34886d52, 0xbbdf09d7} },},
/**/                 {{{0x038e880b, 0x3f477dd8} },
/**/                  {{0x14e596a3, 0xbbb8900e} },},
/**/                 {{{0x47f5e185, 0x3f47fdc0} },
/**/                  {{0x57d202d3, 0xbbebfa5c} },},
/**/                 {{{0x0c8d2d81, 0x3f487da8} },
/**/                  {{0xd68c0614, 0x3be2f6ae} },},
/**/                 {{{0x51556b70, 0x3f48fd8f} },
/**/                  {{0xe08fd201, 0xbbd0f4f2} },},
/**/                 {{{0x164f9abc, 0x3f497d76} },
/**/                  {{0xa871af60, 0x3b5296b7} },},
/**/                 {{{0x5b7cbace, 0x3f49fd5c} },
/**/                  {{0x9f17d42d, 0x3beb6ed4} },},
/**/                 {{{0x20ddcb0d, 0x3f4a7d42} },
/**/                  {{0x67c30397, 0xbbcb1149} },},
/**/                 {{{0x6673cada, 0x3f4afd27} },
/**/                  {{0x45da594f, 0x3bd32225} },},
/**/                 {{{0x2c3fb996, 0x3f4b7d0c} },
/**/                  {{0x208d4630, 0xbbb68893} },},
/**/                 {{{0x7242969d, 0x3f4bfcf0} },
/**/                  {{0x2b3efe1c, 0x3bc5db4d} },},
/**/                 {{{0x387d6149, 0x3f4c7cd4} },
/**/                  {{0xed57d98a, 0x3be46eff} },},
/**/                 {{{0x7ef118f1, 0x3f4cfcb7} },
/**/                  {{0x06f300fb, 0x3becc554} },},
/**/                 {{{0x459ebce9, 0x3f4d7c9a} },
/**/                  {{0x13638eb6, 0x3be1d251} },},
/**/                 {{{0x8c874c82, 0x3f4dfc7c} },
/**/                  {{0xd57a176f, 0xbbe863e9} },},
/**/                 {{{0x53abc708, 0x3f4e7c5e} },
/**/                  {{0x9528e50d, 0x3be2d95c} },},
/**/                 {{{0x9b0d2bc8, 0x3f4efc3f} },
/**/                  {{0xa5f5b8b7, 0x3bd1e8e8} },},
/**/                 {{{0x62ac7a09, 0x3f4f7c20} },
/**/                  {{0x17802a46, 0x3b5c8123} },},
/**/                 {{{0xaa8ab110, 0x3f4ffc00} },
/**/                  {{0xeb9b6cdb, 0xbbe0fecb} },},
/**/                 {{{0x3954680f, 0x3f503df0} },
/**/                  {{0x1c693678, 0x3bdac89b} },},
/**/                 {{{0xdd83eb3a, 0x3f507ddf} },
/**/                  {{0x0a75ad5f, 0xbbf638f6} },},
/**/                 {{{0x41d461a5, 0x3f50bdcf} },
/**/                  {{0x45f05b10, 0x3bfd4bc9} },},
/**/                 {{{0x66464aef, 0x3f50fdbe} },
/**/                  {{0x6abbf59c, 0xbbbd0554} },},
/**/                 {{{0x4ada26b1, 0x3f513dad} },
/**/                  {{0x6036fe6f, 0x3be38c65} },},
/**/                 {{{0xef907485, 0x3f517d9b} },
/**/                  {{0xf158bbc3, 0x3bfdc8a1} },},
/**/                 {{{0x5469b404, 0x3f51bd8a} },
/**/                  {{0x55632e3f, 0xbbdea231} },},
/**/                 {{{0x796664c3, 0x3f51fd78} },
/**/                  {{0x2edb73c2, 0xbbe00849} },},
/**/                 {{{0x5e870657, 0x3f523d66} },
/**/                  {{0x0789343e, 0x3bfba943} },},
/**/                 {{{0x03cc1855, 0x3f527d54} },
/**/                  {{0xeafafc52, 0x3bc5f644} },},
/**/                 {{{0x69361a4e, 0x3f52bd41} },
/**/                  {{0xa4a6e79f, 0xbbf2f743} },},
/**/                 {{{0x8ec58bd2, 0x3f52fd2e} },
/**/                  {{0x5ceb1abf, 0xbbd4f786} },},
/**/                 {{{0x747aec71, 0x3f533d1b} },
/**/                  {{0x49dc497d, 0xbbf369e3} },},
/**/                 {{{0x1a56bbb8, 0x3f537d08} },
/**/                  {{0x3726b14a, 0xbbfc5e6f} },},
/**/                 {{{0x80597933, 0x3f53bcf4} },
/**/                  {{0x808f75a7, 0xbbfe8b82} },},
/**/                 {{{0xa683a46c, 0x3f53fce0} },
/**/                  {{0x9cd06ae6, 0x3be02719} },},
/**/                 {{{0x8cd5bced, 0x3f543ccc} },
/**/                  {{0x758f80f8, 0x3bf9f98d} },},
/**/                 {{{0x3350423e, 0x3f547cb8} },
/**/                  {{0x48401f45, 0xbbd79c3d} },},
/**/                 {{{0x99f3b3e4, 0x3f54bca3} },
/**/                  {{0x2fba8948, 0xbbf422b8} },},
/**/                 {{{0xc0c09163, 0x3f54fc8e} },
/**/                  {{0xf4044be8, 0x3bf32cc1} },},
/**/                 {{{0xa7b75a40, 0x3f553c79} },
/**/                  {{0xf2249008, 0xbbe72cac} },},
/**/                 {{{0x4ed88dfb, 0x3f557c64} },
/**/                  {{0x459a204f, 0xbbe7183c} },},
/**/                 {{{0xb624ac14, 0x3f55bc4e} },
/**/                  {{0xba26d3d7, 0x3bf8aa64} },},
/**/                 {{{0xdd9c340b, 0x3f55fc38} },
/**/                  {{0x45fa193c, 0x3bdbb2ff} },},
/**/                 {{{0xc53fa55c, 0x3f563c22} },
/**/                  {{0x0484397b, 0x3bd67249} },},
/**/                 {{{0x6d0f7f83, 0x3f567c0c} },
/**/                  {{0xf1e73188, 0xbbd183d7} },},
/**/                 {{{0xd50c41fa, 0x3f56bbf5} },
/**/                  {{0x4ab68187, 0xbbef433d} },},
/**/                 {{{0xfd366c39, 0x3f56fbde} },
/**/                  {{0x66e09e58, 0x3be796b8} },},
/**/                 {{{0xe58e7db8, 0x3f573bc7} },
/**/                  {{0x81e6e7e6, 0x3bf65ec5} },},
/**/                 {{{0x8e14f5ed, 0x3f577bb0} },
/**/                  {{0xa9463a9c, 0xbbdb944d} },},
/**/                 {{{0xf6ca544b, 0x3f57bb98} },
/**/                  {{0xc5eda344, 0xbbc396ec} },},
/**/                 {{{0x1faf1845, 0x3f57fb81} },
/**/                  {{0xbb624f97, 0x3beb9e6d} },},
/**/                 {{{0x08c3c14d, 0x3f583b69} },
/**/                  {{0xe6295bf2, 0xbbe6ee13} },},
/**/                 {{{0xb208ced1, 0x3f587b50} },
/**/                  {{0x6ca19875, 0x3bfcf1a5} },},
/**/                 {{{0x1b7ec041, 0x3f58bb38} },
/**/                  {{0x07b4fc7e, 0x3bf2d181} },},
/**/                 {{{0x45261509, 0x3f58fb1f} },
/**/                  {{0x21bad336, 0x3bc419c5} },},
/**/                 {{{0x2eff4c94, 0x3f593b06} },
/**/                  {{0x700b305b, 0xbbdc2a4c} },},
/**/                 {{{0xd90ae64c, 0x3f597aec} },
/**/                  {{0xa23f359c, 0xbbfc53d3} },},
/**/                 {{{0x43496198, 0x3f59bad3} },
/**/                  {{0xaed6b50f, 0x3bf0c270} },},
/**/                 {{{0x6dbb3de1, 0x3f59fab9} },
/**/                  {{0x7a8be031, 0xbbf11464} },},
/**/                 {{{0x5860fa8a, 0x3f5a3a9f} },
/**/                  {{0x470dbe32, 0x3beae9e7} },},
/**/                 {{{0x033b16f8, 0x3f5a7a85} },
/**/                  {{0xda1f8579, 0x3bfc4721} },},
/**/                 {{{0x6e4a128e, 0x3f5aba6a} },
/**/                  {{0x029258ce, 0xbbf41852} },},
/**/                 {{{0x998e6cab, 0x3f5afa4f} },
/**/                  {{0x2eb18782, 0xbbf28584} },},
/**/                 {{{0x8508a4af, 0x3f5b3a34} },
/**/                  {{0x23241a2c, 0xbbea7970} },},
/**/                 {{{0x30b939f8, 0x3f5b7a19} },
/**/                  {{0x600551b6, 0xbbf1d8db} },},
/**/                 {{{0x9ca0abe2, 0x3f5bb9fd} },
/**/                  {{0x8c26cc71, 0xbbeaa412} },},
/**/                 {{{0xc8bf79c8, 0x3f5bf9e1} },
/**/                  {{0x30427cfc, 0xbbe7f81b} },},
/**/                 {{{0xb5162303, 0x3f5c39c5} },
/**/                  {{0xd1f134e1, 0x3bd9ec5f} },},
/**/                 {{{0x61a526eb, 0x3f5c79a9} },
/**/                  {{0x8980e47d, 0x3bff0cb0} },},
/**/                 {{{0xce6d04d7, 0x3f5cb98c} },
/**/                  {{0xe84ca4e2, 0x3bf35aca} },},
/**/                 {{{0xfb6e3c1b, 0x3f5cf96f} },
/**/                  {{0x1b0bd69f, 0x3bf9b1b8} },},
/**/                 {{{0xe8a94c0b, 0x3f5d3952} },
/**/                  {{0x3ce51832, 0x3be21310} },},
/**/                 {{{0x961eb3f8, 0x3f5d7935} },
/**/                  {{0x840c58ce, 0x3bf90786} },},
/**/                 {{{0x03cef334, 0x3f5db918} },
/**/                  {{0xf2dfb3f4, 0xbbfe0048} },},
/**/                 {{{0x31ba890b, 0x3f5df8fa} },
/**/                  {{0x3e295bec, 0x3bfcf652} },},
/**/                 {{{0x1fe1f4ce, 0x3f5e38dc} },
/**/                  {{0x151c9300, 0xbbfc5ebe} },},
/**/                 {{{0xce45b5c6, 0x3f5e78bd} },
/**/                  {{0x8a25b9c7, 0xbbef2cc4} },},
/**/                 {{{0x3ce64b3e, 0x3f5eb89f} },
/**/                  {{0xa6fea7bd, 0x3bfe6d27} },},
/**/                 {{{0x6bc43481, 0x3f5ef880} },
/**/                  {{0x914a6dab, 0xbbf68037} },},
/**/                 {{{0x5adff0d4, 0x3f5f3861} },
/**/                  {{0xf909e0e6, 0xbbf1d2f3} },},
/**/                 {{{0x0a39ff7e, 0x3f5f7842} },
/**/                  {{0xff1e1f71, 0xbbf64661} },},
/**/                 {{{0x79d2dfc3, 0x3f5fb822} },
/**/                  {{0x5a6f9e9a, 0xbbd76ce8} },},
/**/                 {{{0xa9ab10e6, 0x3f5ff802} },
/**/                  {{0xa153e3b2, 0x3bfe29e3} },},
/**/                 {{{0x4ce18915, 0x3f601bf1} },
/**/                  {{0xa3a73044, 0xbbe57c28} },},
/**/                 {{{0x250db166, 0x3f603be1} },
/**/                  {{0xc1ad9590, 0x3c0fd271} },},
/**/                 {{{0xdd5a4107, 0x3f605bd0} },
/**/                  {{0xc424c676, 0x3bfe4b5d} },},
/**/                 {{{0x75c77796, 0x3f607bc0} },
/**/                  {{0xc0eff1ba, 0xbc068804} },},
/**/                 {{{0xee5594b0, 0x3f609baf} },
/**/                  {{0x51dbded5, 0xbc0ff798} },},
/**/                 {{{0x4704d7f2, 0x3f60bb9f} },
/**/                  {{0x2d5aba70, 0xbbf70ef4} },},
/**/                 {{{0x7fd580f9, 0x3f60db8e} },
/**/                  {{0x7ae804b5, 0xbbeccb65} },},
/**/                 {{{0x98c7cf60, 0x3f60fb7d} },
/**/                  {{0x1775134d, 0x3bfede2f} },},
/**/                 {{{0x91dc02c3, 0x3f611b6c} },
/**/                  {{0x91ca4a67, 0xbc04d41e} },},
/**/                 {{{0x6b125aba, 0x3f613b5b} },
/**/                  {{0x4a12201d, 0x3bfe6d0c} },},
/**/                 {{{0x246b16e0, 0x3f615b4a} },
/**/                  {{0x4d4238d3, 0x3bfe507d} },},
/**/                 {{{0xbde676cd, 0x3f617b38} },
/**/                  {{0x0640462a, 0x3bfe0272} },},
/**/                 {{{0x3784ba19, 0x3f619b27} },
/**/                  {{0x02285659, 0x3bd94ab3} },},
/**/                 {{{0x9146205b, 0x3f61bb15} },
/**/                  {{0x1cc35b7b, 0xbbff1e2e} },},
/**/                 {{{0xcb2ae929, 0x3f61db03} },
/**/                  {{0x12f6bf8d, 0xbc03ee8e} },},
/**/                 {{{0xe5335418, 0x3f61faf1} },
/**/                  {{0x7b7d619b, 0x3c0bae5f} },},
/**/                 {{{0xdf5fa0bf, 0x3f621adf} },
/**/                  {{0xb3b731b0, 0xbbf5546a} },},
/**/                 {{{0xb9b00eb0, 0x3f623acd} },
/**/                  {{0x105fd253, 0xbbafb2b0} },},
/**/                 {{{0x7424dd7f, 0x3f625abb} },
/**/                  {{0xca53444b, 0x3c011647} },},
/**/                 {{{0x0ebe4cbf, 0x3f627aa9} },
/**/                  {{0x592f3be8, 0x3c01678f} },},
/**/                 {{{0x897c9c02, 0x3f629a96} },
/**/                  {{0x4347451d, 0xbbef2b12} },},
/**/                 {{{0xe4600ad8, 0x3f62ba83} },
/**/                  {{0xb2a477bc, 0x3bfb5bb7} },},
/**/                 {{{0x1f68d8d3, 0x3f62da71} },
/**/                  {{0x7a5822e4, 0xbc0590e1} },},
/**/                 {{{0x3a974581, 0x3f62fa5e} },
/**/                  {{0x53123101, 0xbbf0f2e5} },},
/**/                 {{{0x35eb9072, 0x3f631a4b} },
/**/                  {{0x0e3f5fde, 0xbc018db4} },},
/**/                 {{{0x1165f933, 0x3f633a38} },
/**/                  {{0x8d0afb38, 0x3c0921d5} },},
/**/                 {{{0xcd06bf53, 0x3f635a24} },
/**/                  {{0xb5791b80, 0x3c01f6ba} },},
/**/                 {{{0x68ce225e, 0x3f637a11} },
/**/                  {{0xa1894236, 0x3bde2af8} },},
/**/                 {{{0xe4bc61e0, 0x3f6399fd} },
/**/                  {{0xd0f06ff3, 0xbc062a48} },},
/**/                 {{{0x40d1bd63, 0x3f63b9ea} },
/**/                  {{0x4b4f9c11, 0x3bffc80c} },},
/**/                 {{{0x7d0e7473, 0x3f63d9d6} },
/**/                  {{0x6a92c891, 0x3c02219b} },},
/**/                 {{{0x9972c699, 0x3f63f9c2} },
/**/                  {{0x790ade9e, 0x3c0d3590} },},
/**/                 {{{0x95fef35f, 0x3f6419ae} },
/**/                  {{0x792a458c, 0xbc01c279} },},
/**/                 {{{0x72b33a4b, 0x3f64399a} },
/**/                  {{0x327bffae, 0x3c02ce64} },},
/**/                 {{{0x2f8fdae7, 0x3f645986} },
/**/                  {{0xd231155c, 0xbc070aec} },},
/**/                 {{{0xcc9514b7, 0x3f647971} },
/**/                  {{0xe4bbf776, 0x3c0f373d} },},
/**/                 {{{0x49c32744, 0x3f64995d} },
/**/                  {{0xbf22b2a7, 0xbbf6d7e5} },},
/**/                 {{{0xa71a5211, 0x3f64b948} },
/**/                  {{0x64fe2936, 0xbbedec69} },},
/**/                 {{{0xe49ad4a3, 0x3f64d933} },
/**/                  {{0xabee4257, 0x3bf5fc4b} },},
/**/                 {{{0x0244ee7e, 0x3f64f91f} },
/**/                  {{0x3cd1474f, 0x3c0c6fe3} },},
/**/                 {{{0x0018df26, 0x3f65190a} },
/**/                  {{0xd11e7fa5, 0xbc023957} },},
/**/                 {{{0xde16e61b, 0x3f6538f4} },
/**/                  {{0x55380346, 0x3c006c31} },},
/**/                 {{{0x9c3f42e1, 0x3f6558df} },
/**/                  {{0xc4a5134c, 0xbc09b7d4} },},
/**/                 {{{0x3a9234f7, 0x3f6578ca} },
/**/                  {{0x2772c19c, 0xbc0e3f10} },},
/**/                 {{{0xb90ffbdd, 0x3f6598b4} },
/**/                  {{0x5592b468, 0x3be6f110} },},
/**/                 {{{0x17b8d714, 0x3f65b89f} },
/**/                  {{0xb251ace2, 0xbc0a5fea} },},
/**/                 {{{0x568d0619, 0x3f65d889} },
/**/                  {{0x315da285, 0xbc0aacc9} },},
/**/                 {{{0x758cc86a, 0x3f65f873} },
/**/                  {{0xba64d81a, 0xbbeb0782} },},
/**/                 {{{0x74b85d85, 0x3f66185d} },
/**/                  {{0x8e1eb3fa, 0xbc09b459} },},
/**/                 {{{0x541004e5, 0x3f663847} },
/**/                  {{0x1d86e863, 0x3bce9c22} },},
/**/                 {{{0x1393fe07, 0x3f665831} },
/**/                  {{0xcf37ee90, 0xbbfbeb77} },},
/**/                 {{{0xb3448865, 0x3f66781a} },
/**/                  {{0xc252e3c9, 0xbc02dc68} },},
/**/                 {{{0x3321e379, 0x3f669804} },
/**/                  {{0xb40b3741, 0xbbe73a0b} },},
  };

#endif
#endif
