/*
 * IBM Accurate Mathematical Library
 * Written by International Business Machines Corp.
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/****************************************************************/
/* TABLES FOR THE utan() FUNCTION                               */
/****************************************************************/


#ifdef BIG_ENDI
static const number
      xfg[186][4] = {                             /* xi,Fi,Gi,FFi, i=16..201 */
/**/                 {{{0x3fb00000, 0x1e519d60} },
/**/                  {{0x3fb00557, 0x96c4e240} },
/**/                  {{0x402ff554, 0x628127b7} },
/**/                  {{0xbb9a1dee, 0x9e355b06} },},
/**/                 {{{0x3fb10000, 0x1b1a7010} },
/**/                  {{0x3fb10668, 0xaab892b7} },
/**/                  {{0x402e12c7, 0xbe3fdf74} },
/**/                  {{0x3ba89234, 0x037da741} },},
/**/                 {{{0x3fb20000, 0x2505e350} },
/**/                  {{0x3fb2079b, 0xff547824} },
/**/                  {{0x402c65c5, 0xde853633} },
/**/                  {{0x3bb7486e, 0xe9614250} },},
/**/                 {{{0x3fb2ffff, 0xfcdc4252} },
/**/                  {{0x3fb308f3, 0x5eb16c68} },
/**/                  {{0x402ae5da, 0xe56be74f} },
/**/                  {{0xbb82c726, 0x91a23034} },},
/**/                 {{{0x3fb3ffff, 0xe3ff849f} },
/**/                  {{0x3fb40a71, 0x154999cc} },
/**/                  {{0x40298c43, 0x046b7352} },
/**/                  {{0x3b9aceaf, 0x3843738f} },},
/**/                 {{{0x3fb4ffff, 0xedc9590f} },
/**/                  {{0x3fb50c17, 0x429bdd80} },
/**/                  {{0x40285384, 0x91b5d674} },
/**/                  {{0xbbc1d02d, 0xb4403d22} },},
/**/                 {{{0x3fb60000, 0x00ee83f7} },
/**/                  {{0x3fb60de7, 0xda80cc21} },
/**/                  {{0x40273724, 0xef21a2a7} },
/**/                  {{0xbb95e53c, 0x72523ffd} },},
/**/                 {{{0x3fb6ffff, 0xeb05ea41} },
/**/                  {{0x3fb70fe4, 0xb8c51bea} },
/**/                  {{0x40263370, 0xfae562ff} },
/**/                  {{0xbb99ad0e, 0x8ffe0626} },},
/**/                 {{{0x3fb7ffff, 0xdc0515f7} },
/**/                  {{0x3fb81210, 0x1db54498} },
/**/                  {{0x40254553, 0x0e7eab5c} },
/**/                  {{0xbb914c87, 0xd62ed686} },},
/**/                 {{{0x3fb8ffff, 0xe384d7ab} },
/**/                  {{0x3fb9146c, 0x2a8d3727} },
/**/                  {{0x40246a33, 0xfd57f3fd} },
/**/                  {{0xbbbbda8d, 0x5381e06d} },},
/**/                 {{{0x3fb9ffff, 0xe4832347} },
/**/                  {{0x3fba16fa, 0xd50e1050} },
/**/                  {{0x40239fe2, 0xc5537a96} },
/**/                  {{0x3bc7f695, 0xc111eabb} },},
/**/                 {{{0x3fbb0000, 0x274540e3} },
/**/                  {{0x3fbb19be, 0x7ae68517} },
/**/                  {{0x4022e481, 0x3637e946} },
/**/                  {{0x3bc307f8, 0x8dbd9d93} },},
/**/                 {{{0x3fbbffff, 0xfebf2e9b} },
/**/                  {{0x3fbc1cb8, 0x8369cd19} },
/**/                  {{0x40223676, 0x17aef223} },
/**/                  {{0x3bc50038, 0x424a9cf3} },},
/**/                 {{{0x3fbd0000, 0x23529045} },
/**/                  {{0x3fbd1feb, 0xc11d7ef7} },
/**/                  {{0x4021945f, 0xb8e43d4e} },
/**/                  {{0x3b812007, 0x52a6f224} },},
/**/                 {{{0x3fbdffff, 0xd872a829} },
/**/                  {{0x3fbe2359, 0x8ee4d6b7} },
/**/                  {{0x4020fd0c, 0x76195d5f} },
/**/                  {{0xbbb4d9ab, 0x85fdca85} },},
/**/                 {{{0x3fbeffff, 0xff323b84} },
/**/                  {{0x3fbf2704, 0xec9073e5} },
/**/                  {{0x40206f71, 0x3020200f} },
/**/                  {{0x3bb77aa2, 0x12836992} },},
/**/                 {{{0x3fc00000, 0x0ce79195} },
/**/                  {{0x3fc01577, 0xbc30cc61} },
/**/                  {{0x401fd549, 0xd6564a88} },
/**/                  {{0xbbc8926f, 0x965c0ad0} },},
/**/                 {{{0x3fc07fff, 0xee40e918} },
/**/                  {{0x3fc0978d, 0x8279ac01} },
/**/                  {{0x401edbb5, 0x9294bc03} },
/**/                  {{0xbb80a533, 0x4aae45d6} },},
/**/                 {{{0x3fc10000, 0x0cc091fd} },
/**/                  {{0x3fc119c5, 0x44dfb2f7} },
/**/                  {{0x401df0bb, 0x067d8e18} },
/**/                  {{0xbbcc2c18, 0x4ff642a4} },},
/**/                 {{{0x3fc18000, 0x0d9936a1} },
/**/                  {{0x3fc19c1f, 0xb9085a4b} },
/**/                  {{0x401d131a, 0x71ce3629} },
/**/                  {{0xbbc36553, 0x0669355b} },},
/**/                 {{{0x3fc1ffff, 0xed5f3188} },
/**/                  {{0x3fc21e9d, 0xee74bf2d} },
/**/                  {{0x401c41b6, 0xff0cd655} },
/**/                  {{0x3b8867f5, 0x478ecfc5} },},
/**/                 {{{0x3fc28000, 0x05f06a51} },
/**/                  {{0x3fc2a141, 0x550b313f} },
/**/                  {{0x401b7b92, 0x1702e6d2} },
/**/                  {{0xbbadab51, 0x380131fe} },},
/**/                 {{{0x3fc2ffff, 0xfe3d339e} },
/**/                  {{0x3fc3240a, 0xa75f76df} },
/**/                  {{0x401abfc8, 0xfcb6409d} },
/**/                  {{0x3bc60bcf, 0x0d291d83} },},
/**/                 {{{0x3fc37fff, 0xed888d6f} },
/**/                  {{0x3fc3a6fb, 0x13cc5db7} },
/**/                  {{0x401a0d8f, 0x8ed5320d} },
/**/                  {{0x3bb8a48e, 0x4eef03ab} },},
/**/                 {{{0x3fc40000, 0x02ca050d} },
/**/                  {{0x3fc42a13, 0xe25776bb} },
/**/                  {{0x4019642d, 0xfa84c2bc} },
/**/                  {{0xbbd0bd5d, 0xcc56516f} },},
/**/                 {{{0x3fc47fff, 0xf2531f5c} },
/**/                  {{0x3fc4ad55, 0xdeb73404} },
/**/                  {{0x4018c2fe, 0xf86e9035} },
/**/                  {{0x3b9cffe7, 0x5aa287c8} },},
/**/                 {{{0x3fc50000, 0x13774992} },
/**/                  {{0x3fc530c2, 0x7d0ee307} },
/**/                  {{0x4018296c, 0x370caf35} },
/**/                  {{0xbbcf75d1, 0xf91d6532} },},
/**/                 {{{0x3fc57fff, 0xedddcb2d} },
/**/                  {{0x3fc5b45a, 0x5db4347d} },
/**/                  {{0x401796ee, 0x52190c0e} },
/**/                  {{0x3b88a25f, 0x17d5d076} },},
/**/                 {{{0x3fc5ffff, 0xf41949a0} },
/**/                  {{0x3fc6381f, 0x13bf986a} },
/**/                  {{0x40170b09, 0x2d2255fd} },
/**/                  {{0xbb9bfb23, 0xb1bcd5e7} },},
/**/                 {{{0x3fc67fff, 0xf834d3a1} },
/**/                  {{0x3fc6bc11, 0x8ec85952} },
/**/                  {{0x4016854c, 0x62cf2268} },
/**/                  {{0x3b9ee53b, 0x82e39e04} },},
/**/                 {{{0x3fc6ffff, 0xfd9106ea} },
/**/                  {{0x3fc74032, 0xf298f6f7} },
/**/                  {{0x40160551, 0x1f4f84a9} },
/**/                  {{0xbbb59c4a, 0x112634b8} },},
/**/                 {{{0x3fc78000, 0x0f649a4f} },
/**/                  {{0x3fc7c484, 0x6ca53abc} },
/**/                  {{0x40158ab9, 0x4809d175} },
/**/                  {{0x3bc91c75, 0x73d3cd2e} },},
/**/                 {{{0x3fc7ffff, 0xef06bbd8} },
/**/                  {{0x3fc84906, 0xdf7d76ad} },
/**/                  {{0x4015152e, 0xdd2b30a6} },
/**/                  {{0xbbbfa2da, 0x084c3eef} },},
/**/                 {{{0x3fc88000, 0x021c6334} },
/**/                  {{0x3fc8cdbb, 0xd965f986} },
/**/                  {{0x4014a462, 0x51b74296} },
/**/                  {{0xbb9ec02e, 0x74dcfe0b} },},
/**/                 {{{0x3fc8ffff, 0xf38d0756} },
/**/                  {{0x3fc952a4, 0x28e173c7} },
/**/                  {{0x4014380b, 0x17b59ebd} },
/**/                  {{0xbbcd0f1c, 0xb77589f0} },},
/**/                 {{{0x3fc98000, 0x104efca1} },
/**/                  {{0x3fc9d7c1, 0x4644d23c} },
/**/                  {{0x4013cfe5, 0xcb1eabd5} },
/**/                  {{0xbbd5d6f7, 0xea188d9e} },},
/**/                 {{{0x3fca0000, 0x09417b30} },
/**/                  {{0x3fca5d14, 0x096d76aa} },
/**/                  {{0x40136bb4, 0xb3723db0} },
/**/                  {{0x3bbe3e0d, 0xfbf3979c} },},
/**/                 {{{0x3fca7fff, 0xeb1c23ec} },
/**/                  {{0x3fcae29d, 0xab60288d} },
/**/                  {{0x40130b3e, 0x783071d7} },
/**/                  {{0xbbc7dd82, 0x3d5384bf} },},
/**/                 {{{0x3fcaffff, 0xfb171c13} },
/**/                  {{0x3fcb685f, 0xa221a96b} },
/**/                  {{0x4012ae4d, 0xd8c0747d} },
/**/                  {{0x3bd4644b, 0xd5554972} },},
/**/                 {{{0x3fcb8000, 0x0aba44be} },
/**/                  {{0x3fcbee5a, 0xecdf241f} },
/**/                  {{0x401254b1, 0xc6fad63b} },
/**/                  {{0x3ba41916, 0xd092b85a} },},
/**/                 {{{0x3fcc0000, 0x113d2a3e} },
/**/                  {{0x3fcc7490, 0xb3e92543} },
/**/                  {{0x4011fe3c, 0x9a62c035} },
/**/                  {{0xbba3cc39, 0x41a03739} },},
/**/                 {{{0x3fcc7fff, 0xf49e00ce} },
/**/                  {{0x3fccfb02, 0x0f59eab0} },
/**/                  {{0x4011aac3, 0xe956a631} },
/**/                  {{0xbbb7a383, 0xbfa8cb5b} },},
/**/                 {{{0x3fcd0000, 0x05f611ab} },
/**/                  {{0x3fcd81b0, 0x89e6844e} },
/**/                  {{0x40115a1f, 0xf391268d} },
/**/                  {{0x3bd39b5c, 0xb2dc91f3} },},
/**/                 {{{0x3fcd8000, 0x14764ceb} },
/**/                  {{0x3fce089d, 0x27debf0d} },
/**/                  {{0x40110c2b, 0xfbc84740} },
/**/                  {{0x3bc14d4d, 0x84712510} },},
/**/                 {{{0x3fce0000, 0x14bcea76} },
/**/                  {{0x3fce8fc9, 0x16dbc820} },
/**/                  {{0x4010c0c5, 0xa00ca48e} },
/**/                  {{0xbbd33788, 0x640f1b9e} },},
/**/                 {{{0x3fce7fff, 0xfd7995bd} },
/**/                  {{0x3fcf1735, 0x88b50424} },
/**/                  {{0x401077cc, 0xbe02169a} },
/**/                  {{0xbbb61fee, 0x221fdf77} },},
/**/                 {{{0x3fcf0000, 0x0cc35436} },
/**/                  {{0x3fcf9ee3, 0xfd21a40b} },
/**/                  {{0x40103123, 0x1ee7ffe8} },
/**/                  {{0x3bd427e3, 0xc79ff5c1} },},
/**/                 {{{0x3fcf8000, 0x01d1da33} },
/**/                  {{0x3fd0136a, 0xb7dbe15c} },
/**/                  {{0x400fd959, 0x77d559e5} },
/**/                  {{0x3bb0c6a1, 0xd67948d7} },},
/**/                 {{{0x3fd00000, 0x060c13b2} },
/**/                  {{0x3fd05785, 0xaaad4f18} },
/**/                  {{0x400f549e, 0x2675d182} },
/**/                  {{0xbbc15208, 0x18f0dd10} },},
/**/                 {{{0x3fd04000, 0x03885492} },
/**/                  {{0x3fd09bc3, 0x660542d7} },
/**/                  {{0x400ed3e2, 0xdf3f5fec} },
/**/                  {{0xbbd95657, 0xb883ae62} },},
/**/                 {{{0x3fd08000, 0x052f5a13} },
/**/                  {{0x3fd0e024, 0x9a195045} },
/**/                  {{0x400e56f8, 0xfa68f2c8} },
/**/                  {{0x3bded7ba, 0x5a543e8e} },},
/**/                 {{{0x3fd0c000, 0x02ba1af5} },
/**/                  {{0x3fd124a9, 0xe2e7f24b} },
/**/                  {{0x400dddb4, 0xbffe633f} },
/**/                  {{0xbbdcba86, 0x0c60278f} },},
/**/                 {{{0x3fd0ffff, 0xf76642c1} },
/**/                  {{0x3fd16953, 0xe162ffe6} },
/**/                  {{0x400d67ed, 0x0311d5d5} },
/**/                  {{0x3b7b1f4a, 0xe40c5f9e} },},
/**/                 {{{0x3fd14000, 0x033602f0} },
/**/                  {{0x3fd1ae23, 0x5f49508e} },
/**/                  {{0x400cf57a, 0xb8708266} },
/**/                  {{0xbbd6a6c2, 0x8620f301} },},
/**/                 {{{0x3fd17fff, 0xfefd1a13} },
/**/                  {{0x3fd1f318, 0xdb2a9ba1} },
/**/                  {{0x400c8639, 0x8d11009e} },
/**/                  {{0x3bd3a9c6, 0x69b21d3b} },},
/**/                 {{{0x3fd1bfff, 0xf718365d} },
/**/                  {{0x3fd23835, 0x0c41e3ac} },
/**/                  {{0x400c1a06, 0xe02be47c} },
/**/                  {{0x3bdb961a, 0x129e8cd1} },},
/**/                 {{{0x3fd1ffff, 0xff001e00} },
/**/                  {{0x3fd27d78, 0xb2f6395e} },
/**/                  {{0x400bb0c1, 0xf2fe9a85} },
/**/                  {{0x3be074a9, 0xe68fd7d8} },},
/**/                 {{{0x3fd23fff, 0xfe425a6a} },
/**/                  {{0x3fd2c2e4, 0x618faabe} },
/**/                  {{0x400b4a4c, 0x190b18df} },
/**/                  {{0xbbdf0d1f, 0xf615aad1} },},
/**/                 {{{0x3fd28000, 0x059ec1db} },
/**/                  {{0x3fd30878, 0xd8583884} },
/**/                  {{0x400ae688, 0x0cd82bc2} },
/**/                  {{0xbbd563c3, 0x141c1f8d} },},
/**/                 {{{0x3fd2c000, 0x000dd081} },
/**/                  {{0x3fd34e36, 0xaffdb6d8} },
/**/                  {{0x400a855a, 0x5270fc15} },
/**/                  {{0xbbc6d88d, 0x9f2cdafd} },},
/**/                 {{{0x3fd2ffff, 0xfc1dcd2b} },
/**/                  {{0x3fd3941e, 0xa95875bc} },
/**/                  {{0x400a26a8, 0xaa9502b6} },
/**/                  {{0xbbe13cad, 0x8389b15c} },},
/**/                 {{{0x3fd33fff, 0xf6c0d4a0} },
/**/                  {{0x3fd3da31, 0x739845f5} },
/**/                  {{0x4009ca5a, 0x4d2573a0} },
/**/                  {{0xbbc71636, 0xacaee379} },},
/**/                 {{{0x3fd38000, 0x06b16793} },
/**/                  {{0x3fd4206f, 0xdbc088f0} },
/**/                  {{0x40097057, 0x9344e33a} },
/**/                  {{0xbbc2c052, 0x1d7a4f81} },},
/**/                 {{{0x3fd3c000, 0x07358fa3} },
/**/                  {{0x3fd466da, 0x6f23311d} },
/**/                  {{0x4009188a, 0x5aa612ea} },
/**/                  {{0x3b8653a5, 0x685e8edc} },},
/**/                 {{{0x3fd3ffff, 0xfc3b18cf} },
/**/                  {{0x3fd4ad71, 0xe9282e6b} },
/**/                  {{0x4008c2dd, 0x641e643d} },
/**/                  {{0x3b95f0ef, 0x3f567c64} },},
/**/                 {{{0x3fd44000, 0x000dd2a8} },
/**/                  {{0x3fd4f437, 0x1fa3f2d1} },
/**/                  {{0x40086f3c, 0x6072f821} },
/**/                  {{0x3bb68efa, 0x95ff68b5} },},
/**/                 {{{0x3fd47fff, 0xfbb43713} },
/**/                  {{0x3fd53b2a, 0xb3ac333c} },
/**/                  {{0x40081d94, 0x3da56692} },
/**/                  {{0xbbbf4d7f, 0x2985fd3f} },},
/**/                 {{{0x3fd4bfff, 0xfb113bf4} },
/**/                  {{0x3fd5824d, 0x6e8ed9c2} },
/**/                  {{0x4007cdd2, 0xa8add00f} },
/**/                  {{0x3bcf478a, 0x1c9b3657} },},
/**/                 {{{0x3fd4ffff, 0xf7f087c9} },
/**/                  {{0x3fd5c9a0, 0x07446496} },
/**/                  {{0x40077fe6, 0x444588eb} },
/**/                  {{0xbbc177dc, 0xa4eabb0c} },},
/**/                 {{{0x3fd54000, 0x088b3814} },
/**/                  {{0x3fd61123, 0x564125f9} },
/**/                  {{0x400733be, 0x6281a765} },
/**/                  {{0xbbc2c52c, 0xf57051c4} },},
/**/                 {{{0x3fd57fff, 0xf7d55966} },
/**/                  {{0x3fd658d7, 0xe194a5d5} },
/**/                  {{0x4006e94b, 0x73b47d1f} },
/**/                  {{0x3bda2fcf, 0xf9996dc6} },},
/**/                 {{{0x3fd5c000, 0x08bf2490} },
/**/                  {{0x3fd6a0be, 0xb775b28d} },
/**/                  {{0x4006a07e, 0x15b6ec28} },
/**/                  {{0xbbe0ca90, 0xaa5285b8} },},
/**/                 {{{0x3fd60000, 0x09fa853f} },
/**/                  {{0x3fd6e8d8, 0x65a66cfd} },
/**/                  {{0x40065948, 0x1c701269} },
/**/                  {{0x3bd9ea95, 0x8591e13a} },},
/**/                 {{{0x3fd64000, 0x07595fca} },
/**/                  {{0x3fd73125, 0xc0556a7c} },
/**/                  {{0x4006139b, 0xbaae9d02} },
/**/                  {{0x3bd88aff, 0x40152b83} },},
/**/                 {{{0x3fd68000, 0x031687da} },
/**/                  {{0x3fd779a7, 0x92e2cfd0} },
/**/                  {{0x4005cf6b, 0xcae0882b} },
/**/                  {{0xbbd8a4a2, 0x9f439451} },},
/**/                 {{{0x3fd6bfff, 0xf5c8cfe2} },
/**/                  {{0x3fd7c25e, 0x9fb452ed} },
/**/                  {{0x40058cab, 0xc561f1cd} },
/**/                  {{0xbbe371a6, 0xf6a37d74} },},
/**/                 {{{0x3fd6ffff, 0xf81df231} },
/**/                  {{0x3fd80b4b, 0xcfb4dab5} },
/**/                  {{0x40054b4f, 0x8d3ca5d3} },
/**/                  {{0x3bcb4686, 0x679dc99f} },},
/**/                 {{{0x3fd73fff, 0xfa71385e} },
/**/                  {{0x3fd8546f, 0xe007a9b6} },
/**/                  {{0x40050b4b, 0xb3b22176} },
/**/                  {{0xbbcd1540, 0xa5c73477} },},
/**/                 {{{0x3fd78000, 0x024a9c2b} },
/**/                  {{0x3fd89dcb, 0xa7fcf5cf} },
/**/                  {{0x4004cc95, 0x3159cbe1} },
/**/                  {{0xbbdc25ea, 0xd58a6ad0} },},
/**/                 {{{0x3fd7c000, 0x02eb62b8} },
/**/                  {{0x3fd8e75f, 0xec0ba5cf} },
/**/                  {{0x40048f21, 0x8731eeea} },
/**/                  {{0xbbc1cb73, 0xcc1adafb} },},
/**/                 {{{0x3fd80000, 0x054a52d1} },
/**/                  {{0x3fd9312d, 0x8bb822e9} },
/**/                  {{0x400452e6, 0x9170a729} },
/**/                  {{0xbbd8bb17, 0xeac002ee} },},
/**/                 {{{0x3fd83fff, 0xf93a00a3} },
/**/                  {{0x3fd97b35, 0x4bb9ad2a} },
/**/                  {{0x400417da, 0xae924e7f} },
/**/                  {{0x3bd4b800, 0x9a378cc7} },},
/**/                 {{{0x3fd87fff, 0xfbdc91c1} },
/**/                  {{0x3fd9c578, 0x2771b601} },
/**/                  {{0x4003ddf4, 0x78855799} },
/**/                  {{0x3bd9077d, 0xa00445d9} },},
/**/                 {{{0x3fd8bfff, 0xf6d215e6} },
/**/                  {{0x3fda0ff6, 0xe0ea4a0b} },
/**/                  {{0x4003a52b, 0x189a0989} },
/**/                  {{0xbbda6831, 0x89c0613d} },},
/**/                 {{{0x3fd90000, 0x02f734ef} },
/**/                  {{0x3fda5ab2, 0x736bf579} },
/**/                  {{0x40036d75, 0xe9244ca6} },
/**/                  {{0x3be3a6d8, 0x4b722377} },},
/**/                 {{{0x3fd94000, 0x04eef8b4} },
/**/                  {{0x3fdaa5ab, 0x9fb6e3d0} },
/**/                  {{0x400336cc, 0xc9089cb7} },
/**/                  {{0x3b9f6963, 0x22cc00bb} },},
/**/                 {{{0x3fd98000, 0x041ec76a} },
/**/                  {{0x3fdaf0e3, 0x5176c7e4} },
/**/                  {{0x40030127, 0xcb0b9506} },
/**/                  {{0x3bb1ffdb, 0x5385a849} },},
/**/                 {{{0x3fd9c000, 0x08044e47} },
/**/                  {{0x3fdb3c5a, 0x77071224} },
/**/                  {{0x4002cc7f, 0x50d75ec7} },
/**/                  {{0xbbb0fade, 0x78effc8a} },},
/**/                 {{{0x3fda0000, 0x01f8235b} },
/**/                  {{0x3fdb8811, 0xe725782e} },
/**/                  {{0x400298cc, 0x18fbfb37} },
/**/                  {{0xbbe55ed3, 0x3b50e71b} },},
/**/                 {{{0x3fda3fff, 0xfb8c6f08} },
/**/                  {{0x3fdbd40a, 0x97b086f3} },
/**/                  {{0x40026607, 0x154de04b} },
/**/                  {{0xbbdec65e, 0x455faae3} },},
/**/                 {{{0x3fda7fff, 0xfb3d63e1} },
/**/                  {{0x3fdc2045, 0x7d9a3b8a} },
/**/                  {{0x40023429, 0x7e60bfbb} },
/**/                  {{0x3be3001c, 0x154ebd33} },},
/**/                 {{{0x3fdabfff, 0xf5f45c48} },
/**/                  {{0x3fdc6cc3, 0x7b8d45e6} },
/**/                  {{0x4002032c, 0xdb1ace69} },
/**/                  {{0xbbe5ebf8, 0x3ed33616} },},
/**/                 {{{0x3fdb0000, 0x0508b34c} },
/**/                  {{0x3fdcb985, 0xa27e8d37} },
/**/                  {{0x4001d30a, 0xd4459a2b} },
/**/                  {{0xbbd01432, 0xae61e2d1} },},
/**/                 {{{0x3fdb4000, 0x0a84710c} },
/**/                  {{0x3fdd068c, 0xc3e50155} },
/**/                  {{0x4001a3bd, 0x775034dd} },
/**/                  {{0xbbe80b1e, 0x58e0e228} },},
/**/                 {{{0x3fdb7fff, 0xf692e9d8} },
/**/                  {{0x3fdd53d9, 0xc49d6627} },
/**/                  {{0x4001753e, 0xfe18066a} },
/**/                  {{0xbbb004c8, 0xf760d33e} },},
/**/                 {{{0x3fdbc000, 0x0280f14d} },
/**/                  {{0x3fdda16d, 0xe4e81013} },
/**/                  {{0x40014789, 0xa38ea052} },
/**/                  {{0x3be848bc, 0x27c9c4ea} },},
/**/                 {{{0x3fdc0000, 0x001121d1} },
/**/                  {{0x3fddef49, 0xeac018f0} },
/**/                  {{0x40011a98, 0x20b8be0c} },
/**/                  {{0xbbe1527e, 0xd0d6010e} },},
/**/                 {{{0x3fdc3fff, 0xfef662aa} },
/**/                  {{0x3fde3d6e, 0xea0c7070} },
/**/                  {{0x4000ee65, 0x32f46ccd} },
/**/                  {{0x3be8d241, 0x189a000d} },},
/**/                 {{{0x3fdc8000, 0x09845818} },
/**/                  {{0x3fde8bdd, 0xf36a8b1b} },
/**/                  {{0x4000c2eb, 0xcac73476} },
/**/                  {{0x3bd221f7, 0x12bed284} },},
/**/                 {{{0x3fdcbfff, 0xfb0493bf} },
/**/                  {{0x3fdeda97, 0xe0c60d10} },
/**/                  {{0x40009827, 0x251c7836} },
/**/                  {{0xbbe0bd54, 0x6eec41b7} },},
/**/                 {{{0x3fdcffff, 0xfd52961f} },
/**/                  {{0x3fdf299d, 0xefb3e44b} },
/**/                  {{0x40006e12, 0x74e459f5} },
/**/                  {{0xbbd93f77, 0xe969c82f} },},
/**/                 {{{0x3fdd3fff, 0xfe2319a4} },
/**/                  {{0x3fdf78f1, 0x17139490} },
/**/                  {{0x400044a9, 0x3e737e94} },
/**/                  {{0xbb91e7cc, 0x49594b7a} },},
/**/                 {{{0x3fdd7fff, 0xfa4de596} },
/**/                  {{0x3fdfc892, 0x638f49e8} },
/**/                  {{0x40001be7, 0x231057a5} },
/**/                  {{0x3bd482b0, 0xf5af9f5f} },},
/**/                 {{{0x3fddbfff, 0xfe729a69} },
/**/                  {{0x3fe00c41, 0x7c6ab019} },
/**/                  {{0x3fffe78f, 0xbf612660} },
/**/                  {{0x3bea5cda, 0x00da681e} },},
/**/                 {{{0x3fde0000, 0x09d66802} },
/**/                  {{0x3fe03461, 0xf6b883cf} },
/**/                  {{0x3fff988e, 0xbc05a87c} },
/**/                  {{0xbbe06c33, 0xf2372669} },},
/**/                 {{{0x3fde3fff, 0xfb211657} },
/**/                  {{0x3fe05cab, 0x191db8e8} },
/**/                  {{0x3fff4ac3, 0x7bcfe6be} },
/**/                  {{0xbbd5d51f, 0x5ed8d35b} },},
/**/                 {{{0x3fde8000, 0x0a3f068a} },
/**/                  {{0x3fe0851d, 0x95fb54f0} },
/**/                  {{0x3ffefe26, 0x144ca408} },
/**/                  {{0xbbc7c894, 0xa2c169c5} },},
/**/                 {{{0x3fdec000, 0x01adb060} },
/**/                  {{0x3fe0adb9, 0xdc7b54f9} },
/**/                  {{0x3ffeb2af, 0x5ebe52a7} },
/**/                  {{0x3bd4e740, 0x312c5ffd} },},
/**/                 {{{0x3fdeffff, 0xff5c0d01} },
/**/                  {{0x3fe0d680, 0x92550a8d} },
/**/                  {{0x3ffe6858, 0x0d71fdf0} },
/**/                  {{0x3bddd8a6, 0x96b35499} },},
/**/                 {{{0x3fdf3fff, 0xf93d5fcc} },
/**/                  {{0x3fe0ff72, 0x45cb4374} },
/**/                  {{0x3ffe1f19, 0x3cce5040} },
/**/                  {{0xbbc9f0ec, 0x7c1efab4} },},
/**/                 {{{0x3fdf7fff, 0xfa0dd18f} },
/**/                  {{0x3fe1288f, 0x944dd508} },
/**/                  {{0x3ffdd6ec, 0x298b874d} },
/**/                  {{0x3bea6ebd, 0x9642a0a6} },},
/**/                 {{{0x3fdfbfff, 0xfd3a9f1a} },
/**/                  {{0x3fe151d9, 0x13750f3e} },
/**/                  {{0x3ffd8fca, 0x5806a27e} },
/**/                  {{0x3bda2a03, 0xfc65ac7a} },},
/**/                 {{{0x3fdfffff, 0xfc481400} },
/**/                  {{0x3fe17b4f, 0x598944ca} },
/**/                  {{0x3ffd49ad, 0x82532170} },
/**/                  {{0x3bc4412e, 0x3d236dc3} },},
/**/                 {{{0x3fe01fff, 0xff53786c} },
/**/                  {{0x3fe1a4f3, 0x07d83d47} },
/**/                  {{0x3ffd048f, 0x851bffeb} },
/**/                  {{0x3bd1589d, 0x29f81b14} },},
/**/                 {{{0x3fe03fff, 0xfee301b7} },
/**/                  {{0x3fe1cec4, 0xb8a6a382} },
/**/                  {{0x3ffcc06a, 0x7c519db6} },
/**/                  {{0x3bd370e6, 0x5b24d6b2} },},
/**/                 {{{0x3fe06000, 0x006e36bf} },
/**/                  {{0x3fe1f8c5, 0x114eb8be} },
/**/                  {{0x3ffc7d38, 0xa34d6786} },
/**/                  {{0xbbea92de, 0x4b98c1d4} },},
/**/                 {{{0x3fe07fff, 0xfd60aa43} },
/**/                  {{0x3fe222f4, 0xabeccecb} },
/**/                  {{0x3ffc3af4, 0x77342ac4} },
/**/                  {{0xbbdd47f6, 0x03a5c2c2} },},
/**/                 {{{0x3fe0a000, 0x037762e8} },
/**/                  {{0x3fe24d54, 0x3f99efe8} },
/**/                  {{0x3ffbf998, 0x75f54fab} },
/**/                  {{0x3bedf7f4, 0x15771a46} },},
/**/                 {{{0x3fe0bfff, 0xff1c6921} },
/**/                  {{0x3fe277e4, 0x598e35d0} },
/**/                  {{0x3ffbb91f, 0x8addd186} },
/**/                  {{0x3be0f16c, 0x5e0e5a73} },},
/**/                 {{{0x3fe0dfff, 0xff07154b} },
/**/                  {{0x3fe2a2a5, 0xb6bc3986} },
/**/                  {{0x3ffb7984, 0x8301646d} },
/**/                  {{0xbbf02dd0, 0xbbaa5310} },},
/**/                 {{{0x3fe10000, 0x02fcdda4} },
/**/                  {{0x3fe2cd99, 0x02a59f1e} },
/**/                  {{0x3ffb3ac2, 0x705219bf} },
/**/                  {{0xbbe59357, 0x112fa616} },},
/**/                 {{{0x3fe12000, 0x01ce1140} },
/**/                  {{0x3fe2f8be, 0xdf0a67c2} },
/**/                  {{0x3ffafcd4, 0x9ab8ae2a} },
/**/                  {{0x3be2c542, 0x9303f346} },},
/**/                 {{{0x3fe14000, 0x04d0f355} },
/**/                  {{0x3fe32418, 0x08fcc7bf} },
/**/                  {{0x3ffabfb6, 0x497b9a36} },
/**/                  {{0x3bebc044, 0xb5a59234} },},
/**/                 {{{0x3fe16000, 0x00fb0c8a} },
/**/                  {{0x3fe34fa5, 0x2471618b} },
/**/                  {{0x3ffa8363, 0x0d26d117} },
/**/                  {{0xbbdbfbb2, 0x3f7bb7c9} },},
/**/                 {{{0x3fe18000, 0x026f10b3} },
/**/                  {{0x3fe37b66, 0xf7579056} },
/**/                  {{0x3ffa47d6, 0x6b4cf4b1} },
/**/                  {{0x3bf0f6b4, 0xaf0b5de9} },},
/**/                 {{{0x3fe19fff, 0xfd0978f8} },
/**/                  {{0x3fe3a75e, 0x290cc78c} },
/**/                  {{0x3ffa0d0c, 0x36c21315} },
/**/                  {{0x3beb2129, 0xa296b262} },},
/**/                 {{{0x3fe1bfff, 0xfd94840b} },
/**/                  {{0x3fe3d38b, 0x85b4e4a4} },
/**/                  {{0x3ff9d300, 0x32f2ecef} },
/**/                  {{0xbbdbab1a, 0xb9bb7d74} },},
/**/                 {{{0x3fe1dfff, 0xfbda1ea1} },
/**/                  {{0x3fe3ffef, 0xbf3cee2f} },
/**/                  {{0x3ff999ae, 0x6770fed8} },
/**/                  {{0x3bda0bdc, 0xb4ace9a4} },},
/**/                 {{{0x3fe1ffff, 0xfc989533} },
/**/                  {{0x3fe42c8b, 0x9c27900c} },
/**/                  {{0x3ff96112, 0xe0d9f1ac} },
/**/                  {{0xbbee19eb, 0x2fa2d81a} },},
/**/                 {{{0x3fe22000, 0x012b8d26} },
/**/                  {{0x3fe4595f, 0xe11975ca} },
/**/                  {{0x3ff92929, 0xcdaa4e80} },
/**/                  {{0x3bf23382, 0xacc82d4b} },},
/**/                 {{{0x3fe24000, 0x04f4d6af} },
/**/                  {{0x3fe4866d, 0x4d224131} },
/**/                  {{0x3ff8f1ef, 0x815c34e8} },
/**/                  {{0xbbd0c6ff, 0x3b740a99} },},
/**/                 {{{0x3fe25fff, 0xfcc07bda} },
/**/                  {{0x3fe4b3b4, 0x98b7d010} },
/**/                  {{0x3ff8bb60, 0x73e7ffa1} },
/**/                  {{0x3bebc31b, 0x1ad7a9c2} },},
/**/                 {{{0x3fe28000, 0x042d9639} },
/**/                  {{0x3fe4e136, 0xb64540d1} },
/**/                  {{0x3ff88578, 0xf4374938} },
/**/                  {{0x3be36de9, 0x1b85e901} },},
/**/                 {{{0x3fe2a000, 0x03be29a0} },
/**/                  {{0x3fe50ef4, 0x52bffd96} },
/**/                  {{0x3ff85035, 0xc0042c06} },
/**/                  {{0x3be15d01, 0x76f5efbd} },},
/**/                 {{{0x3fe2bfff, 0xfaa91f12} },
/**/                  {{0x3fe53cee, 0x3e2f4e0d} },
/**/                  {{0x3ff81b93, 0x8542df07} },
/**/                  {{0x3be555cd, 0x17662a2b} },},
/**/                 {{{0x3fe2dfff, 0xfe884891} },
/**/                  {{0x3fe56b25, 0x6c1a2470} },
/**/                  {{0x3ff7e78e, 0xe422ea70} },
/**/                  {{0x3bf03504, 0xbd030c11} },},
/**/                 {{{0x3fe2ffff, 0xfe87152b} },
/**/                  {{0x3fe5999a, 0x9beaaaa1} },
/**/                  {{0x3ff7b424, 0xd18fe9b3} },
/**/                  {{0xbb649a5f, 0x773e0e64} },},
/**/                 {{{0x3fe31fff, 0xffc1a721} },
/**/                  {{0x3fe5c84e, 0xafe0e564} },
/**/                  {{0x3ff78152, 0x338db8d4} },
/**/                  {{0x3beaf428, 0x5da8e935} },},
/**/                 {{{0x3fe33fff, 0xff70a372} },
/**/                  {{0x3fe5f742, 0x82191d64} },
/**/                  {{0x3ff74f14, 0x1122bcae} },
/**/                  {{0x3bdb1c4b, 0xdee4bfaf} },},
/**/                 {{{0x3fe36000, 0x0436e836} },
/**/                  {{0x3fe62676, 0xfde6ccff} },
/**/                  {{0x3ff71d67, 0x7644252c} },
/**/                  {{0xbbec3d10, 0xe08c3afb} },},
/**/                 {{{0x3fe37fff, 0xfcbe9641} },
/**/                  {{0x3fe655ec, 0xee9ffdaf} },
/**/                  {{0x3ff6ec49, 0xa6fc0515} },
/**/                  {{0x3bdda453, 0x2ed29567} },},
/**/                 {{{0x3fe39fff, 0xffb6d6ca} },
/**/                  {{0x3fe685a5, 0x5e67a1e1} },
/**/                  {{0x3ff6bbb7, 0xbc2ae969} },
/**/                  {{0x3becbf7b, 0x2ef43882} },},
/**/                 {{{0x3fe3c000, 0x04934fec} },
/**/                  {{0x3fe6b5a1, 0x2cc07d75} },
/**/                  {{0x3ff68baf, 0x10b02ef8} },
/**/                  {{0xbbe7c8fb, 0xfeb7cabd} },},
/**/                 {{{0x3fe3e000, 0x03f5cf7f} },
/**/                  {{0x3fe6e5e1, 0x3e59def6} },
/**/                  {{0x3ff65c2d, 0x0e61500f} },
/**/                  {{0xbbe30ba4, 0x035f7845} },},
/**/                 {{{0x3fe40000, 0x05280ad9} },
/**/                  {{0x3fe71666, 0x91ab4c3e} },
/**/                  {{0x3ff62d2f, 0x19f01c90} },
/**/                  {{0xbbf1e9f5, 0xffe95f6a} },},
/**/                 {{{0x3fe42000, 0x049efb65} },
/**/                  {{0x3fe74732, 0x18af3b9d} },
/**/                  {{0x3ff5feb2, 0xb86465e4} },
/**/                  {{0x3bc4cad7, 0x280d591e} },},
/**/                 {{{0x3fe44000, 0x0035ccb6} },
/**/                  {{0x3fe77844, 0xcb4ff1e5} },
/**/                  {{0x3ff5d0b5, 0x7c455428} },
/**/                  {{0x3bed8c18, 0x7ba5617c} },},
/**/                 {{{0x3fe46000, 0x03346717} },
/**/                  {{0x3fe7a99f, 0xba258778} },
/**/                  {{0x3ff5a334, 0xf4392254} },
/**/                  {{0xbbefd14a, 0xfc84a570} },},
/**/                 {{{0x3fe48000, 0x03002575} },
/**/                  {{0x3fe7db43, 0xd836768f} },
/**/                  {{0x3ff5762e, 0xdcf97e0c} },
/**/                  {{0xbbdd7eba, 0x5f5df49e} },},
/**/                 {{{0x3fe4a000, 0x055bf381} },
/**/                  {{0x3fe80d32, 0x35edeefa} },
/**/                  {{0x3ff549a0, 0xea46e31f} },
/**/                  {{0xbbdba522, 0x76823eac} },},
/**/                 {{{0x3fe4c000, 0x04ce10e3} },
/**/                  {{0x3fe83f6b, 0xd67dc1a8} },
/**/                  {{0x3ff51d88, 0xed82bcc4} },
/**/                  {{0xbbeae92d, 0x077d29ea} },},
/**/                 {{{0x3fe4e000, 0x016c60e1} },
/**/                  {{0x3fe871f1, 0xca0aaf31} },
/**/                  {{0x3ff4f1e4, 0xbdacbf16} },
/**/                  {{0x3be82958, 0x46ee425e} },},
/**/                 {{{0x3fe4ffff, 0xff966f0a} },
/**/                  {{0x3fe8a4c5, 0x2bff2dae} },
/**/                  {{0x3ff4c6b2, 0x3917657e} },
/**/                  {{0xbbf127c2, 0x5c86c705} },},
/**/                 {{{0x3fe52000, 0x0076e6eb} },
/**/                  {{0x3fe8d7e7, 0x175651e8} },
/**/                  {{0x3ff49bef, 0x4f459b05} },
/**/                  {{0xbbb1e9d1, 0x4181bbfc} },},
/**/                 {{{0x3fe54000, 0x03d12d3b} },
/**/                  {{0x3fe90b58, 0xa976ed56} },
/**/                  {{0x3ff47199, 0xfdf24af4} },
/**/                  {{0x3be38c17, 0xc30decaf} },},
/**/                 {{{0x3fe55fff, 0xfce7fa8d} },
/**/                  {{0x3fe93f1a, 0xf03a3a09} },
/**/                  {{0x3ff447b0, 0x5f13234b} },
/**/                  {{0x3bf1b8b2, 0x70df7e20} },},
/**/                 {{{0x3fe58000, 0x0331b46a} },
/**/                  {{0x3fe9732f, 0x38e83134} },
/**/                  {{0x3ff41e30, 0x68d8b41b} },
/**/                  {{0xbbee24d8, 0xb90bc28b} },},
/**/                 {{{0x3fe59fff, 0xfc14848e} },
/**/                  {{0x3fe9a796, 0x8471b489} },
/**/                  {{0x3ff3f518, 0x5de3aa73} },
/**/                  {{0xbbecacd9, 0xe0761536} },},
/**/                 {{{0x3fe5bfff, 0xfb7cd395} },
/**/                  {{0x3fe9dc52, 0x24a8b955} },
/**/                  {{0x3ff3cc66, 0x4f8fff15} },
/**/                  {{0xbbf67c97, 0x82045611} },},
/**/                 {{{0x3fe5e000, 0x000dcc40} },
/**/                  {{0x3fea1163, 0x4df5b93e} },
/**/                  {{0x3ff3a418, 0x75853228} },
/**/                  {{0xbbf585da, 0xd481f350} },},
/**/                 {{{0x3fe60000, 0x02efd2fc} },
/**/                  {{0x3fea46cb, 0x30d16323} },
/**/                  {{0x3ff37c2d, 0x187962ae} },
/**/                  {{0x3bf004c3, 0xa5f77bb0} },},
/**/                 {{{0x3fe61fff, 0xfeb8088a} },
/**/                  {{0x3fea7c8b, 0x053920c0} },
/**/                  {{0x3ff354a2, 0x891769a9} },
/**/                  {{0x3bbc6b30, 0x3fee3029} },},
/**/                 {{{0x3fe64000, 0x00f3ca06} },
/**/                  {{0x3feab2a4, 0x28a1911a} },
/**/                  {{0x3ff32d77, 0x0a6f0a4a} },
/**/                  {{0x3bf2a6f8, 0xfac5081a} },},
/**/                 {{{0x3fe65fff, 0xfe9ec2f4} },
/**/                  {{0x3feae917, 0xd4ce7239} },
/**/                  {{0x3ff306a9, 0x0751a948} },
/**/                  {{0xbbe950b5, 0x51ab9dbd} },},
/**/                 {{{0x3fe68000, 0x03d43966} },
/**/                  {{0x3feb1fe7, 0x708b998a} },
/**/                  {{0x3ff2e036, 0xd7a153c7} },
/**/                  {{0x3bdd36e2, 0xa1e4a14e} },},
/**/                 {{{0x3fe69fff, 0xfab67783} },
/**/                  {{0x3feb5714, 0x2e575464} },
/**/                  {{0x3ff2ba1f, 0x05006cb6} },
/**/                  {{0x3bea9a4a, 0x473c2e31} },},
/**/                 {{{0x3fe6bfff, 0xfcb65f89} },
/**/                  {{0x3feb8e9f, 0x981efd2f} },
/**/                  {{0x3ff2945f, 0xe948d9f7} },
/**/                  {{0xbbca5294, 0xe802df72} },},
/**/                 {{{0x3fe6dfff, 0xfc5609a9} },
/**/                  {{0x3febc68a, 0xfaed6ff1} },
/**/                  {{0x3ff26ef8, 0x1533411e} },
/**/                  {{0xbbf89153, 0xf51bc566} },},
/**/                 {{{0x3fe6ffff, 0xfc4eef86} },
/**/                  {{0x3febfed7, 0xc62205fe} },
/**/                  {{0x3ff249e6, 0x0e70978c} },
/**/                  {{0x3bc39021, 0xa2b9ff56} },},
/**/                 {{{0x3fe72000, 0x004d98b3} },
/**/                  {{0x3fec3787, 0x716968ad} },
/**/                  {{0x3ff22528, 0x61be7751} },
/**/                  {{0x3befc9c5, 0x74ee2211} },},
/**/                 {{{0x3fe73fff, 0xfc155075} },
/**/                  {{0x3fec709b, 0x5ec6fd4e} },
/**/                  {{0x3ff200bd, 0xb5d53311} },
/**/                  {{0x3be28a4d, 0xa269ae63} },},
/**/                 {{{0x3fe76000, 0x0498c203} },
/**/                  {{0x3fecaa15, 0x323d08c1} },
/**/                  {{0x3ff1dca4, 0x93433f65} },
/**/                  {{0x3bf8cae4, 0x14a28fb7} },},
/**/                 {{{0x3fe77fff, 0xff1e5636} },
/**/                  {{0x3fece3f6, 0x4147c12c} },
/**/                  {{0x3ff1b8db, 0xbfe294a8} },
/**/                  {{0xbbe7e19c, 0x4b56a744} },},
/**/                 {{{0x3fe7a000, 0x0226d45a} },
/**/                  {{0x3fed1e40, 0x4120eb7f} },
/**/                  {{0x3ff19561, 0xd15f8278} },
/**/                  {{0x3be64b28, 0x032c5d4c} },},
/**/                 {{{0x3fe7c000, 0x0250a5aa} },
/**/                  {{0x3fed58f4, 0xb112a1e1} },
/**/                  {{0x3ff17235, 0x8a59d565} },
/**/                  {{0xbbe716de, 0xb8dc7867} },},
/**/                 {{{0x3fe7e000, 0x0482f82e} },
/**/                  {{0x3fed9415, 0x3576bdf0} },
/**/                  {{0x3ff14f55, 0xa22a1c5b} },
/**/                  {{0x3bf207e1, 0xe1305604} },},
/**/                 {{{0x3fe80000, 0x0205003e} },
/**/                  {{0x3fedcfa3, 0x64d69ff7} },
/**/                  {{0x3ff12cc0, 0xe37eb26f} },
/**/                  {{0xbbd52ec6, 0xe32395f8} },},
/**/                 {{{0x3fe81fff, 0xfbf99411} },
/**/                  {{0x3fee0ba0, 0xebf98f51} },
/**/                  {{0x3ff10a76, 0x16ddd5d6} },
/**/                  {{0xbbece0d6, 0x59866045} },},
/**/                 {{{0x3fe84000, 0x0248e3a3} },
/**/                  {{0x3fee480f, 0x9bb7f565} },
/**/                  {{0x3ff0e873, 0xfb84e05c} },
/**/                  {{0x3bf4e5e8, 0x1595df92} },},
/**/                 {{{0x3fe86000, 0x0145c157} },
/**/                  {{0x3fee84f1, 0x0a10b3ab} },
/**/                  {{0x3ff0c6b9, 0x7cbd7b1e} },
/**/                  {{0xbbe19de6, 0xd5f121d0} },},
/**/                 {{{0x3fe88000, 0x022631b9} },
/**/                  {{0x3feec247, 0x0be1f047} },
/**/                  {{0x3ff0a545, 0x6d0b3ee6} },
/**/                  {{0xbbc272b1, 0xa3ba2c6f} },},
/**/                 {{{0x3fe8a000, 0x045f7828} },
/**/                  {{0x3fef0013, 0x6c45ba1c} },
/**/                  {{0x3ff08416, 0xaf2a0f09} },
/**/                  {{0x3be82b56, 0x5b63c799} },},
/**/                 {{{0x3fe8bfff, 0xffc686cf} },
/**/                  {{0x3fef3e57, 0xf03c824b} },
/**/                  {{0x3ff0632c, 0x33502220} },
/**/                  {{0xbbd039ad, 0x2dbeeb25} },},
/**/                 {{{0x3fe8dfff, 0xfd8644c6} },
/**/                  {{0x3fef7d16, 0x8774261d} },
/**/                  {{0x3ff04284, 0xdd5b3019} },
/**/                  {{0x3bd79f33, 0xe1eba933} },},
/**/                 {{{0x3fe8ffff, 0xfe4e7937} },
/**/                  {{0x3fefbc51, 0x1a99a641} },
/**/                  {{0x3ff0221f, 0x9f69840b} },
/**/                  {{0xbbea9e84, 0x7beee018} },},
/**/                 {{{0x3fe92000, 0x0435251f} },
/**/                  {{0x3feffc09, 0x9eb22390} },
/**/                  {{0x3ff001fb, 0x6f7c51e8} },
/**/                  {{0xbb5a12e7, 0x31032e0a} },},
  };

#else
#ifdef LITTLE_ENDI
static const number
      xfg[186][4] = {                             /* xi,Fi,Gi,FFi, i=16..201 */
/**/                 {{{0x1e519d60, 0x3fb00000} },
/**/                  {{0x96c4e240, 0x3fb00557} },
/**/                  {{0x628127b7, 0x402ff554} },
/**/                  {{0x9e355b06, 0xbb9a1dee} },},
/**/                 {{{0x1b1a7010, 0x3fb10000} },
/**/                  {{0xaab892b7, 0x3fb10668} },
/**/                  {{0xbe3fdf74, 0x402e12c7} },
/**/                  {{0x037da741, 0x3ba89234} },},
/**/                 {{{0x2505e350, 0x3fb20000} },
/**/                  {{0xff547824, 0x3fb2079b} },
/**/                  {{0xde853633, 0x402c65c5} },
/**/                  {{0xe9614250, 0x3bb7486e} },},
/**/                 {{{0xfcdc4252, 0x3fb2ffff} },
/**/                  {{0x5eb16c68, 0x3fb308f3} },
/**/                  {{0xe56be74f, 0x402ae5da} },
/**/                  {{0x91a23034, 0xbb82c726} },},
/**/                 {{{0xe3ff849f, 0x3fb3ffff} },
/**/                  {{0x154999cc, 0x3fb40a71} },
/**/                  {{0x046b7352, 0x40298c43} },
/**/                  {{0x3843738f, 0x3b9aceaf} },},
/**/                 {{{0xedc9590f, 0x3fb4ffff} },
/**/                  {{0x429bdd80, 0x3fb50c17} },
/**/                  {{0x91b5d674, 0x40285384} },
/**/                  {{0xb4403d22, 0xbbc1d02d} },},
/**/                 {{{0x00ee83f7, 0x3fb60000} },
/**/                  {{0xda80cc21, 0x3fb60de7} },
/**/                  {{0xef21a2a7, 0x40273724} },
/**/                  {{0x72523ffd, 0xbb95e53c} },},
/**/                 {{{0xeb05ea41, 0x3fb6ffff} },
/**/                  {{0xb8c51bea, 0x3fb70fe4} },
/**/                  {{0xfae562ff, 0x40263370} },
/**/                  {{0x8ffe0626, 0xbb99ad0e} },},
/**/                 {{{0xdc0515f7, 0x3fb7ffff} },
/**/                  {{0x1db54498, 0x3fb81210} },
/**/                  {{0x0e7eab5c, 0x40254553} },
/**/                  {{0xd62ed686, 0xbb914c87} },},
/**/                 {{{0xe384d7ab, 0x3fb8ffff} },
/**/                  {{0x2a8d3727, 0x3fb9146c} },
/**/                  {{0xfd57f3fd, 0x40246a33} },
/**/                  {{0x5381e06d, 0xbbbbda8d} },},
/**/                 {{{0xe4832347, 0x3fb9ffff} },
/**/                  {{0xd50e1050, 0x3fba16fa} },
/**/                  {{0xc5537a96, 0x40239fe2} },
/**/                  {{0xc111eabb, 0x3bc7f695} },},
/**/                 {{{0x274540e3, 0x3fbb0000} },
/**/                  {{0x7ae68517, 0x3fbb19be} },
/**/                  {{0x3637e946, 0x4022e481} },
/**/                  {{0x8dbd9d93, 0x3bc307f8} },},
/**/                 {{{0xfebf2e9b, 0x3fbbffff} },
/**/                  {{0x8369cd19, 0x3fbc1cb8} },
/**/                  {{0x17aef223, 0x40223676} },
/**/                  {{0x424a9cf3, 0x3bc50038} },},
/**/                 {{{0x23529045, 0x3fbd0000} },
/**/                  {{0xc11d7ef7, 0x3fbd1feb} },
/**/                  {{0xb8e43d4e, 0x4021945f} },
/**/                  {{0x52a6f224, 0x3b812007} },},
/**/                 {{{0xd872a829, 0x3fbdffff} },
/**/                  {{0x8ee4d6b7, 0x3fbe2359} },
/**/                  {{0x76195d5f, 0x4020fd0c} },
/**/                  {{0x85fdca85, 0xbbb4d9ab} },},
/**/                 {{{0xff323b84, 0x3fbeffff} },
/**/                  {{0xec9073e5, 0x3fbf2704} },
/**/                  {{0x3020200f, 0x40206f71} },
/**/                  {{0x12836992, 0x3bb77aa2} },},
/**/                 {{{0x0ce79195, 0x3fc00000} },
/**/                  {{0xbc30cc61, 0x3fc01577} },
/**/                  {{0xd6564a88, 0x401fd549} },
/**/                  {{0x965c0ad0, 0xbbc8926f} },},
/**/                 {{{0xee40e918, 0x3fc07fff} },
/**/                  {{0x8279ac01, 0x3fc0978d} },
/**/                  {{0x9294bc03, 0x401edbb5} },
/**/                  {{0x4aae45d6, 0xbb80a533} },},
/**/                 {{{0x0cc091fd, 0x3fc10000} },
/**/                  {{0x44dfb2f7, 0x3fc119c5} },
/**/                  {{0x067d8e18, 0x401df0bb} },
/**/                  {{0x4ff642a4, 0xbbcc2c18} },},
/**/                 {{{0x0d9936a1, 0x3fc18000} },
/**/                  {{0xb9085a4b, 0x3fc19c1f} },
/**/                  {{0x71ce3629, 0x401d131a} },
/**/                  {{0x0669355b, 0xbbc36553} },},
/**/                 {{{0xed5f3188, 0x3fc1ffff} },
/**/                  {{0xee74bf2d, 0x3fc21e9d} },
/**/                  {{0xff0cd655, 0x401c41b6} },
/**/                  {{0x478ecfc5, 0x3b8867f5} },},
/**/                 {{{0x05f06a51, 0x3fc28000} },
/**/                  {{0x550b313f, 0x3fc2a141} },
/**/                  {{0x1702e6d2, 0x401b7b92} },
/**/                  {{0x380131fe, 0xbbadab51} },},
/**/                 {{{0xfe3d339e, 0x3fc2ffff} },
/**/                  {{0xa75f76df, 0x3fc3240a} },
/**/                  {{0xfcb6409d, 0x401abfc8} },
/**/                  {{0x0d291d83, 0x3bc60bcf} },},
/**/                 {{{0xed888d6f, 0x3fc37fff} },
/**/                  {{0x13cc5db7, 0x3fc3a6fb} },
/**/                  {{0x8ed5320d, 0x401a0d8f} },
/**/                  {{0x4eef03ab, 0x3bb8a48e} },},
/**/                 {{{0x02ca050d, 0x3fc40000} },
/**/                  {{0xe25776bb, 0x3fc42a13} },
/**/                  {{0xfa84c2bc, 0x4019642d} },
/**/                  {{0xcc56516f, 0xbbd0bd5d} },},
/**/                 {{{0xf2531f5c, 0x3fc47fff} },
/**/                  {{0xdeb73404, 0x3fc4ad55} },
/**/                  {{0xf86e9035, 0x4018c2fe} },
/**/                  {{0x5aa287c8, 0x3b9cffe7} },},
/**/                 {{{0x13774992, 0x3fc50000} },
/**/                  {{0x7d0ee307, 0x3fc530c2} },
/**/                  {{0x370caf35, 0x4018296c} },
/**/                  {{0xf91d6532, 0xbbcf75d1} },},
/**/                 {{{0xedddcb2d, 0x3fc57fff} },
/**/                  {{0x5db4347d, 0x3fc5b45a} },
/**/                  {{0x52190c0e, 0x401796ee} },
/**/                  {{0x17d5d076, 0x3b88a25f} },},
/**/                 {{{0xf41949a0, 0x3fc5ffff} },
/**/                  {{0x13bf986a, 0x3fc6381f} },
/**/                  {{0x2d2255fd, 0x40170b09} },
/**/                  {{0xb1bcd5e7, 0xbb9bfb23} },},
/**/                 {{{0xf834d3a1, 0x3fc67fff} },
/**/                  {{0x8ec85952, 0x3fc6bc11} },
/**/                  {{0x62cf2268, 0x4016854c} },
/**/                  {{0x82e39e04, 0x3b9ee53b} },},
/**/                 {{{0xfd9106ea, 0x3fc6ffff} },
/**/                  {{0xf298f6f7, 0x3fc74032} },
/**/                  {{0x1f4f84a9, 0x40160551} },
/**/                  {{0x112634b8, 0xbbb59c4a} },},
/**/                 {{{0x0f649a4f, 0x3fc78000} },
/**/                  {{0x6ca53abc, 0x3fc7c484} },
/**/                  {{0x4809d175, 0x40158ab9} },
/**/                  {{0x73d3cd2e, 0x3bc91c75} },},
/**/                 {{{0xef06bbd8, 0x3fc7ffff} },
/**/                  {{0xdf7d76ad, 0x3fc84906} },
/**/                  {{0xdd2b30a6, 0x4015152e} },
/**/                  {{0x084c3eef, 0xbbbfa2da} },},
/**/                 {{{0x021c6334, 0x3fc88000} },
/**/                  {{0xd965f986, 0x3fc8cdbb} },
/**/                  {{0x51b74296, 0x4014a462} },
/**/                  {{0x74dcfe0b, 0xbb9ec02e} },},
/**/                 {{{0xf38d0756, 0x3fc8ffff} },
/**/                  {{0x28e173c7, 0x3fc952a4} },
/**/                  {{0x17b59ebd, 0x4014380b} },
/**/                  {{0xb77589f0, 0xbbcd0f1c} },},
/**/                 {{{0x104efca1, 0x3fc98000} },
/**/                  {{0x4644d23c, 0x3fc9d7c1} },
/**/                  {{0xcb1eabd5, 0x4013cfe5} },
/**/                  {{0xea188d9e, 0xbbd5d6f7} },},
/**/                 {{{0x09417b30, 0x3fca0000} },
/**/                  {{0x096d76aa, 0x3fca5d14} },
/**/                  {{0xb3723db0, 0x40136bb4} },
/**/                  {{0xfbf3979c, 0x3bbe3e0d} },},
/**/                 {{{0xeb1c23ec, 0x3fca7fff} },
/**/                  {{0xab60288d, 0x3fcae29d} },
/**/                  {{0x783071d7, 0x40130b3e} },
/**/                  {{0x3d5384bf, 0xbbc7dd82} },},
/**/                 {{{0xfb171c13, 0x3fcaffff} },
/**/                  {{0xa221a96b, 0x3fcb685f} },
/**/                  {{0xd8c0747d, 0x4012ae4d} },
/**/                  {{0xd5554972, 0x3bd4644b} },},
/**/                 {{{0x0aba44be, 0x3fcb8000} },
/**/                  {{0xecdf241f, 0x3fcbee5a} },
/**/                  {{0xc6fad63b, 0x401254b1} },
/**/                  {{0xd092b85a, 0x3ba41916} },},
/**/                 {{{0x113d2a3e, 0x3fcc0000} },
/**/                  {{0xb3e92543, 0x3fcc7490} },
/**/                  {{0x9a62c035, 0x4011fe3c} },
/**/                  {{0x41a03739, 0xbba3cc39} },},
/**/                 {{{0xf49e00ce, 0x3fcc7fff} },
/**/                  {{0x0f59eab0, 0x3fccfb02} },
/**/                  {{0xe956a631, 0x4011aac3} },
/**/                  {{0xbfa8cb5b, 0xbbb7a383} },},
/**/                 {{{0x05f611ab, 0x3fcd0000} },
/**/                  {{0x89e6844e, 0x3fcd81b0} },
/**/                  {{0xf391268d, 0x40115a1f} },
/**/                  {{0xb2dc91f3, 0x3bd39b5c} },},
/**/                 {{{0x14764ceb, 0x3fcd8000} },
/**/                  {{0x27debf0d, 0x3fce089d} },
/**/                  {{0xfbc84740, 0x40110c2b} },
/**/                  {{0x84712510, 0x3bc14d4d} },},
/**/                 {{{0x14bcea76, 0x3fce0000} },
/**/                  {{0x16dbc820, 0x3fce8fc9} },
/**/                  {{0xa00ca48e, 0x4010c0c5} },
/**/                  {{0x640f1b9e, 0xbbd33788} },},
/**/                 {{{0xfd7995bd, 0x3fce7fff} },
/**/                  {{0x88b50424, 0x3fcf1735} },
/**/                  {{0xbe02169a, 0x401077cc} },
/**/                  {{0x221fdf77, 0xbbb61fee} },},
/**/                 {{{0x0cc35436, 0x3fcf0000} },
/**/                  {{0xfd21a40b, 0x3fcf9ee3} },
/**/                  {{0x1ee7ffe8, 0x40103123} },
/**/                  {{0xc79ff5c1, 0x3bd427e3} },},
/**/                 {{{0x01d1da33, 0x3fcf8000} },
/**/                  {{0xb7dbe15c, 0x3fd0136a} },
/**/                  {{0x77d559e5, 0x400fd959} },
/**/                  {{0xd67948d7, 0x3bb0c6a1} },},
/**/                 {{{0x060c13b2, 0x3fd00000} },
/**/                  {{0xaaad4f18, 0x3fd05785} },
/**/                  {{0x2675d182, 0x400f549e} },
/**/                  {{0x18f0dd10, 0xbbc15208} },},
/**/                 {{{0x03885492, 0x3fd04000} },
/**/                  {{0x660542d7, 0x3fd09bc3} },
/**/                  {{0xdf3f5fec, 0x400ed3e2} },
/**/                  {{0xb883ae62, 0xbbd95657} },},
/**/                 {{{0x052f5a13, 0x3fd08000} },
/**/                  {{0x9a195045, 0x3fd0e024} },
/**/                  {{0xfa68f2c8, 0x400e56f8} },
/**/                  {{0x5a543e8e, 0x3bded7ba} },},
/**/                 {{{0x02ba1af5, 0x3fd0c000} },
/**/                  {{0xe2e7f24b, 0x3fd124a9} },
/**/                  {{0xbffe633f, 0x400dddb4} },
/**/                  {{0x0c60278f, 0xbbdcba86} },},
/**/                 {{{0xf76642c1, 0x3fd0ffff} },
/**/                  {{0xe162ffe6, 0x3fd16953} },
/**/                  {{0x0311d5d5, 0x400d67ed} },
/**/                  {{0xe40c5f9e, 0x3b7b1f4a} },},
/**/                 {{{0x033602f0, 0x3fd14000} },
/**/                  {{0x5f49508e, 0x3fd1ae23} },
/**/                  {{0xb8708266, 0x400cf57a} },
/**/                  {{0x8620f301, 0xbbd6a6c2} },},
/**/                 {{{0xfefd1a13, 0x3fd17fff} },
/**/                  {{0xdb2a9ba1, 0x3fd1f318} },
/**/                  {{0x8d11009e, 0x400c8639} },
/**/                  {{0x69b21d3b, 0x3bd3a9c6} },},
/**/                 {{{0xf718365d, 0x3fd1bfff} },
/**/                  {{0x0c41e3ac, 0x3fd23835} },
/**/                  {{0xe02be47c, 0x400c1a06} },
/**/                  {{0x129e8cd1, 0x3bdb961a} },},
/**/                 {{{0xff001e00, 0x3fd1ffff} },
/**/                  {{0xb2f6395e, 0x3fd27d78} },
/**/                  {{0xf2fe9a85, 0x400bb0c1} },
/**/                  {{0xe68fd7d8, 0x3be074a9} },},
/**/                 {{{0xfe425a6a, 0x3fd23fff} },
/**/                  {{0x618faabe, 0x3fd2c2e4} },
/**/                  {{0x190b18df, 0x400b4a4c} },
/**/                  {{0xf615aad1, 0xbbdf0d1f} },},
/**/                 {{{0x059ec1db, 0x3fd28000} },
/**/                  {{0xd8583884, 0x3fd30878} },
/**/                  {{0x0cd82bc2, 0x400ae688} },
/**/                  {{0x141c1f8d, 0xbbd563c3} },},
/**/                 {{{0x000dd081, 0x3fd2c000} },
/**/                  {{0xaffdb6d8, 0x3fd34e36} },
/**/                  {{0x5270fc15, 0x400a855a} },
/**/                  {{0x9f2cdafd, 0xbbc6d88d} },},
/**/                 {{{0xfc1dcd2b, 0x3fd2ffff} },
/**/                  {{0xa95875bc, 0x3fd3941e} },
/**/                  {{0xaa9502b6, 0x400a26a8} },
/**/                  {{0x8389b15c, 0xbbe13cad} },},
/**/                 {{{0xf6c0d4a0, 0x3fd33fff} },
/**/                  {{0x739845f5, 0x3fd3da31} },
/**/                  {{0x4d2573a0, 0x4009ca5a} },
/**/                  {{0xacaee379, 0xbbc71636} },},
/**/                 {{{0x06b16793, 0x3fd38000} },
/**/                  {{0xdbc088f0, 0x3fd4206f} },
/**/                  {{0x9344e33a, 0x40097057} },
/**/                  {{0x1d7a4f81, 0xbbc2c052} },},
/**/                 {{{0x07358fa3, 0x3fd3c000} },
/**/                  {{0x6f23311d, 0x3fd466da} },
/**/                  {{0x5aa612ea, 0x4009188a} },
/**/                  {{0x685e8edc, 0x3b8653a5} },},
/**/                 {{{0xfc3b18cf, 0x3fd3ffff} },
/**/                  {{0xe9282e6b, 0x3fd4ad71} },
/**/                  {{0x641e643d, 0x4008c2dd} },
/**/                  {{0x3f567c64, 0x3b95f0ef} },},
/**/                 {{{0x000dd2a8, 0x3fd44000} },
/**/                  {{0x1fa3f2d1, 0x3fd4f437} },
/**/                  {{0x6072f821, 0x40086f3c} },
/**/                  {{0x95ff68b5, 0x3bb68efa} },},
/**/                 {{{0xfbb43713, 0x3fd47fff} },
/**/                  {{0xb3ac333c, 0x3fd53b2a} },
/**/                  {{0x3da56692, 0x40081d94} },
/**/                  {{0x2985fd3f, 0xbbbf4d7f} },},
/**/                 {{{0xfb113bf4, 0x3fd4bfff} },
/**/                  {{0x6e8ed9c2, 0x3fd5824d} },
/**/                  {{0xa8add00f, 0x4007cdd2} },
/**/                  {{0x1c9b3657, 0x3bcf478a} },},
/**/                 {{{0xf7f087c9, 0x3fd4ffff} },
/**/                  {{0x07446496, 0x3fd5c9a0} },
/**/                  {{0x444588eb, 0x40077fe6} },
/**/                  {{0xa4eabb0c, 0xbbc177dc} },},
/**/                 {{{0x088b3814, 0x3fd54000} },
/**/                  {{0x564125f9, 0x3fd61123} },
/**/                  {{0x6281a765, 0x400733be} },
/**/                  {{0xf57051c4, 0xbbc2c52c} },},
/**/                 {{{0xf7d55966, 0x3fd57fff} },
/**/                  {{0xe194a5d5, 0x3fd658d7} },
/**/                  {{0x73b47d1f, 0x4006e94b} },
/**/                  {{0xf9996dc6, 0x3bda2fcf} },},
/**/                 {{{0x08bf2490, 0x3fd5c000} },
/**/                  {{0xb775b28d, 0x3fd6a0be} },
/**/                  {{0x15b6ec28, 0x4006a07e} },
/**/                  {{0xaa5285b8, 0xbbe0ca90} },},
/**/                 {{{0x09fa853f, 0x3fd60000} },
/**/                  {{0x65a66cfd, 0x3fd6e8d8} },
/**/                  {{0x1c701269, 0x40065948} },
/**/                  {{0x8591e13a, 0x3bd9ea95} },},
/**/                 {{{0x07595fca, 0x3fd64000} },
/**/                  {{0xc0556a7c, 0x3fd73125} },
/**/                  {{0xbaae9d02, 0x4006139b} },
/**/                  {{0x40152b83, 0x3bd88aff} },},
/**/                 {{{0x031687da, 0x3fd68000} },
/**/                  {{0x92e2cfd0, 0x3fd779a7} },
/**/                  {{0xcae0882b, 0x4005cf6b} },
/**/                  {{0x9f439451, 0xbbd8a4a2} },},
/**/                 {{{0xf5c8cfe2, 0x3fd6bfff} },
/**/                  {{0x9fb452ed, 0x3fd7c25e} },
/**/                  {{0xc561f1cd, 0x40058cab} },
/**/                  {{0xf6a37d74, 0xbbe371a6} },},
/**/                 {{{0xf81df231, 0x3fd6ffff} },
/**/                  {{0xcfb4dab5, 0x3fd80b4b} },
/**/                  {{0x8d3ca5d3, 0x40054b4f} },
/**/                  {{0x679dc99f, 0x3bcb4686} },},
/**/                 {{{0xfa71385e, 0x3fd73fff} },
/**/                  {{0xe007a9b6, 0x3fd8546f} },
/**/                  {{0xb3b22176, 0x40050b4b} },
/**/                  {{0xa5c73477, 0xbbcd1540} },},
/**/                 {{{0x024a9c2b, 0x3fd78000} },
/**/                  {{0xa7fcf5cf, 0x3fd89dcb} },
/**/                  {{0x3159cbe1, 0x4004cc95} },
/**/                  {{0xd58a6ad0, 0xbbdc25ea} },},
/**/                 {{{0x02eb62b8, 0x3fd7c000} },
/**/                  {{0xec0ba5cf, 0x3fd8e75f} },
/**/                  {{0x8731eeea, 0x40048f21} },
/**/                  {{0xcc1adafb, 0xbbc1cb73} },},
/**/                 {{{0x054a52d1, 0x3fd80000} },
/**/                  {{0x8bb822e9, 0x3fd9312d} },
/**/                  {{0x9170a729, 0x400452e6} },
/**/                  {{0xeac002ee, 0xbbd8bb17} },},
/**/                 {{{0xf93a00a3, 0x3fd83fff} },
/**/                  {{0x4bb9ad2a, 0x3fd97b35} },
/**/                  {{0xae924e7f, 0x400417da} },
/**/                  {{0x9a378cc7, 0x3bd4b800} },},
/**/                 {{{0xfbdc91c1, 0x3fd87fff} },
/**/                  {{0x2771b601, 0x3fd9c578} },
/**/                  {{0x78855799, 0x4003ddf4} },
/**/                  {{0xa00445d9, 0x3bd9077d} },},
/**/                 {{{0xf6d215e6, 0x3fd8bfff} },
/**/                  {{0xe0ea4a0b, 0x3fda0ff6} },
/**/                  {{0x189a0989, 0x4003a52b} },
/**/                  {{0x89c0613d, 0xbbda6831} },},
/**/                 {{{0x02f734ef, 0x3fd90000} },
/**/                  {{0x736bf579, 0x3fda5ab2} },
/**/                  {{0xe9244ca6, 0x40036d75} },
/**/                  {{0x4b722377, 0x3be3a6d8} },},
/**/                 {{{0x04eef8b4, 0x3fd94000} },
/**/                  {{0x9fb6e3d0, 0x3fdaa5ab} },
/**/                  {{0xc9089cb7, 0x400336cc} },
/**/                  {{0x22cc00bb, 0x3b9f6963} },},
/**/                 {{{0x041ec76a, 0x3fd98000} },
/**/                  {{0x5176c7e4, 0x3fdaf0e3} },
/**/                  {{0xcb0b9506, 0x40030127} },
/**/                  {{0x5385a849, 0x3bb1ffdb} },},
/**/                 {{{0x08044e47, 0x3fd9c000} },
/**/                  {{0x77071224, 0x3fdb3c5a} },
/**/                  {{0x50d75ec7, 0x4002cc7f} },
/**/                  {{0x78effc8a, 0xbbb0fade} },},
/**/                 {{{0x01f8235b, 0x3fda0000} },
/**/                  {{0xe725782e, 0x3fdb8811} },
/**/                  {{0x18fbfb37, 0x400298cc} },
/**/                  {{0x3b50e71b, 0xbbe55ed3} },},
/**/                 {{{0xfb8c6f08, 0x3fda3fff} },
/**/                  {{0x97b086f3, 0x3fdbd40a} },
/**/                  {{0x154de04b, 0x40026607} },
/**/                  {{0x455faae3, 0xbbdec65e} },},
/**/                 {{{0xfb3d63e1, 0x3fda7fff} },
/**/                  {{0x7d9a3b8a, 0x3fdc2045} },
/**/                  {{0x7e60bfbb, 0x40023429} },
/**/                  {{0x154ebd33, 0x3be3001c} },},
/**/                 {{{0xf5f45c48, 0x3fdabfff} },
/**/                  {{0x7b8d45e6, 0x3fdc6cc3} },
/**/                  {{0xdb1ace69, 0x4002032c} },
/**/                  {{0x3ed33616, 0xbbe5ebf8} },},
/**/                 {{{0x0508b34c, 0x3fdb0000} },
/**/                  {{0xa27e8d37, 0x3fdcb985} },
/**/                  {{0xd4459a2b, 0x4001d30a} },
/**/                  {{0xae61e2d1, 0xbbd01432} },},
/**/                 {{{0x0a84710c, 0x3fdb4000} },
/**/                  {{0xc3e50155, 0x3fdd068c} },
/**/                  {{0x775034dd, 0x4001a3bd} },
/**/                  {{0x58e0e228, 0xbbe80b1e} },},
/**/                 {{{0xf692e9d8, 0x3fdb7fff} },
/**/                  {{0xc49d6627, 0x3fdd53d9} },
/**/                  {{0xfe18066a, 0x4001753e} },
/**/                  {{0xf760d33e, 0xbbb004c8} },},
/**/                 {{{0x0280f14d, 0x3fdbc000} },
/**/                  {{0xe4e81013, 0x3fdda16d} },
/**/                  {{0xa38ea052, 0x40014789} },
/**/                  {{0x27c9c4ea, 0x3be848bc} },},
/**/                 {{{0x001121d1, 0x3fdc0000} },
/**/                  {{0xeac018f0, 0x3fddef49} },
/**/                  {{0x20b8be0c, 0x40011a98} },
/**/                  {{0xd0d6010e, 0xbbe1527e} },},
/**/                 {{{0xfef662aa, 0x3fdc3fff} },
/**/                  {{0xea0c7070, 0x3fde3d6e} },
/**/                  {{0x32f46ccd, 0x4000ee65} },
/**/                  {{0x189a000d, 0x3be8d241} },},
/**/                 {{{0x09845818, 0x3fdc8000} },
/**/                  {{0xf36a8b1b, 0x3fde8bdd} },
/**/                  {{0xcac73476, 0x4000c2eb} },
/**/                  {{0x12bed284, 0x3bd221f7} },},
/**/                 {{{0xfb0493bf, 0x3fdcbfff} },
/**/                  {{0xe0c60d10, 0x3fdeda97} },
/**/                  {{0x251c7836, 0x40009827} },
/**/                  {{0x6eec41b7, 0xbbe0bd54} },},
/**/                 {{{0xfd52961f, 0x3fdcffff} },
/**/                  {{0xefb3e44b, 0x3fdf299d} },
/**/                  {{0x74e459f5, 0x40006e12} },
/**/                  {{0xe969c82f, 0xbbd93f77} },},
/**/                 {{{0xfe2319a4, 0x3fdd3fff} },
/**/                  {{0x17139490, 0x3fdf78f1} },
/**/                  {{0x3e737e94, 0x400044a9} },
/**/                  {{0x49594b7a, 0xbb91e7cc} },},
/**/                 {{{0xfa4de596, 0x3fdd7fff} },
/**/                  {{0x638f49e8, 0x3fdfc892} },
/**/                  {{0x231057a5, 0x40001be7} },
/**/                  {{0xf5af9f5f, 0x3bd482b0} },},
/**/                 {{{0xfe729a69, 0x3fddbfff} },
/**/                  {{0x7c6ab019, 0x3fe00c41} },
/**/                  {{0xbf612660, 0x3fffe78f} },
/**/                  {{0x00da681e, 0x3bea5cda} },},
/**/                 {{{0x09d66802, 0x3fde0000} },
/**/                  {{0xf6b883cf, 0x3fe03461} },
/**/                  {{0xbc05a87c, 0x3fff988e} },
/**/                  {{0xf2372669, 0xbbe06c33} },},
/**/                 {{{0xfb211657, 0x3fde3fff} },
/**/                  {{0x191db8e8, 0x3fe05cab} },
/**/                  {{0x7bcfe6be, 0x3fff4ac3} },
/**/                  {{0x5ed8d35b, 0xbbd5d51f} },},
/**/                 {{{0x0a3f068a, 0x3fde8000} },
/**/                  {{0x95fb54f0, 0x3fe0851d} },
/**/                  {{0x144ca408, 0x3ffefe26} },
/**/                  {{0xa2c169c5, 0xbbc7c894} },},
/**/                 {{{0x01adb060, 0x3fdec000} },
/**/                  {{0xdc7b54f9, 0x3fe0adb9} },
/**/                  {{0x5ebe52a7, 0x3ffeb2af} },
/**/                  {{0x312c5ffd, 0x3bd4e740} },},
/**/                 {{{0xff5c0d01, 0x3fdeffff} },
/**/                  {{0x92550a8d, 0x3fe0d680} },
/**/                  {{0x0d71fdf0, 0x3ffe6858} },
/**/                  {{0x96b35499, 0x3bddd8a6} },},
/**/                 {{{0xf93d5fcc, 0x3fdf3fff} },
/**/                  {{0x45cb4374, 0x3fe0ff72} },
/**/                  {{0x3cce5040, 0x3ffe1f19} },
/**/                  {{0x7c1efab4, 0xbbc9f0ec} },},
/**/                 {{{0xfa0dd18f, 0x3fdf7fff} },
/**/                  {{0x944dd508, 0x3fe1288f} },
/**/                  {{0x298b874d, 0x3ffdd6ec} },
/**/                  {{0x9642a0a6, 0x3bea6ebd} },},
/**/                 {{{0xfd3a9f1a, 0x3fdfbfff} },
/**/                  {{0x13750f3e, 0x3fe151d9} },
/**/                  {{0x5806a27e, 0x3ffd8fca} },
/**/                  {{0xfc65ac7a, 0x3bda2a03} },},
/**/                 {{{0xfc481400, 0x3fdfffff} },
/**/                  {{0x598944ca, 0x3fe17b4f} },
/**/                  {{0x82532170, 0x3ffd49ad} },
/**/                  {{0x3d236dc3, 0x3bc4412e} },},
/**/                 {{{0xff53786c, 0x3fe01fff} },
/**/                  {{0x07d83d47, 0x3fe1a4f3} },
/**/                  {{0x851bffeb, 0x3ffd048f} },
/**/                  {{0x29f81b14, 0x3bd1589d} },},
/**/                 {{{0xfee301b7, 0x3fe03fff} },
/**/                  {{0xb8a6a382, 0x3fe1cec4} },
/**/                  {{0x7c519db6, 0x3ffcc06a} },
/**/                  {{0x5b24d6b2, 0x3bd370e6} },},
/**/                 {{{0x006e36bf, 0x3fe06000} },
/**/                  {{0x114eb8be, 0x3fe1f8c5} },
/**/                  {{0xa34d6786, 0x3ffc7d38} },
/**/                  {{0x4b98c1d4, 0xbbea92de} },},
/**/                 {{{0xfd60aa43, 0x3fe07fff} },
/**/                  {{0xabeccecb, 0x3fe222f4} },
/**/                  {{0x77342ac4, 0x3ffc3af4} },
/**/                  {{0x03a5c2c2, 0xbbdd47f6} },},
/**/                 {{{0x037762e8, 0x3fe0a000} },
/**/                  {{0x3f99efe8, 0x3fe24d54} },
/**/                  {{0x75f54fab, 0x3ffbf998} },
/**/                  {{0x15771a46, 0x3bedf7f4} },},
/**/                 {{{0xff1c6921, 0x3fe0bfff} },
/**/                  {{0x598e35d0, 0x3fe277e4} },
/**/                  {{0x8addd186, 0x3ffbb91f} },
/**/                  {{0x5e0e5a73, 0x3be0f16c} },},
/**/                 {{{0xff07154b, 0x3fe0dfff} },
/**/                  {{0xb6bc3986, 0x3fe2a2a5} },
/**/                  {{0x8301646d, 0x3ffb7984} },
/**/                  {{0xbbaa5310, 0xbbf02dd0} },},
/**/                 {{{0x02fcdda4, 0x3fe10000} },
/**/                  {{0x02a59f1e, 0x3fe2cd99} },
/**/                  {{0x705219bf, 0x3ffb3ac2} },
/**/                  {{0x112fa616, 0xbbe59357} },},
/**/                 {{{0x01ce1140, 0x3fe12000} },
/**/                  {{0xdf0a67c2, 0x3fe2f8be} },
/**/                  {{0x9ab8ae2a, 0x3ffafcd4} },
/**/                  {{0x9303f346, 0x3be2c542} },},
/**/                 {{{0x04d0f355, 0x3fe14000} },
/**/                  {{0x08fcc7bf, 0x3fe32418} },
/**/                  {{0x497b9a36, 0x3ffabfb6} },
/**/                  {{0xb5a59234, 0x3bebc044} },},
/**/                 {{{0x00fb0c8a, 0x3fe16000} },
/**/                  {{0x2471618b, 0x3fe34fa5} },
/**/                  {{0x0d26d117, 0x3ffa8363} },
/**/                  {{0x3f7bb7c9, 0xbbdbfbb2} },},
/**/                 {{{0x026f10b3, 0x3fe18000} },
/**/                  {{0xf7579056, 0x3fe37b66} },
/**/                  {{0x6b4cf4b1, 0x3ffa47d6} },
/**/                  {{0xaf0b5de9, 0x3bf0f6b4} },},
/**/                 {{{0xfd0978f8, 0x3fe19fff} },
/**/                  {{0x290cc78c, 0x3fe3a75e} },
/**/                  {{0x36c21315, 0x3ffa0d0c} },
/**/                  {{0xa296b262, 0x3beb2129} },},
/**/                 {{{0xfd94840b, 0x3fe1bfff} },
/**/                  {{0x85b4e4a4, 0x3fe3d38b} },
/**/                  {{0x32f2ecef, 0x3ff9d300} },
/**/                  {{0xb9bb7d74, 0xbbdbab1a} },},
/**/                 {{{0xfbda1ea1, 0x3fe1dfff} },
/**/                  {{0xbf3cee2f, 0x3fe3ffef} },
/**/                  {{0x6770fed8, 0x3ff999ae} },
/**/                  {{0xb4ace9a4, 0x3bda0bdc} },},
/**/                 {{{0xfc989533, 0x3fe1ffff} },
/**/                  {{0x9c27900c, 0x3fe42c8b} },
/**/                  {{0xe0d9f1ac, 0x3ff96112} },
/**/                  {{0x2fa2d81a, 0xbbee19eb} },},
/**/                 {{{0x012b8d26, 0x3fe22000} },
/**/                  {{0xe11975ca, 0x3fe4595f} },
/**/                  {{0xcdaa4e80, 0x3ff92929} },
/**/                  {{0xacc82d4b, 0x3bf23382} },},
/**/                 {{{0x04f4d6af, 0x3fe24000} },
/**/                  {{0x4d224131, 0x3fe4866d} },
/**/                  {{0x815c34e8, 0x3ff8f1ef} },
/**/                  {{0x3b740a99, 0xbbd0c6ff} },},
/**/                 {{{0xfcc07bda, 0x3fe25fff} },
/**/                  {{0x98b7d010, 0x3fe4b3b4} },
/**/                  {{0x73e7ffa1, 0x3ff8bb60} },
/**/                  {{0x1ad7a9c2, 0x3bebc31b} },},
/**/                 {{{0x042d9639, 0x3fe28000} },
/**/                  {{0xb64540d1, 0x3fe4e136} },
/**/                  {{0xf4374938, 0x3ff88578} },
/**/                  {{0x1b85e901, 0x3be36de9} },},
/**/                 {{{0x03be29a0, 0x3fe2a000} },
/**/                  {{0x52bffd96, 0x3fe50ef4} },
/**/                  {{0xc0042c06, 0x3ff85035} },
/**/                  {{0x76f5efbd, 0x3be15d01} },},
/**/                 {{{0xfaa91f12, 0x3fe2bfff} },
/**/                  {{0x3e2f4e0d, 0x3fe53cee} },
/**/                  {{0x8542df07, 0x3ff81b93} },
/**/                  {{0x17662a2b, 0x3be555cd} },},
/**/                 {{{0xfe884891, 0x3fe2dfff} },
/**/                  {{0x6c1a2470, 0x3fe56b25} },
/**/                  {{0xe422ea70, 0x3ff7e78e} },
/**/                  {{0xbd030c11, 0x3bf03504} },},
/**/                 {{{0xfe87152b, 0x3fe2ffff} },
/**/                  {{0x9beaaaa1, 0x3fe5999a} },
/**/                  {{0xd18fe9b3, 0x3ff7b424} },
/**/                  {{0x773e0e64, 0xbb649a5f} },},
/**/                 {{{0xffc1a721, 0x3fe31fff} },
/**/                  {{0xafe0e564, 0x3fe5c84e} },
/**/                  {{0x338db8d4, 0x3ff78152} },
/**/                  {{0x5da8e935, 0x3beaf428} },},
/**/                 {{{0xff70a372, 0x3fe33fff} },
/**/                  {{0x82191d64, 0x3fe5f742} },
/**/                  {{0x1122bcae, 0x3ff74f14} },
/**/                  {{0xdee4bfaf, 0x3bdb1c4b} },},
/**/                 {{{0x0436e836, 0x3fe36000} },
/**/                  {{0xfde6ccff, 0x3fe62676} },
/**/                  {{0x7644252c, 0x3ff71d67} },
/**/                  {{0xe08c3afb, 0xbbec3d10} },},
/**/                 {{{0xfcbe9641, 0x3fe37fff} },
/**/                  {{0xee9ffdaf, 0x3fe655ec} },
/**/                  {{0xa6fc0515, 0x3ff6ec49} },
/**/                  {{0x2ed29567, 0x3bdda453} },},
/**/                 {{{0xffb6d6ca, 0x3fe39fff} },
/**/                  {{0x5e67a1e1, 0x3fe685a5} },
/**/                  {{0xbc2ae969, 0x3ff6bbb7} },
/**/                  {{0x2ef43882, 0x3becbf7b} },},
/**/                 {{{0x04934fec, 0x3fe3c000} },
/**/                  {{0x2cc07d75, 0x3fe6b5a1} },
/**/                  {{0x10b02ef8, 0x3ff68baf} },
/**/                  {{0xfeb7cabd, 0xbbe7c8fb} },},
/**/                 {{{0x03f5cf7f, 0x3fe3e000} },
/**/                  {{0x3e59def6, 0x3fe6e5e1} },
/**/                  {{0x0e61500f, 0x3ff65c2d} },
/**/                  {{0x035f7845, 0xbbe30ba4} },},
/**/                 {{{0x05280ad9, 0x3fe40000} },
/**/                  {{0x91ab4c3e, 0x3fe71666} },
/**/                  {{0x19f01c90, 0x3ff62d2f} },
/**/                  {{0xffe95f6a, 0xbbf1e9f5} },},
/**/                 {{{0x049efb65, 0x3fe42000} },
/**/                  {{0x18af3b9d, 0x3fe74732} },
/**/                  {{0xb86465e4, 0x3ff5feb2} },
/**/                  {{0x280d591e, 0x3bc4cad7} },},
/**/                 {{{0x0035ccb6, 0x3fe44000} },
/**/                  {{0xcb4ff1e5, 0x3fe77844} },
/**/                  {{0x7c455428, 0x3ff5d0b5} },
/**/                  {{0x7ba5617c, 0x3bed8c18} },},
/**/                 {{{0x03346717, 0x3fe46000} },
/**/                  {{0xba258778, 0x3fe7a99f} },
/**/                  {{0xf4392254, 0x3ff5a334} },
/**/                  {{0xfc84a570, 0xbbefd14a} },},
/**/                 {{{0x03002575, 0x3fe48000} },
/**/                  {{0xd836768f, 0x3fe7db43} },
/**/                  {{0xdcf97e0c, 0x3ff5762e} },
/**/                  {{0x5f5df49e, 0xbbdd7eba} },},
/**/                 {{{0x055bf381, 0x3fe4a000} },
/**/                  {{0x35edeefa, 0x3fe80d32} },
/**/                  {{0xea46e31f, 0x3ff549a0} },
/**/                  {{0x76823eac, 0xbbdba522} },},
/**/                 {{{0x04ce10e3, 0x3fe4c000} },
/**/                  {{0xd67dc1a8, 0x3fe83f6b} },
/**/                  {{0xed82bcc4, 0x3ff51d88} },
/**/                  {{0x077d29ea, 0xbbeae92d} },},
/**/                 {{{0x016c60e1, 0x3fe4e000} },
/**/                  {{0xca0aaf31, 0x3fe871f1} },
/**/                  {{0xbdacbf16, 0x3ff4f1e4} },
/**/                  {{0x46ee425e, 0x3be82958} },},
/**/                 {{{0xff966f0a, 0x3fe4ffff} },
/**/                  {{0x2bff2dae, 0x3fe8a4c5} },
/**/                  {{0x3917657e, 0x3ff4c6b2} },
/**/                  {{0x5c86c705, 0xbbf127c2} },},
/**/                 {{{0x0076e6eb, 0x3fe52000} },
/**/                  {{0x175651e8, 0x3fe8d7e7} },
/**/                  {{0x4f459b05, 0x3ff49bef} },
/**/                  {{0x4181bbfc, 0xbbb1e9d1} },},
/**/                 {{{0x03d12d3b, 0x3fe54000} },
/**/                  {{0xa976ed56, 0x3fe90b58} },
/**/                  {{0xfdf24af4, 0x3ff47199} },
/**/                  {{0xc30decaf, 0x3be38c17} },},
/**/                 {{{0xfce7fa8d, 0x3fe55fff} },
/**/                  {{0xf03a3a09, 0x3fe93f1a} },
/**/                  {{0x5f13234b, 0x3ff447b0} },
/**/                  {{0x70df7e20, 0x3bf1b8b2} },},
/**/                 {{{0x0331b46a, 0x3fe58000} },
/**/                  {{0x38e83134, 0x3fe9732f} },
/**/                  {{0x68d8b41b, 0x3ff41e30} },
/**/                  {{0xb90bc28b, 0xbbee24d8} },},
/**/                 {{{0xfc14848e, 0x3fe59fff} },
/**/                  {{0x8471b489, 0x3fe9a796} },
/**/                  {{0x5de3aa73, 0x3ff3f518} },
/**/                  {{0xe0761536, 0xbbecacd9} },},
/**/                 {{{0xfb7cd395, 0x3fe5bfff} },
/**/                  {{0x24a8b955, 0x3fe9dc52} },
/**/                  {{0x4f8fff15, 0x3ff3cc66} },
/**/                  {{0x82045611, 0xbbf67c97} },},
/**/                 {{{0x000dcc40, 0x3fe5e000} },
/**/                  {{0x4df5b93e, 0x3fea1163} },
/**/                  {{0x75853228, 0x3ff3a418} },
/**/                  {{0xd481f350, 0xbbf585da} },},
/**/                 {{{0x02efd2fc, 0x3fe60000} },
/**/                  {{0x30d16323, 0x3fea46cb} },
/**/                  {{0x187962ae, 0x3ff37c2d} },
/**/                  {{0xa5f77bb0, 0x3bf004c3} },},
/**/                 {{{0xfeb8088a, 0x3fe61fff} },
/**/                  {{0x053920c0, 0x3fea7c8b} },
/**/                  {{0x891769a9, 0x3ff354a2} },
/**/                  {{0x3fee3029, 0x3bbc6b30} },},
/**/                 {{{0x00f3ca06, 0x3fe64000} },
/**/                  {{0x28a1911a, 0x3feab2a4} },
/**/                  {{0x0a6f0a4a, 0x3ff32d77} },
/**/                  {{0xfac5081a, 0x3bf2a6f8} },},
/**/                 {{{0xfe9ec2f4, 0x3fe65fff} },
/**/                  {{0xd4ce7239, 0x3feae917} },
/**/                  {{0x0751a948, 0x3ff306a9} },
/**/                  {{0x51ab9dbd, 0xbbe950b5} },},
/**/                 {{{0x03d43966, 0x3fe68000} },
/**/                  {{0x708b998a, 0x3feb1fe7} },
/**/                  {{0xd7a153c7, 0x3ff2e036} },
/**/                  {{0xa1e4a14e, 0x3bdd36e2} },},
/**/                 {{{0xfab67783, 0x3fe69fff} },
/**/                  {{0x2e575464, 0x3feb5714} },
/**/                  {{0x05006cb6, 0x3ff2ba1f} },
/**/                  {{0x473c2e31, 0x3bea9a4a} },},
/**/                 {{{0xfcb65f89, 0x3fe6bfff} },
/**/                  {{0x981efd2f, 0x3feb8e9f} },
/**/                  {{0xe948d9f7, 0x3ff2945f} },
/**/                  {{0xe802df72, 0xbbca5294} },},
/**/                 {{{0xfc5609a9, 0x3fe6dfff} },
/**/                  {{0xfaed6ff1, 0x3febc68a} },
/**/                  {{0x1533411e, 0x3ff26ef8} },
/**/                  {{0xf51bc566, 0xbbf89153} },},
/**/                 {{{0xfc4eef86, 0x3fe6ffff} },
/**/                  {{0xc62205fe, 0x3febfed7} },
/**/                  {{0x0e70978c, 0x3ff249e6} },
/**/                  {{0xa2b9ff56, 0x3bc39021} },},
/**/                 {{{0x004d98b3, 0x3fe72000} },
/**/                  {{0x716968ad, 0x3fec3787} },
/**/                  {{0x61be7751, 0x3ff22528} },
/**/                  {{0x74ee2211, 0x3befc9c5} },},
/**/                 {{{0xfc155075, 0x3fe73fff} },
/**/                  {{0x5ec6fd4e, 0x3fec709b} },
/**/                  {{0xb5d53311, 0x3ff200bd} },
/**/                  {{0xa269ae63, 0x3be28a4d} },},
/**/                 {{{0x0498c203, 0x3fe76000} },
/**/                  {{0x323d08c1, 0x3fecaa15} },
/**/                  {{0x93433f65, 0x3ff1dca4} },
/**/                  {{0x14a28fb7, 0x3bf8cae4} },},
/**/                 {{{0xff1e5636, 0x3fe77fff} },
/**/                  {{0x4147c12c, 0x3fece3f6} },
/**/                  {{0xbfe294a8, 0x3ff1b8db} },
/**/                  {{0x4b56a744, 0xbbe7e19c} },},
/**/                 {{{0x0226d45a, 0x3fe7a000} },
/**/                  {{0x4120eb7f, 0x3fed1e40} },
/**/                  {{0xd15f8278, 0x3ff19561} },
/**/                  {{0x032c5d4c, 0x3be64b28} },},
/**/                 {{{0x0250a5aa, 0x3fe7c000} },
/**/                  {{0xb112a1e1, 0x3fed58f4} },
/**/                  {{0x8a59d565, 0x3ff17235} },
/**/                  {{0xb8dc7867, 0xbbe716de} },},
/**/                 {{{0x0482f82e, 0x3fe7e000} },
/**/                  {{0x3576bdf0, 0x3fed9415} },
/**/                  {{0xa22a1c5b, 0x3ff14f55} },
/**/                  {{0xe1305604, 0x3bf207e1} },},
/**/                 {{{0x0205003e, 0x3fe80000} },
/**/                  {{0x64d69ff7, 0x3fedcfa3} },
/**/                  {{0xe37eb26f, 0x3ff12cc0} },
/**/                  {{0xe32395f8, 0xbbd52ec6} },},
/**/                 {{{0xfbf99411, 0x3fe81fff} },
/**/                  {{0xebf98f51, 0x3fee0ba0} },
/**/                  {{0x16ddd5d6, 0x3ff10a76} },
/**/                  {{0x59866045, 0xbbece0d6} },},
/**/                 {{{0x0248e3a3, 0x3fe84000} },
/**/                  {{0x9bb7f565, 0x3fee480f} },
/**/                  {{0xfb84e05c, 0x3ff0e873} },
/**/                  {{0x1595df92, 0x3bf4e5e8} },},
/**/                 {{{0x0145c157, 0x3fe86000} },
/**/                  {{0x0a10b3ab, 0x3fee84f1} },
/**/                  {{0x7cbd7b1e, 0x3ff0c6b9} },
/**/                  {{0xd5f121d0, 0xbbe19de6} },},
/**/                 {{{0x022631b9, 0x3fe88000} },
/**/                  {{0x0be1f047, 0x3feec247} },
/**/                  {{0x6d0b3ee6, 0x3ff0a545} },
/**/                  {{0xa3ba2c6f, 0xbbc272b1} },},
/**/                 {{{0x045f7828, 0x3fe8a000} },
/**/                  {{0x6c45ba1c, 0x3fef0013} },
/**/                  {{0xaf2a0f09, 0x3ff08416} },
/**/                  {{0x5b63c799, 0x3be82b56} },},
/**/                 {{{0xffc686cf, 0x3fe8bfff} },
/**/                  {{0xf03c824b, 0x3fef3e57} },
/**/                  {{0x33502220, 0x3ff0632c} },
/**/                  {{0x2dbeeb25, 0xbbd039ad} },},
/**/                 {{{0xfd8644c6, 0x3fe8dfff} },
/**/                  {{0x8774261d, 0x3fef7d16} },
/**/                  {{0xdd5b3019, 0x3ff04284} },
/**/                  {{0xe1eba933, 0x3bd79f33} },},
/**/                 {{{0xfe4e7937, 0x3fe8ffff} },
/**/                  {{0x1a99a641, 0x3fefbc51} },
/**/                  {{0x9f69840b, 0x3ff0221f} },
/**/                  {{0x7beee018, 0xbbea9e84} },},
/**/                 {{{0x0435251f, 0x3fe92000} },
/**/                  {{0x9eb22390, 0x3feffc09} },
/**/                  {{0x6f7c51e8, 0x3ff001fb} },
/**/                  {{0x31032e0a, 0xbb5a12e7} },},
  };

#endif
#endif
