/* Title:   tbevent.c
 * Purpose: dispatching toolbox events.
 * Author:  IDJ
 * History: 19-Jun-94: IDJ:   created
 *          16-Dec-00:  TV:   bug fix in deregister_toolbox_handler
 *                            changed event_code from int to bits
 *          15-jun-00: TV     Fixed bug causing crash if handler deregisters itself
 */
/*
      OSLibSupport is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

      OSLibSupport is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
   along with this programme; if not, write to the Free Software
   Foundation, Inc, 675 Mass Ave, Cambridge, MA 02139, U S A.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "oslib/messagetrans.h"

#include "Tbevent.h"
// #include "trace.h"
// #include "riscos.h"	// yuk - TV 970707
//#include "X.h"

static event_toolbox_handler_item *Handlers[256];

static event_toolbox_handler_item *All_Handlers = 0;

static int Hash (int word)

{  /* hashing algorithm: add ascending bytes, with carry, and use lower byte as result */

   int temp = (word & 0xff) + (word >> 8 & 0xff) + (word >> 16 & 0xff) +
         (word >> 24 & 0xff);

   return temp + (temp >> 8) & 0xff;
}

#define MATCHES(h, object_id, event_code, handler, handle) \
            h->object_id == (object_id)\
            && h->event_code == (event_code)\
            && h->handler == (handler)\
            && h->handle == (handle)


/* ------------------------------------ dispatching toolbox events -------------------------------- */

static int Matches(  bits event_code,
                     event_toolbox_handler_item *h,
                     toolbox_block *id_block
                  )
{
    /*
     * first look to see if interested in all objects of all classes,
     * then interest in this object.
     */

    if ( h->event_code != event_code && h->event_code != action_ANY )
        return 0;

    if ( h->object_id == event_ANY )      /* all objects */
        return 1;
    else if ( h->object_id == id_block->this_obj )    /* this object */
        return 1;

    return 0;
}


#if 0    // TV 20010615
         // If the current handler de-registers itself,
         // then the link to the next handler disappears -- *crash*
static osbool Call (event_toolbox_handler_item *h,
                  wimp_block *poll_block,
                  toolbox_block *id_block
                 )
{
   toolbox_action *action = (toolbox_action *) poll_block->reserved;

   for (; h != NULL; h = h->next)
      if (  Matches (action->action_no, h, id_block) &&
            h->handler != NULL
         )
      {
//         tracef ("call the handler: id_block 0x%X\n" _ id_block);
         if (  h->handler (   action->action_no,
                              action,
                              id_block,
                              h->handle))
            return TRUE;
      }

   return FALSE;
}
#else
static osbool Call (event_toolbox_handler_item *h,
                  wimp_block *poll_block,
                  toolbox_block *id_block
                 )
{
   toolbox_action *action = (toolbox_action *) poll_block->reserved;

   osbool claimed = FALSE;

   while( !claimed && h != NULL )
   {
      event_toolbox_handler_item *h1 = h;
      h = h -> next;

      if (  Matches (action->action_no, h1, id_block) &&
            h1->handler != NULL
         )
      {
//         tracef ("call the handler: id_block 0x%X\n" _ id_block);
         claimed = h1 ->handler( action->action_no,
                                 action,
                                 id_block,
                                 h1->handle
                               );
      }
   }

   return claimed;
}
#endif

extern void tbevent_dispatch (wimp_block *poll_block,
                              toolbox_block *id_block
                             )
{
   toolbox_action *action = (toolbox_action *) poll_block->reserved;

//   tracef ("tbevent_dispatch\n");
//   tracef ("id_block 0x%X\n" _ id_block);

   if (  !Call( Handlers [Hash (action->action_no)],
                poll_block,
                id_block
              )
      )
      Call( All_Handlers, poll_block, id_block  );
}


/* -------------------------- registering handlers for toolbox events ------------------------------
** returns FALSE if out of memory
*/

osbool tbevent_register_toolbox_handler(  toolbox_o object_id,
                                          bits event_code,
                                          event_toolbox_handler *handler,
                                          void *handle
                                       )
{
   event_toolbox_handler_item *h, *new_h;
   int elem;
   osbool done = FALSE;
    /*
     * start looking down the linked list which hangs off the array element for this toolbox event
     */

    elem = Hash(event_code);

    if (event_code == action_ANY)
        h =  All_Handlers;
    else
        h = Handlers[elem];

    while (h != NULL)
    {
        /*
         * if there's already a handler, just return.
         */

        if (MATCHES (h, object_id, event_code, handler, handle))
            return TRUE;

        h = h->next;
    }

    /*
     * make a new entry in the list for this event
     */

//   new_h = x_ALLOC (sizeof *new_h);
   new_h = malloc (sizeof *new_h);
   if( new_h )
   {
      new_h->object_id  = object_id;
      new_h->event_code = event_code;
      new_h->handler    = handler;
      new_h->handle     = handle;

      if (event_code == action_ANY )
      {
         new_h->next           = All_Handlers;
         All_Handlers = new_h;
      }
      else
      {
         new_h->next             = Handlers[elem];
         Handlers[elem] = new_h;
      }
      done = TRUE;
   }
   return done;
}



/* --------------------------- deregistering toolbox event handlers --------------------------------- */

void tbevent_deregister_toolbox_handler(  toolbox_o object_id,
                                          bits event_code,
                                          event_toolbox_handler *handler,
                                          void *handle
                                       )
{
    event_toolbox_handler_item *h, *prev_h;
    event_toolbox_handler_item **listhead;
    int                      elem;

    /*
     * see if handler registered, and if so delete it.
     */

    /*
     * start looking down the linked list which hangs off the array element for this event
     */

#if 0    /* TV 001216 Bug fixes by Dave Lawrence <DLAWRENC@uk.ibm.com> */
    elem = Hash(event_code);

    if (event_code == -1)
    {
        h = prev_h = Handlers[elem];
        listhead   = &Handlers[elem];
    }
    else
    {
        h = prev_h = All_Handlers;
        listhead   = &All_Handlers;
    }
#else

    if (event_code != -1)
    {
        elem = Hash(event_code);

        h = prev_h = Handlers[elem];
        listhead   = &Handlers[elem];
    }
    else
    {
        h = prev_h = All_Handlers;
        listhead   = &All_Handlers;
    }
#endif

    while (h != NULL)
    {
        /*
         * see if there's a handler, which matches.
         */

        if (MATCHES (h, object_id, event_code, handler, handle))
            break;

        prev_h = h;
        h = h->next;
    }


    /*
     * delete the handler from the list
     */

    if (h != NULL)
    {
        if (h == *listhead)
            *listhead = h->next;
        else
            prev_h->next = h->next;

//#if TRACE
//            x_FREE (h, sizeof *h);
//#else
            free(h);
//#endif
    }
}
