#ifndef tbevent_H
#define tbevent_H

/* Title:   tbevent.c
 * Purpose: dispatching toolbox events.
 * Author:  IDJ
 * History: 19-Jun-94: IDJ: created
 *
 */
/*
      OSLibSupport is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

      OSLibSupport is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
   along with this programme; if not, write to the Free Software
   Foundation, Inc, 675 Mass Ave, Cambridge, MA 02139, U S A.
*/

#ifndef os_H
#include "oslib/os.h"
#endif

#ifndef wimp_H
#include "oslib/wimp.h"
#endif

#ifndef toolbox_H
#include "oslib/toolbox.h"
#endif

#ifndef event_H
#include "Event.h"
#endif

extern void tbevent_dispatch (wimp_block *block, toolbox_block *id_block);

extern osbool tbevent_register_toolbox_handler( toolbox_o,
                                                bits event_code,
                                                event_toolbox_handler *handler,
                                                void *handle
                                              );

extern void tbevent_deregister_toolbox_handler( toolbox_o,
                                                bits event_code,
                                                event_toolbox_handler *handler,
                                                void *handle
                                              );

#endif
