#ifndef messagetrans_H
#define messagetrans_H

/*OSLib---efficient, type-safe, transparent, extensible,\n"
   register-safe API coverage of RISC OS*/
/*Copyright (c) 1994 Jonathan Coxhead*/

/*
      OSLib is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

      OSLib is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
   along with this programme; if not, write to the Free Software
   Foundation, Inc, 675 Mass Ave, Cambridge, MA 02139, U S A.
*/

#include <kernel.h>
#include <swis.h>

#ifndef types_H
   #include "oslib/types.h"
#endif

#ifndef os_H
#include "oslib/os.h"
#endif

#define messagetrans_DIRECT_ACCESS (1 << 0)

typedef struct {int cb [4];} messagetrans_control_block;

#ifdef EXECUTE_ON_UNIX
/* ------------------------------------------------------------------------
 * Function:      messagetrans_error_lookup()
 *
 * Description:   Translates a message token within an error block
 *
 * Input:         error - value of R0 on entry
 *                cb - value of R1 on entry
 *                buffer - value of R2 on entry
 *                size - value of R3 on entry
 *                arg0 - value of R4 on entry
 *                arg1 - value of R5 on entry
 *                arg2 - value of R6 on entry
 *                arg3 - value of R7 on entry
 *
 * Other notes:   Calls SWI 0x41506.
 */

extern os_error *xmessagetrans_error_lookup (os_error const *error,
      messagetrans_control_block const *cb,
      os_error *buffer,
      int size,
      char const *arg0,
      char const *arg1,
      char const *arg2,
      char const *arg3);

extern void messagetrans_error_lookup (os_error const *error,
      messagetrans_control_block const *cb,
      os_error *buffer,
      int size,
      char const *arg0,
      char const *arg1,
      char const *arg2,
      char const *arg3);

#else /* EXECUTE_ON_UNIX */

#define xmessagetrans_file_info(file_name, flags, size) \
  (os_error *)_swix (MessageTrans_FileInfo, _IN (1) | _OUT (0) | _OUT (2), \
      (char *) (file_name), (int *) (flags), (int *) (size))

#define xmessagetrans_open_file(cb, file_name, buffer) \
  (os_error *)_swix (MessageTrans_OpenFile, _IN (0) | _IN (1) | _IN (2), \
      (messagetrans_control_block *) (cb), (char *) (file_name), \
      (char *) (buffer))

#define xmessagetrans_lookup(cb, token, buffer, size_in, arg0, arg1, arg2, \
      arg3, result, size_out) \
  (os_error *)_swix (MessageTrans_Lookup, _IN (0) | _IN (1) | _IN (2) | _IN (3) | \
      _IN (4) | _IN (5) | _IN (6) | _IN (7) | _OUT (2) | _OUT (3), \
      (messagetrans_control_block *) (cb), (char *) (token), \
      (char *) (buffer), (int) (size_in), (char *) (arg0), \
      (char *) (arg1), (char *) (arg2), (char *) (arg3), \
      (char **) (result), (int *) (size_out))

#define xmessagetrans_make_menus(cb, menus, buffer, size_in, size_out) \
  (os_error *)_swix (MessageTrans_MakeMenus, _IN (0) | _IN (1) | _IN (2) | _IN (3) | \
      _OUT (3), \
      (messagetrans_control_block *) (cb), (char *) (menus), \
      (char *) (buffer), (int) (size_in), (int *) (size_out))

#define xmessagetrans_close_file(cb) \
  (os_error *)_swix (MessageTrans_CloseFile, _IN (0), \
      (messagetrans_control_block *) (cb))

#define xmessagetrans_enumerate_tokens(cb, token, buffer, size, index, \
      cont, size_out, index_out) \
   (os_error *)_swix (MessageTrans_EnumerateTokens, \
         _IN (0) | _IN (1) | _IN (2) | _IN (3) | _IN (4) | \
         _OUT (2) | _OUT (3) | _OUT (4), \
         (messagetrans_control_block *) (cb), (char *) (token), \
         (char *) (buffer), (int) (size), (int) (index), \
         (osbool *) (cont), (int *) (size_out), (int *) (index_out))

#define xmessagetrans_error_lookup(error, cb, buffer, size_in, arg0, arg1, \
      arg2, arg3) \
  (os_error *)_swix (MessageTrans_ErrorLookup, _IN (0) | _IN (1) | _IN (2) | _IN (3) | \
      _IN (4) | _IN (5) | _IN (6) | _IN (7), \
      (_kernel_oserror *) (error), (messagetrans_control_block *) (cb), \
      (char *) (buffer), (int) (size_in), (char *) (arg0), \
      (char *) (arg1), (char *) (arg2), (char *) (arg3))

#define messagetrans_error_lookup(error, cb, buffer, size_in, arg0, arg1, \
      arg2, arg3) \
  _swi (MessageTrans_ErrorLookup, _IN (0) | _IN (1) | _IN (2) | _IN (3) | \
      _IN (4) | _IN (5) | _IN (6) | _IN (7), \
      (_kernel_oserror *) (error), (messagetrans_control_block *) (cb), \
      (char *) (buffer), (int) (size_in), (char *) (arg0), \
      (char *) (arg1), (char *) (arg2), (char *) (arg3))

#define xmessagetrans_gs_lookup(cb, token, buffer, size_in, arg0, arg1, \
      arg2, arg3, result, size_out) \
  (os_error *)_swix (MessageTrans_GSLookup, _IN (0) | _IN (1) | _IN (2) | _IN (3) | \
      _IN (4) | _IN (5) | _IN (6) | _IN (7) | _OUT (2)  | _OUT (3), \
      (messagetrans_control_block *) (cb), (char *) (token), \
      (char *) (buffer), (int) (size_in), (char *) (arg0), \
      (char *) (arg1), (char *) (arg2), (char *) (arg3), \
      (char **) (result), (int *) (size_out))

#define xmessagetrans_copy_error(error, copy) \
   (os_error *)_swix (MessageTrans_CopyError, _IN (0) | _OUT (0), \
      (os_error *) (error), (os_error **) (copy))

#endif /* EXECUTE_ON_UNIX */

#endif
