#ifndef osmodule_H
#define osmodule_H

/*OSLib---efficient, type-safe, transparent, extensible,\n"
   register-safe API coverage of RISC OS*/
/*Copyright (c) 1994 Jonathan Coxhead*/

/*
      OSLib is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

      OSLib is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
   along with this programme; if not, write to the Free Software
   Foundation, Inc, 675 Mass Ave, Cambridge, MA 02139, U S A.
*/

#ifndef types_H
   #include "types.h"
#endif

#ifndef os_H
   #include "os.h"
#endif

#define OSModule_Alloc 0x6
#define OSModule_Free 0x7
#define OSModule_Realloc 0xD

#define xosmodule_alloc(size, ptr) \
   (os_error *)_swix (OSModule_Alloc, _IN (3) | _OUT (2), \
         (int) (size), (void *) (ptr))

#define osmodule_free(ptr) \
   _swi (OSModule_Free, _IN (2), (ptr))

#define xosmodule_realloc(ptr, size, ptr_out) \
   (os_error *)_swix (OSModule_Realloc, _IN (2) | _IN (3) | _OUT (2), \
          (void *) (ptr), (int) (size), (void **) (ptr_out))

#endif
