#ifndef osspriteop_H
#define osspriteop_H

/*OSLib---efficient, type-safe, transparent, extensible,\n"
   register-safe API coverage of RISC OS*/
/*Copyright (c) 1994 Jonathan Coxhead*/

/*
      OSLib is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

      OSLib is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
   along with this programme; if not, write to the Free Software
   Foundation, Inc, 675 Mass Ave, Cambridge, MA 02139, U S A.
*/

#if !defined types_H
   #include "types.h"
#endif

#ifndef os_H
   #include "os.h"
#endif

#define OSSpriteOp_ScreenSave             2
#define OSSpriteOp_ScreenLoad             3
#define OSSpriteOp_ReadAreaCB             8
#define OSSpriteOp_ClearSprites           9
#define OSSpriteOp_LoadSpriteFile        10
#define OSSpriteOp_MergeSpriteFile       11
#define OSSpriteOp_SaveSpriteFile        12
#define OSSpriteOp_ReturnName            13
#define OSSpriteOp_GetSprite             14
#define OSSpriteOp_CreateSprite          15
#define OSSpriteOp_GetSpriteUserCoords   16
#define OSSpriteOp_SelectSprite          24
#define OSSpriteOp_DeleteSprite          25
#define OSSpriteOp_RenameSprite          26
#define OSSpriteOp_CopySprite            27
#define OSSpriteOp_PutSprite             28
#define OSSpriteOp_CreateMask            29
#define OSSpriteOp_RemoveMask            30
#define OSSpriteOp_InsertRow             31
#define OSSpriteOp_DeleteRow             32
#define OSSpriteOp_FlipAboutXAxis        33
#define OSSpriteOp_PutSpriteUserCoords   34
#define OSSpriteOp_AppendSprite          35
#define OSSpriteOp_SetPointerShape       36
#define OSSpriteOp_CreateRemovePalette   37
#define OSSpriteOp_ReadSpriteSize        40
#define OSSpriteOp_ReadPixelColour       41
#define OSSpriteOp_WritePixelColour      42
#define OSSpriteOp_ReadPixelMask         43
#define OSSpriteOp_WritePixelMask        44
#define OSSpriteOp_InsertColumn          45
#define OSSpriteOp_DeleteColumn          46
#define OSSpriteOp_FlipAboutYAxis        47
#define OSSpriteOp_PlotMask              48
#define OSSpriteOp_PlotMaskUserCoords    49
#define OSSpriteOp_PlotMaskScaled        50
#define OSSpriteOp_PaintCharScaled       51
#define OSSpriteOp_PutSpriteScaled       52
#define OSSpriteOp_PutSpriteGreyScaled   53
#define OSSpriteOp_RemoveLeftHandWastage 54
#define OSSpriteOp_PlotMaskTrfm          55
#define OSSpriteOp_PutSpriteTrfm         56
#define OSSpriteOp_InsertDeleteRows      57
#define OSSpriteOp_InsertDeleteColumns   58
#define OSSpriteOp_SwitchOutputToSprite  60
#define OSSpriteOp_SwitchOutputToMask    61
#define OSSpriteOp_ReadSaveAreaSize      62

#define osspriteop_NAME_LIMIT            12
#define osspriteop_SYSTEM_AREA           0
#define osspriteop_USER_AREA             (1 << 8)
#define osspriteop_NAME                  (1 << 8) /*=> in user area*/
#define osspriteop_PTR                   (1 << 9) /*=> in user area*/

#define osspriteop_TRFM_COORDS     (1U << 0)
#define osspriteop_GIVEN_RECTANGLE (1U << 1)

typedef byte *osspriteop_id;

typedef struct {int x_mul; int y_mul; int x_div; int y_div;} osspriteop_factors;
typedef struct {char c [UNKNOWN];} osspriteop_trans_tab;
typedef struct {int size; int sprite_count; int first; int used;}
      osspriteop_area;
typedef struct {int size; char name [osspriteop_NAME_LIMIT]; int width;
      int height; int left_bit; int right_bit; int image; int mask; int mode;}
      osspriteop_header;
typedef void *osspriteop_ptr;

#define xosspriteop_screen_save(file_name, palette_flag) \
   (os_error *)_swix (OS_SpriteOp, _IN (0) | _IN (2) | _IN (3), \
         OSSpriteOp_ScreenSave, (char *) (file_name), (osbool) (palette_flag))

#define xosspriteop_screen_load() ...

#define xosspriteop_read_area_cb(bits, area, size, no, first, free) \
   (os_error *)_swix (OS_SpriteOp, \
         _IN (0) | _IN (1) | _OUT (2) | _OUT (3) | _OUT (4) | _OUT (5), \
         OSSpriteOp_ReadAreaCB | (int) (bits), (osspriteop_area *) (area), \
         (int *) (size), (int *) (no), (int *) (first), (int *) (free))

#define xosspriteop_clear_sprites() ...

#define xosspriteop_load_sprite_file(bits, area, file_name) \
   (os_error *)_swix (OS_SpriteOp, _IN (0) | _IN (1) | _IN (2), \
         OSSpriteOp_LoadSpriteFile | (int) (bits), (osspriteop_area *) (area), \
         (char *) (file_name))

#define xosspriteop_merge_sprite_file(bits, area, file_name) \
   (os_error *)_swix (OS_SpriteOp, _IN (0) | _IN (1) | _IN (2), \
         OSSpriteOp_MergeSpriteFile | (int) (bits), (osspriteop_area *) (area), \
         (char *) (file_name))

#define xosspriteop_save_sprite_file(bits, area, file_name) \
   (os_error *)_swix (OS_SpriteOp, _IN (0) | _IN (1) | _IN (2), \
         OSSpriteOp_SaveSpriteFile | (int) (bits), (osspriteop_area *) (area), \
         (char *) (file_name))

#define xosspriteop_return_name(bits, area, name, len, no, len_out) \
   (os_error *)_swix (OS_SpriteOp, \
         _IN (0) | _IN (1) | _IN (2) | _IN (3) | _IN (4) |  _OUT (3), \
         OSSpriteOp_ReturnName | (int) (bits), (osspriteop_area *) (area), \
         (char *) (name), (int) (len), (int) (no), (int *) (len_out))

#define xosspriteop_get_sprite() ...

#define xosspriteop_create_sprite() ...

#define xosspriteop_get_sprite_user_coords() ...

#define xosspriteop_select_sprite(bits, area, ptr, header) \
   (os_error *)_swix (OS_SpriteOp, \
         _IN (0) | _IN (1) | _IN (2) | _OUT (2), \
         OSSpriteOp_SelectSprite | (int) (bits), (osspriteop_area *) (area), \
         (void *) (ptr), (osspriteop_header **) (header))

#define xosspriteop_delete_sprite() ...

#define xosspriteop_rename_rprite() ...

#define xosspriteop_copy_sprite() ...

#define xosspriteop_put_sprite() ...

#define xosspriteop_create_mask() ...

#define xosspriteop_remove_mask() ...

#define xosspriteop_insert_row() ...

#define xosspriteop_delete_row() ...

#define xosspriteop_flip_about_x_axis() ...

#define xosspriteop_put_sprite_user_coords() ...

#define xosspriteop_append_sprite() ...

#define xosspriteop_set_pointer_shape() ...

#define xosspriteop_create_remove_palette() ...

#define xosspriteop_read_sprite_size(bits, area, ptr, width, height, mask, mode) \
   (os_error *)_swix (OS_SpriteOp, \
         _IN (0) | _IN (1) | _IN (2) | _OUT (3) | _OUT (4) | _OUT (5) | \
         _OUT (6), \
         OSSpriteOp_ReadSpriteSize | (int) (bits), (osspriteop_area *) (area), \
         (void *) (ptr), (int *) (width), (int *) (height), (osbool *) (mask), \
         (int *) (mode))

#define xosspriteop_read_pixel_colour(bits, area, ptr, x, y, colour, tint) \
   (os_error *)_swix (OS_SpriteOp, \
         _IN (0) | _IN (1) | _IN (2) | _IN (3) | _IN (4) | _OUT (5) | _OUT (6), \
         OSSpriteOp_ReadPixelColour | (int) (bits), (osspriteop_area *) (area), \
         (void *) (ptr), (int) (x), (int) (y), (int *) (colour), (int *) (tint))

#define xosspriteop_write_pixel_colour(bits, area, ptr, x, y, colour, tint) \
   (os_error *)_swix (OS_SpriteOp, \
         _IN (0) | _IN (1) | _IN (2) | _IN (3) | _IN (4) | _IN (5) | _IN (6), \
         OSSpriteOp_WritePixelColour | (int) (bits), (osspriteop_area *) (area), \
         (void *) (ptr), (int) (x), (int) (y), (int) (colour), (int) (tint))

#define xosspriteop_read_pixel_mask() ...

#define xosspriteop_write_pixel_mask() ...

#define xosspriteop_insert_column() ...

#define xosspriteop_delete_column() ...

#define xosspriteop_flip_about_y_axis() ...

#define xosspriteop_plot_mask() ...

#define xosspriteop_plot_mask_user_coords() ...

#define xosspriteop_plot_mask_scaled() ...

#define xosspriteop_paint_char_scaled() ...

#define xosspriteop_put_sprite_scaled() ...

#define xosspriteop_put_sprite_grey_scaled() ...

#define xosspriteop_remove_left_hand_wastage(bits, area, ptr) \
   (os_error *)_swix (OS_SpriteOp, _IN (0) | _IN (1) | _IN (2), \
         OSSpriteOp_RemoveLeftHandWastage | (int) (bits), \
         (osspriteop_area *) (area), (void *) (ptr))

#define xosspriteop_plot_mask_trfm(bits, area, ptr, flags, rect, \
      mat_or_pgm, ttab) \
   (os_error *)_swix (OS_SpriteOp, _IN (0) | _IN (1) | _IN (2) | _IN (3) | _IN (4) | \
         _IN (5) | _IN (6) | _IN (7), OSSpriteOp_PlotMaskTrfm | (int) (bits), \
         (osspriteop_area *) (area), (void *) (ptr), (int) (flags), \
         (os_box *) (rect), (void *) (mat_or_pgm), (char *) (ttab))

#define xosspriteop_put_sprite_trfm(bits, area, ptr, flags, rect, action, \
      mat_or_pgm, ttab) \
   (os_error *)_swix (OS_SpriteOp, _IN (0) | _IN (1) | _IN (2) | _IN (3) | _IN (4) | \
         _IN (5) | _IN (6) | _IN (7), OSSpriteOp_PutSpriteTrfm | (int) (bits), \
         (osspriteop_area *) (area), (void *) (ptr), (int) (flags), \
         (os_box *) (rect), (int) (action), (void *) (mat_or_pgm), \
         (char *) (ttab))

#define xosspriteop_insert_delete_rows() ...

#define xosspriteop_insert_delete_columns() ...

#define xosspriteop_switch_output_to_sprite() ...

#define xosspriteop_switch_output_to_mask() ...

#define xosspriteop_read_save_area_size() ...

#endif
