#ifndef taskwindow_H
#define taskwindow_H

/* C header file for TaskWindow
 */

/*OSLib---efficient, type-safe, transparent, extensible,\n"
   register-safe API coverage of RISC OS*/
/*Copyright (c) 1994 Jonathan Coxhead*/

/*
      OSLib is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

      OSLib is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

      You should have received a copy of the GNU General Public License
   along with this programme; if not, write to the Free Software
   Foundation, Inc, 675 Mass Ave, Cambridge, MA 02139, U S A.
*/

#if !defined types_H
   #include "types.h"
#endif

#ifndef os_H
   #include "os.h"
#endif

#define TaskWindowTaskInfo_WindowTask 0x0
#define TaskWindowTaskInfo_WindowTaskParent 0x1

#define taskwindow_ERROR_CANT_KILL 2688
#define taskwindow_ERROR_BAD_SWI_ENTRY 2689
#define taskwindow_ERROR_BAD_TASK_HANDLE 2690
#define taskwindow_ERROR_DYING 2691
#define taskwindow_ERROR_FILE_SLEEP 2692
#define taskwindow_ERROR_NO_EDITOR 2693
#define taskwindow_ERROR_NO_REDIRECTION 2694
#define message_TASK_WINDOW_INPUT 526528
#define message_TASK_WINDOW_OUTPUT 526529
#define message_TASK_WINDOW_EGO 526530
#define message_TASK_WINDOW_MORIO 526531
#define message_TASK_WINDOW_MORITE 526532
#define message_TASK_WINDOW_NEW_TASK 526533
#define message_TASK_WINDOW_SUSPEND 526534
#define message_TASK_WINDOW_RESUME 526535

#define xtaskwindowtaskinfo_window_task(window_task) \
   (os_error *)_swix (TaskWindow_TaskInfo, _IN (0) | _OUT (0), \
         TaskWindowTaskInfo_WindowTask, (osbool *) (window_task))

#define xtaskwindowtaskinfo_window_task_parent(parent, txt) \
   (os_error *)_swix (TaskWindow_TaskInfo, _IN (0) | _OUT (0) | _OUT (1), \
         TaskWindowTaskInfo_WindowTaskParent, \
         (wimp_t *) (parent), (int *) (txt))

#endif
