/*56 instructions*/

#include <kernel.h>

#include "oslib/colourtrans.h"
#include "oslib/font.h"
#include "oslib/os.h"
#include "oslib/pdriver.h"

_kernel_oserror *x (int page, char *t)

{  osbool more;
   os_box req;
   _kernel_oserror *oserror = NULL;
   _kernel_swi_regs swi_regs;

   swi_regs.r [0] = 1;
   swi_regs.r [1] = (int) &req;
   swi_regs.r [2] = page;
   swi_regs.r [3] = (int) NULL;

   if ((oserror = _kernel_swi (PDriver_DrawPage, &swi_regs, &swi_regs)) !=
         NULL)
      goto finish;

   while (more)
   {  swi_regs.r [0] = os_COLOUR_BLACK;
      swi_regs.r [3] = colourtrans_SET_FG;
      swi_regs.r [4] = os_ACTION_OVERWRITE;

      if ((oserror = _kernel_swi (ColourTrans_SetGCOL, &swi_regs, &swi_regs))
            != NULL)
         goto finish;

      swi_regs.r [1] = (int) t;
      swi_regs.r [2] = NONE;
      swi_regs.r [3] = 0;
      swi_regs.r [4] = 0;

      if ((oserror = _kernel_swi (Font_Paint, &swi_regs, &swi_regs)) != NULL)
         goto finish;

      swi_regs.r [1] = (int) &req;

      if ((oserror = _kernel_swi (PDriver_GetRectangle, &swi_regs,
            &swi_regs)) != NULL)
         goto finish;

      more = swi_regs.r [0];
   }

finish:
  return oserror;
}
