/* This source code in this file is licensed to You by Castle Technology
 * Limited ("Castle") and its licensors on contractual terms and conditions
 * ("Licence") which entitle you freely to modify and/or to distribute this
 * source code subject to Your compliance with the terms of the Licence.
 * 
 * This source code has been made available to You without any warranties
 * whatsoever. Consequently, Your use, modification and distribution of this
 * source code is entirely at Your own risk and neither Castle, its licensors
 * nor any other person who has contributed to this source code shall be
 * liable to You for any loss or damage which You may suffer as a result of
 * Your use, modification or distribution of this source code.
 * 
 * Full details of Your rights and obligations are set out in the Licence.
 * You should have received a copy of the Licence with this source code file.
 * If You have not received a copy, the text of the Licence is available
 * online at www.castle-technology.co.uk/riscosbaselicence.htm
 */
typedef unsigned int word;
typedef enum { NO, YES } bool;

typedef struct aifhdr {
    word  bl_decompress;
    word  bl_selfreloc;
    word  bl_zeroinit;
    word  bl_imageentry;
    word  swi_exit;
    int   codesize;
    int   datasize;
    int   debugsize;
    int   zerosize;
    int   debugtype;
    int   imagebase;
    int   reserved[5];
    word  zeroinit[16];
} aifhdr;

#define AIFBYTES   sizeof(aifhdr)  /* size in bytes of an AIF header */
#define AIFWORDS   (AIFBYTES / sizeof(int))
#define AIFPRELUDE 5 /* no of extra instructions in AIF decompression */
#define PREFETCH   2 /* words of ARM prefetch */

typedef struct datahdr {
    word  bl_decompress;
    word  datamagic;
    word  load;
    word  exec;
    word  size;
} datahdr;

#define DATABYTES ((int)(sizeof(datahdr)))
#define DATAWORDS (DATABYTES / sizeof(int))
#define DATAMAGIC 0x213542
#define SQUEEZED 0xffffea00

typedef struct SqueezeHeader {
  int decodedsize;
  int encodedsize;
  int encodedtabs;
  int nshorts;
  int nlongs;
  int bytestomove;
} SqueezeHeader;

#define SQUEEZEBYTES sizeof(SqueezeHeader)
#define SQUEEZEWORDS (SQUEEZEBYTES / sizeof(int))

#define B 0xea000000
#define BL 0xeb000000
#define B_OFFSET 0x00ffffff
#define MOV_PC_R8 0xe1a0f008
#define ADD_R8_R8_0 0xe2888000
#define SUB_R8_R8_0 0xe2488000
#define MOV_R0_R0 0xe1a00000
#define LDR_PC_R8_MINUS4 0xe518f004
#define NV (0xf0000000 - 0xe0000000)
#define SUB_R1_R8_IMM4 (0xE2481004)
#define SWI_XOS_SynchroniseCodeAreas (0xEF02006E)
