From 874a7d09eb853fe6b5e959a0e60e28636b3f0269 Mon Sep 17 00:00:00 2001
From: rjd <3246251196ryan@gmail.com>
Date: Thu, 23 Nov 2023 22:12:35 +0000
Subject: [PATCH 38/41] Provide clib4 as an additional C runtime library.

As well as the existing newlib and clib2 as C runtime library choices,
clib4 is now introduced. Support for clib4 is currently restricted to
GCC version 11.
---
 gcc/config/rs6000/amigaos.h           | 43 ++++++++++++++++++++-------
 gcc/config/rs6000/t-amigaos           |  4 +--
 libstdc++-v3/configure                | 15 ++++++++++
 libstdc++-v3/crossconfig.m4           | 12 ++++++++
 libstdc++-v3/include/c_global/cstdlib |  4 +--
 5 files changed, 64 insertions(+), 14 deletions(-)

diff --git a/gcc/config/rs6000/amigaos.h b/gcc/config/rs6000/amigaos.h
index 8a549ed05ca4358e30e2bdef6a2b6d2d177fdd14..f92526783393a0ac40d0ea9c08ab932c7f472744 100644
--- gcc/config/rs6000/amigaos.h
+++ gcc/config/rs6000/amigaos.h
@@ -122,12 +122,17 @@
       else if (IS_MCRT("clib2") || IS_MCRT("clib2-ts")) \
         {					\
           builtin_define_std ("CLIB2");		\
           if (IS_MCRT("clib2-ts"))		\
             builtin_define ("__THREAD_SAFE");	\
         }					\
+      else if (IS_MCRT("clib4"))		\
+        {					\
+          builtin_define_std ("CLIB4");		\
+          builtin_define ("CLIB4");		\
+        }					\
       else if (IS_MCRT("ixemul"))		\
         {					\
           builtin_define_std ("ixemul");	\
           builtin_define_std ("IXEMUL");	\
         }					\
       else if (IS_MCRT("libnix"))		\
@@ -166,28 +171,18 @@
 #undef REAL_LIBGCC_SPEC
 #define REAL_LIBGCC_SPEC "\
 %{static|static-libgcc: %{!use-dynld: -lgcc -lgcc_eh} %{use-dynld: -lgcc} }%{!static:%{!static-libgcc:%{!shared:%{!shared-libgcc: %{!use-dynld: -lgcc -lgcc_eh} %{use-dynld: -lgcc}}%{shared-libgcc:-lgcc}}%{shared:%{shared-libgcc:-lgcc}%{!shared-libgcc:-lgcc}}}}"
 
 
 /* make newlib the default */
-#if 1
 #define CPP_AMIGA_DEFAULT_SPEC "%{mcrt=default|!mcrt=*:%<mcrt=default -mcrt=newlib} %(cpp_newlib)"
 #define LINK_AMIGA_DEFAULT_SPEC "%(link_newlib)"
 #define STARTFILE_AMIGA_DEFAULT_SPEC "%(startfile_newlib)"
 #define ENDFILE_AMIGA_DEFAULT_SPEC "%(endfile_newlib)"
 #undef MULTILIB_DEFAULTS
 #define MULTILIB_DEFAULTS {"mcrt=newlib"}
-#else
-/* make clib2 the default */
-#define CPP_AMIGA_DEFAULT_SPEC "%{mcrt=default|!mcrt=*:%<mcrt=default -mcrt=clib2} %(cpp_clib2)"
-#define LINK_AMIGA_DEFAULT_SPEC "%(link_clib2)"
-#define STARTFILE_AMIGA_DEFAULT_SPEC "%(startfile_clib2)"
-#define ENDFILE_AMIGA_DEFAULT_SPEC "%(endfile_clib2)"
-#undef MULTILIB_DEFAULTS
-#define MULTILIB_DEFAULTS {"mcrt=clib2"}
-#endif
 
 
 /* For specifying the include system paths, we generally use -idirafter so the include
  * paths are added at the end of the gcc default include paths. This is required for
  * fixincludes and libstdc++ to work properly
  */
@@ -212,12 +207,30 @@
                  "%{!msoft-float:%(lib_subdir_type)}/crt0.o"
 
 #define ENDFILE_CLIB2_SPEC "\
 %(base_sdk)clib2/%{mcrt=clib2-ts:lib.threadsafe; :lib}" \
                  "%{!msoft-float:%(lib_subdir_type)}/crtend.o"
 
+/* clib4 */
+
+#define CPP_CLIB4_SPEC "\
+-idirafter %(base_sdk)clib4/include -idirafter %(base_sdk)local/clib4/include"
+
+#define LIB_SUBDIR_CLIB4_SPEC "lib%(lib_subdir_type)"
+
+#define LINK_CLIB4_SPEC "\
+-L%(base_sdk)clib4/%(lib_subdir_clib4) \
+-L%(base_gcc)lib/gcc/ppc-amigaos/%(version)/clib4/lib%(lib_subdir_type) \
+-L%(base_sdk)local/clib4/%(lib_subdir_clib4)"
+
+#define STARTFILE_CLIB4_SPEC "\
+%{shared: %(base_sdk)clib4/%(lib_subdir_clib4)/shcrtbegin.o} %{!shared: %(base_sdk)clib4/%(lib_subdir_clib4)/crtbegin.o} %{!shared: %(base_sdk)clib4/%(lib_subdir_clib4)/crt0.o}"
+
+#define ENDFILE_CLIB4_SPEC "\
+%{shared: %(base_sdk)clib4/%(lib_subdir_clib4)/shcrtend.o} %{!shared: %(base_sdk)clib4/%(lib_subdir_clib4)/crtend.o}"
+
 /* ixemul */
 
 #define CPP_IXEMUL_SPEC "\
 -idirafter %(base_sdk)ixemul/include -idirafter %(base_sdk)local/ixemul/include"
 
 #define LIB_SUBDIR_IXEMUL_SPEC "lib%(lib_subdir_type)"
@@ -267,12 +280,13 @@
 
 /* End clib specific */
 
 #undef CPP_OS_DEFAULT_SPEC
 #define CPP_OS_DEFAULT_SPEC "\
 %{mcrt=clib2|mcrt=clib2-ts: %(cpp_clib2); \
+mcrt=clib4: %(cpp_clib4); \
 mcrt=ixemul: %(cpp_ixemul); \
 mcrt=libnix: %(cpp_libnix); \
 mcrt=newlib: %(cpp_newlib); \
 mcrt=default|!mcrt=*: %{mcrt=default|!nostdinc: %(cpp_amiga_default)}; \
 : %eInvalid C runtime library} \
 %{!nostdinc: -idirafter %(base_sdk)include/include_h -idirafter %(base_sdk)include/netinclude -idirafter %(base_sdk)local/common/include} \
@@ -286,12 +300,13 @@ mcrt=default|!mcrt=*: %{mcrt=default|!nostdinc: %(cpp_amiga_default)}; \
 -q -d %{h*} %{v:-V} %{G*} \
 %{Wl,*:%*} %{YP,*} %{R*} \
 %{Qy:} %{!Qn:-Qy} \
 %(link_thread) %(link_shlib) %(link_text) \
 %{mbaserel: %{msdata|msdata=default|msdata=sysv: %e-mbaserel and -msdata options are incompatible}} \
 %{mcrt=clib2|mcrt=clib2-ts: %(link_clib2); \
+mcrt=clib4: %(link_clib4); \
 mcrt=ixemul: %(link_ixemul); \
 mcrt=libnix: %(link_libnix); \
 mcrt=newlib: %(link_newlib); \
 mcrt=default|!mcrt=*: %(link_amiga_default); \
 : %eInvalid C runtime library} \
 -L%(base_sdk)local/common/lib%(lib_subdir_type) \
@@ -311,21 +326,23 @@ mcrt=default|!mcrt=*: %(link_amiga_default); \
 #define LINK_THREAD "\
 %s%{athread=native:gthr-amigaos-native.o;athread=single:gthr-amigaos-single.o;athread=pthread:gthr-amigaos-pthread.o}"
 
 #undef STARTFILE_SPEC
 #define STARTFILE_SPEC "\
 %{mcrt=clib2|mcrt=clib2-ts: %(startfile_clib2); \
+mcrt=clib4: %(startfile_clib4); \
 mcrt=ixemul: %(startfile_ixemul); \
 mcrt=libnix: %(startfile_libnix); \
 mcrt=newlib: %(startfile_newlib); \
 mcrt=default|!mcrt=*: %(startfile_amiga_default); \
 : %eInvalid C runtime library}"
 
 #undef ENDFILE_SPEC
 #define ENDFILE_SPEC "\
 %{mcrt=clib2|mcrt=clib2-ts: %(endfile_clib2); \
+mcrt=clib4: %(endfile_clib4); \
 mcrt=ixemul: %(endfile_ixemul); \
 mcrt=libnix: %(endfile_libnix); \
 mcrt=newlib: %(endfile_newlib); \
 mcrt=default|!mcrt=*: %(endfile_amiga_default); \
 : %eInvalid C runtime library}"
 
@@ -350,12 +367,18 @@ mcrt=default|!mcrt=*: %(endfile_amiga_default); \
   /* clib2 */ \
   {"cpp_clib2", CPP_CLIB2_SPEC}, \
   {"lib_subdir_clib2", LIB_SUBDIR_CLIB2_SPEC}, \
   {"link_clib2", LINK_CLIB2_SPEC}, \
   {"startfile_clib2", STARTFILE_CLIB2_SPEC}, \
   {"endfile_clib2", ENDFILE_CLIB2_SPEC}, \
+  /* clib4 */ \
+  {"cpp_clib4", CPP_CLIB4_SPEC}, \
+  {"lib_subdir_clib4", LIB_SUBDIR_CLIB4_SPEC}, \
+  {"link_clib4", LINK_CLIB4_SPEC}, \
+  {"startfile_clib4", STARTFILE_CLIB4_SPEC}, \
+  {"endfile_clib4", ENDFILE_CLIB4_SPEC}, \
   /* ixemul */ \
   {"cpp_ixemul", CPP_IXEMUL_SPEC}, \
   {"lib_subdir_ixemul", LIB_SUBDIR_IXEMUL_SPEC}, \
   {"link_ixemul", LINK_IXEMUL_SPEC}, \
   {"startfile_ixemul", STARTFILE_IXEMUL_SPEC}, \
   {"endfile_ixemul", ENDFILE_IXEMUL_SPEC}, \
diff --git a/gcc/config/rs6000/t-amigaos b/gcc/config/rs6000/t-amigaos
index 15d9d3fd5a5f0c8109cd158242745fa52b19257e..0d8049f400ca7f0937330ffec4f01546d9d61cc2 100644
--- gcc/config/rs6000/t-amigaos
+++ gcc/config/rs6000/t-amigaos
@@ -12,9 +12,9 @@ LIMITS_H_TEST = true
 NATIVE_SYSTEM_HEADER_DIR=/gcc/include
 #OTHER_FIXINCLUDES_DIRS=${gcc_tooldir}/include
 
 # Build the libraries for both newlib and clib2
 # We do not build soft float flavours as none of the
 # libs support soft floats
-MULTILIB_OPTIONS = mcrt=newlib/mcrt=clib2
-MULTILIB_DIRNAMES = newlib clib2
+MULTILIB_OPTIONS = mcrt=newlib/mcrt=clib2/mcrt=clib4
+MULTILIB_DIRNAMES = newlib clib2 clib4
 #MULTILIB_REUSE = =mcrt=newlib
diff --git a/libstdc++-v3/configure b/libstdc++-v3/configure
index 6f771d0b1bc3a62bb68bd0657bb295b11c005ba6..d566c6173da7da2084d6eed531967c5fead2d779 100755
--- libstdc++-v3/configure
+++ libstdc++-v3/configure
@@ -74119,12 +74119,27 @@ $as_echo "$ac_ld_relro" >&6; }
     OPT_LDFLAGS="-Wl,-O1 $OPT_LDFLAGS"
   fi
 
 
 
 
+
+
+    for ac_func in acosf asinf atan2f atanf ceilf cosf coshf expf fabsf floorf fmodf frexpf sqrtf hypotf ldexpf log10f logf modff powf sinf sinhf tanf tanhf fabsl acosl asinl atanl atan2l ceill cosl coshl expl floorl fmodl frexpl sqrtl hypotl ldexpl logl log10l modfl powl sinl sinhl tanl tanhl
+do :
+  as_ac_var=`$as_echo "ac_cv_func_$ac_func" | $as_tr_sh`
+ac_fn_c_check_func "$LINENO" "$ac_func" "$as_ac_var"
+if eval test \"x\$"$as_ac_var"\" = x"yes"; then :
+  cat >>confdefs.h <<_ACEOF
+#define `$as_echo "HAVE_$ac_func" | $as_tr_cpp` 1
+_ACEOF
+
+fi
+done
+
+
     ;;
   *)
     as_fn_error $? "No support for this host/target combination." "$LINENO" 5
    ;;
 esac
 
diff --git a/libstdc++-v3/crossconfig.m4 b/libstdc++-v3/crossconfig.m4
index cbbfff770cb1356bf9352ad7e61ef5c77458f262..cb22f046dc2585323e457cde10a7d50a1683863b 100644
--- libstdc++-v3/crossconfig.m4
+++ libstdc++-v3/crossconfig.m4
@@ -316,12 +316,24 @@ dnl # the expansion of the present macro.
     AC_CHECK_HEADERS([nan.h ieeefp.h endian.h sys/isa_defs.h \
       machine/endian.h machine/param.h sys/machine.h sys/types.h \
       fp.h locale.h float.h inttypes.h])
     SECTION_FLAGS='-ffunction-sections -fdata-sections'
     AC_SUBST(SECTION_FLAGS)
     GLIBCXX_CHECK_LINKER_FEATURES
+
+dnl # Although we are cross compiling for Amiga, we already built the
+dnl # first stage compiler: the compiler without any libraries such as
+dnl # libstdc++. This means that we DO have access to AC_CHECK_FUNCS
+dnl # as all the CRTs have been built and installed at the point of
+dnl # running the configure file for libstdc++-v3.
+dnl #
+dnl # Adding checks here:
+
+dnl #
+    AC_CHECK_FUNCS(acosf asinf atan2f atanf ceilf cosf coshf expf fabsf floorf fmodf frexpf sqrtf hypotf ldexpf log10f logf modff powf sinf sinhf tanf tanhf fabsl acosl asinl atanl atan2l ceill cosl coshl expl floorl fmodl frexpl sqrtl hypotl ldexpl logl log10l modfl powl sinl sinhl tanl tanhl)
+
     ;;
   *)
     AC_MSG_ERROR([No support for this host/target combination.])
    ;;
 esac
 ])
diff --git a/libstdc++-v3/include/c_global/cstdlib b/libstdc++-v3/include/c_global/cstdlib
index 99325ad0682f2f88bc04ca38a50cc97a2bcea4d5..deae1df7fd4657b48ee9ccd4f0d1781f2d09237e 100644
--- libstdc++-v3/include/c_global/cstdlib
+++ libstdc++-v3/include/c_global/cstdlib
@@ -188,14 +188,14 @@ _GLIBCXX_END_NAMESPACE_VERSION
 #undef lldiv
 #undef atoll
 #undef strtoll
 #undef strtoull
 #undef strtof
 
-/* Neigther clib2 nor newlib offers strtoud() */
-#ifndef __amigaos4__
+/* clib2 and newlib do not provide an implementation of strtold */
+#if !defined (__amigaos4__) || defined(__CLIB4__)
 #undef strtold
 #endif
 
 namespace __gnu_cxx _GLIBCXX_VISIBILITY(default)
 {
 _GLIBCXX_BEGIN_NAMESPACE_VERSION
-- 
2.34.1

