From e6ec2d752903863da6dcf190e18c73e346b6b253 Mon Sep 17 00:00:00 2001
From: Sebastian Bauer <mail@sebastianbauer.info>
Date: Wed, 2 Dec 2015 21:39:42 +0100
Subject: [PATCH 05/41] Disable the usage of /dev/urandom when compiling for
 AmigaOS.

---
 gcc/gcc.c    | 3 +++
 gcc/toplev.c | 2 ++
 2 files changed, 5 insertions(+)

diff --git a/gcc/gcc.c b/gcc/gcc.c
index 7bc4e7047573d724e913679cf18fc7649534442f..cf92e18ecdacebad78a6aefc80f727c20c85b63d 100644
--- gcc/gcc.c
+++ gcc/gcc.c
@@ -10451,22 +10451,25 @@ print_asm_header_spec_function (int arg ATTRIBUTE_UNUSED,
 /* Get a random number for -frandom-seed */
 
 static unsigned HOST_WIDE_INT
 get_random_number (void)
 {
   unsigned HOST_WIDE_INT ret = 0;
+
+#ifndef __amigaos4__
   int fd; 
 
   fd = open ("/dev/urandom", O_RDONLY); 
   if (fd >= 0)
     {
       read (fd, &ret, sizeof (HOST_WIDE_INT));
       close (fd);
       if (ret)
         return ret;
     }
+#endif
 
   /* Get some more or less random data.  */
 #ifdef HAVE_GETTIMEOFDAY
   {
     struct timeval tv;
 
diff --git a/gcc/toplev.c b/gcc/toplev.c
index d8cc254adef2677798354697af5d7eb957c03c9a..9856a8009e42f37defb131ea38284dcfc44c6117 100644
--- gcc/toplev.c
+++ gcc/toplev.c
@@ -273,20 +273,22 @@ init_local_tick (void)
 
 HOST_WIDE_INT
 get_random_seed (bool noinit)
 {
   if (!random_seed && !noinit)
     {
+#ifndef __amigaos4__
       int fd = open ("/dev/urandom", O_RDONLY);
       if (fd >= 0)
         {
           if (read (fd, &random_seed, sizeof (random_seed))
               != sizeof (random_seed))
             random_seed = 0;
           close (fd);
         }
+#endif
       if (!random_seed)
 	random_seed = local_tick ^ getpid ();
     }
   return random_seed;
 }
 
-- 
2.34.1

