From a01c2a5ac436a00b931a0146cf802f69127c2884 Mon Sep 17 00:00:00 2001
From: Sebastian Bauer <mail@sebastianbauer.info>
Date: Sat, 5 Dec 2015 13:17:26 +0100
Subject: [PATCH 06/41] Expand arg zero on AmigaOS using the PROGDIR: assign.

This should make sure that the proper relative paths are computed during
process_command().
---
 gcc/gcc.c | 10 ++++++++++
 1 file changed, 10 insertions(+)

diff --git a/gcc/gcc.c b/gcc/gcc.c
index cf92e18ecdacebad78a6aefc80f727c20c85b63d..9ac8835c794a1dd66afaa081554c8eca6ad4e5e1 100644
--- gcc/gcc.c
+++ gcc/gcc.c
@@ -8025,12 +8025,22 @@ driver::~driver ()
 int
 driver::main (int argc, char **argv)
 {
   bool early_exit;
 
   set_progname (argv[0]);
+#ifdef __amigaos4__
+  /* Expand the command name on AmigaOS */
+  char *expanded_progdir = lrealpath("/progdir/");
+  if (expanded_progdir)
+    {
+      char *expanded_argv0 = concat(expanded_progdir,"/",progname,NULL);
+      argv[0] = expanded_argv0; /* FIXME: Leak */
+      free(expanded_progdir);
+    }
+#endif
   expand_at_files (&argc, &argv);
   decode_argv (argc, const_cast <const char **> (argv));
   global_initializations ();
   build_multilib_strings ();
   set_up_specs ();
   putenv_COLLECT_AS_OPTIONS (assembler_options);
-- 
2.34.1

