/*
 * WinDom: a high level GEM library
 * Copyright (c) 1997-2006 windom authors (see AUTHORS file)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * $Source: /cvsroot/windom/windom/src/cicon.c,v $
 * Module : Color icon related functions
 *
 * CVS info:
 *   $Author: bercegeay $
 *   $Date: 2006/02/14 20:50:10 $
 *   $Revision: 1.6 $
 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "globals.h"
#include "cicon.h"

#ifdef __TURBOC__
#pragma warn -sig		/* disable warn "Conversion may loose significant digits" */
#endif

#ifdef __SOZOBONX__
extern void lmemset(void*,char,long);
#define malloc(a)      lalloc((long)(a))
#define memcpy(a,b,c)  lmemcpy((a),(b),(long)(c))
#define memset(a,b,c)  lmemset((a),(b),(long)(c))
#endif /* __SOZOBONX__ */

/****** TYPES ****************************************************************/

/****** VARIABLES ************************************************************/

static WORD    xpixelbytes;


/****** FUNCTIONS ************************************************************/

static WORD xadd_cicon	 ( APPvar *app, CICONBLK *cicnblk, OBJECT *obj, WORD nub, XRSRCFIX *fix);
static void draw_bitblk  ( short vdih, WORD *p, WORD x, WORD y, WORD w, WORD h, WORD num_planes, WORD mode, INT16 *__index);
static void xfix_cicon   ( APPvar *app, UWORD *col_data, LONG len, WORD old_planes, WORD new_planes, MFDB *s, XRSRCFIX *fix);
static void std_to_byte  ( UWORD *col_data, LONG len, WORD old_planes, ULONG *farbtbl2, MFDB *s);
static WORD test_rez     ( APPvar *app);
static void xfill_farbtbl( APPvar *app, XRSRCFIX *fix);
static short __CDECL xdraw_cicon (PARMBLK *pb);

/*****************************************************************************/
/* changer le format de l'icne et l'adapter aux autres rsolutions.         */
/*****************************************************************************/

static WORD xadd_cicon (APPvar *app, CICONBLK *cicnblk, OBJECT *obj, WORD nub, XRSRCFIX *fix)
{	WORD     x, y, line, xmax, best_planes, find_planes;
	CICON    *cicn, *color_icn, *best_icn = NULL;
  	LONG     len, *next;
  	MFDB     d;

	len = cicnblk->monoblk.ib_wicon / 8 * cicnblk->monoblk.ib_hicon;

	color_icn = &fix->cicon_table[nub];

	best_planes = 1;
	if (app->nplanes > 8)
		find_planes = 4;
	else
		find_planes = app->nplanes;

	cicn = cicnblk->mainlist;
	next = (LONG *)&cicnblk->mainlist;

	while (cicn != NULL)
	{
		*next = (LONG)cicn;
		next = (LONG *)&cicn->next_res;

		if (cicn->num_planes >= best_planes && cicn->num_planes <= find_planes)
		{
			best_planes = cicn->num_planes;
			best_icn = cicn;
		}
		cicn = cicn->next_res;
	}
	
	if (best_icn == NULL)		/* aucune icne couleur trouve */
		return (FALSE);
	else
		*color_icn = *best_icn;

	if (best_planes > 1)
		color_icn->num_planes = app->nplanes;
	else
		color_icn->num_planes = 1;
	
	/* Platz fr das gerteabhngige Format allozieren */
	if ((color_icn->col_data = malloc (len * color_icn->num_planes)) == NULL)
		return (FALSE);
	if (color_icn->sel_data)
	{
		if ((color_icn->sel_data = malloc (len * color_icn->num_planes)) == NULL)
		{
			free (color_icn->col_data);
			return (FALSE);
		}
	}
	
	if (best_planes > 1)
	{	if (best_icn->sel_data == NULL)
		{
			/* Selected-Maske vorbereiten */
			if ((color_icn->sel_mask = malloc (len)) == NULL)

			{
				free (color_icn->col_data);
				if (color_icn->sel_data)
					free (color_icn->sel_data);
				return (FALSE);
			}
	
			xmax = cicnblk->monoblk.ib_wicon / 16;
	
			for (y = 0; y < cicnblk->monoblk.ib_hicon; y++)
			{
				line = y * xmax;
	
				for (x = 0; x < xmax; x++)
				{
					if (y & 1)
						color_icn->sel_mask[line + x] = best_icn->col_mask[line + x] & 0xaaaa;
					else
						color_icn->sel_mask[line + x] = best_icn->col_mask[line + x] & 0x5555;
				}
			}
		}
		
		d.fd_addr    = color_icn->col_data;
		d.fd_w       = cicnblk->monoblk.ib_wicon;
		d.fd_h       = cicnblk->monoblk.ib_hicon;
		d.fd_wdwidth = d.fd_w >> 4;
		d.fd_stand   = TRUE;
		d.fd_nplanes = app->nplanes;
	
		xfix_cicon (app, (UWORD *)best_icn->col_data, len, best_planes, app->nplanes, &d, fix);
		if (best_icn->sel_data)
		{	d.fd_addr = color_icn->sel_data;
			xfix_cicon (app, (UWORD *)best_icn->sel_data, len, best_planes, app->nplanes, &d, fix);
		}
	}
	else
	{
		memcpy (color_icn->col_data, best_icn->col_data, len);
		memcpy (color_icn->sel_data, best_icn->sel_data, len);
	}

	color_icn->next_res = cicnblk->mainlist;
	cicnblk->mainlist = color_icn;

	fix->obblk[nub].w_parm.wp_type = G_CICON;
	fix->obblk[nub].w_parm.wp_spec = obj->ob_spec.index;
	fix->obblk[nub].w_parm.wp_app = app;
	fix->obblk[nub].ublk.ub_parm = (long)&(fix->obblk[nub].w_parm);
	fix->obblk[nub].ublk.ub_code = xdraw_cicon;
	obj->ob_spec.userblk = &fix->obblk[nub].ublk;
	obj->ob_type = (XCICON << 8) | G_USERDEF;
	
	return (TRUE);
}

/*****************************************************************************/
/* En mode True-Color, passer la valeur de point en palette RVB              */
/*****************************************************************************/

static void xfill_farbtbl ( APPvar *app, XRSRCFIX *fix)
{
	int np, color, backup[32];
	INT16 pxy[8], rgb[3];
	MFDB screen;
	MFDB pixel = {NULL, 16, 1, 1, 0, 1, 0, 0, 0};
	MFDB stdfm = {NULL, 16, 1, 1, 1, 1, 0, 0, 0};
	WORD pixtbl[16] = {0, 2, 3, 6, 4, 7, 5, 8, 9, 10, 11, 14, 12, 15, 13, 16};
	
	if (app->nplanes >= 8)
	{
		if (app->nplanes > 8)
		{
			if (fix->is_palette == FALSE)	/* pas de palette dans le ressource */
			{
				for (color = 0; color < 255; color++)
				{	if (color < 16)
					{	vq_color( app->graf.handle, pixtbl[color], 1, fix->rgb_palette[color]);
						fix->rgb_palette[color][3] = pixtbl[color];
					}
					else
					{	vq_color( app->graf.handle, color + 1, 1, fix->rgb_palette[color]);
						fix->rgb_palette[color][3] = color + 1;
					}
				}
				vq_color (app->graf.handle, 1, 1, fix->rgb_palette[255]);
				fix->rgb_palette[255][3] = 1;
				fix->is_palette = TRUE;
			}
			
			vs_clip (app->graf.handle, FALSE, pxy);
			mt_graf_mouse (M_OFF, NULL, app->aes_global);

			memset (backup, 0, sizeof (backup));
	 		memset (fix->farbtbl, 0, 32 * 256 * sizeof (WORD));
			screen.fd_addr = NULL;
			stdfm.fd_nplanes = pixel.fd_nplanes = app->nplanes;
		
			vswr_mode (app->graf.handle, MD_REPLACE);
			vsl_ends (app->graf.handle, 0, 0);
			vsl_type (app->graf.handle, 1);
			vsl_width (app->graf.handle, 1);
			memset (pxy, 0, sizeof (pxy));
			
			pixel.fd_addr = backup;	/* Punkt retten */
			vro_cpyfm (app->graf.handle, S_ONLY, pxy, &screen, &pixel);
		
			/* Alte Farbe retten */
			vq_color (app->graf.handle, 15, 1, rgb);

			for (color = 0; color < 256; color++)
			{
				vs_color (app->graf.handle, 15, fix->rgb_palette[color]);
				vsl_color (app->graf.handle, 15);
				v_pline (app->graf.handle, 2, pxy);
				
				stdfm.fd_addr = pixel.fd_addr = fix->farbtbl[color];
		
				/* vro_cpyfm, weil v_get_pixel nicht mit TrueColor (>=24 Planes) funktioniert */
				vro_cpyfm (app->graf.handle, S_ONLY, pxy, &screen, &pixel);
	
				if (fix->farbtbl2 != NULL && xpixelbytes)
				{	fix->farbtbl2[color] = 0L;
					memcpy (&fix->farbtbl2[color], pixel.fd_addr, xpixelbytes);
				}
					
				vr_trnfm (app->graf.handle, &pixel, &stdfm);
				for (np = 0; np < app->nplanes; np++)
					if (fix->farbtbl[color][np])
						fix->farbtbl[color][np] = 0xffff;
			}
		
			/* Alte Farbe restaurieren */
			vs_color (app->graf.handle, 15, rgb);

			pixel.fd_addr = backup;	/* Punkt restaurieren */
			vro_cpyfm (app->graf.handle, S_ONLY, pxy, &pixel, &screen);
		
			mt_graf_mouse (M_ON, NULL, app->aes_global);
		}
		else
		{	if (fix->farbtbl2 != NULL && xpixelbytes)
				for (color = 0; color < 256; color++)
					*(UBYTE *)&fix->farbtbl2[color] = color;
		}
	}
}

/*****************************************************************************/
/* combiens de bytes par pixels seront changs au format                    */
/*****************************************************************************/

static WORD test_rez (APPvar *app)

{	int     i, np, color, bpp = 0;
	UWORD    backup[32], test[32];
	INT16     pxy[8], rgb[3];
	INT16     black[3] = {0, 0, 0};
	INT16     white[3] = {1000, 1000, 1000};
	MFDB     screen;
	MFDB     pixel = {NULL, 16, 1, 1, 0, 1, 0, 0, 0};
	MFDB     stdfm = {NULL, 16, 1, 1, 1, 1, 0, 0, 0};

	if (app->nplanes >= 8)
	{
		stdfm.fd_nplanes = pixel.fd_nplanes = app->nplanes;

		if (app->nplanes == 8)
		{
			color = 0xff;
			memset (test, 0, app->nplanes * sizeof (WORD));
			for (np = 0; np < app->nplanes; np++)
				test[np] = (color & (1 << np)) << (15 - np);
	
			pixel.fd_addr = stdfm.fd_addr = test;
			vr_trnfm (app->graf.handle, &stdfm, &pixel);
			
			for (i = 1; i < app->nplanes; i++)
				if (test[i])	break;
			
			if (i >= app->nplanes && !(test[0] & 0x00ff))
				bpp = 1;
		}
		else
		{
			vs_clip (app->graf.handle, FALSE, pxy);
			screen.fd_addr = NULL;
			
			memset (backup, 0, sizeof (backup));
		
			vswr_mode (app->graf.handle, MD_REPLACE);
			vsl_ends (app->graf.handle, 0, 0);
			vsl_type (app->graf.handle, 1);
			vsl_width (app->graf.handle, 1);
			memset (pxy, 0, sizeof (pxy));
			
			mt_graf_mouse (M_OFF, NULL, app->aes_global);
		
			pixel.fd_addr = backup;	

			vro_cpyfm (app->graf.handle, S_ONLY, pxy, &screen, &pixel);
		
			/* sauver l'ancienne couleur */
			vq_color (app->graf.handle, 15, 1, rgb);
	
			/* tester le format universel */
			pixel.fd_addr = test;
			vsl_color (app->graf.handle, 15);
			vs_color (app->graf.handle, 15, white);
			v_pline (app->graf.handle, 2, pxy);
			
			memset (test, 0, app->nplanes * sizeof (WORD));
			vro_cpyfm (app->graf.handle, S_ONLY, pxy, &screen, &pixel);
			
			for (i = (app->nplanes + 15) / 16 * 2; i < app->nplanes; i++)
				if (test[i])	break;
			
			if (i >= app->nplanes)
			{
				vs_color (app->graf.handle, 15, black);
				v_pline (app->graf.handle, 2, pxy);
				
				memset (test, 0, app->nplanes * sizeof (WORD));
				vro_cpyfm (app->graf.handle, S_ONLY, pxy, &screen, &pixel);
				
				for (i = (app->nplanes + 15) / 16 * 2; i < app->nplanes; i++)
					if (test[i])	break;
				
				if (i >= app->nplanes)
					bpp = (app->nplanes + 7) / 8;
			}

			/* restaurer les anciennes couleurs */
			vs_color (app->graf.handle, 15, rgb);
	
			pixel.fd_addr = backup;	/* restaure le point */
			vro_cpyfm (app->graf.handle, S_ONLY, pxy, &pixel, &screen);
		
			mt_graf_mouse (M_ON, NULL, app->aes_global);
		}
	}

	return (bpp);
}

/*****************************************************************************/
/* adapter l'icne  la rsolution graphique actuelle                        */
/* (par exemple : une icne de 4 Plans vers 24 Plans TrueColor)              */
/*****************************************************************************/

static void xfix_cicon (APPvar *app, UWORD *col_data, LONG len, WORD old_planes, WORD new_planes, MFDB *s, XRSRCFIX *fix)

{	LONG  x, i, old_len, rest_len, mul[32], pos;
	UWORD np, *new_data, mask, pixel, bit, color, back[32], old_col[32], maxcol=0;
	WORD  got_mem = FALSE;
	MFDB  d;
	
	len >>= 1;

	if (old_planes == new_planes)
	{	if (s != NULL)
		{	if (new_planes == app->nplanes)
			{
				d = *s;
				d.fd_stand = FALSE;
				s->fd_addr = col_data;
				if (d.fd_addr == s->fd_addr)
				{	if ((d.fd_addr = malloc (len * 2 * new_planes)) == NULL)
						d.fd_addr = s->fd_addr;
					else
						got_mem = TRUE;
				}
				
				vr_trnfm (app->graf.handle, s, &d);
				if (d.fd_addr != s->fd_addr && got_mem == TRUE)
				{
					memcpy (s->fd_addr, d.fd_addr, len * 2 * new_planes);
					free (d.fd_addr);
				}
			}
			else
				memcpy (s->fd_addr, col_data, len * 2 * new_planes);
		}
		return;
	}
	/* debug windom */
	old_len  = 0;
	rest_len = 0;
	/* ------------ */
	if (new_planes <= 8)
	{
		old_len  = old_planes * len;
		rest_len = new_planes * len - old_len;

		if (s != NULL)
		{
			new_data = &((UWORD *)s->fd_addr)[old_len];
			memset (new_data, 0, rest_len * 2);
			memcpy (s->fd_addr, col_data, old_len * 2);
			col_data = s->fd_addr;
		}
		else
			new_data = (UWORD *)&col_data[old_len];
		
		for (x = 0; x < len; x++)
		{
			mask = 0xffff;
	
			for (i = 0; i < old_len; i += len)
				mask &= (UWORD)col_data[x+i];
			
			if (mask)
				for (i = 0; i < rest_len; i += len)
					new_data[x+i] |= mask;
		}

		if (s != NULL)	/* convertir au format universel */
		{
			d = *s;
			d.fd_stand = 0;
			if ((d.fd_addr = malloc (len * 2 * new_planes)) == NULL)
				d.fd_addr = s->fd_addr;
			
			vr_trnfm (app->graf.handle, s, &d);
			if (d.fd_addr != s->fd_addr)
			{
				memcpy (s->fd_addr, d.fd_addr, len * 2 * new_planes);
				free (d.fd_addr);
			}
		}
	}
	else	/* TrueColor, valeur de points en RVB */
	{
		if (!xpixelbytes || s == NULL)
		{
			for (i = 0; i < new_planes; i++)
				mul[i] = i * len;
			
			if (old_planes < 8)
			{
				maxcol = (1 << old_planes) - 1;
				memcpy (old_col, fix->farbtbl[maxcol], new_planes * sizeof (WORD));
				memset (fix->farbtbl[maxcol], 0, new_planes * sizeof (WORD));
			}
	
			if (s != NULL)
			{
				new_data = &((UWORD *)s->fd_addr)[old_len];
				memset (new_data, 0, rest_len * 2);
				memcpy (s->fd_addr, col_data, old_len * 2);
				col_data = s->fd_addr;
			}
			
			for (x = 0; x < len; x++)
			{
				bit = 1;
				for (np = 0; np < old_planes; np++)
					back[np] = col_data[mul[np] + x];
				
				for (pixel = 0; pixel < 16; pixel++)
				{
					color = 0;
					for (np = 0; np < old_planes; np++)
					{
						color += ((back[np] & 1) << np);
						back[np] >>= 1;
					}
					
					for (np = 0; np < new_planes; np++)
					{	pos = mul[np] + x;
						col_data[pos] = (col_data[pos] & ~bit) | (fix->farbtbl[color][np] & bit);
					}
					
					bit <<= 1;
				}
			}
			if (old_planes < 8)
				memcpy (fix->farbtbl[maxcol], old_col, new_planes * sizeof (WORD));

			if (s != NULL)	/* convertir au format universel */
			{
				d = *s;
				d.fd_stand = 0;
				if ((d.fd_addr = malloc (len * 2 * new_planes)) == NULL)
					d.fd_addr = s->fd_addr;
				
				vr_trnfm (app->graf.handle, s, &d);
				if (d.fd_addr != s->fd_addr)
				{
					memcpy (s->fd_addr, d.fd_addr, len * 2 * new_planes);
					free (d.fd_addr);
				}
			}
		}
		else
			std_to_byte (col_data, len, old_planes, fix->farbtbl2, s);
	}
}

/*****************************************************************************/
/* std_to_byte transforme un dessin du format standard au format             */
/* universel (pour les rsolutions >= 16 Plans)                              */
/*****************************************************************************/

static void std_to_byte (col_data, len, old_planes, farbtbl2, s)
UWORD *col_data;
LONG  len;
WORD  old_planes;
ULONG *farbtbl2;
MFDB  *s;

{	LONG  x, i, mul[32], pos;
	UWORD np, *new_data, pixel, color, back[32];
	WORD  memflag = FALSE;
	UBYTE *p1, *p2;
	ULONG  colback=0;

	if (s->fd_addr == col_data)
	{
		if ((col_data = malloc (len * 2 * s->fd_nplanes)) == NULL)
			return;
		memcpy (col_data, s->fd_addr, len * 2 * s->fd_nplanes);
		memflag = TRUE;
	}
	new_data = (UWORD *)s->fd_addr;
	p1 = (UBYTE *)new_data;

	if (old_planes < 8)
	{
		colback = farbtbl2[(1 << old_planes) - 1];
		farbtbl2[(1 << old_planes) - 1] = farbtbl2[255];
	}
		
	for (i = 0; i < old_planes; i++)
		mul[i] = i * len;
	
	pos = 0;
	
	for (x = 0; x < len; x++)
	{
		for (np = 0; np < old_planes; np++)
			back[np] = col_data[mul[np] + x];
		
		for (pixel = 0; pixel < 16; pixel++)
		{
			color = 0;
			for (np = 0; np < old_planes; np++)
			{
				color |= ((back[np] & 0x8000) >> (15 - np));
				back[np] <<= 1;
			}
			
			switch (xpixelbytes)
			{
				case 2:
					new_data[pos++] = *(UWORD *)&farbtbl2[color];
					break;

				case 3:
					p2 = (UBYTE *)&farbtbl2[color];
					*(p1++) = *(p2++);
					*(p1++) = *(p2++);
					*(p1++) = *(p2++);
					break;

				case 4:
					((ULONG *)new_data)[pos++] = farbtbl2[color];
					break;
			}
		}
	}

	if (old_planes < 8)
		farbtbl2[(1 << old_planes) - 1] = colback;

	if (memflag)
		free (col_data);
}

/*****************************************************************************/
/* dessine l'icne couleur                                                        */
/*****************************************************************************/


short __CDECL cdecl_draw_cicon( long vdih, OBJECT *tree, long ob, long ob_state, long ob_x, long ob_y)
{
	WORD	 	x, y, m_mode, i_mode=0, mskcol, icncol;
	INT16		pxy[4], dummy;
	INT16		fatr[10],tatr[10];
	INT16       mindex[2], iindex[2];
	LONG	 	ob_spec;
	ICONBLK 	*iconblk;
	CICON   	*cicn;
	INT16    	*mask, *data, *dark = NULL;
	BYTE    	letter[2];
	int    		selected, buf, eff;
	int 		invert = FALSE;

   	vqt_attributes(vdih,tatr);
   	vqf_attributes(vdih,fatr);

	selected = ob_state & SELECTED;
	
	ob_spec	= ((W_PARM *)(tree[ob].ob_spec.userblk->ub_parm))->wp_spec;

	iconblk = (ICONBLK *)ob_spec;
	cicn    = ((CICONBLK *)ob_spec)->mainlist;
	
	m_mode  = MD_TRANS;

	if (selected) /* it was an objc_change */
	{
		if (cicn->sel_data != NULL)
		{
			mask = cicn->sel_mask;
			data = cicn->sel_data;
			if (cicn->num_planes > 1)
			{	if (cicn->num_planes > 8)
					i_mode = S_AND_D;
				else
					i_mode = S_OR_D;
			}
			else
				i_mode = MD_TRANS;
		}
		else
		{
			mask = cicn->col_mask;
			data = cicn->col_data;

			if (cicn->num_planes > 1)
			{	if (cicn->num_planes > 8)
					i_mode = S_AND_D;
				else
					i_mode = S_OR_D;
				dark = cicn->sel_mask;
			}
			else
				invert = TRUE;
		}
	}
	else
	{
		mask = cicn->col_mask;
		data = cicn->col_data;
	
		if (cicn->num_planes > 1)
		{	if (cicn->num_planes > 8)
				i_mode = S_AND_D;
			else
				i_mode = S_OR_D;
		}
		else
			i_mode = MD_TRANS;
	}
	
	mindex [0] = ((iconblk->ib_char & 0x0f00) != 0x0100) ? (iconblk->ib_char & 0x0f00) >> 8 : WHITE;
	mindex [1] = WHITE;
	
	icncol = iindex[0] = (WORD)(((UWORD)iconblk->ib_char & 0xf000U) >> 12U);
	iindex[1] = WHITE;

	mskcol = (iconblk->ib_char & 0x0f00) >> 8;

	x = ob_x + iconblk->ib_xicon;
	y = ob_y + iconblk->ib_yicon;

	if (invert)
	{
		buf       = iindex[0];
		iindex[0] = mindex[0];
		mindex[0] = buf;
		i_mode    = MD_TRANS;
	}
	if (selected)
	{
		buf    = icncol;
		icncol = mskcol;
		mskcol = buf;
	}
	
	draw_bitblk (vdih, mask, x, y, iconblk->ib_wicon, iconblk->ib_hicon, 1, m_mode, mindex);
	draw_bitblk (vdih, data, x, y, iconblk->ib_wicon, iconblk->ib_hicon, cicn->num_planes, i_mode, iindex);
	
	if (dark)
	{
		mindex [0] = BLACK;
		mindex [1] = WHITE;
		draw_bitblk (vdih, dark, x, y, iconblk->ib_wicon, iconblk->ib_hicon, 1, MD_TRANS, mindex);
	}

	if (iconblk->ib_ptext[0]) {
		x = ob_x + iconblk->ib_xtext;
		y = ob_y + iconblk->ib_ytext;
		
		pxy[0] = x;
		pxy[1] = y;
		pxy[2] = x + iconblk->ib_wtext - 1;
		pxy[3] = y + iconblk->ib_htext - 1;
		
		vswr_mode     (vdih, MD_REPLACE);
		vsf_color     (vdih, mskcol);
		vsf_interior  (vdih, FIS_SOLID );
		vsf_perimeter (vdih, FALSE);
		if( !(ob_state & OS_STATE08) || selected)
			v_bar     (vdih, pxy);
	}

	vswr_mode     (vdih, MD_TRANS);
  	vst_font      (vdih, 1);	/* Systemfont */
	vst_height    (vdih, 4, &dummy, &dummy, &dummy, &dummy);
  	vst_color     (vdih, icncol);
  	vst_alignment (vdih, TA_LEFT, TA_ASCENT, &dummy, &dummy);
  	vst_rotation  (vdih, 0);
	
	eff = TXT_NORMAL;
	if( ob_state & OS_STATE09)  eff |= TXT_THICKENED;
	if( ob_state & OS_STATE10) eff |= TXT_UNDERLINED;
	if( ob_state & OS_STATE11) eff |= TXT_SKEWED;
  	vst_effects   (vdih, eff);

	if (iconblk->ib_ptext[0]) {	
		x += (iconblk->ib_wtext - strlen (iconblk->ib_ptext) * 6) / 2;
		y += (iconblk->ib_htext - 6) / 2;
		
		v_gtext (vdih, x, y, iconblk->ib_ptext);
	}

	letter[0] = iconblk->ib_char & 0xff;
	if (letter[0])
	{
		letter[1] = '\0';
		x = ob_x + iconblk->ib_xicon + iconblk->ib_xchar;
		y = ob_y + iconblk->ib_yicon + iconblk->ib_ychar;
	
		v_gtext (vdih, x, y, letter);
	}

	/* restore old settings */
	vsf_color		(vdih,fatr[1]);
	vsf_interior	(vdih,fatr[0]);
	vsf_perimeter	(vdih,fatr[4]);
  	vst_font		(vdih,tatr[0]);
	vst_height		(vdih,tatr[7],&dummy,&dummy,&dummy,&dummy);
  	vst_color		(vdih,tatr[1]);
  	vst_alignment	(vdih,tatr[3],tatr[4],&dummy,&dummy);
  	vst_rotation	(vdih,tatr[2]);
  	vst_effects		(vdih,TXT_NORMAL);
	vswr_mode		(vdih,MD_REPLACE);
	
	return 0;
}


static short __CDECL xdraw_cicon (PARMBLK *pb)
{
	APPvar *app;
	short tabclip[4];
	short vdih;
	
	app = (((W_PARM *)(pb->pb_parm))->wp_app);
	vdih = app->graf.handle;

	grect_to_array( (GRECT *)&pb->pb_xc, tabclip);
	vs_clip (vdih, TRUE, tabclip);
	
	cdecl_draw_cicon( vdih, pb->pb_tree, pb->pb_obj, pb->pb_currstate, pb->pb_x, pb->pb_y);
	
	vs_clip_off( vdih);

	return (pb->pb_currstate & ~ SELECTED);
}

/*****************************************************************************/

static void draw_bitblk (short vdih, WORD *p, WORD x, WORD y, WORD w, WORD h, WORD num_planes, WORD mode, INT16 *_index)
{
	INT16	 	pxy[8];
	MFDB	 	s, d;

	d.fd_addr	   = NULL; /* screen */
	s.fd_addr    = (void *)p;
	s.fd_w       = w;
	s.fd_h       = h;
	s.fd_wdwidth = w >> 4;
	s.fd_stand   = FALSE;
	s.fd_nplanes = num_planes;

	pxy[0] = 0;
	pxy[1] = 0;
 	pxy[2] = s.fd_w - 1;
 	pxy[3] = s.fd_h - 1;

	pxy[4] = x;
	pxy[5] = y;
	pxy[6] = pxy[4] + pxy [2];
	pxy[7] = pxy[5] + pxy [3];

	if (num_planes > 1)
		vro_cpyfm (vdih, mode, pxy, &s, &d);
	else
		vrt_cpyfm (vdih, mode, pxy, &s, &d, _index);
}

/**
 * @brief Fix color icons to the current screen resolution.
 *
 * @param app application descriptor,
 * @param object pointer to an objects tree,
 * @param num_obs number of objects in \e object,
 * @param num_cib number of color icons in \e object,
 * @param palette color palette,
 * @param _fix pointer to a structure containing the fixed icons. 
 *
 * mt_RsrcFixCicon() fixes the color icons to the current resolution. When
 * a resource file is loaded by mt_RsrcLoad(), color icon are fixed by
 * AES. mt_RsrcXload() fixes icon colors too.
 * The parameter  \e palette  is optional and  can be set to
 * \b NULL. This parameter is provided by the RSH file (created by resource
 * editor program). After the call of mt_RsrcFixCicon(), the structure  
 * \b _fix is filled with the fixed icon and will be released by calling 
 * mt_RsrcFreeCicon().
 *
 * @sa mt_RsrcFreeCicon().
 */

void mt_RsrcFixCicon ( APPvar *app, OBJECT *object, int num_obs, int num_cib, INT16 palette[][4], void *_fix) {
	XRSRCFIX *fix = _fix;
	int    i, nub = 0;
	UWORD   type, xtype;
	OBJECT  *ob;
	
	fix->num_cib = num_cib;
	if (num_cib) {
		xpixelbytes = test_rez (app);
		
		if ((fix->obblk = (OBBLK *)malloc (num_cib * sizeof (OBBLK))) != 0L)
			memset (fix->obblk, 0, num_cib * sizeof (OBBLK));
		if ((fix->cicon_table = (CICON *)malloc (num_cib * sizeof (CICON))) != 0L)
			memset (fix->cicon_table, 0, num_cib * sizeof (CICON));

		if (palette != NULL) {
			fix->is_palette = TRUE;
			memcpy (fix->rgb_palette, palette, sizeof (fix->rgb_palette));
		} else
			fix->is_palette = FALSE;
		xfill_farbtbl (app, fix);
	}
	
	for (i = 0; i < num_obs; i++) {
		ob    = &object[i];
		type  = ob->ob_type & 0xFF;
		xtype = ob->ob_type & 0xff00;
				
		if (type == G_CICON) {	
			if (fix->obblk != NULL && fix->cicon_table != NULL)
			{
				if (xadd_cicon (app, (CICONBLK *)ob->ob_spec.index, ob, nub++, fix) == FALSE)
				{
					memset (&fix->cicon_table[nub-1], 0, sizeof (CICON));
					ob->ob_type = xtype | G_ICON;
				}
				/* L'icne et l'image monochrome devront plus tard tre transformes     */
				/* au format universel !                                                 */
			}
			else
				ob->ob_type = xtype | G_ICON;
		}
	}
}

/**
 * @brief Release from memory fixed color icons.
 *
 * @param app application descriptor,
 * @param _fix pointer filled in by mt_RsrcFixCicon().
 *
 * @sa mt_RsrcFixCicon()
 */

void mt_RsrcFreeCicon ( APPvar *app, void *_fix) {
	XRSRCFIX *fix = _fix;
	WORD i;
	
	if (fix->cicon_table != NULL) {
		for (i = 0; i < fix->num_cib; i++) {
			if (fix->cicon_table[i].num_planes > 1) {
				if (fix->cicon_table[i].col_data != NULL)
					free (fix->cicon_table[i].col_data);
				if (fix->cicon_table[i].sel_data != NULL)
					free (fix->cicon_table[i].sel_data);
				if (fix->cicon_table[i].sel_data == NULL && fix->cicon_table[i].sel_mask != NULL)
					free (fix->cicon_table[i].sel_mask);
			}
		}
		free (fix->cicon_table);
	}
	if (fix->obblk)
		free (fix->obblk);
}

