/*
 * This file does not contains any code. It contains only
 * additional documentation to compile with Doxygen
 *
 * $Id: main.c,v 1.3 2005/11/17 22:48:40 bercegeay Exp $
 */

/**
 * @mainpage windom documentation
 *
 * This is the documentation of WinDom, a high level GEM library.
 *
 * @par This documentation contains:
 *  \ref pagepres \n
 *  \ref pageinstall \n
 *  \ref pageusage \n
 *  \ref Reference\n
 *  \ref Tutorial (to introduce windom programming)\n
 *  \ref Extobjtype \n
 *  \ref UserdefAPI \n
 *  \ref Configfile \n
 *  \ref pagemigr \n
 *  \ref pagelgpl \n
 *  \ref pagelog  (\ref pagehist1)
 *
 *
 * @par Authors:
 * Arnaud Bercegeay \n
 * Stanislav Opichal\n
 * Dominique B&eacute;r&eacute;ziat
 *
 * @par Web site:
 * http://windom.sf.net
 *
 */

/** @page pagemigr some notes to migrate your windom1 application to windom2
 *
 *  @include CHANGES
 */

/** @page pagelgpl LGPL copyright notice, applicable to windom
 *
 *
 *  @include COPYRIGHT
 *
 */

/** @page pagelog ChangeLog generated by cvs2cl.pl
 *
 *
 *  @include ChangeLog
 *
 */

/**
 * @defgroup Reference Reference documentation
 * @brief reference documentation (each function, contant, type defined
 *  by windom are documented there)
 */

/** @addtogroup Reference
 * @{ */

/** 
 * @defgroup Application Application Library
 * @brief Group of functions devoted to parametrize the 
 * GEM application.
 */

/** 
 * @defgroup Avlib AV-protocol Library
 * @brief Group of functions devoted to handle efficiently the
 * AV protocol.
 */
 
/** 
 * @defgroup BubbleGEM BubbleGEM Library
 * @brief Group of functions devoted to handle efficiently the
 * BubbleGEM system.
 */
 
/** 
 * @defgroup Configuration Configuration Library
 * @brief Group of functions devoted to WinDom configuration
 * file management.
 */
 
/** 
 * @defgroup Data Data Library
 * @brief To link data to windows.
  */
 
/** 
 * @defgroup Event Event Library
 * @brief Catch and handle GEM events.
 */
 
/** 
 * @defgroup Formular Formular Library
 * @brief Display and handle formulars.
 */
 
/** 
 * @defgroup Mouse Mouse Library
 * @brief Utility functions related to mouse.
 */
 
/** 
 * @defgroup Frame Frame Library
 * @brief Divide windows into hierachical and independante frames.
 */

/** 
 * @defgroup Font Font Library
 * @brief Utility functions related to fonts.
 */

/** 
 * @defgroup Selector Selector Library
 * @brief File and Font selectors support.
 */

/** 
 * @defgroup Menu Menu Library
 * @brief Group of functions related to desktop and window menu handling.
 */

/** 
 * @defgroup Object Object Library
 * @brief Group of functions for controling efficiently AES objects.
 */

/** 
 * @defgroup Window Window Library
 * @brief Manipulate AES Windows in WinDom
 */

/** 
 * @defgroup Slider Slider Library
 * @brief Efficient management of slider objects in formulars.
 */

/** 
 * @defgroup Resource Resource Library
 * @brief Using external and internal resource file.
 */

/** 
 * @defgroup Inquire Inquire Library
 * @brief Group of functions inquiring to OS a feature.
 */

/** 
 * @defgroup Utility Utility Library
 * @brief Group of usefull and diverse functions.
 */

/** 
 * @defgroup List List Library
 * @brief Some usefull functions and macro to handle a 
 *        double chained list of any type of structure.
 *        Heavily internally used by windom.
 */

/**
 * @defgroup Callback Standard callback functions
 * @brief Group of predefined callback functions attributed by WindCreate().
 */

/** @defgroup Constants WinDom constants and macros
 * @brief Thematic list and signification of all WinDom constants and macro functions
 */

/** @addtogroup Constants
 * @{ */

/**
 * @defgroup macros Usefull macro functions
 */

/**
 * @defgroup win_status WS_ (Window Status) constants
 * @brief List of possible status for a window (field status).
 */

/**
 * @defgroup aes4_status AES4_ constants (variable app->aes4)
 * @brief List of possible values for variable \e app->aes4.
 */

/* @} */

/**
 * @defgroup Component Component Library
 * @brief Group of functions to manage COMPONENTs. This is quite experimental
 *        at the moment, but we need feedback to stabilise the component API, 
 *        so don't hesitate to give it a try, and moreover to stress this API !
 */

/* @} */

/**
 * @defgroup UserdefAPI External UserDef library (LDG) API
 * @brief definition of the API of an external userdef library.
 *
 *  ADD THERE some explanations about what is userdef.ldg and 
 *  recommandations like support of all extended objects type defined by windom (TODO)
 */

