/*
 * WinDom: a high level GEM library
 * Copyright (c) 1997-2006 windom authors (see AUTHORS file)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * $Source: /cvsroot/windom/windom/src/mouse.rsh,v $
 *
 * CVS info:
 *   $Author: bercegeay $
 *   $Date: 2006/01/03 13:52:34 $
 *   $Revision: 1.3 $
 */

/* GEM Resource C Source */

#include "mouse.h"

#if !defined(WHITEBAK)
#define WHITEBAK    0x0040
#endif
#if !defined(DRAW3D)
#define DRAW3D      0x0080
#endif

#define FLAGS9  0x0200
#define FLAGS10 0x0400
#define FLAGS11 0x0800
#define FLAGS12 0x1000
#define FLAGS13 0x2000
#define FLAGS14 0x4000
#define FLAGS15 0x8000
#define STATE8  0x0100
#define STATE9  0x0200
#define STATE10 0x0400
#define STATE11 0x0800
#define STATE12 0x1000
#define STATE13 0x2000
#define STATE14 0x4000
#define STATE15 0x8000

static WORD RSIB0MASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0x7FFE, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x0FF0
};

static WORD RSIB0DATA[] =
{ 0x0000, 0x07E0, 0x18F8, 0x20FC, 
  0x20FC, 0x40FE, 0x40FE, 0x40FE, 
  0x7F02, 0x7F02, 0x7F06, 0x3F04, 
  0x3F0C, 0x1F18, 0x07E0, 0x0000
};

static WORD RSIB1MASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0x7FFE, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x0FF0
};

static WORD RSIB1DATA[] =
{ 0x0000, 0x07E0, 0x1818, 0x201C, 
  0x203C, 0x703E, 0x7C7E, 0x7FFE, 
  0x7FFE, 0x7E3E, 0x7C0E, 0x3C04, 
  0x3804, 0x1818, 0x07E0, 0x0000
};

static WORD RSIB2MASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0x7FFE, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x0FF0
};

static WORD RSIB2DATA[] =
{ 0x0000, 0x07E0, 0x1818, 0x300C, 
  0x381C, 0x7C3E, 0x7E7E, 0x7FFE, 
  0x7FFE, 0x7E7E, 0x7C3E, 0x381C, 
  0x300C, 0x1818, 0x07E0, 0x0000
};

static WORD RSIB3MASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0x7FFE, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x0FF0
};

static WORD RSIB3DATA[] =
{ 0x0000, 0x07E0, 0x1818, 0x3804, 
  0x3C04, 0x7C0E, 0x7E3E, 0x7FFE, 
  0x7FFE, 0x7C7E, 0x703E, 0x203C, 
  0x201C, 0x1818, 0x07E0, 0x0000
};

static WORD RSIB4MASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0x7FFE, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x0FF0
};

static WORD RSIB4DATA[] =
{ 0x0000, 0x07E0, 0x1F18, 0x3F0C, 
  0x3F04, 0x7F06, 0x7F02, 0x7F02, 
  0x40FE, 0x40FE, 0x40FE, 0x20FC, 
  0x20FC, 0x18F8, 0x07E0, 0x0000
};

static WORD RSIB5MASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0x7FFE, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x0FF0
};

static WORD RSIB5DATA[] =
{ 0x0000, 0x07E0, 0x1FF8, 0x3FE4, 
  0x3FC4, 0x5FC2, 0x4782, 0x4182, 
  0x4182, 0x41E2, 0x43FA, 0x23FC, 
  0x27FC, 0x1FF8, 0x07E0, 0x0000
};

static WORD RSIB6MASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0x7FFE, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x0FF0
};

static WORD RSIB6DATA[] =
{ 0x0000, 0x07E0, 0x1FF8, 0x3FFC, 
  0x2FF4, 0x47E2, 0x43C2, 0x4182, 
  0x4182, 0x43C2, 0x47E2, 0x2FF4, 
  0x3FFC, 0x1FF8, 0x07E0, 0x0000
};

static WORD RSIB7MASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0x7FFE, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x0FF0
};

static WORD RSIB7DATA[] =
{ 0x0000, 0x07E0, 0x1FF8, 0x27FC, 
  0x23FC, 0x43FA, 0x41E2, 0x4182, 
  0x4182, 0x4782, 0x5FC2, 0x3FC4, 
  0x3FE4, 0x1FF8, 0x07E0, 0x0000
};

static ICONBLK rs_iconblk[] =
{ {RSIB0MASK, RSIB0DATA, "\0", 0x1000|'\0',
    8,   8,   0,   0,  16,  16,   0,   0,   0,   8},
  {RSIB1MASK, RSIB1DATA, "\0", 0x1000|'\0',
    8,   8,   0,   0,  16,  16,   0,   0,   0,   8},
  {RSIB2MASK, RSIB2DATA, "\0", 0x1000|'\0',
    8,   8,   0,   0,  16,  16,   0,   0,   0,   8},
  {RSIB3MASK, RSIB3DATA, "\0", 0x1000|'\0',
    8,   8,   0,   0,  16,  16,   0,   0,   0,   8},
  {RSIB4MASK, RSIB4DATA, "\0", 0x1000|'\0',
    8,   8,   0,   0,  16,  16,   0,   0,   0,   8},
  {RSIB5MASK, RSIB5DATA, "\0", 0x1000|'\0',
    8,   8,   0,   0,  16,  16,   0,   0,   0,   8},
  {RSIB6MASK, RSIB6DATA, "\0", 0x1000|'\0',
    8,   8,   0,   0,  16,  16,   0,   0,   0,   8},
  {RSIB7MASK, RSIB7DATA, "\0", 0x1000|'\0',
    8,   8,   0,   0,  16,  16,   0,   0,   0,   8}
};

static OBJECT rs_object[] =
{ 
  /******** Tree 0 MOUSE ****************************************************/
  {      -1,        1,        8, G_BOX             ,   /* Object 0  */
  FLAGS10, OUTLINED, {(LONG)0x00021100L},
  0x0000, 0x0000, 0x0024, 0x0807},
  {       2,       -1,       -1, G_ICON            ,   /* Object 1  */
  NONE, NORMAL, {(LONG)&rs_iconblk[0]},
  0x0104, 0x0F02, 0x0002, 0x0001},
  {       3,       -1,       -1, G_ICON            ,   /* Object 2  */
  NONE, NORMAL, {(LONG)&rs_iconblk[1]},
  0x0107, 0x0F02, 0x0002, 0x0001},
  {       4,       -1,       -1, G_ICON            ,   /* Object 3  */
  NONE, NORMAL, {(LONG)&rs_iconblk[2]},
  0x010A, 0x0F02, 0x0002, 0x0001},
  {       5,       -1,       -1, G_ICON            ,   /* Object 4  */
  NONE, NORMAL, {(LONG)&rs_iconblk[3]},
  0x010D, 0x0F02, 0x0002, 0x0001},
  {       6,       -1,       -1, G_ICON            ,   /* Object 5  */
  NONE, NORMAL, {(LONG)&rs_iconblk[4]},
  0x0110, 0x0F02, 0x0002, 0x0001},
  {       7,       -1,       -1, G_ICON            ,   /* Object 6  */
  NONE, NORMAL, {(LONG)&rs_iconblk[5]},
  0x0113, 0x0F02, 0x0002, 0x0001},
  {       8,       -1,       -1, G_ICON            ,   /* Object 7  */
  NONE, NORMAL, {(LONG)&rs_iconblk[6]},
  0x0116, 0x0F02, 0x0002, 0x0001},
  {       0,       -1,       -1, G_ICON            ,   /* Object 8  */
  LASTOB, NORMAL, {(LONG)&rs_iconblk[7]},
  0x0119, 0x0F02, 0x0002, 0x0001}
};

static OBJECT *rs_trindex[] =
{ &rs_object[0]    /* Tree  0 MOUSE            */
};
