/*
 * WinDom: a high level GEM library
 * Copyright (c) 1997-2006 windom authors (see AUTHORS file)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * $Source: /cvsroot/windom/windom/userdef/extended/wsystem.rsh,v $
 *
 * CVS info:
 *   $Author: bercegeay $
 *   $Date: 2006/01/03 14:52:21 $
 *   $Revision: 1.3 $
 */

/* GEM Resource C Source */

#include "wsystem.h"

#if !defined(WHITEBAK)
#define WHITEBAK    0x0040
#endif
#if !defined(DRAW3D)
#define DRAW3D      0x0080
#endif

#define FLAGS9  0x0200
#define FLAGS10 0x0400
#define FLAGS11 0x0800
#define FLAGS12 0x1000
#define FLAGS13 0x2000
#define FLAGS14 0x4000
#define FLAGS15 0x8000
#define STATE8  0x0100
#define STATE9  0x0200
#define STATE10 0x0400
#define STATE11 0x0800
#define STATE12 0x1000
#define STATE13 0x2000
#define STATE14 0x4000
#define STATE15 0x8000

static short RS0_MMASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0xFFFF, 
  0xFFFF, 0x7FFE, 0x3FFC, 0x0FF0
};

static short RS0_MDATA[] =
{ 0x0FF0, 0x381C, 0x6006, 0xC003, 
  0xC003, 0x6006, 0x381C, 0x0FF0
};

static short RS0_1CMASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0xFFFF, 
  0xFFFF, 0x7FFE, 0x3FFC, 0x0FF0
};

static short RS0_1CDATA[] =
{ 0x0FF0, 0x381C, 0x6006, 0xC003, 
  0xC003, 0x6006, 0x381C, 0x0FF0
};

static short RS0_1SMASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0xFFFF, 
  0xFFFF, 0x7FFE, 0x3FFC, 0x0FF0
};

static short RS0_1SDATA[] =
{ 0x0FF0, 0x381C, 0x63C6, 0xCFF3, 
  0xCFF3, 0x63C6, 0x381C, 0x0FF0
};

static short RS0_4CMASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0x7FFE, 
  0x7FFE, 0x3FFC, 0x0FF0, 0x0000
};

static short RS0_4CDATA[] =
{ 0x0030, 0x00EC, 0x0FFA, 0x1FFA, 
  0x0FF2, 0x078C, 0x0FF0, 0x0000, 
  0x0030, 0x00EC, 0x0FFA, 0x1FFA, 
  0x0FF2, 0x078C, 0x0FF0, 0x0000, 
  0x0030, 0x00EC, 0x0FFA, 0x1FFA, 
  0x0FF2, 0x078C, 0x0FF0, 0x0000, 
  0x0FF0, 0x301C, 0x4006, 0x4006, 
  0x400E, 0x307C, 0x0FF0, 0x0000
};

static short RS0_4SMASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0x7FFE, 
  0x7FFE, 0x3FFC, 0x0FF0, 0x0000
};

static short RS0_4SDATA[] =
{ 0x0FF0, 0x33E0, 0x4DB0, 0x5BD8, 
  0x5DB0, 0x3700, 0x0C00, 0x0000, 
  0x0FF0, 0x33E0, 0x4DB0, 0x5BD8, 
  0x5DB0, 0x3700, 0x0C00, 0x0000, 
  0x0FF0, 0x33E0, 0x4DB0, 0x5BD8, 
  0x5DB0, 0x3700, 0x0C00, 0x0000, 
  0x0FF0, 0x3C0C, 0x73C2, 0x67E2, 
  0x63C2, 0x380C, 0x0FF0, 0x0000
};

static short RS1_MMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
};

static short RS1_MDATA[] =
{ 0xFFFE, 0x8006, 0x8006, 0x8006, 
  0x8006, 0x8006, 0x8006, 0xFFFE
};

static short RS1_1CMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
};

static short RS1_1CDATA[] =
{ 0xFFFE, 0x8006, 0x8006, 0x8006, 
  0x8006, 0x8006, 0x8006, 0xFFFE
};

static short RS1_1SMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
};

static short RS1_1SDATA[] =
{ 0xFFFE, 0xC002, 0xDC72, 0xC7C2, 
  0xC7C2, 0xDC72, 0xC002, 0xFFFE
};

static short RS1_4CMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
};

static short RS1_4CDATA[] =
{ 0x0002, 0x7FFE, 0x7FFE, 0x7FFE, 
  0x7FFE, 0x7FFE, 0x7FFE, 0xFFFE, 
  0x0002, 0x7FFE, 0x7FFE, 0x7FFE, 
  0x7FFE, 0x7FFE, 0x7FFE, 0xFFFE, 
  0x0002, 0x7FFE, 0x7FFE, 0x7FFE, 
  0x7FFE, 0x7FFE, 0x7FFE, 0xFFFE, 
  0x0002, 0x0002, 0x0002, 0x0002, 
  0x0002, 0x0002, 0x0002, 0xFFFE
};

static short RS1_4SMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
};

static short RS1_4SDATA[] =
{ 0xFFFE, 0xFFFC, 0xFFFC, 0xFFFC, 
  0xFFFC, 0xFFFC, 0xFFFC, 0x8000, 
  0xFFFE, 0xFFFC, 0xFFFC, 0xFFFC, 
  0xFFFC, 0xFFFC, 0xFFFC, 0x8000, 
  0xFFFE, 0xFFFC, 0xFFFC, 0xFFFC, 
  0xFFFC, 0xFFFC, 0xFFFC, 0x8000, 
  0xFFFE, 0x8000, 0x9C70, 0x87C0, 
  0x87C0, 0x9C70, 0x8000, 0x8000
};

static short RS2_MMASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0xFFFF, 
  0xFFFF, 0x7FFE, 0x3FFC, 0x0FF0
};

static short RS2_MDATA[] =
{ 0x0FF0, 0x381C, 0x6006, 0xC003, 
  0xC003, 0x6006, 0x381C, 0x0FF0
};

static short RS2_1CMASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0xFFFF, 
  0xFFFF, 0x7FFE, 0x3FFC, 0x0FF0
};

static short RS2_1CDATA[] =
{ 0x0FF0, 0x381C, 0x6006, 0xC003, 
  0xC003, 0x6006, 0x381C, 0x0FF0
};

static short RS2_1SMASK[] =
{ 0x0FF0, 0x3FFC, 0x7FFE, 0xFFFF, 
  0xFFFF, 0x7FFE, 0x3FFC, 0x0FF0
};

static short RS2_1SDATA[] =
{ 0x0FF0, 0x381C, 0x63C6, 0xCFF3, 
  0xCFF3, 0x63C6, 0x381C, 0x0FF0
};

static short RS3_MMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
};

static short RS3_MDATA[] =
{ 0xFFFE, 0x8006, 0x8006, 0x8006, 
  0x8006, 0x8006, 0x8006, 0xFFFE
};

static short RS3_1CMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
};

static short RS3_1CDATA[] =
{ 0xFFFE, 0x8006, 0x8006, 0x8006, 
  0x8006, 0x8006, 0x8006, 0xFFFE
};

static short RS3_1SMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE
};

static short RS3_1SDATA[] =
{ 0xFFFE, 0xC002, 0xDC72, 0xC7C2, 
  0xC7C2, 0xDC72, 0xC002, 0xFFFE
};

static short RS4_MMASK[] =
{ 0x07C0, 0x1FF0, 0x3FF8, 0x7FFC, 
  0x7BBC, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0x7FFC, 0x7FFC, 
  0x3FF8, 0x1FF0, 0x07C0, 0x0000
};

static short RS4_MDATA[] =
{ 0x07C0, 0x1830, 0x2008, 0x400C, 
  0x4384, 0x84C6, 0x8866, 0x8866, 
  0x8CE6, 0x87CE, 0x438C, 0x401C, 
  0x3078, 0x1FF0, 0x07C0, 0x0000
};

static short RS4_1CMASK[] =
{ 0x07C0, 0x1FF0, 0x3FF8, 0x7FFC, 
  0x7BBC, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0x7FFC, 0x7FFC, 
  0x3FF8, 0x1FF0, 0x07C0, 0x0000
};

static short RS4_1CDATA[] =
{ 0x07C0, 0x1830, 0x2008, 0x400C, 
  0x4384, 0x84C6, 0x8866, 0x8866, 
  0x8CE6, 0x87CE, 0x438C, 0x401C, 
  0x3078, 0x1FF0, 0x07C0, 0x0000
};

static short RS4_1SMASK[] =
{ 0x07C0, 0x1FF0, 0x3FF8, 0x7FFC, 
  0x7FFC, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0x7FFC, 0x7FFC, 
  0x3FF8, 0x1FF0, 0x07C0, 0x0000
};

static short RS4_1SDATA[] =
{ 0x07C0, 0x1FF0, 0x3C38, 0x7004, 
  0x6004, 0xE1C2, 0xC262, 0xC432, 
  0xC432, 0xC672, 0x63E4, 0x61C4, 
  0x2008, 0x1830, 0x07C0, 0x0000
};

static short RS4_4CMASK[] =
{ 0x07C0, 0x1FF0, 0x3FF8, 0x7FFC, 
  0x7FFC, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0x7FFC, 0x7FFC, 
  0x3FF8, 0x1FF0, 0x07C0, 0x0000
};

static short RS4_4CDATA[] =
{ 0x07C0, 0x1830, 0x23C8, 0x4FFC, 
  0x5FFC, 0x9CFE, 0xBBFE, 0xBBFE, 
  0xBFFE, 0xBFFE, 0x5FFC, 0x5FFC, 
  0x3FF8, 0x1FF0, 0x07C0, 0x0000, 
  0x07C0, 0x1830, 0x23C8, 0x4FFC, 
  0x5FFC, 0x9CFE, 0xBBFE, 0xBBFE, 
  0xBFFE, 0xBFFE, 0x5FFC, 0x5FFC, 
  0x3FF8, 0x1FF0, 0x07C0, 0x0000, 
  0x07C0, 0x1830, 0x23C8, 0x4FFC, 
  0x5FFC, 0x9CFE, 0xBBFE, 0xBBFE, 
  0xBFFE, 0xBFFE, 0x5FFC, 0x5FFC, 
  0x3FF8, 0x1FF0, 0x07C0, 0x0000, 
  0x07C0, 0x1830, 0x2008, 0x400C, 
  0x4004, 0x8006, 0x8006, 0x8046, 
  0x8046, 0x818E, 0x400C, 0x401C, 
  0x3078, 0x1FF0, 0x07C0, 0x0000
};

static short RS4_4SMASK[] =
{ 0x07C0, 0x1FF0, 0x3FF8, 0x7FFC, 
  0x7FFC, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0x7FFC, 0x7FFC, 
  0x3FF8, 0x1FF0, 0x07C0, 0x0000
};

static short RS4_4SDATA[] =
{ 0x07C0, 0x1FF0, 0x3FF8, 0x7FF4, 
  0x7FF4, 0xFFFA, 0xFE7A, 0xFDFA, 
  0xFDFA, 0xFFF2, 0x7FF4, 0x7FE4, 
  0x2788, 0x1830, 0x07C0, 0x0000, 
  0x07C0, 0x1FF0, 0x3FF8, 0x7FF4, 
  0x7FF4, 0xFFFA, 0xFE7A, 0xFDFA, 
  0xFDFA, 0xFFF2, 0x7FF4, 0x7FE4, 
  0x2788, 0x1830, 0x07C0, 0x0000, 
  0x07C0, 0x1FF0, 0x3FF8, 0x7FF4, 
  0x7FF4, 0xFFFA, 0xFE7A, 0xFDFA, 
  0xFDFA, 0xFFF2, 0x7FF4, 0x7FE4, 
  0x2788, 0x1830, 0x07C0, 0x0000, 
  0x07C0, 0x1FF0, 0x3C38, 0x7004, 
  0x6004, 0xE002, 0xC002, 0xC002, 
  0xC022, 0xC022, 0x60C4, 0x6004, 
  0x2008, 0x1830, 0x07C0, 0x0000
};

static short RS5_MMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0x0000
};

static short RS5_MDATA[] =
{ 0xFFFE, 0x8006, 0x8006, 0x8006, 
  0x8006, 0x8006, 0x8006, 0x8006, 
  0x8006, 0x8006, 0x8006, 0x8006, 
  0x8006, 0xFFFE, 0xFFFE, 0x0000
};

static short RS5_1CMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0x0000
};

static short RS5_1CDATA[] =
{ 0xFFFE, 0x8006, 0x8006, 0x8006, 
  0x8006, 0x8006, 0x8006, 0x8006, 
  0x8006, 0x8006, 0x8006, 0x8006, 
  0x8006, 0xFFFE, 0xFFFE, 0x0000
};

static short RS5_1SMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0x0000
};

static short RS5_1SDATA[] =
{ 0xFFFE, 0xFFFE, 0xC002, 0xC01A, 
  0xC072, 0xD8E2, 0xF9C2, 0xFB82, 
  0xFF02, 0xFE02, 0xFC02, 0xD802, 
  0xC002, 0xC002, 0xFFFE, 0x0000
};

static short RS5_4CMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0x0000
};

static short RS5_4CDATA[] =
{ 0x0002, 0x0006, 0x3FFA, 0x3FFA, 
  0x3FFA, 0x3FFA, 0x3FFA, 0x3FFA, 
  0x3FFA, 0x3FFA, 0x3FFA, 0x3FFA, 
  0x3FFA, 0x0002, 0xFFFE, 0x0000, 
  0x0002, 0x0006, 0x3FFA, 0x3FFA, 
  0x3FFA, 0x3FFA, 0x3FFA, 0x3FFA, 
  0x3FFA, 0x3FFA, 0x3FFA, 0x3FFA, 
  0x3FFA, 0x0002, 0xFFFE, 0x0000, 
  0x0002, 0x0006, 0x3FFA, 0x3FFA, 
  0x3FFA, 0x3FFA, 0x3FFA, 0x3FFA, 
  0x3FFA, 0x3FFA, 0x3FFA, 0x3FFA, 
  0x3FFA, 0x0002, 0xFFFE, 0x0000, 
  0x0002, 0x0002, 0x0006, 0x0006, 
  0x0006, 0x0006, 0x0006, 0x0006, 
  0x0006, 0x0006, 0x0006, 0x0006, 
  0x0006, 0x7FFE, 0xFFFE, 0x0000
};

static short RS5_4SMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0x0000
};

static short RS5_4SDATA[] =
{ 0x0000, 0x0004, 0x3FF8, 0x3FF8, 
  0x3FF8, 0x3FF8, 0x3FF8, 0x3FF8, 
  0x3FF8, 0x3FF8, 0x3FF8, 0x3FF8, 
  0x3FF8, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0004, 0x3FF8, 0x3FF8, 
  0x3FF8, 0x3FF8, 0x3FF8, 0x3FF8, 
  0x3FF8, 0x3FF8, 0x3FF8, 0x3FF8, 
  0x3FF8, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0004, 0x3FF8, 0x3FF8, 
  0x3FF8, 0x3FF8, 0x3FF8, 0x3FF8, 
  0x3FF8, 0x3FF8, 0x3FF8, 0x3FF8, 
  0x3FF8, 0x0000, 0x0000, 0x0000, 
  0xFFFE, 0xFFF8, 0xC000, 0xC018, 
  0xC070, 0xD8E0, 0xF9C0, 0xFB80, 
  0xFF00, 0xFE00, 0xFC00, 0xD800, 
  0xC000, 0xC000, 0x8000, 0x0000
};

static short RS6_MMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0x0000
};

static short RS6_MDATA[] =
{ 0xFFFE, 0x8006, 0x8006, 0x8006, 
  0x8006, 0x8006, 0x8006, 0x8006, 
  0x8006, 0x8006, 0x8006, 0x8006, 
  0x8006, 0xFFFE, 0xFFFE, 0x0000
};

static short RS6_1CMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0x0000
};

static short RS6_1CDATA[] =
{ 0xFFFE, 0x8006, 0x8006, 0x8006, 
  0x8006, 0x8006, 0x8006, 0x8006, 
  0x8006, 0x8006, 0x8006, 0x8006, 
  0x8006, 0xFFFE, 0xFFFE, 0x0000
};

static short RS6_1SMASK[] =
{ 0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0xFFFE, 0x0000
};

static short RS6_1SDATA[] =
{ 0xFFFE, 0xFFFE, 0xC002, 0xC01A, 
  0xC072, 0xD8E2, 0xF9C2, 0xFB82, 
  0xFF02, 0xFE02, 0xFC02, 0xD802, 
  0xC002, 0xC002, 0xFFFE, 0x0000
};

static short RS7_MMASK[] =
{ 0x07C0, 0x1FF0, 0x3FF8, 0x7FFC, 
  0x7FFC, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFDE, 0x7FFC, 0x7FFC, 
  0x3FF8, 0x1FF0, 0x07C0, 0x0000
};

static short RS7_MDATA[] =
{ 0x07C0, 0x1830, 0x2008, 0x400C, 
  0x4384, 0x84C6, 0x8866, 0x8866, 
  0x8CE6, 0x87CE, 0x438C, 0x401C, 
  0x3078, 0x1FF0, 0x07C0, 0x0000
};

static short RS7_1CMASK[] =
{ 0x07C0, 0x1FF0, 0x3FF8, 0x7FFC, 
  0x7FFC, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFDE, 0x7FFC, 0x7FFC, 
  0x3FF8, 0x1FF0, 0x07C0, 0x0000
};

static short RS7_1CDATA[] =
{ 0x07C0, 0x1830, 0x2008, 0x400C, 
  0x4384, 0x84C6, 0x8866, 0x8866, 
  0x8CE6, 0x87CE, 0x438C, 0x401C, 
  0x3078, 0x1FF0, 0x07C0, 0x0000
};

static short RS7_1SMASK[] =
{ 0x07C0, 0x1FF0, 0x3FF8, 0x7FFC, 
  0x7FFC, 0xFFFE, 0xFFFE, 0xFFFE, 
  0xFFFE, 0xFFFE, 0x7FFC, 0x7FFC, 
  0x3FF8, 0x1FF0, 0x07C0, 0x0000
};

static short RS7_1SDATA[] =
{ 0x07C0, 0x1FF0, 0x3C38, 0x7004, 
  0x6004, 0xE1C2, 0xC262, 0xC432, 
  0xC432, 0xC672, 0x63E4, 0x61C4, 
  0x2008, 0x1830, 0x07C0, 0x0000
};

static short RS8_MMASK[] =
{ 0x4000, 0x4800, 0x4DE0, 0x4E18, 
  0x4F04, 0x4004, 0x4002, 0x5002, 
  0x5002, 0x5000, 0x4800, 0x483C, 
  0x461C, 0x41EC, 0x4004, 0x4000
};

static short RS8_MDATA[] =
{ 0x4000, 0x4800, 0x4DE0, 0x4E18, 
  0x4F04, 0x4004, 0x4002, 0x5002, 
  0x5002, 0x5000, 0x4800, 0x483C, 
  0x461C, 0x41EC, 0x4004, 0x4000
};

static short RS8_1CMASK[] =
{ 0x4000, 0x4800, 0x4DE0, 0x4E18, 
  0x4F04, 0x4004, 0x4002, 0x5002, 
  0x5002, 0x5000, 0x4800, 0x483C, 
  0x461C, 0x41EC, 0x4004, 0x4000
};

static short RS8_1CDATA[] =
{ 0x4000, 0x4800, 0x4DE0, 0x4E18, 
  0x4F04, 0x4004, 0x4002, 0x5002, 
  0x5002, 0x5000, 0x4800, 0x483C, 
  0x461C, 0x41EC, 0x4004, 0x4000
};

static short RS8_1SMASK[] =
{ 0x4000, 0x4000, 0x4180, 0x461E, 
  0x481C, 0x481C, 0x5012, 0x5002, 
  0x5002, 0x5202, 0x4E04, 0x4E04, 
  0x5E18, 0x4060, 0x4000, 0x4000
};

static short RS8_1SDATA[] =
{ 0x4000, 0x4000, 0x4180, 0x461E, 
  0x481C, 0x481C, 0x5012, 0x5002, 
  0x5002, 0x5202, 0x4E04, 0x4E04, 
  0x5E18, 0x4060, 0x4000, 0x4000
};

static short RS8_4CMASK[] =
{ 0xC000, 0xC800, 0xCDE0, 0xCE18, 
  0xCF04, 0xC004, 0xC002, 0xD002, 
  0xD002, 0xD000, 0xC800, 0xC83C, 
  0xC61C, 0xC1EC, 0xC004, 0xC000
};

static short RS8_4CDATA[] =
{ 0x0000, 0x0800, 0x0DE0, 0x0E18, 
  0x0F04, 0x0004, 0x0002, 0x1002, 
  0x1002, 0x1000, 0x0800, 0x083C, 
  0x061C, 0x01EC, 0x0004, 0x0000, 
  0x0000, 0x0800, 0x0DE0, 0x0E18, 
  0x0F04, 0x0004, 0x0002, 0x1002, 
  0x1002, 0x1000, 0x0800, 0x083C, 
  0x061C, 0x01EC, 0x0004, 0x0000, 
  0x0000, 0x0800, 0x0DE0, 0x0E18, 
  0x0F04, 0x0004, 0x0002, 0x1002, 
  0x1002, 0x1000, 0x0800, 0x083C, 
  0x061C, 0x01EC, 0x0004, 0x0000, 
  0x8000, 0x8800, 0x8DE0, 0x8E18, 
  0x8F04, 0x8004, 0x8002, 0x9002, 
  0x9002, 0x9000, 0x8800, 0x883C, 
  0x861C, 0x81EC, 0x8004, 0x8000
};

static short RS8_4SMASK[] =
{ 0xC000, 0xC000, 0xC180, 0xC61E, 
  0xC81C, 0xC81C, 0xD012, 0xD002, 
  0xD002, 0xD202, 0xCE04, 0xCE04, 
  0xDE18, 0xC060, 0xC000, 0xC000
};

static short RS8_4SDATA[] =
{ 0x0000, 0x0000, 0x0180, 0x061E, 
  0x081C, 0x081C, 0x1012, 0x1002, 
  0x1002, 0x1202, 0x0E04, 0x0E04, 
  0x1E18, 0x0060, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0180, 0x061E, 
  0x081C, 0x081C, 0x1012, 0x1002, 
  0x1002, 0x1202, 0x0E04, 0x0E04, 
  0x1E18, 0x0060, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x0180, 0x061E, 
  0x081C, 0x081C, 0x1012, 0x1002, 
  0x1002, 0x1202, 0x0E04, 0x0E04, 
  0x1E18, 0x0060, 0x0000, 0x0000, 
  0x8000, 0x8000, 0x8180, 0x861E, 
  0x881C, 0x881C, 0x9012, 0x9002, 
  0x9002, 0x9202, 0x8E04, 0x8E04, 
  0x9E18, 0x8060, 0x8000, 0x8000
};

static short RS9_MMASK[] =
{ 0x4000, 0x57F0, 0x5808, 0x5C00, 
  0x401C, 0x480C, 0x47F4, 0x4000
};

static short RS9_MDATA[] =
{ 0x4000, 0x57F0, 0x5808, 0x5C00, 
  0x401C, 0x480C, 0x47F4, 0x4000
};

static short RS9_1CMASK[] =
{ 0x4000, 0x57F0, 0x5808, 0x5C00, 
  0x401C, 0x480C, 0x47F4, 0x4000
};

static short RS9_1CDATA[] =
{ 0x4000, 0x57F0, 0x5808, 0x5C00, 
  0x401C, 0x480C, 0x47F4, 0x4000
};

static short RS9_1SMASK[] =
{ 0x4000, 0x479C, 0x4818, 0x5014, 
  0x5404, 0x4C08, 0x5CF0, 0x4000
};

static short RS9_1SDATA[] =
{ 0x4000, 0x479C, 0x4818, 0x5014, 
  0x5404, 0x4C08, 0x5CF0, 0x4000
};

static short RS9_4CMASK[] =
{ 0xC000, 0xD7F0, 0xD808, 0xDC00, 
  0xC01C, 0xC80C, 0xC7F4, 0xC000
};

static short RS9_4CDATA[] =
{ 0x0000, 0x17F0, 0x1808, 0x1C00, 
  0x001C, 0x080C, 0x07F4, 0x0000, 
  0x0000, 0x17F0, 0x1808, 0x1C00, 
  0x001C, 0x080C, 0x07F4, 0x0000, 
  0x0000, 0x17F0, 0x1808, 0x1C00, 
  0x001C, 0x080C, 0x07F4, 0x0000, 
  0x8000, 0x97F0, 0x9808, 0x9C00, 
  0x801C, 0x880C, 0x87F4, 0x8000
};

static short RS9_4SMASK[] =
{ 0xC000, 0xC79C, 0xC818, 0xD014, 
  0xD404, 0xCC08, 0xDCF0, 0xC000
};

static short RS9_4SDATA[] =
{ 0x0000, 0x079C, 0x0818, 0x1014, 
  0x1404, 0x0C08, 0x1CF0, 0x0000, 
  0x0000, 0x079C, 0x0818, 0x1014, 
  0x1404, 0x0C08, 0x1CF0, 0x0000, 
  0x0000, 0x079C, 0x0818, 0x1014, 
  0x1404, 0x0C08, 0x1CF0, 0x0000, 
  0x8000, 0x879C, 0x8818, 0x9014, 
  0x9404, 0x8C08, 0x9CF0, 0x8000
};

static short RS10_MMASK[] =
{ 0xC000, 0xC800, 0xCDE0, 0xCE18, 
  0xCF04, 0xC004, 0xC002, 0xD002, 
  0xD002, 0xD000, 0xC800, 0xC83C, 
  0xC61C, 0xC1EC, 0xC004, 0xC000
};

static short RS10_MDATA[] =
{ 0x4000, 0x4800, 0x4DE0, 0x4E18, 
  0x4F04, 0x4004, 0x4002, 0x5002, 
  0x5002, 0x5000, 0x4800, 0x483C, 
  0x461C, 0x41EC, 0x4004, 0x4000
};

static short RS10_1CMASK[] =
{ 0xC000, 0xC800, 0xCDE0, 0xCE18, 
  0xCF04, 0xC004, 0xC002, 0xD002, 
  0xD002, 0xD000, 0xC800, 0xC83C, 
  0xC61C, 0xC1EC, 0xC004, 0xC000
};

static short RS10_1CDATA[] =
{ 0x4000, 0x4800, 0x4DE0, 0x4E18, 
  0x4F04, 0x4004, 0x4002, 0x5002, 
  0x5002, 0x5000, 0x4800, 0x483C, 
  0x461C, 0x41EC, 0x4004, 0x4000
};

static short RS10_1SMASK[] =
{ 0xC000, 0xC000, 0xC180, 0xC61E, 
  0xC81C, 0xC81C, 0xD012, 0xD002, 
  0xD002, 0xD202, 0xCE04, 0xCE04, 
  0xDE18, 0xC060, 0xC000, 0xC000
};

static short RS10_1SDATA[] =
{ 0x4000, 0x4000, 0x4180, 0x461E, 
  0x481C, 0x481C, 0x5012, 0x5002, 
  0x5002, 0x5202, 0x4E04, 0x4E04, 
  0x5E18, 0x4060, 0x4000, 0x4000
};

static short RS11_MMASK[] =
{ 0xC000, 0xD7F0, 0xD808, 0xDC00, 
  0xC01C, 0xC80C, 0xC7F4, 0xC000
};

static short RS11_MDATA[] =
{ 0x4000, 0x57F0, 0x5808, 0x5C00, 
  0x401C, 0x480C, 0x47F4, 0x4000
};

static short RS11_1CMASK[] =
{ 0xC000, 0xD7F0, 0xD808, 0xDC00, 
  0xC01C, 0xC80C, 0xC7F4, 0xC000
};

static short RS11_1CDATA[] =
{ 0x4000, 0x57F0, 0x5808, 0x5C00, 
  0x401C, 0x480C, 0x47F4, 0x4000
};

static short RS11_1SMASK[] =
{ 0xC000, 0xC79C, 0xC818, 0xD014, 
  0xD404, 0xCC08, 0xDCF0, 0xC000
};

static short RS11_1SDATA[] =
{ 0x4000, 0x479C, 0x4818, 0x5014, 
  0x5404, 0x4C08, 0x5CF0, 0x4000
};

static short RS12_MMASK[] =
{ 0x0000, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x0000, 0x0000
};

static short RS12_MDATA[] =
{ 0x0000, 0x7FFC, 0x7FF8, 0x6008, 
  0x6008, 0x6008, 0x6008, 0x6008, 
  0x6008, 0x6008, 0x6008, 0x6008, 
  0x7FF8, 0x4000, 0x0000, 0x0000
};

static short RS12_1CMASK[] =
{ 0x0000, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x0000, 0x0000
};

static short RS12_1CDATA[] =
{ 0x0000, 0x7FFC, 0x7FF8, 0x6008, 
  0x6008, 0x6008, 0x6008, 0x6008, 
  0x6008, 0x6008, 0x6008, 0x6008, 
  0x7FF8, 0x4000, 0x0000, 0x0000
};

static short RS12_1SMASK[] =
{ 0x0000, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x0000, 0x0000
};

static short RS12_1SDATA[] =
{ 0x0000, 0x7FFC, 0x7FF8, 0x6008, 
  0x6C68, 0x6EE8, 0x67C8, 0x6388, 
  0x67C8, 0x6EE8, 0x6C68, 0x6008, 
  0x7FF8, 0x4000, 0x0000, 0x0000
};

static short RS12_4CMASK[] =
{ 0x0000, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x0000, 0x0000
};

static short RS12_4CDATA[] =
{ 0x0000, 0x0000, 0x3FF8, 0x2008, 
  0x2008, 0x2008, 0x2008, 0x2008, 
  0x2008, 0x2008, 0x2008, 0x2008, 
  0x3FF8, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x3FF8, 0x2008, 
  0x2008, 0x2008, 0x2008, 0x2008, 
  0x2008, 0x2008, 0x2008, 0x2008, 
  0x3FF8, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x3FF8, 0x2008, 
  0x2008, 0x2008, 0x2008, 0x2008, 
  0x2008, 0x2008, 0x2008, 0x2008, 
  0x3FF8, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x7FFC, 0x7FF8, 0x6000, 
  0x6000, 0x6000, 0x6000, 0x6000, 
  0x6000, 0x6000, 0x6000, 0x6000, 
  0x4000, 0x0000, 0x0000, 0x0000
};

static short RS12_4SMASK[] =
{ 0x0000, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x0000, 0x0000
};

static short RS12_4SDATA[] =
{ 0x0000, 0x0000, 0x3FF8, 0x2008, 
  0x2C68, 0x2EE8, 0x27C8, 0x2388, 
  0x27C8, 0x2EE8, 0x2C68, 0x2008, 
  0x3FF8, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x3FF8, 0x2008, 
  0x2C68, 0x2EE8, 0x27C8, 0x2388, 
  0x27C8, 0x2EE8, 0x2C68, 0x2008, 
  0x3FF8, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x0000, 0x3FF8, 0x2008, 
  0x2C68, 0x2EE8, 0x27C8, 0x2388, 
  0x27C8, 0x2EE8, 0x2C68, 0x2008, 
  0x3FF8, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x7FFC, 0x7FF8, 0x6000, 
  0x6C60, 0x6EE0, 0x67C0, 0x6380, 
  0x67C0, 0x6EE0, 0x6C60, 0x6000, 
  0x4000, 0x0000, 0x0000, 0x0000
};

static short RS13_MMASK[] =
{ 0x0000, 0x03C0, 0x0FF0, 0x1FF8, 
  0x3FFC, 0x3FFC, 0x7FFE, 0x7FFE, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x3FFC, 
  0x1FF8, 0x0FF0, 0x03C0, 0x0000
};

static short RS13_MDATA[] =
{ 0x0000, 0x03C0, 0x0C30, 0x1018, 
  0x200C, 0x2004, 0x4006, 0x4006, 
  0x4006, 0x400E, 0x200C, 0x301C, 
  0x1878, 0x0FF0, 0x03C0, 0x0000
};

static short RS13_1CMASK[] =
{ 0x0000, 0x03C0, 0x0FF0, 0x1FF8, 
  0x3FFC, 0x3FFC, 0x7FFE, 0x7FFE, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x3FFC, 
  0x1FF8, 0x0FF0, 0x03C0, 0x0000
};

static short RS13_1CDATA[] =
{ 0x0000, 0x03C0, 0x0C30, 0x1018, 
  0x200C, 0x2004, 0x4006, 0x4006, 
  0x4006, 0x400E, 0x200C, 0x301C, 
  0x1878, 0x0FF0, 0x03C0, 0x0000
};

static short RS13_1SMASK[] =
{ 0x0000, 0x03C0, 0x0FF0, 0x1FF8, 
  0x3FFC, 0x3FBC, 0x7FDE, 0x7FEE, 
  0x7FEE, 0x7FDE, 0x3FBC, 0x3FFC, 
  0x1FF8, 0x0FF0, 0x03C0, 0x0000
};

static short RS13_1SDATA[] =
{ 0x0000, 0x03C0, 0x0FF0, 0x1E18, 
  0x380C, 0x3184, 0x73C2, 0x67E2, 
  0x67E2, 0x63C2, 0x2184, 0x3004, 
  0x1808, 0x0C30, 0x03C0, 0x0000
};

static short RS13_4CMASK[] =
{ 0x0000, 0x03C0, 0x0FF0, 0x1FF8, 
  0x3FFC, 0x3FFC, 0x7FFE, 0x7FFE, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x3FFC, 
  0x1FF8, 0x0FF0, 0x03C0, 0x0000
};

static short RS13_4CDATA[] =
{ 0x0000, 0x0000, 0x0000, 0x01E8, 
  0x07F4, 0x0FFC, 0x0FFA, 0x1FFA, 
  0x1FFA, 0x1FF2, 0x1FF4, 0x0FE4, 
  0x1788, 0x0C30, 0x03C0, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x01E8, 
  0x07F4, 0x0FFC, 0x0FFA, 0x1FFA, 
  0x1FFA, 0x1FF2, 0x1FF4, 0x0FE4, 
  0x1788, 0x0C30, 0x03C0, 0x0000, 
  0x0000, 0x0000, 0x0000, 0x01E8, 
  0x07F4, 0x0FFC, 0x0FFA, 0x1FFA, 
  0x1FFA, 0x1FF2, 0x1FF4, 0x0FE4, 
  0x1788, 0x0C30, 0x03C0, 0x0000, 
  0x0000, 0x03C0, 0x0C30, 0x1008, 
  0x200C, 0x2004, 0x4006, 0x4006, 
  0x4006, 0x400E, 0x200C, 0x201C, 
  0x1878, 0x0FF0, 0x03C0, 0x0000
};

static short RS13_4SMASK[] =
{ 0x0000, 0x03C0, 0x0FF0, 0x1FF8, 
  0x3FFC, 0x3FFC, 0x7FFE, 0x7FFE, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x3FFC, 
  0x1FF8, 0x0FF0, 0x03C0, 0x0000
};

static short RS13_4SDATA[] =
{ 0x0000, 0x03C0, 0x0C30, 0x11E8, 
  0x27F0, 0x2DB8, 0x4BD8, 0x5FF8, 
  0x5FF8, 0x5BD0, 0x3DB0, 0x2FE0, 
  0x1780, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x03C0, 0x0C30, 0x11E8, 
  0x27F0, 0x2DB8, 0x4BD8, 0x5FF8, 
  0x5FF8, 0x5BD0, 0x3DB0, 0x2FE0, 
  0x1780, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x03C0, 0x0C30, 0x11E8, 
  0x27F0, 0x2DB8, 0x4BD8, 0x5FF8, 
  0x5FF8, 0x5BD0, 0x3DB0, 0x2FE0, 
  0x1780, 0x0000, 0x0000, 0x0000, 
  0x0000, 0x03C0, 0x0FF0, 0x1E18, 
  0x3804, 0x33C4, 0x77E2, 0x67E2, 
  0x67E2, 0x67E2, 0x23C4, 0x3004, 
  0x1008, 0x0C30, 0x03C0, 0x0000
};

static short RS14_MMASK[] =
{ 0x03C0, 0x0FF0, 0x3FFC, 0x7FFE, 
  0x7FFE, 0x3FFC, 0x1FF8, 0x07C0
};

static short RS14_MDATA[] =
{ 0x03C0, 0x0C30, 0x200C, 0x4006, 
  0x4006, 0x200C, 0x1878, 0x07C0
};

static short RS14_1CMASK[] =
{ 0x03C0, 0x0FF0, 0x3FFC, 0x7FFE, 
  0x7FFE, 0x3FFC, 0x1FF8, 0x07C0
};

static short RS14_1CDATA[] =
{ 0x03C0, 0x0C30, 0x200C, 0x4006, 
  0x4006, 0x200C, 0x1878, 0x07C0
};

static short RS14_1SMASK[] =
{ 0x03C0, 0x0FF0, 0x3FFC, 0x7FDE, 
  0x7FEE, 0x3FBC, 0x1FF8, 0x07E0
};

static short RS14_1SDATA[] =
{ 0x03C0, 0x0FF0, 0x380C, 0x73C2, 
  0x67E2, 0x2184, 0x1818, 0x07E0
};

static short RS14_4CMASK[] =
{ 0x03C0, 0x1FF0, 0x3FFC, 0x7FFE, 
  0x7FFE, 0x3FFC, 0x1FF8, 0x07C0
};

static short RS14_4CDATA[] =
{ 0x0000, 0x0000, 0x07F4, 0x0FFA, 
  0x1FFA, 0x1FF4, 0x1788, 0x07C0, 
  0x0000, 0x0000, 0x07F4, 0x0FFA, 
  0x1FFA, 0x1FF4, 0x1788, 0x07C0, 
  0x0000, 0x0000, 0x07F4, 0x0FFA, 
  0x1FFA, 0x1FF4, 0x1788, 0x07C0, 
  0x03C0, 0x1C30, 0x200C, 0x4006, 
  0x4006, 0x200C, 0x1878, 0x07C0
};

static short RS14_4SMASK[] =
{ 0x03C0, 0x0FF0, 0x3FFC, 0x7FFE, 
  0x7FFE, 0x3FFC, 0x1FF8, 0x07E0
};

static short RS14_4SDATA[] =
{ 0x03C0, 0x0C30, 0x27F0, 0x4BD8, 
  0x5FF8, 0x3DB0, 0x1380, 0x0000, 
  0x03C0, 0x0C30, 0x27F0, 0x4BD8, 
  0x5FF8, 0x3DB0, 0x1380, 0x0000, 
  0x03C0, 0x0C30, 0x27F0, 0x4BD8, 
  0x5FF8, 0x3DB0, 0x1380, 0x0000, 
  0x03C0, 0x0FF0, 0x3804, 0x77E2, 
  0x67E2, 0x23C4, 0x1818, 0x07E0
};

static short RS15_MMASK[] =
{ 0x0000, 0x0000, 0x3FFE, 0x3FFE, 
  0x3FFE, 0x3FFE, 0x3FFE, 0x3FFE, 
  0x3FFE, 0x3FFE, 0x3FFE, 0x3FFE, 
  0x3FFE, 0x3FFE, 0x3FFE, 0x0000
};

static short RS15_MDATA[] =
{ 0x0000, 0x0000, 0x3FFE, 0x3FFC, 
  0x3004, 0x3004, 0x3004, 0x3004, 
  0x3004, 0x3004, 0x3004, 0x3004, 
  0x3004, 0x3FFC, 0x2000, 0x0000
};

static short RS15_1CMASK[] =
{ 0x0000, 0x0000, 0x3FFE, 0x3FFE, 
  0x3FFE, 0x3FFE, 0x3FFE, 0x3FFE, 
  0x3FFE, 0x3FFE, 0x3FFE, 0x3FFE, 
  0x3FFE, 0x3FFE, 0x3FFE, 0x0000
};

static short RS15_1CDATA[] =
{ 0x0000, 0x0000, 0x3FFE, 0x3FFC, 
  0x3004, 0x3004, 0x3004, 0x3004, 
  0x3004, 0x3004, 0x3004, 0x3004, 
  0x3004, 0x3FFC, 0x2000, 0x0000
};

static short RS15_1SMASK[] =
{ 0x0000, 0x0000, 0x3FFE, 0x3FFE, 
  0x3FFE, 0x3FFE, 0x3FFE, 0x3FFE, 
  0x3FFE, 0x3FFE, 0x3FFE, 0x3FFE, 
  0x3FFE, 0x3FFE, 0x3FFE, 0x0000
};

static short RS15_1SDATA[] =
{ 0x0000, 0x0000, 0x3FFE, 0x3FFC, 
  0x3004, 0x3634, 0x3774, 0x33E4, 
  0x31C4, 0x33E4, 0x3774, 0x3634, 
  0x3004, 0x3FFC, 0x2000, 0x0000
};

static short RS16_MMASK[] =
{ 0x0000, 0x03C0, 0x0FF0, 0x1FF8, 
  0x3FFC, 0x3FFC, 0x7FFE, 0x7FFE, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x3FFC, 
  0x1FF8, 0x0FF0, 0x03C0, 0x0000
};

static short RS16_MDATA[] =
{ 0x0000, 0x03C0, 0x0C30, 0x1018, 
  0x200C, 0x2004, 0x4006, 0x4006, 
  0x4006, 0x400E, 0x200C, 0x301C, 
  0x1878, 0x0FF0, 0x03C0, 0x0000
};

static short RS16_1CMASK[] =
{ 0x0000, 0x03C0, 0x0FF0, 0x1FF8, 
  0x3FFC, 0x3FFC, 0x7FFE, 0x7FFE, 
  0x7FFE, 0x7FFE, 0x3FFC, 0x3FFC, 
  0x1FF8, 0x0FF0, 0x03C0, 0x0000
};

static short RS16_1CDATA[] =
{ 0x0000, 0x03C0, 0x0C30, 0x1018, 
  0x200C, 0x2004, 0x4006, 0x4006, 
  0x4006, 0x400E, 0x200C, 0x301C, 
  0x1878, 0x0FF0, 0x03C0, 0x0000
};

static short RS16_1SMASK[] =
{ 0x0000, 0x03C0, 0x0FF0, 0x1FF8, 
  0x3FFC, 0x3FBC, 0x7FDE, 0x7FEE, 
  0x7FEE, 0x7FDE, 0x3FBC, 0x3FFC, 
  0x1FF8, 0x0FF0, 0x03C0, 0x0000
};

static short RS16_1SDATA[] =
{ 0x0000, 0x03C0, 0x0FF0, 0x1E18, 
  0x380C, 0x3184, 0x73C2, 0x67E2, 
  0x67E2, 0x63C2, 0x2184, 0x3004, 
  0x1808, 0x0C30, 0x03C0, 0x0000
};

static short RS17_MMASK[] =
{ 0x03C0, 0x0FF0, 0x3FFC, 0x7FFE, 
  0x7FFE, 0x3FFC, 0x1FF8, 0x07C0
};

static short RS17_MDATA[] =
{ 0x03C0, 0x0C30, 0x200C, 0x4006, 
  0x4006, 0x200C, 0x1878, 0x07C0
};

static short RS17_1CMASK[] =
{ 0x03C0, 0x0FF0, 0x3FFC, 0x7FFE, 
  0x7FFE, 0x3FFC, 0x1FF8, 0x07C0
};

static short RS17_1CDATA[] =
{ 0x03C0, 0x0C30, 0x200C, 0x4006, 
  0x4006, 0x200C, 0x1878, 0x07C0
};

static short RS17_1SMASK[] =
{ 0x03C0, 0x0FF0, 0x3FFC, 0x7FDE, 
  0x7FEE, 0x3FBC, 0x1FF8, 0x07E0
};

static short RS17_1SDATA[] =
{ 0x03C0, 0x0FF0, 0x380C, 0x73C2, 
  0x67E2, 0x2184, 0x1818, 0x07E0
};

static short RS18_MMASK[] =
{ 0x0000, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x0000
};

static short RS18_MDATA[] =
{ 0x0000, 0x7FF8, 0x6008, 0x6008, 
  0x6008, 0x6008, 0x7FF8, 0x0000
};

static short RS18_1CMASK[] =
{ 0x0000, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x0000
};

static short RS18_1CDATA[] =
{ 0x0000, 0x7FF8, 0x6008, 0x6008, 
  0x6008, 0x6008, 0x7FF8, 0x0000
};

static short RS18_1SMASK[] =
{ 0x0000, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x0000
};

static short RS18_1SDATA[] =
{ 0x0000, 0x7FF8, 0x6C68, 0x67C8, 
  0x67C8, 0x6C68, 0x7FF8, 0x0000
};

static short RS18_4CMASK[] =
{ 0x0000, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x0000
};

static short RS18_4CDATA[] =
{ 0x0000, 0x3FF8, 0x2008, 0x2008, 
  0x2008, 0x2008, 0x3FF8, 0x0000, 
  0x0000, 0x3FF8, 0x2008, 0x2008, 
  0x2008, 0x2008, 0x3FF8, 0x0000, 
  0x0000, 0x3FF8, 0x2008, 0x2008, 
  0x2008, 0x2008, 0x3FF8, 0x0000, 
  0x0000, 0x7FF8, 0x6000, 0x6000, 
  0x6000, 0x6000, 0x4000, 0x0000
};

static short RS18_4SMASK[] =
{ 0x0000, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x0000
};

static short RS18_4SDATA[] =
{ 0x0000, 0x3FF8, 0x2C68, 0x27C8, 
  0x27C8, 0x2C68, 0x3FF8, 0x0000, 
  0x0000, 0x3FF8, 0x2C68, 0x27C8, 
  0x27C8, 0x2C68, 0x3FF8, 0x0000, 
  0x0000, 0x3FF8, 0x2C68, 0x27C8, 
  0x27C8, 0x2C68, 0x3FF8, 0x0000, 
  0x0000, 0x7FF8, 0x6C60, 0x67C0, 
  0x67C0, 0x6C60, 0x4000, 0x0000
};

static short RS19_MMASK[] =
{ 0x0000, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x0000
};

static short RS19_MDATA[] =
{ 0x0000, 0x7FF8, 0x6008, 0x6008, 
  0x6008, 0x6008, 0x7FF8, 0x0000
};

static short RS19_1CMASK[] =
{ 0x0000, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x0000
};

static short RS19_1CDATA[] =
{ 0x0000, 0x7FF8, 0x6008, 0x6008, 
  0x6008, 0x6008, 0x7FF8, 0x0000
};

static short RS19_1SMASK[] =
{ 0x0000, 0x7FFC, 0x7FFC, 0x7FFC, 
  0x7FFC, 0x7FFC, 0x7FFC, 0x0000
};

static short RS19_1SDATA[] =
{ 0x0000, 0x7FF8, 0x6C68, 0x67C8, 
  0x67C8, 0x6C68, 0x7FF8, 0x0000
};

#ifdef __SOZOBONX__
static CICON __rs_cicon[1] = {1,RS0_1CDATA, RS0_1CMASK, RS0_1SDATA, RS0_1SMASK,0L};
static CICON rs_cicon[] =
{ 1, RS0_1CDATA, RS0_1CMASK, RS0_1SDATA, RS0_1SMASK, &__rs_cicon[2],
  4, RS0_4CDATA, RS0_4CMASK, RS0_4SDATA, RS0_4SMASK, NULL,
  1, RS1_1CDATA, RS1_1CMASK, RS1_1SDATA, RS1_1SMASK, &__rs_cicon[4],
  4, RS1_4CDATA, RS1_4CMASK, RS1_4SDATA, RS1_4SMASK, NULL,
  1, RS2_1CDATA, RS2_1CMASK, RS2_1SDATA, RS2_1SMASK, NULL,
  1, RS3_1CDATA, RS3_1CMASK, RS3_1SDATA, RS3_1SMASK, NULL,
  1, RS4_1CDATA, RS4_1CMASK, RS4_1SDATA, RS4_1SMASK, &__rs_cicon[8],
  4, RS4_4CDATA, RS4_4CMASK, RS4_4SDATA, RS4_4SMASK, NULL,
  1, RS5_1CDATA, RS5_1CMASK, RS5_1SDATA, RS5_1SMASK, &__rs_cicon[10],
  4, RS5_4CDATA, RS5_4CMASK, RS5_4SDATA, RS5_4SMASK, NULL,
  1, RS6_1CDATA, RS6_1CMASK, RS6_1SDATA, RS6_1SMASK, NULL,
  1, RS7_1CDATA, RS7_1CMASK, RS7_1SDATA, RS7_1SMASK, NULL,
  1, RS8_1CDATA, RS8_1CMASK, RS8_1SDATA, RS8_1SMASK, &__rs_cicon[14],
  4, RS8_4CDATA, RS8_4CMASK, RS8_4SDATA, RS8_4SMASK, NULL,
  1, RS9_1CDATA, RS9_1CMASK, RS9_1SDATA, RS9_1SMASK, &__rs_cicon[16],
  4, RS9_4CDATA, RS9_4CMASK, RS9_4SDATA, RS9_4SMASK, NULL,
  1, RS10_1CDATA, RS10_1CMASK, RS10_1SDATA, RS10_1SMASK, NULL,
  1, RS11_1CDATA, RS11_1CMASK, RS11_1SDATA, RS11_1SMASK, NULL,
  1, RS12_1CDATA, RS12_1CMASK, RS12_1SDATA, RS12_1SMASK, &__rs_cicon[20],
  4, RS12_4CDATA, RS12_4CMASK, RS12_4SDATA, RS12_4SMASK, NULL,
  1, RS13_1CDATA, RS13_1CMASK, RS13_1SDATA, RS13_1SMASK, &__rs_cicon[22],
  4, RS13_4CDATA, RS13_4CMASK, RS13_4SDATA, RS13_4SMASK, NULL,
  1, RS14_1CDATA, RS14_1CMASK, RS14_1SDATA, RS14_1SMASK, &__rs_cicon[24],
  4, RS14_4CDATA, RS14_4CMASK, RS14_4SDATA, RS14_4SMASK, NULL,
  1, RS15_1CDATA, RS15_1CMASK, RS15_1SDATA, RS15_1SMASK, NULL,
  1, RS16_1CDATA, RS16_1CMASK, RS16_1SDATA, RS16_1SMASK, NULL,
  1, RS17_1CDATA, RS17_1CMASK, RS17_1SDATA, RS17_1SMASK, NULL,
  1, RS18_1CDATA, RS18_1CMASK, RS18_1SDATA, RS18_1SMASK, &__rs_cicon[29],
  4, RS18_4CDATA, RS18_4CMASK, RS18_4SDATA, RS18_4SMASK, NULL,
  1, RS19_1CDATA, RS19_1CMASK, RS19_1SDATA, RS19_1SMASK, NULL
};
#else
static CICON rs_cicon[] =
{ {1, RS0_1CDATA, RS0_1CMASK, RS0_1SDATA, RS0_1SMASK, &rs_cicon[1]},
  {4, RS0_4CDATA, RS0_4CMASK, RS0_4SDATA, RS0_4SMASK, NULL},
  {1, RS1_1CDATA, RS1_1CMASK, RS1_1SDATA, RS1_1SMASK, &rs_cicon[3]},
  {4, RS1_4CDATA, RS1_4CMASK, RS1_4SDATA, RS1_4SMASK, NULL},
  {1, RS2_1CDATA, RS2_1CMASK, RS2_1SDATA, RS2_1SMASK, NULL},
  {1, RS3_1CDATA, RS3_1CMASK, RS3_1SDATA, RS3_1SMASK, NULL},
  {1, RS4_1CDATA, RS4_1CMASK, RS4_1SDATA, RS4_1SMASK, &rs_cicon[7]},
  {4, RS4_4CDATA, RS4_4CMASK, RS4_4SDATA, RS4_4SMASK, NULL},
  {1, RS5_1CDATA, RS5_1CMASK, RS5_1SDATA, RS5_1SMASK, &rs_cicon[9]},
  {4, RS5_4CDATA, RS5_4CMASK, RS5_4SDATA, RS5_4SMASK, NULL},
  {1, RS6_1CDATA, RS6_1CMASK, RS6_1SDATA, RS6_1SMASK, NULL},
  {1, RS7_1CDATA, RS7_1CMASK, RS7_1SDATA, RS7_1SMASK, NULL},
  {1, RS8_1CDATA, RS8_1CMASK, RS8_1SDATA, RS8_1SMASK, &rs_cicon[13]},
  {4, RS8_4CDATA, RS8_4CMASK, RS8_4SDATA, RS8_4SMASK, NULL},
  {1, RS9_1CDATA, RS9_1CMASK, RS9_1SDATA, RS9_1SMASK, &rs_cicon[15]},
  {4, RS9_4CDATA, RS9_4CMASK, RS9_4SDATA, RS9_4SMASK, NULL},
  {1, RS10_1CDATA, RS10_1CMASK, RS10_1SDATA, RS10_1SMASK, NULL},
  {1, RS11_1CDATA, RS11_1CMASK, RS11_1SDATA, RS11_1SMASK, NULL},
  {1, RS12_1CDATA, RS12_1CMASK, RS12_1SDATA, RS12_1SMASK, &rs_cicon[19]},
  {4, RS12_4CDATA, RS12_4CMASK, RS12_4SDATA, RS12_4SMASK, NULL},
  {1, RS13_1CDATA, RS13_1CMASK, RS13_1SDATA, RS13_1SMASK, &rs_cicon[21]},
  {4, RS13_4CDATA, RS13_4CMASK, RS13_4SDATA, RS13_4SMASK, NULL},
  {1, RS14_1CDATA, RS14_1CMASK, RS14_1SDATA, RS14_1SMASK, &rs_cicon[23]},
  {4, RS14_4CDATA, RS14_4CMASK, RS14_4SDATA, RS14_4SMASK, NULL},
  {1, RS15_1CDATA, RS15_1CMASK, RS15_1SDATA, RS15_1SMASK, NULL},
  {1, RS16_1CDATA, RS16_1CMASK, RS16_1SDATA, RS16_1SMASK, NULL},
  {1, RS17_1CDATA, RS17_1CMASK, RS17_1SDATA, RS17_1SMASK, NULL},
  {1, RS18_1CDATA, RS18_1CMASK, RS18_1SDATA, RS18_1SMASK, &rs_cicon[28]},
  {4, RS18_4CDATA, RS18_4CMASK, RS18_4SDATA, RS18_4SMASK, NULL},
  {1, RS19_1CDATA, RS19_1CMASK, RS19_1SDATA, RS19_1SMASK, NULL}
};
#endif

static CICONBLK rs_ciconblk[] =
{ {{RS0_MMASK, RS0_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,   8,   5,   1,   6,   8}, &rs_cicon[0]},
  {{RS1_MMASK, RS1_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,   8,   5,   1,   6,   8}, &rs_cicon[2]},
  {{RS2_MMASK, RS2_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,   8,   5,   1,   6,   8}, &rs_cicon[4]},
  {{RS3_MMASK, RS3_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,   8,   5,   1,   6,   8}, &rs_cicon[5]},
  {{RS4_MMASK, RS4_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,  16,   5,   5,   6,   8}, &rs_cicon[6]},
  {{RS5_MMASK, RS5_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,  16,   5,   5,   6,   8}, &rs_cicon[8]},
  {{RS6_MMASK, RS6_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,  16,   5,   5,   6,   8}, &rs_cicon[10]},
  {{RS7_MMASK, RS7_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,  16,   5,   5,   6,   8}, &rs_cicon[11]},
  {{RS8_MMASK, RS8_MDATA, "\0\000", 0x1000|'\0',
    5,   7,   0,   0,  16,  16,   5,   4,   6,   8}, &rs_cicon[12]},
  {{RS9_MMASK, RS9_MDATA, "\0\000", 0x1000|'\0',
    5,   2,   0,   0,  16,   8,   3,   0,   6,   8}, &rs_cicon[14]},
  {{RS10_MMASK, RS10_MDATA, "\0\000", 0x1000|'\0',
    5,   7,   0,   0,  16,  16,   5,   4,   6,   8}, &rs_cicon[16]},
  {{RS11_MMASK, RS11_MDATA, "\0\000", 0x1000|'\0',
    5,   2,   0,   0,  16,   8,   3,   0,   6,   8}, &rs_cicon[17]},
  {{RS12_MMASK, RS12_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,  16,   5,   5,   6,   8}, &rs_cicon[18]},
  {{RS13_MMASK, RS13_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,  16,   5,   5,   6,   8}, &rs_cicon[20]},
  {{RS14_MMASK, RS14_MDATA, "\0\000", 0x1000|'\0',
    8,   2,   0,   0,  16,   8,   5,   5,   6,   8}, &rs_cicon[22]},
  {{RS15_MMASK, RS15_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,  16,   5,   5,   6,   8}, &rs_cicon[24]},
  {{RS16_MMASK, RS16_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,  16,   5,   5,   6,   8}, &rs_cicon[25]},
  {{RS17_MMASK, RS17_MDATA, "\0\000", 0x1000|'\0',
    8,   2,   0,   0,  16,   8,   5,   5,   6,   8}, &rs_cicon[26]},
  {{RS18_MMASK, RS18_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,   8,   5,   5,   6,   8}, &rs_cicon[27]},
  {{RS19_MMASK, RS19_MDATA, "\0\000", 0x1000|'\0',
   14,  21,   0,   0,  16,   8,   5,   5,   6,   8}, &rs_cicon[29]}
};

static short rgb_palette[][4] =
{ {0x03E8, 0x03E8, 0x03E8, 0x0000}, 
  {0x03E8, 0x0000, 0x0000, 0x0002},
  {0x0000, 0x03E8, 0x0000, 0x0003},
  {0x03E8, 0x03E8, 0x0000, 0x0006},
  {0x0000, 0x0000, 0x03E8, 0x0004},
  {0x03E8, 0x0000, 0x03E8, 0x0007},
  {0x0000, 0x03E8, 0x03E8, 0x0005},
  {0x02DA, 0x02DA, 0x02DA, 0x0008},
  {0x020B, 0x020B, 0x020B, 0x0009},
  {0x029A, 0x0000, 0x0000, 0x000A},
  {0x0000, 0x029A, 0x0000, 0x000B},
  {0x029A, 0x029A, 0x0000, 0x000E},
  {0x0000, 0x0000, 0x029A, 0x000C},
  {0x029A, 0x0000, 0x029A, 0x000F},
  {0x0000, 0x029A, 0x029A, 0x000D},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0000},
  {0x0000, 0x0000, 0x0000, 0x0001}
};

static OBJECT rs_object[] =
{ 
  /******** Tree 0 USERDEF ****************************************************/
  {      -1, LRAD            , MLBUT2          , G_BOX             ,   /* Object 0  */
  FLAGS10, OUTLINED, {(long)0x00021180L},
  0x0000, 0x0000, 0x0411, 0x080A},
  {LBUT            ,       -1,       -1, G_CICON           ,   /* Object 1 LRAD */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[0]},
  0x0005, 0x0801, 0x0002, 0x0900},
  {MLRAD           ,       -1,       -1, G_CICON           ,   /* Object 2 LBUT */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[1]},
  0x0005, 0x0003, 0x0002, 0x0900},
  {MLBUT           ,       -1,       -1, G_CICON           ,   /* Object 3 MLRAD */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[2]},
  0x0404, 0x0806, 0x0002, 0x0900},
  {HRAD            ,       -1,       -1, G_CICON           ,   /* Object 4 MLBUT */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[3]},
  0x0404, 0x0208, 0x0002, 0x0900},
  {HBUT            ,       -1,       -1, G_CICON           ,   /* Object 5 HRAD */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[4]},
  0x0501, 0x0001, 0x0002, 0x0001},
  {MHBUT           ,       -1,       -1, G_CICON           ,   /* Object 6 HBUT */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[5]},
  0x0501, 0x0902, 0x0002, 0x0001},
  {MHRAD           ,       -1,       -1, G_CICON           ,   /* Object 7 MHBUT */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[6]},
  0x0301, 0x0D07, 0x0002, 0x0001},
  {HCIR            ,       -1,       -1, G_CICON           ,   /* Object 8 MHRAD */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[7]},
  0x0201, 0x0506, 0x0002, 0x0001},
  {LCIR            ,       -1,       -1, G_CICON           ,   /* Object 9 HCIR */
  NONE, NORMAL, {(long)&rs_ciconblk[8]},
  0x0501, 0x0304, 0x0002, 0x0001},
  {MHCIR           ,       -1,       -1, G_CICON           ,   /* Object 10 LCIR */
  NONE, NORMAL, {(long)&rs_ciconblk[9]},
  0x0005, 0x0804, 0x0002, 0x0800},
  {MLCIR           ,       -1,       -1, G_CICON           ,   /* Object 11 MHCIR */
  NONE, NORMAL, {(long)&rs_ciconblk[10]},
  0x0301, 0x0309, 0x0002, 0x0001},
  {HBUT2           ,       -1,       -1, G_CICON           ,   /* Object 12 MLCIR */
  NONE, NORMAL, {(long)&rs_ciconblk[11]},
  0x0604, 0x0A09, 0x0002, 0x0800},
  {HRAD2           ,       -1,       -1, G_CICON           ,   /* Object 13 HBUT2 */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[12]},
  0x0609, 0x0A02, 0x0002, 0x0001},
  {LRAD2           ,       -1,       -1, G_CICON           ,   /* Object 14 HRAD2 */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[13]},
  0x0509, 0x0301, 0x0002, 0x0001},
  {MHBUT2          ,       -1,       -1, G_CICON           ,   /* Object 15 LRAD2 */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[14]},
  0x040C, 0x0801, 0x0002, 0x0D00},
  {MHRAD2          ,       -1,       -1, G_CICON           ,   /* Object 16 MHBUT2 */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[15]},
  0x0608, 0x0B07, 0x0002, 0x0001},
  {MLRAD2          ,       -1,       -1, G_CICON           ,   /* Object 17 MHRAD2 */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[16]},
  0x0608, 0x0406, 0x0002, 0x0001},
  {LBUT2           ,       -1,       -1, G_CICON           ,   /* Object 18 MLRAD2 */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[17]},
  0x060B, 0x0806, 0x0002, 0x0D00},
  {MLBUT2          ,       -1,       -1, G_CICON           ,   /* Object 19 LBUT2 */
  SELECTABLE, NORMAL, {(long)&rs_ciconblk[18]},
  0x030C, 0x0F02, 0x0002, 0x0D00},
  {       0,       -1,       -1, G_CICON           ,   /* Object 20 MLBUT2 */
  SELECTABLE|LASTOB, NORMAL, {(long)&rs_ciconblk[19]},
  0x070B, 0x0008, 0x0002, 0x0D00}
};

static OBJECT *rs_trindex[] =
{ &rs_object[0]    /* Tree  0 USERDEF          */
};
