/* -----------------------------------------------------------------
 *	CPX LDG Version 2.22
 *	Ce programme est freeware et fait partie
 *	du package LDG
 *	Tous droits rservs  l'auteur (c) 1999/2000
 * -----------------------------------------------------------------
 *	Auteur : Dominique Brziat
 *	Module : main.c
 *	But : section .TEXT, variables globales et dmarrage du CPX 
 *  Tabulation : 4
 * -----------------------------------------------------------------
 */

#include <stdio.h>
#include <string.h>
#include "global.h"


/* Section .TEXT : sert de zone inscriptible
 * par Xcontrol pour les sauvegardes du CPX.
 * Le champ version sert d'indicateur pour savoir si
 * le CPX a dj t sauv */

/* Valeurs par defaut du CPX et donc du TSR */

CPX_SAVE conf = { FALSE, "C:\\gemsys\\ldg\\", 30, 1000};

/* external resource must be included after CPX data */
#include "resource.h"

/* Variables globales
 */
#ifdef NOSTARTUP
int errno;	/* makes the compiler happy */
#endif

CPX_PARAMS*	params;
GRECT		cpx_wind;
OBJECT*		dialog;
LDG_INFOS*	cook = NULL;
LDG*		ldg = NULL;
int			currform, lastform;
int			cpxid = -1;
int			request_listlib = 0;
int			snd_to = TO_TSR;
struct lib* listlib = NULL;
char**		free_string;
short		edit, pos=0;
struct ldg_infos	intern;
short*		global;

/*
 *	main : Init Cpx : premire fonction appele par Xcontrol
 */

CPX_INFO *CDECL main( CPX_PARAMS *par) {
  static CPX_INFO info = { cpx_call, cpx_draw, 
			   cpx_wmove, 0L,
			   cpx_key, cpx_button, 0L, 0L, 
			   cpx_evhook, cpx_close};
  
  /* debug : curseur en haut de l'cran */
  /* Cconws( "\33H\r\n\r\n"); */
  
  if( !(*par->find_cookie)( LDG_COOKIE, (long*)&cook))
    cook = NULL;
  
  /* Au boot de Xcontrol */
  if ( par->booting ) {
    /* Le CPX installe ses rglages */
    if( cook && conf.saved ) {
      strcpy( cook->path, conf.path);
      cook->garbage = conf.garbage;
      cook->idle    = conf.idle;
    }
    return (CPX_INFO*)1L;
  } else {
    /* Ouverture du CPX */
    params = par;
    global = aes_global;
    /* On fixe le ressource ? */
    if( !params->rsc_init ) {
      int i;
      for( i=0; i<NUM_OBS; (*params->objc_adjust)( rs_object, i++));
    }
    /* C'est un Event-CPX ! */
    (*par->multi)( MU_MESAG|MU_KEYBD|MU_BUTTON, NULL, NULL, -1);
    /* On retourne les fonctions vnements : le CPX est prt  s'ouvrir */
    return &info;
  }
}

/*  Lorsque le CPX est ouvert dans Xcontrol,
 *  ce dernier appelle cette fonction.
 */

short CDECL cpx_call( GRECT *work) {
  dialog = (OBJECT*)rs_trindex[CPXFORM];
  editable3d( dialog);

  select_form( CONFIGURE);
  dialog->ob_x = work->g_x;
  dialog->ob_y = work->g_y;
  objc_draw( dialog, ROOT, MAX_DEPTH, work->g_x, work->g_y, work->g_w, work->g_h);
  cpx_wind = *work;
  free_string = rs_frstr;
  return 1;
}


#include <scancode.h>
#include <stdlib.h>
#include <av.h>

/*
 *	vnement WM_REDRAW du CPX
 */

void CDECL cpx_draw( GRECT *clip) {
	GRECT *xrect;
	
	xrect = (*params->rci_first)( clip);
	while( xrect) {
		objc_draw( dialog, ROOT, MAX_DEPTH, 
			xrect->g_x, xrect->g_y, xrect->g_w, xrect->g_h);
		xrect = (*params->rci_next)();
	}
}

/*
 *	Dplacement de la fentre
 */

void CDECL cpx_wmove( GRECT *work) {
	dialog->ob_x = work->g_x;
	dialog->ob_y = work->g_y;
	cpx_wind = *work;
}

/*
 *	Gestion des clicks souris sur les objets,
 *	sous fonction de cpx_button()
 *	retour : 1 : quitter le CPX, 0 sinon
 */

int do_button( int button) {
	int res, old;
	char *p;
	
	switch( button) {
	/* Les boutons GLOBAUX */
	case CNF_OK:
		if( currform == COMMENT) {
			/* Retour au formulaire prcdent */
			select_form( lastform);
			draw_tree( dialog, 0);
			break;
		} else {
			/* Valider les rglages et quitter */
			get_form();
			return 1;
		}
	case CNF_SAVE:
		/* Valider les rglages et sauver */
		if( currform != COMMENT && (*params->alert)(0) ) {
			get_form();
			conf.saved = TRUE;
			(*params->write_config)( &conf, sizeof( CPX_SAVE));
		}
		break;
	case CNF_CANCEL:
		if( currform != COMMENT )
			/* Juste quitter sans valider */
			return 1;
	case CNF_MENU:
		/* Appel du popup MENU & affichage du formulaire */
		if( currform == COMMENT )break;
		old = currform;
		res = call_menu( button, &currform, &cpx_wind);
		if( res != -1 && old != currform) {
			select_form( currform);
			draw_object( dialog, currform);
		}
		break;

	/* Formulaire CONFIGURE */
		
	/* Appel du slecteur de fichier */
	case CNF_PATH:
		select_path();
		draw_object( dialog, CNF_PATH);
		break;

	/* Formulaire Expert */
	case EXP_TO:
		res = call_sndto( button, snd_to, &cpx_wind);
		if( res >= 0) {
			snd_to = res;
			strcpy( TEXT(EXP_TO), res?"manager":"tsr");
			draw_object( dialog, EXP_TO);
			select_manager( snd_to);
			draw_object( dialog, EXP_LIBLOADED);
		}
		break;

	case EXP_REQUEST:
		snd_request( call_action( button, &cpx_wind, 
								  (snd_to == TO_MGR)?5:4), snd_to);
		break;
	
	/* Formulaire LIB */
	case LIB_SELECT:
		lib_select();
		break;
	case LIB_LIST:
		list_functions( button, &cpx_wind);
		break;

	/* Formulaire INFOS */
	case INF_DOC:
		ApplWrite( appl_find( "ST-GUIDE"), VA_START, "*:\\LDG.HYP");
		break;
	case URL_LDG:
		if( shel_envrn( &p, "BROWSER=")) {
			exec_app( p, TEXT(URL_LDG));
		/*	ApplWrite( appl_find( p), VA_START, "*:\\LDG.HYP"); */
		}
		break;

	/* Formulaire COMMENT */
	case COM_CLIP:
		copy_clipbd();
		draw_object( dialog, COM_CLIP);
		break;
	}	

	if( currform != COMMENT)
		draw_tree( dialog, button);	
	return 0;
}

/*
 *	vnement MU_BUTTON
 */

void CDECL cpx_button( CPX_MOUSE_RET *mrets, short nclicks, short *event) {
	short button, dum;

	button = objc_find( dialog, ROOT, MAX_DEPTH, mrets->mx, mrets->my);
	if( button != -1 && mrets->mbutton & 0x1) {
		if( !form_button( dialog, button, nclicks, &dum)) {
			/* dslection du bouton */
			dialog[button].ob_state &= ~SELECTED;
			/* Gestion des objets */
			*event = do_button( button);
		}
		if( dialog[button].ob_flags & EDITABLE && button != edit) {
			objc_edit( dialog, edit, 0, &pos, ED_END);
			edit = button;
			pos = 0;
			objc_edit( dialog, edit, 0, &pos, ED_INIT);			
		}
	} else if( button != -1 && mrets->mbutton & 0x2) {
		bubble_do( button, mrets->mx, mrets->my);
	}
}

/*
 *	vnement MU_KEYBD
 */

void CDECL cpx_key( short kstate, short scancode, short *evnt) {
	short key=0, button, res, old;
	int asc = scancode >> 8;

	switch(  asc ) {
	/* Commandes gnrales */
	case SC_RETURN:
	case SC_ENTER:
		if( currform == COMMENT) {
			select_form( lastform);
			draw_tree( dialog, 0);
			break;
		} else {
			get_form();
			*evnt = 1;
		}
		break;
	case SC_UNDO:
		if( currform == COMMENT) break;
		*evnt = 1;
		break;
	case SC_INSERT:
		if( currform == COMMENT) break;
		if( (*params->alert)(0) ) {
			get_form();
			conf.saved = TRUE;
			(*params->write_config)( &conf, sizeof( CPX_SAVE));
		}
		break;
	case SC_HELP:
		ApplWrite( appl_find( "ST-GUIDE"), VA_START, "*:\\LDG.HYP");
		break;
	case SC_SPACE:
		if( currform == COMMENT) break;
		old = currform;
		res = call_menu( CNF_MENU, &currform, &cpx_wind);
		if( res != -1 && old != currform) {
			select_form( currform);
			draw_object( dialog, currform);
		}		
		break;

	/* Raccourci clavier du popup gnral */
	case SC_F1:
		if( currform != CONFIGURE) {
			select_form( CONFIGURE);
			draw_tree( dialog, CONFIGURE);
		}
		break;
	case SC_F2:
		if( currform != LIBRARY) {
			select_form( LIBRARY);
			draw_tree( dialog, LIBRARY);
		}
		break;
	case SC_F3:
		if( currform != EXPERT) {
 	 		select_form( EXPERT);
			draw_tree( dialog, EXPERT);
		}
		break;
	case SC_F4:
		if( currform != INFORMATION) {
			select_form( INFORMATION);
			draw_tree( dialog, INFORMATION);
		}
		break;

	/* Touches de fonction dpendant du dialogue courant */
	case SC_F6:
		switch( currform) {
		case CONFIGURE:
			select_path();
			draw_object( dialog, CNF_PATH);
			break;
		case LIBRARY:
			lib_select();
			break;
		case EXPERT:
			snd_request( call_action( EXP_REQUEST, &cpx_wind, 4), snd_to);
			break;
		}

	case SC_F7:
		switch( currform) {
		case LIBRARY:
			list_functions( LIB_LIST, &cpx_wind);
			break;
		case EXPERT:
			res = call_sndto( EXP_TO, snd_to, &cpx_wind);
			if( res >= 0) {
				snd_to = res;
				strcpy( TEXT(EXP_TO), res?"manager":"tsr");
				draw_object( dialog, EXP_TO);
				select_manager( snd_to);
				draw_object( dialog, EXP_LIBLOADED);
			}
			break;
		}
		break;

	/* Dialogue expert */

	case SC_F11:
	case SC_F12:
	case SC_F13:
	case SC_F14:
	case SC_F15:
		if( currform == EXPERT)
			snd_request( asc-SC_F11, snd_to);
		break;
	case SC_F16:
	case SC_F17:
		if( currform == EXPERT) {
			snd_to = (asc == SC_F16)?TO_TSR:TO_MGR;
			strcpy( TEXT(EXP_TO), snd_to?"manager":"tsr");
			draw_object( dialog, EXP_TO);
			select_manager( snd_to);
			draw_object( dialog, EXP_LIBLOADED);
		}
		break;
	
	/* Dialog Comment */
	case 0x2C:
		copy_clipbd();
		draw_object( dialog, COM_CLIP);
		break;
	default:
		/* gestion formulaire */	
		if( !form_keybd( dialog, (edit==-1)?0:edit, 1, scancode, &button, &key))
			do_button( button);
		if( key) 
			objc_edit( dialog, edit, key, &pos, ED_CHAR);
		else {
			objc_edit( dialog, edit, 0, &pos, ED_END);
			edit = button;
			objc_edit( dialog, edit, (int)strlen(TEXT(edit)), &pos, ED_INIT);
		}
	}
}

/*
 * Autres vnements
 */
 
short CDECL cpx_evhook( short ev, short *msgbuff, CPX_MOUSE_RET *mrets, 
					    short *key, short *nclicks) {
	if( ev & MU_MESAG) {
		if( cpxid == -1) cpxid = global[2] = msgbuff[1];
		switch( msgbuff[0]) {
		
		/* Message qui indique la fin volontaire d'une lib */
		case LDG_QUIT:
			{
				char alrt[80], *p;
				LDG *ldg = *(LDG **)&msgbuff[3];
				
				p = strrchr( ldg->path, '\\');
				sprintf( alrt, "[][Warning: Library|%s|has finished|raison=%d][OK]",
								p?p+1:ldg->path, msgbuff[5]);
				form_alert( 1, alrt);			
			}
			break;
		}
	}
	return 0;
}

void CDECL cpx_close( short flag) {
	if( ldg) {
		/* ldg_close( ldg); */
		ldg_term( cpxid, ldg);
	}
	if( flag) get_form();
}
/*
 * -----------------------------------------------------------------
 */

#include <stdarg.h>

#ifdef __PUREC__
#include <tos.h>
#else
#include <osbind.h>
#endif

/*
 * Formatte le nom d'un fichier dans un champ
 * trop petit.
 */
 
void format_filename( char *dest, char *src, int size) {
	int len = (int)strlen( src);
	int middle = size/2;
	char buf [255];
	
	if( len > size) {
		strncpy( buf, src, size);
		buf[middle-3] = '\0';
		strcat( buf, "...");
		strcat( buf, src + len - middle - size%2);
		buf[size]='\0';
		strcpy( dest, buf);
	} else
		strcpy( dest, src);
}

/*
 * Ajoute un backslash si besoin
 */

void add_slash( char *p) {
	if( p[strlen(p)-1] != '\\')
		strcat( p, "\\");
}

/*
 * dessin d'un object avec le bon clippage
 */

void draw_object( OBJECT *tree, int object) {
	objc_draw( tree, object, MAX_DEPTH, 
				cpx_wind.g_x,cpx_wind.g_y,cpx_wind.g_w,cpx_wind.g_h);	
}

/*
 *	dessin du formulaire et mise  jour de sa position
 */

void draw_tree(OBJECT *tree, int root) {
	tree[0].ob_x = cpx_wind.g_x;
	tree[0].ob_y = cpx_wind.g_y;
	draw_object( tree, root);
}

/*
 *	Interroge un gestionnaire et met  jour 
 *	le formulaire.
 */

void select_manager( int to) {
	if( to == TO_MGR)
		ldg_mgrlist( &intern, global);
	else
		ldg_libslist( &intern, global);
/*	itoa( ldg_loadlib( &intern), TEXT(EXP_LIBLOADED), 10); */
	sprintf( TEXT(EXP_LIBLOADED), "%d", ldg_loadlib( &intern));
}

/*
 *	Appliquer les rglages du formulaire 
 *	(valable en fait que pour le cookie)
 */

void get_form( void) {
	switch( currform) {
	case CONFIGURE:
		if( cook) {	
			strcpy( cook->path, conf.path);
			cook->garbage = atoi( TEXT(CNF_GARBAGE));
		}
		/* Pour la sauvegarde du CPX */
		conf.garbage  = atoi( TEXT(CNF_GARBAGE));
		break;
	case EXPERT:
		if( cook)
			cook->idle    = atoi( TEXT(EXP_IDLE));
		/* Pour la sauvegarde du CPX */
		conf.idle     = atoi( TEXT(EXP_IDLE));
		break;
	}
}

/*
 * Choix du formulaire et initialise le formulaire.
 */

void select_form( int form) {
	short dum;
	char *p;
	
	lastform = currform;
	currform = form;
	
	/* Cacher les formulaires, sauf l'actif */
	dialog[CONFIGURE].ob_flags 		|= HIDETREE;
	dialog[EXPERT].ob_flags 		|= HIDETREE;
	dialog[LIBRARY].ob_flags 		|= HIDETREE;
	dialog[INFORMATION].ob_flags 	|= HIDETREE;
	dialog[COMMENT].ob_flags 		|= HIDETREE;

	/* reactiver les boutons globaux si besoin */
	if( lastform == COMMENT) {
		dialog[CNF_SAVE].ob_state &= ~DISABLED;
		dialog[CNF_CANCEL].ob_state &= ~DISABLED;
		dialog[CNF_MENU].ob_state &= ~DISABLED;
		strcpy( dialog[CNF_OK].ob_spec.free_string,  "Ok");
	}

	/* recaler l'actif */	
	dialog[form].ob_flags 			&= ~HIDETREE;	
	dialog[form].ob_x = 0;
	dialog[form].ob_y = 0;
	
	/* Dsactiver les objets editables */
	
	dialog[EXP_IDLE].ob_flags &= ~EDITABLE;
	dialog[CNF_GARBAGE].ob_flags &= ~EDITABLE;
	
	switch( form) {
	case CONFIGURE:
		/* Initialisation des champs */
		if( cook) {	
			/* itoa( cook->version, TEXT(CNF_VERSION), 16);*/
			sprintf( TEXT(CNF_VERSION), "%X", cook->version);
			strcpy ( conf.path, cook->path);
			format_filename( TEXT(CNF_PATH), cook->path, LEN_PATH-1);
			/* itoa( cook->garbage, TEXT(CNF_GARBAGE), 10); */
			sprintf( TEXT(CNF_GARBAGE), "%X", cook->garbage);
		} else {
			if( shel_envrn( &p, "LDGPATH=")) {
				strcpy( conf.path, p);
				format_filename( TEXT(CNF_PATH), p, LEN_PATH-1);
			}
			if( shel_envrn( &p, "LDG_GARBAGE="))
				strcpy( TEXT(CNF_GARBAGE), p);
		}
		/* Curseur sur champs ditable */
		dum = 0;
		objc_edit( dialog, CNF_GARBAGE, 0, &dum, ED_INIT);
		dialog[CNF_GARBAGE].ob_flags |= EDITABLE;
		break;

	case LIBRARY:
		break;
	case EXPERT:
		/* Initialisation des champs */
		select_manager( snd_to);
		if( cook) 
			/* itoa( cook->idle, TEXT(EXP_IDLE), 10);*/
			sprintf( TEXT(EXP_IDLE), "%d", cook->idle);
		else {
			if( shel_envrn( &p, "LDG_IDLE="))
				strcpy( TEXT(EXP_IDLE), p);
		}
		/* Curseur sur champ ditable */
		dum = 0;
		objc_edit( dialog, EXP_IDLE, 0, &dum, ED_INIT);
		dialog[EXP_IDLE].ob_flags |= EDITABLE;
		break;
	case COMMENT:
		dialog[CNF_SAVE].ob_state |= DISABLED;
		dialog[CNF_CANCEL].ob_state |= DISABLED;
		dialog[CNF_MENU].ob_state |= DISABLED;
		strcpy( dialog[CNF_OK].ob_spec.free_string,  "<<");
		break;	
	case INFORMATION:
		strcpy( TEXT(CNF_CPXVERSION), CPXVERSION);		
		break;
	}
}

#define CLEN 30
#define NLINE 6

void fill_comment( char *fmt, ...) {
	int i,j,k;
	char buf[CLEN*NLINE];
	char *q, *p = NULL;
	va_list arg;
	
	/* Copie des arguments dans un buffer temporaire */
	va_start( arg, fmt);
	vsprintf( buf, fmt, arg);
	va_end( arg);
	
	/* Mise  zro des champs */
	for( i=0; i<NLINE; memset( TEXT(LINE1+i++), 0, CLEN));
	/*	 *TEXT(LINE1+i++)='\0'); */

	/* Copie du buffer vers les champs */
	q = buf;
	p = TEXT(LINE1);
	for( i=j=k=0; i < CLEN*NLINE && *q; i++) {
		if( (k && k % CLEN == 0) || *q == '\n') {
			j ++;
			p = TEXT(LINE1+j);
			k = 0;
		} 

		if( *q == '\n')
			q ++;	/* avancer sans copier */
		else {
			*p++ = *q++;
			k ++;
		}
	}
	*p = '\0';
}

/*
 *	Binding AES 
 */

#define AES_PROCESS		4

int is_appl_search( void) {
	short dum, parm3;

	if( appl_find( "?AGI") != -1) {
		appl_getinfo( AES_PROCESS, &dum, &dum, &parm3, &dum);
		if( parm3 == 1) return 1;	
	}
	return 0;
}

char *appl_name( int id) {
	short i,m=0x0F;
	static char name[9]="???"; 
	char name2[9];
	
	if( is_appl_search() &&  appl_search(0, name2, &m, &i) && i != id) {
		while( appl_search(1, name2, &m, &i)) {
			if( i == id )
				break;
		}
	}
	sscanf( name2, "%s", name);
	return name;
}

/*
 *	Execute une appli GEM
 */

void exec_app( char *ap, char *cmd) {
	char *p, *q, name[9];
	int id;
	char *app = strdup( ap);
	
	p = strrchr( app, '\\');
	if( p)  p++;
	else	p = app;
	q = strrchr( p, '.');
	if( q) *q = '\0';
	strupr( p);
	strcpy( name, "        ");
	for( id=0; id < strlen(p); id++)
		name[id]=p[id];
	id = appl_find(name);
	if( id == -1) {
		id = shel_write( 1, 1, 100, ap, cmd);
		evnt_timer( 2000);
	}
	ApplWrite( id, VA_START, cmd);
	free( ap);
}

struct objcolor {
		unsigned borderc:4;
		unsigned textc  :4;
		unsigned opaque :1;
		unsigned pattern:3;
		unsigned fillc  :4;
	};

void editable3d( OBJECT *tree) {
	int res;
#define COOKIE_MAGX 0x4D61658UL
	if( !ldg_cookie( COOKIE_MAGX, NULL)) {
		res = 0;
		while( !(tree[res].ob_flags & LASTOB)) {
			if( tree[res].ob_type == G_FTEXT &&
				!(tree[res].ob_state & (1<<15))) {
				struct objcolor *color;
			
				tree[res].ob_state |= SELECTED;
				tree[res].ob_flags |= (1<<9);
				tree[res].ob_flags |= (1<<10);
				color = (struct objcolor*)&tree[res].ob_spec.tedinfo->te_color;
				color -> fillc = 8;
			}
			res ++;
		}
	}
}

/*
 * La fonction appl_write en plus pratique (extrait de WinDom)
 */

int ApplWrite( int to, int msg, ...) {
	va_list args;	
	short buf[8];

	buf[0] = msg;
	buf[1] = cpxid;
	buf[2] = 0;
	va_start( args, msg);
	buf[3] = va_arg( args, short);
	buf[4] = va_arg( args, short);
	buf[5] = va_arg( args, short);
	buf[6] = va_arg( args, short);
	buf[7] = va_arg( args, short);
	va_end( args);
	return appl_write( to, 16, buf);
}

/*
 * Trouver l'id de BubbleGEM. Au besoin, le charger.
 */

int BubbleGet( void) {
	int bubble_id = appl_find("BUBBLE  ");

	if( bubble_id < 0 && _AESnumapps != 1) {
		char *value;
    	
    	shel_envrn( &value, "BUBBLE=");
    	if( !value) shel_envrn( &value, "BUBBLEGEM=");
    	if( value)
    		shel_write( 1, 1, 100, value, "");
    	else 
    		return -2;

    	evnt_timer( 500);
    	bubble_id = appl_find("BUBBLE  ");
	}
	return bubble_id;
}

#define BGS7_MOUSE 		0x0004
#define BUBBLEGEM_SHOW	0xBABB

int BubbleCall( char *help, int x, int y) {
	char *bubble_buf;
	int bubble_id;
	
	bubble_id = BubbleGet();

    if (bubble_id >= 0) {

    	/* Demander de la mmoire pour la communication */
    	bubble_buf = ldg_Malloc( 256);
		if( bubble_buf == NULL) return -3;
	
		/* Affichage de la bulle */
		strcpy(bubble_buf, help);
		ApplWrite( bubble_id, BUBBLEGEM_SHOW, x, y, bubble_buf, BGS7_MOUSE);
 		
		/* Libration mmoire */        
        ldg_Free( bubble_buf);

        return 0;
    }
    return bubble_id;
}

/* EOF */

/* -----------------------------------------------------------------*/

int BubbleGet( void);						/* WinDom */
int BubbleCall( char *help, int x, int y);	/* WinDom */

static char *bubble_help[] = {
	/* 0 */
	"Apply the settings and save the CPX configuration",
	"Close CPX without apply the settings",
	"Close CPX and apply the settings",
	"Select a topic:|"
		 "configure: system configuration|"
		 "library: infos about *.LDG files|"
		 "expert: some experts actions|"
		 "Back.Comp.: compatibility with LDG 1.xx|"
		 "informations: infos about this program",
	"Display the 'LDGM' cookie version",
	/* 5 */
	"Define the path where are stored the libraries.",
	"Set the garbage collector time (in min) (if LDGGARB.APP is resident or if LDG 1.xx is used).",
	"Set the idle time (in msec) (for LDG 1.xx only).",
	"Display the version of the LDG-manager.",
	"Display how many libs are currenlty loaded by the LDG-manager.",
	"Choice a request to send to the LDG_manager.",
	"Select a library and display infos about it.",
	"Display the version of the library.",
	"A popup containing the list of the functions available in the library."
	"Indicates if the library may be shared with severals clients",
	"Indicates if the library is busy (by a client) and can be used",
	"Indicates if the library is memory-resident",
	"Indicates if the library have a closure-function",
	"Indicates a personal extension of the library",
	"Indicates if the library have an extension (a new LDG version)",
	"Display the version of the LDG protocol used by the library"
};

void bubble_do( int button, int mx, int my) {
	int idx = -1;
		
	switch( button) {
	case CNF_SAVE:
		idx = 0;
		break;
	case CNF_CANCEL:
		idx = 1;
		break;
	case CNF_OK:
		idx = 2;		
		break;
	case CNF_MENU:
		idx = 3;
		break;
	case CNF_VERSION:
		idx = 4;
		break;
	case CNF_PATH:
		idx = 5;
		break;
	case CNF_GARBAGE:
		idx = 6;
		break;

	/* Formulaire Expert actions */

	/* Formulaire BackWard Compatibility */

	case EXP_IDLE:
		idx = 7;
		break;
	case MGR_VERSION:
		idx = 8;
		break;
	case MGR_NLIB:
		idx = 9;
		break;
	case MGR_ACTION:
		idx = 10;
		break;

	/* Formulaire library */

	case LIB_SELECT:
		idx = 11;
		break;
	case LIB_VERSION:
		idx = 12;
		break;
	case LIB_LIST:
		idx = 13;
		break;
	case LIB_SHARE:
		idx = 14;
		break;
	case LIB_LOCKED:
		idx = 15;
		break;
	case LIB_RESIDENT:
		idx = 16;
		break;
	case LIB_CLOSURE:
		idx = 17;
		break;
	case LIB_EXT:
		idx = 18;
		break;
	case LIB_SPEC:
		idx = 19;
		break;
	case LIB_PROTOCOL:
		idx = 20;
		break;
	}

	if( idx != -1) BubbleCall( bubble_help[idx], mx, my);
}


/* ----------------------------------------------------------------- */

#define FO_WRITE 1
char *appl_name( int id);

/* Appel du menu popup MENU */

char *mainMENU[] = { "  Configure    F1 ",
					 "  Libraries    F2 ",
					 "  Expert       F3 ",
					 "  Information  F4 " };

int call_menu( int button, int *lastform, GRECT *work) {
	int res, item;
	GRECT pop;
	
	switch( *lastform) {
	case CONFIGURE:
		item = 0;
		break;
	case LIBRARY:
		item = 1;
		break;
	case EXPERT:
		item = 2;
		break;
	case INFORMATION:
		item = 3;
		break;
	}
	objc_offset( dialog, button, &pop.g_x, &pop.g_y);
	pop.g_w = dialog[button].ob_width;
	pop.g_h = dialog[button].ob_height;
	res = (*params->do_pulldown)( mainMENU, 4, item, LARGE, &pop, work);
	switch( res ) {
	case 0:
		*lastform = CONFIGURE;
		break;
	case 1:
		*lastform = LIBRARY;
		break;
	case 2:
		*lastform = EXPERT;
		break;
	case 3:
		*lastform = INFORMATION;
		break;
	
	}
	return res;
}

/* Choix du rpertoire LDG */

void select_path( void) {
	char path[128], *p;
	short res;

	strcpy( path, conf.path);
	add_slash(path);
	strcat( path, "*.*");
	if (fsel_input( path, "", &res) && res) {
		p = strrchr( path, '\\');
		if( p) *(p+1) = '\0';
		strcpy( conf.path, path);
		format_filename( TEXT(CNF_PATH), path, LEN_PATH-1);
	}
}


char *list_error[] = {
	"Manager error (libs fulled)",
	"Manager error (apps fulled)",
	"Pexec error",
	"Bad format",
	"strange error",
	"lib locked",
	"No manager",
	"lib not found",
	"Memory exhausted",
	"Time idle",
	"No TSR",
	"Functionality not supported"
	};

void request_lib( char *lib) {
	char *p;

#ifdef USE_LDGLOAD
	void ldg_unload( int, LDG*);
	LDG* ldg_load( int, char*);

	if( ldg) ldg_unload( mt_AESapid(global), ldg);
	ldg = ldg_load( mt_AESapid(global), lib);
#else
	if( ldg) ldg_close( ldg, global);
	ldg = ldg_open( lib, global);
#endif
	
	
	if( ldg) {
		p = strrchr( lib, '\\');
		strcpy( TEXT(LIB_SELECT), p+1);
		/* itoa( ldg->vers, TEXT(LIB_VERSION), 16); */
		sprintf( TEXT(LIB_VERSION), "%1x%02x", ldg->vers>>8, ldg->vers & 0x00FF);
		strcpy( TEXT(LIB_SHARE), (ldg->flags & LDG_NOT_SHARED)?"no ":"yes");
		strcpy( TEXT(LIB_LOCKED), (ldg->flags & LDG_LOCKED)?"yes":"no ");
		strcpy( TEXT(LIB_RESIDENT), (ldg->flags & LDG_RESIDENT)?"yes":"no ");
		strcpy( TEXT(LIB_CLOSURE), (ldg->close)?"yes":"no ");
		if( ldg->vers_ldg >= 0x100) {
		/*	itoa( ldg->vers_ldg, TEXT(LIB_PROTOCOL), 16); */
			sprintf( TEXT(LIB_PROTOCOL), "%1x%02x", ldg->vers_ldg>>8, ldg->vers_ldg & 0x00FF);
			strcpy( TEXT(LIB_EXT), ldg->user_ext?"yes":"no ");
			strcpy( TEXT(LIB_SPEC), ldg->addr_ext?"yes":"no ");	
		}
		/* itoa( ldg->num, TEXT(LIB_LIST), 10); */
		sprintf( TEXT(LIB_LIST), "%d", ldg->num);
		strcat( TEXT(LIB_LIST), " functions");
		draw_tree( dialog, ROOT);
	} else {
		char alrt[80];
		int err = ldg_error();

		if( err < 0 && err >= LDG_BAD_TSR) {
			sprintf( alrt, "[1][LDG error %d:|%s][OK]", err, list_error[-err-1]);
			form_alert( 1, alrt);
		} else {
			sprintf( alrt, "[1][LDG error %d:|unknown][OK]", err);
			form_alert( 1, alrt);
		}
	}
}

void list_functions( int button, GRECT *work) {
	if( ldg) {
		char **list;
		GRECT pop;
		int i;
		
		list = (char **)malloc( sizeof(char*)*(ldg->num+1));
		list[0] = " *General infos* ";
		for( i = 0; i<ldg->num; i++)
			list[i+1] = ldg->list[i].name;
		objc_offset( dialog, button, &pop.g_x, &pop.g_y);
		pop.g_w = dialog[button].ob_width;
		pop.g_h = dialog[button].ob_height;
		i = (*params->do_pulldown)( list, ldg->num+1, -1, LARGE, &pop, work);
		free( list);
		if( i != -1) {
			if( i == 0)
				fill_comment( "%s", ldg->infos);
			else
				fill_comment( "%s", ldg->list[i-1].info);
			select_form( COMMENT);
			draw_tree( dialog, ROOT);
		}
	}
}

char *actionMENU[]={ "  Garbage collecting  F11 ",
					 "  Reset               F12 ",
					 "  List libs           F13 ",
					 "  Internal infos      F14 ",
					 "  Shutdown            F15 "};

int call_action( int button, GRECT *work, int items) {
	GRECT pop;
	
	objc_offset( dialog, button, &pop.g_x, &pop.g_y);
	pop.g_w = dialog[button].ob_width;
	pop.g_h = dialog[button].ob_height;
	return (*params->do_pulldown)( actionMENU, items, -1, LARGE, &pop, work);
}

char *sndtoMENU[]= { "  Tsr     F16 ",
					 "  Manager F17 " };

int call_sndto( int button, int def, GRECT *work) {
	GRECT pop;
	
	objc_offset( dialog, button, &pop.g_x, &pop.g_y);
	pop.g_w = dialog[button].ob_width;
	pop.g_h = dialog[button].ob_height;
	return (*params->do_pulldown)( sndtoMENU, 2, def, LARGE, &pop, work);
}

void lib_select( void) {
	char path[128];
	char name[20], *p;
	short res;

	strcpy( path, conf.path);
	add_slash( path);
	strcat( path, "*.ldg");
	*name = '\0';
	if( fsel_input( path, name, &res) && res) {
		p = strrchr( path, '\\');
		if( p) *(p+1) = '\0';
		strcat( path, name);
		request_lib( path);
	}
}

/* Envoie une requete au manager ou au TSR */

void snd_request( int act, int to) {
	if( cook == NULL || cook->version < LDG2_VERS ) 
		to &= ~TO_TSR;
	
	switch( act) {
	case 0:
		/* Garbage */
		if( to == TO_MGR)
			ApplWrite( appl_find( "LDGMGR  "), LDG_GARBAGE);
		else
			(*cook->ldg_garbage)( global);			
		break;
	case 1:
		/* Reset manager */
		if( to == TO_MGR)
			ApplWrite( appl_find( "LDGMGR  "), LDG_FORCE);
		else
			(*cook->ldg_reset)( global);
		break;
	case 2:
		{
			char **poplib;
			struct ldg_lib *libs;
			GRECT pop;
			int i, nlib = ldg_loadlib( &intern);
							  
			poplib = (char **)malloc( sizeof(char*)*(nlib+1));
			libs = (struct ldg_lib *)malloc( sizeof(struct ldg_lib)*(nlib+1));
			poplib[0] = nlib?" Libs loaded: ":" Any lib loaded";
			ldg_initlist( &intern);
			for( i=1; i<=nlib; i++) {
				ldg_getlib( &intern, libs+i);
				poplib[i] = libs[i].name;
			}
			objc_offset( dialog, EXP_REQUEST, &pop.g_x, &pop.g_y);
			pop.g_w = dialog[EXP_REQUEST].ob_width;
			pop.g_h = dialog[EXP_REQUEST].ob_height;
			i = (*params->do_pulldown)( poplib, nlib+1, -1, LARGE, &pop, &cpx_wind);
			if( i>0) {
				int j, k;
				sprintf( TEXT(LINE1), "Lib '%s' used by: ", libs[i].name);
				for( j=1; j<6; j++) TEXT(LINE1+j) [0] = '\0';
				for( k=1, j=0; j<intern.maxclient && k<6; j++) {
					if( libs[i].usedby[j] != -1)
						sprintf( TEXT(LINE1+k++), "  + %d '%s'", 
								libs[i].usedby[j],
								appl_name( libs[i].usedby[j]));
				}
				select_form( COMMENT);
				draw_tree( dialog, ROOT);
			}
			free( poplib);
			free( libs);

		}
		request_listlib = 1;
		break;
	case 3:
		/* Internal infos */
		if( to == TO_MGR)
			ApplWrite( appl_find( "LDGMGR  "), VA_START);
		else {
			fill_comment( "Max libs: %d\nMax Apps: %d\nMax lib per apps: %d", 
						  intern.maxlib, intern.totalclient, intern.maxclient);
			select_form( COMMENT);
			draw_tree( dialog, ROOT);
		}
		break;
	case 4:
		/* Shutdown */
		if( to == TO_MGR)
			ApplWrite( appl_find( "LDGMGR  "), AP_TERM);
		break;
	}
}


/* requete sur le TSR, LDG 2.xx */


/*
 *	Copie le formulaire COMMENT vers le presse papier GEM
 */

void copy_clipbd( void) {
	char path[128];
	int  fp;
	int  line;
	
	if( !scrp_read(path)) {
		return;	/* Pas de dossier clipboard install */
	}
	strcat( path, "scrap.txt");
	fp = (int)Fopen( path, FO_WRITE);
	for( line = LINE1; line <= LINE6; line++)
		Fwrite( fp, strlen(TEXT(line)), TEXT(line));
	Fwrite( fp, 2, "\r\n");
	Fclose( fp);
}

/* EOF */
