/* -----------------------------------------------------------------
 *	CPX LDG Version 2.22
 *	Ce programme est freeware et fait partie
 *	du package LDG
 *	Tous droits rservs  l'auteur (c) 1999/2000
 * -----------------------------------------------------------------
 *	Auteur : Dominique Brziat
 *	Module : main.c
 *	But : section .TEXT, variables globales et dmarrage du CPX 
 *  Tabulation : 4
 * -----------------------------------------------------------------
 */

#include <stdio.h>
#include <string.h>
#include "global.h"

/* Section .TEXT : sert de zone inscriptible
 * par Xcontrol pour les sauvegardes du CPX.
 * Le champ version sert d'indicateur pour savoir si
 * le CPX a dj t sauv */

/* Valeurs par defaut du CPX et donc du TSR */

CPX_SAVE conf = { FALSE, "C:\\gemsys\\ldg\\", 30, 1000};

/* external resource must be included after CPX data */
#include "resource.h"

/* Variables globales
 */
#ifdef NOSTARTUP
int errno;	/* makes the compiler happy */
#endif

CPX_PARAMS*	params;
GRECT		cpx_wind;
OBJECT*		dialog;
LDG_INFOS*	cook = NULL;
LDG*		ldg = NULL;
int			currform, lastform;
int			cpxid = -1;
int			request_listlib = 0;
int			snd_to = TO_TSR;
struct lib* listlib = NULL;
char**		free_string;
short		edit, pos=0;
struct ldg_infos	intern;
short*		global;

/*
 *	main : Init Cpx : premire fonction appele par Xcontrol
 */

CPX_INFO *CDECL main( CPX_PARAMS *par) {
  static CPX_INFO info = { cpx_call, cpx_draw, 
			   cpx_wmove, 0L,
			   cpx_key, cpx_button, 0L, 0L, 
			   cpx_evhook, cpx_close};

  void log( char *);

  /* debug : curseur en haut de l'cran */
  /* Cconws( "\33H\r\n\r\n"); */

  log( NULL);
  log( "starting CPX");

  if( !(*par->find_cookie)( LDG_COOKIE, (long*)&cook))
    cook = NULL;
  
  /* Au boot de Xcontrol */
  if ( par->booting ) {

    log( "boot CPX");


    /* Le CPX installe ses rglages */
    if( cook && conf.saved ) {
      strcpy( cook->path, conf.path);
      cook->garbage = conf.garbage;
      cook->idle    = conf.idle;
    }

    return (CPX_INFO*)1L;
  } else {
    /* Ouverture du CPX */
    params = par;
    global = aes_global;
    /* On fixe le ressource ? */
    if( !params->rsc_init ) {
      int i;
      for( i=0; i<NUM_OBS; (*params->objc_adjust)( rs_object, i++));
    }
    
    log( "open CPX");

    /* C'est un Event-CPX ! */
    (*par->multi)( MU_MESAG|MU_KEYBD|MU_BUTTON, NULL, NULL, -1);
    /* On retourne les fonctions vnements : le CPX est prt  s'ouvrir */
    return &info;
  }
}

void log( char *str) {
  FILE *fp = fopen("ldg-cpx.log",str?"a":"w");
  if( fp) {
    if( str) fprintf( fp, "%s\n", str);
    fclose( fp);
  }
}

/*  Lorsque le CPX est ouvert dans Xcontrol,
 *  ce dernier appelle cette fonction.
 */

short CDECL cpx_call( GRECT *work) {
  dialog = (OBJECT*)rs_trindex[CPXFORM];
  editable3d( dialog);

  select_form( CONFIGURE);
  dialog->ob_x = work->g_x;
  dialog->ob_y = work->g_y;
  objc_draw( dialog, ROOT, MAX_DEPTH, work->g_x, work->g_y, work->g_w, work->g_h);
  cpx_wind = *work;
  free_string = rs_frstr;
  return 1;
}
