# Librairie Dynamique GEM
# Olivier Landemarre, Dominique Brziat and Arnaud Bercegeay
# tous droits rservs 1997-2003
#
# Makefile to build LDG.CPX using the cc drives
#
# $Id$

CC      = cc
CFLAGS  = -O -W0,-P,-M -I. -I..\..\include -DNOSTARTUP
STARTUP = -T <none>
LDFLAGS = -s $(STARTUP) -lgem ..\..\lib\purec\ldg.lib

OBJECTS = main.o evnt.o funcs.o bubble.o utils.o internal.o \
		  ..\..\lib\purec\ldg.lib
TARGET  = ..\..\cpx\ldg.cpx

all: $(TARGET)

$(TARGET): ldg.cp header.rsc
	mcpx -i ldg.cp -r header.rsc
	mv ldg.cpx $(TARGET)

ldg.cp: $(OBJECTS)
	$(CC) $^ -o $@ $(LDFLAGS)

internal.o: ..\share\internal.c
main.o: main.c global.h
evnt.o: evnt.c global.h
funcs.o: funcs.c global.h
bubble.o: bubble.c global.h 
utils.o: utils.c global.h

clean:
	$(RM) $(OBJECTS) ldg.cp
