/*
 * LDG : Gem Dynamical Libraries
 * Copyright (c) 1997-2004 Olivier Landemarre, Dominique Bereziat & Arnaud Bercegeay
 *
 * ldg_init() : the LDG interface from LDG-library side
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * $Id$
 */

#include <stdlib.h>
#include <string.h>

#ifdef __PUREC__
#include <tos.h>
#else
#include <osbind.h>
#endif

#include <version.h>
#include <options.h>
#include <ldg.h>

#ifdef __SOZOBONX__
volatile static LDG lib;
#else
static volatile LDG lib;
#endif

/*
 *  Dtournement des fonctions pour les rendre compatible "stdcall"
 *  cd, seuls les registres a0-a1 et d0-d1 sont des scratch registers.
 *  les autres registres (comme a2 et d2) doivent tre prservs,
 *  ce qui n'est pas le cas avec sozobon et pure c.
 *  (ajout Arnaud Bercegeay nov 2001)
 */

#ifndef __GNUC__

# ifdef __PUREC__  /* avec un '_' de plus au debut pour linker avec stdcall.s */
#  define LDG_BEGIN_STDCALL ___ldg_begin_stdcall
#  define LDG_ADR_REGCTX 	___ldg_adr_regctx
#  define LDG_NB_REGCTX	  	___ldg_nb_regctx
# else
#  define LDG_BEGIN_STDCALL  __ldg_begin_stdcall
#  define LDG_ADR_REGCTX	 __ldg_adr_regctx
#  define LDG_NB_REGCTX	     __ldg_nb_regctx
# endif

/* nouvelle destination des fonctions dtournes */
/* voir stdcall.s */
extern void __ldg_begin_stdcall (void );

/* point d'entre de la redirection des fonctions */

#define NB_PROC_REDIRECT 500
static struct { short _r1; void * _r2; short _r3; void * _r4;
	} tab_redirect_proc[ NB_PROC_REDIRECT ];

/* sauvegarde des contextes (registres) */

#define NB_REG_CONTEXT 512
unsigned long __ldg_nb_regctx  = NB_REG_CONTEXT;
struct { unsigned long _r1, _r2, _r3, _r4;
	} __ldg_adr_regctx [ NB_REG_CONTEXT ] ;

static void trnfm_to_stdcall ( void ) {
	int i;

	if ( lib.num > NB_PROC_REDIRECT ) {
		Cconws("\r\nldg_trnfm_to_stdcall failed (tab_redirect_proc too small)\r\n");
		return;
	}
	
	/* IMPORTANT: the buffer HAVE TO be zero-ed before use */
	memset( __ldg_adr_regctx, 0, sizeof(__ldg_adr_regctx));
	
	/* init des procdures de redirection */
	for (i = 0; i < lib.num; i++) {
		tab_redirect_proc[i]._r1 = 0x41F9 ;  		 /* LEA A0, <abs.l ea> */
		tab_redirect_proc[i]._r2 = lib.list[i].func; /* the ea */
		tab_redirect_proc[i]._r3 = 0x4EF9 ;  		 /* JMP <abs.l ea> */
		tab_redirect_proc[i]._r4 = __ldg_begin_stdcall;
		lib.list[i].func = &tab_redirect_proc[i];
	}

	lib.flags |= LDG_STDCALL;
}
#endif /* __GNUC__ */

/*
 *	Interface LDG des libraries
 */
 
int ldg_init( LDGLIB *liblib) {
	char *env;
	long *offset_pere;
	long offset = (long ) &lib;   /* directement */

	lib.magic    = LDG_COOKIE;
	lib.vers     = liblib->vers;
	lib.num      = liblib->num;
	lib.list     = liblib->list;
	lib.infos    = liblib->infos;
	lib.flags    = liblib->flags;
	lib.close    = liblib->close;
 	lib.vers_ldg = LDG_NUM;
 	lib.user_ext = liblib->user_ext;
 	lib.addr_ext = 0L;
	
	/* dtournement des fonction pour prserver les registres */
	/* a2 et d2 si cela est ncessaire (sozobon et pure c) */

#ifndef __GNUC__
	lib.flags &= ~LDG_STDCALL;
	trnfm_to_stdcall();
#else
	lib.flags |= LDG_STDCALL;
#endif

	env = getenv("OFFSETLDG");
	if( env) {
    	/* rcupration de l'adresse offset du client pour la remplir */
    	offset_pere = (long*)atol(env);
    	*offset_pere = offset;
    	return 0;  /* Pas d'erreurs */
	} else
    	return -1; /* ne peut pas etre lanc du bureau */
}

/*
 *	Vrai chemin de la librarie. Doit tre appele depuis une fonction
 *	de la librairie mais jamais du main() de la lib.
 */

char *ldg_getpath( void) {
	return (char *)(lib.path);
}

