/*
 * LDG : Gem Dynamical Libraries
 * Copyright (c) 1997-2004 Olivier Landemarre, Dominique Bereziat & Arnaud Bercegeay
 *
 * Low-level functions to load and unload a LDG-library
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * $Id$
 */


#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#ifdef __PUREC__
# include <tos.h>
#endif
#if defined(__GNUC__) | defined(__SOZOBONX__)
# if (__GNUC__ > 2) || ( __GNUC_MINOR__ > 8 )
#  include <mint/basepage.h>
# else
#  include <basepage.h>
# endif
# include <osbind.h>
# include <mintbind.h>
# define BASPAG	BASEPAGE
#endif

#include <options.h>
#include <ldg.h>
#include "global.h"

/*
 * Charger un module et retourne l'adresse
 * de la structure LDG du module.
 * apid: id du lanceur.
 */

LDG *ldg_load( int apid, const char *path) {
	LDG *ldg = NULL;
	BASPAG *module;
	LDG **addr = NULL;
	char offsetxt[24];

	/* 
	 * L'adresse du descripteur de la lib (LDG) 
	 * est fournit par la librairie (peut tre un
	 * programme en mmoire protge) et est transmise 
	 * entre lib et client via une variable d'environnement !
	 */

	if( !addr) 
		addr = (LDG**)ldg_Malloc(sizeof(LDG**));
	if( !addr) {
		set_error( LDG_NO_MEMORY);
		return(NULL);
	}
  	*addr=NULL;
	
	/* on met directement addr */
#ifdef __GNUC__
	sprintf(offsetxt,"OFFSETLDG=%ld%c%c",(long)addr,'\0','\0');
#else
	strcpy(offsetxt,"OFFSETLDG=");
  	ltoa( (long)addr, offsetxt+10, 10);
  	offsetxt[strlen( offsetxt) + 1] = '\0';
#endif

	module = (BASPAG *)Pexec( 3, path, NULL, offsetxt);
	if( (long)module < 0L) {
		set_error( LDG_ERR_EXEC);
		return NULL;	/* echec de Pexec */
	}
	
	/* Vider les caches */
	ldg_cpush();  

	(void) Pexec( 4, NULL, module, NULL);

	/* Vider les caches */
	ldg_cpush();  
	Pwait();

	if(*addr==0L)  {
    	set_error( LDG_BAD_FORMAT);
    	Mfree( module->p_env);
    	Mfree( module);
    	ldg_Free(addr);
    	addr = NULL;
    	return NULL;	/* Pas une librairie */
	}
	ldg = *addr;
	if( ldg -> magic != LDG_COOKIE) {
 		set_error( LDG_BAD_FORMAT);
    	Mfree( module->p_env);
    	Mfree( module);
    	ldg_Free(addr);
    	addr = NULL;
    	return NULL;	/* mauvais format de librairie */
  	}
  	
	ldg -> id = (short)(apid&0xFFFF);    /* contient maintenant l'id du lanceur */
	ldg -> baspag = module;
	
	/* depuis version 1.00 */
 	if( ldg -> vers_ldg >= 0x100) {
 		if( !strrchr( path, '\\')) {
 			char currpath[PATHLEN];
			
			currpath[0]=Dgetdrv()+'A';
			currpath[1]=':';
			currpath[2]='\\';
			currpath[3]='\0';
			Dgetpath( currpath+3, 0);
			strncpy( ldg->path, currpath, PATHLEN-1);
			strcat( ldg->path,"\\");
			strcat( ldg->path, path); 
		}
		else
			strncpy( ldg->path,path,PATHLEN-1);
	}
	ldg_Free(addr);
	addr = NULL;
	return ldg;
}

/*
 * Enlever un module de la mmoire
 */

int ldg_unload( LDG *ldg) {
	if( ldg) {
		if( ldg->close) (*ldg->close)();
		Mfree( ((BASPAG *)ldg->baspag)->p_env);
		Mfree( ldg->baspag);
		ldg->baspag = NULL;
	}
	return 0;
}

/* EOF */
