# Librairie Dynamique GEM
# Olivier Landemarre, Dominique Brziat, Arnaud Bercegeay
# tous droits rservs 1997/1998/1999/2000/2001/2002
#
# Makefile for Gnu C 16 bits

CC 		= $(CC_GCC281)
AR 		= $(AR_GCC281)
CFLAGS 	= -O -Wall -W -mshort -I..\..\include\ldg.h  -I..\options.h -I..\version.h

HEADER 	= ..\..\include\ldg.h ..\options.h ..\version.h
OBJECTS = gcc16\ldgapp.o gcc16\ldglib.o gcc16\ldgutil.o gcc16\ldgload.o
TARGET=..\..\lib\gcc281\libldg16.olb

all: $(TARGET)

$(TARGET): $(OBJECTS)
	$(RM) -f $(TARGET)
	$(AR) -r $(TARGET) $(OBJECTS)

gcc16\ldgapp.o: ldgapp.c $(HEADER)
	$(CC) $(CFLAGS) -c $< -o $@
gcc16\ldglib.o: ldglib.c $(HEADER)
	$(CC) $(CFLAGS) -c $< -o $@
gcc16\ldgutil.o: ldgutil.c $(HEADER)
	$(CC) $(CFLAGS) -c $< -o $@
gcc16\ldgload.o: ldgload.c $(HEADER)
	$(CC) $(CFLAGS) -c $< -o $@

clean:
	rm -f $(OBJECTS) 
