# Librairie Dynamique GEM
# Olivier Landemarre, Dominique Brziat, Arnaud Bercegeay
# tous droits rservs 1997/1998/1999/2000/2001/2002
#
# Makefile for Gnu C 2.95-3 (32 bits only)

ifeq ($(CROSS),yes)
CC = m68k-atari-mint-gcc
AR = m68k-atari-mint-ar
INSTDIR= /usr/m68k-atari-mint
else
CC = gcc
AR = ar
INSTDIR= /usr/GEM
endif

SRCDIR = .
OBJDIR = gcc295
LIBDIR = ../../lib/gcc295

CFLAGS = -O -Wall -fomit-frame-pointer -I../../include/ldg.h  -I../options.h -I../version.h
HEADER = ../../include/ldg.h ../options.h ../version.h
OBJECTS = $(OBJDIR)/ldgapp.o $(OBJDIR)/ldglib.o $(OBJDIR)/ldgutil.o $(OBJDIR)/ldgload.o
LIB = $(LIBDIR)/libldg.a

all: $(LIB)

$(LIB): $(OBJECTS)
	if [ ! -d $(LIBDIR) ]; then mkdir $(LIBDIR); fi
	rm -f $@
	$(AR) cru $@ $(OBJECTS)

$(OBJDIR)/%.o: $(SRCDIR)/%.c $(HEADER)
	if [ ! -d $(OBJDIR) ]; then mkdir $(OBJDIR); fi
	$(CC) $(CFLAGS) -c $< -o $@

install:
	cp -fv $(LIB) $(INSTDIR)/lib
	cp -fv ../../include/ldg.h $(INSTDIR)/include

clean:
	rm -f $(OBJECTS) 
	if [ -d $(OBJDIR) ]; then rmdir $(OBJDIR); fi
