# Librairie Dynamique GEM
# Olivier Landemarre, Dominique Brziat, Arnaud Bercegeay
# tous droits rservs 1997/1998/1999/2000/2001/2002
#
# Makefile for Sozobon C

CC      = $(CC_SOX)
AR      = $(AR_SOX)
AS      = jas
CFLAGS  = -O -I..\..\include\ldg.h  -I..\options.h -I..\version.h
HEADER  = ..\..\include\ldg.h ..\options.h ..\version.h
OBJECTS = soz\ldgapp.o soz\ldglib.o soz\ldgutil.o soz\ldgload.o soz\stdcall.o
TARGET  =..\..\lib\sozobon\libldg.a

all: $(TARGET)

$(TARGET): $(OBJECTS)
	$(RM) -f $(TARGET)
	$(AR) -r $(TARGET) $(OBJECTS)

soz\stdcall.o: stdcall.s
	$(AS) -o soz\stdcall.o stdcall.s
soz\ldgapp.o: ldgapp.c $(HEADER)
	$(CC) $(CFLAGS) -c $< -o $@
soz\ldglib.o: ldglib.c $(HEADER)
	$(CC) $(CFLAGS) -c $< -o $@
soz\ldgutil.o: ldgutil.c $(HEADER)
	$(CC) $(CFLAGS) -c $< -o $@
soz\ldgload.o: ldgload.c $(HEADER)
	$(CC) $(CFLAGS) -c $< -o $@

#$(HEADER)

clean:
	$(RM) -f $(OBJECTS)

