; TRNFM_TO_STDCALL
;
; dtournement des routines des lib LDG pour que les registres
; a2/d2 soient sauves avant que la fonction "dtourne" ne soit
; effectivement appele. Au retour de cette fonction, les registres
; seront restaurs.
;
; but de ce "dtournement":
; garantir que seuls les registres a0-a1 et d0-d1 puissent tre
; modifis (scratch registers).
;
; utile pour les lib compiles avec pure c qui considre que
; d2 est galement un scratch register.
; utile pour les lib compiles avec sozobonx qui considre que
; a2/d2 sont galement des scratchs register.
; ceci ne concerne pas GCC pour qui seuls d0-d1 et a0-a1 sont
; des scratch registers.
;
; Copyright (c) 2001 Arnaud BERCEGEAY <bercegeay@atari.org>
; 

;
; ***************************************************************
;   PREAMBULE
; ***************************************************************
;
; Le code de chaque fonction est dtourn vers un autre code qui
; contient les instructions suivantes:
;
; LEA #adresse_de_la_procedure_originale, A0
; JMP __ldg_begin_stdcall
;
; ==> toutes les procdures de la lib LDG sont rediriges vers
; __ldg_begin_stdcall. En entrant dans ce code, A0 contient
; l'adresse de la fonction  appeler.
;

	.globl __ldg_adr_regctx, __ldg_nb_regctx
	
	
; section DATA
	.data

; variable statique : le verrou
; positionn  1 pour locker l'utilisation de la table des contextes
; (ncessaire car les LDG sont partageables)

verrou:
	.dc.b	0

; section TEXT
	.text

; point d'entrer du programme.
; toutes les fonctions du LDG sont dtournes ici.
; a0 contient alors la valeur de la fonction "originale".

	.globl	__ldg_begin_stdcall

__ldg_begin_stdcall:

;	on verifie que le mcanisme de "contexte" n'est pas
;  en cours d'utilisation. S'il est dj utilis, on boucle jusqu'
;  ce qu'il se libre.

lock:
	bset	#0, verrou
	bne	lock

;  le verrou est positionn. On est sur que personne d'autre n'est
;  en train de manipuler les structures regctx.
;  on recherche la premiere structure libre
	
	move.l	#__ldg_adr_regctx,a1
	move.l	__ldg_nb_regctx,d0
tst_ctx:
	tst.l		d0
	beq		go_to_real_function
	tst.l		(a1)
	beq		save_ctx
	subq.l	#1,d0
	adda.l	#16,a1
	bra		tst_ctx

;  on a trouv un espace pour sauver le contexte.
;  a1 pointe sur cet espace.
;  on sauve le contexte (d2,a2,a3,(a7)) dans cet espace
;  - d2 et a2 parceque ce ne sont pas des "scratch registers" pour
;    tout le monde
;  - (a7) contient l'adresse de retour car elle sera modifi dans la pile
;  - a3 car on va le modifier pour y sauver l'adresse de "l'espace (this)"

save_ctx:
	adda.l	#16,a1
	movem.l	d2/a2/a3,-(a1)
	move.l	(a7),-(a1)
	move.l	a1,a3
	
;  maintenant, le contexte est sauv et a3 contient l'adresse du contexte
;  sauvegard. On modifie l'adresse de retour dans la pile pour que
;  la fonction de restitution du contexte soit appele en sortie

	move.l	#__ldg_end_stdcall,(a7)
	
go_to_real_function:

;  a ce niveau, il faut lancer la "vraie" fonction
;  dont l'adresse est stocke dans a0 depuis le dbut.
;  mais avant tout, il est grand temps de libr le verrou
;  pour ne plus monopoliser la liste des contextes

	clr.b	verrou
	jmp		(a0)


;  de retour de la "vraie" fonction, il faut restituer 
;  le contexte point par a3.
;  ATTENTION: le registre D0 contient la valeur de retour de la
;  "vraie" fonction, et il ne doit donc pas tre modifi

__ldg_end_stdcall:

;  sauvegarde de a3 dans a1 (avant de restituer a3)
;  restitution des registres sauvegards
	
	move.l	a3,a1
	move.l	(a1)+,a0
	movem.l	(a1)+,d2/a2/a3

;	pour rendre le "contexte" libre, il suffit de remettre  0
;  le 1er champ de a1 (adresse de retour apres appel  la fonction)

	clr.l		-16(a1)

;	a0 contient maintenant l'adresse de retour du client qui a appele
;  la "vraie" fonction.

	jmp		(a0)
	
