/*
 * LDG : Gem Dynamical Libraries
 * Copyright (c) 1997-2004 Olivier Landemarre, Dominique Bereziat & Arnaud Bercegeay
 *
 * Implementation of LDGM cookie functions
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * $Id$
 */

/*
 * Utilisateur de Pure C : corrigez la dclaration de Fcntl() dans
 * TOS.H : la fonction retourne un long (et non un int).
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <options.h>
#include "global.h"

/*	Fonctions externes
 */
LDG* 	ldg_load	( int id, char *lib);
int		ldg_unload	( LDG *ldg);
void 	ldg_snd_msg	( int from_id, int to_id, int msg, 
		  		  	  int mot3, int mot4, int mot5, int mot6, int mot7,
		  		  	  short *global);
int 	appl_name	( char *name, int id, short *gl);
int 	get_app		( int id, int *list);
int 	get_lib		( char *name, LDG *ldg);
void 	set_error	( int);

/*	Variables externes
 */
extern struct internal intern[];

static void close_shm( int id) { 
	char path[50];
	sprintf( path, LDG_SHM_FILENAME, id);
	/* si la shm n'est pas supporte, cet appel
	 * est sans consquence ...
	 */
	Fdelete( path);
}

static void addslash( char *p) {
  if( p[strlen(p)-1] != '\\') strcat( p, "\\");
}

/*
 *	Cette fonction retourne le vrai chemin d'une librairie
 *	retourne 1 si le chemin est Okay 0 sinon.
 *	path doit pointer sur une chaine suffisament longue
 *
 * TODO: if path is empty : return a valid LDG directory
 *       if path is a directory (finishing by / or \) try to locate
 *       this directory among LDG paths
 */

short __CDECL cdecl_ldg_libpath( char *path, short *global) {
  char ppath[256];
  char *p;
  int fd;
  LDG_INFOS *cook;

  /* Convert in TOS format if needed */

  /* case of mint unified fs /.. -> u:/..  */
  if( *path == '/') {
#if 0
    path[0] = tolower(path[1]);
    path[1] = ':';
    p = path + 2; 
#else
    strcpy( ppath, path);
    strcpy( path, "u:");
    strcat( path, ppath);
  }
#endif
  /* convert slash to anti-slash */
  for( p=path; *p != '\0'; p++)
    if( *p == '/') *p = '\\';
  
  strcpy( ppath, path);

  /* ... dans le rpertoire courant (relatif ou complet)... */

  fd = (int)Fopen( path, FO_READ);
  
  /* ... dans le cookie LDGM ... */
  if( fd < 0 && ldg_cookie( LDG_COOKIE, (long*)&cook)) {
    strcpy( path, cook->path);
    addslash( path);
    strcat( path, ppath);
    fd = (int)Fopen( path, FO_READ);
  }

  /* ... ou dans la variable d'environnement LDGPATH ... */
  if( fd < 0) {
    mt_shel_envrn( &p, "LDGPATH=", global);
    if( p) {
      strcpy( path, p);
      addslash( path);
      strcat( path, ppath);
      fd = (int)Fopen( path, FO_READ);
    }	
  }
  
  /* dans les chemins PATH */
  if( fd < 0) {
    mt_shel_find( path, global);
    fd = (int)Fopen( path, FO_READ);
  }

  /* Le rsultat */ 
  if( fd >= 0 ) {
    (void)Fclose(fd);
    return 1;
  }
  return 0;		/* Librairie absente */
}

/*
 *	dclaration d'une lib et de son client
 *	LDG: adresse la lib
 *	name: nom de la lib
 *	id: id client
 *  fload : si 1, force le rechargement de la librairie.
 */

static LDG* ldg_open_flag( char *name, short *gl, int fload) {
  int i,j, id = _AESapid(gl);
  char *p;
  int loaded = 0;
  int fd;
	
  /* librairie dj ouverte partageable ? */
  
  /* remove path, keep filename, in TOS or MiNT format */
#if 0  /* Modif for LDG 2.33 */
  p = strpbrk( name, "/\\");
  p = p?(p+1):name;
#else
  p = name;
#endif
  i = get_lib( p, NULL);
  if( i != -1 && intern->libs[i].ldg->flags & LDG_NOT_SHARED) i = -1;

  /* librairie non ouverte */
  if( i == -1 || fload) {
    /* insrer dans la liste et charger la lib */
    for( i=0; i<intern->maxlib; i++)
      if( intern->libs[i].ldg == NULL) {
	char path[255];

	strcpy( path, name);
	/* Chemin de la lib puis chargement */
	if( cdecl_ldg_libpath( path, gl)) {
	  intern->libs[i].ldg = ldg_load( id, path);
	  sprintf( path, LDG_SHM_FILENAME, i);
	  fd = (int) Fcreate(path,0);
	  /* erreur ou SHM non support */
	  if( fd >= 0) {
	    Fcntl( fd, (long)intern->libs[i].ldg->baspag, SHMSETBLK);
	    Fclose( fd);
	    /* Cas des librairies rsidentes */
	    if( intern->libs[i].ldg->flags & LDG_RESIDENT) {
	      int id = mt_appl_find( "LDGD    ", gl);
	      if( id != -1) {
		ldg_snd_msg( gl[2], id, 
			     LDGD_SHM_REQUEST, /* requete SHM pour LDGD */ 
			     LDGD_SHARE_LDG,   /* partage de la lib */
			     i,                /* librarie concerne */
			     0, 0, 0, gl);
	      }
	    }
	  }
	  loaded = 1;
	} else {
	  set_error( LDG_NOT_FOUND);
	  return NULL;
	}
	strcpy( intern->libs[i].name, p);
	for( j=0; j<intern->maxclient; intern->libs[i].usedby[j++] = -1);
	break;
      }
    if( i == intern->maxlib) {
      set_error( LDG_LIB_FULLED);
      return NULL;		/* erreur, plus de place */
    }
  }

  /* dclaration du client */
  appl_name( intern->apps[id], id, gl);
  /* client dj dclar ? */
  j = get_app( id, intern->libs[i].usedby);
  if( j == -1) {
    if( loaded==0 && intern->libs[i].ldg->flags & LDG_LOCKED) {
      set_error( LDG_LIB_LOCKED);
      return NULL;	/* erreur, librairie verrouille */
    }
    /* insrer le client dans la liste */
    for( j=0; j<intern->maxclient; j++)
      if( intern->libs[i].usedby[j] == -1) {
	if( j != 0) {
	  char path[50];
      				
	  sprintf( path, LDG_SHM_FILENAME, i);
	  fd = (int)Fopen( path, FO_RW);
	  /* erreur ou SHM non support */
	  if( fd >= 0) {	
	    char *blk;
      					
	    blk = (char *)Fcntl( fd, 0L, SHMGETBLK);
	    Fclose( fd);
	    if( blk != intern->libs[i].ldg->baspag) {
	      /* aie Mint a dplac la lib ! 
	       * on pourrait vouloir la recharger
	       * mais ce sera un autre jour ! 
	       */ 
	      /*
		set_error( LDG_LOST_LIB);
		return NULL;
	      */
	      if( blk) Mfree( blk);
	      /* La librarie se recharge */
	      /* Dom -> Olivier : est-ce bien utile de passer par
	       * ldg_open_flag et pas directement cdecl_ldg_open() ? */
	      return ldg_open_flag( name, gl, 1);
	    }
	  }
	}
	intern->libs[i].usedby[j] = id;
	intern->libs[i].ndecl[j] = 1;
	return intern->libs[i].ldg;
      }
    set_error( LDG_APP_FULLED);
    return NULL;		/* erreur, plus de place */
  } else
    intern->libs[i].ndecl[j] ++;

  return intern->libs[i].ldg;
}

LDG* __CDECL cdecl_ldg_open( char *name, short *gl) {
	return ldg_open_flag( name, gl, 0);
}

/*
 *	Une librarie n'est plus utilise
 */

short __CDECL cdecl_ldg_close( LDG *ldg, short *gl) {
	int ilib, 		/* index lib */
		iclient;	/* index client */
	int apid = AESapid(gl);
	
    /* Chercher l'index de la lib */
	ilib = get_lib( NULL, ldg);
	if( ilib != -1) {
		/* chercher l'index du client */
		iclient = get_app( apid, intern->libs[ilib].usedby);
		/* Si client trouv, on l'enlve de la liste */
		if( iclient != -1) {
			if(intern->libs[ilib].ndecl[iclient] > 1)
				intern->libs[ilib].ndecl[iclient] --;
			else
				intern->libs[ilib].usedby[iclient] = -1;
		}

		/* Si plus de client, on retire la lib */
		if( get_app( -1, intern->libs[ilib].usedby) == 0 ) {
			close_shm( ilib);
			ldg_unload( intern->libs[ilib].ldg);
			intern->libs[ilib].ldg = NULL;
			*(intern->libs[ilib].name) = '\0';
		} else {

	/* DOM : ICI JE COMPREND PAS TROP */

		/* Arg ce qui suit ne fonctionne pas comme il faut sous 
		 * Magic 5 le bougre efface purrement et simplement le bloc !
		 * donc le LDG, on laisse faire le systeme alors de toute
		 * facon ce qui devra etre libr le sera
		 * En theorie c'est ce qu'il faudrait faire sous Mint
		
			if( is_Fcntl())
				Mfree(intern->libs[ilib].ldg->baspag); / * desaloc du block obtenu par Fcntl() * /
		 */
		}
	} else
		return LDG_NOT_FOUND;	/* lib pas trouve */
	return 0;
}

void __CDECL cdecl_ldg_garbage( short *gl) {
	int i, j;
	
  	for( i=0; i<intern->maxlib; i++) {
  		/* Librarie charge et non rsidente */
  		if( intern->libs[i].ldg && !(intern->libs[i].ldg -> flags & LDG_RESIDENT)) {
  			for( j=0; j<intern->maxclient; j++) {
  				if( intern->libs[i].usedby[j] != -1) {
  					/* Pseudo ping du client */
  					if( mt_appl_find( intern->apps[intern->libs[i].usedby[j]], gl) == -1)
  						intern->libs[i].usedby[j] = -1;
  				}
  			}
  			if( get_app( -1, intern->libs[i].usedby) == 0) {
  				close_shm( i);
  				ldg_unload( intern->libs[i].ldg);
  				*(intern->libs[i].name) = '\0';
  				intern->libs[i].ldg = NULL;
  			}
  		}
  	}
}

/* on supprime toutes les libs */

void __CDECL cdecl_ldg_release( short *gl) {
	int i, j;

	for( i=0; i<intern->maxlib; i++) {
		if( intern->libs[i].ldg) {
			*(intern->libs[i].name) = '\0';
			for( j=0; j<intern->maxclient; j++) {
				if( intern->libs[i].usedby[j] != -1) {
					/* On informe les clients de la terminaison
					 * des libraries */
					ldg_snd_msg( AESapid(gl), intern->libs[i].usedby[j],
								 LDG_QUIT, ADR2WORD( intern->libs[i].ldg),
								 2, /* LDG 1.xx spcifie cette valeur qui indique
								 	 * la raison de la terminaison */
								 0, 0, gl);	
				}
			}
      		close_shm( i);
			ldg_unload( intern->libs[i].ldg);			
			intern->libs[i].ldg = NULL;
    	}
    }
}

void* __CDECL cdecl_ldg_find( char *name_fct, LDG *ldg) {
	static int lastpos = 0;
	int i, j;

	if( ldg == NULL) return NULL;
	for( i=0; i < ldg->num; i++) {
		j = (i + lastpos) % ldg->num;
		if(!strcmp( ldg->list[j].name, name_fct)) {
			lastpos = j+1;
			return((void *)ldg->list[j].func);
		}
	}
	return(NULL);
}

/* EOF */

