#!make -f
#
# LDG : Gem Dynamical Libraries
# Copyright (c) 1997-2004 Olivier Landemarre, Dominique Bereziat & Arnaud Bercegeay
#
# Makefile to build MEM.LDG
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# $Id$

CC      = $(CC_PUREC)
AS      = $(AS_PUREC)
LD      = $(LD_PUREC)
CFLAGS  = -G -P -DDOSHM -I.. -I../../include -I$(PURECINC)
LDFLAGS = -V
STARTUP = $(PURECLIB)/pcstart.o 
LDLIBS  = $(PURECLIB)/pcstdlib.lib $(PURECLIB)/pctoslib.lib \
          $(PURECLIB)/gem.lib ../../lib/purec/ldg.lib 

TARGET  = ../../gemsys/ldg/mem.ldg
OBJECTS = ldgmain.o getpages.o globals.o osmem.o \
	  sbrk.o malloc.o realloc.o bzero.o bcopy.o

$(TARGET): $(OBJECTS)
	@echo LD $(notdir $@)
	@$(LD) $(LDFLAGS) -O=$@ $(STARTUP) $^ $(LDLIBS) 

# Rules
%.o: %.c 
	@echo CC $(notdir $@)
	@$(CC) $(CFLAGS) -O=$@ $<
%.o: %.s 
	@echo AS $(notdir $@)
	@$(AS) $(ASFLAGS) -O=$@ $<

clean:; $(RM) $(OBJECTS)
