#
# All rigth reserved Dominique Brziat
# (c) 2000-2003
#
# Makefile for building mem.ldg and pure c lib binding
#

CC 		= cc
AS 		= pasm
AR		= plink -J

CFLAGS	= -O -DDOSHM -W0,-P -I..\..\include
LDFLAGS	= -s -lgem ..\..\lib\purec\ldg.lib

OBJECTS	  = ldgmain.o getpages.o globals.o osmem.o \
			sbrk.o malloc.o realloc.o bzero.o bcopy.o
LDGTARGET = ..\..\gemsys\ldg\mem.ldg
LIBTARGET = ..\..\lib\purec\mem.lib

all: $(LDGTARGET) $(LIBTARGET)

ldg: $(LDGTARGET)
lib: $(LIBTARGET)

$(LDGTARGET): $(OBJECTS)
	$(CC) $^ -o $@ $(LDFLAGS)
	prgflags +g $@

bcopy.o: bcopy.s
	$(CC) -c $< -o tmp.o $(CFLAGS)
	mv tmp.o $@

$(LIBTARGET): mem.o
	$(AR) mem.o -O=$(LIBTARGET)

clean:
	$(RM) $(OBJECTS) mem.o
