#ifndef _SYS_SYSLIMITS_H_
#define _SYS_SYSLIMITS_H_

#include <features.h>

#define	ARG_MAX			65536	/* max bytes for an exec function */
#ifndef CHILD_MAX
#define	CHILD_MAX		   40	/* max simultaneous processes */
#endif
#define	LINK_MAX		32767	/* max file link count */
#define	MAX_CANON		  255	/* max bytes in term canon input line */
#define	MAX_INPUT		  255	/* max bytes in terminal input */
#define	NAME_MAX		  255	/* max bytes in a file name */
#define	NGROUPS_MAX		   16	/* max supplemental group id's */
#ifndef OPEN_MAX
#define	OPEN_MAX		   64	/* max open files per process */
#endif
#define LOGIN_NAME_MAX    256   /* max length of a login name */
#define	PATH_MAX		 1024	/* max bytes in pathname */
#define	PIPE_BUF		  512	/* max bytes for atomic pipe writes */
#define	IOV_MAX			 1024	/* max elements in i/o vector */
#define HOST_NAME_MAX      65   /* max bytes in hostname */

#define	BC_BASE_MAX		   99	/* max ibase/obase values in bc(1) */
#define	BC_DIM_MAX		 2048	/* max array elements in bc(1) */
#define	BC_SCALE_MAX	   99	/* max scale value in bc(1) */
#define	BC_STRING_MAX	 1000	/* max const string length in bc(1) */
#define	COLL_WEIGHTS_MAX  255	/* max weights for order keyword */
#define	EXPR_NEST_MAX	   32	/* max expressions nested in expr(1) */
#define	LINE_MAX		 2048	/* max bytes in an input line */
#define	RE_DUP_MAX		  255	/* max RE's in interval notation */

#endif /* _SYS_SYSLIMITS_H_ */