#ifndef CLIB_EXEC_PROTOS_H
#define CLIB_EXEC_PROTOS_H

/*
** This file was machine generated by idltool.py 54.8.
** Do not edit.
**
** Copyright (C) 2003-2022 Trevor Dickinson
**
** C prototypes. For use with 32 bit integers only.
*/

#include <exec/types.h>
#include <exec/tasks.h>
#include <exec/memory.h>
#include <exec/ports.h>
#include <exec/devices.h>
#include <exec/io.h>
#include <exec/semaphores.h>
#include <exec/avl.h>

#ifdef __amigaos4__
#error Include <proto/> header files, not <clib/> header files in AmigaOS 4.
#endif

#ifdef __cplusplus
#ifdef __USE_AMIGAOS_NAMESPACE__
namespace AmigaOS {
#endif
extern "C" {
#endif /* __cplusplus */

ULONG Supervisor(APTR userFunc);
void InitCode(ULONG startClass, ULONG version);
void InitStruct(CONST_APTR initTable, APTR memory, ULONG size);
struct Library * MakeLibrary(CONST_APTR vectors, CONST_APTR structure, CONST_APTR init, ULONG dataSize, APTR segList);
ULONG MakeFunctions(APTR target, CONST_APTR functionArray, CONST_APTR funcDispBase);
struct Resident * FindResident(CONST_STRPTR name);
APTR InitResident(const struct Resident * resident, ULONG segList);
void Alert(ULONG alertNum);
void Disable(void);
void Enable(void);
void Forbid(void);
void Permit(void);
ULONG SetSR(ULONG newSR, ULONG mask);
APTR SuperState(void);
void UserState(APTR sysStack);
struct Interrupt * SetIntVector(ULONG intNum, const struct Interrupt * interrupt);
BOOL AddIntServer(ULONG intNum, struct Interrupt * interrupt);
void RemIntServer(ULONG intNum, struct Interrupt * interrupt);
void Cause(struct Interrupt * interrupt);
APTR Allocate(struct MemHeader * memHeader, ULONG byteSize);
void Deallocate(struct MemHeader * memHeader, APTR memoryBlock, ULONG byteSize);
APTR AllocMem(ULONG byteSize, ULONG attributes);
APTR AllocAbs(ULONG byteSize, APTR location);
void FreeMem(APTR memoryBlock, ULONG byteSize);
ULONG AvailMem(ULONG attributes);
struct MemList * AllocEntry(struct MemList * memList);
void FreeEntry(struct MemList * memList);
void Insert(struct List * list, struct Node * node, struct Node * listNode);
void AddHead(struct List * list, struct Node * node);
void AddTail(struct List * list, struct Node * node);
void Remove(struct Node * node);
struct Node * RemHead(struct List * list);
struct Node * RemTail(struct List * list);
void Enqueue(struct List * list, struct Node * node);
struct Node * FindName(struct List * start, CONST_STRPTR name);
APTR AddTask(struct Task * task, CONST_APTR initialPC, CONST_APTR finalPC);
void RemTask(struct Task * task);
struct Task * FindTask(CONST_STRPTR name);
BYTE SetTaskPri(struct Task * task, BYTE priority);
ULONG SetSignal(ULONG newSignals, ULONG signalMask);
ULONG SetExcept(ULONG newSignals, ULONG signalMask);
ULONG Wait(ULONG signalSet);
void Signal(struct Task * task, ULONG signals);
BYTE AllocSignal(BYTE signalNum);
void FreeSignal(BYTE signalNum);
LONG AllocTrap(ULONG trapNum);
void FreeTrap(ULONG trapNum);
void AddPort(struct MsgPort * port);
void RemPort(struct MsgPort * port);
void PutMsg(struct MsgPort * port, struct Message * message);
struct Message * GetMsg(struct MsgPort * port);
void ReplyMsg(struct Message * message);
struct Message * WaitPort(struct MsgPort * port);
struct MsgPort * FindPort(CONST_STRPTR name);
void AddLibrary(struct Library * library);
ULONG RemLibrary(struct Library * library);
APTR CloseLibrary(struct Library * library);
APTR SetFunction(struct Library * library, LONG funcOffset, CONST_APTR newFunc);
void SumLibrary(struct Library * library);
void AddDevice(struct Device * device);
ULONG RemDevice(struct Device * device);
LONG OpenDevice(CONST_STRPTR devName, ULONG unitNumber, struct IORequest * ioRequest, ULONG flags);
APTR CloseDevice(struct IORequest * ioRequest);
BYTE DoIO(struct IORequest * ioRequest);
void SendIO(struct IORequest * ioRequest);
struct IORequest * CheckIO(struct IORequest * ioRequest);
BYTE WaitIO(struct IORequest * ioRequest);
void AbortIO(struct IORequest * ioRequest);
void AddResource(APTR resource);
void RemResource(APTR resource);
APTR OpenResource(CONST_STRPTR resName);
APTR RawDoFmt(CONST_STRPTR formatString, CONST_APTR dataStream, void (*PutChProc)(), APTR PutChData);
UWORD GetCC(void);
ULONG TypeOfMem(CONST_APTR address);
void Procure(struct SignalSemaphore * semaphore, struct SemaphoreMessage * bidMessage);
void Vacate(struct SignalSemaphore * semaphore, struct SemaphoreMessage * bidMessage);
struct Library * OpenLibrary(CONST_STRPTR name, ULONG version);
void InitSemaphore(struct SignalSemaphore * semaphore);
void ObtainSemaphore(struct SignalSemaphore * semaphore);
void ReleaseSemaphore(struct SignalSemaphore * semaphore);
LONG AttemptSemaphore(struct SignalSemaphore * semaphore);
void ObtainSemaphoreList(struct List * list);
void ReleaseSemaphoreList(struct List * list);
struct SignalSemaphore * FindSemaphore(CONST_STRPTR name);
void AddSemaphore(struct SignalSemaphore * semaphore);
void RemSemaphore(struct SignalSemaphore * semaphore);
ULONG SumKickData(void);
void AddMemList(ULONG size, ULONG attributes, LONG pri, APTR base, CONST_STRPTR name);
void CopyMem(CONST_APTR source, APTR dest, ULONG size);
void CopyMemQuick(CONST_APTR source, APTR dest, ULONG size);
void CacheClearU(void);
void CacheClearE(APTR address, ULONG length, ULONG caches);
ULONG CacheControl(ULONG cacheBits, ULONG cacheMask);
struct IORequest * CreateIORequest(const struct MsgPort * ioReplyPort, ULONG size);
void DeleteIORequest(struct IORequest * ioRequest);
struct MsgPort * CreateMsgPort(void);
void DeleteMsgPort(struct MsgPort * port);
void ObtainSemaphoreShared(struct SignalSemaphore * semaphore);
APTR AllocVec(ULONG byteSize, ULONG attributes);
void FreeVec(APTR memoryBlock);
APTR CreatePool(ULONG memFlags, ULONG puddleSize, ULONG threshSize);
void DeletePool(APTR poolHeader);
APTR AllocPooled(APTR poolHeader, ULONG memSize);
void FreePooled(APTR poolHeader, APTR memory, ULONG memSize);
LONG AttemptSemaphoreShared(struct SignalSemaphore * semaphore);
void ColdReboot(void);
void StackSwap(struct StackSwapStruct * newstack);
APTR CachePreDMA(CONST_APTR vaddr, ULONG * length, ULONG flags);
void CachePostDMA(CONST_APTR vaddr, ULONG * length, ULONG flags);
VOID AddMemHandler(struct Interrupt * memHandler);
VOID RemMemHandler(struct Interrupt * memHandler);
ULONG ObtainQuickVector(APTR interruptCode);
void NewMinList(struct MinList * list);
struct AVLNode * AVL_AddNode(struct AVLNode ** root, struct AVLNode * node, AVLNODECOMP func);
struct AVLNode * AVL_RemNodeByAddress(struct AVLNode ** root, struct AVLNode * node);
struct AVLNode * AVL_RemNodeByKey(struct AVLNode ** root, AVLKey key, AVLKEYCOMP func);
struct AVLNode * AVL_FindNode(const struct AVLNode * root, AVLKey key, AVLKEYCOMP func);
struct AVLNode * AVL_FindPrevNodeByAddress(const struct AVLNode * root);
struct AVLNode * AVL_FindPrevNodeByKey(const struct AVLNode * root, AVLKey key, AVLKEYCOMP func);
struct AVLNode * AVL_FindNextNodeByAddress(const struct AVLNode * root);
struct AVLNode * AVL_FindNextNodeByKey(const struct AVLNode * root, AVLKey key, AVLKEYCOMP func);
struct AVLNode * AVL_FindFirstNode(const struct AVLNode * root);
struct AVLNode * AVL_FindLastNode(const struct AVLNode * root);

#ifdef __cplusplus
}
#ifdef __USE_AMIGAOS_NAMESPACE__
}
#endif
#endif /* __cplusplus */

#endif /* CLIB_EXEC_PROTOS_H */
