#ifndef CLIB_UTILITY_PROTOS_H
#define CLIB_UTILITY_PROTOS_H

/*
** This file was machine generated by idltool.py 54.8.
** Do not edit.
**
** Copyright (C) 2003-2021 Trevor Dickinson
**
** C prototypes. For use with 32 bit integers only.
*/

#include <exec/ports.h>
#include <utility/tagitem.h>
#include <utility/date.h>
#include <utility/hooks.h>
#include <utility/name.h>
#include <utility/data_structures.h>
#include <utility/random.h>
#include <utility/message_digest.h>

#ifdef __amigaos4__
#error Include <proto/> header files, not <clib/> header files in AmigaOS 4.
#endif

#ifdef __cplusplus
#ifdef __USE_AMIGAOS_NAMESPACE__
namespace AmigaOS {
#endif
extern "C" {
#endif /* __cplusplus */

struct TagItem * FindTagItem(Tag tagValue, const struct TagItem * tagList);
ULONG GetTagData(Tag tagValue, ULONG defaultVal, const struct TagItem * tagList);
ULONG PackBoolTags(ULONG initialFlags, const struct TagItem * tagList, const struct TagItem * boolMap);
struct TagItem * NextTagItem(struct TagItem ** tags);
VOID FilterTagChanges(struct TagItem * changeList, struct TagItem * originalList, ULONG apply);
VOID MapTags(struct TagItem * tagList, const struct TagItem * mapList, ULONG mapType);
struct TagItem * AllocateTagItems(ULONG numTags);
struct TagItem * CloneTagItems(const struct TagItem * original);
VOID FreeTagItems(struct TagItem * tagList);
VOID RefreshTagItemClones(struct TagItem * clone, const struct TagItem * original);
BOOL TagInArray(Tag tagValue, const Tag * tagArray);
ULONG FilterTagItems(struct TagItem * taglist, const Tag * filterArray, ULONG logic);
ULONG CallHookPkt(struct Hook * hook, APTR object, APTR message);
void Amiga2Date(ULONG date_amiga, struct ClockData * cd);
ULONG Date2Amiga(const struct ClockData * date);
ULONG CheckDate(const struct ClockData * date);
LONG Stricmp(CONST_STRPTR s1, CONST_STRPTR s2);
LONG Strnicmp(CONST_STRPTR s1, CONST_STRPTR s2, LONG n);
ULONG ToUpper(TEXT c);
ULONG ToLower(TEXT c);
VOID ApplyTagChanges(struct TagItem * list, const struct TagItem * changeList);
ULONG PackStructureTags(APTR pack, const ULONG * pack_table, const struct TagItem * tagList);
ULONG UnpackStructureTags(CONST_APTR pack, const ULONG * pack_table, struct TagItem * tagList);
BOOL AddNamedObject(struct NamedObject * nameSpace, struct NamedObject * object);
struct NamedObject * AllocNamedObjectA(CONST_STRPTR name, const struct TagItem * tags);
struct NamedObject * AllocNamedObject(CONST_STRPTR name, Tag tags, ...);
LONG AttemptRemNamedObject(struct NamedObject * object);
struct NamedObject * FindNamedObject(struct NamedObject * name_space, CONST_STRPTR name, struct NamedObject * previous_object);
struct NamedObject * FreeNamedObject(struct NamedObject * obj);
STRPTR NamedObjectName(struct NamedObject * obj);
void ReleaseNamedObject(struct NamedObject * obj);
void RemNamedObject(struct NamedObject * obj, struct Message * message);
ULONG GetUniqueID(void);
LONG Strlcpy(STRPTR dst, CONST_STRPTR src, LONG size);
LONG Strlcat(STRPTR dst, CONST_STRPTR src, LONG size);
LONG VSNPrintf(STRPTR buffer, LONG bufferSize, CONST_STRPTR fmt, APTR args);
LONG SNPrintf(STRPTR buffer, LONG bufferSize, CONST_STRPTR fmt, ULONG arg1, ...);
STRPTR VASPrintf(CONST_STRPTR fmt, APTR args);
STRPTR ASPrintf(CONST_STRPTR fmt, ULONG arg1, ...);
struct SkipList * CreateSkipList(struct Hook * hook, LONG max_levels);
void DeleteSkipList(struct SkipList * skipList);
struct SkipNode * InsertSkipNode(struct SkipList * skipList, APTR key, ULONG dataSize);
struct SkipNode * FindSkipNode(const struct SkipList * skipList, APTR key);
BOOL RemoveSkipNode(struct SkipList * skipList, APTR key);
struct SkipNode * GetFirstSkipNode(const struct SkipList * skipList);
struct SkipNode * GetNextSkipNode(const struct SkipList * skipList, const struct SkipNode * node);
struct SplayTree * CreateSplayTree(struct Hook * compareHook);
void DeleteSplayTree(struct SplayTree * splayTree);
struct SplayNode * InsertSplayNode(struct SplayTree * splayTree, APTR key, ULONG date_size);
struct SplayNode * FindSplayNode(const struct SplayTree * splayTree, APTR key);
struct SplayNode * RemoveSplayNode(struct SplayTree * splayTree, APTR key);
APTR SetMem(APTR destination, UBYTE fillChar, LONG length);
struct Node * FindNameNC(struct List * list, CONST_STRPTR name);
ULONG Random(struct RandomState * state);
void MessageDigest_SHA_Init(struct MessageDigest_SHA * shas);
void MessageDigest_SHA_Update(struct MessageDigest_SHA * shas, APTR data, LONG num_bytes);
void MessageDigest_SHA_Final(struct MessageDigest_SHA * shas);

#ifdef __cplusplus
}
#ifdef __USE_AMIGAOS_NAMESPACE__
}
#endif
#endif /* __cplusplus */

#endif /* CLIB_UTILITY_PROTOS_H */
