#ifndef _INLINE_UTILITY_H
#define _INLINE_UTILITY_H
/*
** This file was machine generated by idltool.py 54.8.
** Do not edit.
**
** Copyright (C) 2003-2021 Trevor Dickinson
*/

#ifdef __amigaos4__
#error Include <proto/> header files, not <inline/> header files in AmigaOS 4.
#endif

#ifndef CLIB_UTILITY_PROTOS_H
#define CLIB_UTILITY_PROTOS_H
#endif

#include <exec/ports.h>
#include <utility/tagitem.h>
#include <utility/date.h>
#include <utility/hooks.h>
#include <utility/name.h>
#include <utility/data_structures.h>
#include <utility/random.h>
#include <utility/message_digest.h>

#ifndef UTILITY_BASE_NAME
#define UTILITY_BASE_NAMEUtilityBase
#endif

#define FindTagItem(tagValue, tagList) ({ \
  Tag _FindTagItem_tagValue = (tagValue); \
  const struct TagItem * _FindTagItem_tagList = (tagList); \
  struct TagItem * _FindTagItem__re = \
  ({ \
  register struct UtilityBase * const __FindTagItem__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct TagItem * __FindTagItem__re __asm("d0"); \
  register Tag __FindTagItem_tagValue __asm("d0") = (_FindTagItem_tagValue); \
  register const struct TagItem * __FindTagItem_tagList __asm("a0") = (_FindTagItem_tagList); \
  __asm volatile ("jsr a6@(-30:W)" \
  : "=r"(__FindTagItem__re) \
  : "r"(__FindTagItem__bn), "r"(__FindTagItem_tagValue), "r"(__FindTagItem_tagList) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __FindTagItem__re; \
  }); \
  _FindTagItem__re; \
})

#define GetTagData(tagValue, defaultVal, tagList) ({ \
  Tag _GetTagData_tagValue = (tagValue); \
  ULONG _GetTagData_defaultVal = (defaultVal); \
  const struct TagItem * _GetTagData_tagList = (tagList); \
  ULONG _GetTagData__re = \
  ({ \
  register struct UtilityBase * const __GetTagData__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register ULONG __GetTagData__re __asm("d0"); \
  register Tag __GetTagData_tagValue __asm("d0") = (_GetTagData_tagValue); \
  register ULONG __GetTagData_defaultVal __asm("d1") = (_GetTagData_defaultVal); \
  register const struct TagItem * __GetTagData_tagList __asm("a0") = (_GetTagData_tagList); \
  __asm volatile ("jsr a6@(-36:W)" \
  : "=r"(__GetTagData__re) \
  : "r"(__GetTagData__bn), "r"(__GetTagData_tagValue), "r"(__GetTagData_defaultVal), "r"(__GetTagData_tagList) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __GetTagData__re; \
  }); \
  _GetTagData__re; \
})

#define PackBoolTags(initialFlags, tagList, boolMap) ({ \
  ULONG _PackBoolTags_initialFlags = (initialFlags); \
  const struct TagItem * _PackBoolTags_tagList = (tagList); \
  const struct TagItem * _PackBoolTags_boolMap = (boolMap); \
  ULONG _PackBoolTags__re = \
  ({ \
  register struct UtilityBase * const __PackBoolTags__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register ULONG __PackBoolTags__re __asm("d0"); \
  register ULONG __PackBoolTags_initialFlags __asm("d0") = (_PackBoolTags_initialFlags); \
  register const struct TagItem * __PackBoolTags_tagList __asm("a0") = (_PackBoolTags_tagList); \
  register const struct TagItem * __PackBoolTags_boolMap __asm("a1") = (_PackBoolTags_boolMap); \
  __asm volatile ("jsr a6@(-42:W)" \
  : "=r"(__PackBoolTags__re) \
  : "r"(__PackBoolTags__bn), "r"(__PackBoolTags_initialFlags), "r"(__PackBoolTags_tagList), "r"(__PackBoolTags_boolMap) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __PackBoolTags__re; \
  }); \
  _PackBoolTags__re; \
})

#define NextTagItem(tags) ({ \
  struct TagItem ** _NextTagItem_tags = (tags); \
  struct TagItem * _NextTagItem__re = \
  ({ \
  register struct UtilityBase * const __NextTagItem__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct TagItem * __NextTagItem__re __asm("d0"); \
  register struct TagItem ** __NextTagItem_tags __asm("a0") = (_NextTagItem_tags); \
  __asm volatile ("jsr a6@(-48:W)" \
  : "=r"(__NextTagItem__re) \
  : "r"(__NextTagItem__bn), "r"(__NextTagItem_tags) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __NextTagItem__re; \
  }); \
  _NextTagItem__re; \
})

#define FilterTagChanges(changeList, originalList, apply) ({ \
  struct TagItem * _FilterTagChanges_changeList = (changeList); \
  struct TagItem * _FilterTagChanges_originalList = (originalList); \
  ULONG _FilterTagChanges_apply = (apply); \
  { \
  register struct UtilityBase * const __FilterTagChanges__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct TagItem * __FilterTagChanges_changeList __asm("a0") = (_FilterTagChanges_changeList); \
  register struct TagItem * __FilterTagChanges_originalList __asm("a1") = (_FilterTagChanges_originalList); \
  register ULONG __FilterTagChanges_apply __asm("d0") = (_FilterTagChanges_apply); \
  __asm volatile ("jsr a6@(-54:W)" \
  : \
  : "r"(__FilterTagChanges__bn), "r"(__FilterTagChanges_changeList), "r"(__FilterTagChanges_originalList), "r"(__FilterTagChanges_apply) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#define MapTags(tagList, mapList, mapType) ({ \
  struct TagItem * _MapTags_tagList = (tagList); \
  const struct TagItem * _MapTags_mapList = (mapList); \
  ULONG _MapTags_mapType = (mapType); \
  { \
  register struct UtilityBase * const __MapTags__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct TagItem * __MapTags_tagList __asm("a0") = (_MapTags_tagList); \
  register const struct TagItem * __MapTags_mapList __asm("a1") = (_MapTags_mapList); \
  register ULONG __MapTags_mapType __asm("d0") = (_MapTags_mapType); \
  __asm volatile ("jsr a6@(-60:W)" \
  : \
  : "r"(__MapTags__bn), "r"(__MapTags_tagList), "r"(__MapTags_mapList), "r"(__MapTags_mapType) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#define AllocateTagItems(numTags) ({ \
  ULONG _AllocateTagItems_numTags = (numTags); \
  struct TagItem * _AllocateTagItems__re = \
  ({ \
  register struct UtilityBase * const __AllocateTagItems__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct TagItem * __AllocateTagItems__re __asm("d0"); \
  register ULONG __AllocateTagItems_numTags __asm("d0") = (_AllocateTagItems_numTags); \
  __asm volatile ("jsr a6@(-66:W)" \
  : "=r"(__AllocateTagItems__re) \
  : "r"(__AllocateTagItems__bn), "r"(__AllocateTagItems_numTags) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __AllocateTagItems__re; \
  }); \
  _AllocateTagItems__re; \
})

#define CloneTagItems(original) ({ \
  const struct TagItem * _CloneTagItems_original = (original); \
  struct TagItem * _CloneTagItems__re = \
  ({ \
  register struct UtilityBase * const __CloneTagItems__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct TagItem * __CloneTagItems__re __asm("d0"); \
  register const struct TagItem * __CloneTagItems_original __asm("a0") = (_CloneTagItems_original); \
  __asm volatile ("jsr a6@(-72:W)" \
  : "=r"(__CloneTagItems__re) \
  : "r"(__CloneTagItems__bn), "r"(__CloneTagItems_original) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __CloneTagItems__re; \
  }); \
  _CloneTagItems__re; \
})

#define FreeTagItems(tagList) ({ \
  struct TagItem * _FreeTagItems_tagList = (tagList); \
  { \
  register struct UtilityBase * const __FreeTagItems__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct TagItem * __FreeTagItems_tagList __asm("a0") = (_FreeTagItems_tagList); \
  __asm volatile ("jsr a6@(-78:W)" \
  : \
  : "r"(__FreeTagItems__bn), "r"(__FreeTagItems_tagList) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#define RefreshTagItemClones(clone, original) ({ \
  struct TagItem * _RefreshTagItemClones_clone = (clone); \
  const struct TagItem * _RefreshTagItemClones_original = (original); \
  { \
  register struct UtilityBase * const __RefreshTagItemClones__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct TagItem * __RefreshTagItemClones_clone __asm("a0") = (_RefreshTagItemClones_clone); \
  register const struct TagItem * __RefreshTagItemClones_original __asm("a1") = (_RefreshTagItemClones_original); \
  __asm volatile ("jsr a6@(-84:W)" \
  : \
  : "r"(__RefreshTagItemClones__bn), "r"(__RefreshTagItemClones_clone), "r"(__RefreshTagItemClones_original) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#define TagInArray(tagValue, tagArray) ({ \
  Tag _TagInArray_tagValue = (tagValue); \
  const Tag * _TagInArray_tagArray = (tagArray); \
  BOOL _TagInArray__re = \
  ({ \
  register struct UtilityBase * const __TagInArray__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register BOOL __TagInArray__re __asm("d0"); \
  register Tag __TagInArray_tagValue __asm("d0") = (_TagInArray_tagValue); \
  register const Tag * __TagInArray_tagArray __asm("a0") = (_TagInArray_tagArray); \
  __asm volatile ("jsr a6@(-90:W)" \
  : "=r"(__TagInArray__re) \
  : "r"(__TagInArray__bn), "r"(__TagInArray_tagValue), "r"(__TagInArray_tagArray) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __TagInArray__re; \
  }); \
  _TagInArray__re; \
})

#define FilterTagItems(taglist, filterArray, logic) ({ \
  struct TagItem * _FilterTagItems_taglist = (taglist); \
  const Tag * _FilterTagItems_filterArray = (filterArray); \
  ULONG _FilterTagItems_logic = (logic); \
  ULONG _FilterTagItems__re = \
  ({ \
  register struct UtilityBase * const __FilterTagItems__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register ULONG __FilterTagItems__re __asm("d0"); \
  register struct TagItem * __FilterTagItems_taglist __asm("a0") = (_FilterTagItems_taglist); \
  register const Tag * __FilterTagItems_filterArray __asm("a1") = (_FilterTagItems_filterArray); \
  register ULONG __FilterTagItems_logic __asm("d0") = (_FilterTagItems_logic); \
  __asm volatile ("jsr a6@(-96:W)" \
  : "=r"(__FilterTagItems__re) \
  : "r"(__FilterTagItems__bn), "r"(__FilterTagItems_taglist), "r"(__FilterTagItems_filterArray), "r"(__FilterTagItems_logic) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __FilterTagItems__re; \
  }); \
  _FilterTagItems__re; \
})

#define CallHookPkt(hook, object, message) ({ \
  struct Hook * _CallHookPkt_hook = (hook); \
  APTR _CallHookPkt_object = (object); \
  APTR _CallHookPkt_message = (message); \
  ULONG _CallHookPkt__re = \
  ({ \
  register struct UtilityBase * const __CallHookPkt__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register ULONG __CallHookPkt__re __asm("d0"); \
  register struct Hook * __CallHookPkt_hook __asm("a0") = (_CallHookPkt_hook); \
  register APTR __CallHookPkt_object __asm("a2") = (_CallHookPkt_object); \
  register APTR __CallHookPkt_message __asm("a1") = (_CallHookPkt_message); \
  __asm volatile ("jsr a6@(-102:W)" \
  : "=r"(__CallHookPkt__re) \
  : "r"(__CallHookPkt__bn), "r"(__CallHookPkt_hook), "r"(__CallHookPkt_object), "r"(__CallHookPkt_message) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __CallHookPkt__re; \
  }); \
  _CallHookPkt__re; \
})

#define Amiga2Date(date_amiga, cd) ({ \
  ULONG _Amiga2Date_date_amiga = (date_amiga); \
  struct ClockData * _Amiga2Date_cd = (cd); \
  { \
  register struct UtilityBase * const __Amiga2Date__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register ULONG __Amiga2Date_date_amiga __asm("d0") = (_Amiga2Date_date_amiga); \
  register struct ClockData * __Amiga2Date_cd __asm("a0") = (_Amiga2Date_cd); \
  __asm volatile ("jsr a6@(-120:W)" \
  : \
  : "r"(__Amiga2Date__bn), "r"(__Amiga2Date_date_amiga), "r"(__Amiga2Date_cd) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#define Date2Amiga(date) ({ \
  const struct ClockData * _Date2Amiga_date = (date); \
  ULONG _Date2Amiga__re = \
  ({ \
  register struct UtilityBase * const __Date2Amiga__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register ULONG __Date2Amiga__re __asm("d0"); \
  register const struct ClockData * __Date2Amiga_date __asm("a0") = (_Date2Amiga_date); \
  __asm volatile ("jsr a6@(-126:W)" \
  : "=r"(__Date2Amiga__re) \
  : "r"(__Date2Amiga__bn), "r"(__Date2Amiga_date) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __Date2Amiga__re; \
  }); \
  _Date2Amiga__re; \
})

#define CheckDate(date) ({ \
  const struct ClockData * _CheckDate_date = (date); \
  ULONG _CheckDate__re = \
  ({ \
  register struct UtilityBase * const __CheckDate__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register ULONG __CheckDate__re __asm("d0"); \
  register const struct ClockData * __CheckDate_date __asm("a0") = (_CheckDate_date); \
  __asm volatile ("jsr a6@(-132:W)" \
  : "=r"(__CheckDate__re) \
  : "r"(__CheckDate__bn), "r"(__CheckDate_date) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __CheckDate__re; \
  }); \
  _CheckDate__re; \
})

#define Stricmp(s1, s2) ({ \
  CONST_STRPTR _Stricmp_s1 = (s1); \
  CONST_STRPTR _Stricmp_s2 = (s2); \
  LONG _Stricmp__re = \
  ({ \
  register struct UtilityBase * const __Stricmp__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register LONG __Stricmp__re __asm("d0"); \
  register CONST_STRPTR __Stricmp_s1 __asm("a0") = (_Stricmp_s1); \
  register CONST_STRPTR __Stricmp_s2 __asm("a1") = (_Stricmp_s2); \
  __asm volatile ("jsr a6@(-162:W)" \
  : "=r"(__Stricmp__re) \
  : "r"(__Stricmp__bn), "r"(__Stricmp_s1), "r"(__Stricmp_s2) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __Stricmp__re; \
  }); \
  _Stricmp__re; \
})

#define Strnicmp(s1, s2, n) ({ \
  CONST_STRPTR _Strnicmp_s1 = (s1); \
  CONST_STRPTR _Strnicmp_s2 = (s2); \
  LONG _Strnicmp_n = (n); \
  LONG _Strnicmp__re = \
  ({ \
  register struct UtilityBase * const __Strnicmp__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register LONG __Strnicmp__re __asm("d0"); \
  register CONST_STRPTR __Strnicmp_s1 __asm("a0") = (_Strnicmp_s1); \
  register CONST_STRPTR __Strnicmp_s2 __asm("a1") = (_Strnicmp_s2); \
  register LONG __Strnicmp_n __asm("d0") = (_Strnicmp_n); \
  __asm volatile ("jsr a6@(-168:W)" \
  : "=r"(__Strnicmp__re) \
  : "r"(__Strnicmp__bn), "r"(__Strnicmp_s1), "r"(__Strnicmp_s2), "r"(__Strnicmp_n) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __Strnicmp__re; \
  }); \
  _Strnicmp__re; \
})

#define ToUpper(c) ({ \
  TEXT _ToUpper_c = (c); \
  ULONG _ToUpper__re = \
  ({ \
  register struct UtilityBase * const __ToUpper__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register ULONG __ToUpper__re __asm("d0"); \
  register TEXT __ToUpper_c __asm("d0") = (_ToUpper_c); \
  __asm volatile ("jsr a6@(-174:W)" \
  : "=r"(__ToUpper__re) \
  : "r"(__ToUpper__bn), "r"(__ToUpper_c) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __ToUpper__re; \
  }); \
  _ToUpper__re; \
})

#define ToLower(c) ({ \
  TEXT _ToLower_c = (c); \
  ULONG _ToLower__re = \
  ({ \
  register struct UtilityBase * const __ToLower__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register ULONG __ToLower__re __asm("d0"); \
  register TEXT __ToLower_c __asm("d0") = (_ToLower_c); \
  __asm volatile ("jsr a6@(-180:W)" \
  : "=r"(__ToLower__re) \
  : "r"(__ToLower__bn), "r"(__ToLower_c) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __ToLower__re; \
  }); \
  _ToLower__re; \
})

#define ApplyTagChanges(list, changeList) ({ \
  struct TagItem * _ApplyTagChanges_list = (list); \
  const struct TagItem * _ApplyTagChanges_changeList = (changeList); \
  { \
  register struct UtilityBase * const __ApplyTagChanges__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct TagItem * __ApplyTagChanges_list __asm("a0") = (_ApplyTagChanges_list); \
  register const struct TagItem * __ApplyTagChanges_changeList __asm("a1") = (_ApplyTagChanges_changeList); \
  __asm volatile ("jsr a6@(-186:W)" \
  : \
  : "r"(__ApplyTagChanges__bn), "r"(__ApplyTagChanges_list), "r"(__ApplyTagChanges_changeList) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#define PackStructureTags(pack, pack_table, tagList) ({ \
  APTR _PackStructureTags_pack = (pack); \
  const ULONG * _PackStructureTags_pack_table = (pack_table); \
  const struct TagItem * _PackStructureTags_tagList = (tagList); \
  ULONG _PackStructureTags__re = \
  ({ \
  register struct UtilityBase * const __PackStructureTags__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register ULONG __PackStructureTags__re __asm("d0"); \
  register APTR __PackStructureTags_pack __asm("a0") = (_PackStructureTags_pack); \
  register const ULONG * __PackStructureTags_pack_table __asm("a1") = (_PackStructureTags_pack_table); \
  register const struct TagItem * __PackStructureTags_tagList __asm("a2") = (_PackStructureTags_tagList); \
  __asm volatile ("jsr a6@(-210:W)" \
  : "=r"(__PackStructureTags__re) \
  : "r"(__PackStructureTags__bn), "r"(__PackStructureTags_pack), "r"(__PackStructureTags_pack_table), "r"(__PackStructureTags_tagList) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __PackStructureTags__re; \
  }); \
  _PackStructureTags__re; \
})

#define UnpackStructureTags(pack, pack_table, tagList) ({ \
  CONST_APTR _UnpackStructureTags_pack = (pack); \
  const ULONG * _UnpackStructureTags_pack_table = (pack_table); \
  struct TagItem * _UnpackStructureTags_tagList = (tagList); \
  ULONG _UnpackStructureTags__re = \
  ({ \
  register struct UtilityBase * const __UnpackStructureTags__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register ULONG __UnpackStructureTags__re __asm("d0"); \
  register CONST_APTR __UnpackStructureTags_pack __asm("a0") = (_UnpackStructureTags_pack); \
  register const ULONG * __UnpackStructureTags_pack_table __asm("a1") = (_UnpackStructureTags_pack_table); \
  register struct TagItem * __UnpackStructureTags_tagList __asm("a2") = (_UnpackStructureTags_tagList); \
  __asm volatile ("jsr a6@(-216:W)" \
  : "=r"(__UnpackStructureTags__re) \
  : "r"(__UnpackStructureTags__bn), "r"(__UnpackStructureTags_pack), "r"(__UnpackStructureTags_pack_table), "r"(__UnpackStructureTags_tagList) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __UnpackStructureTags__re; \
  }); \
  _UnpackStructureTags__re; \
})

#define AddNamedObject(nameSpace, object) ({ \
  struct NamedObject * _AddNamedObject_nameSpace = (nameSpace); \
  struct NamedObject * _AddNamedObject_object = (object); \
  BOOL _AddNamedObject__re = \
  ({ \
  register struct UtilityBase * const __AddNamedObject__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register BOOL __AddNamedObject__re __asm("d0"); \
  register struct NamedObject * __AddNamedObject_nameSpace __asm("a0") = (_AddNamedObject_nameSpace); \
  register struct NamedObject * __AddNamedObject_object __asm("a1") = (_AddNamedObject_object); \
  __asm volatile ("jsr a6@(-222:W)" \
  : "=r"(__AddNamedObject__re) \
  : "r"(__AddNamedObject__bn), "r"(__AddNamedObject_nameSpace), "r"(__AddNamedObject_object) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __AddNamedObject__re; \
  }); \
  _AddNamedObject__re; \
})

#define AllocNamedObjectA(name, tags) ({ \
  CONST_STRPTR _AllocNamedObjectA_name = (name); \
  const struct TagItem * _AllocNamedObjectA_tags = (tags); \
  struct NamedObject * _AllocNamedObjectA__re = \
  ({ \
  register struct UtilityBase * const __AllocNamedObjectA__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct NamedObject * __AllocNamedObjectA__re __asm("d0"); \
  register CONST_STRPTR __AllocNamedObjectA_name __asm("a0") = (_AllocNamedObjectA_name); \
  register const struct TagItem * __AllocNamedObjectA_tags __asm("a1") = (_AllocNamedObjectA_tags); \
  __asm volatile ("jsr a6@(-228:W)" \
  : "=r"(__AllocNamedObjectA__re) \
  : "r"(__AllocNamedObjectA__bn), "r"(__AllocNamedObjectA_name), "r"(__AllocNamedObjectA_tags) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __AllocNamedObjectA__re; \
  }); \
  _AllocNamedObjectA__re; \
})

#ifndef NO_INLINE_STDARG
static __inline__ struct NamedObject * ___AllocNamedObject(struct UtilityBase * UtilityBase, CONST_STRPTR name, Tag tags, ...)
{
  return AllocNamedObjectA(name, (const struct TagItem *) &tags);
}

#define AllocNamedObject(name...) ___AllocNamedObject(UTILITY_BASE_NAME, name)
#endif

#define AttemptRemNamedObject(object) ({ \
  struct NamedObject * _AttemptRemNamedObject_object = (object); \
  LONG _AttemptRemNamedObject__re = \
  ({ \
  register struct UtilityBase * const __AttemptRemNamedObject__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register LONG __AttemptRemNamedObject__re __asm("d0"); \
  register struct NamedObject * __AttemptRemNamedObject_object __asm("a0") = (_AttemptRemNamedObject_object); \
  __asm volatile ("jsr a6@(-234:W)" \
  : "=r"(__AttemptRemNamedObject__re) \
  : "r"(__AttemptRemNamedObject__bn), "r"(__AttemptRemNamedObject_object) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __AttemptRemNamedObject__re; \
  }); \
  _AttemptRemNamedObject__re; \
})

#define FindNamedObject(name_space, name, previous_object) ({ \
  struct NamedObject * _FindNamedObject_name_space = (name_space); \
  CONST_STRPTR _FindNamedObject_name = (name); \
  struct NamedObject * _FindNamedObject_previous_object = (previous_object); \
  struct NamedObject * _FindNamedObject__re = \
  ({ \
  register struct UtilityBase * const __FindNamedObject__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct NamedObject * __FindNamedObject__re __asm("d0"); \
  register struct NamedObject * __FindNamedObject_name_space __asm("a0") = (_FindNamedObject_name_space); \
  register CONST_STRPTR __FindNamedObject_name __asm("a1") = (_FindNamedObject_name); \
  register struct NamedObject * __FindNamedObject_previous_object __asm("a2") = (_FindNamedObject_previous_object); \
  __asm volatile ("jsr a6@(-240:W)" \
  : "=r"(__FindNamedObject__re) \
  : "r"(__FindNamedObject__bn), "r"(__FindNamedObject_name_space), "r"(__FindNamedObject_name), "r"(__FindNamedObject_previous_object) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __FindNamedObject__re; \
  }); \
  _FindNamedObject__re; \
})

#define FreeNamedObject(obj) ({ \
  struct NamedObject * _FreeNamedObject_obj = (obj); \
  { \
  register struct UtilityBase * const __FreeNamedObject__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct NamedObject * __FreeNamedObject_obj __asm("a0") = (_FreeNamedObject_obj); \
  __asm volatile ("jsr a6@(-246:W)" \
  : \
  : "r"(__FreeNamedObject__bn), "r"(__FreeNamedObject_obj) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#define NamedObjectName(obj) ({ \
  struct NamedObject * _NamedObjectName_obj = (obj); \
  STRPTR _NamedObjectName__re = \
  ({ \
  register struct UtilityBase * const __NamedObjectName__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register STRPTR __NamedObjectName__re __asm("d0"); \
  register struct NamedObject * __NamedObjectName_obj __asm("a0") = (_NamedObjectName_obj); \
  __asm volatile ("jsr a6@(-252:W)" \
  : "=r"(__NamedObjectName__re) \
  : "r"(__NamedObjectName__bn), "r"(__NamedObjectName_obj) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __NamedObjectName__re; \
  }); \
  _NamedObjectName__re; \
})

#define ReleaseNamedObject(obj) ({ \
  struct NamedObject * _ReleaseNamedObject_obj = (obj); \
  { \
  register struct UtilityBase * const __ReleaseNamedObject__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct NamedObject * __ReleaseNamedObject_obj __asm("a0") = (_ReleaseNamedObject_obj); \
  __asm volatile ("jsr a6@(-258:W)" \
  : \
  : "r"(__ReleaseNamedObject__bn), "r"(__ReleaseNamedObject_obj) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#define RemNamedObject(obj, message) ({ \
  struct NamedObject * _RemNamedObject_obj = (obj); \
  struct Message * _RemNamedObject_message = (message); \
  { \
  register struct UtilityBase * const __RemNamedObject__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct NamedObject * __RemNamedObject_obj __asm("a0") = (_RemNamedObject_obj); \
  register struct Message * __RemNamedObject_message __asm("a1") = (_RemNamedObject_message); \
  __asm volatile ("jsr a6@(-264:W)" \
  : \
  : "r"(__RemNamedObject__bn), "r"(__RemNamedObject_obj), "r"(__RemNamedObject_message) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#define GetUniqueID() ({ \
  ULONG _GetUniqueID__re = \
  ({ \
  register struct UtilityBase * const __GetUniqueID__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register ULONG __GetUniqueID__re __asm("d0"); \
  __asm volatile ("jsr a6@(-270:W)" \
  : "=r"(__GetUniqueID__re) \
  : "r"(__GetUniqueID__bn) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __GetUniqueID__re; \
  }); \
  _GetUniqueID__re; \
})

#define Strlcpy(dst, src, size) ({ \
  STRPTR _Strlcpy_dst = (dst); \
  CONST_STRPTR _Strlcpy_src = (src); \
  LONG _Strlcpy_size = (size); \
  LONG _Strlcpy__re = \
  ({ \
  register struct UtilityBase * const __Strlcpy__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register LONG __Strlcpy__re __asm("d0"); \
  register STRPTR __Strlcpy_dst __asm("a0") = (_Strlcpy_dst); \
  register CONST_STRPTR __Strlcpy_src __asm("a1") = (_Strlcpy_src); \
  register LONG __Strlcpy_size __asm("d0") = (_Strlcpy_size); \
  __asm volatile ("jsr a6@(-300:W)" \
  : "=r"(__Strlcpy__re) \
  : "r"(__Strlcpy__bn), "r"(__Strlcpy_dst), "r"(__Strlcpy_src), "r"(__Strlcpy_size) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __Strlcpy__re; \
  }); \
  _Strlcpy__re; \
})

#define Strlcat(dst, src, size) ({ \
  STRPTR _Strlcat_dst = (dst); \
  CONST_STRPTR _Strlcat_src = (src); \
  LONG _Strlcat_size = (size); \
  LONG _Strlcat__re = \
  ({ \
  register struct UtilityBase * const __Strlcat__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register LONG __Strlcat__re __asm("d0"); \
  register STRPTR __Strlcat_dst __asm("a0") = (_Strlcat_dst); \
  register CONST_STRPTR __Strlcat_src __asm("a1") = (_Strlcat_src); \
  register LONG __Strlcat_size __asm("d0") = (_Strlcat_size); \
  __asm volatile ("jsr a6@(-306:W)" \
  : "=r"(__Strlcat__re) \
  : "r"(__Strlcat__bn), "r"(__Strlcat_dst), "r"(__Strlcat_src), "r"(__Strlcat_size) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __Strlcat__re; \
  }); \
  _Strlcat__re; \
})

#define VSNPrintf(buffer, bufferSize, fmt, args) ({ \
  STRPTR _VSNPrintf_buffer = (buffer); \
  LONG _VSNPrintf_bufferSize = (bufferSize); \
  CONST_STRPTR _VSNPrintf_fmt = (fmt); \
  APTR _VSNPrintf_args = (args); \
  LONG _VSNPrintf__re = \
  ({ \
  register struct UtilityBase * const __VSNPrintf__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register LONG __VSNPrintf__re __asm("d0"); \
  register STRPTR __VSNPrintf_buffer __asm("a0") = (_VSNPrintf_buffer); \
  register LONG __VSNPrintf_bufferSize __asm("d0") = (_VSNPrintf_bufferSize); \
  register CONST_STRPTR __VSNPrintf_fmt __asm("a1") = (_VSNPrintf_fmt); \
  register APTR __VSNPrintf_args __asm("a2") = (_VSNPrintf_args); \
  __asm volatile ("jsr a6@(-312:W)" \
  : "=r"(__VSNPrintf__re) \
  : "r"(__VSNPrintf__bn), "r"(__VSNPrintf_buffer), "r"(__VSNPrintf_bufferSize), "r"(__VSNPrintf_fmt), "r"(__VSNPrintf_args) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __VSNPrintf__re; \
  }); \
  _VSNPrintf__re; \
})

#ifndef NO_INLINE_STDARG
static __inline__ LONG ___SNPrintf(struct UtilityBase * UtilityBase, STRPTR buffer, LONG bufferSize, CONST_STRPTR fmt, ULONG arg1, ...)
{
  return VSNPrintf(buffer, bufferSize, fmt, (APTR) ((ULONG) &fmt + sizeof(CONST_STRPTR)));
}

#define SNPrintf(buffer, bufferSize, fmt...) ___SNPrintf(UTILITY_BASE_NAME, buffer, bufferSize, fmt)
#endif

#define VASPrintf(fmt, args) ({ \
  CONST_STRPTR _VASPrintf_fmt = (fmt); \
  APTR _VASPrintf_args = (args); \
  STRPTR _VASPrintf__re = \
  ({ \
  register struct UtilityBase * const __VASPrintf__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register STRPTR __VASPrintf__re __asm("d0"); \
  register CONST_STRPTR __VASPrintf_fmt __asm("a0") = (_VASPrintf_fmt); \
  register APTR __VASPrintf_args __asm("a1") = (_VASPrintf_args); \
  __asm volatile ("jsr a6@(-318:W)" \
  : "=r"(__VASPrintf__re) \
  : "r"(__VASPrintf__bn), "r"(__VASPrintf_fmt), "r"(__VASPrintf_args) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __VASPrintf__re; \
  }); \
  _VASPrintf__re; \
})

#ifndef NO_INLINE_STDARG
static __inline__ STRPTR ___ASPrintf(struct UtilityBase * UtilityBase, CONST_STRPTR fmt, ULONG arg1, ...)
{
  return VASPrintf(fmt, (APTR) ((ULONG) &fmt + sizeof(CONST_STRPTR)));
}

#define ASPrintf(fmt...) ___ASPrintf(UTILITY_BASE_NAME, fmt)
#endif

#define CreateSkipList(hook, max_levels) ({ \
  struct Hook * _CreateSkipList_hook = (hook); \
  LONG _CreateSkipList_max_levels = (max_levels); \
  struct SkipList * _CreateSkipList__re = \
  ({ \
  register struct UtilityBase * const __CreateSkipList__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct SkipList * __CreateSkipList__re __asm("d0"); \
  register struct Hook * __CreateSkipList_hook __asm("a0") = (_CreateSkipList_hook); \
  register LONG __CreateSkipList_max_levels __asm("d0") = (_CreateSkipList_max_levels); \
  __asm volatile ("jsr a6@(-324:W)" \
  : "=r"(__CreateSkipList__re) \
  : "r"(__CreateSkipList__bn), "r"(__CreateSkipList_hook), "r"(__CreateSkipList_max_levels) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __CreateSkipList__re; \
  }); \
  _CreateSkipList__re; \
})

#define DeleteSkipList(skipList) ({ \
  struct SkipList * _DeleteSkipList_skipList = (skipList); \
  { \
  register struct UtilityBase * const __DeleteSkipList__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct SkipList * __DeleteSkipList_skipList __asm("a0") = (_DeleteSkipList_skipList); \
  __asm volatile ("jsr a6@(-330:W)" \
  : \
  : "r"(__DeleteSkipList__bn), "r"(__DeleteSkipList_skipList) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#define InsertSkipNode(skipList, key, dataSize) ({ \
  struct SkipList * _InsertSkipNode_skipList = (skipList); \
  APTR _InsertSkipNode_key = (key); \
  ULONG _InsertSkipNode_dataSize = (dataSize); \
  struct SkipNode * _InsertSkipNode__re = \
  ({ \
  register struct UtilityBase * const __InsertSkipNode__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct SkipNode * __InsertSkipNode__re __asm("d0"); \
  register struct SkipList * __InsertSkipNode_skipList __asm("a0") = (_InsertSkipNode_skipList); \
  register APTR __InsertSkipNode_key __asm("a1") = (_InsertSkipNode_key); \
  register ULONG __InsertSkipNode_dataSize __asm("d0") = (_InsertSkipNode_dataSize); \
  __asm volatile ("jsr a6@(-336:W)" \
  : "=r"(__InsertSkipNode__re) \
  : "r"(__InsertSkipNode__bn), "r"(__InsertSkipNode_skipList), "r"(__InsertSkipNode_key), "r"(__InsertSkipNode_dataSize) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __InsertSkipNode__re; \
  }); \
  _InsertSkipNode__re; \
})

#define FindSkipNode(skipList, key) ({ \
  const struct SkipList * _FindSkipNode_skipList = (skipList); \
  APTR _FindSkipNode_key = (key); \
  struct SkipNode * _FindSkipNode__re = \
  ({ \
  register struct UtilityBase * const __FindSkipNode__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct SkipNode * __FindSkipNode__re __asm("d0"); \
  register const struct SkipList * __FindSkipNode_skipList __asm("a0") = (_FindSkipNode_skipList); \
  register APTR __FindSkipNode_key __asm("a1") = (_FindSkipNode_key); \
  __asm volatile ("jsr a6@(-342:W)" \
  : "=r"(__FindSkipNode__re) \
  : "r"(__FindSkipNode__bn), "r"(__FindSkipNode_skipList), "r"(__FindSkipNode_key) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __FindSkipNode__re; \
  }); \
  _FindSkipNode__re; \
})

#define RemoveSkipNode(skipList, key) ({ \
  struct SkipList * _RemoveSkipNode_skipList = (skipList); \
  APTR _RemoveSkipNode_key = (key); \
  BOOL _RemoveSkipNode__re = \
  ({ \
  register struct UtilityBase * const __RemoveSkipNode__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register BOOL __RemoveSkipNode__re __asm("d0"); \
  register struct SkipList * __RemoveSkipNode_skipList __asm("a0") = (_RemoveSkipNode_skipList); \
  register APTR __RemoveSkipNode_key __asm("a1") = (_RemoveSkipNode_key); \
  __asm volatile ("jsr a6@(-348:W)" \
  : "=r"(__RemoveSkipNode__re) \
  : "r"(__RemoveSkipNode__bn), "r"(__RemoveSkipNode_skipList), "r"(__RemoveSkipNode_key) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __RemoveSkipNode__re; \
  }); \
  _RemoveSkipNode__re; \
})

#define GetFirstSkipNode(skipList) ({ \
  const struct SkipList * _GetFirstSkipNode_skipList = (skipList); \
  struct SkipNode * _GetFirstSkipNode__re = \
  ({ \
  register struct UtilityBase * const __GetFirstSkipNode__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct SkipNode * __GetFirstSkipNode__re __asm("d0"); \
  register const struct SkipList * __GetFirstSkipNode_skipList __asm("a0") = (_GetFirstSkipNode_skipList); \
  __asm volatile ("jsr a6@(-354:W)" \
  : "=r"(__GetFirstSkipNode__re) \
  : "r"(__GetFirstSkipNode__bn), "r"(__GetFirstSkipNode_skipList) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __GetFirstSkipNode__re; \
  }); \
  _GetFirstSkipNode__re; \
})

#define GetNextSkipNode(skipList, node) ({ \
  const struct SkipList * _GetNextSkipNode_skipList = (skipList); \
  const struct SkipNode * _GetNextSkipNode_node = (node); \
  struct SkipNode * _GetNextSkipNode__re = \
  ({ \
  register struct UtilityBase * const __GetNextSkipNode__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct SkipNode * __GetNextSkipNode__re __asm("d0"); \
  register const struct SkipList * __GetNextSkipNode_skipList __asm("a0") = (_GetNextSkipNode_skipList); \
  register const struct SkipNode * __GetNextSkipNode_node __asm("a1") = (_GetNextSkipNode_node); \
  __asm volatile ("jsr a6@(-360:W)" \
  : "=r"(__GetNextSkipNode__re) \
  : "r"(__GetNextSkipNode__bn), "r"(__GetNextSkipNode_skipList), "r"(__GetNextSkipNode_node) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __GetNextSkipNode__re; \
  }); \
  _GetNextSkipNode__re; \
})

#define CreateSplayTree(compareHook) ({ \
  struct Hook * _CreateSplayTree_compareHook = (compareHook); \
  struct SplayTree * _CreateSplayTree__re = \
  ({ \
  register struct UtilityBase * const __CreateSplayTree__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct SplayTree * __CreateSplayTree__re __asm("d0"); \
  register struct Hook * __CreateSplayTree_compareHook __asm("a0") = (_CreateSplayTree_compareHook); \
  __asm volatile ("jsr a6@(-366:W)" \
  : "=r"(__CreateSplayTree__re) \
  : "r"(__CreateSplayTree__bn), "r"(__CreateSplayTree_compareHook) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __CreateSplayTree__re; \
  }); \
  _CreateSplayTree__re; \
})

#define DeleteSplayTree(splayTree) ({ \
  struct SplayTree * _DeleteSplayTree_splayTree = (splayTree); \
  { \
  register struct UtilityBase * const __DeleteSplayTree__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct SplayTree * __DeleteSplayTree_splayTree __asm("a0") = (_DeleteSplayTree_splayTree); \
  __asm volatile ("jsr a6@(-372:W)" \
  : \
  : "r"(__DeleteSplayTree__bn), "r"(__DeleteSplayTree_splayTree) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#define InsertSplayNode(splayTree, key, date_size) ({ \
  struct SplayTree * _InsertSplayNode_splayTree = (splayTree); \
  APTR _InsertSplayNode_key = (key); \
  ULONG _InsertSplayNode_date_size = (date_size); \
  struct SplayNode * _InsertSplayNode__re = \
  ({ \
  register struct UtilityBase * const __InsertSplayNode__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct SplayNode * __InsertSplayNode__re __asm("d0"); \
  register struct SplayTree * __InsertSplayNode_splayTree __asm("a0") = (_InsertSplayNode_splayTree); \
  register APTR __InsertSplayNode_key __asm("a1") = (_InsertSplayNode_key); \
  register ULONG __InsertSplayNode_date_size __asm("d0") = (_InsertSplayNode_date_size); \
  __asm volatile ("jsr a6@(-378:W)" \
  : "=r"(__InsertSplayNode__re) \
  : "r"(__InsertSplayNode__bn), "r"(__InsertSplayNode_splayTree), "r"(__InsertSplayNode_key), "r"(__InsertSplayNode_date_size) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __InsertSplayNode__re; \
  }); \
  _InsertSplayNode__re; \
})

#define FindSplayNode(splayTree, key) ({ \
  const struct SplayTree * _FindSplayNode_splayTree = (splayTree); \
  APTR _FindSplayNode_key = (key); \
  struct SplayNode * _FindSplayNode__re = \
  ({ \
  register struct UtilityBase * const __FindSplayNode__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct SplayNode * __FindSplayNode__re __asm("d0"); \
  register const struct SplayTree * __FindSplayNode_splayTree __asm("a0") = (_FindSplayNode_splayTree); \
  register APTR __FindSplayNode_key __asm("a1") = (_FindSplayNode_key); \
  __asm volatile ("jsr a6@(-384:W)" \
  : "=r"(__FindSplayNode__re) \
  : "r"(__FindSplayNode__bn), "r"(__FindSplayNode_splayTree), "r"(__FindSplayNode_key) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __FindSplayNode__re; \
  }); \
  _FindSplayNode__re; \
})

#define RemoveSplayNode(splayTree, key) ({ \
  struct SplayTree * _RemoveSplayNode_splayTree = (splayTree); \
  APTR _RemoveSplayNode_key = (key); \
  struct SplayNode * _RemoveSplayNode__re = \
  ({ \
  register struct UtilityBase * const __RemoveSplayNode__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct SplayNode * __RemoveSplayNode__re __asm("d0"); \
  register struct SplayTree * __RemoveSplayNode_splayTree __asm("a0") = (_RemoveSplayNode_splayTree); \
  register APTR __RemoveSplayNode_key __asm("a1") = (_RemoveSplayNode_key); \
  __asm volatile ("jsr a6@(-390:W)" \
  : "=r"(__RemoveSplayNode__re) \
  : "r"(__RemoveSplayNode__bn), "r"(__RemoveSplayNode_splayTree), "r"(__RemoveSplayNode_key) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __RemoveSplayNode__re; \
  }); \
  _RemoveSplayNode__re; \
})

#define SetMem(destination, fillChar, length) ({ \
  APTR _SetMem_destination = (destination); \
  UBYTE _SetMem_fillChar = (fillChar); \
  LONG _SetMem_length = (length); \
  APTR _SetMem__re = \
  ({ \
  register struct UtilityBase * const __SetMem__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register APTR __SetMem__re __asm("d0"); \
  register APTR __SetMem_destination __asm("a0") = (_SetMem_destination); \
  register UBYTE __SetMem_fillChar __asm("d0") = (_SetMem_fillChar); \
  register LONG __SetMem_length __asm("d1") = (_SetMem_length); \
  __asm volatile ("jsr a6@(-396:W)" \
  : "=r"(__SetMem__re) \
  : "r"(__SetMem__bn), "r"(__SetMem_destination), "r"(__SetMem_fillChar), "r"(__SetMem_length) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __SetMem__re; \
  }); \
  _SetMem__re; \
})

#define FindNameNC(list, name) ({ \
  struct List * _FindNameNC_list = (list); \
  CONST_STRPTR _FindNameNC_name = (name); \
  struct Node * _FindNameNC__re = \
  ({ \
  register struct UtilityBase * const __FindNameNC__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct Node * __FindNameNC__re __asm("d0"); \
  register struct List * __FindNameNC_list __asm("a0") = (_FindNameNC_list); \
  register CONST_STRPTR __FindNameNC_name __asm("a1") = (_FindNameNC_name); \
  __asm volatile ("jsr a6@(-402:W)" \
  : "=r"(__FindNameNC__re) \
  : "r"(__FindNameNC__bn), "r"(__FindNameNC_list), "r"(__FindNameNC_name) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __FindNameNC__re; \
  }); \
  _FindNameNC__re; \
})

#define Random(state) ({ \
  struct RandomState * _Random_state = (state); \
  ULONG _Random__re = \
  ({ \
  register struct UtilityBase * const __Random__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register ULONG __Random__re __asm("d0"); \
  register struct RandomState * __Random_state __asm("a0") = (_Random_state); \
  __asm volatile ("jsr a6@(-408:W)" \
  : "=r"(__Random__re) \
  : "r"(__Random__bn), "r"(__Random_state) \
  : "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  __Random__re; \
  }); \
  _Random__re; \
})

#define MessageDigest_SHA_Init(shas) ({ \
  struct MessageDigest_SHA * _MessageDigest_SHA_Init_shas = (shas); \
  { \
  register struct UtilityBase * const __MessageDigest_SHA_Init__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct MessageDigest_SHA * __MessageDigest_SHA_Init_shas __asm("a0") = (_MessageDigest_SHA_Init_shas); \
  __asm volatile ("jsr a6@(-414:W)" \
  : \
  : "r"(__MessageDigest_SHA_Init__bn), "r"(__MessageDigest_SHA_Init_shas) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#define MessageDigest_SHA_Update(shas, data, num_bytes) ({ \
  struct MessageDigest_SHA * _MessageDigest_SHA_Update_shas = (shas); \
  APTR _MessageDigest_SHA_Update_data = (data); \
  LONG _MessageDigest_SHA_Update_num_bytes = (num_bytes); \
  { \
  register struct UtilityBase * const __MessageDigest_SHA_Update__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct MessageDigest_SHA * __MessageDigest_SHA_Update_shas __asm("a0") = (_MessageDigest_SHA_Update_shas); \
  register APTR __MessageDigest_SHA_Update_data __asm("a1") = (_MessageDigest_SHA_Update_data); \
  register LONG __MessageDigest_SHA_Update_num_bytes __asm("d0") = (_MessageDigest_SHA_Update_num_bytes); \
  __asm volatile ("jsr a6@(-420:W)" \
  : \
  : "r"(__MessageDigest_SHA_Update__bn), "r"(__MessageDigest_SHA_Update_shas), "r"(__MessageDigest_SHA_Update_data), "r"(__MessageDigest_SHA_Update_num_bytes) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#define MessageDigest_SHA_Final(shas) ({ \
  struct MessageDigest_SHA * _MessageDigest_SHA_Final_shas = (shas); \
  { \
  register struct UtilityBase * const __MessageDigest_SHA_Final__bn __asm("a6") = (struct UtilityBase *) (UTILITY_BASE_NAME);\
  register struct MessageDigest_SHA * __MessageDigest_SHA_Final_shas __asm("a0") = (_MessageDigest_SHA_Final_shas); \
  __asm volatile ("jsr a6@(-426:W)" \
  : \
  : "r"(__MessageDigest_SHA_Final__bn), "r"(__MessageDigest_SHA_Final_shas) \
  : "d0", "d1", "a0", "a1", "fp0", "fp1", "cc", "memory"); \
  } \
})

#endif /*  _INLINE_UTILITY_H  */
