#ifndef INLINE4_EXEC_H
#define INLINE4_EXEC_H

/*
** This file was machine generated by idltool.py 54.8.
** Do not edit.
**
** Copyright (C) 2003-2022 Trevor Dickinson
**
** It provides compatibility to AmigaOS 3.x style library
** calls by substituting functions.
*/

#include <exec/types.h>
#include <exec/exec.h>
#include <exec/interfaces.h>

#include <utility/utility.h>
#include <interfaces/exec.h>

/* Inline macros for Interface "main" */
#define AddHead(list, node) IExec->AddHead((list), (node))
#define AddMemHandler(memHandler) IExec->AddMemHandler((memHandler))
#define AddMemList(size, attributes, pri, base, name) IExec->AddMemList((size), (attributes), (pri), (base), (name))
#define AddTail(list, node) IExec->AddTail((list), (node))
#define AllocAbs(byteSize, location) IExec->AllocAbs((byteSize), (location))
#define Allocate(memHeader, byteSize) IExec->Allocate((memHeader), (byteSize))
#define AllocEntry(memList) IExec->AllocEntry((memList))
#define AllocMem(byteSize, attributes) IExec->AllocMem((byteSize), (attributes))
#define AllocPooled(poolHeader, memSize) IExec->AllocPooled((poolHeader), (memSize))
#define AllocVec(byteSize, attributes) IExec->AllocVec((byteSize), (attributes))
#define AllocVecPooled(poolHeader, size) IExec->AllocVecPooled((poolHeader), (size))
#define AvailMem(attributes) IExec->AvailMem((attributes))
#define CopyMem(source, dest, size) IExec->CopyMem((source), (dest), (size))
#define CopyMemQuick(source, dest, size) IExec->CopyMemQuick((source), (dest), (size))
#define CreatePool(memFlags, puddleSize, threshSize) IExec->CreatePool((memFlags), (puddleSize), (threshSize))
#define Deallocate(memHeader, memoryBlock, byteSize) IExec->Deallocate((memHeader), (memoryBlock), (byteSize))
#define DeletePool(poolHeader) IExec->DeletePool((poolHeader))
#define Enqueue(list, node) IExec->Enqueue((list), (node))
#define FindName(start, name) IExec->FindName((start), (name))
#define FindIName(start, name) IExec->FindIName((start), (name))
#define Forbid() IExec->Forbid()
#define FreeEntry(memList) IExec->FreeEntry((memList))
#define FreeMem(memoryBlock, byteSize) IExec->FreeMem((memoryBlock), (byteSize))
#define FreePooled(poolHeader, memory, memSize) IExec->FreePooled((poolHeader), (memory), (memSize))
#define FreeVec(memoryBlock) IExec->FreeVec((memoryBlock))
#define FreeVecPooled(poolHeader, memory) IExec->FreeVecPooled((poolHeader), (memory))
#define InitData(initTab, memory, size) IExec->InitData((initTab), (memory), (size))
#define InitStruct(initTable, memory, size) IExec->InitStruct((initTable), (memory), (size))
#define Insert(list, node, listNode) IExec->Insert((list), (node), (listNode))
#define MakeInterface(library, taglist) IExec->MakeInterface((library), (taglist))
#define MakeInterfaceTags(...) IExec->MakeInterfaceTags(__VA_ARGS__)
#define Permit() IExec->Permit()
#define RawDoFmt(formatString, dataStream, PutChProc, PutChData) IExec->RawDoFmt((formatString), (dataStream), (PutChProc), (PutChData))
#define RemHead(list) IExec->RemHead((list))
#define RemMemHandler(memHandler) IExec->RemMemHandler((memHandler))
#define Remove(node) IExec->Remove((node))
#define RemTail(list) IExec->RemTail((list))
#define TypeOfMem(address) IExec->TypeOfMem((address))
#define InitResident(resident, segList) IExec->InitResident((resident), (segList))
#define InitCode(startClass, version) IExec->InitCode((startClass), (version))
#define SumKickData() IExec->SumKickData()
#define AddTask(task, initialPC, finalPC, tagList) IExec->AddTask((task), (initialPC), (finalPC), (tagList))
#define AddTaskTags(task, initialPC, ...) IExec->AddTaskTags((task), (initialPC), __VA_ARGS__)
#define Disable() IExec->Disable()
#define Enable() IExec->Enable()
#define Reschedule() IExec->Reschedule()
#define FindTask(name) IExec->FindTask((name))
#define RemTask(task) IExec->RemTask((task))
#define SetTaskPri(task, priority) IExec->SetTaskPri((task), (priority))
#define StackSwap(newstack) IExec->StackSwap((newstack))
#define AllocSignal(signalNum) IExec->AllocSignal((signalNum))
#define FreeSignal(signalNum) IExec->FreeSignal((signalNum))
#define SetExcept(newSignals, signalMask) IExec->SetExcept((newSignals), (signalMask))
#define SetSignal(newSignals, signalMask) IExec->SetSignal((newSignals), (signalMask))
#define Signal(task, signals) IExec->Signal((task), (signals))
#define Wait(signalSet) IExec->Wait((signalSet))
#define AddPort(port) IExec->AddPort((port))
#define CreatePort(name, pri) IExec->CreatePort((name), (pri))
#define CreateMsgPort() IExec->CreateMsgPort()
#define DeletePort(port) IExec->DeletePort((port))
#define DeleteMsgPort(port) IExec->DeleteMsgPort((port))
#define FindPort(name) IExec->FindPort((name))
#define GetMsg(port) IExec->GetMsg((port))
#define PutMsg(port, message) IExec->PutMsg((port), (message))
#define RemPort(port) IExec->RemPort((port))
#define ReplyMsg(message) IExec->ReplyMsg((message))
#define WaitPort(port) IExec->WaitPort((port))
#define Cause(interrupt) IExec->Cause((interrupt))
#define AddSemaphore(semaphore) IExec->AddSemaphore((semaphore))
#define AttemptSemaphore(semaphore) IExec->AttemptSemaphore((semaphore))
#define AttemptSemaphoreShared(semaphore) IExec->AttemptSemaphoreShared((semaphore))
#define FindSemaphore(name) IExec->FindSemaphore((name))
#define InitSemaphore(semaphore) IExec->InitSemaphore((semaphore))
#define ObtainSemaphore(semaphore) IExec->ObtainSemaphore((semaphore))
#define ObtainSemaphoreList(list) IExec->ObtainSemaphoreList((list))
#define ObtainSemaphoreShared(semaphore) IExec->ObtainSemaphoreShared((semaphore))
#define Procure(semaphore, bidMessage) IExec->Procure((semaphore), (bidMessage))
#define ReleaseSemaphore(semaphore) IExec->ReleaseSemaphore((semaphore))
#define ReleaseSemaphoreList(list) IExec->ReleaseSemaphoreList((list))
#define RemSemaphore(semaphore) IExec->RemSemaphore((semaphore))
#define Vacate(semaphore, bidMessage) IExec->Vacate((semaphore), (bidMessage))
#define CreateTask(name, pri, initPC, stackSize, tagList) IExec->CreateTask((name), (pri), (initPC), (stackSize), (tagList))
#define CreateTaskTags(name, pri, initPC, ...) IExec->CreateTaskTags((name), (pri), (initPC), __VA_ARGS__)
#define DeleteTask(task) IExec->DeleteTask((task))
#define SumLibrary(library) IExec->SumLibrary((library))
#define CreateLibrary(taglist) IExec->CreateLibrary((taglist))
#define CreateLibraryTags(...) IExec->CreateLibraryTags(__VA_ARGS__)
#define OpenLibrary(name, version) IExec->OpenLibrary((name), (version))
#define CloseLibrary(library) IExec->CloseLibrary((library))
#define AddLibrary(library) IExec->AddLibrary((library))
#define RemLibrary(library) IExec->RemLibrary((library))
#define AddDevice(device) IExec->AddDevice((device))
#define RemDevice(device) IExec->RemDevice((device))
#define GetInterface(library, name, version, taglist) IExec->GetInterface((library), (name), (version), (taglist))
#define GetInterfaceTags(library, name, ...) IExec->GetInterfaceTags((library), (name), __VA_ARGS__)
#define DropInterface(interface) IExec->DropInterface((interface))
#define AddInterface(library, interface) IExec->AddInterface((library), (interface))
#define RemInterface(interface) IExec->RemInterface((interface))
#define SumInterface(interface) IExec->SumInterface((interface))
#define FindResident(name) IExec->FindResident((name))
#define SetMethod(interface, funcOffset, newFunc) IExec->SetMethod((interface), (funcOffset), (newFunc))
#define DeleteInterface(interface) IExec->DeleteInterface((interface))
#define DeleteLibrary(library) IExec->DeleteLibrary((library))
#define SetFunction(library, funcOffset, newFunc) IExec->SetFunction((library), (funcOffset), (newFunc))
#define CacheClearE(address, length, caches) IExec->CacheClearE((address), (length), (caches))
#define CacheClearU() IExec->CacheClearU()
#define MakeFunctions(target, functionArray, funcDispBase) IExec->MakeFunctions((target), (functionArray), (funcDispBase))
#define OpenDevice(devName, unitNumber, ioRequest, flags) IExec->OpenDevice((devName), (unitNumber), (ioRequest), (flags))
#define CloseDevice(ioRequest) IExec->CloseDevice((ioRequest))
#define CreateIORequest(ioReplyPort, size) IExec->CreateIORequest((ioReplyPort), (size))
#define DeleteIORequest(ioRequest) IExec->DeleteIORequest((ioRequest))
#define AbortIO(ioRequest) IExec->AbortIO((ioRequest))
#define CheckIO(ioRequest) IExec->CheckIO((ioRequest))
#define DoIO(ioRequest) IExec->DoIO((ioRequest))
#define SendIO(ioRequest) IExec->SendIO((ioRequest))
#define BeginIO(ioRequest) IExec->BeginIO((ioRequest))
#define WaitIO(ioRequest) IExec->WaitIO((ioRequest))
#define AddResource(resource) IExec->AddResource((resource))
#define RemResource(resource) IExec->RemResource((resource))
#define OpenResource(resName) IExec->OpenResource((resName))
#define AddIntServer(intNum, interrupt) IExec->AddIntServer((intNum), (interrupt))
#define RemIntServer(intNum, interrupt) IExec->RemIntServer((intNum), (interrupt))
#define SetIntVector(intNum, interrupt) IExec->SetIntVector((intNum), (interrupt))
#define ObtainQuickVector(interruptCode) IExec->ObtainQuickVector((interruptCode))
#define Alert(alertNum) IExec->Alert((alertNum))
#define SuperState() IExec->SuperState()
#define UserState(sysStack) IExec->UserState((sysStack))
#define Supervisor(userFunc) IExec->Supervisor((userFunc))
#define SetTaskTrap(trapNum, trapCode, trapData) IExec->SetTaskTrap((trapNum), (trapCode), (trapData))
#define AllocTrap(trapNum) IExec->AllocTrap((trapNum))
#define FreeTrap(trapNum) IExec->FreeTrap((trapNum))
#define GetCC() IExec->GetCC()
#define SetSR(newSR, mask) IExec->SetSR((newSR), (mask))
#define AVL_AddNode(root, node, func) IExec->AVL_AddNode((root), (node), (func))
#define AVL_FindFirstNode(root) IExec->AVL_FindFirstNode((root))
#define AVL_FindLastNode(root) IExec->AVL_FindLastNode((root))
#define AVL_FindNextNodeByAddress(root) IExec->AVL_FindNextNodeByAddress((root))
#define AVL_FindNextNodeByKey(root, key, func) IExec->AVL_FindNextNodeByKey((root), (key), (func))
#define AVL_FindNode(root, key, func) IExec->AVL_FindNode((root), (key), (func))
#define AVL_FindPrevNodeByAddress(root) IExec->AVL_FindPrevNodeByAddress((root))
#define AVL_FindPrevNodeByKey(root, key, func) IExec->AVL_FindPrevNodeByKey((root), (key), (func))
#define AVL_RemNodeByAddress(root, node) IExec->AVL_RemNodeByAddress((root), (node))
#define AVL_RemNodeByKey(root, key, func) IExec->AVL_RemNodeByKey((root), (key), (func))
#define CacheControl(cacheBits, cacheMask) IExec->CacheControl((cacheBits), (cacheMask))
#define LockMem(baseAddress, size) IExec->LockMem((baseAddress), (size))
#define UnlockMem(baseAddress, size) IExec->UnlockMem((baseAddress), (size))
#define CachePreDMA(vaddr, length, flags) IExec->CachePreDMA((vaddr), (length), (flags))
#define CachePostDMA(vaddr, length, flags) IExec->CachePostDMA((vaddr), (length), (flags))
#define StartDMA(startAddr, blockSize, flags) IExec->StartDMA((startAddr), (blockSize), (flags))
#define EndDMA(startAddr, blockSize, flags) IExec->EndDMA((startAddr), (blockSize), (flags))
#define GetDMAList(startAddr, blockSize, flags, dmaList) IExec->GetDMAList((startAddr), (blockSize), (flags), (dmaList))
#define AddTrackable(usingTask, object, destFunc) IExec->AddTrackable((usingTask), (object), (destFunc))
#define FindTrackable(usingTask, object) IExec->FindTrackable((usingTask), (object))
#define RemTrackable(usingTask, trackable) IExec->RemTrackable((usingTask), (trackable))
#define DeleteTrackable(trackable) IExec->DeleteTrackable((trackable))
#define AllocSysObject(type, tags) IExec->AllocSysObject((type), (tags))
#define AllocSysObjectTags(...) IExec->AllocSysObjectTags(__VA_ARGS__)
#define FreeSysObject(type, object) IExec->FreeSysObject((type), (object))
#define SuspendTask(whichTask, flags) IExec->SuspendTask((whichTask), (flags))
#define RestartTask(whichTask, flags) IExec->RestartTask((whichTask), (flags))
#define MoveList(destinationList, sourceList) IExec->MoveList((destinationList), (sourceList))
#define NewList(list) IExec->NewList((list))
#define NewMinList(list) IExec->NewMinList((list))
#define ColdReboot() IExec->ColdReboot()
#define MakeLibrary(vectors, structure, init, dataSize, segList) IExec->MakeLibrary((vectors), (structure), (init), (dataSize), (segList))
#define Emulate(InitPC, tagList) IExec->Emulate((InitPC), (tagList))
#define EmulateTags(...) IExec->EmulateTags(__VA_ARGS__)
#define DebugPrintF(...) IExec->DebugPrintF(__VA_ARGS__)
#define IsNative(code) IExec->IsNative((code))
#define GetCPUInfo(TagList) IExec->GetCPUInfo((TagList))
#define GetCPUInfoTags(...) IExec->GetCPUInfoTags(__VA_ARGS__)
#define OwnerOfMem(Address) IExec->OwnerOfMem((Address))
#define AddResetCallback(resetCallback) IExec->AddResetCallback((resetCallback))
#define RemResetCallback(resetCallback) IExec->RemResetCallback((resetCallback))
#define ItemPoolAlloc(itemPool) IExec->ItemPoolAlloc((itemPool))
#define ItemPoolFree(itemPool, item) IExec->ItemPoolFree((itemPool), (item))
#define ItemPoolGC(itemPool) IExec->ItemPoolGC((itemPool))
#define ItemPoolControl(itemPool, tagList) IExec->ItemPoolControl((itemPool), (tagList))
#define ItemPoolControlTags(...) IExec->ItemPoolControlTags(__VA_ARGS__)
#define ItemPoolFlush(itemPool) IExec->ItemPoolFlush((itemPool))
#define GetHead(list) IExec->GetHead((list))
#define GetTail(list) IExec->GetTail((list))
#define GetSucc(node) IExec->GetSucc((node))
#define GetPred(node) IExec->GetPred((node))
#define IceColdReboot() IExec->IceColdReboot()
#define RMapAlloc(Map, size, flags) IExec->RMapAlloc((Map), (size), (flags))
#define RMapFree(Map, addr, size) IExec->RMapFree((Map), (addr), (size))
#define AllocVecTagList(size, tags) IExec->AllocVecTagList((size), (tags))
#define AllocVecTags(...) IExec->AllocVecTags(__VA_ARGS__)
#define RMapExtAlloc(Map, size, alignment, flags) IExec->RMapExtAlloc((Map), (size), (alignment), (flags))
#define RMapExtFree(Map, addr, size) IExec->RMapExtFree((Map), (addr), (size))
#define AllocNamedMemory(byteSize, space, name, tagList) IExec->AllocNamedMemory((byteSize), (space), (name), (tagList))
#define AllocNamedMemoryTags(byteSize, space, ...) IExec->AllocNamedMemoryTags((byteSize), (space), __VA_ARGS__)
#define FreeNamedMemory(space, name) IExec->FreeNamedMemory((space), (name))
#define FindNamedMemory(space, name) IExec->FindNamedMemory((space), (name))
#define UpdateNamedMemory(space, name) IExec->UpdateNamedMemory((space), (name))
#define LockNamedMemory(space, name) IExec->LockNamedMemory((space), (name))
#define AttemptNamedMemory(space, name) IExec->AttemptNamedMemory((space), (name))
#define UnlockNamedMemory(space, name) IExec->UnlockNamedMemory((space), (name))
#define ScanNamedMemory(scHook, flags, user) IExec->ScanNamedMemory((scHook), (flags), (user))
#define AllocTaskMemEntry(memList) IExec->AllocTaskMemEntry((memList))
#define MutexObtain(Mutex) IExec->MutexObtain((Mutex))
#define MutexAttempt(Mutex) IExec->MutexAttempt((Mutex))
#define MutexRelease(Mutex) IExec->MutexRelease((Mutex))
#define MutexAttemptWithSignal(Mutex, SigSet) IExec->MutexAttemptWithSignal((Mutex), (SigSet))
#define NewStackRun(initPC, TagList) IExec->NewStackRun((initPC), (TagList))
#define NewStackRunTags(...) IExec->NewStackRunTags(__VA_ARGS__)
#define AttemptSemaphoreWithSignal(semaphore, sigmask) IExec->AttemptSemaphoreWithSignal((semaphore), (sigmask))
#define AttemptSemaphoreSharedWithSignal(semaphore, sigmask) IExec->AttemptSemaphoreSharedWithSignal((semaphore), (sigmask))
#define GetTaskAttrs(task, taglist) IExec->GetTaskAttrs((task), (taglist))
#define GetTaskAttrsTags(...) IExec->GetTaskAttrsTags(__VA_ARGS__)
#define OBSOLETEMutexObtainDisable(mutex) IExec->OBSOLETEMutexObtainDisable((mutex))
#define OBSOLETEMutexReleaseEnable(mutex) IExec->OBSOLETEMutexReleaseEnable((mutex))
#define FindResidentTagList(tagList) IExec->FindResidentTagList((tagList))
#define FindResidentTags(...) IExec->FindResidentTags(__VA_ARGS__)
#define GetSystemInfo(TagList) IExec->GetSystemInfo((TagList))
#define GetSystemInfoTags(...) IExec->GetSystemInfoTags(__VA_ARGS__)
#define SetTaskAffinity(task, TagList) IExec->SetTaskAffinity((task), (TagList))
#define SetTaskAffinityTags(...) IExec->SetTaskAffinityTags(__VA_ARGS__)

/* Inline macros for Interface "MMU" */
#define MapMemory(virtualAddress, phyiscal, length, attrib) IMMU->MapMemory((virtualAddress), (phyiscal), (length), (attrib))
#define UnmapMemory(virtualAddress, length) IMMU->UnmapMemory((virtualAddress), (length))
#define RemapMemory(virtualAddress, phyiscal, length, attrib) IMMU->RemapMemory((virtualAddress), (phyiscal), (length), (attrib))
#define SetMemoryAttrs(virtualAddress, length, attrib) IMMU->SetMemoryAttrs((virtualAddress), (length), (attrib))
#define GetMemoryAttrs(virtualAddress, flags) IMMU->GetMemoryAttrs((virtualAddress), (flags))
#define GetPhysicalAddress(virtualAddress) IMMU->GetPhysicalAddress((virtualAddress))

/* Inline macros for Interface "debug" */
#define AddDebugHook(task, debugHook) IDebug->AddDebugHook((task), (debugHook))
#define DisassembleNative(targetAddress, opcodeName, operands) IDebug->DisassembleNative((targetAddress), (opcodeName), (operands))
#define Disassemble68k(targetAddress, opcodeName, operands) IDebug->Disassemble68k((targetAddress), (opcodeName), (operands))
#define GetDebugLevel() IDebug->GetDebugLevel()
#define ReadTaskContext(targetTask, contextStore, flags) IDebug->ReadTaskContext((targetTask), (contextStore), (flags))
#define WriteTaskContext(targetTask, contextStore, flags) IDebug->WriteTaskContext((targetTask), (contextStore), (flags))
#define StackTrace(task, hook) IDebug->StackTrace((task), (hook))
#define ObtainDebugSymbol(address, tagList) IDebug->ObtainDebugSymbol((address), (tagList))
#define ObtainDebugSymbolTags(...) IDebug->ObtainDebugSymbolTags(__VA_ARGS__)
#define ReleaseDebugSymbol(sym) IDebug->ReleaseDebugSymbol((sym))
#define IsIn68kEmulator(task) IDebug->IsIn68kEmulator((task))
#define StartDebugOutputNotify(tagList) IDebug->StartDebugOutputNotify((tagList))
#define StartDebugOutputNotifyTags(...) IDebug->StartDebugOutputNotifyTags(__VA_ARGS__)
#define EndDebugOutputNotify(notify) IDebug->EndDebugOutputNotify((notify))

#endif /* INLINE4_EXEC_H */
