#ifndef EXEC_INTERFACE_DEF_H
#define EXEC_INTERFACE_DEF_H

/*
** This file was machine generated by idltool.py 54.8.
** Do not edit.
**
** Copyright (C) 2003-2022 Trevor Dickinson
**
*/

#include <exec/types.h>
#include <exec/exec.h>
#include <exec/interfaces.h>

#include <utility/utility.h>

#ifdef __cplusplus
#ifdef __USE_AMIGAOS_NAMESPACE__
namespace AmigaOS {
#endif
extern "C" {
#endif

struct ExecIFace
{
	struct InterfaceData Data;

	ULONG APICALL (*Obtain)(struct ExecIFace *Self);
	ULONG APICALL (*Release)(struct ExecIFace *Self);
	APTR Expunge_UNIMPLEMENTED;
	APTR Clone_UNIMPLEMENTED;
	void APICALL (*AddHead)(struct ExecIFace *Self, struct List * list, struct Node * node);
	VOID APICALL (*AddMemHandler)(struct ExecIFace *Self, struct Interrupt * memHandler);
	DEPRECATED void APICALL (*AddMemList)(struct ExecIFace *Self, ULONG size, ULONG attributes, LONG pri, APTR base, CONST_STRPTR name);
	void APICALL (*AddTail)(struct ExecIFace *Self, struct List * list, struct Node * node);
	DEPRECATED APTR APICALL (*AllocAbs)(struct ExecIFace *Self, ULONG byteSize, APTR location);
	DEPRECATED APTR APICALL (*Allocate)(struct ExecIFace *Self, struct MemHeader * memHeader, ULONG byteSize);
	DEPRECATED struct MemList * APICALL (*AllocEntry)(struct ExecIFace *Self, struct MemList * memList);
	DEPRECATED APTR APICALL (*AllocMem)(struct ExecIFace *Self, ULONG byteSize, ULONG attributes);
	APTR APICALL (*AllocPooled)(struct ExecIFace *Self, APTR poolHeader, ULONG memSize);
	DEPRECATED APTR APICALL (*AllocVec)(struct ExecIFace *Self, ULONG byteSize, ULONG attributes);
	APTR APICALL (*AllocVecPooled)(struct ExecIFace *Self, APTR poolHeader, ULONG size);
	ULONG APICALL (*AvailMem)(struct ExecIFace *Self, ULONG attributes);
	void APICALL (*CopyMem)(struct ExecIFace *Self, CONST_APTR source, APTR dest, ULONG size);
	void APICALL (*CopyMemQuick)(struct ExecIFace *Self, CONST_APTR source, APTR dest, ULONG size);
	DEPRECATED APTR APICALL (*CreatePool)(struct ExecIFace *Self, ULONG memFlags, ULONG puddleSize, ULONG threshSize);
	DEPRECATED void APICALL (*Deallocate)(struct ExecIFace *Self, struct MemHeader * memHeader, APTR memoryBlock, ULONG byteSize);
	DEPRECATED void APICALL (*DeletePool)(struct ExecIFace *Self, APTR poolHeader);
	void APICALL (*Enqueue)(struct ExecIFace *Self, struct List * list, struct Node * node);
	struct Node * APICALL (*FindName)(struct ExecIFace *Self, struct List * start, CONST_STRPTR name);
	struct Node * APICALL (*FindIName)(struct ExecIFace *Self, struct List * start, CONST_STRPTR name);
	void APICALL (*Forbid)(struct ExecIFace *Self);
	void APICALL (*FreeEntry)(struct ExecIFace *Self, struct MemList * memList);
	DEPRECATED void APICALL (*FreeMem)(struct ExecIFace *Self, APTR memoryBlock, ULONG byteSize);
	void APICALL (*FreePooled)(struct ExecIFace *Self, APTR poolHeader, APTR memory, ULONG memSize);
	void APICALL (*FreeVec)(struct ExecIFace *Self, APTR memoryBlock);
	void APICALL (*FreeVecPooled)(struct ExecIFace *Self, APTR poolHeader, APTR memory);
	DEPRECATED void APICALL (*InitData)(struct ExecIFace *Self, CONST_APTR initTab, APTR memory, ULONG size);
	DEPRECATED void APICALL (*InitStruct)(struct ExecIFace *Self, CONST_APTR initTable, APTR memory, ULONG size);
	void APICALL (*Insert)(struct ExecIFace *Self, struct List * list, struct Node * node, struct Node * listNode);
	struct Interface * APICALL (*MakeInterface)(struct ExecIFace *Self, struct Library * library, const struct TagItem * taglist);
	struct Interface * APICALL (*MakeInterfaceTags)(struct ExecIFace *Self, struct Library * library, ...);
	void APICALL (*Permit)(struct ExecIFace *Self);
	APTR APICALL (*RawDoFmt)(struct ExecIFace *Self, CONST_STRPTR formatString, CONST_APTR dataStream, void (*PutChProc)(), APTR PutChData);
	struct Node * APICALL (*RemHead)(struct ExecIFace *Self, struct List * list);
	VOID APICALL (*RemMemHandler)(struct ExecIFace *Self, struct Interrupt * memHandler);
	void APICALL (*Remove)(struct ExecIFace *Self, struct Node * node);
	struct Node * APICALL (*RemTail)(struct ExecIFace *Self, struct List * list);
	ULONG APICALL (*TypeOfMem)(struct ExecIFace *Self, CONST_APTR address);
	APTR APICALL (*InitResident)(struct ExecIFace *Self, const struct Resident * resident, ULONG segList);
	void APICALL (*InitCode)(struct ExecIFace *Self, ULONG startClass, ULONG version);
	ULONG APICALL (*SumKickData)(struct ExecIFace *Self);
	APTR APICALL (*AddTask)(struct ExecIFace *Self, struct Task * task, CONST_APTR initialPC, CONST_APTR finalPC, const struct TagItem * tagList);
	APTR APICALL (*AddTaskTags)(struct ExecIFace *Self, struct Task * task, CONST_APTR initialPC, CONST_APTR finalPC, ...);
	void APICALL (*Disable)(struct ExecIFace *Self);
	void APICALL (*Enable)(struct ExecIFace *Self);
	void APICALL (*Reschedule)(struct ExecIFace *Self);
	struct Task * APICALL (*FindTask)(struct ExecIFace *Self, CONST_STRPTR name);
	void APICALL (*RemTask)(struct ExecIFace *Self, struct Task * task);
	BYTE APICALL (*SetTaskPri)(struct ExecIFace *Self, struct Task * task, BYTE priority);
	DEPRECATED void APICALL (*StackSwap)(struct ExecIFace *Self, struct StackSwapStruct * newstack);
	BYTE APICALL (*AllocSignal)(struct ExecIFace *Self, BYTE signalNum);
	void APICALL (*FreeSignal)(struct ExecIFace *Self, BYTE signalNum);
	ULONG APICALL (*SetExcept)(struct ExecIFace *Self, ULONG newSignals, ULONG signalMask);
	ULONG APICALL (*SetSignal)(struct ExecIFace *Self, ULONG newSignals, ULONG signalMask);
	void APICALL (*Signal)(struct ExecIFace *Self, struct Task * task, ULONG signals);
	ULONG APICALL (*Wait)(struct ExecIFace *Self, ULONG signalSet);
	void APICALL (*AddPort)(struct ExecIFace *Self, struct MsgPort * port);
	DEPRECATED struct MsgPort * APICALL (*CreatePort)(struct ExecIFace *Self, CONST_STRPTR name, BYTE pri);
	DEPRECATED struct MsgPort * APICALL (*CreateMsgPort)(struct ExecIFace *Self);
	DEPRECATED void APICALL (*DeletePort)(struct ExecIFace *Self, struct MsgPort * port);
	DEPRECATED void APICALL (*DeleteMsgPort)(struct ExecIFace *Self, struct MsgPort * port);
	struct MsgPort * APICALL (*FindPort)(struct ExecIFace *Self, CONST_STRPTR name);
	struct Message * APICALL (*GetMsg)(struct ExecIFace *Self, struct MsgPort * port);
	void APICALL (*PutMsg)(struct ExecIFace *Self, struct MsgPort * port, struct Message * message);
	void APICALL (*RemPort)(struct ExecIFace *Self, struct MsgPort * port);
	void APICALL (*ReplyMsg)(struct ExecIFace *Self, struct Message * message);
	struct Message * APICALL (*WaitPort)(struct ExecIFace *Self, struct MsgPort * port);
	void APICALL (*Cause)(struct ExecIFace *Self, struct Interrupt * interrupt);
	void APICALL (*AddSemaphore)(struct ExecIFace *Self, struct SignalSemaphore * semaphore);
	LONG APICALL (*AttemptSemaphore)(struct ExecIFace *Self, struct SignalSemaphore * semaphore);
	LONG APICALL (*AttemptSemaphoreShared)(struct ExecIFace *Self, struct SignalSemaphore * semaphore);
	struct SignalSemaphore * APICALL (*FindSemaphore)(struct ExecIFace *Self, CONST_STRPTR name);
	void APICALL (*InitSemaphore)(struct ExecIFace *Self, struct SignalSemaphore * semaphore);
	void APICALL (*ObtainSemaphore)(struct ExecIFace *Self, struct SignalSemaphore * semaphore);
	void APICALL (*ObtainSemaphoreList)(struct ExecIFace *Self, struct List * list);
	void APICALL (*ObtainSemaphoreShared)(struct ExecIFace *Self, struct SignalSemaphore * semaphore);
	void APICALL (*Procure)(struct ExecIFace *Self, struct SignalSemaphore * semaphore, struct SemaphoreMessage * bidMessage);
	void APICALL (*ReleaseSemaphore)(struct ExecIFace *Self, struct SignalSemaphore * semaphore);
	void APICALL (*ReleaseSemaphoreList)(struct ExecIFace *Self, struct List * list);
	void APICALL (*RemSemaphore)(struct ExecIFace *Self, struct SignalSemaphore * semaphore);
	void APICALL (*Vacate)(struct ExecIFace *Self, struct SignalSemaphore * semaphore, struct SemaphoreMessage * bidMessage);
	struct Task * APICALL (*CreateTask)(struct ExecIFace *Self, CONST_STRPTR name, LONG pri, CONST_APTR initPC, ULONG stackSize, const struct TagItem * tagList);
	struct Task * APICALL (*CreateTaskTags)(struct ExecIFace *Self, CONST_STRPTR name, LONG pri, CONST_APTR initPC, ULONG stackSize, ...);
	void APICALL (*DeleteTask)(struct ExecIFace *Self, struct Task * task);
	void APICALL (*SumLibrary)(struct ExecIFace *Self, struct Library * library);
	struct Library * APICALL (*CreateLibrary)(struct ExecIFace *Self, const struct TagItem * taglist);
	struct Library * APICALL (*CreateLibraryTags)(struct ExecIFace *Self, ...);
	struct Library * APICALL (*OpenLibrary)(struct ExecIFace *Self, CONST_STRPTR name, ULONG version);
	APTR APICALL (*CloseLibrary)(struct ExecIFace *Self, struct Library * library);
	void APICALL (*AddLibrary)(struct ExecIFace *Self, struct Library * library);
	ULONG APICALL (*RemLibrary)(struct ExecIFace *Self, struct Library * library);
	void APICALL (*AddDevice)(struct ExecIFace *Self, struct Device * device);
	ULONG APICALL (*RemDevice)(struct ExecIFace *Self, struct Device * device);
	struct Interface * APICALL (*GetInterface)(struct ExecIFace *Self, struct Library * library, CONST_STRPTR name, ULONG version, const struct TagItem * taglist);
	struct Interface * APICALL (*GetInterfaceTags)(struct ExecIFace *Self, struct Library * library, CONST_STRPTR name, ULONG version, ...);
	void APICALL (*DropInterface)(struct ExecIFace *Self, struct Interface * interface);
	void APICALL (*AddInterface)(struct ExecIFace *Self, struct Library * library, struct Interface * interface);
	void APICALL (*RemInterface)(struct ExecIFace *Self, struct Interface * interface);
	void APICALL (*SumInterface)(struct ExecIFace *Self, struct Interface * interface);
	struct Resident * APICALL (*FindResident)(struct ExecIFace *Self, CONST_STRPTR name);
	APTR APICALL (*SetMethod)(struct ExecIFace *Self, struct Interface * interface, LONG funcOffset, CONST_APTR newFunc);
	void APICALL (*DeleteInterface)(struct ExecIFace *Self, struct Interface * interface);
	void APICALL (*DeleteLibrary)(struct ExecIFace *Self, struct Library * library);
	APTR APICALL (*SetFunction)(struct ExecIFace *Self, struct Library * library, LONG funcOffset, CONST_APTR newFunc);
	void APICALL (*CacheClearE)(struct ExecIFace *Self, APTR address, ULONG length, ULONG caches);
	DEPRECATED void APICALL (*CacheClearU)(struct ExecIFace *Self);
	ULONG APICALL (*MakeFunctions)(struct ExecIFace *Self, APTR target, CONST_APTR functionArray, CONST_APTR funcDispBase);
	LONG APICALL (*OpenDevice)(struct ExecIFace *Self, CONST_STRPTR devName, ULONG unitNumber, struct IORequest * ioRequest, ULONG flags);
	APTR APICALL (*CloseDevice)(struct ExecIFace *Self, struct IORequest * ioRequest);
	DEPRECATED struct IORequest * APICALL (*CreateIORequest)(struct ExecIFace *Self, const struct MsgPort * ioReplyPort, ULONG size);
	DEPRECATED void APICALL (*DeleteIORequest)(struct ExecIFace *Self, struct IORequest * ioRequest);
	void APICALL (*AbortIO)(struct ExecIFace *Self, struct IORequest * ioRequest);
	struct IORequest * APICALL (*CheckIO)(struct ExecIFace *Self, struct IORequest * ioRequest);
	BYTE APICALL (*DoIO)(struct ExecIFace *Self, struct IORequest * ioRequest);
	void APICALL (*SendIO)(struct ExecIFace *Self, struct IORequest * ioRequest);
	void APICALL (*BeginIO)(struct ExecIFace *Self, struct IORequest * ioRequest);
	BYTE APICALL (*WaitIO)(struct ExecIFace *Self, struct IORequest * ioRequest);
	void APICALL (*AddResource)(struct ExecIFace *Self, APTR resource);
	void APICALL (*RemResource)(struct ExecIFace *Self, APTR resource);
	APTR APICALL (*OpenResource)(struct ExecIFace *Self, CONST_STRPTR resName);
	BOOL APICALL (*AddIntServer)(struct ExecIFace *Self, ULONG intNum, struct Interrupt * interrupt);
	void APICALL (*RemIntServer)(struct ExecIFace *Self, ULONG intNum, struct Interrupt * interrupt);
	struct Interrupt * APICALL (*SetIntVector)(struct ExecIFace *Self, ULONG intNum, const struct Interrupt * interrupt);
	DEPRECATED ULONG APICALL (*ObtainQuickVector)(struct ExecIFace *Self, APTR interruptCode);
	void APICALL (*Alert)(struct ExecIFace *Self, ULONG alertNum);
	APTR APICALL (*SuperState)(struct ExecIFace *Self);
	void APICALL (*UserState)(struct ExecIFace *Self, APTR sysStack);
	ULONG APICALL (*Supervisor)(struct ExecIFace *Self, APTR userFunc);
	BOOL APICALL (*SetTaskTrap)(struct ExecIFace *Self, ULONG trapNum, CONST_APTR trapCode, CONST_APTR trapData);
	DEPRECATED LONG APICALL (*AllocTrap)(struct ExecIFace *Self, ULONG trapNum);
	DEPRECATED void APICALL (*FreeTrap)(struct ExecIFace *Self, ULONG trapNum);
	DEPRECATED UWORD APICALL (*GetCC)(struct ExecIFace *Self);
	DEPRECATED ULONG APICALL (*SetSR)(struct ExecIFace *Self, ULONG newSR, ULONG mask);
	struct AVLNode * APICALL (*AVL_AddNode)(struct ExecIFace *Self, struct AVLNode ** root, struct AVLNode * node, AVLNODECOMP func);
	struct AVLNode * APICALL (*AVL_FindFirstNode)(struct ExecIFace *Self, const struct AVLNode * root);
	struct AVLNode * APICALL (*AVL_FindLastNode)(struct ExecIFace *Self, const struct AVLNode * root);
	struct AVLNode * APICALL (*AVL_FindNextNodeByAddress)(struct ExecIFace *Self, const struct AVLNode * root);
	struct AVLNode * APICALL (*AVL_FindNextNodeByKey)(struct ExecIFace *Self, const struct AVLNode * root, AVLKey key, AVLKEYCOMP func);
	struct AVLNode * APICALL (*AVL_FindNode)(struct ExecIFace *Self, const struct AVLNode * root, AVLKey key, AVLKEYCOMP func);
	struct AVLNode * APICALL (*AVL_FindPrevNodeByAddress)(struct ExecIFace *Self, const struct AVLNode * root);
	struct AVLNode * APICALL (*AVL_FindPrevNodeByKey)(struct ExecIFace *Self, const struct AVLNode * root, AVLKey key, AVLKEYCOMP func);
	struct AVLNode * APICALL (*AVL_RemNodeByAddress)(struct ExecIFace *Self, struct AVLNode ** root, struct AVLNode * node);
	struct AVLNode * APICALL (*AVL_RemNodeByKey)(struct ExecIFace *Self, struct AVLNode ** root, AVLKey key, AVLKEYCOMP func);
	ULONG APICALL (*CacheControl)(struct ExecIFace *Self, ULONG cacheBits, ULONG cacheMask);
	BOOL APICALL (*LockMem)(struct ExecIFace *Self, APTR baseAddress, ULONG size);
	void APICALL (*UnlockMem)(struct ExecIFace *Self, APTR baseAddress, ULONG size);
	APTR ReallocVec_UNIMPLEMENTED;
	APTR APICALL (*CachePreDMA)(struct ExecIFace *Self, CONST_APTR vaddr, ULONG * length, ULONG flags);
	void APICALL (*CachePostDMA)(struct ExecIFace *Self, CONST_APTR vaddr, ULONG * length, ULONG flags);
	ULONG APICALL (*StartDMA)(struct ExecIFace *Self, CONST_APTR startAddr, ULONG blockSize, ULONG flags);
	void APICALL (*EndDMA)(struct ExecIFace *Self, CONST_APTR startAddr, ULONG blockSize, ULONG flags);
	void APICALL (*GetDMAList)(struct ExecIFace *Self, CONST_APTR startAddr, ULONG blockSize, ULONG flags, struct DMAEntry * dmaList);
	struct Trackable * APICALL (*AddTrackable)(struct ExecIFace *Self, struct Task * usingTask, APTR object, struct Hook * destFunc);
	struct Trackable * APICALL (*FindTrackable)(struct ExecIFace *Self, struct Task * usingTask, APTR object);
	struct Trackable * APICALL (*RemTrackable)(struct ExecIFace *Self, struct Task * usingTask, struct Trackable * trackable);
	void APICALL (*DeleteTrackable)(struct ExecIFace *Self, struct Trackable * trackable);
	APTR APICALL (*AllocSysObject)(struct ExecIFace *Self, ULONG type, const struct TagItem * tags);
	APTR APICALL (*AllocSysObjectTags)(struct ExecIFace *Self, ULONG type, ...);
	void APICALL (*FreeSysObject)(struct ExecIFace *Self, ULONG type, APTR object);
	void APICALL (*SuspendTask)(struct ExecIFace *Self, struct Task * whichTask, ULONG flags);
	void APICALL (*RestartTask)(struct ExecIFace *Self, struct Task * whichTask, ULONG flags);
	void APICALL (*MoveList)(struct ExecIFace *Self, struct List * destinationList, struct List * sourceList);
	void APICALL (*NewList)(struct ExecIFace *Self, struct List * list);
	void APICALL (*NewMinList)(struct ExecIFace *Self, struct MinList * list);
	void APICALL (*ColdReboot)(struct ExecIFace *Self);
	struct Library * APICALL (*MakeLibrary)(struct ExecIFace *Self, CONST_APTR vectors, CONST_APTR structure, CONST_APTR init, ULONG dataSize, APTR segList);
	ULONG APICALL (*Emulate)(struct ExecIFace *Self, CONST_APTR InitPC, const struct TagItem * tagList);
	ULONG APICALL (*EmulateTags)(struct ExecIFace *Self, CONST_APTR InitPC, ...);
	void APICALL (*DebugPrintF)(struct ExecIFace *Self, CONST_STRPTR format, ...);
	BOOL APICALL (*IsNative)(struct ExecIFace *Self, CONST_APTR code);
	APTR Private1;
	APTR Private2;
	void APICALL (*GetCPUInfo)(struct ExecIFace *Self, const struct TagItem * TagList);
	void APICALL (*GetCPUInfoTags)(struct ExecIFace *Self, ...);
	struct Task * APICALL (*OwnerOfMem)(struct ExecIFace *Self, CONST_APTR Address);
	BOOL APICALL (*AddResetCallback)(struct ExecIFace *Self, struct Interrupt * resetCallback);
	void APICALL (*RemResetCallback)(struct ExecIFace *Self, struct Interrupt * resetCallback);
	APTR APICALL (*ItemPoolAlloc)(struct ExecIFace *Self, APTR itemPool);
	void APICALL (*ItemPoolFree)(struct ExecIFace *Self, APTR itemPool, APTR item);
	void APICALL (*ItemPoolGC)(struct ExecIFace *Self, APTR itemPool);
	uint32 APICALL (*ItemPoolControl)(struct ExecIFace *Self, APTR itemPool, const struct TagItem * tagList);
	uint32 APICALL (*ItemPoolControlTags)(struct ExecIFace *Self, APTR itemPool, ...);
	void APICALL (*ItemPoolFlush)(struct ExecIFace *Self, APTR itemPool);
	struct Node * APICALL (*GetHead)(struct ExecIFace *Self, struct List * list);
	struct Node * APICALL (*GetTail)(struct ExecIFace *Self, struct List * list);
	struct Node * APICALL (*GetSucc)(struct ExecIFace *Self, struct Node * node);
	struct Node * APICALL (*GetPred)(struct ExecIFace *Self, struct Node * node);
	void APICALL (*IceColdReboot)(struct ExecIFace *Self);
	APTR Private3;
	APTR Private4;
	APTR Private5;
	APTR Private6;
	APTR Private7;
	APTR Private8;
	APTR Private9;
	APTR Private10;
	APTR Private11;
	APTR Private12;
	APTR Private13;
	APTR Private14;
	APTR Private15;
	APTR Private16;
	APTR Private17;
	APTR Private18;
	APTR Private19;
	APTR Private20;
	APTR Obsolete1_UNIMPLEMENTED;
	APTR Obsolete2_UNIMPLEMENTED;
	APTR Obsolete3_UNIMPLEMENTED;
	APTR APICALL (*RMapAlloc)(struct ExecIFace *Self, APTR Map, uint32 size, uint32 flags);
	void APICALL (*RMapFree)(struct ExecIFace *Self, APTR Map, APTR addr, uint32 size);
	APTR Private21;
	APTR Private22;
	APTR Private23;
	APTR APICALL (*AllocVecTagList)(struct ExecIFace *Self, uint32 size, const struct TagItem * tags);
	APTR APICALL (*AllocVecTags)(struct ExecIFace *Self, uint32 size, ...);
	APTR Private24;
	APTR APICALL (*RMapExtAlloc)(struct ExecIFace *Self, APTR Map, uint32 size, uint32 alignment, uint32 flags);
	void APICALL (*RMapExtFree)(struct ExecIFace *Self, APTR Map, APTR addr, uint32 size);
	APTR Private25;
	APTR APICALL (*AllocNamedMemory)(struct ExecIFace *Self, uint32 byteSize, CONST_STRPTR space, CONST_STRPTR name, struct TagItem * tagList);
	APTR APICALL (*AllocNamedMemoryTags)(struct ExecIFace *Self, uint32 byteSize, CONST_STRPTR space, CONST_STRPTR name, ...);
	BOOL APICALL (*FreeNamedMemory)(struct ExecIFace *Self, CONST_STRPTR space, CONST_STRPTR name);
	void * APICALL (*FindNamedMemory)(struct ExecIFace *Self, CONST_STRPTR space, CONST_STRPTR name);
	void APICALL (*UpdateNamedMemory)(struct ExecIFace *Self, CONST_STRPTR space, CONST_STRPTR name);
	void * APICALL (*LockNamedMemory)(struct ExecIFace *Self, CONST_STRPTR space, CONST_STRPTR name);
	void * APICALL (*AttemptNamedMemory)(struct ExecIFace *Self, CONST_STRPTR space, CONST_STRPTR name);
	void APICALL (*UnlockNamedMemory)(struct ExecIFace *Self, CONST_STRPTR space, CONST_STRPTR name);
	uint32 APICALL (*ScanNamedMemory)(struct ExecIFace *Self, struct Hook * scHook, uint32 flags, APTR user);
	struct MemList * APICALL (*AllocTaskMemEntry)(struct ExecIFace *Self, struct MemList * memList);
	APTR Private26;
	APTR Private27;
	APTR Private28;
	APTR Private29;
	VOID APICALL (*MutexObtain)(struct ExecIFace *Self, APTR Mutex);
	BOOL APICALL (*MutexAttempt)(struct ExecIFace *Self, APTR Mutex);
	VOID APICALL (*MutexRelease)(struct ExecIFace *Self, APTR Mutex);
	uint32 APICALL (*MutexAttemptWithSignal)(struct ExecIFace *Self, APTR Mutex, uint32 SigSet);
	int32 APICALL (*NewStackRun)(struct ExecIFace *Self, APTR initPC, const struct TagItem * TagList);
	int32 APICALL (*NewStackRunTags)(struct ExecIFace *Self, APTR initPC, ...);
	uint32 APICALL (*AttemptSemaphoreWithSignal)(struct ExecIFace *Self, struct SignalSemaphore * semaphore, uint32 sigmask);
	uint32 APICALL (*AttemptSemaphoreSharedWithSignal)(struct ExecIFace *Self, struct SignalSemaphore * semaphore, uint32 sigmask);
	int32 APICALL (*GetTaskAttrs)(struct ExecIFace *Self, struct Task * task, const struct TagItem * taglist);
	int32 APICALL (*GetTaskAttrsTags)(struct ExecIFace *Self, struct Task * task, ...);
	DEPRECATED void APICALL (*OBSOLETEMutexObtainDisable)(struct ExecIFace *Self, APTR mutex);
	DEPRECATED void APICALL (*OBSOLETEMutexReleaseEnable)(struct ExecIFace *Self, APTR mutex);
	struct Resident * APICALL (*FindResidentTagList)(struct ExecIFace *Self, const struct TagItem * tagList);
	struct Resident * APICALL (*FindResidentTags)(struct ExecIFace *Self, ...);
	APTR Private30;
	APTR Private31;
	APTR Private32;
	APTR Private33;
	APTR Private34;
	APTR Private35;
	APTR Private36;
	APTR Private37;
	void APICALL (*GetSystemInfo)(struct ExecIFace *Self, const struct TagItem * TagList);
	void APICALL (*GetSystemInfoTags)(struct ExecIFace *Self, ...);
	APTR Private38;
	APTR Private39;
	APTR Private40;
	APTR Private41;
	void APICALL (*SetTaskAffinity)(struct ExecIFace *Self, struct Task * task, const struct TagItem * TagList);
	void APICALL (*SetTaskAffinityTags)(struct ExecIFace *Self, struct Task * task, ...);
};

struct MMUIFace
{
	struct InterfaceData Data;

	ULONG APICALL (*Obtain)(struct MMUIFace *Self);
	ULONG APICALL (*Release)(struct MMUIFace *Self);
	APTR Expunge_UNIMPLEMENTED;
	APTR Clone_UNIMPLEMENTED;
	BOOL APICALL (*MapMemory)(struct MMUIFace *Self, APTR virtualAddress, APTR phyiscal, ULONG length, ULONG attrib);
	void APICALL (*UnmapMemory)(struct MMUIFace *Self, APTR virtualAddress, ULONG length);
	void APICALL (*RemapMemory)(struct MMUIFace *Self, APTR virtualAddress, APTR phyiscal, ULONG length, ULONG attrib);
	void APICALL (*SetMemoryAttrs)(struct MMUIFace *Self, APTR virtualAddress, ULONG length, ULONG attrib);
	ULONG APICALL (*GetMemoryAttrs)(struct MMUIFace *Self, APTR virtualAddress, ULONG flags);
	APTR APICALL (*GetPhysicalAddress)(struct MMUIFace *Self, APTR virtualAddress);
};

struct DebugIFace
{
	struct InterfaceData Data;

	ULONG APICALL (*Obtain)(struct DebugIFace *Self);
	ULONG APICALL (*Release)(struct DebugIFace *Self);
	APTR Expunge_UNIMPLEMENTED;
	APTR Clone_UNIMPLEMENTED;
	BOOL APICALL (*AddDebugHook)(struct DebugIFace *Self, struct Task * task, struct Hook * debugHook);
	APTR APICALL (*DisassembleNative)(struct DebugIFace *Self, APTR targetAddress, STRPTR opcodeName, STRPTR operands);
	APTR APICALL (*Disassemble68k)(struct DebugIFace *Self, APTR targetAddress, STRPTR opcodeName, STRPTR operands);
	uint32 APICALL (*GetDebugLevel)(struct DebugIFace *Self);
	uint32 APICALL (*ReadTaskContext)(struct DebugIFace *Self, struct Task * targetTask, struct ExceptionContext * contextStore, uint32 flags);
	uint32 APICALL (*WriteTaskContext)(struct DebugIFace *Self, struct Task * targetTask, struct ExceptionContext * contextStore, uint32 flags);
	int32 APICALL (*StackTrace)(struct DebugIFace *Self, struct Task * task, struct Hook * hook);
	struct DebugSymbol * APICALL (*ObtainDebugSymbol)(struct DebugIFace *Self, CONST_APTR address, struct TagItem * tagList);
	struct DebugSymbol * APICALL (*ObtainDebugSymbolTags)(struct DebugIFace *Self, CONST_APTR address, ...);
	void APICALL (*ReleaseDebugSymbol)(struct DebugIFace *Self, struct DebugSymbol * sym);
	BOOL APICALL (*IsIn68kEmulator)(struct DebugIFace *Self, const struct Task * task);
	struct DebugOutputNotify * APICALL (*StartDebugOutputNotify)(struct DebugIFace *Self, struct TagItem * tagList);
	struct DebugOutputNotify * APICALL (*StartDebugOutputNotifyTags)(struct DebugIFace *Self, ...);
	void APICALL (*EndDebugOutputNotify)(struct DebugIFace *Self, struct DebugOutputNotify * notify);
};

#ifdef __cplusplus
}
#ifdef __USE_AMIGAOS_NAMESPACE__
}
#endif
#endif

#endif /* EXEC_INTERFACE_DEF_H */
