#ifndef SCSI_SENSE_CODES_H
#define SCSI_SENSE_CODES_H

/*
**    $VER: sense_codes.h 54.16 (22.08.2022)
**
**    SCSI sense codes
**
**    Copyright (C) 1985-2005 Hyperion Entertainment VOF and Amiga, Inc.
**        All Rights Reserved
**
**    Copyright (c) 2010 Hyperion Entertainment CVBA.
**        All Rights Reserved.
*/

/****************************************************************************/

#ifdef __cplusplus
#ifdef __USE_AMIGAOS_NAMESPACE__
namespace AmigaOS {
#endif
extern "C" {
#endif

#ifdef __GNUC__
   #ifdef __PPC__
    #pragma pack(2)
   #endif
#elif defined(__VBCC__)
   #pragma amiga-align
#endif

/****************************************************************************/

/* Codes for sense key. Keep in mind that only the low 4 bits must be compared! */
enum SCSI_sense_keys
{
    NO_SENSE         = 0x0,
    RECOVERED_ERROR  = 0x1,
    NOT_READY        = 0x2,
    MEDIUM_ERROR     = 0x3,
    HARDWARE_ERROR   = 0x4,
    ILLEGAL_REQUEST  = 0x5,
    UNIT_ATTENTION   = 0x6,
    DATA_PROTECT     = 0x7,
    BLANK_CHECK      = 0x8,
    VENDOR_SPECIFIC  = 0x9,
    COPY_ABORTED     = 0xA,
    ABORTED_COMMAND  = 0xB,
    EQUAL            = 0xC, /* Set as obsolete by SPC2 */
    VOLUME_OVERFLOW  = 0xD,
    MISCOMPARE       = 0xE,
    RESERVED         = 0xF
};

#define COMPARE_SKEY(sk, test) ((sk & 0xf) == test)

/* Codes for ASC and ASCQ. Since these two bytes are contiguous in memory, it's
   safe to compare them together - if you're running on a big endian machine,
   of course! If you're compiling for a little-endian processor (yuk!),
   use the macro at the bottom.
   Also, pay attention that some codes are defined as a group, with ASCQ being
   a parameter. They are commented here - you'll have to check for them
   separately. ATM they are:
       0x70NN
       0x5DNN
       0x40NN
       0x4DNN
*/

enum SCSI_ASC_ASCQ
{
    ADD_LOGICAL_UNIT_FAILED                                 = 0x6702,
    ADDRESS_MARK_NOT_FOUND_FOR_DATA_FIELD                   = 0x1300,
    ADDRESS_MARK_NOT_FOUND_FOR_ID_FIELD                     = 0x1200,
    ASSIGN_FAILURE_OCCURRED                                 = 0x6708,
    ASSOCIATED_WRITE_PROTECT                                = 0x2703,
    ATTACHMENT_OF_LOGICAL_UNIT_FAILED                       = 0x6706,
    AUDIO_PLAY_OPERATION_IN_PROGRESS                        = 0x0011,
    AUDIO_PLAY_OPERATION_PAUSED                             = 0x0012,
    AUDIO_PLAY_OPERATION_STOPPED_DUE_TO_ERROR               = 0x0014,
    AUDIO_PLAY_OPERATION_SUCCESSFULLY_COMPLETED             = 0x0013,
    AUTOMATIC_DOCUMENT_FEEDER_COVER_UP                      = 0x6600,
    AUTOMATIC_DOCUMENT_FEEDER_LIFT_UP                       = 0x6601,
    BEGINNING_OF_PARTITION_MEDIUM_DETECTED                  = 0x0004,
    BLOCK_NOT_COMPRESSIBLE                                  = 0x0C06,
    BLOCK_SEQUENCE_ERROR                                    = 0x1404,
    BUS_DEVICE_RESET_FUNCTION_OCCURRED                      = 0x2903,
    CANNOT_DECOMPRESS_USING_DECLARED_ALGORITHM              = 0x110E,
    CANNOT_FORMAT_MEDIUM_INCOMPATIBLE_MEDIUM                = 0x3006,
    CANNOT_READ_MEDIUM_INCOMPATIBLE_FORMAT                  = 0x3002,
    CANNOT_READ_MEDIUM_UNKNOWN_FORMAT                       = 0x3001,
    CANNOT_WRITE_APPLICATION_CODE_MISMATCH                  = 0x3008,
    CANNOT_WRITE_MEDIUM_INCOMPATIBLE_FORMAT                 = 0x3005,
    CANNOT_WRITE_MEDIUM_UNKNOWN_FORMAT                      = 0x3004,
    CARTRIDGE_FAULT                                         = 0x5200,
    CD_CONTROL_ERROR                                        = 0x7300,
    CDB_DECRYPTION_ERROR                                    = 0x2401,
    CHANGED_OPERATING_DEFINITION                            = 0x3F02,
    CIRC_UNRECOVERED_ERROR                                  = 0x1106,
    CLEANING_CARTRIDGE_INSTALLED                            = 0x3003,
    CLEANING_FAILURE                                        = 0x3007,
    CLEANING_REQUESTED                                      = 0x0017,
    COMMAND_PHASE_ERROR                                     = 0x4A00,
    COMMAND_SEQUENCE_ERROR                                  = 0x2C00,
    COMMAND_TO_LOGICAL_UNIT_FAILED                          = 0x6E00,
    COMMANDS_CLEARED_BY_ANOTHER_INITIATOR                   = 0x2F00,
    COMPONENT_DEVICE_ATTACHED                               = 0x3F04,
    COMPRESSION_CHECK_MISCOMPARE_ERROR                      = 0x0C04,
    CONFIGURATION_FAILURE                                   = 0x6700,
    CONFIGURATION_OF_INCAPABLE_LOGICAL_UNITS_FAILED         = 0x6701,
    COPY_CANNOT_EXECUTE_SINCE_HOST_CANNOT_DISCONNECT        = 0x2B00,
    COPY_PROT_KEY_EXCH_FAIL_AUTHENTICATION_FAILURE          = 0x6F00,
    COPY_PROT_KEY_EXCH_FAIL_KEY_N_ESTABLISHED               = 0x6F02,
    COPY_PROT_KEY_EXCH_FAIL_KEY_N_PRESENT                   = 0x6F01,
    CREATION_OF_LOGICAL_UNIT_FAILED                         = 0x6707,
    CURRENT_PROGRAM_AREA_IS_EMPTY                           = 0x2C04,
    CURRENT_PROGRAM_AREA_IS_NOT_EMPTY                       = 0x2C03,
    CURRENT_SESSION_NOT_FIXATED_FOR_APPEND                  = 0x3009,
    DATA_DECRYPTION_ERROR                                   = 0x2605,
    DATA_EXPANSION_OCCURRED_DURING_COMPRESSION              = 0x0C05,
    DATA_LOSS_ON_LOGICAL_UNIT                               = 0x6900,
    DATA_PATH_FAILURE_SHOULD_USE_40_NN                      = 0x4100,
    DATA_PHASE_ERROR                                        = 0x4B00,
    DATA_RESYNCHRONIZATION_ERROR                            = 0x1107,
    DATA_SYNC_ERROR_DATA_AUTO_REALLOCATED                   = 0x1603,
    DATA_SYNC_ERROR_DATA_REWRITTEN                          = 0x1601,
    DATA_SYNC_ERROR_RECOMMEND_REASSIGNMENT                  = 0x1604,
    DATA_SYNC_ERROR_RECOMMEND_REWRITE                       = 0x1602,
    DATA_SYNCHRONIZATION_MARK_ERROR                         = 0x1600,
    DE_COMPRESSION_CRC_ERROR                                = 0x110D,
    DECOMPRESSION_EXCEPTION_LONG_ALGORITHM_ID               = 0x7100,
/*  DECOMPRESSION_EXCEPTION_SHORT_ALGORITHM_ID_OF_NN        = 0x70NN, */
    DEFECT_LIST_ERROR                                       = 0x1900,
    DEFECT_LIST_ERROR_IN_GROWN_LIST                         = 0x1903,
    DEFECT_LIST_ERROR_IN_PRIMARY_LIST                       = 0x1902,
    DEFECT_LIST_NOT_AVAILABLE                               = 0x1901,
    DEFECT_LIST_NOT_FOUND                                   = 0x1C00,
    DEFECT_LIST_UPDATE_FAILURE                              = 0x3201,
/*  DETAILED_FAILURE_PREDICTION_INFORMATION_(nn=10h_7Fh)    = 0x5DNN, */
    DEVICE_IDENTIFIER_CHANGED                               = 0x3F05,
    DEVICE_INTERNAL_RESET                                   = 0x2904,
/*  DIAGNOSTIC_FAILURE_ON_COMPONENT_NN_(80H_FFH)            = 0x40NN, */
    DOCUMENT_JAM_IN_AUTOMATIC_DOCUMENT_FEEDER               = 0x6602,
    DOCUMENT_MISS_FEED_AUTOMATIC_IN_DOCUMENT_FEEDER         = 0x6603,
    DRIVE_REGION_MUST_BE_PERMANENT_REGION_RESET_COUNT_ERROR = 0x6F05,
    EMPTY_OR_PARTIALLY_WRITTEN_RESERVED_TRACK               = 0x7204,
    ENCLOSURE_FAILURE                                       = 0x3400,
    ENCLOSURE_SERVICES_FAILURE                              = 0x3500,
    ENCLOSURE_SERVICES_TRANSFER_FAILURE                     = 0x3503,
    ENCLOSURE_SERVICES_TRANSFER_REFUSED                     = 0x3504,
    ENCLOSURE_SERVICES_UNAVAILABLE                          = 0x3502,
    END_OF_MEDIUM_REACHED                                   = 0x3B0F,
    END_OF_USER_AREA_ENCOUNTERED_ON_THIS_TRACK              = 0x6300,
    END_OF_DATA_DETECTED                                    = 0x0005,
    END_OF_DATA_NOT_FOUND                                   = 0x1403,
    END_OF_PARTITION_MEDIUM_DETECTED                        = 0x0002,
    ERASE_FAILURE                                           = 0x5100,
    ERROR_LOG_OVERFLOW                                      = 0x0A00,
    ERROR_READING_ISRC_NUMBER                               = 0x1110,
    ERROR_READING_UPC_EAN_NUMBER                            = 0x110F,
    ERROR_TOO_LONG_TO_CORRECT                               = 0x1102,
    ESN_DEVICE_BUSY_CLASS_EVENT                             = 0x3806,
    ESN_MEDIA_CLASS_EVENT                                   = 0x3804,
    ESN_POWER_MANAGEMENT_CLASS_EVENT                        = 0x3802,
    EVENT_STATUS_NOTIFICATION                               = 0x3800,
    EXCESSIVE_WRITE_ERRORS                                  = 0x0302,
    EXCHANGE_OF_LOGICAL_UNIT_FAILED                         = 0x6704,
    FAILED_TO_SENSE_BOTTOM_OF_FORM                          = 0x3B07,
    FAILED_TO_SENSE_TOP_OF_FORM                             = 0x3B06,
    FAILURE_PREDICTION_THRESHOLD_EXCEEDED                   = 0x5D00,
    FAILURE_PREDICTION_THRESHOLD_NOT_EXCEEDED               = 0x5DFF,
    FILEMARK_DETECTED                                       = 0x0001,
    FILEMARK_OR_SETMARK_NOT_FOUND                           = 0x1402,
    FOCUS_SERVO_FAILURE                                     = 0x0902,
    FORMAT_COMMAND_FAILED                                   = 0x3101,
    GENERATION_DOES_NOT_EXIST                               = 0x5800,
    GROWN_DEFECT_LIST_NOT_FOUND                             = 0x1C02,
    HARDWARE_WRITE_PROTECTED                                = 0x2701,
    HEAD_SELECT_FAULT                                       = 0x0904,
    I_O_PROCESS_TERMINATED                                  = 0x0006,
    ID_CRC_OR_ECC_ERROR                                     = 0x1000,
    IDLE_CONDITION_ACTIVATED_BY_COMMAND                     = 0x5E03,
    IDLE_CONDITION_ACTIVATED_BY_TIMER                       = 0x5E01,
    ILLEGAL_FUNCTION                                        = 0x2200,
    ILLEGAL_MODE_FOR_THIS_TRACK                             = 0x6400,
    ILLEGAL_POWER_CONDITION_REQUEST                         = 0x2C05,
    IMPORT_OR_EXPORT_ELEMENT_ACCESSED                       = 0x2801,
    INCOMPATIBLE_MEDIUM_INSTALLED                           = 0x3000,
    INCOMPLETE_BLOCK_READ                                   = 0x1108,
    INFORMATIONAL_REFER_TO_LOG                              = 0x6A00,
    INITIATOR_DETECTED_ERROR_MESSAGE_RECEIVED               = 0x4800,
    INQUIRY_DATA_HAS_CHANGED                                = 0x3F03,
    INSUFFICIENT_REGISTRATION_RESOURCES                     = 0x5504,
    INSUFFICIENT_RESERVATION_RESOURCES                      = 0x5502,
    INSUFFICIENT_RESOURCES                                  = 0x5503,
    INTERNAL_TARGET_FAILURE                                 = 0x4400,
    INVALID_BITS_IN_IDENTIFY_MESSAGE                        = 0x3D00,
    INVALID_COMBINATION_OF_WINDOWS_SPECIFIED                = 0x2C02,
    INVALID_COMMAND_OPERATION_CODE                          = 0x2000,
    INVALID_ELEMENT_ADDRESS                                 = 0x2101,
    INVALID_FIELD_IN_CDB                                    = 0x2400,
    INVALID_FIELD_IN_PARAMETER_LIST                         = 0x2600,
    INVALID_MESSAGE_ERROR                                   = 0x4900,
    INVALID_PACKET_SIZE                                     = 0x6401,
    INVALID_RELEASE_OF_PERSISTENT_RESERVATION               = 0x2604,
    L_EC_UNCORRECTABLE_ERROR                                = 0x1105,
    LAMP_FAILURE                                            = 0x6000,
    LOG_COUNTER_AT_MAXIMUM                                  = 0x5B02,
    LOG_EXCEPTION                                           = 0x5B00,
    LOG_LIST_CODES_EXHAUSTED                                = 0x5B03,
    LOG_PARAMETERS_CHANGED                                  = 0x2A02,
    LOGICAL_BLOCK_ADDRESS_OUT_OF_RANGE                      = 0x2100,
    LOGICAL_UNIT_COMMUNICATION_CRC_ERROR_ULTRA_DMA32        = 0x0803,
    LOGICAL_UNIT_COMMUNICATION_FAILURE                      = 0x0800,
    LOGICAL_UNIT_COMMUNICATION_PARITY_ERROR                 = 0x0802,
    LOGICAL_UNIT_COMMUNICATION_TIME_OUT                     = 0x0801,
    LOGICAL_UNIT_DOES_NOT_RESPOND_TO_SELECTION              = 0x0500,
    LOGICAL_UNIT_FAILED_SELF_CONFIGURATION                  = 0x4C00,
    LOGICAL_UNIT_FAILURE                                    = 0x3E01,
    LOGICAL_UNIT_FAILURE_PREDICTION_THRESHOLD_EXCEEDED      = 0x5D02,
    LOGICAL_UNIT_HAS_NOT_SELF_CONFIGURED_YET                = 0x3E00,
    LOGICAL_UNIT_IS_IN_PROCESS_OF_BECOMING_READY            = 0x0401,
    LOGICAL_UNIT_NOT_CONFIGURED                             = 0x6800,
    LOGICAL_UNIT_NOT_READY_CAUSE_NOT_REPORTABLE             = 0x0400,
    LOGICAL_UNIT_NOT_READY_FORMAT_IN_PROGRESS               = 0x0404,
    LOGICAL_UNIT_NOT_READY_INITIALIZING_CMD_REQUIRED        = 0x0402,
    LOGICAL_UNIT_NOT_READY_LONG_WRITE_IN_PROGRESS           = 0x0408,
    LOGICAL_UNIT_NOT_READY_MANUAL_INTERVENTION_REQUIRED     = 0x0403,
    LOGICAL_UNIT_NOT_READY_OPERATION_IN_PROGRESS            = 0x0407,
    LOGICAL_UNIT_NOT_READY_REBUILD_IN_PROGRESS              = 0x0405,
    LOGICAL_UNIT_NOT_READY_RECALCULATION_IN_PROGRESS        = 0x0406,
    LOGICAL_UNIT_NOT_SUPPORTED                              = 0x2500,
    LOGICAL_UNIT_SOFTWARE_WRITE_PROTECTED                   = 0x2702,
    LOW_POWER_CONDITION_ON                                  = 0x5E00,
    MECHANICAL_POSITIONING_ERROR                            = 0x1501,
    MECHANICAL_POSITIONING_OR_CHANGER_ERROR                 = 0x3B16,
    MEDIA_FAILURE_PREDICTION_THRESHOLD_EXCEEDED             = 0x5D01,
    MEDIA_LOAD_OR_EJECT_FAILED                              = 0x5300,
    MEDIA_REGION_CODE_IS_MISMATCHED_TO_LOGICAL_UNIT_REGION  = 0x6F04,
    MEDIUM_DESTINATION_ELEMENT_FULL                         = 0x3B0D,
    MEDIUM_FORMAT_CORRUPTED                                 = 0x3100,
    MEDIUM_MAGAZINE_INSERTED                                = 0x3B13,
    MEDIUM_MAGAZINE_LOCKED                                  = 0x3B14,
    MEDIUM_MAGAZINE_NOT_ACCESSIBLE                          = 0x3B11,
    MEDIUM_MAGAZINE_REMOVED                                 = 0x3B12,
    MEDIUM_MAGAZINE_UNLOCKED                                = 0x3B15,
    MEDIUM_NOT_PRESENT                                      = 0x3A00,
    MEDIUM_NOT_PRESENT_TRAY_CLOSED                          = 0x3A01,
    MEDIUM_NOT_PRESENT_TRAY_OPEN                            = 0x3A02,
    MEDIUM_REMOVAL_PREVENTED                                = 0x5302,
    MEDIUM_SOURCE_ELEMENT_EMPTY                             = 0x3B0E,
    MESSAGE_ERROR                                           = 0x4300,
    MICROCODE_HAS_BEEN_CHANGED                              = 0x3F01,
    MISCOMPARE_DURING_VERIFY_OPERATION                      = 0x1D00,
    MISCORRECTED_ERROR                                      = 0x110A,
    MODE_PARAMETERS_CHANGED                                 = 0x2A01,
    MODIFICATION_OF_LOGICAL_UNIT_FAILED                     = 0x6703,
    MULTIPLE_LOGICAL_UNIT_FAILURES                          = 0x6901,
    MULTIPLE_PERIPHERAL_DEVICES_SELECTED                    = 0x0700,
    MULTIPLE_READ_ERRORS                                    = 0x1103,
    MULTIPLY_ASSIGNED_LOGICAL_UNIT                          = 0x6709,
    NO_ADDITIONAL_SENSE_INFORMATION                         = 0x0000,
    NO_CURRENT_AUDIO_STATUS_TO_RETURN                       = 0x0015,
    NO_DEFECT_SPARE_LOCATION_AVAILABLE                      = 0x3200,
    NO_GAP_FOUND                                            = 0x1109,
    NO_INDEX_SECTOR_SIGNAL                                  = 0x0100,
    NO_MORE_TRACK_RESERVATIONS_ALLOWED                      = 0x7205,
    NO_REFERENCE_POSITION_FOUND                             = 0x0600,
    NO_SEEK_COMPLETE                                        = 0x0200,
    NO_WRITE_CURRENT                                        = 0x0301,
    NOT_READY_TO_READY_CHANGE_MEDIUM_MAY_HAVE_CHANGED       = 0x2800,
    OPERATION_IN_PROGRESS                                   = 0x0016,
    OPERATOR_MEDIUM_REMOVAL_REQUEST                         = 0x5A01,
    OPERATOR_REQUEST_OR_STATE_CHANGE_INPUT                  = 0x5A00,
    OPERATOR_SELECTED_WRITE_PERMIT                          = 0x5A03,
    OPERATOR_SELECTED_WRITE_PROTECT                         = 0x5A02,
    OUT_OF_FOCUS                                            = 0x6102,
    OVERLAPPED_COMMANDS_ATTEMPTED                           = 0x4E00,
    OVERWRITE_ERROR_ON_UPDATE_IN_PLACE                      = 0x2D00,
    PACKET_DOES_NOT_FIT_IN_AVAILABLE_SPACE                  = 0x6301,
    PAPER_JAM                                               = 0x3B05,
    PARAMETER_LIST_LENGTH_ERROR                             = 0x1A00,
    PARAMETER_NOT_SUPPORTED                                 = 0x2601,
    PARAMETER_VALUE_INVALID                                 = 0x2602,
    PARAMETERS_CHANGED                                      = 0x2A00,
    PARITY_DATA_MISMATCH                                    = 0x6902,
    PARTIAL_DEFECT_LIST_TRANSFER                            = 0x1F00,
    PERIPHERAL_DEVICE_WRITE_FAULT                           = 0x0300,
    PERMANENT_WRITE_PROTECT                                 = 0x2705,
    PERSISTENT_WRITE_PROTECT                                = 0x2704,
    POSITION_ERROR_RELATED_TO_TIMING                        = 0x5002,
    POSITION_PAST_BEGINNING_OF_MEDIUM                       = 0x3B0C,
    POSITION_PAST_END_OF_MEDIUM                             = 0x3B0B,
    POSITIONING_ERROR_DETECTED_BY_READ_OF_MEDIUM            = 0x1502,
    POWER_CALIBRATION_AREA_ALMOST_FULL                      = 0x7301,
    POWER_CALIBRATION_AREA_ERROR                            = 0x7303,
    POWER_CALIBRATION_AREA_IS_FULL                          = 0x7302,
    POWER_ON_OCCURRED                                       = 0x2901,
    POWER_ON_RESET_OR_BUS_DEVICE_RESET_OCCURRED             = 0x2900,
    POWER_STATE_CHANGE_TO_ACTIVE                            = 0x5E41,
    POWER_STATE_CHANGE_TO_DEVICE_CONTROL                    = 0x5E47,
    POWER_STATE_CHANGE_TO_IDLE                              = 0x5E42,
    POWER_STATE_CHANGE_TO_SLEEP                             = 0x5E45,
    POWER_STATE_CHANGE_TO_STANDBY                           = 0x5E43,
    POWER_ON_OR_SELF_TEST_FAILURE_SHOULD_USE_40_NN          = 0x4200,
    PRIMARY_DEFECT_LIST_NOT_FOUND                           = 0x1C01,
    PROGRAM_MEMORY_AREA_IS_FULL                             = 0x7305,
    PROGRAM_MEMORY_AREA_UPDATE_FAILURE                      = 0x7304,
    RAM_FAILURE_SHOULD_USE_40_NN                            = 0x4000,
    RANDOM_POSITIONING_ERROR                                = 0x1500,
    READ_ERROR_LOSS_OF_STREAMING                            = 0x1111,
    READ_OF_SCRAMBLED_SECTOR_WITHOUT_AUTHENTICATION         = 0x6F03,
    READ_PAST_BEGINNING_OF_MEDIUM                           = 0x3B0A,
    READ_PAST_END_OF_MEDIUM                                 = 0x3B09,
    READ_RETRIES_EXHAUSTED                                  = 0x1101,
    REBUILD_FAILURE_OCCURRED                                = 0x6C00,
    RECALCULATE_FAILURE_OCCURRED                            = 0x6D00,
    RECORD_NOT_FOUND                                        = 0x1401,
    RECORD_NOT_FOUND_DATA_AUTO_REALLOCATED                  = 0x1406,
    RECORD_NOT_FOUND_RECOMMEND_REASSIGNMENT                 = 0x1405,
    RECORDED_ENTITY_NOT_FOUND                               = 0x1400,
    RECOV_DATA_DATA_AUTO_REALLOCATED                        = 0x1802,
    RECOV_DATA_RECOMMEND_REASSIGNMENT                       = 0x1805,
    RECOV_DATA_RECOMMEND_REWRITE                            = 0x1806,
    RECOV_DATA_USING_PREVIOUS_SECTOR_ID                     = 0x1705,
    RECOV_DATA_WITH_CIRC                                    = 0x1803,
    RECOV_DATA_WITH_ECC_DATA_REWRITTEN                      = 0x1807,
    RECOV_DATA_WITH_ERROR_CORR_N_RETRIES_APPLIED            = 0x1801,
    RECOV_DATA_WITH_ERROR_CORRECTION_APPLIED                = 0x1800,
    RECOV_DATA_WITH_L_EC                                    = 0x1804,
    RECOV_DATA_WITH_NEGATIVE_HEAD_OFFSET                    = 0x1703,
    RECOV_DATA_WITH_NO_ERROR_CORRECTION_APPLIED             = 0x1700,
    RECOV_DATA_WITH_POSITIVE_HEAD_OFFSET                    = 0x1702,
    RECOV_DATA_WITH_RETRIES                                 = 0x1701,
    RECOV_DATA_WITH_RETRIES_AND_OR_CIRC_APPLIED             = 0x1704,
    RECOV_DATA_W_OUT_ECC_DATA_AUTO_REALLOCATED              = 0x1706,
    RECOV_DATA_W_OUT_ECC_DATA_REWRITTEN                     = 0x1709,
    RECOV_DATA_W_OUT_ECC_RECOMM_REASSIGNMENT                = 0x1707,
    RECOV_DATA_W_OUT_ECC_RECOMM_REWRITE                     = 0x1708,
    RECOV_ID_WITH_ECC_CORRECTION                            = 0x1E00,
    REDUNDANCY_GROUP_CREATED_OR_MODIFIED                    = 0x3F06,
    REDUNDANCY_GROUP_DELETED                                = 0x3F07,
    REDUNDANCY_LEVEL_GOT_BETTER                             = 0x6B01,
    REDUNDANCY_LEVEL_GOT_WORSE                              = 0x6B02,
    REGISTRATIONS_PREEMPTED                                 = 0x2A05,
    REMOVE_OF_LOGICAL_UNIT_FAILED                           = 0x6705,
    REPORTED_LUNS_DATA_HAS_CHANGED                          = 0x3F0E,
    REPOSITION_ERROR                                        = 0x3B08,
    RESERVATIONS_PREEMPTED                                  = 0x2A03,
    RESERVATIONS_RELEASED                                   = 0x2A04,
    RIBBON_INK_OR_TONER_FAILURE                             = 0x3600,
    RMA_PMA_IS_FULL                                         = 0x7306,
    ROUNDED_PARAMETER                                       = 0x3700,
    RPL_STATUS_CHANGE                                       = 0x5C00,
    SAVING_PARAMETERS_NOT_SUPPORTED                         = 0x3900,
    SCAN_HEAD_POSITIONING_ERROR                             = 0x6200,
    SCSI_BUS_RESET_OCCURRED                                 = 0x2902,
    SCSI_PARITY_ERROR                                       = 0x4700,
    SCSI_TO_HOST_SYSTEM_INTERFACE_FAILURE                   = 0x5400,
    SELECT_OR_RESELECT_FAILURE                              = 0x4500,
    SEQUENTIAL_POSITIONING_ERROR                            = 0x3B00,
    SESSION_FIX_ERROR                                       = 0x7200,
    SESSION_FIX_ERROR_INCOMPLETE_TRACK_IN_SESSION           = 0x7203,
    SESSION_FIX_ERROR_WRITING_LEAD_IN                       = 0x7201,
    SESSION_FIX_ERROR_WRITING_LEAD_OUT                      = 0x7202,
    SETMARK_DETECTED                                        = 0x0003,
    SLEW_FAILURE                                            = 0x3B04,
    SPARE_CREATED_OR_MODIFIED                               = 0x3F08,
    SPARE_DELETED                                           = 0x3F09,
    SPINDLE_SERVO_FAILURE                                   = 0x0903,
    SPINDLES_NOT_SYNCHRONIZED                               = 0x5C02,
    SPINDLES_SYNCHRONIZED                                   = 0x5C01,
    STANDBY_CONDITION_ACTIVATED_BY_COMMAND                  = 0x5E04,
    STANDBY_CONDITION_ACTIVATED_BY_TIMER                    = 0x5E02,
    STATE_CHANGE_HAS_OCCURRED                               = 0x6B00,
    SYNCHRONOUS_DATA_TRANSFER_ERROR                         = 0x1B00,
    SYSTEM_BUFFER_FULL                                      = 0x5501,
    SYSTEM_RESOURCE_FAILURE                                 = 0x5500,
/*  TAGGED_OVERLAPPED_COMMANDS_(NN_=_QUEUE_TAG)             = 0x4DNN, */
    TAPE_LENGTH_ERROR                                       = 0x3300,
    TAPE_OR_ELECTRONIC_VERTICAL_FORMS_UNIT_NOT_READY        = 0x3B03,
    TAPE_POSITION_ERROR_AT_BEGINNING_OF_MEDIUM              = 0x3B01,
    TAPE_POSITION_ERROR_AT_END_OF_MEDIUM                    = 0x3B02,
    TARGET_OPERATING_CONDITIONS_HAVE_CHANGED                = 0x3F00,
    THRESHOLD_CONDITION_MET                                 = 0x5B01,
    THRESHOLD_PARAMETERS_NOT_SUPPORTED                      = 0x2603,
    TIMEOUT_ON_LOGICAL_UNIT                                 = 0x3E02,
    TOO_MANY_WINDOWS_SPECIFIED                              = 0x2C01,
    TRACK_FOLLOWING_ERROR                                   = 0x0900,
    TRACKING_SERVO_FAILURE                                  = 0x0901,
    TRANSCEIVER_MODE_CHANGED_TO_LVD                         = 0x2906,
    TRANSCEIVER_MODE_CHANGED_TO_SINGLE_ENDED                = 0x2905,
    UNABLE_TO_ACQUIRE_VIDEO                                 = 0x6101,
    UNABLE_TO_RECOVER_TABLE_OF_CONTENTS                     = 0x5700,
    UNLOAD_TAPE_FAILURE                                     = 0x5301,
    UNRECOVERED_READ_ERR                                    = 0x1100,
    UNRECOVERED_READ_ERR_AUTO_REALLOCATE_FAILED             = 0x1104,
    UNRECOVERED_READ_ERR_RECOMM_REASSIGNMENT                = 0x110B,
    UNRECOVERED_READ_ERR_RECOMM_REWRITE_THE_DATA            = 0x110C,
    UNSUCCESSFUL_SOFT_RESET                                 = 0x4600,
    UNSUPPORTED_ENCLOSURE_FUNCTION                          = 0x3501,
    UPDATED_BLOCK_READ                                      = 0x5900,
    VIDEO_ACQUISITION_ERROR                                 = 0x6100,
    VOLTAGE_FAULT                                           = 0x6500,
    VOLUME_SET_CREATED_OR_MODIFIED                          = 0x3F0A,
    VOLUME_SET_DEASSIGNED                                   = 0x3F0C,
    VOLUME_SET_DELETED                                      = 0x3F0B,
    VOLUME_SET_REASSIGNED                                   = 0x3F0D,
    WARNING                                                 = 0x0B00,
    WARNING_ENCLOSURE_DEGRADED                              = 0x0B02,
    WARNING_SPECIFIED_TEMPERATURE_EXCEEDED                  = 0x0B01,
    WRITE_APPEND_ERROR                                      = 0x5000,
    WRITE_APPEND_POSITION_ERROR                             = 0x5001,
    WRITE_ERROR                                             = 0x0C00,
    WRITE_ERROR_AUTO_REALLOCATION_FAILED                    = 0x0C02,
    WRITE_ERROR_LOSS_OF_STREAMING                           = 0x0C09,
    WRITE_ERROR_PADDING_BLOCKS_ADDED                        = 0x0C0A,
    WRITE_ERROR_RECOMMEND_REASSIGNMENT                      = 0x0C03,
    WRITE_ERROR_RECOVERED_WITH_AUTO_REALLOCATION            = 0x0C01,
    WRITE_ERROR_RECOVERY_FAILED                             = 0x0C08,
    WRITE_ERROR_RECOVERY_NEEDED                             = 0x0C07,
    WRITE_PROTECTED                                         = 0x2700,
};

#define LITTLEENDIAN(code) (code >> 8 | (unsigned short)(code << 8))

/****************************************************************************/

#ifdef __GNUC__
   #ifdef __PPC__
    #pragma pack()
   #endif
#elif defined(__VBCC__)
   #pragma default-align
#endif


#ifdef __cplusplus
}
#ifdef __USE_AMIGAOS_NAMESPACE__
}
#endif
#endif

/****************************************************************************/

#endif /* SCSI_SENSE_CODES_H */
