/*
 * Copyright 2024 Vincent Sanders <vince@netsurf-browser.org>
 *
 * This file is part of NetSurf, http://www.netsurf-browser.org/
 *
 * NetSurf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * NetSurf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file
 * Bookmarks corewindow.
 */
extern "C" {
#include "desktop/hotlist.h"
}

#include "qt/bookmarks.cls.h"

NS_Bookmarks::NS_Bookmarks(QWidget *parent) : NS_Corewindow(parent)
{
	hotlist_manager_init((struct core_window *)m_core_window);
}

NS_Bookmarks::~NS_Bookmarks()
{
	hotlist_manager_fini();
}


void NS_Bookmarks::draw(struct rect *clip, struct redraw_context *ctx)
{
	hotlist_redraw(0, 0, clip, ctx);
}

bool NS_Bookmarks::key_press(uint32_t nskey)
{
	return hotlist_keypress(nskey);
}

void NS_Bookmarks::mouse_action(browser_mouse_state mouse_state, int x, int y)
{
	hotlist_mouse_action(mouse_state, x, y);
}
