###########################################################################
##
## PBL - Program Base Library, Copyright 2002 - 2007 Peter Graf
##
##  This file is part of PBL - The Program Base Library.
##  PBL is free software.
##
##   This program is free software; you can redistribute it and/or modify
##   it under the terms of the GNU General Public License as published by
##   the Free Software Foundation; either version 2 of the License, or
##   (at your option) any later version.
##
##   This program is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY; without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##   GNU General Public License for more details.
##
##   You should have received a copy of the GNU General Public License
##   along with this program; if not, write to the Free Software
##   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
##
##  For more information on the Program Base Library or Peter Graf,
##  please see: http://www.mission-base.com/.
##
## ISAM file implementation test case, this test case is set up for 
## a regression test of the ISAM library, don't change it unless you 
## know what you are doing!
##
## Usage: 
##
##   1. Build the pbliftst executable.          make all
##   2. Create the sub directory isamtest.      mkdir isamtest
##   3. Clear the sub directory isamtest.       rm isamtest/*
##   4. Run the test frame on this file.        pbliftst ISAM0001.TST
##   5. Compare ISAM0001.TST and pbliftst.log   diff ISAM0001.TST pbliftst.log
##
##   There should be no differences reported, if so your build of the
##   PBL library is most likely ok!
##
###########################################################################
##
## Test case 1 - basic test of functionality
##
## Open the file isam file isamtest/0001main with three index files
##  0001key0, 0001dup1 and 0001key2
##  open the file for update, create if necessary
##   the index 0001key0 contains unique keys
##   the index 0001dup1 can contain duplicate keys, 
##    ( the test frame allows that because its name contains the string 'dup' )
##   the index 0001key2 contains unique keys
##
## open filename keyfile1,dkeyfile2,... update
##
open isamtest/0001main 0001key0,0001dup1,0001key2 1
# pblIsamOpen( isamtest/0001main, 3, 1 )
# ok!
##
## Get the first record according to index 0001key0, should report an error
##
## get index < NEXT | PREV | FIRST | LAST | THIS >
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# rc -1, pbl_errno 1003, errno 0
##
## Delete 100000 records, should report an error
##
## ndelete n
##
ndelete 100000
# pblIsamDelete( 100000 records )
# i 0, rc -1, pbl_errno 1041, errno 0
##
## Insert one record with keys "key1", "key", "key20" and data "data1"
##
## insert ,key1,key2... data
##
insert ,key1,key,key20 data1
# pblIsamInsert( 1, ,key1,key,key20, 15, data1, 6 )
# rc 0
##
## Insert one record with keys "long1", "key", "long1" and 'long' data
## Note the key "key" is a duplicate key
##
insert ,long1,key,long1 1data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
# pblIsamInsert( 1, ,long1,key,long1, 16, 1data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891, 1276 )
# rc 0
##
## Insert one record with keys "long2", "key", "long2" and 'long' data
## Note the key "key" is a duplicate key
##
insert ,long2,key,long2 2data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
# pblIsamInsert( 1, ,long2,key,long2, 16, 2data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891, 1276 )
# rc 0
##
## Insert more records with long data
##
insert ,long3,key,long3 3data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
# pblIsamInsert( 1, ,long3,key,long3, 16, 3data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891, 1276 )
# rc 0
insert ,long4,key,long4 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
# pblIsamInsert( 1, ,long4,key,long4, 16, 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891, 1276 )
# rc 0
##
## Read the datalen of the current record, 'long4' the one just inserted
##
datalen
# pblIsamReadDatalen( currentrecord )
# datalen 1276
##
## Read the data of the current record, 'long4' the one just inserted
##
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 5, key long4
##
## read the datalen and the data again
##
datalen
# pblIsamReadDatalen( currentrecord )
# datalen 1276
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
##
## Read alphabetically previous record according to index 0001key0
## changes the current record to 'long3'
##
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 5, key long3
##
## Read datalen and data of current record, 'long3'
##
datalen
# pblIsamReadDatalen( currentrecord )
# datalen 1276
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 3data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
##
## Read alphabetically previous record according to index 0001key0
## changes the current record to 'long2'
##
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 5, key long2
##
## Read datalen and data of current record, 'long2'
##
datalen
# pblIsamReadDatalen( currentrecord )
# datalen 1276
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 2data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
##
## Read alphabetically previous record according to index 0001key0
## changes the current record to 'long1'
##
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 5, key long1
##
## Read datalen and data of current record, 'long2'
##
datalen
# pblIsamReadDatalen( currentrecord )
# datalen 1276
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 1data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
##
## Read alphabetically previous record according to index 0001key0
## changes the current record to 'key1'
##
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 4, key key1
##
## Read datalen and data of current record, 'key1'
##
datalen
# pblIsamReadDatalen( currentrecord )
# datalen 6
readdata
# pblIsamReadData( currentrecord )
# datalen 6, data data1
##
## Read alphabetically previous record according to index 0001key0
## reports an error, because we are positioned on the first record
##
get 0 PREV
# pblIsamGet( 3, 0 )
# rc -1, pbl_errno 1003, errno 0
##
## Read datalen and data of current record, 'key1'
##
datalen
# pblIsamReadDatalen( currentrecord )
# datalen 6
readdata
# pblIsamReadData( currentrecord )
# datalen 6, data data1
##
## Insert a record with an empty value for index 0001key2,
## results in an error, because the index needs unique keys
## and does therefore not allow empty values
##
insert ,key8,key,      data1
# pblIsamInsert( 1, ,key8,key,, 10, data1, 6 )
# rc -1, pbl_errno 1006, errno 0
##
## Insert a record with an value "key20" for index 0001key2,
## this should result in an error, because the index needs unique keys
## and the value "key20" was already inserted with the very first insert
##
insert ,key2,key,key20 data1
# pblIsamInsert( 1, ,key2,key,key20, 15, data1, 6 )
# rc -1, pbl_errno 1002, errno 0
##
## Flush all changes made so far
##
flush
# pblIsamFlush( 1 )
# rc 0
##
## Insert a record with key values "key2", "key", "key1f"
##
insert ,key2,key,key1f data1
# pblIsamInsert( 1, ,key2,key,key1f, 15, data1, 6 )
# rc 0
##
## Flush all changes made so far
##
flush
# pblIsamFlush( 1 )
# rc 0
##
## Read alphabetically first record according to index 0001key0
## sets the current record to 'key1'
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 4, key key1
##
## Delete the current record
##
## Note: This positions the current record to the record that
##       was historically inserted after the 'key1' record
##       i.e. the 'long1' record
##
ndelete 1
# pblIsamDelete( 1 records )
# deleted 1 records, rc 0
##
## Get the current record according to index 0001key0
## should be the 'long1' record, the second record ever inserted!
##
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 5, key long1
##
## Read alphabetically first record according to index 0001key0
## this yields the alphabetically smallest key, 'key2'
## and sets the current record to that record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 4, key key2
##
## Delete the current record, 'key2'
##
ndelete 1
# pblIsamDelete( 1 records )
# deleted 1 records, rc 0
##
## Insert a record with key values "key1", "key", "key20"
##
insert ,key1,key,key20 data1
# pblIsamInsert( 1, ,key1,key,key20, 15, data1, 6 )
# rc 0
##
## Insert a record with key values "key2", "key", "key1f"
##
insert ,key2,key,key1f data1
# pblIsamInsert( 1, ,key2,key,key1f, 15, data1, 6 )
# rc 0
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 5, key long4
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 4, key key1
##
## Update the index 0001key0 of the record to 'key2' instead of 'key1'
## Reports an error because the value 'key2' exists already
##
updatekey 0 key2
# pblIsamUpdateKey( 0, key2, 4 )
# rc -1, pbl_errno 1002, errno 0
##
## Update the index 0001key0 of the record to key to 'key1'
##
updatekey 0 key1
# pblIsamUpdateKey( 0, key1, 4 )
# rc 0
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 5, key long4
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 4, key key1
##
## Update the data of the current record
##
updatedata da
# pblIsamUpdateData( da, 3 )
# datalen 3
##
## Update the data of the current record
##
updatedata deta1
# pblIsamUpdateData( deta1, 6 )
# datalen 6
##
## Update the data of the current record
##
updatedata data1
# pblIsamUpdateData( data1, 6 )
# datalen 6
##
## Update index 0001key0 of the current record
##
updatekey 0 key1
# pblIsamUpdateKey( 0, key1, 4 )
# rc 0
##
## Update index 0001key0 of the current record
##
updatekey 0 key11
# pblIsamUpdateKey( 0, key11, 5 )
# rc 0
##
## Update index 0001key0 of the current record
##
updatekey 0 key1
# pblIsamUpdateKey( 0, key1, 4 )
# rc 0
##
## Update index 0001key0 of the current record
##
updatekey 0 key1
# pblIsamUpdateKey( 0, key1, 4 )
# rc 0
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 5, key long4
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 4, key key1
##
## Update the value of the index 0001dup1, allowing duplicates
##
updatekey 1 key
# pblIsamUpdateKey( 1, key, 3 )
# rc 0
##
## Update the value of the index 0001dup1, allowing duplicates
##
updatekey 1 key1
# pblIsamUpdateKey( 1, key1, 4 )
# rc 0
##
## Update the value of the index 0001dup1, allowing duplicates
##
updatekey 1 key
# pblIsamUpdateKey( 1, key, 3 )
# rc 0
##
## Update the value of the index 0001dup1, allowing duplicates
##
updatekey 1 key
# pblIsamUpdateKey( 1, key, 3 )
# rc 0
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 5, key long4
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 4, key key1
##
## Start a transaction
##
transaction START
# pblIsamStartTransaction( )
# rc 0
##
## Insert some records
##
insert ,key3,key,key1e data1
# pblIsamInsert( 1, ,key3,key,key1e, 15, data1, 6 )
# rc 0
insert ,key4,keya,key1d data1
# pblIsamInsert( 1, ,key4,keya,key1d, 16, data1, 6 )
# rc 0
insert ,key5,keya,key1c data1
# pblIsamInsert( 1, ,key5,keya,key1c, 16, data1, 6 )
# rc 0
insert ,key6,keya,key1b data1
# pblIsamInsert( 1, ,key6,keya,key1b, 16, data1, 6 )
# rc 0
insert ,key7,keya,key1a data1
# pblIsamInsert( 1, ,key7,keya,key1a, 16, data1, 6 )
# rc 0
insert ,key8,keya,key10 data1
# pblIsamInsert( 1, ,key8,keya,key10, 16, data1, 6 )
# rc 0
insert ,key9,key,key19 data1
# pblIsamInsert( 1, ,key9,key,key19, 15, data1, 6 )
# rc 0
insert ,keya,key,key18 data1
# pblIsamInsert( 1, ,keya,key,key18, 15, data1, 6 )
# rc 0
insert ,keyb,key,key17 data1
# pblIsamInsert( 1, ,keyb,key,key17, 15, data1, 6 )
# rc 0
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 5, key long4
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 4, key key1
##
## Read the alphabetically next couple of records according to index 0001key0
##
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key2
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key3
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key4
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key5
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key6
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key7
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key8
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key9
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key keya
##
## Rollback the transaction, the inserts that happened
## after the transaction started are NOT committed
##
transaction ROLLBACK
# pblIsamCommit( ROLLBACK )
# rc 1, pbl_errno 0, errno 0
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 5, key long4
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 4, key key1
##
## Read the alphabetically next couple of records according to index 0001key0
##
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key2
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 5, key long1
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 5, key long2
##
## Start another transaction
##
transaction START
# pblIsamStartTransaction( )
# rc 0
##
## Repeat the inserts done during the last transaction
##
insert ,key3,key,key1e data1
# pblIsamInsert( 1, ,key3,key,key1e, 15, data1, 6 )
# rc 0
insert ,key4,keya,key1d data1
# pblIsamInsert( 1, ,key4,keya,key1d, 16, data1, 6 )
# rc 0
insert ,key5,keya,key1c data1
# pblIsamInsert( 1, ,key5,keya,key1c, 16, data1, 6 )
# rc 0
insert ,key6,keya,key1b data1
# pblIsamInsert( 1, ,key6,keya,key1b, 16, data1, 6 )
# rc 0
insert ,key7,keya,key1a data1
# pblIsamInsert( 1, ,key7,keya,key1a, 16, data1, 6 )
# rc 0
insert ,key8,keya,key10 data1
# pblIsamInsert( 1, ,key8,keya,key10, 16, data1, 6 )
# rc 0
insert ,key9,key,key19 data1
# pblIsamInsert( 1, ,key9,key,key19, 15, data1, 6 )
# rc 0
insert ,keya,key,key18 data1
# pblIsamInsert( 1, ,keya,key,key18, 15, data1, 6 )
# rc 0
insert ,keyb,key,key17 data1
# pblIsamInsert( 1, ,keyb,key,key17, 15, data1, 6 )
# rc 0
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 5, key long4
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 4, key key1
##
## Read the alphabetically next couple of records according to index 0001key0
##
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key2
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key3
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key4
##
## Commit the transacttion, make the inserts permanent
##
transaction COMMIT
# pblIsamCommit( COMMIT )
# rc 0
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 5, key long4
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 4, key key1
##
## Read the alphabetically next couple of records according to index 0001key0
##
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key2
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key3
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 4, key key4
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 5, key long4
##
## Read the data of the current record
##
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
##
## Read alphabetically previous record according to index 0001key0
## this sets the current record
##
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 5, key long3
##
## Read the value of the index 0001dup1 of the current record
##
get 1 THIS
# pblIsamGet( 1, 1 )
# keylen 3, key key
##
## Find a record who's index 0001dup1 value is the biggest value
## that is alphabetically lower than 'keya'
##
find 1 keya LT
# pblIsamFind( LT, keya, 4 )
# keylen 3, key key
##
## Read the value of the index 0001key0 of the current record
##
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key keyb
##
## Find a record who's index 0001dup1 value is alphabetically equal to 'keya'
## or who's index 0001dup1 value is the biggest value that is alphabetically
## lower than 'keya'
##
find 1 keya LE
# pblIsamFind( LE, keya, 4 )
# keylen 4, key keya
##
## Read the value of the index 0001key0 of the current record
##
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key4
##
## Find the first record who's index 0001dup1 value is alphabetically
## equal to 'keya'
##
find 1 keya FI
# pblIsamFind( FI, keya, 4 )
# keylen 4, key keya
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key4
##
## Find any record who's index 0001dup1 value is alphabetically
## equal to 'keya'
##
find 1 keya EQ
# pblIsamFind( EQ, keya, 4 )
# keylen 4, key keya
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key4
find 1 notfound EQ
# pblIsamFind( EQ, notfound, 8 )
# rc -1, pbl_errno 1003, errno 0
##
## Find the last record who's index 0001dup1 value is alphabetically
## equal to 'keya'
##
find 1 keya LA
# pblIsamFind( LA, keya, 4 )
# keylen 4, key keya
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key8
##
## Find a record who's index 0001dup1 value is alphabetically equal to 'keya'
## or who's index 0001dup1 value is the smallest value that is alphabetically
## bigger than 'keya'
##
find 1 keya GE
# pblIsamFind( GE, keya, 4 )
# keylen 4, key keya
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key8
##
## Find a record who's index 0001dup1 value is the smallest value
## that is alphabetically bigger than 'keya'
## Reports an error because 'keya' is the biggest value in index 0001dup1
##
find 1 keya GT
# pblIsamFind( GT, keya, 4 )
# rc -1, pbl_errno 1003, errno 0
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 5, key long4
##
## loop backward according to index 0001key0
##
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 5, key long3
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 5, key long2
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 5, key long1
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 4, key keyb
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 4, key keya
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 4, key key9
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 4, key key8
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 4, key key7
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 4, key key6
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 4, key key5
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 4, key key4
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 4, key key3
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 4, key key2
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 4, key key1
get 0 PREV
# pblIsamGet( 3, 0 )
# rc -1, pbl_errno 1003, errno 0
get 0 PREV
# pblIsamGet( 3, 0 )
# rc -1, pbl_errno 1003, errno 0
##
## Loop forwards through the file according to index 0001dup1
## Read alphabetically first record according to index 0001dup1
## this sets the current record
##
get 1 FIRST
# pblIsamGet( 4, 1 )
# keylen 3, key key
##
## Get the index 0001key0 value of the current record
## 
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 5, key long1
##
## 
## Read alphabetically next record according to index 0001dup1
## this sets the current record
##
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 3, key key
##
## Get the index 0001key0 value of the current record
##
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 5, key long2
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 3, key key
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 5, key long3
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 3, key key
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 5, key long4
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 3, key key
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key1
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 3, key key
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key2
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 3, key key
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key3
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 3, key key
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key9
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 3, key key
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key keya
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 3, key key
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key keyb
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 4, key keya
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key4
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 4, key keya
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key5
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 4, key keya
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key6
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 4, key keya
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key7
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 4, key keya
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key8
get 1 NEXT
# pblIsamGet( 2, 1 )
# rc -1, pbl_errno 1003, errno 0
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key8
get 1 NEXT
# pblIsamGet( 2, 1 )
# rc -1, pbl_errno 1003, errno 0
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key8
get 1 NEXT
# pblIsamGet( 2, 1 )
# rc -1, pbl_errno 1003, errno 0
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 4, key key8
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 5, key long4
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 4, key key1
##
## Start a transaction
##
transaction START
# pblIsamStartTransaction( )
# rc 0
##
## Delete 1000 records, reports an error after 15 records are deleted
##
ndelete 1000
# pblIsamDelete( 1000 records )
# i 15, rc -1, pbl_errno 1041, errno 0
##
## Read alphabetically last record according to index 0001key0
## There is no such record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# rc -1, pbl_errno 1003, errno 0
##
## Read alphabetically first record according to index 0001key0
## There is no such record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# rc -1, pbl_errno 1003, errno 0
##
## Rollback the transaction, do not commit the deletes done above
##
transaction ROLLBACK
# pblIsamCommit( ROLLBACK )
# rc 1, pbl_errno 0, errno 0
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 5, key long4
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 4, key key1
##
## Start a transaction
##
transaction START
# pblIsamStartTransaction( )
# rc 0
##
## Delete all records
##
ndelete 1000
# pblIsamDelete( 1000 records )
# i 15, rc -1, pbl_errno 1041, errno 0
##
## Read alphabetically last record according to index 0001key0
## There is no such record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# rc -1, pbl_errno 1003, errno 0
##
## Read alphabetically first record according to index 0001key0
## There is no such record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# rc -1, pbl_errno 1003, errno 0
##
## Commit the transaction, make the deletes permanent
##
transaction COMMIT
# pblIsamCommit( COMMIT )
# rc 0
##
## Read alphabetically last record according to index 0001key0
## There is no such record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# rc -1, pbl_errno 1003, errno 0
##
## Read alphabetically first record according to index 0001key0
## There is no such record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# rc -1, pbl_errno 1003, errno 0
##
## Start a transaction
##
transaction START
# pblIsamStartTransaction( )
# rc 0
##
## insert 1000 records, the keys are "key10" to "key1999" for 0001key0, ...
##
ninsert 1000 key1,key2,key3 dataaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
# pblIsamInsert( 1, ,key10,key20,key30, 18, dataaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa, 52 )
# inserted 1000 records, rc 0
##
## Read Data of current record
##
readdata
# pblIsamReadData( currentrecord )
# datalen 52, data dataaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
##
## Read alphabetically last record according to index 0001key0
## this sets the current record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 7, key key1999
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 5, key key10
##
## Rollback the transaction, do not commit the 1000 inserts done above
##
transaction ROLLBACK
# pblIsamCommit( ROLLBACK )
# rc 1, pbl_errno 0, errno 0
##
## Read alphabetically last record according to index 0001key0
## There is no such record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# rc -1, pbl_errno 1003, errno 0
##
## Read alphabetically first record according to index 0001key0
## There is no such record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# rc -1, pbl_errno 1003, errno 0
##
## Start a transaction
##
transaction START
# pblIsamStartTransaction( )
# rc 0
##
## Reinsert the 1000 records
##
ninsert 1000 key1,key2,key3 dataaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
# pblIsamInsert( 1, ,key10,key20,key30, 18, dataaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa, 52 )
# inserted 1000 records, rc 0
##
## Read last and first record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 7, key key1999
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 5, key key10
##
## Commit the 1000 inserts
##
transaction COMMIT
# pblIsamCommit( COMMIT )
# rc 0
##
## Read last and first record
##
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 7, key key1999
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 5, key key10
get 0 THIS
# pblIsamGet( 1, 0 )
# keylen 5, key key10
ndelete 1000
# pblIsamDelete( 1000 records )
# deleted 1000 records, rc 0
##
## Delete 1000 records,
##
flush
# pblIsamFlush( 1 )
# rc 0
##
## Close the empty file
##
close
# pblIsamClose( 1 )
# rc 0
##
## Open the file again
##
open isamtest/0001main 0001key0,0001dup1,0001key2 1
# pblIsamOpen( isamtest/0001main, 3, 1 )
# ok!
##
## insert 10000 records
##
ninsert 10000 loooooooooooooooongkey1,loooooooooooooooongkey2,loooooooooooooooongkey3 dataaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
# pblIsamInsert( 1, ,loooooooooooooooongkey10,loooooooooooooooongkey20,loooooooooooooooongkey30, 75, dataaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa, 134 )
# inserted 10000 records, rc 0
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 24, key loooooooooooooooongkey10
readdata
# pblIsamReadData( currentrecord )
# datalen 134, data dataaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
##
## Find a record with an index 0001key0 value
## lower than loooooooooooooooongkey12555
##
find 0 loooooooooooooooongkey12555 LT
# pblIsamFind( LT, loooooooooooooooongkey12555, 27 )
# keylen 27, key loooooooooooooooongkey12554
##
## Find a record with an index 0001key0 value
## lower than or equal to loooooooooooooooongkey13666
##
find 0 loooooooooooooooongkey13666 LE
# pblIsamFind( LE, loooooooooooooooongkey13666, 27 )
# keylen 27, key loooooooooooooooongkey13666
##
## Find the first record with an index 0001key0 value
## equal to loooooooooooooooongkey13666
##
find 0 loooooooooooooooongkey14777 FI
# pblIsamFind( FI, loooooooooooooooongkey14777, 27 )
# keylen 27, key loooooooooooooooongkey14777
##
## Find any record with an index 0001key0 value
## equal to loooooooooooooooongkey15888
##
find 0 loooooooooooooooongkey15888 EQ
# pblIsamFind( EQ, loooooooooooooooongkey15888, 27 )
# keylen 27, key loooooooooooooooongkey15888
##
## Find the last record with an index 0001key0 value
## equal to loooooooooooooooongkey16999
##
find 0 loooooooooooooooongkey16999 LA
# pblIsamFind( LA, loooooooooooooooongkey16999, 27 )
# keylen 27, key loooooooooooooooongkey16999
##
## Find a record with an index 0001key0 value
## equal to or bigger than loooooooooooooooongkey17111
##
find 0 loooooooooooooooongkey17111 GE
# pblIsamFind( GE, loooooooooooooooongkey17111, 27 )
# keylen 27, key loooooooooooooooongkey17111
##
## Find a record with an index 0001key0 value
## bigger than loooooooooooooooongkey18222
##
find 0 loooooooooooooooongkey18222 GT
# pblIsamFind( GT, loooooooooooooooongkey18222, 27 )
# keylen 27, key loooooooooooooooongkey18223
##
## Get the next record according to index 0001key0
##
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 27, key loooooooooooooooongkey18224
##
## Do some finds on index 0001dup1
##
find 1 loooooooooooooooongkey22555 LE
# pblIsamFind( LE, loooooooooooooooongkey22555, 27 )
# keylen 27, key loooooooooooooooongkey22555
find 1 loooooooooooooooongkey23666 FI
# pblIsamFind( FI, loooooooooooooooongkey23666, 27 )
# keylen 27, key loooooooooooooooongkey23666
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 27, key loooooooooooooooongkey23667
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 27, key loooooooooooooooongkey23668
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 27, key loooooooooooooooongkey23669
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 26, key loooooooooooooooongkey2367
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 27, key loooooooooooooooongkey23670
get 1 PREV
# pblIsamGet( 3, 1 )
# keylen 26, key loooooooooooooooongkey2367
##
## Do some finds on index 0001key2
##
find 2 loooooooooooooooongkey32555 LT
# pblIsamFind( LT, loooooooooooooooongkey32555, 27 )
# keylen 27, key loooooooooooooooongkey32554
find 2 loooooooooooooooongkey33666 LE
# pblIsamFind( LE, loooooooooooooooongkey33666, 27 )
# keylen 27, key loooooooooooooooongkey33666
find 2 loooooooooooooooongkey34777 FI
# pblIsamFind( FI, loooooooooooooooongkey34777, 27 )
# keylen 27, key loooooooooooooooongkey34777
find 2 loooooooooooooooongkey35888 EQ
# pblIsamFind( EQ, loooooooooooooooongkey35888, 27 )
# keylen 27, key loooooooooooooooongkey35888
find 2 loooooooooooooooongkey36999 LA
# pblIsamFind( LA, loooooooooooooooongkey36999, 27 )
# keylen 27, key loooooooooooooooongkey36999
find 2 loooooooooooooooongkey37111 GE
# pblIsamFind( GE, loooooooooooooooongkey37111, 27 )
# keylen 27, key loooooooooooooooongkey37111
find 2 loooooooooooooooongkey38222 GT
# pblIsamFind( GT, loooooooooooooooongkey38222, 27 )
# keylen 27, key loooooooooooooooongkey38223
##
## Start a transaction
##
transaction START
# pblIsamStartTransaction( )
# rc 0
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 24, key loooooooooooooooongkey10
##
## Delete 800 records
##
ndelete 800
# pblIsamDelete( 800 records )
# deleted 800 records, rc 0
readdata
# pblIsamReadData( currentrecord )
# datalen 134, data dataaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
##
## Delete 200 records
##
ndelete 200
# pblIsamDelete( 200 records )
# deleted 200 records, rc 0
##
## Read alphabetically first record according to index 0001key0
## this sets the current record
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 27, key loooooooooooooooongkey11000
##
## Rollback the transaction
##
transaction ROLLBACK
# pblIsamCommit( ROLLBACK )
# rc 1, pbl_errno 0, errno 0
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 24, key loooooooooooooooongkey10
##
## Start a transaction
##
transaction START
# pblIsamStartTransaction( )
# rc 0
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 24, key loooooooooooooooongkey10
##
## Delete 1000 records
##
ndelete 1000
# pblIsamDelete( 1000 records )
# deleted 1000 records, rc 0
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 27, key loooooooooooooooongkey11000
transaction COMMIT
# pblIsamCommit( COMMIT )
# rc 0
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 27, key loooooooooooooooongkey11000
##
## Delete 1000 records
##
ndelete 1000
# pblIsamDelete( 1000 records )
# deleted 1000 records, rc 0
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 27, key loooooooooooooooongkey12000
##
## Delete 8000 records, i.e. all of them
##
ndelete 8000
# pblIsamDelete( 8000 records )
# deleted 8000 records, rc 0
##
## Verify the file is empty now
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# rc -1, pbl_errno 1003, errno 0
get 1 FIRST
# pblIsamGet( 4, 1 )
# rc -1, pbl_errno 1003, errno 0
get 2 FIRST
# pblIsamGet( 4, 2 )
# rc -1, pbl_errno 1003, errno 0
##
## Insert one record with keys "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1", "key", "long1" and 'long' data
## Note the key "key" is a duplicate key
##
insert ,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1,key,long1 1data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
# pblIsamInsert( 1, ,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1,key,long1, 156, 1data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891, 1276 )
# rc 0
##
## Insert one record with keys "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long2", "key", "long2" and 'long' data
## Note the key "key" is a duplicate key
##
insert ,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long2,key,long2 2data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
# pblIsamInsert( 1, ,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long2,key,long2, 156, 2data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891, 1276 )
# rc 0
##
## Insert one record with keys "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3", "key", "long3" and 'long' data
## Note the key "key" is a duplicate key
##
insert ,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3,key,long3 3data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
# pblIsamInsert( 1, ,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3,key,long3, 156, 3data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891, 1276 )
# rc 0
##
## Insert one record with keys "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long4", "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key", "long4" and 'long' data
##
insert ,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long4,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key,long4 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
# pblIsamInsert( 1, ,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long4,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key,long4, 296, 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891, 1276 )
# rc 0
##
## Insert one record with keys "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long5", "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key", "long5" and 'long' data
##
insert ,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long5,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key,long5 5data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
# pblIsamInsert( 1, ,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long5,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key,long5, 296, 5data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891, 1276 )
# rc 0
##
## Insert one record with keys "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6", "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key", "long6" and 'long' data
##
insert ,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key,long6 6data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
# pblIsamInsert( 1, ,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6,12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key,long6, 296, 6data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891, 1276 )
# rc 0
get 0 FIRST
# pblIsamGet( 4, 0 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long2
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long2
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long4
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long5
get 0 NEXT
# pblIsamGet( 2, 0 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6
get 0 LAST
# pblIsamGet( 5, 0 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long5
get 0 PREV
# pblIsamGet( 3, 0 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long4
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
get 1 FIRST
# pblIsamGet( 4, 1 )
# keylen 143, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 143, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 5data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
get 1 PREV
# pblIsamGet( 3, 1 )
# keylen 143, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 143, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 5data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 143, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 6data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 3, key key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 1data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 3, key key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 2data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
get 1 NEXT
# pblIsamGet( 2, 1 )
# keylen 3, key key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 3data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
get 1 LAST
# pblIsamGet( 5, 1 )
# keylen 3, key key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 3data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
get 1 PREV
# pblIsamGet( 3, 1 )
# keylen 3, key key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 2data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
get 1 PREV
# pblIsamGet( 3, 1 )
# keylen 3, key key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 1data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
get 2 FIRST
# pblIsamGet( 4, 2 )
# keylen 5, key long1
get 2 NEXT
# pblIsamGet( 2, 2 )
# keylen 5, key long2
get 2 PREV
# pblIsamGet( 3, 2 )
# keylen 5, key long1
get 2 NEXT
# pblIsamGet( 2, 2 )
# keylen 5, key long2
get 2 NEXT
# pblIsamGet( 2, 2 )
# keylen 5, key long3
get 2 NEXT
# pblIsamGet( 2, 2 )
# keylen 5, key long4
get 2 NEXT
# pblIsamGet( 2, 2 )
# keylen 5, key long5
get 2 NEXT
# pblIsamGet( 2, 2 )
# keylen 5, key long6
get 2 LAST
# pblIsamGet( 5, 2 )
# keylen 5, key long6
get 2 PREV
# pblIsamGet( 3, 2 )
# keylen 5, key long5
get 2 PREV
# pblIsamGet( 3, 2 )
# keylen 5, key long4
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
##
## Find the records with the long keys
##
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1 LT
# pblIsamFind( LT, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1, 145 )
# rc -1, pbl_errno 1003, errno 0
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10 LT
# pblIsamFind( LT, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10, 146 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1 LE
# pblIsamFind( LE, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10 LE
# pblIsamFind( LE, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10, 146 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1 FI
# pblIsamFind( FI, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10 FI
# pblIsamFind( FI, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10, 146 )
# rc -1, pbl_errno 1003, errno 0
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1 EQ
# pblIsamFind( EQ, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10 EQ
# pblIsamFind( EQ, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10, 146 )
# rc -1, pbl_errno 1003, errno 0
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1 LA
# pblIsamFind( LA, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10 LA
# pblIsamFind( LA, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10, 146 )
# rc -1, pbl_errno 1003, errno 0
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1 GE
# pblIsamFind( GE, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10 GE
# pblIsamFind( GE, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10, 146 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long2
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1 GT
# pblIsamFind( GT, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long1, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long2
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10 GT
# pblIsamFind( GT, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long10, 146 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long2
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3 LT
# pblIsamFind( LT, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long2
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3 LE
# pblIsamFind( LE, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3 FI
# pblIsamFind( FI, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3 EQ
# pblIsamFind( EQ, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3 LA
# pblIsamFind( LA, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3 GE
# pblIsamFind( GE, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3 GT
# pblIsamFind( GT, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long3, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long4
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6 LT
# pblIsamFind( LT, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long5
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6 LE
# pblIsamFind( LE, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6 FI
# pblIsamFind( FI, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6 EQ
# pblIsamFind( EQ, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6 LA
# pblIsamFind( LA, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6 GE
# pblIsamFind( GE, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6, 145 )
# keylen 145, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6
find 0 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6 GT
# pblIsamFind( GT, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890long6, 145 )
# rc -1, pbl_errno 1003, errno 0
##
## Find the record with the long duplicate key
##
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key LT
# pblIsamFind( LT, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key, 143 )
# rc -1, pbl_errno 1003, errno 0
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 6data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0 LT
# pblIsamFind( LT, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0, 144 )
# keylen 143, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 6data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key LE
# pblIsamFind( LE, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key, 143 )
# keylen 143, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0 LE
# pblIsamFind( LE, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0, 144 )
# keylen 143, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 6data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key FI
# pblIsamFind( FI, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key, 143 )
# keylen 143, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0 FI
# pblIsamFind( FI, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0, 144 )
# rc -1, pbl_errno 1003, errno 0
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key EQ
# pblIsamFind( EQ, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key, 143 )
# keylen 143, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0 EQ
# pblIsamFind( EQ, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0, 144 )
# rc -1, pbl_errno 1003, errno 0
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 4data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key LA
# pblIsamFind( LA, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key, 143 )
# keylen 143, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 6data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0 LA
# pblIsamFind( LA, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0, 144 )
# rc -1, pbl_errno 1003, errno 0
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 6data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key GE
# pblIsamFind( GE, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key, 143 )
# keylen 143, key 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 6data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0 GE
# pblIsamFind( GE, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0, 144 )
# keylen 3, key key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 1data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key GT
# pblIsamFind( GT, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key, 143 )
# keylen 3, key key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 1data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
find 1 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0 GT
# pblIsamFind( GT, 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890key0, 144 )
# keylen 3, key key
readdata
# pblIsamReadData( currentrecord )
# datalen 1276, data 1data1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567891
##
## Delete 6 records, i.e. all of them
##
ndelete 6
# pblIsamDelete( 6 records )
# deleted 6 records, rc 0
##
## Verify the file is empty now
##
get 0 FIRST
# pblIsamGet( 4, 0 )
# rc -1, pbl_errno 1003, errno 0
get 1 FIRST
# pblIsamGet( 4, 1 )
# rc -1, pbl_errno 1003, errno 0
get 2 FIRST
# pblIsamGet( 4, 2 )
# rc -1, pbl_errno 1003, errno 0
##
## Close the file
##
close
# pblIsamClose( 1 )
# rc 0
quit
